// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from stone2.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:54
 *
 * Usage in Kywy projects:
 *   #include "stone2.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, STONE2_FRAME_WIDTH,
 *                            STONE2_FRAME_HEIGHT, STONE2_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {STONE2_frame_0, STONE2_frame_1, STONE2_frame_2,
 * STONE2_frame_3, STONE2_frame_4, STONE2_frame_5, STONE2_frame_6,
 * STONE2_frame_7, STONE2_frame_8, STONE2_frame_9, STONE2_frame_10,
 * STONE2_frame_11}; engine.display.drawBitmap(x, y, STONE2_FRAME_WIDTH,
 *                            STONE2_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef STONE2_H
#define STONE2_H

#include <stdint.h>

// Sprite sheet information
#define STONE2_FRAME_WIDTH 64
#define STONE2_FRAME_HEIGHT 64
#define STONE2_FRAME_COUNT 12
#define STONE2_SPRITE_COLS 3
#define STONE2_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t STONE2_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xeb, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xdf, 0xdf, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xbf, 0x77, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xf6, 0x7e, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa,
  0xf9, 0xfd, 0xef, 0xff, 0xff, 0xfe, 0x0f, 0xf7, 0x7b, 0xfb, 0xdf, 0xff,
  0xff, 0xfe, 0x70, 0x2f, 0x87, 0xe7, 0xdf, 0xff, 0xff, 0xfe, 0x9f, 0x9f,
  0x6f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0x66, 0x5e, 0xdf, 0xbf, 0xbf, 0xff,
  0xff, 0xff, 0x79, 0xe9, 0xbf, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xe6,
  0x5e, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xd1, 0xe5, 0xe0, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0xbf, 0xf8, 0x1f, 0x7f, 0xff, 0xf8, 0x3f, 0xdf, 0x7f,
  0xff, 0xff, 0x7f, 0xff, 0xf9, 0xdf, 0xbf, 0x6f, 0xff, 0xff, 0xbf, 0xff,
  0xfa, 0xe9, 0x7f, 0x75, 0xff, 0xff, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x76,
  0x0b, 0xd8, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x7a, 0x15, 0xb2, 0x3f, 0xff,
  0xfb, 0xb5, 0xfe, 0x3b, 0x01, 0x80, 0xbf, 0xff, 0xfd, 0xd5, 0xfd, 0x1b,
  0x03, 0xe0, 0xbf, 0xff, 0xfe, 0xe1, 0xfd, 0x1b, 0x06, 0x71, 0xbf, 0xff,
  0xff, 0x1c, 0xfb, 0x9a, 0xfe, 0x7f, 0xbf, 0xff, 0xff, 0xbd, 0x37, 0x91,
  0xff, 0xff, 0x7f, 0xff, 0xff, 0x7d, 0xcf, 0x80, 0xff, 0xfe, 0xff, 0xff,
  0xff, 0x7d, 0xff, 0xc0, 0xff, 0xfd, 0xff, 0xff, 0x9f, 0x7d, 0xff, 0xe0,
  0x6e, 0xed, 0xff, 0xff, 0x26, 0xfc, 0xff, 0xfe, 0x4e, 0xcb, 0xff, 0xff,
  0x58, 0xfe, 0x7f, 0xfd, 0xb1, 0x33, 0xff, 0xff, 0x6e, 0xfe, 0x3f, 0xf3,
  0xff, 0xff, 0xff, 0xff, 0xb5, 0xff, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff,
  0xd9, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0xf1, 0x81, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf5, 0xce, 0x62, 0xfe, 0x7f, 0xff, 0xff, 0xff,
  0xf9, 0x3f, 0xbe, 0xf9, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xce, 0xe6,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xf5, 0x9e, 0xff, 0xff, 0xff, 0xff,
  0xfe, 0xff, 0xf4, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xf8, 0x3b,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xf8, 0x1b, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe7, 0xf0, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xe1, 0xe7,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x03, 0xef, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xde, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x09, 0xe3,
  0xff, 0x0f, 0xff, 0xff, 0xff, 0xdf, 0xfe, 0xe5, 0x98, 0xf0, 0x1f, 0xff,
  0xff, 0xdf, 0xfe, 0xc6, 0x67, 0x39, 0xef, 0xff, 0xff, 0xef, 0xfe, 0x0f,
  0x7b, 0xc5, 0xe7, 0xff, 0xff, 0xf1, 0xfe, 0x1f, 0x7d, 0xee, 0xd7, 0xff,
  0xff, 0xf8, 0x00, 0x6f, 0x7d, 0xde, 0x30, 0x7f, 0xff, 0xf8, 0x00, 0xf7,
  0xbe, 0xde, 0x77, 0xbf, 0xff, 0xf8, 0x03, 0xf3, 0xbe, 0xdc, 0x77, 0xdf,
  0xff, 0xfa, 0x0f, 0xf5, 0xbf, 0x50, 0xf3, 0x9f, 0xff, 0xfb, 0xdf, 0xf6,
  0x7f, 0x01, 0xe1, 0x2f, 0xff, 0xfb, 0xdf, 0xf6, 0x7e, 0x02, 0x00, 0x6f,
  0xff, 0xfd, 0xdf, 0xee, 0x1d, 0x0f, 0xcf, 0xe3, 0xff, 0xfe, 0x67, 0xec,
  0x23, 0x7f, 0xdf, 0xcd, 0xff, 0xff, 0xb3, 0xd0, 0x7f, 0x7f, 0xef, 0x9e,
  0xff, 0xff, 0xc0, 0x00, 0xfe, 0xff, 0xf0, 0x3e, 0xff, 0xff, 0xff, 0x81,
  0xfd, 0xff, 0xff, 0x7e, 0xff, 0xff, 0xff, 0xc3, 0xf3, 0xff, 0xff, 0xbe,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xc1
};

// Frame 1 bitmap data (512 bytes)
const uint8_t STONE2_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf7, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xd7, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x2f, 0xbf, 0x77, 0xff, 0xff, 0xfe, 0x0f, 0xfc, 0xf6, 0x7e, 0xef, 0xff,
  0xff, 0xfe, 0x71, 0xfa, 0xf9, 0xfd, 0xef, 0xff, 0xff, 0xfe, 0x9e, 0xf7,
  0x7b, 0xfb, 0xdf, 0xff, 0xff, 0xff, 0x67, 0x2f, 0x87, 0xe7, 0xdf, 0xff,
  0xff, 0xff, 0x78, 0x9f, 0x6f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0xbf, 0x5e,
  0xdf, 0xbf, 0xbf, 0xff, 0xff, 0xff, 0xbe, 0x29, 0xbf, 0x7f, 0x7f, 0xff,
  0xff, 0xff, 0xc1, 0xe6, 0x5e, 0xff, 0x7f, 0xff, 0xf8, 0x3f, 0xdd, 0xd1,
  0xe5, 0xe0, 0xff, 0xff, 0xf9, 0xdf, 0xbe, 0xbf, 0xf8, 0x1f, 0x7f, 0xff,
  0xfa, 0xe9, 0x7f, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0xfb, 0x76, 0xff, 0x6f,
  0xff, 0xff, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x75, 0xff, 0xff, 0xbf, 0xff,
  0xfb, 0xb5, 0xff, 0x76, 0x0b, 0xd8, 0xbf, 0xff, 0xfd, 0xd5, 0xfd, 0x7a,
  0x15, 0xb2, 0x3f, 0xff, 0xfe, 0xe1, 0xfc, 0x3b, 0x01, 0x80, 0xbf, 0xff,
  0xff, 0x1c, 0xfb, 0x1b, 0x03, 0xe0, 0xbf, 0xff, 0xff, 0xbd, 0x37, 0x1b,
  0x06, 0x71, 0xbf, 0xff, 0xff, 0x7d, 0xcf, 0x9a, 0xfe, 0x7f, 0xbf, 0xff,
  0xff, 0x7d, 0xff, 0x91, 0xff, 0xff, 0x7f, 0xff, 0x9f, 0x7d, 0xff, 0x80,
  0xff, 0xfe, 0xff, 0xff, 0x26, 0xfc, 0xff, 0xc0, 0xff, 0xfd, 0xff, 0xff,
  0x58, 0xfe, 0x7f, 0xe0, 0x6e, 0xed, 0xff, 0xff, 0x6e, 0xfe, 0x3f, 0xfe,
  0x4e, 0xcb, 0xff, 0xff, 0xb5, 0xff, 0x00, 0xfd, 0xb1, 0x33, 0xff, 0xff,
  0xd9, 0xff, 0x01, 0x02, 0x7f, 0xff, 0xff, 0xff, 0xed, 0xf1, 0x81, 0xf9,
  0x7f, 0xff, 0xff, 0xff, 0xf5, 0xce, 0x62, 0xe6, 0xff, 0xff, 0xff, 0xff,
  0xf9, 0x3f, 0xbe, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xce, 0x7d,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xf5, 0x3b, 0xff, 0xff, 0xff, 0xff,
  0xfe, 0xff, 0xf4, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xf8, 0xd7,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xf9, 0xe7, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x03, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xef,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x09, 0xe3, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xdf, 0xfe, 0xe5, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfe, 0xc6,
  0x67, 0xff, 0xff, 0xff, 0xff, 0xef, 0xfe, 0x0f, 0x7b, 0xff, 0xf8, 0x7f,
  0xff, 0xf1, 0xfe, 0x1f, 0x7d, 0xff, 0xf7, 0xbf, 0xff, 0xf8, 0x00, 0x6f,
  0x7d, 0xff, 0xe7, 0xd3, 0xff, 0xf8, 0x00, 0xf7, 0xbe, 0xcf, 0x83, 0x8d,
  0xff, 0xf8, 0x03, 0xf3, 0xbe, 0x02, 0x09, 0x2e, 0xff, 0xfa, 0x0f, 0xf5,
  0xbf, 0x01, 0xe8, 0x6e, 0xff, 0xfb, 0xdf, 0xf6, 0x7f, 0x10, 0xf7, 0xee,
  0xff, 0xfb, 0xdf, 0xf6, 0x7e, 0x1c, 0x77, 0xce, 0xff, 0xfd, 0xdf, 0xee,
  0x1d, 0x1e, 0x77, 0x81, 0xff, 0xfe, 0x67, 0xec, 0x23, 0x1e, 0x30, 0x3f,
  0xff, 0xff, 0xb3, 0xd0, 0x7f, 0x0e, 0xd7, 0xff, 0xff, 0xff, 0xc0, 0x00,
  0xfe, 0x05, 0xef, 0xff, 0xff, 0xff, 0xff, 0x81, 0xfc, 0x39, 0xef, 0xff,
  0xff, 0xff, 0xff, 0xc3, 0xf2, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t STONE2_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf7, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xd7, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x2f, 0xbf, 0x77, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf6, 0x7e, 0xef, 0xff,
  0xff, 0xff, 0xff, 0xfa, 0xf9, 0xfd, 0xef, 0xff, 0xff, 0xfe, 0x0f, 0xf7,
  0x7b, 0xfb, 0xdf, 0xff, 0xff, 0xfe, 0x70, 0x2f, 0x87, 0xe7, 0xdf, 0xff,
  0xff, 0xfe, 0x9f, 0x9f, 0x6f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0x66, 0x5e,
  0xdf, 0xbf, 0xbf, 0xff, 0xff, 0xff, 0x79, 0xe9, 0xbf, 0x7f, 0x7f, 0xff,
  0xff, 0xff, 0xbf, 0xe6, 0x5e, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xd1,
  0xe5, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xbf, 0xf8, 0x1f, 0x7f, 0xff,
  0xf8, 0x3f, 0xdf, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0xf9, 0xdf, 0xbf, 0x6f,
  0xff, 0xff, 0xbf, 0xff, 0xfa, 0xe9, 0x7f, 0x75, 0xff, 0xff, 0xbf, 0xff,
  0xfb, 0x76, 0xff, 0x76, 0x0b, 0xd8, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x7a,
  0x15, 0xb2, 0x3f, 0xff, 0xfb, 0xb5, 0xfe, 0x3b, 0x01, 0x80, 0xbf, 0xff,
  0xfd, 0xd5, 0xfd, 0x1b, 0x03, 0xe0, 0xbf, 0xff, 0xfe, 0xe1, 0xfd, 0x1b,
  0x06, 0x71, 0xbf, 0xff, 0xff, 0x1c, 0xfb, 0x9a, 0xfe, 0x7f, 0xbf, 0xff,
  0xff, 0xbd, 0x37, 0x91, 0xff, 0xff, 0x7f, 0xff, 0x9f, 0x7d, 0xcf, 0x80,
  0xff, 0xfe, 0xff, 0xff, 0x26, 0xfd, 0xff, 0xc0, 0xff, 0xfd, 0xff, 0xff,
  0x58, 0xfd, 0xff, 0xe0, 0x6e, 0xed, 0xff, 0xff, 0x6e, 0xfc, 0xff, 0xfe,
  0x4e, 0xcb, 0xff, 0xff, 0xb5, 0xfe, 0x07, 0xfd, 0xb1, 0x33, 0xff, 0xff,
  0xd9, 0xfe, 0x03, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xed, 0xf1, 0x80, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xf5, 0xce, 0x61, 0xfe, 0x7f, 0xff, 0xff, 0xff,
  0xf9, 0x3f, 0xbe, 0xf9, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xce, 0xe6,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xf5, 0x9e, 0xff, 0xff, 0xff, 0xff,
  0xfe, 0xff, 0xf4, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xf8, 0x3b,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xf8, 0x1b, 0xff, 0xff, 0xf0, 0xc1,
  0xff, 0xe7, 0xf0, 0xd7, 0xff, 0xff, 0xef, 0x3e, 0xff, 0xe1, 0xe1, 0xe7,
  0xff, 0xff, 0x1f, 0xde, 0xff, 0xc8, 0x03, 0xef, 0xff, 0xf0, 0xc7, 0xde,
  0xff, 0xde, 0x07, 0xef, 0xff, 0xc9, 0xe0, 0x6e, 0xff, 0xdf, 0x09, 0xe3,
  0xff, 0x35, 0xd1, 0x2d, 0xff, 0xdf, 0xfe, 0xe5, 0x98, 0xfe, 0x33, 0x83,
  0xff, 0xdf, 0xfe, 0xc6, 0x67, 0x0e, 0x77, 0xdf, 0xff, 0xef, 0xfe, 0x0f,
  0x7b, 0xee, 0x77, 0xbf, 0xff, 0xf1, 0xfe, 0x1f, 0x7d, 0xdc, 0xe0, 0x7f,
  0xff, 0xf8, 0x00, 0x6f, 0x7d, 0xdc, 0xef, 0xff, 0xff, 0xf8, 0x00, 0xf7,
  0xbe, 0xdd, 0x1f, 0xff, 0xff, 0xf8, 0x03, 0xf3, 0xbe, 0xd8, 0xff, 0xff,
  0xff, 0xfa, 0x0f, 0xf5, 0xbf, 0x49, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xf6,
  0x7f, 0x03, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xf6, 0x7e, 0x0f, 0xff, 0xff,
  0xff, 0xfd, 0xdf, 0xee, 0x1d, 0x3f, 0xff, 0xff, 0xff, 0xfe, 0x67, 0xec,
  0x23, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xb3, 0xd0, 0x7f, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xf3, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t STONE2_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xeb, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xdf, 0xdf, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xbf, 0x77, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xf6, 0x7e, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa,
  0xf9, 0xfd, 0xef, 0xff, 0xff, 0xfe, 0x0f, 0xf7, 0x7b, 0xfb, 0xdf, 0xff,
  0xff, 0xfe, 0x70, 0x2f, 0x87, 0xe7, 0xdf, 0xff, 0xff, 0xfe, 0x9f, 0x9f,
  0x6f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0x66, 0x5e, 0xdf, 0xbf, 0xbf, 0xff,
  0xff, 0xff, 0x79, 0xe9, 0xbf, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xe6,
  0x5e, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xd1, 0xe5, 0xe0, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0xbf, 0xf8, 0x1f, 0x7f, 0xff, 0xf8, 0x3f, 0xdf, 0x7f,
  0xff, 0xff, 0x7f, 0xff, 0xf9, 0xdf, 0xbf, 0x6f, 0xff, 0xff, 0xbf, 0xff,
  0xfa, 0xe9, 0x7f, 0x77, 0xff, 0xff, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x77,
  0xff, 0xff, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x79, 0xff, 0xff, 0xbf, 0xff,
  0xfb, 0xb5, 0xfe, 0x3a, 0x0b, 0xd8, 0xbf, 0xff, 0xfd, 0xd5, 0xfd, 0x1a,
  0x05, 0xb0, 0x3f, 0xff, 0xfe, 0xe1, 0xfd, 0x1b, 0x01, 0x81, 0xbf, 0xff,
  0xff, 0x1c, 0xfb, 0x9a, 0xe3, 0xe7, 0xbf, 0xff, 0xff, 0xbd, 0x37, 0x91,
  0xfe, 0x7f, 0x7f, 0xff, 0xff, 0x7d, 0xcf, 0x80, 0xfe, 0x7e, 0xff, 0xff,
  0xff, 0x7d, 0xff, 0xc0, 0xff, 0xfd, 0xff, 0xff, 0x9f, 0x7d, 0xff, 0xe0,
  0x6e, 0xed, 0xff, 0xff, 0x26, 0xfc, 0xff, 0xfe, 0x4e, 0xcb, 0xff, 0xff,
  0x58, 0xfe, 0x7f, 0xfd, 0xb1, 0x33, 0xff, 0xff, 0x6e, 0xfe, 0x3f, 0xf3,
  0xff, 0xff, 0xff, 0xff, 0xb5, 0xff, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff,
  0xd9, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0xf1, 0x81, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf5, 0xce, 0x62, 0xfe, 0x7f, 0xff, 0xff, 0xff,
  0xf9, 0x3f, 0xbe, 0xf9, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xce, 0xe6,
  0xff, 0xff, 0xff, 0xef, 0xfe, 0xff, 0xf5, 0x9e, 0xff, 0xff, 0xff, 0x97,
  0xfe, 0xff, 0xf4, 0x7d, 0xff, 0xff, 0xfe, 0x7b, 0xff, 0x7f, 0xf8, 0x3b,
  0xff, 0xff, 0xfd, 0xfd, 0xff, 0x9f, 0xf8, 0x1b, 0xff, 0xff, 0xfb, 0xfe,
  0xff, 0xe7, 0xf0, 0xd7, 0xff, 0xff, 0xf3, 0xfe, 0xff, 0xe1, 0xe1, 0xe7,
  0xff, 0xff, 0xf5, 0xfa, 0xff, 0xc8, 0x03, 0xef, 0xff, 0xff, 0xf6, 0x76,
  0xff, 0xde, 0x07, 0xef, 0xff, 0xff, 0xf7, 0x8e, 0xff, 0xdf, 0x09, 0xe3,
  0xff, 0x0f, 0xf7, 0xfe, 0xff, 0xdf, 0xfe, 0xe5, 0x98, 0xf0, 0x1b, 0xfd,
  0xff, 0xdf, 0xfe, 0xc6, 0x67, 0x39, 0xeb, 0xfb, 0xff, 0xef, 0xfe, 0x0f,
  0x7b, 0xc5, 0xe5, 0xf7, 0xff, 0xf1, 0xfe, 0x1f, 0x7d, 0xee, 0xd6, 0x0f,
  0xff, 0xf8, 0x00, 0x6f, 0x7d, 0xde, 0x30, 0x7f, 0xff, 0xf8, 0x00, 0xf7,
  0xbe, 0xde, 0x77, 0xbf, 0xff, 0xf8, 0x03, 0xf3, 0xbe, 0xdc, 0x77, 0xdf,
  0xff, 0xfa, 0x0f, 0xf5, 0xbf, 0x50, 0xf3, 0x9f, 0xff, 0xfb, 0xdf, 0xf6,
  0x7f, 0x01, 0xe1, 0x2f, 0xff, 0xfb, 0xdf, 0xf6, 0x7e, 0x02, 0x00, 0x6f,
  0xff, 0xfd, 0xdf, 0xee, 0x1d, 0x0f, 0xcf, 0xe3, 0xff, 0xfe, 0x67, 0xec,
  0x23, 0x7f, 0xdf, 0xcd, 0xff, 0xff, 0xb3, 0xd0, 0x7f, 0x7f, 0xef, 0x9e,
  0xff, 0xff, 0xc0, 0x00, 0xfe, 0xff, 0xf0, 0x3e, 0xff, 0xff, 0xff, 0x81,
  0xfd, 0xff, 0xff, 0x7e, 0xff, 0xff, 0xff, 0xc3, 0xf3, 0xff, 0xff, 0xbe,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xc1
};

// Frame 4 bitmap data (512 bytes)
const uint8_t STONE2_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf7, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xd7, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x2f, 0xbf, 0x77, 0xff, 0xff, 0xfe, 0x0f, 0xfc, 0xf6, 0x7e, 0xef, 0xff,
  0xff, 0xfe, 0x71, 0xfa, 0xf9, 0xfd, 0xef, 0xff, 0xff, 0xfe, 0x9e, 0xf7,
  0x7b, 0xfb, 0xdf, 0xff, 0xff, 0xff, 0x67, 0x2f, 0x87, 0xe7, 0xdf, 0xff,
  0xff, 0xff, 0x78, 0x9f, 0x6f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0xbf, 0x5e,
  0xdf, 0xbf, 0xbf, 0xff, 0xff, 0xff, 0xbe, 0x29, 0xbf, 0x7f, 0x7f, 0xff,
  0xff, 0xff, 0xc1, 0xe6, 0x5e, 0xff, 0x7f, 0xff, 0xf8, 0x3f, 0xdd, 0xd1,
  0xe5, 0xe0, 0xff, 0xff, 0xf9, 0xdf, 0xbe, 0xbf, 0xf8, 0x1f, 0x7f, 0xff,
  0xfa, 0xe9, 0x7f, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0xfb, 0x76, 0xff, 0x6f,
  0xff, 0xff, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x77, 0xff, 0xff, 0xbf, 0xff,
  0xfb, 0xb5, 0xff, 0x77, 0xff, 0xff, 0xbf, 0xff, 0xfd, 0xd5, 0xfd, 0x79,
  0xff, 0xff, 0xbf, 0xff, 0xfe, 0xe1, 0xfc, 0x3a, 0x0b, 0xd8, 0xbf, 0xff,
  0xff, 0x1c, 0xfb, 0x1a, 0x05, 0xb0, 0x3f, 0xff, 0xff, 0xbd, 0x37, 0x1b,
  0x81, 0x81, 0xbf, 0xff, 0xff, 0x7d, 0xcf, 0x9a, 0xe3, 0xe7, 0xbf, 0xff,
  0xff, 0x7d, 0xff, 0x91, 0xfe, 0x7f, 0x7f, 0xff, 0x9f, 0x7d, 0xff, 0x80,
  0xfe, 0x7e, 0xff, 0xff, 0x26, 0xfc, 0xff, 0xc0, 0xff, 0xfd, 0xff, 0xff,
  0x58, 0xfe, 0x7f, 0xe0, 0x6e, 0xed, 0xff, 0xff, 0x6e, 0xfe, 0x3f, 0xfe,
  0x4e, 0xcb, 0xff, 0xff, 0xb5, 0xff, 0x00, 0xfd, 0xb1, 0x33, 0xff, 0xff,
  0xd9, 0xff, 0x01, 0x02, 0x7f, 0xff, 0xff, 0xff, 0xed, 0xf1, 0x81, 0xf9,
  0x7f, 0xff, 0xff, 0xff, 0xf5, 0xce, 0x62, 0xe6, 0xff, 0xff, 0xff, 0xff,
  0xf9, 0x3f, 0xbe, 0x9e, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xce, 0x7d,
  0xff, 0xf0, 0x3f, 0xff, 0xfe, 0xff, 0xf5, 0x3b, 0xff, 0xef, 0xdf, 0xff,
  0xfe, 0xff, 0xf4, 0x1b, 0xff, 0xdd, 0xef, 0xff, 0xff, 0x7f, 0xf8, 0xd7,
  0xff, 0xde, 0xf7, 0xff, 0xff, 0x9f, 0xf9, 0xe7, 0xff, 0xdf, 0x7b, 0xff,
  0xff, 0xc0, 0x03, 0xef, 0xff, 0xdf, 0x7b, 0xff, 0xff, 0xc0, 0x07, 0xef,
  0xff, 0xdf, 0x7b, 0xff, 0xff, 0xdf, 0x09, 0xe3, 0xff, 0xde, 0xfb, 0xff,
  0xff, 0xdf, 0xfe, 0xe5, 0x9f, 0xde, 0xfb, 0xff, 0xff, 0xdf, 0xfe, 0xc6,
  0x67, 0xed, 0xf7, 0xff, 0xff, 0xef, 0xfe, 0x0f, 0x7b, 0xf3, 0xc8, 0x7f,
  0xff, 0xf1, 0xfe, 0x1f, 0x7d, 0xf8, 0x37, 0xbf, 0xff, 0xf8, 0x00, 0x6f,
  0x7d, 0xff, 0xe7, 0xd3, 0xff, 0xf8, 0x00, 0xf7, 0xbe, 0xcf, 0x83, 0x8d,
  0xff, 0xf8, 0x03, 0xf3, 0xbe, 0x02, 0x09, 0x2e, 0xff, 0xfa, 0x0f, 0xf5,
  0xbf, 0x01, 0xe8, 0x6e, 0xff, 0xfb, 0xdf, 0xf6, 0x7f, 0x10, 0xf7, 0xee,
  0xff, 0xfb, 0xdf, 0xf6, 0x7e, 0x1c, 0x77, 0xce, 0xff, 0xfd, 0xdf, 0xee,
  0x1d, 0x1e, 0x77, 0x81, 0xff, 0xfe, 0x67, 0xec, 0x23, 0x1e, 0x30, 0x3f,
  0xff, 0xff, 0xb3, 0xd0, 0x7f, 0x0e, 0xd7, 0xff, 0xff, 0xff, 0xc0, 0x00,
  0xfe, 0x05, 0xef, 0xff, 0xff, 0xff, 0xff, 0x81, 0xfc, 0x39, 0xef, 0xff,
  0xff, 0xff, 0xff, 0xc3, 0xf2, 0xf0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0x0f, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t STONE2_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf7, 0xeb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xd7, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xdf, 0xdf, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x2f, 0xbf, 0x77, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xf6, 0x7e, 0xef, 0xff,
  0xff, 0xff, 0xff, 0xfa, 0xf9, 0xfd, 0xef, 0xff, 0xff, 0xfe, 0x0f, 0xf7,
  0x7b, 0xfb, 0xdf, 0xff, 0xff, 0xfe, 0x70, 0x2f, 0x87, 0xe7, 0xdf, 0xff,
  0xff, 0xfe, 0x9f, 0x9f, 0x6f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0x66, 0x5e,
  0xdf, 0xbf, 0xbf, 0xff, 0xff, 0xff, 0x79, 0xe9, 0xbf, 0x7f, 0x7f, 0xff,
  0xff, 0xff, 0xbf, 0xe6, 0x5e, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xd1,
  0xe5, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xbf, 0xf8, 0x1f, 0x7f, 0xff,
  0xf8, 0x3f, 0xdf, 0x7f, 0xff, 0xff, 0x7f, 0xff, 0xf9, 0xdf, 0xbf, 0x6f,
  0xff, 0xff, 0xbf, 0xdf, 0xfa, 0xe9, 0x7f, 0x77, 0xff, 0xff, 0xbf, 0x2f,
  0xfb, 0x76, 0xff, 0x77, 0xff, 0xff, 0xbc, 0xf7, 0xfb, 0x76, 0xff, 0x79,
  0xff, 0xff, 0xbb, 0xfb, 0xfb, 0xb5, 0xfe, 0x3a, 0x0b, 0xd8, 0xb7, 0xfd,
  0xfd, 0xd5, 0xfd, 0x1a, 0x05, 0xb0, 0x27, 0xfd, 0xfe, 0xe1, 0xfd, 0x1b,
  0x81, 0x81, 0xab, 0xf5, 0xff, 0x1c, 0xfb, 0x9a, 0xe3, 0xe7, 0xac, 0xed,
  0xff, 0xbd, 0x37, 0x91, 0xfe, 0x7f, 0x6f, 0x1d, 0x9f, 0x7d, 0xcf, 0x80,
  0xfe, 0x7e, 0xef, 0xfd, 0x26, 0xfd, 0xff, 0xc0, 0xff, 0xfd, 0xf7, 0xfb,
  0x58, 0xfd, 0xff, 0xe0, 0x6e, 0xed, 0xf7, 0xf7, 0x6e, 0xfc, 0xff, 0xfe,
  0x4e, 0xcb, 0xfb, 0xef, 0xb5, 0xfe, 0x07, 0xfd, 0xb1, 0x33, 0xfc, 0x1f,
  0xd9, 0xfe, 0x03, 0xf3, 0xff, 0xff, 0x87, 0xff, 0xed, 0xf1, 0x80, 0x0f,
  0xff, 0xff, 0x7b, 0xff, 0xf5, 0xce, 0x61, 0xfe, 0x7f, 0xfe, 0xfb, 0xff,
  0xf9, 0x3f, 0xbe, 0xf9, 0x7f, 0xfe, 0xfb, 0xff, 0xfe, 0xff, 0xce, 0xe6,
  0xff, 0xfe, 0x3b, 0xff, 0xfe, 0xff, 0xf5, 0x9e, 0xff, 0xfc, 0xcb, 0xff,
  0xfe, 0xff, 0xf4, 0x7d, 0xff, 0xfa, 0x77, 0xff, 0xff, 0x7f, 0xf8, 0x3b,
  0xff, 0xf7, 0x37, 0xff, 0xff, 0x9f, 0xf8, 0x1b, 0xff, 0xf7, 0xbb, 0xff,
  0xff, 0xe7, 0xf0, 0xd7, 0xff, 0xf7, 0x3b, 0xff, 0xff, 0xe1, 0xe1, 0xe7,
  0xff, 0xf6, 0x3b, 0xff, 0xff, 0xc8, 0x03, 0xef, 0xff, 0xe0, 0x1b, 0xff,
  0xff, 0xde, 0x07, 0xef, 0xff, 0x83, 0x97, 0xff, 0xff, 0xdf, 0x09, 0xe3,
  0xff, 0x3b, 0x4f, 0xff, 0xff, 0xdf, 0xfe, 0xe5, 0x98, 0xfc, 0xef, 0xff,
  0xff, 0xdf, 0xfe, 0xc6, 0x67, 0x0c, 0xef, 0xff, 0xff, 0xef, 0xfe, 0x0f,
  0x7b, 0xec, 0xef, 0xff, 0xff, 0xf1, 0xfe, 0x1f, 0x7d, 0xdd, 0xdf, 0xff,
  0xff, 0xf8, 0x00, 0x6f, 0x7d, 0xdc, 0xbf, 0xff, 0xff, 0xf8, 0x00, 0xf7,
  0xbe, 0xdd, 0x7f, 0xff, 0xff, 0xf8, 0x03, 0xf3, 0xbe, 0xd8, 0xff, 0xff,
  0xff, 0xfa, 0x0f, 0xf5, 0xbf, 0x49, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xf6,
  0x7f, 0x03, 0xff, 0xff, 0xff, 0xfb, 0xdf, 0xf6, 0x7e, 0x0f, 0xff, 0xff,
  0xff, 0xfd, 0xdf, 0xee, 0x1d, 0x3f, 0xff, 0xff, 0xff, 0xfe, 0x67, 0xec,
  0x23, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xb3, 0xd0, 0x7f, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0x00, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x81,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xf3, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t STONE2_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x3f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0xbf, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfe, 0xfd, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xfd, 0xfb, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0xf2, 0xfb, 0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xcf, 0x67, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff, 0xaf, 0x9f, 0xde, 0xff,
  0xff, 0xff, 0xe0, 0xff, 0x77, 0xbf, 0xbd, 0xff, 0xff, 0xff, 0xe7, 0x02,
  0xf8, 0x7e, 0x7d, 0xff, 0xff, 0xff, 0xe9, 0xf9, 0xf6, 0xfd, 0xfb, 0xff,
  0xff, 0xff, 0xf6, 0x65, 0xed, 0xfb, 0xfb, 0xff, 0xff, 0xff, 0xf7, 0x9e,
  0x9b, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xfb, 0xfe, 0x65, 0xef, 0xf7, 0xff,
  0xff, 0xff, 0xfb, 0xfd, 0x1e, 0x5e, 0x0f, 0xff, 0xff, 0xff, 0xfc, 0x0b,
  0xff, 0x81, 0xf7, 0xff, 0xff, 0x83, 0xfd, 0xf7, 0xff, 0xff, 0xf7, 0xff,
  0xff, 0x9d, 0xfb, 0xf6, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xae, 0x97, 0xf7,
  0x7f, 0xff, 0xfb, 0xff, 0xff, 0xb7, 0x6f, 0xf7, 0x7f, 0xff, 0xfb, 0xff,
  0xff, 0xb7, 0x6f, 0xf7, 0x9f, 0xff, 0xfb, 0xff, 0xff, 0xbb, 0x5f, 0xe3,
  0xa0, 0xbd, 0x8b, 0xff, 0xff, 0xdd, 0x5f, 0xd1, 0xa0, 0x5b, 0x03, 0xff,
  0xff, 0xee, 0x1f, 0xd1, 0xb9, 0x18, 0x9b, 0xff, 0xff, 0xf1, 0xcf, 0xb9,
  0xae, 0x3e, 0x7b, 0xff, 0xff, 0xfb, 0xd3, 0x79, 0x1f, 0xe7, 0xf7, 0xff,
  0xf9, 0xf7, 0xdc, 0xf8, 0x0f, 0xe7, 0xef, 0xff, 0xf2, 0x6f, 0xdf, 0xfc,
  0x0f, 0xff, 0xdf, 0xff, 0xf5, 0x8f, 0xdf, 0xfe, 0x06, 0xee, 0xdf, 0xff,
  0xf6, 0xef, 0xcf, 0xff, 0xe4, 0xec, 0xbf, 0xff, 0xfb, 0x5f, 0xe0, 0x7f,
  0xdb, 0x13, 0x3f, 0xff, 0xfd, 0x9f, 0xe0, 0x3f, 0x3f, 0xff, 0xf8, 0x7f,
  0xfe, 0xdf, 0x18, 0x00, 0xff, 0xff, 0xf7, 0xbf, 0xff, 0x5c, 0xe6, 0x1f,
  0xe7, 0xff, 0xef, 0xbf, 0xff, 0x93, 0xfb, 0xef, 0x97, 0xff, 0xef, 0xbf,
  0xff, 0xef, 0xfc, 0xee, 0x6f, 0xff, 0xe3, 0xbf, 0xff, 0xef, 0xff, 0x59,
  0xef, 0xff, 0xcc, 0xbf, 0xff, 0xef, 0xff, 0x47, 0xdf, 0xff, 0xa7, 0x7f,
  0xff, 0xf7, 0xff, 0x83, 0xbf, 0xff, 0x73, 0x7f, 0xff, 0xf9, 0xff, 0x81,
  0xbf, 0xff, 0x7b, 0xbf, 0xff, 0xfe, 0x7f, 0x0d, 0x7f, 0xff, 0x73, 0xbf,
  0xff, 0xfe, 0x1e, 0x1e, 0x7f, 0xff, 0x63, 0xbf, 0xff, 0xfc, 0x80, 0x3e,
  0xff, 0xfe, 0x01, 0xbf, 0xff, 0xfd, 0xe0, 0x7e, 0xff, 0xf8, 0x39, 0x7f,
  0xff, 0xfd, 0xf0, 0x9e, 0x3f, 0xf3, 0xb4, 0xff, 0xff, 0xfd, 0xff, 0xee,
  0x59, 0x8f, 0xce, 0xff, 0xff, 0xfd, 0xff, 0xec, 0x66, 0x70, 0xce, 0xff,
  0xff, 0xfe, 0xff, 0xe0, 0xf7, 0xbe, 0xce, 0xff, 0xff, 0xff, 0x1f, 0xe1,
  0xf7, 0xdd, 0xdd, 0xff, 0xff, 0xff, 0x80, 0x06, 0xf7, 0xdd, 0xcb, 0xff,
  0xff, 0xff, 0x80, 0x0f, 0x7b, 0xed, 0xd7, 0xff, 0xff, 0xff, 0x80, 0x3f,
  0x3b, 0xed, 0x8f, 0xff, 0xff, 0xff, 0xa0, 0xff, 0x5b, 0xf4, 0x9f, 0xff,
  0xff, 0xff, 0xbd, 0xff, 0x67, 0xf0, 0x3f, 0xff, 0xff, 0xff, 0xbd, 0xff,
  0x67, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xdd, 0xfe, 0xe1, 0xd3, 0xff, 0xff,
  0xff, 0xff, 0xe6, 0x7e, 0xc2, 0x37, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x3d,
  0x07, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x0f, 0xef, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf8, 0x1f, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x3f, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t STONE2_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x9f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0x5f, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0x7e, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe, 0xfd, 0xbf,
  0xff, 0xff, 0xff, 0xff, 0xf9, 0x7d, 0xfb, 0xbf, 0xff, 0xff, 0xff, 0xff,
  0xe7, 0xb3, 0xf7, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xd7, 0xcf, 0xef, 0x7f,
  0xff, 0xff, 0xf0, 0x7f, 0xbb, 0xdf, 0xde, 0xff, 0xff, 0xff, 0xf3, 0x81,
  0x7c, 0x3f, 0x3e, 0xff, 0xff, 0xff, 0xf4, 0xfc, 0xfb, 0x7e, 0xfd, 0xff,
  0xff, 0xff, 0xfb, 0x32, 0xf6, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xfb, 0xcf,
  0x4d, 0xfb, 0xfb, 0xff, 0xff, 0xff, 0xfd, 0xff, 0x32, 0xf7, 0xfb, 0xff,
  0xff, 0xff, 0xfd, 0xfe, 0x8f, 0x2f, 0x07, 0xff, 0xff, 0xff, 0xfe, 0x05,
  0xff, 0xc0, 0xfb, 0xff, 0xff, 0xc1, 0xfe, 0xfb, 0xff, 0xff, 0xfb, 0xff,
  0xff, 0xce, 0xfd, 0xfb, 0x7f, 0xff, 0xfd, 0xff, 0xff, 0xd7, 0x4b, 0xfb,
  0xbf, 0xff, 0xfd, 0xff, 0xff, 0xdb, 0xb7, 0xfb, 0xbf, 0xff, 0xfd, 0xff,
  0xff, 0xdb, 0xb7, 0xfb, 0xcf, 0xff, 0xfd, 0xff, 0xff, 0xdd, 0xaf, 0xf1,
  0xd0, 0x5e, 0xc5, 0xff, 0xff, 0xee, 0xaf, 0xe8, 0xd0, 0x2d, 0x81, 0xff,
  0xff, 0xf7, 0x0f, 0xe8, 0xdc, 0x8c, 0x4d, 0xff, 0xff, 0xf8, 0xe7, 0xdc,
  0xd7, 0x1f, 0x3d, 0xff, 0xff, 0xfd, 0xe9, 0xbc, 0x8f, 0xf3, 0xfb, 0xff,
  0xfc, 0xfb, 0xee, 0x7c, 0x07, 0xf3, 0xf7, 0xff, 0xf9, 0x37, 0xef, 0xfe,
  0x07, 0xff, 0xef, 0xff, 0xfa, 0xc7, 0xef, 0xff, 0x03, 0x77, 0x6f, 0xff,
  0xfb, 0x77, 0xe7, 0xff, 0xf2, 0x76, 0x5f, 0xff, 0xfd, 0xaf, 0xf0, 0x3f,
  0xed, 0x88, 0x0f, 0xff, 0xfe, 0xcf, 0xf0, 0x1f, 0x9f, 0xfe, 0xf7, 0xff,
  0xff, 0x6f, 0x8c, 0x00, 0x7f, 0xfd, 0xf7, 0xff, 0xff, 0xae, 0x73, 0x0f,
  0xf3, 0xfd, 0xf7, 0xff, 0xff, 0xc9, 0xfd, 0xf7, 0xcb, 0xfc, 0x0f, 0xff,
  0xff, 0xf7, 0xfe, 0x77, 0x37, 0xfe, 0xf7, 0xff, 0xff, 0xf7, 0xff, 0xac,
  0xf7, 0xfc, 0x77, 0xff, 0xff, 0xf7, 0xff, 0xa3, 0xef, 0xfb, 0x3b, 0xff,
  0xff, 0xfb, 0xff, 0xc1, 0xdf, 0xf7, 0xdd, 0xff, 0xff, 0xfc, 0xff, 0xc0,
  0xdf, 0xf7, 0x9d, 0xff, 0xff, 0xff, 0x3f, 0x86, 0xbf, 0xf7, 0x0d, 0xff,
  0xff, 0xff, 0x0f, 0x0f, 0x3f, 0xfb, 0x0b, 0xff, 0xff, 0xfe, 0x40, 0x1f,
  0x7f, 0xf8, 0xf3, 0xff, 0xff, 0xfe, 0xf0, 0x3f, 0x7f, 0xf8, 0xdb, 0xff,
  0xff, 0xfe, 0xf8, 0x4f, 0x1f, 0xe6, 0x3b, 0xff, 0xff, 0xfe, 0xff, 0xf7,
  0x2c, 0xcf, 0x3b, 0xff, 0xff, 0xfe, 0xff, 0xf6, 0x33, 0x3b, 0x9b, 0xff,
  0xff, 0xff, 0x7f, 0xf0, 0x7b, 0x81, 0xb7, 0xff, 0xff, 0xff, 0x8f, 0xf0,
  0xfb, 0xe9, 0x97, 0xff, 0xff, 0xff, 0xc0, 0x03, 0x7b, 0xe9, 0xa7, 0xff,
  0xff, 0xff, 0xc0, 0x07, 0xbd, 0xf1, 0x8f, 0xff, 0xff, 0xff, 0xc0, 0x1f,
  0x9d, 0xf5, 0x9f, 0xff, 0xff, 0xff, 0xd0, 0x7f, 0xad, 0xf8, 0xbf, 0xff,
  0xff, 0xff, 0xde, 0xff, 0xb3, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xde, 0xff,
  0xb3, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xee, 0xff, 0x70, 0xe9, 0xff, 0xff,
  0xff, 0xff, 0xf3, 0x3f, 0x61, 0x1b, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x9e,
  0x83, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x00, 0x07, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x0f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x1f, 0x9f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t STONE2_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfd, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xfb, 0xf6, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xe5, 0xf7, 0xee, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x9e, 0xcf, 0xdd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x5f, 0x3f, 0xbd, 0xff,
  0xff, 0xff, 0xc1, 0xfe, 0xef, 0x7f, 0x7b, 0xff, 0xff, 0xff, 0xce, 0x05,
  0xf0, 0xfc, 0xfb, 0xff, 0xff, 0xff, 0xd3, 0xf3, 0xed, 0xfb, 0xf7, 0xff,
  0xff, 0xff, 0xec, 0xcb, 0xdb, 0xf7, 0xf7, 0xff, 0xff, 0xff, 0xef, 0x3d,
  0x37, 0xef, 0xef, 0xff, 0xff, 0xff, 0xf7, 0xfc, 0xcb, 0xdf, 0xef, 0xff,
  0xff, 0xff, 0xf7, 0xfa, 0x3c, 0xbc, 0x1f, 0xff, 0xff, 0xff, 0xf8, 0x17,
  0xff, 0x03, 0xef, 0xff, 0xff, 0x07, 0xfb, 0xef, 0xff, 0xff, 0xef, 0xff,
  0xff, 0x3b, 0xf7, 0xed, 0xff, 0xff, 0xf7, 0xff, 0xff, 0x5d, 0x2f, 0xee,
  0xff, 0xff, 0xf7, 0xff, 0xff, 0x6e, 0xdf, 0xee, 0xff, 0xff, 0xf7, 0xff,
  0xff, 0x6e, 0xdf, 0xef, 0x3f, 0xff, 0xf7, 0xff, 0xff, 0x76, 0xbf, 0xc7,
  0x41, 0x7b, 0x17, 0xff, 0xff, 0xba, 0xbf, 0xa3, 0x40, 0xb6, 0x07, 0xff,
  0xff, 0xdc, 0x3f, 0xa3, 0x72, 0x31, 0x37, 0xff, 0xff, 0xe3, 0x9f, 0x73,
  0x5c, 0x7c, 0xf7, 0xff, 0xff, 0xf7, 0xa6, 0xf2, 0x3f, 0xcf, 0xef, 0xff,
  0xf3, 0xef, 0xb9, 0xf0, 0x1f, 0xcf, 0xdf, 0xff, 0xe4, 0xdf, 0xbf, 0xf8,
  0x1f, 0xff, 0xbf, 0xff, 0xeb, 0x1f, 0xbf, 0xfc, 0x0d, 0xdd, 0xbf, 0xff,
  0xed, 0xdf, 0x9f, 0xff, 0xc9, 0xd9, 0x7f, 0xff, 0xf6, 0xbf, 0xc0, 0xff,
  0xb6, 0x26, 0x7f, 0xff, 0xfb, 0x3f, 0xc0, 0x78, 0x30, 0xff, 0xff, 0xff,
  0xfd, 0xbe, 0x30, 0x01, 0xcf, 0x7f, 0xff, 0xff, 0xfe, 0xb9, 0xcc, 0x37,
  0x8f, 0x87, 0xff, 0xff, 0xff, 0x27, 0xf7, 0xd7, 0x36, 0x3b, 0xff, 0xff,
  0xff, 0xdf, 0xf9, 0xd4, 0xe0, 0x7d, 0xff, 0xff, 0xff, 0xdf, 0xfe, 0xb3,
  0xc8, 0xbe, 0xff, 0xff, 0xff, 0xdf, 0xfe, 0x8f, 0x9c, 0xc5, 0x7f, 0xff,
  0xff, 0xef, 0xff, 0x07, 0x3e, 0xc0, 0x3f, 0xff, 0xff, 0xf3, 0xff, 0x03,
  0x5e, 0x3f, 0x3f, 0xff, 0xff, 0xfc, 0xfe, 0x1a, 0xe0, 0x7f, 0xdf, 0xff,
  0xff, 0xfc, 0x3c, 0x3c, 0xfe, 0x67, 0xef, 0xff, 0xff, 0xf9, 0x00, 0x7d,
  0xff, 0x6b, 0xef, 0xff, 0xff, 0xfb, 0xc0, 0xfd, 0xff, 0x23, 0xef, 0xff,
  0xff, 0xfb, 0xe1, 0x3c, 0x7f, 0x8c, 0xef, 0xff, 0xff, 0xfb, 0xff, 0xdc,
  0xb3, 0x1f, 0x6f, 0xff, 0xff, 0xfb, 0xff, 0xd8, 0xcc, 0xff, 0xaf, 0xff,
  0xff, 0xfd, 0xff, 0xc1, 0xef, 0x7f, 0xcf, 0xff, 0xff, 0xfe, 0x3f, 0xc3,
  0xef, 0xbf, 0xdf, 0xff, 0xff, 0xff, 0x00, 0x0d, 0xef, 0xbf, 0xdf, 0xff,
  0xff, 0xff, 0x00, 0x1e, 0xf7, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0x00, 0x7e,
  0x77, 0xdf, 0xdf, 0xff, 0xff, 0xff, 0x41, 0xfe, 0xb7, 0xef, 0xbf, 0xff,
  0xff, 0xff, 0x7b, 0xfe, 0xcf, 0xe6, 0x7f, 0xff, 0xff, 0xff, 0x7b, 0xfe,
  0xcf, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xbb, 0xfd, 0xc3, 0xa7, 0xff, 0xff,
  0xff, 0xff, 0xcc, 0xfd, 0x84, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x7a,
  0x0f, 0xef, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x1f, 0xdf, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x3f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x01, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t STONE2_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfb, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xeb, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xef, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xdf, 0xdf, 0xb7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2f, 0xbf, 0x77, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0xf6, 0x7e, 0xef, 0xff, 0xff, 0xff, 0xff, 0xfa,
  0xf9, 0xfd, 0xef, 0xff, 0xff, 0xfe, 0x0f, 0xf7, 0x7b, 0xfb, 0xdf, 0xff,
  0xff, 0xfe, 0x70, 0x2f, 0x87, 0xe7, 0xdf, 0xff, 0xff, 0xfe, 0x9f, 0x9f,
  0x6f, 0xdf, 0xbf, 0xff, 0xff, 0xff, 0x66, 0x5e, 0xdf, 0xbf, 0xbf, 0xff,
  0xff, 0xff, 0x79, 0xe9, 0xbf, 0x7f, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xe6,
  0x5e, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xd1, 0xe5, 0xe0, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0xbf, 0xf8, 0x1f, 0x7f, 0xff, 0xf8, 0x3f, 0xdf, 0x7f,
  0xff, 0xff, 0x7f, 0xff, 0xf9, 0xdf, 0xbf, 0x6f, 0xff, 0xff, 0xbf, 0xff,
  0xfa, 0xe9, 0x7f, 0x75, 0xff, 0xff, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x76,
  0x0b, 0xd8, 0xbf, 0xff, 0xfb, 0x76, 0xff, 0x7a, 0x05, 0xb0, 0x3f, 0xff,
  0xfb, 0xb5, 0xfe, 0x3b, 0x21, 0x84, 0xbf, 0xff, 0xfd, 0xd5, 0xfd, 0x1b,
  0x53, 0xea, 0xbf, 0xff, 0xfe, 0xe1, 0xfd, 0x1b, 0x06, 0x71, 0xbf, 0xff,
  0xff, 0x1c, 0xfb, 0x9a, 0xfe, 0x7f, 0xbf, 0xff, 0xff, 0xbd, 0x37, 0x91,
  0xff, 0xff, 0x7f, 0xff, 0xff, 0x7d, 0xcf, 0x80, 0xff, 0xfe, 0xff, 0xff,
  0xff, 0x7d, 0xff, 0xc0, 0xff, 0xfd, 0xff, 0xff, 0x9f, 0x7d, 0xff, 0xe0,
  0x6e, 0xed, 0xff, 0xff, 0x26, 0xfc, 0xff, 0xfe, 0x4e, 0xcb, 0xff, 0xff,
  0x58, 0xfe, 0x7f, 0xfd, 0xb1, 0x33, 0xff, 0xff, 0x6e, 0xfe, 0x3f, 0xf3,
  0xff, 0xff, 0xff, 0xff, 0xb5, 0xff, 0x00, 0x0f, 0xff, 0xff, 0xff, 0xff,
  0xd9, 0xff, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xed, 0xf1, 0x81, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf5, 0xce, 0x62, 0xfe, 0x7f, 0xff, 0xff, 0xff,
  0xf9, 0x3f, 0xbe, 0xf9, 0x7f, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xce, 0xe6,
  0xff, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xf5, 0x9e, 0xff, 0xff, 0xff, 0xff,
  0xfe, 0xff, 0xf4, 0x7d, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xf8, 0x3b,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xf8, 0x1b, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe7, 0xf0, 0xd7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xe1, 0xe7,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0x03, 0xef, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xde, 0x07, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x09, 0xe3,
  0xff, 0x0f, 0xff, 0xff, 0xff, 0xdf, 0xfe, 0xe5, 0x98, 0xf0, 0x1f, 0xff,
  0xff, 0xdf, 0xfe, 0xc6, 0x67, 0x39, 0xef, 0xff, 0xff, 0xef, 0xfe, 0x0f,
  0x7b, 0xc5, 0xe7, 0xff, 0xff, 0xf1, 0xfe, 0x1f, 0x7d, 0xee, 0xd7, 0xff,
  0xff, 0xf8, 0x00, 0x6f, 0x7d, 0xde, 0x30, 0x7f, 0xff, 0xf8, 0x00, 0xf7,
  0xbe, 0xde, 0x77, 0xbf, 0xff, 0xf8, 0x03, 0xf3, 0xbe, 0xdc, 0x77, 0xdf,
  0xff, 0xfa, 0x0f, 0xf5, 0xbf, 0x50, 0xf3, 0x9f, 0xff, 0xfb, 0xdf, 0xf6,
  0x7f, 0x01, 0xe1, 0x2f, 0xff, 0xfb, 0xdf, 0xf6, 0x7e, 0x02, 0x00, 0x6f,
  0xff, 0xfd, 0xdf, 0xee, 0x1d, 0x0f, 0xcf, 0xe3, 0xff, 0xfe, 0x67, 0xec,
  0x23, 0x7f, 0xdf, 0xcd, 0xff, 0xff, 0xb3, 0xd0, 0x7f, 0x7f, 0xef, 0x9e,
  0xff, 0xff, 0xc0, 0x00, 0xfe, 0xff, 0xf0, 0x3e, 0xff, 0xff, 0xff, 0x81,
  0xfd, 0xff, 0xff, 0x7e, 0xff, 0xff, 0xff, 0xc3, 0xf3, 0xff, 0xff, 0xbe,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xc1
};

// Frame 10 bitmap data (512 bytes)
const uint8_t STONE2_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t STONE2_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // STONE2_H
