// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from plant2.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:54
 *
 * Usage in Kywy projects:
 *   #include "plant2.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, PLANT2_FRAME_WIDTH,
 *                            PLANT2_FRAME_HEIGHT, PLANT2_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {PLANT2_frame_0, PLANT2_frame_1, PLANT2_frame_2,
 * PLANT2_frame_3, PLANT2_frame_4, PLANT2_frame_5, PLANT2_frame_6,
 * PLANT2_frame_7, PLANT2_frame_8, PLANT2_frame_9, PLANT2_frame_10,
 * PLANT2_frame_11}; engine.display.drawBitmap(x, y, PLANT2_FRAME_WIDTH,
 *                            PLANT2_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef PLANT2_H
#define PLANT2_H

#include <stdint.h>

// Sprite sheet information
#define PLANT2_FRAME_WIDTH 64
#define PLANT2_FRAME_HEIGHT 64
#define PLANT2_FRAME_COUNT 12
#define PLANT2_SPRITE_COLS 3
#define PLANT2_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t PLANT2_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0x81, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xdf, 0xec, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xe3, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xcf, 0xff, 0xdf, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xbf, 0xff, 0xdf, 0xff, 0xff, 0xfe, 0x0f, 0x7f,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xf9, 0xf0, 0x7f, 0x7f, 0xff, 0xdf, 0xff,
  0xff, 0xf7, 0xff, 0x7e, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xbe,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xdf, 0xff, 0xde, 0xfc, 0x00, 0xbf, 0xff,
  0xff, 0xdf, 0xff, 0xee, 0xf3, 0xff, 0x3f, 0xff, 0xff, 0xbf, 0xf0, 0xf5,
  0xef, 0xff, 0xcf, 0xff, 0xff, 0xbf, 0x0f, 0x01, 0xdf, 0xff, 0xe7, 0xff,
  0xff, 0xbc, 0x7f, 0xe5, 0xbf, 0xff, 0xfb, 0xff, 0xff, 0x73, 0xff, 0xde,
  0x7f, 0xff, 0xf9, 0xff, 0xff, 0x6f, 0xff, 0xbe, 0xff, 0xff, 0xfd, 0xff,
  0xff, 0x4f, 0xff, 0xbe, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x2f, 0xff, 0x7f,
  0x47, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xfe, 0xff, 0x80, 0xff, 0xff, 0x7f,
  0xff, 0xdf, 0xf9, 0xff, 0x9f, 0x7f, 0xff, 0x7f, 0xff, 0xdf, 0xc1, 0xff,
  0xbf, 0xbf, 0xff, 0x7f, 0xff, 0xdf, 0x0d, 0xff, 0xbf, 0xdf, 0xff, 0x7f,
  0xff, 0xdc, 0x9e, 0xff, 0xbf, 0xef, 0xfe, 0xff, 0xff, 0xd3, 0x3f, 0x7f,
  0xbf, 0xf7, 0xfe, 0xff, 0xff, 0xcf, 0x3f, 0x7f, 0x7f, 0xf7, 0xfe, 0xff,
  0xfe, 0x3f, 0x7c, 0xbf, 0x7e, 0x37, 0xfc, 0x7f, 0xf9, 0x8f, 0x7c, 0x1f,
  0x78, 0x37, 0xf9, 0x9f, 0xfb, 0xc3, 0x7c, 0x2f, 0x76, 0x33, 0xf3, 0xdf,
  0xf7, 0xe0, 0x7c, 0x33, 0x76, 0x33, 0xe7, 0xef, 0xf7, 0xe0, 0x7e, 0x04,
  0x30, 0x73, 0x87, 0xef, 0xf7, 0xf0, 0x7f, 0x0f, 0x38, 0xfb, 0x8f, 0xef,
  0xef, 0xf0, 0x7b, 0xff, 0xff, 0xb9, 0x0f, 0xf7, 0xef, 0xf8, 0x38, 0x71,
  0xc7, 0x38, 0x1f, 0xf7, 0xef, 0xf8, 0x38, 0x00, 0x80, 0x30, 0x1f, 0xf7,
  0xdf, 0xf8, 0x18, 0x07, 0x00, 0x20, 0x3f, 0xfb, 0xdf, 0xfc, 0x5e, 0x0f,
  0xe0, 0xec, 0x3f, 0xfb, 0xdf, 0xfd, 0x8f, 0x9f, 0xf3, 0xd2, 0x3f, 0xfb,
  0xdf, 0xfe, 0x03, 0xe3, 0xcf, 0x81, 0x7f, 0xfb, 0xdf, 0xfe, 0x00, 0xfc,
  0x3e, 0x00, 0x7f, 0xfb, 0xdf, 0xfe, 0x01, 0x3f, 0xf1, 0x80, 0x7f, 0xfb,
  0xdf, 0xfe, 0x01, 0xc7, 0x8f, 0x80, 0x7f, 0xfb, 0xdf, 0xff, 0x00, 0xf8,
  0x7f, 0x80, 0xff, 0xfb, 0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd, 0xbf, 0xff, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfd, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfd, 0xbf, 0xfc, 0x01, 0xff,
  0xff, 0x00, 0x3f, 0xfd, 0xdf, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x4f, 0xfb,
  0xdf, 0xef, 0x01, 0xff, 0xff, 0x80, 0x77, 0xfb, 0xdf, 0xef, 0x01, 0xff,
  0xff, 0xc0, 0xf7, 0xfb, 0xef, 0xdf, 0x83, 0xff, 0xff, 0xc0, 0xfb, 0xf7,
  0xef, 0xbf, 0x87, 0xff, 0xff, 0xe0, 0xfd, 0xf7, 0xef, 0xbf, 0xcf, 0xff,
  0xff, 0xf3, 0xfd, 0xef, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t PLANT2_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0x81, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f,
  0xec, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xe3, 0xff, 0xbf, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xcf, 0xff, 0xdf, 0xff, 0xff, 0xfc, 0x07, 0x7f,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xfb, 0xfa, 0x7f, 0x3f, 0xff, 0xdf, 0xff,
  0xff, 0xf7, 0xfc, 0x7e, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xbe,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xdf, 0xff, 0xde, 0xfc, 0x00, 0xbf, 0xff,
  0xff, 0xdf, 0xff, 0xee, 0xf3, 0xff, 0x1f, 0xff, 0xff, 0xbf, 0xff, 0xf5,
  0xef, 0xff, 0xef, 0xff, 0xff, 0xbf, 0x00, 0x01, 0xdf, 0xff, 0xf7, 0xff,
  0xff, 0x78, 0xff, 0xe5, 0xbf, 0xff, 0xfb, 0xff, 0xff, 0x77, 0xff, 0xde,
  0x7f, 0xff, 0xfd, 0xff, 0xff, 0x4f, 0xff, 0xbe, 0xff, 0xff, 0xfd, 0xff,
  0xff, 0x2f, 0xff, 0xbe, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xff, 0x7f,
  0x47, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xfe, 0xff, 0x80, 0xff, 0xff, 0x7f,
  0xff, 0xdf, 0xf9, 0xff, 0x9f, 0x3f, 0xff, 0x7f, 0xff, 0xbf, 0xc1, 0xff,
  0xbf, 0xdf, 0xff, 0x7f, 0xff, 0xbe, 0x0d, 0xff, 0xbf, 0xef, 0xff, 0x7f,
  0xff, 0xa1, 0x9e, 0xff, 0xbf, 0xf7, 0xf2, 0xff, 0xff, 0x9f, 0x3f, 0x7f,
  0xbf, 0xfb, 0xec, 0xff, 0xff, 0xc7, 0x3f, 0x7f, 0x7f, 0xfd, 0xee, 0xff,
  0xff, 0x3b, 0x7c, 0xbf, 0x7e, 0x3d, 0xdf, 0x7f, 0xff, 0x7b, 0x7c, 0x1f,
  0x78, 0x3d, 0xbf, 0x7f, 0xfe, 0xfd, 0x7c, 0x2f, 0x76, 0x3d, 0x7f, 0x7f,
  0xfe, 0xfc, 0x7c, 0x33, 0x76, 0x3d, 0x7f, 0xbf, 0xfe, 0xfe, 0x7e, 0x04,
  0x30, 0x7c, 0xff, 0xbf, 0xfd, 0xfe, 0x7f, 0x0f, 0x38, 0xfa, 0xff, 0xbf,
  0xfd, 0xff, 0x7b, 0xff, 0xff, 0xb9, 0xff, 0xdf, 0xfd, 0xff, 0x38, 0x71,
  0xc7, 0x39, 0xff, 0xdf, 0xfb, 0xff, 0xb8, 0x00, 0x80, 0x31, 0xff, 0xdf,
  0xfb, 0xff, 0x98, 0x07, 0x00, 0x21, 0xff, 0xdf, 0xfb, 0xff, 0xde, 0x0f,
  0xe0, 0xe3, 0xff, 0xdf, 0xfb, 0xff, 0xcf, 0x9f, 0xf3, 0xc3, 0xff, 0xdf,
  0xfb, 0xff, 0xc3, 0xe3, 0xcf, 0x83, 0xff, 0xdf, 0xfb, 0xff, 0xc0, 0xfc,
  0x3c, 0x03, 0xff, 0xdf, 0xfb, 0xff, 0xcf, 0x3f, 0xf0, 0x07, 0xff, 0xef,
  0xfb, 0xff, 0xcf, 0xc7, 0x88, 0x07, 0xff, 0xef, 0xf7, 0xff, 0xc7, 0xf8,
  0x78, 0x07, 0xff, 0xef, 0xf7, 0xff, 0xc7, 0xff, 0xf0, 0x07, 0xff, 0xef,
  0xf7, 0xff, 0xc7, 0xff, 0xf0, 0x03, 0xff, 0xef, 0xf7, 0xff, 0xc7, 0xff,
  0xf0, 0x01, 0xff, 0xef, 0xf7, 0xff, 0x87, 0xff, 0xf0, 0x00, 0x7f, 0xdf,
  0xf7, 0xff, 0x07, 0xff, 0xf0, 0x00, 0x3f, 0xdf, 0xfb, 0xff, 0x07, 0xff,
  0xf0, 0x01, 0x3f, 0xdf, 0xfb, 0xfe, 0x0f, 0xff, 0xf8, 0x01, 0xdf, 0xbf,
  0xfb, 0xfc, 0x0f, 0xff, 0xf8, 0x03, 0xef, 0xbf, 0xfd, 0xf8, 0x1f, 0xff,
  0xfc, 0x03, 0xef, 0x7f, 0xfd, 0xf0, 0x3f, 0xff, 0xfc, 0x07, 0xf0, 0x7f,
  0xfd, 0xf0, 0x7f, 0xff, 0xfe, 0x0f, 0xff, 0xff, 0xfe, 0x08, 0xff, 0xff,
  0xff, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t PLANT2_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0x81, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
  0xec, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xe3, 0xff, 0xbf, 0xff,
  0xff, 0xfe, 0x07, 0x7f, 0xcf, 0xff, 0xdf, 0xff, 0xff, 0xfd, 0xfb, 0x7f,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xfb, 0xfc, 0x7f, 0xbf, 0xff, 0xdf, 0xff,
  0xff, 0xf7, 0xff, 0x7e, 0x7f, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xbe,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xdf, 0xff, 0xde, 0xfc, 0x00, 0xbf, 0xff,
  0xff, 0xdf, 0xff, 0xee, 0xf3, 0xff, 0x0f, 0xff, 0xff, 0xbf, 0xf0, 0xf5,
  0xef, 0xff, 0xf7, 0xff, 0xff, 0xbf, 0x0f, 0x01, 0xdf, 0xff, 0xfb, 0xff,
  0xff, 0xbc, 0x7f, 0xe5, 0xbf, 0xff, 0xfd, 0xff, 0xff, 0x7b, 0xff, 0xde,
  0x7f, 0xff, 0xfe, 0xff, 0xff, 0x77, 0xff, 0xbe, 0xff, 0xff, 0xff, 0x7f,
  0xff, 0x6f, 0xff, 0xbe, 0xff, 0xff, 0xff, 0x7f, 0xff, 0x0f, 0xff, 0x7f,
  0x47, 0xff, 0xff, 0x7f, 0xff, 0xdf, 0xfe, 0xff, 0x80, 0xff, 0xff, 0x7f,
  0xff, 0xdf, 0xf9, 0xff, 0x9f, 0x7f, 0xff, 0x3f, 0xff, 0xdf, 0xc1, 0xff,
  0xbf, 0xbf, 0xfe, 0x4f, 0xff, 0xdf, 0x0d, 0xff, 0xbf, 0xdf, 0xfd, 0xef,
  0xff, 0xdc, 0x9e, 0xff, 0xbf, 0xef, 0xfb, 0xf7, 0xff, 0xd3, 0x3f, 0x7f,
  0xbf, 0xf7, 0xfb, 0xf7, 0xff, 0xcf, 0x3f, 0x7f, 0x7f, 0xf7, 0xf7, 0xf7,
  0xff, 0xbc, 0x7c, 0xbf, 0x7e, 0x37, 0xf7, 0xfb, 0xff, 0xcb, 0xbc, 0x1f,
  0x78, 0x37, 0xf7, 0xfb, 0xff, 0xe7, 0xbc, 0x2f, 0x76, 0x33, 0xef, 0xfb,
  0xff, 0xef, 0xdc, 0x33, 0x76, 0x33, 0xcf, 0xfd, 0xff, 0xef, 0xde, 0x04,
  0x30, 0x73, 0x8f, 0xfd, 0xff, 0xdf, 0xdf, 0x0f, 0x38, 0xfb, 0x9f, 0xfd,
  0xff, 0xdf, 0xeb, 0xff, 0xff, 0xb9, 0x1f, 0xfd, 0xff, 0xbf, 0xe8, 0x71,
  0xc7, 0x38, 0x1f, 0xfd, 0xff, 0xbf, 0xe8, 0x00, 0x80, 0x30, 0x3f, 0xfd,
  0xff, 0xbf, 0xf0, 0x07, 0x00, 0x20, 0x3f, 0xfd, 0xff, 0x7f, 0xf6, 0x0f,
  0xe0, 0xec, 0x7f, 0xfd, 0xff, 0x7f, 0xf7, 0x9f, 0xf3, 0xd2, 0x7f, 0xfe,
  0xfe, 0xff, 0xfb, 0xe3, 0xcf, 0x89, 0x7f, 0xfe, 0xfe, 0xff, 0xfc, 0xfc,
  0x38, 0x04, 0x7f, 0xfe, 0xfe, 0xff, 0xfd, 0x3f, 0xe0, 0x01, 0x7f, 0xfe,
  0xfe, 0xff, 0xfd, 0xc7, 0x80, 0x03, 0xbf, 0xfe, 0xfd, 0xff, 0xfc, 0xf8,
  0x60, 0x03, 0xdf, 0xfe, 0xfd, 0xff, 0xfc, 0xff, 0xc0, 0x03, 0xe7, 0xfd,
  0xfd, 0xff, 0xfc, 0xff, 0xc0, 0x03, 0xfb, 0xfd, 0xfd, 0xff, 0xfc, 0xff,
  0xc0, 0x03, 0xfb, 0xfd, 0xfe, 0xff, 0xfc, 0xff, 0xc0, 0x07, 0xfd, 0xfb,
  0xfe, 0xff, 0xfc, 0xff, 0xc0, 0x07, 0xfe, 0xfb, 0xff, 0x7f, 0xfc, 0xff,
  0xc0, 0x07, 0xfe, 0xf7, 0xfe, 0x3f, 0xfd, 0xff, 0xe0, 0x07, 0xff, 0x07,
  0xfe, 0x1f, 0xfd, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xfe, 0x0f, 0xfd, 0xff,
  0xf0, 0x0f, 0xff, 0xff, 0xfe, 0x07, 0xf3, 0xff, 0xf0, 0x1f, 0xff, 0xff,
  0xfe, 0x03, 0xe7, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xff, 0x03, 0xcf, 0xff,
  0xfc, 0xff, 0xff, 0xff, 0xff, 0x84, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t PLANT2_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfb, 0x7f, 0xfa, 0xff, 0xff, 0xff, 0xff, 0x8f, 0xf7,
  0xbf, 0xe7, 0x7f, 0xff, 0xff, 0xff, 0xb7, 0xef, 0xdf, 0x1f, 0xbf, 0xff,
  0xff, 0xff, 0xb9, 0xdf, 0xec, 0xff, 0xbf, 0xdf, 0xff, 0x1f, 0xbe, 0x3f,
  0xe3, 0xff, 0xdf, 0xaf, 0xff, 0x67, 0xdf, 0x7f, 0xcf, 0xff, 0xdf, 0x6f,
  0xff, 0x7b, 0xdf, 0x7f, 0xbf, 0xff, 0xbe, 0xef, 0xff, 0x7c, 0x0f, 0x7f,
  0xbf, 0xff, 0xb9, 0xef, 0xff, 0xbf, 0xf0, 0x7f, 0x7f, 0xff, 0x07, 0xef,
  0xff, 0xbf, 0xff, 0x7e, 0xff, 0xf0, 0x7f, 0xef, 0xff, 0xcf, 0xff, 0xbe,
  0xff, 0x0f, 0xff, 0xef, 0xff, 0xf7, 0xff, 0xde, 0xfc, 0xff, 0xff, 0xdf,
  0xff, 0xfb, 0xff, 0xee, 0xf3, 0xff, 0xff, 0xdf, 0xff, 0xfd, 0xf0, 0xf5,
  0xef, 0xff, 0xff, 0xbf, 0xff, 0x1c, 0x0f, 0x01, 0xdf, 0xff, 0xff, 0x7f,
  0xff, 0x63, 0xff, 0xe5, 0xbf, 0xff, 0xfe, 0xff, 0xff, 0x7f, 0xff, 0xde,
  0x7f, 0xff, 0xfd, 0xff, 0xff, 0xbf, 0xff, 0xbe, 0xff, 0xff, 0xfb, 0xff,
  0xff, 0xbf, 0xff, 0xbe, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xdf, 0xff, 0x7f,
  0x47, 0xff, 0xcf, 0xff, 0xff, 0xef, 0xfe, 0xff, 0x80, 0xff, 0xbf, 0xff,
  0xff, 0xf3, 0xf9, 0xff, 0x9f, 0x7c, 0x7f, 0xff, 0xff, 0xfc, 0x01, 0xff,
  0xbf, 0x83, 0xff, 0xff, 0xff, 0xff, 0x8d, 0xff, 0xbf, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0x9e, 0xff, 0xbf, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x7f,
  0xbf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x7f, 0x7f, 0xfb, 0xff, 0xff,
  0xfe, 0x3f, 0x7c, 0xbf, 0x7e, 0x3b, 0x3c, 0x7f, 0xf9, 0x8f, 0x7c, 0x1f,
  0x78, 0x3c, 0x19, 0x9f, 0xfb, 0xc3, 0x7c, 0x4f, 0x72, 0x3c, 0x03, 0xdf,
  0xf7, 0xe0, 0x7c, 0x23, 0x74, 0x3c, 0x07, 0xef, 0xf7, 0xe0, 0x7e, 0x04,
  0x30, 0x7c, 0x07, 0xef, 0xf7, 0xf0, 0x7f, 0x0f, 0x38, 0xf8, 0x0f, 0xef,
  0xef, 0xf0, 0x7b, 0xff, 0xff, 0xb8, 0x0f, 0xf7, 0xef, 0xf8, 0x38, 0x71,
  0xc7, 0x38, 0x1f, 0xf7, 0xef, 0xf8, 0x38, 0x00, 0x80, 0x30, 0x1f, 0xf7,
  0xdf, 0xf8, 0x18, 0x07, 0x00, 0x20, 0x3f, 0xfb, 0xdf, 0xfc, 0x5e, 0x0f,
  0xe0, 0xec, 0x3f, 0xfb, 0xdf, 0xfd, 0x8f, 0x9f, 0xf3, 0xd2, 0x3f, 0xfb,
  0xdf, 0xfe, 0x03, 0xe3, 0xcf, 0x81, 0x7f, 0xfb, 0xdf, 0xfe, 0x00, 0xfc,
  0x3e, 0x00, 0x7f, 0xfb, 0xdf, 0xfe, 0x01, 0x3f, 0xf1, 0x80, 0x7f, 0xfb,
  0xdf, 0xfe, 0x01, 0xc7, 0x8f, 0x80, 0x7f, 0xfb, 0xdf, 0xff, 0x00, 0xf8,
  0x7f, 0x80, 0xff, 0xfb, 0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd, 0xbf, 0xff, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfd, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfd, 0xbf, 0xfc, 0x01, 0xff,
  0xff, 0x00, 0x3f, 0xfd, 0xdf, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x4f, 0xfb,
  0xdf, 0xef, 0x01, 0xff, 0xff, 0x80, 0x77, 0xfb, 0xdf, 0xef, 0x01, 0xff,
  0xff, 0xc0, 0xf7, 0xfb, 0xef, 0xdf, 0x83, 0xff, 0xff, 0xc0, 0xfb, 0xf7,
  0xef, 0xbf, 0x87, 0xff, 0xff, 0xe0, 0xfd, 0xf7, 0xef, 0xbf, 0xcf, 0xff,
  0xff, 0xf3, 0xfd, 0xef, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t PLANT2_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf5, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
  0xff, 0xed, 0xff, 0xff, 0xff, 0xff, 0x1f, 0xef, 0x7f, 0xde, 0xff, 0xff,
  0xff, 0xff, 0x6f, 0xdf, 0x9f, 0x3f, 0x7f, 0xff, 0xff, 0xff, 0x71, 0xdf,
  0xec, 0xff, 0x7f, 0xff, 0xff, 0xc3, 0x7e, 0x3f, 0xe3, 0xff, 0xbf, 0xbf,
  0xff, 0xdd, 0xbf, 0x7f, 0xcf, 0xff, 0xbf, 0x5f, 0xff, 0xde, 0xdf, 0x7f,
  0xbf, 0xff, 0x7e, 0xdf, 0xff, 0xdf, 0x0f, 0x7f, 0xbf, 0xff, 0x7d, 0xdf,
  0xff, 0xef, 0xf0, 0x7f, 0x7f, 0xff, 0x03, 0xdf, 0xff, 0xef, 0xff, 0x7e,
  0xff, 0xf0, 0x7f, 0xdf, 0xff, 0xef, 0xff, 0xbe, 0xff, 0x0f, 0xff, 0xdf,
  0xff, 0xf7, 0xff, 0xde, 0xfc, 0xff, 0xff, 0xdf, 0xff, 0x1b, 0xff, 0xee,
  0xf3, 0xff, 0xff, 0xbf, 0xff, 0x61, 0xf0, 0xf5, 0xef, 0xff, 0xff, 0xbf,
  0xff, 0x7c, 0x0f, 0x01, 0xdf, 0xff, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xe5,
  0xbf, 0xff, 0xfe, 0xff, 0xff, 0xbf, 0xff, 0xde, 0x7f, 0xff, 0xfd, 0xff,
  0xff, 0xdf, 0xff, 0xbe, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xef, 0xff, 0xbe,
  0xff, 0xff, 0xf7, 0xff, 0xff, 0xf3, 0xff, 0x7f, 0x47, 0xff, 0xef, 0xff,
  0xff, 0xfc, 0xfe, 0xff, 0x80, 0xff, 0x9f, 0xff, 0xff, 0xff, 0x39, 0xff,
  0x9f, 0x00, 0x7f, 0xff, 0xff, 0xff, 0x81, 0xff, 0xbf, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0x8c, 0xff, 0xbf, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x9f, 0x7f,
  0xbf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x7f, 0x7f, 0xfb, 0xff, 0xff,
  0xfe, 0x3f, 0x3c, 0xbf, 0x7e, 0x3b, 0x3c, 0x7f, 0xf9, 0x8f, 0x7c, 0x1f,
  0x78, 0x3c, 0x19, 0x9f, 0xfb, 0xc3, 0x7c, 0x4f, 0x72, 0x3c, 0x03, 0xdf,
  0xf7, 0xe0, 0x7c, 0x23, 0x74, 0x3c, 0x07, 0xef, 0xf7, 0xe0, 0x7e, 0x04,
  0x30, 0x7c, 0x07, 0xef, 0xf7, 0xf0, 0x7f, 0x0f, 0x38, 0xf8, 0x0f, 0xef,
  0xef, 0xf0, 0x7b, 0xff, 0xff, 0xb8, 0x0f, 0xf7, 0xef, 0xf8, 0x38, 0x71,
  0xc7, 0x38, 0x1f, 0xf7, 0xef, 0xf8, 0x38, 0x00, 0x80, 0x30, 0x1f, 0xf7,
  0xdf, 0xf8, 0x18, 0x07, 0x00, 0x20, 0x3f, 0xfb, 0xdf, 0xfc, 0x5e, 0x0f,
  0xe0, 0xec, 0x3f, 0xfb, 0xdf, 0xfd, 0x8f, 0x9f, 0xf3, 0xd2, 0x3f, 0xfb,
  0xdf, 0xfe, 0x03, 0xe3, 0xcf, 0x81, 0x7f, 0xfb, 0xdf, 0xfe, 0x00, 0xfc,
  0x3e, 0x00, 0x7f, 0xfb, 0xdf, 0xfe, 0x01, 0x3f, 0xf1, 0x80, 0x7f, 0xfb,
  0xdf, 0xfe, 0x01, 0xc7, 0x8f, 0x80, 0x7f, 0xfb, 0xdf, 0xff, 0x00, 0xf8,
  0x7f, 0x80, 0xff, 0xfb, 0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd, 0xbf, 0xff, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfd, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfd, 0xbf, 0xfc, 0x01, 0xff,
  0xff, 0x00, 0x3f, 0xfd, 0xdf, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x4f, 0xfb,
  0xdf, 0xef, 0x01, 0xff, 0xff, 0x80, 0x77, 0xfb, 0xdf, 0xef, 0x01, 0xff,
  0xff, 0xc0, 0xf7, 0xfb, 0xef, 0xdf, 0x83, 0xff, 0xff, 0xc0, 0xfb, 0xf7,
  0xef, 0xbf, 0x87, 0xff, 0xff, 0xe0, 0xfd, 0xf7, 0xef, 0xbf, 0xcf, 0xff,
  0xff, 0xf3, 0xfd, 0xef, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t PLANT2_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
  0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xff, 0xf5, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf6, 0xff, 0xee, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xef,
  0x7f, 0xdf, 0x7f, 0xff, 0xff, 0xff, 0xed, 0xdf, 0x9f, 0x3f, 0x7f, 0x7f,
  0xff, 0x07, 0xee, 0xdf, 0xec, 0xff, 0xbe, 0xbf, 0xff, 0x79, 0xef, 0x3f,
  0xe3, 0xff, 0xbd, 0xbf, 0xff, 0x7e, 0x6f, 0x7f, 0xcf, 0xff, 0x7b, 0xbf,
  0xff, 0x7f, 0x8f, 0x7f, 0xbf, 0xff, 0x67, 0xbf, 0xff, 0xbf, 0xcf, 0x7f,
  0xbf, 0xfe, 0x1f, 0xbf, 0xff, 0xbf, 0xf0, 0x7f, 0x7f, 0xe0, 0xff, 0xbf,
  0xff, 0xdf, 0xff, 0x7e, 0xff, 0xdf, 0xff, 0xbf, 0xff, 0xef, 0xff, 0xbe,
  0xff, 0x3f, 0xff, 0x7f, 0xff, 0xf7, 0xff, 0xde, 0xfc, 0xff, 0xff, 0x7f,
  0xff, 0xfb, 0xff, 0xee, 0xf3, 0xff, 0xfe, 0xff, 0xff, 0x1d, 0xf0, 0xf5,
  0xef, 0xff, 0xfd, 0xff, 0xff, 0x62, 0x0f, 0x01, 0xdf, 0xff, 0xfb, 0xff,
  0xff, 0x7f, 0xff, 0xe5, 0xbf, 0xff, 0xfb, 0xff, 0xff, 0xbf, 0xff, 0xde,
  0x7f, 0xff, 0xf7, 0xff, 0xff, 0xbf, 0xff, 0xbe, 0xff, 0xff, 0xef, 0xff,
  0xff, 0xdf, 0xff, 0xbe, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xef, 0xff, 0x7f,
  0x47, 0xff, 0x7f, 0xff, 0xff, 0xf3, 0xfe, 0xff, 0x80, 0xfe, 0xff, 0xff,
  0xff, 0xfc, 0x79, 0xff, 0x9f, 0x7d, 0xff, 0xff, 0xff, 0xff, 0x81, 0xff,
  0xbf, 0x83, 0xff, 0xff, 0xff, 0xff, 0x8d, 0xff, 0xbf, 0xcf, 0xff, 0xff,
  0xff, 0xff, 0x9e, 0xff, 0xbf, 0xf7, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x7f,
  0xbf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0x3f, 0x7f, 0x7f, 0xfb, 0xff, 0xff,
  0xfe, 0x3f, 0x7c, 0xbf, 0x7e, 0x3b, 0x3c, 0x7f, 0xf9, 0x8f, 0x7c, 0x1f,
  0x78, 0x3c, 0x19, 0x9f, 0xfb, 0xc3, 0x7c, 0x4f, 0x72, 0x3c, 0x03, 0xdf,
  0xf7, 0xe0, 0x7c, 0x23, 0x74, 0x3c, 0x07, 0xef, 0xf7, 0xe0, 0x7e, 0x04,
  0x30, 0x7c, 0x07, 0xef, 0xf7, 0xf0, 0x7f, 0x0f, 0x38, 0xf8, 0x0f, 0xef,
  0xef, 0xf0, 0x7b, 0xff, 0xff, 0xb8, 0x0f, 0xf7, 0xef, 0xf8, 0x38, 0x71,
  0xc7, 0x38, 0x1f, 0xf7, 0xef, 0xf8, 0x38, 0x00, 0x80, 0x30, 0x1f, 0xf7,
  0xdf, 0xf8, 0x18, 0x07, 0x00, 0x20, 0x3f, 0xfb, 0xdf, 0xfc, 0x5e, 0x0f,
  0xe0, 0xec, 0x3f, 0xfb, 0xdf, 0xfd, 0x8f, 0x9f, 0xf3, 0xd2, 0x3f, 0xfb,
  0xdf, 0xfe, 0x03, 0xe3, 0xcf, 0x81, 0x7f, 0xfb, 0xdf, 0xfe, 0x00, 0xfc,
  0x3e, 0x00, 0x7f, 0xfb, 0xdf, 0xfe, 0x01, 0x3f, 0xf1, 0x80, 0x7f, 0xfb,
  0xdf, 0xfe, 0x01, 0xc7, 0x8f, 0x80, 0x7f, 0xfb, 0xdf, 0xff, 0x00, 0xf8,
  0x7f, 0x80, 0xff, 0xfb, 0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd, 0xbf, 0xff, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfd, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfd, 0xbf, 0xfc, 0x01, 0xff,
  0xff, 0x00, 0x3f, 0xfd, 0xdf, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x4f, 0xfb,
  0xdf, 0xef, 0x01, 0xff, 0xff, 0x80, 0x77, 0xfb, 0xdf, 0xef, 0x01, 0xff,
  0xff, 0xc0, 0xf7, 0xfb, 0xef, 0xdf, 0x83, 0xff, 0xff, 0xc0, 0xfb, 0xf7,
  0xef, 0xbf, 0x87, 0xff, 0xff, 0xe0, 0xfd, 0xf7, 0xef, 0xbf, 0xcf, 0xff,
  0xff, 0xf3, 0xfd, 0xef, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t PLANT2_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0x81, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
  0xec, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xe3, 0xff, 0xbf, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xcf, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xfe, 0x0f, 0x7f, 0xbf, 0xff, 0xdf, 0xff,
  0xff, 0xf9, 0xf0, 0x7f, 0x7f, 0xff, 0xdf, 0xff, 0xff, 0xf7, 0xff, 0x7e,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xbe, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xdf, 0xff, 0xde, 0xfc, 0x00, 0xbf, 0xff, 0xff, 0xdf, 0xff, 0xee,
  0xf3, 0xff, 0x3f, 0xff, 0xff, 0xbf, 0xf0, 0xf5, 0xef, 0xff, 0xcf, 0xff,
  0xff, 0xbf, 0x0f, 0x01, 0xdf, 0xff, 0xe7, 0xff, 0xff, 0xbc, 0x7f, 0xe5,
  0xbf, 0xff, 0xfb, 0xff, 0xff, 0x73, 0xff, 0xde, 0x7f, 0xff, 0xf9, 0xff,
  0xff, 0x6f, 0xff, 0xbe, 0xff, 0xff, 0xfd, 0xff, 0xff, 0x4f, 0xff, 0xbe,
  0xff, 0xff, 0xfe, 0xff, 0xff, 0x2f, 0xff, 0x7f, 0x47, 0xff, 0xfe, 0xff,
  0xff, 0xdf, 0xfe, 0xff, 0x80, 0xff, 0xff, 0x7f, 0xff, 0xdf, 0xf9, 0xff,
  0x9f, 0x7f, 0xff, 0x7f, 0xff, 0xdf, 0xc1, 0xff, 0xbf, 0xbf, 0xff, 0x7f,
  0xff, 0xdf, 0x0d, 0xff, 0xbf, 0xdf, 0xff, 0x7f, 0xff, 0xdc, 0x9e, 0xff,
  0xbf, 0xef, 0xfe, 0xff, 0xff, 0xd3, 0x3f, 0x7f, 0xbf, 0xf7, 0xfe, 0xff,
  0xfe, 0x0f, 0x3f, 0x7f, 0x7f, 0xf7, 0xfe, 0x7f, 0xf9, 0x8f, 0x7c, 0xbf,
  0x7e, 0x37, 0xf9, 0x9f, 0xfb, 0xc7, 0x7c, 0x1f, 0x78, 0x37, 0xfb, 0xdf,
  0xf7, 0xe3, 0x7c, 0x0f, 0x70, 0x33, 0xf7, 0xef, 0xf7, 0xe0, 0x7c, 0x43,
  0x71, 0x33, 0xe7, 0xef, 0xf7, 0xf0, 0x7e, 0x24, 0x32, 0x73, 0x8f, 0xef,
  0xef, 0xf0, 0x7f, 0x0f, 0x38, 0xfb, 0x8f, 0xf7, 0xef, 0xf8, 0x7b, 0xff,
  0xff, 0xb9, 0x1f, 0xf7, 0xef, 0xf8, 0x38, 0x71, 0xc7, 0x38, 0x1f, 0xf7,
  0xdf, 0xf8, 0x38, 0x00, 0x80, 0x30, 0x3f, 0xfb, 0xdf, 0xfc, 0x18, 0x07,
  0x00, 0x20, 0x3f, 0xfb, 0xdf, 0xfd, 0x8e, 0x0f, 0xe0, 0xe2, 0x3f, 0xfb,
  0xdf, 0xfe, 0x07, 0x9f, 0xf3, 0xd1, 0x7f, 0xfb, 0xdf, 0xfe, 0x01, 0xe3,
  0xcf, 0x80, 0x7f, 0xfb, 0xdf, 0xfe, 0x00, 0xfc, 0x3e, 0x00, 0x7f, 0xfb,
  0xdf, 0xfe, 0x01, 0x3f, 0xf1, 0x80, 0x7f, 0xfb, 0xdf, 0xff, 0x00, 0xc7,
  0x8f, 0x80, 0xff, 0xfb, 0xbf, 0xff, 0x00, 0xf8, 0x7f, 0x00, 0xff, 0xfd,
  0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd, 0xbf, 0xff, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfd, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfd, 0xbf, 0xfc, 0x01, 0xff,
  0xff, 0x00, 0x3f, 0xfd, 0xdf, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x4f, 0xfb,
  0xdf, 0xef, 0x01, 0xff, 0xff, 0x80, 0x77, 0xfb, 0xdf, 0xef, 0x01, 0xff,
  0xff, 0xc0, 0xf7, 0xfb, 0xef, 0xdf, 0x83, 0xff, 0xff, 0xc0, 0xfb, 0xf7,
  0xef, 0xbf, 0x87, 0xff, 0xff, 0xe0, 0xfd, 0xf7, 0xef, 0xbf, 0xcf, 0xff,
  0xff, 0xf3, 0xfd, 0xef, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t PLANT2_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0x81, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xdf, 0xec, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xe3, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xcf, 0xff, 0xdf, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xbf, 0xff, 0xdf, 0xff, 0xff, 0xfe, 0x0f, 0x7f,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xf9, 0xf0, 0x7f, 0x7f, 0xff, 0xdf, 0xff,
  0xff, 0xf7, 0xff, 0x7e, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xbe,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xdf, 0xff, 0xde, 0xfc, 0x00, 0xbf, 0xff,
  0xff, 0xdf, 0xff, 0xee, 0xf3, 0xff, 0x3f, 0xff, 0xff, 0xbf, 0xf0, 0xf5,
  0xef, 0xff, 0xcf, 0xff, 0xff, 0xbf, 0x0f, 0x01, 0xdf, 0xff, 0xe7, 0xff,
  0xff, 0xbc, 0x7f, 0xe5, 0xbf, 0xff, 0xfb, 0xff, 0xff, 0x73, 0xff, 0xde,
  0x7f, 0xff, 0xf9, 0xff, 0xff, 0x6f, 0xff, 0xbe, 0xff, 0xff, 0xfd, 0xff,
  0xff, 0x4f, 0xff, 0xbe, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x2f, 0xff, 0x7f,
  0x47, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xfe, 0xff, 0x80, 0xff, 0xff, 0x7f,
  0xff, 0xdf, 0xf9, 0xff, 0x9f, 0x7f, 0xff, 0x7f, 0xff, 0xdf, 0xc1, 0xff,
  0xbf, 0xbf, 0xff, 0x7f, 0xff, 0xdf, 0x0d, 0xff, 0xbf, 0xdf, 0xff, 0x7f,
  0xff, 0xdc, 0x9e, 0xff, 0xbf, 0xef, 0xfe, 0xff, 0xff, 0xd3, 0x3f, 0x7f,
  0xbf, 0xf7, 0xfe, 0xff, 0xff, 0xcf, 0x3f, 0x7f, 0x7f, 0xf7, 0xfe, 0x7f,
  0xfe, 0x3f, 0x7f, 0xbf, 0x7f, 0xf7, 0xf9, 0xbf, 0xf9, 0x87, 0x7c, 0x5f,
  0x7e, 0x37, 0xfb, 0xdf, 0xfb, 0xc3, 0x7c, 0x0f, 0x78, 0x33, 0xf7, 0xdf,
  0xf7, 0xe1, 0x7c, 0x03, 0x70, 0x33, 0xe7, 0xef, 0xf7, 0xe0, 0x7c, 0x44,
  0x31, 0x33, 0x8f, 0xef, 0xf7, 0xf0, 0x7e, 0x27, 0x32, 0x7b, 0x9f, 0xef,
  0xef, 0xf0, 0x7f, 0x0f, 0xf8, 0xf9, 0x1f, 0xf7, 0xef, 0xf8, 0x7b, 0xff,
  0xff, 0xb8, 0x1f, 0xf7, 0xef, 0xf8, 0x38, 0x71, 0xc7, 0x30, 0x1f, 0xfb,
  0xdf, 0xf8, 0x38, 0x00, 0x80, 0x20, 0x3f, 0xfd, 0xdf, 0xfc, 0x08, 0x07,
  0x00, 0x20, 0x3f, 0xfd, 0xdf, 0xfd, 0x86, 0x0f, 0xe0, 0xd2, 0x3f, 0xfd,
  0xdf, 0xfe, 0x01, 0x9f, 0xf3, 0x81, 0x7f, 0xfd, 0xdf, 0xfe, 0x00, 0xe3,
  0xce, 0x00, 0x7f, 0xfd, 0xdf, 0xfe, 0x00, 0x3c, 0x31, 0x80, 0x7f, 0xfd,
  0xdf, 0xfe, 0x00, 0xc7, 0x8f, 0x00, 0x7f, 0xfd, 0xdf, 0xff, 0x00, 0xf8,
  0x7f, 0x00, 0xff, 0xfd, 0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfe,
  0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfe, 0xbf, 0xff, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfe, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfe,
  0xbf, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfe, 0xbf, 0xfc, 0x01, 0xff,
  0xff, 0x00, 0x1f, 0xfe, 0xbf, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x6f, 0xfd,
  0xbf, 0xef, 0x01, 0xff, 0xff, 0x80, 0x77, 0xfd, 0xbf, 0xdf, 0x01, 0xff,
  0xff, 0xc0, 0xfb, 0xfd, 0xdf, 0xbf, 0x83, 0xff, 0xff, 0xc0, 0xfd, 0xfb,
  0xdf, 0x7f, 0x87, 0xff, 0xff, 0xe0, 0xfe, 0xfb, 0xdf, 0x7f, 0xcf, 0xff,
  0xff, 0xf3, 0xff, 0x7b, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x83,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t PLANT2_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xe0, 0x0f, 0x81, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf,
  0xec, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xe3, 0xff, 0xbf, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xcf, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xfe, 0x0f, 0x7f, 0xbf, 0xff, 0xdf, 0xff,
  0xff, 0xf9, 0xf0, 0x7f, 0x7f, 0xff, 0xdf, 0xff, 0xff, 0xf7, 0xff, 0x7e,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xbe, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xdf, 0xff, 0xde, 0xfc, 0x00, 0xbf, 0xff, 0xff, 0xdf, 0xff, 0xee,
  0xf3, 0xff, 0x3f, 0xff, 0xff, 0xbf, 0xf0, 0xf5, 0xef, 0xff, 0xcf, 0xff,
  0xff, 0xbf, 0x0f, 0x01, 0xdf, 0xff, 0xe7, 0xff, 0xff, 0xbc, 0x7f, 0xe5,
  0xbf, 0xff, 0xfb, 0xff, 0xff, 0x73, 0xff, 0xde, 0x7f, 0xff, 0xf9, 0xff,
  0xff, 0x6f, 0xff, 0xbe, 0xff, 0xff, 0xfd, 0xff, 0xff, 0x4f, 0xff, 0xbe,
  0xff, 0xff, 0xfe, 0xff, 0xff, 0x2f, 0xff, 0x7f, 0x47, 0xff, 0xfe, 0xff,
  0xff, 0xdf, 0xfe, 0xff, 0x80, 0xff, 0xff, 0x7f, 0xff, 0xdf, 0xf9, 0xff,
  0x9f, 0x7f, 0xff, 0x7f, 0xff, 0xdf, 0xc1, 0xff, 0xbf, 0xbf, 0xff, 0x7f,
  0xff, 0xdf, 0x0d, 0xff, 0xbf, 0xdf, 0xff, 0x7f, 0xff, 0xdc, 0x9e, 0xff,
  0xbf, 0xef, 0xfe, 0xff, 0xff, 0xd3, 0x3f, 0x7f, 0xbf, 0xf7, 0xfe, 0xff,
  0xff, 0xcf, 0x3f, 0x7f, 0x7f, 0xf7, 0xfe, 0xff, 0xff, 0xff, 0x7f, 0xbf,
  0x7f, 0xf7, 0xf9, 0xff, 0xff, 0xff, 0x7c, 0x5f, 0x7e, 0x37, 0xf8, 0x7f,
  0xfc, 0xff, 0x7c, 0x0f, 0x78, 0x33, 0xf3, 0xbf, 0xfb, 0x0f, 0x7c, 0x03,
  0x70, 0x33, 0xe3, 0xdf, 0xf7, 0x83, 0x7c, 0x04, 0x30, 0x33, 0x87, 0xdf,
  0xef, 0xc1, 0x7e, 0x07, 0x30, 0x7b, 0x8f, 0xef, 0xef, 0xe0, 0x7f, 0x0f,
  0xf8, 0xf9, 0x2f, 0xef, 0xef, 0xf1, 0x7b, 0xff, 0xff, 0xb8, 0x1f, 0xef,
  0xdf, 0xf0, 0x38, 0x71, 0xc7, 0x30, 0x1f, 0xf7, 0xdf, 0xf8, 0x38, 0x00,
  0x80, 0x20, 0x1f, 0xf7, 0xdf, 0xf9, 0x88, 0x07, 0x00, 0x20, 0x1f, 0xf7,
  0xbf, 0xf8, 0x06, 0x0f, 0xe0, 0xd0, 0x3f, 0xfb, 0xbf, 0xfc, 0x61, 0x9f,
  0xf3, 0x84, 0x3f, 0xfb, 0xbf, 0xfd, 0x80, 0xe3, 0xce, 0x02, 0x3f, 0xfb,
  0xbf, 0xfe, 0x00, 0x3c, 0x31, 0xe1, 0x7f, 0xfb, 0xbf, 0xfe, 0x00, 0x47,
  0x8f, 0xe0, 0x7f, 0xfb, 0xbf, 0xfe, 0x00, 0x78, 0x7f, 0x80, 0x7f, 0xfb,
  0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0x7f, 0xfb, 0xbf, 0xfe, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfb, 0x7f, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfb,
  0x7f, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfb, 0x7f, 0xfc, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfb, 0x7f, 0xfc, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfb,
  0x7f, 0xfc, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfb, 0x7f, 0xf8, 0x01, 0xff,
  0xff, 0x00, 0x3f, 0xfb, 0x7f, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x5f, 0xf7,
  0x7f, 0xef, 0x01, 0xff, 0xff, 0x80, 0x6f, 0xf7, 0x7f, 0xdf, 0x01, 0xff,
  0xff, 0xc0, 0xef, 0xf7, 0xbf, 0xbf, 0x83, 0xff, 0xff, 0xc0, 0xf7, 0xef,
  0xbf, 0x7f, 0x87, 0xff, 0xff, 0xe0, 0xfb, 0xef, 0xbe, 0xff, 0xcf, 0xff,
  0xff, 0xf3, 0xfb, 0xdf, 0xc1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x1f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t PLANT2_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x0f, 0x81, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xdf, 0xec, 0x7e, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xe3, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xcf, 0xff, 0xdf, 0xff,
  0xff, 0xff, 0xff, 0x7f, 0xbf, 0xff, 0xdf, 0xff, 0xff, 0xfe, 0x0f, 0x7f,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xf9, 0xf0, 0x7f, 0x7f, 0xff, 0xdf, 0xff,
  0xff, 0xf7, 0xff, 0x7e, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xef, 0xff, 0xbe,
  0xff, 0xff, 0xdf, 0xff, 0xff, 0xdf, 0xff, 0xde, 0xfc, 0x00, 0xbf, 0xff,
  0xff, 0xdf, 0xff, 0xee, 0xf3, 0xff, 0x3f, 0xff, 0xff, 0xbf, 0xf0, 0xf5,
  0xef, 0xff, 0xcf, 0xff, 0xff, 0xbf, 0x0f, 0x01, 0xdf, 0xff, 0xe7, 0xff,
  0xff, 0xbc, 0x7f, 0xe5, 0xbf, 0xff, 0xfb, 0xff, 0xff, 0x73, 0xff, 0xde,
  0x7f, 0xff, 0xf9, 0xff, 0xff, 0x6f, 0xff, 0xbe, 0xff, 0xff, 0xfd, 0xff,
  0xff, 0x4f, 0xff, 0xbe, 0xff, 0xff, 0xfe, 0xff, 0xff, 0x2f, 0xff, 0x7f,
  0x47, 0xff, 0xfe, 0xff, 0xff, 0xdf, 0xfe, 0xff, 0x80, 0xff, 0xff, 0x7f,
  0xff, 0xdf, 0xf9, 0xff, 0x9f, 0x7f, 0xff, 0x7f, 0xff, 0xdf, 0xc1, 0xff,
  0xbf, 0xbf, 0xff, 0x7f, 0xff, 0xdf, 0x0d, 0xff, 0xbf, 0xdf, 0xff, 0x7f,
  0xff, 0xdc, 0x9e, 0xff, 0xbf, 0xef, 0xfe, 0xff, 0xff, 0xd3, 0x3f, 0x7f,
  0xbf, 0xf7, 0xfe, 0xff, 0xff, 0xcf, 0x3e, 0x7f, 0x78, 0x77, 0xfe, 0xff,
  0xfe, 0x3f, 0x7c, 0x3f, 0x70, 0x37, 0xfc, 0x7f, 0xf9, 0x8f, 0x7c, 0x1f,
  0x70, 0x37, 0xf9, 0x9f, 0xfb, 0xc3, 0x7c, 0x2f, 0x76, 0x33, 0xf3, 0xdf,
  0xf7, 0xe0, 0x7c, 0x33, 0x76, 0x33, 0xe7, 0xef, 0xf7, 0xe0, 0x7e, 0x34,
  0x36, 0x33, 0x87, 0xef, 0xf7, 0xf0, 0x7f, 0x0f, 0x38, 0x7b, 0x8f, 0xef,
  0xef, 0xf0, 0x7f, 0xff, 0xff, 0xf9, 0x0f, 0xf7, 0xef, 0xf8, 0x3b, 0xff,
  0xff, 0xb8, 0x1f, 0xf7, 0xef, 0xf8, 0x3c, 0x73, 0xe7, 0x70, 0x1f, 0xf7,
  0xdf, 0xf8, 0x1f, 0x0d, 0xd8, 0xe0, 0x3f, 0xfb, 0xdf, 0xfc, 0x5f, 0xfe,
  0xbf, 0xec, 0x3f, 0xfb, 0xdf, 0xfd, 0x8f, 0xff, 0x7f, 0xd2, 0x3f, 0xfb,
  0xdf, 0xfe, 0x03, 0xff, 0xff, 0x81, 0x7f, 0xfb, 0xdf, 0xfe, 0x00, 0xff,
  0xfe, 0x00, 0x7f, 0xfb, 0xdf, 0xfe, 0x01, 0x3f, 0xf1, 0x80, 0x7f, 0xfb,
  0xdf, 0xfe, 0x01, 0xc7, 0x8f, 0x80, 0x7f, 0xfb, 0xdf, 0xff, 0x00, 0xf8,
  0x7f, 0x80, 0xff, 0xfb, 0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xff, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd, 0xbf, 0xff, 0x00, 0xff,
  0xff, 0x00, 0xff, 0xfd, 0xbf, 0xfe, 0x00, 0xff, 0xff, 0x00, 0xff, 0xfd,
  0xbf, 0xfe, 0x01, 0xff, 0xff, 0x00, 0x7f, 0xfd, 0xbf, 0xfc, 0x01, 0xff,
  0xff, 0x00, 0x3f, 0xfd, 0xdf, 0xf2, 0x01, 0xff, 0xff, 0x80, 0x4f, 0xfb,
  0xdf, 0xef, 0x01, 0xff, 0xff, 0x80, 0x77, 0xfb, 0xdf, 0xef, 0x01, 0xff,
  0xff, 0xc0, 0xf7, 0xfb, 0xef, 0xdf, 0x83, 0xff, 0xff, 0xc0, 0xfb, 0xf7,
  0xef, 0xbf, 0x87, 0xff, 0xff, 0xe0, 0xfd, 0xf7, 0xef, 0xbf, 0xcf, 0xff,
  0xff, 0xf3, 0xfd, 0xef, 0xf0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t PLANT2_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t PLANT2_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // PLANT2_H
