// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from fire2.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:53
 *
 * Usage in Kywy projects:
 *   #include "fire2.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, FIRE2_FRAME_WIDTH,
 *                            FIRE2_FRAME_HEIGHT, FIRE2_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {FIRE2_frame_0, FIRE2_frame_1, FIRE2_frame_2,
 * FIRE2_frame_3, FIRE2_frame_4, FIRE2_frame_5, FIRE2_frame_6, FIRE2_frame_7,
 * FIRE2_frame_8, FIRE2_frame_9, FIRE2_frame_10, FIRE2_frame_11};
 *   engine.display.drawBitmap(x, y, FIRE2_FRAME_WIDTH,
 *                            FIRE2_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef FIRE2_H
#define FIRE2_H

#include <stdint.h>

// Sprite sheet information
#define FIRE2_FRAME_WIDTH 64
#define FIRE2_FRAME_HEIGHT 64
#define FIRE2_FRAME_COUNT 12
#define FIRE2_SPRITE_COLS 3
#define FIRE2_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t FIRE2_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87, 0x1f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x06, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x0c, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x04, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x04, 0x3f, 0xff, 0xff, 0xff, 0xdf, 0xfd, 0xfc,
  0x00, 0x3f, 0xff, 0xff, 0xff, 0xcf, 0xfc, 0xfc, 0x00, 0x38, 0x7f, 0xff,
  0xff, 0xc7, 0xfb, 0x4c, 0x00, 0x3b, 0x8f, 0xff, 0xff, 0xc3, 0xfb, 0x46,
  0x00, 0x1d, 0xf3, 0xff, 0xff, 0xc1, 0xfb, 0xa0, 0x00, 0x0e, 0xfd, 0xff,
  0xff, 0xe0, 0xfd, 0xa0, 0x04, 0x03, 0x7e, 0xff, 0xff, 0xe0, 0xfd, 0xd0,
  0x03, 0x00, 0x3f, 0x7f, 0xff, 0xf0, 0x7d, 0xe0, 0x01, 0xf8, 0x1f, 0xbf,
  0xff, 0xf0, 0x7e, 0xf8, 0x00, 0xff, 0x0f, 0xdf, 0xff, 0xf8, 0x7e, 0xfc,
  0x00, 0x7f, 0x87, 0xdf, 0xfc, 0xf8, 0x77, 0x7f, 0x00, 0x3f, 0xc3, 0xdf,
  0xfc, 0x78, 0x33, 0xbf, 0xe0, 0x1f, 0xe3, 0xef, 0xfc, 0x78, 0x30, 0x3f,
  0xfe, 0x0f, 0xf3, 0xef, 0xfe, 0x32, 0x78, 0x1f, 0xff, 0x87, 0xf3, 0xef,
  0xfe, 0x02, 0xfc, 0x07, 0xff, 0xc3, 0xf1, 0xef, 0xff, 0x04, 0xee, 0x01,
  0xff, 0xe3, 0xf9, 0xef, 0xff, 0x0c, 0xce, 0x00, 0x7f, 0xf1, 0xf9, 0xef,
  0xff, 0x89, 0xcf, 0x00, 0x1f, 0xf8, 0xf9, 0xef, 0xff, 0x88, 0x87, 0x80,
  0x0f, 0xfc, 0x79, 0xef, 0xff, 0xc4, 0x07, 0x80, 0x07, 0xfe, 0x3b, 0xef,
  0xff, 0xc4, 0x04, 0x18, 0x03, 0xff, 0x87, 0xef, 0xff, 0xc6, 0x06, 0x0f,
  0x07, 0xff, 0xcf, 0xdf, 0xfb, 0xe7, 0x0f, 0x06, 0x0f, 0xff, 0xff, 0xbf,
  0xf8, 0xe3, 0x8f, 0x80, 0x18, 0x3f, 0xfc, 0xbf, 0xf8, 0x03, 0x9f, 0x80,
  0x38, 0xdf, 0xfa, 0xbf, 0xf8, 0x43, 0x8e, 0x60, 0x78, 0xcf, 0xf0, 0xbf,
  0xfc, 0x63, 0x81, 0xe0, 0xfc, 0x05, 0xd0, 0xbf, 0xfc, 0x77, 0x87, 0xe9,
  0xfe, 0x0e, 0xb9, 0xbf, 0xfe, 0x3c, 0x3e, 0x69, 0xff, 0xff, 0xff, 0xdf,
  0xff, 0x03, 0xc1, 0x6b, 0xff, 0xfc, 0x0f, 0xdf, 0xfe, 0xfc, 0x1f, 0x6d,
  0xff, 0x73, 0xe6, 0xdf, 0xfd, 0x83, 0xff, 0x6d, 0xff, 0x8b, 0xe9, 0xdf,
  0xfb, 0x7f, 0xff, 0x6e, 0xff, 0xdb, 0xed, 0xdf, 0xf6, 0xff, 0xff, 0xb7,
  0x7f, 0xeb, 0xeb, 0xbf, 0xf6, 0x3f, 0xff, 0xdb, 0xbf, 0xf7, 0xf7, 0xbf,
  0xf1, 0x0f, 0xff, 0xec, 0x9f, 0xff, 0xff, 0x7f, 0xff, 0x83, 0xff, 0x86,
  0x7f, 0xff, 0xfe, 0xff, 0xff, 0xc1, 0xfe, 0x71, 0xff, 0xff, 0xfd, 0xff,
  0xff, 0xc0, 0xf9, 0xc7, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xe0, 0xff, 0x3f,
  0xbf, 0xff, 0xcf, 0xff, 0xff, 0xf0, 0xf0, 0xff, 0x7f, 0xff, 0xbf, 0xff,
  0xff, 0xf8, 0x81, 0xff, 0x7e, 0xf7, 0x7f, 0xff, 0xff, 0xfe, 0x01, 0xfe,
  0xff, 0x7a, 0x7f, 0xff, 0xff, 0xff, 0xc3, 0xfe, 0xff, 0x79, 0x7f, 0xff,
  0xff, 0xff, 0xf7, 0xfd, 0xff, 0x7b, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xfb,
  0xfe, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xfb, 0xfa, 0xe7, 0xbf, 0xff,
  0xff, 0xff, 0xdf, 0xf1, 0xe1, 0x9f, 0x9f, 0xff, 0xff, 0xff, 0xbf, 0xe0,
  0x40, 0x5f, 0x1f, 0xff, 0xff, 0xff, 0x9f, 0xd0, 0x03, 0xc7, 0x1f, 0xff,
  0xff, 0xff, 0x8f, 0x38, 0x03, 0xe2, 0x0f, 0xff, 0xff, 0xff, 0x80, 0xf8,
  0x03, 0xe0, 0x0f, 0xff, 0xff, 0xff, 0x81, 0xf8, 0x03, 0xf0, 0x07, 0xff,
  0xff, 0xff, 0x83, 0xfc, 0x00, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc3, 0xfe,
  0x3b, 0x78, 0xed, 0xff, 0xff, 0xff, 0xc7, 0xff, 0x3d, 0xb8, 0xf6, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x80, 0x3c, 0x00, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t FIRE2_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x8f, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x80, 0xc7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
  0x43, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x43, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xc0, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xc0,
  0x03, 0x87, 0xff, 0xff, 0xff, 0xf3, 0xb4, 0xc0, 0x03, 0xb8, 0xff, 0xff,
  0xff, 0xe3, 0xb4, 0x60, 0x01, 0xdf, 0x3f, 0xff, 0xff, 0xc7, 0xba, 0x00,
  0x00, 0xef, 0xdf, 0xff, 0xff, 0x87, 0xda, 0x00, 0x40, 0x37, 0xef, 0xff,
  0xff, 0x8f, 0xdd, 0x00, 0x30, 0x03, 0xf7, 0xff, 0xff, 0x0f, 0xde, 0x00,
  0x1f, 0x81, 0xfb, 0xff, 0xff, 0x1f, 0xef, 0x80, 0x0f, 0xf0, 0xfd, 0xff,
  0xff, 0x1f, 0xef, 0xc0, 0x07, 0xf8, 0x7d, 0xff, 0xff, 0x0f, 0xf7, 0xf0,
  0x03, 0xfc, 0x3d, 0xff, 0xfe, 0x07, 0xbb, 0xfe, 0x01, 0xfe, 0x3e, 0xff,
  0xfe, 0x07, 0x83, 0xff, 0xe0, 0xff, 0x3e, 0xff, 0xfc, 0x07, 0x81, 0xff,
  0xf8, 0x7f, 0x3e, 0xff, 0xf9, 0x07, 0xc0, 0x7f, 0xfc, 0x3f, 0x1e, 0xff,
  0xf1, 0x0f, 0xe0, 0x1f, 0xfe, 0x3f, 0x9e, 0xff, 0xf3, 0x8f, 0xc0, 0x07,
  0xff, 0x1f, 0x9e, 0xff, 0xf1, 0x8c, 0xf0, 0x01, 0xff, 0x8f, 0x9e, 0xff,
  0xf1, 0x8c, 0xf8, 0x00, 0xff, 0xc7, 0x9e, 0xff, 0xf9, 0x98, 0x78, 0x00,
  0x7f, 0xe3, 0xbe, 0xff, 0xf8, 0xc8, 0x21, 0x80, 0x3f, 0xf8, 0x7e, 0xff,
  0xf8, 0x40, 0x02, 0xf0, 0x7f, 0xfc, 0xfd, 0xff, 0xec, 0x22, 0x01, 0x60,
  0xff, 0xff, 0xfb, 0xff, 0xf2, 0x32, 0x7d, 0x81, 0x83, 0xff, 0xcb, 0xff,
  0xf0, 0x3a, 0x7d, 0x83, 0x8d, 0xff, 0xab, 0xff, 0xf0, 0x1e, 0xfc, 0x87,
  0x8c, 0xff, 0x0b, 0xff, 0xe0, 0x1f, 0x33, 0x0f, 0xc0, 0x5d, 0x0b, 0xff,
  0xe2, 0x0f, 0x0f, 0x0f, 0xe0, 0xeb, 0x9b, 0xff, 0xe1, 0x8e, 0x19, 0x0f,
  0xff, 0xff, 0xfd, 0xff, 0xf1, 0xdc, 0xf5, 0x8f, 0xff, 0xc0, 0xfd, 0xff,
  0xf1, 0xf3, 0x8d, 0x8f, 0xf7, 0x3e, 0x6d, 0xff, 0xf8, 0x0c, 0x7e, 0xd7,
  0xf8, 0xbe, 0x9d, 0xff, 0xfc, 0xfb, 0xfe, 0xeb, 0xfd, 0xbe, 0xdd, 0xff,
  0xfb, 0x87, 0xff, 0x71, 0xfe, 0xbe, 0xbb, 0xff, 0xfb, 0x7f, 0xff, 0x99,
  0xff, 0x7f, 0x7b, 0xff, 0xf6, 0xff, 0xff, 0xce, 0xff, 0xff, 0xf7, 0xff,
  0xed, 0xff, 0xff, 0xb1, 0xff, 0xff, 0xef, 0xff, 0xec, 0x1f, 0xfe, 0x47,
  0xff, 0xff, 0xdf, 0xff, 0xe2, 0x03, 0xf9, 0x9f, 0xef, 0xff, 0x3f, 0xff,
  0xff, 0xc1, 0xfe, 0x3f, 0xf7, 0xfc, 0xff, 0xff, 0xff, 0xc1, 0xf8, 0x3b,
  0xf7, 0xfb, 0xff, 0xff, 0xff, 0xe1, 0xe0, 0x77, 0xfb, 0xbb, 0xff, 0xff,
  0xff, 0xf0, 0x80, 0xf7, 0xfb, 0xd3, 0xff, 0xff, 0xff, 0xf8, 0x01, 0xf7,
  0xfd, 0xcb, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xfb, 0xfe, 0xdd, 0xff, 0xff,
  0xff, 0xff, 0xef, 0xfa, 0xfe, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xef, 0xec,
  0x3c, 0x38, 0xff, 0xff, 0xff, 0xff, 0xef, 0xf0, 0x00, 0x10, 0x7f, 0xff,
  0xff, 0xff, 0xef, 0xf6, 0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xdf, 0xf6,
  0x00, 0xc0, 0x3f, 0xff, 0xff, 0xff, 0x9f, 0xee, 0x00, 0x60, 0x0f, 0xff,
  0xff, 0xff, 0x9f, 0xc0, 0x00, 0x63, 0xb7, 0xff, 0xff, 0xff, 0x8f, 0x00,
  0x1d, 0x83, 0xdb, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x9e, 0xd0, 0x03, 0xff,
  0xff, 0xff, 0xc0, 0x01, 0xc0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x43,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t FIRE2_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe3, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x86, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x02, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0x7f, 0xff, 0xff,
  0xff, 0xef, 0xfe, 0xfe, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xe7, 0xfe, 0x7e,
  0x00, 0x3c, 0x3f, 0xff, 0xff, 0xf3, 0xfd, 0xa6, 0x00, 0x1d, 0xc7, 0xff,
  0xff, 0xf0, 0xfd, 0xa3, 0x00, 0x0e, 0xf9, 0xff, 0xff, 0xf8, 0xfd, 0xd0,
  0x00, 0x07, 0x7e, 0xff, 0xff, 0xf8, 0x7e, 0xd0, 0x02, 0x01, 0xbf, 0x7f,
  0xff, 0xfc, 0x7e, 0xe8, 0x01, 0x80, 0x1f, 0xbf, 0xff, 0xfc, 0x3e, 0xf0,
  0x00, 0xfc, 0x0f, 0xdf, 0xfe, 0xfc, 0x1f, 0x7c, 0x00, 0x7f, 0x87, 0xef,
  0xfe, 0x7c, 0x1f, 0x7e, 0x00, 0x3f, 0xc3, 0xef, 0xfe, 0x78, 0x1b, 0xbf,
  0x80, 0x1f, 0xe1, 0xef, 0xfc, 0x50, 0x09, 0xdf, 0xf0, 0x0f, 0xf1, 0xf7,
  0xf8, 0x50, 0x00, 0x1f, 0xff, 0x07, 0xf9, 0xf7, 0xf8, 0xc0, 0x04, 0x0f,
  0xff, 0xc3, 0xf9, 0xf7, 0xf8, 0xc0, 0x06, 0x03, 0xff, 0xe1, 0xf8, 0xf7,
  0xf8, 0x01, 0x03, 0x00, 0xff, 0xf1, 0xfc, 0xf7, 0xfc, 0x03, 0x03, 0x00,
  0x3f, 0xf8, 0xfc, 0xf7, 0xfc, 0x03, 0x03, 0x80, 0x0f, 0xfc, 0x7c, 0xf7,
  0xfe, 0x03, 0x83, 0xc0, 0x07, 0xfe, 0x3c, 0xf7, 0xfe, 0x03, 0xc7, 0xc0,
  0x03, 0xff, 0x1d, 0xf7, 0xfe, 0x01, 0xe6, 0x0c, 0x01, 0xff, 0xc3, 0xf7,
  0xfe, 0x01, 0xef, 0x07, 0x83, 0xff, 0xe7, 0xef, 0xff, 0x21, 0xe7, 0x03,
  0x07, 0xff, 0xff, 0xdf, 0xfe, 0x31, 0xf0, 0xc0, 0x0c, 0x1f, 0xfe, 0x5f,
  0xfe, 0x3b, 0xe3, 0xf0, 0x1c, 0x6f, 0xfd, 0x5f, 0xff, 0x1e, 0x1f, 0x30,
  0x3c, 0x67, 0xf8, 0x5f, 0xff, 0x81, 0xe0, 0xb0, 0x7e, 0x02, 0xe8, 0x5f,
  0xff, 0x7e, 0x0f, 0xb4, 0xff, 0x07, 0x5c, 0xdf, 0xfe, 0xc1, 0xff, 0xb4,
  0xff, 0xff, 0xff, 0xef, 0xfd, 0xbf, 0xff, 0xb5, 0xff, 0xfe, 0x07, 0xef,
  0xfb, 0x7f, 0xff, 0xda, 0xff, 0xb9, 0xf3, 0x6f, 0xfb, 0x1f, 0xff, 0xec,
  0xff, 0xc5, 0xf4, 0xef, 0xf8, 0x87, 0xff, 0xf6, 0x7f, 0xed, 0xf6, 0xef,
  0xff, 0xc1, 0xff, 0xc3, 0x3f, 0xf5, 0xf5, 0xdf, 0xff, 0xe0, 0xff, 0x38,
  0xdf, 0xfb, 0xfb, 0xdf, 0xff, 0xe0, 0x7c, 0xe3, 0xcf, 0xff, 0xff, 0xbf,
  0xff, 0xf0, 0x05, 0x9f, 0xdf, 0xff, 0xff, 0x7f, 0xff, 0xf8, 0x38, 0x7f,
  0xbf, 0xff, 0xfe, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xbf, 0x7b, 0xf9, 0xff,
  0xff, 0xfc, 0x3f, 0xff, 0x7f, 0xbd, 0x07, 0xff, 0xff, 0xfc, 0x3f, 0xfe,
  0x7f, 0xb8, 0x9f, 0xff, 0xff, 0xfc, 0x3f, 0xfe, 0xfe, 0xb3, 0x9f, 0xff,
  0xff, 0xf8, 0x1f, 0xfe, 0x78, 0x6f, 0xcf, 0xff, 0xff, 0xf8, 0x0f, 0xfc,
  0xc0, 0x3e, 0x3f, 0xff, 0xff, 0xfc, 0x70, 0x02, 0x00, 0x0e, 0x3f, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x00, 0x10, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf8,
  0x00, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1,
  0xd8, 0x76, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xec, 0x7b, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t FIRE2_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x71, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x61, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x43, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc0, 0x43, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xdf, 0xc0,
  0x03, 0xff, 0xff, 0xff, 0xfc, 0xff, 0xcf, 0xc0, 0x03, 0x87, 0xff, 0xff,
  0xfc, 0x7f, 0xb4, 0xc0, 0x03, 0xb8, 0xff, 0xff, 0xfc, 0x3f, 0xb4, 0x60,
  0x01, 0xdf, 0x3f, 0xff, 0xfc, 0x1f, 0xba, 0x00, 0x00, 0xef, 0xdf, 0xff,
  0xfe, 0x0f, 0xda, 0x00, 0x40, 0x37, 0xef, 0xff, 0xfe, 0x0f, 0xdd, 0x00,
  0x30, 0x03, 0xf7, 0xff, 0xff, 0x07, 0xde, 0x00, 0x1f, 0x81, 0xfb, 0xff,
  0xff, 0x07, 0xef, 0x80, 0x0f, 0xf0, 0xfd, 0xff, 0xff, 0x87, 0xef, 0xc0,
  0x07, 0xf8, 0x7d, 0xff, 0xcf, 0x87, 0x77, 0xf0, 0x03, 0xfc, 0x3d, 0xff,
  0xc7, 0x83, 0x3b, 0xfe, 0x01, 0xfe, 0x3e, 0xff, 0xc7, 0x83, 0x03, 0xff,
  0xe0, 0xff, 0x3e, 0xff, 0xe3, 0x27, 0x81, 0xff, 0xf8, 0x7f, 0x3e, 0xff,
  0xe0, 0x2f, 0xc0, 0x7f, 0xfc, 0x3f, 0x1e, 0xff, 0xf0, 0x4e, 0xe0, 0x1f,
  0xfe, 0x3f, 0x9e, 0xff, 0xf0, 0xcc, 0xe0, 0x07, 0xff, 0x1f, 0x9e, 0xff,
  0xf8, 0x9c, 0xf0, 0x01, 0xff, 0x8f, 0x9e, 0xff, 0xf8, 0x88, 0x78, 0x00,
  0xff, 0xc7, 0x9e, 0xff, 0xfc, 0x40, 0x78, 0x00, 0x7f, 0xe3, 0xbe, 0xff,
  0xfc, 0x40, 0x41, 0x80, 0x3f, 0xf8, 0x7e, 0xff, 0xfc, 0x60, 0x60, 0xf0,
  0x7f, 0xfc, 0xfd, 0xff, 0xbe, 0x70, 0xf0, 0x60, 0xff, 0xff, 0xfb, 0xff,
  0x8e, 0x38, 0xf8, 0x01, 0x83, 0xff, 0xcb, 0xff, 0x80, 0x39, 0xf8, 0x03,
  0x8d, 0xff, 0xab, 0xff, 0x84, 0x38, 0xe6, 0x07, 0x8c, 0xff, 0x0b, 0xff,
  0xc6, 0x38, 0x1e, 0x0f, 0xc0, 0x5d, 0x0b, 0xff, 0xc7, 0x78, 0x7e, 0x9f,
  0xe0, 0xeb, 0x9d, 0xff, 0xe3, 0xc3, 0xe6, 0x9f, 0xff, 0xff, 0xfd, 0xc7,
  0xf0, 0x3c, 0x16, 0xbf, 0xff, 0xc0, 0xfd, 0x83, 0xef, 0xc1, 0xf6, 0xdf,
  0xf7, 0x3e, 0x6d, 0x81, 0xd8, 0x3f, 0xf6, 0xdf, 0xf8, 0x80, 0x9d, 0x01,
  0xb7, 0xff, 0xf6, 0xef, 0xfd, 0xbe, 0xdc, 0x00, 0x6f, 0xff, 0xfb, 0x77,
  0xfe, 0x86, 0x8c, 0x00, 0x63, 0xff, 0xfd, 0xbb, 0xfe, 0x7b, 0x04, 0x00,
  0x10, 0xff, 0xfe, 0xc9, 0xff, 0x7d, 0x00, 0x00, 0xf8, 0x3f, 0xf8, 0x67,
  0xff, 0x80, 0x80, 0x00, 0xfc, 0x1f, 0xe7, 0x1f, 0xff, 0xff, 0xc0, 0x00,
  0xfc, 0x0f, 0x9c, 0x7f, 0xff, 0xff, 0x00, 0x00, 0xfe, 0x0f, 0xf3, 0xfb,
  0xff, 0xfc, 0xe4, 0x00, 0xff, 0x0f, 0x0f, 0xf7, 0xff, 0xfb, 0xfe, 0x01,
  0xff, 0x88, 0x1f, 0xf7, 0xef, 0x77, 0xff, 0x87, 0xff, 0xe0, 0x1f, 0xef,
  0xf7, 0xa7, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xef, 0xf7, 0x97, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xdf, 0xf7, 0xbb, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf,
  0xef, 0x7b, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xae, 0x7b, 0xff, 0xff,
  0xff, 0xfd, 0xff, 0x0f, 0x05, 0xf9, 0xff, 0xff, 0xff, 0xfb, 0xff, 0x04,
  0x01, 0xf1, 0xff, 0xff, 0xff, 0xf9, 0xfc, 0x00, 0x3c, 0x71, 0xff, 0xff,
  0xff, 0xf8, 0xf2, 0x00, 0x7e, 0x20, 0xff, 0xff, 0xff, 0xf8, 0x0e, 0x00,
  0xfe, 0x00, 0xff, 0xff, 0xff, 0xf8, 0x1c, 0x00, 0xff, 0x00, 0x7f, 0xff,
  0xff, 0xf8, 0x38, 0x01, 0xff, 0x00, 0x3f, 0xff, 0xff, 0xfc, 0x36, 0xe3,
  0xff, 0x8e, 0xdf, 0xff, 0xff, 0xfc, 0x6d, 0xe7, 0xff, 0x8f, 0x6f, 0xff,
  0xff, 0xff, 0xe0, 0x0f, 0xff, 0xc0, 0x0f, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t FIRE2_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x71, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x61, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x43, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc0, 0x43, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xc0,
  0x03, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xcf, 0xc0, 0x03, 0x87, 0xff, 0xff,
  0xff, 0xf3, 0xb4, 0xc0, 0x03, 0xb8, 0xff, 0xff, 0xff, 0xe7, 0xb4, 0x60,
  0x01, 0xdf, 0x3f, 0xff, 0xff, 0xcf, 0xba, 0x00, 0x00, 0xef, 0xdf, 0xff,
  0xff, 0x8f, 0xda, 0x00, 0x40, 0x37, 0xef, 0xff, 0xff, 0x17, 0xdd, 0x00,
  0x30, 0x03, 0xf7, 0xff, 0xfe, 0x0f, 0xde, 0x00, 0x1f, 0x81, 0xfb, 0xff,
  0xfe, 0x07, 0xef, 0x80, 0x0f, 0xf0, 0xfd, 0xff, 0xfc, 0x07, 0xef, 0xc0,
  0x07, 0xf8, 0x7d, 0xff, 0xfc, 0x07, 0x77, 0xf0, 0x03, 0xfc, 0x3d, 0xff,
  0xe8, 0x07, 0x3b, 0xfe, 0x01, 0xfe, 0x3e, 0xff, 0xc8, 0x03, 0x03, 0xff,
  0xe0, 0xff, 0x3e, 0xff, 0xe8, 0x27, 0x81, 0xff, 0xf8, 0x7f, 0x3e, 0xff,
  0xe8, 0x25, 0xc0, 0x7f, 0xfc, 0x3f, 0x1e, 0xff, 0xc8, 0x44, 0xe0, 0x1f,
  0xfe, 0x3f, 0x9e, 0xff, 0xc8, 0xcc, 0xe0, 0x07, 0xff, 0x1f, 0x9e, 0xff,
  0xc4, 0x8c, 0xf0, 0x01, 0xff, 0x8f, 0x9e, 0xff, 0xc0, 0x88, 0x78, 0x00,
  0xff, 0xc7, 0x9e, 0xff, 0xc0, 0x48, 0x78, 0x00, 0x7f, 0xe3, 0xbe, 0xff,
  0xe0, 0x00, 0x41, 0x80, 0x3f, 0xf8, 0x7e, 0xff, 0xe0, 0x60, 0x60, 0xf0,
  0x7f, 0xfc, 0xfd, 0xff, 0xb0, 0x70, 0xf0, 0x60, 0xff, 0xff, 0xfb, 0xff,
  0x88, 0x38, 0xf8, 0x01, 0x83, 0xff, 0xcb, 0xff, 0x80, 0x38, 0xfc, 0x03,
  0x8d, 0xff, 0xab, 0xff, 0x80, 0x38, 0x7e, 0x07, 0x8c, 0xff, 0x0b, 0xff,
  0xc0, 0x3a, 0x38, 0x0f, 0xc0, 0x5d, 0x0b, 0xff, 0xc4, 0x7a, 0x26, 0x1f,
  0xe0, 0xeb, 0x9d, 0xcf, 0xe6, 0x78, 0x1e, 0x1f, 0xff, 0xff, 0xfd, 0x87,
  0xf3, 0x43, 0xfe, 0xbf, 0xff, 0xc0, 0xf8, 0x03, 0xf0, 0x3c, 0x0e, 0xdf,
  0xf7, 0x3e, 0x68, 0x01, 0xef, 0xc1, 0xf6, 0xdf, 0xf8, 0x80, 0x90, 0x01,
  0xd8, 0x3f, 0xf6, 0xef, 0xfd, 0xbe, 0xc0, 0x00, 0xb7, 0xff, 0xf6, 0xf7,
  0xfe, 0x86, 0x80, 0x00, 0x6f, 0xff, 0xfb, 0x7b, 0xfe, 0x7b, 0x00, 0x00,
  0x63, 0xff, 0xfd, 0xb9, 0xff, 0x7d, 0x00, 0x01, 0x10, 0xff, 0xfe, 0xc7,
  0xff, 0x80, 0x80, 0x01, 0xf8, 0x3f, 0xf8, 0x1f, 0xff, 0xff, 0xc0, 0x01,
  0xfc, 0x1f, 0xe0, 0x7f, 0xff, 0xff, 0x04, 0x07, 0xfc, 0x0f, 0x81, 0xfb,
  0xff, 0xfc, 0xfe, 0x0f, 0xff, 0x0f, 0x0f, 0xf7, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0x88, 0x1f, 0xf7, 0xef, 0x77, 0xff, 0xff, 0xff, 0xe0, 0x1f, 0xef,
  0xf7, 0xa7, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xef, 0xf7, 0x97, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xdf, 0xf7, 0xbb, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf,
  0xef, 0x7b, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xae, 0x7b, 0xff, 0xff,
  0xff, 0xfd, 0xff, 0x0f, 0x05, 0xf9, 0xff, 0xff, 0xff, 0xfb, 0xff, 0x04,
  0x01, 0xf1, 0xff, 0xff, 0xff, 0xf9, 0xfc, 0x00, 0x3c, 0x71, 0xff, 0xff,
  0xff, 0xf8, 0xf2, 0x00, 0x7e, 0x20, 0xff, 0xff, 0xff, 0xf8, 0x0e, 0x00,
  0xfe, 0x00, 0xff, 0xff, 0xff, 0xf8, 0x1c, 0x00, 0xff, 0x00, 0x7f, 0xff,
  0xff, 0xf8, 0x38, 0x01, 0xff, 0x00, 0x3f, 0xff, 0xff, 0xfc, 0x36, 0xe3,
  0xff, 0x8e, 0xdf, 0xff, 0xff, 0xfc, 0x6d, 0xe7, 0xff, 0x8f, 0x6f, 0xff,
  0xff, 0xff, 0xe0, 0x0f, 0xff, 0xc0, 0x0f, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t FIRE2_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x71, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x61, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
  0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x43, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc0, 0x43, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xc0,
  0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xcf, 0xc0, 0x03, 0x87, 0xff, 0xff,
  0xff, 0xff, 0xb4, 0xc0, 0x03, 0xb8, 0xff, 0xff, 0xff, 0xff, 0xb4, 0x60,
  0x01, 0xdf, 0x3f, 0xff, 0xff, 0xff, 0xba, 0x00, 0x00, 0xef, 0xdf, 0xff,
  0xff, 0xff, 0xda, 0x00, 0x40, 0x37, 0xef, 0xff, 0xfd, 0xff, 0xdd, 0x00,
  0x30, 0x03, 0xf7, 0xff, 0xfe, 0x7f, 0xde, 0x00, 0x1f, 0x81, 0xfb, 0xff,
  0xfe, 0x3f, 0xef, 0x80, 0x0f, 0xf0, 0xfd, 0xff, 0xfe, 0x1f, 0xef, 0xc0,
  0x07, 0xf8, 0x7d, 0xff, 0xfe, 0x0f, 0x77, 0xf0, 0x03, 0xfc, 0x3d, 0xff,
  0xee, 0x07, 0x3b, 0xfe, 0x01, 0xfe, 0x3e, 0xff, 0xce, 0x07, 0x03, 0xff,
  0xe0, 0xff, 0x3e, 0xff, 0xce, 0x27, 0x81, 0xff, 0xf8, 0x7f, 0x3e, 0xff,
  0x8c, 0x35, 0xc0, 0x7f, 0xfc, 0x3f, 0x1e, 0xff, 0x8c, 0x71, 0xe0, 0x1f,
  0xfe, 0x3f, 0x9e, 0xff, 0x88, 0xf1, 0xe0, 0x07, 0xff, 0x1f, 0x9e, 0xff,
  0x80, 0xf0, 0xf0, 0x01, 0xff, 0x8f, 0x9e, 0xff, 0xc4, 0xf0, 0x78, 0x00,
  0xff, 0xc7, 0x9e, 0xff, 0xc6, 0x70, 0x78, 0x00, 0x7f, 0xe3, 0xbe, 0xff,
  0xe3, 0x50, 0x41, 0x80, 0x3f, 0xf8, 0x7e, 0xff, 0xe0, 0xe0, 0x60, 0xf0,
  0x7f, 0xfc, 0xfd, 0xff, 0xb0, 0x70, 0xf0, 0x60, 0xff, 0xff, 0xfb, 0xff,
  0x88, 0x38, 0x78, 0x01, 0x83, 0xff, 0xcb, 0xff, 0x80, 0x38, 0x3c, 0x03,
  0x8d, 0xff, 0xab, 0xff, 0x80, 0x3e, 0x1e, 0x07, 0x8c, 0xff, 0x0b, 0xff,
  0xc0, 0x38, 0x1e, 0x0f, 0xc0, 0x5d, 0x0b, 0xff, 0xc4, 0x7a, 0x09, 0x1f,
  0xe0, 0xeb, 0x9d, 0xff, 0xe6, 0x7a, 0x06, 0x1f, 0xff, 0xff, 0xfd, 0xff,
  0xf3, 0x78, 0x1e, 0xbf, 0xff, 0xc0, 0xfd, 0xff, 0xe0, 0x03, 0xfe, 0xdf,
  0xf7, 0x3e, 0x6c, 0xbf, 0xdf, 0xfc, 0x0e, 0xdf, 0xf8, 0x80, 0x98, 0x1f,
  0xb0, 0x01, 0xf6, 0xef, 0xfd, 0xbe, 0xd0, 0x07, 0x6f, 0xff, 0xf6, 0xf7,
  0xfe, 0x86, 0x80, 0x03, 0x67, 0xff, 0xf3, 0x7b, 0xfe, 0x7b, 0x00, 0x03,
  0x13, 0xff, 0xfd, 0xb9, 0xff, 0x7d, 0x00, 0x01, 0xf8, 0xff, 0xfe, 0xc7,
  0xff, 0x80, 0x80, 0x01, 0xf8, 0x3f, 0xf8, 0x1f, 0xff, 0xff, 0xc0, 0x01,
  0xfc, 0x1f, 0xe0, 0x7f, 0xff, 0xff, 0x00, 0x01, 0xfc, 0x0f, 0x81, 0xfb,
  0xff, 0xfc, 0xe4, 0x01, 0xff, 0x0f, 0x0f, 0xf7, 0xff, 0xfb, 0xf8, 0x07,
  0xff, 0x88, 0x1f, 0xf7, 0xef, 0x77, 0xf8, 0x83, 0xff, 0xe0, 0x1f, 0xef,
  0xf7, 0xa7, 0xfd, 0xc3, 0xff, 0xfc, 0x3f, 0xef, 0xf7, 0x97, 0xff, 0xc3,
  0xff, 0xff, 0x7f, 0xdf, 0xf7, 0xbb, 0xff, 0xef, 0xff, 0xfe, 0xff, 0xbf,
  0xef, 0x7b, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xbf, 0xae, 0x7b, 0xff, 0xff,
  0xff, 0xfd, 0xff, 0x0f, 0x05, 0xf9, 0xff, 0xff, 0xff, 0xfb, 0xff, 0x04,
  0x01, 0xf1, 0xff, 0xff, 0xff, 0xf9, 0xfc, 0x00, 0x3c, 0x71, 0xff, 0xff,
  0xff, 0xf8, 0xf2, 0x00, 0x7e, 0x20, 0xff, 0xff, 0xff, 0xf8, 0x0e, 0x00,
  0xfe, 0x00, 0xff, 0xff, 0xff, 0xf8, 0x1c, 0x00, 0xff, 0x00, 0x7f, 0xff,
  0xff, 0xf8, 0x38, 0x01, 0xff, 0x00, 0x3f, 0xff, 0xff, 0xfc, 0x36, 0xe3,
  0xff, 0x8e, 0xdf, 0xff, 0xff, 0xfc, 0x6d, 0xe7, 0xff, 0x8f, 0x6f, 0xff,
  0xff, 0xff, 0xe0, 0x0f, 0xff, 0xc0, 0x0f, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t FIRE2_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87, 0x1f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x06, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x0c, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x04, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x04, 0x3f, 0xff, 0xff, 0xff, 0xdf, 0xfd, 0xfc,
  0x00, 0x3f, 0xff, 0xff, 0xff, 0xcf, 0xfc, 0xfc, 0x00, 0x38, 0x7f, 0xff,
  0xff, 0xc7, 0xfb, 0x4c, 0x00, 0x3b, 0x8f, 0xff, 0xff, 0xc3, 0xfb, 0x46,
  0x00, 0x1d, 0xf3, 0xff, 0xff, 0xc1, 0xfb, 0xa0, 0x00, 0x0e, 0xfd, 0xff,
  0xff, 0xe0, 0xfd, 0xa0, 0x04, 0x03, 0x7e, 0xff, 0xff, 0xe0, 0xfd, 0xd0,
  0x03, 0x00, 0x3f, 0x7f, 0xff, 0xf0, 0x7d, 0xe0, 0x01, 0xf8, 0x1f, 0xbf,
  0xff, 0xf0, 0x7e, 0xf8, 0x00, 0xff, 0x0f, 0xdf, 0xff, 0xf8, 0x7e, 0xfc,
  0x00, 0x7f, 0x87, 0xdf, 0xfc, 0xf8, 0x77, 0x7f, 0x00, 0x3f, 0xc3, 0xdf,
  0xfc, 0x78, 0x33, 0xbf, 0xe0, 0x1f, 0xe3, 0xef, 0xfc, 0x78, 0x30, 0x3f,
  0xfe, 0x0f, 0xf3, 0xef, 0xfe, 0x32, 0x78, 0x1f, 0xff, 0x87, 0xf3, 0xef,
  0xfe, 0x02, 0xfc, 0x07, 0xff, 0xc3, 0xf1, 0xef, 0xff, 0x04, 0xee, 0x01,
  0xff, 0xe3, 0xf9, 0xef, 0xff, 0x0c, 0xce, 0x00, 0x7f, 0xf1, 0xf9, 0xef,
  0xff, 0x89, 0xcf, 0x00, 0x1f, 0xf8, 0xf9, 0xef, 0xff, 0x88, 0x87, 0x80,
  0x0f, 0xfc, 0x79, 0xef, 0xff, 0xc4, 0x07, 0x80, 0x07, 0xfe, 0x3b, 0xef,
  0xff, 0xc4, 0x04, 0x18, 0x03, 0xff, 0x87, 0xef, 0xff, 0xc6, 0x06, 0x0f,
  0x07, 0xff, 0xcf, 0xdf, 0xfb, 0xe7, 0x0f, 0x06, 0x0f, 0xff, 0xff, 0xbf,
  0xf8, 0xe3, 0x8f, 0x80, 0x1c, 0x3f, 0xfc, 0xbf, 0xf8, 0x03, 0x9f, 0x80,
  0x3f, 0x9f, 0xf9, 0xbf, 0xf8, 0x43, 0x8e, 0x60, 0x7f, 0x0f, 0xf3, 0xbf,
  0xfc, 0x63, 0x81, 0xe0, 0xfc, 0x05, 0xd0, 0xbf, 0xfc, 0x77, 0x87, 0xe9,
  0xff, 0xfe, 0xbf, 0xbf, 0xfe, 0x3c, 0x3e, 0x69, 0xff, 0xff, 0xff, 0xdf,
  0xff, 0x03, 0xc1, 0x6b, 0xff, 0xfc, 0x0f, 0xdf, 0xfe, 0xfc, 0x1f, 0x6d,
  0xff, 0xf3, 0xe7, 0xdf, 0xfd, 0x83, 0xff, 0x6d, 0xff, 0xcb, 0xeb, 0xdf,
  0xfb, 0x7f, 0xff, 0x6e, 0xff, 0xd8, 0xcd, 0xdf, 0xf6, 0xff, 0xff, 0xb7,
  0x7f, 0xeb, 0x2b, 0xbf, 0xf6, 0x3f, 0xff, 0xdb, 0xbf, 0xf7, 0xf7, 0xbf,
  0xf1, 0x0f, 0xff, 0xec, 0x9f, 0xff, 0xff, 0x7f, 0xff, 0x83, 0xff, 0x86,
  0x7f, 0xff, 0xfe, 0xff, 0xff, 0xc1, 0xfe, 0x71, 0xff, 0xff, 0xfd, 0xff,
  0xff, 0xc0, 0xf9, 0xc7, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xe0, 0xff, 0x3f,
  0xb0, 0x3f, 0xcf, 0xff, 0xff, 0xf0, 0xf0, 0xff, 0x60, 0x0f, 0xbf, 0xff,
  0xff, 0xf8, 0x81, 0xff, 0x43, 0xb7, 0x7f, 0xff, 0xff, 0xfe, 0x01, 0xfe,
  0x83, 0xda, 0x7f, 0xff, 0xff, 0xff, 0xc3, 0xfe, 0x80, 0x01, 0x7f, 0xff,
  0xff, 0xff, 0xf7, 0xfd, 0x40, 0x3b, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xfb,
  0xe0, 0x77, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xfb, 0xe0, 0x67, 0xbf, 0xff,
  0xff, 0xff, 0xdf, 0xf3, 0xfe, 0x9f, 0x9f, 0xff, 0xff, 0xff, 0xbf, 0xed,
  0xfe, 0x5f, 0x1f, 0xff, 0xff, 0xff, 0x9f, 0xde, 0x79, 0xc7, 0x1f, 0xff,
  0xff, 0xff, 0x8f, 0x3f, 0x87, 0xe2, 0x0f, 0xff, 0xff, 0xff, 0x80, 0xff,
  0xff, 0xe0, 0x0f, 0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xf0, 0x07, 0xff,
  0xff, 0xff, 0x83, 0xff, 0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc3, 0xff,
  0xff, 0xf8, 0xed, 0xff, 0xff, 0xff, 0xc7, 0xff, 0xff, 0xf8, 0xf6, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x00, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t FIRE2_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x0e, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x0c, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x18, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x08, 0x7f, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xf8,
  0x08, 0x7f, 0xff, 0xff, 0xff, 0xcf, 0xfb, 0xf8, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xc7, 0xf9, 0xf8, 0x00, 0x70, 0xff, 0xff, 0xff, 0xc3, 0xf6, 0x98,
  0x00, 0x77, 0x1f, 0xff, 0xff, 0xc1, 0xf6, 0x8c, 0x00, 0x3b, 0xe7, 0xff,
  0xff, 0xe0, 0xf7, 0x40, 0x00, 0x1d, 0xfb, 0xff, 0xff, 0xe0, 0xfb, 0x40,
  0x08, 0x06, 0xfb, 0xff, 0xff, 0xf0, 0x7b, 0xa0, 0x06, 0x00, 0x7d, 0xff,
  0xff, 0xf0, 0x7b, 0xc0, 0x03, 0xf0, 0x3e, 0xff, 0xff, 0xf8, 0x7d, 0xf0,
  0x01, 0xfe, 0x1f, 0x7f, 0xfc, 0xf8, 0x7d, 0xf8, 0x00, 0xff, 0x0f, 0x7f,
  0xfc, 0x78, 0x3e, 0xfe, 0x00, 0x7f, 0x87, 0x7f, 0xfc, 0x78, 0x27, 0x7f,
  0xc0, 0x3f, 0xc7, 0xbf, 0xfe, 0x32, 0x60, 0x7f, 0xfc, 0x1f, 0xe7, 0xbf,
  0xfe, 0x02, 0xf0, 0x3f, 0xff, 0x0f, 0xe7, 0xbf, 0xff, 0x04, 0xe8, 0x0f,
  0xff, 0x87, 0xe3, 0xbf, 0xff, 0x0c, 0xcc, 0x03, 0xff, 0xc7, 0xf3, 0xbf,
  0xff, 0x89, 0xcc, 0x00, 0xff, 0xe3, 0xf3, 0xbf, 0xff, 0x88, 0x86, 0x00,
  0x3f, 0xf1, 0xf3, 0xbf, 0xff, 0xc4, 0x07, 0x00, 0x1f, 0xf8, 0xf3, 0xbf,
  0xff, 0xc4, 0x07, 0x00, 0x0f, 0xfc, 0x77, 0xbf, 0xff, 0xc6, 0x00, 0x30,
  0x07, 0xff, 0x0f, 0xbf, 0xfb, 0xe7, 0x0c, 0x1e, 0x0f, 0xff, 0x9f, 0x7f,
  0xf8, 0xe3, 0x8e, 0x0c, 0x1f, 0xff, 0xfe, 0xff, 0xf8, 0x03, 0x9f, 0x00,
  0x38, 0x7f, 0xfa, 0xff, 0xf8, 0x43, 0x8e, 0x40, 0x7f, 0x3f, 0xf2, 0xff,
  0xfc, 0x63, 0x81, 0xe0, 0xfe, 0x1f, 0xe6, 0xff, 0xfc, 0x77, 0x87, 0xe1,
  0xf8, 0x0f, 0xe2, 0xff, 0xfe, 0x3c, 0x3e, 0x63, 0xff, 0xfb, 0xbe, 0xff,
  0xff, 0x03, 0xc1, 0x63, 0xff, 0xfd, 0x7f, 0x7f, 0xfe, 0xfc, 0x1f, 0x67,
  0xff, 0xff, 0xff, 0x7f, 0xfd, 0x83, 0xff, 0x6b, 0xff, 0xf8, 0x1f, 0x7f,
  0xfb, 0x7f, 0xff, 0x6b, 0xff, 0xe7, 0xcf, 0x7f, 0xf6, 0xff, 0xff, 0xb5,
  0xff, 0x97, 0xd7, 0x7f, 0xf6, 0x3f, 0xff, 0xda, 0xff, 0xb1, 0x9a, 0xff,
  0xf1, 0x0f, 0xff, 0xec, 0x7f, 0xd6, 0x56, 0xff, 0xff, 0x83, 0xff, 0x86,
  0x3f, 0xef, 0xed, 0xff, 0xff, 0xc1, 0xfe, 0x71, 0xff, 0xff, 0xfb, 0xff,
  0xff, 0xc0, 0xf9, 0xc7, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xe0, 0xff, 0x3f,
  0x60, 0x7f, 0xcf, 0xff, 0xff, 0xf0, 0xf0, 0xfe, 0xc0, 0x1f, 0x3f, 0xff,
  0xff, 0xf8, 0x81, 0xfe, 0x87, 0x6e, 0xff, 0xff, 0xff, 0xfe, 0x01, 0xfd,
  0x07, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xfd, 0x00, 0x02, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xfa, 0x80, 0x77, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0xf7,
  0xc0, 0xef, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0xc0, 0xcf, 0x7f, 0xff,
  0xff, 0xff, 0xef, 0xf7, 0xfd, 0x3f, 0x3f, 0xff, 0xff, 0xff, 0xdf, 0xeb,
  0xfc, 0xbe, 0x3f, 0xff, 0xff, 0xff, 0xcf, 0xdc, 0xf3, 0x8e, 0x3f, 0xff,
  0xff, 0xff, 0xc7, 0xbf, 0x0f, 0xc4, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0x7f,
  0xff, 0xc0, 0x1f, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xe0, 0x0f, 0xff,
  0xff, 0xff, 0xc1, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 0xe1, 0xff,
  0xff, 0xf1, 0xdb, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xf1, 0xed, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x01, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t FIRE2_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x0e, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x0c, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x18, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x08, 0x7f, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xf8,
  0x08, 0x7f, 0xff, 0xff, 0xff, 0xcf, 0xfb, 0xf8, 0x00, 0x7f, 0xff, 0xff,
  0xff, 0xc7, 0xf9, 0xf8, 0x00, 0x70, 0xff, 0xff, 0xff, 0xc3, 0xf6, 0x98,
  0x00, 0x77, 0x1f, 0xff, 0xff, 0xc1, 0xf6, 0x8c, 0x00, 0x3b, 0xe7, 0xff,
  0xff, 0xe0, 0xf7, 0x40, 0x00, 0x1d, 0xfb, 0xff, 0xff, 0xe0, 0xfb, 0x40,
  0x08, 0x06, 0xfb, 0xff, 0xff, 0xf0, 0x7b, 0xa0, 0x06, 0x00, 0x7d, 0xff,
  0xff, 0xf0, 0x7b, 0xc0, 0x03, 0xf0, 0x3e, 0xff, 0xff, 0xf8, 0x7d, 0xf0,
  0x01, 0xfe, 0x1f, 0x7f, 0xfc, 0xf8, 0x7d, 0xf8, 0x00, 0xff, 0x0f, 0x7f,
  0xfc, 0x78, 0x3e, 0xfe, 0x00, 0x7f, 0x87, 0x7f, 0xfc, 0x78, 0x27, 0x7f,
  0xc0, 0x3f, 0xc7, 0xbf, 0xfe, 0x32, 0x60, 0x7f, 0xfc, 0x1f, 0xe7, 0xbf,
  0xfe, 0x02, 0xf0, 0x3f, 0xff, 0x0f, 0xe7, 0xbf, 0xff, 0x04, 0xe8, 0x0f,
  0xff, 0x87, 0xe3, 0xbf, 0xff, 0x0c, 0xcc, 0x03, 0xff, 0xc7, 0xf3, 0xbf,
  0xff, 0x89, 0xcc, 0x00, 0xff, 0xe3, 0xf3, 0xbf, 0xff, 0x88, 0x86, 0x00,
  0x3f, 0xf1, 0xf3, 0xbf, 0xff, 0xc4, 0x07, 0x00, 0x1f, 0xf8, 0xf3, 0xbf,
  0xff, 0xc4, 0x07, 0x00, 0x0f, 0xfc, 0x77, 0xbf, 0xff, 0xc6, 0x00, 0x30,
  0x07, 0xff, 0x0f, 0xbf, 0xfb, 0xe7, 0x0c, 0x1e, 0x0f, 0xff, 0x9f, 0x7f,
  0xf8, 0xe3, 0x8e, 0x0c, 0x1f, 0xff, 0xfe, 0xff, 0xf8, 0x03, 0x9f, 0x00,
  0x3f, 0xff, 0xfe, 0xff, 0xf8, 0x43, 0x8e, 0x40, 0x78, 0x7f, 0xfa, 0xff,
  0xfc, 0x63, 0x81, 0xe0, 0xff, 0x3f, 0xf2, 0xff, 0xfc, 0x77, 0x87, 0xe1,
  0xfe, 0x1f, 0xe6, 0xff, 0xfe, 0x3c, 0x3e, 0x63, 0xf8, 0x0b, 0xa2, 0xff,
  0xff, 0x03, 0xc1, 0x63, 0xff, 0xfd, 0x7f, 0x7f, 0xfe, 0xfc, 0x1f, 0x67,
  0xff, 0xff, 0xff, 0x7f, 0xfd, 0x83, 0xff, 0x6b, 0xff, 0xf8, 0x1f, 0x7f,
  0xfb, 0x7f, 0xff, 0x6b, 0xff, 0xe7, 0xcf, 0x7f, 0xf6, 0xff, 0xff, 0xb5,
  0xff, 0x97, 0xd7, 0x7f, 0xf6, 0x3f, 0xff, 0xda, 0xff, 0xb1, 0x9a, 0xff,
  0xf1, 0x0f, 0xff, 0xec, 0x7f, 0xd6, 0x56, 0xff, 0xff, 0x83, 0xff, 0x86,
  0x3f, 0xef, 0xed, 0xff, 0xff, 0xc1, 0xfe, 0x71, 0xff, 0xff, 0xfb, 0xff,
  0xff, 0xc0, 0xf9, 0xc7, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xe0, 0xff, 0x3f,
  0x60, 0x7f, 0xcf, 0xff, 0xff, 0xf0, 0xf0, 0xfe, 0xc0, 0x1f, 0x3f, 0xff,
  0xff, 0xf8, 0x81, 0xfe, 0x87, 0x6e, 0xff, 0xff, 0xff, 0xfe, 0x01, 0xfd,
  0x07, 0xb4, 0xff, 0xff, 0xff, 0xff, 0xc3, 0xfd, 0x00, 0x02, 0xff, 0xff,
  0xff, 0xff, 0xf7, 0xfa, 0x80, 0x77, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0xf7,
  0xc0, 0xef, 0x7f, 0xff, 0xff, 0xff, 0xf7, 0xf7, 0xc0, 0xcf, 0x7f, 0xff,
  0xff, 0xff, 0xf7, 0xf7, 0xfd, 0x3f, 0x3f, 0xff, 0xff, 0xff, 0xef, 0xeb,
  0xfc, 0xbe, 0x3f, 0xff, 0xff, 0xff, 0xe7, 0xdc, 0xf3, 0x8e, 0x3f, 0xff,
  0xff, 0xff, 0xe3, 0xdf, 0x0f, 0xc4, 0x1f, 0xff, 0xff, 0xff, 0xe0, 0x3f,
  0xff, 0xc0, 0x1f, 0xff, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xe0, 0x0f, 0xff,
  0xff, 0xff, 0xe0, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 0xf0, 0xff,
  0xff, 0xf1, 0xdb, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xf1, 0xed, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x01, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t FIRE2_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xc3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x87, 0x1f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x06, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x0c, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x04, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfc, 0x04, 0x3f, 0xff, 0xff, 0xff, 0xdf, 0xfd, 0xfc,
  0x00, 0x3f, 0xff, 0xff, 0xff, 0xcf, 0xfc, 0xfc, 0x00, 0x38, 0x7f, 0xff,
  0xff, 0xc7, 0xfb, 0x4c, 0x00, 0x3b, 0x8f, 0xff, 0xff, 0xc3, 0xfb, 0x46,
  0x00, 0x1d, 0xf3, 0xff, 0xff, 0xc1, 0xfb, 0xa0, 0x00, 0x0e, 0xfd, 0xff,
  0xff, 0xe0, 0xfd, 0xa0, 0x04, 0x03, 0x7e, 0xff, 0xff, 0xe0, 0xfd, 0xd0,
  0x03, 0x00, 0x3f, 0x7f, 0xff, 0xf0, 0x7d, 0xe0, 0x01, 0xf8, 0x1f, 0xbf,
  0xff, 0xf0, 0x7e, 0xf8, 0x00, 0xff, 0x0f, 0xdf, 0xff, 0xf8, 0x7e, 0xfc,
  0x00, 0x7f, 0x87, 0xdf, 0xfc, 0xf8, 0x77, 0x7f, 0x00, 0x3f, 0xc3, 0xdf,
  0xfc, 0x78, 0x33, 0xbf, 0xe0, 0x1f, 0xe3, 0xef, 0xfc, 0x78, 0x30, 0x3f,
  0xfe, 0x0f, 0xf3, 0xef, 0xfe, 0x32, 0x78, 0x1f, 0xff, 0x87, 0xf3, 0xef,
  0xfe, 0x02, 0xfc, 0x07, 0xff, 0xc3, 0xf1, 0xef, 0xff, 0x04, 0xee, 0x01,
  0xff, 0xe3, 0xf9, 0xef, 0xff, 0x0c, 0xce, 0x00, 0x7f, 0xf1, 0xf9, 0xef,
  0xff, 0x89, 0xcf, 0x00, 0x1f, 0xf8, 0xf9, 0xef, 0xff, 0x88, 0x87, 0x80,
  0x0f, 0xfc, 0x79, 0xef, 0xff, 0xc4, 0x07, 0x80, 0x07, 0xfe, 0x3b, 0xef,
  0xff, 0xc4, 0x04, 0x18, 0x03, 0xff, 0x87, 0xef, 0xff, 0xc6, 0x06, 0x0f,
  0x06, 0x1f, 0xcc, 0x5f, 0xfb, 0xe7, 0x0f, 0x06, 0x0c, 0x0f, 0xf8, 0x3f,
  0xf8, 0xe3, 0x8f, 0x80, 0x18, 0xc7, 0xf3, 0x3f, 0xf8, 0x03, 0x9f, 0x80,
  0x39, 0x27, 0xf4, 0xbf, 0xf8, 0x43, 0x8e, 0x60, 0x78, 0x07, 0xf0, 0x3f,
  0xfc, 0x63, 0x81, 0xe0, 0xfc, 0x05, 0xd0, 0x3f, 0xfc, 0x77, 0x87, 0xe9,
  0xfe, 0x0e, 0xb8, 0xbf, 0xfe, 0x3c, 0x3e, 0x69, 0xff, 0xff, 0xff, 0xdf,
  0xff, 0x03, 0xc1, 0x6b, 0xff, 0xfc, 0x0f, 0xdf, 0xfe, 0xfc, 0x1f, 0x6d,
  0xff, 0x70, 0x06, 0xdf, 0xfd, 0x83, 0xff, 0x6d, 0xff, 0x88, 0x09, 0xdf,
  0xfb, 0x7f, 0xff, 0x6e, 0xff, 0xdb, 0x0d, 0xdf, 0xf6, 0xff, 0xff, 0xb7,
  0x7f, 0xeb, 0x8b, 0xbf, 0xf6, 0x3f, 0xff, 0xdb, 0xbf, 0xf1, 0xd7, 0xbf,
  0xf1, 0x0f, 0xff, 0xec, 0x9f, 0xfe, 0x3f, 0x7f, 0xff, 0x83, 0xff, 0x86,
  0x7f, 0xff, 0xfe, 0xff, 0xff, 0xc1, 0xfe, 0x71, 0xff, 0xff, 0xfd, 0xff,
  0xff, 0xc0, 0xf9, 0xc7, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xe0, 0xff, 0x3f,
  0xbf, 0xff, 0xcf, 0xff, 0xff, 0xf0, 0xf0, 0xff, 0x7f, 0xff, 0xbf, 0xff,
  0xff, 0xf8, 0x81, 0xff, 0x7e, 0xf7, 0x7f, 0xff, 0xff, 0xfe, 0x01, 0xfe,
  0xff, 0x7a, 0x7f, 0xff, 0xff, 0xff, 0xc3, 0xfe, 0xff, 0x79, 0x7f, 0xff,
  0xff, 0xff, 0xf7, 0xfd, 0xff, 0x7b, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xfb,
  0xfe, 0xf7, 0xbf, 0xff, 0xff, 0xff, 0xef, 0xfb, 0xfa, 0xe7, 0xbf, 0xff,
  0xff, 0xff, 0xdf, 0xf1, 0xe1, 0x9f, 0x9f, 0xff, 0xff, 0xff, 0xbf, 0xe0,
  0x40, 0x5f, 0x1f, 0xff, 0xff, 0xff, 0x9f, 0xd0, 0x03, 0xc7, 0x1f, 0xff,
  0xff, 0xff, 0x8f, 0x38, 0x03, 0xe2, 0x0f, 0xff, 0xff, 0xff, 0x80, 0xf8,
  0x03, 0xe0, 0x0f, 0xff, 0xff, 0xff, 0x81, 0xf8, 0x03, 0xf0, 0x07, 0xff,
  0xff, 0xff, 0x83, 0xfc, 0x00, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc3, 0xfe,
  0x3b, 0x78, 0xed, 0xff, 0xff, 0xff, 0xc7, 0xff, 0x3d, 0xb8, 0xf6, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x80, 0x3c, 0x00, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t FIRE2_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t FIRE2_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // FIRE2_H
