// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from fire.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:53
 *
 * Usage in Kywy projects:
 *   #include "fire.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, FIRE_FRAME_WIDTH,
 *                            FIRE_FRAME_HEIGHT, FIRE_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {FIRE_frame_0, FIRE_frame_1, FIRE_frame_2,
 * FIRE_frame_3, FIRE_frame_4, FIRE_frame_5, FIRE_frame_6, FIRE_frame_7,
 * FIRE_frame_8, FIRE_frame_9, FIRE_frame_10, FIRE_frame_11};
 *   engine.display.drawBitmap(x, y, FIRE_FRAME_WIDTH,
 *                            FIRE_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef FIRE_H
#define FIRE_H

#include <stdint.h>

// Sprite sheet information
#define FIRE_FRAME_WIDTH 64
#define FIRE_FRAME_HEIGHT 64
#define FIRE_FRAME_COUNT 12
#define FIRE_SPRITE_COLS 3
#define FIRE_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t FIRE_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x40, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x3f, 0x3f,
  0xff, 0xff, 0xff, 0xfb, 0x00, 0x0c, 0x3e, 0xbf, 0xff, 0xf7, 0xff, 0xfb,
  0x00, 0x1c, 0x3e, 0xbf, 0xff, 0xf3, 0xff, 0xf7, 0x00, 0x3c, 0x3e, 0xbf,
  0xff, 0xf1, 0xff, 0xf7, 0x1c, 0x38, 0x3d, 0xbf, 0xff, 0xf8, 0xff, 0xef,
  0x1e, 0x38, 0x7d, 0xbf, 0xff, 0xf8, 0x7f, 0xee, 0x9f, 0x18, 0xfb, 0xbf,
  0xff, 0xbc, 0x3f, 0xde, 0x9f, 0xf9, 0xfb, 0xbf, 0xff, 0x9c, 0x1f, 0xde,
  0xdf, 0xfd, 0xe7, 0xbf, 0xff, 0x8c, 0x1f, 0xdf, 0x5f, 0xfd, 0x1f, 0xbf,
  0xff, 0x84, 0x1f, 0xdf, 0x9f, 0xfe, 0xff, 0x7f, 0xff, 0x80, 0x0f, 0xdf,
  0xe1, 0xfe, 0xff, 0x7f, 0xff, 0x80, 0x0f, 0xef, 0xfe, 0x1e, 0x7c, 0xff,
  0xff, 0x80, 0x0f, 0xf7, 0xff, 0xee, 0xbb, 0xff, 0xff, 0x80, 0x0f, 0xf9,
  0xff, 0xf6, 0xd7, 0xff, 0xff, 0x80, 0x09, 0xfe, 0x3f, 0xf9, 0xef, 0xff,
  0xff, 0x81, 0x11, 0xfe, 0xfe, 0x3f, 0xb7, 0xff, 0xff, 0xc3, 0x03, 0xfd,
  0xfc, 0x1f, 0x57, 0xff, 0xff, 0xc3, 0x83, 0xfd, 0xf9, 0x8f, 0x57, 0xff,
  0xff, 0xe3, 0x87, 0xfd, 0xf9, 0x8f, 0x17, 0xff, 0xff, 0xe3, 0xc7, 0xfd,
  0xf8, 0x0a, 0x97, 0xff, 0xff, 0xe1, 0xcf, 0xfd, 0xfc, 0x1f, 0xb7, 0xff,
  0xff, 0xf0, 0xcf, 0xfd, 0xfe, 0x3f, 0xf7, 0xff, 0xff, 0xf8, 0x5f, 0xfe,
  0xff, 0xe8, 0x6f, 0xff, 0xff, 0xfe, 0x53, 0xfe, 0xff, 0xe7, 0xdf, 0xff,
  0xff, 0xff, 0x95, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xf5, 0xff,
  0x9f, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xed, 0xff, 0xe7, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xee, 0xfe, 0x1f, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd,
  0xbf, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd, 0x7e, 0xfd, 0x7f, 0xff,
  0xff, 0xff, 0x2e, 0x7c, 0xff, 0x7d, 0xbf, 0xff, 0xff, 0xfe, 0xce, 0xb1,
  0xff, 0xbd, 0xdf, 0xff, 0xff, 0xff, 0x7e, 0xcd, 0xf7, 0xdd, 0xef, 0xff,
  0xff, 0xff, 0xbf, 0xeb, 0xf9, 0xdc, 0xef, 0xff, 0xff, 0xff, 0xdf, 0xeb,
  0xfe, 0xdd, 0x1f, 0xff, 0xff, 0xff, 0xdf, 0xe7, 0xff, 0x3d, 0xff, 0xff,
  0xff, 0xff, 0xe0, 0x67, 0xef, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xf7, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xf7, 0xff, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xe3, 0xf7, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
  0xf0, 0x0f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t FIRE_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x87, 0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x83, 0xf3, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x80, 0xe1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0x80, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x60, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xc0, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x40, 0x00, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xfd, 0x0c, 0x00, 0x3f, 0x3f, 0xff, 0xff, 0xff, 0xfb,
  0x1c, 0x00, 0x3e, 0xbf, 0xff, 0xff, 0xff, 0xfb, 0x18, 0x00, 0x3e, 0xbf,
  0xff, 0xff, 0x9f, 0xf7, 0x38, 0x00, 0x3e, 0xbf, 0xff, 0xff, 0x1f, 0xf7,
  0x3c, 0x00, 0x3d, 0xbf, 0xff, 0xfe, 0x1f, 0xef, 0x3e, 0x00, 0x7d, 0xbf,
  0xff, 0xfe, 0x1f, 0xee, 0xbf, 0x00, 0xfb, 0xbf, 0xff, 0xfc, 0x3f, 0xde,
  0x9f, 0xf1, 0xfb, 0xbf, 0xff, 0xb8, 0x3f, 0xde, 0xdf, 0xf9, 0xe7, 0xbf,
  0xff, 0xb0, 0x1f, 0xdf, 0x5f, 0xfd, 0x1f, 0xbf, 0xff, 0xb0, 0x1f, 0xdf,
  0x9f, 0xfe, 0xff, 0x7f, 0xff, 0xb0, 0x1f, 0xdf, 0xe1, 0xfe, 0xff, 0x7f,
  0xff, 0x10, 0x0f, 0xef, 0xfe, 0x1e, 0x7c, 0xff, 0xff, 0x00, 0x0f, 0xf7,
  0xff, 0xee, 0xbb, 0xff, 0xfe, 0x00, 0x0f, 0xf9, 0xff, 0xf6, 0xd7, 0xff,
  0xff, 0x00, 0x8f, 0xfe, 0x3f, 0xf9, 0xef, 0xff, 0xff, 0x00, 0xc9, 0xfe,
  0xfe, 0x3f, 0xb7, 0xff, 0xff, 0x81, 0xd1, 0xfd, 0xfc, 0x1f, 0x57, 0xff,
  0xff, 0x81, 0xc3, 0xfd, 0xf9, 0x8f, 0x57, 0xff, 0xff, 0x81, 0xd3, 0xfd,
  0xf9, 0x8f, 0x17, 0xff, 0xff, 0x81, 0xe7, 0xfd, 0xf8, 0x0a, 0x97, 0xff,
  0xff, 0xc1, 0xe7, 0xfd, 0xfc, 0x1f, 0xb7, 0xff, 0xff, 0xc1, 0xef, 0xfd,
  0xfe, 0x3f, 0xf7, 0xff, 0xff, 0xe0, 0xcf, 0xfe, 0xff, 0xe8, 0x6f, 0xff,
  0xff, 0xf8, 0x5f, 0xfe, 0xff, 0xe7, 0xdf, 0xff, 0xff, 0xfe, 0x53, 0xff,
  0x7f, 0xff, 0xbf, 0xff, 0xff, 0xff, 0x95, 0xff, 0x9f, 0xfe, 0x7f, 0xff,
  0xff, 0xff, 0xf5, 0xff, 0xe7, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xed, 0xfe,
  0x1f, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd, 0xbf, 0xfc, 0x1f, 0xff,
  0xff, 0xff, 0xee, 0xfd, 0x7f, 0xfd, 0xef, 0xff, 0xff, 0xff, 0xee, 0xfc,
  0xff, 0xbd, 0xf7, 0xff, 0xff, 0xff, 0x2e, 0x71, 0xf7, 0xbd, 0xf7, 0xff,
  0xff, 0xfe, 0xce, 0x8d, 0xf7, 0xbd, 0x8f, 0xff, 0xff, 0xff, 0x7e, 0xeb,
  0xf7, 0xbc, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xeb, 0xf7, 0xbd, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xe7, 0xfb, 0xbe, 0x7f, 0xff, 0xff, 0xff, 0xdf, 0xe7,
  0xfc, 0x7f, 0xbf, 0xff, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xff, 0xff, 0x9f, 0xfb, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xe3,
  0xfb, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xf8, 0x0f, 0xdf, 0xff,
  0xff, 0xff, 0xff, 0xfd, 0xf7, 0xf0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfd,
  0xf7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t FIRE_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfb, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf3, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xc0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc1, 0xc0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x40, 0x80, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x80, 0x7f, 0x3f,
  0xff, 0xff, 0xff, 0xfb, 0x00, 0x80, 0x3e, 0xbf, 0xff, 0xff, 0xff, 0xfb,
  0x00, 0x84, 0x3e, 0xbf, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x0c, 0x3e, 0xbf,
  0xff, 0xff, 0xff, 0xf7, 0x1c, 0x18, 0x3d, 0xbf, 0xff, 0xf7, 0xff, 0xef,
  0x1e, 0x38, 0x7d, 0xbf, 0xff, 0xf3, 0xff, 0xee, 0x9f, 0x38, 0xfb, 0xbf,
  0xff, 0xf1, 0xff, 0xde, 0x9f, 0xf9, 0xfb, 0xbf, 0xff, 0xf8, 0xff, 0xde,
  0xdf, 0xfd, 0xe7, 0xbf, 0xff, 0xf8, 0x7f, 0xdf, 0x5f, 0xfd, 0x1f, 0xbf,
  0xff, 0xfc, 0x3f, 0xdf, 0x9f, 0xfe, 0xff, 0x7f, 0xff, 0xfc, 0x1f, 0xdf,
  0xe1, 0xfe, 0xff, 0x7f, 0xff, 0xdc, 0x1f, 0xef, 0xfe, 0x1e, 0x7c, 0xff,
  0xff, 0xc4, 0x1f, 0xf7, 0xff, 0xee, 0xbb, 0xff, 0xff, 0xc0, 0x0f, 0xf9,
  0xff, 0xf6, 0xd7, 0xff, 0xff, 0xc0, 0x0f, 0xfe, 0x3f, 0xf9, 0xef, 0xff,
  0xfe, 0xe0, 0x0f, 0xfe, 0xfe, 0x3f, 0xb7, 0xff, 0xff, 0x20, 0x0f, 0xfd,
  0xfc, 0x1f, 0x57, 0xff, 0xff, 0x10, 0x1f, 0xfd, 0xf9, 0x8f, 0x57, 0xff,
  0xff, 0x81, 0x1f, 0xfd, 0xf9, 0x8f, 0x17, 0xff, 0xff, 0x83, 0x0f, 0xfd,
  0xf8, 0x0a, 0x97, 0xff, 0xff, 0x83, 0x87, 0xfd, 0xfc, 0x1f, 0xb7, 0xff,
  0xff, 0x83, 0x8f, 0xfd, 0xfe, 0x3f, 0xf7, 0xff, 0xff, 0xc3, 0xcf, 0xfe,
  0xff, 0xe8, 0x6f, 0xff, 0xff, 0xc1, 0xcf, 0xfe, 0xff, 0xe7, 0xdf, 0xff,
  0xff, 0xe0, 0xcf, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xff, 0xf8, 0x5f, 0xff,
  0x9f, 0xfe, 0x7f, 0xff, 0xff, 0xfe, 0x53, 0xff, 0xe7, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0x95, 0xfe, 0x1f, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xf5, 0xfd,
  0xbf, 0xfc, 0x7f, 0xff, 0xff, 0xff, 0xed, 0xfd, 0x7e, 0x7d, 0xbf, 0xff,
  0xff, 0xff, 0xee, 0xfc, 0xff, 0xbd, 0xdf, 0xff, 0xff, 0xff, 0xee, 0xf1,
  0xff, 0xdd, 0xef, 0xff, 0xff, 0xff, 0xee, 0x8d, 0xf7, 0xdd, 0xef, 0xff,
  0xff, 0xff, 0x2e, 0x6b, 0xf9, 0xdc, 0x1f, 0xff, 0xff, 0xfe, 0xce, 0xeb,
  0xfe, 0x3d, 0xff, 0xff, 0xff, 0xff, 0x7e, 0xe7, 0xfb, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xe7, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xff,
  0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xdf, 0x8f, 0xfe, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xe0, 0x03, 0xfe, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0xfc, 0x3b, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x02, 0xf7, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t FIRE_frame_3[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xcf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc7, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x61, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfe, 0x60, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x40, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf0, 0x40, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x80, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0x7e, 0x7f,
  0xff, 0xff, 0xff, 0xf6, 0x00, 0x18, 0x7d, 0x7f, 0xff, 0xef, 0xff, 0xf6,
  0x00, 0x38, 0x7d, 0x7f, 0xff, 0xe7, 0xff, 0xee, 0x00, 0x78, 0x7d, 0x7f,
  0xff, 0xe3, 0xff, 0xee, 0x38, 0x70, 0x7b, 0x7f, 0xff, 0xf1, 0xff, 0xde,
  0x3c, 0x70, 0xfb, 0x7f, 0xff, 0xf0, 0xff, 0xdd, 0x3e, 0x31, 0xf7, 0x7f,
  0xff, 0x78, 0x7f, 0xbd, 0x3f, 0xf3, 0xf7, 0x7f, 0xff, 0x38, 0x3f, 0xbd,
  0xbf, 0xfb, 0xcf, 0x7f, 0xff, 0x18, 0x3f, 0xbe, 0xbf, 0xfa, 0x3f, 0x7f,
  0xff, 0x08, 0x3f, 0xbf, 0x3f, 0xfd, 0xfe, 0xff, 0xff, 0x00, 0x1f, 0xbf,
  0xc3, 0xfd, 0xfe, 0xff, 0xff, 0x80, 0x1f, 0xdf, 0xfc, 0x3c, 0xf9, 0xff,
  0xfd, 0x80, 0x1f, 0xef, 0xff, 0xdd, 0x77, 0xff, 0xfe, 0x40, 0x1f, 0xf3,
  0xff, 0xed, 0xaf, 0xef, 0xfe, 0x20, 0x13, 0xfc, 0x7f, 0xf3, 0xdf, 0xe7,
  0xff, 0x02, 0x23, 0xfd, 0xfc, 0x7f, 0x6f, 0xe7, 0xff, 0x06, 0x07, 0xfb,
  0xf8, 0x3e, 0x2f, 0xe7, 0xff, 0x07, 0x07, 0xfb, 0xfb, 0x9e, 0x2f, 0xe7,
  0xff, 0x07, 0x0f, 0xfb, 0xff, 0xde, 0xaf, 0xe3, 0xff, 0x87, 0x8f, 0xfb,
  0xff, 0xf5, 0xee, 0xe3, 0xff, 0x83, 0x9f, 0xfb, 0xff, 0xff, 0xec, 0xc1,
  0xff, 0xc1, 0x9f, 0xfb, 0xff, 0xd0, 0xec, 0x80, 0xff, 0xf0, 0xbf, 0xfd,
  0xff, 0xc0, 0xd8, 0x80, 0xff, 0xfc, 0xa7, 0xfd, 0xff, 0xd9, 0xb0, 0x00,
  0xff, 0xff, 0x2b, 0xfe, 0xff, 0xeb, 0x40, 0x00, 0xff, 0xff, 0xeb, 0xff,
  0x3f, 0xfc, 0x20, 0x01, 0xff, 0xff, 0xdb, 0xfe, 0xdf, 0xf9, 0xd0, 0x01,
  0xff, 0xff, 0xdd, 0xfc, 0xe7, 0xfb, 0xd0, 0x03, 0xff, 0xff, 0xdd, 0xfa,
  0xfb, 0xfb, 0xb8, 0x23, 0xff, 0xff, 0xdd, 0xfa, 0x7f, 0xfb, 0x7c, 0x73,
  0xff, 0xfe, 0x5c, 0xf9, 0x3f, 0xfa, 0xfe, 0xff, 0xff, 0xfd, 0x9d, 0x62,
  0xdf, 0xf9, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0x9b, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xd7, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xd7,
  0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xcf, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0xcf, 0xdf, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xef, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef, 0xfe, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc7, 0xef, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
  0xe0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xdf, 0xe0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t FIRE_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x07, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfc, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xec, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc4, 0x01, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x84, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x84, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x04, 0x00, 0xfe, 0x7f,
  0xff, 0xff, 0xff, 0xf6, 0x00, 0x18, 0xfd, 0x7f, 0xff, 0xff, 0xff, 0xf6,
  0x00, 0x38, 0xfd, 0x7f, 0xff, 0xff, 0xff, 0xee, 0x00, 0x38, 0xfd, 0x7f,
  0xff, 0xff, 0xbf, 0xee, 0x18, 0x10, 0xfb, 0x7f, 0xff, 0xff, 0x1f, 0xde,
  0x0c, 0x01, 0xfb, 0x7f, 0xff, 0xff, 0x1f, 0xdd, 0x0e, 0x01, 0xf7, 0x7f,
  0xff, 0xfe, 0x1f, 0xbd, 0x0f, 0xe3, 0xf7, 0x7f, 0xff, 0xfc, 0x1f, 0xbd,
  0x87, 0xf3, 0xcf, 0x7f, 0xff, 0xf8, 0x1f, 0xbe, 0x87, 0xfa, 0x3f, 0x7f,
  0xff, 0xe8, 0x1f, 0xbf, 0x03, 0xfd, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xbf,
  0xc0, 0xfd, 0xfe, 0xff, 0xff, 0xc0, 0x3f, 0xdf, 0xfc, 0x3c, 0xf9, 0xff,
  0xff, 0x80, 0x3f, 0xef, 0xff, 0xdd, 0x77, 0xff, 0xff, 0x81, 0x3f, 0xf3,
  0xff, 0xed, 0xaf, 0xff, 0xff, 0x03, 0x1f, 0xfc, 0x7f, 0xf3, 0xdf, 0xff,
  0xff, 0x03, 0x1f, 0xfd, 0xfc, 0x7f, 0x6f, 0xff, 0xff, 0x07, 0x9f, 0xfb,
  0xf8, 0x3e, 0x2f, 0xff, 0xff, 0x07, 0x8f, 0xfb, 0xfb, 0x9e, 0x2f, 0xff,
  0xff, 0x07, 0xcf, 0xfb, 0xff, 0xde, 0xaf, 0xff, 0xff, 0x87, 0xcf, 0xfb,
  0xff, 0xf5, 0xef, 0xbf, 0xff, 0x83, 0xcf, 0xfb, 0xff, 0xff, 0xef, 0x9f,
  0xff, 0xc1, 0x9f, 0xfb, 0xff, 0xd0, 0xef, 0x1f, 0xff, 0xf0, 0x9f, 0xfd,
  0xff, 0xc0, 0xdb, 0x1f, 0xff, 0xfc, 0xa7, 0xfd, 0xff, 0xd9, 0xb0, 0x0b,
  0xff, 0xff, 0x2b, 0xfe, 0xff, 0xeb, 0x40, 0x01, 0xff, 0xff, 0xeb, 0xff,
  0x3f, 0xfc, 0x30, 0x01, 0xff, 0xff, 0xdb, 0xfe, 0xdf, 0xf9, 0xd8, 0x03,
  0xff, 0xff, 0xdd, 0xfc, 0xe7, 0xfb, 0xde, 0x07, 0xff, 0xff, 0xdd, 0xfa,
  0xfb, 0xfb, 0xbf, 0x1f, 0xff, 0xff, 0xdd, 0xfa, 0x7f, 0xfb, 0x7f, 0x9f,
  0xff, 0xfe, 0x5c, 0xf9, 0x3f, 0xfa, 0xff, 0xbf, 0xff, 0xfd, 0x9d, 0x62,
  0xdf, 0xf9, 0xff, 0xff, 0xff, 0xfe, 0xfd, 0x9b, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0x7f, 0xd7, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xd7,
  0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xcf, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0xcf, 0xdf, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xef, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef, 0xfe, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc7, 0xef, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
  0xe0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xdf, 0xe0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t FIRE_frame_5[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfd, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x3f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xe0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x80, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
  0x80, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x00, 0x00, 0xfe, 0x7f,
  0xff, 0xff, 0xff, 0xf6, 0x00, 0x00, 0xfd, 0x7f, 0xff, 0xff, 0xff, 0xf6,
  0x00, 0x00, 0x7d, 0x7f, 0xff, 0xff, 0xef, 0xee, 0x00, 0x20, 0x7d, 0x7f,
  0xff, 0xff, 0x8f, 0xee, 0x00, 0x20, 0x7b, 0x7f, 0xff, 0xf8, 0x0f, 0xde,
  0x0c, 0x70, 0xfb, 0x7f, 0xff, 0xf0, 0x0f, 0xdd, 0x0e, 0x31, 0xf7, 0x7f,
  0xff, 0xf0, 0x0f, 0xbd, 0x0f, 0x33, 0xf7, 0x7f, 0xff, 0xe0, 0x1f, 0xbd,
  0x8f, 0xdb, 0xcf, 0x7f, 0xff, 0x80, 0x3f, 0xbe, 0x87, 0xfa, 0x3f, 0x7f,
  0xff, 0x80, 0x3f, 0xbf, 0x03, 0xfd, 0xfe, 0xff, 0xff, 0x00, 0x7f, 0xbf,
  0xc1, 0xfd, 0xfe, 0xff, 0xff, 0x00, 0x7f, 0xdf, 0xfc, 0x3c, 0xf9, 0xff,
  0xff, 0x00, 0x7f, 0xef, 0xff, 0xdd, 0x77, 0xff, 0xff, 0x00, 0x7f, 0xf3,
  0xff, 0xed, 0xaf, 0xff, 0xff, 0x00, 0x37, 0xfc, 0x7f, 0xf3, 0xdf, 0xff,
  0xff, 0x00, 0x2f, 0xfd, 0xfc, 0x7f, 0x6f, 0xff, 0xff, 0x00, 0x0f, 0xfb,
  0xf8, 0x3e, 0x2f, 0xff, 0xff, 0x30, 0x0f, 0xfb, 0xfb, 0x9e, 0x2f, 0xff,
  0xff, 0x3c, 0x1f, 0xfb, 0xff, 0xde, 0xaf, 0xff, 0xff, 0x9e, 0x1f, 0xfb,
  0xff, 0xf5, 0xef, 0x7f, 0xff, 0x8f, 0x3f, 0xfb, 0xff, 0xff, 0xef, 0x7f,
  0xff, 0xc3, 0xbf, 0xfb, 0xff, 0xd0, 0xee, 0x3f, 0xff, 0xf0, 0xbf, 0xfd,
  0xff, 0xc0, 0xdc, 0x3f, 0xff, 0xfc, 0xa7, 0xfd, 0xff, 0xd9, 0xb8, 0x1f,
  0xff, 0xff, 0x2b, 0xfe, 0xff, 0xeb, 0x40, 0x1f, 0xff, 0xff, 0xeb, 0xff,
  0x3f, 0xfc, 0x30, 0x1f, 0xff, 0xff, 0xdb, 0xfe, 0xdf, 0xf9, 0xd8, 0x1d,
  0xff, 0xff, 0xdd, 0xfc, 0xe7, 0xfb, 0xdc, 0x1d, 0xff, 0xff, 0xdd, 0xfa,
  0xfb, 0xfb, 0xbc, 0x19, 0xff, 0xff, 0xdd, 0xfa, 0x7f, 0xfb, 0x7c, 0x11,
  0xff, 0xfe, 0x5c, 0xf9, 0x3f, 0xfa, 0xfc, 0x01, 0xff, 0xfd, 0x9d, 0x62,
  0xdf, 0xf9, 0xfc, 0x03, 0xff, 0xfe, 0xfd, 0x9b, 0xff, 0xfb, 0xfe, 0x03,
  0xff, 0xff, 0x7f, 0xd7, 0xff, 0xfb, 0xff, 0x07, 0xff, 0xff, 0xbf, 0xd7,
  0xff, 0xfb, 0xff, 0xcf, 0xff, 0xff, 0xbf, 0xcf, 0xff, 0xfb, 0xff, 0xff,
  0xff, 0xff, 0xc0, 0xcf, 0xdf, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7f,
  0xef, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xef, 0xfe, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xc7, 0xef, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,
  0xe0, 0x1e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xdf, 0xe0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t FIRE_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x40, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x3f, 0x3f,
  0xff, 0xff, 0xff, 0xfb, 0x00, 0x0c, 0x3e, 0xbf, 0xff, 0xf7, 0xff, 0xfb,
  0x00, 0x1c, 0x3e, 0xbf, 0xff, 0xf3, 0xff, 0xf7, 0x00, 0x3c, 0x3e, 0xbf,
  0xff, 0xf1, 0xff, 0xf7, 0x1c, 0x38, 0x3d, 0xbf, 0xff, 0xf8, 0xff, 0xef,
  0x1e, 0x38, 0x7d, 0xbf, 0xff, 0xf8, 0x7f, 0xee, 0x9f, 0x18, 0xfb, 0xbf,
  0xff, 0xbc, 0x3f, 0xde, 0x9f, 0xf9, 0xfb, 0xbf, 0xff, 0x9c, 0x1f, 0xde,
  0xdf, 0xfd, 0xe7, 0xbf, 0xff, 0x8c, 0x1f, 0xdf, 0x5f, 0xfd, 0x1f, 0xbf,
  0xff, 0x84, 0x1f, 0xdf, 0x9f, 0xfe, 0xff, 0x7f, 0xff, 0x80, 0x0f, 0xdf,
  0xe1, 0xfe, 0xff, 0x7f, 0xff, 0xc0, 0x0f, 0xef, 0xfe, 0x1e, 0x7c, 0xff,
  0xfe, 0xc0, 0x0f, 0xf7, 0xff, 0xee, 0xbb, 0xff, 0xff, 0x20, 0x0f, 0xf9,
  0xff, 0xf6, 0xd7, 0xff, 0xff, 0x10, 0x09, 0xfe, 0x3f, 0xf9, 0xef, 0xff,
  0xff, 0x81, 0x11, 0xfe, 0xff, 0xff, 0xf7, 0xff, 0xff, 0x83, 0x03, 0xfd,
  0xff, 0xff, 0xf7, 0xff, 0xff, 0x83, 0x83, 0xfd, 0xf8, 0x3f, 0x97, 0xff,
  0xff, 0x83, 0x87, 0xfd, 0xff, 0x8f, 0x37, 0xff, 0xff, 0xc3, 0xc7, 0xfd,
  0xf8, 0x0a, 0x97, 0xff, 0xff, 0xc1, 0xcf, 0xfd, 0xff, 0xff, 0xf7, 0xff,
  0xff, 0xe0, 0xcf, 0xfd, 0xff, 0xf7, 0xf7, 0xff, 0xff, 0xf8, 0x5f, 0xfe,
  0xff, 0xe8, 0xef, 0xff, 0xff, 0xfe, 0x53, 0xfe, 0xff, 0xff, 0xdf, 0xff,
  0xff, 0xff, 0x95, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xf5, 0xff,
  0x9f, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xed, 0xff, 0xe7, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xee, 0xfe, 0x1f, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd,
  0xbf, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd, 0x7e, 0xfd, 0x7f, 0xff,
  0xff, 0xff, 0x2e, 0x7c, 0xff, 0x7d, 0xbf, 0xff, 0xff, 0xfe, 0xce, 0xb1,
  0xff, 0xbd, 0xdf, 0xff, 0xff, 0xff, 0x7e, 0xcd, 0xf7, 0xdd, 0xef, 0xff,
  0xff, 0xff, 0xbf, 0xeb, 0xf9, 0xdc, 0xef, 0xff, 0xff, 0xff, 0xdf, 0xeb,
  0xfe, 0xdd, 0x1f, 0xff, 0xff, 0xff, 0xdf, 0xe7, 0xff, 0x3d, 0xff, 0xff,
  0xff, 0xff, 0xe0, 0x67, 0xef, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xf7, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xf7, 0xff, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xe3, 0xf7, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
  0xf0, 0x0f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t FIRE_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xd8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x3f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x10, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfc, 0x10, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x3f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe0, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x20, 0x00, 0x3f, 0xff,
  0xff, 0xf7, 0xff, 0xfe, 0x80, 0x00, 0x1f, 0x9f, 0xff, 0xf3, 0xff, 0xfd,
  0x80, 0x06, 0x1f, 0x5f, 0xff, 0xf1, 0xff, 0xfd, 0x80, 0x0e, 0x1f, 0x5f,
  0xff, 0xf8, 0xff, 0xfb, 0x80, 0x1e, 0x1f, 0x5f, 0xff, 0xf8, 0x7f, 0xfb,
  0x8e, 0x1c, 0x1e, 0xdf, 0xff, 0xbc, 0x3f, 0xf7, 0x8f, 0x1c, 0x3e, 0xdf,
  0xff, 0x9c, 0x1f, 0xf7, 0x4f, 0x8c, 0x7d, 0xdf, 0xff, 0x8c, 0x1f, 0xef,
  0x4f, 0xfc, 0xfd, 0xdf, 0xff, 0x84, 0x1f, 0xef, 0x6f, 0xfe, 0xf3, 0xdf,
  0xff, 0x80, 0x0f, 0xef, 0xaf, 0xfe, 0x8f, 0xdf, 0xff, 0xc0, 0x0f, 0xef,
  0xcf, 0xff, 0x7f, 0xbf, 0xfe, 0xc0, 0x0f, 0xef, 0xf0, 0xff, 0x7f, 0xbf,
  0xff, 0x20, 0x0f, 0xf7, 0xff, 0x0f, 0x3e, 0x7f, 0xff, 0x10, 0x09, 0xfb,
  0xff, 0xf7, 0x5d, 0xff, 0xff, 0x81, 0x11, 0xfc, 0xff, 0xfb, 0x6b, 0xff,
  0xff, 0x83, 0x03, 0xff, 0x1f, 0xfc, 0xf7, 0xff, 0xff, 0x83, 0x83, 0xff,
  0x7f, 0xff, 0xfb, 0xff, 0xff, 0x83, 0x87, 0xfe, 0xff, 0xff, 0xfb, 0xff,
  0xff, 0xc3, 0xc7, 0xfe, 0xfc, 0x1f, 0xcb, 0xff, 0xff, 0xc1, 0xcf, 0xfe,
  0xff, 0xc7, 0x9b, 0xff, 0xff, 0xe0, 0xcf, 0xfe, 0xfc, 0x05, 0x4b, 0xff,
  0xff, 0xf8, 0x5f, 0xfe, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xfe, 0x53, 0xfe,
  0xff, 0xfb, 0xfb, 0xff, 0xff, 0xff, 0x95, 0xff, 0x7f, 0xf4, 0x77, 0xff,
  0xff, 0xff, 0xf5, 0xff, 0x7f, 0xff, 0xef, 0xff, 0xff, 0xff, 0xed, 0xff,
  0xbf, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xee, 0xff, 0xdf, 0xff, 0x3f, 0xff,
  0xff, 0xff, 0xee, 0xfe, 0x07, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd,
  0xbf, 0xfd, 0xff, 0xff, 0xff, 0xff, 0x2e, 0xfd, 0x7f, 0xfc, 0xff, 0xff,
  0xff, 0xfe, 0xce, 0x7c, 0xfe, 0xfd, 0x7f, 0xff, 0xff, 0xff, 0x7e, 0xb1,
  0xff, 0x7d, 0xbf, 0xff, 0xff, 0xff, 0xbf, 0xcd, 0xff, 0xbd, 0xdf, 0xff,
  0xff, 0xff, 0xdf, 0xeb, 0xf7, 0xdd, 0xef, 0xff, 0xff, 0xff, 0xef, 0xeb,
  0xf9, 0xdc, 0xef, 0xff, 0xff, 0xff, 0xf0, 0xe7, 0xfe, 0xdd, 0x1f, 0xff,
  0xff, 0xff, 0xff, 0x67, 0xef, 0x3e, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xf7, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xf7, 0xff, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xe3, 0xf7, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
  0xf0, 0x0f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t FIRE_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf8, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0x98, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x10, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x10, 0x3f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf0, 0x00, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x3f, 0xff,
  0xff, 0xf7, 0xff, 0xff, 0x20, 0x00, 0x3f, 0xff, 0xff, 0xf3, 0xff, 0xfe,
  0x80, 0x00, 0x1f, 0x9f, 0xff, 0xf1, 0xff, 0xfd, 0x80, 0x06, 0x1f, 0x5f,
  0xff, 0xf8, 0xff, 0xfd, 0x80, 0x0e, 0x1f, 0x5f, 0xff, 0xf8, 0x7f, 0xfb,
  0x80, 0x1e, 0x1f, 0x5f, 0xff, 0xbc, 0x3f, 0xfb, 0x8e, 0x1c, 0x1e, 0xdf,
  0xff, 0x9c, 0x1f, 0xf7, 0x8f, 0x1c, 0x3e, 0xdf, 0xff, 0x8c, 0x1f, 0xf7,
  0x4f, 0x8c, 0x7d, 0xdf, 0xff, 0x84, 0x1f, 0xef, 0x4f, 0xfc, 0xfd, 0xdf,
  0xff, 0x80, 0x0f, 0xef, 0x6f, 0xfe, 0xf3, 0xdf, 0xff, 0xc0, 0x0f, 0xef,
  0xaf, 0xfe, 0x8f, 0xdf, 0xfe, 0xc0, 0x0f, 0xef, 0xcf, 0xff, 0x7f, 0xbf,
  0xff, 0x20, 0x0f, 0xef, 0xf0, 0xff, 0x7f, 0xbf, 0xff, 0x10, 0x09, 0xf7,
  0xff, 0x0f, 0x3e, 0x7f, 0xff, 0x81, 0x11, 0xfb, 0xff, 0xf7, 0x5d, 0xff,
  0xff, 0x83, 0x03, 0xfc, 0xff, 0xfb, 0x6b, 0xff, 0xff, 0x83, 0x83, 0xff,
  0x1f, 0xfc, 0xf7, 0xff, 0xff, 0x83, 0x87, 0xff, 0x7f, 0xff, 0xfb, 0xff,
  0xff, 0xc3, 0xc7, 0xfe, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xc1, 0xcf, 0xfe,
  0xff, 0xff, 0xfb, 0xff, 0xff, 0xe0, 0xcf, 0xfe, 0xfc, 0x1f, 0xcb, 0xff,
  0xff, 0xf8, 0x5f, 0xfe, 0xff, 0xc7, 0x9b, 0xff, 0xff, 0xfe, 0x53, 0xfe,
  0xfc, 0x05, 0x4b, 0xff, 0xff, 0xff, 0x95, 0xfe, 0xff, 0xff, 0xfb, 0xff,
  0xff, 0xff, 0xf5, 0xff, 0x7f, 0xfb, 0xf7, 0xff, 0xff, 0xff, 0xed, 0xff,
  0x1f, 0xf4, 0x6f, 0xff, 0xff, 0xff, 0xee, 0xff, 0x6f, 0xff, 0xcf, 0xff,
  0xff, 0xff, 0xee, 0xfe, 0x73, 0xfe, 0x2f, 0xff, 0xff, 0xff, 0xee, 0xfd,
  0x7d, 0xfd, 0xdf, 0xff, 0xff, 0xff, 0x2e, 0xfd, 0x3f, 0xfd, 0xbf, 0xff,
  0xff, 0xfe, 0xce, 0x7c, 0xdf, 0xfd, 0x7f, 0xff, 0xff, 0xff, 0x7e, 0xb1,
  0xef, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xbf, 0xcd, 0xff, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xdf, 0xeb, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xef, 0xeb,
  0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xe7, 0xff, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xff, 0x67, 0xef, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xf7, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xf7, 0xff, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xe3, 0xf7, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
  0xf0, 0x0f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t FIRE_frame_9[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe7, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0x30, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x20, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xf8, 0x20, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe,
  0x40, 0x00, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x00, 0x00, 0x3f, 0x3f,
  0xff, 0xff, 0xff, 0xfb, 0x00, 0x0c, 0x3e, 0xbf, 0xff, 0xf7, 0xff, 0xfb,
  0x00, 0x1c, 0x3e, 0xbf, 0xff, 0xf3, 0xff, 0xf7, 0x00, 0x3c, 0x3e, 0xbf,
  0xff, 0xf1, 0xff, 0xf7, 0x1c, 0x38, 0x3d, 0xbf, 0xff, 0xf8, 0xff, 0xef,
  0x1e, 0x38, 0x7d, 0xbf, 0xff, 0xf8, 0x7f, 0xee, 0x9f, 0x18, 0xfb, 0xbf,
  0xff, 0xbc, 0x3f, 0xde, 0x9f, 0xf9, 0xfb, 0xbf, 0xff, 0x9c, 0x1f, 0xde,
  0xdf, 0xfd, 0xe7, 0xbf, 0xff, 0x8c, 0x1f, 0xdf, 0x5f, 0xfd, 0x1f, 0xbf,
  0xff, 0x84, 0x1f, 0xdf, 0x9f, 0xfe, 0xff, 0x7f, 0xff, 0x80, 0x0f, 0xdf,
  0xe1, 0xfe, 0xff, 0x7f, 0xff, 0x80, 0x0f, 0xef, 0xfe, 0x1e, 0x7c, 0xff,
  0xff, 0x80, 0x0f, 0xf7, 0xff, 0xee, 0xbb, 0xff, 0xff, 0x80, 0x0f, 0xf9,
  0xff, 0xf6, 0xd7, 0xff, 0xff, 0x80, 0x09, 0xfe, 0x3f, 0xf9, 0xef, 0xff,
  0xff, 0x81, 0x11, 0xfe, 0xfe, 0x3f, 0xf7, 0xff, 0xff, 0xc3, 0x03, 0xfd,
  0xfc, 0x1f, 0x97, 0xff, 0xff, 0xc3, 0x83, 0xfd, 0xf8, 0x6f, 0x27, 0xff,
  0xff, 0xe3, 0x87, 0xfd, 0xf8, 0x6f, 0x27, 0xff, 0xff, 0xe3, 0xc7, 0xfd,
  0xf8, 0x0a, 0x07, 0xff, 0xff, 0xe1, 0xcf, 0xfd, 0xfc, 0x1f, 0x97, 0xff,
  0xff, 0xf0, 0xcf, 0xfd, 0xfe, 0x3f, 0xf7, 0xff, 0xff, 0xf8, 0x5f, 0xfe,
  0xff, 0xe8, 0x6f, 0xff, 0xff, 0xfe, 0x53, 0xfe, 0xff, 0xe7, 0xdf, 0xff,
  0xff, 0xff, 0x95, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xff, 0xff, 0xf5, 0xff,
  0x9f, 0xfe, 0x7f, 0xff, 0xff, 0xff, 0xed, 0xff, 0xe6, 0x25, 0xff, 0xff,
  0xff, 0xff, 0xee, 0xfe, 0x1d, 0xd9, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd,
  0xbb, 0xde, 0xff, 0xff, 0xff, 0xff, 0xee, 0xfd, 0x77, 0xde, 0xff, 0xff,
  0xff, 0xff, 0x2e, 0x7c, 0xff, 0xae, 0xff, 0xff, 0xff, 0xfe, 0xce, 0xb1,
  0xff, 0x76, 0xff, 0xff, 0xff, 0xff, 0x7e, 0xcd, 0xfe, 0xf9, 0xff, 0xff,
  0xff, 0xff, 0xbf, 0xeb, 0xfd, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xeb,
  0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xe7, 0xff, 0xfd, 0xff, 0xff,
  0xff, 0xff, 0xe0, 0x67, 0xef, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xbf,
  0xf7, 0xfe, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xf7, 0xff, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xe3, 0xf7, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfd,
  0xf0, 0x0f, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xef, 0xf0, 0x7f, 0xff,
  0xff, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t FIRE_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t FIRE_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // FIRE_H
