// SPDX-FileCopyrightText: 2025 KOINSLOT, Inc.
// SPDX-License-Identifier: GPL-3.0-or-later

/*
 * Auto-generated header file from electric2.bmp
 * Sprite sheet: 3x4 frames
 * Frame size: 64x64 pixels
 * Total frames: 12
 * Format: 1-bit packed bitmap (0=black, 1=white)
 * Generated: 2025-06-29 12:14:53
 *
 * Usage in Kywy projects:
 *   #include "electric2.h"
 *
 *   // Draw individual frames:
 *   engine.display.drawBitmap(x, y, ELECTRIC2_FRAME_WIDTH,
 *                            ELECTRIC2_FRAME_HEIGHT, ELECTRIC2_frame_0);
 *
 *   // Animate through frames:
 *   const uint8_t* frames[] = {ELECTRIC2_frame_0, ELECTRIC2_frame_1,
 * ELECTRIC2_frame_2, ELECTRIC2_frame_3, ELECTRIC2_frame_4, ELECTRIC2_frame_5,
 * ELECTRIC2_frame_6, ELECTRIC2_frame_7, ELECTRIC2_frame_8, ELECTRIC2_frame_9,
 * ELECTRIC2_frame_10, ELECTRIC2_frame_11}; engine.display.drawBitmap(x, y,
 * ELECTRIC2_FRAME_WIDTH, ELECTRIC2_FRAME_HEIGHT, frames[currentFrame]);
 */

#ifndef ELECTRIC2_H
#define ELECTRIC2_H

#include <stdint.h>

// Sprite sheet information
#define ELECTRIC2_FRAME_WIDTH 64
#define ELECTRIC2_FRAME_HEIGHT 64
#define ELECTRIC2_FRAME_COUNT 12
#define ELECTRIC2_SPRITE_COLS 3
#define ELECTRIC2_SPRITE_ROWS 4

// Frame 0 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_0[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x07, 0xff, 0xe3, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0f,
  0xf3, 0x80, 0x3f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0xcb, 0xc4, 0x00, 0xff,
  0xff, 0xff, 0x00, 0x01, 0xd3, 0xe4, 0x00, 0x1f, 0xff, 0xff, 0xc0, 0x02,
  0x1f, 0xf6, 0x00, 0x1f, 0xdf, 0xff, 0xe0, 0x01, 0xff, 0xfb, 0x00, 0x3f,
  0xcf, 0xff, 0xf0, 0x03, 0xff, 0xff, 0x80, 0x3f, 0xc7, 0xff, 0xe0, 0x07,
  0xff, 0xff, 0xc0, 0x7f, 0xc3, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xc0, 0x7f,
  0xe1, 0xff, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x3f, 0xe0, 0xfe, 0x00, 0x1f,
  0xff, 0xff, 0xf0, 0x1f, 0xe0, 0x7c, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x1f,
  0xe0, 0x3e, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0x0f, 0xe0, 0x1f, 0xc0, 0x07,
  0xf1, 0xff, 0xfd, 0x07, 0xe0, 0x0f, 0xf8, 0x03, 0xec, 0xff, 0xed, 0xf3,
  0xf0, 0x07, 0xfb, 0x01, 0xde, 0x7f, 0xd5, 0xff, 0xf0, 0x03, 0xe7, 0xe0,
  0xcc, 0x7f, 0xd5, 0xff, 0xf0, 0x03, 0x9f, 0xff, 0xc0, 0x7f, 0xc6, 0xff,
  0xf0, 0x03, 0xe1, 0xff, 0xc0, 0x7f, 0xc6, 0xff, 0xf0, 0x03, 0xfe, 0x7f,
  0xc0, 0x7f, 0xc6, 0xf7, 0xf0, 0x03, 0xfe, 0xff, 0xe0, 0xfe, 0x46, 0xab,
  0xf8, 0x03, 0xfd, 0xff, 0xf1, 0xde, 0x6f, 0x5f, 0xf8, 0x03, 0xf3, 0xff,
  0xff, 0xdf, 0x77, 0x7f, 0xf8, 0x03, 0xef, 0xff, 0xff, 0xee, 0x37, 0xbf,
  0xf8, 0x03, 0xd8, 0xff, 0xff, 0xf1, 0xcf, 0xbf, 0xf8, 0x01, 0x85, 0xf3,
  0xff, 0xff, 0xff, 0xdf, 0xf8, 0x01, 0xfb, 0x01, 0xff, 0xff, 0xf8, 0x1f,
  0xcc, 0x01, 0xf8, 0x60, 0xff, 0xff, 0xf7, 0xff, 0xc0, 0x01, 0xfe, 0xe7,
  0x3f, 0xff, 0xcf, 0xff, 0xe0, 0x01, 0xfd, 0xef, 0xcf, 0xfe, 0x3f, 0xff,
  0xe0, 0x00, 0xf3, 0xf7, 0x80, 0x00, 0x5b, 0xef, 0xf0, 0x00, 0xef, 0xf7,
  0x07, 0x08, 0x25, 0xd7, 0xf0, 0x00, 0xcf, 0xf6, 0x07, 0x0c, 0x35, 0x37,
  0xf0, 0x00, 0xf1, 0xf8, 0x0f, 0x0e, 0x36, 0xfb, 0xf8, 0x00, 0xf3, 0xfc,
  0x0f, 0x06, 0x37, 0xff, 0xf8, 0x07, 0xcf, 0xde, 0x1f, 0x07, 0x77, 0xff,
  0xfc, 0x07, 0xbf, 0xdf, 0x0f, 0x04, 0xdb, 0xff, 0xfc, 0x07, 0x0f, 0xdf,
  0xf0, 0x03, 0xdb, 0xff, 0xfe, 0x07, 0xdf, 0xdf, 0xfb, 0xdf, 0xd7, 0xff,
  0xfe, 0x06, 0x3f, 0xe7, 0xeb, 0xd7, 0xdb, 0xff, 0xfe, 0x04, 0xff, 0xeb,
  0xc3, 0xc1, 0xbc, 0xff, 0xff, 0x03, 0xff, 0xf5, 0x83, 0xc0, 0x7f, 0x7f,
  0xff, 0x00, 0x7f, 0xfa, 0x03, 0xc0, 0x7f, 0xbf, 0xff, 0x80, 0xff, 0xfb,
  0x07, 0xc0, 0xfe, 0x7f, 0xff, 0x81, 0xff, 0xfb, 0x8f, 0xe1, 0xff, 0x7f,
  0xff, 0x83, 0xff, 0xfd, 0xff, 0xfd, 0xff, 0xbf, 0xff, 0xc3, 0xff, 0xfd,
  0xff, 0xfd, 0xff, 0xdf, 0xff, 0xc3, 0xff, 0xfe, 0xdf, 0xbd, 0xff, 0xcf,
  0xff, 0xe3, 0xff, 0xfe, 0x9f, 0x3b, 0xff, 0x3f, 0xff, 0xe7, 0xff, 0xfe,
  0x5e, 0xdb, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xff, 0xde, 0xd7, 0xff, 0x7f,
  0xff, 0xd7, 0xff, 0xff, 0xdd, 0xef, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xfd,
  0xe3, 0xdf, 0xfe, 0xff, 0xfe, 0x5b, 0xff, 0xfb, 0xff, 0xbf, 0xfd, 0xff,
  0xfe, 0x9c, 0xff, 0xf7, 0xff, 0x7f, 0xe0, 0xff, 0xfe, 0xfe, 0x0f, 0xc0,
  0x00, 0x9e, 0x1f, 0x3f, 0xfe, 0xf9, 0xf0, 0x3f, 0xff, 0xe1, 0xff, 0xdf,
  0xff, 0xf7, 0xfe, 0xff, 0xff, 0xfe, 0x1f, 0xdf, 0xff, 0xf7, 0xfe, 0xff,
  0xff, 0xff, 0xe0, 0x3f, 0xff, 0xf8, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 1 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_1[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0xff,
  0xc2, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xff, 0xe3, 0x0f, 0xff, 0xff,
  0xff, 0xf0, 0x00, 0x0f, 0xf3, 0x80, 0x3f, 0xff, 0xff, 0xfc, 0x00, 0x00,
  0xcb, 0xc4, 0x00, 0xff, 0xff, 0xff, 0x00, 0x01, 0xd3, 0xe4, 0x00, 0x1f,
  0x7f, 0xff, 0xc0, 0x02, 0x1f, 0xf6, 0x00, 0x1f, 0x3f, 0xff, 0xe0, 0x01,
  0xff, 0xfb, 0x00, 0x3f, 0x1f, 0xff, 0xf0, 0x03, 0xff, 0xff, 0x80, 0x3f,
  0x0f, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xc0, 0x7f, 0x87, 0xff, 0xc0, 0x0f,
  0xff, 0xff, 0xc0, 0x7f, 0x83, 0xff, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x3f,
  0xc0, 0xfe, 0x00, 0x1f, 0xff, 0xff, 0xf0, 0x1f, 0xc0, 0x7c, 0x00, 0x1f,
  0xff, 0xff, 0xf8, 0x1f, 0xc0, 0x3e, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0x0f,
  0xc0, 0x1f, 0xc0, 0x07, 0xf1, 0xff, 0xfd, 0x07, 0xe0, 0x0f, 0xf8, 0x03,
  0xec, 0xff, 0xed, 0xf3, 0xe0, 0x07, 0xfb, 0x01, 0xde, 0x7f, 0xd5, 0xff,
  0xe0, 0x07, 0xe7, 0xe0, 0xcc, 0x7f, 0xd5, 0xff, 0xe0, 0x07, 0x9f, 0xff,
  0xc0, 0x7f, 0xc6, 0xff, 0xe0, 0x07, 0xe1, 0xff, 0xc0, 0x7f, 0xc6, 0xef,
  0xe0, 0x07, 0xfe, 0x7f, 0xc0, 0x7f, 0xc6, 0x8f, 0xf0, 0x07, 0xfe, 0xff,
  0xe0, 0xfe, 0x46, 0xf5, 0xf0, 0x07, 0xfd, 0xff, 0xf1, 0xde, 0x6f, 0x7b,
  0xf0, 0x07, 0xf3, 0xff, 0xff, 0xdf, 0x77, 0x7f, 0xf0, 0x07, 0xef, 0xff,
  0xff, 0xee, 0x37, 0xbf, 0xf8, 0x01, 0xd8, 0xff, 0xff, 0xf1, 0xcf, 0xbf,
  0xf8, 0x01, 0x85, 0xf3, 0xff, 0xff, 0xff, 0xdf, 0xcc, 0x01, 0xfb, 0x01,
  0xff, 0xff, 0xf8, 0x1f, 0xc0, 0x01, 0xf8, 0x60, 0xff, 0xff, 0xf7, 0xff,
  0xe0, 0x01, 0xfd, 0xef, 0x3f, 0xff, 0x8f, 0x7f, 0xe0, 0x00, 0xf3, 0xf7,
  0x8f, 0xfe, 0x5e, 0xbf, 0xf0, 0x00, 0xef, 0xf7, 0x00, 0x00, 0x25, 0xaf,
  0xf0, 0x00, 0xcf, 0xf6, 0x07, 0x0c, 0x37, 0xaf, 0xf0, 0x00, 0xf1, 0xf8,
  0x0f, 0x0e, 0x37, 0xa7, 0xf8, 0x00, 0xf3, 0xfc, 0x0f, 0x06, 0x37, 0xdf,
  0xf8, 0x07, 0xcf, 0xde, 0x1f, 0x07, 0x77, 0xff, 0xfc, 0x07, 0xbf, 0xdf,
  0x0f, 0x04, 0xdb, 0xff, 0xfc, 0x07, 0x0f, 0xdf, 0xf0, 0x03, 0xd8, 0xff,
  0xff, 0x03, 0xdf, 0xdf, 0xfb, 0xdf, 0xd7, 0x7f, 0xff, 0x06, 0x3f, 0xe7,
  0xeb, 0xd7, 0xdb, 0xbf, 0xff, 0x04, 0xff, 0xeb, 0xc3, 0xc1, 0xbe, 0x7f,
  0xff, 0x83, 0xff, 0xf5, 0x83, 0xc0, 0x7f, 0x7f, 0xff, 0x80, 0x7f, 0xfa,
  0x03, 0xc0, 0x7f, 0x8f, 0xff, 0xc0, 0xff, 0xfb, 0x07, 0xc0, 0xff, 0xb7,
  0xff, 0xc1, 0xff, 0xfb, 0x8f, 0xe1, 0xff, 0xb7, 0xff, 0xc3, 0xff, 0xfd,
  0xff, 0xfd, 0xff, 0x77, 0xff, 0xc3, 0xff, 0xfd, 0xff, 0xfd, 0xff, 0x77,
  0xff, 0xc3, 0xff, 0xfe, 0xdf, 0xbd, 0xff, 0x77, 0xff, 0xe3, 0xff, 0xfe,
  0x9f, 0x3b, 0xff, 0x77, 0xff, 0xe5, 0xff, 0xfe, 0x5e, 0xdb, 0xfe, 0xef,
  0xff, 0xdb, 0xff, 0xff, 0xde, 0xd7, 0xfe, 0xdf, 0xff, 0xdb, 0xff, 0xff,
  0xdd, 0xef, 0xfc, 0xbf, 0xff, 0x9d, 0xff, 0xfd, 0xe3, 0xdf, 0xe0, 0x7f,
  0xfe, 0x7e, 0xff, 0xfb, 0xff, 0xa0, 0x1f, 0xff, 0xfd, 0xff, 0x0c, 0x11,
  0xff, 0x7f, 0xff, 0xff, 0xfd, 0xff, 0xe3, 0xe0, 0x00, 0xff, 0xff, 0xff,
  0xfd, 0xff, 0xdf, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfb,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x07, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 2 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_2[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfd, 0xff, 0xff, 0xff, 0xff, 0x01, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xff,
  0xff, 0xc0, 0x07, 0xff, 0xe3, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0f,
  0xf3, 0x80, 0x3f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0xcb, 0xc4, 0x00, 0xff,
  0xff, 0xff, 0x00, 0x01, 0xd3, 0xe4, 0x00, 0x1f, 0xff, 0xff, 0xc0, 0x02,
  0x1f, 0xf6, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x01, 0xff, 0xfb, 0x00, 0x3f,
  0x7f, 0xff, 0xf0, 0x03, 0xff, 0xff, 0x80, 0x3f, 0x3f, 0xff, 0xe0, 0x07,
  0xff, 0xff, 0xc0, 0x7f, 0x1f, 0xff, 0xc0, 0x0f, 0xff, 0xff, 0xc0, 0x7f,
  0x07, 0xff, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x3f, 0x03, 0xfe, 0x00, 0x1f,
  0xff, 0xff, 0xf0, 0x1f, 0x81, 0xfc, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x1f,
  0x80, 0xfe, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0x0f, 0x80, 0x7f, 0xc0, 0x07,
  0xf1, 0xff, 0xfd, 0x07, 0x80, 0x3f, 0xf8, 0x03, 0xec, 0xff, 0xed, 0xf3,
  0xc0, 0x1f, 0xfb, 0x01, 0xde, 0x7f, 0xd5, 0xff, 0xc0, 0x0f, 0xe7, 0xe0,
  0xcc, 0x7f, 0xd5, 0xff, 0xc0, 0x07, 0x9f, 0xff, 0xc0, 0x7f, 0xc6, 0xf7,
  0xc0, 0x07, 0xe1, 0xff, 0xc0, 0x7f, 0xc6, 0xeb, 0xe0, 0x07, 0xfe, 0x7f,
  0xc0, 0x7f, 0xc6, 0xdb, 0xe0, 0x07, 0xfe, 0xff, 0xe0, 0xfe, 0x46, 0xbf,
  0xe0, 0x07, 0xfd, 0xff, 0xf1, 0xde, 0x6f, 0x7f, 0xe0, 0x07, 0xf3, 0xff,
  0xff, 0xdf, 0x77, 0x7f, 0xf0, 0x07, 0xef, 0xff, 0xff, 0xee, 0x37, 0xbf,
  0xf0, 0x03, 0xd8, 0xff, 0xff, 0xf1, 0xcf, 0xbf, 0xf0, 0x03, 0x85, 0xf3,
  0xff, 0xff, 0xff, 0xdf, 0xf0, 0x01, 0xfb, 0x01, 0xff, 0xff, 0xf8, 0x1f,
  0xf8, 0x01, 0xf8, 0x60, 0xff, 0xff, 0xf7, 0xff, 0xc8, 0x01, 0xfe, 0xe7,
  0x3f, 0xff, 0xcf, 0xff, 0xc0, 0x01, 0xfd, 0xef, 0xcf, 0xfe, 0x3f, 0x8f,
  0xe0, 0x01, 0xf3, 0xf7, 0x80, 0x00, 0x5b, 0x77, 0xe0, 0x00, 0xef, 0xf7,
  0x07, 0x08, 0x24, 0xf7, 0xf0, 0x00, 0xcf, 0xf6, 0x07, 0x0c, 0x37, 0xf7,
  0xf0, 0x00, 0xf1, 0xf8, 0x0f, 0x0e, 0x37, 0xfb, 0xf0, 0x00, 0xf3, 0xfc,
  0x0f, 0x06, 0x37, 0xff, 0xf8, 0x00, 0xcf, 0xde, 0x1f, 0x07, 0x77, 0xff,
  0xf8, 0x07, 0xbf, 0xdf, 0x0f, 0x04, 0xdb, 0xff, 0xfc, 0x07, 0x0f, 0xdf,
  0xf0, 0x03, 0xdb, 0xff, 0xfc, 0x07, 0xdf, 0xdf, 0xfb, 0xdf, 0xd7, 0xff,
  0xff, 0x02, 0x3f, 0xe7, 0xeb, 0xd7, 0xdb, 0xff, 0xff, 0x00, 0xff, 0xeb,
  0xc3, 0xc1, 0xb3, 0xff, 0xff, 0x03, 0xff, 0xf5, 0x83, 0xc0, 0x7d, 0xff,
  0xff, 0x80, 0x7f, 0xfa, 0x03, 0xc0, 0x7e, 0xff, 0xff, 0x80, 0xfe, 0x3b,
  0x07, 0xc0, 0xf9, 0xff, 0xff, 0xc1, 0xfd, 0xdb, 0x8f, 0xe1, 0xfd, 0xff,
  0xff, 0xc3, 0xfb, 0xdd, 0xff, 0xfd, 0xfe, 0xff, 0xff, 0xc3, 0xf7, 0xdd,
  0xff, 0xfd, 0xff, 0x7f, 0xff, 0xc3, 0xf7, 0xde, 0xdf, 0xbd, 0xff, 0x3f,
  0xff, 0xe3, 0xef, 0xde, 0x9f, 0x3b, 0xfc, 0xff, 0xff, 0xe7, 0xef, 0xde,
  0x5e, 0xdb, 0xfd, 0xff, 0xff, 0xd7, 0xef, 0xdf, 0xde, 0xd7, 0xfb, 0xff,
  0xfe, 0x3b, 0xef, 0xdf, 0xdd, 0xef, 0xf7, 0xff, 0xfd, 0xfc, 0xef, 0xb5,
  0xe3, 0xdf, 0xf7, 0xff, 0xfd, 0xff, 0x07, 0x5b, 0xff, 0xbf, 0xef, 0xff,
  0xfb, 0xff, 0xf0, 0x0f, 0xff, 0x7e, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xf0,
  0x00, 0x61, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x9f, 0xfd, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xe1, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 3 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_3[] = {
  0xff, 0x01, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xff,
  0xe3, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0f, 0xf3, 0x80, 0x3f, 0xff,
  0xff, 0xfc, 0x00, 0x00, 0xcb, 0xc4, 0x00, 0xff, 0xff, 0xff, 0x00, 0x01,
  0xd3, 0xe4, 0x00, 0x1f, 0xfe, 0xff, 0xc0, 0x02, 0x1f, 0xf6, 0x00, 0x1f,
  0xfe, 0xff, 0xe0, 0x01, 0xff, 0xfb, 0x00, 0x3f, 0xfc, 0x7f, 0xf0, 0x03,
  0xff, 0xff, 0x80, 0x3f, 0xfc, 0x7f, 0xe0, 0x07, 0xff, 0xff, 0xc0, 0x7f,
  0xf8, 0x7f, 0xc0, 0x0f, 0xff, 0xff, 0xc0, 0x7f, 0xf8, 0x3f, 0x00, 0x1f,
  0xff, 0xff, 0xe0, 0x3f, 0xf8, 0x3e, 0x00, 0x1f, 0xff, 0xff, 0xf0, 0x1f,
  0xf0, 0x3c, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xf0, 0x1e, 0x00, 0x0f,
  0xff, 0xff, 0xf8, 0x0f, 0xf0, 0x1f, 0xc0, 0x07, 0xf1, 0xff, 0xfd, 0x07,
  0xe0, 0x1f, 0xf8, 0x03, 0xe6, 0xff, 0xed, 0xf3, 0xe0, 0x1f, 0xfb, 0x01,
  0xcc, 0x7f, 0xc5, 0xff, 0xc0, 0x0f, 0xe7, 0xe0, 0xd8, 0x7f, 0xd5, 0xff,
  0xc0, 0x0f, 0x9f, 0xff, 0xc6, 0x7f, 0xc6, 0xff, 0xc0, 0x0f, 0xe1, 0xff,
  0xc3, 0x7f, 0xd6, 0xff, 0x80, 0x07, 0xfe, 0x7f, 0xc2, 0x7f, 0xc6, 0xf7,
  0x80, 0x07, 0xfe, 0xff, 0xe4, 0xfe, 0x56, 0xab, 0xc0, 0x07, 0xfd, 0xff,
  0xf1, 0xde, 0x6f, 0x5f, 0xe0, 0x03, 0xf3, 0xff, 0xff, 0xdf, 0x77, 0x7f,
  0xf0, 0x03, 0xef, 0xff, 0xff, 0xee, 0x37, 0xbf, 0xf0, 0x03, 0xd8, 0xff,
  0xff, 0xf1, 0xcf, 0xbf, 0xf8, 0x01, 0x85, 0xf3, 0xff, 0xff, 0xff, 0xdf,
  0xfc, 0x01, 0xfb, 0x01, 0xff, 0xff, 0xf8, 0x1f, 0xfe, 0x03, 0xf8, 0x60,
  0xff, 0xff, 0xf7, 0xff, 0xfc, 0x03, 0xfe, 0xe7, 0x3f, 0xff, 0xcf, 0xff,
  0xf8, 0x07, 0xfd, 0xef, 0xcf, 0xfe, 0x3f, 0xff, 0xf0, 0x07, 0xf3, 0xf7,
  0x80, 0x00, 0x5b, 0xef, 0xe0, 0x0f, 0xef, 0xf7, 0x07, 0x08, 0x25, 0xd7,
  0xc0, 0x0f, 0xcf, 0xd6, 0x07, 0x0c, 0x05, 0x37, 0x80, 0x1f, 0xf1, 0xb8,
  0x0f, 0x0e, 0x36, 0xfb, 0xc0, 0x1f, 0xf3, 0x7c, 0x0f, 0x06, 0x39, 0xff,
  0xe0, 0x0f, 0xce, 0xfe, 0x1f, 0x07, 0x78, 0xff, 0xe0, 0x0f, 0xbc, 0xff,
  0x0f, 0x04, 0xf0, 0x7f, 0xf0, 0x0f, 0x08, 0x7f, 0xf0, 0x03, 0xf0, 0x7f,
  0xf8, 0x07, 0xd8, 0x3f, 0xff, 0xff, 0xe0, 0x7f, 0xfc, 0x06, 0x38, 0x3d,
  0xff, 0xff, 0xf0, 0x7f, 0xfe, 0x04, 0xfc, 0x33, 0xff, 0xff, 0xc0, 0xff,
  0xfe, 0x03, 0xfe, 0x03, 0xff, 0xff, 0xff, 0x7f, 0xff, 0x00, 0x79, 0xfb,
  0xff, 0xff, 0xff, 0xbf, 0xff, 0x80, 0xf6, 0xfb, 0xff, 0xff, 0xfe, 0x7f,
  0xff, 0xc1, 0xef, 0x7b, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xe3, 0xdf, 0x7d,
  0xff, 0xfd, 0xff, 0xbf, 0xff, 0xe3, 0xdf, 0x7d, 0xff, 0xfd, 0xff, 0xdf,
  0xff, 0xf3, 0xdf, 0xbe, 0xdf, 0xbd, 0xff, 0xcf, 0xff, 0xfb, 0xdf, 0xbe,
  0x9f, 0x3b, 0xff, 0x3f, 0xff, 0xfb, 0xdf, 0xbe, 0x5e, 0xdb, 0xff, 0x7f,
  0xff, 0xfb, 0xdf, 0x7f, 0xde, 0xd7, 0xff, 0x7f, 0xff, 0xdb, 0xdf, 0x7f,
  0xdd, 0xef, 0xff, 0x7f, 0xff, 0xdd, 0xef, 0x7d, 0xe3, 0xdf, 0xfe, 0xff,
  0xfe, 0x5e, 0xf0, 0xfb, 0xff, 0xbf, 0xfd, 0xff, 0xfe, 0x9f, 0x7f, 0xf7,
  0xff, 0x7f, 0xfb, 0xff, 0xfe, 0xff, 0x8f, 0xc0, 0x00, 0xbf, 0xf7, 0xff,
  0xfe, 0xff, 0xf0, 0x3f, 0xff, 0xdf, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe8, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 4 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_4[] = {
  0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xc2, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xff, 0xff, 0xe3, 0x7f, 0xff, 0xff,
  0xff, 0x80, 0x1f, 0xff, 0xf3, 0x83, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x3f,
  0xcb, 0xc4, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x03, 0xd3, 0xe4, 0x3f, 0xff,
  0xff, 0xfc, 0x00, 0x06, 0x1f, 0xf6, 0x0f, 0xff, 0xdf, 0xfe, 0x00, 0x05,
  0xff, 0xfb, 0x01, 0xff, 0xcf, 0xff, 0x80, 0x0b, 0xff, 0xff, 0x80, 0x3f,
  0xc7, 0xff, 0x80, 0x17, 0xff, 0xff, 0xc0, 0x0f, 0xc3, 0xff, 0x00, 0x0f,
  0xff, 0xff, 0xc0, 0x03, 0xe1, 0xff, 0x00, 0x3f, 0xff, 0xff, 0xe0, 0x0f,
  0xe0, 0xfe, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x1f, 0xe0, 0x7c, 0x00, 0x7f,
  0xff, 0xff, 0xf8, 0x3f, 0xe0, 0x3e, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0xff,
  0xe0, 0x1f, 0xc0, 0x07, 0xf1, 0xff, 0xfd, 0xff, 0xe0, 0x0f, 0xf8, 0x03,
  0xe2, 0xff, 0xed, 0xff, 0xf0, 0x07, 0xfb, 0x01, 0xc4, 0x7f, 0xc5, 0xff,
  0xf0, 0x03, 0xe7, 0xe0, 0xc8, 0x7f, 0xc5, 0xff, 0xf0, 0x03, 0x9f, 0xff,
  0xc8, 0x7f, 0xd6, 0xff, 0xf0, 0x03, 0xe1, 0xff, 0xc4, 0x7f, 0xc6, 0xef,
  0xf0, 0x03, 0xfe, 0x7f, 0xc6, 0x7f, 0xd6, 0xd7, 0xf0, 0x03, 0xfe, 0xff,
  0xe2, 0xfe, 0x46, 0xbb, 0xf8, 0x03, 0xfd, 0xff, 0xf1, 0xde, 0x6f, 0x3b,
  0xf8, 0x03, 0xf3, 0xff, 0xff, 0xdf, 0x77, 0x7d, 0xf8, 0x03, 0xef, 0xff,
  0xff, 0xee, 0x37, 0xbf, 0xf8, 0x03, 0xd8, 0xff, 0xff, 0xf1, 0xcf, 0xbf,
  0xf8, 0x01, 0x85, 0xf3, 0xff, 0xff, 0xff, 0xdf, 0xf8, 0x01, 0xfb, 0x0d,
  0xff, 0xff, 0xf8, 0x1f, 0xcc, 0x01, 0xf8, 0x6c, 0xff, 0xff, 0xf7, 0xbf,
  0xc0, 0x01, 0xfe, 0xe8, 0x3f, 0xff, 0xcf, 0x5f, 0xe0, 0x01, 0xfd, 0xe0,
  0x0f, 0xfe, 0x3f, 0x5f, 0xe0, 0x00, 0xf3, 0xf0, 0x70, 0x01, 0x5e, 0xef,
  0xf0, 0x00, 0xef, 0xf0, 0xf8, 0xe3, 0xad, 0xf7, 0xf0, 0x00, 0xcf, 0xd1,
  0xf8, 0xf1, 0xc5, 0xf7, 0xf0, 0x00, 0xf1, 0xbb, 0xf8, 0xf1, 0xb7, 0xfb,
  0xf8, 0x00, 0xf3, 0x7d, 0xf0, 0xf8, 0xb9, 0xff, 0xf8, 0x07, 0xce, 0xfe,
  0xf0, 0xf8, 0x78, 0xff, 0xfc, 0x07, 0xbc, 0xff, 0x00, 0x78, 0xf0, 0x7f,
  0xfc, 0x07, 0x08, 0x7f, 0xf0, 0x03, 0xf0, 0x7f, 0xfe, 0x07, 0xd8, 0x3f,
  0xff, 0xff, 0xe0, 0x7f, 0xfe, 0x06, 0x38, 0x3d, 0xff, 0xff, 0xf0, 0x7f,
  0xfe, 0x04, 0xfc, 0x33, 0xff, 0xff, 0xc0, 0xff, 0xff, 0x03, 0xfe, 0x03,
  0xff, 0xff, 0xff, 0x7f, 0xff, 0x00, 0x79, 0xfb, 0xff, 0xff, 0xff, 0xbf,
  0xff, 0x80, 0xf6, 0xfb, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0x81, 0xef, 0x7b,
  0xff, 0xff, 0xff, 0x7f, 0xff, 0x83, 0xdf, 0x7d, 0xff, 0xfd, 0xff, 0xbf,
  0xff, 0xc3, 0xdf, 0x7d, 0xff, 0xfd, 0xff, 0xdf, 0xff, 0xc3, 0xdf, 0xbe,
  0xdf, 0xbd, 0xff, 0xcf, 0xff, 0xe3, 0xdf, 0xbe, 0x9f, 0x3b, 0xff, 0x3f,
  0xff, 0xe3, 0xdf, 0xbe, 0x5e, 0xdb, 0xff, 0x7f, 0xff, 0xdb, 0xdf, 0x7f,
  0xde, 0xd7, 0xff, 0x7f, 0xff, 0xdb, 0xdf, 0x7f, 0xdd, 0xef, 0xfe, 0xff,
  0xff, 0xdd, 0xef, 0x7d, 0xe3, 0xdf, 0xfd, 0xff, 0xfe, 0x5e, 0xf0, 0xfb,
  0xff, 0xbf, 0xfb, 0xff, 0xfe, 0x9f, 0x7f, 0xf7, 0xff, 0x7f, 0xf7, 0xff,
  0xfe, 0xff, 0x8f, 0xc0, 0x00, 0xbf, 0x83, 0xff, 0xfe, 0xff, 0xf0, 0x3f,
  0xff, 0xc8, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 5 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_5[] = {
  0xff, 0xcf, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xff, 0xff,
  0xe3, 0x0f, 0xff, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xf3, 0x81, 0xff, 0xff,
  0xff, 0xff, 0x01, 0xff, 0xcb, 0xc4, 0x3f, 0xff, 0xfb, 0xff, 0xc0, 0x0f,
  0xd3, 0xe4, 0x01, 0xff, 0xf9, 0xff, 0xf0, 0x00, 0x1f, 0xf6, 0x00, 0x3f,
  0xf9, 0xff, 0xfc, 0x00, 0x7f, 0xfb, 0x00, 0x0f, 0xf8, 0xff, 0xfe, 0x00,
  0x1f, 0xff, 0x80, 0x03, 0xf8, 0xff, 0xfc, 0x00, 0x3f, 0xff, 0xc0, 0x1f,
  0xf0, 0x7f, 0xf8, 0x00, 0xff, 0xff, 0xc0, 0x7f, 0xf0, 0x7f, 0xf0, 0x03,
  0xff, 0xff, 0xe0, 0x3f, 0xf0, 0x3f, 0xe0, 0x0f, 0xff, 0xff, 0xf0, 0x0f,
  0xf0, 0x3f, 0x80, 0x1f, 0xff, 0xff, 0xf8, 0x03, 0xf0, 0x1f, 0x00, 0x0f,
  0xff, 0xff, 0xf8, 0x00, 0xf0, 0x1e, 0x00, 0x07, 0xf1, 0xff, 0xfd, 0xff,
  0xe0, 0x0c, 0x00, 0x03, 0xec, 0xff, 0xed, 0xff, 0xe0, 0x08, 0x00, 0x01,
  0xc6, 0x7f, 0xd5, 0xff, 0xe0, 0x07, 0xe4, 0x00, 0xc3, 0x7f, 0xc5, 0xff,
  0xe0, 0x07, 0x9f, 0xff, 0xcc, 0x7f, 0xd6, 0xff, 0xe0, 0x03, 0xe1, 0xff,
  0xd8, 0x7f, 0xc6, 0xef, 0xc0, 0x03, 0xfe, 0x7f, 0xc8, 0x7f, 0xd6, 0xd7,
  0xc0, 0x01, 0xfe, 0xff, 0xe4, 0xfe, 0x46, 0xbb, 0xc0, 0x01, 0xfd, 0xff,
  0xf1, 0xde, 0x6f, 0x7b, 0xc0, 0x00, 0xf3, 0xff, 0xff, 0xdf, 0x77, 0x7f,
  0xc0, 0x00, 0xef, 0xff, 0xff, 0xee, 0x37, 0xbf, 0x80, 0x00, 0xd8, 0xff,
  0xff, 0xf1, 0xcf, 0xbf, 0x80, 0x01, 0x85, 0xf3, 0xff, 0xff, 0xff, 0xdf,
  0x80, 0x01, 0xfb, 0x01, 0xff, 0xff, 0xf8, 0x1f, 0xe0, 0x03, 0xf8, 0x60,
  0xff, 0xff, 0xf7, 0xff, 0xfc, 0x03, 0xfe, 0xe7, 0x3f, 0xff, 0xcf, 0xf7,
  0xfe, 0x03, 0xfd, 0xef, 0xcf, 0xfe, 0x3f, 0xe7, 0xfc, 0x07, 0xf3, 0xf7,
  0x80, 0x00, 0x5f, 0xdb, 0xfc, 0x07, 0xef, 0xf7, 0x07, 0x08, 0x2f, 0xbb,
  0xf8, 0x07, 0xcf, 0xd6, 0x07, 0x0c, 0x07, 0x3b, 0xf8, 0x0f, 0xf1, 0xb8,
  0x0f, 0x0e, 0x34, 0xfd, 0xf8, 0x0f, 0xf3, 0x7c, 0x0f, 0x06, 0x39, 0xfd,
  0xf0, 0x1f, 0xce, 0xfe, 0x1f, 0x07, 0x78, 0xff, 0xf0, 0x1f, 0xbc, 0xff,
  0x0f, 0x04, 0xf0, 0x7f, 0xe0, 0x0f, 0x08, 0x7f, 0xf0, 0x03, 0xf0, 0x7f,
  0xe0, 0x0f, 0xd8, 0x3f, 0xff, 0xff, 0xe0, 0x7f, 0xc0, 0x06, 0x38, 0x3d,
  0xff, 0xff, 0xf0, 0x7f, 0xc0, 0x04, 0xfc, 0x33, 0xff, 0xff, 0xc0, 0xff,
  0xe0, 0x01, 0xfe, 0x03, 0xff, 0xff, 0xff, 0x7f, 0xf0, 0x00, 0x79, 0xfb,
  0xff, 0xff, 0xff, 0xbf, 0xfc, 0x00, 0xf6, 0xfb, 0xff, 0xff, 0xfe, 0x7f,
  0xfe, 0x01, 0xef, 0x7b, 0xff, 0xff, 0xff, 0x7f, 0xff, 0x03, 0xdf, 0x7d,
  0xff, 0xfd, 0xff, 0xbf, 0xff, 0xc3, 0xdf, 0x7d, 0xff, 0xfd, 0xff, 0xdf,
  0xff, 0xc3, 0xdf, 0xbe, 0xdf, 0xbd, 0xff, 0xcf, 0xff, 0xe3, 0xdf, 0xbe,
  0x9f, 0x3b, 0xff, 0x3f, 0xff, 0xe3, 0xdf, 0xbe, 0x5e, 0xdb, 0xff, 0x7f,
  0xff, 0xdb, 0xdf, 0x7f, 0xde, 0xd7, 0xff, 0x7f, 0xff, 0xdb, 0xdf, 0x7f,
  0xdd, 0xef, 0xff, 0x7f, 0xff, 0xdd, 0xef, 0x7d, 0xe3, 0xdf, 0xfe, 0xff,
  0xfe, 0x5e, 0xf0, 0xfb, 0xff, 0xbf, 0xfd, 0xff, 0xfe, 0x9f, 0x7f, 0xf7,
  0xff, 0x7f, 0xfb, 0xff, 0xfe, 0xff, 0x8f, 0xc0, 0x00, 0xbf, 0xf7, 0xff,
  0xfe, 0xff, 0xf0, 0x3f, 0xff, 0xdf, 0x83, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xe8, 0x7c, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xff, 0x7f,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xf9, 0xff, 0x7f, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xfe, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 6 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_6[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xe3, 0x7f, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x01, 0xf3, 0x8b, 0xff, 0xff,
  0xff, 0x80, 0x00, 0x03, 0xcb, 0xc4, 0x3f, 0xff, 0xff, 0xf8, 0x00, 0x03,
  0xd3, 0xe4, 0x00, 0xff, 0xdf, 0xff, 0x00, 0x00, 0x1f, 0xf6, 0x00, 0x1f,
  0xcf, 0xff, 0xe0, 0x03, 0xff, 0xfb, 0x00, 0x3f, 0xc7, 0xff, 0xf0, 0x07,
  0xff, 0xff, 0x80, 0x3f, 0xc3, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xc0, 0x7f,
  0xe1, 0xff, 0xc0, 0x1f, 0xff, 0xff, 0xc0, 0x7f, 0xe0, 0xff, 0x00, 0x7f,
  0xff, 0xff, 0xe0, 0x7f, 0xe0, 0x7e, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x3f,
  0xe0, 0x3c, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xe0, 0x1e, 0x00, 0x0f,
  0xff, 0xff, 0xf9, 0x9f, 0xe0, 0x0f, 0xc0, 0x07, 0xff, 0xff, 0xfd, 0xef,
  0xf0, 0x07, 0xf8, 0x03, 0xff, 0xff, 0xfd, 0xff, 0xf0, 0x03, 0xfb, 0x01,
  0xff, 0xff, 0xfd, 0xff, 0xf0, 0x03, 0xe7, 0xe0, 0xcf, 0xff, 0xfd, 0xff,
  0xf0, 0x03, 0x9f, 0xff, 0xc1, 0xff, 0xe6, 0xff, 0xf0, 0x03, 0xe1, 0xff,
  0xf0, 0x7f, 0xc6, 0xff, 0xf0, 0x03, 0xfe, 0x7f, 0xfe, 0x7f, 0xde, 0xf7,
  0xf8, 0x03, 0xfe, 0xff, 0xff, 0xf9, 0xfe, 0xab, 0xf8, 0x03, 0xfd, 0xff,
  0xff, 0xf9, 0xff, 0x5f, 0xf8, 0x03, 0xf3, 0xff, 0xff, 0xfd, 0xff, 0x7f,
  0xf8, 0x03, 0xef, 0xff, 0xff, 0xf8, 0xff, 0xbf, 0xf8, 0x01, 0xd8, 0xff,
  0xff, 0xc7, 0x3f, 0xbf, 0xf8, 0x01, 0x85, 0xf3, 0xff, 0x8f, 0x3f, 0xdf,
  0xcc, 0x01, 0xfb, 0x01, 0xff, 0xf0, 0xf8, 0x1f, 0xc0, 0x01, 0xf8, 0x60,
  0xff, 0xff, 0xf7, 0xff, 0xe0, 0x01, 0xfc, 0xe7, 0x0f, 0xfe, 0x0f, 0xff,
  0xe0, 0x00, 0xf3, 0xf7, 0x80, 0x00, 0x5b, 0xef, 0xf0, 0x00, 0xef, 0xf7,
  0x07, 0x08, 0x25, 0xd7, 0xf0, 0x00, 0xcf, 0xf6, 0x07, 0x0c, 0x35, 0x37,
  0xf0, 0x00, 0xf1, 0xf8, 0x0f, 0x0e, 0x36, 0xfb, 0xf8, 0x00, 0xf3, 0xfc,
  0x0f, 0x06, 0x37, 0xff, 0xf8, 0x07, 0xcf, 0xde, 0x1f, 0x07, 0x77, 0xff,
  0xfc, 0x07, 0xbf, 0xdf, 0x0f, 0x04, 0xdb, 0xff, 0xfc, 0x07, 0x0f, 0xdf,
  0xf0, 0x03, 0xdb, 0xff, 0xfe, 0x07, 0xdf, 0xdf, 0xfb, 0xdf, 0xd7, 0xff,
  0xfe, 0x06, 0x3f, 0xe7, 0xeb, 0xd7, 0xdb, 0xff, 0xfe, 0x04, 0xff, 0xeb,
  0xc3, 0xc1, 0xbc, 0xff, 0xff, 0x03, 0xff, 0xf5, 0x83, 0xc0, 0x7f, 0x7f,
  0xff, 0x00, 0x7f, 0xfa, 0x03, 0xc0, 0x7f, 0xbf, 0xff, 0x80, 0xff, 0xfb,
  0x07, 0xc0, 0xfe, 0x7f, 0xff, 0x81, 0xff, 0xfb, 0x8f, 0xe1, 0xff, 0x7f,
  0xff, 0x83, 0xff, 0xfd, 0xff, 0xfd, 0xff, 0xbf, 0xff, 0xc3, 0xff, 0xfd,
  0xff, 0xfd, 0xff, 0xdf, 0xff, 0xc3, 0xff, 0xfe, 0xdf, 0xbd, 0xff, 0xcf,
  0xff, 0xe3, 0xff, 0xfe, 0x9f, 0x3b, 0xff, 0x3f, 0xff, 0xe7, 0xff, 0xfe,
  0x5e, 0xdb, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xff, 0xde, 0xd7, 0xff, 0x7f,
  0xff, 0xd7, 0xff, 0xff, 0xdd, 0xef, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xfd,
  0xe3, 0xdf, 0xfe, 0xff, 0xfe, 0x5b, 0xff, 0xfb, 0xff, 0xbf, 0xfd, 0xff,
  0xfe, 0x9c, 0xff, 0xf7, 0xff, 0x7f, 0xe0, 0xff, 0xfe, 0xfe, 0x0f, 0xc0,
  0x00, 0x9e, 0x1f, 0x3f, 0xfe, 0xf9, 0xf0, 0x3f, 0xff, 0xe1, 0xff, 0xdf,
  0xff, 0xf7, 0xfe, 0xff, 0xff, 0xfe, 0x1f, 0xdf, 0xff, 0xf7, 0xfe, 0xff,
  0xff, 0xff, 0xe0, 0x3f, 0xff, 0xf8, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 7 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_7[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xfa, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe3, 0x7f, 0xff, 0xff,
  0xfe, 0x00, 0x00, 0x01, 0xf3, 0x8b, 0xff, 0xff, 0xff, 0x80, 0x00, 0x03,
  0xcb, 0xc4, 0x3f, 0xff, 0xff, 0xf8, 0x00, 0x03, 0xd3, 0xe4, 0x00, 0xff,
  0xff, 0xff, 0x00, 0x00, 0x1f, 0xf6, 0x00, 0x1f, 0x7f, 0xff, 0xe0, 0x03,
  0xff, 0xfb, 0x00, 0x3f, 0x3f, 0xff, 0xf0, 0x07, 0xff, 0xff, 0x80, 0x3f,
  0x9f, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0xc0, 0x7f, 0x8f, 0xff, 0xc0, 0x1f,
  0xff, 0xff, 0xc0, 0x7f, 0x87, 0xff, 0x00, 0x7f, 0xff, 0xff, 0xe0, 0x7f,
  0xc3, 0xfe, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x3f, 0xc0, 0xfc, 0x00, 0x1f,
  0xff, 0xff, 0xf8, 0x1f, 0xc0, 0x7e, 0x00, 0x0f, 0xff, 0xff, 0xf9, 0x9f,
  0xe0, 0x3f, 0xc0, 0x07, 0xff, 0xff, 0xfd, 0xef, 0xe0, 0x1f, 0xf8, 0x03,
  0xff, 0xff, 0xfd, 0xff, 0xe0, 0x0f, 0xfb, 0x01, 0xff, 0xff, 0xfd, 0xff,
  0xe0, 0x07, 0xe7, 0xe0, 0xff, 0xff, 0xfd, 0xff, 0xf0, 0x07, 0x9f, 0xff,
  0xcf, 0xff, 0xfe, 0xff, 0xf0, 0x07, 0xe1, 0xff, 0xc1, 0xff, 0xe6, 0xff,
  0xf0, 0x07, 0xfe, 0x7f, 0xf0, 0x7f, 0xc6, 0xf7, 0xf8, 0x07, 0xfe, 0xff,
  0xfe, 0x79, 0xde, 0xab, 0xf8, 0x07, 0xfd, 0xff, 0xff, 0xf9, 0xff, 0x5f,
  0xf8, 0x07, 0xf3, 0xff, 0xff, 0xfd, 0xff, 0x7f, 0xfc, 0x07, 0xef, 0xff,
  0xff, 0xf8, 0xff, 0xbf, 0xfc, 0x03, 0xd8, 0xff, 0xff, 0xc7, 0x3f, 0xbf,
  0xfc, 0x03, 0x85, 0xf3, 0xff, 0x8f, 0x3f, 0xdf, 0xfe, 0x03, 0xfb, 0x01,
  0xff, 0xf0, 0xf8, 0x1f, 0xf8, 0x03, 0xf8, 0x60, 0xff, 0xff, 0xf7, 0xff,
  0xc0, 0x03, 0xfc, 0xe7, 0x0f, 0xfe, 0x0f, 0xff, 0xe0, 0x03, 0xf3, 0xf7,
  0x80, 0x00, 0x5b, 0xef, 0xe0, 0x03, 0xef, 0xf7, 0x07, 0x08, 0x25, 0xd7,
  0xf0, 0x03, 0xcf, 0xf6, 0x07, 0x0c, 0x35, 0x37, 0xf0, 0x03, 0xf1, 0xf8,
  0x0f, 0x0e, 0x36, 0xfb, 0xf8, 0x1f, 0xc3, 0xfc, 0x0f, 0x06, 0x37, 0xff,
  0xf8, 0x0f, 0xbf, 0xde, 0x1f, 0x07, 0x77, 0xff, 0xfc, 0x0f, 0x0f, 0xdf,
  0x0f, 0x04, 0xdb, 0xff, 0xfc, 0x07, 0xdf, 0xdf, 0xf0, 0x03, 0xdb, 0xff,
  0xfe, 0x06, 0x3f, 0xdf, 0xfb, 0xdf, 0xd7, 0xff, 0xfe, 0x04, 0xff, 0xe7,
  0xeb, 0xd7, 0xdb, 0xff, 0xff, 0x03, 0xff, 0xeb, 0xc3, 0xc1, 0xbc, 0xff,
  0xff, 0x00, 0x7f, 0xf5, 0x83, 0xc0, 0x7f, 0x7f, 0xff, 0x80, 0xff, 0xfa,
  0x03, 0xc0, 0x7f, 0xbf, 0xff, 0x81, 0xff, 0xfb, 0x07, 0xc0, 0xfe, 0x7f,
  0xff, 0xc3, 0xff, 0xfd, 0x8f, 0xe1, 0xff, 0xbf, 0xff, 0xc3, 0xff, 0xfd,
  0xff, 0xfd, 0xff, 0xdf, 0xff, 0xe3, 0xff, 0xfe, 0xdf, 0xbd, 0xff, 0xcf,
  0xff, 0xf3, 0xff, 0xfe, 0x9f, 0x3b, 0xff, 0x3f, 0xff, 0xf7, 0xff, 0xfe,
  0x5e, 0xdb, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xff, 0xde, 0xd7, 0xff, 0x7f,
  0xff, 0xd7, 0xff, 0xff, 0xdd, 0xef, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xfd,
  0xe3, 0xdf, 0xfe, 0xff, 0xfe, 0x5b, 0xff, 0xfb, 0xff, 0xbf, 0xfd, 0xff,
  0xfe, 0x9c, 0xff, 0xf7, 0xff, 0x7f, 0xe0, 0xff, 0xfe, 0xfe, 0x0f, 0xc0,
  0x00, 0x9e, 0x1f, 0x3f, 0xfe, 0xf9, 0xf0, 0x3f, 0xff, 0xe1, 0xff, 0xdf,
  0xff, 0xf7, 0xfe, 0xff, 0xff, 0xfe, 0x1f, 0xdf, 0xff, 0xf7, 0xfe, 0xff,
  0xff, 0xff, 0xe0, 0x3f, 0xff, 0xf8, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 8 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_8[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xf5, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc6, 0xff, 0xff, 0xff,
  0xfc, 0x00, 0x00, 0x03, 0xe7, 0x17, 0xff, 0xff, 0xff, 0x00, 0x00, 0x07,
  0x97, 0x88, 0x7f, 0xff, 0xff, 0xf0, 0x00, 0x07, 0xa7, 0xc8, 0x01, 0xff,
  0xff, 0xfe, 0x00, 0x00, 0x3f, 0xec, 0x00, 0x3f, 0xff, 0xff, 0xc0, 0x07,
  0xff, 0xf6, 0x00, 0x7f, 0xfd, 0xff, 0xe0, 0x0f, 0xff, 0xff, 0x00, 0x7f,
  0xfc, 0xff, 0xc0, 0x1f, 0xff, 0xff, 0x80, 0xff, 0xfc, 0xff, 0x80, 0x3f,
  0xff, 0xff, 0x80, 0xff, 0xfc, 0x7e, 0x00, 0xff, 0xff, 0xff, 0xc0, 0xff,
  0xfc, 0x3c, 0x00, 0x7f, 0xff, 0xff, 0xe0, 0x7f, 0xfc, 0x38, 0x00, 0x3f,
  0xff, 0xff, 0xf0, 0x3f, 0xfc, 0x1c, 0x00, 0x1f, 0xff, 0xff, 0xf3, 0x3f,
  0xfc, 0x0f, 0x80, 0x0f, 0xff, 0xff, 0xfb, 0xdf, 0xfc, 0x07, 0xf0, 0x07,
  0xff, 0xff, 0xfb, 0xff, 0xfc, 0x07, 0xf6, 0x03, 0xff, 0xff, 0xfb, 0xff,
  0xfc, 0x03, 0xcf, 0xc1, 0xff, 0xff, 0xfb, 0xff, 0xfc, 0x01, 0x3f, 0xff,
  0x9f, 0xff, 0xfd, 0xff, 0xfe, 0x01, 0xc3, 0xff, 0x83, 0xff, 0xcd, 0xff,
  0xfe, 0x00, 0xfc, 0xff, 0xe0, 0xff, 0x8d, 0xef, 0xfe, 0x00, 0xfd, 0xff,
  0xfc, 0xf3, 0xbd, 0x57, 0xfe, 0x00, 0xfb, 0xff, 0xff, 0xf3, 0xfe, 0xbf,
  0xfe, 0x00, 0xe7, 0xff, 0xff, 0xfb, 0xfe, 0xff, 0xfe, 0x00, 0xdf, 0xff,
  0xff, 0xf1, 0xff, 0x7f, 0xfe, 0x00, 0xb1, 0xff, 0xff, 0x8e, 0x7f, 0x7f,
  0xfe, 0x00, 0x0b, 0xe7, 0xff, 0x1e, 0x7f, 0xbf, 0xfe, 0x00, 0xf6, 0x03,
  0xff, 0xe1, 0xf0, 0x3f, 0xfe, 0x01, 0xf0, 0xc1, 0xff, 0xff, 0xef, 0xff,
  0xfc, 0x01, 0xf9, 0xce, 0x1f, 0xfc, 0x1f, 0xff, 0xf0, 0x01, 0xe7, 0xef,
  0x00, 0x00, 0xb7, 0xdf, 0xc0, 0x01, 0xdf, 0xee, 0x0e, 0x10, 0x4b, 0xaf,
  0x80, 0x01, 0x9f, 0xec, 0x0e, 0x18, 0x6a, 0x6f, 0xc0, 0x01, 0xe3, 0xf0,
  0x1e, 0x1c, 0x6d, 0xf7, 0xe0, 0x01, 0xc7, 0xf8, 0x1e, 0x0c, 0x6f, 0xff,
  0xe0, 0x01, 0xbf, 0xbc, 0x3e, 0x0e, 0xef, 0xff, 0xf0, 0x07, 0x0f, 0xbe,
  0x1e, 0x09, 0xb7, 0xff, 0xf8, 0x0f, 0xdf, 0xbf, 0xe0, 0x07, 0xb7, 0xff,
  0xfc, 0x0e, 0x3f, 0xbf, 0xf7, 0xbf, 0xaf, 0xff, 0xfc, 0x04, 0xff, 0xcf,
  0xd7, 0xaf, 0xb7, 0xff, 0xfe, 0x03, 0xff, 0xd7, 0x87, 0x83, 0x79, 0xff,
  0xff, 0x00, 0x7f, 0xeb, 0x07, 0x80, 0xfe, 0xff, 0xff, 0x80, 0xff, 0xf4,
  0x07, 0x80, 0xfe, 0x7f, 0xff, 0xc1, 0xff, 0xf2, 0x0f, 0x81, 0xff, 0x7f,
  0xff, 0xc1, 0xff, 0xfd, 0x1f, 0xc1, 0xff, 0xbf, 0xff, 0xe3, 0xff, 0xfd,
  0xff, 0xfd, 0xff, 0xdf, 0xff, 0xf3, 0xff, 0xfe, 0xdf, 0xbd, 0xff, 0xcf,
  0xff, 0xfb, 0xff, 0xfe, 0x9f, 0x3b, 0xff, 0x3f, 0xff, 0xf7, 0xff, 0xfe,
  0x5e, 0xdb, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xff, 0xde, 0xd7, 0xff, 0x7f,
  0xff, 0xd7, 0xff, 0xff, 0xdd, 0xef, 0xff, 0x7f, 0xff, 0xd7, 0xff, 0xfd,
  0xe3, 0xdf, 0xfe, 0xff, 0xfe, 0x5b, 0xff, 0xfb, 0xff, 0xbf, 0xfd, 0xff,
  0xfe, 0x9c, 0xff, 0xf7, 0xff, 0x7f, 0xe0, 0xff, 0xfe, 0xfe, 0x0f, 0xc0,
  0x00, 0x9e, 0x1f, 0x3f, 0xfe, 0xf9, 0xf0, 0x3f, 0xff, 0xe1, 0xff, 0xdf,
  0xff, 0xf7, 0xfe, 0xff, 0xff, 0xfe, 0x1f, 0xdf, 0xff, 0xf7, 0xfe, 0xff,
  0xff, 0xff, 0xe0, 0x3f, 0xff, 0xf8, 0x01, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 9 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_9[] = {
  0xff, 0x01, 0xff, 0xff, 0xc2, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x07, 0xff,
  0xe3, 0x0f, 0xff, 0xff, 0xff, 0xf0, 0x00, 0x0f, 0xf3, 0x80, 0x3f, 0xff,
  0xff, 0xfc, 0x00, 0x00, 0xcb, 0xc4, 0x00, 0xff, 0xff, 0xff, 0x00, 0x01,
  0xd3, 0xe4, 0x00, 0x1f, 0xfe, 0xff, 0xc0, 0x02, 0x1f, 0xf6, 0x00, 0x1f,
  0xfe, 0xff, 0xe0, 0x01, 0xff, 0xfb, 0x00, 0x3f, 0xfc, 0x7f, 0xf0, 0x03,
  0xff, 0xff, 0x80, 0x3f, 0xfc, 0x7f, 0xe0, 0x07, 0xff, 0xff, 0xc0, 0x7f,
  0xf8, 0x7f, 0xc0, 0x0f, 0xff, 0xff, 0xc0, 0x7f, 0xf8, 0x3f, 0x00, 0x1f,
  0xff, 0xff, 0xe0, 0x3f, 0xf8, 0x3e, 0x00, 0x1f, 0xff, 0xff, 0xf0, 0x1f,
  0xf0, 0x3c, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xf0, 0x1e, 0x00, 0x0f,
  0xff, 0xff, 0xf8, 0x0f, 0xf0, 0x1f, 0xc0, 0x07, 0xf1, 0xff, 0xfd, 0x07,
  0xe0, 0x1f, 0xf8, 0x03, 0xe0, 0xff, 0xe5, 0xf3, 0xe0, 0x1f, 0xfb, 0x01,
  0xc0, 0x7f, 0xc1, 0xff, 0xc0, 0x0f, 0xe7, 0xe0, 0xdb, 0x7f, 0xd1, 0xff,
  0xc0, 0x0f, 0x9f, 0xff, 0xdf, 0x7f, 0xda, 0xff, 0xc0, 0x0f, 0xe1, 0xff,
  0xce, 0x7f, 0xda, 0xff, 0x80, 0x07, 0xfe, 0x7f, 0xc4, 0x7f, 0xca, 0xf7,
  0x80, 0x07, 0xfe, 0xff, 0xe0, 0xfe, 0x42, 0xab, 0xc0, 0x07, 0xfd, 0xff,
  0xf1, 0xde, 0x67, 0x5f, 0xe0, 0x03, 0xf3, 0xff, 0xff, 0xdf, 0x77, 0x7f,
  0xf0, 0x03, 0xef, 0xff, 0xff, 0xee, 0x37, 0xbf, 0xf0, 0x03, 0xd8, 0xff,
  0xff, 0xf1, 0xcf, 0xbf, 0xf8, 0x01, 0x85, 0xf3, 0xff, 0xff, 0xff, 0xdf,
  0xfc, 0x01, 0xfb, 0xc1, 0xff, 0xff, 0xf8, 0x1f, 0xfe, 0x03, 0xf8, 0x00,
  0xff, 0xff, 0xf0, 0xff, 0xfc, 0x03, 0xfc, 0x33, 0x3f, 0xff, 0xc0, 0x7f,
  0xf8, 0x07, 0xf8, 0x3d, 0xcf, 0xfe, 0x20, 0x7f, 0xf0, 0x07, 0xf0, 0x3d,
  0x80, 0x00, 0x70, 0x7f, 0xe0, 0x0f, 0xe8, 0x7d, 0x07, 0x08, 0x30, 0x7f,
  0xc0, 0x0f, 0xcc, 0xfc, 0x07, 0x0c, 0x18, 0xff, 0x80, 0x1f, 0xf2, 0xfc,
  0x0f, 0x0e, 0x39, 0xff, 0xc0, 0x1f, 0xf3, 0x7c, 0x0f, 0x06, 0x37, 0xff,
  0xe0, 0x0f, 0xcf, 0xbe, 0x1f, 0x07, 0x6f, 0xff, 0xe0, 0x0f, 0xbf, 0xdf,
  0x0f, 0x04, 0xf7, 0xff, 0xf0, 0x0f, 0x0f, 0xff, 0xf0, 0x03, 0xfb, 0xff,
  0xf8, 0x07, 0xdf, 0xff, 0xff, 0xff, 0xfb, 0xff, 0xfc, 0x06, 0x3f, 0xff,
  0xff, 0xff, 0xfd, 0xff, 0xfe, 0x04, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xff,
  0xfe, 0x03, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0x00, 0x79, 0xfb,
  0xff, 0xff, 0xff, 0xbf, 0xff, 0x80, 0xf6, 0xfb, 0xff, 0xff, 0xfe, 0x7f,
  0xff, 0xc1, 0xef, 0x7b, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xe3, 0xdf, 0x7d,
  0xff, 0xfd, 0xff, 0xbf, 0xff, 0xe3, 0xdf, 0x7d, 0xff, 0xfd, 0xff, 0xdf,
  0xff, 0xf3, 0xdf, 0xbe, 0xdf, 0xbd, 0xff, 0xcf, 0xff, 0xfb, 0xdf, 0xbe,
  0x9f, 0x3b, 0xff, 0x3f, 0xff, 0xfb, 0xdf, 0xbe, 0x5e, 0xdb, 0xff, 0x7f,
  0xff, 0xfb, 0xdf, 0x7f, 0xde, 0xd7, 0xff, 0x7f, 0xff, 0xfb, 0xdf, 0x7e,
  0xdd, 0xef, 0xff, 0x7f, 0xff, 0xfd, 0xef, 0x7d, 0xe3, 0xdf, 0xfe, 0xff,
  0xff, 0xfe, 0xf0, 0xfb, 0xff, 0xbf, 0xfd, 0xff, 0xff, 0xff, 0x7f, 0xf7,
  0xff, 0x7f, 0xfb, 0xff, 0xff, 0xff, 0x8f, 0xc0, 0x00, 0xbf, 0xf7, 0xff,
  0xff, 0xff, 0xf0, 0x3f, 0xff, 0xbe, 0x0f, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xa1, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xdf, 0xfd, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xe7, 0xfd, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xf8, 0x03, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 10 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_10[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

// Frame 11 bitmap data (512 bytes)
const uint8_t ELECTRIC2_frame_11[] = {
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};

#endif  // ELECTRIC2_H
