// SPDX-FileCopyrightText: 2023 - 2025 KOINSLOT, Inc.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "Kywy.hpp"

Kywy::Engine engine;

const uint8_t splashScreen[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x1c, 0xe6, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
  0xff, 0xff, 0xff, 0xf0, 0x66, 0x38, 0x1c, 0xe6, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x38,
  0x1c, 0xe6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x66, 0x30, 0x03, 0x00, 0x60, 0x7b, 0x32, 0x6c,
  0x9b, 0x26, 0xc9, 0xb2, 0x6c, 0x9b, 0x24, 0xc8, 0xfc, 0x0e, 0x00, 0xc0,
  0x03, 0x00, 0x60, 0x40, 0x32, 0x6c, 0x9b, 0x26, 0xc9, 0x12, 0x6c, 0x9b,
  0x26, 0x08, 0x00, 0x0e, 0x00, 0xc0, 0x03, 0x00, 0x08, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x10, 0x00, 0xc0,
  0x1c, 0x18, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xe0, 0x08, 0x38, 0x1c, 0x18, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x18, 0x28,
  0x00, 0xe6, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x10, 0x66, 0x00, 0x00, 0xe6, 0x18, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x65, 0x00,
  0x00, 0xe6, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0x00, 0x1c, 0x18, 0x20, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x0c, 0x18, 0x38,
  0x1c, 0x18, 0x30, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x00, 0x0c, 0x18, 0x38, 0x1c, 0x00, 0xc0, 0x00, 0x08, 0x80,
  0x00, 0x80, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x02, 0x00, 0x28,
  0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x82, 0x00, 0x20, 0x01, 0x00, 0x00,
  0x04, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x80, 0x08, 0x00, 0x21, 0x10, 0x00, 0x00, 0x00, 0xc0, 0x00,
  0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x80,
  0x00, 0x00, 0x00, 0x20, 0xc0, 0x40, 0x02, 0x0c, 0x00, 0x00, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x40,
  0x01, 0x90, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xe0,
  0x00, 0x00, 0x42, 0x00, 0x19, 0x88, 0x11, 0x98, 0x07, 0x00, 0x04, 0x08,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x19, 0x98,
  0x10, 0x60, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xe0,
  0x00, 0x02, 0x00, 0x00, 0x06, 0x08, 0x10, 0x60, 0x07, 0x00, 0x20, 0x00,
  0x00, 0x00, 0x81, 0x00, 0x03, 0x40, 0x00, 0x40, 0x00, 0x00, 0x06, 0x08,
  0x10, 0x20, 0x07, 0x00, 0x20, 0x40, 0x10, 0x88, 0x00, 0x00, 0x03, 0xe0,
  0x00, 0x00, 0x00, 0x00, 0x06, 0x08, 0x11, 0x80, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x08, 0x00, 0x00, 0xe0, 0x01, 0x88,
  0x11, 0x80, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x20, 0x00,
  0x20, 0x00, 0x00, 0xe1, 0x01, 0x18, 0x12, 0x00, 0x07, 0x01, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0xe0, 0x00, 0x48,
  0x12, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xe0, 0x00, 0x48, 0x12, 0x00, 0x07, 0x00, 0x00, 0x01,
  0xc2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xa0, 0x00, 0x58,
  0x12, 0x00, 0x07, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x20, 0x00, 0xe0, 0x00, 0x48, 0x12, 0x00, 0x47, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0xa0, 0x00, 0x58,
  0x12, 0x00, 0x07, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x22, 0x40, 0x00,
  0x40, 0x00, 0x00, 0xe0, 0x00, 0x58, 0x12, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x10, 0xe0, 0x08, 0x48,
  0x12, 0x00, 0x07, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xe0, 0x00, 0x58, 0x12, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x80, 0x00, 0x00, 0x00, 0x04, 0x00, 0x08, 0x00, 0xe0, 0x00, 0x48,
  0x02, 0x01, 0x07, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xe0, 0x00, 0x58, 0x12, 0x00, 0x07, 0x00, 0x00, 0x02,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x00, 0x00, 0xe0, 0x00, 0x48,
  0x12, 0x00, 0x07, 0x00, 0x44, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00, 0x00,
  0x41, 0x00, 0x80, 0xe0, 0x22, 0x58, 0x12, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x10, 0x10, 0x00, 0x02, 0x00, 0x04, 0x00, 0x00, 0xc0, 0x00, 0x48,
  0x12, 0x00, 0x07, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x01, 0x08, 0x00,
  0x00, 0x00, 0x00, 0xa0, 0x00, 0x58, 0x12, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xe0, 0x00, 0x48,
  0x12, 0x04, 0x27, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xc0, 0x00, 0x58, 0x12, 0x00, 0x07, 0x02, 0x00, 0x00,
  0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0xe0, 0x00, 0x48,
  0x12, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
  0x40, 0x00, 0x00, 0xe0, 0x00, 0x58, 0x12, 0x00, 0x07, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x40, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x40, 0x48,
  0x12, 0x00, 0x05, 0x00, 0x20, 0x21, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04,
  0x01, 0x10, 0x00, 0xa0, 0x04, 0x58, 0x12, 0x00, 0x47, 0x00, 0x01, 0x00,
  0x00, 0x08, 0x00, 0x40, 0x40, 0x00, 0x00, 0x01, 0x00, 0xe0, 0x00, 0x48,
  0x12, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
  0x00, 0x00, 0x00, 0xe0, 0x00, 0x48, 0x12, 0x04, 0x07, 0x00, 0x00, 0x00,
  0x01, 0x07, 0xf8, 0x7f, 0x80, 0x00, 0x00, 0x00, 0x10, 0xe0, 0x00, 0x58,
  0x02, 0x00, 0x07, 0x00, 0x40, 0x00, 0x00, 0x07, 0xf8, 0x6f, 0x80, 0x00,
  0x02, 0x00, 0x00, 0xc0, 0x20, 0x48, 0x12, 0x00, 0x07, 0x01, 0x00, 0x00,
  0x08, 0x1f, 0xf8, 0x5f, 0x60, 0x00, 0x00, 0x00, 0x80, 0xe0, 0x00, 0x58,
  0x12, 0x00, 0x07, 0x00, 0x02, 0x00, 0x00, 0x1d, 0x7c, 0x7f, 0xe1, 0x00,
  0x80, 0x00, 0x00, 0xe0, 0x00, 0x48, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x40, 0x3c, 0x2c, 0x30, 0x78, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x0c, 0x38, 0x3c, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x48, 0x12, 0x01, 0x00, 0x00, 0x00, 0x04,
  0x00, 0x38, 0x0c, 0x38, 0x2c, 0x02, 0x00, 0x02, 0x00, 0x00, 0x01, 0x48,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x28, 0x0c, 0x38, 0x3c, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x08, 0x58, 0x12, 0x01, 0x00, 0x00, 0x01, 0x00,
  0x00, 0x00, 0x0c, 0x38, 0x34, 0x00, 0x00, 0x00, 0x08, 0x00, 0x40, 0x48,
  0x12, 0x00, 0x04, 0x02, 0x04, 0x00, 0x04, 0x00, 0x3c, 0x30, 0x3c, 0x00,
  0x04, 0x00, 0x00, 0x00, 0x00, 0x58, 0x12, 0x00, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x3c, 0x38, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x48,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x7c, 0x28, 0x3c, 0x01,
  0x00, 0x00, 0x00, 0x04, 0x00, 0x58, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x78, 0x38, 0x3c, 0x04, 0x00, 0x10, 0x00, 0x00, 0x00, 0x58,
  0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xe0, 0x38, 0x3c, 0x00,
  0x00, 0x40, 0x00, 0x20, 0x00, 0x48, 0x12, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x01, 0x0f, 0xe0, 0x28, 0x3c, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x58,
  0x12, 0x00, 0x08, 0x00, 0x00, 0x00, 0x04, 0x0d, 0x80, 0x38, 0x3c, 0x00,
  0x04, 0x00, 0x02, 0x00, 0x00, 0x58, 0x12, 0x00, 0x00, 0x04, 0x00, 0x01,
  0x00, 0x0f, 0x00, 0x38, 0x3c, 0x00, 0x00, 0x00, 0x80, 0x00, 0x10, 0x58,
  0x12, 0x00, 0x0c, 0x99, 0x36, 0x4c, 0x9b, 0x1f, 0x06, 0x28, 0x78, 0xc9,
  0xb3, 0x64, 0xd9, 0x30, 0x00, 0x48, 0x12, 0x00, 0x08, 0x99, 0x36, 0x4c,
  0x93, 0x3c, 0x06, 0x38, 0x78, 0xc9, 0x93, 0x44, 0xd9, 0x30, 0x00, 0x58,
  0x12, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x5f, 0xc0, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3f, 0xfa, 0x77, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x48,
  0x10, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x37, 0xf6, 0x3e, 0x80, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x10, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18,
  0x10, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x58,
  0x12, 0x00, 0x07, 0xff, 0xfc, 0xff, 0xfc, 0xfc, 0x1b, 0xef, 0x81, 0xfc,
  0xff, 0x00, 0xf1, 0xc0, 0x20, 0x48, 0x11, 0x80, 0x07, 0xef, 0xe8, 0xfb,
  0xf4, 0xfc, 0x0e, 0xed, 0xc1, 0xfc, 0xff, 0x0b, 0xfd, 0xc0, 0x00, 0x98,
  0x11, 0x80, 0x07, 0xff, 0xbc, 0xdf, 0xfc, 0xae, 0x0f, 0xef, 0xe1, 0x7c,
  0xdb, 0x0f, 0xed, 0xc0, 0x80, 0x98, 0x01, 0x84, 0x06, 0xfd, 0xfc, 0x7e,
  0xbc, 0xfd, 0x0e, 0xef, 0x61, 0xec, 0xff, 0x0f, 0xfe, 0xc0, 0x00, 0x80,
  0x02, 0x40, 0x07, 0xf7, 0xe8, 0x78, 0x1c, 0x37, 0x05, 0x83, 0xe0, 0x70,
  0x38, 0x1b, 0x8f, 0x80, 0x02, 0x40, 0x02, 0x40, 0x07, 0x0e, 0x1c, 0x58,
  0x14, 0x1b, 0x07, 0x83, 0xd0, 0x60, 0x3c, 0x1e, 0x03, 0xc0, 0x02, 0x40,
  0x04, 0x20, 0x07, 0x0a, 0x08, 0x78, 0x1c, 0x3f, 0x87, 0x83, 0x70, 0x70,
  0x24, 0x1e, 0x03, 0xc0, 0x04, 0x20, 0x1b, 0x18, 0x16, 0x0e, 0x1c, 0x58,
  0x1c, 0x3b, 0x86, 0x83, 0xf0, 0x70, 0x3c, 0x1e, 0x01, 0x80, 0x18, 0xc8,
  0x1b, 0x18, 0x40, 0x06, 0x00, 0x78, 0x00, 0x3f, 0xc7, 0x82, 0xec, 0x70,
  0x3c, 0x1b, 0x80, 0x40, 0x18, 0xc8, 0x04, 0x20, 0x00, 0x0e, 0x00, 0x68,
  0x00, 0x3d, 0xc7, 0x83, 0xbc, 0x70, 0x34, 0x1f, 0x80, 0x01, 0x04, 0x20,
  0x04, 0x60, 0x00, 0x0e, 0x00, 0x78, 0x60, 0x33, 0xc6, 0x83, 0xbe, 0x70,
  0x3c, 0x0b, 0xc0, 0x00, 0x03, 0x40, 0x02, 0x40, 0x00, 0x0e, 0x00, 0x7f,
  0xe0, 0x3b, 0xe7, 0x83, 0xba, 0x60, 0x2c, 0x0f, 0xf0, 0x00, 0x03, 0x40,
  0x01, 0x80, 0x00, 0x0e, 0x00, 0x7f, 0xe0, 0x39, 0xe6, 0x83, 0x97, 0x70,
  0x3c, 0x03, 0x7c, 0x00, 0x00, 0x80, 0x11, 0x80, 0x00, 0x0e, 0x00, 0x5b,
  0xe0, 0x39, 0xf7, 0x83, 0x9f, 0x70, 0x3c, 0x01, 0xbf, 0x00, 0x00, 0x98,
  0x12, 0x00, 0x00, 0x0e, 0x00, 0x7e, 0xe0, 0x39, 0x57, 0x83, 0x0f, 0x50,
  0x3c, 0x00, 0xfb, 0x00, 0x00, 0x58, 0x12, 0x00, 0x00, 0x0a, 0x00, 0x68,
  0x40, 0x38, 0xf6, 0x83, 0x8f, 0xf0, 0x3c, 0x00, 0x17, 0x81, 0x00, 0x18,
  0x12, 0x00, 0x04, 0x0e, 0x00, 0x70, 0x00, 0x38, 0xb7, 0x83, 0x8e, 0xd0,
  0x30, 0x00, 0x07, 0xc4, 0x00, 0x58, 0x10, 0x00, 0x40, 0x0e, 0x00, 0x78,
  0x00, 0x38, 0x7e, 0x83, 0x87, 0xf0, 0x3c, 0x00, 0x01, 0xc0, 0x04, 0x18,
  0x10, 0x06, 0x00, 0x0e, 0x00, 0x78, 0x00, 0x38, 0x7f, 0x83, 0x87, 0xf0,
  0x3c, 0x1c, 0x03, 0x80, 0x00, 0x18, 0x10, 0x04, 0x00, 0x06, 0x01, 0x78,
  0x00, 0x38, 0x3f, 0x83, 0x82, 0xb0, 0x3c, 0x1c, 0x03, 0xc0, 0x00, 0x18,
  0x12, 0x00, 0x00, 0x0e, 0x00, 0x68, 0x1c, 0x30, 0x3d, 0x83, 0x83, 0xf0,
  0x38, 0x1e, 0x03, 0xc0, 0x00, 0x58, 0x12, 0x00, 0x00, 0x8e, 0x00, 0x58,
  0x3c, 0x30, 0x17, 0x83, 0x01, 0x70, 0x3c, 0x1b, 0x85, 0xc0, 0x10, 0x58,
  0x12, 0x00, 0x00, 0x0e, 0x00, 0x78, 0x2c, 0x38, 0x1d, 0x83, 0x81, 0xf0,
  0x3c, 0x1f, 0x87, 0xc0, 0x00, 0x58, 0x10, 0x00, 0x00, 0x7b, 0xc0, 0xf7,
  0xfc, 0xf6, 0x1f, 0x0f, 0xc0, 0xf0, 0xf7, 0x1d, 0xfd, 0x00, 0x10, 0x48,
  0x12, 0x00, 0x00, 0x37, 0xc0, 0xff, 0x7c, 0xdc, 0x0f, 0x8e, 0xe0, 0xb0,
  0xff, 0x1d, 0xef, 0x00, 0x00, 0x58, 0x12, 0x00, 0x00, 0x3e, 0xc0, 0xff,
  0x7c, 0xfc, 0x0f, 0x8f, 0xc0, 0xf0, 0xbf, 0x1c, 0xf4, 0x00, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x2f, 0xc0, 0xaa, 0xd4, 0xdc, 0x0c, 0x8a, 0xc0, 0xd0,
  0xde, 0x1c, 0x5c, 0x00, 0x00, 0x48, 0x12, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x58,
  0x12, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x00, 0x48, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x12, 0x00, 0x40, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x12, 0x04, 0x00, 0x00, 0x00, 0x20,
  0x80, 0x00, 0x00, 0x40, 0x02, 0x00, 0x00, 0x08, 0x00, 0x00, 0x01, 0x50,
  0x12, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x02, 0x00, 0x00,
  0x30, 0x40, 0x00, 0x02, 0x00, 0x18, 0x12, 0x00, 0x00, 0x02, 0x00, 0x00,
  0x00, 0x08, 0x00, 0x00, 0x10, 0x00, 0x20, 0x00, 0x40, 0x00, 0x00, 0x48,
  0x12, 0x00, 0x08, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x04, 0x00, 0x08, 0x58, 0x10, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x09, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x10, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x00, 0x00, 0x02, 0x00, 0x58, 0x02, 0x01, 0x00, 0x10, 0x00, 0x00,
  0x20, 0x80, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x00, 0x80, 0x80, 0x00, 0x00, 0x58, 0x12, 0x00, 0x00, 0x00, 0x00, 0x20,
  0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x48,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x20, 0x00, 0x58, 0x12, 0x04, 0x10, 0x00, 0x40, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x48,
  0x12, 0x00, 0x00, 0x41, 0x03, 0xcf, 0x9f, 0x3c, 0xf0, 0x39, 0xf9, 0xc7,
  0xdf, 0x82, 0x02, 0x00, 0x00, 0x58, 0x02, 0x00, 0x00, 0x00, 0x02, 0x6c,
  0xd0, 0x6c, 0x90, 0x4c, 0x63, 0x26, 0x42, 0x00, 0x00, 0x00, 0x20, 0x58,
  0x12, 0x02, 0x00, 0x00, 0x02, 0x6c, 0xd0, 0x40, 0x80, 0x40, 0x63, 0x26,
  0x42, 0x00, 0x00, 0x00, 0x00, 0x48, 0x12, 0x00, 0x00, 0x00, 0x02, 0x4c,
  0xd6, 0x70, 0xc0, 0x70, 0x62, 0x26, 0x42, 0x00, 0x00, 0x00, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x00, 0x03, 0xef, 0xde, 0x38, 0xf0, 0x28, 0x62, 0x27,
  0xc2, 0x00, 0x00, 0x04, 0x00, 0x48, 0x12, 0x00, 0x00, 0x02, 0x03, 0xce,
  0x10, 0x04, 0x10, 0x0c, 0x63, 0xe7, 0x82, 0x00, 0x18, 0x00, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x80, 0x02, 0x0d, 0xc0, 0x64, 0x90, 0x0c, 0x62, 0x22,
  0x82, 0x00, 0x00, 0x20, 0x20, 0x58, 0x12, 0x00, 0x08, 0x00, 0x02, 0x0c,
  0xde, 0x7c, 0xf0, 0x78, 0x62, 0x26, 0x42, 0x00, 0x00, 0x00, 0x10, 0x48,
  0x12, 0x04, 0x00, 0x00, 0x02, 0x0c, 0xdb, 0x38, 0xf0, 0x38, 0x62, 0x26,
  0x42, 0x01, 0x00, 0x00, 0x00, 0x58, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x48,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x58, 0x12, 0x00, 0x10, 0x08, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x02, 0x00, 0x80, 0x48,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x00, 0x58, 0x12, 0x00, 0x00, 0x20, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x48,
  0x12, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x01, 0x48, 0x02, 0x00, 0x43, 0x00, 0x20, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x58,
  0x12, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
  0x00, 0x40, 0x00, 0x00, 0x00, 0x48, 0x12, 0x00, 0x00, 0x00, 0x00, 0x08,
  0x20, 0x00, 0x20, 0x01, 0x00, 0x10, 0x01, 0x00, 0x40, 0x0c, 0x00, 0x58,
  0x12, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x84, 0x00, 0x00, 0x01, 0x00,
  0x20, 0x01, 0x00, 0x00, 0x02, 0x58, 0x11, 0x80, 0x00, 0x00, 0x00, 0x00,
  0x60, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x48,
  0x01, 0x80, 0x00, 0x00, 0x02, 0x00, 0x40, 0x00, 0x02, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x21, 0x98, 0x10, 0x60, 0x00, 0x00, 0x10, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x18,
  0x10, 0x60, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00,
  0x00, 0x00, 0x02, 0x00, 0x02, 0x08, 0x10, 0x60, 0x08, 0x80, 0x00, 0x00,
  0x00, 0x00, 0x40, 0x02, 0x02, 0x08, 0x80, 0x00, 0x00, 0x00, 0x02, 0x18,
  0x11, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x43, 0x00, 0x00, 0x19, 0x88, 0x11, 0x38, 0x00, 0x00, 0x00, 0x01,
  0x04, 0x20, 0x00, 0x00, 0x10, 0x00, 0x02, 0x02, 0x00, 0x00, 0x09, 0x88,
  0x02, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x02, 0x20, 0x40, 0x02, 0x03, 0x00, 0x06, 0x00, 0x00,
  0x00, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x02, 0x08, 0xc0, 0x40,
  0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x04, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x20, 0x00, 0x08, 0x03, 0x00, 0x00,
  0x00, 0x00, 0x84, 0x20, 0x00, 0x00, 0x02, 0x00, 0x00, 0x04, 0x00, 0x08,
  0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x1c, 0x18, 0x30, 0x00, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x20, 0x00, 0x04, 0x18, 0x38,
  0x1c, 0x18, 0x20, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 0x00,
  0x08, 0x81, 0x00, 0x04, 0x18, 0x38, 0x00, 0xe6, 0x08, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x18, 0x67, 0x00,
  0x00, 0xe6, 0x08, 0x00, 0x08, 0x80, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x18, 0x67, 0x00, 0x00, 0xe6, 0x08, 0x00, 0x40, 0x40,
  0x40, 0x10, 0x21, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x27, 0x00,
  0x1c, 0x18, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0xe0, 0x18, 0x38, 0x1c, 0x18, 0x06, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 0x00, 0xe0, 0x18, 0x38,
  0x03, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x08,
  0x00, 0x00, 0x21, 0x10, 0x00, 0xc0, 0x03, 0x00, 0x48, 0x80, 0x22, 0x08,
  0x9a, 0x00, 0x00, 0x10, 0x00, 0x10, 0x04, 0x40, 0x02, 0x16, 0x00, 0xc0,
  0x03, 0x00, 0x70, 0x7f, 0x32, 0x6c, 0x9b, 0x26, 0xc9, 0xb2, 0x6c, 0x9b,
  0x26, 0xc8, 0xfe, 0x0e, 0x00, 0xc0, 0x1c, 0x26, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x67, 0x38,
  0x1c, 0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x67, 0x38, 0x1c, 0x66, 0x0f, 0xbf, 0xff, 0xff,
  0xff, 0xfe, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xdf, 0xfb, 0xf0, 0x67, 0x28,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

class gameManager : public Actor::Actor {
public:
  bool startScreen = true;
  int highScore = 0;

  int score, opponentScore;
  bool gameOver, inPoint;
  int yDirection;

  int ballX, ballY, ballXVelocity, ballYVelocity;

  static const int movesPerTick = 4;
  static const int ballRadius = 5;
  static const int paddleLength = 30;
  static const int paddleWidth = 5;
  static const int screenBorder = 2;

  int paddleY, opponentPaddleY;

  void preparePoint() {
    engine.display.clear();
    unsubscribe(&engine.clock);
    inPoint = false;
    paddleY = KYWY_DISPLAY_HEIGHT / 2 - paddleLength / 2;
    opponentPaddleY = paddleY;
    ballX = KYWY_DISPLAY_WIDTH / 2;
    ballY = KYWY_DISPLAY_HEIGHT / 2;
    ballXVelocity = 0;
    ballYVelocity = 0;
    yDirection = 0;
    drawPaddlesAndBall();
    drawScore();
  }

  void startGame() {
    gameOver = false;
    score = 0;
    opponentScore = 0;
    preparePoint();
    countdown();
  };

  void endGame() {
    unsubscribe(&engine.clock);
    gameOver = true;
    engine.display.clear();
    if (score >= 5) {
      engine.display.drawText(5, 5, "You win!");
    } else {
      engine.display.drawText(5, 5, "You lose...");
    }
    char msg[32];
    snprintf(msg, sizeof(msg), "Score: %d - %d", (uint16_t)score, (uint16_t)opponentScore);
    engine.display.drawText(5, 18, msg);
    engine.display.drawText(5, 45, "Press left button");
    engine.display.drawText(5, 55, "to try again.");
    engine.display.update();
  }

  void initialize() {
    engine.display.drawBitmap(0, 0, KYWY_DISPLAY_WIDTH, KYWY_DISPLAY_HEIGHT, (uint8_t *)splashScreen);
    engine.display.update();
    subscribe(&engine.input);
  }

  void drawPaddlesAndBall() {
    engine.display.fillRectangle(screenBorder, paddleY, paddleWidth, paddleLength);
    engine.display.fillRectangle(KYWY_DISPLAY_WIDTH - screenBorder - paddleWidth, opponentPaddleY, paddleWidth, paddleLength);
    if (inPoint) {
      engine.display.fillCircle(ballX, ballY, ballRadius * 2 + 1, Display::Object2DOptions().origin(Display::Origin::Object2D::CENTER));
    }
  }

  void drawScore() {
    char msg[24];
    snprintf(msg, sizeof(msg), "%d - %d", (uint16_t)score, (uint16_t)opponentScore);
    engine.display.drawText(KYWY_DISPLAY_WIDTH / 2, 8, msg, Display::TextOptions().origin(Display::Origin::Text::CENTER));
  }

  void countdown() {
    engine.display.fillRectangle(KYWY_DISPLAY_WIDTH / 2, KYWY_DISPLAY_HEIGHT / 2, 10, 10, Display::Object2DOptions().origin(Display::Origin::Object2D::CENTER).color(WHITE));
    engine.display.drawText(KYWY_DISPLAY_WIDTH / 2, KYWY_DISPLAY_HEIGHT / 2, "3", Display::TextOptions().origin(Display::Origin::Text::CENTER));
    engine.display.update();
    delay(500);
    engine.display.fillRectangle(KYWY_DISPLAY_WIDTH / 2, KYWY_DISPLAY_HEIGHT / 2, 10, 10, Display::Object2DOptions().origin(Display::Origin::Object2D::CENTER).color(WHITE));
    engine.display.drawText(KYWY_DISPLAY_WIDTH / 2, KYWY_DISPLAY_HEIGHT / 2, "2", Display::TextOptions().origin(Display::Origin::Text::CENTER));
    engine.display.update();
    delay(500);
    engine.display.fillRectangle(KYWY_DISPLAY_WIDTH / 2, KYWY_DISPLAY_HEIGHT / 2, 10, 10, Display::Object2DOptions().origin(Display::Origin::Object2D::CENTER).color(WHITE));
    engine.display.drawText(KYWY_DISPLAY_WIDTH / 2, KYWY_DISPLAY_HEIGHT / 2, "1", Display::TextOptions().origin(Display::Origin::Text::CENTER));
    engine.display.update();
    delay(500);
    engine.display.fillRectangle(KYWY_DISPLAY_WIDTH / 2, KYWY_DISPLAY_HEIGHT / 2, 10, 10, Display::Object2DOptions().origin(Display::Origin::Object2D::CENTER).color(WHITE));
    engine.display.update();
    ballXVelocity = random(2) == 1 ? -5 : 5;
    ballYVelocity = (random(2) == 1 ? -1 : 1) * random(3);
    inPoint = true;
    subscribe(&engine.clock);
  }

  void handle(::Actor::Message *message) {
    int distanceFromMiddleOfOpponentPaddle;

    switch (message->signal) {
      case Kywy::Events::D_PAD_UP_PRESSED:
        yDirection = -1;
        break;
      case Kywy::Events::D_PAD_UP_RELEASED:
        yDirection = 0;
        break;
      case Kywy::Events::D_PAD_DOWN_PRESSED:
        yDirection = 1;
        break;
      case Kywy::Events::D_PAD_DOWN_RELEASED:
        yDirection = 0;
        break;
      case Kywy::Events::TICK:
        // move paddle
        paddleY += yDirection * movesPerTick;

        if (paddleY < screenBorder) {
          paddleY = screenBorder;
        }

        if (paddleY > KYWY_DISPLAY_HEIGHT - screenBorder - paddleLength) {
          paddleY = KYWY_DISPLAY_HEIGHT - screenBorder - paddleLength;
        }

        // move opponent paddle
        distanceFromMiddleOfOpponentPaddle = ballY - (opponentPaddleY + paddleLength / 2);
        if (distanceFromMiddleOfOpponentPaddle > 5) {
          opponentPaddleY += movesPerTick;
        } else if (distanceFromMiddleOfOpponentPaddle < -5) {
          opponentPaddleY -= movesPerTick;
        }

        // move ball
        ballX += ballXVelocity;
        ballY += ballYVelocity;

        if ((ballX - ballRadius <= screenBorder + paddleWidth) && (ballY >= paddleY - ballRadius) && (ballY <= paddleY + paddleLength + ballRadius)) {  // paddle collision
          ballX = screenBorder + paddleWidth + ballRadius - 2;                                                                                          // look like it hit the paddle

          ballXVelocity = abs(ballXVelocity);                                                                      // bounce back
          ballYVelocity = (int)(((float)(ballY - (paddleY + paddleLength / 2)) / (float)(paddleLength / 2)) * 5);  // change angle based on y velocity
        }

        if ((ballX + ballRadius >= KYWY_DISPLAY_WIDTH - screenBorder - paddleWidth) && (ballY >= opponentPaddleY - ballRadius) && (ballY <= opponentPaddleY + paddleLength + ballRadius)) {  // opponent paddle collision
          ballX = KYWY_DISPLAY_WIDTH - screenBorder - paddleWidth - ballRadius + 2;                                                                                                          // look like it hit the paddle

          ballXVelocity = -1 * abs(ballXVelocity);                                                                         // bounce back
          ballYVelocity = (int)(((float)(ballY - (opponentPaddleY + paddleLength / 2)) / (float)(paddleLength / 2)) * 5);  // change angle based on y velocity
        }

        if (ballX - ballRadius <= screenBorder) {  // left wall collision
          ballX = screenBorder + ballRadius;
          ballXVelocity = abs(ballXVelocity);
          opponentScore += 1;
          if (opponentScore >= 5) {
            endGame();
            return;
          }
          preparePoint();
          countdown();
          return;
        }

        if (ballX >= KYWY_DISPLAY_WIDTH - screenBorder - ballRadius) {  // right wall collision
          ballX = KYWY_DISPLAY_WIDTH - screenBorder - ballRadius;
          ballXVelocity = -1 * abs(ballXVelocity);
          score += 1;
          if (score >= 5) {
            endGame();
            return;
          }
          preparePoint();
          countdown();
          return;
        }

        if (ballY - ballRadius <= screenBorder) {  // top wall collision
          ballY = screenBorder + ballRadius;
          ballYVelocity = abs(ballYVelocity);
        }

        if (ballY >= KYWY_DISPLAY_HEIGHT - screenBorder - ballRadius) {  // bottom wall collision
          ballY = KYWY_DISPLAY_HEIGHT - screenBorder - ballRadius;
          ballYVelocity = -1 * abs(ballYVelocity);
        }


        engine.display.clear();
        drawScore();
        drawPaddlesAndBall();
        engine.display.update();
        break;
      case Kywy::Events::INPUT_PRESSED:
        if (!startScreen) {
          break;
        }

        startScreen = false;
        startGame();
        break;
      case Kywy::Events::BUTTON_LEFT_PRESSED:
        if (!gameOver) {
          break;
        }
        startGame();
        break;
    }
  }

} gameManager;

void setup() {
  engine.start();
  gameManager.start();
}

void loop() {
  delay(1000);
}
