/*
  Smooth Movement Example
  Demonstrates smooth servo movements
*/

#include <ServoM.h>

ServoM myservo;

void setup() {
  Serial.begin(9600);
  Serial.println("ServoM Smooth Movement Example");
  
  myservo.attach(9);
  myservo.setLimits(0, 180);
}

void loop() {
  // Smooth movement examples
  Serial.println("Smooth move to 0 degrees (2 seconds)");
  myservo.smoothMove(0, 2000);
  
  while (myservo.isMoving()) {
    myservo.update();
    delay(10);
  }
  delay(1000);
  
  Serial.println("Smooth move to 180 degrees (3 seconds)");
  myservo.smoothMove(180, 3000);
  
  while (myservo.isMoving()) {
    myservo.update();
    
    // You can do other tasks here
    // while the servo is moving smoothly
    Serial.print("Current angle: ");
    Serial.println(myservo.getCurrentAngle());
    
    delay(50);
  }
  delay(1000);
  
  Serial.println("Smooth move to 90 degrees (1.5 seconds)");
  myservo.smoothMove(90, 1500);
  
  while (myservo.isMoving()) {
    myservo.update();
    delay(10);
  }
  delay(1000);
}
