/*
  Multiple Servos Example
  Demonstrates controlling multiple servos
*/

#include <ServoM.h>

// Create multiple servo objects
ServoM servo1;
ServoM servo2;
ServoM servo3;

void setup() {
  Serial.begin(9600);
  Serial.println("ServoM Multiple Servos Example");
  
  // Attach servos to different pins
  servo1.attach(9);
  servo2.attach(10);
  servo3.attach(11);
  
  // Set different limits for each servo
  servo1.setLimits(0, 90);    // Limited range
  servo2.setLimits(0, 180);   // Full range
  servo3.setLimits(45, 135);  // Centered range
}

void loop() {
  // Move all servos to different positions
  Serial.println("Moving servos to different positions");
  
  servo1.smoothMove(45, 2000);
  servo2.smoothMove(90, 2500);
  servo3.smoothMove(90, 1500);
  
  // Update all servos until they finish moving
  while (servo1.isMoving() || servo2.isMoving() || servo3.isMoving()) {
    servo1.update();
    servo2.update();
    servo3.update();
    
    // Print current angles
    Serial.print("Angles: ");
    Serial.print(servo1.getCurrentAngle());
    Serial.print(", ");
    Serial.print(servo2.getCurrentAngle());
    Serial.print(", ");
    Serial.println(servo3.getCurrentAngle());
    
    delay(50);
  }
  
  delay(1000);
  
  // Move to another set of positions
  servo1.smoothMove(0, 1000);
  servo2.smoothMove(180, 2000);
  servo3.smoothMove(135, 1500);
  
  while (servo1.isMoving() || servo2.isMoving() || servo3.isMoving()) {
    servo1.update();
    servo2.update();
    servo3.update();
    delay(10);
  }
  
  delay(1000);
}
