/*
  Basic ServoM Example
  Demonstrates basic servo control
*/

#include <ServoM.h>

ServoM myservo;

void setup() {
  Serial.begin(9600);
  Serial.println("ServoM Basic Example");
  
  // Attach servo to pin 9
  if (myservo.attach(9)) {
    Serial.println("Servo attached successfully");
  } else {
    Serial.println("Failed to attach servo");
    while (1); // Stop if failed
  }
  
  // Optional: Set angle limits
  myservo.setLimits(0, 180);
}

void loop() {
  Serial.println("Moving to 0 degrees");
  myservo.write(0);
  delay(1000);
  
  Serial.println("Moving to 90 degrees");
  myservo.write(90);
  delay(1000);
  
  Serial.println("Moving to 180 degrees");
  myservo.write(180);
  delay(1000);
  
  Serial.println("Moving to 45 degrees");
  myservo.write(45);
  delay(1000);
}
