# Spiderbot – 8-Servo Motion Control Library
### by **Jade Lab**

Spiderbot is an Arduino library for controlling 8-servo spider-style walking robots.  
It provides smooth motion sequences using PROGMEM tables and interpolation for natural walking, rotation, dancing, and action poses.

---

## ⭐ Features
- 8-servo gait engine (4 legs × 2 servos each)
- Movement sequences stored in PROGMEM
- Smooth interpolation between servo positions
- Forward, backward, left rotate, right rotate
- Extra motions: lie down, push-up, fight, dance motions
- Supports Bluetooth serial commands
- Easy to integrate into any Arduino project

---

## 📦 Folder Structure
```
Spiderbot/
 ├── src/
 │    ├── movements.h
 │    ├── movements.cpp
 ├── examples/
 │    └── Spiderbot_Control/
 │         └── Spiderbot_Control.ino
 ├── library.properties
 ├── LICENSE
 └── README.md
```

---

## 🔧 Installation
1. Download from GitHub or install from Arduino Library Manager  
   (once approved)
2. Go to  
   **Sketch → Include Library → Add .ZIP Library**
3. Select the Spiderbot library folder.

---

## 🚀 Basic Usage
```cpp
#include <Spiderbot.h>

int pins[8] = {2,3,4,5,6,7,8,9};

void setup() {
  Serial.begin(9600);
  initServos(pins);
  neutralStand();
}

void loop() {
  if (Serial.available()) {
    char cmd = Serial.read();

    if (cmd == 'F') walkForward();
    if (cmd == 'B') walkBackward();
    if (cmd == 'L') rotateLeft();
    if (cmd == 'R') rotateRight();
    if (cmd == 'S') neutralStand();
  }
}
```

You can send commands via:
- Bluetooth module (HC-05 / HC-06)
- Serial Monitor
- Any controller app

---

## 📡 Bluetooth Commands
| Command | Action |
|--------|--------|
| `F` | Walk Forward |
| `B` | Walk Backward |
| `L` | Rotate Left |
| `R` | Rotate Right |
| `S` | Stand Neutral |
| `U` | Lie Down |
| `P` | Push-Up |
| `H` | Say Hi |
| `D` | Dance 1 |
| `Z` | Dance 2 |

---

## 🛠 Compatibility
- Works on **Arduino Nano**, **Uno**, **Mega**, and similar AVR boards.
- Compatible with **Servo.h**
- No additional dependencies

---

## 📄 License
This project is licensed under the **MIT License**.  
See the `LICENSE` file for details.

---

## 🙌 Author
**Jade Lab**  
Email: *jaderb.rnd@gmail.com*  
GitHub: https://github.com/JadeRB-RND

---

## ⭐ Support the Project
If you find this library useful, give the GitHub repo a ⭐ and share your Spiderbot builds!

