/**
 * @file        tle94112-motor-ino.hpp
 * @brief       TLE94112 Motor Arduino API
 * @copyright   Copyright (c) 2019-2020 Infineon Technologies AG
 * @details     This file can optionally be included in projects that use an Infineon
 *              DC Motor Control Shield with TLE94112
 *              It provides a higher abstraction for controlling motors with the TLE94112
 *              acting as an output driver
 *
 * SPDX-License-Identifier: MIT
 */

#ifndef TLE94112MOTOR_INO_HPP_
#define TLE94112MOTOR_INO_HPP_

#include "tle94112-ino.hpp"
#include "tle94112-motor.hpp"

/**
 * @class Tle94112MotorIno
 *
 * @brief represents a motor connected to a TLE94112
 *
 * This file exists only for compatibility with the Arduino setup.
 *
 * @see Tle94112
 */

#endif /** TLE94112MOTOR_INO_HPP_ **/