[![Compile examples](https://github.com/Infineon/arduino-multi-half-bridge/actions/workflows/compile_examples.yml/badge.svg)](https://github.com/Infineon/arduino-multi-half-bridge/actions/workflows/compile_examples.yml)

# Multi Half-Bridge Arduino Library

Arduino library of Infineon's Multi Half-Bridge IC controllers.

## Supported Products

<table>
    <tr>
        <td><img src="https://github.com/Infineon/Assets/raw/master/Pictures/TLE94112EL_Shield.png" width=200></td>
        <td><img src="https://www.infineon.com/export/sites/default/_images/product/power/motor_control_ics/TLE94112ES_TSDSO-24-51_Combi.jpg_1867607890.jpg" width=200></td>
    </tr>
    <tr>
        <td style="text-align: center"><a href="https://github.com/Infineon/multi-half-bridge/wiki/Ino-Getting-Started">DC motor control shield with TLE94112EL for Arduino</a></td>
        <td style="text-align: center"><a href="https://github.com/Infineon/multi-half-bridge/wiki/Home">TLE94112ES / TLE94112EL</a></td>
    </tr>
</table>

### Supported Hardware Platforms

The library should be supported by any Arduino platform based on the reference Arduino cores. 

Check in this [link](https://github.com/Infineon/multi-half-bridge/wiki/Hardware-Platforms) the already verified (at least successfully built) platforms, and find out which boards are under CI build check [here](https://github.com/Infineon/multi-half-bridge/blob/master/.github/workflows/build-check.yml).

### Getting Started

Find a getting started tutorial based on the DC Motor Control Shield for Arduino and the XMC4700 Relax Kit [here](https://github.com/Infineon/multi-half-bridge/wiki/Ino-Getting-Started).

### More information

The complete relevant Arduino documentation (and more) can be found in the base XFP library [Wiki](https://github.com/infineon/multi-half-bridge/wiki/Home):

* <a href="https://github.com/Infineon/multi-half-bridge/wiki/Ino-Library-Installation"> Arduino Lib Installation</a><br> 
* <a href="https://github.com/Infineon/multi-half-bridge/wiki/Examples"> Examples</a><br>
* <a href="https://github.com/Infineon/multi-half-bridge/wiki/Arduino-API">Arduino API</a><br>
* <a href="https://github.com/Infineon/multi-half-bridge/wiki/PlatformIO">PlatformIO</a><br>

### Contributing

This is a release repository for the Arduino framework. The code basis is maintained and developed in the Multi Half-bridge Cross-Framework-Platform (XFP) library [repository](https://github.com/infineon/multi-half-bridge). 
  
### License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.


