# Smart High-Side Switch Arduino Library

[![Compile examples](https://github.com/Infineon/arduino-high-side-switch/actions/workflows/compile_examples.yml/badge.svg)](https://github.com/Infineon/arduino-high-side-switch/actions/workflows/compile_examples.yml)

Arduino library for Infineon's Arduino shields for **PROFET™ Smart High-Side Power Switches** Automotive grade

## Supported Products

<table>
    <tr>
        <td><img src="https://raw.githubusercontent.com/Infineon/high-side-switch/master/docs/img/Profet%2B2.png" width="300"></td>
        <td><img src="https://raw.githubusercontent.com/Infineon/high-side-switch/master/docs/img/BTT6020_1EKA.jpg" width="300"></td>
        <td><img src="https://raw.githubusercontent.com/Infineon/high-side-switch/master/docs/img/BTS50015_1TAD.jpg" width="300"></td>
        <td><img src="https://raw.githubusercontent.com/Infineon/high-side-switch/master/docs/img/Power_PROFET_BTS500xx_1LUA.png" width="300"></td>
        <td><img src="https://raw.githubusercontent.com/Infineon/high-side-switch/master/docs/img/Power_PROFET_BTS500xx_1LUA.png" width="300"></td>
    </tr>
    <tr>
        <td style="test-align : center"><a href="https://high-side-switch.readthedocs.io/en/latest/hw-platforms.html#profettrade-2-12v-family">PROFET™ +2 12V BTS700x-1EPP Arduino Shield</a></td>
        <td style="test-align : center"><a href="https://high-side-switch.readthedocs.io/en/latest/hw-platforms.html#profettrade-24v-family">PROFET™ + 24V BTT60xx Arduino Shield</a></td>
        <td style="test-align : center"><a href="https://high-side-switch.readthedocs.io/en/latest/hw-platforms.html#power-profettrade-family">Power PROFET™ BTS5001x-1TAD Arduino Shield</a></td>
        <td style="test-align: center"><a href="https://high-side-switch.readthedocs.io/en/latest/hw-platforms.html#power-profettrade-12v-family">Power PROFET™ + 12 V BTS500xx-1LUA</a></td>
        <td style="test-align : center"><a href="https://high-side-switch.readthedocs.io/en/latest/hw-platforms.html#power-profettrade-24v-48v-family">Power PROFET™ + 24V/48V BTH500xx-1LUA</a></td>
    </tr>
</table>

## Supported Frameworks

The library should be supported by any Arduino platform based on the reference Arduino cores.

Check in this [link](https://high-side-switch.readthedocs.io/en/latest/sw-frmwk/arduino/arduino-compatible-kits.html) the already verified (at least successfully built) platforms.

## Documentation

The complete documentation of the library as well as detailed information about the PROFET™ Arduino Shields, can be found [here](https://high-side-switch.readthedocs.io/en/latest/index.html).

## Contributing

This is a release repository for the Arduino framework. The code base is maintained and developed in the High-Side-Switch Cross-Framework-Platform (XFP) library [repository](https://github.com/infineon/high-side-switch).

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.
