<p align=left>
   <a href="https://registry.platformio.org/libraries/ipdotsetaf/ESPAsyncHTTPUpdateServer"><img src="https://img.shields.io/badge/dynamic/json?url=https%3A%2F%2Fapi.github.com%2Frepos%2FIPdotSetAF%2FESPAsyncHTTPUpdateServer%2Freleases%2Flatest&query=%24.tag_name&logo=data%3Aimage%2Fsvg%2Bxml%3Bbase64%2CPHN2ZyB3aWR0aD0iMjUwMCIgaGVpZ2h0PSIyNTAwIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiBwcmVzZXJ2ZUFzcGVjdFJhdGlvPSJ4TWlkWU1pZCI%20PHBhdGggZD0iTTEyOCAwQzkzLjgxIDAgNjEuNjY2IDEzLjMxNCAzNy40OSAzNy40OSAxMy4zMTQgNjEuNjY2IDAgOTMuODEgMCAxMjhjMCAzNC4xOSAxMy4zMTQgNjYuMzM0IDM3LjQ5IDkwLjUxQzYxLjY2NiAyNDIuNjg2IDkzLjgxIDI1NiAxMjggMjU2YzM0LjE5IDAgNjYuMzM0LTEzLjMxNCA5MC41MS0zNy40OUMyNDIuNjg2IDE5NC4zMzQgMjU2IDE2Mi4xOSAyNTYgMTI4YzAtMzQuMTktMTMuMzE0LTY2LjMzNC0zNy40OS05MC41MUMxOTQuMzM0IDEzLjMxNCAxNjIuMTkgMCAxMjggMCIgZmlsbD0iI0ZGN0YwMCIvPjxwYXRoIGQ9Ik0yNDkuMzg2IDEyOGMwIDY3LjA0LTU0LjM0NyAxMjEuMzg2LTEyMS4zODYgMTIxLjM4NkM2MC45NiAyNDkuMzg2IDYuNjEzIDE5NS4wNCA2LjYxMyAxMjggNi42MTMgNjAuOTYgNjAuOTYgNi42MTQgMTI4IDYuNjE0YzY3LjA0IDAgMTIxLjM4NiA1NC4zNDYgMTIxLjM4NiAxMjEuMzg2IiBmaWxsPSIjRkZGIi8%20PHBhdGggZD0iTTE2MC44NjkgNzQuMDYybDUuMTQ1LTE4LjUzN2M1LjI2NC0uNDcgOS4zOTItNC44ODYgOS4zOTItMTAuMjczIDAtNS43LTQuNjItMTAuMzItMTAuMzItMTAuMzJzLTEwLjMyIDQuNjItMTAuMzIgMTAuMzJjMCAzLjc1NSAyLjAxMyA3LjAzIDUuMDEgOC44MzdsLTUuMDUgMTguMTk1Yy0xNC40MzctMy42Ny0yNi42MjUtMy4zOS0yNi42MjUtMy4zOWwtMi4yNTggMS4wMXYxNDAuODcybDIuMjU4Ljc1M2MxMy42MTQgMCA3My4xNzctNDEuMTMzIDczLjMyMy04NS4yNyAwLTMxLjYyNC0yMS4wMjMtNDUuODI1LTQwLjU1NS01Mi4xOTd6TTE0Ni41MyAxNjQuOGMtMTEuNjE3LTE4LjU1Ny02LjcwNi02MS43NTEgMjMuNjQzLTY3LjkyNSA4LjMyLTEuMzMzIDE4LjUwOSA0LjEzNCAyMS41MSAxNi4yNzkgNy41ODIgMjUuNzY2LTM3LjAxNSA2MS44NDUtNDUuMTUzIDUxLjY0NnptMTguMjE2LTM5Ljc1MmE5LjM5OSA5LjM5OSAwIDAgMC05LjM5OSA5LjM5OSA5LjM5OSA5LjM5OSAwIDAgMCA5LjQgOS4zOTkgOS4zOTkgOS4zOTkgMCAwIDAgOS4zOTgtOS40IDkuMzk5IDkuMzk5IDAgMCAwLTkuMzk5LTkuMzk4em0yLjgxIDguNjcyYTIuMzc0IDIuMzc0IDAgMSAxIDAtNC43NDkgMi4zNzQgMi4zNzQgMCAwIDEgMCA0Ljc0OXoiIGZpbGw9IiNFNTcyMDAiLz48cGF0aCBkPSJNMTAxLjM3MSA3Mi43MDlsLTUuMDIzLTE4LjkwMWMyLjg3NC0xLjgzMiA0Ljc4Ni01LjA0IDQuNzg2LTguNzAxIDAtNS43LTQuNjItMTAuMzItMTAuMzItMTAuMzItNS42OTkgMC0xMC4zMTkgNC42Mi0xMC4zMTkgMTAuMzIgMCA1LjY4MiA0LjU5MiAxMC4yODkgMTAuMjY3IDEwLjMxN0w5NS44IDc0LjM3OGMtMTkuNjA5IDYuNTEtNDAuODg1IDIwLjc0Mi00MC44ODUgNTEuODguNDM2IDQ1LjAxIDU5LjU3MiA4NS4yNjcgNzMuMTg2IDg1LjI2N1Y2OC44OTJzLTEyLjI1Mi0uMDYyLTI2LjcyOSAzLjgxN3ptMTAuMzk1IDkyLjA5Yy04LjEzOCAxMC4yLTUyLjczNS0yNS44OC00NS4xNTQtNTEuNjQ1IDMuMDAyLTEyLjE0NSAxMy4xOS0xNy42MTIgMjEuNTExLTE2LjI4IDMwLjM1IDYuMTc1IDM1LjI2IDQ5LjM2OSAyMy42NDMgNjcuOTI2em0tMTguODItMzkuNDZhOS4zOTkgOS4zOTkgMCAwIDAtOS4zOTkgOS4zOTggOS4zOTkgOS4zOTkgMCAwIDAgOS40IDkuNCA5LjM5OSA5LjM5OSAwIDAgMCA5LjM5OC05LjQgOS4zOTkgOS4zOTkgMCAwIDAtOS4zOTktOS4zOTl6bS0yLjgxIDguNjcxYTIuMzc0IDIuMzc0IDAgMSAxIDAtNC43NDggMi4zNzQgMi4zNzQgMCAwIDEgMCA0Ljc0OHoiIGZpbGw9IiNGRjdGMDAiLz48L3N2Zz4%3D&label=PIO%20Registry&color=orange&link=https%3A%2F%2Fregistry.platformio.org%2Flibraries%2Fipdotsetaf%2FESPAsyncHTTPUpdateServer"></a>
   <a href="https://www.ardu-badge.com/ESPAsyncHTTPUpdateServer"><img src="https://www.ardu-badge.com/badge/ESPAsyncHTTPUpdateServer.svg"/></a>
   <img src="https://img.shields.io/github/v/release/IPdotSetAF/ESPAsyncHTTPUpdateServer"/>
   <img src="https://img.shields.io/github/release-date/IPdotSetAF/ESPAsyncHTTPUpdateServer"/>
   <img src="https://img.shields.io/github/last-commit/IPdotSetAF/ESPAsyncHTTPUpdateServer"/>
   <img src="https://img.shields.io/github/license/IPdotSetAF/ESPAsyncHTTPUpdateServer"/>
   <!--<img src="https://img.shields.io/github/downloads/IPdotSetAF/ESPAsyncHTTPUpdateServer/total"/>-->
</p>

# ESP Async HTTP Update Server

This is an advanced version [ESP8266HTTPUpdateServer](https://github.com/esp8266/Arduino/tree/master/libraries/ESP8266HTTPUpdateServer)/[ESP32's HTTPUpdateServer](https://github.com/espressif/arduino-esp32/tree/master/libraries/HTTPUpdateServer) library, modified to be compatible with [ESPAsyncWebServer](https://github.com/me-no-dev/ESPAsyncWebServer) and also add optional Styling 🌈 to the page.

It will provide a webpage for updating the firmware/filesystem of `ESP8266` or `ESP32` microcontrollers.

> [!IMPORTANT]
> If you found this library helpful, please consider leaving a Star⭐
> 
> It helps a lot in maintaining the project ❤️

## Features
- Supports:
    - ESP8266
    - ESP32
- Can Update:
    - Firmware
    - FileSystem
- Styling:
    - Stylized (Additional ~350 bytes)
    - Minimal
- Update modes:
   - Firmware + FileSystem
   - Firmware only
   - FileSystem only
- Update route customization (default: `/update`)
- Update credentials customization (default: `No credentials`)
    - Username
    - Password
- Update Events:
    - onUpdateBegin
    - onUpdateEnd
- Force Aborting Update using events 
- FileSystem Options:
    - SPIFFS
    - LittleFS

## HowTo

### Install

This Library is available in `Arduino Library Repository` and `PIO` and you can install it from: 

| Arduino IDE Library Manager | PlatformIO Libraries |
|:---:|:---:|
|<img width="500" src="previews/arduino.png" alt="Arduino library manager"/>|<img width="500" src="previews/pio.png" alt="pltformio library"/>|

`ipdotsetaf/ESPAsyncHTTPUpdateServer@^3.0.0`
### Setup
1. Include the library after `ESPAsyncWebServer.h`
``` C++
#include <ESPAsyncWebServer.h>
#include <ESPAsyncHTTPUpdateServer.h>
```
2. Create an object from `ESPAsyncHTTPUpdateServer`
``` C++
ESPAsyncHTTPUpdateServer updateServer;
AsyncWebServer server(80);
```
3. Setup the update server before starting the webServer
``` C++
updateServer.setup(&server);
server.begin();
``` 
#### Custom Route
``` C++
updateServer.setup(&server, "/customroute");
```
#### Credentials
``` C++
updateServer.setup(&server, "username", "password");
```
or
``` C++
updateServer.setup(&server, "/customroute", "username", "password");
```
#### Events
```c++
updateServer.onUpdateBegin = [](const UpdateType type, int &result)
    {      
        //...
    };

updateServer.onUpdateEnd = [](const UpdateType type, int &result)
    {
        //...
    };
```
#### Aborting the update
```c++
updateServer.onUpdateBegin = [](const UpdateType type, int &result)
    {      
        result = UpdateResult::UPDATE_ABORT;
    };
```

### Styling and Customizing OTA Page

| Stylized | Minimal |
|:---:|:---:|
|<img width="450" src="previews/stylized.png" alt="Stylized OTA Page"/> | <img width="450" src="previews/minimal.png" alt="Minimal OTA Page"/> |

> [!IMPORTANT]
> By default styling is disabled to save ~350 bytes of flash memory.
>
> You can enable the styling by adding the `-DESPASYNCHTTPUPDATESERVER_PRETTY` Build Flag to your environment.

### Customizing OTA Page

> [!IMPORTANT]
> Add the `-DESPASYNCHTTPUPDATESERVER_MODE` Build Flag with desired value to choose different update mode.
> Choose the right value based on your needs from bellow table: 
>
> | Update mode | value |
> |:---:|:---:|
> |Firmware and FileSystem|0|
> |Firmware only|1|
> |FileSystem only|2|

#### Modifying Htmls

in case you liked to modify the html of any of the pages, you need to run the `scripts/codeGenerator.py` afterwards so html contents get processed and placed in the source.

Instructions:
1. Make sure you have python installed
2. In your python environment run the following
3. `pip install -r requirements.txt`
4. `python codeGenerator.py`

### Selecting FileSystem
> [!IMPORTANT]
> The library's default fileSystem is `SPIFFS` but if you are using `LittleFS` for your FileSystem, make sure to add the `-DESPASYNCHTTPUPDATESERVER_LITTLEFS` Build Flag to your environment.

### Debugging
> [!TIP]
> To debug the library functionality, you can add the `-DESPASYNCHTTPUPDATESERVER_DEBUG` Build Flag to your environment.
>
> This will enable the library to print logs to the Serial.

> [!TIP]
> If you are using another `Serial` port, you can override the default serial by adding the `-DESPASYNCHTTPUPDATESERVER_SerialOutput=Serial1` Build Flag to your environment.

### Server Working Example

Please refer to this [fully working example](examples/simple_server/simple_server.ino)

## TODO:
- Custom CSS support
- Synchronous WebServer support

## Contribution
- You can open Issues for any bug report or feature request.
- You are free to contribute to this project by following these steps:
   1. Fork this Repo.
   2. Create a new branch for your feature/bugfix in your forked Repo.
   3. Commit your changes to the new branch you just made.
   4. Create a pull request from your branch into the `master` branch of This Repo([https://github.com/IPdotSetAF/ESPAsyncHTTPUpdateServer](https://github.com/IPdotSetAF/ESPAsyncHTTPUpdateServer)).
