#ifndef MPU6050_VIBRATION_RMS_H
#define MPU6050_VIBRATION_RMS_H

#include <Wire.h>
#include <math.h>
#include "arduinoFFT.h"
#include <SimpleKalmanFilter.h>

class MPU6050_VibrationRMS {
public:
    MPU6050_VibrationRMS();
    void begin();
    float readVRMS();

private:
    void MPU6050_Init();
    void readAccelerometer(int16_t &ax, int16_t &ay, int16_t &az);
    void calibrateAccelerometer();
    void performFFT();
    float movingAverage(float newValue);
    float calculateVelocityRMS();

    // internal variables
    SimpleKalmanFilter kalmanX, kalmanY, kalmanZ;
    arduinoFFT FFT;
    double vReal[128];
    double vImag[128];
    uint8_t fftIndex;
    int16_t ax_offset, ay_offset, az_offset;
    float ax_prev, ay_prev, az_prev;
    float ax_hpf, ay_hpf, az_hpf;
    float alpha;
    float prevVelocityRMS;
    float velocityRMSHistory[6];
    int historyIndex;
};

#endif
