# MPU6050_VibrationRMS

Arduino library to compute vibration **velocity RMS (mm/s)** and **peak frequency** from MPU6050 accelerometer data.  
This library integrates **Kalman filtering**, a **high-pass filter**, **moving average smoothing**, and **FFT analysis** to measure vibration severity according to ISO 10816 principles.

---

## ✨ Features
- Calculate **Velocity RMS (mm/s)** in real time  
- Detect **dominant frequency** using FFT  
- Built-in **Kalman filter** for noise reduction  
- Configurable **sampling rate** and **moving average** window  
- Example included for easy integration

---

## 📦 Requirements
Make sure these dependencies are installed before compiling:
- [arduinoFFT](https://github.com/kosme/arduinoFFT)
- [SimpleKalmanFilter](https://github.com/denyssene/SimpleKalmanFilter)
- Wire (built-in Arduino library)

Tested on:
- Arduino Uno / Nano
- ESP32
- ESP8266

---

## ⚙️ Installation

### Option 1 – Manual ZIP
1. Download this repository as a ZIP file.  
2. In Arduino IDE:  
   **Sketch → Include Library → Add .ZIP Library…**  
3. Select the downloaded file.  

### Option 2 – Git Clone
Clone directly into your Arduino libraries folder:
```bash
cd ~/Documents/Arduino/libraries/
git clone https://github.com/IFTAHULYUSRO/MPU6050_VIBRATIONRMS.git
