# HomeSpan Services and Characteristics

Below is a list of all Services supported by HomeSpan, along with a brief description of each Service.  Click on the arrow next to the description of any Service to see a list of all Characteristics supported by the Service, as well as a description of each Characteristic.[^1]

A blue diamond (🔹) next to a Characteristic means it is **required** for that Service, otherwise it is optional.  Information included for each Characteristic is as follows:

* **Format** - the native format of the Characteristic's value.  Note that *string* means a standard C-string (i.e. char \*)
* **Perms**, where
  * PR = Paired Read.  This means HomeKit can read the value from HomeSpan[^2]
  * PW = Paired Write.  This means HomeKit can write the value to HomeSpan, which triggers a call to `update()`
  * EV = Event Notification.  This means HomeSpan can push notifications of value changes to HomeKit using `setVal()`
* **Min** / **Max** - the default minimum and maximum values allowed in HomeKit.  For applicable numerical Characteristics, you can change the allowed minimum and maximum values using `setRange()`
* **Constants/Defaults**
  * for enumerated Characteristics, a list of all allowed values in the form of pre-defined constant expressions and their equivalent numeric values.  A check mark next to a constant indicates that it is the default value.  If your Accessory does not support certain states of a Characteristic, you can change the allowed values using `setValidValues()`
  * for all other Characteristics, the actual default value that is used if you do not specify one when instantiating the Characteristic

 [^1]: The hexidecimal numbers in parentheses next to each Service and Characteristic represent the short-form of the Apple's UUID for that Service or Characteristic.  These are provided for informational purposes only (you do not need to use them, or even know about them, to create HomeSpan sketches)

 [^2]: Though rarely needed, you can change the permissions of a Characteristic using `setPerms()`, `addPerms()`, and `removePerms()`
 
HomeSpan Services and Characteristics are implemented as C++ Classes with names that exactly match the spelling and capitalization specified by Apple in Sections 8  and 9 of HAP-R2, but without any spaces.  HomeSpan Services are defined in HomeSpan's `Service` namespace.  HomeSpan Characteristics are defined in HomeSpan's `Characteristic` namespace.  For example, HomeSpan defines the *Carbon Dioxide Sensor* Service (HAP Service 8.7) as `Service::CarbonDioxideSensor`, and the *Carbon Dioxide Detected* Characteristic (HAP Characteristic 9.16) as `Characteristic::CarbonDioxideDetected`.

The pre-defined constant expressions for enumerated Characteristics are in namespaces that match the name of the Characteristic.  For example, to set the *Air Quality* Characteristic of an *Air Quality Sensor* Service, you could use `setVal(Characteristic::AirQuality::GOOD)` or, equivalently, `setVal(2)`.[^3]

[^3]: Note that a Characteristic's pre-defined constants are inherited by objects that you create from that Characteristic.  This means that if you create a pointer to the *AirQuality* Characteristic using `Characteristic::AirQuality *air = new Characteristic::AirQuality;` then later in your code you can either say<br> `air->setVal(Characteristic::AirQuality::GOOD)` or `air->GOOD`.  Both will work, but the latter is much easier to type.

<!-- AUTOGENERATED_TEXT.  DO NOT EDIT THIS LINE OR ANYTHING BELOW -->


##  MANDATORY SERVICES
### AccessoryInformation (3E)
<i> Required Identification Information.  For each Accessory in a HomeSpan device this must be included as the first Service.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Identify (14) :small_blue_diamond:</b><ul><li> triggers an update when HomeKit wants HomeSpan to run its identification routine for an Accessory</li></ul></td><td align="center">bool</td><td align="center">PW</td><td align="center">1</td><td align="center">1</td><td><ul><li><span>RUN_ID&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>Name (23) </b><ul><li> default display name of the Accessory</li></ul></td><td align="center">string</td><td align="center">PR</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
<tr><td><b>FirmwareRevision (52) </b><ul><li> must be in form x[.y[.z]] - informational only</li></ul></td><td align="center">string</td><td align="center">PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"1.0.0"</td></tr>
<tr><td><b>Manufacturer (20) </b><ul><li> any string - informational only</li></ul></td><td align="center">string</td><td align="center">PR</td><td align="center">-</td><td align="center">-</td><td align="center">"HomeSpan"</td></tr>
<tr><td><b>Model (21) </b><ul><li> any string - informational only</li></ul></td><td align="center">string</td><td align="center">PR</td><td align="center">-</td><td align="center">-</td><td align="center">"HomeSpan-ESP32"</td></tr>
<tr><td><b>SerialNumber (30) </b><ul><li> any string - informational only</li></ul></td><td align="center">string</td><td align="center">PR</td><td align="center">-</td><td align="center">-</td><td align="center">"HS-12345"</td></tr>
<tr><td><b>HardwareRevision (53) </b><ul><li> must be in form x[.y[.z]] - informational only</li></ul></td><td align="center">string</td><td align="center">PR</td><td align="center">-</td><td align="center">-</td><td align="center">"1.0.0"</td></tr>
</table><br>

##  LIGHTS, POWER, AND SWITCHES
### BatteryService (96)
<i> Defines a standalone Battery Service.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>BatteryLevel (68) :small_blue_diamond:</b><ul><li> measured as a percentage</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">100</td></tr>
<tr><td><b>ChargingState (8F) :small_blue_diamond:</b><ul><li> indicates state of battery charging</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>NOT_CHARGING&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CHARGING&nbsp(1)&nbsp;</span></li><li><span>NOT_CHARGEABLE&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) :small_blue_diamond:</b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### LightBulb (43)
<i> Defines any type of Light.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>On (25) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">bool</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>OFF&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ON&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>Brightness (8) </b><ul><li> measured as a percentage</li></ul></td><td align="center">int</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>Hue (13) </b><ul><li> color (in degrees) from red (0) to green (120) to blue (240) and back to red (360)</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">360</td><td align="center">0</td></tr>
<tr><td><b>Saturation (2F) </b><ul><li> color saturation, measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>ColorTemperature (CE) </b><ul><li> measured in inverse megaKelvin (= 1,000,000 / Kelvin)</li></ul></td><td align="center">uint32</td><td align="center">PR+PW+EV</td><td align="center">140</td><td align="center">500</td><td align="center">200</td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### Outlet (47)
<i> Defines a controllable Outlet used to power any light or appliance.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>On (25) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">bool</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>OFF&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ON&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>OutletInUse (26) :small_blue_diamond:</b><ul><li> indicates if an appliance or light is plugged into the outlet, regardless of whether on or off </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_IN_USE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>IN_USE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### StatelessProgrammableSwitch (89)
<i> Defines a "Stateless" Programmable Switch that can be used to trigger actions in the Home App.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>ProgrammableSwitchEvent (73) :small_blue_diamond:</b><ul><li> specifies type of button press</li></ul></td><td align="center">uint8</td><td align="center">PR+EV+NV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>SINGLE_PRESS&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DOUBLE_PRESS&nbsp(1)&nbsp;</span></li><li><span>LONG_PRESS&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ServiceLabelIndex (CB) </b><ul><li> numerical index used to distinguish multiple copies of the same Service within an Accessory</li></ul></td><td align="center">uint8</td><td align="center">PR</td><td align="center">1</td><td align="center">255</td><td align="center">1</td></tr>
</table><br>

### Switch (49)
<i> Defines a generic Switch.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>On (25) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">bool</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>OFF&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ON&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

##  HEATING, VENTILATION, AND AIR CONDITIONING (HVAC)
### AirPurifier (BB)
<i> Defines a basic Air Purifier with an optional fan and swing mode.  Optional Linked Services: <b>FilterMaintenance</b>.  Combine with an <b>AirSensor</b> Service for automated operations.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CurrentAirPurifierState (A9) :small_blue_diamond:</b><ul><li> indicates current state of air purification</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>IDLE&nbsp(1)&nbsp;</span></li><li><span>PURIFYING&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>TargetAirPurifierState (A8) :small_blue_diamond:</b><ul><li> indicates desired state of air purifier</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>MANUAL&nbsp(0)&nbsp;</span></li><li><span>AUTO&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>RotationSpeed (29) </b><ul><li> measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>SwingMode (B6) </b><ul><li> indicates whether swing-mode is enabled</li></ul></td><td align="center">uint8</td><td align="center">PR+EV+PW</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>SWING_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>SWING_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>LockPhysicalControls (A7) </b><ul><li> indicates if local control lock is enabled</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>CONTROL_LOCK_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CONTROL_LOCK_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### Fan (B7)
<i> Defines a Fan.  Combine with a <b>LightBulb</b> Service to create a Lighted Ceiling Fan.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CurrentFanState (AF) </b><ul><li> indicates current state of a fan</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span></li><li><span>IDLE&nbsp(1)&nbsp;</span>:heavy_check_mark:</li><li><span>BLOWING&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>TargetFanState (BF) </b><ul><li> indicates desired state of fan</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>MANUAL&nbsp(0)&nbsp;</span></li><li><span>AUTO&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>RotationDirection (28) </b><ul><li> indicates the rotation direction of a fan</li></ul></td><td align="center">int</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>CLOCKWISE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>COUNTERCLOCKWISE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>RotationSpeed (29) </b><ul><li> measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>SwingMode (B6) </b><ul><li> indicates whether swing-mode is enabled</li></ul></td><td align="center">uint8</td><td align="center">PR+EV+PW</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>SWING_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>SWING_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>LockPhysicalControls (A7) </b><ul><li> indicates if local control lock is enabled</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>CONTROL_LOCK_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CONTROL_LOCK_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### FilterMaintenance (BA)
<i> Defines a Filter Maintainence check.  Use only as a Linked Service for the <b>AirPurifier</b> Service.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>FilterChangeIndication (AC) :small_blue_diamond:</b><ul><li> indicates state of filter</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_CHANGE_NEEDED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CHANGE_NEEDED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>FilterLifeLevel (AB) </b><ul><li> measured as a percentage of remaining life</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">100</td></tr>
<tr><td><b>ResetFilterIndication (AD) </b><ul><li> triggers an update when the user chooses to reset the <b>FilterChangeIndication</b> (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PW</td><td align="center">1</td><td align="center">1</td><td><ul><li><span>RESET_FILTER&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### HeaterCooler (BC)
<i> Defines a standalone Heater, Cooler, or combined Heater/Cooler.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CurrentTemperature (11) :small_blue_diamond:</b><ul><li> current temperature measured in Celsius</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>CurrentHeaterCoolerState (B1) :small_blue_diamond:</b><ul><li> indicates whether appliance is currently heating, cooling, idle, or off</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span></li><li><span>IDLE&nbsp(1)&nbsp;</span>:heavy_check_mark:</li><li><span>HEATING&nbsp(2)&nbsp;</span></li><li><span>COOLING&nbsp(3)&nbsp;</span></li></ul></td></tr>
<tr><td><b>TargetHeaterCoolerState (B2) :small_blue_diamond:</b><ul><li> indicates desired state of heater/cooler</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>AUTO&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>HEAT&nbsp(1)&nbsp;</span></li><li><span>COOL&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>RotationSpeed (29) </b><ul><li> measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>TemperatureDisplayUnits (36) </b><ul><li> indicates the desired units to display the temperature on the device itself (has no effect on Home App)</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>CELSIUS&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAHRENHEIT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>SwingMode (B6) </b><ul><li> indicates whether swing-mode is enabled</li></ul></td><td align="center">uint8</td><td align="center">PR+EV+PW</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>SWING_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>SWING_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CoolingThresholdTemperature (D) </b><ul><li> cooling turns on when temperature (in Celsius) rises above this threshold</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">10</td><td align="center">35</td><td align="center">10</td></tr>
<tr><td><b>HeatingThresholdTemperature (12) </b><ul><li> heating turns on when temperature (in Celsius) falls below this threshold</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">25</td><td align="center">16</td></tr>
<tr><td><b>LockPhysicalControls (A7) </b><ul><li> indicates if local control lock is enabled</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>CONTROL_LOCK_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CONTROL_LOCK_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### HumidifierDehumidifier (BD)
<i> Defines a Humidifer, Dehumidifier, or combined Humidifer/Dehumidifier.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CurrentRelativeHumidity (10) :small_blue_diamond:</b><ul><li> current humidity measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>CurrentHumidifierDehumidifierState (B3) :small_blue_diamond:</b><ul><li> indicates current state of humidifier/dehumidifer</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span></li><li><span>IDLE&nbsp(1)&nbsp;</span>:heavy_check_mark:</li><li><span>HUMIDIFYING&nbsp(2)&nbsp;</span></li><li><span>DEHUMIDIFYING&nbsp(3)&nbsp;</span></li></ul></td></tr>
<tr><td><b>TargetHumidifierDehumidifierState (B4) :small_blue_diamond:</b><ul><li> indicates desired state of humidifier/dehumidifier</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>AUTO&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>HUMIDIFY&nbsp(1)&nbsp;</span></li><li><span>DEHUMIDIFY&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>RelativeHumidityDehumidifierThreshold (C9) </b><ul><li> dehumidfier turns on when humidity rises above this threshold</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">50</td></tr>
<tr><td><b>RelativeHumidityHumidifierThreshold (CA) </b><ul><li> humidfier turns on when humidity falls below this threshold</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">50</td></tr>
<tr><td><b>RotationSpeed (29) </b><ul><li> measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>SwingMode (B6) </b><ul><li> indicates whether swing-mode is enabled</li></ul></td><td align="center">uint8</td><td align="center">PR+EV+PW</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>SWING_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>SWING_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>WaterLevel (B5) </b><ul><li> measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>LockPhysicalControls (A7) </b><ul><li> indicates if local control lock is enabled</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>CONTROL_LOCK_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CONTROL_LOCK_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### Slat (B9)
<i> Defines a motorized ventilation Slat(s).</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentSlatState (AA) :small_blue_diamond:</b><ul><li> indicates current state of slats</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>FIXED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>JAMMED&nbsp(1)&nbsp;</span></li><li><span>SWINGING&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>SlatType (C0) :small_blue_diamond:</b><ul><li> indicates the direction of a slat or group of slats</li></ul></td><td align="center">uint8</td><td align="center">PR</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>HORIZONTAL&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>VERTICAL&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>SwingMode (B6) </b><ul><li> indicates whether swing-mode is enabled</li></ul></td><td align="center">uint8</td><td align="center">PR+EV+PW</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>SWING_DISABLED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>SWING_ENABLED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CurrentTiltAngle (C1) </b><ul><li> current angle (in degrees) of slats from fully up or left (-90) to fully open (0) to fully down or right (90)</li></ul></td><td align="center">int</td><td align="center">PR+EV</td><td align="center">-90</td><td align="center">90</td><td align="center">0</td></tr>
<tr><td><b>TargetTiltAngle (C2) </b><ul><li> indicated desired angle (in degrees) of slats from fully up or left (-90) to fully open (0) to fully down or right (90) </li></ul></td><td align="center">int</td><td align="center">PW+PR+EV</td><td align="center">-90</td><td align="center">90</td><td align="center">0</td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### Thermostat (4A)
<i> Defines a Thermostat used to control a furnace, air conditioner, or both.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentHeatingCoolingState (F) :small_blue_diamond:</b><ul><li> indicates whether appliance is currently heating, cooling, or just idle</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>IDLE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>HEATING&nbsp(1)&nbsp;</span></li><li><span>COOLING&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>TargetHeatingCoolingState (33) :small_blue_diamond:</b><ul><li> indicates desired state of appliance</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>OFF&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>HEAT&nbsp(1)&nbsp;</span></li><li><span>COOL&nbsp(2)&nbsp;</span></li><li><span>AUTO&nbsp(3)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CurrentTemperature (11) :small_blue_diamond:</b><ul><li> current temperature measured in Celsius</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>TargetTemperature (35) :small_blue_diamond:</b><ul><li> indicates desired temperature measures in Celsius</li></ul></td><td align="center">float</td><td align="center">PW+PR+EV</td><td align="center">10</td><td align="center">38</td><td align="center">16</td></tr>
<tr><td><b>TemperatureDisplayUnits (36) :small_blue_diamond:</b><ul><li> indicates the desired units to display the temperature on the device itself (has no effect on Home App)</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>CELSIUS&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAHRENHEIT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CoolingThresholdTemperature (D) </b><ul><li> cooling turns on when temperature (in Celsius) rises above this threshold</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">10</td><td align="center">35</td><td align="center">10</td></tr>
<tr><td><b>CurrentRelativeHumidity (10) </b><ul><li> current humidity measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>HeatingThresholdTemperature (12) </b><ul><li> heating turns on when temperature (in Celsius) falls below this threshold</li></ul></td><td align="center">float</td><td align="center">PR+PW+EV</td><td align="center">0</td><td align="center">25</td><td align="center">16</td></tr>
<tr><td><b>TargetRelativeHumidity (34) </b><ul><li> indicates desired humidity measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

##  STANDALONE SENSORS
### AirQualitySensor (8D)
<i> Defines an Air Quality Sensor. </i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>AirQuality (95) :small_blue_diamond:</b><ul><li> a subjective description</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">5</td><td><ul><li><span>UNKNOWN&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>EXCELLENT&nbsp(1)&nbsp;</span></li><li><span>GOOD&nbsp(2)&nbsp;</span></li><li><span>FAIR&nbsp(3)&nbsp;</span></li><li><span>INFERIOR&nbsp(4)&nbsp;</span></li><li><span>POOR&nbsp(5)&nbsp;</span></li></ul></td></tr>
<tr><td><b>OzoneDensity (C3) </b><ul><li> measured in &micro;g/m<sup>3</sup></li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1000</td><td align="center">0</td></tr>
<tr><td><b>NitrogenDioxideDensity (C4) </b><ul><li> measured in &micro;g/m<sup>3</sup></li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1000</td><td align="center">0</td></tr>
<tr><td><b>SulphurDioxideDensity (C5) </b><ul><li> measured in &micro;g/m<sup>3</sup></li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1000</td><td align="center">0</td></tr>
<tr><td><b>PM25Density (C6) </b><ul><li> 2.5-micron particulate density, measured in &micro;g/m<sup>3</sup></li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1000</td><td align="center">0</td></tr>
<tr><td><b>PM10Density (C7) </b><ul><li> 10-micron particulate density, measured in &micro;g/m<sup>3</sup></li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1000</td><td align="center">0</td></tr>
<tr><td><b>VOCDensity (C8) </b><ul><li> measured in &micro;g/m<sup>3</sup></li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1000</td><td align="center">0</td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### CarbonDioxideSensor (97)
<i> Defines a Carbon Dioxide Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CarbonDioxideDetected (92) :small_blue_diamond:</b><ul><li> indicates if abnormal level is detected</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NORMAL&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ABNORMAL&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CarbonDioxideLevel (93) </b><ul><li> measured on parts per million (ppm)</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100000</td><td align="center">0</td></tr>
<tr><td><b>CarbonDioxidePeakLevel (94) </b><ul><li> measured in parts per million (ppm)</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100000</td><td align="center">0</td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### CarbonMonoxideSensor (7F)
<i> Defines a Carbon Monoxide Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CarbonMonoxideDetected (69) :small_blue_diamond:</b><ul><li> indicates if abnormal level is detected</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NORMAL&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ABNORMAL&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CarbonMonoxideLevel (90) </b><ul><li> measured in parts per million (ppm)</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>CarbonMonoxidePeakLevel (91) </b><ul><li> measured in parts per million (ppm)</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### ContactSensor (80)
<i> Defines a Contact Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>ContactSensorState (6A) :small_blue_diamond:</b><ul><li> indictates if contact is detected (i.e. closed)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>DETECTED&nbsp(0)&nbsp;</span></li><li><span>NOT_DETECTED&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### HumiditySensor (82)
<i> Defines a Humidity Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentRelativeHumidity (10) :small_blue_diamond:</b><ul><li> current humidity measured as a percentage</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### LeakSensor (83)
<i> Defines a Leak Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>LeakDetected (70) :small_blue_diamond:</b><ul><li> indictates if a leak is detected</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### LightSensor (84)
<i> Defines a Light Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentAmbientLightLevel (6B) :small_blue_diamond:</b><ul><li> measured in Lux (lumens/m<sup>2</sup></li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0.0001</td><td align="center">100000</td><td align="center">1</td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### MotionSensor (85)
<i> Defines a Motion Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>MotionDetected (22) :small_blue_diamond:</b><ul><li> indicates if motion is detected</li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### OccupancySensor (86)
<i> Defines and Occupancy Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>OccupancyDetected (71) :small_blue_diamond:</b><ul><li> indicates if occupanccy is detected</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### SmokeSensor (87)
<i> Defines a Smoke Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>SmokeDetected (76) :small_blue_diamond:</b><ul><li> indicates if smoke is detected</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### TemperatureSensor (8A)
<i> Defines a Temperature Sensor.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentTemperature (11) :small_blue_diamond:</b><ul><li> current temperature measured in Celsius</li></ul></td><td align="center">float</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>StatusActive (75) </b><ul><li> indicates whether the Service is properly functioning </li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_FUNCTIONING&nbsp(0)&nbsp;</span></li><li><span>FUNCTIONING&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusLowBattery (79) </b><ul><li> indicates state of battery</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_LOW_BATTERY&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOW_BATTERY&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

##  DOORS, LOCKS, AND WINDOWS
### Door (81)
<i> Defines a motorized Door.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentPosition (6D) :small_blue_diamond:</b><ul><li> current position (as a percentage) from fully closed (0) to full open (100)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>TargetPosition (7C) :small_blue_diamond:</b><ul><li> indicates target position (as a percentage) from fully closed (0) to full open (100)</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>ObstructionDetected (24) </b><ul><li> indicates if obstruction is detected</li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### Doorbell (121)
<i> Defines a Doorbell.  Can be used on a standalone basis or in conjunction with a <b>LockMechanism</b> Service.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>ProgrammableSwitchEvent (73) :small_blue_diamond:</b><ul><li> specifies type of button press</li></ul></td><td align="center">uint8</td><td align="center">PR+EV+NV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>SINGLE_PRESS&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DOUBLE_PRESS&nbsp(1)&nbsp;</span></li><li><span>LONG_PRESS&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### GarageDoorOpener (41)
<i> Defines a motorized Garage Door Opener.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentDoorState (E) :small_blue_diamond:</b><ul><li> indicates current state of a door</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">4</td><td><ul><li><span>OPEN&nbsp(0)&nbsp;</span></li><li><span>CLOSED&nbsp(1)&nbsp;</span>:heavy_check_mark:</li><li><span>OPENING&nbsp(2)&nbsp;</span></li><li><span>CLOSING&nbsp(3)&nbsp;</span></li><li><span>STOPPED&nbsp(4)&nbsp;</span></li></ul></td></tr>
<tr><td><b>TargetDoorState (32) :small_blue_diamond:</b><ul><li> indicates desired state of door</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>OPEN&nbsp(0)&nbsp;</span></li><li><span>CLOSED&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>ObstructionDetected (24) :small_blue_diamond:</b><ul><li> indicates if obstruction is detected</li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>LockCurrentState (1D) </b><ul><li> indicates state of a lock</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>UNLOCKED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOCKED&nbsp(1)&nbsp;</span></li><li><span>JAMMED&nbsp(2)&nbsp;</span></li><li><span>UNKNOWN&nbsp(3)&nbsp;</span></li></ul></td></tr>
<tr><td><b>LockTargetState (1E) </b><ul><li> indicates desired state of lock</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>UNLOCK&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOCK&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### LockMechanism (45)
<i> Defines an electronic Lock.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>LockCurrentState (1D) :small_blue_diamond:</b><ul><li> indicates state of a lock</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>UNLOCKED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOCKED&nbsp(1)&nbsp;</span></li><li><span>JAMMED&nbsp(2)&nbsp;</span></li><li><span>UNKNOWN&nbsp(3)&nbsp;</span></li></ul></td></tr>
<tr><td><b>LockTargetState (1E) :small_blue_diamond:</b><ul><li> indicates desired state of lock</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>UNLOCK&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>LOCK&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### Window (8B)
<i> Defines a motorized Window.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>CurrentPosition (6D) :small_blue_diamond:</b><ul><li> current position (as a percentage) from fully closed (0) to full open (100)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>TargetPosition (7C) :small_blue_diamond:</b><ul><li> indicates target position (as a percentage) from fully closed (0) to full open (100)</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>ObstructionDetected (24) </b><ul><li> indicates if obstruction is detected</li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### WindowCovering (8C)
<i> Defines a motorized Window Shade, Screen, Awning, etc.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>TargetPosition (7C) :small_blue_diamond:</b><ul><li> indicates target position (as a percentage) from fully closed (0) to full open (100)</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>CurrentPosition (6D) :small_blue_diamond:</b><ul><li> current position (as a percentage) from fully closed (0) to full open (100)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">100</td><td align="center">0</td></tr>
<tr><td><b>CurrentHorizontalTiltAngle (6C) </b><ul><li> current angle (in degrees) of slats from fully up (-90) to fully open (0) to fully down (90) </li></ul></td><td align="center">int</td><td align="center">PR+EV</td><td align="center">-90</td><td align="center">90</td><td align="center">0</td></tr>
<tr><td><b>TargetHorizontalTiltAngle (7B) </b><ul><li> indicates desired angle (in degrees) of slats from fully up (-90) to fully open (0) to fully down (90)</li></ul></td><td align="center">int</td><td align="center">PW+PR+EV</td><td align="center">-90</td><td align="center">90</td><td align="center">0</td></tr>
<tr><td><b>CurrentVerticalTiltAngle (6E) </b><ul><li> current angle (in degrees) of slats from fully left (-90) to fully open (0) to fully right (90)</li></ul></td><td align="center">int</td><td align="center">PR+EV</td><td align="center">-90</td><td align="center">90</td><td align="center">0</td></tr>
<tr><td><b>TargetVerticalTiltAngle (7D) </b><ul><li> indicates desired angle (in degrees) of slats from fully left (-90) to fully open (0) to fully right (90)</li></ul></td><td align="center">int</td><td align="center">PW+PR+EV</td><td align="center">-90</td><td align="center">90</td><td align="center">0</td></tr>
<tr><td><b>ObstructionDetected (24) </b><ul><li> indicates if obstruction is detected</li></ul></td><td align="center">bool</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_DETECTED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>DETECTED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

##  WATER SYSTEMS
### Faucet (D7)
<i> Defines the master control for a multi-Valve appliance.  Linked Services: <b>Valve</b> (at least one required), and <b>HeaterCooler</b> (optional).</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### IrrigationSystem (CF)
<i> Defines an Irrigation System.  Linked Services: <b>Valve</b> Service (at least one required).</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ProgramMode (D1) :small_blue_diamond:</b><ul><li> indicates if pre-scheduled program is running</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">2</td><td><ul><li><span>NONE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>SCHEDULED&nbsp(1)&nbsp;</span></li><li><span>SCHEDULE_OVERRIDEN&nbsp(2)&nbsp;</span></li></ul></td></tr>
<tr><td><b>InUse (D2) :small_blue_diamond:</b><ul><li> if Service is set to active, this indictes whether it is currently in use</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_IN_USE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>IN_USE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>RemainingDuration (D4) </b><ul><li> duration (in seconds) remaining for Service to be active/on</li></ul></td><td align="center">uint32</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3600</td><td align="center">60</td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### Valve (D0)
<i> Defines an electronic Valve.  Can be used standalone or as a Linked Service for either a <b>Faucet</b> or <b>IrrigationSystem</b> Service.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>InUse (D2) :small_blue_diamond:</b><ul><li> if Service is set to active, this indictes whether it is currently in use</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_IN_USE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>IN_USE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ValveType (D5) :small_blue_diamond:</b><ul><li> indicates the type of valve</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>GENERIC&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>IRRIGATION&nbsp(1)&nbsp;</span></li><li><span>SHOWER_HEAD&nbsp(2)&nbsp;</span></li><li><span>FAUCET&nbsp(3)&nbsp;</span></li></ul></td></tr>
<tr><td><b>SetDuration (D3) </b><ul><li> specifies the duration (in seconds) for a Service to remain on once activated</li></ul></td><td align="center">uint32</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">3600</td><td align="center">60</td></tr>
<tr><td><b>RemainingDuration (D4) </b><ul><li> duration (in seconds) remaining for Service to be active/on</li></ul></td><td align="center">uint32</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3600</td><td align="center">60</td></tr>
<tr><td><b>IsConfigured (D6) </b><ul><li> indicates if a predefined Service has been configured</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_CONFIGURED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CONFIGURED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ServiceLabelIndex (CB) </b><ul><li> numerical index used to distinguish multiple copies of the same Service within an Accessory</li></ul></td><td align="center">uint8</td><td align="center">PR</td><td align="center">1</td><td align="center">255</td><td align="center">1</td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

##  SECURITY SYSTEMS
### SecuritySystem (7E)
<i> Defines a Security System.  Often used in combination with <b>MotionSensor</b> and <b>ContactSensor</b> Services.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>SecuritySystemCurrentState (66) :small_blue_diamond:</b><ul><li> indicates current state of the security system </li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">4</td><td><ul><li><span>ARMED_STAY&nbsp(0)&nbsp;</span></li><li><span>ARMED_AWAY&nbsp(1)&nbsp;</span></li><li><span>ARMED_NIGHT&nbsp(2)&nbsp;</span></li><li><span>DISARMED&nbsp(3)&nbsp;</span>:heavy_check_mark:</li><li><span>ALARM_TRIGGERED&nbsp(4)&nbsp;</span></li></ul></td></tr>
<tr><td><b>SecuritySystemTargetState (67) :small_blue_diamond:</b><ul><li> indicates desired state of the security system</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>ARM_STAY&nbsp(0)&nbsp;</span></li><li><span>ARM_AWAY&nbsp(1)&nbsp;</span></li><li><span>ARM_NIGHT&nbsp(2)&nbsp;</span></li><li><span>DISARM&nbsp(3)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>SecuritySystemAlarmType (8E) </b><ul><li> indicates whether alarm was triggered for known reason</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>KNOWN&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>UNKNOWN&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusFault (77) </b><ul><li> indicates whether the Service has a fault (only appears in Eve App, not Home App)</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NO_FAULT&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>FAULT&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>StatusTampered (7A) </b><ul><li> indicates whether the Service has been tampered with</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_TAMPERED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>TAMPERED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

##  TELEVISIONS
### InputSource (D9)
<i> Defines an Input Source for a TV.  Use only as a Linked Service for the <b>Television</b> Service.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Identifier (E6) :small_blue_diamond:</b><ul><li> numerical Identifer of the <b>InputSource</b>.</li></ul></td><td align="center">uint32</td><td align="center">PR</td><td align="center">0</td><td align="center">255</td><td align="center">0</td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
<tr><td><b>IsConfigured (D6) </b><ul><li> indicates if a predefined Service has been configured</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>NOT_CONFIGURED&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>CONFIGURED&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>CurrentVisibilityState (135) </b><ul><li> current visibility of the Service, as selectable on the Settings Page of the Home App</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>VISIBLE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>NOT_VISIBLE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>TargetVisibilityState (134) </b><ul><li> indicates desired visibility of the Service, as selectable on the Settings Page of the Home App</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>VISIBLE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>NOT_VISIBLE&nbsp(1)&nbsp;</span></li></ul></td></tr>
</table><br>

### Television (D8)
<i> Defines a TV.  Optional Linked Services: <b>InputSource</b> and <b>TelevisionSpeaker</b>.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>Active (B0) :small_blue_diamond:</b><ul><li> indicates if the Service is active/on</li></ul></td><td align="center">uint8</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>INACTIVE&nbsp(0)&nbsp;</span>:heavy_check_mark:</li><li><span>ACTIVE&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ActiveIdentifier (E7) </b><ul><li> numerical Identifier of the <b>InputSource</b> selected in the Home App.</li></ul></td><td align="center">uint32</td><td align="center">PW+PR+EV</td><td align="center">0</td><td align="center">255</td><td align="center">0</td></tr>
<tr><td><b>DisplayOrder (136) </b><ul><li> specifies the order in which the TV inputs are displayed for selection in the Home App</li></ul></td><td align="center">tlv8</td><td align="center">PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">NULL_TLV</td></tr>
<tr><td><b>RemoteKey (E1) </b><ul><li> triggers an update when the corresponding key is pressed in the Remote Control widget on an iPhone </li></ul></td><td align="center">uint8</td><td align="center">PW</td><td align="center">4</td><td align="center">15</td><td><ul><li><span>UP&nbsp(4)&nbsp;</span></li><li><span>DOWN&nbsp(5)&nbsp;</span></li><li><span>LEFT&nbsp(6)&nbsp;</span></li><li><span>RIGHT&nbsp(7)&nbsp;</span></li><li><span>CENTER&nbsp(8)&nbsp;</span></li><li><span>BACK&nbsp(9)&nbsp;</span></li><li><span>PLAY_PAUSE&nbsp(11)&nbsp;</span></li><li><span>INFO&nbsp(15)&nbsp;</span></li></ul></td></tr>
<tr><td><b>PowerModeSelection (DF) </b><ul><li> when defined, creates a "View TV Settings" button in the Home App that triggers an update to this Characteristic when pressed </li></ul></td><td align="center">uint8</td><td align="center">PW</td><td align="center">0</td><td align="center">0</td><td><ul><li><span>VIEW_SETTINGS&nbsp(0)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

### TelevisionSpeaker (113)
<i> Defines a Television Speaker that can be controlled via the Remote Control widget on an iPhone.  Use only as a Linked Service for the <b>Television</b> Service.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>VolumeControlType (E9) :small_blue_diamond:</b><ul><li> indicates the type of volume control</li></ul></td><td align="center">uint8</td><td align="center">PR+EV</td><td align="center">0</td><td align="center">3</td><td><ul><li><span>NONE&nbsp(0)&nbsp;</span></li><li><span>RELATIVE&nbsp(1)&nbsp;</span></li><li><span>RELATIVE_CURRENT&nbsp(2)&nbsp;</span></li><li><span>ABSOLUTE&nbsp(3)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
<tr><td><b>VolumeSelector (EA) :small_blue_diamond:</b><ul><li> triggered by presses to the iPhone's volume up/down buttons when TV is selected in the Remote Control widget</li></ul></td><td align="center">uint8</td><td align="center">PW</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>VOLUME_UP&nbsp(0)&nbsp;</span></li><li><span>VOLUME_DOWN&nbsp(1)&nbsp;</span></li></ul></td></tr>
<tr><td><b>ConfiguredName (E3) </b><ul><li> default display name of this Service</li></ul></td><td align="center">string</td><td align="center">PW+PR+EV</td><td align="center">-</td><td align="center">-</td><td align="center">"unnamed"</td></tr>
</table><br>

##  MISCELLANEOUS
### ServiceLabel (CC)
<i> Defines a naming scheme for un-nameable Services, such as a <b>StatelessProgrammableSwitch</b>, by Linking them to this Service.  When used, those other Services must each include a <b>ServiceLabelIndex</b> Characteristic with a unique value.</i><br><table>
<tr><th>Characteristic</th><th>Format</th><th>Perms</th><th>Min</th><th>Max</th><th>Constants/Defaults</th></tr>
<tr><td><b>ServiceLabelNamespace (CD) :small_blue_diamond:</b><ul><li> indicates how un-named Services linked together with a <b>ServiceLabel</b> Service should be displayed in the Home App  </li></ul></td><td align="center">uint8</td><td align="center">PR</td><td align="center">0</td><td align="center">1</td><td><ul><li><span>DOTS&nbsp(0)&nbsp;</span></li><li><span>NUMERALS&nbsp(1)&nbsp;</span>:heavy_check_mark:</li></ul></td></tr>
</table><br>

---

[↩️](../README.md) Back to the Welcome page

