# Frequently Asked Questions

*A list of answers to frequently-asked-questions, as well as discussions of various topics of interest.*

#### How do I set my WiFi SSID and Password (i.e. WiFi Credentials)?

* Though commercial HomeKit devices can automatically retrieve WiFi Credentials from an iPhone, Apple does not provide this mechanism in the non-commerical version of HomeKit used by HomeSpan.  Instead, you need to add your WiFi Credentials to a HomeSpan device using one of four methods:

  * From within the Arduino IDE, simply use the HomeSpan Command Line Interface and type 'W' into the Serial Monitor.  HomeSpan will prompt you to input your WiFi SSID and Password.  You will only need to do this once since HomeSpan stores the WiFi Credentials you provide in the device's non-volatile storage (NVS) for use every time the device boots.  See the [HomeSpan CLI](CLI.md) for complete details.
  
  * As an alternative, and especially if your HomeSpan device is not connected to a computer, you can launch HomeSpan's Temporary WiFi Setup Network and input your WiFi Credentials directly into the temporary web form served by HomeSpan.  Similar to above, this only needs to be done once since HomeSpan likewise stores the WiFi Credentials you input using this method.  See the [HomeSpan User Guide](UserGuide.md#setting-homespans-wifi-credentials-and-setup-code) for details.

  * If you really want to, you can programmatically set your WiFi Credentials directly in your sketch using HomeSpan's `setWifiCredentials()` method.  However, this is **not** recommended since hardcoding sensitive passwords into a sketch poses a security risk, and is generally not considered a good practice.  See the [HomeSpan API Reference](Reference.md) for details.

  * Finally, for advanced users, HomeSpan provides an API hook `setApFunction()` that allows you to create your own custom method for inputting your WiFi Credentials.  See the [HomeSpan API Reference](Reference.md) for details.

#### What is the Setup Code used for pairing a HomeSpan device to HomeKit?

* The HomeSpan default Setup Code is 466-37-726.  You can (and should) use the HomeSpan Command Line Interface to change this default to a secret code unique for each of your devices.  Simply type 'S \<code\>' into the Serial Monitor, or specify your desired Setup Code at the outset when configuring your WiFi Credentials using HomeSpan's Temporary WiFi Setup Network.  Alternatively, you can programmatically set the Setup Code in your sketch using HomeSpan's `setPairingCode()` method.  However, hardcoding your Setup Code in a sketch is generally considered a security risk, as well as being inconsistent with Apple's HomeKit guidelines.

#### Can you use more than one HomeSpan device on the same HomeKit network?

* Yes. Multiple ESP32's, each running a separate copy of HomeSpan, can be used on the same HomeKit network, provided that each device has a unique *Device ID*, a unique *Host Name*, and a unique *Display Name*.  Normally, the *Device ID* is randomly-generated by HomeSpan at start-up and will therefore automatically be unique across multiple devices.  Also, unless you override the suffix of the default *Host Name*, it will also be unique across multiple devices since HomeSpan uses the *Device ID* as the suffix of the *Host Name*.  The only thing you need to ensure is that you assign a different *Display Name* to each of your devices.  See the [HomeSpan API Reference](Reference.md) for details on how to do this.

#### Does HomeSpan require the use of a HomeKit Hub, such as a HomePod or Apple TV?

* Yes. If you want HomeSpan to be able to send notifications, such as status updates if a contact sensor is opened, or updates from a temperature sensor, you must use a HomeKit Hub.  If your device can only be operated from the Home App (i.e. it has no local control buttons) and does not generate any status messages, than a HomeKit Hub *may* not be necessary.  Note you will also need a HomeKit Hub if you wish to control your device via the Internet when away from your local WiFi network.  These requirements and conditions are not specific to HomeSpan, but apply to all commercial HomeKit devices as a result of Apple updating its HomeKit Architecture (as of iOS 16.4).

#### Does HomeSpan support video and audio streams?

* No. HomeSpan does not support streaming services, such as Audio Stream Management, Data Stream Transport Management, or Camera RTP Management.  See [HomeSpan Services and Characteristics](ServiceList.md) for a complete list of all Services supported by HomeSpan.

#### Does HomeSpan work with PlatformIO?

* HomeSpan does not explicitly support PlatformIO but multiple users have reported successfully using the HomeSpan library with PlatformIO.

#### Will HomeSpan work on an ESP8266 device?

* No. HomeSpan is coded specifically for the ESP32 and will not operate on an ESP8266 device, though an ESP8266 can be used as a remote [SpanPoint ESP-NOW](NOW.md) Device.

#### How can I read HomeSpan's MDNS broadcast mentioned in the [OTA](OTA.md) documentation?

* HomeSpan uses MDNS (multicast DNS) to broadcast a variety of HAP information used by Controllers wishing to pair with HomeSpan.  Apple uses the name *Bonjour* to refer to MDNS, and originally included a Bonjour "Browser" in Safari that has since been discontinued.  However, there are a number of alternative MDNS browsers available for free that operate on both the Mac and the iPhone, such as the [Discovery - DNS-SD Browser](https://apps.apple.com/us/app/discovery-dns-sd-browser/id1381004916?mt=12).  You'll find all your HomeSpan devices, as well as any other HomeKit devices you may have, under the MDNS service named *_hap._tcp.*  The fields broadcast by HomeSpan are a combination of all data elements requires by HAP (HAP-R2, Table 6-7) plus three additional HomeSpan fields:

  * *hspn* - the version number of the HomeSpan library used to compile the sketch
  * *sketch* - the version number of the sketch, as specified with `homeSpan.setSketchVersion(const char *)`, or *n/a* if no version was specified
  * *ota* - either *yes* or *no* depending on whether OTA was enabled for the sketch using the method `homeSpan.enableOTA()` 

#### Does HomeSpan support Television Services?

* Yes.  Though undocumented by Apple and not officially part of HAP-R2, HomeSpan supports HomeKit Television controls.  See [Television Services](TVServices.md) for details.

#### Can you use HomeSpan via Bluetooth?

* No.  HomeSpan does not support Apple's HAP-R2 protocol for HomeKit connectivity via Bluetooth.  However, you can still use the Bluetooth radio on your device for other connectivity unrelated to HomeKit if needed.

#### Can you use HomeSpan with an Ethernet connection instead of a WiFi connection?

* Yes, provided that you are using HomeSpan 2.0.0 or later and that the Ethernet board you are using is supported by the Arduino-ESP32 library.  Users are responsible for establishing Ethernet connectivity by calling the Arduino library `ETH.begin()` function from the `setup()` portion of their sketch with parameters appropriate for their specific Ethernet board.  At startup, if HomeSpan detects an Ethernet interface device has been properly configured and found (even if the Ethernet cable itself is not yet plugged in) it will automatically switch into "Ethernet mode" and use Ethernet instead of WiFi for all communications to and from your home network.

#### Does HomeSpan work with SPI and I2C?

* Yes. the standard Arduino libraries `SPI.h` and `Wire.h` both work well within the HomeSpan environment.  Typically the code to read from an SPI or I2C device is implemented within the `loop()` method of a HomeSpan Service with any initialization being done in the constructor for that Service.  See [TemperatureSensorI2C](https://github.com/HomeSpan/TempSensorI2C) for an illustrative example.

#### Can you add a Web Server to HomeSpan?

* Yes, provided you implement your Web Server using standard ESP32-Arduino libraries, such as `WebServer.h`. See [ProgrammableHub](../examples/Other%20Examples/ProgrammableHub) for an illustrative example of how to easily integrate a Web Server into HomeSpan.  This project also covers various other advanced topics, including TCP slot management, dynamic creation of Accessories, and saving arbitrary data in the ESP32's NVS.

#### Can you add *custom* Services and Characteristics to HomeSpan?

* Yes. HomeSpan includes two easy-to-use macros to define your own custom Services and custom Characteristics beyond those specified in HAP-R2.  See the [HomeSpan API Reference](Reference.md#custom-characteristics-and-custom-services-macros) for details and examples demonstrating how to do this.  Note that any new Characteristics you create will be *completely ignored* by the Home App.  Similarly, any new Services you create will be shown in the Home App on a tile labeled "Not Supported".  Apple ***does not*** provide any mechanism to extend the functionality of the Home App itself.  However, the place where custom Services and Characteristics can be used is in third-party applications designed for these extra features.  For example, the *Eve for HomeKit* App properly handles all the Services and Characteristics defined in HAP-R2, *plus* a variety of additional Services and Characteristics designed explictly for use with Eve products.  If you know the UUID codes for these extra Services and Characteristics you can add them to HomeKit and use them within the Eve App just as if they were HAP-R2 Services and Characteristics.

#### Can HomeSpan be used for commercial devices?

* No, an MFi license is needed to create commercial devices. HomeSpan was developed using Apple's HAP-R2 specs, which Apple provides for [non-commercial devices that won't be distributed or sold](https://developers.apple.com/homekit/faq/).  Though I believe the commercial specifications are functionally the same, there is a slight, but critical, difference in the pairing protocol between HAP-R2 and MFi. Note that when you pair a HomeSpan device (or any device that is based on HAP-R2, such as Apple's HAP-R2 ADK, Espressif's non-commercial ADK, HomeBridge, etc.) the Home App on your iPhone will flag the device as uncertified and require you to grant it permission to proceed with pairing. This warning message about the device being uncertified does not appear on commercial devices, presumably because Apple provides the licensee with a custom MFi authorization code that is recognized by the iPhone.

#### Why does the Home App indicate the Doorbell Service is unsupported?

* Though not documented in HAP-R2, it appears that the Doorbell Service is designed to be used in conjunction with another service, such as the Lock Mechanism.  If you add in a second service, the Home App will show the appropriate Tile (such as a Lock) with the Doorbell being the second service.  However, you can still use the Doorbell Service on a standalone basis --- even though the Home App says it is unsupported, a button press on the device will properly trigger a chime on your Home Pods as expected.

#### How can I read the current date and time from within my sketch?

* HomeSpan can automatically acquire the current date and time for your local timezone when you enable the HomeSpan Web Log using `homeSpan.enableWebLog()`. Note this command can be used to set the date and time even without enabling the Web Log itself (see the [HomeSpan API Reference](Reference.md) for details on how to do this).  Once the date and time has been acquired, you can use the built-in Arduino-ESP32 `getLocalTime(struct tm *info)` command whenever needed to populate *info* with the current date and time.  Note *info* is in [standard Unix](https://man7.org/linux/man-pages/man0/time.h.0p.html) `struct tm` format which is easily parsed as follows:

```C++
struct tm myTime;        // create a tm structure
getLocalTime(&myTime);   // populate the tm structure with current date and time

// print the individual elements of the tm structure (see standard Unix tm structure for details)

Serial.printf("Current Date = %02d/%02d/%04d\n", myTime.tm_mon+1, myTime.tm_mday, myTime.tm_year+1900);
Serial.printf("Current Time = %02d:%02d:%02d\n", myTime.tm_hour, myTime.tm_min, myTime.tm_sec);
```
  
---

[↩️](../README.md) Back to the Welcome page

