#ifndef __MACROS_H__
#define __MACROS_H__

// Error numbers which are generated by the compiler: "warning: narrowing conversion of 'xxx' from 'int' to 'const unsigned char' inside { } [-Wnarrowing]
#ifdef LONG_LED_ADDR
#define _ERR_INPUT_RANGE    (256<<6) // Is generated if the In number is >= 16384       (_INP_STRUCT_ARRAY_SIZE * 4)
#define _ERR_LED_RANGE      (512<<6) // Is generated if the LED number is >= NUM_LEDS
#else
#define _ERR_INPUT_RANGE    256 // Is generated if the In number is >= 256       (_INP_STRUCT_ARRAY_SIZE * 4)
#define _ERR_LED_RANGE      512 // Is generated if the LED number is >= NUM_LEDS
#endif

#define _INP_STRUCT_ARRAY_SIZE  64       // _INP_STRUCT_ARRAY_SIZE*4 defines the maximal number of inputs (Maximal 64)    11.12.19:  Reduzieren auf 8 vergroessert den FLASH Bedarf um 6 Bytes?
#define _MAX_INP_CHANNEL (_INP_STRUCT_ARRAY_SIZE*4-1)

#define _ChkIn(In) ((In) < _INP_STRUCT_ARRAY_SIZE*4 ? (In) : _ERR_INPUT_RANGE) // Generate a compiler warning if the input channel is invalid
                                                                               // In this case th input is mapped to 0.
                                                                               //   LEDs_Eisenbahn.ino:268:3: warning: narrowing conversion of '256' from 'int' to 'const unsigned char' inside { } [-Wnarrowing]
                                                                               //   LEDs_Eisenbahn.ino:268:3: warning: large integer implicitly truncated to unsigned type [-Woverflow]
                                                                               // Normaly this message is not generated because _INP_STRUCT_ARRAY_SIZE is set to 64 => 256 inputs are possible

// Todo: Warum wird hier uint32_t und nicht uint16_t verwendet ?
#define _W2B(w)   (((uint32_t)(w))&0xFF), (((uint32_t)(w))>>8)             // Split a 16 bit number into two bytes. Maximal value 65535
#define _T2B(t)   _W2B(t)                                                  // Split a time into two bytes. Maximal value 65535ms = 65.5 Sec.


// Automatisches umschalten der Zeiten fuer RandMux() und Random()
// Wenn die Zeiten groesser als 65535 werden wird automatisch die Zeitbasis von ms auf 16 ms umgeschaltet.
// Dazu wird der Mode RF_SLOW gesetzt und die Zeiten durch 16 geteilt.
// Die Logik dazu war verzwickt weil die UND Verknuepfung "&&" als Argument des _T2B() Makros nicht funktioniert hat.
// Vielleicht lag es gar nicht an der UND Verknuepfung sondern daran, das um das _T2B() Makro noch eine Klammer war.
// Darum wurde die UND Funktion ueber eine Multiplikation geloest. Das Makro _LT_MX() liefert eine 1 wenn das Argument
// kleiner als _MAX_TIMER_VAL ist. Mehere _LT_MX() Ausdruecke koennen miteinander multipliziert werden. Das Ergebnis
// ist nur dann 1 wenn alle Teile zutreffen.

// Disable warning in _ALL_LT_MX2 and _ALL_LT_MX4
#define GCC_VERSION (__GNUC__ * 10000L + __GNUC_MINOR__ * 100L + __GNUC_PATCHLEVEL__)
#if GCC_VERSION >= 70300L     // Don't know exactly in which version this check was added                     // 07.10.19:
  #pragma GCC diagnostic ignored "-Wint-in-bool-context"                                                      // 05.10.19:
#endif
// Todo: Noch mal mit logischer verknuepfung und nit mit "*" versuchen. Dann kann das #pragma wieder entfallen

#define _MAX_TIMER_VAL 65536  // Could be chaged to test the automatic switching
#define _LT_MX(MaxTime)                                     (((MaxTime)<_MAX_TIMER_VAL)?1:0)
#define _ALL_LT_MX2(MinTime,MaxTime)                        ((_LT_MX(MinTime) * _LT_MX(MaxTime)  * _LT_MX((MinTime)+(MaxTime))))  // Die Multiplikation kann wie eine UND Verknuepfung verwendet werden
#define _ALL_LT_MX4(MinTime1, MaxTime1, MinTime2, MaxTime2) (_ALL_LT_MX2((MinTime1), (MaxTime1)) * _ALL_LT_MX2((MinTime2), (MaxTime2)))
#define _RAND_MODE2(MinTime,  MaxTime)                      (_ALL_LT_MX2((MinTime ), (MaxTime )                    )?0:RF_SLOW)
#define _RAND_MODE4(MinTime1, MaxTime1, MinTime2, MaxTime2) (_ALL_LT_MX4((MinTime1), (MaxTime1), MinTime2, MaxTime2)?0:RF_SLOW)
#define _RAND_DIV2( MinTime,  MaxTime)                      (_ALL_LT_MX2((MinTime), (MaxTime)                          )?1L:16L)
#define _RAND_DIV4( MinTime1, MaxTime1, MinTime2, MaxTime2) (_ALL_LT_MX4((MinTime1),(MaxTime1), (MinTime2), (MaxTime2) )?1L:16L)
#define _Tx2B2(Time, OtherTime)                             _T2B((Time)/_RAND_DIV2((Time), (OtherTime)))                            // Hier darf aussen herum kleine Klammer hinzugefuegt werden weil das Ergebnis zwei durch Komma getrennte Bytes sind
#define _Tx2B4(Time, OtherTime1, OtherTime2, OtherTime3)    _T2B((Time)/_RAND_DIV4((Time), (OtherTime1), (OtherTime2), (OtherTime3)))

// Checking the leds[] array size. Therefore "NUM_LEDS" must be defined in the sketch.
#ifdef LONG_LED_ADDR
#define _CHKL(LED) _W2B((LED) < NUM_LEDS ? (LED) : _ERR_LED_RANGE)
#else
#define _CHKL(LED) ((LED) < NUM_LEDS ? (LED) : _ERR_LED_RANGE) 
#endif
                                                               // If you got the error "'NUM_LEDS' was not declared in this scope" you have do add a #define NUM_LEDS ... line to your sketch
                                                               // The warnung "warning: narrowing conversion of '512' from 'int' to 'const unsigned char' inside { } [-Wnarrowing]"
                                                               // is generated if the LED number is >= NUM_LEDS


/*
Ueberlegung zur Erweiterung der Anzahl der Timing Parameter                                                  // 13.10.20:
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 Es gibt 6 Gruppen wobei es jede Gruppe ein mal mit Enable und einmal ohne gibt
 => 3 Gruppen
 Jede Gruppe enthlt 30, seit Version 1.9.6F 32 Zeiten.
 Es wre schn, wenn man die Anzahl der Zeiten vergrern knnte am besten gleich auf 256.
 Dazu muss aber einiges umgestellt werden.
 - Es darf nur noch ein Macro pro Gruppe geben
 - Ein zustzliches Byte enthlt die Anzahl der Zeiten
 - Evtl. muss __VA_ARGS__ vergrert werden

 #define PatternT1(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1, ...)  PATTERNT1_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define APatternT1(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1, ...)  APATTERNT1_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT1(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1, ...)  APATTERNT1_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,

 #define PatternTE1(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1, ...)  PATTERNT1_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define APatternTE1( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1, ...)  APATTERNT1_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE1( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1, ...)  APATTERNT1_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,

 Problem: Die Zeiten mssen als zwei Bytes abgelegt werden. Das macht momentan _T2B().
          Das Funktioniert nicht wenn die Parameter als variable Argumentliste bergeben werden ;-(

 => Man braucht die vielen Makros
 ==> Es wird auf die bisherige methode auf 64 Zeiten erweitert  14.10.20:

//#define PATTERN_W256_TIMES

#ifdef PATTERN_W256_TIMES                                                                                     // 14.10.20:
  // Maximal time for one time interval 65.535 Sec
  #define PatternTn(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,TimeCnt, ...)  PATTERNT_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          TimeCnt,_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
  #define APatternTn( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,TimeCnt, ...) APATTERNT_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          TimeCnt,_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
  #define XPatternTn( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,TimeCnt, ...) APATTERNT_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,TimeCnt,_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
  #define PatternETn( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,TimeCnt, ...)  PATTERNT_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          TimeCnt,_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
  #define APatternETn(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,TimeCnt, ...) APATTERNT_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          TimeCnt,_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
  #define XPatternETn(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,TimeCnt, ...) APATTERNT_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,TimeCnt,_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,

  // For compatibility with existing macros
  #define PatternT1( LED,NStru,InCh,LEDs,Val0,Val1,Off,Mode, ...) PatternTn(LED,NStru,InCh,LEDs,Val0,Val1,Off,Mode,1, __VA_ARGS__)
  #define PatternT2( LED,NStru,InCh,LEDs,Val0,Val1,Off,Mode, ...) PatternTn(LED,NStru,InCh,LEDs,Val0,Val1,Off,Mode,2, __VA_ARGS__)
  #define PatternT3( LED,NStru,InCh,LEDs,Val0,Val1,Off,Mode, ...) PatternTn(LED,NStru,InCh,LEDs,Val0,Val1,Off,Mode,3, __VA_ARGS__)
  //:
*/


// Created by Create_Pattern_H_File() from Prog_Generator_MobaLedLib.xlsm

#define  PatternT1(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,...)                                                                                                                                                                                                                                                                  PATTERNT1_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT2(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,...)                                                                                                                                                                                                                                                               PATTERNT2_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT3(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,...)                                                                                                                                                                                                                                                            PATTERNT3_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT4(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,...)                                                                                                                                                                                                                                                         PATTERNT4_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT5(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,...)                                                                                                                                                                                                                                                      PATTERNT5_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT6(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,...)                                                                                                                                                                                                                                                   PATTERNT6_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT7(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,...)                                                                                                                                                                                                                                                PATTERNT7_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT8(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,...)                                                                                                                                                                                                                                             PATTERNT8_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT9(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,...)                                                                                                                                                                                                                                          PATTERNT9_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT10(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,...)                                                                                                                                                                                                                                      PATTERNT10_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT11(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,...)                                                                                                                                                                                                                                  PATTERNT11_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT12(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,...)                                                                                                                                                                                                                              PATTERNT12_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT13(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,...)                                                                                                                                                                                                                          PATTERNT13_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT14(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,...)                                                                                                                                                                                                                      PATTERNT14_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT15(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,...)                                                                                                                                                                                                                  PATTERNT15_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT16(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,...)                                                                                                                                                                                                              PATTERNT16_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT17(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,...)                                                                                                                                                                                                          PATTERNT17_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT18(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,...)                                                                                                                                                                                                      PATTERNT18_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT19(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,...)                                                                                                                                                                                                  PATTERNT19_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT20(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,...)                                                                                                                                                                                              PATTERNT20_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT21(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,...)                                                                                                                                                                                          PATTERNT21_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT22(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,...)                                                                                                                                                                                      PATTERNT22_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT23(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,...)                                                                                                                                                                                  PATTERNT23_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT24(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,...)                                                                                                                                                                              PATTERNT24_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT25(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,...)                                                                                                                                                                          PATTERNT25_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT26(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,...)                                                                                                                                                                      PATTERNT26_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT27(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,...)                                                                                                                                                                  PATTERNT27_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT28(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,...)                                                                                                                                                              PATTERNT28_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT29(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,...)                                                                                                                                                          PATTERNT29_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT30(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,...)                                                                                                                                                      PATTERNT30_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT31(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,...)                                                                                                                                                  PATTERNT31_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT32(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,...)                                                                                                                                              PATTERNT32_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT33(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,...)                                                                                                                                          PATTERNT33_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT34(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,...)                                                                                                                                      PATTERNT34_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT35(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,...)                                                                                                                                  PATTERNT35_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT36(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,...)                                                                                                                              PATTERNT36_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT37(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,...)                                                                                                                          PATTERNT37_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT38(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,...)                                                                                                                      PATTERNT38_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT39(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,...)                                                                                                                  PATTERNT39_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT40(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,...)                                                                                                              PATTERNT40_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT41(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,...)                                                                                                          PATTERNT41_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT42(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,...)                                                                                                      PATTERNT42_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT43(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,...)                                                                                                  PATTERNT43_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT44(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,...)                                                                                              PATTERNT44_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT45(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,...)                                                                                          PATTERNT45_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT46(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,...)                                                                                      PATTERNT46_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT47(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,...)                                                                                  PATTERNT47_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT48(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,...)                                                                              PATTERNT48_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT49(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,...)                                                                          PATTERNT49_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT50(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,...)                                                                      PATTERNT50_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT51(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,...)                                                                  PATTERNT51_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT52(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,...)                                                              PATTERNT52_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT53(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,...)                                                          PATTERNT53_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT54(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,...)                                                      PATTERNT54_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT55(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,...)                                                  PATTERNT55_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT56(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,...)                                              PATTERNT56_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT57(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,...)                                          PATTERNT57_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT58(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,...)                                      PATTERNT58_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT59(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,...)                                  PATTERNT59_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT60(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,...)                              PATTERNT60_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT61(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,...)                          PATTERNT61_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT62(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,...)                      PATTERNT62_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT63(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,...)                  PATTERNT63_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternT64(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,T64,...)              PATTERNT64_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_T2B(T64),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,

#define APatternT1(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,...)                                                                                                                                                                                                                                                                 APATTERNT1_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT2(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,...)                                                                                                                                                                                                                                                              APATTERNT2_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT3(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,...)                                                                                                                                                                                                                                                           APATTERNT3_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT4(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,...)                                                                                                                                                                                                                                                        APATTERNT4_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT5(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,...)                                                                                                                                                                                                                                                     APATTERNT5_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT6(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,...)                                                                                                                                                                                                                                                  APATTERNT6_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT7(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,...)                                                                                                                                                                                                                                               APATTERNT7_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT8(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,...)                                                                                                                                                                                                                                            APATTERNT8_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT9(   LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,...)                                                                                                                                                                                                                                         APATTERNT9_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT10(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,...)                                                                                                                                                                                                                                     APATTERNT10_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT11(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,...)                                                                                                                                                                                                                                 APATTERNT11_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT12(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,...)                                                                                                                                                                                                                             APATTERNT12_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT13(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,...)                                                                                                                                                                                                                         APATTERNT13_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT14(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,...)                                                                                                                                                                                                                     APATTERNT14_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT15(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,...)                                                                                                                                                                                                                 APATTERNT15_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT16(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,...)                                                                                                                                                                                                             APATTERNT16_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT17(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,...)                                                                                                                                                                                                         APATTERNT17_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT18(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,...)                                                                                                                                                                                                     APATTERNT18_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT19(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,...)                                                                                                                                                                                                 APATTERNT19_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT20(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,...)                                                                                                                                                                                             APATTERNT20_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT21(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,...)                                                                                                                                                                                         APATTERNT21_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT22(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,...)                                                                                                                                                                                     APATTERNT22_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT23(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,...)                                                                                                                                                                                 APATTERNT23_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT24(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,...)                                                                                                                                                                             APATTERNT24_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT25(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,...)                                                                                                                                                                         APATTERNT25_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT26(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,...)                                                                                                                                                                     APATTERNT26_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT27(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,...)                                                                                                                                                                 APATTERNT27_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT28(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,...)                                                                                                                                                             APATTERNT28_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT29(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,...)                                                                                                                                                         APATTERNT29_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT30(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,...)                                                                                                                                                     APATTERNT30_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT31(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,...)                                                                                                                                                 APATTERNT31_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT32(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,...)                                                                                                                                             APATTERNT32_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT33(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,...)                                                                                                                                         APATTERNT33_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT34(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,...)                                                                                                                                     APATTERNT34_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT35(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,...)                                                                                                                                 APATTERNT35_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT36(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,...)                                                                                                                             APATTERNT36_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT37(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,...)                                                                                                                         APATTERNT37_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT38(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,...)                                                                                                                     APATTERNT38_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT39(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,...)                                                                                                                 APATTERNT39_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT40(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,...)                                                                                                             APATTERNT40_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT41(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,...)                                                                                                         APATTERNT41_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT42(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,...)                                                                                                     APATTERNT42_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT43(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,...)                                                                                                 APATTERNT43_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT44(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,...)                                                                                             APATTERNT44_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT45(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,...)                                                                                         APATTERNT45_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT46(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,...)                                                                                     APATTERNT46_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT47(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,...)                                                                                 APATTERNT47_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT48(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,...)                                                                             APATTERNT48_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT49(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,...)                                                                         APATTERNT49_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT50(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,...)                                                                     APATTERNT50_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT51(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,...)                                                                 APATTERNT51_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT52(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,...)                                                             APATTERNT52_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT53(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,...)                                                         APATTERNT53_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT54(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,...)                                                     APATTERNT54_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT55(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,...)                                                 APATTERNT55_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT56(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,...)                                             APATTERNT56_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT57(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,...)                                         APATTERNT57_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT58(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,...)                                     APATTERNT58_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT59(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,...)                                 APATTERNT59_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT60(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,...)                             APATTERNT60_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT61(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,...)                         APATTERNT61_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT62(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,...)                     APATTERNT62_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT63(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,...)                 APATTERNT63_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternT64(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,T64,...)             APATTERNT64_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_T2B(T64),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,

#define USE_XFADE // 220 Bytes Flash
#ifdef USE_XFADE
// Drittes Makro bei dem fuer jede LED ein Byte RAM Reserviert wird. Das wird benoetigt wenn das flag _PF_XFADE gesetzt ist.
// Dummerweise kann bei dieser Funktion keine Berechnung beim Parameter LED gemacht werden ;-(
 #define XPatternT1(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,...)                                                                                                                                                                                                                                                                 APATTERNT1_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT2(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,...)                                                                                                                                                                                                                                                              APATTERNT2_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT3(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,...)                                                                                                                                                                                                                                                           APATTERNT3_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT4(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,...)                                                                                                                                                                                                                                                        APATTERNT4_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT5(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,...)                                                                                                                                                                                                                                                     APATTERNT5_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT6(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,...)                                                                                                                                                                                                                                                  APATTERNT6_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT7(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,...)                                                                                                                                                                                                                                               APATTERNT7_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT8(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,...)                                                                                                                                                                                                                                            APATTERNT8_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT9(  LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,...)                                                                                                                                                                                                                                         APATTERNT9_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT10( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,...)                                                                                                                                                                                                                                     APATTERNT10_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT11( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,...)                                                                                                                                                                                                                                 APATTERNT11_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT12( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,...)                                                                                                                                                                                                                             APATTERNT12_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT13( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,...)                                                                                                                                                                                                                         APATTERNT13_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT14( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,...)                                                                                                                                                                                                                     APATTERNT14_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT15( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,...)                                                                                                                                                                                                                 APATTERNT15_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT16( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,...)                                                                                                                                                                                                             APATTERNT16_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT17( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,...)                                                                                                                                                                                                         APATTERNT17_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT18( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,...)                                                                                                                                                                                                     APATTERNT18_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT19( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,...)                                                                                                                                                                                                 APATTERNT19_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT20( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,...)                                                                                                                                                                                             APATTERNT20_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT21( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,...)                                                                                                                                                                                         APATTERNT21_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT22( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,...)                                                                                                                                                                                     APATTERNT22_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT23( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,...)                                                                                                                                                                                 APATTERNT23_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT24( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,...)                                                                                                                                                                             APATTERNT24_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT25( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,...)                                                                                                                                                                         APATTERNT25_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT26( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,...)                                                                                                                                                                     APATTERNT26_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT27( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,...)                                                                                                                                                                 APATTERNT27_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT28( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,...)                                                                                                                                                             APATTERNT28_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT29( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,...)                                                                                                                                                         APATTERNT29_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT30( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,...)                                                                                                                                                     APATTERNT30_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT31( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,...)                                                                                                                                                 APATTERNT31_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT32( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,...)                                                                                                                                             APATTERNT32_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT33( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,...)                                                                                                                                         APATTERNT33_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT34( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,...)                                                                                                                                     APATTERNT34_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT35( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,...)                                                                                                                                 APATTERNT35_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT36( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,...)                                                                                                                             APATTERNT36_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT37( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,...)                                                                                                                         APATTERNT37_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT38( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,...)                                                                                                                     APATTERNT38_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT39( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,...)                                                                                                                 APATTERNT39_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT40( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,...)                                                                                                             APATTERNT40_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT41( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,...)                                                                                                         APATTERNT41_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT42( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,...)                                                                                                     APATTERNT42_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT43( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,...)                                                                                                 APATTERNT43_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT44( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,...)                                                                                             APATTERNT44_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT45( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,...)                                                                                         APATTERNT45_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT46( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,...)                                                                                     APATTERNT46_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT47( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,...)                                                                                 APATTERNT47_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT48( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,...)                                                                             APATTERNT48_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT49( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,...)                                                                         APATTERNT49_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT50( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,...)                                                                     APATTERNT50_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT51( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,...)                                                                 APATTERNT51_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT52( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,...)                                                             APATTERNT52_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT53( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,...)                                                         APATTERNT53_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT54( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,...)                                                     APATTERNT54_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT55( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,...)                                                 APATTERNT55_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT56( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,...)                                             APATTERNT56_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT57( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,...)                                         APATTERNT57_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT58( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,...)                                     APATTERNT58_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT59( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,...)                                 APATTERNT59_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT60( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,...)                             APATTERNT60_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT61( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,...)                         APATTERNT61_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT62( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,...)                     APATTERNT62_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT63( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,...)                 APATTERNT63_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternT64( LED,NStru,InCh,       LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,T64,...)             APATTERNT64_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),SI_1,  LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_T2B(T64),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#endif

// Same macros with an enable input 05.11.18:

#define  PatternTE1(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,...)                                                                                                                                                                                                                                                                  PATTERNT1_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE2(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,...)                                                                                                                                                                                                                                                               PATTERNT2_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE3(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,...)                                                                                                                                                                                                                                                            PATTERNT3_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE4(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,...)                                                                                                                                                                                                                                                         PATTERNT4_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE5(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,...)                                                                                                                                                                                                                                                      PATTERNT5_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE6(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,...)                                                                                                                                                                                                                                                   PATTERNT6_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE7(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,...)                                                                                                                                                                                                                                                PATTERNT7_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE8(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,...)                                                                                                                                                                                                                                             PATTERNT8_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE9(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,...)                                                                                                                                                                                                                                          PATTERNT9_T,  _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE10( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,...)                                                                                                                                                                                                                                      PATTERNT10_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE11( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,...)                                                                                                                                                                                                                                  PATTERNT11_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE12( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,...)                                                                                                                                                                                                                              PATTERNT12_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE13( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,...)                                                                                                                                                                                                                          PATTERNT13_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE14( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,...)                                                                                                                                                                                                                      PATTERNT14_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE15( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,...)                                                                                                                                                                                                                  PATTERNT15_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE16( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,...)                                                                                                                                                                                                              PATTERNT16_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE17( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,...)                                                                                                                                                                                                          PATTERNT17_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE18( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,...)                                                                                                                                                                                                      PATTERNT18_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE19( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,...)                                                                                                                                                                                                  PATTERNT19_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE20( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,...)                                                                                                                                                                                              PATTERNT20_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE21( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,...)                                                                                                                                                                                          PATTERNT21_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE22( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,...)                                                                                                                                                                                      PATTERNT22_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE23( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,...)                                                                                                                                                                                  PATTERNT23_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE24( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,...)                                                                                                                                                                              PATTERNT24_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE25( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,...)                                                                                                                                                                          PATTERNT25_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE26( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,...)                                                                                                                                                                      PATTERNT26_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE27( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,...)                                                                                                                                                                  PATTERNT27_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE28( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,...)                                                                                                                                                              PATTERNT28_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE29( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,...)                                                                                                                                                          PATTERNT29_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE30( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,...)                                                                                                                                                      PATTERNT30_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE31( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,...)                                                                                                                                                  PATTERNT31_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE32( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,...)                                                                                                                                              PATTERNT32_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE33( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,...)                                                                                                                                          PATTERNT33_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE34( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,...)                                                                                                                                      PATTERNT34_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE35( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,...)                                                                                                                                  PATTERNT35_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE36( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,...)                                                                                                                              PATTERNT36_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE37( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,...)                                                                                                                          PATTERNT37_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE38( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,...)                                                                                                                      PATTERNT38_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE39( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,...)                                                                                                                  PATTERNT39_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE40( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,...)                                                                                                              PATTERNT40_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE41( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,...)                                                                                                          PATTERNT41_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE42( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,...)                                                                                                      PATTERNT42_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE43( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,...)                                                                                                  PATTERNT43_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE44( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,...)                                                                                              PATTERNT44_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE45( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,...)                                                                                          PATTERNT45_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE46( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,...)                                                                                      PATTERNT46_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE47( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,...)                                                                                  PATTERNT47_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE48( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,...)                                                                              PATTERNT48_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE49( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,...)                                                                          PATTERNT49_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE50( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,...)                                                                      PATTERNT50_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE51( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,...)                                                                  PATTERNT51_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE52( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,...)                                                              PATTERNT52_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE53( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,...)                                                          PATTERNT53_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE54( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,...)                                                      PATTERNT54_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE55( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,...)                                                  PATTERNT55_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE56( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,...)                                              PATTERNT56_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE57( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,...)                                          PATTERNT57_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE58( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,...)                                      PATTERNT58_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE59( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,...)                                  PATTERNT59_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE60( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,...)                              PATTERNT60_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE61( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,...)                          PATTERNT61_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE62( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,...)                      PATTERNT62_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE63( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,...)                  PATTERNT63_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define  PatternTE64( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,T64,...)              PATTERNT64_T, _CHKL(LED)+RAM5,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_T2B(T64),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,

#define APatternTE1(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,...)                                                                                                                                                                                                                                                                 APATTERNT1_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE2(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,...)                                                                                                                                                                                                                                                              APATTERNT2_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE3(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,...)                                                                                                                                                                                                                                                           APATTERNT3_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE4(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,...)                                                                                                                                                                                                                                                        APATTERNT4_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE5(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,...)                                                                                                                                                                                                                                                     APATTERNT5_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE6(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,...)                                                                                                                                                                                                                                                  APATTERNT6_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE7(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,...)                                                                                                                                                                                                                                               APATTERNT7_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE8(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,...)                                                                                                                                                                                                                                            APATTERNT8_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE9(  LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,...)                                                                                                                                                                                                                                         APATTERNT9_T,  _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE10( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,...)                                                                                                                                                                                                                                     APATTERNT10_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE11( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,...)                                                                                                                                                                                                                                 APATTERNT11_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE12( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,...)                                                                                                                                                                                                                             APATTERNT12_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE13( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,...)                                                                                                                                                                                                                         APATTERNT13_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE14( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,...)                                                                                                                                                                                                                     APATTERNT14_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE15( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,...)                                                                                                                                                                                                                 APATTERNT15_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE16( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,...)                                                                                                                                                                                                             APATTERNT16_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE17( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,...)                                                                                                                                                                                                         APATTERNT17_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE18( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,...)                                                                                                                                                                                                     APATTERNT18_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE19( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,...)                                                                                                                                                                                                 APATTERNT19_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE20( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,...)                                                                                                                                                                                             APATTERNT20_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE21( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,...)                                                                                                                                                                                         APATTERNT21_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE22( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,...)                                                                                                                                                                                     APATTERNT22_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE23( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,...)                                                                                                                                                                                 APATTERNT23_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE24( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,...)                                                                                                                                                                             APATTERNT24_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE25( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,...)                                                                                                                                                                         APATTERNT25_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE26( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,...)                                                                                                                                                                     APATTERNT26_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE27( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,...)                                                                                                                                                                 APATTERNT27_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE28( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,...)                                                                                                                                                             APATTERNT28_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE29( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,...)                                                                                                                                                         APATTERNT29_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE30( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,...)                                                                                                                                                     APATTERNT30_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE31( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,...)                                                                                                                                                 APATTERNT31_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE32( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,...)                                                                                                                                             APATTERNT32_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE33( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,...)                                                                                                                                         APATTERNT33_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE34( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,...)                                                                                                                                     APATTERNT34_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE35( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,...)                                                                                                                                 APATTERNT35_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE36( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,...)                                                                                                                             APATTERNT36_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE37( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,...)                                                                                                                         APATTERNT37_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE38( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,...)                                                                                                                     APATTERNT38_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE39( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,...)                                                                                                                 APATTERNT39_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE40( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,...)                                                                                                             APATTERNT40_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE41( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,...)                                                                                                         APATTERNT41_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE42( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,...)                                                                                                     APATTERNT42_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE43( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,...)                                                                                                 APATTERNT43_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE44( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,...)                                                                                             APATTERNT44_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE45( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,...)                                                                                         APATTERNT45_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE46( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,...)                                                                                     APATTERNT46_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE47( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,...)                                                                                 APATTERNT47_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE48( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,...)                                                                             APATTERNT48_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE49( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,...)                                                                         APATTERNT49_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE50( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,...)                                                                     APATTERNT50_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE51( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,...)                                                                 APATTERNT51_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE52( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,...)                                                             APATTERNT52_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE53( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,...)                                                         APATTERNT53_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE54( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,...)                                                     APATTERNT54_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE55( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,...)                                                 APATTERNT55_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE56( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,...)                                             APATTERNT56_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE57( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,...)                                         APATTERNT57_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE58( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,...)                                     APATTERNT58_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE59( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,...)                                 APATTERNT59_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE60( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,...)                             APATTERNT60_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE61( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,...)                         APATTERNT61_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE62( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,...)                     APATTERNT62_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE63( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,...)                 APATTERNT63_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#define APatternTE64( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,T64,...)             APATTERNT64_T, _CHKL(LED)+RAM7,           (NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode,          _T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_T2B(T64),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,

#ifdef USE_XFADE
// Drittes Makro bei dem fuer jede LED ein Byte RAM Reserviert wird. Das wird benoetigt wenn das flag _PF_XFADE gesetzt ist.
// Dummerweise kann bei dieser Funktion keine Berechnung beim Parameter LED gemacht werden ;-(
 #define XPatternTE1( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,...)                                                                                                                                                                                                                                                                 APATTERNT1_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE2( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,...)                                                                                                                                                                                                                                                              APATTERNT2_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE3( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,...)                                                                                                                                                                                                                                                           APATTERNT3_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE4( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,...)                                                                                                                                                                                                                                                        APATTERNT4_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE5( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,...)                                                                                                                                                                                                                                                     APATTERNT5_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE6( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,...)                                                                                                                                                                                                                                                  APATTERNT6_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE7( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,...)                                                                                                                                                                                                                                               APATTERNT7_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE8( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,...)                                                                                                                                                                                                                                            APATTERNT8_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE9( LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,...)                                                                                                                                                                                                                                         APATTERNT9_T,  _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE10(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,...)                                                                                                                                                                                                                                     APATTERNT10_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE11(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,...)                                                                                                                                                                                                                                 APATTERNT11_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE12(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,...)                                                                                                                                                                                                                             APATTERNT12_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE13(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,...)                                                                                                                                                                                                                         APATTERNT13_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE14(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,...)                                                                                                                                                                                                                     APATTERNT14_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE15(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,...)                                                                                                                                                                                                                 APATTERNT15_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE16(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,...)                                                                                                                                                                                                             APATTERNT16_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE17(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,...)                                                                                                                                                                                                         APATTERNT17_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE18(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,...)                                                                                                                                                                                                     APATTERNT18_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE19(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,...)                                                                                                                                                                                                 APATTERNT19_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE20(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,...)                                                                                                                                                                                             APATTERNT20_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE21(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,...)                                                                                                                                                                                         APATTERNT21_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE22(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,...)                                                                                                                                                                                     APATTERNT22_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE23(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,...)                                                                                                                                                                                 APATTERNT23_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE24(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,...)                                                                                                                                                                             APATTERNT24_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE25(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,...)                                                                                                                                                                         APATTERNT25_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE26(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,...)                                                                                                                                                                     APATTERNT26_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE27(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,...)                                                                                                                                                                 APATTERNT27_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE28(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,...)                                                                                                                                                             APATTERNT28_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE29(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,...)                                                                                                                                                         APATTERNT29_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE30(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,...)                                                                                                                                                     APATTERNT30_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE31(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,...)                                                                                                                                                 APATTERNT31_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE32(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,...)                                                                                                                                             APATTERNT32_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE33(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,...)                                                                                                                                         APATTERNT33_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE34(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,...)                                                                                                                                     APATTERNT34_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE35(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,...)                                                                                                                                 APATTERNT35_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE36(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,...)                                                                                                                             APATTERNT36_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE37(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,...)                                                                                                                         APATTERNT37_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE38(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,...)                                                                                                                     APATTERNT38_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE39(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,...)                                                                                                                 APATTERNT39_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE40(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,...)                                                                                                             APATTERNT40_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE41(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,...)                                                                                                         APATTERNT41_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE42(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,...)                                                                                                     APATTERNT42_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE43(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,...)                                                                                                 APATTERNT43_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE44(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,...)                                                                                             APATTERNT44_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE45(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,...)                                                                                         APATTERNT45_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE46(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,...)                                                                                     APATTERNT46_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE47(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,...)                                                                                 APATTERNT47_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE48(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,...)                                                                             APATTERNT48_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE49(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,...)                                                                         APATTERNT49_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE50(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,...)                                                                     APATTERNT50_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE51(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,...)                                                                 APATTERNT51_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE52(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,...)                                                             APATTERNT52_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE53(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,...)                                                         APATTERNT53_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE54(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,...)                                                     APATTERNT54_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE55(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,...)                                                 APATTERNT55_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE56(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,...)                                             APATTERNT56_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE57(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,...)                                         APATTERNT57_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE58(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,...)                                     APATTERNT58_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE59(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,...)                                 APATTERNT59_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE60(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,...)                             APATTERNT60_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE61(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,...)                         APATTERNT61_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE62(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,...)                     APATTERNT62_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE63(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,...)                 APATTERNT63_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
 #define XPatternTE64(LED,NStru,InCh,Enable,LEDs,Val0,Val1,Off,Mode,T1,T2,T3,T4,T5,T6,T7,T8,T9,T10,T11,T12,T13,T14,T15,T16,T17,T18,T19,T20,T21,T22,T23,T24,T25,T26,T27,T28,T29,T30,T31,T32,T33,T34,T35,T36,T37,T38,T39,T40,T41,T42,T43,T44,T45,T46,T47,T48,T49,T50,T51,T52,T53,T54,T55,T56,T57,T58,T59,T60,T61,T62,T63,T64,...)             APATTERNT64_T, _CHKL(LED)+RAM7+RAMN(LEDs),(NStru)&0xFF,_ChkIn(InCh),Enable,LEDs,Val0,Val1,Off,Mode|_PF_XFADE,_T2B(T1),_T2B(T2),_T2B(T3),_T2B(T4),_T2B(T5),_T2B(T6),_T2B(T7),_T2B(T8),_T2B(T9),_T2B(T10),_T2B(T11),_T2B(T12),_T2B(T13),_T2B(T14),_T2B(T15),_T2B(T16),_T2B(T17),_T2B(T18),_T2B(T19),_T2B(T20),_T2B(T21),_T2B(T22),_T2B(T23),_T2B(T24),_T2B(T25),_T2B(T26),_T2B(T27),_T2B(T28),_T2B(T29),_T2B(T30),_T2B(T31),_T2B(T32),_T2B(T33),_T2B(T34),_T2B(T35),_T2B(T36),_T2B(T37),_T2B(T38),_T2B(T39),_T2B(T40),_T2B(T41),_T2B(T42),_T2B(T43),_T2B(T44),_T2B(T45),_T2B(T46),_T2B(T47),_T2B(T48),_T2B(T49),_T2B(T50),_T2B(T51),_T2B(T52),_T2B(T53),_T2B(T54),_T2B(T55),_T2B(T56),_T2B(T57),_T2B(T58),_T2B(T59),_T2B(T60),_T2B(T61),_T2B(T62),_T2B(T63),_T2B(T64),_W2B(COUNT_VARARGS(__VA_ARGS__)), __VA_ARGS__,
#endif

// Die Verschiedenen Ausgangstypen:
#define END_T                    0
#define CONST_T                  1 // Die ersten Ausgangstypen haben als Parameter eine channel mask mit
#define RANDMUX_T                2 // der ausgewaehlt wird welche LEDs angestuert werden
#define SCHEDULE_T               3 // Bei diesen Typen steht InCh an Position 2

  #define PATTERNT1_T           10 // Muster mit einer Zeit fuer alle Zustaende
  #define PATTERNT2_T           11 // Muster mit zwei abwechselnd genutzten Zeiten
  #define PATTERNT3_T           12 //   "        drei     "
  #define PATTERNT4_T           13
  #define PATTERNT5_T           14
  #define PATTERNT6_T           15
  #define PATTERNT7_T           16
  #define PATTERNT8_T           17
  #define PATTERNT9_T           18
  #define PATTERNT10_T          19
  #define PATTERNT11_T          20
  #define PATTERNT12_T          21
  #define PATTERNT13_T          22
  #define PATTERNT14_T          23
  #define PATTERNT15_T          24
  #define PATTERNT16_T          25
  #define PATTERNT17_T          26
  #define PATTERNT18_T          27
  #define PATTERNT19_T          28
  #define PATTERNT20_T          29
  #define PATTERNT21_T          30
  #define PATTERNT22_T          31
  #define PATTERNT23_T          32
  #define PATTERNT24_T          33
  #define PATTERNT25_T          34
  #define PATTERNT26_T          35
  #define PATTERNT27_T          36
  #define PATTERNT28_T          37
  #define PATTERNT29_T          38
  #define PATTERNT30_T          39
  #define PATTERNT31_T          40
  #define PATTERNT32_T          41
  #define PATTERNT33_T          42
  #define PATTERNT34_T          43
  #define PATTERNT35_T          44
  #define PATTERNT36_T          45
  #define PATTERNT37_T          46
  #define PATTERNT38_T          47
  #define PATTERNT39_T          48
  #define PATTERNT40_T          49
  #define PATTERNT41_T          50
  #define PATTERNT42_T          51
  #define PATTERNT43_T          52
  #define PATTERNT44_T          53
  #define PATTERNT45_T          54
  #define PATTERNT46_T          55
  #define PATTERNT47_T          56
  #define PATTERNT48_T          57
  #define PATTERNT49_T          58
  #define PATTERNT50_T          59
  #define PATTERNT51_T          60
  #define PATTERNT52_T          61
  #define PATTERNT53_T          62
  #define PATTERNT54_T          63
  #define PATTERNT55_T          64
  #define PATTERNT56_T          65
  #define PATTERNT57_T          66
  #define PATTERNT58_T          67
  #define PATTERNT59_T          68
  #define PATTERNT60_T          69
  #define PATTERNT61_T          70
  #define PATTERNT62_T          71
  #define PATTERNT63_T          72
  #define PATTERNT64_T          73
  #define LAST_PATTERN_T        PATTERNT64_T

  #define APATTERNT1_T          74 // Muster mit einer Zeit fuer alle Zustaende mit analogen Uebergaengen
  #define APATTERNT2_T          75 // Muster mit zwei abwechselnd genutzten Zeiten
  #define APATTERNT3_T          76 //   "        drei    "
  #define APATTERNT4_T          77
  #define APATTERNT5_T          78
  #define APATTERNT6_T          79
  #define APATTERNT7_T          80
  #define APATTERNT8_T          81
  #define APATTERNT9_T          82
  #define APATTERNT10_T         83
  #define APATTERNT11_T         84
  #define APATTERNT12_T         85
  #define APATTERNT13_T         86
  #define APATTERNT14_T         87
  #define APATTERNT15_T         88
  #define APATTERNT16_T         89
  #define APATTERNT17_T         90
  #define APATTERNT18_T         91
  #define APATTERNT19_T         92
  #define APATTERNT20_T         93
  #define APATTERNT21_T         94
  #define APATTERNT22_T         95
  #define APATTERNT23_T         96
  #define APATTERNT24_T         97
  #define APATTERNT25_T         98
  #define APATTERNT26_T         99
  #define APATTERNT27_T         100
  #define APATTERNT28_T         101
  #define APATTERNT29_T         102
  #define APATTERNT30_T         103
  #define APATTERNT31_T         104
  #define APATTERNT32_T         105
  #define APATTERNT33_T         106
  #define APATTERNT34_T         107
  #define APATTERNT35_T         108
  #define APATTERNT36_T         109
  #define APATTERNT37_T         110
  #define APATTERNT38_T         111
  #define APATTERNT39_T         112
  #define APATTERNT40_T         113
  #define APATTERNT41_T         114
  #define APATTERNT42_T         115
  #define APATTERNT43_T         116
  #define APATTERNT44_T         117
  #define APATTERNT45_T         118
  #define APATTERNT46_T         119
  #define APATTERNT47_T         120
  #define APATTERNT48_T         121
  #define APATTERNT49_T         122
  #define APATTERNT50_T         123
  #define APATTERNT51_T         124
  #define APATTERNT52_T         125
  #define APATTERNT53_T         126
  #define APATTERNT54_T         127
  #define APATTERNT55_T         128
  #define APATTERNT56_T         129
  #define APATTERNT57_T         130
  #define APATTERNT58_T         131
  #define APATTERNT59_T         132
  #define APATTERNT60_T         133
  #define APATTERNT61_T         134
  #define APATTERNT62_T         135
  #define APATTERNT63_T         136
  #define APATTERNT64_T         137

  #define LAST_APATTERN_T APATTERNT64_T

#define HOUSE_T                 138 // Erster Ausgangstyp ohne ChMsk (WITHOUT_CHANNEL_MASK). Hier steht InCh an Position 1. Bei den Typen davor steht InCh an Position 2.
#define FIRE_T                  139
#define RANDOM_T                140
#define WELDING_CONT_T          141
#define WELDING_T               142
#define COPYLED_T               143
#define COUNTER_T               144

#define NEW_HSV_GROUP_T         170  // Erster Ausgangstyp ohne InpCh (WITHOUT_INP_CH)
#define NEW_LOCAL_VAR_T         171                                                                           // 07.11.18:
#define USE_GLOBALVAR_T         172

#if _USE_INCH_TRIGGER                                                                                         // 02.06.20: New trigger method from Juergen
  #define INCH_TO_X_VAR_T       173                                                                           // 25.11.18:
  #define BIN_INCH_TO_TMPVAR_T  174                                                                           // 18.01.19:
#else
  #define INCH_TO_TMPVAR_T      173                                                                           // 25.11.18:
  #define INCH_TO_TMPVAR1_T     174                                                                           // 07.05.20:
  #define BIN_INCH_TO_TMPVAR_T  175                                                                           // 18.01.19:
  #define BIN_INCH_TO_TMPVAR1_T 176                                                                           // 07.05.20:
#endif

#ifdef _NEW_ROOM_COL
 #define SET_COLTAB_T           180
#endif
#if _USE_SET_TVTAB                                                                                            // 10.01.20:
 #define SET_TV_TAB_T           181
#endif

#if _USE_DEF_NEON                                                                                             // 12.01.20:
 #define SET_DEF_NEON_T         182
#endif

#if _USE_CANDLE
 #define SET_CANDLETAB_T        183                                                                           // 10.06.20:
#endif

#define LOGIC_T                 184
  
#define EXT_PROC_BASE_T         240    // Makro extensions may use type ids >=l EXT_PROC_BASE_T up to 255     // 21.10.21: Juergen

// Only used in the Charliplexing modul
#define CPX_LED_ASSIGNEMENT     200    // Define the LED assignement
#define CPX_ANALOG_INPUT        201    // Enable the analog input
#define CPX_ANALOG_LIMMITS      202    // Table with analog limits which defines the Goto Nr levels

#define WITHOUT_CHANNEL_MASK  HOUSE_T
#define WITHOUT_INP_CH        NEW_HSV_GROUP_T




// Using the __COUNTER__ function to calculate the RAM usage at compile time.
// Advantages:
// - Memory consumption is known at compile time and printed => No Out of memory risk at runtime
// - Individual RAM for each function
#define RAM0  0
#define RAM1  1 + __COUNTER__ - __COUNTER__
#define RAM2  RAM1+RAM1
#define RAM3  RAM2+RAM1
#define RAM4  RAM3+RAM1
#define RAM5  RAM4+RAM1
#define RAM6  RAM5+RAM1
#define RAM7  RAM6+RAM1
#define RAM8  RAM7+RAM1
#define RAM9  RAM8+RAM1
#define RAM10 RAM9+RAM1
#define RAM11 RAM10+RAM1
#define RAM12 RAM11+RAM1
#define RAM13 RAM12+RAM1
#define RAM14 RAM13+RAM1
#define RAM15 RAM14+RAM1
#define RAM16 RAM15+RAM1
#define RAM17 RAM16+RAM1
#define RAM18 RAM17+RAM1
#define RAM19 RAM18+RAM1
#define RAM20 RAM19+RAM1
#define RAM21 RAM20+RAM1
#define RAM22 RAM21+RAM1
#define RAM23 RAM22+RAM1
#define RAM24 RAM23+RAM1
#define RAM25 RAM24+RAM1
#define RAM26 RAM25+RAM1
#define RAM27 RAM26+RAM1
#define RAM28 RAM27+RAM1
#define RAM29 RAM28+RAM1
#define RAM30 RAM29+RAM1
#define RAM31 RAM30+RAM1
#define RAM32 RAM31+RAM1
#define RAM33 RAM32+RAM1
#define RAM34 RAM33+RAM1
#define RAM35 RAM34+RAM1
#define RAM36 RAM35+RAM1
#define RAM37 RAM36+RAM1
#define RAM38 RAM37+RAM1
#define RAM39 RAM38+RAM1
#define RAM40 RAM39+RAM1
#define RAM41 RAM40+RAM1
#define RAM42 RAM41+RAM1
#define RAM43 RAM42+RAM1
#define RAM44 RAM43+RAM1
#define RAM45 RAM44+RAM1
#define RAM46 RAM45+RAM1
#define RAM47 RAM46+RAM1
#define RAM48 RAM47+RAM1
#define RAM49 RAM48+RAM1
#define RAM50 RAM49+RAM1
#define RAM51 RAM50+RAM1                                                                                      // 13.01.19:  Added 51-100
#define RAM52 RAM51+RAM1
#define RAM53 RAM52+RAM1
#define RAM54 RAM53+RAM1
#define RAM55 RAM54+RAM1
#define RAM56 RAM55+RAM1
#define RAM57 RAM56+RAM1
#define RAM58 RAM57+RAM1
#define RAM59 RAM58+RAM1
#define RAM60 RAM59+RAM1
#define RAM61 RAM60+RAM1
#define RAM62 RAM61+RAM1
#define RAM63 RAM62+RAM1
#define RAM64 RAM63+RAM1
#define RAM65 RAM64+RAM1
#define RAM66 RAM65+RAM1
#define RAM67 RAM66+RAM1
#define RAM68 RAM67+RAM1
#define RAM69 RAM68+RAM1
#define RAM70 RAM69+RAM1
#define RAM71 RAM70+RAM1
#define RAM72 RAM71+RAM1
#define RAM73 RAM72+RAM1
#define RAM74 RAM73+RAM1
#define RAM75 RAM74+RAM1
#define RAM76 RAM75+RAM1
#define RAM77 RAM76+RAM1
#define RAM78 RAM77+RAM1
#define RAM79 RAM78+RAM1
#define RAM80 RAM79+RAM1
#define RAM81 RAM80+RAM1
#define RAM82 RAM81+RAM1
#define RAM83 RAM82+RAM1
#define RAM84 RAM83+RAM1
#define RAM85 RAM84+RAM1
#define RAM86 RAM85+RAM1
#define RAM87 RAM86+RAM1
#define RAM88 RAM87+RAM1
#define RAM89 RAM88+RAM1
#define RAM90 RAM89+RAM1
#define RAM91 RAM90+RAM1
#define RAM92 RAM91+RAM1
#define RAM93 RAM92+RAM1
#define RAM94 RAM93+RAM1
#define RAM95 RAM94+RAM1
#define RAM96 RAM95+RAM1
#define RAM97 RAM96+RAM1
#define RAM98 RAM97+RAM1
#define RAM99 RAM98+RAM1
#define RAM100 RAM99+RAM1

#define RAMN(n) RAM ## n

// https://codecraft.co/2014/11/25/variadic-macros-tricks/
// Accept any number of args >= N, but expand to just the Nth one.
// Note that this macro is preceded by an underscore--it's an
// implementation detail, not something we expect people to call
// directly.
#define _GET_NTH_ARG(        _1,   _2,   _3,   _4,   _5,   _6,   _7,   _8,   _9, \
                      _10,  _11,  _12,  _13,  _14,  _15,  _16,  _17,  _18,  _19, \
                      _20,  _21,  _22,  _23,  _24,  _25,  _26,  _27,  _28,  _29, \
                      _30,  _31,  _32,  _33,  _34,  _35,  _36,  _37,  _38,  _39, \
                      _40,  _41,  _42,  _43,  _44,  _45,  _46,  _47,  _48,  _49, \
                      _50,  _51,  _52,  _53,  _54,  _55,  _56,  _57,  _58,  _59, \
                      _60,  _61,  _62,  _63,  _64,  _65,  _66,  _67,  _68,  _69, \
                      _70,  _71,  _72,  _73,  _74,  _75,  _76,  _77,  _78,  _79, \
                      _80,  _81,  _82,  _83,  _84,  _85,  _86,  _87,  _88,  _89, \
                      _90,  _91,  _92,  _93,  _94,  _95,  _96,  _97,  _98,  _99, \
                     _100, _101, _102, _103, _104, _105, _106, _107, _108, _109, \
                     _110, _111, _112, _113, _114, _115, _116, _117, _118, _119, \
                     _120, _121, _122, _123, _124, _125, _126, _127, _128, _129, \
                     _130, _131, _132, _133, _134, _135, _136, _137, _138, _139, \
                     _140, _141, _142, _143, _144, _145, _146, _147, _148, _149, \
                     _150, _151, _152, _153, _154, _155, _156, _157, _158, _159, \
                     _160, _161, _162, _163, _164, _165, _166, _167, _168, _169, \
                     _170, _171, _172, _173, _174, _175, _176, _177, _178, _179, \
                     _180, _181, _182, _183, _184, _185, _186, _187, _188, _189, \
                     _190, _191, _192, _193, _194, _195, _196, _197, _198, _199, \
                     _200, _201, _202, _203, _204, _205, _206, _207, _208, _209, \
                     _210, _211, _212, _213, _214, _215, _216, _217, _218, _219, \
                     _220, _221, _222, _223, _224, _225, _226, _227, _228, _229, \
                     _230, _231, _232, _233, _234, _235, _236, _237, _238, _239, \
                     _240, _241, _242, _243, _244, _245, _246, _247, _248, _249, \
                     _250, _251, _252, _253, _254, _255, _256, _257, _258, _259, \
                     _260, _261, _262, _263, _264, _265, _266, _267, _268, _269, \
                     _270, _271, _272, _273, _274, _275, _276, _277, _278, _279, \
                     _280, _281, _282, _283, _284, _285, _286, _287, _288, _289, \
                     _290, _291, _292, _293, _294, _295, _296, _297, _298, _299, \
                     _300, _301, _302, _303, _304, _305, _306, _307, _308, _309, \
                     _310, _311, _312, _313, _314, _315, _316, _317, _318, _319, \
                     _320, _321, _322, _323, _324, _325, _326, _327, _328, _329, \
                     _330, _331, _332, _333, _334, _335, _336, _337, _338, _339, \
                     _340, _341, _342, _343, _344, _345, _346, _347, _348, _349, \
                     _350, _351, _352, _353, _354, _355, _356, _357, _358, _359, \
                     _360, _361, _362, _363, _364, _365, _366, _367, _368, _369, \
                     _370, _371, _372, _373, _374, _375, _376, _377, _378, _379, \
                     _380, _381, _382, _383, _384, _385, _386, _387, _388, _389, \
                     _390, _391, _392, _393, _394, _395, _396, _397, _398, _399, \
                     _400, _401, _402, _403, _404, _405, _406, _407, _408, _409, \
                     _410, _411, _412, _413, _414, _415, _416, _417, _418, _419, \
                     _420, _421, _422, _423, _424, _425, _426, _427, _428, _429, \
                     _430, _431, _432, _433, _434, _435, _436, _437, _438, _439, \
                     _440, _441, _442, _443, _444, _445, _446, _447, _448, _449, \
                     _450, _451, _452, _453, _454, _455, _456, _457, _458, _459, \
                     _460, _461, _462, _463, _464, _465, _466, _467, _468, _469, \
                     _470, _471, _472, _473, _474, _475, _476, _477, _478, _479, \
                     _480, _481, _482, _483, _484, _485, _486, _487, _488, _489, \
                     _490, _491, _492, _493, _494, _495, _496, _497, _498, _499, \
                     _500, _501, _502, _503, _504, _505, _506, _507, _508, _509, \
                     _510, _511, _512, _513, _514, _515, _516, _517, _518, _519, \
                     _520, _521, _522, _523, _524, _525, _526, _527, _528, _529, \
                     _530, _531, _532, _533, _534, _535, _536, _537, _538, _539, \
                     _540, _541, _542, _543, _544, _545, _546, _547, _548, _549, \
                     _550, _551, _552, _553, _554, _555, _556, _557, _558, _559, \
                     _560, _561, _562, _563, _564, _565, _566, _567, _568, _569, \
                     _570, _571, _572, _573, _574, _575, _576, _577, _578, _579, \
                     _580, _581, _582, _583, _584, _585, _586, _587, _588, _589, \
                     _590, _591, _592, _593, _594, _595, _596, _597, _598, _599, \
                     _600, _601, _602, _603, _604, _605, _606, _607, _608, _609, \
                     _610, _611, _612, _613, _614, _615, _616, _617, _618, _619, \
                     _620, _621, _622, _623, _624, _625, _626, _627, _628, _629, \
                     _630, _631, _632, _633, _634, _635, _636, _637, _638, _639, \
                     _640, _641, _642, _643, _644, _645, _646, _647, _648, _649, \
                     _650, _651, _652, _653, _654, _655, _656, _657, _658, _659, \
                     _660, _661, _662, _663, _664, _665, _666, _667, _668, _669, \
                     _670, _671, _672, _673, _674, _675, _676, _677, _678, _679, \
                     _680, _681, _682, _683, _684, _685, _686, _687, _688, _689, \
                     _690, _691, _692, _693, _694, _695, _696, _697, _698, _699, \
                     _700, _701, _702, _703, _704, _705, _706, _707, _708, _709, \
                     _710, _711, _712, _713, _714, _715, _716, _717, _718, _719, \
                     _720, _721, _722, _723, _724, _725, _726, _727, _728, _729, \
                     _730, _731, _732, _733, _734, _735, _736, _737, _738, _739, \
                     _740, _741, _742, _743, _744, _745, _746, _747, _748, _749, \
                     _750, _751, _752, _753, _754, _755, _756, _757, _758, _759, \
                     _760, _761, _762, _763, _764, _765, _766, _767, _768, _769, \
                     _770, _771, _772, _773, _774, _775, _776, _777, _778, _779, \
                     _780, _781, _782, _783, _784, _785, _786, _787, _788, _789, \
                     _790, _791, _792, _793, _794, _795, _796, _797, _798, _799, \
                     _800, _801, _802, _803, _804, _805, _806, _807, _808, _809, \
                     _810, _811, _812, _813, _814, _815, _816, _817, _818, _819, \
                     _820, _821, _822, _823, _824, _825, _826, _827, _828, _829, \
                     _830, _831, _832, _833, _834, _835, _836, _837, _838, _839, \
                     _840, _841, _842, _843, _844, _845, _846, _847, _848, _849, \
                     _850, _851, _852, _853, _854, _855, _856, _857, _858, _859, \
                     _860, _861, _862, _863, _864, _865, _866, _867, _868, _869, \
                     _870, _871, _872, _873, _874, _875, _876, _877, _878, _879, \
                     _880, _881, _882, _883, _884, _885, _886, _887, _888, _889, \
                     _890, _891, _892, _893, _894, _895, _896, _897, _898, _899, \
                     _900, _901, _902, _903, _904, _905, _906, _907, _908, _909, \
                     _910, _911, _912, _913, _914, _915, _916, _917, _918, _919, \
                     _920, _921, _922, _923, _924, _925, _926, _927, _928, _929, \
                     _930, _931, _932, _933, _934, _935, _936, _937, _938, _939, \
                     _940, _941, _942, _943, _944, _945, _946, _947, _948, _949, \
                     _950, _951, _952, _953, _954, _955, _956, _957, _958, _959, \
                     _960, _961, _962, _963, _964, _965, _966, _967, _968, _969, \
                     _970, _971, _972, _973, _974, _975, _976, _977, _978, _979, \
                     _980, _981, _982, _983, _984, _985, _986, _987, _988, _989, \
                     _990, _991, _992, _993, _994, _995, _996, _997, _998, _999, \
                    _1000,_1001,_1002,_1003,_1004,_1005,_1006,_1007,_1008,_1009, \
                    _1010,_1011,_1012,_1013,_1014,_1015,_1016,_1017,_1018,_1019, \
                    _1020,_1021,_1022,_1023,_1024,_1025,_1026,_1027,_1028,_1029, \
                    _1030,_1031,_1032,_1033,_1034,_1035,_1036,_1037,_1038,_1039, \
                    _1040,_1041,_1042,_1043,_1044,_1045,_1046,_1047,_1048,_1049, \
                    _1050,_1051,_1052,_1053,_1054,_1055,_1056,_1057,_1058,_1059, \
                    _1060,_1061,_1062,_1063,_1064,_1065,_1066,_1067,_1068,_1069, \
                    _1070,_1071,_1072,_1073,_1074,_1075,_1076,_1077,_1078,_1079, \
                    _1080,_1081,_1082,_1083,_1084,_1085,_1086,_1087,_1088,_1089, \
                    _1090,_1091,_1092,_1093,_1094,_1095,_1096,_1097,_1098,_1099, \
                    _1100,_1101,_1102,_1103,_1104,_1105,_1106,_1107,_1108,_1109, \
                    _1110,_1111,_1112,_1113,_1114,_1115,_1116,_1117,_1118,_1119, \
                    _1120,_1121,_1122,_1123,_1124,_1125,_1126,_1127,_1128,_1129, \
                    _1130,_1131,_1132,_1133,_1134,_1135,_1136,_1137,_1138,_1139, \
                    _1140,_1141,_1142,_1143,_1144,_1145,_1146,_1147,_1148,_1149, \
                    _1150,_1151,_1152,_1153,_1154,_1155,_1156,_1157,_1158,_1159, \
                    _1160,_1161,_1162,_1163,_1164,_1165,_1166,_1167,_1168,_1169, \
                    _1170,_1171,_1172,_1173,_1174,_1175,_1176,_1177,_1178,_1179, \
                    _1180,_1181,_1182,_1183,_1184,_1185,_1186,_1187,_1188,_1189, \
                    _1190,_1191,_1192,_1193,_1194,_1195,_1196,_1197,_1198,_1199, \
                    _1200,_1201,_1202,_1203,_1204,_1205,_1206,_1207,_1208,_1209, \
                    _1210,_1211,_1212,_1213,_1214,_1215,_1216,_1217,_1218,_1219, \
                    _1220,_1221,_1222,_1223,_1224,_1225,_1226,_1227,_1228,_1229, \
                    _1230,_1231,_1232,_1233,_1234,_1235,_1236,_1237,_1238,_1239, \
                    _1240,_1241,_1242,_1243,_1244,_1245,_1246,_1247,_1248,_1249, \
                    _1250,_1251,_1252,_1253,_1254,_1255,_1256,_1257,_1258,_1259, \
                    _1260,_1261,_1262,_1263,_1264,_1265,_1266,_1267,_1268,_1269, \
                    _1270,_1271,_1272,_1273,_1274,_1275,_1276,_1277,_1278,_1279, \
                    _1280,_1281,_1282,_1283,_1284,_1285,_1286,_1287,_1288,_1289, \
                    _1290,_1291,_1292,_1293,_1294,_1295,_1296,_1297,_1298,_1299, \
                    _1300,_1301,_1302,_1303,_1304,_1305,_1306,_1307,_1308,_1309, \
                    _1310,_1311,_1312,_1313,_1314,_1315,_1316,_1317,_1318,_1319, \
                    _1320,_1321,_1322,_1323,_1324,_1325,_1326,_1327,_1328,_1329, \
                    _1330,_1331,_1332,_1333,_1334,_1335,_1336,_1337,_1338,_1339, \
                    _1340,_1341,_1342,_1343,_1344,_1345,_1346,_1347,_1348,_1349, \
                    _1350,_1351,_1352,_1353,_1354,_1355,_1356,_1357,_1358,_1359, \
                    _1360,_1361,_1362,_1363,_1364,_1365,_1366,_1367,_1368,_1369, \
                    _1370,_1371,_1372,_1373,_1374,_1375,_1376,_1377,_1378,_1379, \
                    _1380,_1381,_1382,_1383,_1384,_1385,_1386,_1387,_1388,_1389, \
                    _1390,_1391,_1392,_1393,_1394,_1395,_1396,_1397,_1398,_1399, \
                    _1400,_1401,_1402,_1403,_1404,_1405,_1406,_1407,_1408,_1409, \
                    _1410,_1411,_1412,_1413,_1414,_1415,_1416,_1417,_1418,_1419, \
                    _1420,_1421,_1422,_1423,_1424,_1425,_1426,_1427,_1428,_1429, \
                    _1430,_1431,_1432,_1433,_1434,_1435,_1436,_1437,_1438,_1439, \
                    _1440,_1441,_1442,_1443,_1444,_1445,_1446,_1447,_1448,_1449, \
                    _1450,_1451,_1452,_1453,_1454,_1455,_1456,_1457,_1458,_1459, \
                    _1460,_1461,_1462,_1463,_1464,_1465,_1466,_1467,_1468,_1469, \
                    _1470,_1471,_1472,_1473,_1474,_1475,_1476,_1477,_1478,_1479, \
                    _1480,_1481,_1482,_1483,_1484,_1485,_1486,_1487,_1488,_1489, \
                    _1490,_1491,_1492,_1493,_1494,_1495,_1496,_1497,_1498,_1499, \
                    _1500,_1501,_1502,_1503,_1504,_1505,_1506,_1507,_1508,_1509, \
                    _1510,_1511,_1512,_1513,_1514,_1515,_1516,_1517,_1518,_1519, \
                    _1520,_1521,_1522,_1523,_1524,_1525,_1526,_1527,_1528,_1529, \
                    _1530,_1531,_1532,_1533,_1534,_1535,_1536,_1537,_1538,_1539, \
                    _1540,_1541,_1542,_1543,_1544,_1545,_1546,_1547,_1548,_1549, \
                    _1550,_1551,_1552,_1553,_1554,_1555,_1556,_1557,_1558,_1559, \
                    _1560,_1561,_1562,_1563,_1564,_1565,_1566,_1567,_1568,_1569, \
                    _1570,_1571,_1572,_1573,_1574,_1575,_1576,_1577,_1578,_1579, \
                    _1580,_1581,_1582,_1583,_1584,_1585,_1586,_1587,_1588,_1589, \
                    _1590,_1591,_1592,_1593,_1594,_1595,_1596,_1597,_1598,_1599, \
                    _1600,_1601,_1602,_1603,_1604,_1605,_1606,_1607,_1608,_1609, \
                    _1610,_1611,_1612,_1613,_1614,_1615,_1616,_1617,_1618,_1619, \
                    _1620,_1621,_1622,_1623,_1624,_1625,_1626,_1627,_1628,_1629, \
                    _1630,_1631,_1632,_1633,_1634,_1635,_1636,_1637,_1638,_1639, \
                    _1640,_1641,_1642,_1643,_1644,_1645,_1646,_1647,_1648,_1649, \
                    _1650,_1651,_1652,_1653,_1654,_1655,_1656,_1657,_1658,_1659, \
                    _1660,_1661,_1662,_1663,_1664,_1665,_1666,_1667,_1668,_1669, \
                    _1670,_1671,_1672,_1673,_1674,_1675,_1676,_1677,_1678,_1679, \
                    _1680,_1681,_1682,_1683,_1684,_1685,_1686,_1687,_1688,_1689, \
                    _1690,_1691,_1692,_1693,_1694,_1695,_1696,_1697,_1698,_1699, \
                    _1700,_1701,_1702,_1703,_1704,_1705,_1706,_1707,_1708,_1709, \
                    _1710,_1711,_1712,_1713,_1714,_1715,_1716,_1717,_1718,_1719, \
                    _1720,_1721,_1722,_1723,_1724,_1725,_1726,_1727,_1728,_1729, \
                    _1730,_1731,_1732,_1733,_1734,_1735,_1736,_1737,_1738,_1739, \
                    _1740,_1741,_1742,_1743,_1744,_1745,_1746,_1747,_1748,_1749, \
                    _1750,_1751,_1752,_1753,_1754,_1755,_1756,_1757,_1758,_1759, \
                    _1760,_1761,_1762,_1763,_1764,_1765,_1766,_1767,_1768,_1769, \
                    _1770,_1771,_1772,_1773,_1774,_1775,_1776,_1777,_1778,_1779, \
                    _1780,_1781,_1782,_1783,_1784,_1785,_1786,_1787,_1788,_1789, \
                    _1790,_1791,_1792,_1793,_1794,_1795,_1796,_1797,_1798,_1799, \
                    _1800,_1801,_1802,_1803,_1804,_1805,_1806,_1807,_1808,_1809, \
                    _1810,_1811,_1812,_1813,_1814,_1815,_1816,_1817,_1818,_1819, \
                    _1820,_1821,_1822,_1823,_1824,_1825,_1826,_1827,_1828,_1829, \
                    _1830,_1831,_1832,_1833,_1834,_1835,_1836,_1837,_1838,_1839, \
                    _1840,_1841,_1842,_1843,_1844,_1845,_1846,_1847,_1848,_1849, \
                    _1850,_1851,_1852,_1853,_1854,_1855,_1856,_1857,_1858,_1859, \
                    _1860,_1861,_1862,_1863,_1864,_1865,_1866,_1867,_1868,_1869, \
                    _1870,_1871,_1872,_1873,_1874,_1875,_1876,_1877,_1878,_1879, \
                    _1880,_1881,_1882,_1883,_1884,_1885,_1886,_1887,_1888,_1889, \
                    _1890,_1891,_1892,_1893,_1894,_1895,_1896,_1897,_1898,_1899, \
                    _1900,_1901,_1902,_1903,_1904,_1905,_1906,_1907,_1908,_1909, \
                    _1910,_1911,_1912,_1913,_1914,_1915,_1916,_1917,_1918,_1919, \
                    _1920,_1921,_1922,_1923,_1924,_1925,_1926,_1927,_1928,_1929, \
                    _1930,_1931,_1932,_1933,_1934,_1935,_1936,_1937,_1938,_1939, \
                    _1940,_1941,_1942,_1943,_1944,_1945,_1946,_1947,_1948,_1949, \
                    _1950,_1951,_1952,_1953,_1954,_1955,_1956,_1957,_1958,_1959, \
                    _1960,_1961,_1962,_1963,_1964,_1965,_1966,_1967,_1968,_1969, \
                    _1970,_1971,_1972,_1973,_1974,_1975,_1976,_1977,_1978,_1979, \
                    _1980,_1981,_1982,_1983,_1984,_1985,_1986,_1987,_1988,_1989, \
                    _1990,_1991,_1992,_1993,_1994,_1995,_1996,_1997,_1998,_1999, _2000, _2001, N, ...) N

// Count how many args are in a variadic macro. Only works for up to N-1 args.
#define COUNT_VARARGS(...) _GET_NTH_ARG(__VA_ARGS__,                        \
                     2001, 2000,                                            \
                     1999,1998,1997,1996,1995,1994,1993,1992,1991,1990,     \
                     1989,1988,1987,1986,1985,1984,1983,1982,1981,1980,     \
                     1979,1978,1977,1976,1975,1974,1973,1972,1971,1970,     \
                     1969,1968,1967,1966,1965,1964,1963,1962,1961,1960,     \
                     1959,1958,1957,1956,1955,1954,1953,1952,1951,1950,     \
                     1949,1948,1947,1946,1945,1944,1943,1942,1941,1940,     \
                     1939,1938,1937,1936,1935,1934,1933,1932,1931,1930,     \
                     1929,1928,1927,1926,1925,1924,1923,1922,1921,1920,     \
                     1919,1918,1917,1916,1915,1914,1913,1912,1911,1910,     \
                     1909,1908,1907,1906,1905,1904,1903,1902,1901,1900,     \
                     1899,1898,1897,1896,1895,1894,1893,1892,1891,1890,     \
                     1889,1888,1887,1886,1885,1884,1883,1882,1881,1880,     \
                     1879,1878,1877,1876,1875,1874,1873,1872,1871,1870,     \
                     1869,1868,1867,1866,1865,1864,1863,1862,1861,1860,     \
                     1859,1858,1857,1856,1855,1854,1853,1852,1851,1850,     \
                     1849,1848,1847,1846,1845,1844,1843,1842,1841,1840,     \
                     1839,1838,1837,1836,1835,1834,1833,1832,1831,1830,     \
                     1829,1828,1827,1826,1825,1824,1823,1822,1821,1820,     \
                     1819,1818,1817,1816,1815,1814,1813,1812,1811,1810,     \
                     1809,1808,1807,1806,1805,1804,1803,1802,1801,1800,     \
                     1799,1798,1797,1796,1795,1794,1793,1792,1791,1790,     \
                     1789,1788,1787,1786,1785,1784,1783,1782,1781,1780,     \
                     1779,1778,1777,1776,1775,1774,1773,1772,1771,1770,     \
                     1769,1768,1767,1766,1765,1764,1763,1762,1761,1760,     \
                     1759,1758,1757,1756,1755,1754,1753,1752,1751,1750,     \
                     1749,1748,1747,1746,1745,1744,1743,1742,1741,1740,     \
                     1739,1738,1737,1736,1735,1734,1733,1732,1731,1730,     \
                     1729,1728,1727,1726,1725,1724,1723,1722,1721,1720,     \
                     1719,1718,1717,1716,1715,1714,1713,1712,1711,1710,     \
                     1709,1708,1707,1706,1705,1704,1703,1702,1701,1700,     \
                     1699,1698,1697,1696,1695,1694,1693,1692,1691,1690,     \
                     1689,1688,1687,1686,1685,1684,1683,1682,1681,1680,     \
                     1679,1678,1677,1676,1675,1674,1673,1672,1671,1670,     \
                     1669,1668,1667,1666,1665,1664,1663,1662,1661,1660,     \
                     1659,1658,1657,1656,1655,1654,1653,1652,1651,1650,     \
                     1649,1648,1647,1646,1645,1644,1643,1642,1641,1640,     \
                     1639,1638,1637,1636,1635,1634,1633,1632,1631,1630,     \
                     1629,1628,1627,1626,1625,1624,1623,1622,1621,1620,     \
                     1619,1618,1617,1616,1615,1614,1613,1612,1611,1610,     \
                     1609,1608,1607,1606,1605,1604,1603,1602,1601,1600,     \
                     1599,1598,1597,1596,1595,1594,1593,1592,1591,1590,     \
                     1589,1588,1587,1586,1585,1584,1583,1582,1581,1580,     \
                     1579,1578,1577,1576,1575,1574,1573,1572,1571,1570,     \
                     1569,1568,1567,1566,1565,1564,1563,1562,1561,1560,     \
                     1559,1558,1557,1556,1555,1554,1553,1552,1551,1550,     \
                     1549,1548,1547,1546,1545,1544,1543,1542,1541,1540,     \
                     1539,1538,1537,1536,1535,1534,1533,1532,1531,1530,     \
                     1529,1528,1527,1526,1525,1524,1523,1522,1521,1520,     \
                     1519,1518,1517,1516,1515,1514,1513,1512,1511,1510,     \
                     1509,1508,1507,1506,1505,1504,1503,1502,1501,1500,     \
                     1499,1498,1497,1496,1495,1494,1493,1492,1491,1490,     \
                     1489,1488,1487,1486,1485,1484,1483,1482,1481,1480,     \
                     1479,1478,1477,1476,1475,1474,1473,1472,1471,1470,     \
                     1469,1468,1467,1466,1465,1464,1463,1462,1461,1460,     \
                     1459,1458,1457,1456,1455,1454,1453,1452,1451,1450,     \
                     1449,1448,1447,1446,1445,1444,1443,1442,1441,1440,     \
                     1439,1438,1437,1436,1435,1434,1433,1432,1431,1430,     \
                     1429,1428,1427,1426,1425,1424,1423,1422,1421,1420,     \
                     1419,1418,1417,1416,1415,1414,1413,1412,1411,1410,     \
                     1409,1408,1407,1406,1405,1404,1403,1402,1401,1400,     \
                     1399,1398,1397,1396,1395,1394,1393,1392,1391,1390,     \
                     1389,1388,1387,1386,1385,1384,1383,1382,1381,1380,     \
                     1379,1378,1377,1376,1375,1374,1373,1372,1371,1370,     \
                     1369,1368,1367,1366,1365,1364,1363,1362,1361,1360,     \
                     1359,1358,1357,1356,1355,1354,1353,1352,1351,1350,     \
                     1349,1348,1347,1346,1345,1344,1343,1342,1341,1340,     \
                     1339,1338,1337,1336,1335,1334,1333,1332,1331,1330,     \
                     1329,1328,1327,1326,1325,1324,1323,1322,1321,1320,     \
                     1319,1318,1317,1316,1315,1314,1313,1312,1311,1310,     \
                     1309,1308,1307,1306,1305,1304,1303,1302,1301,1300,     \
                     1299,1298,1297,1296,1295,1294,1293,1292,1291,1290,     \
                     1289,1288,1287,1286,1285,1284,1283,1282,1281,1280,     \
                     1279,1278,1277,1276,1275,1274,1273,1272,1271,1270,     \
                     1269,1268,1267,1266,1265,1264,1263,1262,1261,1260,     \
                     1259,1258,1257,1256,1255,1254,1253,1252,1251,1250,     \
                     1249,1248,1247,1246,1245,1244,1243,1242,1241,1240,     \
                     1239,1238,1237,1236,1235,1234,1233,1232,1231,1230,     \
                     1229,1228,1227,1226,1225,1224,1223,1222,1221,1220,     \
                     1219,1218,1217,1216,1215,1214,1213,1212,1211,1210,     \
                     1209,1208,1207,1206,1205,1204,1203,1202,1201,1200,     \
                     1199,1198,1197,1196,1195,1194,1193,1192,1191,1190,     \
                     1189,1188,1187,1186,1185,1184,1183,1182,1181,1180,     \
                     1179,1178,1177,1176,1175,1174,1173,1172,1171,1170,     \
                     1169,1168,1167,1166,1165,1164,1163,1162,1161,1160,     \
                     1159,1158,1157,1156,1155,1154,1153,1152,1151,1150,     \
                     1149,1148,1147,1146,1145,1144,1143,1142,1141,1140,     \
                     1139,1138,1137,1136,1135,1134,1133,1132,1131,1130,     \
                     1129,1128,1127,1126,1125,1124,1123,1122,1121,1120,     \
                     1119,1118,1117,1116,1115,1114,1113,1112,1111,1110,     \
                     1109,1108,1107,1106,1105,1104,1103,1102,1101,1100,     \
                     1099,1098,1097,1096,1095,1094,1093,1092,1091,1090,     \
                     1089,1088,1087,1086,1085,1084,1083,1082,1081,1080,     \
                     1079,1078,1077,1076,1075,1074,1073,1072,1071,1070,     \
                     1069,1068,1067,1066,1065,1064,1063,1062,1061,1060,     \
                     1059,1058,1057,1056,1055,1054,1053,1052,1051,1050,     \
                     1049,1048,1047,1046,1045,1044,1043,1042,1041,1040,     \
                     1039,1038,1037,1036,1035,1034,1033,1032,1031,1030,     \
                     1029,1028,1027,1026,1025,1024,1023,1022,1021,1020,     \
                     1019,1018,1017,1016,1015,1014,1013,1012,1011,1010,     \
                     1009,1008,1007,1006,1005,1004,1003,1002,1001,1000,     \
                      999, 998, 997, 996, 995, 994, 993, 992, 991, 990,     \
                      989, 988, 987, 986, 985, 984, 983, 982, 981, 980,     \
                      979, 978, 977, 976, 975, 974, 973, 972, 971, 970,     \
                      969, 968, 967, 966, 965, 964, 963, 962, 961, 960,     \
                      959, 958, 957, 956, 955, 954, 953, 952, 951, 950,     \
                      949, 948, 947, 946, 945, 944, 943, 942, 941, 940,     \
                      939, 938, 937, 936, 935, 934, 933, 932, 931, 930,     \
                      929, 928, 927, 926, 925, 924, 923, 922, 921, 920,     \
                      919, 918, 917, 916, 915, 914, 913, 912, 911, 910,     \
                      909, 908, 907, 906, 905, 904, 903, 902, 901, 900,     \
                      899, 898, 897, 896, 895, 894, 893, 892, 891, 890,     \
                      889, 888, 887, 886, 885, 884, 883, 882, 881, 880,     \
                      879, 878, 877, 876, 875, 874, 873, 872, 871, 870,     \
                      869, 868, 867, 866, 865, 864, 863, 862, 861, 860,     \
                      859, 858, 857, 856, 855, 854, 853, 852, 851, 850,     \
                      849, 848, 847, 846, 845, 844, 843, 842, 841, 840,     \
                      839, 838, 837, 836, 835, 834, 833, 832, 831, 830,     \
                      829, 828, 827, 826, 825, 824, 823, 822, 821, 820,     \
                      819, 818, 817, 816, 815, 814, 813, 812, 811, 810,     \
                      809, 808, 807, 806, 805, 804, 803, 802, 801, 800,     \
                      799, 798, 797, 796, 795, 794, 793, 792, 791, 790,     \
                      789, 788, 787, 786, 785, 784, 783, 782, 781, 780,     \
                      779, 778, 777, 776, 775, 774, 773, 772, 771, 770,     \
                      769, 768, 767, 766, 765, 764, 763, 762, 761, 760,     \
                      759, 758, 757, 756, 755, 754, 753, 752, 751, 750,     \
                      749, 748, 747, 746, 745, 744, 743, 742, 741, 740,     \
                      739, 738, 737, 736, 735, 734, 733, 732, 731, 730,     \
                      729, 728, 727, 726, 725, 724, 723, 722, 721, 720,     \
                      719, 718, 717, 716, 715, 714, 713, 712, 711, 710,     \
                      709, 708, 707, 706, 705, 704, 703, 702, 701, 700,     \
                      699, 698, 697, 696, 695, 694, 693, 692, 691, 690,     \
                      689, 688, 687, 686, 685, 684, 683, 682, 681, 680,     \
                      679, 678, 677, 676, 675, 674, 673, 672, 671, 670,     \
                      669, 668, 667, 666, 665, 664, 663, 662, 661, 660,     \
                      659, 658, 657, 656, 655, 654, 653, 652, 651, 650,     \
                      649, 648, 647, 646, 645, 644, 643, 642, 641, 640,     \
                      639, 638, 637, 636, 635, 634, 633, 632, 631, 630,     \
                      629, 628, 627, 626, 625, 624, 623, 622, 621, 620,     \
                      619, 618, 617, 616, 615, 614, 613, 612, 611, 610,     \
                      609, 608, 607, 606, 605, 604, 603, 602, 601, 600,     \
                      599, 598, 597, 596, 595, 594, 593, 592, 591, 590,     \
                      589, 588, 587, 586, 585, 584, 583, 582, 581, 580,     \
                      579, 578, 577, 576, 575, 574, 573, 572, 571, 570,     \
                      569, 568, 567, 566, 565, 564, 563, 562, 561, 560,     \
                      559, 558, 557, 556, 555, 554, 553, 552, 551, 550,     \
                      549, 548, 547, 546, 545, 544, 543, 542, 541, 540,     \
                      539, 538, 537, 536, 535, 534, 533, 532, 531, 530,     \
                      529, 528, 527, 526, 525, 524, 523, 522, 521, 520,     \
                      519, 518, 517, 516, 515, 514, 513, 512, 511, 510,     \
                      509, 508, 507, 506, 505, 504, 503, 502, 501, 500,     \
                      499, 498, 497, 496, 495, 494, 493, 492, 491, 490,     \
                      489, 488, 487, 486, 485, 484, 483, 482, 481, 480,     \
                      479, 478, 477, 476, 475, 474, 473, 472, 471, 470,     \
                      469, 468, 467, 466, 465, 464, 463, 462, 461, 460,     \
                      459, 458, 457, 456, 455, 454, 453, 452, 451, 450,     \
                      449, 448, 447, 446, 445, 444, 443, 442, 441, 440,     \
                      439, 438, 437, 436, 435, 434, 433, 432, 431, 430,     \
                      429, 428, 427, 426, 425, 424, 423, 422, 421, 420,     \
                      419, 418, 417, 416, 415, 414, 413, 412, 411, 410,     \
                      409, 408, 407, 406, 405, 404, 403, 402, 401, 400,     \
                      399, 398, 397, 396, 395, 394, 393, 392, 391, 390,     \
                      389, 388, 387, 386, 385, 384, 383, 382, 381, 380,     \
                      379, 378, 377, 376, 375, 374, 373, 372, 371, 370,     \
                      369, 368, 367, 366, 365, 364, 363, 362, 361, 360,     \
                      359, 358, 357, 356, 355, 354, 353, 352, 351, 350,     \
                      349, 348, 347, 346, 345, 344, 343, 342, 341, 340,     \
                      339, 338, 337, 336, 335, 334, 333, 332, 331, 330,     \
                      329, 328, 327, 326, 325, 324, 323, 322, 321, 320,     \
                      319, 318, 317, 316, 315, 314, 313, 312, 311, 310,     \
                      309, 308, 307, 306, 305, 304, 303, 302, 301, 300,     \
                      299, 298, 297, 296, 295, 294, 293, 292, 291, 290,     \
                      289, 288, 287, 286, 285, 284, 283, 282, 281, 280,     \
                      279, 278, 277, 276, 275, 274, 273, 272, 271, 270,     \
                      269, 268, 267, 266, 265, 264, 263, 262, 261, 260,     \
                      259, 258, 257, 256, 255, 254, 253, 252, 251, 250,     \
                      249, 248, 247, 246, 245, 244, 243, 242, 241, 240,     \
                      239, 238, 237, 236, 235, 234, 233, 232, 231, 230,     \
                      229, 228, 227, 226, 225, 224, 223, 222, 221, 220,     \
                      219, 218, 217, 216, 215, 214, 213, 212, 211, 210,     \
                      209, 208, 207, 206, 205, 204, 203, 202, 201, 200,     \
                      199, 198, 197, 196, 195, 194, 193, 192, 191, 190,     \
                      189, 188, 187, 186, 185, 184, 183, 182, 181, 180,     \
                      179, 178, 177, 176, 175, 174, 173, 172, 171, 170,     \
                      169, 168, 167, 166, 165, 164, 163, 162, 161, 160,     \
                      159, 158, 157, 156, 155, 154, 153, 152, 151, 150,     \
                      149, 148, 147, 146, 145, 144, 143, 142, 141, 140,     \
                      139, 138, 137, 136, 135, 134, 133, 132, 131, 130,     \
                      129, 128, 127, 126, 125, 124, 123, 122, 121, 120,     \
                      119, 118, 117, 116, 115, 114, 113, 112, 111, 110,     \
                      109, 108, 107, 106, 105, 104, 103, 102, 101, 100,     \
                       99,  98,  97,  96,  95,  94,  93,  92,  91,  90,     \
                       89,  88,  87,  86,  85,  84,  83,  82,  81,  80,     \
                       79,  78,  77,  76,  75,  74,  73,  72,  71,  70,     \
                       69,  68,  67,  66,  65,  64,  63,  62,  61,  60,     \
                       59,  58,  57,  56,  55,  54,  53,  52,  51,  50,     \
                       49,  48,  47,  46,  45,  44,  43,  42,  41,  40,     \
                       39,  38,  37,  36,  35,  34,  33,  32,  31,  30,     \
                       29,  28,  27,  26,  25,  24,  23,  22,  21,  20,     \
                       19,  18,  17,  16,  15,  14,  13,  12,  11,  10,     \
                        9,   8,   7,   6,   5,   4,   3,   2,   1)

#endif // __MACROS_H__
