/* ----------------------------------------------------------------------   
* Copyright (C) 2010-2012 ARM Limited. All rights reserved.   
*   
* $Date:        17. January 2013  
* $Revision: 	V1.4.0   
*   
* Project: 	    CMSIS DSP Library   
* Title:	     	arm_fft_bin_data.c
*   
* Description:	 Data file used for example code
*   
* Target Processor: Cortex-M4/Cortex-M3/Cortex-M0
*  
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions
* are met:
*   - Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*   - Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in
*     the documentation and/or other materials provided with the 
*     distribution.
*   - Neither the name of ARM LIMITED nor the names of its contributors
*     may be used to endorse or promote products derived from this
*     software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
* COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
* BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
* ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.  
 * -------------------------------------------------------------------- */

#include "arm_math.h"

/* ----------------------------------------------------------------------
Test Input signal contains 10KHz signal + Uniformly distributed white noise
** ------------------------------------------------------------------- */

float32_t testInput_f32_10khz[2048] = 
{   
-0.865129623056441, 	0.000000000000000, 	-2.655020678073846, 	0.000000000000000, 	0.600664612949661, 	0.000000000000000, 	0.080378093886515, 	0.000000000000000, 	
-2.899160484012034, 	0.000000000000000, 	2.563004262857762, 	0.000000000000000, 	3.078328403304206, 	0.000000000000000, 	0.105906778385130, 	0.000000000000000, 	
0.048366940168201, 	0.000000000000000, 	-0.145696461188734, 	0.000000000000000, 	-0.023417155362879, 	0.000000000000000, 	2.127729174988954, 	0.000000000000000, 	
-1.176633086028377, 	0.000000000000000, 	3.690223557991855, 	0.000000000000000, 	-0.622791766173194, 	0.000000000000000, 	0.722837373872203, 	0.000000000000000, 	
2.739754205367484, 	0.000000000000000, 	-0.062610410524552, 	0.000000000000000, 	-0.891296810967338, 	0.000000000000000, 	-1.845872258871811, 	0.000000000000000, 	
1.195039415434387, 	0.000000000000000, 	-2.177388969045026, 	0.000000000000000, 	1.078649103637905, 	0.000000000000000, 	2.570976050490193, 	0.000000000000000, 	
-1.383551403404574, 	0.000000000000000, 	2.392141424058873, 	0.000000000000000, 	2.858002843205065, 	0.000000000000000, 	-3.682433899725536, 	0.000000000000000, 	
-3.488146646451150, 	0.000000000000000, 	1.323468578888120, 	0.000000000000000, 	-0.099771155430726, 	0.000000000000000, 	1.561168082500454, 	0.000000000000000, 	
1.025026795103179, 	0.000000000000000, 	0.928841900171200, 	0.000000000000000, 	2.930499509864950, 	0.000000000000000, 	2.013349089766430, 	0.000000000000000, 	
2.381676148486737, 	0.000000000000000, 	-3.081062307950236, 	0.000000000000000, 	-0.389579115537544, 	0.000000000000000, 	0.181540149166620, 	0.000000000000000, 	
-2.601953341353208, 	0.000000000000000, 	0.333435137783218, 	0.000000000000000, 	-2.812945856162965, 	0.000000000000000, 	2.649109640172910, 	0.000000000000000, 	
-1.003963025744654, 	0.000000000000000, 	1.552460768755035, 	0.000000000000000, 	0.088641345335247, 	0.000000000000000, 	-2.519951327113426, 	0.000000000000000, 	
-4.341348988610527, 	0.000000000000000, 	0.557772429359965, 	0.000000000000000, 	-1.671267412948494, 	0.000000000000000, 	0.733951350960387, 	0.000000000000000, 	
0.409263788034864, 	0.000000000000000, 	3.566033071952806, 	0.000000000000000, 	1.882565173848352, 	0.000000000000000, 	-1.106017073793287, 	0.000000000000000, 	
0.154456720778718, 	0.000000000000000, 	-2.513205795512153, 	0.000000000000000, 	0.310978660939421, 	0.000000000000000, 	0.579706500111723, 	0.000000000000000, 	
0.000086383683251, 	0.000000000000000, 	-1.311866980897721, 	0.000000000000000, 	1.840007477574986, 	0.000000000000000, 	-3.253005768451345, 	0.000000000000000, 	
1.462584328739432, 	0.000000000000000, 	1.610103610851738, 	0.000000000000000, 	0.761914676858907, 	0.000000000000000, 	0.974541361089834, 	0.000000000000000, 	
0.686845845885983, 	0.000000000000000, 	1.849153122025191, 	0.000000000000000, 	0.787800410401453, 	0.000000000000000, 	-1.187438909666279, 	0.000000000000000, 	
-0.754937911044720, 	0.000000000000000, 	0.084373858395232, 	0.000000000000000, 	-2.600269011710521, 	0.000000000000000, 	-0.962982842142644, 	0.000000000000000, 	
-0.369328108540868, 	0.000000000000000, 	0.810791418361879, 	0.000000000000000, 	3.587016488699641, 	0.000000000000000, 	-0.520776145083723, 	0.000000000000000, 	
0.640249919627884, 	0.000000000000000, 	1.103122489464969, 	0.000000000000000, 	2.231779881455556, 	0.000000000000000, 	-1.308035392685241, 	0.000000000000000, 	
0.424070304330106, 	0.000000000000000, 	-0.200383932651189, 	0.000000000000000, 	-2.365526783356541, 	0.000000000000000, 	-0.989114757436628, 	0.000000000000000, 	
2.770807688959777, 	0.000000000000000, 	-0.444172737462307, 	0.000000000000000, 	0.079760979374078, 	0.000000000000000, 	-0.005199118412183, 	0.000000000000000, 	
-0.664712668309527, 	0.000000000000000, 	-0.624171857561896, 	0.000000000000000, 	0.537306979007338, 	0.000000000000000, 	-2.575955675497642, 	0.000000000000000, 	
1.562363235756780, 	0.000000000000000, 	1.814069369848895, 	0.000000000000000, 	-1.293428583392509, 	0.000000000000000, 	-1.026188449495686, 	0.000000000000000, 	
-2.981771815588717, 	0.000000000000000, 	-4.223468103075124, 	0.000000000000000, 	2.672674782004045, 	0.000000000000000, 	-0.856096801117735, 	0.000000000000000, 	
0.048517345512563, 	0.000000000000000, 	-0.026860721136222, 	0.000000000000000, 	0.392932277758187, 	0.000000000000000, 	-1.331740855093099, 	0.000000000000000, 	
-1.894292129477081, 	0.000000000000000, 	-1.425006468460681, 	0.000000000000000, 	-2.721772427617057, 	0.000000000000000, 	-1.616831100216806, 	0.000000000000000, 	
3.551177651488947, 	0.000000000000000, 	-0.069685667896087, 	0.000000000000000, 	-3.134634907409102, 	0.000000000000000, 	-0.263627598944639, 	0.000000000000000, 	
-1.650469945991350, 	0.000000000000000, 	-2.203580339374399, 	0.000000000000000, 	-0.872203246123242, 	0.000000000000000, 	1.230782812607287, 	0.000000000000000, 	
0.257288860093291, 	0.000000000000000, 	1.989083106173137, 	0.000000000000000, 	-1.985638729453261, 	0.000000000000000, 	-1.416185105842892, 	0.000000000000000, 	
-1.131097688325772, 	0.000000000000000, 	-2.245130805416057, 	0.000000000000000, 	-1.938873996219074, 	0.000000000000000, 	2.043608361562645, 	0.000000000000000, 	
-0.583727989880841, 	0.000000000000000, 	-1.785266378212929, 	0.000000000000000, 	1.961457586224753, 	0.000000000000000, 	1.139400099963223, 	0.000000000000000, 	
-1.979519343363991, 	0.000000000000000, 	2.003023322818429, 	0.000000000000000, 	0.229004069076829, 	0.000000000000000, 	3.452808862193135, 	0.000000000000000, 	
2.882273808365857, 	0.000000000000000, 	-1.549450501844438, 	0.000000000000000, 	-3.283872089931876, 	0.000000000000000, 	-0.327025884099064, 	0.000000000000000, 	
-0.054979977136430, 	0.000000000000000, 	-1.192280531479012, 	0.000000000000000, 	0.645539328365578, 	0.000000000000000, 	2.300832863404618, 	0.000000000000000, 	
-1.092951789535240, 	0.000000000000000, 	-1.017368249363773, 	0.000000000000000, 	-0.142673056169787, 	0.000000000000000, 	0.831073544881250, 	0.000000000000000, 	
-2.314612531587064, 	0.000000000000000, 	-2.221456299106321, 	0.000000000000000, 	0.460261143885226, 	0.000000000000000, 	0.050585301888595, 	0.000000000000000, 	
0.364373329183988, 	0.000000000000000, 	-1.685956552069538, 	0.000000000000000, 	0.050664512351055, 	0.000000000000000, 	-0.193355783902718, 	0.000000000000000, 	
-0.158660446046828, 	0.000000000000000, 	2.394156453841953, 	0.000000000000000, 	-1.562965718554525, 	0.000000000000000, 	-2.199750600869900, 	0.000000000000000, 	
1.544984022381773, 	0.000000000000000, 	-1.988307216807315, 	0.000000000000000, 	-0.628240722541046, 	0.000000000000000, 	-1.436235771505429, 	0.000000000000000, 	
1.677013691147313, 	0.000000000000000, 	1.600741781678228, 	0.000000000000000, 	-0.757380959134706, 	0.000000000000000, 	-4.784797439515566, 	0.000000000000000, 	
0.265121462834569, 	0.000000000000000, 	3.862029485934378, 	0.000000000000000, 	2.386823577249430, 	0.000000000000000, 	-3.655779745436893, 	0.000000000000000, 	
-0.763541621368016, 	0.000000000000000, 	-1.182140388432962, 	0.000000000000000, 	-1.349106114858063, 	0.000000000000000, 	-2.287533624396759, 	0.000000000000000, 	
-0.028603745188423, 	0.000000000000000, 	-1.353580755934427, 	0.000000000000000, 	0.461602380352937, 	0.000000000000000, 	-0.059599055078928, 	0.000000000000000, 	
-0.929946734342228, 	0.000000000000000, 	0.065773089295561, 	0.000000000000000, 	1.106565863102982, 	0.000000000000000, 	4.719295086373593, 	0.000000000000000, 	
-2.108377703544395, 	0.000000000000000, 	-2.226393620240159, 	0.000000000000000, 	1.375668397437521, 	0.000000000000000, 	-0.960772428525443, 	0.000000000000000, 	
-2.156313465390571, 	0.000000000000000, 	1.126060012375311, 	0.000000000000000, 	2.756485137030720, 	0.000000000000000, 	0.739639690862600, 	0.000000000000000, 	
3.914769510295006, 	0.000000000000000, 	1.685232785586675, 	0.000000000000000, 	4.079058040970612, 	0.000000000000000, 	-1.174598301660513, 	0.000000000000000, 	
-2.885776587275580, 	0.000000000000000, 	-0.241073635188767, 	0.000000000000000, 	3.080489872502403, 	0.000000000000000, 	-2.051244183999421, 	0.000000000000000, 	
0.664330486845139, 	0.000000000000000, 	-1.697798999370016, 	0.000000000000000, 	1.452369423649782, 	0.000000000000000, 	-1.523532831019280, 	0.000000000000000, 	
0.171981186587481, 	0.000000000000000, 	-4.685274721583927, 	0.000000000000000, 	-1.336175835319380, 	0.000000000000000, 	1.419070770428945, 	0.000000000000000, 	
-0.035791601713475, 	0.000000000000000, 	2.291937971632081, 	0.000000000000000, 	-1.962559313450293, 	0.000000000000000, 	-4.831595589339301, 	0.000000000000000, 	
-1.857055284000925, 	0.000000000000000, 	2.606271522635512, 	0.000000000000000, 	-0.576447978738030, 	0.000000000000000, 	0.082299166967720, 	0.000000000000000, 	
1.888399453494614, 	0.000000000000000, 	-3.564705298046079, 	0.000000000000000, 	-0.939357831083889, 	0.000000000000000, 	-1.903578203697778, 	0.000000000000000, 	
-2.642492215447250, 	0.000000000000000, 	-0.182990405251017, 	0.000000000000000, 	3.742026478011174, 	0.000000000000000, 	0.104295803798333, 	0.000000000000000, 	
1.848678195370347, 	0.000000000000000, 	-1.887384346896369, 	0.000000000000000, 	0.365048973046045, 	0.000000000000000, 	-0.889638010354219, 	0.000000000000000, 	
1.173877118428863, 	0.000000000000000, 	-1.178562827540109, 	0.000000000000000, 	0.610271645685184, 	0.000000000000000, 	1.831284815697871, 	0.000000000000000, 	
0.449575390102283, 	0.000000000000000, 	1.597171905253443, 	0.000000000000000, 	3.918574971904773, 	0.000000000000000, 	0.868104027970404, 	0.000000000000000, 	
0.582643134746494, 	0.000000000000000, 	2.321256382353331, 	0.000000000000000, 	-0.238118642223180, 	0.000000000000000, 	-2.890287868054370, 	0.000000000000000, 	
0.970995414625622, 	0.000000000000000, 	0.666137930891283, 	0.000000000000000, 	-0.202435718709502, 	0.000000000000000, 	2.057930200518194, 	0.000000000000000, 	
3.120583443719949, 	0.000000000000000, 	-0.863945271701041, 	0.000000000000000, 	0.906848893874630, 	0.000000000000000, 	-1.434124930222570, 	0.000000000000000, 	
0.754659384848783, 	0.000000000000000, 	-5.224154442713778, 	0.000000000000000, 	2.330229744098967, 	0.000000000000000, 	1.113946320164698, 	0.000000000000000, 	
0.523324920322840, 	0.000000000000000, 	1.750740911548348, 	0.000000000000000, 	-0.899333972913577, 	0.000000000000000, 	0.228705845203506, 	0.000000000000000, 	
-1.934782624767648, 	0.000000000000000, 	-3.508386237231303, 	0.000000000000000, 	-2.107108523073510, 	0.000000000000000, 	0.380587645474815, 	0.000000000000000, 	
-0.476200877183279, 	0.000000000000000, 	-2.172086712642198, 	0.000000000000000, 	1.795372535780299, 	0.000000000000000, 	-2.100318983391055, 	0.000000000000000, 	
-0.022571122461405, 	0.000000000000000, 	0.674514020010955, 	0.000000000000000, 	-0.148872569390857, 	0.000000000000000, 	0.298175890592737, 	0.000000000000000, 	
-1.134244492493590, 	0.000000000000000, 	-3.146848422289455, 	0.000000000000000, 	-1.357950199087602, 	0.000000000000000, 	0.667362732020878, 	0.000000000000000, 	
-3.119397998316724, 	0.000000000000000, 	-1.189341126297637, 	0.000000000000000, 	-1.532744386856668, 	0.000000000000000, 	-1.672972484202534, 	0.000000000000000, 	
-2.042283373871558, 	0.000000000000000, 	-1.479481547595924, 	0.000000000000000, 	-0.002668662875396, 	0.000000000000000, 	0.262737760129546, 	0.000000000000000, 	
2.734456080621830, 	0.000000000000000, 	-0.671945925075102, 	0.000000000000000, 	-3.735078262179111, 	0.000000000000000, 	-0.161705013319883, 	0.000000000000000, 	
0.748963512361001, 	0.000000000000000, 	1.128046374367600, 	0.000000000000000, 	0.649651335592966, 	0.000000000000000, 	1.880020215025867, 	0.000000000000000, 	
-1.095632293842306, 	0.000000000000000, 	1.197764876160487, 	0.000000000000000, 	0.323646656252985, 	0.000000000000000, 	-1.655502751114502, 	0.000000000000000, 	
3.666399062961496, 	0.000000000000000, 	-0.334060899735197, 	0.000000000000000, 	-2.119056978738397, 	0.000000000000000, 	3.721375117275012, 	0.000000000000000, 	
0.044874186872307, 	0.000000000000000, 	-2.733053897593234, 	0.000000000000000, 	1.590700278891042, 	0.000000000000000, 	3.215711772781902, 	0.000000000000000, 	
-1.792085012843801, 	0.000000000000000, 	-0.405797188885475, 	0.000000000000000, 	-0.628080020080892, 	0.000000000000000, 	-1.831815840843960, 	0.000000000000000, 	
2.973656862522834, 	0.000000000000000, 	-0.212032655138417, 	0.000000000000000, 	0.372437389437234, 	0.000000000000000, 	-1.614030579023492, 	0.000000000000000, 	
-0.704900996358698, 	0.000000000000000, 	1.123700273452105, 	0.000000000000000, 	-0.136371848130819, 	0.000000000000000, 	3.020284357635585, 	0.000000000000000, 	
-0.550211350877649, 	0.000000000000000, 	5.101256236381711, 	0.000000000000000, 	3.367051512192333, 	0.000000000000000, 	-4.385131946669234, 	0.000000000000000, 	
-3.967303337694391, 	0.000000000000000, 	-0.965894936640022, 	0.000000000000000, 	0.328366945264681, 	0.000000000000000, 	0.199041562924914, 	0.000000000000000, 	
1.067681999025495, 	0.000000000000000, 	-1.939516091697170, 	0.000000000000000, 	-1.092980954328824, 	0.000000000000000, 	0.273786079368066, 	0.000000000000000, 	
-0.040928322190265, 	0.000000000000000, 	-0.118368078577437, 	0.000000000000000, 	1.766589628899997, 	0.000000000000000, 	1.738321311635393, 	0.000000000000000, 	
-2.895012794321649, 	0.000000000000000, 	1.213521771395142, 	0.000000000000000, 	0.922971726633985, 	0.000000000000000, 	1.091516563636489, 	0.000000000000000, 	
3.226378465469620, 	0.000000000000000, 	1.149169778666974, 	0.000000000000000, 	-1.695986327709386, 	0.000000000000000, 	-0.974803077355813, 	0.000000000000000, 	
-4.898035507513607, 	0.000000000000000, 	1.622719302889447, 	0.000000000000000, 	0.583891313586579, 	0.000000000000000, 	-1.677182424094957, 	0.000000000000000, 	
-1.915633132814685, 	0.000000000000000, 	-1.980150370851616, 	0.000000000000000, 	0.604538269404190, 	0.000000000000000, 	0.939862406149365, 	0.000000000000000, 	
-1.266939874246416, 	0.000000000000000, 	-1.494771249200063, 	0.000000000000000, 	0.278042784093988, 	0.000000000000000, 	0.326627416008916, 	0.000000000000000, 	
-1.914530157643303, 	0.000000000000000, 	1.908947721862196, 	0.000000000000000, 	0.531819285694044, 	0.000000000000000, 	3.056856632319658, 	0.000000000000000, 	
-0.389241827774643, 	0.000000000000000, 	-2.418606606780420, 	0.000000000000000, 	0.915299238878703, 	0.000000000000000, 	-0.098774174295283, 	0.000000000000000, 	
-0.906199428444304, 	0.000000000000000, 	0.316716451217743, 	0.000000000000000, 	-4.367700643578311, 	0.000000000000000, 	1.491687997515293, 	0.000000000000000, 	
-1.962381126288365, 	0.000000000000000, 	-0.700829196527045, 	0.000000000000000, 	3.028958963615630, 	0.000000000000000, 	-2.313461067462598, 	0.000000000000000, 	
-1.431933239886712, 	0.000000000000000, 	-0.831153039725342, 	0.000000000000000, 	3.939495598250743, 	0.000000000000000, 	0.342974753984771, 	0.000000000000000, 	
-2.768330763002974, 	0.000000000000000, 	-2.744010370019008, 	0.000000000000000, 	3.821352685212561, 	0.000000000000000, 	4.551065271455856, 	0.000000000000000, 	
3.270136437041298, 	0.000000000000000, 	-3.188028411950982, 	0.000000000000000, 	-0.777075012417436, 	0.000000000000000, 	0.097110650265216, 	0.000000000000000, 	
1.221216137608812, 	0.000000000000000, 	-1.325824244541822, 	0.000000000000000, 	-2.655296734084113, 	0.000000000000000, 	-1.074792144885704, 	0.000000000000000, 	
2.770401584439407, 	0.000000000000000, 	5.240270645610543, 	0.000000000000000, 	0.108576672208892, 	0.000000000000000, 	-1.209394350650142, 	0.000000000000000, 	
1.403344353838785, 	0.000000000000000, 	-0.299032904177277, 	0.000000000000000, 	4.074959450638227, 	0.000000000000000, 	1.718727473952107, 	0.000000000000000, 	
-3.061349227080806, 	0.000000000000000, 	-1.158596888541269, 	0.000000000000000, 	3.381858904662625, 	0.000000000000000, 	0.957339964054052, 	0.000000000000000, 	
0.179900074904899, 	0.000000000000000, 	-3.909641902506081, 	0.000000000000000, 	0.805717289408649, 	0.000000000000000, 	2.047413793928261, 	0.000000000000000, 	
-1.273580225826614, 	0.000000000000000, 	-2.681359186869971, 	0.000000000000000, 	-0.721241345822093, 	0.000000000000000, 	-1.613090681569475, 	0.000000000000000, 	
0.463138804815955, 	0.000000000000000, 	0.377223507800954, 	0.000000000000000, 	2.046550684968141, 	0.000000000000000, 	0.178508732797712, 	0.000000000000000, 	
-0.477815330358845, 	0.000000000000000, 	3.763355908332053, 	0.000000000000000, 	1.300430303035163, 	0.000000000000000, 	-0.214625793857725, 	0.000000000000000, 	
1.343267891864081, 	0.000000000000000, 	-0.340007682433245, 	0.000000000000000, 	2.062703194680005, 	0.000000000000000, 	0.042032160234235, 	0.000000000000000, 	
0.643732569732250, 	0.000000000000000, 	-1.913502543857589, 	0.000000000000000, 	3.771340762937158, 	0.000000000000000, 	1.050024807363386, 	0.000000000000000, 	
-4.440489488592649, 	0.000000000000000, 	0.444904302066643, 	0.000000000000000, 	2.898702265650048, 	0.000000000000000, 	1.953232980548558, 	0.000000000000000, 	
2.761564952735079, 	0.000000000000000, 	1.963537633260397, 	0.000000000000000, 	-2.168858472916215, 	0.000000000000000, 	-4.116235357699841, 	0.000000000000000, 	
4.183678271896528, 	0.000000000000000, 	0.600422284944681, 	0.000000000000000, 	-0.659352647255126, 	0.000000000000000, 	-0.993127338218109, 	0.000000000000000, 	
-2.463571314945747, 	0.000000000000000, 	0.937720951545881, 	0.000000000000000, 	-3.098957308429730, 	0.000000000000000, 	-2.354719140045463, 	0.000000000000000, 	
-0.417285119323949, 	0.000000000000000, 	2.187974075975947, 	0.000000000000000, 	1.101468905172585, 	0.000000000000000, 	-3.185800678152109, 	0.000000000000000, 	
2.357534709345083, 	0.000000000000000, 	0.246645606729407, 	0.000000000000000, 	4.440905650784504, 	0.000000000000000, 	-2.236807716637866, 	0.000000000000000, 	
-2.171481518317550, 	0.000000000000000, 	-2.029571795072690, 	0.000000000000000, 	0.135599790431348, 	0.000000000000000, 	-1.277965265520191, 	0.000000000000000, 	
-1.927976233157507, 	0.000000000000000, 	-5.434492783745394, 	0.000000000000000, 	-2.026375829312657, 	0.000000000000000, 	1.009666016819321, 	0.000000000000000, 	
0.238549782367247, 	0.000000000000000, 	-0.516403923971309, 	0.000000000000000, 	-0.933977817429352, 	0.000000000000000, 	0.155803015935614, 	0.000000000000000, 	
-0.396194809997929, 	0.000000000000000, 	-0.915178100253214, 	0.000000000000000, 	0.666329367985015, 	0.000000000000000, 	-1.517991149945785, 	0.000000000000000, 	
0.458266744144822, 	0.000000000000000, 	-1.242845974381418, 	0.000000000000000, 	0.057914823556477, 	0.000000000000000, 	0.994101307476875, 	0.000000000000000, 	
-2.387209849199325, 	0.000000000000000, 	0.459297048883826, 	0.000000000000000, 	0.227711405683905, 	0.000000000000000, 	0.030255073506117, 	0.000000000000000, 	
-1.323361608181337, 	0.000000000000000, 	-4.650244457426706, 	0.000000000000000, 	0.062908579526021, 	0.000000000000000, 	3.462831028244432, 	0.000000000000000, 	
1.303608183314856, 	0.000000000000000, 	-1.430415193881612, 	0.000000000000000, 	-1.672886118942142, 	0.000000000000000, 	0.992890699210099, 	0.000000000000000, 	
-0.160814531784247, 	0.000000000000000, 	-1.238132939350430, 	0.000000000000000, 	-0.589223271459376, 	0.000000000000000, 	2.326363810561534, 	0.000000000000000, 	
-4.433789496230785, 	0.000000000000000, 	1.664686987538929, 	0.000000000000000, 	-2.366128834617921, 	0.000000000000000, 	1.212421570743837, 	0.000000000000000, 	
-4.847914267690055, 	0.000000000000000, 	0.228485221404712, 	0.000000000000000, 	0.466139765470957, 	0.000000000000000, 	-1.344202776943546, 	0.000000000000000, 	
-1.012053673330574, 	0.000000000000000, 	-2.844980626424742, 	0.000000000000000, 	-1.552703722026340, 	0.000000000000000, 	-1.448830983885038, 	0.000000000000000, 	
0.127010756753980, 	0.000000000000000, 	-1.667188263752299, 	0.000000000000000, 	3.424818052085100, 	0.000000000000000, 	0.956291135453840, 	0.000000000000000, 	
-3.725533331754662, 	0.000000000000000, 	-1.584534272368832, 	0.000000000000000, 	-1.654148210472472, 	0.000000000000000, 	0.701610500675698, 	0.000000000000000, 	
0.164954538683927, 	0.000000000000000, 	-0.739260064712987, 	0.000000000000000, 	-2.167324026090101, 	0.000000000000000, 	-0.310240491909496, 	0.000000000000000, 	
-2.281790349106906, 	0.000000000000000, 	1.719655331305361, 	0.000000000000000, 	-2.997005923606441, 	0.000000000000000, 	-1.999301431556852, 	0.000000000000000, 	
-0.292229010068828, 	0.000000000000000, 	1.172317994855851, 	0.000000000000000, 	0.196734885241533, 	0.000000000000000, 	2.981365193477068, 	0.000000000000000, 	
2.637726016926352, 	0.000000000000000, 	1.434045125217982, 	0.000000000000000, 	0.883627180451827, 	0.000000000000000, 	-1.434040761445747, 	0.000000000000000, 	
-1.528891971086553, 	0.000000000000000, 	-3.306913135367542, 	0.000000000000000, 	-0.399059265470646, 	0.000000000000000, 	-0.265674394285178, 	0.000000000000000, 	
3.502591252855384, 	0.000000000000000, 	0.830301156604454, 	0.000000000000000, 	-0.220021317046083, 	0.000000000000000, 	-0.090553770476646, 	0.000000000000000, 	
0.771863477047951, 	0.000000000000000, 	1.351209629105760, 	0.000000000000000, 	3.773699756201963, 	0.000000000000000, 	0.472600118752329, 	0.000000000000000, 	
2.332825668012222, 	0.000000000000000, 	1.853747950314528, 	0.000000000000000, 	0.759515251766178, 	0.000000000000000, 	1.327112776215496, 	0.000000000000000, 	
2.518730296237868, 	0.000000000000000, 	0.764450208786353, 	0.000000000000000, 	-0.278275349491296, 	0.000000000000000, 	-0.041559465082020, 	0.000000000000000, 	
1.387166083167787, 	0.000000000000000, 	2.612996769598122, 	0.000000000000000, 	-0.385404831721799, 	0.000000000000000, 	2.005630016170309, 	0.000000000000000, 	
-0.950500047307998, 	0.000000000000000, 	-1.166884021392492, 	0.000000000000000, 	1.432973552928162, 	0.000000000000000, 	2.540370505384567, 	0.000000000000000, 	
-1.140505295054501, 	0.000000000000000, 	-3.673358835201185, 	0.000000000000000, 	-0.450691288038056, 	0.000000000000000, 	1.601024294408014, 	0.000000000000000, 	
0.773213556014045, 	0.000000000000000, 	2.973873693246168, 	0.000000000000000, 	-1.361548406382279, 	0.000000000000000, 	1.409136332424815, 	0.000000000000000, 	
-0.963382518314713, 	0.000000000000000, 	-2.031268227368161, 	0.000000000000000, 	0.983309972085586, 	0.000000000000000, 	-3.461412488471631, 	0.000000000000000, 	
-2.601124929406039, 	0.000000000000000, 	-0.533896239766343, 	0.000000000000000, 	-2.627129008866350, 	0.000000000000000, 	0.622111169161305, 	0.000000000000000, 	
-1.160926365580422, 	0.000000000000000, 	-2.406196188132628, 	0.000000000000000, 	-1.076870362758737, 	0.000000000000000, 	-1.791866820937175, 	0.000000000000000, 	
-0.749453071522325, 	0.000000000000000, 	-5.324156615990973, 	0.000000000000000, 	-1.038698022238289, 	0.000000000000000, 	-2.106629944730630, 	0.000000000000000, 	
0.659295598564773, 	0.000000000000000, 	0.520940881580988, 	0.000000000000000, 	-0.055649203928700, 	0.000000000000000, 	0.292096765423137, 	0.000000000000000, 	
-4.663743901790872, 	0.000000000000000, 	-0.125066503391666, 	0.000000000000000, 	-2.452620252445380, 	0.000000000000000, 	-0.712128227397468, 	0.000000000000000, 	
-0.048938037970968, 	0.000000000000000, 	-1.821520226003361, 	0.000000000000000, 	0.810106421304257, 	0.000000000000000, 	-0.196636623956257, 	0.000000000000000, 	
-0.701769836763804, 	0.000000000000000, 	2.460345045649201, 	0.000000000000000, 	3.506597671641116, 	0.000000000000000, 	-2.711322611972225, 	0.000000000000000, 	
-0.658079876600542, 	0.000000000000000, 	-2.040082099646173, 	0.000000000000000, 	2.201668355395807, 	0.000000000000000, 	1.181507395879711, 	0.000000000000000, 	
-1.640739552179682, 	0.000000000000000, 	-1.613393726467190, 	0.000000000000000, 	-1.156741241731352, 	0.000000000000000, 	2.527773464519963, 	0.000000000000000, 	
-0.497040638009502, 	0.000000000000000, 	-0.975817112895589, 	0.000000000000000, 	-2.866830755546166, 	0.000000000000000, 	1.120214498507878, 	0.000000000000000, 	
5.986771654661698, 	0.000000000000000, 	0.398219252656757, 	0.000000000000000, 	-3.545606013198135, 	0.000000000000000, 	0.312398099396191, 	0.000000000000000, 	
-2.265327979531788, 	0.000000000000000, 	0.792121001107366, 	0.000000000000000, 	-3.736145137670100, 	0.000000000000000, 	0.762228883650802, 	0.000000000000000, 	
2.283545661214646, 	0.000000000000000, 	3.780020629583529, 	0.000000000000000, 	3.117260228608810, 	0.000000000000000, 	-2.011159255609613, 	0.000000000000000, 	
0.279107700476072, 	0.000000000000000, 	2.003369134246936, 	0.000000000000000, 	-1.448171234480257, 	0.000000000000000, 	0.584697150310140, 	0.000000000000000, 	
0.919508663636197, 	0.000000000000000, 	-3.071349141675388, 	0.000000000000000, 	-1.555923649263667, 	0.000000000000000, 	2.232497079438850, 	0.000000000000000, 	
-0.012662139119883, 	0.000000000000000, 	0.372825540734715, 	0.000000000000000, 	2.378543590847629, 	0.000000000000000, 	1.459053407813062, 	0.000000000000000, 	
-0.967913907390927, 	0.000000000000000, 	1.322825200678212, 	0.000000000000000, 	-1.033775820061824, 	0.000000000000000, 	-1.813629552693142, 	0.000000000000000, 	
4.794348161661486, 	0.000000000000000, 	0.655279811518676, 	0.000000000000000, 	-2.224590138589720, 	0.000000000000000, 	0.595329481295766, 	0.000000000000000, 	
3.364055988866225, 	0.000000000000000, 	1.863416422998127, 	0.000000000000000, 	1.930305751828105, 	0.000000000000000, 	-0.284467053432545, 	0.000000000000000, 	
-0.923374905878938, 	0.000000000000000, 	1.922988234041399, 	0.000000000000000, 	0.310482143432719, 	0.000000000000000, 	0.332122302397134, 	0.000000000000000, 	
-1.659487472408966, 	0.000000000000000, 	-1.865943507877961, 	0.000000000000000, 	-0.186775297569864, 	0.000000000000000, 	-1.700543850628361, 	0.000000000000000, 	
0.497157959366735, 	0.000000000000000, 	-0.471244843957418, 	0.000000000000000, 	-0.432013753969948, 	0.000000000000000, 	-4.000189880113231, 	0.000000000000000, 	
-0.415335170016467, 	0.000000000000000, 	0.317311950972859, 	0.000000000000000, 	0.038393428927595, 	0.000000000000000, 	0.177219909465206, 	0.000000000000000, 	
0.531650958095143, 	0.000000000000000, 	-2.711644985175806, 	0.000000000000000, 	0.328744077805156, 	0.000000000000000, 	-0.938417707547928, 	0.000000000000000, 	
0.970379584897379, 	0.000000000000000, 	1.873649473917137, 	0.000000000000000, 	0.177938226987023, 	0.000000000000000, 	0.155609346302393, 	0.000000000000000, 	
-1.276504241867208, 	0.000000000000000, 	-0.463725075928807, 	0.000000000000000, 	-0.064748250389500, 	0.000000000000000, 	-1.725568534062385, 	0.000000000000000, 	
-0.139066584804067, 	0.000000000000000, 	1.975514554117767, 	0.000000000000000, 	-0.807063199499478, 	0.000000000000000, 	-0.326926659682788, 	0.000000000000000, 	
1.445727032487938, 	0.000000000000000, 	-0.597151107739100, 	0.000000000000000, 	2.732557531709386, 	0.000000000000000, 	-2.907130934109188, 	0.000000000000000, 	
-1.461264832679981, 	0.000000000000000, 	-1.708588604968163, 	0.000000000000000, 	3.652851925431363, 	0.000000000000000, 	0.682050868282879, 	0.000000000000000, 	
-0.281312579963294, 	0.000000000000000, 	0.554966483307825, 	0.000000000000000, 	-0.981341739340932, 	0.000000000000000, 	1.279543331141603, 	0.000000000000000, 	
0.036589747826856, 	0.000000000000000, 	2.312073745896073, 	0.000000000000000, 	1.754682200732425, 	0.000000000000000, 	-0.957515875428627, 	0.000000000000000, 	
-0.833596942819695, 	0.000000000000000, 	0.437054368791033, 	0.000000000000000, 	-0.898819399360279, 	0.000000000000000, 	-0.296050580896839, 	0.000000000000000, 	
-0.785144257649601, 	0.000000000000000, 	-2.541503089003311, 	0.000000000000000, 	2.225075846758761, 	0.000000000000000, 	-1.587290487902002, 	0.000000000000000, 	
-1.421404172056462, 	0.000000000000000, 	-3.015149802293631, 	0.000000000000000, 	1.780874288867949, 	0.000000000000000, 	-0.865812740882613, 	0.000000000000000, 	
-2.845327531197112, 	0.000000000000000, 	1.445225867774367, 	0.000000000000000, 	2.183733236584647, 	0.000000000000000, 	1.163371072749080, 	0.000000000000000, 	
0.883547693520409, 	0.000000000000000, 	-1.224093106684675, 	0.000000000000000, 	-1.854501116331044, 	0.000000000000000, 	1.783082089255796, 	0.000000000000000, 	
2.301508706196191, 	0.000000000000000, 	-0.539901944139077, 	0.000000000000000, 	1.962315832319967, 	0.000000000000000, 	-0.060709041870503, 	0.000000000000000, 	
-1.353139923300238, 	0.000000000000000, 	-1.482887537805234, 	0.000000000000000, 	1.273732601967176, 	0.000000000000000, 	-3.456609915556321, 	0.000000000000000, 	
-3.752320586540873, 	0.000000000000000, 	3.536356614978951, 	0.000000000000000, 	0.206035952043233, 	0.000000000000000, 	5.933966913773842, 	0.000000000000000, 	
-0.486633898075490, 	0.000000000000000, 	-0.329595089863342, 	0.000000000000000, 	1.496414153905337, 	0.000000000000000, 	0.137868749388880, 	0.000000000000000, 	
-0.437192030996792, 	0.000000000000000, 	2.682750615210656, 	0.000000000000000, 	-2.440234892848570, 	0.000000000000000, 	1.433910252426186, 	0.000000000000000, 	
-0.415051506104074, 	0.000000000000000, 	1.982003013708649, 	0.000000000000000, 	1.345796609972435, 	0.000000000000000, 	-2.335949513404370, 	0.000000000000000, 	
1.065988867433025, 	0.000000000000000, 	2.741844905000464, 	0.000000000000000, 	-1.754047930934362, 	0.000000000000000, 	0.229252730015575, 	0.000000000000000, 	
-0.679791016408669, 	0.000000000000000, 	-2.274097820043743, 	0.000000000000000, 	0.149802252231876, 	0.000000000000000, 	-0.139697151364830, 	0.000000000000000, 	
-2.773367420505435, 	0.000000000000000, 	-4.403400246165611, 	0.000000000000000, 	-1.468974515184135, 	0.000000000000000, 	0.664990623095844, 	0.000000000000000, 	
-3.446979775557143, 	0.000000000000000, 	1.850006428987618, 	0.000000000000000, 	-1.550866747921936, 	0.000000000000000, 	-3.632874882935257, 	0.000000000000000, 	
0.828039662992464, 	0.000000000000000, 	2.794055182632816, 	0.000000000000000, 	-0.593995716682633, 	0.000000000000000, 	0.142788156054200, 	0.000000000000000, 	
0.552461945119668, 	0.000000000000000, 	0.842127129738758, 	0.000000000000000, 	1.414335509600077, 	0.000000000000000, 	-0.311559241382430, 	0.000000000000000, 	
1.510590844695250, 	0.000000000000000, 	1.692217183824300, 	0.000000000000000, 	0.613760285711957, 	0.000000000000000, 	0.065233463207770, 	0.000000000000000, 	
-2.571912893711505, 	0.000000000000000, 	-1.707001531141341, 	0.000000000000000, 	0.673884968382041, 	0.000000000000000, 	0.889863883420103, 	0.000000000000000, 	
-2.395635435233346, 	0.000000000000000, 	1.129247296359819, 	0.000000000000000, 	0.569074704779735, 	0.000000000000000, 	6.139436017480722, 	0.000000000000000, 	
0.822158309259017, 	0.000000000000000, 	-3.289872016222589, 	0.000000000000000, 	0.417612988384414, 	0.000000000000000, 	1.493982103868165, 	0.000000000000000, 	
-0.415353391377005, 	0.000000000000000, 	0.288670764933155, 	0.000000000000000, 	-1.895650228872272, 	0.000000000000000, 	-0.139631694475020, 	0.000000000000000, 	
1.445103299005436, 	0.000000000000000, 	2.877182243683429, 	0.000000000000000, 	1.192428490172580, 	0.000000000000000, 	-5.964591921763842, 	0.000000000000000, 	
0.570859795882959, 	0.000000000000000, 	2.328333316356666, 	0.000000000000000, 	0.333755014930026, 	0.000000000000000, 	1.221901577771909, 	0.000000000000000, 	
0.943358697415568, 	0.000000000000000, 	2.793063983613067, 	0.000000000000000, 	3.163005066073616, 	0.000000000000000, 	2.098300664513867, 	0.000000000000000, 	
-3.915313164333447, 	0.000000000000000, 	-2.475766769064539, 	0.000000000000000, 	1.720472044894277, 	0.000000000000000, 	-1.273591949275665, 	0.000000000000000, 	
-1.213451272938616, 	0.000000000000000, 	0.697439404325690, 	0.000000000000000, 	-0.309902287574293, 	0.000000000000000, 	2.622575852162781, 	0.000000000000000, 	
-2.075881936219060, 	0.000000000000000, 	0.777847545691770, 	0.000000000000000, 	-3.967947986440650, 	0.000000000000000, 	-3.066503371806472, 	0.000000000000000, 	
1.193780625937845, 	0.000000000000000, 	0.214246579281311, 	0.000000000000000, 	-2.610681491162162, 	0.000000000000000, 	-1.261224183972745, 	0.000000000000000, 	
-1.165071748544285, 	0.000000000000000, 	-1.116548474834374, 	0.000000000000000, 	0.847202164846982, 	0.000000000000000, 	-3.474301529532390, 	0.000000000000000, 	
0.020799541946476, 	0.000000000000000, 	-3.868995473288166, 	0.000000000000000, 	1.757979409638067, 	0.000000000000000, 	0.868115130183109, 	0.000000000000000, 	
0.910167436737958, 	0.000000000000000, 	-1.878855115563720, 	0.000000000000000, 	1.710357104174161, 	0.000000000000000, 	-1.468933980990902, 	0.000000000000000, 	
1.799544171601169, 	0.000000000000000, 	-4.922332880027887, 	0.000000000000000, 	0.219424548939720, 	0.000000000000000, 	-0.971671113451924, 	0.000000000000000, 	
-0.940533475616266, 	0.000000000000000, 	0.122510114412152, 	0.000000000000000, 	-1.373686254916911, 	0.000000000000000, 	1.760348103896323, 	0.000000000000000, 	
0.391745067829643, 	0.000000000000000, 	2.521958505327354, 	0.000000000000000, 	-1.300693516405092, 	0.000000000000000, 	-0.538251788309178, 	0.000000000000000, 	
0.797184135810173, 	0.000000000000000, 	2.908800548982588, 	0.000000000000000, 	1.590902251655215, 	0.000000000000000, 	-1.070323714487264, 	0.000000000000000, 	
-3.349764443340999, 	0.000000000000000, 	-1.190563529731447, 	0.000000000000000, 	1.363369471291963, 	0.000000000000000, 	-1.814270299924576, 	0.000000000000000, 	
-0.023381588315711, 	0.000000000000000, 	1.719182048679569, 	0.000000000000000, 	0.839917213252626, 	0.000000000000000, 	1.006099633839122, 	0.000000000000000, 	
0.812462674381527, 	0.000000000000000, 	1.755814336346739, 	0.000000000000000, 	2.546848681206319, 	0.000000000000000, 	-1.555300208869455, 	0.000000000000000, 	
1.017053811631167, 	0.000000000000000, 	0.996591039170903, 	0.000000000000000, 	-1.228047247924881, 	0.000000000000000, 	4.809462271463009, 	0.000000000000000, 	
2.318113116151685, 	0.000000000000000, 	-1.206932520679733, 	0.000000000000000, 	1.273757685623312, 	0.000000000000000, 	0.724335352481802, 	0.000000000000000, 	
1.519876652073198, 	0.000000000000000, 	-2.749670314714158, 	0.000000000000000, 	3.424042481847581, 	0.000000000000000, 	-3.714668360421517, 	0.000000000000000, 	
1.612834197004014, 	0.000000000000000, 	-2.038234723985566, 	0.000000000000000, 	1.470938786562152, 	0.000000000000000, 	2.111634918450302, 	0.000000000000000, 	
1.030376670151787, 	0.000000000000000, 	-0.420877189003829, 	0.000000000000000, 	-1.502024800532894, 	0.000000000000000, 	0.452310749163804, 	0.000000000000000, 	
-1.606059382300987, 	0.000000000000000, 	-4.006159967834147, 	0.000000000000000, 	-2.152801208196508, 	0.000000000000000, 	1.671674089372579, 	0.000000000000000, 	
1.714536333564101, 	0.000000000000000, 	-1.011518543005344, 	0.000000000000000, 	-0.576410282180584, 	0.000000000000000, 	0.733689809480836, 	0.000000000000000, 	
1.004245602717974, 	0.000000000000000, 	1.010090391888449, 	0.000000000000000, 	3.811459513385621, 	0.000000000000000, 	-5.230621089271954, 	0.000000000000000, 	
0.678044861034399, 	0.000000000000000, 	1.255935859598107, 	0.000000000000000, 	1.674521701615288, 	0.000000000000000, 	-1.656695216761705, 	0.000000000000000, 	
1.169286028869693, 	0.000000000000000, 	0.524915416191998, 	0.000000000000000, 	2.397642885039520, 	0.000000000000000, 	2.108711400616072, 	0.000000000000000, 	
2.037618211018084, 	0.000000000000000, 	-0.623664553406925, 	0.000000000000000, 	2.984106170984409, 	0.000000000000000, 	1.132182737400932, 	0.000000000000000, 	
-2.859274340352130, 	0.000000000000000, 	-0.975550071398723, 	0.000000000000000, 	-1.359935119997407, 	0.000000000000000, 	-2.963308211050121, 	0.000000000000000, 	
-0.228726662781163, 	0.000000000000000, 	-1.411110379682043, 	0.000000000000000, 	0.741553355734225, 	0.000000000000000, 	0.497554254758309, 	0.000000000000000, 	
2.371907950598855, 	0.000000000000000, 	1.063465168988748, 	0.000000000000000, 	-0.641082692081488, 	0.000000000000000, 	-0.855439878540726, 	0.000000000000000, 	
0.578321738578726, 	0.000000000000000, 	3.005809768796194, 	0.000000000000000, 	1.961458699064065, 	0.000000000000000, 	-3.206261663772745, 	0.000000000000000, 	
-0.364431989095434, 	0.000000000000000, 	-0.263182496622273, 	0.000000000000000, 	1.843464680631139, 	0.000000000000000, 	-0.419107530229249, 	0.000000000000000, 	
1.662335873298487, 	0.000000000000000, 	-0.853687563304005, 	0.000000000000000, 	-2.584133404357169, 	0.000000000000000, 	3.466839568922895, 	0.000000000000000, 	
0.881671345091973, 	0.000000000000000, 	0.454620014206908, 	0.000000000000000, 	-1.737245187402739, 	0.000000000000000, 	2.162713238369243, 	0.000000000000000, 	
-3.868539002714486, 	0.000000000000000, 	2.014114855933826, 	0.000000000000000, 	-0.703233831811006, 	0.000000000000000, 	-3.410319935997574, 	0.000000000000000, 	
-1.851235811006584, 	0.000000000000000, 	0.909783907894036, 	0.000000000000000, 	0.091884002136728, 	0.000000000000000, 	-2.688294201131650, 	0.000000000000000, 	
-0.906134178460955, 	0.000000000000000, 	3.475054609035133, 	0.000000000000000, 	-0.573927964170323, 	0.000000000000000, 	-0.429542937515399, 	0.000000000000000, 	
0.991348618739939, 	0.000000000000000, 	1.974804904926325, 	0.000000000000000, 	0.975783450796698, 	0.000000000000000, 	-3.057119549071503, 	0.000000000000000, 	
-3.899429237481194, 	0.000000000000000, 	0.362439009175350, 	0.000000000000000, 	-1.124461670265618, 	0.000000000000000, 	1.806000360163583, 	0.000000000000000, 	
-2.768333362600288, 	0.000000000000000, 	0.244387897900379, 	0.000000000000000, 	0.908767296720926, 	0.000000000000000, 	1.254669374391882, 	0.000000000000000, 	
-1.420441929463686, 	0.000000000000000, 	-0.875658895966293, 	0.000000000000000, 	0.183824603376167, 	0.000000000000000, 	-3.361653917011686, 	0.000000000000000, 	
-0.796615630227952, 	0.000000000000000, 	-1.660226542658673, 	0.000000000000000, 	1.654439358307226, 	0.000000000000000, 	2.782812946709771, 	0.000000000000000, 	
1.418064412811531, 	0.000000000000000, 	-0.819645647243761, 	0.000000000000000, 	0.807724772592699, 	0.000000000000000, 	-0.941967976379298, 	0.000000000000000, 	
-2.312768306047469, 	0.000000000000000, 	0.872426936477443, 	0.000000000000000, 	0.919528961530845, 	0.000000000000000, 	-2.084904575264847, 	0.000000000000000, 	
-1.972464868459322, 	0.000000000000000, 	-1.050687203338466, 	0.000000000000000, 	1.659579707007902, 	0.000000000000000, 	-1.820640014705855, 	0.000000000000000, 	
-1.195078061671045, 	0.000000000000000, 	-1.639773173762048, 	0.000000000000000, 	1.616744338157063, 	0.000000000000000, 	4.019216096811563, 	0.000000000000000, 	
3.461021102549681, 	0.000000000000000, 	1.642352734361484, 	0.000000000000000, 	-0.046354693720813, 	0.000000000000000, 	-0.041936252359677, 	0.000000000000000, 	
-2.393307519480551, 	0.000000000000000, 	-0.341471634615121, 	0.000000000000000, 	-0.392073595257017, 	0.000000000000000, 	-0.219299018372730, 	0.000000000000000, 	
-2.016391579662071, 	0.000000000000000, 	-0.653096251969787, 	0.000000000000000, 	1.466353155666821, 	0.000000000000000, 	-2.872058864320412, 	0.000000000000000, 	
-2.157180779503830, 	0.000000000000000, 	0.723257479841560, 	0.000000000000000, 	3.769951308104384, 	0.000000000000000, 	-1.923392042420024, 	0.000000000000000, 	
0.644899359942840, 	0.000000000000000, 	-2.090226891621437, 	0.000000000000000, 	-0.277043982890403, 	0.000000000000000, 	-0.528271428321112, 	0.000000000000000, 	
2.518120645960652, 	0.000000000000000, 	1.040820431111488, 	0.000000000000000, 	-4.560583754742486, 	0.000000000000000, 	-0.226899614918836, 	0.000000000000000, 	
1.713331231108959, 	0.000000000000000, 	-3.293941019163642, 	0.000000000000000, 	-1.113331444648290, 	0.000000000000000, 	-1.032308423149906, 	0.000000000000000, 	
1.593774272982443, 	0.000000000000000, 	-1.246840475090529, 	0.000000000000000, 	-0.190344684920137, 	0.000000000000000, 	-1.719386356896355, 	0.000000000000000, 	
-2.827721754659679, 	0.000000000000000, 	-0.092438285279020, 	0.000000000000000, 	-0.565844430675246, 	0.000000000000000, 	-1.077916121691716, 	0.000000000000000, 	
-1.208665809504693, 	0.000000000000000, 	-2.996014266381254, 	0.000000000000000, 	2.888573323402423, 	0.000000000000000, 	2.829507048720695, 	0.000000000000000, 	
-0.859177034120755, 	0.000000000000000, 	-1.969302377743254, 	0.000000000000000, 	0.777437674525362, 	0.000000000000000, 	-0.124910190157646, 	0.000000000000000, 	
0.129875493115290, 	0.000000000000000, 	-4.192139262163992, 	0.000000000000000, 	3.023496047962126, 	0.000000000000000, 	1.149775163736637, 	0.000000000000000, 	
2.038151304801731, 	0.000000000000000, 	3.016122489841263, 	0.000000000000000, 	-4.829481812137012, 	0.000000000000000, 	-1.668436615909279, 	0.000000000000000, 	
0.958586784636918, 	0.000000000000000, 	1.550652410058678, 	0.000000000000000, 	-1.456305257976716, 	0.000000000000000, 	-0.079588392344731, 	0.000000000000000, 	
-2.453213599392345, 	0.000000000000000, 	0.296795909127105, 	0.000000000000000, 	-0.253426616607643, 	0.000000000000000, 	1.418937160028195, 	0.000000000000000, 	
-1.672949529066915, 	0.000000000000000, 	-1.620990298572947, 	0.000000000000000, 	-1.085103073196045, 	0.000000000000000, 	0.738606361195386, 	0.000000000000000, 	
-2.097831202853255, 	0.000000000000000, 	2.711952282071310, 	0.000000000000000, 	1.498539238246888, 	0.000000000000000, 	1.317457282535915, 	0.000000000000000, 	
-0.302765938349717, 	0.000000000000000, 	-0.044623707947201, 	0.000000000000000, 	2.337405215062395, 	0.000000000000000, 	-3.980689173859100, 	0.000000000000000, 	


};

