## Контейнеры
Виджеты можно объединять в контейнеры. Контейнер нужно начать и закончить, так как пакет данных собирается линейно в целях оптимизации скорости и памяти.

Метод `beginКонтейнер` всегда вернёт true для красоты организации кода в блоке условия:

```cpp
void build(sets::Builder& b) {
    if (b.beginКонтейнер()) {
        // виджеты...

        b.endКонтейнер();  // закрыть контейнер
    }
}
```

Второй вариант - у всех контейнеров есть парный класс, который сам откроет и закроет контейнер. Нужно создать объект с любым именем и передать ему билдер:

```cpp
void build(sets::Builder& b) {
    {
        sets::Контейнер g(b);  // должен быть первым в блоке

        // виджеты...

    } // автоматически закроется здесь
}
```

### Группа
Объединяет виджеты по вертикали с общим фоном и заголовком:

```cpp
void build(sets::Builder& b) {
    if (b.beginGroup("Group 1")) {
        b.Input();

        b.endGroup();  // закрыть группу
    }
}
```

### Меню
Можно создавать вложенные меню. Указанный заголовок будет отображаться на кнопке и в заголовке страницы при входе на меню. Все виджеты и группы, находящиеся в блоке с меню, будут находиться на отдельной странице. Вложенность меню неограниченная:

```cpp
void build(sets::Builder& b) {
    b.Input();

    {
        sets::Menu g(b, "Submenu");

        b.Input();
    }
}
```

Когда пользователь входит в меню - вызывается билдер, для того чтобы можно было например обновить некоторые поля внутри этого меню. Для опроса события входа используется `b.enterMenu()`:

```cpp
{
    sets::Menu m(b, "menu 1");
    if (b.enterMenu()) Serial.println("menu 1");
    // b.Input();
}
{
    sets::Menu m(b, "menu 2");
    if (b.enterMenu()) Serial.println("menu 2");
    // b.Input();
    {
        sets::Menu m(b, "menu 2.1");
        if (b.enterMenu()) Serial.println("menu 2.1");
        // b.Input();
    }
}
```

### Строка
Можно располагать виджеты горизонтально в строку, у них может быть общее название. Вне группы строка получит белый фон. Если у виджета задано название - он будет пытаться растянуться на всю ширину, если нет - то не будет. Частый вариант использования - первый виджет с названием, остальные мелкие без:

```cpp
void build(sets::Builder& b) {
    {
        sets::Row g(b);
        // sets::Row g(b, "Row");

        b.Slider("Slider");
        b.LED();
        b.Switch();
    }
}
```

У строки **вне группы** есть три стиля:

```cpp
void build(sets::Builder& b) {
    // разные стили Row ВНЕ ГРУППЫ
    if (b.beginRow("", sets::DivType::Default)) {
        b.Switch("Switch");
        b.Switch("Switch");
        b.endRow();
    }
    if (b.beginRow("", sets::DivType::Block)) {
        b.Switch("Switch");
        b.Switch("Switch");
        b.endRow();
    }
    if (b.beginRow("", sets::DivType::Line)) {
        b.Switch("Switch");
        b.Switch("Switch");
        b.endRow();
    }
}
```

### Кнопки
Отдельный тип контейнера - кнопки, внутри него можно добавлять только кнопки. Вне группы у них будет прозрачный фон:

```cpp
void build(sets::Builder& b) {
    {
        sets::Buttons btns(b);

        // кнопка вернёт true при клике
        if (b.Button("Button 1")) {
            Serial.println("Button 1");
        }

        if (b.Button("Button 2", sets::Colors::Blue)) {
            Serial.println("Button 2");
        }
    }
}
```

Если группа кнопок или одиночная кнопка является последней в группе - у кнопки будет другой стиль:

```cpp
void build(sets::Builder& b) {
    {
        sets::Group g(b);
        {
            sets::Buttons g(b);
            b.Button();
            b.Button();
            b.Button();
        }
        b.Button();
    }
    {
        sets::Group g(b);
        {
            sets::Row g(b);
            b.Button();
            b.Button();
            b.Button();
        }
        {
            sets::Buttons g(b);
            b.Button();
            b.Button();
            b.Button();
        }
    }
    {
        sets::Buttons g(b);
        b.Button();
        b.Button();
        b.Button();
    }
    {
        sets::Row g(b);
        b.Button();
        b.Button();
        b.Button();
    }
    b.Button();
}
```

### Авторизация
В системе предусмотрена авторизация: если в прошивке указать отличный от пустой строки пароль - вебморда будет работать в "гостевом" режиме: отображаются только разрешённые гостям виджеты, файловый менеджер и OTA скрыты и заблокированы. Для ввода пароля нужно зайти в меню (правая верхняя кнопка) и нажать на ключик. Серый ключик означает что авторизация отключена, зелёный - клиент авторизован, красный - неверный пароль. Пароль может содержать любые символы и иметь любую длину - в явном виде он не хранится и не передаётся. Пароль сохраняется в браузере и авторизация работает автоматически при перезагрузке страницы.

Для разделения админского и гостевого доступа предусмотрен виртуальный контейнер Guest. Если пароль установлен и клиент не авторизован - он будет видеть только виджеты из гостевых контейнеров. Для корректной работы гостевой контейнер не должен прерываться обычными контейнерами. Пример:

```cpp
void setup() {
    // ...
    // sett.setPass("pass1234");
    sett.setPass(F("pass1234"));  // любая строка
}

void build(sets::Builder& b) {
    if (b.beginGroup("Group 1")) {
        // гости не видят
        b.Pass(kk::pass, "Password");

        // виджеты, которые видят гости и админы
        {
            sets::GuestAccess g(b);
            b.Input(kk::uintw, "uint");
            b.Input(kk::intw, "int");
            b.Input(kk::int64w, "int 64");
        }

        // гости не видят
        {
            sets::Menu m(b, "sub sub");
            b.Label(kk::lbl2, "millis()", "", sets::Colors::Red);
        }

        b.endGroup();
    }
}
```

В гостевой контейнер можно поместить несколько обычных контейнеров, например групп.

> Примечание: если вложенное меню закрыто от гостей, но содержит ещё одно вложенное меню - кнопка открытия меню будет отображаться, но само меню будет пустым