### Настройки вебморды
Некоторые параметры вебморды можно менять из скетча. Настройки обновляются при перезагрузке страницы:

```cpp
// таймаут отправки слайдера, мс. 0 чтобы отключить
sett.config.sliderTout = 100;

// таймаут ожидания ответа сервера, мс
sett.config.requestTout = 2000;

// период обновлений, мс. 0 чтобы отключить
sett.config.updateTout = 2500;

// основная цветовая схема
sett.config.theme = sets::Colors::Green;
```

### Статус
- Вебморда отслеживает статус устройства, при потере связи появится текст offline в заголовке страницы. После потери связи вебморда будет запрашивать информацию о виджетах, это очень удобно при разработке - например добавляем виджет, загружаем прошивку. За это время вебморда уже понимает что устройство оффлайн и при первом успешном подключении выводит актуальные виджеты.
- При изменении значений виджетов вебморда следит за доставкой пакета, при ошибке связи появится надпись **error*** у соответствующего виджета
- В программе можно отследить наличие подключения с браузера по флагу `sett.focused()` или подключить обработчик `onFocusChange`

```cpp
sett.onFocusChange([]() {
    Serial.print("Focus: ");
    Serial.println(sett.focused());
});
```

### Время с браузера
При подключении браузер отправляет своё время в unix-формате, а система продолжает его поддерживать при помощи `StampKeeper` из библиотеки [Stamp](https://github.com/GyverLibs/Stamp). Можно использовать для синхронизации внешнего RTC или напрямую:

```cpp

void setup() {
    // ...

    // часовой пояс для rtc
    setStampZone(3);

    sett.rtc.onSecond([]() {
        // каждую секунду если синхронизирован
    });

    sett.rtc.onSync([](uint32_t unix) {
        // момент и время синхронизации
        Serial.print("Sync: ");
        Serial.println(unix);
    });
}

void loop() {
    sett.tick();

    // каждую секунду если синхронизирован
    if (sett.rtc.newSecond()) {
        Serial.println(sett.rtc.toString());
    }
}
```

## Другой вебсервер
Можно поднять библиотеку на любом вебсервере, для этого нужно наследоваться от `sets::SettingsBase` и реализовать нужные методы по аналогии со стандартными `SettingsGyver`, `SettingsESP` и проч.

Самый простой вариант - сделать класс на базе `SettingsT` - он использует вебсервер `GyverHTTP` на базе любого указанного стороннего сервера и клиента:

```cpp
#include "SettingsT.h"

class MySettings : public SettingsT<MyServer, MyClient> {
   public:
    using SettingsT<MyServer, MyClient>::SettingsT;

   private:
    String getMac() override {
        // mac адрес для приложения поиска Settings Discover (необязательно)
    }
    int getRSSI() override {
        // качество связи в % (необязательно)
    }
};
```

где `MyServer` и `MyClient` - класс сервера и клиента для вашей реализации связи, например классы от Ethernet модуля.