## Обновления
В системе реализован механизм обновлений - вебморда периодически запрашивает "обновления" у устройства. Если база данных подключена - то при изменениях значений в базе где то в программе библиотека **автоматически отправит новые значения** в вебморду (например если какое то значение изменилось при помощи кнопки).

> Примечание: если вебморда открыта одновременно с нескольких браузеров - обновления базы данных получит только тот из них, который запросил их первым. Также можно отправить свои значения, если база данных не подключена или не используется для каких-то виджетов. Для этого нужно подключить обработчик обновлений и вручную отправить данные по id виджета

Отправка обновлений вручную на лейблы:

```cpp
void build(sets::Builder& b) {
    b.Label("lbl1"_h, "Random");
    b.Label("lbl2"_h, "millis()", "", sets::Colors::Red);
}
void update(sets::Updater& upd) {
    upd.update("lbl1"_h, random(100));
    upd.update("lbl2"_h, millis());
}

void setup() {
    sett.begin();
    sett.onBuild(build);
    sett.onUpdate(update);
}

void loop() {
    sett.tick();
}
```

> [!WARNING]
> В функции `update` нельзя складывать строки, либо результат нужно преобразовать к String: `upd.update(id, (String)(str + 123 + "abc"));`. Проблема в несовместимости String API между ядрами esp разных версий

### Обновление цвета
Если у виджета в настройках есть цвет - этот цвет можно обновить в обновлении через `updateColor(id, цвет)`:

```cpp
void build(sets::Builder& b) {
    b.LED(H(led));
}
void update(sets::Updater& upd) {
    upd.updateColor(H(led), 0x00ff00);
    // upd.updateColor(H(led), sets::Colors::Blue);
}
```

### Всплывающие окна
Для вызова всплывающих окон нужно отправить соответствующий апдейт. Для Confirm - с его id, для остальных - просто с текстом:

```cpp
bool cfm_f, notice_f, alert_f;

void build(sets::Builder& b) {
    if (b.beginButtons()) {
        if (b.Button("Notice")) notice_f = true;
        if (b.Button("Error")) alert_f = true;
        if (b.Button("Confirm")) cfm_f = true;
        b.endButtons();
    }

    bool res;
    if (b.Confirm(kk::conf, "Confirm", &res)) {
        Serial.println(res);
        // Serial.println(b.build.value.toBool());
    }
}

void update(sets::Updater& u) {
    if (cfm_f) {
        cfm_f = false;
        u.confirm(kk::conf);
    }
    if (notice_f) {
        notice_f = false;
        u.notice("Уведомление");
    }
    if (alert_f) {
        alert_f = false;
        u.alert("Ошибка");
    }
}
```

## Вебсокет
В версиях библиотеки с вебсокетом обновления работают иначе:

- Вебморда не запрашивает обновления, их нужно отправлять самостоятельно из любого места в программе
- Изменения в БД автоматически отправляются с шагом 300мс

Для отправки обновления используется следующая конструкция:

```cpp
SettingsXxx sett;

void foo() {
    // одно значение
    sett.updater().update(...);

    // несколько значений
    sett.updater()
        .update(...)
        .update(...)
        .update(...)
        .update(...);
}
```

Для вызова доступны все версии функций `update` из обычных обновлений (`updateColor`, `update2`, `alert`...).

> [!WARNING]
> Слишком частая отправка обновлений может замедлить работу программы вплоть до перезагрузки МК! Отправляйте по таймеру, не чаще пары десятков раз в секунду

```cpp
void loop() {
    static uint32_t tmr;
    if (millis() - tmr >= 200) {
        tmr = millis();

        sett.updater()
            .updateColor(H(lbl1), 0xffaabb)
            .update(H(lbl2), random(100));
    }
}
```

Или используйте библиотеку [GTimer](https://github.com/GyverLibs/GTimer):

```cpp
void loop() {
    static GTimer<millis> tmr(500, true);

    if (tmr) {
        sett.updater()
            .update(H(lbl1), millis())
            .update(H(lbl2), random(100));
    }
}
```