## Настройки компиляции
```cpp
#define SETT_NO_DB      // полностью отключить поддержку GyverDB
#define SETT_NO_TABLE   // полностью отключить поддержку Table
```

## Типы данных
### Text
`Text` - это обёртка для текстовых данных из библиотеки [StringUtils](https://github.com/GyverLibs/StringUtils), см. документацию там. Text может конвертироваться в любые другие типы и сравниваться с ними, а также имеет множество инструментов для парсинга и поиска.

```cpp
Serial.println(b.build.value);  // печатается
b.build.value == 123;           // сравнивается
b.build.value == "123";         // сравнивается
b.build.value.toFloat();        // конвертируется
int b = b.build.value;          // авто-конвертируется
```

При передаче в функцию библиотеки аргумент `Text` может быть любым строковым типом:

```cpp
void foo(Text);     // условная функция библиотеки

String s;
foo(s);
foo("cstring");
foo(F("F-string"));
```

Если в качестве строкового значения нужно число - используйте конструктор `Value`, например `b.Color("col", "Color", Value(int_var));`

### AnyPtr
Указатель на переменную любого типа: `float`, `double`, любой целочисленный, `String`, `AnyPtr(char[], size_t len)`. В этот аргумент происходит "подключение" переменной, чтобы библиотека могла её менять:

```cpp
void foo(AnyPtr);   // условная функция библиотеки

uint32_t ul;
int arr[2];
float fl;
String s;
char buf[10];

foo(nullptr);   // по умолчанию, передано "ничего"
foo(&ul);
foo(&arr[0]);
foo(&fl);
foo(&s);
foo(AnyPtr(buf, 10));   // для char-буфера нужно явно указать длину
```

## Описание классов
- `SettingsT` (*SettingsT.h*) - вебсервер и клиент на выбор (для связи через Ethernet например)
- `SettingsGyver` (*SettingsGyver.h*) - вебсервер GyverHTTP
- `SettingsESP` (*SettingsESP.h*) - стандартный вебсервер ESP
- `SettingsAsync` (*SettingsAsync.h*) - асинхронный ESPAsyncWebserver
- `SettingsGyverWS` (*SettingsGyverWS.h*) - вебсервер GyverHTTP + websocket
- `SettingsESPWS` (*SettingsESPWS.h*) - стандартный вебсервер ESP + websocket
- `SettingsAsyncWS` (*SettingsAsyncWS.h*) - асинхронный ESPAsyncWebserver + websocket

### Вебсокет
Версия с вебсокетом позволяет отправлять обновления сразу **из любого места в программе**. Также обмен данных с сервером осуществляется быстрее, чем в обычной HTTP версии.

### SettingsXxx
```cpp
Settings(const String& title = "", GyverDB* db = nullptr);

// запустить. captive - запустить mdns для автооткрытия окна в режиме AP при подключении к точке
// domain - домен, по которому есп будет доступна в локальной сети по адресу домен.local
void begin(bool captive = true, const char* domain = nullptr);

// установить версию прошивки для отображения в меню
void setVersion(const char* ver);

// установить пароль на вебморду. Пустая строка "" чтобы отключить
void setPass(Text pass);

// перезагрузить страницу. Можно вызывать где угодно + в обработчике update
void reload(bool force = false);

// установить заголовок страницы
void setTitle(const String& title);

// подключить базу данных
void attachDB(GyverDB* db);

// использовать автоматические обновления из БД (при изменении записи новое значение отправится в браузер)
void useAutoUpdates(bool use);

// обработчик билда типа f(sets::Builder& b)
void onBuild(BuildCallback cb);

// обработчик скачивания файлов с устройства типа f(Text path)
void onFetch(FileCallback cb);

// обработчик загрузки файлов на устройство типа f(Text path)
void onUpload(FileCallback cb);

// обработчик подключения браузера f()
void onFocusChange(FocusCallback cb);

// обработчик обновлений типа f(sets::Updater& upd) [ДЛЯ ВЕРСИЙ БЕЗ ВЕБСОКЕТА]
void onUpdate(UpdateCallback cb);

// начать обновления [ДЛЯ ВЕРСИЙ С ВЕБСОКЕТОМ]
InlineUpdater updater();

// тикер, вызывать в родительском классе
void tick();

// вебморда открыта в браузере
bool focused();

// установить размер пакета (умолч. 1024 Б). 0 - отключить разбивку на пакеты. Не работает для Async-версии
void setPacketSize(size_t size);

// установить кастом js код из PROGMEM
void setCustom(const char* js, size_t len, bool gz = false);

// установить кастом js код из файла
void setCustomFile(const char* path, bool gz = false);

// установить инфо о проекте (отображается на вкладке настроек и файлов)
void setProjectInfo(const char* name, const char* link = nullptr);

// время с браузера
StampKeeper rtc;

// настройки вебморды
Config config;
{
    // таймаут отправки слайдера, мс. 0 чтобы отключить
    uint16_t sliderTout = 100;

    // таймаут ожидания ответа сервера, мс
    uint16_t requestTout = 2000;

    // период обновлений, мс. 0 чтобы отключить
    uint16_t updateTout = 2500;

    // основная цветовая схема
    Colors theme = Colors::Green;

    // использовать файловый менеджер
    bool useFS = true;
}
```

### Builder
```cpp
// инфо о билде
Build build;

// авто-ID следующего виджета
size_t nextID();

// указатель на текущий SettingsXxx
void* thisSettings();

// перезагрузить страницу (вызывать в действии, например if (...click() b.reload()))
void reload(bool force = false);

// было действие с каким-то из виджетов выше
bool wasSet();

// сбросить флаг чтения wasSet
void clearSet();

// КОНТЕЙНЕРЫ
// разрешить неавторизованным клиентам следующий код
bool beginGuest();

// запретить неавторизованным клиентам
void endGuest();

// группа
bool beginGroup(Text title = Text());
void endGroup();

// вложенное меню
bool beginMenu(Text title);
void endMenu();

// true, если в вебморде было открыто текущее меню
bool enterMenu();

// горизонтальная группа виджетов [DivType::Line | DivType::Block]
bool beginRow(Text title = Text(), DivType divtype = DivType::Default);
void endRow();

// ряд кнопок
bool beginButtons();
void endButtons();
```

#### Пассивные виджеты
```cpp
// ================= LINK =================
void Link(Text label, Text url);

// ================= LOG =================
void Log(size_t id, Logger& log, Text label = "");
void Log(Logger& log, Text label = "");

// ================= LABEL =================
// текстовое значение, может обновляться по id
void Label(size_t id, Text label = "", Text text = Text(), uint32_t color = SETS_DEFAULT_COLOR);
void Label(size_t id, Text label, Text text, sets::Colors color);
void Label(Text label = "", Text text = Text(), uint32_t color = SETS_DEFAULT_COLOR);
void Label(Text label, Text text, sets::Colors color);

// лейбл с численным значением (выполняется быстрее, весит меньше)
void LabelNum(size_t id, Text label, T text, uint32_t color = SETS_DEFAULT_COLOR);
void LabelNum(size_t id, Text label, T text, sets::Colors color);
void LabelNum(Text label, T text, uint32_t color = SETS_DEFAULT_COLOR);
void LabelNum(Text label, T text, sets::Colors color);

void LabelFloat(size_t id, Text label, float text, uint8_t dec = 2, uint32_t color = SETS_DEFAULT_COLOR);
void LabelFloat(size_t id, Text label, float text, uint8_t dec, sets::Colors color);
void LabelFloat(Text label, float text, uint8_t dec = 2, uint32_t color = SETS_DEFAULT_COLOR);
void LabelFloat(Text label, float text, uint8_t dec, sets::Colors color);

// ================= LED =================
// светодиод (value 1 включен - зелёный, value 0 выключен - красный)
void LED(size_t id, Text label, bool value);
void LED(size_t id, Text label = "");
void LED(Text label, bool value);
void LED(Text label = "");

// светодиод с цветом на выбор
void LED(size_t id, Text label, bool value, uint32_t colorOff, uint32_t colorOn);
void LED(size_t id, Text label, bool value, Colors colorOff, Colors colorOn);
void LED(Text label, bool value, uint32_t colorOff, uint32_t colorOn);
void LED(Text label, bool value, Colors colorOff, Colors colorOn);

// ================= IMAGE =================
// изображение, url или path на флешке
void Image(size_t id, Text label, Text path);
void Image(Text label, Text path);

// ================= STREAM =================
// видео с камеры ESP32-CAM
void Stream();

// ================= TEXT =================
// текстовый абзац
void Paragraph(size_t id, Text label = "", Text text = Text());
void Paragraph(Text label = "", Text text = Text());

// ================= HTML =================
// HTML
void HTML(size_t id, Text label = "", Text html = Text());
void HTML(Text label = "", Text html = Text());

// ================= TABLE =================
// таблица. CSV текст, или путь к CSV файлу .csv, или путь к бинарной таблице .tbl. Подписи - список с разделением ';'
void Table(size_t id, Text table, Text labels = Text());
void Table(Text table, Text labels = Text());

// таблица из бинарной таблицы в RAM. Подписи - список с разделением ';'
void Table(size_t id, ::Table& table, Text labels = Text());
void Table(::Table& table, Text labels = Text());

// ================= GAUGE =================
void LinearGauge(size_t id, Text label = "", float min = 0, float max = 100, Text unit = Text(), float value = NAN, uint32_t color = SETS_DEFAULT_COLOR);
void LinearGauge(size_t id, Text label, float min, float max, Text unit, float value, Colors color);
void LinearGauge(Text label = "", float min = 0, float max = 100, Text unit = Text(), float value = NAN, uint32_t color = SETS_DEFAULT_COLOR);
void LinearGauge(Text label, float min, float max, Text unit, float value, Colors color);

// ================= PLOT =================
// бегущий график. Принимает обновления вида float[]. Подписи разделяются ;
void PlotRunning(size_t id, Text labels = Text(), uint16_t period = 200);
void PlotRunning(Text labels = Text(), uint16_t period = 200);

// собирающийся график. Принимает обновления вида float[]. Подписи разделяются ;
void PlotStack(size_t id, Text labels = Text());
void PlotStack(Text labels = Text());

// график с временем точек. Требует таблицу формата [unix, y1, y2...]. Путь к таблице в FS (.tbl, .csv). Подписи разделяются ;
void Plot(size_t id, Text path = Text(), Text labels = Text());
void Plot(Text path = Text(), Text labels = Text());

// график с временем точек. Требует таблицу формата [unix, y1, y2...]. Подписи разделяются ;
void Plot(size_t id, Table& table, Text labels = Text(), bool clearTable = true);
void Plot(Table& table, Text labels = Text(), bool clearTable = true);

// таймлайн. Требует таблицу формата [unix, mask] - Mask, [unix, y1, y2...] - All, [unix, n, y] Single. Путь к таблице в FS (.tbl, .csv). Подписи разделяются ;
void PlotTimeline(size_t id, Text path, TMode mode, Text labels);
void PlotTimeline(Text path, TMode mode, Text labels);

// таймлайн. Требует таблицу формата [unix, mask] - Mask, [unix, y1, y2...] - All, [unix, n, y] Single. Подписи разделяются ;
void PlotTimeline(size_t id, Table& table, TMode mode, Text labels, bool clearTable = true);
void PlotTimeline(Table& table, TMode mode, Text labels, bool clearTable = true);

TMode = sets::TMode::Single | sets::TMode::All | sets::TMode::Mask
```

#### Активные виджеты
```cpp
// ================= INPUT =================
// ввод текста и цифр [результат - строка], подключаемая переменная - любой тип, format - описание regex
bool Input(size_t id, Text label = "", AnyPtr value = nullptr, Text regex = Text(), Text format = Text());
bool Input(Text label = "", AnyPtr value = nullptr, Text regex = Text(), Text format = Text());

// ================= NUMBER =================
// ввод цифр [результат - строка], подключаемая переменная - любой тип, можно указать минимум и максимум
bool Number(size_t id, Text label = "", AnyPtr value = nullptr, float min = NAN, float max = NAN);
bool Number(Text label = "", AnyPtr value = nullptr, float min = NAN, float max = NAN);

// ================= PASS =================
// ввод пароля [результат - строка], подключаемая переменная - любой тип
bool Pass(size_t id, Text label = "", AnyPtr value = nullptr);
bool Pass(Text label = "", AnyPtr value = nullptr);

// ================= COLOR =================
// ввод цвета [результат - 24-бит DEC число], подключаемая переменная - uint32_t
bool Color(size_t id, Text label = "", uint32_t* value = nullptr);
bool Color(Text label = "", uint32_t* value = nullptr);

// ================= SWITCH =================
// переключатель [результат 1/0], подключаемая переменная - bool
bool Switch(size_t id, Text label = "", bool* value = nullptr, uint32_t color = SETS_DEFAULT_COLOR);
bool Switch(size_t id, Text label, bool* value, Colors color);
bool Switch(Text label = "", bool* value = nullptr, uint32_t color = SETS_DEFAULT_COLOR);
bool Switch(Text label, bool* value, Colors color);

// ================= DATE =================
// дата [результат - unix секунды], подключаемая переменная - uint32_t
bool Date(size_t id, Text label = "", uint32_t* value = nullptr, float zone_hours = NAN);
bool Date(Text label = "", uint32_t* value = nullptr, float zone_hours = NAN);

// ================= TIME =================
// время [результат - секунды с начала суток], подключаемая переменная - uint32_t
bool Time(size_t id, Text label = "", uint32_t* value = nullptr);
bool Time(Text label = "", uint32_t* value = nullptr);

// ================= DATETIME =================
// дата и время [результат - unix секунды], подключаемая переменная - uint32_t
bool DateTime(size_t id, Text label = "", uint32_t* value = nullptr, float zone_hours = NAN);
bool DateTime(Text label = "", uint32_t* value = nullptr, float zone_hours = NAN);

// ================= SPINNER =================
// сипннер [результат - число], подключаемая переменная - любой тип
bool Spinner(size_t id, Text label = "", float min = 0, float max = 100, float step = 1, AnyPtr value = nullptr);
bool Spinner(Text label = "", float min = 0, float max = 100, float step = 1, AnyPtr value = nullptr);

// ================= SLIDER =================
// слайдер [результат - число], подключаемая переменная - любой тип
bool Slider(size_t id, Text label = "", float min = 0, float max = 100, float step = 1, Text unit = Text(), AnyPtr value = nullptr, uint32_t color = SETS_DEFAULT_COLOR);
bool Slider(size_t id, Text label, float min, float max, float step, Text unit, AnyPtr value, Colors color);
bool Slider(Text label = "", float min = 0, float max = 100, float step = 1, Text unit = Text(), AnyPtr value = nullptr, uint32_t color = SETS_DEFAULT_COLOR);
bool Slider(Text label, float min, float max, float step, Text unit, AnyPtr value, Colors color);

// двойной слайдер [результат - число], подключаемая переменная - любой тип
bool Slider2(size_t id_min, size_t id_max, Text label = "", float min = 0, float max = 100, float step = 1, Text unit = Text(), AnyPtr value_min = nullptr, AnyPtr value_max = nullptr, uint32_t color = SETS_DEFAULT_COLOR);
bool Slider2(size_t id_min, size_t id_max, Text label, float min, float max, float step, Text unit, AnyPtr value_min, AnyPtr value_max, Colors color);
bool Slider2(Text label = "", float min = 0, float max = 100, float step = 1, Text unit = Text(), AnyPtr value_min = nullptr, AnyPtr value_max = nullptr, uint32_t color = SETS_DEFAULT_COLOR);
bool Slider2(Text label, float min, float max, float step, Text unit, AnyPtr value_min, AnyPtr value_max, Colors color);

// ================= SELECT =================
// опции разделяются ; или \n [результат - индекс (число)]
bool Select(size_t id, Text label, Text options, AnyPtr value = nullptr);
bool Select(Text label, Text options, AnyPtr value = nullptr);

// опции разделяются ; или \n [результат - строка]
bool SelectText(Text label, Text options);

// ================= TABS =================
// опции разделяются ; или \n [результат - индекс (число)]
bool Tabs(size_t id, Text tabs, AnyPtr value = nullptr);
bool Tabs(Text tabs, AnyPtr value = nullptr);

// ================= BUTTON =================
// кнопку можно добавлять как внутри контейнера кнопок, так и как одиночный виджет
bool Button(size_t id, Text label = "", uint32_t color = SETS_DEFAULT_COLOR);
bool Button(Text label = "", uint32_t color = SETS_DEFAULT_COLOR);

bool Button(size_t id, Text label, sets::Colors color);
bool Button(Text label, sets::Colors color);

// кнопка сигналит при нажатии и отпускании, используй b.build.pressed()
bool ButtonHold(size_t id, Text label = "", uint32_t color = SETS_DEFAULT_COLOR);
bool ButtonHold(Text label = "", uint32_t color = SETS_DEFAULT_COLOR);

bool ButtonHold(size_t id, Text label, Colors color);
bool ButtonHold(Text label, Colors color);

// ================= JOYSTICK =================
// флаг center - возвращать в центр при отпускании
bool Joystick(Pos& pos, bool center = false);

// misc
// окно подтверждения, для активации отправь пустой update на его id или update с текстом подтверждения
bool Confirm(size_t id, Text label = "", bool* ptr = nullptr);

// кастомный виджет, type соответствует имени класса. params - ключи и значения
bool Custom(Text type, size_t id, const BSON& params = BSON(), AnyPtr value = nullptr);
```

### Build
Инфо о билде
```cpp
// тип билда
const Type type;

// клиент авторизован
const bool granted;

// id виджета (действие)
const size_t id;

// значение виджета (действие)
const Text value;

// состояние ButtonHold
bool pressed();

// тип - сборка виджетов
bool isBuild();

// тип - действие (обработка клика или значения)
bool isAction();
```

### Контейнеры
```cpp
// контейнер гостевого доступа
class GuestAccess(Builder& b);

// контейнер группы виджетов
class Group(Builder& b, Text title = Text());

// контейнер вложенного меню
class Menu(Builder& b, Text title);

// горизонтальный контейнер [DivType::Default | DivType::Line | DivType::Block]
class Row(Builder& b, Text title, DivType divtype = DivType::Default);

// контейнер кнопок
class Buttons(Builder& b);
```

### Updater
```cpp
// всплывающее уведомление красное
void alert(Text text);

// всплывающее уведомление зелёное
void notice(Text text);

// вызов виджета Confirm
void confirm(size_t id);

// пустой апдейт (например для вызова Confirm)
void update(size_t id);

// апдейт с float
void update(size_t id, float value, uint8_t dec = 2);

// апдейт с числом
void update(size_t id, <любой численный тип> value);

// апдейт с текстом
void update(size_t id, <любой текстовый тип> value);

// апдейт логгера
void update(size_t id, Logger& logger);

// апдейт для двойного слайдера
void update2(size_t id_min, <любой численный тип> value_min, <любой численный тип> value_max);
void update2(size_t id_min, float value_min, float value_max, uint8_t dec = 2);

// апдейт для кастом виджета, params - ключи и значения
void update(size_t id, BSON& params);

// апдейт с цветом
void updateColor(size_t id, uint32_t color);
void updateColor(size_t id, sets::Colors color);

// апдейт для Table
Updater& updateTable(size_t id, Table& table);

// апдейт для графиков из файла
Updater& updatePlot(size_t id, Text path);

// апдейт для running и stack графиков
void updatePlot(size_t id, float data[]);

// апдейт для plot графиков
void updatePlot(size_t id, Table& table, bool clearTable = true);

// апдейт для timeline графиков
void updatePlot(size_t id, Table& table, TMode mode, bool clearTable = true);

TMode = sets::TMode::Single | sets::TMode::All | sets::TMode::Mask
```

### Logger
```cpp
Logger(size_t size);

// наследует Print
void print(любые_данные);
void println(любые_данные);

static String error();
static String warn();
static String info();

// вывод в String
String toString();
```