#pragma once
#include <inttypes.h>
#include <stddef.h>

#include "../platform.h"
#include "../utils/flags.h"
#include "../utils/hash.h"
#include "../utils/list.h"
#include "../utils/macro.h"

#define TASK_ENABLED (1 << 0)
#define TASK_IS_LISTENER (1 << 1)
#define TASK_IS_TICKER (1 << 2)
#define TASK_IS_TIMER (1 << 3)
#define TASK_IS_THREAD (1 << 4)
#define TASK_HAS_EVENTS (1 << 5)
#define TASK_HAS_STATES (1 << 6)
#define TASK_SETUP (1 << 7)

#define TASK_ENABLED_TICKER (TASK_ENABLED | TASK_IS_TICKER)
#define TASK_ENABLED_TIMER (TASK_ENABLED | TASK_IS_TIMER)
#define TASK_ENABLED_THREAD (TASK_ENABLED | TASK_IS_THREAD)
#define TASK_SETUP_TICKER (TASK_ENABLED_TICKER | TASK_SETUP)
#define TASK_SETUP_TIMER (TASK_ENABLED_TIMER | TASK_SETUP)
#define TASK_SETUP_THREAD (TASK_ENABLED_THREAD | TASK_SETUP)

enum class tState : uint8_t {
    Setup,
    Loop,
    Exit,
    Event,
};

LP_MAKE_CALLBACK(TaskCallback, void);

class LoopTask : public looper::List<LoopTask>::Node {
   public:
    LoopTask(hash_t id, TaskCallback callback, uint8_t type, bool states, bool events);

    ~LoopTask() { removeLoop(); }

    // добавить в loop
    void addLoop();

    // убрать из loop
    void removeLoop();

    // спровоцировать вызов со статусом Setup
    void restart();

    // вызвать обработчик
    void exec();

    // подключить обработчик
    void attach(TaskCallback callback);

    // отключить обработчик
    void detach();

    // id задачи
    hash_t id();

    // включить задачу
    void enable();

    // выключить задачу
    void disable();

    // задача запущена
    bool isEnabled();

    // включить если выключена и наоборот
    void toggle();

    // включить обработку событий
    void enableEvents();

    // отключить обработку событий
    void disableEvents();

    // включена обработка событий
    bool hasEvents();

    // включить статусы Setup Exit
    void enableStates();

    // выключить статусы Setup Exit
    void disableStates();

    // включены статусы Setup Exit
    bool hasStates();

    // задача - таймер
    bool isTimer();

    // задача - тикер
    bool isTicker();

    // задача - обработчик событий
    bool isListener();

    // задача - поток
    bool isThread();

    // запущен и слушает события
    bool canListen();

    uint8_t _tickMask();
    void _settle();

   private:
#if LOOPER_USE_ID
    hash_t _id;
#endif
    TaskCallback _cb;
    looper::Flags sreg;
};