[![latest](https://img.shields.io/github/v/release/GyverLibs/Looper.svg?color=brightgreen)](https://github.com/GyverLibs/Looper/releases/latest/download/Looper.zip)
[![PIO](https://badges.registry.platformio.org/packages/gyverlibs/library/Looper.svg)](https://registry.platformio.org/libraries/gyverlibs/Looper)
[![Foo](https://img.shields.io/badge/Website-AlexGyver.ru-blue.svg?style=flat-square)](https://alexgyver.ru/)
[![Foo](https://img.shields.io/badge/%E2%82%BD%24%E2%82%AC%20%D0%9F%D0%BE%D0%B4%D0%B4%D0%B5%D1%80%D0%B6%D0%B0%D1%82%D1%8C-%D0%B0%D0%B2%D1%82%D0%BE%D1%80%D0%B0-orange.svg?style=flat-square)](https://alexgyver.ru/support_alex/)
[![Foo](https://img.shields.io/badge/README-ENGLISH-blueviolet.svg?style=flat-square)](https://github-com.translate.goog/GyverLibs/Looper?_x_tr_sl=ru&_x_tr_tl=en)  

[![Foo](https://img.shields.io/badge/ПОДПИСАТЬСЯ-НА%20ОБНОВЛЕНИЯ-brightgreen.svg?style=social&logo=telegram&color=blue)](https://t.me/GyverLibs)

![logo](images/logo.png)

# Looper
Лёгкий псевдо-многопоточный событийно-ориентированный фреймворк для Arduino
- Более удобная организация программы
- Разделение на виртуальные потоки
- Полноценные потоки с параллельным выполнением и асинхронным ожиданием
- Статическое и динамическое создание задач
- Вызов задач с заданным периодом
- Отправка событий и данных между задачами
- Общее выполнение в одном потоке без нужды в мьютексах
- Удобный ООП API для создания своих задач и интеграции с другими классами
- Легко отвязывается от Arduino ядра (заменить две функции)
- Без зависимостей от других библиотек
- Лёгкий вес: ядро занимает 1 кБ флешки и 30 Б оперативки (AVR)

### Совместимость
Совместима со всеми Arduino платформами (используются Arduino-функции)

## Документация
Находится в [папке docs](https://github.com/GyverLibs/Looper/tree/main/docs/0.main.md)

## Содержание
- [Версии](#versions)
- [Установка](#install)
- [Баги и обратная связь](#feedback)

<a id="usage"></a>

## Для чего нужен Looper
Классический Arduino проект, не основанный на операционных системах типа FreeRTOS, имеет архитектуру однопоточного суперцикла (*pool based*): есть основной цикл `loop`, который выполняется по кругу на всём протяжении работы программы и в этом цикле мы опрашиваем кнопки/датчики/связь/прочее. Такие опросные функции в терминологии данной библиотеки называются "тикеры". Для инициализации некоторых сущностей код помещается также в `setup` для выполнения один раз перед запуском основного цикла.

При разработке крупного многофайлового проекта приходится тащить тикеры различных блоков программы из разных файлов в основной loop, вместе с ними тянутся и функции инициализации для вызова в setup, а также создаются глобальные переменные для взаимодействия между файлами и блоками. Для задач, которые вызываются с неким периодом (например раз в секунду), пишутся программные таймеры и также помещаются в loop на постоянную проверку времени.
```cpp
void setup() {
    disp_init();
    sensor_init();
    wifi_init();
}

void loop() {
    sensors_tick();
    buttons_tick();
}
```

Данная библиотека решает все эти проблемы:
- Добавление тикеров в общий в loop из любого конца программы без подключения в основной исполняемый файл
- Создание дополнительных "виртуальных" setup и loop, инкапсулированных в отдельных файлах
- Динамическое создание и удаление задач в процессе работы программы
- Отправка и получение событий сквозь всю программу
- Встроенный таймер для периодического или отложенного вызова задач

> Это позволяет разделять программу на полностью независимые потоки, а также писать код в событийно-ориентированном стиле

Минусы:
- Каждая задача занимает в оперативной памяти 7 байт (вес можно уменьшить, отключив поддержку ID и событий)
- Проход по списку задач и вызов обработчиков занимает в районе 8us на одну задачу (AVR 16MHz), что равносильно двум вызовам digitalRead

<a id="versions"></a>

## Версии
- v1.0
- v1.1.0 - добавлены потоки с параллельным выполнением и асинхронным ожиданием

<a id="install"></a>
## Установка
- Библиотеку можно найти по названию **Looper** и установить через менеджер библиотек в:
    - Arduino IDE
    - Arduino IDE v2
    - PlatformIO
- [Скачать библиотеку](https://github.com/GyverLibs/Looper/archive/refs/heads/main.zip) .zip архивом для ручной установки:
    - Распаковать и положить в *C:\Program Files (x86)\Arduino\libraries* (Windows x64)
    - Распаковать и положить в *C:\Program Files\Arduino\libraries* (Windows x32)
    - Распаковать и положить в *Документы/Arduino/libraries/*
    - (Arduino IDE) автоматическая установка из .zip: *Скетч/Подключить библиотеку/Добавить .ZIP библиотеку…* и указать скачанный архив
- Читай более подробную инструкцию по установке библиотек [здесь](https://alexgyver.ru/arduino-first/#%D0%A3%D1%81%D1%82%D0%B0%D0%BD%D0%BE%D0%B2%D0%BA%D0%B0_%D0%B1%D0%B8%D0%B1%D0%BB%D0%B8%D0%BE%D1%82%D0%B5%D0%BA)
### Обновление
- Рекомендую всегда обновлять библиотеку: в новых версиях исправляются ошибки и баги, а также проводится оптимизация и добавляются новые фичи
- Через менеджер библиотек IDE: найти библиотеку как при установке и нажать "Обновить"
- Вручную: **удалить папку со старой версией**, а затем положить на её место новую. "Замену" делать нельзя: иногда в новых версиях удаляются файлы, которые останутся при замене и могут привести к ошибкам!

<a id="feedback"></a>

## Баги и обратная связь
При нахождении багов создавайте **Issue**, а лучше сразу пишите на почту [alex@alexgyver.ru](mailto:alex@alexgyver.ru)  
Библиотека открыта для доработки и ваших **Pull Request**'ов!

При сообщении о багах или некорректной работе библиотеки нужно обязательно указывать:
- Версия библиотеки
- Какой используется МК
- Версия SDK (для ESP)
- Версия Arduino IDE
- Корректно ли работают ли встроенные примеры, в которых используются функции и конструкции, приводящие к багу в вашем коде
- Какой код загружался, какая работа от него ожидалась и как он работает в реальности
- В идеале приложить минимальный код, в котором наблюдается баг. Не полотно из тысячи строк, а минимальный код