// Делаем свой счётчик времени сна
// допустим таймер 0 у нас используется для других целей, но нам
// нужно хотя бы приблизительно считать время и выполнять по нему действия

#include <GyverPower.h>

uint32_t myMillis = 0;  // наш миллис

void setup() {
  power.autoCalibrate(); // автоматическая калибровка
}

void loop() {
  static uint32_t tmr1, tmr2;

  // "таймер" на 2 секунды
  if (myMillis - tmr1 > 2000) {
    tmr1 += 2000;
    // действие 1
  }

  // "таймер" на 10 секунд
  if (myMillis - tmr2 > 10000) {
    tmr2 += 10000;
    // действие 2
  }

  // спим 1 секунду (1000 мс)
  // sleepDelay возвращает остаток сна в мс, если он есть
  byte left = power.sleepDelay(1000);

  // прибавляем и корректируем наш миллис
  myMillis += 1000 - left;
}
