#include <GyverPWM.h>

void setup() {
  pinMode(3, OUTPUT);
  pinMode(5, OUTPUT);
  pinMode(9, OUTPUT);
  pinMode(10, OUTPUT);
  
  // Данные функции убирают один ШИМ выход у 8-ми битных таймеров, оставляя нам ШИМ пины D3, D5, D9 и D10 на ATmega328

  // запустить ШИМ на D3, разрядность 4 бита (0-15), частота 1 МГц (см. таблицу №1 в GyverPWM.h), режим FAST_PWM
  PWM_resolution(3, 4, FAST_PWM);

  // запустить ШИМ на D5, разрядность 6 бит (0-63), частота 254 кГц (см. таблицу №1 в GyverPWM.h), режим FAST_PWM. Сломает millis()!
  PWM_resolution(5, 6, FAST_PWM);

  // запустить ШИМ на D9, разрядность 12 бит (0-4095), частота 3.9 кГц (см. таблицу №1 в GyverPWM.h), режим FAST_PWM
  PWM_resolution(9, 12, FAST_PWM);

  // запустить ШИМ на D10, разрядность 12 бит (0-4095), частота 3.9 кГц (см. таблицу №1 в GyverPWM.h), режим FAST_PWM
  PWM_resolution(10, 12, FAST_PWM);
  // пины 9 и 10 работают на одной разрядности, запустить на разных не получится!
}

void loop() {
  PWM_set(3, 3);      // установить заполнение ШИМ на D3, равное 3 из 15, частота 1 МГц (см. таблицу №1 в GyverPWM.h)
  PWM_set(5, 40);     // установить заполнение ШИМ на D5, равное 40 из 63, частота 254 кГц (см. таблицу №1 в GyverPWM.h)
  PWM_set(9, 2842);   // установить заполнение ШИМ на D9, равное 2842 из 4095, частота 3.9 кГц (см. таблицу №1 в GyverPWM.h)
  PWM_set(10, 1248);  // установить заполнение ШИМ на D10, равное 1248 из 4095, частота 3.9 кГц (см. таблицу №1 в GyverPWM.h)
}
