/*
	Пример плавного управления мотором при помощи драйвера полного моста и потенциометра
*/
#include "GyverMotor.h"
GMotor motor(DRIVER2WIRE, 2, 3, HIGH);

// варианты инициализации в зависимости от типа драйвера:
// GMotor motor(DRIVER2WIRE, dig_pin, PWM_pin, (LOW / HIGH) )
// GMotor motor(DRIVER3WIRE, dig_pin_A, dig_pin_B, PWM_pin, (LOW/HIGH) )
// GMotor motor(RELAY2WIRE, dig_pin_A, dig_pin_B, (LOW/HIGH) )
/*
  DRIVER2WIRE - двухпроводной драйвер (направление + ШИМ)
  DRIVER3WIRE - трёхпроводной драйвер (два пина направления + ШИМ)
  RELAY2WIRE - реле в качестве драйвера (два пина направления)

  dig_pin, dig_pin_A, dig_pin_B - любой цифровой пин МК
  PWM_pin - любой ШИМ пин МК
  LOW / HIGH - уровень драйвера. Если при увеличении скорости мотор наоборот тормозит - смени уровень
*/

void setup() {
  Serial.begin(9600);

  // установка скорости изменения скорости (ускорения) мотора
  motor.setSmoothSpeed(20);

  // ключ на старт!
  motor.setMode(FORWARD);
}

void loop() {
  // потенциометр на А0
  // преобразуем значение в -255.. 255
  int val = 255 - analogRead(0) / 2;

  // данную функцию рекомендуется вызывать чаще чем каждые 50 мс
  // (работает по встроенному таймеру)
  // она будет плавно менять скорость мотора к заданной
  motor.smoothTick(val);

  // отладка. Откройте Инструменты/Плоттер по последовательному порту
  Serial.print(val);            // первый график - установленная скорость
  Serial.print(',');
  Serial.println(motor._duty);  // второй график - реальный сигнал на мотор
  
  delay(10);  // задержка просто для "стабильности"
}
