[![latest](https://img.shields.io/github/v/release/GyverLibs/GyverMotor.svg?color=brightgreen)](https://github.com/GyverLibs/GyverMotor/releases/latest/download/GyverMotor.zip)
[![PIO](https://badges.registry.platformio.org/packages/gyverlibs/library/GyverMotor.svg)](https://registry.platformio.org/libraries/gyverlibs/GyverMotor)
[![Foo](https://img.shields.io/badge/Website-AlexGyver.ru-blue.svg?style=flat-square)](https://alexgyver.ru/)
[![Foo](https://img.shields.io/badge/%E2%82%BD%24%E2%82%AC%20%D0%9F%D0%BE%D0%B4%D0%B4%D0%B5%D1%80%D0%B6%D0%B0%D1%82%D1%8C-%D0%B0%D0%B2%D1%82%D0%BE%D1%80%D0%B0-orange.svg?style=flat-square)](https://alexgyver.ru/support_alex/)
[![Foo](https://img.shields.io/badge/README-ENGLISH-blueviolet.svg?style=flat-square)](https://github-com.translate.goog/GyverLibs/GyverMotor?_x_tr_sl=ru&_x_tr_tl=en)  

[![Foo](https://img.shields.io/badge/ПОДПИСАТЬСЯ-НА%20ОБНОВЛЕНИЯ-brightgreen.svg?style=social&logo=telegram&color=blue)](https://t.me/GyverLibs)

# GyverMotor
Библиотека для удобного управления коллекторными моторами через драйвер
- Контроль скорости и направления вращения
- Работа с ШИМ любого разрешения
- Плавный пуск и изменение скорости
- Активный тормоз
- Порог минимального ШИМ
- Deadtime
- Поддержка 5 типов драйверов

> Библиотека "состоит" из двух библиотек: GyverMotor и GyverMotor2. Вторая версия новее, легче, лучше оптимизирована и проще в использовании!

### Совместимость
Совместима со всеми Arduino платформами (используются Arduino-функции)
- Для esp8266 (до SDK v2.7.4) не забудь переключить управление в 10 бит!

### Документация
К библиотеке есть [расширенная документация](https://alexgyver.ru/GyverMotor/)

## Содержание
- [Установка](#install)
- [Инициализация](#init)
- [Использование](#usage)
- [Пример](#example)
- [Версии](#versions)
- [Баги и обратная связь](#feedback)

<a id="install"></a>
## Установка
- Библиотеку можно найти по названию **GyverMotor** и установить через менеджер библиотек в:
    - Arduino IDE
    - Arduino IDE v2
    - PlatformIO
- [Скачать библиотеку](https://github.com/GyverLibs/GyverMotor/archive/refs/heads/main.zip) .zip архивом для ручной установки:
    - Распаковать и положить в *C:\Program Files (x86)\Arduino\libraries* (Windows x64)
    - Распаковать и положить в *C:\Program Files\Arduino\libraries* (Windows x32)
    - Распаковать и положить в *Документы/Arduino/libraries/*
    - (Arduino IDE) автоматическая установка из .zip: *Скетч/Подключить библиотеку/Добавить .ZIP библиотеку…* и указать скачанный архив
- Читай более подробную инструкцию по установке библиотек [здесь](https://alexgyver.ru/arduino-first/#%D0%A3%D1%81%D1%82%D0%B0%D0%BD%D0%BE%D0%B2%D0%BA%D0%B0_%D0%B1%D0%B8%D0%B1%D0%BB%D0%B8%D0%BE%D1%82%D0%B5%D0%BA)
### Обновление
- Рекомендую всегда обновлять библиотеку: в новых версиях исправляются ошибки и баги, а также проводится оптимизация и добавляются новые фичи
- Через менеджер библиотек IDE: найти библиотеку как при установке и нажать "Обновить"
- Вручную: **удалить папку со старой версией**, а затем положить на её место новую. "Замену" делать нельзя: иногда в новых версиях удаляются файлы, которые останутся при замене и могут привести к ошибкам!


<a id="init"></a>

## Инициализация (GyverMotor2)
Типы драйверов:

| Драйвер                  | Описание                               | Пины            | Сигнал вперёд | Сигнал назад |
|--------------------------|----------------------------------------|-----------------|---------------|--------------|
| `DRIVER2WIRE`            | двухпроводной драйвер с инверсией шим  | GPIO, PWM       | 0, PWM        | 1, ~PWM      |
| `DRIVER2WIRE_NO_INVERT`  | двухпроводной драйвер без инверсии ШИМ | GPIO, PWM       | 0, PWM        | 1, PWM       |
| `DRIVER2WIRE_PWM`        | двухпроводной драйвер с двумя ШИМ      | PWM, PWM        | 0, PWM        | PWM, 0       |
| `DRIVER2WIRE_PWM_INVERT` | двухпроводной драйвер с двумя ШИМ      | PWM, PWM        | PWM, 1        | 1, PWM       |
| `DRIVER3WIRE`            | трёхпроводной драйвер                  | GPIO, GPIO, PWM | 0, 1, PWM     | 1, 0, PWM    |
| `RELAY2WIRE`             | реле в качестве драйвера               | GPIO, GPIO      | 0, 1          | 1, 0         |

Для двухпроводных мостовых драйверов стоит отдавать предпочтение типу **DRIVER2WIRE_PWM**. Он требует два ШИМ пина, 
но драйвер работает более правильно и меньше нагружается, а также скорость будет одинаковая в обе стороны, в отличие от простого **DRIVER2WIRE**.

> `DRIVER2WIRE_PWM` даёт мотору более высокую скорость, а `DRIVER2WIRE_PWM_INVERT` - более высокий момент

```cpp
GMotor2<тип> motor(пин1, пин2, пин3);               // разрядность ШИМ 8 бит (0.. 255)
GMotor2<тип, разрядность> motor(пин1, пин2, пин3);  // общий случай, разрядность ШИМ в битах
```

<a id="usage"></a>

## Использование (GyverMotor2)
```cpp
void setMinDuty(uint16_t mduty);        // установить минимальный ШИМ (умолч. 0)
void setMinDutyPerc(uint16_t mduty);    // установить минимальный ШИМ в % (умолч. 0)
void setDeadtime(uint16_t us);          // установить deadtime в микросекундах (умолч. 0)
void reverse(bool r);                   // реверс направления (умолч. false)

void stop();                            // остановка. Если включен плавный режим, то плавная
void brake();                           // активный тормоз
void setSpeed(int16_t s);               // установить скорость (-макс.. макс)
void setSpeedPerc(int16_t s);           // установить скорость в процентах (-100.. 100%)

int8_t getState();                      // получить статус: мотор крутится (1 и -1), мотор остановлен (0)
int16_t getSpeed();                     // получить текущую скорость мотора

void smoothMode(bool mode);             // установить режим плавного изменения скорости (умолч. false)
void tick();                            // плавное изменение к указанной скорости, вызывать в цикле
void setSmoothSpeed(uint8_t s);         // установить скорость изменения скорости (умолч. 20)
void setSmoothSpeedPerc(uint8_t s);     // установить скорость изменения скорости в процентах
```

### Разрядность ШИМ
В AVR Arduino по умолчанию используется 8-ми битный ШИМ (0.. 255). В esp8266 используется 10-ти битный (0.. 1023). 
При инициализации библиотеки можно настроить нужную разрядность, она может быть любой.

### Скорость
Скорость задаётся в `setSpeed(-макс ШИМ.. макс ШИМ)` в величине ШИМ сигнала, либо в `setSpeedPerc(-100.. 100)` в процентах. Скорость может быть отрицательной, 
тогда мотор будет крутиться в обратную сторону. При значении 0 мотор остановится и драйвер будет отключен.

### Режимы работы
Вызов `stop()` равносилен `setSpeed(0)`. При прямом управлении мотор будет сразу остановлен, при плавном - остановится плавно. Драйвер отключится, вал мотора будет освобождён.  
Вызов `brake()` остановит мотор и переключит драйвер в режим активного торможения (замкнёт мотор через себя). Вал мотора будет сопротивляться вращению.  
Вызов `reverse(true)` инвертирует направление вращения мотора для всех функций.

### Минимальный ШИМ
В `setMinDuty(-макс ШИМ.. макс ШИМ)` можно установить минимальную скорость, при которой мотор начинает вращение, это удобно в большинстве применений. 
Установленная в `setSpeed()` скорость будет автоматически масштабироваться с учётом минимальной. 
Также можно задать минимальную скорость в процентах `setMinDutyPerc(-100.. 100)`.

### Плавный режим
В плавном режиме установленная в `setSpeed()` скорость применяется не сразу, а плавно в течением времени. Для включения 
плавного режима нужно вызвать `smoothMode(true)` и поместить в основном цикле программы функцию-тикер `tick()`. 
Внутри этой функции скорсть будет плавно меняться по встроенному таймеру (период - 50мс). 
Можно настроить скорость изменения скорости - `setSmoothSpeed()` в величинах ШИМ и `setSmoothSpeedPerc()` в процентах.

<a id="example"></a>

## Пример
Остальные примеры смотри в **examples**!
```cpp
#include <GyverMotor2.h>
GMotor2<DRIVER2WIRE> motor(5, 6);
//GMotor2<DRIVER2WIRE_NO_INVERT> motor(5, 6);
//GMotor2<DRIVER2WIRE_PWM> motor(5, 6);
//GMotor2<DRIVER3WIRE> motor(5, 6, 11);
//GMotor2<RELAY2WIRE> motor(5, 6);

void setup() {
  motor.setMinDuty(70);   // мин. ШИМ
  //motor.reverse(1);     // реверс
  //motor.setDeadtime(5); // deadtime
}

void loop() {
  motor.setSpeed(10);
  delay(1000);
  motor.setSpeed(-100);
  delay(1000);
  motor.setSpeed(50);
  delay(1000);
  motor.setSpeed(255);
  delay(1000);
  motor.brake();
  delay(3000);
}
```

<a id="versions"></a>

## Версии
- v1.1 - убраны дефайны
- v1.2 - возвращены дефайны
- v2.0:
    - Программный deadtime
    - Отрицательные скорости
    - Поддержка двух типов драйверов и реле
    - Плавный пуск и изменение скорости
- v2.1: небольшие фиксы и добавления
- v2.2: оптимизация
- v2.3: добавлена поддержка esp (исправлены ошибки)
- v2.4: совместимость с другими библами
- v2.5: добавлен тип DRIVER2WIRE_NO_INVERT
- v3.0: переделана логика minDuty, добавлен режим для ШИМ любой битности
- v3.1: мелкие исправления
- v3.2: улучшена стабильность плавного режима
- v3.2.1: вернул run() в public
- v4.0: исправлен баг в GyverMotor. Добавлен GyverMotor2

<a id="feedback"></a>

## Баги и обратная связь
При нахождении багов создавайте **Issue**, а лучше сразу пишите на почту [alex@alexgyver.ru](mailto:alex@alexgyver.ru)  
Библиотека открыта для доработки и ваших **Pull Request**'ов!

При сообщении о багах или некорректной работе библиотеки нужно обязательно указывать:
- Версия библиотеки
- Какой используется МК
- Версия SDK (для ESP)
- Версия Arduino IDE
- Корректно ли работают ли встроенные примеры, в которых используются функции и конструкции, приводящие к багу в вашем коде
- Какой код загружался, какая работа от него ожидалась и как он работает в реальности
- В идеале приложить минимальный код, в котором наблюдается баг. Не полотно из тысячи строк, а минимальный код