[![latest](https://img.shields.io/github/v/release/GyverLibs/GyverJoy.svg?color=brightgreen)](https://github.com/GyverLibs/GyverJoy/releases/latest/download/GyverJoy.zip)
[![PIO](https://badges.registry.platformio.org/packages/gyverlibs/library/GyverJoy.svg)](https://registry.platformio.org/libraries/gyverlibs/GyverJoy)
[![Foo](https://img.shields.io/badge/Website-AlexGyver.ru-blue.svg?style=flat-square)](https://alexgyver.ru/)
[![Foo](https://img.shields.io/badge/%E2%82%BD%24%E2%82%AC%20%D0%9F%D0%BE%D0%B4%D0%B4%D0%B5%D1%80%D0%B6%D0%B0%D1%82%D1%8C-%D0%B0%D0%B2%D1%82%D0%BE%D1%80%D0%B0-orange.svg?style=flat-square)](https://alexgyver.ru/support_alex/)
[![Foo](https://img.shields.io/badge/README-ENGLISH-blueviolet.svg?style=flat-square)](https://github-com.translate.goog/GyverLibs/GyverJoy?_x_tr_sl=ru&_x_tr_tl=en)  

[![Foo](https://img.shields.io/badge/ПОДПИСАТЬСЯ-НА%20ОБНОВЛЕНИЯ-brightgreen.svg?style=social&logo=telegram&color=blue)](https://t.me/GyverLibs)

# GyverJoy
Библиотека для удобной работы с аналоговым джойстиком
- Работает с 10 бит АЦП (0.. 1023)
- Виртуальный режим с внешним значением 10 бит
- Инверсия
- Калибровка нуля
- Мёртвая зона с линеаризацией значения
- "Экспонента" для более плавного контроля
- Оптимизированные вычисления
- Вход: 0.. 1023
- Выход: -255.. 255

### Совместимость
Совместима со всеми Arduino платформами (используются Arduino-функции)

## Содержание
- [Установка](#install)
- [Использование](#usage)
- [Пример](#example)
- [Версии](#versions)
- [Баги и обратная связь](#feedback)

<a id="usage"></a>

## Использование
### GyverJoyVirt
```cpp
GyverJoyVirt joy;   // виртуальный режим
```
```cpp
// инвертировать (умолч. false)
void invert(bool ninv);

// установить период опроса (по умолч. 10 мс)
void setPeriod(uint8_t nprd);

// калибровать "ноль" внешним значением
void calibrate(uint16_t val);

// установить мёртвую зону
void deadzone(uint8_t ndead);

// настроить экспоненту GJ_LINEAR (умолч.), GJ_SQUARE и GJ_CUBIC или цифрами 0, 1 и 2
void exponent(uint8_t nmode);

// тикер, вызывать в цикле. Опрос по своему таймеру
bool tick();

// ручной опрос внешним значением
int16_t compute(uint16_t adc);

// получить значение -255.. 255
int16_t value();
```

### GyverJoy
```cpp
GyverJoy joy(pin);  // с указанием пина АЦП
```
```cpp
// инвертировать (умолч. false)
void invert(bool ninv);

// установить период опроса (по умолч. 10 мс)
void setPeriod(uint8_t nprd);

// калибровать "ноль" внешним значением
void calibrate(uint16_t val);

// установить мёртвую зону
void deadzone(uint8_t ndead);

// настроить экспоненту GJ_LINEAR (умолч.), GJ_SQUARE и GJ_CUBIC или цифрами 0, 1 и 2
void exponent(uint8_t nmode);

// указать пин
void setPin(uint8_t npin);

// калибровать "ноль" с пина
void calibrate();

// прочитать с пина и сделать расчёт
int16_t compute();

// тикер, вызывать в цикле. Опрос пина по своему таймеру
bool tick();

// получить значение -255.. 255
int16_t value();
```

![demo](/docs/demo.png)

### Обычный режим
Укажи пин при инициализации и вызывай `tick()` в `loop()`. По встроенному таймеру джойстик будет 
опрашиваться, значение можно забрать из `value()`. Также `tick()` вернёт `true`, если произошло вычисление.

### Виртуальный режим
При инициализации указывать пин не нужно. Для вычисления передай внешнее значение (0.. 1023) в `compute()`. Функция вернёт результат соответственно настройкам.

### Настройки
- `invert` инвертирует направление джойстика
- `calibrate` читает *текущее* значение сигнала и считает его за "ноль" джойстика
- `deadzone` устанавливает мёртвую зону, но значения пересчитываются и линейность сохраняется
- `exponent` задаёт "экспоненциальное" преобразование значения для более плавного управления

`deadzone` и `exponent` можно использовать совместно! Экспонента будет считаться от краёв мёртвой зоны.

<a id="example"></a>

## Пример
### Бортовой АЦП
```cpp
#include <GyverJoy.h>
GyverJoy jx(0);  // джойстик на пине 0

void setup() {
    Serial.begin(9600);
    // jx.invert(true);  // инвертировать
    jx.calibrate();         // калибровка нуля при запуске
    jx.deadzone(30);        // мёртвая зона
    jx.exponent(GJ_CUBIC);  // экспонента для плавности
}

void loop() {
    // тикер опрашивает АЦП по своему таймеру
    if (jx.tick()) {
        // выводим значение
        Serial.println(jx.value());
    }
}
```

### Виртуальный режим
```cpp
#include <GyverJoy.h>
GyverJoyVirt jx;  // виртуальный джойстик

void setup() {
    Serial.begin(9600);
    // jx.invert(true);  // инвертировать
    //  калибровка внешним значением
    jx.calibrate(analogRead(0));
    jx.deadzone(30);        // мёртвая зона
    jx.exponent(GJ_CUBIC);  // экспонента для плавности
}

void loop() {
    // передаём аналоговый сигнал с любого источника
    int value = jx.compute(analogRead(0));
    Serial.println(value);
    delay(10);
}

```

<a id="versions"></a>
## Версии
- v1.0
- v1.1 - исправлена калибровка при reverse, исправлена кубическая гамма при нулевом сигнале


<a id="install"></a>

## Установка
- Библиотеку можно найти по названию **GyverJoy** и установить через менеджер библиотек в:
    - Arduino IDE
    - Arduino IDE v2
    - PlatformIO
- [Скачать библиотеку](https://github.com/GyverLibs/GyverJoy/archive/refs/heads/main.zip) .zip архивом для ручной установки:
    - Распаковать и положить в *C:\Program Files (x86)\Arduino\libraries* (Windows x64)
    - Распаковать и положить в *C:\Program Files\Arduino\libraries* (Windows x32)
    - Распаковать и положить в *Документы/Arduino/libraries/*
    - (Arduino IDE) автоматическая установка из .zip: *Скетч/Подключить библиотеку/Добавить .ZIP библиотеку…* и указать скачанный архив
- Читай более подробную инструкцию по установке библиотек [здесь](https://alexgyver.ru/arduino-first/#%D0%A3%D1%81%D1%82%D0%B0%D0%BD%D0%BE%D0%B2%D0%BA%D0%B0_%D0%B1%D0%B8%D0%B1%D0%BB%D0%B8%D0%BE%D1%82%D0%B5%D0%BA)
### Обновление
- Рекомендую всегда обновлять библиотеку: в новых версиях исправляются ошибки и баги, а также проводится оптимизация и добавляются новые фичи
- Через менеджер библиотек IDE: найти библиотеку как при установке и нажать "Обновить"
- Вручную: **удалить папку со старой версией**, а затем положить на её место новую. "Замену" делать нельзя: иногда в новых версиях удаляются файлы, которые останутся при замене и могут привести к ошибкам!

<a id="feedback"></a>

## Баги и обратная связь
При нахождении багов создавайте **Issue**, а лучше сразу пишите на почту [alex@alexgyver.ru](mailto:alex@alexgyver.ru)  
Библиотека открыта для доработки и ваших **Pull Request**'ов!

При сообщении о багах или некорректной работе библиотеки нужно обязательно указывать:
- Версия библиотеки
- Какой используется МК
- Версия SDK (для ESP)
- Версия Arduino IDE
- Корректно ли работают ли встроенные примеры, в которых используются функции и конструкции, приводящие к багу в вашем коде
- Какой код загружался, какая работа от него ожидалась и как он работает в реальности
- В идеале приложить минимальный код, в котором наблюдается баг. Не полотно из тысячи строк, а минимальный код
