#include <GyverINA.h>

// Создаем обьект: INA219 ina(Сопротивление шунта, Макс. ожидаемый ток, I2c адрес);
// INA219 ina(0x41);              // Стандартные настройки для модуля, но измененный адрес
// INA219 ina(0.05f);             // Стандартный адрес и макс. ток, но другой шунт (0.05 Ом)
// INA219 ina(0.05f, 2.0f);       // Стандартный адрес, но другой шунт (0.05 Ом) и макс. ожидаемый ток (2А)
// INA219 ina(0.05f, 2.0f, 0x41); // Полностью настраиваемый вариант, ручное указание параметров
INA219 ina;                       // Стандартный набор параметров для Arduino модуля (0.1, 3.2, 0x40)

void setup() {
  // Открываем последовательный порт
  Serial.begin(9600);
  Serial.print(F("INA219..."));

  // Проверяем наличие и инициализируем INA219
  if (ina.begin()) {	// ina.begin(4, 5) // Для ESP32/ESP8266 можно указать пины I2C
    Serial.println(F("connected!"));
  } else {
    Serial.println(F("not found!"));
    while (1);
  }

  // Можно веревести в режим сна, вызвав .sleep с аргументом true, чтобы разбудить - вызываем повторно с указанием false
  // ina.sleep(true);   // Усыпить INA219
  // ina.sleep(false);  // Разбудить INA219

  // INA219 имеет возможность встроенной калибровки измерения тока, при помощи специального калибровочного значения
  // После запуска библиотека автоматически рассчитает и запишет калибровочное значение на основе введенных данных
  // Полученное значение можно прочитать, используя метод .getCalibration(); для изменения и/или сохранения в EEPROM
  Serial.print(F("Calibration value: ")); Serial.println(ina.getCalibration());
  // Далее полученное значение можно изменять для подстройки под реальное сопротивление шунта и сохранять в EEPROM
  // Чтобы записать калибровочное значение в INA219 существует метод .setCalibration(value);
  // ina.setCalibration(ina.getCalibration() + 10); // Прочитать-модифицировать-записать калибровочное значение
  // Так же, можно использовать метод .adjCalibration(offset); для подстройки калибровки без непосредственного чтения
  // ina.adjCalibration(10);  // Увеличить калибровочное значение на 10
  // ina.adjCalibration(-20); // Уменьшить калибровочное значение на 20
  // Можно хранить в EEPROM и загружать в INA219 именно смещение калибровки вместо непосредственного значения

  // Так же имеется возможность выбрать разрешение АЦП (9-12 Бит) и включить встроенное усреднение измерений
  // Выбор настроек для измерения напряжения и тока разделены и определяются константами INA219_VBUS или INA219_VSHUNT
  // Усреднение увеличивает время измерений, снижая шумы измерений, доступно только для 12ти битного режима
  // ina.setResolution(INA219_VBUS, INA219_RES_10BIT); // Измеряем напряжение в 10ти битном режиме, 12 бит по умолчанию
  // Использование пониженного разрешения ускоряет измерения (см. таблицу в INA219.h), но НЕ рекомендуется
  // Использование встроенного усреднения крайне рекомендуется для повышения стабильности показаний на шумной нагрузке
  ina.setResolution(INA219_VBUS, INA219_RES_12BIT_X4);      // Напряжение в 12ти битном режиме + 4х кратное усреднение
  ina.setResolution(INA219_VSHUNT, INA219_RES_12BIT_X128);  // Ток в 12ти битном режиме + 128х кратное усреднение
  
  Serial.println("");
}

void loop() {
  // Читаем напряжение
  Serial.print(F("Voltage: "));
  Serial.print(ina.getVoltage(), 3);
  Serial.println(F(" V"));

  // Читаем ток
  Serial.print(F("Current: "));
  Serial.print(ina.getCurrent(), 3);
  Serial.println(F(" A"));

  // Читаем мощность
  Serial.print(F("Power: "));
  Serial.print(ina.getPower(), 3);
  Serial.println(F(" W"));

  // Читаем напряжение на шунте
  Serial.print(F("Shunt voltage: "));
  Serial.print(ina.getShuntVoltage(), 6);
  Serial.println(F(" V"));

  Serial.println("");
  delay(1000);
}
