/**
 * Font: Roboto Medium Regular 17
 * Copyright: Copyright 2011 Google Inc. All Rights Reserved.
 * Charcodes: 0x20-0x7e
 */

#include <stdint.h>

#define FONT_ROBOTOM12_4_ASCENT 17
#define FONT_ROBOTOM12_4_DESCENT 5
#define FONT_ROBOTOM12_4_CAP_HEIGHT 12
#define FONT_ROBOTOM12_4_LINE_HEIGHT 22
#define FONT_ROBOTOM12_4_BOUNDINGBOX_LEFT -1
#define FONT_ROBOTOM12_4_BOUNDINGBOX_BOTTOM -4
#define FONT_ROBOTOM12_4_BOUNDINGBOX_WIDTH 16
#define FONT_ROBOTOM12_4_BOUNDINGBOX_HEIGHT 18

const uint8_t font_robotoM12_4[3723] =
{
0x00, 0x0c, 0x00, 0x11, 0x00, 0x05, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x10, 0x00, 0x12, 0x02, 0x05,
0x04, 0x05, 0x04, 0x04, 0x01, 0x00, 0x89, 0x48, 0x20, 0x03, 0x00, 0x00, 0x04, 0x15, 0x81, 0x61,
0xb5, 0xaf, 0xf6, 0xd5, 0x3e, 0xd2, 0x47, 0xfa, 0x48, 0xdf, 0xe4, 0x9b, 0x7c, 0x02, 0x16, 0x90,
0xbe, 0xca, 0x47, 0x0e, 0xa4, 0x22, 0x26, 0x8f, 0x94, 0xe5, 0x8d, 0xae, 0x3c, 0x51, 0x95, 0x07,
0x29, 0x02, 0x36, 0x80, 0x65, 0x0a, 0xc6, 0x09, 0x61, 0x83, 0x7b, 0x06, 0xad, 0xc2, 0xcd, 0x13,
0xc8, 0x0d, 0x96, 0xff, 0x17, 0x90, 0xd4, 0x76, 0xe1, 0xab, 0x02, 0x63, 0x85, 0xb0, 0xc1, 0xbd,
0x83, 0x76, 0x61, 0xf3, 0x7f, 0x07, 0x45, 0xe1, 0xab, 0x7a, 0x58, 0x02, 0x3b, 0x87, 0xe6, 0x09,
0x9c, 0x2e, 0x64, 0x0f, 0x5c, 0x27, 0x94, 0x0c, 0x06, 0x3b, 0xf8, 0x84, 0x0a, 0x76, 0x09, 0x2f,
0x17, 0x6e, 0xf8, 0xe3, 0x01, 0xcd, 0xb7, 0xfb, 0x09, 0x94, 0x0f, 0x41, 0xf9, 0x10, 0xd2, 0x57,
0xa0, 0x61, 0x84, 0xec, 0xf5, 0x80, 0xdb, 0x8f, 0x0b, 0xae, 0xf8, 0x5b, 0x70, 0xd3, 0x0f, 0x63,
0x15, 0x46, 0x8f, 0xa1, 0x6f, 0x40, 0xf6, 0x16, 0xba, 0x4f, 0xf7, 0x23, 0x90, 0xf5, 0xc7, 0x04,
0xc7, 0x09, 0xef, 0x0a, 0x06, 0x41, 0x00, 0x66, 0x0c, 0x0d, 0xbf, 0x0d, 0x78, 0xbe, 0xd4, 0x0a,
0x4a, 0x03, 0xc9, 0x23, 0xe8, 0x1c, 0xa2, 0x27, 0x20, 0x79, 0x04, 0x9d, 0x43, 0x8d, 0x60, 0xbe,
0xd4, 0x8a, 0x0d, 0x37, 0xfc, 0x96, 0x1e, 0xc1, 0xc7, 0x5a, 0xfd, 0x12, 0xce, 0x7c, 0x5e, 0xd6,
0x3b, 0x58, 0x3c, 0xab, 0x17, 0x90, 0x2e, 0x4c, 0x17, 0xaa, 0x17, 0x90, 0x2e, 0x8c, 0x05, 0x92,
0x97, 0xe4, 0x07, 0xaf, 0xfa, 0x29, 0x04, 0x3d, 0x80, 0x65, 0x0b, 0x92, 0x7d, 0x9e, 0xe0, 0xfa,
0x2d, 0xbf, 0x04, 0x9b, 0xb7, 0x20, 0x6f, 0xb0, 0x79, 0x0c, 0xc9, 0x5b, 0x38, 0x7e, 0xfa, 0x5c,
0xe0, 0xe8, 0xe3, 0x80, 0x1b, 0xff, 0x5c, 0x20, 0x5c, 0x90, 0xbf, 0xb1, 0xd7, 0xe1, 0x0e, 0xcd,
0x63, 0xd0, 0xbd, 0x7e, 0x0a, 0xc9, 0xf3, 0x00, 0xed, 0x37, 0xa0, 0x7d, 0xae, 0xfb, 0x3b, 0xd8,
0xf5, 0xf3, 0x2d, 0x7f, 0x05, 0x0a, 0xa4, 0x21, 0x53, 0x6f, 0xea, 0x49, 0xbd, 0xa8, 0x07, 0x01,
0x2a, 0xf1, 0x92, 0x06, 0xbb, 0x02, 0xe1, 0x2b, 0x68, 0x1e, 0x82, 0xd8, 0x41, 0xf2, 0x10, 0x74,
0x8f, 0x40, 0xfb, 0x02, 0xd4, 0x0f, 0x08, 0xcc, 0x1d, 0xd6, 0x0f, 0xb6, 0x2f, 0x40, 0xf8, 0x08,
0x24, 0x0f, 0x61, 0xec, 0xb0, 0x79, 0x07, 0xc3, 0x47, 0x30, 0x2c, 0x2c, 0xf0, 0x92, 0x66, 0x07,
0xab, 0x77, 0xb0, 0x7c, 0x02, 0x8a, 0xb7, 0x30, 0x7d, 0x02, 0xb2, 0x77, 0x20, 0x79, 0x0a, 0x8a,
0xd7, 0x40, 0x60, 0xcf, 0x41, 0xf1, 0x1a, 0x24, 0x4f, 0x41, 0xf6, 0x0e, 0xa4, 0x4f, 0x40, 0x6f,
0x41, 0xf8, 0x04, 0xaa, 0x67, 0x20, 0x3b, 0x18, 0x1d, 0x10, 0x44, 0x08, 0x73, 0x04, 0xe7, 0x07,
0x2b, 0x8c, 0x3e, 0x52, 0x28, 0xff, 0x1b, 0x28, 0xf4, 0x23, 0x58, 0xb8, 0x3e, 0x84, 0x6d, 0x43,
0xf7, 0x04, 0x14, 0x03, 0x2a, 0x10, 0x18, 0x84, 0x54, 0x09, 0x8b, 0x1a, 0x60, 0x81, 0xa3, 0xb7,
0xb0, 0xfb, 0x5f, 0x57, 0xb7, 0x7f, 0xdd, 0x0b, 0x03, 0x16, 0xbd, 0x05, 0x17, 0x47, 0x30, 0x0b,
0xf4, 0x29, 0x04, 0x79, 0x43, 0xde, 0xf1, 0xf6, 0x1e, 0xcd, 0x41, 0x07, 0x90, 0x12, 0x66, 0x7f,
0xa4, 0xaa, 0x09, 0x08, 0x81, 0x19, 0x05, 0x09, 0xc4, 0xaf, 0xf2, 0x0d, 0x23, 0xfc, 0x6b, 0x07,
0x66, 0x4f, 0xc0, 0x98, 0xc1, 0xe4, 0x1d, 0x18, 0xbe, 0x00, 0xeb, 0x05, 0x9b, 0x57, 0x60, 0xf9,
0xe0, 0x5e, 0x82, 0xd5, 0x23, 0xb0, 0x75, 0xb0, 0x78, 0x08, 0x76, 0x4f, 0xc0, 0x98, 0xe1, 0x00,
0x34, 0x80, 0x64, 0x0a, 0x2a, 0x7e, 0xae, 0x02, 0xa2, 0x6f, 0xf9, 0x39, 0x88, 0x5f, 0x81, 0xf6,
0x19, 0xf4, 0xc1, 0xea, 0x69, 0x3c, 0x87, 0x11, 0xf0, 0x79, 0x2c, 0xcf, 0x61, 0xf3, 0x38, 0x9e,
0xc3, 0xe8, 0x2d, 0xf4, 0xc1, 0xea, 0x29, 0xc4, 0xaf, 0x40, 0xfb, 0x0c, 0xa2, 0x6f, 0xf9, 0x35,
0x8c, 0xf8, 0x53, 0x81, 0x00, 0x13, 0x01, 0x63, 0x0a, 0xab, 0xad, 0x38, 0xff, 0x2a, 0x9f, 0xfb,
0xab, 0x22, 0x08, 0xd8, 0x4f, 0x5f, 0xc1, 0xf4, 0x15, 0x2e, 0x00, 0x65, 0x0a, 0x32, 0x7e, 0xae,
0x02, 0xc3, 0xe7, 0xda, 0x5f, 0x40, 0xf1, 0x09, 0x68, 0xdf, 0x41, 0xd3, 0x0a, 0xbb, 0x87, 0xf0,
0xf6, 0x11, 0xb8, 0x7a, 0x0c, 0x6e, 0x9e, 0x0b, 0xdc, 0x7c, 0x03, 0x1c, 0x38, 0xf1, 0x47, 0xe0,
0xfa, 0x75, 0x66, 0x66, 0x42, 0xf1, 0x7f, 0x10, 0x33, 0x80, 0x64, 0x0a, 0xba, 0x7e, 0xae, 0x01,
0xca, 0xe7, 0xca, 0xcf, 0x23, 0xbe, 0x00, 0xed, 0xb3, 0x28, 0x82, 0xe5, 0x3b, 0xb8, 0xf1, 0x27,
0x30, 0xfe, 0x7c, 0xc0, 0x2e, 0xf9, 0x31, 0x3c, 0x7d, 0x27, 0x46, 0xb0, 0x7a, 0x3a, 0xcf, 0x61,
0xf9, 0x10, 0xda, 0xe7, 0xca, 0xcf, 0x03, 0x74, 0xfd, 0x3c, 0x03, 0x02, 0x30, 0x00, 0x65, 0x0a,
0xa7, 0x6f, 0xc1, 0xd1, 0xb7, 0xe0, 0xfa, 0x5b, 0x38, 0x00, 0x7c, 0x0b, 0x26, 0x4f, 0xe9, 0x2d,
0x18, 0xbf, 0xa0, 0xb7, 0x30, 0x7b, 0x07, 0xd1, 0x5b, 0x50, 0x78, 0x83, 0xe8, 0x2d, 0x08, 0xff,
0x6f, 0x4a, 0x55, 0x75, 0x9f, 0xab, 0xc0, 0xd1, 0x5b, 0x78, 0xf4, 0x16, 0x04, 0x2d, 0x01, 0x64,
0x0a, 0xfd, 0x97, 0xf1, 0x31, 0x33, 0x9f, 0x3c, 0x85, 0xa3, 0x87, 0x70, 0xf6, 0xd8, 0x5f, 0x17,
0x84, 0xcf, 0x95, 0xbf, 0x81, 0x26, 0x40, 0xf8, 0x16, 0x2e, 0x9e, 0x97, 0xc1, 0xe2, 0xe3, 0x57,
0xa0, 0x7b, 0x4b, 0xdf, 0xee, 0x47, 0xd0, 0xac, 0x3f, 0x26, 0x08, 0x34, 0x80, 0x64, 0x0a, 0x0b,
0xec, 0x37, 0xb0, 0xf9, 0x7c, 0x05, 0x14, 0xfe, 0x0c, 0xee, 0x1e, 0x82, 0xe3, 0x77, 0xfc, 0xba,
0x40, 0xbf, 0xdd, 0x6f, 0xa0, 0x8f, 0x40, 0xf8, 0x16, 0xfa, 0x60, 0xf1, 0x1c, 0xf2, 0x17, 0xa0,
0x78, 0x0e, 0xe5, 0x43, 0xd0, 0x3d, 0x85, 0xc2, 0x1f, 0xef, 0x37, 0x20, 0xd9, 0x6f, 0x07, 0x02,
0x25, 0x80, 0x64, 0x6a, 0xff, 0x47, 0xaa, 0xaa, 0xba, 0x8f, 0xc1, 0xe5, 0x2b, 0xb8, 0x78, 0x0e,
0x0e, 0xdf, 0x81, 0xf3, 0x07, 0xee, 0x5e, 0x82, 0xf3, 0x27, 0x70, 0xf5, 0x14, 0x5c, 0xbf, 0x81,
0xa3, 0xc7, 0xe0, 0xf8, 0x15, 0x18, 0x39, 0x80, 0x64, 0x0a, 0x2a, 0x7e, 0xae, 0x02, 0xaa, 0x4f,
0xf9, 0x79, 0x40, 0xfb, 0x0a, 0xb4, 0xcf, 0xa0, 0x7e, 0x03, 0xc2, 0x77, 0x10, 0x3e, 0x0d, 0xe9,
0x27, 0x20, 0xfd, 0x2b, 0xd0, 0xf8, 0x53, 0x7e, 0x0c, 0xea, 0x37, 0xa0, 0x7c, 0x18, 0xcf, 0x61,
0xf4, 0x16, 0xfa, 0x04, 0x84, 0x4f, 0x21, 0xfc, 0x74, 0xbf, 0x01, 0x19, 0x3f, 0xdf, 0x81, 0x00,
0x33, 0x80, 0x64, 0x0a, 0xb2, 0x7e, 0x8e, 0xb0, 0xfb, 0xb4, 0x9f, 0x82, 0x3e, 0x01, 0xf5, 0x9b,
0x79, 0x0d, 0xbb, 0x87, 0xf2, 0x1c, 0x56, 0x4f, 0x21, 0x7f, 0x07, 0x4d, 0x3f, 0x85, 0xe8, 0xcf,
0x5f, 0x82, 0xe4, 0x90, 0xf0, 0x1d, 0xb8, 0x7e, 0x02, 0x16, 0xfa, 0x16, 0x56, 0xfc, 0x75, 0xc0,
0xee, 0xf1, 0xc1, 0x00, 0x0e, 0x81, 0x51, 0x05, 0x09, 0xc4, 0x8f, 0xd4, 0x07, 0xfe, 0x04, 0xe2,
0x47, 0xea, 0x03, 0x15, 0x74, 0x6a, 0x04, 0x45, 0x80, 0xfc, 0x09, 0xd4, 0x1e, 0xf0, 0x7f, 0xfb,
0x40, 0xfc, 0x40, 0xde, 0x10, 0xbd, 0x83, 0x04, 0x41, 0x1c, 0x04, 0x44, 0x09, 0x27, 0x69, 0xb0,
0xd1, 0xef, 0xa0, 0xe2, 0x8f, 0x0d, 0xba, 0x0f, 0x05, 0x66, 0xdf, 0x16, 0x98, 0xe4, 0x2f, 0x05,
0x16, 0xe7, 0xef, 0xc0, 0x55, 0x01, 0x0f, 0x0d, 0x34, 0xca, 0xff, 0x15, 0x02, 0x52, 0x1d, 0xf0,
0x8f, 0xff, 0x2b, 0x04, 0xa4, 0x3a, 0x1b, 0x05, 0x44, 0xb9, 0x06, 0xce, 0x9f, 0x63, 0xc0, 0x04,
0xfb, 0xd3, 0x01, 0x9b, 0xfc, 0x06, 0x24, 0xe8, 0x9f, 0x14, 0x7f, 0x6d, 0xa0, 0x6f, 0x09, 0x0c,
0x05, 0x1c, 0x24, 0x00, 0x64, 0x08, 0xc9, 0xfa, 0x63, 0x82, 0xc2, 0x1f, 0xf3, 0x37, 0xe5, 0x09,
0xc2, 0x87, 0x70, 0xf7, 0x10, 0x6c, 0x3e, 0x81, 0xcd, 0x47, 0x60, 0xfd, 0x08, 0xee, 0x35, 0xf8,
0x0b, 0x70, 0xf1, 0x1c, 0x2e, 0x9c, 0x61, 0x69, 0xf0, 0x87, 0x0f, 0x16, 0xd8, 0x5f, 0xa3, 0x80,
0x1b, 0xf7, 0x23, 0x32, 0x7e, 0x05, 0x36, 0x4f, 0xc1, 0xd9, 0x1b, 0x58, 0x2f, 0x78, 0xca, 0xa0,
0x7a, 0x02, 0x32, 0x7f, 0x3c, 0xd0, 0xbc, 0x80, 0x96, 0x41, 0xf6, 0xb0, 0x5e, 0x82, 0x5e, 0x41,
0x8e, 0xa0, 0x97, 0xa0, 0x77, 0xa0, 0xb6, 0x78, 0x06, 0xd5, 0x23, 0x28, 0x9e, 0x81, 0xda, 0xe4,
0x11, 0x84, 0x2f, 0x20, 0x79, 0x04, 0x7a, 0x14, 0xaf, 0x20, 0x7c, 0x01, 0xd9, 0x1b, 0x88, 0x5e,
0x40, 0xef, 0x20, 0x7a, 0x7b, 0xfe, 0x90, 0x3a, 0x41, 0xbb, 0x20, 0xf4, 0x9e, 0x7b, 0x9e, 0x30,
0x7b, 0x03, 0x7f, 0xec, 0x02, 0x7e, 0xc1, 0x4f, 0x8d, 0x4c, 0x09, 0x3c, 0x5b, 0x7f, 0xbe, 0x03,
0x06, 0x8a, 0x78, 0x41, 0x37, 0x00, 0x66, 0x0b, 0x76, 0x8f, 0xe1, 0xeb, 0x4f, 0xe0, 0xcd, 0xf3,
0x87, 0xf0, 0xf2, 0xd9, 0x73, 0x78, 0x1f, 0xb4, 0x8f, 0xe0, 0xec, 0x2d, 0x64, 0x6f, 0xe1, 0xf8,
0x19, 0x14, 0x5f, 0xc0, 0xe4, 0x0b, 0x10, 0xbf, 0x83, 0xe1, 0xff, 0x1a, 0xe6, 0x8f, 0x77, 0x77,
0xbf, 0x81, 0xe8, 0x39, 0x9c, 0xbe, 0x84, 0xf4, 0x21, 0xdc, 0x7c, 0x10, 0x34, 0x81, 0x64, 0xcb,
0x7f, 0xad, 0x02, 0xf1, 0xe3, 0x5d, 0xff, 0x84, 0x5f, 0xc1, 0xf8, 0x1d, 0xbf, 0x82, 0xe5, 0x43,
0x7e, 0x05, 0x1a, 0x7f, 0xc3, 0xff, 0x15, 0xc4, 0x6f, 0x11, 0xf5, 0xb9, 0xf0, 0x2b, 0xd8, 0x3d,
0xe5, 0x57, 0x30, 0x7a, 0xcd, 0xaf, 0x60, 0xf9, 0x96, 0x1f, 0xab, 0xf6, 0x47, 0xfc, 0xe7, 0x3b,
0x10, 0x35, 0x80, 0x65, 0x0b, 0x33, 0xfe, 0x96, 0xc0, 0xf6, 0x63, 0xfe, 0x0c, 0x74, 0xaf, 0x03,
0x44, 0x1f, 0xa8, 0x1f, 0x81, 0xf1, 0x2b, 0xe8, 0x0b, 0xb0, 0x90, 0x90, 0x0f, 0x3c, 0xf9, 0xe0,
0xfb, 0xc0, 0x05, 0xa8, 0x1f, 0x81, 0xf1, 0x2b, 0xe8, 0x5e, 0x07, 0x88, 0xbe, 0x00, 0xf1, 0xb7,
0xfc, 0x19, 0xd8, 0xf5, 0xb7, 0x04, 0x02, 0x36, 0x01, 0x65, 0xcb, 0x3f, 0xdf, 0x82, 0xf1, 0xe3,
0xe5, 0x2f, 0x41, 0xfc, 0x0a, 0x24, 0xfd, 0x0c, 0xe2, 0x57, 0xb0, 0x7a, 0x0d, 0xf1, 0x2b, 0xb0,
0x2f, 0x80, 0x0f, 0xbf, 0x02, 0xf3, 0x37, 0xfc, 0x0a, 0xec, 0x0b, 0x7e, 0x05, 0xab, 0xd7, 0x10,
0xbf, 0x02, 0x89, 0x3f, 0x83, 0xf8, 0xb1, 0xf2, 0x97, 0x20, 0xfe, 0xf9, 0x12, 0x0c, 0x21, 0x81,
0x64, 0xca, 0xff, 0x0b, 0x7e, 0xbc, 0xbb, 0xbb, 0x10, 0xb0, 0xf8, 0x15, 0x38, 0xfe, 0x8f, 0x20,
0x7e, 0xac, 0xaa, 0x3a, 0x10, 0xb0, 0xf8, 0x15, 0x38, 0x7e, 0xac, 0xaa, 0xaa, 0xc1, 0xff, 0x13,
0x18, 0x01, 0x64, 0xc9, 0xff, 0x39, 0x3f, 0xde, 0xdd, 0x4d, 0x60, 0xf1, 0x2b, 0x38, 0xfe, 0x6f,
0xf8, 0xb1, 0xaa, 0xaa, 0x00, 0x3b, 0x7e, 0x05, 0x07, 0x39, 0x80, 0x65, 0x0c, 0xbb, 0x7e, 0xce,
0x04, 0xc6, 0x1f, 0xf3, 0x77, 0xa0, 0x7b, 0x2d, 0xa0, 0xf9, 0x02, 0xea, 0x57, 0x60, 0xd9, 0x04,
0x7d, 0x01, 0x2f, 0x3e, 0xf0, 0xe2, 0x03, 0xc5, 0x1f, 0x42, 0x5f, 0x80, 0x32, 0xfb, 0x21, 0xc4,
0xcf, 0xc0, 0xf2, 0x21, 0x64, 0xcf, 0x05, 0xa6, 0x0f, 0x41, 0xfa, 0xed, 0xfa, 0x47, 0x30, 0xe3,
0xaf, 0x53, 0x20, 0x17, 0x01, 0x65, 0x0c, 0x7c, 0xc7, 0xaf, 0xc0, 0xe8, 0x35, 0xff, 0x5f, 0xf3,
0xe3, 0xdd, 0x5d, 0x06, 0xbe, 0x7b, 0xcd, 0xaf, 0xc0, 0xe8, 0x35, 0x16, 0x81, 0x61, 0xa5, 0xef,
0xf4, 0x9d, 0xbe, 0xd3, 0x77, 0xfa, 0x4e, 0xdf, 0xe9, 0x3b, 0x7d, 0xa7, 0xef, 0xf4, 0x9d, 0xbe,
0xd3, 0x77, 0x19, 0x80, 0x64, 0x09, 0xec, 0x07, 0xae, 0x1f, 0x55, 0x12, 0xac, 0xdf, 0xdc, 0x63,
0xd0, 0x7c, 0x11, 0xfe, 0x7a, 0xbf, 0x04, 0x89, 0xfa, 0x6b, 0x03, 0x01, 0x3a, 0x01, 0x65, 0xcb,
0xaf, 0x60, 0xf6, 0x09, 0xbf, 0x02, 0xd1, 0x47, 0x10, 0xbf, 0x82, 0xc4, 0xdf, 0x81, 0xf8, 0x55,
0xf4, 0x4b, 0x18, 0xbf, 0xda, 0xb7, 0x60, 0xfc, 0xfa, 0x23, 0x30, 0xfe, 0x6b, 0x30, 0x7e, 0x2e,
0xfc, 0x14, 0xc6, 0xaf, 0x20, 0xf9, 0x0a, 0xc4, 0xaf, 0x40, 0xf6, 0x3c, 0x20, 0x7e, 0x05, 0xdb,
0xc7, 0x10, 0xbf, 0x82, 0x85, 0xbf, 0x03, 0x0e, 0x01, 0x64, 0x09, 0xec, 0x1f, 0xbf, 0x82, 0xe3,
0xc7, 0xaa, 0xaa, 0xc8, 0xff, 0x35, 0x4e, 0x81, 0x66, 0xcf, 0x9f, 0xc0, 0xd1, 0xa7, 0xfc, 0x21,
0x9c, 0x7e, 0xca, 0x9f, 0xc3, 0xfd, 0x94, 0xdf, 0x3e, 0x82, 0xd9, 0xdb, 0xa7, 0xfc, 0xec, 0x29,
0x8c, 0x9f, 0x3d, 0xe5, 0x37, 0xfd, 0x02, 0x92, 0xa7, 0xf5, 0x94, 0x1f, 0xdd, 0x33, 0x08, 0x1f,
0xd9, 0x53, 0x7e, 0x14, 0x8f, 0x21, 0x77, 0xe8, 0x9e, 0xf2, 0x2b, 0x48, 0xdf, 0x3d, 0x84, 0xee,
0x29, 0xbf, 0x82, 0xe8, 0x27, 0xd0, 0x3d, 0xe5, 0x57, 0x20, 0x7f, 0x0c, 0xba, 0xa7, 0xfc, 0x0a,
0x84, 0xaf, 0x40, 0xf7, 0x14, 0x3d, 0x01, 0x65, 0xcc, 0x4f, 0xc1, 0xe8, 0x35, 0x7f, 0x04, 0xa3,
0xd7, 0xfc, 0x35, 0x8c, 0x5e, 0xf3, 0xf3, 0x87, 0x20, 0x7a, 0xcd, 0xcf, 0xfc, 0x0d, 0x44, 0xaf,
0xf9, 0x95, 0x3d, 0x86, 0xe8, 0x35, 0xbf, 0x82, 0xf8, 0x1d, 0xbd, 0xe6, 0x57, 0x90, 0x7c, 0xf6,
0x9a, 0x5f, 0x81, 0xf0, 0xf9, 0x6b, 0x7e, 0x05, 0xeb, 0xaf, 0xf9, 0x15, 0x6c, 0xbe, 0xe6, 0x57,
0x60, 0xf9, 0x1a, 0x39, 0x80, 0x65, 0x0c, 0x33, 0x7e, 0xbe, 0x04, 0xa6, 0x1f, 0xf7, 0x67, 0x20,
0x7b, 0x2e, 0x20, 0xfa, 0x04, 0xe2, 0x67, 0x60, 0xfa, 0x10, 0xfa, 0x02, 0xac, 0x1e, 0x03, 0x8f,
0x7c, 0x70, 0xf3, 0x1a, 0xfa, 0x02, 0xac, 0x1e, 0x43, 0xfc, 0x0c, 0x4c, 0x1f, 0x42, 0xf6, 0x5c,
0x40, 0xf5, 0x09, 0x48, 0x3f, 0xee, 0xcf, 0xc0, 0x8c, 0x9f, 0x2f, 0x81, 0x00, 0x2a, 0x01, 0x65,
0xcb, 0xff, 0x98, 0x40, 0xfc, 0x78, 0x97, 0x3f, 0x83, 0xf8, 0x15, 0xac, 0x3e, 0x88, 0x5f, 0x81,
0xf9, 0x1b, 0x7e, 0x05, 0xf6, 0x0d, 0xbf, 0x02, 0x45, 0x3e, 0x87, 0xf8, 0x3f, 0x27, 0x88, 0x1f,
0xaf, 0xe6, 0x05, 0x08, 0xd8, 0xf8, 0x15, 0x3c, 0x3d, 0xf8, 0x75, 0x0c, 0x33, 0x7e, 0xbe, 0x03,
0xb6, 0x1f, 0xfb, 0x57, 0x20, 0x7b, 0x1d, 0x20, 0xfb, 0x02, 0xea, 0x57, 0x60, 0xfb, 0x2e, 0x3e,
0x38, 0x7b, 0x0b, 0x7c, 0xe4, 0x39, 0x1c, 0x3d, 0x8e, 0x0f, 0xce, 0xde, 0x42, 0xfd, 0x0a, 0x6c,
0xdf, 0x41, 0xf6, 0x3a, 0x40, 0xf5, 0x05, 0x68, 0x3f, 0xee, 0xcf, 0xc0, 0x8c, 0x9f, 0x7f, 0x05,
0x5e, 0x7d, 0x07, 0x9e, 0x6c, 0x00, 0x3b, 0x01, 0x65, 0xcb, 0x7f, 0xad, 0x02, 0xe2, 0xc7, 0xbb,
0xfe, 0x09, 0xc4, 0xaf, 0x60, 0xfb, 0x14, 0xe2, 0x57, 0x30, 0x7a, 0x0d, 0xf1, 0x2b, 0x58, 0x3d,
0x86, 0xf8, 0x15, 0x68, 0xfa, 0x19, 0xc4, 0xff, 0x29, 0x88, 0x1f, 0x2f, 0xbf, 0x86, 0xf1, 0x2b,
0x50, 0xbf, 0x02, 0xf1, 0x2b, 0x50, 0x3d, 0x07, 0xf1, 0x2b, 0xd8, 0x3e, 0x84, 0xf8, 0x15, 0x6c,
0x3e, 0x01, 0x35, 0x00, 0x65, 0x0a, 0x9a, 0xf5, 0xd7, 0x08, 0xb3, 0x8f, 0xd7, 0x5f, 0x83, 0xfc,
0x15, 0x8c, 0x9f, 0x41, 0xdf, 0xc0, 0x28, 0x0b, 0xd2, 0xd7, 0x05, 0x2e, 0xf6, 0xa7, 0x03, 0x47,
0xfa, 0x4b, 0x78, 0xf6, 0xd5, 0x2c, 0x82, 0xe1, 0x4b, 0xf9, 0x06, 0xb6, 0x0f, 0x21, 0xfc, 0x58,
0xfb, 0xb9, 0x80, 0x68, 0xfd, 0x75, 0x0a, 0x04, 0x12, 0x00, 0x65, 0xaa, 0xff, 0xcf, 0x76, 0xf7,
0xdb, 0x5d, 0x05, 0x03, 0xf6, 0xe7, 0x6f, 0xe0, 0xf9, 0x1b, 0x18, 0x1f, 0x01, 0x65, 0x0b, 0xdc,
0xf7, 0x09, 0xd8, 0x17, 0x9f, 0x80, 0x7d, 0x90, 0xbf, 0x81, 0xc5, 0x07, 0xe9, 0x53, 0x18, 0x3e,
0x86, 0xe4, 0xeb, 0xed, 0x6f, 0x40, 0xa2, 0xfe, 0x5c, 0x05, 0x04, 0x37, 0x80, 0x65, 0xab, 0x2f,
0xe1, 0xf2, 0x29, 0x3d, 0x87, 0xf3, 0x57, 0x90, 0x3f, 0x82, 0xd1, 0x73, 0x50, 0xbe, 0x84, 0xe5,
0x4b, 0xd0, 0x3c, 0x87, 0xf9, 0x1b, 0x58, 0xbf, 0x81, 0xe6, 0x35, 0x18, 0x3e, 0x84, 0xf2, 0x21,
0x98, 0xbc, 0x86, 0xfc, 0x09, 0x1c, 0x3f, 0x7b, 0x0c, 0xce, 0x7e, 0x06, 0x2e, 0x7e, 0x01, 0x6f,
0xdf, 0x82, 0x01, 0x54, 0x80, 0x67, 0x7f, 0x2f, 0x61, 0xf7, 0x10, 0x86, 0x0f, 0x07, 0x98, 0xc7,
0xb0, 0x7d, 0x04, 0x7d, 0xb0, 0x1f, 0xec, 0x0b, 0x88, 0xdf, 0x40, 0xf3, 0xfa, 0x11, 0x24, 0xaf,
0x41, 0xf8, 0x0c, 0xba, 0x57, 0x0f, 0xa1, 0x7a, 0x09, 0xaa, 0xa7, 0xd0, 0x3a, 0xd4, 0x0c, 0xe5,
0x2b, 0x50, 0xbc, 0x86, 0x9e, 0x42, 0xf9, 0x82, 0x9f, 0xc0, 0xfa, 0xd1, 0x33, 0x08, 0xa0, 0x9e,
0x83, 0xe9, 0xe3, 0x27, 0x50, 0x3c, 0x7e, 0x0a, 0x66, 0x5f, 0xc3, 0xf8, 0x3b, 0x30, 0xf9, 0x12,
0x86, 0xdf, 0xc0, 0xf9, 0x2b, 0x18, 0x7d, 0x30, 0x37, 0x80, 0x65, 0x4b, 0x9f, 0xc0, 0xea, 0x0b,
0x48, 0xdf, 0xc2, 0xfc, 0x19, 0x28, 0xbe, 0x82, 0xf0, 0x31, 0x98, 0xbd, 0x96, 0x6f, 0xe0, 0xf8,
0xf9, 0x4b, 0x70, 0xf3, 0x79, 0x80, 0xa3, 0x5f, 0x80, 0xeb, 0xe7, 0x4f, 0xe1, 0xf0, 0xb5, 0x7c,
0x04, 0x93, 0x8f, 0xa0, 0x7b, 0x0d, 0xdb, 0xa7, 0xb0, 0x7e, 0x08, 0xd5, 0x17, 0x30, 0xfa, 0x04,
0x29, 0x80, 0x65, 0xaa, 0x4f, 0xc1, 0xe8, 0x0b, 0xf9, 0x04, 0xc6, 0xef, 0x40, 0xf9, 0x12, 0x44,
0xcf, 0x61, 0xf1, 0x05, 0xc4, 0xcf, 0xc0, 0xf0, 0xe5, 0xbc, 0x06, 0xe7, 0x8f, 0x5f, 0x81, 0xbb,
0x8f, 0xc1, 0xf3, 0x47, 0xc0, 0x06, 0x9e, 0xbf, 0x01, 0x03, 0x29, 0x00, 0x65, 0x4a, 0xff, 0x77,
0x03, 0x68, 0xf7, 0x23, 0x70, 0xfa, 0x14, 0x5c, 0x3d, 0x0f, 0xb8, 0xf0, 0x47, 0xe0, 0xf6, 0x25,
0xb8, 0x7b, 0x0d, 0x4e, 0xbe, 0x01, 0xc7, 0xef, 0xc0, 0xe1, 0x63, 0x70, 0xf3, 0xb1, 0xaa, 0xaa,
0x5e, 0xfd, 0x9f, 0x02, 0x2a, 0x75, 0x8a, 0xe5, 0xdf, 0xf9, 0x4b, 0xf2, 0x17, 0x90, 0xbf, 0x80,
0xfc, 0x05, 0xe4, 0x2f, 0x20, 0x7f, 0x01, 0xf9, 0x0b, 0xc8, 0x5f, 0x40, 0xfe, 0x02, 0xf2, 0x17,
0x90, 0xbf, 0x80, 0xfc, 0x05, 0xe4, 0x2f, 0x20, 0x7f, 0x01, 0xf9, 0x4b, 0xf2, 0xef, 0x00, 0x25,
0x7c, 0x6c, 0xa7, 0xaf, 0xe0, 0xe6, 0x2d, 0xb8, 0x7e, 0x02, 0x77, 0x0f, 0xe1, 0xe2, 0x39, 0xb8,
0x7d, 0x04, 0x47, 0x4f, 0xc1, 0xf9, 0x0b, 0x38, 0x7c, 0x07, 0x27, 0xaf, 0xc1, 0xf1, 0x1b, 0xb8,
0x7a, 0x09, 0xee, 0x83, 0x00, 0x2a, 0x74, 0x8a, 0xe5, 0x1f, 0x22, 0x3f, 0x84, 0xf0, 0x21, 0x84,
0x0f, 0x21, 0x7c, 0x08, 0xe1, 0x43, 0x08, 0x1f, 0x42, 0xf8, 0x10, 0xc2, 0x87, 0x10, 0x3e, 0x84,
0xf0, 0x21, 0x84, 0x0f, 0x21, 0x7c, 0x08, 0xe1, 0x43, 0x08, 0x1f, 0x22, 0x3f, 0xf4, 0x0f, 0x01,
0x17, 0x98, 0x33, 0x07, 0xa2, 0x87, 0x60, 0xfb, 0x1c, 0x26, 0x8f, 0x5f, 0x81, 0xf0, 0x49, 0x33,
0xc8, 0x17, 0xba, 0x37, 0xf5, 0x0a, 0x8a, 0x97, 0x08, 0x78, 0x14, 0xf8, 0x3f, 0x45, 0x40, 0x99,
0x05, 0x0a, 0xa8, 0x1a, 0x35, 0xcf, 0x03, 0x74, 0x4f, 0x61, 0xbb, 0x01, 0x88, 0x2b, 0x61, 0x28,
0x80, 0x4c, 0x09, 0xba, 0x7e, 0x9e, 0x30, 0x7c, 0x9d, 0xfd, 0x14, 0xe4, 0x2f, 0xa0, 0xf8, 0xe0,
0xf9, 0x13, 0x48, 0xb2, 0xff, 0x04, 0xf2, 0x87, 0x44, 0xfe, 0x64, 0x5e, 0xc3, 0x3e, 0x81, 0xfc,
0xf1, 0xfa, 0x27, 0xd0, 0xf0, 0xeb, 0xdb, 0x57, 0x26, 0x01, 0x6c, 0x0a, 0xd8, 0x07, 0xee, 0xb3,
0x7e, 0x4d, 0xd0, 0x6f, 0xf9, 0x93, 0x6f, 0x40, 0xf9, 0xf2, 0x83, 0xcd, 0xe3, 0x0f, 0x26, 0xcf,
0x3f, 0xd8, 0x3c, 0xfe, 0x08, 0x94, 0x2f, 0x7f, 0xcb, 0x9f, 0x3c, 0xb7, 0x7e, 0x4d, 0x10, 0x26,
0x80, 0x4c, 0x09, 0xb2, 0x7e, 0x9e, 0x01, 0xba, 0x4f, 0xfb, 0x31, 0xe8, 0x13, 0x10, 0xbf, 0xa1,
0xc7, 0x30, 0xa1, 0xa8, 0xa7, 0xe0, 0xe8, 0x31, 0xbc, 0x4f, 0x40, 0xfb, 0x08, 0xba, 0xe7, 0xca,
0x8f, 0x61, 0xd6, 0xcf, 0x33, 0x20, 0x2e, 0x80, 0x6c, 0x0a, 0x6c, 0xe0, 0xee, 0x21, 0x08, 0xdd,
0x37, 0x1f, 0x42, 0xf8, 0x6d, 0x7f, 0x08, 0x7d, 0x03, 0xd2, 0x87, 0xf3, 0x18, 0x76, 0x0f, 0xe9,
0x2d, 0xec, 0x1e, 0xce, 0x63, 0xd8, 0x3d, 0x84, 0xbe, 0x01, 0xe9, 0x43, 0x08, 0xbf, 0xe5, 0x0f,
0x41, 0xe8, 0x6f, 0xef, 0x21, 0x28, 0x80, 0x4c, 0x09, 0x22, 0x7e, 0xae, 0x01, 0xaa, 0x4f, 0xf9,
0x35, 0xc8, 0x9f, 0x80, 0xf4, 0xd5, 0x3c, 0x57, 0x55, 0x7e, 0x48, 0x5f, 0x77, 0x77, 0xe3, 0xbc,
0x86, 0xf7, 0x15, 0xcc, 0x40, 0xf6, 0xad, 0xfa, 0x1b, 0x10, 0xf1, 0xb7, 0x04, 0x01, 0x1c, 0x80,
0x6b, 0x06, 0x92, 0x75, 0x87, 0xf5, 0x6b, 0x05, 0xc9, 0x73, 0xb0, 0x79, 0x0c, 0xd3, 0xbf, 0x84,
0x4a, 0x9f, 0x23, 0x81, 0x80, 0x3d, 0x7a, 0x0c, 0x46, 0x8f, 0x61, 0x38, 0xf4, 0x64, 0x0a, 0x3a,
0x7f, 0x7c, 0x2f, 0xa1, 0xfb, 0xb6, 0xbf, 0x84, 0x3e, 0x02, 0xe5, 0xcb, 0x79, 0x0d, 0xb3, 0x97,
0xf4, 0x16, 0x66, 0x2f, 0xe5, 0x31, 0xcc, 0x5e, 0x42, 0xfe, 0x06, 0x94, 0x2f, 0xa1, 0xfb, 0xb6,
0xbf, 0x04, 0x9d, 0xbf, 0xcd, 0x97, 0xa0, 0x81, 0xed, 0x33, 0x28, 0x1f, 0x6b, 0xbf, 0x06, 0x05,
0xf6, 0xeb, 0x0c, 0x08, 0x19, 0x01, 0x6c, 0x09, 0xd8, 0x07, 0xee, 0xa3, 0x7e, 0x4d, 0xd0, 0x6f,
0xf9, 0x8b, 0x6f, 0x40, 0xfc, 0xea, 0x83, 0xe5, 0x33, 0xe0, 0xee, 0x83, 0xe5, 0x3b, 0x18, 0x81,
0x69, 0x04, 0x05, 0xd4, 0x6f, 0xd6, 0x05, 0xd6, 0x4f, 0xfa, 0x49, 0x3f, 0xe9, 0x27, 0xfd, 0xa4,
0x9f, 0xf4, 0x93, 0x7e, 0xd2, 0x4f, 0x00, 0x16, 0xf7, 0x82, 0x04, 0x0b, 0x98, 0xbf, 0x00, 0xb1,
0x07, 0x3c, 0x60, 0x7f, 0xfe, 0x04, 0xe4, 0x2f, 0x8c, 0x9f, 0x43, 0xf9, 0x78, 0x20, 0x27, 0x01,
0x6c, 0x09, 0xb4, 0x2f, 0xe0, 0xbe, 0x80, 0xe8, 0x9b, 0x2f, 0xe6, 0x23, 0xe8, 0x1b, 0x7f, 0x05,
0xfa, 0xfa, 0x21, 0xec, 0x8f, 0x61, 0x5f, 0xf2, 0x3b, 0xd0, 0x17, 0xf2, 0x0d, 0xf4, 0x05, 0x64,
0xaf, 0xa1, 0x2f, 0x40, 0xfb, 0x12, 0x18, 0x81, 0x69, 0xd4, 0x4f, 0xfa, 0x49, 0x3f, 0xe9, 0x27,
0xfd, 0xa4, 0x9f, 0xf4, 0x93, 0x7e, 0xd2, 0x4f, 0xfa, 0x49, 0x3f, 0xe9, 0x27, 0xfd, 0x04, 0x23,
0x81, 0x4e, 0xff, 0x55, 0xbf, 0x2e, 0xd9, 0xe7, 0x08, 0xfd, 0xb6, 0x3f, 0xe7, 0xfd, 0xec, 0x1b,
0x10, 0x3f, 0x05, 0xd9, 0xd3, 0x0f, 0x96, 0xcf, 0x40, 0xf4, 0x16, 0xf8, 0xbb, 0x0f, 0x96, 0xcf,
0x40, 0xf4, 0x18, 0x17, 0x01, 0x4c, 0xf9, 0x9c, 0xfa, 0x75, 0x41, 0xbf, 0xe5, 0x2f, 0xbe, 0x01,
0xf1, 0xab, 0x0f, 0x96, 0xcf, 0x80, 0xbb, 0x0f, 0x96, 0xef, 0x00, 0x2a, 0x80, 0x4c, 0x0a, 0x2a,
0x7e, 0xae, 0x02, 0xb2, 0x6f, 0xf9, 0xb9, 0x40, 0xfe, 0x06, 0x94, 0x4f, 0xe7, 0x31, 0x4c, 0x9e,
0xd7, 0x5b, 0xb0, 0x8f, 0x1e, 0xc3, 0xe4, 0x39, 0xe4, 0x6f, 0x40, 0xf8, 0x12, 0xb2, 0x4f, 0xf9,
0x79, 0x80, 0x8a, 0x9f, 0xab, 0x40, 0x26, 0x75, 0x64, 0xfa, 0xdc, 0xfa, 0x31, 0x41, 0xbf, 0xed,
0x4f, 0xbe, 0x01, 0xe9, 0xcb, 0x0f, 0x36, 0x8f, 0x3f, 0x98, 0x3c, 0xff, 0x60, 0xf3, 0xf8, 0x1b,
0x90, 0xbe, 0xfc, 0x2d, 0x7f, 0xf2, 0x59, 0x3f, 0x26, 0x08, 0xd0, 0x07, 0x0e, 0x2e, 0xf4, 0x64,
0x0a, 0x42, 0x7f, 0x7b, 0x0f, 0x21, 0xfc, 0xb6, 0x3f, 0x8c, 0x6f, 0x40, 0xfa, 0x70, 0x1e, 0xc3,
0xf0, 0x21, 0xbd, 0x85, 0xe1, 0xc3, 0x79, 0x0c, 0xc3, 0x87, 0xd0, 0x37, 0x20, 0x7d, 0x08, 0xe1,
0xa7, 0xfc, 0x21, 0x08, 0xfd, 0xad, 0x02, 0xeb, 0x21, 0x38, 0x7c, 0x08, 0x0c, 0x81, 0x4a, 0xf6,
0x99, 0xef, 0xdf, 0x7e, 0x07, 0x02, 0xbc, 0x0f, 0x06, 0x27, 0x80, 0x4c, 0x09, 0x42, 0x7f, 0x7d,
0xb0, 0x7d, 0x8b, 0xfd, 0x10, 0xf4, 0x81, 0x82, 0x15, 0xd4, 0x6f, 0x2b, 0xc0, 0x62, 0x7f, 0x2c,
0x60, 0x41, 0xfa, 0x1a, 0x22, 0x57, 0xd8, 0x07, 0xea, 0xb7, 0xc8, 0x4f, 0x41, 0x91, 0xfe, 0x1a,
0x41, 0x1a, 0x00, 0x5b, 0x06, 0xdd, 0x4b, 0xd8, 0xbd, 0x04, 0xfd, 0x93, 0xdb, 0xc7, 0x18, 0x10,
0xb0, 0xdd, 0x4b, 0x98, 0xbd, 0x84, 0xd1, 0xb7, 0x02, 0xca, 0xe7, 0x02, 0x17, 0x80, 0x4c, 0x09,
0xbc, 0x07, 0x7d, 0xb0, 0x7c, 0x06, 0xf9, 0x13, 0x10, 0x3f, 0x83, 0xf2, 0xb9, 0xf6, 0x67, 0x50,
0xa8, 0x3f, 0xcd, 0x67, 0x25, 0x80, 0x4c, 0xa8, 0xcf, 0x40, 0xf1, 0x41, 0xf4, 0x16, 0x54, 0x4f,
0x41, 0xfe, 0x40, 0xfa, 0x0a, 0x94, 0xaf, 0x20, 0x7f, 0xb0, 0x79, 0x39, 0x4f, 0xc1, 0xdc, 0xf1,
0x11, 0x18, 0x7e, 0x0e, 0x37, 0x5f, 0x82, 0xeb, 0x47, 0x30, 0x3b, 0x80, 0x4e, 0x9d, 0xaf, 0x40,
0xf9, 0x06, 0xc4, 0x4f, 0xea, 0x25, 0xc8, 0x1f, 0x82, 0x9e, 0x83, 0x5e, 0x43, 0xf3, 0x31, 0x34,
0x4f, 0x41, 0xfc, 0x02, 0x5f, 0xbe, 0xb8, 0x57, 0xa0, 0x7b, 0xd4, 0x3c, 0xcf, 0xf6, 0x05, 0x68,
0x9e, 0xbe, 0x83, 0x7c, 0xbd, 0xc1, 0xfc, 0x13, 0x28, 0x3f, 0x04, 0xd3, 0xd7, 0x20, 0xfa, 0x08,
0xcc, 0x1e, 0xc2, 0xfc, 0xc1, 0x00, 0x25, 0x80, 0x4c, 0x09, 0x4c, 0xbd, 0x06, 0xed, 0x33, 0xa8,
0x1f, 0x81, 0xe4, 0x39, 0x3e, 0x05, 0xbb, 0x5f, 0x80, 0xc5, 0xa7, 0x70, 0xf9, 0x13, 0xd8, 0x3c,
0xb7, 0xb7, 0x30, 0x60, 0xf8, 0x15, 0x74, 0x8f, 0x41, 0xf3, 0x3c, 0x00, 0x2e, 0xf4, 0x64, 0xb8,
0xef, 0x40, 0xf2, 0x41, 0xf5, 0x18, 0x74, 0x2f, 0x41, 0x5f, 0x40, 0xfc, 0x06, 0x94, 0xcf, 0xe2,
0x39, 0x6c, 0xde, 0xda, 0x43, 0xb0, 0x7e, 0xfc, 0x04, 0xec, 0x3e, 0x86, 0x8b, 0xcf, 0xc0, 0xf5,
0x0b, 0xb8, 0x79, 0x0b, 0x16, 0xfb, 0x0d, 0x98, 0x3c, 0x37, 0x38, 0x1d, 0x00, 0x4c, 0x39, 0xff,
0xb1, 0xa8, 0xaa, 0x7e, 0x09, 0x66, 0xaf, 0xc1, 0xe6, 0x13, 0xb0, 0x7e, 0x05, 0xa6, 0x2f, 0xc1,
0xec, 0x35, 0x98, 0x7c, 0x9b, 0x99, 0x59, 0xff, 0x03, 0x29, 0x74, 0x83, 0x06, 0x23, 0x1e, 0x10,
0xbd, 0x0d, 0xd0, 0x3e, 0x81, 0xf9, 0x03, 0xfb, 0xc0, 0x9e, 0xc3, 0xec, 0x2d, 0x08, 0x5f, 0x07,
0x88, 0xfa, 0x15, 0x2c, 0x5e, 0x03, 0x80, 0x7d, 0x60, 0xfe, 0xc0, 0xf6, 0x0d, 0x6c, 0x1e, 0x0b,
0x6c, 0x78, 0x00, 0x11, 0x79, 0x71, 0x94, 0x9d, 0x9d, 0x9d, 0x9d, 0x9d, 0x9d, 0x9d, 0x9d, 0x9d,
0x9d, 0x9d, 0x9d, 0x9d, 0x0d, 0x29, 0x74, 0x83, 0x86, 0x1a, 0xb0, 0x71, 0x07, 0xbb, 0x67, 0xc0,
0xc0, 0xe8, 0x25, 0x6c, 0x9e, 0x82, 0x3d, 0x17, 0x18, 0x7d, 0x03, 0xd2, 0xa7, 0x01, 0xc9, 0x63,
0x60, 0x60, 0xf4, 0x12, 0x56, 0x0f, 0x61, 0xf8, 0x0a, 0x44, 0xaf, 0x61, 0x98, 0x01, 0x03, 0x1a,
0x8c, 0x25, 0x0b, 0xd2, 0xd7, 0x03, 0x1a, 0x1e, 0xe8, 0x1e, 0xfb, 0x23, 0x08, 0x9f, 0x40, 0xcd,
0x50, 0x34, 0xc0, 0x63, 0x90, 0x1a, 0x28, 0xf6, 0xb1, 0x40, 0x00
};
