/**
 * Font: Roboto Medium Regular 17
 * Copyright: Copyright 2011 Google Inc. All Rights Reserved.
 * Codepoints: 0x20-0x7e
 */

#include <stdint.h>

#define FONT_ROBOTOM12_3BPP_ASCENT 17
#define FONT_ROBOTOM12_3BPP_DESCENT 5
#define FONT_ROBOTOM12_3BPP_CAP_HEIGHT 12
#define FONT_ROBOTOM12_3BPP_LINE_HEIGHT 22
#define FONT_ROBOTOM12_3BPP_BOUNDINGBOX_LEFT -1
#define FONT_ROBOTOM12_3BPP_BOUNDINGBOX_BOTTOM -4
#define FONT_ROBOTOM12_3BPP_BOUNDINGBOX_WIDTH 16
#define FONT_ROBOTOM12_3BPP_BOUNDINGBOX_HEIGHT 18

const uint8_t font_robotoM12_3bpp[2911] = {
    0x00, 0x0c, 0x00, 0x11, 0x00, 0x05, 0xff, 0xff, 0xff, 0xfc, 0x00, 0x10, 0x00, 0x12, 0x02, 0x05,
    0x04, 0x05, 0x04, 0x03, 0x01, 0x00, 0x87, 0x48, 0x20, 0x03, 0x00, 0x00, 0x04, 0x10, 0x81, 0x61,
    0xd5, 0x53, 0x4f, 0x3d, 0xf5, 0xd4, 0x53, 0x2f, 0xbc, 0xf0, 0x02, 0xd7, 0x13, 0x4f, 0x0b, 0xa4,
    0x22, 0x96, 0x53, 0x9d, 0x4b, 0x9b, 0x4b, 0x9b, 0x43, 0x25, 0x2c, 0x80, 0x65, 0x0a, 0x33, 0x11,
    0x0d, 0x77, 0x43, 0x2d, 0x2e, 0x17, 0x74, 0xc3, 0xf8, 0x3f, 0x28, 0xaa, 0xc5, 0x93, 0x60, 0x2e,
    0xa2, 0xe1, 0x6e, 0xa8, 0xc5, 0xf2, 0xbf, 0x41, 0xe2, 0x49, 0x47, 0x05, 0xdb, 0xa1, 0x5c, 0x70,
    0x2d, 0xda, 0xc1, 0x99, 0x88, 0x86, 0x01, 0x30, 0xf8, 0x84, 0x0a, 0x1b, 0xf1, 0x58, 0x5c, 0xfc,
    0x1c, 0x28, 0xaf, 0x7d, 0x41, 0x3c, 0x42, 0x3c, 0xa2, 0x9e, 0xa0, 0x98, 0x68, 0xe7, 0xc0, 0xf5,
    0x59, 0x38, 0xf9, 0x15, 0x2e, 0x3e, 0xa2, 0x16, 0xd3, 0x19, 0xbd, 0x40, 0xbb, 0xa2, 0xbd, 0xf6,
    0x09, 0x9a, 0x9f, 0x85, 0x33, 0xf1, 0x26, 0x0c, 0x34, 0x00, 0x66, 0x8c, 0xe2, 0x2b, 0xbc, 0xab,
    0x5c, 0x88, 0x83, 0x72, 0x42, 0x3b, 0xa4, 0x0b, 0x94, 0x13, 0xda, 0x21, 0x13, 0x76, 0x95, 0x4b,
    0xe3, 0xe2, 0xab, 0x4e, 0xf8, 0x5c, 0xf9, 0x88, 0xdb, 0xe5, 0xa8, 0x1b, 0xec, 0xa6, 0x83, 0x5a,
    0xac, 0x45, 0x3a, 0xa8, 0xc5, 0x1c, 0x94, 0xa3, 0x6e, 0x78, 0xf2, 0x15, 0x01, 0x2e, 0x80, 0x65,
    0x0b, 0xa5, 0x8f, 0x70, 0xbe, 0xfa, 0x08, 0xcb, 0x15, 0x3a, 0xc3, 0x72, 0x46, 0xb9, 0xe2, 0x7c,
    0x7d, 0xc1, 0xe9, 0x19, 0x2e, 0xbf, 0x20, 0x16, 0x7a, 0xd9, 0x19, 0x3d, 0x94, 0x33, 0xb4, 0xf3,
    0x15, 0xe5, 0x61, 0x7d, 0x81, 0xfa, 0xda, 0x6f, 0xd8, 0xfc, 0xaa, 0x27, 0x08, 0xa4, 0x21, 0xa3,
    0x8b, 0x2e, 0x3a, 0xa4, 0x43, 0x22, 0xf1, 0x92, 0x86, 0x4d, 0x10, 0x4f, 0x28, 0x47, 0xc8, 0x07,
    0xe5, 0x08, 0xed, 0x04, 0xf5, 0x30, 0x1f, 0x00, 0x7b, 0x98, 0x0f, 0xeb, 0x61, 0x3c, 0x41, 0x39,
    0x62, 0x3e, 0x2c, 0x37, 0x8c, 0x27, 0x8c, 0x02, 0x23, 0xf0, 0x92, 0xb6, 0x61, 0xba, 0x61, 0xbc,
    0x60, 0x57, 0xac, 0x17, 0x68, 0x37, 0x28, 0x57, 0xec, 0x0c, 0xc0, 0x1e, 0x76, 0x86, 0x72, 0x85,
    0x76, 0x83, 0x7a, 0x81, 0xae, 0x10, 0x2f, 0x48, 0x37, 0x68, 0xc3, 0x00, 0x18, 0x10, 0x44, 0x88,
    0x1d, 0xe1, 0x6e, 0x98, 0x88, 0x3c, 0x15, 0xf1, 0x5f, 0xa0, 0x3e, 0xc1, 0xae, 0x47, 0xac, 0x46,
    0xbb, 0x60, 0x81, 0x04, 0x01, 0x16, 0x84, 0x54, 0x09, 0x53, 0xc0, 0x82, 0xd3, 0x15, 0xdb, 0x7f,
    0x96, 0xfd, 0xd9, 0xc5, 0xc0, 0xe8, 0x0a, 0xa7, 0x2b, 0xde, 0x84, 0x01, 0x0a, 0xf4, 0x29, 0x84,
    0xce, 0xe8, 0x8c, 0xae, 0x3b, 0x65, 0x08, 0x06, 0x90, 0x12, 0xb6, 0x9f, 0xda, 0x12, 0x07, 0x81,
    0x19, 0x85, 0x82, 0x7c, 0xe2, 0x05, 0x1c, 0xfc, 0x6b, 0x07, 0xdb, 0x05, 0x66, 0xc3, 0x72, 0x83,
    0xf1, 0x70, 0x2e, 0x2c, 0x27, 0x18, 0x0f, 0x77, 0x84, 0xe9, 0x04, 0xeb, 0xe1, 0x8e, 0xb0, 0x5d,
    0x60, 0x36, 0x0e, 0x27, 0x80, 0x64, 0x0a, 0xc9, 0xaf, 0x81, 0xf4, 0xea, 0x07, 0xf9, 0x04, 0xf5,
    0x86, 0x1e, 0xa6, 0x2b, 0x7a, 0x98, 0xc0, 0x73, 0xce, 0xc3, 0x72, 0x06, 0x0f, 0x7a, 0x98, 0xae,
    0xc8, 0x27, 0xa8, 0x37, 0xa4, 0x57, 0x9f, 0x31, 0xf9, 0x35, 0x08, 0x0f, 0x01, 0x63, 0x8a, 0xa9,
    0x42, 0xfb, 0xc4, 0x9f, 0x24, 0x04, 0xf6, 0xeb, 0x09, 0xeb, 0x09, 0x24, 0x00, 0x65, 0x0a, 0xcd,
    0xaf, 0xc1, 0xf8, 0xea, 0x87, 0xbd, 0x40, 0xbd, 0xa1, 0xb8, 0xd8, 0x8e, 0x78, 0x3d, 0xc1, 0xe9,
    0x0c, 0x07, 0x26, 0x2f, 0xb8, 0x3c, 0xe1, 0xf2, 0x04, 0xe7, 0x33, 0x49, 0x12, 0xfa, 0x1f, 0x02,
    0x25, 0x80, 0x64, 0x0a, 0xcd, 0xaf, 0x18, 0x5f, 0xfd, 0xa0, 0x87, 0xf5, 0x86, 0x24, 0x8c, 0x37,
    0x5c, 0x5e, 0x30, 0x7f, 0x81, 0x8d, 0x3e, 0xe3, 0xf5, 0x96, 0x09, 0xd3, 0x35, 0x0f, 0xe3, 0x11,
    0xf5, 0xd5, 0x0f, 0x9b, 0x1f, 0x21, 0x27, 0x00, 0x65, 0x8a, 0xeb, 0x15, 0x4e, 0xaf, 0x70, 0x7e,
    0xc5, 0xf1, 0x78, 0x85, 0xe5, 0xaa, 0x2b, 0xcc, 0x87, 0x74, 0xc5, 0x76, 0x43, 0xba, 0x62, 0x67,
    0x48, 0x57, 0x88, 0xff, 0x8b, 0xda, 0xb6, 0xaf, 0xc1, 0xe9, 0x8a, 0xa7, 0x2b, 0x04, 0x23, 0x01,
    0x64, 0x8a, 0xfe, 0x11, 0x3d, 0xdb, 0x5e, 0xae, 0x38, 0x1d, 0x71, 0x3b, 0x3f, 0x0b, 0xf1, 0xd5,
    0x2f, 0x28, 0x18, 0xaf, 0x70, 0x4f, 0x83, 0x3d, 0x9f, 0xa0, 0x5d, 0xf5, 0xda, 0x27, 0x94, 0x3e,
    0x0b, 0x01, 0x25, 0x80, 0x64, 0x0a, 0xa3, 0x2f, 0x58, 0xbe, 0x06, 0x7b, 0xc3, 0xed, 0x08, 0xe7,
    0x9b, 0xcf, 0x82, 0xbe, 0xf6, 0x05, 0x3d, 0x41, 0xbc, 0x82, 0x41, 0x0f, 0xf6, 0x10, 0x8f, 0xd0,
    0xae, 0xd0, 0x73, 0x5f, 0xa0, 0xf4, 0x35, 0x08, 0x1d, 0x80, 0x64, 0xba, 0xff, 0x09, 0xa8, 0x3d,
    0xc3, 0xf1, 0x04, 0xf7, 0xe0, 0x78, 0x83, 0x7b, 0x70, 0x3b, 0xc2, 0xbd, 0xe0, 0x74, 0x85, 0xf3,
    0x05, 0xa7, 0x33, 0x9c, 0x4f, 0x30, 0x2c, 0x80, 0x64, 0x0a, 0xc9, 0xaf, 0x81, 0xf4, 0xea, 0x07,
    0xf5, 0x04, 0xf5, 0x86, 0x7c, 0x81, 0x78, 0x43, 0xbc, 0xa2, 0xf8, 0x02, 0xf5, 0x27, 0x28, 0xaf,
    0x3e, 0x43, 0xbe, 0x40, 0x3c, 0xa2, 0x87, 0xe9, 0x8a, 0x5e, 0x20, 0x5e, 0x11, 0x5f, 0xfb, 0x02,
    0xcd, 0xaf, 0x41, 0x27, 0x80, 0x64, 0x0a, 0xcd, 0x8f, 0xd8, 0x5e, 0x7d, 0x85, 0x5e, 0x20, 0x5f,
    0x72, 0xc6, 0x76, 0xcc, 0xc3, 0x74, 0x45, 0x6f, 0x28, 0xbe, 0x22, 0xfd, 0x23, 0x94, 0x51, 0xbc,
    0xc1, 0xf9, 0x82, 0xeb, 0x15, 0x93, 0x9f, 0x61, 0x3b, 0x0f, 0x03, 0x0c, 0x81, 0x51, 0x85, 0x82,
    0x7c, 0xea, 0x05, 0x7f, 0x41, 0x3e, 0xf5, 0x02, 0x10, 0x74, 0x6a, 0x84, 0x7b, 0x41, 0x3e, 0xf8,
    0xbf, 0x1e, 0xe4, 0x83, 0xce, 0x48, 0x37, 0x14, 0x42, 0x16, 0x04, 0x44, 0x89, 0x0b, 0x87, 0xa5,
    0x6f, 0x48, 0x7e, 0x1e, 0xda, 0x63, 0xb0, 0xbd, 0x0a, 0x16, 0x7e, 0x0c, 0x6c, 0x6f, 0x70, 0x12,
    0x0d, 0x0d, 0x34, 0xea, 0x7f, 0x22, 0x50, 0x1b, 0xf8, 0xe7, 0x7f, 0x22, 0x50, 0x1b, 0x15, 0x05,
    0x44, 0xd9, 0xc1, 0x7d, 0x84, 0x85, 0x7e, 0x0d, 0x2c, 0x7c, 0x81, 0xc2, 0x2f, 0xf2, 0xf3, 0xa0,
    0x57, 0xc1, 0x18, 0x38, 0x1c, 0x00, 0x64, 0x88, 0xd2, 0x67, 0x41, 0xcf, 0x7e, 0xd1, 0x11, 0xe2,
    0x11, 0xb7, 0x23, 0x2c, 0x2f, 0x58, 0x9e, 0x60, 0x3e, 0xe1, 0xce, 0xf0, 0x7f, 0x0f, 0xee, 0x8c,
    0x01, 0x4f, 0xf0, 0x87, 0x8f, 0xa3, 0x9f, 0x19, 0xb8, 0xbc, 0x49, 0xf3, 0x09, 0x96, 0x2b, 0xdc,
    0x2e, 0x98, 0x0b, 0xaf, 0x86, 0x74, 0x81, 0xf6, 0x1c, 0x94, 0x83, 0x6a, 0x68, 0x47, 0x1d, 0xa1,
    0x13, 0x02, 0x39, 0x42, 0x37, 0xc8, 0x43, 0x37, 0xa4, 0x13, 0x74, 0x83, 0xbc, 0x9c, 0x10, 0x0f,
    0xca, 0x09, 0x02, 0x39, 0x21, 0x1e, 0xb4, 0x0b, 0xd2, 0x41, 0x37, 0xa4, 0xeb, 0x1e, 0x65, 0x42,
    0x2d, 0xc4, 0x73, 0xf6, 0x88, 0x0d, 0xcc, 0x05, 0x7f, 0xbe, 0x4e, 0xab, 0xe0, 0xad, 0x5f, 0x03,
    0x03, 0x88, 0x31, 0x41, 0x2b, 0x00, 0x66, 0x0b, 0xdb, 0x19, 0x9f, 0x5f, 0xf0, 0xf2, 0x11, 0x8f,
    0xb7, 0x87, 0xf7, 0x50, 0x4f, 0xb8, 0x5d, 0xd1, 0xae, 0x38, 0xdf, 0xa0, 0x07, 0xcb, 0xc3, 0x7c,
    0xc3, 0xf8, 0x9f, 0xb1, 0xe7, 0xb6, 0x7d, 0x41, 0x7a, 0xb8, 0x1e, 0x51, 0x8f, 0xb8, 0x3c, 0x04,
    0x29, 0x81, 0x64, 0xeb, 0x9f, 0x1b, 0xe4, 0x73, 0xfb, 0xc5, 0x27, 0xcc, 0x37, 0x9f, 0x30, 0x1e,
    0x7d, 0x82, 0xf2, 0xe2, 0x7f, 0x42, 0xbe, 0x92, 0x7d, 0xf1, 0x09, 0xdb, 0xd5, 0x27, 0x4c, 0x67,
    0x9f, 0x30, 0x5e, 0x7d, 0x6e, 0xfd, 0xe4, 0xbf, 0x06, 0x01, 0x28, 0x80, 0x65, 0x8b, 0xcd, 0xaf,
    0x82, 0xf5, 0xd9, 0x6f, 0xd0, 0xce, 0x98, 0x1e, 0xe4, 0x13, 0xcc, 0x27, 0xf4, 0xe0, 0x82, 0xf2,
    0xe0, 0x05, 0xf0, 0xf0, 0xf9, 0x04, 0xf3, 0x09, 0xed, 0x8c, 0xe9, 0x61, 0x7e, 0xf5, 0x1b, 0x6c,
    0x7e, 0x15, 0x04, 0x29, 0x01, 0x65, 0xeb, 0x5f, 0x85, 0xf9, 0x5c, 0x3f, 0x42, 0x3e, 0x41, 0xf1,
    0x0d, 0xf9, 0x84, 0xe9, 0x0c, 0x1e, 0xe4, 0x13, 0xec, 0x81, 0x27, 0x3e, 0xc1, 0x1e, 0xf2, 0x09,
    0xd3, 0x19, 0xf9, 0x04, 0xe5, 0x0d, 0xf9, 0x5c, 0x3f, 0x42, 0xfe, 0x55, 0x18, 0x1c, 0x81, 0x64,
    0xea, 0xff, 0x90, 0xcf, 0x6d, 0x5b, 0x04, 0x96, 0x4f, 0x70, 0xfe, 0x27, 0xe4, 0x73, 0xdb, 0x06,
    0x81, 0xe5, 0x13, 0x9c, 0xcf, 0x6d, 0x5b, 0xe4, 0xff, 0x02, 0x14, 0x01, 0x64, 0xe9, 0xff, 0x7c,
    0x6e, 0x5b, 0x82, 0xe5, 0x13, 0xce, 0xff, 0xe2, 0x73, 0xdb, 0x06, 0xec, 0x7c, 0xc2, 0x01, 0x2b,
    0x80, 0x65, 0x8c, 0xcd, 0xcf, 0x82, 0xf9, 0xd9, 0x6f, 0xd0, 0xce, 0x81, 0xf2, 0x20, 0x9f, 0x60,
    0xb4, 0x10, 0xe0, 0xe1, 0x7b, 0xd8, 0x8f, 0xe8, 0x61, 0xa4, 0x8f, 0xc8, 0x37, 0x18, 0x8f, 0x68,
    0x2f, 0x58, 0x8f, 0x50, 0x5f, 0xfb, 0x09, 0x9b, 0x9f, 0x19, 0x04, 0x14, 0x01, 0x65, 0x0c, 0xbe,
    0xf3, 0x09, 0xa6, 0xb3, 0xff, 0x67, 0x9f, 0xdb, 0xd6, 0xe0, 0xbb, 0xb3, 0x4f, 0x30, 0x9d, 0x01,
    0x12, 0x81, 0x61, 0xd5, 0x5b, 0x6f, 0xbd, 0xf5, 0xd6, 0x5b, 0x6f, 0xbd, 0xf5, 0xd6, 0x5b, 0x6f,
    0xbd, 0xf5, 0x06, 0x14, 0x80, 0x64, 0x09, 0xf6, 0x83, 0xf3, 0x49, 0x14, 0xe6, 0xcb, 0xce, 0x50,
    0x1e, 0xf4, 0xdc, 0x47, 0x28, 0x7d, 0x1e, 0x04, 0x2d, 0x01, 0x65, 0xeb, 0x13, 0xb6, 0x17, 0x9f,
    0x20, 0x3d, 0x21, 0x9f, 0x50, 0xde, 0x20, 0x9f, 0x90, 0x8f, 0x98, 0x4f, 0xbd, 0xc2, 0x7c, 0x7e,
    0x82, 0xf9, 0x67, 0x98, 0x5f, 0x7c, 0xc5, 0x7c, 0x42, 0x79, 0x82, 0x7c, 0x82, 0xf6, 0x20, 0x9f,
    0xb0, 0x9e, 0x91, 0x4f, 0xb0, 0x37, 0x0c, 0x01, 0x64, 0x09, 0xf6, 0xcf, 0x27, 0x9c, 0xcf, 0x6d,
    0x4b, 0xff, 0x33, 0x3e, 0x81, 0x66, 0xef, 0x17, 0x9c, 0x5e, 0xfd, 0x88, 0xeb, 0xab, 0x3f, 0xdc,
    0x57, 0x5f, 0x4f, 0xd8, 0xae, 0x57, 0xdf, 0xae, 0x98, 0x6f, 0x57, 0x5f, 0x7c, 0x50, 0xae, 0xba,
    0xfa, 0xb4, 0x1b, 0xe2, 0x69, 0x57, 0x9f, 0xd0, 0x19, 0x3d, 0xb4, 0xab, 0x4f, 0xa8, 0xb7, 0x23,
    0xda, 0xd5, 0x27, 0xa4, 0x2f, 0x68, 0x57, 0x9f, 0xa0, 0x67, 0x68, 0x57, 0x9f, 0x20, 0x9e, 0xa0,
    0x5d, 0x01, 0x2f, 0x01, 0x65, 0xec, 0x2b, 0x4c, 0x67, 0x3f, 0x61, 0x3a, 0xfb, 0x19, 0xd3, 0xd9,
    0x1f, 0x21, 0x9d, 0x7d, 0x7b, 0x41, 0x3a, 0xfb, 0xb4, 0x33, 0xd2, 0xd9, 0x27, 0xe4, 0x9b, 0xce,
    0x3e, 0xa1, 0xbc, 0x9d, 0x7d, 0x82, 0xf8, 0xd9, 0x27, 0xcc, 0xcf, 0x3e, 0x61, 0x79, 0xf6, 0x09,
    0xc6, 0x33, 0x2c, 0x80, 0x65, 0x8c, 0xcd, 0xaf, 0x82, 0xf5, 0xd9, 0x6f, 0xd0, 0x5e, 0x20, 0xbd,
    0x20, 0xdf, 0x60, 0x3d, 0xa2, 0x87, 0x13, 0x78, 0xce, 0x79, 0xb8, 0x9c, 0xd1, 0xc3, 0xe9, 0x8c,
    0x7c, 0x83, 0xf5, 0x88, 0xf6, 0x02, 0xe9, 0x05, 0xea, 0xb3, 0xdf, 0x60, 0xf3, 0xab, 0x20, 0x1f,
    0x01, 0x65, 0xeb, 0x3f, 0x0b, 0xf2, 0xb9, 0xf5, 0x1b, 0xf2, 0x09, 0xd3, 0x43, 0xe0, 0xf1, 0x09,
    0xf6, 0xe2, 0x13, 0xc6, 0x87, 0xfc, 0x9f, 0x90, 0xcf, 0x2d, 0x87, 0x81, 0xcd, 0x27, 0x3c, 0x2f,
    0xf8, 0x75, 0x8c, 0xcd, 0xaf, 0x81, 0xf5, 0xf9, 0x13, 0xb4, 0x33, 0xb6, 0x07, 0xf9, 0x04, 0xeb,
    0x0d, 0x3d, 0xdc, 0xae, 0xe0, 0xc9, 0xc3, 0xe9, 0x8c, 0x1e, 0x6e, 0x57, 0xe4, 0x13, 0xac, 0x37,
    0xb4, 0x33, 0xa6, 0x87, 0xf5, 0xd9, 0x6f, 0xb0, 0xf9, 0x27, 0x78, 0x7a, 0x83, 0x97, 0x22, 0x2a,
    0x01, 0x65, 0xeb, 0x9f, 0x1b, 0xc8, 0xe7, 0xf6, 0x0b, 0xf2, 0x09, 0xeb, 0x15, 0xfc, 0x20, 0x9f,
    0x30, 0x9d, 0x91, 0x4f, 0x50, 0x7c, 0x43, 0xfe, 0x57, 0xc8, 0xe7, 0xfa, 0x8c, 0x81, 0xe5, 0x13,
    0xa4, 0x07, 0xf9, 0x84, 0xf5, 0x88, 0x7c, 0xc2, 0xf2, 0x02, 0x29, 0x00, 0x65, 0x0a, 0xa5, 0xcf,
    0xc4, 0xf6, 0xdc, 0x67, 0xe8, 0x09, 0xf3, 0x0d, 0xbd, 0x60, 0xa2, 0x50, 0xcf, 0xc2, 0xeb, 0xd7,
    0xe0, 0xd4, 0x8f, 0x78, 0x7b, 0x4a, 0x09, 0xe3, 0x31, 0x2f, 0x58, 0x8f, 0x88, 0xcf, 0xf5, 0x0b,
    0xa4, 0x3e, 0x33, 0x08, 0x0f, 0x00, 0x65, 0xda, 0xff, 0x5b, 0xdb, 0xd7, 0xb6, 0x30, 0xd0, 0xdf,
    0x0b, 0xde, 0x0b, 0x06, 0x13, 0x01, 0x65, 0x0b, 0xee, 0xef, 0x05, 0xf6, 0x50, 0xaf, 0x18, 0xcf,
    0x28, 0xcf, 0xf5, 0x0b, 0x94, 0x7e, 0x0d, 0x04, 0x2a, 0x80, 0x65, 0xdb, 0x23, 0x8e, 0x57, 0x3d,
    0xdc, 0x13, 0x7a, 0xc2, 0xf4, 0x20, 0x1e, 0x31, 0x1e, 0xa1, 0x3c, 0xec, 0x05, 0xf3, 0x05, 0xe5,
    0x0c, 0xe3, 0x11, 0xf1, 0x08, 0xcb, 0x19, 0xbd, 0xe0, 0x7c, 0x3b, 0xc3, 0xed, 0x1b, 0xde, 0x07,
    0xaf, 0x57, 0x18, 0x42, 0x80, 0x67, 0x0f, 0x66, 0x47, 0x8c, 0xc7, 0x80, 0x39, 0x63, 0x3d, 0xa1,
    0x87, 0x7d, 0xd8, 0x83, 0x7c, 0x41, 0x39, 0x9f, 0x50, 0xce, 0x10, 0x6f, 0x68, 0xa7, 0x23, 0xd2,
    0x11, 0xd2, 0x15, 0xf5, 0x90, 0x8d, 0x78, 0xc2, 0xce, 0xe8, 0x8a, 0x78, 0xc8, 0x17, 0xcc, 0xa7,
    0x1b, 0xd2, 0xe9, 0xc1, 0x7a, 0xbe, 0x40, 0xe7, 0x2b, 0x6c, 0xcf, 0x98, 0xdf, 0x60, 0x79, 0xc4,
    0xf8, 0x82, 0x7b, 0xc2, 0xf4, 0x30, 0x29, 0x80, 0x65, 0xab, 0x17, 0x4c, 0x0f, 0xea, 0x15, 0x7b,
    0xc3, 0x9e, 0x10, 0xcf, 0xb0, 0x9d, 0xf3, 0x82, 0xf3, 0x47, 0xb8, 0x7c, 0x78, 0xfa, 0xf0, 0xfc,
    0x15, 0xc7, 0x73, 0x9e, 0xb0, 0x3c, 0xa1, 0x9d, 0xb1, 0x5e, 0x31, 0x1f, 0x91, 0x1e, 0x4c, 0x2f,
    0x20, 0x80, 0x65, 0xda, 0x2b, 0x4c, 0x0f, 0xe5, 0x05, 0xf3, 0x0d, 0xe2, 0x11, 0xd2, 0x83, 0x3d,
    0xc8, 0x37, 0x18, 0x8f, 0x39, 0xc3, 0x3d, 0x9f, 0xe0, 0xf6, 0x0c, 0xef, 0x09, 0x34, 0x78, 0x2f,
    0x30, 0x21, 0x00, 0x65, 0xaa, 0xff, 0x2d, 0x40, 0xed, 0x13, 0x5c, 0xaf, 0x70, 0x7a, 0x78, 0x4f,
    0x70, 0x3d, 0xc2, 0xed, 0x0c, 0x97, 0x17, 0x38, 0xdf, 0xe0, 0x78, 0x86, 0xcb, 0x73, 0xdb, 0x76,
    0xfa, 0x5f, 0x01, 0x0c, 0x75, 0x8a, 0xf5, 0xed, 0x51, 0xc0, 0xff, 0x3d, 0xe8, 0x51, 0xdf, 0x00,
    0x1d, 0x7c, 0x6c, 0xd7, 0x13, 0x2e, 0x57, 0x38, 0x5f, 0x70, 0x3b, 0xc2, 0x3d, 0xb8, 0x9e, 0x70,
    0xba, 0xc2, 0x3d, 0x38, 0xde, 0x70, 0x39, 0xc3, 0xf9, 0x82, 0xd3, 0x11, 0xee, 0x21, 0x21, 0x74,
    0x8a, 0xf5, 0x91, 0x3e, 0x22, 0x1e, 0x11, 0x8f, 0x88, 0x47, 0xc4, 0x23, 0xe2, 0x11, 0xf1, 0x88,
    0x78, 0x44, 0x3c, 0x22, 0x1e, 0x11, 0x8f, 0x88, 0x47, 0xc4, 0x23, 0xe2, 0x91, 0x3e, 0x7e, 0x04,
    0x13, 0x98, 0x33, 0x07, 0xe9, 0x08, 0xeb, 0xc3, 0x72, 0x3e, 0x41, 0xbc, 0xd8, 0xd0, 0x15, 0xed,
    0xa2, 0x13, 0x74, 0x04, 0x07, 0x78, 0x14, 0xf8, 0x5f, 0x81, 0x48, 0x0a, 0x08, 0xa8, 0x1a, 0x95,
    0x87, 0xed, 0x8a, 0xb5, 0x08, 0x86, 0x46, 0x61, 0x1e, 0x80, 0x4c, 0x09, 0xcd, 0x8f, 0x18, 0xcf,
    0xf4, 0x15, 0x7a, 0xd8, 0xc3, 0x7b, 0x41, 0xa1, 0x7f, 0x41, 0x8f, 0xd2, 0x4b, 0xce, 0xd8, 0x0b,
    0x7a, 0xee, 0x17, 0x14, 0x9f, 0xd7, 0x13, 0x1e, 0x01, 0x6c, 0x0a, 0xec, 0xc1, 0xbd, 0xf9, 0x2c,
    0xf4, 0xd5, 0x80, 0x17, 0x88, 0xc7, 0x87, 0xe5, 0xfc, 0xb0, 0xfc, 0xb0, 0x9c, 0x9f, 0x20, 0x1e,
    0xbf, 0xfa, 0xe5, 0xcd, 0x67, 0x21, 0x1e, 0x80, 0x4c, 0x09, 0xcd, 0x8f, 0xd8, 0x5e, 0x7d, 0x86,
    0x5e, 0x20, 0x5f, 0x74, 0xc6, 0x22, 0xa4, 0x2b, 0x9c, 0xce, 0x78, 0x2f, 0x50, 0x4f, 0x68, 0xaf,
    0x3e, 0x63, 0xf3, 0x23, 0x04, 0x25, 0x80, 0x6c, 0x0a, 0x36, 0xb8, 0x1d, 0x21, 0xbe, 0xf2, 0x88,
    0xf8, 0xea, 0x47, 0xf4, 0x02, 0xf5, 0x98, 0x33, 0xb6, 0xa3, 0xae, 0xd8, 0x8e, 0x39, 0x63, 0x3b,
    0xa2, 0x17, 0xa8, 0x47, 0xc4, 0x57, 0x3f, 0x42, 0x7c, 0xdd, 0x11, 0x1f, 0x80, 0x4c, 0x09, 0xc9,
    0xaf, 0x98, 0x5e, 0x7d, 0x86, 0x5e, 0xa0, 0x9e, 0xf2, 0xda, 0xfa, 0xa8, 0x67, 0xdb, 0x66, 0xce,
    0x78, 0x4f, 0xd8, 0xa0, 0xbd, 0xf6, 0x05, 0x92, 0x5f, 0x85, 0x00, 0x17, 0x80, 0x6b, 0x06, 0xa5,
    0x0f, 0xf3, 0xb9, 0x50, 0x1e, 0x2c, 0x67, 0xac, 0x3f, 0x22, 0xf5, 0x51, 0x10, 0xd8, 0xd3, 0x19,
    0xa6, 0x33, 0x06, 0x2c, 0xf4, 0x64, 0x0a, 0xed, 0x79, 0x47, 0xb4, 0x57, 0x3f, 0xa2, 0x27, 0x88,
    0xc7, 0x9c, 0xb1, 0x1d, 0x75, 0xc5, 0x76, 0xcc, 0x19, 0xdb, 0x11, 0xbd, 0x40, 0x3c, 0xa2, 0xbd,
    0xfa, 0x11, 0xda, 0x2b, 0x8f, 0x50, 0xb0, 0xde, 0x10, 0xcf, 0xf5, 0x19, 0xa3, 0xcf, 0x84, 0x00,
    0x13, 0x01, 0x6c, 0x09, 0xec, 0xc1, 0x3d, 0xf9, 0x2c, 0xf4, 0xd5, 0x0f, 0xbd, 0x40, 0x3e, 0x81,
    0x7b, 0x0f, 0xe3, 0x0d, 0x12, 0x81, 0x69, 0x84, 0xf9, 0xd2, 0x0b, 0xe6, 0x8b, 0x2f, 0xbe, 0xf8,
    0xe2, 0x8b, 0x2f, 0xbe, 0xf8, 0xe2, 0x0b, 0x10, 0xf7, 0x82, 0x84, 0xf7, 0x30, 0x1f, 0x3c, 0xd0,
    0xdf, 0x0b, 0xf4, 0xd0, 0xfc, 0x10, 0xcf, 0x41, 0x1f, 0x01, 0x6c, 0x09, 0xec, 0xc1, 0x3d, 0x48,
    0x2f, 0x0f, 0xe5, 0x09, 0xbd, 0x3c, 0x41, 0xcf, 0x47, 0xec, 0x67, 0xec, 0xd1, 0x37, 0xe8, 0xa1,
    0xbc, 0xa0, 0x07, 0xed, 0x8c, 0x1e, 0xd6, 0x23, 0x13, 0x81, 0x69, 0xe4, 0x8b, 0x2f, 0xbe, 0xf8,
    0xe2, 0x8b, 0x2f, 0xbe, 0xf8, 0xe2, 0x8b, 0x2f, 0xbe, 0xf8, 0xe2, 0x0b, 0x1e, 0x81, 0x4e, 0xff,
    0xe4, 0xb3, 0xd2, 0x47, 0xf4, 0xd5, 0x9f, 0xfb, 0xf6, 0x02, 0xf9, 0x0a, 0x0d, 0xfc, 0xb9, 0x3e,
    0x8c, 0x37, 0x48, 0xe0, 0x6f, 0xe7, 0x87, 0xf1, 0x06, 0xe9, 0x0c, 0x10, 0x01, 0x4c, 0xf9, 0xe4,
    0xb3, 0xd0, 0x57, 0x3f, 0xf4, 0x02, 0xf9, 0x04, 0xee, 0x3d, 0x8c, 0x37, 0x20, 0x80, 0x4c, 0x0a,
    0xc9, 0xaf, 0x81, 0xf6, 0xea, 0x17, 0xf4, 0x02, 0xf1, 0x9a, 0x33, 0x96, 0xa7, 0x2b, 0xec, 0xe9,
    0x8c, 0xe5, 0xa1, 0x17, 0x88, 0x47, 0xb4, 0x57, 0x3f, 0x4c, 0x7e, 0x0d, 0x02, 0x1e, 0x75, 0x64,
    0xfa, 0xe6, 0xb3, 0xd0, 0x57, 0x03, 0x5e, 0xa0, 0x1e, 0x1f, 0x96, 0xf3, 0xc3, 0xf2, 0xc3, 0x72,
    0x7e, 0x81, 0x7a, 0xfc, 0xea, 0x97, 0x37, 0x9f, 0x85, 0x80, 0x1e, 0x1c, 0x25, 0xf4, 0x64, 0x0a,
    0xf1, 0x75, 0x47, 0xc4, 0x57, 0x3f, 0xa2, 0x17, 0xa8, 0xc7, 0x9c, 0x31, 0x1e, 0x75, 0xc5, 0x78,
    0xcc, 0x19, 0xe3, 0x11, 0xbd, 0x40, 0x3d, 0x22, 0xbe, 0xfa, 0x11, 0xe2, 0x6b, 0xc1, 0x3a, 0xc2,
    0xf1, 0x08, 0x0b, 0x81, 0x4a, 0xf6, 0x76, 0xfd, 0xf5, 0x0d, 0x02, 0xde, 0xc3, 0x00, 0x1e, 0x80,
    0x4c, 0x09, 0xf1, 0x79, 0x58, 0xaf, 0xf4, 0x11, 0x7a, 0x98, 0x0b, 0xf9, 0x2a, 0xb8, 0x7e, 0x0e,
    0x4e, 0x3d, 0x23, 0x5d, 0xb1, 0x07, 0xf9, 0x4a, 0x5f, 0x31, 0x3e, 0x13, 0x02, 0x13, 0x00, 0x5b,
    0x86, 0x76, 0xc4, 0x76, 0x84, 0xfe, 0xb2, 0x9e, 0x09, 0x81, 0xdd, 0x8e, 0x98, 0x5e, 0x03, 0xf1,
    0x05, 0x12, 0x80, 0x4c, 0x09, 0xde, 0x43, 0x0f, 0xe3, 0x0d, 0xbd, 0x40, 0xbe, 0x21, 0xbe, 0xfa,
    0x0d, 0xea, 0x2b, 0x6f, 0x1c, 0x80, 0x4c, 0xd8, 0x1b, 0xf6, 0x10, 0x18, 0x5d, 0xa1, 0x07, 0xf5,
    0x04, 0xf1, 0x84, 0x1e, 0x96, 0x63, 0xae, 0xb0, 0xc7, 0x13, 0x8c, 0x1f, 0x2e, 0x8f, 0x70, 0x3e,
    0x61, 0x2e, 0x80, 0x4e, 0xcd, 0x13, 0xc4, 0x0b, 0xe4, 0x8b, 0x0e, 0x84, 0xd0, 0x83, 0xce, 0x28,
    0xcf, 0x28, 0x57, 0xc8, 0x87, 0x78, 0x3c, 0xb4, 0x13, 0xb4, 0x93, 0x9d, 0x5b, 0x0f, 0xcb, 0xf5,
    0x86, 0xae, 0x67, 0xd8, 0x17, 0xc4, 0x47, 0x58, 0xcf, 0x90, 0x9e, 0x60, 0x3b, 0x62, 0x0f, 0x03,
    0x1d, 0x80, 0x4c, 0x09, 0x46, 0x67, 0xa8, 0x37, 0xe4, 0x13, 0x94, 0xc7, 0x2b, 0x6c, 0x1f, 0xdc,
    0x2b, 0x8e, 0x5f, 0xb0, 0xbc, 0x5d, 0x31, 0x30, 0x3e, 0xa1, 0x9d, 0xa1, 0x3c, 0x04, 0x24, 0xf4,
    0x64, 0xd8, 0x1b, 0x94, 0x87, 0x74, 0x86, 0x76, 0x84, 0x1e, 0xe4, 0x0b, 0xc4, 0x1b, 0x7a, 0x58,
    0xae, 0x3b, 0xc2, 0x7c, 0xbe, 0xc0, 0xf6, 0x0c, 0xf7, 0x06, 0xe7, 0x83, 0xcb, 0x15, 0xd7, 0x17,
    0x58, 0xde, 0x70, 0x18, 0x00, 0x4c, 0x99, 0x7f, 0x4e, 0xdb, 0x3e, 0xc2, 0x76, 0x86, 0xe5, 0x05,
    0xe6, 0x13, 0xac, 0x47, 0xd8, 0xce, 0xb0, 0xbc, 0x92, 0xa4, 0xfe, 0x03, 0x1e, 0x74, 0x83, 0x86,
    0xc9, 0x81, 0x74, 0xc5, 0x7a, 0xc1, 0x00, 0x0f, 0xf6, 0xb0, 0x5d, 0x21, 0x9e, 0x31, 0xf9, 0x04,
    0x3b, 0x03, 0xc1, 0x1e, 0xac, 0x17, 0x2c, 0xe7, 0x60, 0x71, 0x00, 0x0d, 0x79, 0x71, 0x44, 0xd3,
    0x34, 0x4d, 0xd3, 0x34, 0x4d, 0xd3, 0x34, 0x4d, 0xd3, 0x1e, 0x74, 0x83, 0xc6, 0xc2, 0xf2, 0x60,
    0xbb, 0x81, 0xc1, 0x74, 0xc4, 0x72, 0x85, 0xbd, 0x60, 0x7a, 0x81, 0x7a, 0x85, 0x72, 0x06, 0x0b,
    0xd3, 0x11, 0xe3, 0x09, 0xd2, 0x19, 0x23, 0x61, 0x15, 0x8c, 0x25, 0x0b, 0xf5, 0x1c, 0x28, 0x0e,
    0xda, 0xf9, 0x09, 0xf1, 0x82, 0x6c, 0xc8, 0xe7, 0x33, 0xd4, 0x61, 0x3d, 0x07, 0x01, 0x00,
};
