/**
 * Font: robotoR24
 * Copyright: Roboto Matrix font by Gissio. Based on Google Roboto.
 * Codepoints: 0x20-0x7e
 */

#include <stdint.h>

#define FONT_ROBOTO_MATRIXR24_ASCENT 31
#define FONT_ROBOTO_MATRIXR24_DESCENT 8
#define FONT_ROBOTO_MATRIXR24_CAP_HEIGHT 24
#define FONT_ROBOTO_MATRIXR24_LINE_HEIGHT 39
#define FONT_ROBOTO_MATRIXR24_BOUNDINGBOX_LEFT 0
#define FONT_ROBOTO_MATRIXR24_BOUNDINGBOX_BOTTOM -8
#define FONT_ROBOTO_MATRIXR24_BOUNDINGBOX_WIDTH 28
#define FONT_ROBOTO_MATRIXR24_BOUNDINGBOX_HEIGHT 35

const uint8_t font_roboto_matrixR24[2656] = {
    0x00, 0x18, 0x00, 0x1f, 0x00, 0x08, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x1c, 0x00, 0x23, 0x03, 0x06,
    0x05, 0x06, 0x05, 0x01, 0x02, 0x02, 0x86, 0x6f, 0x20, 0x04, 0x00, 0x00, 0x80, 0x00, 0x07, 0x03,
    0x06, 0x96, 0xfa, 0xff, 0x70, 0x19, 0x07, 0x8a, 0x0e, 0xb2, 0x06, 0x7c, 0x76, 0x36, 0x2c, 0x02,
    0x24, 0x46, 0x1d, 0xcc, 0xa8, 0xd1, 0x46, 0x0d, 0x06, 0x6b, 0xd4, 0x68, 0xa3, 0x06, 0xe5, 0x49,
    0x1e, 0xa0, 0x06, 0x46, 0x1b, 0x35, 0x18, 0xcc, 0xa8, 0xd1, 0x80, 0x51, 0x79, 0x92, 0x87, 0x60,
    0x8d, 0x1a, 0x6d, 0xd4, 0x60, 0x30, 0xa3, 0x46, 0x1b, 0x35, 0x0e, 0x2e, 0xea, 0x9f, 0x37, 0x1d,
    0x30, 0xba, 0xf1, 0x92, 0xf6, 0xd8, 0x06, 0xa0, 0xb3, 0x62, 0x45, 0x30, 0x85, 0x95, 0x94, 0xae,
    0x70, 0x87, 0x4b, 0x80, 0xb7, 0xbc, 0x84, 0x3b, 0x5c, 0xe9, 0x80, 0xa5, 0x95, 0x94, 0x2b, 0x3a,
    0x75, 0xd6, 0xa9, 0x0c, 0x4b, 0x38, 0x60, 0x74, 0xc3, 0x00, 0x3c, 0x02, 0x2a, 0x96, 0xed, 0x7c,
    0x4f, 0x37, 0x68, 0x70, 0xc3, 0x46, 0x0d, 0x82, 0x67, 0xd8, 0xa0, 0x51, 0xc3, 0xc6, 0x80, 0x61,
    0x43, 0x83, 0x0d, 0x1a, 0x1b, 0xec, 0xd1, 0x78, 0x87, 0x80, 0xe1, 0x1b, 0xbf, 0xb1, 0xf3, 0x86,
    0x9e, 0x36, 0x34, 0x68, 0xb0, 0x21, 0x78, 0x86, 0x0d, 0x1b, 0x83, 0x67, 0xd8, 0xa8, 0x41, 0x30,
    0xc3, 0x06, 0x8d, 0xee, 0xf9, 0xce, 0x00, 0x32, 0x02, 0x26, 0x56, 0x59, 0xf1, 0x9a, 0x97, 0x71,
    0x65, 0xa5, 0xc1, 0x2a, 0x55, 0x58, 0xa1, 0xe2, 0x8a, 0x8e, 0x2b, 0x39, 0xdc, 0xd2, 0x25, 0xdd,
    0xc2, 0x3d, 0x54, 0x76, 0x74, 0x80, 0x15, 0x3a, 0x80, 0x8a, 0x3d, 0x2a, 0xb7, 0xac, 0xb0, 0x84,
    0xca, 0x01, 0xa7, 0x96, 0xea, 0xa9, 0x8c, 0x8e, 0x25, 0x75, 0x04, 0x8a, 0x04, 0x62, 0x7e, 0x1a,
    0xc2, 0xd3, 0xc8, 0x5c, 0x38, 0xa0, 0x14, 0xac, 0x62, 0xc3, 0x80, 0x62, 0xa5, 0xc0, 0xbf, 0x62,
    0xe5, 0x80, 0x62, 0xb0, 0xca, 0x8d, 0x03, 0x95, 0x0b, 0x01, 0x1b, 0xc1, 0xd3, 0xc8, 0x24, 0x40,
    0xae, 0x60, 0xb9, 0x71, 0x05, 0xb0, 0x72, 0xe0, 0x5f, 0xb1, 0x52, 0xa0, 0x62, 0x30, 0xc3, 0x8a,
    0x0d, 0x03, 0x4a, 0x95, 0x0b, 0x07, 0x1b, 0x50, 0x9c, 0xe3, 0x18, 0x68, 0x70, 0xe3, 0x02, 0x0d,
    0x0a, 0x49, 0x32, 0xd2, 0x67, 0x0f, 0x3b, 0x6d, 0x61, 0x43, 0xe3, 0x8a, 0x4a, 0x15, 0x2a, 0x35,
    0x68, 0x0c, 0x0e, 0x19, 0x62, 0x34, 0x1d, 0x78, 0xc5, 0x2b, 0xd7, 0xff, 0xe7, 0xc0, 0x2b, 0x5e,
    0x39, 0x09, 0xd8, 0x0b, 0x72, 0xc0, 0x51, 0x49, 0xc9, 0xd1, 0x10, 0x05, 0x49, 0xce, 0x90, 0xf2,
    0x01, 0x07, 0x02, 0x08, 0x81, 0x64, 0xe4, 0xc9, 0x08, 0x16, 0xf1, 0x99, 0xe6, 0xe0, 0xa5, 0x95,
    0x56, 0x58, 0xc1, 0x4b, 0x2b, 0xac, 0xb4, 0x82, 0x07, 0x2b, 0xad, 0xb4, 0xc2, 0x80, 0xd2, 0x00,
    0x1c, 0x02, 0x1e, 0x26, 0x55, 0xc2, 0x32, 0xd5, 0xd9, 0xa9, 0x83, 0xa1, 0x72, 0x25, 0x05, 0xfe,
    0xd3, 0x96, 0x56, 0x02, 0x53, 0xae, 0xe8, 0xd4, 0x59, 0xa7, 0x32, 0x2c, 0x29, 0x0e, 0x03, 0x12,
    0x26, 0x59, 0xa1, 0x44, 0x7f, 0x94, 0x10, 0xf8, 0xff, 0x57, 0xac, 0x00, 0x1c, 0x02, 0x20, 0x26,
    0x55, 0xd2, 0x32, 0xd6, 0xa1, 0x53, 0x67, 0xe5, 0x8a, 0x4a, 0x2b, 0x29, 0x0d, 0x28, 0x5d, 0xe1,
    0x4a, 0x07, 0x14, 0x0e, 0xfc, 0x9d, 0xf7, 0xff, 0x03, 0x27, 0x02, 0x1e, 0x26, 0x55, 0xc2, 0x32,
    0xd5, 0xd9, 0xa9, 0xa3, 0x72, 0x25, 0xa5, 0x2d, 0xad, 0x70, 0x40, 0x79, 0xa7, 0x32, 0xf6, 0x5c,
    0x86, 0x3b, 0x5c, 0xe9, 0x0a, 0x07, 0x2c, 0xad, 0xa4, 0x5c, 0xd1, 0xa9, 0xb3, 0x4e, 0x65, 0x58,
    0x52, 0x23, 0x01, 0x22, 0x26, 0xb9, 0x03, 0x70, 0xc9, 0x5b, 0x30, 0x5c, 0x49, 0x69, 0x45, 0x30,
    0x85, 0x95, 0x95, 0x2b, 0x04, 0x53, 0xac, 0x54, 0xa9, 0x62, 0x30, 0x85, 0xca, 0x95, 0xf5, 0xff,
    0x79, 0xe0, 0x8a, 0x57, 0x06, 0x23, 0x02, 0x1e, 0x26, 0x41, 0x94, 0x23, 0xa0, 0x70, 0xe5, 0x01,
    0x85, 0x2b, 0x49, 0xac, 0x43, 0x9f, 0x9d, 0x3a, 0x14, 0xae, 0x74, 0xa0, 0xc2, 0x01, 0x4b, 0x2b,
    0x29, 0x57, 0x74, 0xea, 0xac, 0x53, 0x19, 0x96, 0x14, 0x25, 0x02, 0x1e, 0x26, 0x5d, 0xc2, 0x9a,
    0x7b, 0x2c, 0x69, 0x07, 0x78, 0x85, 0x2b, 0xaf, 0x28, 0xa9, 0x92, 0x67, 0x39, 0x4a, 0xea, 0xe4,
    0x5c, 0xc9, 0x61, 0xe0, 0x96, 0x56, 0x52, 0xae, 0xe8, 0xd4, 0x59, 0xa7, 0x32, 0x2c, 0x29, 0x0c,
    0x01, 0x20, 0x26, 0xff, 0x7f, 0xb0, 0x7f, 0xba, 0xc2, 0x95, 0xae, 0x38, 0x2a, 0x02, 0x1e, 0x26,
    0x55, 0xc2, 0x32, 0xd5, 0xd9, 0xa9, 0xa3, 0x72, 0x25, 0x05, 0x68, 0x4b, 0x2b, 0x29, 0x57, 0x74,
    0xea, 0xac, 0x53, 0x99, 0xea, 0xec, 0xd4, 0x51, 0xb9, 0x92, 0x02, 0x69, 0x4b, 0x2b, 0x29, 0x57,
    0x74, 0xea, 0xac, 0x53, 0x19, 0x96, 0x14, 0x25, 0x02, 0x1e, 0x26, 0x55, 0xc2, 0x32, 0xd5, 0xd9,
    0xa9, 0xa3, 0x72, 0x25, 0x05, 0x4e, 0x5b, 0xd8, 0x49, 0xb9, 0x93, 0x53, 0x89, 0x72, 0xf6, 0xa4,
    0x54, 0xa2, 0xf2, 0x0a, 0x07, 0x94, 0x77, 0x5a, 0x62, 0xcf, 0x35, 0x2c, 0x39, 0x0c, 0x02, 0x88,
    0x84, 0x64, 0xe4, 0xc9, 0xf0, 0x7f, 0x23, 0x4f, 0x46, 0x00, 0x10, 0xd8, 0xcb, 0x75, 0x68, 0xe8,
    0xe4, 0x68, 0xf8, 0xff, 0x03, 0x2b, 0x02, 0x4a, 0x8e, 0x86, 0x00, 0x10, 0x19, 0xda, 0x13, 0x71,
    0xc1, 0x15, 0x06, 0x96, 0x58, 0xc2, 0x0a, 0x1c, 0x97, 0xb8, 0xc2, 0x05, 0x09, 0x32, 0x9c, 0x32,
    0xf7, 0x3f, 0xfc, 0xff, 0xf6, 0x3f, 0x10, 0x1b, 0xda, 0x13, 0x03, 0x57, 0xe0, 0xb8, 0xc4, 0x15,
    0x06, 0x96, 0x58, 0xc2, 0x8a, 0x0b, 0x1c, 0x1e, 0x01, 0x1c, 0x06, 0x51, 0x72, 0x19, 0xea, 0xec,
    0xd0, 0xc9, 0xb1, 0x92, 0xc2, 0x80, 0xf2, 0x80, 0xe2, 0x40, 0xa7, 0x1d, 0xc0, 0x15, 0xc8, 0x2b,
    0xfd, 0x7f, 0x40, 0x79, 0xc5, 0x00, 0x51, 0xca, 0xf5, 0xe7, 0xb9, 0x86, 0x97, 0xc3, 0x25, 0x95,
    0xb8, 0xf2, 0x0a, 0x2b, 0x5d, 0xb1, 0xf2, 0x15, 0x2a, 0xbd, 0x41, 0xe3, 0x37, 0x34, 0x5a, 0x62,
    0x43, 0xe3, 0x1e, 0x1b, 0x19, 0x76, 0x36, 0xec, 0xdc, 0xa8, 0x61, 0xc7, 0x4a, 0x0d, 0x3b, 0x80,
    0x0d, 0x3b, 0x55, 0x0c, 0xde, 0x86, 0x9d, 0x1a, 0x37, 0xec, 0xd4, 0xb0, 0x52, 0x23, 0xc0, 0xa8,
    0x43, 0x25, 0xa3, 0xca, 0x92, 0x95, 0x8d, 0x6a, 0xd2, 0xd0, 0xb0, 0x43, 0x89, 0x0d, 0x08, 0xbf,
    0xc2, 0xef, 0xdc, 0xf0, 0x3e, 0xbc, 0xc7, 0x01, 0x87, 0x46, 0x41, 0x2e, 0x01, 0x28, 0x66, 0x31,
    0xe0, 0xf0, 0xce, 0x07, 0x2c, 0xde, 0xd0, 0xe8, 0x8a, 0x0a, 0x57, 0x54, 0x1e, 0x4c, 0xa1, 0xe2,
    0x0a, 0x95, 0x06, 0x53, 0xac, 0xb0, 0x62, 0xe5, 0x0a, 0x2b, 0xb6, 0x53, 0xc0, 0x0f, 0x15, 0x57,
    0x76, 0xdc, 0xc1, 0x50, 0xe1, 0x4a, 0x8a, 0xb7, 0x78, 0x05, 0x25, 0x03, 0x20, 0x56, 0x3b, 0x95,
    0xb3, 0x1d, 0x15, 0x56, 0x04, 0x5b, 0x69, 0x25, 0x85, 0x15, 0x95, 0x3b, 0x02, 0x72, 0xb6, 0xa3,
    0xc2, 0x4e, 0x4a, 0x2b, 0x29, 0x30, 0x6e, 0x69, 0x25, 0x85, 0x9d, 0xec, 0x28, 0x67, 0x9d, 0x02,
    0x25, 0x02, 0x24, 0x56, 0xd9, 0xe2, 0x36, 0xf7, 0xa9, 0xa4, 0x0e, 0x15, 0x76, 0x54, 0x5c, 0x51,
    0x79, 0x0b, 0xb7, 0xc0, 0xcf, 0x57, 0xb8, 0x92, 0xf2, 0x4a, 0x8a, 0x2b, 0x2b, 0xec, 0x2c, 0xa9,
    0x53, 0x9f, 0xdb, 0xb8, 0xc5, 0x00, 0x23, 0x03, 0x22, 0x66, 0x37, 0xf7, 0xa9, 0x1c, 0x2a, 0x96,
    0xac, 0xb0, 0xa3, 0xd2, 0x8a, 0x60, 0x15, 0x57, 0x52, 0xe0, 0x79, 0x0b, 0x16, 0x57, 0x52, 0xda,
    0x49, 0x61, 0x47, 0xc5, 0x92, 0xe5, 0xd0, 0xa7, 0x36, 0x07, 0x10, 0x03, 0x1e, 0x36, 0x41, 0x3b,
    0x01, 0x5f, 0xe1, 0x40, 0x39, 0x02, 0xbf, 0xc2, 0xe5, 0xff, 0x00, 0x0e, 0x03, 0x1c, 0x26, 0xf3,
    0x7f, 0xe0, 0xf3, 0xca, 0x03, 0xe5, 0x04, 0xfc, 0x2b, 0x0f, 0x25, 0x02, 0x24, 0x66, 0x5d, 0xf2,
    0x32, 0x97, 0x43, 0x49, 0x25, 0x2b, 0xad, 0xa8, 0xbc, 0x92, 0xf2, 0x16, 0x38, 0x5f, 0x81, 0x5c,
    0x87, 0x5b, 0x38, 0x98, 0x92, 0xf2, 0x8a, 0x8a, 0x2b, 0x4a, 0xee, 0x6c, 0xc7, 0x3a, 0xad, 0x21,
    0x0f, 0x03, 0x24, 0x76, 0x0b, 0xfc, 0xe1, 0x16, 0xee, 0xff, 0x3f, 0xf0, 0x0f, 0xb7, 0x70, 0x05,
    0x06, 0x03, 0x06, 0x96, 0xfe, 0xff, 0x1f, 0x13, 0x01, 0x1e, 0x26, 0xc1, 0xff, 0x0f, 0x57, 0x38,
    0x60, 0x69, 0x0b, 0x3b, 0x29, 0x76, 0xf4, 0xa1, 0xcd, 0x2d, 0x05, 0x37, 0x03, 0x24, 0x56, 0x8b,
    0x3b, 0x29, 0xed, 0xa8, 0xb0, 0xb3, 0x72, 0x87, 0x8a, 0x9d, 0x2a, 0x75, 0xac, 0xd0, 0xb9, 0xb2,
    0xc3, 0x8a, 0x4e, 0x2b, 0x39, 0xae, 0x79, 0x8f, 0xcb, 0xb4, 0xa3, 0xc3, 0x0a, 0x9d, 0x2b, 0x55,
    0xae, 0xd4, 0xb1, 0x62, 0xa7, 0xca, 0x1d, 0x2a, 0xac, 0x50, 0x61, 0x67, 0xa5, 0x1d, 0x15, 0x77,
    0x52, 0xde, 0x01, 0x0a, 0x03, 0x1c, 0x26, 0xc1, 0xff, 0xff, 0x95, 0xb7, 0xff, 0x01, 0x2d, 0x02,
    0x2e, 0xb6, 0xcf, 0xf7, 0x7c, 0x99, 0x6e, 0xd3, 0x75, 0x80, 0xf7, 0x79, 0x19, 0x3c, 0x52, 0x5a,
    0xc9, 0x82, 0x17, 0x95, 0x2b, 0x5a, 0xf0, 0x58, 0xa9, 0xb2, 0x05, 0x2f, 0x54, 0x56, 0x68, 0xc1,
    0xa3, 0x4a, 0x4a, 0x2d, 0x58, 0x2c, 0xb1, 0xe5, 0xca, 0x2d, 0xc0, 0x15, 0x2f, 0x03, 0x24, 0x86,
    0xcf, 0x6b, 0x1e, 0xf0, 0xb8, 0x4c, 0xdb, 0xb0, 0x25, 0x85, 0x2d, 0x39, 0xb7, 0xe8, 0xd8, 0xb2,
    0x62, 0xcb, 0x4e, 0x2d, 0x74, 0x68, 0xa9, 0x42, 0x4b, 0x9d, 0x2d, 0x56, 0xb6, 0x5c, 0xd1, 0x72,
    0x27, 0x0b, 0x2b, 0x59, 0xd8, 0xa6, 0x65, 0x00, 0xf7, 0xbc, 0x86, 0x2b, 0x24, 0x02, 0x26, 0x76,
    0x5d, 0xc2, 0x65, 0x58, 0x0e, 0x50, 0x09, 0x95, 0x56, 0x56, 0x5e, 0x51, 0x79, 0x25, 0x05, 0xfe,
    0x74, 0x4b, 0x57, 0x52, 0x5e, 0x51, 0x79, 0x65, 0xa5, 0x15, 0x02, 0x92, 0xca, 0x61, 0x9b, 0x97,
    0x1c, 0x1c, 0x03, 0x22, 0x56, 0x3f, 0xb5, 0xb3, 0x1e, 0x15, 0x96, 0x60, 0xa4, 0xb8, 0x92, 0x02,
    0x79, 0x0b, 0x86, 0x2b, 0x29, 0x2c, 0x49, 0x8f, 0x76, 0xf6, 0x29, 0xf0, 0x57, 0x3c, 0x29, 0xe2,
    0x27, 0x77, 0x5d, 0xc2, 0x65, 0x58, 0x0e, 0x50, 0x09, 0x95, 0x56, 0x56, 0x5e, 0x51, 0x79, 0x25,
    0x05, 0xfe, 0x74, 0x4b, 0x57, 0x52, 0x5e, 0x51, 0x79, 0x65, 0xa5, 0x15, 0x02, 0x92, 0xca, 0x61,
    0x9b, 0x97, 0x01, 0x78, 0x87, 0x57, 0x7a, 0x41, 0x27, 0x03, 0x20, 0x46, 0x37, 0xf6, 0xa1, 0x9c,
    0x95, 0x3b, 0x2a, 0xac, 0x08, 0x76, 0xa5, 0x95, 0x14, 0x56, 0x54, 0xee, 0x28, 0x67, 0xc0, 0x87,
    0x8a, 0x15, 0x82, 0x29, 0x57, 0x06, 0x53, 0x58, 0x11, 0x4c, 0x69, 0x25, 0xc5, 0x2d, 0xae, 0x00,
    0x26, 0x02, 0x20, 0x46, 0xd5, 0xc2, 0x36, 0xf5, 0xd9, 0xb1, 0xa3, 0xc2, 0x4a, 0x0a, 0xe0, 0x16,
    0xaf, 0x74, 0x09, 0x07, 0x34, 0xaf, 0xe1, 0x92, 0xee, 0x74, 0xc5, 0x03, 0x16, 0x57, 0x52, 0x58,
    0xd1, 0xb1, 0xb3, 0x4f, 0x6d, 0xd8, 0x52, 0x0c, 0x01, 0x24, 0x46, 0xf7, 0xff, 0x39, 0xf0, 0xff,
    0xbf, 0xf2, 0x15, 0x06, 0x13, 0x02, 0x22, 0x56, 0x0b, 0xfc, 0xff, 0xf3, 0x96, 0x57, 0x52, 0x5a,
    0xd1, 0xb9, 0xb3, 0x9c, 0xea, 0xb0, 0xa6, 0x00, 0x31, 0x01, 0x26, 0x56, 0x0b, 0xd0, 0x2d, 0x5d,
    0x09, 0x4c, 0x79, 0x45, 0xe5, 0x95, 0x95, 0x56, 0xa8, 0xb4, 0x52, 0xe5, 0x4e, 0x95, 0x2b, 0x06,
    0x94, 0x83, 0x29, 0x55, 0x58, 0xa9, 0xd2, 0x60, 0xca, 0x8a, 0x2b, 0x2b, 0xaf, 0xa4, 0x70, 0x25,
    0xa5, 0x1b, 0x29, 0x5d, 0xe2, 0x25, 0x5f, 0xe1, 0x15, 0x06, 0x3d, 0x01, 0x36, 0xd6, 0x81, 0xd2,
    0x60, 0x96, 0x56, 0x5a, 0x09, 0xbc, 0xca, 0x25, 0x57, 0x54, 0x2e, 0xb9, 0x32, 0xf8, 0x29, 0x55,
    0x52, 0xaa, 0x50, 0xa9, 0x12, 0xa0, 0x14, 0xfc, 0x2a, 0x2b, 0x2b, 0x2b, 0x06, 0x2a, 0x2b, 0x07,
    0x3f, 0x25, 0xa5, 0x4a, 0x0a, 0x2b, 0x29, 0x55, 0x52, 0xda, 0x48, 0xa9, 0x92, 0x81, 0xc5, 0x25,
    0x97, 0x3c, 0x98, 0xd2, 0x0a, 0x57, 0x5a, 0x31, 0x33, 0x01, 0x26, 0x56, 0xcf, 0x3b, 0x39, 0xed,
    0xac, 0xb0, 0x43, 0xe7, 0x80, 0x62, 0xe7, 0x4a, 0x15, 0x76, 0x76, 0x5a, 0xd1, 0x71, 0x27, 0x05,
    0xe0, 0x9a, 0x2e, 0xf1, 0x92, 0xae, 0xe1, 0x9a, 0x77, 0x52, 0x5e, 0x59, 0x69, 0x67, 0xe7, 0x4e,
    0x95, 0x2b, 0x76, 0xea, 0xdc, 0xd9, 0x69, 0x65, 0xa7, 0x9d, 0x9c, 0x77, 0x24, 0x01, 0x22, 0x46,
    0xcb, 0x5b, 0x5e, 0x49, 0x69, 0x45, 0xa5, 0x95, 0x95, 0x2b, 0x54, 0x0e, 0x28, 0x55, 0xac, 0x54,
    0xb9, 0xb2, 0xc2, 0xca, 0x4a, 0x2b, 0x29, 0xae, 0xa4, 0xbc, 0x84, 0x4b, 0x3a, 0xf0, 0x57, 0xbc,
    0x72, 0x19, 0x01, 0x22, 0x46, 0x41, 0xf2, 0x83, 0xff, 0x47, 0x57, 0xbc, 0xd2, 0x95, 0xae, 0x74,
    0xc5, 0x2b, 0x5d, 0x01, 0xba, 0xe2, 0x01, 0xa5, 0xeb, 0xff, 0x03, 0x0b, 0xda, 0x0d, 0x98, 0xf2,
    0x81, 0xff, 0xff, 0x3f, 0x2b, 0xdb, 0x03, 0x17, 0xf1, 0x99, 0xe6, 0xe0, 0x55, 0x5a, 0x71, 0xa5,
    0xc1, 0x53, 0x5c, 0x69, 0xa5, 0xc1, 0x14, 0x57, 0x1a, 0x3c, 0xa5, 0x15, 0x57, 0x5a, 0x01, 0x0b,
    0xd8, 0x0d, 0x98, 0xf6, 0xc0, 0xff, 0xff, 0x9f, 0x95, 0xe5, 0x03, 0x17, 0x61, 0x18, 0xe3, 0xd4,
    0x70, 0xa3, 0x1d, 0x76, 0x6e, 0xb1, 0xa5, 0x8a, 0x0a, 0x15, 0x95, 0x15, 0x2a, 0x2a, 0x54, 0x52,
    0x6c, 0xb1, 0x02, 0x05, 0xe8, 0xdf, 0xf0, 0xf2, 0x7f, 0x07, 0xa1, 0x4e, 0xa1, 0x0e, 0x81, 0x4a,
    0x15, 0x86, 0x0b, 0x61, 0x1e, 0x02, 0x9c, 0x24, 0xd1, 0x62, 0x9b, 0x7d, 0x72, 0xac, 0xa4, 0x30,
    0xa0, 0xbc, 0x42, 0x1b, 0x7d, 0x92, 0x93, 0x72, 0xc0, 0xc2, 0x96, 0x7b, 0x2a, 0x49, 0x8e, 0x9e,
    0x14, 0x3a, 0x2b, 0x1f, 0x02, 0x5e, 0x36, 0xc1, 0x57, 0xb8, 0xa2, 0xa4, 0x3e, 0xcb, 0xd1, 0xa9,
    0x04, 0x23, 0x85, 0x95, 0x14, 0x78, 0xda, 0xc2, 0x4a, 0xce, 0x95, 0x24, 0x94, 0x24, 0x47, 0x9f,
    0x95, 0x2c, 0x05, 0x1b, 0x01, 0x9c, 0x14, 0x55, 0x72, 0x19, 0xea, 0x28, 0xa1, 0xa2, 0x72, 0x25,
    0xe5, 0x16, 0x38, 0xaf, 0x70, 0x30, 0xe5, 0x4a, 0x12, 0x2a, 0xeb, 0x50, 0xe6, 0x12, 0x02, 0x20,
    0x01, 0x5e, 0x36, 0xc1, 0x87, 0x2b, 0x95, 0xa8, 0xec, 0xa3, 0x9c, 0x24, 0x75, 0x52, 0x58, 0x49,
    0x61, 0xe0, 0x2d, 0xad, 0xa4, 0xb0, 0x92, 0x72, 0x27, 0x09, 0x25, 0xca, 0xd9, 0xa7, 0x96, 0x14,
    0x1d, 0x01, 0x9e, 0x14, 0x55, 0xc2, 0x32, 0xd5, 0x01, 0x96, 0x60, 0xa8, 0x5c, 0x49, 0x69, 0xfd,
    0x7f, 0xb8, 0xd2, 0x15, 0xae, 0xb0, 0xa1, 0xa4, 0x8e, 0x3e, 0xb4, 0xb9, 0x85, 0x00, 0x14, 0x01,
    0x54, 0xb6, 0x54, 0x42, 0xcb, 0x9a, 0x15, 0x03, 0xca, 0x95, 0x02, 0x32, 0xc9, 0x0c, 0xfc, 0xbf,
    0x72, 0xa5, 0x00, 0x26, 0xca, 0x5f, 0x36, 0x51, 0xb2, 0xa2, 0x4c, 0x8a, 0x72, 0x72, 0x2a, 0x73,
    0x0d, 0x7c, 0xda, 0xd2, 0x4a, 0xca, 0x9d, 0x9c, 0x4a, 0x94, 0xb3, 0x0f, 0x2d, 0x2a, 0x5c, 0x79,
    0x65, 0x81, 0x15, 0x95, 0x4a, 0xf4, 0xa1, 0xcd, 0x2d, 0x05, 0x13, 0x02, 0x5c, 0x26, 0xc1, 0x57,
    0x5e, 0x59, 0xb2, 0x92, 0x47, 0x39, 0x49, 0xaa, 0xe4, 0x1c, 0xf8, 0xbf, 0x85, 0x15, 0x07, 0x03,
    0x06, 0x86, 0x32, 0x6d, 0xff, 0x1f, 0x0d, 0xc8, 0xcb, 0x87, 0x40, 0x54, 0x7a, 0xe0, 0xff, 0xff,
    0x8a, 0x3e, 0x29, 0x02, 0x29, 0x02, 0x5e, 0x16, 0xc1, 0x57, 0xb8, 0x72, 0x27, 0xc5, 0x8e, 0x4a,
    0x9d, 0x15, 0x3a, 0x54, 0x76, 0xaa, 0xe8, 0x58, 0xc9, 0x39, 0xa0, 0x61, 0xcf, 0x9d, 0x1c, 0x2b,
    0x3b, 0x55, 0x08, 0x28, 0x55, 0xa8, 0xd4, 0x59, 0xb1, 0xa3, 0x72, 0x27, 0x85, 0x1d, 0x06, 0x03,
    0x46, 0x86, 0xfa, 0xff, 0x3f, 0x1a, 0x02, 0xb2, 0xd4, 0xcb, 0x12, 0x4b, 0x56, 0xf2, 0xec, 0x51,
    0x4e, 0x36, 0x49, 0xa8, 0xa1, 0x93, 0x63, 0x89, 0x35, 0xd8, 0xff, 0xb0, 0xc2, 0x16, 0x80, 0x15,
    0x12, 0x02, 0x9c, 0x24, 0xcb, 0x92, 0x95, 0x3c, 0xca, 0x49, 0x42, 0x27, 0xc7, 0x1a, 0xf8, 0x1f,
    0xb6, 0xb0, 0x02, 0x1a, 0x02, 0x9e, 0x34, 0x55, 0xc2, 0x32, 0xd5, 0xd9, 0xa9, 0xa3, 0x72, 0x25,
    0x05, 0x3e, 0x6d, 0x69, 0x25, 0xe5, 0x8a, 0x4e, 0x9d, 0x75, 0x2a, 0xc3, 0x92, 0x02, 0x1e, 0xca,
    0x5f, 0x36, 0xcb, 0x4e, 0x95, 0x3c, 0xcb, 0x51, 0x52, 0x27, 0xe7, 0x4a, 0x0a, 0x7c, 0xda, 0xd2,
    0x9a, 0x2b, 0x49, 0xea, 0x24, 0x47, 0x25, 0xcf, 0xca, 0x4e, 0x81, 0xaf, 0x70, 0x1e, 0xc9, 0x5f,
    0x26, 0xd5, 0x59, 0xd9, 0x93, 0xa2, 0x9c, 0x9c, 0x4a, 0x52, 0xae, 0x81, 0x4f, 0x5b, 0x5a, 0x49,
    0xb9, 0x93, 0x53, 0x89, 0x72, 0xf6, 0xa4, 0xd4, 0x19, 0xf8, 0x0a, 0x57, 0x0c, 0x02, 0x92, 0xb4,
    0x8a, 0x9a, 0xfc, 0xd9, 0x29, 0xf0, 0x7f, 0xc5, 0x00, 0x1a, 0x02, 0x9a, 0x14, 0xd1, 0x52, 0x99,
    0x75, 0x54, 0xaa, 0xb9, 0xc5, 0x25, 0xad, 0xb9, 0x8c, 0x3d, 0x2d, 0x71, 0xc0, 0x72, 0x4d, 0x9d,
    0x74, 0xb6, 0xa1, 0x66, 0x10, 0x00, 0x94, 0xb5, 0x0c, 0x54, 0xae, 0xd0, 0xfe, 0x0c, 0xfc, 0x57,
    0xee, 0xdc, 0x42, 0x8b, 0x1d, 0x12, 0x02, 0x9c, 0x24, 0x0b, 0xfc, 0x0f, 0x5b, 0x58, 0x63, 0x27,
    0xa5, 0x92, 0xe4, 0xe8, 0x49, 0xa1, 0xb3, 0x02, 0x1e, 0x01, 0x9c, 0x04, 0x0b, 0xc0, 0x16, 0x56,
    0x02, 0x53, 0xac, 0xa8, 0x58, 0x19, 0xa8, 0x50, 0x29, 0x98, 0xa2, 0x62, 0x45, 0xe5, 0x80, 0x85,
    0x2d, 0xed, 0xb8, 0xf3, 0x06, 0x37, 0x0c, 0x36, 0x01, 0xae, 0x94, 0x81, 0x72, 0x30, 0xcb, 0x95,
    0x5b, 0x2c, 0xb1, 0x92, 0x52, 0x49, 0x15, 0x15, 0x6a, 0xa8, 0xa8, 0x50, 0x49, 0x21, 0xa0, 0xac,
    0xa4, 0x0c, 0x7e, 0x0a, 0x15, 0x95, 0x15, 0x95, 0x2a, 0x29, 0x2b, 0x29, 0x56, 0x32, 0x6a, 0xa4,
    0xd8, 0x52, 0xcb, 0x25, 0x95, 0x60, 0xb0, 0x73, 0x07, 0x68, 0xc3, 0x8d, 0x36, 0x0a, 0x22, 0x01,
    0x9c, 0x04, 0x0b, 0x6b, 0xec, 0xa4, 0x58, 0x19, 0x50, 0xe8, 0xe8, 0x54, 0x51, 0xb9, 0x85, 0x2d,
    0xed, 0xb8, 0xd3, 0x16, 0xb6, 0x5c, 0x51, 0xa9, 0xa3, 0x03, 0x50, 0x59, 0xb1, 0x92, 0x63, 0x0d,
    0x2b, 0x29, 0xc9, 0x5d, 0x06, 0x0b, 0x5b, 0x58, 0x63, 0x27, 0xc5, 0x8a, 0x8a, 0x95, 0x15, 0x3a,
    0x03, 0x15, 0x2a, 0x55, 0x74, 0xaa, 0xa8, 0x58, 0x51, 0xb9, 0xe6, 0x16, 0xb6, 0x34, 0xe0, 0xb8,
    0xf3, 0x06, 0xf0, 0xca, 0x1b, 0xee, 0x30, 0x20, 0x69, 0xc5, 0x01, 0x12, 0x01, 0x9c, 0x04, 0x41,
    0x92, 0x83, 0x1f, 0xae, 0xb8, 0xe2, 0x8a, 0x3b, 0xed, 0x40, 0x5c, 0x71, 0xfb, 0x1f, 0x1b, 0xd1,
    0xd5, 0xb7, 0xd8, 0x29, 0x78, 0x8a, 0x95, 0x2b, 0x07, 0xae, 0x5c, 0xb1, 0x52, 0xc7, 0x0e, 0xc0,
    0x0a, 0x7c, 0xae, 0x30, 0xa0, 0x1c, 0x50, 0xd8, 0x61, 0x21, 0x06, 0xe3, 0x05, 0x87, 0xfe, 0xff,
    0x01, 0x1b, 0xd0, 0xd5, 0xb7, 0x0e, 0xc0, 0x0a, 0x70, 0x85, 0x81, 0xaf, 0x1c, 0x50, 0xd8, 0xb1,
    0x53, 0xc5, 0xc0, 0x57, 0xae, 0x18, 0x50, 0xae, 0x58, 0xa9, 0x73, 0x81, 0x01, 0x11, 0x32, 0xe4,
    0x61, 0xed, 0x74, 0x8d, 0x95, 0x64, 0xaa, 0xd9, 0x59, 0x53, 0x99, 0x14, 0x6b, 0xba, 0x33, 0x00,
};
