/*
  Trained via Tensorflow: 10 epochs | 944 parameters (total 3776 bytes) | accuracy: 0.9192 - loss: 0.2784
*/

#define NumberOf(arg) ((unsigned int) (sizeof (arg) / sizeof (arg [0]))) // calculates the number of layers (in this case 3)
#define _3_OPTIMIZE 0B00000001 // ENABLES REDUCE_RAM_DELETE__GATED_OUTPUTS (Comment\Disable it to increase CPU performance)
#define _2_OPTIMIZE 0B00100000 // ENABLES MULTIPLE_BIASES_PER_LAYER
#define _1_OPTIMIZE 0B11000010 // https://github.com/GiorgosXou/NeuralNetworks#define-macro-properties
#define USE_LSTM__NB           // Makes LSTM the core-architecture of your NeuralNetwork. (NB = NO_BACKPROP support)
#define SELU                   // Defines core activation-function of your NeuralNetwork. 
#define LSTM_ACT Sigmoid       // Defines the core recurrent-activation-function of your NeuralNetwork. (Sigmoid is the default, not necessary to define)
#include <NeuralNetwork.h>

const unsigned int layers[] = {28, 3, 10};
float *output; // 3rd layer's output(s)

// Thanks to #define _2_OPTIMIZE B00100000 you have: [Pretrained Biases] 1 for each neuron of layer-to-layer
const PROGMEM float biases[] = {
  // LSTM Layer 0 -> 1 //
   1.8675588 ,  0.12353227,  1.0546633 , /* forget gate       */ 
   1.3924853 ,  0.33717656, -0.42719418, /* input/update gate */ 
  -0.18967809,  0.7552282 ,  0.44167143, /* cell state        */ 
  -1.6899384 ,  0.5349524 , -0.66676843, /* output gate       */ 
  // LSTM Layer 1 -> 2 //
   1.6627344 ,  1.9060102 ,  1.4922147, 0.6743402 ,  2.0475428 ,  1.7608254 ,  1.712977 , 2.120958  ,  1.1387573 ,  1.8026544 , /* forget gate       */
   0.08671667, -0.03171019,  0.4561975, 0.5618198 , -0.15433131,  1.1821122 , -0.8998648, 0.55608726, -0.6530956 , -0.83330846, /* input/update gate */
  -0.6164292 ,  0.6721867 , -0.5466426, 0.63220406,  0.8369218 , -0.10819003, -1.1827694, 0.7507485 , -0.77909905,  0.50866973, /* cell state        */
   0.62419844,  0.44148615,  1.6112335, 0.11277908, -0.15184392,  0.86934423,  0.9810437, 1.6760906 , -0.32645926, -0.43324342, /* output gate       */
};

const PROGMEM float weights[] = {
  // LSTM LAYER 0 -> 1

  // forget gate
  -0.56006646f,  1.79424167f,  0.81205106f,  0.81113166f,  2.30884886f,  1.75076365f,  1.36988425f,  1.66045594f,  1.16815233f,  1.08721220f,  0.89682341f,  0.55578101f, -0.40467992f, -0.28004271f, -0.74355423f, -0.05208818f, -0.27323025f, -0.24220188f, -0.07963811f, -0.18722382f,  0.06338824f,  0.03499802f,  0.24257170f, -0.18918101f, -0.11050037f,  0.38869050f,  1.39015269f, -0.21438445f,
  -0.51460099f, -0.09726919f, -0.31960040f,
  -0.41215420f, -0.94994891f,  0.20133986f,  1.28578365f,  0.35428804f, -0.72345948f, -0.35135022f, -0.51639819f,  0.20730650f, -0.08173729f,  0.21571699f,  0.44239438f, -0.22099584f, -0.49934489f, -0.64617449f, -0.11488798f, -0.30597004f, -0.06611744f, -0.21512373f, -0.08032195f, -0.07729846f,  0.04366026f, -0.18597691f,  0.13518848f, -0.03304829f, -1.66714704f, -1.10094833f, -1.26943636f,
   0.89844388f,  0.35804650f, -1.04262161f,
   0.67106211f, -0.81679940f, -0.21686098f, -0.05103207f,  0.07643954f, -0.08101801f,  0.26221278f,  0.06763724f,  0.07340547f,  0.04324827f, -0.13537291f,  0.06125998f, -0.59195065f, -0.28065377f, -0.75229692f, -0.15546843f,  0.13312404f,  0.02256791f,  0.04493543f, -0.03560763f, -0.10623152f, -0.14769486f, -0.23918468f, -0.38317570f, -0.10404819f,  0.45655292f,  1.03252697f,  0.25401977f,
  -0.15322214f,  0.07984018f, -0.47229961f,

  // input/update gate
   1.34447765f,  1.21506214f, -0.00142059f,  0.37407270f, -0.67142844f, -0.28981662f, -0.16806358f, -0.39499149f, -0.05909899f, -0.27746835f, -0.22176799f,  0.18669653f,  0.04838876f, -0.26253757f, -0.33554101f, -0.46165776f,  0.17933881f,  0.10198914f, -0.38190004f,  0.00671451f,  0.11519508f,  0.18730962f,  0.23812754f,  0.59023058f,  0.44282946f,  0.77560413f,  0.37955281f,  0.81551337f,
  -0.42633763f,  0.97479421f, -0.38563108f,
   0.99282682f, -1.13231957f,  1.46942675f, -0.59089506f, -1.99689901f, -2.31340694f, -2.15398097f, -2.75448966f, -1.68494415f, -1.41880786f, -1.32607532f, -1.37217879f, -0.79940987f, -0.36072943f, -0.34936172f, -0.37788448f, -0.17201650f, -0.18726853f, -0.34458348f, -0.33023658f, -0.33150494f, -0.34759584f, -0.56068408f, -0.34508711f, -0.61267924f,  0.60549521f,  0.96488827f,  0.73914552f,
   0.01679827f,  0.36399242f, -0.51245916f,
   1.02967644f,  0.09480006f,  0.09677152f, -0.93974328f, -0.32035834f, -0.00736407f,  0.31755978f,  0.40403068f,  0.33996096f,  0.19141860f,  0.42212084f, -0.08932101f, -0.30268469f,  1.08072138f,  2.97160220f,  2.74109817f,  0.32955056f,  0.00403675f, -0.45292276f, -0.43291992f, -0.54763448f, -0.19301017f, -0.46445060f,  0.03185485f, -0.08717186f,  0.56168318f,  1.41251922f,  1.84750640f,
   0.17265072f, -0.85993540f,  2.18982601f,

  // cell state
  -0.19087586f,  1.24044859f, -0.70197016f,  0.10922338f, -0.21573128f,  0.84394532f,  0.69601023f,  1.70341873f,  1.49062467f,  1.67779112f,  1.47652173f,  1.62026000f,  0.72526121f, -0.71792161f, -0.95526499f, -0.46554071f,  0.67816925f,  0.66729504f,  1.42333448f,  0.63413370f,  0.64662939f,  0.43221179f,  0.09482156f,  0.36382565f, -0.19289227f, -0.81633443f,  0.10302726f,  1.30510926f,
   0.69137800f,  0.59071922f, -0.47390920f,
   1.58350635f, -1.57978821f, -1.78727078f, -0.93569636f, -2.62355471f, -3.00895572f, -3.17816782f, -0.01917537f,  1.24165928f,  1.02797663f,  1.06172192f,  0.69685608f,  0.68569553f,  0.56274617f,  0.41248098f, -0.01654957f,  0.02152747f,  0.03580673f, -0.00374022f,  0.12310059f, -0.08431561f, -0.15814811f,  0.17915021f, -0.15462899f,  0.41090792f, -0.21434867f, -0.49728012f, -0.68445230f,
  -0.64034599f, -0.22869247f,  0.59553313f,
   0.29689723f,  0.15499316f, -0.32276353f, -0.69326800f,  0.48983440f, -0.05303346f, -0.02092475f,  0.08989809f, -0.09949818f,  0.15357046f, -0.02347321f,  0.14803188f, -0.79051512f, -4.36831760f, -0.77878898f, -0.11333635f, -0.28685811f, -0.01347244f, -0.06504449f, -0.08552788f, -0.20878452f, -0.24343704f, -0.28463370f,  0.10027931f, -0.55648339f, -0.94688445f, -0.92462224f, -1.68074107f,
   0.01916010f, -0.04572369f, -0.15342626f,

  // output gate
  -0.29471025f,  0.65447104f, -0.95578432f, -0.00483017f,  0.13734744f,  0.08690482f,  0.01413853f,  0.06712017f, -0.11340532f, -0.19122984f, -0.19977257f, -0.44530314f, -0.25337633f,  0.03516580f,  0.23717359f,  0.16718726f, -0.13098601f, -0.01616865f,  0.05306531f,  0.06529616f, -0.05828264f,  0.01374966f, -0.09201138f, -0.13988717f, -0.06386571f,  0.05483698f, -0.75540972f, -1.85123193f,
  -0.01023790f,  0.52701426f, -0.12977500f,
  -0.15793592f, -2.05620933f,  0.64971727f,  2.36356306f,  0.05133714f, -0.16817196f, -0.83424717f, -0.32466695f, -0.11790483f, -0.27157372f, -0.40910015f, -0.11877602f, -0.29331073f,  0.35549530f,  0.54819506f,  1.02231205f,  0.73250651f,  0.82868052f,  0.74025238f,  1.57716465f,  1.12688804f,  1.50504875f,  1.24566472f,  0.24697587f,  0.97118306f, -0.17196757f, -1.85712004f, -2.00669932f,
  -0.14837329f, -0.95674235f,  0.31384301f,
  -0.50161368f, -0.36506653f, -0.31619829f,  0.78934085f,  0.56784892f, -0.79475415f, -0.55510288f, -0.36954474f, -0.15870598f, -0.17765272f,  0.33743262f,  2.11138129f,  1.95963931f,  0.75791401f, -0.62293029f,  0.02121293f, -0.07178543f, -0.11223798f, -0.28585276f, -0.04628057f, -0.40629497f, -0.12985863f,  0.16763306f,  0.47262946f,  0.04262070f, -0.68983823f,  0.06299054f, -2.38174891f,
   1.05681944f,  0.28780106f, -0.79772419f,

  // LSTM LAYER 1 -> 2

  // forget gate
  -0.16493922f, -1.26009190f, -0.05413349f,
  -0.01696047f,  0.28865978f, -0.15231532f, -0.59464049f, -0.34690365f,  0.32321247f, -0.11454142f,  0.05769234f,  0.33351517f, -0.04491666f,
  -0.43322575f,  0.61103946f,  0.14045604f,
  -0.15655079f, -0.07692902f, -0.37125480f, -0.11042360f, -0.26997066f,  0.58946216f,  0.03800166f,  0.11128956f, -0.12843464f,  0.32497230f,
  -0.48774040f, -0.93227303f,  0.40686432f,
  -0.34312829f, -0.02521760f, -0.08169277f,  0.21072663f,  0.14090538f,  0.34482610f,  0.12482032f,  0.05798277f,  0.22161427f, -0.21253330f,
   0.71641576f, -0.39412513f, -1.15240383f,
  -0.30447644f, -0.06086191f, -0.11747300f, -0.03403278f, -0.39638665f,  0.40001878f, -0.10171037f, -0.06676395f, -0.33643755f, -0.35772246f,
  -0.26046267f,  0.14401907f,  0.98157203f,
  -0.06955429f, -0.30868003f, -0.51409948f, -0.56796819f,  0.07042276f,  0.80196714f,  0.13522246f, -0.01388796f, -0.02947731f, -0.17187649f,
   0.18303558f, -0.55581480f,  0.17886367f,
  -0.15785298f, -0.10647552f, -0.49765900f, -0.09425836f, -0.31487614f, -0.29128307f, -0.13344359f, -0.06541111f, -0.29475513f, -0.03691937f,
  -0.22582600f,  0.03787405f, -1.02993548f,
   0.14594491f,  0.39920229f,  0.08065582f, -0.33046740f, -0.11204619f,  0.11781869f,  0.05123695f, -0.11514365f,  0.22186039f, -0.82345492f,
   0.26716670f,  0.25190282f,  0.22193505f,
   0.25800541f, -0.08067107f, -0.16873598f, -0.05733146f, -0.68740457f,  0.54117751f,  0.02030283f,  0.41330275f, -0.17714353f, -0.16533946f,
   1.11641526f, -0.54951996f,  0.06266943f,
  -0.35743338f, -0.27333274f, -0.49216551f,  0.36387479f, -0.12734042f,  1.16655850f,  0.48473361f,  0.23333599f, -0.19934489f, -0.16665202f,
  -0.36076894f,  0.74003655f,  1.01242471f,
   0.33870134f,  0.20822345f,  0.19724806f,  0.58966225f,  0.88477498f,  0.50311953f,  0.67159379f, -0.05570782f, -0.11141520f,  0.00858200f,

  // input/update gate
  -0.42262959f,  0.23802783f, -0.87493795f,
  -0.89707750f, -0.26824099f, -0.87564105f, -0.13215806f, -0.46830550f, -0.02798980f, -0.22069554f, -0.07104062f, -0.23705599f,  0.00566624f,
   0.32787743f,  1.56817412f, -1.62498319f,
  -0.15852068f,  0.07120777f, -0.29592982f,  0.07365563f, -1.42920530f, -1.91960919f,  0.04183483f, -0.15614767f, -0.42393142f, -0.37845436f,
  -0.13945471f, -2.81681395f, -1.04310644f,
  -0.00922197f, -0.65534526f, -0.29030889f, -0.26454687f, -0.80292159f, -0.16473234f,  0.42072126f,  0.15794827f, -0.05565554f,  0.23477302f,
  -0.11369653f,  0.72687602f,  0.20927177f,
   0.15866482f, -0.09087269f,  0.33104968f,  0.09374230f,  0.49513009f,  0.18882571f, -0.65965700f,  0.28398860f, -0.04066667f,  0.33177736f,
   0.35270700f,  1.93981969f,  1.55401886f,
   0.10787209f, -0.31753609f, -0.32485071f,  0.02590377f, -0.49601340f, -0.19612709f,  0.22511500f, -0.22583891f, -0.23032019f, -0.64401633f,
   1.06953633f, -1.05110788f,  0.49136686f,
   0.08803122f,  0.06325507f, -0.12572083f,  0.88999462f, -0.23964235f, -0.56072164f, -0.03567090f, -0.59174299f, -0.30014336f, -0.16590850f,
   0.28135747f, -0.68184769f, -1.21463346f,
  -0.16797072f,  0.15812539f, -0.41442391f,  0.18435125f,  0.62549728f, -0.19938649f, -0.21071732f,  0.29504171f, -0.38388181f,  0.58854109f,
   0.23972254f,  0.89219451f,  0.14204782f,
   0.16526666f, -0.01843548f, -0.10712090f,  0.02482131f, -0.09085839f, -0.10298438f,  0.34125859f,  0.08381723f,  0.04030328f, -0.34918040f,
   0.70557123f, -2.40554667f, -1.31325150f,
   0.40333739f, -0.25841677f, -0.13528252f, -0.76622802f, -0.67449266f,  0.49883765f,  0.70389944f,  0.19354145f, -0.34877589f,  0.24347436f,
  -0.71330512f, -0.05411004f,  0.42366290f,
   0.01298585f, -0.55469054f,  1.04361045f, -0.21143988f, -1.57679415f, -0.41923672f,  0.68090034f, -1.39931571f,  0.18198535f, -1.40158617f,

  // cell state
   0.23861460f, -0.85004973f, -0.32886192f,
   0.00566141f, -0.15958388f, -0.03095914f, -1.08511925f, -1.19205463f,  0.36261991f,  0.11856414f,  0.04912700f,  0.49459946f, -1.11247480f,
  -0.45858362f,  1.15304208f, -0.39122033f,
  -0.67837012f, -0.04141403f, -0.67228025f, -0.64028728f,  0.41727942f,  0.62361264f, -0.21258867f,  0.59272814f, -0.82124668f,  0.02453784f,
  -0.24069206f, -1.16996861f,  0.57931787f,
  -0.04907694f,  0.20734318f, -0.16088445f, -0.15382069f,  0.10868329f,  0.46432933f, -0.05361123f,  0.39302859f,  0.10062328f, -0.01455231f,
  -0.66785502f, -0.98094761f, -1.36836100f,
   0.01371568f,  0.09913408f,  0.09183359f, -0.17469153f,  0.07600378f, -0.16603953f, -0.46536559f, -0.05258796f,  0.06966893f, -0.13480642f,
  -0.30735689f,  1.21684289f, -0.17072213f,
   0.29689497f, -0.56489652f, -0.10440008f,  0.19449610f, -0.29329759f,  0.36380261f,  0.56864560f, -0.06466061f, -0.20188119f,  0.03358295f,
   0.19586506f, -1.36192381f, -0.44188792f,
  -0.38671544f, -0.00300455f, -0.29242930f,  0.20226355f, -0.34523717f,  0.09420040f,  1.06332815f,  0.05145033f,  0.59791529f, -0.00848348f,
   0.09560012f, -0.31146228f, -1.89429057f,
   0.48808435f,  0.17556663f,  0.19565961f, -0.16833530f, -0.14468431f, -0.58984250f, -0.43806627f,  0.07577468f,  0.29318094f, -0.35840735f,
   0.06460276f,  2.12761283f, -0.20329112f,
   0.00560066f, -0.19005916f, -0.69150341f,  0.24084952f,  0.11081810f, -0.12240799f, -0.53948921f, -0.31346905f, -0.55891061f,  0.13859175f,
   0.01627002f,  1.08858371f, -0.66658527f,
  -0.18254898f,  0.26649883f, -0.06915800f, -0.24659699f,  0.98086655f,  0.20833401f, -0.69507498f,  0.36565411f, -0.19386508f, -0.08087756f,
   0.01720111f,  0.43502572f, -0.72602850f,
   0.07294327f, -0.29109478f,  0.13020366f, -0.54563504f,  0.40989110f, -0.01915616f, -0.06805101f, -0.18717326f,  0.96781248f,  0.03246217f,

  // output gate
  -0.37037301f, -0.51843697f,  0.29056391f,
   0.06163151f, -0.00391751f,  0.17932904f, -0.10584930f,  0.28739619f,  0.36926296f,  0.57110757f,  0.12020499f, -0.06420802f,  0.24353038f,
  -0.36640096f,  0.12224261f,  0.77891105f,
   0.61813045f, -0.07169502f,  0.37402394f,  0.04538017f,  0.37756434f,  0.18411499f, -0.21425879f, -0.32876575f,  0.56446815f, -0.00452046f,
  -0.04541032f,  0.39399272f, -0.70955050f,
   0.20602447f, -0.17365831f,  0.28210083f,  0.19737521f,  0.30187553f, -0.59625322f, -0.10414902f, -0.00739687f,  0.09291830f,  0.03148792f,
   0.43346795f, -1.23848224f,  0.69852620f,
   0.24495718f, -0.02316259f, -0.27805242f, -0.06235467f, -0.04809268f,  0.05732569f,  0.64623791f,  0.26236674f,  0.02582471f, -0.26180002f,
   0.55564392f,  1.00022781f,  1.55261540f,
   0.04719401f, -0.69177228f, -0.63487673f, -0.54145044f,  0.58942533f,  0.33059871f,  0.26759985f,  0.40342233f,  0.60018933f,  0.15972221f,
  -0.15196642f, -0.00910466f,  0.25598723f,
  -0.03622982f, -0.14248766f,  0.00817016f, -0.22563107f,  0.08201106f, -0.09507491f, -0.20625103f,  0.13508186f, -0.14018467f,  0.45798302f,
  -0.04240255f,  0.67585784f,  0.64543813f,
  -0.13558394f, -0.15170315f, -0.00249222f,  0.37220377f, -0.08538636f, -0.09516627f, -0.00094250f, -0.20198278f, -0.06956805f,  0.82647562f,
   0.08416159f, -0.48813400f,  0.62588191f,
  -0.28211367f,  0.34042332f, -0.42197496f,  0.07455880f, -0.36579433f,  0.80373108f, -0.36101624f,  0.10374884f, -0.01280551f,  0.33139029f,
  -0.54947156f, -0.43805793f, -0.55774879f,
  -0.25873697f, -0.10840828f, -0.12641066f,  0.00471524f, -0.17169897f, -0.02619877f, -0.23107861f, -0.03757890f, -0.01566719f, -0.22846757f,
   0.05120865f, -0.35318655f,  1.10324955f,
   0.04415803f,  0.42860848f, -0.47141668f, -0.18496287f,  0.28531027f, -0.01398248f, -0.11655515f,  0.29797387f, -0.16540739f, -0.10242357f,
};

// Images of handwritten Numbers\Digits in byte form. 
const PROGMEM byte handwritten[4][28][28] = { 
{ // NUMBER: 4
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0, 50,224,  0,  0,  0,  0,  0,  0,  0, 70, 29,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,121,231,  0,  0,  0,  0,  0,  0,  0,148,168,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  4,195,231,  0,  0,  0,  0,  0,  0,  0, 96,210, 11,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0, 69,252,134,  0,  0,  0,  0,  0,  0,  0,114,252, 21,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0, 45,236,217, 12,  0,  0,  0,  0,  0,  0,  0,192,252, 21,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,168,247, 53,  0,  0,  0,  0,  0,  0,  0, 18,255,253, 21,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 84,242,211,  0,  0,  0,  0,  0,  0,  0,  0,141,253,189,  5,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,169,252,106,  0,  0,  0,  0,  0,  0,  0, 32,232,250, 66,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 15,225,252,  0,  0,  0,  0,  0,  0,  0,  0,134,252,211,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 22,252,164,  0,  0,  0,  0,  0,  0,  0,  0,169,252,167,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  9,204,209, 18,  0,  0,  0,  0,  0,  0, 22,253,253,107,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,169,252,199, 85, 85, 85, 85,129,164,195,252,252,106,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 41,170,245,252,252,252,252,232,231,251,252,252,  9,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0, 49, 84, 84, 84, 84,  0,  0,161,252,252,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,127,252,252, 45,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,128,253,253,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,127,252,252,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,135,252,244,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,232,236,111,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,179, 66,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
},
{ // NUMBER: 7
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0, 38,113,113,113,114,238,253,253,253,255,206, 88,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 57, 85,147,234,252,252,252,253,252,252,252,252,253,252,246, 75,  0, 0,0,0,0},
    {0,0,0,0, 0, 67,197,234,252,253,252,252,252,252,196,195,195,195,195,253,252,252, 84,  0, 0,0,0,0},
    {0,0,0,0, 0, 85,252,252,252,225,223,114, 84, 84,  0,  0,  0,  0, 16,253,252,214, 28,  0, 0,0,0,0},
    {0,0,0,0, 0, 38,221,157,112,  0,  0,  0,  0,  0,  0,  0,  0, 16,203,253,252,118,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 26,207,253,255,168,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,104,252,252,215, 33,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 67,240,252,220, 31,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 29,181,252,217, 37,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,253,252,252, 84,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0, 76,191,255,215,110,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0, 19,196,252,253,121,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0, 67,209,252,252, 56,  6,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0, 29,181,252,217, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,253,252,252, 84,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 13,191,255,215, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,154,252,253,121,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 13,187,252,133,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 57,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 57,252,252,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},  
},
{ // NUMBER: 0
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0, 61,  3, 42,118,193,118,118, 61,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0, 14,179,245,236,242,254,254,254,254,245,235, 84,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,151,254,254,254,213,192,178,178,180,254,254,241, 46,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 43,235,254,226, 64, 28, 12,  0,  0,  2,128,252,255,173, 17,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 56,254,253,107,  0,  0,  0,  0,  0,  0,  0,134,250,254, 75,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 63,254,158,  0,  0,  0,  0,  0,  0,  0,  0,  0,221,254,157,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,194,254,103,  0,  0,  0,  0,  0,  0,  0,  0,  0,150,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0, 34,220,239, 58,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,126,254,171,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,239, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 11,219,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 84,254,213,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 98,254,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,162,254,209,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 98,254,199,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,238,254, 75,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 98,254,199,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,165,254,195,  4,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0, 66,241,199,  0,  0,  0,  0,  0,  0,  0,  0,  3,167,254,227, 55,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,213, 20,  0,  0,  0,  0,  0, 46,152,202,254,254, 63,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,214,254,204,180,180,180,180,180,235,254,254,234,156, 10,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0, 81,205,254,254,254,254,254,254,254,252,234,120,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0, 26,210,254,254,254,254,254,153,104,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0,}
},
{ // NUMBER: 3
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0, 67,128,188,254,254,255,254,254,181,123, 38,  3,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0, 94,249,251,202,136, 88, 89,136,136,160,230,253,186, 21,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0, 22,235,193, 60,  0,  0,  0,  0,  0,  0,  0, 15, 99,214,205,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0, 88,235, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 65,253, 49,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0, 25,121,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,236, 79,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,107,253, 43,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,118,247,174,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 49,211,249,144,  8,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  2, 20, 62, 98,152,175,242,254,211, 85,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0, 20,253,253,253,254,253,253,253,207, 57,  6,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  9,117,117,117, 63, 51,117,140,236,253,220, 95,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 14, 92,241,253,229, 60,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,121,248,230, 51,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 53,244,203,  3, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,153,253, 19, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,141,253, 19, 0,0,0,0},
    {0,0,0,0, 0,13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,   5, 44,134,254,189,  0, 0,0,0,0},
    {0,0,0,0,16,231,112, 40, 25,  0,  0,  0,  0,  0,  0, 25, 40,100,197,253,208,125, 27,  0, 0,0,0,0},
    {0,0,0,0, 3,168,253,253,239,215,172,136,191,215,215,238,254,253,253,150,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  3, 62,122,175,187,229,253,254,193,175,175, 98, 97, 31,  2,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0},
    {0,0,0,0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0,0,0,0}, 
},
}; // ^^^^^^ (images*(rows*pixels)) = (4*(28*28)) = 3136 Bytes 
unsigned int timestamp;


unsigned int maxOutput(){
  unsigned int maxi=0;
  for (unsigned int i = 0; i < 10; i++)
    if (output[i] > output[maxi])
      maxi = i;
  return maxi;
}


float rowPixels[28]; // Single Row Pixels
void fromProgmemRead(unsigned int image, unsigned int row){
  for (unsigned int pixel = 0; pixel < 28; pixel++)
    rowPixels[pixel] = pgm_read_byte(&handwritten[image][row][pixel]) / 255.0; // normalized between [0,1]
}


void setup()
{
  Serial.begin(9600);
  while (!Serial){ };

  // Creating a NeuralNetwork with pretrained Weights and Biases
  NeuralNetwork NN(layers, weights, biases, NumberOf(layers));

  //Goes through each image
  for (unsigned int image = 0; image < 4; image++){
    timestamp = millis();  
    // Goes through each row (total of [28-Pixel * 28-Rows])     
    for (unsigned int row = 0; row < 28; row++){
      // Offloads image's row-pixels: from progmem to RAM\rowPixels
      fromProgmemRead(image, row);
      // Feedfowards & after all rows: it returns the predicted output(s).
      output = NN.FeedForward(rowPixels); 
    }
    Serial.println((String)"Predicted [" + (maxOutput()) + "] - Under " + (millis() - timestamp) + " milliseconds.");
    NN.resetStates();
  }
}
void loop(){}
