/*
  🎨 [랜덤 ASCII 아트 출력기] 🎨

  📌 [프로그램 설명]
  - 스위치를 누르면 LED가 빠르게 깜빡이며 ASCII 아트를 준비합니다.
  - 스위치를 떼면 시리얼 모니터에 랜덤한 ASCII 아트를 출력합니다.
  - LED는 아트 출력 중 깜빡이며 진행 상황을 표시합니다.
  - 출력이 끝나면 LED가 잠깐 켜졌다 꺼지며 "완료"를 알립니다.

  📌 [사용 환경]
  - 아두이노 보드 또는 ESP32 등의 개발 보드 (내장 버튼 및 LED 포함)
  - 시리얼 모니터(115200 baud) 사용 가능

  ✅ [사용 방법]
  1. 버튼을 누르면 ASCII 아트가 랜덤으로 선택됩니다.
  2. 버튼을 떼면 시리얼 모니터에 선택된 ASCII 아트가 출력됩니다.
  3. LED가 진행 상태를 나타내며, 출력이 끝나면 LED가 잠깐 켜졌다 꺼집니다.
*/

#define sw_Pressed  LOW   // 스위치가 눌린 상태를 LOW로 정의 (내장 풀업 저항 사용)
#define sw_Released HIGH  // 스위치를 뗀 상태를 HIGH로 정의 (내장 풀업 저항 사용)

int numAsciiArts = 0;  // ASCII 아트 개수를 저장할 변수 (초기화)

// ==============================
// 🎨 ASCII 아트 리스트 정의 🎨
// ==============================

/*
  📌 [ASCII 아트 리스트]
  - ASCII 아트를 저장하는 문자열 배열입니다.
  - `const` 키워드를 사용하여 변경되지 않도록 설정합니다.
  - 각 아트는 큰 따옴표(" ") 대신 **`R"( )"`** 형식을 사용하여 여러 줄을 저장합니다.

  📌 [R"( )" 란?]
  - C++의 **"Raw String Literal"** 기능입니다.
  - 큰따옴표를 사용하지 않고 여러 줄의 텍스트를 그대로 저장할 수 있습니다.
  - 이 방식을 사용하면 `\n`, `\"`, `\\` 등의 이스케이프 문자 없이 입력 가능하여 ASCII 아트를 다룰 때 편리합니다.

  예시:
  ```cpp
  const char* example = R"(
    *   *  
     * *   
      *    
     * *   
    *   *
  )";
*/
const char* asciiArts[] = {

  // 1️⃣ 첫 번째 ASCII 아트: 패턴 디자인
  R"(
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=----------------------@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@=----------@@@@@@@@@@@@@@@---------------------------@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@---------------=@@@@@@@@@@@------------------------------@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@-------------------@@@@@@@@@-------------@@@@@-------------=@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@=--------------------@@@@@@@----------@@@@@@@@@@@@@----------@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@----------------------@@@@@:--------=@@@@@@@--@@@@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@=-------@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@=--------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@---------@@@@----------@@@@@-------@@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@---------@@@@@---------@@@@@@@=--@@@@@@@---------@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@=--------.@@@@:----------@@@@@@@@@@@@@=----------@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@---------@@@@@----------------.==--------------@@@@@--------=@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@:---------@@@@@=------------------------------@@@@@---------@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@----------@@@@@@---------------------------=@@@@@---------+@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@=----------@@@@@@-----------------------@@@@@@-----------@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@=----------=@@@@@@@-----------------@@@@@@@-----------=@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@=------------@@@@@@@@@@@@@@@@@@@@@@@@@@-------------=@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@--------------=*@@@@@@@@@@@@@@@@=----------------@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@----------------------------------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@=-----------------------------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@------------------------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-----------------------------=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*-----------------=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
)",

  // 2️⃣ 두 번째 ASCII 아트: 선과 기호 패턴
  R"(
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------============--------===========-----------------------------------
  ------------------------------=+#%@@@@@@@@@@@@%=----+%@@@@@@@@@@@%%*+-------------------------------
  ----------------------------=#@@@@@@@@@@@@@@@@@*----#@@@@@@@@@@@@@@@@%*=----------------------------
  ---------------------------*@@@@@@@@@@@@@@@@@@@*----#@@@@@@@@@@@@@@@@@@@+---------------------------
  --------------------------*@@@@@@@@@@@@@@@@@@@@+----#@@@@@@@@@@@@@@@@@@@@+--------------------------
  -------------------------+@@@@@@@@@@@@@@@@@@@@@+----*@@@@@@@@@@@@@@@@@@@@@=-------------------------
  -------------------------#@@@@@@@@@@@@@@@@@@@@@=----*@@@@@@@@@@@@@@@@@@@@@*-------------------------
  ------------------------=@@@@@@@@@@@@@@@@@@@@@@=----+@@@@@@@@@@@@@@@@@@@@@@=------------------------
  ------------------------#@@@@@@@@@@@@@@@@@@@@@%-----+@@@@@@@@@@@@@@@@@@@@@@*------------------------
  -----------------------=@@@@@@@@@@@@@@@@@@@@@@%-----=@@@@@@@@@@@@@@@@@@@@@@@=-----------------------
  -----------------------#@@@@@@@@@@@@@@@@@@@@@@#-----=@@@@@@@@@@@@@@@@@@@@@@@*-----------------------
  ----------------------=@@@@@@@@@@@@@@@@@@@@@@@#-----=@@@@@@@@@@@@@@@@@@@@@@@@=----------------------
  ----------------------*@@@@@@@@@@@@@@@@@@@@@@@*------%@@@@@@@@@@@@@@@@@@@@@@@*----------------------
  ---------------------=@@@@@@@@@@@@@@@@@@@@@@@@*------%@@@@@@@@@@@@@@@@@@@@@@@@=---------------------
  ---------------------+@@@@@@@@@@@@@@@@@@@@@@@@+------#@@@@@@@@@@@@@@@@@@@@@@@@+---------------------
  ---------------------#@@@@@@@@@@@@@@@@@@@@@@@@*======%@@@@@@@@@@@@@@@@@@@@@@@@#---------------------
  ---------------------#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#---------------------
  ---------------------#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#---------------------
  ---------------------*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*---------------------
  ---------------------=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=---------------------
  ----------------------#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#----------------------
  ----------------------=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=----------------------
  -----------------------+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+-----------------------
  ------------------------+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+------------------------
  -------------------------=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+-------------------------
  --------------------------=#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#=--------------------------
  ----------------------------+%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+----------------------------
  ------------------------------+#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+------------------------------
  --------------------------------=*%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%*=--------------------------------
  -----------------------------------=*#@@@@@@@@@@@@@@@@@@@@@@@@#*=-----------------------------------
  --------------------------------------==+*#%%@@@@@@@@@@%%#*+==--------------------------------------
  ---------------------------------------------==========---------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------

)",

  // 3️⃣ 세 번째 ASCII 아트: 텍스트 기반 아트
  R"(
    _______  _______  _______  __  ___ .______    __       _______ 
  /  _____||   ____||   ____||  |/  / |   _  \  |  |     |   ____|
  |  |  __  |  |__   |  |__   |  '  /  |  |_)  | |  |     |  |__   
  |  | |_ | |   __|  |   __|  |    <   |   _  <  |  |     |   __|  
  |  |__| | |  |____ |  |____ |  .  \  |  |_)  | |  `----.|  |____ 
  \______| |_______||_______||__|\__\ |______/  |_______||_______|
                                                                  
  )",

  // 4️⃣ 네 번째 ASCII 아트: 텍스트 기반 도트 아트
  R"(
      _  _  _  _                                                   _  _  _  _       
    _(_)(_)(_)(_)_                                                (_)(_)(_)(_)      
   (_)          (_)         _  _  _              _  _  _           (_)      (_)_    
   (_)_  _  _  _         _ (_)(_)(_) _        _ (_)(_)(_) _        (_)        (_)   
     (_)(_)(_)(_)_      (_)         (_)      (_)         (_)       (_)        (_)   
    _           (_)     (_)         (_)      (_)         (_)       (_)       _(_)   
   (_)_  _  _  _(_)     (_) _  _  _ (_)      (_) _  _  _ (_)       (_)_  _  (_)     
     (_)(_)(_)(_)          (_)(_)(_)            (_)(_)(_)         (_)(_)(_)(_)      

  )",
  NULL // 마지막 원소는 NULL (배열 종료를 알림) 
};

// ==============================
// 🔧 초기 설정 (setup) 함수
// ==============================
void setup() 
{
  Serial.begin(115200);   // 시리얼 통신 속도를 115200bps로 설정
  pinMode(LED_BUILTIN, OUTPUT);       // 내장 LED를 출력 모드로 설정
  pinMode(SW_BUILTIN, INPUT_PULLUP);  // 내장 스위치를 입력 모드로 설정 (내부 풀업 저항 사용)

  // ==============================
  // 🎯 ASCII 아트 개수 자동 계산
  // ==============================
  while (asciiArts[numAsciiArts] != NULL) 
  {
    numAsciiArts = (numAsciiArts + 1);
  }

  Serial.print("🎨 총 ASCII 아트 개수: ");
  Serial.print(numAsciiArts);
  Serial.print("\n🎨 버튼을 눌러 랜덤 ASCII 아트를 출력하세요!\n");
}

// ==============================
// 🔄 랜덤 ASCII 아트 출력 기능 🔄
// ==============================
void loop() 
{
  // ==========================
  // 🎨 ASCII 아트 선택
  // ==========================
  if (digitalRead(SW_BUILTIN) == sw_Pressed) 
  {  
    Serial.print("🔄 ASCII 아트 생성 중...\n");

    // LED 깜빡이며 준비 상태 표시
    for (int i = 0; i < 5; i = (i + 1)) 
    {  
      digitalWrite(LED_BUILTIN, HIGH);
      delay(100);
      digitalWrite(LED_BUILTIN, LOW);
      delay(100);
    }

    // 버튼을 뗄 때까지 대기
    while (digitalRead(SW_BUILTIN) == sw_Pressed) 
    {  
      ;
    }

    // 랜덤 ASCII 아트 선택
    int randomIndex = random(0, numAsciiArts);

    // ==========================
    // 🎯 선택된 ASCII 아트 출력
    // ==========================
    Serial.print("\n🎨 당신의 랜덤 ASCII 아트:\n");
    Serial.print(asciiArts[randomIndex]);
    Serial.print("\n🔁 다시 버튼을 눌러 다른 아트를 출력하세요!\n");

    // 출력 완료 LED 피드백
    digitalWrite(LED_BUILTIN, HIGH);
    delay(500);
    digitalWrite(LED_BUILTIN, LOW);
  }
}