/*
  🎨 [랜덤 ASCII 아트 출력기] 🎨

  📌 [프로그램 설명]
  - 스위치를 누르면 LED가 빠르게 깜빡이며 ASCII 아트를 준비합니다.
  - 스위치를 떼면 시리얼 모니터에 랜덤한 ASCII 아트를 출력합니다.
  - LED는 아트 출력 중 깜빡이며 진행 상황을 표시합니다.
  - 출력이 끝나면 LED가 잠깐 켜졌다 꺼지며 "완료"를 알립니다.

  📌 [사용 환경]
  - 아두이노 보드 또는 ESP32 등의 개발 보드 (내장 버튼 및 LED 포함)
  - 시리얼 모니터(115200 baud) 사용 가능

  ✅ [사용 방법]
  1. 버튼을 누르면 ASCII 아트가 랜덤으로 선택됩니다.
  2. 버튼을 떼면 시리얼 모니터에 선택된 ASCII 아트가 출력됩니다.
  3. LED가 진행 상태를 나타내며, 출력이 끝나면 LED가 잠깐 켜졌다 꺼집니다.
*/

#define sw_Pressed  LOW  // 스위치가 눌린 상태를 LOW로 정의 (내장 풀업 저항 사용)

void setup() {
  Serial.begin(115200);  // 시리얼 통신 시작
  pinMode(LED_BUILTIN, OUTPUT);  // LED 출력 설정
  pinMode(SW_BUILTIN, INPUT_PULLUP);  // 스위치 입력 (풀업 저항 사용)

  Serial.println("🎨 Press the button to display an ASCII art! 🎨");
}


// ASCII 아트 리스트
const char* asciiArts[] = {
  R"(
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=----------------------@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@=----------@@@@@@@@@@@@@@@---------------------------@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@---------------=@@@@@@@@@@@------------------------------@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@-------------------@@@@@@@@@-------------@@@@@-------------=@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@=--------------------@@@@@@@----------@@@@@@@@@@@@@----------@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@----------------------@@@@@:--------=@@@@@@@--@@@@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@=-------@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@---------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@--------@@@@@---------@@@@@=--------@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@---------@@@@----------@@@@@-------@@@@@@--------@@@@@--------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@---------@@@@@---------@@@@@@@=--@@@@@@@---------@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@=--------.@@@@:----------@@@@@@@@@@@@@=----------@@@@---------@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@---------@@@@@----------------.==--------------@@@@@--------=@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@:---------@@@@@=------------------------------@@@@@---------@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@----------@@@@@@---------------------------=@@@@@---------+@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@=----------@@@@@@-----------------------@@@@@@-----------@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@=----------=@@@@@@@-----------------@@@@@@@-----------=@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@=------------@@@@@@@@@@@@@@@@@@@@@@@@@@-------------=@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@--------------=*@@@@@@@@@@@@@@@@=----------------@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@----------------------------------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@=-----------------------------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@------------------------------------@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@-----------------------------=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*-----------------=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
)",

  R"(
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------============--------===========-----------------------------------
  ------------------------------=+#%@@@@@@@@@@@@%=----+%@@@@@@@@@@@%%*+-------------------------------
  ----------------------------=#@@@@@@@@@@@@@@@@@*----#@@@@@@@@@@@@@@@@%*=----------------------------
  ---------------------------*@@@@@@@@@@@@@@@@@@@*----#@@@@@@@@@@@@@@@@@@@+---------------------------
  --------------------------*@@@@@@@@@@@@@@@@@@@@+----#@@@@@@@@@@@@@@@@@@@@+--------------------------
  -------------------------+@@@@@@@@@@@@@@@@@@@@@+----*@@@@@@@@@@@@@@@@@@@@@=-------------------------
  -------------------------#@@@@@@@@@@@@@@@@@@@@@=----*@@@@@@@@@@@@@@@@@@@@@*-------------------------
  ------------------------=@@@@@@@@@@@@@@@@@@@@@@=----+@@@@@@@@@@@@@@@@@@@@@@=------------------------
  ------------------------#@@@@@@@@@@@@@@@@@@@@@%-----+@@@@@@@@@@@@@@@@@@@@@@*------------------------
  -----------------------=@@@@@@@@@@@@@@@@@@@@@@%-----=@@@@@@@@@@@@@@@@@@@@@@@=-----------------------
  -----------------------#@@@@@@@@@@@@@@@@@@@@@@#-----=@@@@@@@@@@@@@@@@@@@@@@@*-----------------------
  ----------------------=@@@@@@@@@@@@@@@@@@@@@@@#-----=@@@@@@@@@@@@@@@@@@@@@@@@=----------------------
  ----------------------*@@@@@@@@@@@@@@@@@@@@@@@*------%@@@@@@@@@@@@@@@@@@@@@@@*----------------------
  ---------------------=@@@@@@@@@@@@@@@@@@@@@@@@*------%@@@@@@@@@@@@@@@@@@@@@@@@=---------------------
  ---------------------+@@@@@@@@@@@@@@@@@@@@@@@@+------#@@@@@@@@@@@@@@@@@@@@@@@@+---------------------
  ---------------------#@@@@@@@@@@@@@@@@@@@@@@@@*======%@@@@@@@@@@@@@@@@@@@@@@@@#---------------------
  ---------------------#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#---------------------
  ---------------------#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#---------------------
  ---------------------*@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@*---------------------
  ---------------------=@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=---------------------
  ----------------------#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#----------------------
  ----------------------=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@=----------------------
  -----------------------+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+-----------------------
  ------------------------+@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@+------------------------
  -------------------------=%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+-------------------------
  --------------------------=#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@#=--------------------------
  ----------------------------+%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+----------------------------
  ------------------------------+#@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%+------------------------------
  --------------------------------=*%@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@%*=--------------------------------
  -----------------------------------=*#@@@@@@@@@@@@@@@@@@@@@@@@#*=-----------------------------------
  --------------------------------------==+*#%%@@@@@@@@@@%%#*+==--------------------------------------
  ---------------------------------------------==========---------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------
  ----------------------------------------------------------------------------------------------------

)",

  R"(
    SooDragon
    @Geekble Since 2011
    Hello Makers!
  )"
};



const int numAsciiArts = sizeof(asciiArts) / sizeof(asciiArts[0]);  // 총 아트 개수

void loop() {
  if (digitalRead(SW_BUILTIN) == sw_Pressed) {
    Serial.println("🔄 Generating ASCII Art...");

    // LED 깜빡이며 준비 상태 표시
    for (int i = 0; i < 5; i++) {
      digitalWrite(LED_BUILTIN, HIGH);
      delay(100);
      digitalWrite(LED_BUILTIN, LOW);
      delay(100);
    }

    // 버튼을 뗄 때까지 대기
    while (digitalRead(SW_BUILTIN) == sw_Pressed);

    // 랜덤 ASCII 아트 선택
    int randomIndex = random(0, numAsciiArts);
    
    // 시리얼 모니터에 ASCII 아트 출력
    Serial.println("\n🎨 Your ASCII Art:");
    Serial.println(asciiArts[randomIndex]);
    Serial.println("\n🔁 Press again for another one!\n");

    // 출력 완료 LED 피드백
    digitalWrite(LED_BUILTIN, HIGH);
    delay(500);
    digitalWrite(LED_BUILTIN, LOW);
  }
}