/*******************************************************************************
 * Size: 48 px
 * Bpp: 1
 * Opts: --bpp 1 --size 48 --stride 1 --align 1 --font FZYTK.TTF --range 32-127,160-255,8192-8303,12288-12351,65280-65519,19968-40869 --format lvgl -o fzytk48.c
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
    #include "lvgl.h"
#else
    #include "lvgl/lvgl.h"
#endif



#ifndef FZYTK48
#define FZYTK48 1
#endif

#if FZYTK48

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */
    0x0,

    /* U+0021 "!" */
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77,
    0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x0, 0x0,
    0xff, 0xff, 0xf0,

    /* U+0022 "\"" */
    0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3,
    0xe3, 0xe3, 0xe3,

    /* U+0023 "#" */
    0x0, 0x6, 0x1c, 0x0, 0xe, 0x1c, 0x0, 0xe,
    0x18, 0x0, 0xc, 0x38, 0x0, 0x1c, 0x38, 0x0,
    0x1c, 0x38, 0x0, 0x1c, 0x30, 0x0, 0x38, 0x70,
    0x0, 0x38, 0x70, 0x0, 0x38, 0x60, 0x0, 0x30,
    0xe0, 0x0, 0x70, 0xe0, 0x0, 0x70, 0xe0, 0x1f,
    0xff, 0xff, 0x1f, 0xff, 0xfe, 0x1f, 0xff, 0xfe,
    0x0, 0xe1, 0x80, 0x0, 0xc1, 0x80, 0x1, 0xc3,
    0x80, 0x1, 0xc3, 0x80, 0x1, 0x83, 0x0, 0x3,
    0x87, 0x0, 0x7f, 0xff, 0xf8, 0x7f, 0xff, 0xf8,
    0xff, 0xff, 0xf8, 0x7, 0xe, 0x0, 0x7, 0xc,
    0x0, 0x6, 0x1c, 0x0, 0xe, 0x1c, 0x0, 0xe,
    0x18, 0x0, 0xc, 0x38, 0x0, 0x1c, 0x38, 0x0,
    0x1c, 0x30, 0x0, 0x18, 0x30, 0x0, 0x38, 0x70,
    0x0, 0x38, 0x70, 0x0, 0x30, 0x60, 0x0,

    /* U+0024 "$" */
    0x0, 0x30, 0x0, 0x0, 0xc0, 0x0, 0x3, 0x0,
    0x0, 0xc, 0x0, 0x3, 0xfe, 0x0, 0x3f, 0xfe,
    0x1, 0xff, 0xfc, 0xf, 0xcc, 0xf8, 0x3c, 0x31,
    0xe0, 0xf0, 0xc7, 0xc7, 0x83, 0xf, 0x1e, 0xc,
    0x3c, 0x78, 0x30, 0xf1, 0xe0, 0xc0, 0x7, 0x83,
    0x0, 0x1e, 0xc, 0x0, 0x3c, 0x30, 0x0, 0xf8,
    0xc0, 0x1, 0xfb, 0x0, 0x7, 0xfc, 0x0, 0xf,
    0xf8, 0x0, 0xf, 0xf8, 0x0, 0x1f, 0xf8, 0x0,
    0x1f, 0xf0, 0x0, 0x3f, 0xe0, 0x0, 0xcf, 0xc0,
    0x3, 0x1f, 0x0, 0xc, 0x3e, 0x0, 0x30, 0xf9,
    0xc0, 0xc1, 0xe7, 0x3, 0x7, 0x9c, 0xc, 0x1e,
    0x70, 0x30, 0x79, 0xc0, 0xc1, 0xe7, 0x83, 0x7,
    0x9e, 0xc, 0x3c, 0x3c, 0x30, 0xf0, 0xf8, 0xcf,
    0x81, 0xff, 0xfe, 0x3, 0xff, 0xf0, 0x3, 0xfe,
    0x0, 0x0, 0xc0, 0x0, 0x3, 0x0, 0x0, 0xc,
    0x0, 0x0, 0x30, 0x0, 0x0, 0xc0, 0x0,

    /* U+0025 "%" */
    0x0, 0x0, 0x1, 0xc0, 0x3, 0xf0, 0x0, 0x70,
    0x3, 0xfe, 0x0, 0x18, 0x1, 0xff, 0xc0, 0xe,
    0x0, 0x78, 0xf0, 0x3, 0x0, 0x3c, 0x1e, 0x1,
    0xc0, 0xe, 0x3, 0x80, 0x60, 0x3, 0x80, 0xe0,
    0x38, 0x0, 0xe0, 0x38, 0xe, 0x0, 0x38, 0xe,
    0x3, 0x0, 0xe, 0x3, 0x81, 0xc0, 0x3, 0x80,
    0xe0, 0x60, 0x0, 0xe0, 0x38, 0x38, 0x0, 0x3c,
    0x1e, 0xc, 0x0, 0x7, 0x8f, 0x7, 0x0, 0x1,
    0xff, 0xc1, 0xc0, 0x0, 0x3f, 0xe0, 0x60, 0x0,
    0x3, 0xf0, 0x38, 0x0, 0x0, 0x0, 0xc, 0x0,
    0x0, 0x0, 0x7, 0x1, 0xf0, 0x0, 0x1, 0x81,
    0xff, 0x0, 0x0, 0xe0, 0xff, 0xe0, 0x0, 0x30,
    0x3c, 0x78, 0x0, 0x1c, 0xe, 0xf, 0x0, 0x7,
    0x7, 0x3, 0xc0, 0x1, 0x81, 0xc0, 0x70, 0x0,
    0xe0, 0x70, 0x1c, 0x0, 0x30, 0x1c, 0x7, 0x0,
    0x1c, 0x7, 0x1, 0xc0, 0x6, 0x1, 0xc0, 0x70,
    0x3, 0x80, 0x70, 0x1c, 0x0, 0xe0, 0x1c, 0x7,
    0x0, 0x30, 0x3, 0x83, 0x80, 0x1c, 0x0, 0xf1,
    0xe0, 0x6, 0x0, 0x3f, 0xf0, 0x3, 0x80, 0x7,
    0xf8, 0x0, 0xc0, 0x0, 0x7c, 0x0,

    /* U+0026 "&" */
    0x0, 0xfc, 0x0, 0x0, 0xff, 0xc0, 0x0, 0x7f,
    0xf8, 0x0, 0x1f, 0x1e, 0x0, 0xf, 0x87, 0xc0,
    0x3, 0xc0, 0xf0, 0x0, 0xf0, 0x3c, 0x0, 0x3c,
    0xf, 0x0, 0xf, 0x3, 0xc0, 0x3, 0xc1, 0xf0,
    0x0, 0xf8, 0x78, 0x0, 0x1e, 0x3e, 0x0, 0x7,
    0xcf, 0x0, 0x0, 0xff, 0x80, 0x0, 0x1f, 0xc0,
    0x0, 0x7, 0xe0, 0x0, 0x1, 0xf0, 0x0, 0x1,
    0xfe, 0x0, 0x0, 0xff, 0x80, 0x0, 0x7c, 0xf0,
    0x0, 0x3e, 0x1e, 0xf, 0xf, 0x7, 0x83, 0xc7,
    0x80, 0xf0, 0xf1, 0xe0, 0x3e, 0x3c, 0xf0, 0x7,
    0x8f, 0x3c, 0x0, 0xf7, 0x8f, 0x0, 0x3f, 0xe3,
    0xc0, 0x7, 0xf8, 0xf0, 0x0, 0xfe, 0x3c, 0x0,
    0x3f, 0xf, 0x0, 0x7, 0x81, 0xe0, 0x1, 0xf0,
    0x7c, 0x0, 0xfe, 0x1f, 0x80, 0xff, 0xc3, 0xff,
    0xff, 0xf8, 0x7f, 0xfe, 0x3e, 0x7, 0xfe, 0x7,
    0xc0, 0x8, 0x0, 0x0,

    /* U+0027 "'" */
    0xff, 0xff, 0xff, 0xff, 0x80,

    /* U+0028 "(" */
    0x0, 0xc0, 0x38, 0xe, 0x1, 0xc0, 0x70, 0x1e,
    0x3, 0x80, 0xf0, 0x1c, 0x3, 0x80, 0xf0, 0x1c,
    0x3, 0x80, 0xf0, 0x1e, 0x3, 0x80, 0x70, 0x1e,
    0x3, 0xc0, 0x78, 0xf, 0x1, 0xe0, 0x3c, 0x7,
    0x80, 0xf0, 0x1e, 0x3, 0xc0, 0x78, 0x7, 0x80,
    0xf0, 0x1e, 0x1, 0xc0, 0x38, 0x7, 0x80, 0x70,
    0xf, 0x0, 0xe0, 0x1c, 0x1, 0xc0, 0x38, 0x3,
    0x80, 0x38, 0x7, 0x0,

    /* U+0029 ")" */
    0xe0, 0x38, 0x7, 0x1, 0xc0, 0x38, 0xf, 0x1,
    0xc0, 0x78, 0xe, 0x3, 0x80, 0xf0, 0x1c, 0x7,
    0x1, 0xe0, 0x78, 0x1e, 0x3, 0x80, 0xf0, 0x3c,
    0xf, 0x3, 0xc0, 0xf0, 0x3c, 0xf, 0x3, 0xc0,
    0xf0, 0x3c, 0xe, 0x7, 0x81, 0xe0, 0x78, 0x1c,
    0x7, 0x3, 0xc0, 0xe0, 0x38, 0x1c, 0x7, 0x3,
    0x80, 0xe0, 0x70, 0x1c, 0xe, 0x0,

    /* U+002A "*" */
    0x3, 0x0, 0xc, 0x0, 0x30, 0x0, 0xc0, 0xc3,
    0xf, 0xcd, 0xf7, 0xff, 0xc7, 0xf8, 0x7, 0x80,
    0x3f, 0x1, 0xdc, 0x6, 0x38, 0x38, 0x70, 0xc1,
    0xc0, 0x0, 0x0,

    /* U+002B "+" */
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0,

    /* U+002C "," */
    0xff, 0xff, 0xf3, 0x33, 0x7e, 0xc8,

    /* U+002D "-" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+002E "." */
    0xff, 0xff, 0xf0,

    /* U+002F "/" */
    0x0, 0x1c, 0x0, 0x60, 0x3, 0x80, 0xe, 0x0,
    0x38, 0x1, 0xc0, 0x7, 0x0, 0x1c, 0x0, 0x60,
    0x3, 0x80, 0xe, 0x0, 0x30, 0x1, 0xc0, 0x7,
    0x0, 0x18, 0x0, 0xe0, 0x3, 0x80, 0xe, 0x0,
    0x30, 0x1, 0xc0, 0x7, 0x0, 0x18, 0x0, 0xe0,
    0x3, 0x80, 0xc, 0x0, 0x70, 0x1, 0xc0, 0x6,
    0x0, 0x18, 0x0, 0xe0, 0x3, 0x80, 0xc, 0x0,
    0x70, 0x1, 0xc0, 0x6, 0x0, 0x18, 0x0, 0xe0,
    0x3, 0x0, 0x0,

    /* U+0030 "0" */
    0x1, 0xf8, 0x0, 0x7f, 0xe0, 0xf, 0xff, 0x1,
    0xff, 0xf8, 0x1f, 0xf, 0x83, 0xe0, 0x7c, 0x3c,
    0x3, 0xc7, 0xc0, 0x1e, 0x78, 0x1, 0xe7, 0x80,
    0x1e, 0x78, 0x1, 0xef, 0x80, 0xe, 0xf0, 0x0,
    0xff, 0x0, 0xf, 0xf0, 0x0, 0xff, 0x0, 0xf,
    0xf0, 0x0, 0xff, 0x0, 0xf, 0xf8, 0x0, 0xff,
    0x0, 0xf, 0xf0, 0x0, 0xff, 0x0, 0xf, 0xf0,
    0x0, 0xff, 0x0, 0xf, 0xf0, 0x0, 0xff, 0x0,
    0xf, 0x70, 0x0, 0xe7, 0x0, 0x1e, 0x78, 0x1,
    0xe7, 0x80, 0x1e, 0x78, 0x1, 0xe3, 0xc0, 0x3c,
    0x3c, 0x3, 0xc1, 0xe0, 0x78, 0xf, 0xbf, 0x0,
    0xff, 0xf0, 0x3, 0xfc, 0x0, 0x4, 0x0,

    /* U+0031 "1" */
    0x0, 0x70, 0x7, 0x0, 0xf0, 0xf, 0x1, 0xf0,
    0x3f, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,

    /* U+0032 "2" */
    0x3, 0xf8, 0x0, 0xff, 0xe0, 0x1f, 0xff, 0x83,
    0xe0, 0xf8, 0x7c, 0x3, 0xc7, 0x80, 0x3c, 0xf8,
    0x1, 0xef, 0x0, 0x1e, 0xf0, 0x1, 0xef, 0x0,
    0x1e, 0xf0, 0x1, 0xef, 0x0, 0x1e, 0x0, 0x1,
    0xe0, 0x0, 0x3e, 0x0, 0x3, 0xc0, 0x0, 0x7c,
    0x0, 0x7, 0x80, 0x0, 0xf8, 0x0, 0x1f, 0x0,
    0x3, 0xe0, 0x0, 0x7e, 0x0, 0xf, 0xc0, 0x1,
    0xf8, 0x0, 0x3f, 0x0, 0x7, 0xc0, 0x0, 0xf8,
    0x0, 0x1f, 0x0, 0x3, 0xe0, 0x0, 0x7c, 0x0,
    0x7, 0x80, 0x0, 0x78, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+0033 "3" */
    0x1, 0xfc, 0x0, 0x7f, 0xf0, 0x1f, 0xff, 0x81,
    0xf0, 0xfc, 0x3e, 0x3, 0xc3, 0xc0, 0x3e, 0x7c,
    0x1, 0xe7, 0x80, 0x1e, 0x78, 0x1, 0xe7, 0x80,
    0x1e, 0x78, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0x1,
    0xe0, 0x0, 0x3c, 0x0, 0x7, 0xc0, 0x0, 0xf8,
    0x0, 0xff, 0x0, 0xf, 0xc0, 0x0, 0xff, 0x80,
    0xf, 0xfc, 0x0, 0x7, 0xe0, 0x0, 0x3e, 0x0,
    0x1, 0xf0, 0x0, 0x1f, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0xf8, 0x0, 0xf7, 0x80, 0xf, 0x78, 0x0,
    0xf7, 0x80, 0xf, 0x78, 0x0, 0xf7, 0x80, 0x1e,
    0x3c, 0x1, 0xe3, 0xe0, 0x3c, 0x1f, 0xff, 0xc0,
    0xff, 0xf8, 0x7, 0xfe, 0x0, 0x6, 0x0,

    /* U+0034 "4" */
    0x0, 0x7, 0x80, 0x0, 0x78, 0x0, 0xf, 0x80,
    0x1, 0xf8, 0x0, 0x1f, 0x80, 0x3, 0xf8, 0x0,
    0x3f, 0x80, 0x7, 0x78, 0x0, 0x77, 0x80, 0xe,
    0x78, 0x1, 0xe7, 0x80, 0x1c, 0x78, 0x3, 0xc7,
    0x80, 0x38, 0x78, 0x7, 0x7, 0x80, 0x70, 0x78,
    0xe, 0x7, 0x80, 0xe0, 0x78, 0x1c, 0x7, 0x83,
    0xc0, 0x78, 0x38, 0x7, 0x87, 0x80, 0x78, 0x70,
    0x7, 0x8e, 0x0, 0x78, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x78, 0x0, 0x7,
    0x80, 0x0, 0x78, 0x0, 0x7, 0x80, 0x0, 0x78,
    0x0, 0x7, 0x80, 0x0, 0x78, 0x0, 0x7, 0x80,
    0x0, 0x78, 0x0, 0x7, 0x80,

    /* U+0035 "5" */
    0x1f, 0xff, 0xc3, 0xff, 0xf8, 0x7f, 0xff, 0x1e,
    0x0, 0x3, 0xc0, 0x0, 0x78, 0x0, 0xf, 0x0,
    0x1, 0xc0, 0x0, 0x38, 0x0, 0x7, 0x0, 0x0,
    0xe0, 0x0, 0x1c, 0x0, 0x7, 0x9f, 0x80, 0xef,
    0xfc, 0x1f, 0xff, 0xe3, 0xf0, 0x7c, 0x78, 0x7,
    0xcf, 0x0, 0x79, 0xc0, 0xf, 0x0, 0x1, 0xf0,
    0x0, 0x1e, 0x0, 0x3, 0xc0, 0x0, 0x78, 0x0,
    0xf, 0x0, 0x1, 0xe0, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x3f, 0xe0, 0x7, 0x9e,
    0x0, 0xf3, 0xe0, 0x3c, 0x3e, 0xf, 0x87, 0xff,
    0xe0, 0x3f, 0xf8, 0x1, 0xfc, 0x0,

    /* U+0036 "6" */
    0x0, 0xfc, 0x0, 0x3f, 0xf0, 0x7, 0xff, 0x80,
    0xf0, 0xfc, 0x1e, 0x3, 0xc1, 0xc0, 0x3e, 0x38,
    0x1, 0xe3, 0x80, 0x1e, 0x78, 0x1, 0xe7, 0x80,
    0x0, 0x70, 0x0, 0x7, 0x0, 0x0, 0x70, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0xfc, 0xf, 0x3f, 0xf0,
    0xf7, 0xff, 0x8f, 0xe0, 0xfc, 0xfc, 0x3, 0xef,
    0x80, 0x1e, 0xf8, 0x1, 0xef, 0x0, 0xf, 0xf0,
    0x0, 0xff, 0x0, 0xf, 0xf0, 0x0, 0xff, 0x0,
    0xf, 0xf0, 0x0, 0xf7, 0x0, 0xf, 0x70, 0x0,
    0xf7, 0x80, 0xf, 0x78, 0x1, 0xe3, 0x80, 0x1e,
    0x3c, 0x3, 0xe1, 0xe0, 0x7c, 0xf, 0xff, 0xc0,
    0x7f, 0xf8, 0x3, 0xfe, 0x0, 0x3, 0x0,

    /* U+0037 "7" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0xf, 0x0, 0x0, 0xe0, 0x0, 0x1c, 0x0,
    0x3, 0xc0, 0x0, 0x38, 0x0, 0x7, 0x0, 0x0,
    0xf0, 0x0, 0xe, 0x0, 0x1, 0xe0, 0x0, 0x1c,
    0x0, 0x3, 0xc0, 0x0, 0x38, 0x0, 0x7, 0x80,
    0x0, 0x78, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xe, 0x0, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0x3,
    0xc0, 0x0, 0x3c, 0x0, 0x3, 0xc0, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x0, 0x78, 0x0, 0x7, 0x80,
    0x0, 0x78, 0x0, 0xf, 0x80, 0x0, 0xf8, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0,

    /* U+0038 "8" */
    0x3, 0xf8, 0x1, 0xff, 0xc0, 0x7f, 0xfc, 0x1f,
    0x7, 0xc3, 0xc0, 0x78, 0xf8, 0xf, 0x9e, 0x0,
    0xf3, 0xc0, 0x1e, 0x78, 0x3, 0xcf, 0x0, 0x79,
    0xe0, 0xf, 0x3c, 0x1, 0xe3, 0x80, 0x3c, 0x78,
    0xf, 0x7, 0x1, 0xe0, 0x78, 0x78, 0x3, 0xfe,
    0x0, 0xff, 0x80, 0x7f, 0xfc, 0x1f, 0x7, 0xc7,
    0xc0, 0x7c, 0xf0, 0x7, 0xbc, 0x0, 0xff, 0x80,
    0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x1f, 0xe0, 0x3, 0xfe,
    0x0, 0xf3, 0xc0, 0x1e, 0x7c, 0x7, 0xc7, 0xc1,
    0xf0, 0x7f, 0xfe, 0x7, 0xff, 0x0, 0x3f, 0x80,

    /* U+0039 "9" */
    0x1, 0xf8, 0x0, 0x7f, 0xe0, 0xf, 0xff, 0x1,
    0xff, 0xf8, 0x3e, 0xf, 0xc7, 0xc0, 0x3c, 0x78,
    0x1, 0xc7, 0x80, 0x1e, 0xf0, 0x1, 0xef, 0x0,
    0xe, 0xf0, 0x0, 0xff, 0x0, 0xf, 0xf0, 0x0,
    0xff, 0x0, 0xf, 0xf0, 0x0, 0xff, 0x0, 0xf,
    0xf0, 0x0, 0xff, 0x80, 0x1f, 0x78, 0x1, 0xf7,
    0xc0, 0x3f, 0x7e, 0x7, 0xf3, 0xff, 0xff, 0x1f,
    0xfe, 0xf0, 0xff, 0xcf, 0x3, 0xf0, 0xf0, 0x0,
    0xe, 0x0, 0x0, 0xe0, 0x0, 0xe, 0x0, 0x1,
    0xe7, 0x80, 0x1c, 0x78, 0x1, 0xc7, 0x80, 0x3c,
    0x7c, 0x3, 0x83, 0xe0, 0x78, 0x3f, 0xff, 0x1,
    0xff, 0xe0, 0xf, 0xf8, 0x0, 0x8, 0x0,

    /* U+003A ":" */
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf0,

    /* U+003B ";" */
    0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xf3, 0x33, 0x7e,
    0xc8,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x70,
    0x0, 0x1f, 0x0, 0x7, 0xe0, 0x1, 0xfc, 0x0,
    0x3f, 0x0, 0xf, 0xc0, 0x3, 0xf0, 0x0, 0xfe,
    0x0, 0x1f, 0x80, 0x7, 0xe0, 0x0, 0xf8, 0x0,
    0xf, 0x0, 0x0, 0xf8, 0x0, 0x7, 0xe0, 0x0,
    0x1f, 0x80, 0x0, 0xfe, 0x0, 0x3, 0xf0, 0x0,
    0xf, 0xc0, 0x0, 0x3f, 0x0, 0x0, 0xfc, 0x0,
    0x7, 0xe0, 0x0, 0x1f, 0x0, 0x0, 0x70, 0x0,
    0x1,

    /* U+003D "=" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+003E ">" */
    0x0, 0x0, 0xc, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x80, 0x0, 0x7e, 0x0, 0x3, 0xf8, 0x0, 0xf,
    0xc0, 0x0, 0x3f, 0x0, 0x0, 0xfc, 0x0, 0x7,
    0xf0, 0x0, 0x1f, 0x80, 0x0, 0x7e, 0x0, 0x3,
    0xf0, 0x0, 0xf, 0x0, 0x1, 0xf0, 0x0, 0x7e,
    0x0, 0x1f, 0x80, 0x7, 0xf0, 0x0, 0xfc, 0x0,
    0x3f, 0x0, 0xf, 0xc0, 0x3, 0xf0, 0x0, 0x7e,
    0x0, 0xf, 0x80, 0x0, 0xe0, 0x0, 0x8, 0x0,
    0x0,

    /* U+003F "?" */
    0x3, 0xfc, 0x1, 0xff, 0xe0, 0x7f, 0xfe, 0x1f,
    0x7, 0xe7, 0xc0, 0x3c, 0xf0, 0x7, 0xde, 0x0,
    0x7f, 0x80, 0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f,
    0xc0, 0x7, 0x80, 0x0, 0xf0, 0x0, 0x3c, 0x0,
    0x7, 0x80, 0x1, 0xf0, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x3, 0xe0, 0x0, 0xf8, 0x0, 0x3e, 0x0,
    0x7, 0x80, 0x1, 0xf0, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0x7, 0x80,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x0, 0xf0, 0x0, 0x1e, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x1, 0xff, 0xf8,
    0x0, 0x0, 0xfe, 0x3f, 0xc0, 0x0, 0x7c, 0x0,
    0x7c, 0x0, 0x1e, 0x0, 0x3, 0xc0, 0x7, 0x0,
    0x0, 0x1c, 0x1, 0xc0, 0x0, 0x1, 0xc0, 0x70,
    0x0, 0x0, 0x1c, 0xc, 0x0, 0xfe, 0x39, 0x83,
    0x0, 0x7f, 0xef, 0x38, 0xe0, 0x3f, 0xff, 0xc3,
    0x18, 0xf, 0x81, 0xf8, 0x63, 0x3, 0xe0, 0x3f,
    0xe, 0xc0, 0x78, 0x3, 0xc0, 0xd8, 0x1e, 0x0,
    0x78, 0x1b, 0x3, 0xc0, 0xf, 0x3, 0x60, 0xf0,
    0x3, 0xc0, 0x68, 0x1e, 0x0, 0x78, 0xf, 0x3,
    0xc0, 0xf, 0x1, 0xe0, 0xf0, 0x3, 0xc0, 0x34,
    0x1e, 0x0, 0x78, 0xc, 0xc3, 0xc0, 0xf, 0x1,
    0x98, 0x78, 0x3, 0xc0, 0x73, 0xf, 0x0, 0x78,
    0xc, 0x61, 0xe0, 0x1f, 0x3, 0x86, 0x3e, 0x7,
    0xc0, 0xe0, 0xc3, 0xe1, 0xf8, 0x38, 0x1c, 0x7f,
    0xff, 0x8f, 0x1, 0x87, 0xfe, 0xff, 0xc0, 0x38,
    0x3f, 0xf, 0xe3, 0x83, 0x80, 0x0, 0xf0, 0xe0,
    0x38, 0x0, 0x0, 0x38, 0x3, 0x80, 0x0, 0xe,
    0x0, 0x38, 0x0, 0x3, 0x80, 0x3, 0xc0, 0x1,
    0xc0, 0x0, 0x1f, 0x80, 0xf0, 0x0, 0x0, 0x3f,
    0xf0, 0x0,

    /* U+0041 "A" */
    0x0, 0x3e, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x1f,
    0xc0, 0x0, 0xf, 0xe0, 0x0, 0x7, 0x70, 0x0,
    0x7, 0xbc, 0x0, 0x3, 0x9e, 0x0, 0x1, 0xcf,
    0x0, 0x1, 0xe3, 0x80, 0x0, 0xf1, 0xe0, 0x0,
    0x78, 0xf0, 0x0, 0x38, 0x78, 0x0, 0x3c, 0x1e,
    0x0, 0x1e, 0xf, 0x0, 0xf, 0x7, 0x80, 0x7,
    0x3, 0xc0, 0x7, 0x81, 0xf0, 0x3, 0xc0, 0x78,
    0x1, 0xe0, 0x3c, 0x1, 0xe0, 0x1e, 0x0, 0xf0,
    0xf, 0x80, 0x78, 0x3, 0xc0, 0x3c, 0x1, 0xe0,
    0x3f, 0xff, 0xf8, 0x1f, 0xff, 0xfc, 0xf, 0xff,
    0xfe, 0xf, 0x0, 0xf, 0x7, 0x80, 0x7, 0xc3,
    0xc0, 0x1, 0xe1, 0xe0, 0x0, 0xf1, 0xe0, 0x0,
    0x78, 0xf0, 0x0, 0x3e, 0x78, 0x0, 0xf, 0x3c,
    0x0, 0x7, 0xbc, 0x0, 0x3, 0xfe, 0x0, 0x1,
    0xff, 0x0, 0x0, 0x78,

    /* U+0042 "B" */
    0xff, 0xfc, 0xf, 0xff, 0xf0, 0xff, 0xff, 0x8f,
    0x1, 0xfc, 0xf0, 0x7, 0xcf, 0x0, 0x3e, 0xf0,
    0x1, 0xef, 0x0, 0x1e, 0xf0, 0x1, 0xef, 0x0,
    0x1e, 0xf0, 0x1, 0xef, 0x0, 0x1e, 0xf0, 0x1,
    0xef, 0x0, 0x3c, 0xf0, 0x3, 0xcf, 0x0, 0xf8,
    0xff, 0xfe, 0xf, 0xff, 0xe0, 0xff, 0xff, 0x8f,
    0x0, 0xfc, 0xf0, 0x3, 0xef, 0x0, 0x1e, 0xf0,
    0x1, 0xff, 0x0, 0xf, 0xf0, 0x0, 0xff, 0x0,
    0xf, 0xf0, 0x0, 0xff, 0x0, 0xf, 0xf0, 0x0,
    0xff, 0x0, 0xf, 0xf0, 0x1, 0xef, 0x0, 0x1e,
    0xf0, 0x3, 0xef, 0x0, 0x7c, 0xff, 0xff, 0x8f,
    0xff, 0xf0, 0xff, 0xfc, 0x0,

    /* U+0043 "C" */
    0x0, 0x0, 0x0, 0x7, 0xfe, 0x0, 0x7f, 0xfe,
    0x3, 0xff, 0xfc, 0x1f, 0x1, 0xf0, 0x78, 0x3,
    0xe3, 0xc0, 0x7, 0x8f, 0x0, 0x1f, 0x78, 0x0,
    0x3d, 0xe0, 0x0, 0xf7, 0x80, 0x3, 0xde, 0x0,
    0xf, 0xf0, 0x0, 0x3, 0xc0, 0x0, 0xf, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0xf0, 0x0, 0x3, 0xc0,
    0x0, 0xf, 0x0, 0x0, 0x3c, 0x0, 0x0, 0xf0,
    0x0, 0x3, 0xc0, 0x0, 0xf, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0xf0, 0x0, 0x3, 0xc0, 0x0, 0xf7,
    0x80, 0x3, 0xde, 0x0, 0xf, 0x78, 0x0, 0x3d,
    0xe0, 0x1, 0xf3, 0xc0, 0x7, 0x8f, 0x0, 0x1e,
    0x3e, 0x0, 0xf8, 0x78, 0x3, 0xe0, 0xf0, 0x1f,
    0x3, 0xff, 0xf8, 0x3, 0xff, 0xc0, 0x7, 0xfe,
    0x0, 0x1, 0x80, 0x0,

    /* U+0044 "D" */
    0xff, 0xfc, 0x1, 0xff, 0xfe, 0x3, 0xff, 0xff,
    0x7, 0x80, 0x3f, 0xf, 0x0, 0x1f, 0x1e, 0x0,
    0x1e, 0x3c, 0x0, 0x1e, 0x78, 0x0, 0x3c, 0xf0,
    0x0, 0x3d, 0xe0, 0x0, 0x7b, 0xc0, 0x0, 0xf7,
    0x80, 0x0, 0xef, 0x0, 0x1, 0xfe, 0x0, 0x3,
    0xfc, 0x0, 0x7, 0xf8, 0x0, 0xf, 0xf0, 0x0,
    0x1f, 0xe0, 0x0, 0x3f, 0xc0, 0x0, 0x7f, 0x80,
    0x0, 0xff, 0x0, 0x1, 0xfe, 0x0, 0x3, 0xfc,
    0x0, 0x7, 0xf8, 0x0, 0xf, 0xf0, 0x0, 0x3f,
    0xe0, 0x0, 0x7b, 0xc0, 0x0, 0xf7, 0x80, 0x1,
    0xef, 0x0, 0x7, 0xde, 0x0, 0xf, 0x3c, 0x0,
    0x3e, 0x78, 0x0, 0x7c, 0xf0, 0x1, 0xf1, 0xe0,
    0xf, 0xc3, 0xff, 0xff, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xe0, 0x0,

    /* U+0045 "E" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x3, 0xc0, 0x0, 0xff, 0xff, 0xbf, 0xff,
    0xef, 0xff, 0xfb, 0xc0, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0,
    0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0,

    /* U+0046 "F" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0,
    0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1, 0xe0,
    0x0, 0xf0, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1,
    0xe0, 0x0, 0xff, 0xff, 0x7f, 0xff, 0xbf, 0xff,
    0xde, 0x0, 0xf, 0x0, 0x7, 0x80, 0x3, 0xc0,
    0x1, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x3c,
    0x0, 0x1e, 0x0, 0xf, 0x0, 0x7, 0x80, 0x3,
    0xc0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x0,
    0x3c, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x8, 0x0, 0x3, 0xff, 0x80, 0xf, 0xff,
    0x80, 0x7f, 0xff, 0xc0, 0xf8, 0xf, 0x83, 0xe0,
    0xf, 0x8f, 0x80, 0xf, 0x1e, 0x0, 0x1f, 0x7c,
    0x0, 0x1e, 0xf0, 0x0, 0x3d, 0xe0, 0x0, 0x7b,
    0xc0, 0x0, 0xff, 0x80, 0x0, 0x1e, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf0, 0x0,
    0x1, 0xe0, 0x0, 0x3, 0xc0, 0x0, 0x7, 0x80,
    0xff, 0xff, 0x1, 0xff, 0xfe, 0x3, 0xff, 0xfc,
    0x7, 0xff, 0xf8, 0x0, 0xf, 0xf0, 0x0, 0x1f,
    0xe0, 0x0, 0x3f, 0xc0, 0x0, 0x7b, 0xc0, 0x0,
    0xf7, 0x80, 0x1, 0xef, 0x0, 0x7, 0xde, 0x0,
    0xf, 0x9e, 0x0, 0x1f, 0x3c, 0x0, 0x7e, 0x3c,
    0x0, 0xdc, 0x7c, 0x3, 0xb8, 0x7f, 0x3e, 0x70,
    0x7f, 0xfc, 0xe0, 0x3f, 0xe1, 0xc0, 0x4, 0x0,
    0x0,

    /* U+0048 "H" */
    0xf0, 0x0, 0x3f, 0xc0, 0x0, 0xff, 0x0, 0x3,
    0xfc, 0x0, 0xf, 0xf0, 0x0, 0x3f, 0xc0, 0x0,
    0xff, 0x0, 0x3, 0xfc, 0x0, 0xf, 0xf0, 0x0,
    0x3f, 0xc0, 0x0, 0xff, 0x0, 0x3, 0xfc, 0x0,
    0xf, 0xf0, 0x0, 0x3f, 0xc0, 0x0, 0xff, 0x0,
    0x3, 0xfc, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0xf, 0xf0,
    0x0, 0x3f, 0xc0, 0x0, 0xff, 0x0, 0x3, 0xfc,
    0x0, 0xf, 0xf0, 0x0, 0x3f, 0xc0, 0x0, 0xff,
    0x0, 0x3, 0xfc, 0x0, 0xf, 0xf0, 0x0, 0x3f,
    0xc0, 0x0, 0xff, 0x0, 0x3, 0xfc, 0x0, 0xf,
    0xf0, 0x0, 0x3f, 0xc0, 0x0, 0xff, 0x0, 0x3,
    0xfc, 0x0, 0xf, 0xf0, 0x0, 0x3c,

    /* U+0049 "I" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+004A "J" */
    0x0, 0x7, 0x80, 0x3, 0xc0, 0x1, 0xe0, 0x0,
    0xf0, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1, 0xe0,
    0x0, 0xf0, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1,
    0xe0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0xf, 0x0, 0x7, 0x80, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f,
    0xc0, 0x1f, 0xe0, 0x1f, 0x78, 0xf, 0x3c, 0xf,
    0x9f, 0xff, 0x87, 0xff, 0x80, 0xff, 0x80, 0x4,
    0x0,

    /* U+004B "K" */
    0xf0, 0x0, 0x7d, 0xe0, 0x1, 0xf3, 0xc0, 0x7,
    0xc7, 0x80, 0xf, 0x8f, 0x0, 0x3e, 0x1e, 0x0,
    0xf8, 0x3c, 0x1, 0xe0, 0x78, 0x7, 0xc0, 0xf0,
    0x1f, 0x1, 0xe0, 0x3c, 0x3, 0xc0, 0xf0, 0x7,
    0x83, 0xe0, 0xf, 0x7, 0x80, 0x1e, 0x1e, 0x0,
    0x3c, 0x78, 0x0, 0x78, 0xf0, 0x0, 0xf3, 0xe0,
    0x1, 0xef, 0xe0, 0x3, 0xdf, 0xc0, 0x7, 0xff,
    0xc0, 0xf, 0xe7, 0xc0, 0x1f, 0x8f, 0x80, 0x3e,
    0xf, 0x80, 0x7c, 0x1f, 0x0, 0xf0, 0x1f, 0x1,
    0xe0, 0x3e, 0x3, 0xc0, 0x3e, 0x7, 0x80, 0x3c,
    0xf, 0x0, 0x7c, 0x1e, 0x0, 0x78, 0x3c, 0x0,
    0xf8, 0x78, 0x0, 0xf8, 0xf0, 0x1, 0xf1, 0xe0,
    0x1, 0xf3, 0xc0, 0x3, 0xe7, 0x80, 0x3, 0xef,
    0x0, 0x7, 0xc0,

    /* U+004C "L" */
    0xf0, 0x0, 0x1e, 0x0, 0x3, 0xc0, 0x0, 0x78,
    0x0, 0xf, 0x0, 0x1, 0xe0, 0x0, 0x3c, 0x0,
    0x7, 0x80, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x3,
    0xc0, 0x0, 0x78, 0x0, 0xf, 0x0, 0x1, 0xe0,
    0x0, 0x3c, 0x0, 0x7, 0x80, 0x0, 0xf0, 0x0,
    0x1e, 0x0, 0x3, 0xc0, 0x0, 0x78, 0x0, 0xf,
    0x0, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0x7, 0x80,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x3, 0xc0, 0x0,
    0x78, 0x0, 0xf, 0x0, 0x1, 0xe0, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x0, 0xf0, 0x0, 0x1e, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,

    /* U+004D "M" */
    0xfe, 0x0, 0x1, 0xff, 0xf8, 0x0, 0x7, 0xff,
    0xf0, 0x0, 0x3f, 0xff, 0xc0, 0x0, 0xff, 0xff,
    0x0, 0x3, 0xbf, 0xdc, 0x0, 0xe, 0xff, 0x78,
    0x0, 0x7b, 0xfd, 0xe0, 0x1, 0xef, 0xf7, 0x80,
    0x7, 0x3f, 0xce, 0x0, 0x1c, 0xff, 0x3c, 0x0,
    0xf3, 0xfc, 0xf0, 0x3, 0xcf, 0xf3, 0xc0, 0xe,
    0x3f, 0xc7, 0x0, 0x38, 0xff, 0x1e, 0x1, 0xe3,
    0xfc, 0x78, 0x7, 0x8f, 0xf1, 0xe0, 0x1c, 0x3f,
    0xc3, 0x80, 0x70, 0xff, 0xf, 0x3, 0xc3, 0xfc,
    0x3c, 0xf, 0xf, 0xf0, 0xf0, 0x38, 0x3f, 0xc1,
    0xc0, 0xe0, 0xff, 0x7, 0x87, 0x83, 0xfc, 0x1e,
    0x1e, 0xf, 0xf0, 0x38, 0x70, 0x3f, 0xc0, 0xe1,
    0xc0, 0xff, 0x3, 0xcf, 0x3, 0xfc, 0xf, 0x3c,
    0xf, 0xf0, 0x1c, 0xe0, 0x3f, 0xc0, 0x73, 0x80,
    0xff, 0x1, 0xde, 0x3, 0xfc, 0x7, 0xf8, 0xf,
    0xf0, 0xf, 0xc0, 0x3f, 0xc0, 0x3f, 0x0, 0xff,
    0x0, 0xfc, 0x3, 0xfc, 0x3, 0xf0, 0xf, 0xf0,
    0x7, 0x80, 0x3c,

    /* U+004E "N" */
    0xfe, 0x0, 0x3f, 0xf8, 0x0, 0xff, 0xe0, 0x3,
    0xff, 0xc0, 0xf, 0xff, 0x0, 0x3f, 0xdc, 0x0,
    0xff, 0x78, 0x3, 0xfd, 0xe0, 0xf, 0xf3, 0x80,
    0x3f, 0xcf, 0x0, 0xff, 0x3c, 0x3, 0xfc, 0x70,
    0xf, 0xf1, 0xe0, 0x3f, 0xc7, 0x80, 0xff, 0xe,
    0x3, 0xfc, 0x3c, 0xf, 0xf0, 0xf0, 0x3f, 0xc1,
    0xc0, 0xff, 0x7, 0x83, 0xfc, 0xe, 0xf, 0xf0,
    0x3c, 0x3f, 0xc0, 0xf0, 0xff, 0x1, 0xc3, 0xfc,
    0x7, 0x8f, 0xf0, 0x1e, 0x3f, 0xc0, 0x38, 0xff,
    0x0, 0xf3, 0xfc, 0x3, 0xcf, 0xf0, 0x7, 0x3f,
    0xc0, 0x1e, 0xff, 0x0, 0x7b, 0xfc, 0x0, 0xef,
    0xf0, 0x3, 0xbf, 0xc0, 0xf, 0xff, 0x0, 0x1f,
    0xfc, 0x0, 0x7f, 0xf0, 0x1, 0xfc,

    /* U+004F "O" */
    0x0, 0x8, 0x0, 0x1, 0xff, 0x80, 0x7, 0xff,
    0xe0, 0xf, 0xff, 0xf0, 0x1f, 0x0, 0xf8, 0x1e,
    0x0, 0x78, 0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c,
    0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0,
    0x1e, 0x78, 0x0, 0x1e, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0x78, 0x0,
    0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c,
    0x3e, 0x0, 0x7c, 0x1f, 0x0, 0xf8, 0xf, 0xc3,
    0xf0, 0xf, 0xff, 0xf0, 0x3, 0xff, 0xc0, 0x1,
    0xff, 0x80, 0x0, 0x10, 0x0,

    /* U+0050 "P" */
    0xff, 0xfc, 0x7, 0xff, 0xfc, 0x3f, 0xff, 0xf1,
    0xe0, 0x1f, 0xcf, 0x0, 0x3f, 0x78, 0x0, 0xfb,
    0xc0, 0x3, 0xde, 0x0, 0xf, 0xf0, 0x0, 0x7f,
    0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0, 0x0, 0xff,
    0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x3, 0xfe,
    0x0, 0x1e, 0xf0, 0x1, 0xf7, 0x80, 0x3f, 0x3f,
    0xff, 0xf9, 0xff, 0xff, 0x8f, 0xff, 0xf0, 0x7f,
    0xfc, 0x3, 0xc0, 0x0, 0x1e, 0x0, 0x0, 0xf0,
    0x0, 0x7, 0x80, 0x0, 0x3c, 0x0, 0x1, 0xe0,
    0x0, 0xf, 0x0, 0x0, 0x78, 0x0, 0x3, 0xc0,
    0x0, 0x1e, 0x0, 0x0, 0xf0, 0x0, 0x7, 0x80,
    0x0, 0x3c, 0x0, 0x1, 0xe0, 0x0, 0xf, 0x0,
    0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xe0, 0x0, 0x7f,
    0xfe, 0x0, 0x3f, 0xbf, 0xc0, 0x1f, 0x0, 0xf8,
    0x7, 0x80, 0x1e, 0x3, 0xc0, 0x3, 0xc0, 0xf0,
    0x0, 0xf0, 0x7c, 0x0, 0x1e, 0x1e, 0x0, 0x7,
    0x87, 0x80, 0x1, 0xe1, 0xe0, 0x0, 0x78, 0xf8,
    0x0, 0xf, 0x3c, 0x0, 0x3, 0xcf, 0x0, 0x0,
    0xf3, 0xc0, 0x0, 0x3c, 0xf0, 0x0, 0xf, 0x3c,
    0x0, 0x3, 0xcf, 0x0, 0x0, 0xf3, 0xc0, 0x0,
    0x3c, 0xf0, 0x0, 0xf, 0x3c, 0x0, 0x3, 0xcf,
    0x0, 0x0, 0xf3, 0xc0, 0x0, 0x3c, 0xf0, 0x0,
    0xf, 0x3c, 0x0, 0x3, 0xc7, 0x0, 0x0, 0xf1,
    0xe0, 0x0, 0x78, 0x78, 0x0, 0x1e, 0x1e, 0x0,
    0xe7, 0x83, 0xc0, 0x7d, 0xe0, 0xf0, 0xf, 0xf8,
    0x3e, 0x1, 0xfc, 0x7, 0x80, 0x3f, 0x0, 0xf8,
    0xf, 0xe0, 0x1f, 0xdf, 0xfc, 0x3, 0xff, 0xef,
    0x80, 0x7f, 0xf1, 0xe0, 0x0, 0x80, 0x10,

    /* U+0052 "R" */
    0xff, 0xf8, 0x1, 0xff, 0xfe, 0x3, 0xff, 0xff,
    0x7, 0xff, 0xff, 0xf, 0x0, 0x7e, 0x1e, 0x0,
    0x3e, 0x3c, 0x0, 0x3c, 0x78, 0x0, 0x7c, 0xf0,
    0x0, 0x79, 0xe0, 0x0, 0xf3, 0xc0, 0x1, 0xe7,
    0x80, 0x3, 0xcf, 0x0, 0x7, 0x9e, 0x0, 0x1e,
    0x3c, 0x0, 0x3c, 0x78, 0x0, 0xf8, 0xf0, 0x7,
    0xe1, 0xff, 0xff, 0x3, 0xff, 0xf8, 0x7, 0xff,
    0xfe, 0xf, 0xff, 0xff, 0x1e, 0x0, 0x7e, 0x3c,
    0x0, 0x7e, 0x78, 0x0, 0x7c, 0xf0, 0x0, 0x79,
    0xe0, 0x0, 0xf3, 0xc0, 0x1, 0xe7, 0x80, 0x3,
    0xcf, 0x0, 0x7, 0x9e, 0x0, 0xf, 0x3c, 0x0,
    0x1e, 0x78, 0x0, 0x3c, 0xf0, 0x0, 0x79, 0xe0,
    0x0, 0xf3, 0xc0, 0x0, 0xe7, 0x80, 0x1, 0xcf,
    0x0, 0x3, 0xe0,

    /* U+0053 "S" */
    0x0, 0x0, 0x0, 0xf, 0xfe, 0x0, 0x3f, 0xff,
    0x0, 0xff, 0xff, 0x3, 0xe0, 0x1f, 0x7, 0x80,
    0x1e, 0x1f, 0x0, 0x3e, 0x3c, 0x0, 0x3c, 0x78,
    0x0, 0x78, 0xf0, 0x0, 0xf1, 0xe0, 0x0, 0x3,
    0xc0, 0x0, 0x7, 0x80, 0x0, 0xf, 0x80, 0x0,
    0xf, 0x80, 0x0, 0x1f, 0x80, 0x0, 0x1f, 0xe0,
    0x0, 0x1f, 0xf8, 0x0, 0x1f, 0xfc, 0x0, 0xf,
    0xfe, 0x0, 0x7, 0xfe, 0x0, 0x1, 0xfe, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0xfb, 0xc0, 0x0, 0xf7, 0x80, 0x1,
    0xe7, 0x0, 0x3, 0xce, 0x0, 0x7, 0x9e, 0x0,
    0xf, 0x3c, 0x0, 0x1e, 0x78, 0x0, 0x78, 0x78,
    0x0, 0xf0, 0xf8, 0x3, 0xc0, 0xff, 0xff, 0x80,
    0xff, 0xfe, 0x0, 0x7f, 0xf0, 0x0, 0xc, 0x0,
    0x0,

    /* U+0054 "T" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x3, 0xc0, 0x0, 0x7, 0x80, 0x0, 0xf,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x78, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0,
    0x3, 0xc0, 0x0, 0x7, 0x80, 0x0, 0xf, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78,
    0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x3,
    0xc0, 0x0, 0x7, 0x80, 0x0, 0xf, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0,
    0x0, 0xf0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xc0,
    0x0, 0x7, 0x80, 0x0, 0xf, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x78, 0x0, 0x0,
    0xf0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xc0, 0x0,
    0x7, 0x80, 0x0,

    /* U+0055 "U" */
    0xf0, 0x0, 0x7f, 0x80, 0x3, 0xfc, 0x0, 0x1f,
    0xe0, 0x0, 0xff, 0x0, 0x7, 0xf8, 0x0, 0x3f,
    0xc0, 0x1, 0xfe, 0x0, 0xf, 0xf0, 0x0, 0x7f,
    0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0, 0x0, 0xff,
    0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe,
    0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80, 0x3, 0xfc,
    0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0, 0x7, 0xf8,
    0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0, 0xf, 0xf0,
    0x0, 0x7f, 0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0,
    0x0, 0xff, 0x0, 0x7, 0xf8, 0x0, 0x3f, 0xe0,
    0x3, 0xff, 0x0, 0x1f, 0x7c, 0x1, 0xf3, 0xf0,
    0x1f, 0x8f, 0xff, 0xf8, 0x3f, 0xff, 0x80, 0x7f,
    0xf0, 0x0, 0x30, 0x0,

    /* U+0056 "V" */
    0xf0, 0x0, 0x7, 0xf8, 0x0, 0x7, 0xfc, 0x0,
    0x3, 0xef, 0x0, 0x1, 0xe7, 0x80, 0x0, 0xf3,
    0xc0, 0x0, 0xf9, 0xe0, 0x0, 0x78, 0x78, 0x0,
    0x3c, 0x3c, 0x0, 0x1e, 0x1e, 0x0, 0x1f, 0xf,
    0x0, 0xf, 0x3, 0xc0, 0x7, 0x81, 0xe0, 0x3,
    0xc0, 0xf0, 0x3, 0xc0, 0x38, 0x1, 0xe0, 0x1e,
    0x0, 0xf0, 0xf, 0x0, 0x78, 0x7, 0x80, 0x78,
    0x1, 0xc0, 0x3c, 0x0, 0xf0, 0x1e, 0x0, 0x78,
    0xe, 0x0, 0x1c, 0xf, 0x0, 0xe, 0x7, 0x80,
    0x7, 0x83, 0xc0, 0x3, 0xc1, 0xc0, 0x0, 0xe1,
    0xe0, 0x0, 0x70, 0xf0, 0x0, 0x3c, 0x70, 0x0,
    0xe, 0x38, 0x0, 0x7, 0x3c, 0x0, 0x3, 0x9e,
    0x0, 0x1, 0xee, 0x0, 0x0, 0x77, 0x0, 0x0,
    0x3f, 0x80, 0x0, 0x1f, 0x80, 0x0, 0xf, 0xc0,
    0x0, 0x3, 0xe0, 0x0,

    /* U+0057 "W" */
    0xf0, 0x0, 0xfc, 0x0, 0x3f, 0xc0, 0x3, 0xf0,
    0x1, 0xff, 0x80, 0xf, 0xc0, 0x7, 0xfe, 0x0,
    0x3f, 0x0, 0x1f, 0x78, 0x0, 0xfc, 0x0, 0x79,
    0xe0, 0x7, 0xf8, 0x1, 0xe7, 0x80, 0x1f, 0xe0,
    0xf, 0x9f, 0x0, 0x77, 0x80, 0x3e, 0x7c, 0x1,
    0xde, 0x0, 0xf0, 0xf0, 0x7, 0x38, 0x3, 0xc3,
    0xc0, 0x3c, 0xf0, 0xf, 0xf, 0x0, 0xf3, 0xc0,
    0x7c, 0x3c, 0x3, 0xcf, 0x1, 0xe0, 0xf8, 0xf,
    0x3c, 0x7, 0x81, 0xe0, 0x78, 0x70, 0x1e, 0x7,
    0x81, 0xe1, 0xc0, 0x78, 0x1e, 0x7, 0x87, 0x83,
    0xe0, 0x78, 0x1e, 0x1e, 0xf, 0x0, 0xf0, 0x70,
    0x78, 0x3c, 0x3, 0xc3, 0xc0, 0xe0, 0xf0, 0xf,
    0xf, 0x3, 0x83, 0xc0, 0x3c, 0x3c, 0xf, 0x1e,
    0x0, 0xf0, 0xf0, 0x3c, 0x78, 0x1, 0xe3, 0x80,
    0xf1, 0xe0, 0x7, 0x9e, 0x3, 0xc7, 0x80, 0x1e,
    0x78, 0x7, 0x1e, 0x0, 0x79, 0xe0, 0x1c, 0xf0,
    0x1, 0xe7, 0x80, 0x7b, 0xc0, 0x3, 0x9c, 0x1,
    0xef, 0x0, 0xe, 0xf0, 0x7, 0xbc, 0x0, 0x3f,
    0xc0, 0xe, 0xe0, 0x0, 0xff, 0x0, 0x3b, 0x80,
    0x3, 0xf8, 0x0, 0xee, 0x0, 0x7, 0xe0, 0x3,
    0xf8, 0x0, 0x1f, 0x80, 0xf, 0xc0, 0x0, 0x7e,
    0x0, 0x1f, 0x0, 0x1, 0xf8, 0x0, 0x7c, 0x0,

    /* U+0058 "X" */
    0xf8, 0x0, 0xf, 0x3e, 0x0, 0xf, 0x8f, 0x0,
    0x7, 0x87, 0xc0, 0x7, 0xc1, 0xe0, 0x7, 0xc0,
    0xf8, 0x3, 0xe0, 0x3c, 0x3, 0xe0, 0x1f, 0x1,
    0xe0, 0x7, 0x81, 0xf0, 0x3, 0xe0, 0xf0, 0x0,
    0xf0, 0xf8, 0x0, 0x7c, 0x78, 0x0, 0x1e, 0x7c,
    0x0, 0x7, 0xbc, 0x0, 0x3, 0xfe, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0xf, 0x80, 0x0, 0xf, 0xe0, 0x0, 0x7,
    0xf0, 0x0, 0x7, 0xfc, 0x0, 0x3, 0xde, 0x0,
    0x3, 0xcf, 0x80, 0x3, 0xe3, 0xc0, 0x1, 0xe1,
    0xf0, 0x1, 0xf0, 0x78, 0x0, 0xf0, 0x3e, 0x0,
    0xf8, 0xf, 0x0, 0x78, 0x7, 0xc0, 0x7c, 0x1,
    0xe0, 0x3c, 0x0, 0xf8, 0x3e, 0x0, 0x3c, 0x1e,
    0x0, 0x1f, 0x1f, 0x0, 0x7, 0xcf, 0x0, 0x3,
    0xef, 0x80, 0x0, 0xf8,

    /* U+0059 "Y" */
    0x78, 0x0, 0x7, 0xde, 0x0, 0x1, 0xe7, 0xc0,
    0x0, 0xf8, 0xf0, 0x0, 0x3c, 0x3e, 0x0, 0x1f,
    0x7, 0x80, 0x7, 0x81, 0xf0, 0x3, 0xe0, 0x3c,
    0x0, 0xf0, 0xf, 0x0, 0x3c, 0x1, 0xe0, 0x1e,
    0x0, 0x78, 0x7, 0x80, 0xf, 0x3, 0xc0, 0x3,
    0xc0, 0xf0, 0x0, 0x78, 0x78, 0x0, 0x1e, 0x1e,
    0x0, 0x3, 0xcf, 0x0, 0x0, 0xf3, 0xc0, 0x0,
    0x1f, 0xf0, 0x0, 0x7, 0xf8, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x7, 0x80, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x1e, 0x0,
    0x0,

    /* U+005A "Z" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf8,
    0x0, 0x7, 0x80, 0x0, 0x78, 0x0, 0x3, 0xc0,
    0x0, 0x3c, 0x0, 0x1, 0xe0, 0x0, 0x1e, 0x0,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0x78, 0x0,
    0x7, 0x80, 0x0, 0x38, 0x0, 0x3, 0xc0, 0x0,
    0x3c, 0x0, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0x78, 0x0, 0x7,
    0x80, 0x0, 0x38, 0x0, 0x3, 0xc0, 0x0, 0x1c,
    0x0, 0x1, 0xe0, 0x0, 0xe, 0x0, 0x0, 0xf0,
    0x0, 0xf, 0x0, 0x0, 0x78, 0x0, 0x7, 0x80,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x80,

    /* U+005B "[" */
    0xff, 0xff, 0xff, 0xfe, 0xf, 0x7, 0x83, 0xc1,
    0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83,
    0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7,
    0x83, 0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf,
    0x7, 0x83, 0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e,
    0xf, 0x7, 0x83, 0xc1, 0xe0, 0xff, 0xff, 0xff,
    0xe0,

    /* U+005C "\\" */
    0xc0, 0x1, 0xc0, 0x1, 0x80, 0x3, 0x0, 0x7,
    0x0, 0x6, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x18,
    0x0, 0x30, 0x0, 0x70, 0x0, 0x60, 0x0, 0xc0,
    0x1, 0xc0, 0x1, 0x80, 0x3, 0x0, 0x7, 0x0,
    0xe, 0x0, 0xc, 0x0, 0x1c, 0x0, 0x38, 0x0,
    0x30, 0x0, 0x70, 0x0, 0xe0, 0x0, 0xc0, 0x1,
    0xc0, 0x3, 0x80, 0x3, 0x0, 0x7, 0x0, 0xe,
    0x0, 0xc, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x30,
    0x0, 0x70, 0x0, 0xe0, 0x0, 0xc0,

    /* U+005D "]" */
    0xff, 0xff, 0xff, 0xe0, 0xf0, 0x78, 0x3c, 0x1e,
    0xf, 0x7, 0x83, 0xc1, 0xe0, 0xf0, 0x78, 0x3c,
    0x1e, 0xf, 0x7, 0x83, 0xc1, 0xe0, 0xf0, 0x78,
    0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1, 0xe0, 0xf0,
    0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1, 0xe0,
    0xf0, 0x78, 0x3c, 0x1e, 0xf, 0xff, 0xff, 0xff,
    0xe0,

    /* U+005E "^" */
    0xf, 0xc0, 0x3f, 0x1, 0xfe, 0xf, 0x3c, 0x3c,
    0x71, 0xe1, 0xef, 0x3, 0xc0,

    /* U+005F "_" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff,

    /* U+0060 "`" */
    0xf8, 0x3e, 0xf, 0x3, 0xc0, 0xf0, 0x38, 0x1e,

    /* U+0061 "a" */
    0x3, 0xf0, 0x1, 0xff, 0x80, 0x7f, 0xf8, 0x1e,
    0xf, 0x3, 0x80, 0xf0, 0xf0, 0x1e, 0x1e, 0x3,
    0xc3, 0xc0, 0x38, 0x0, 0x7, 0x0, 0x1, 0xe0,
    0x0, 0x3c, 0x0, 0x1f, 0x80, 0xf, 0xf0, 0xf,
    0xde, 0x7, 0xe3, 0xc1, 0xf0, 0x78, 0x7c, 0xf,
    0xf, 0x1, 0xe3, 0xc0, 0x3c, 0x78, 0x7, 0x8f,
    0x0, 0xf1, 0xe0, 0x1e, 0x3c, 0x3, 0xc7, 0x80,
    0xf8, 0x78, 0x3f, 0xf, 0xfe, 0xfc, 0xff, 0x8f,
    0x8f, 0xe1, 0xf0, 0x20, 0x0,

    /* U+0062 "b" */
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x7e, 0xf, 0x7f,
    0xe3, 0xdf, 0xf8, 0xfe, 0x1f, 0x3f, 0x3, 0xef,
    0x80, 0x7b, 0xe0, 0x1e, 0xf0, 0x7, 0xfc, 0x0,
    0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc,
    0x0, 0xff, 0x0, 0x3f, 0x80, 0xf, 0xe0, 0x3,
    0xf8, 0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0,
    0x3, 0xfc, 0x1, 0xef, 0x0, 0x7b, 0xe0, 0x1e,
    0xf8, 0xf, 0x3f, 0x3, 0xcf, 0xfb, 0xe3, 0xdf,
    0xf8, 0xf3, 0xf8, 0x0, 0x10, 0x0,

    /* U+0063 "c" */
    0x3, 0xf8, 0x7, 0xfe, 0x7, 0xff, 0x87, 0xc3,
    0xe3, 0xc0, 0xf3, 0xe0, 0x7d, 0xe0, 0x1e, 0xf0,
    0xf, 0x78, 0x7, 0xf8, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1,
    0xe0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x3c, 0x1,
    0xfe, 0x0, 0xf7, 0x0, 0x7b, 0xc0, 0x3d, 0xe0,
    0x1e, 0xf0, 0x1e, 0x3c, 0xf, 0xf, 0xdf, 0x3,
    0xff, 0x80, 0xff, 0x0, 0x4, 0x0,

    /* U+0064 "d" */
    0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x3, 0xc1, 0xf0, 0xf0, 0xff,
    0x3c, 0x7f, 0xef, 0x3e, 0x1f, 0xdf, 0x3, 0xf7,
    0x80, 0x7d, 0xe0, 0x1f, 0x78, 0x7, 0xfc, 0x0,
    0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc,
    0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3,
    0xfc, 0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0,
    0x3, 0xfe, 0x0, 0xf7, 0x80, 0x7d, 0xe0, 0x1f,
    0x7c, 0xf, 0xcf, 0x3, 0xf3, 0xf7, 0xbc, 0x7f,
    0xef, 0xf, 0xe3, 0xc0, 0x40, 0x0,

    /* U+0065 "e" */
    0x3, 0xf0, 0x7, 0xfc, 0x7, 0xff, 0x7, 0xc3,
    0xc3, 0xc0, 0xf3, 0xc0, 0x79, 0xe0, 0x3c, 0xf0,
    0xe, 0xf8, 0x7, 0xf8, 0x3, 0xfc, 0x1, 0xfe,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0xf7, 0x0, 0x7b, 0xc0, 0x3d, 0xe0,
    0x1e, 0xf0, 0x1e, 0x3c, 0x1f, 0xf, 0xff, 0x7,
    0xff, 0x80, 0xff, 0x0, 0xc, 0x0,

    /* U+0066 "f" */
    0x0, 0xf0, 0x3f, 0x7, 0xf0, 0xff, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,

    /* U+0067 "g" */
    0x7, 0xe0, 0x3, 0xfc, 0xf1, 0xff, 0xbc, 0xf8,
    0x7f, 0x7c, 0xf, 0xde, 0x1, 0xf7, 0x80, 0x7d,
    0xe0, 0x1f, 0xf0, 0x3, 0xfc, 0x0, 0xff, 0x0,
    0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc, 0x0, 0xff,
    0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc, 0x0,
    0xff, 0x0, 0x3f, 0xc0, 0x1f, 0x78, 0x7, 0xde,
    0x1, 0xf7, 0x80, 0xfc, 0xf0, 0x3f, 0x3e, 0x1f,
    0xc7, 0xfe, 0xf0, 0xff, 0x3c, 0x1f, 0x8f, 0x78,
    0x7, 0x9e, 0x1, 0xe7, 0x80, 0xf8, 0xf0, 0x7c,
    0x1f, 0xfe, 0x3, 0xff, 0x0, 0x7f, 0x0,

    /* U+0068 "h" */
    0xf0, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1, 0xe0,
    0x0, 0xf0, 0x0, 0x78, 0x7e, 0x3c, 0xff, 0x9e,
    0xff, 0xef, 0xe1, 0xf7, 0xe0, 0x7f, 0xe0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f,
    0xc0, 0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3,
    0xfc, 0x1, 0xfe, 0x0, 0xff, 0x0, 0x78,

    /* U+0069 "i" */
    0xff, 0xff, 0xf0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+006A "j" */
    0x1e, 0x3c, 0x78, 0xf1, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x78, 0xf1, 0xe3, 0xc7, 0x8f, 0x1e, 0x3c,
    0x78, 0xf1, 0xe3, 0xc7, 0x8f, 0x1e, 0x3c, 0x78,
    0xf1, 0xe3, 0xc7, 0x8f, 0x1e, 0x3c, 0x78, 0xf1,
    0xe3, 0xc7, 0x8f, 0xfd, 0xfb, 0xe7, 0x80, 0x0,

    /* U+006B "k" */
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x7b, 0xc0, 0x3e, 0xf0, 0x1f, 0x3c, 0x7, 0x8f,
    0x3, 0xc3, 0xc1, 0xe0, 0xf0, 0xf8, 0x3c, 0x3c,
    0xf, 0x1e, 0x3, 0xcf, 0x0, 0xf7, 0x80, 0x3d,
    0xf0, 0xf, 0xfc, 0x3, 0xff, 0x80, 0xfd, 0xf0,
    0x3e, 0x3c, 0xf, 0x8f, 0x83, 0xc1, 0xe0, 0xf0,
    0x7c, 0x3c, 0xf, 0xf, 0x3, 0xe3, 0xc0, 0x78,
    0xf0, 0x1f, 0x3c, 0x3, 0xcf, 0x0, 0xfb, 0xc0,
    0x1e, 0xf0, 0x7, 0xc0,

    /* U+006C "l" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+006D "m" */
    0x0, 0xf8, 0x7, 0xc3, 0xcf, 0xf8, 0x7f, 0xcf,
    0x7f, 0xf3, 0xff, 0xbf, 0x87, 0xdc, 0x3e, 0xfc,
    0xf, 0xe0, 0x7f, 0xe0, 0x1f, 0x0, 0xff, 0x0,
    0x78, 0x3, 0xfc, 0x1, 0xe0, 0xf, 0xf0, 0x7,
    0x80, 0x3f, 0xc0, 0x1e, 0x0, 0xff, 0x0, 0x78,
    0x3, 0xfc, 0x1, 0xe0, 0xf, 0xf0, 0x7, 0x80,
    0x3f, 0xc0, 0x1e, 0x0, 0xff, 0x0, 0x78, 0x3,
    0xfc, 0x1, 0xe0, 0xf, 0xf0, 0x7, 0x80, 0x3f,
    0xc0, 0x1e, 0x0, 0xff, 0x0, 0x78, 0x3, 0xfc,
    0x1, 0xe0, 0xf, 0xf0, 0x7, 0x80, 0x3f, 0xc0,
    0x1e, 0x0, 0xff, 0x0, 0x78, 0x3, 0xfc, 0x1,
    0xe0, 0xf, 0xf0, 0x7, 0x80, 0x3f, 0xc0, 0x1e,
    0x0, 0xff, 0x0, 0x78, 0x3, 0xfc, 0x1, 0xe0,
    0xf,

    /* U+006E "n" */
    0x0, 0xfc, 0x79, 0xff, 0x3d, 0xff, 0xdf, 0xc3,
    0xef, 0xc0, 0xff, 0xc0, 0x3f, 0xc0, 0x1f, 0xe0,
    0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1, 0xfe,
    0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xf0,

    /* U+006F "o" */
    0x3, 0xf8, 0x1, 0xff, 0xc0, 0x7f, 0xfc, 0x1f,
    0x87, 0xc3, 0xc0, 0x78, 0xf8, 0xf, 0x9e, 0x0,
    0xf3, 0xc0, 0x1e, 0xf8, 0x3, 0xfe, 0x0, 0x3f,
    0xc0, 0x7, 0xf8, 0x0, 0xff, 0x0, 0x1f, 0xe0,
    0x3, 0xfc, 0x0, 0x7f, 0x80, 0xf, 0xf0, 0x1,
    0xfe, 0x0, 0x3f, 0xc0, 0x7, 0xf8, 0x0, 0xe7,
    0x80, 0x3c, 0xf0, 0x7, 0x9e, 0x0, 0xf1, 0xe0,
    0x3c, 0x3e, 0xf, 0x83, 0xff, 0xe0, 0x3f, 0xf8,
    0x3, 0xfe, 0x0, 0x4, 0x0,

    /* U+0070 "p" */
    0x1, 0xf8, 0x3c, 0xff, 0xf, 0x7f, 0xe3, 0xf8,
    0x7c, 0xfc, 0xf, 0xbe, 0x1, 0xef, 0x80, 0x7b,
    0xe0, 0x1f, 0xf0, 0x3, 0xfc, 0x0, 0xff, 0x0,
    0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc, 0x0, 0xff,
    0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc, 0x0,
    0xff, 0x0, 0x3f, 0xc0, 0xe, 0xf8, 0x7, 0xbe,
    0x1, 0xef, 0x80, 0x7b, 0xf0, 0x3c, 0xfe, 0x1f,
    0x3d, 0xff, 0x8f, 0x3f, 0xc3, 0xc7, 0xe0, 0xf0,
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x0,

    /* U+0071 "q" */
    0x3, 0xe0, 0x3, 0xfc, 0xf1, 0xff, 0xbc, 0xf8,
    0x7f, 0x3c, 0xf, 0xdf, 0x1, 0xf7, 0x80, 0x7d,
    0xe0, 0x1f, 0xf8, 0x3, 0xfc, 0x0, 0xff, 0x0,
    0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc, 0x0, 0xff,
    0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc, 0x0,
    0xff, 0x0, 0x3f, 0xc0, 0xf, 0x78, 0x7, 0xde,
    0x1, 0xf7, 0x80, 0x7d, 0xf0, 0x3f, 0x3e, 0x1f,
    0xc7, 0xfe, 0xf0, 0xff, 0x3c, 0x1f, 0xf, 0x0,
    0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c,

    /* U+0072 "r" */
    0x0, 0xf, 0x1f, 0xf3, 0xff, 0x7f, 0xff, 0xf,
    0xc0, 0xf8, 0xf, 0x80, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0,

    /* U+0073 "s" */
    0x7, 0xf8, 0x7, 0xff, 0x83, 0xff, 0xf0, 0xf8,
    0x3e, 0x7c, 0x7, 0x9e, 0x0, 0xf7, 0x80, 0x3d,
    0xe0, 0xf, 0x78, 0x0, 0x1f, 0x0, 0x7, 0xe0,
    0x0, 0xfc, 0x0, 0x1f, 0xe0, 0x3, 0xfe, 0x0,
    0x3f, 0xe0, 0x1, 0xfc, 0x0, 0x1f, 0x80, 0x1,
    0xe0, 0x0, 0x7c, 0x0, 0xf, 0x78, 0x3, 0xde,
    0x0, 0xf7, 0x80, 0x3d, 0xf0, 0x1f, 0x3e, 0xf,
    0x87, 0xff, 0xc0, 0xff, 0xe0, 0xf, 0xe0,

    /* U+0074 "t" */
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0xf0, 0x7f, 0x3, 0xf0,

    /* U+0075 "u" */
    0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1, 0xfe, 0x0,
    0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f, 0xe0,
    0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1, 0xfe,
    0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x7f, 0xc0,
    0x3f, 0xf0, 0x3f, 0x7f, 0xf7, 0xbf, 0xf3, 0xcf,
    0xf1, 0xe0, 0x40, 0x0,

    /* U+0076 "v" */
    0xf0, 0x0, 0xef, 0x0, 0x1e, 0xf0, 0x1, 0xe7,
    0x0, 0x1e, 0x78, 0x1, 0xc7, 0x80, 0x3c, 0x78,
    0x3, 0xc3, 0x80, 0x38, 0x3c, 0x3, 0x83, 0xc0,
    0x78, 0x1c, 0x7, 0x81, 0xc0, 0x70, 0x1e, 0x7,
    0x0, 0xe0, 0xf0, 0xe, 0xe, 0x0, 0xf0, 0xe0,
    0xf, 0xe, 0x0, 0x71, 0xe0, 0x7, 0x1c, 0x0,
    0x79, 0xc0, 0x3, 0xbc, 0x0, 0x3b, 0x80, 0x3,
    0xb8, 0x0, 0x1f, 0x80, 0x1, 0xf0, 0x0, 0x1f,
    0x0, 0x1, 0xf0, 0x0,

    /* U+0077 "w" */
    0xf0, 0x7, 0x80, 0x3f, 0xc0, 0x1e, 0x0, 0xf7,
    0x0, 0x78, 0x3, 0xde, 0x3, 0xf0, 0x1e, 0x78,
    0xf, 0xc0, 0x79, 0xe0, 0x3b, 0x1, 0xe3, 0x80,
    0xcc, 0x7, 0x8e, 0x3, 0x30, 0x1c, 0x3c, 0xc,
    0xe0, 0xf0, 0xf0, 0x73, 0x83, 0xc1, 0xc1, 0xce,
    0xf, 0x7, 0x6, 0x18, 0x38, 0x1c, 0x18, 0x60,
    0xe0, 0x78, 0x61, 0xc3, 0x80, 0xe3, 0x87, 0x1e,
    0x3, 0x8e, 0x1c, 0x70, 0xe, 0x38, 0x31, 0xc0,
    0x38, 0xc0, 0xc7, 0x0, 0x73, 0x3, 0x9c, 0x1,
    0xcc, 0xe, 0xe0, 0x7, 0x70, 0x3b, 0x80, 0x1d,
    0xc0, 0x6e, 0x0, 0x36, 0x1, 0xb8, 0x0, 0xf8,
    0x6, 0xc0, 0x3, 0xe0, 0x1f, 0x0, 0xf, 0x80,
    0x7c, 0x0, 0x1e, 0x0, 0xf0, 0x0,

    /* U+0078 "x" */
    0x78, 0x0, 0xf1, 0xe0, 0x7, 0x8f, 0x0, 0x78,
    0x3c, 0x3, 0xc0, 0xf0, 0x3c, 0x7, 0x83, 0xc0,
    0x1e, 0x1e, 0x0, 0xf9, 0xe0, 0x3, 0xcf, 0x0,
    0x1f, 0xf0, 0x0, 0x7f, 0x0, 0x1, 0xf8, 0x0,
    0xf, 0x80, 0x0, 0x7c, 0x0, 0x3, 0xf0, 0x0,
    0x3f, 0x80, 0x1, 0xde, 0x0, 0x1e, 0xf0, 0x1,
    0xe3, 0xc0, 0xf, 0xf, 0x0, 0xf0, 0x78, 0x7,
    0x81, 0xe0, 0x78, 0xf, 0x7, 0x80, 0x3c, 0x3c,
    0x0, 0xf3, 0xc0, 0x7, 0x9e, 0x0, 0x1e,

    /* U+0079 "y" */
    0xf0, 0x0, 0xff, 0x0, 0xf, 0x78, 0x0, 0xe7,
    0x80, 0x1e, 0x78, 0x1, 0xe3, 0x80, 0x1c, 0x3c,
    0x3, 0xc3, 0xc0, 0x3c, 0x1c, 0x3, 0xc1, 0xc0,
    0x38, 0x1e, 0x7, 0x81, 0xe0, 0x78, 0xe, 0x7,
    0x0, 0xe0, 0x70, 0xf, 0xf, 0x0, 0x70, 0xe0,
    0x7, 0xe, 0x0, 0x70, 0xe0, 0x7, 0x9e, 0x0,
    0x39, 0xc0, 0x3, 0x9c, 0x0, 0x3f, 0xc0, 0x1,
    0xf8, 0x0, 0x1f, 0x80, 0x1, 0xf8, 0x0, 0x1f,
    0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xe0,
    0x0, 0xe, 0x0, 0x1, 0xc0, 0x0, 0x3c, 0x0,
    0x7f, 0x80, 0x7, 0xf0, 0x0, 0x7e, 0x0, 0x0,

    /* U+007A "z" */
    0xff, 0xff, 0x7f, 0xff, 0xbf, 0xff, 0xc0, 0x1,
    0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0xf0, 0x0,
    0xf0, 0x0, 0x78, 0x0, 0x78, 0x0, 0x3c, 0x0,
    0x3c, 0x0, 0x1c, 0x0, 0x1e, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0xf, 0x0, 0x7, 0x0, 0x7, 0x80,
    0x3, 0x80, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0xc0,
    0x1, 0xe0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0,

    /* U+007B "{" */
    0x0, 0xe0, 0x38, 0x7, 0x80, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0x1e, 0x1, 0xc0, 0x70, 0x3,
    0x80, 0x1c, 0x0, 0xe0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0x7, 0x0, 0x78, 0x1, 0xc0, 0x3,

    /* U+007C "|" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf0,

    /* U+007D "}" */
    0x0, 0xf, 0x0, 0x3c, 0x1, 0xe0, 0xe, 0x0,
    0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0x70, 0x3, 0xc0,
    0xf, 0x1, 0xc0, 0x78, 0x7, 0x0, 0xf0, 0xf,
    0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0, 0xf0, 0xf, 0x0,
    0xf0, 0xf, 0x1, 0xe0, 0x1c, 0x7, 0x0,

    /* U+007E "~" */
    0x0, 0x0, 0x0, 0xf0, 0x2, 0x1f, 0xc0, 0x73,
    0xff, 0xe, 0x71, 0xff, 0xee, 0x7, 0xfc, 0xe0,
    0x3f, 0x84, 0x0, 0xf0, 0x40, 0x0, 0x0,

    /* U+00A0 " " */
    0x0,

    /* U+00A1 "¡" */
    0xff, 0xff, 0xf0, 0x0, 0x6, 0x66, 0x66, 0x66,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0,

    /* U+00A2 "¢" */
    0x0, 0x1c, 0x0, 0xc, 0x0, 0x6, 0x0, 0x3,
    0x0, 0x3, 0x80, 0x1f, 0x80, 0x3f, 0xe0, 0x3f,
    0xf8, 0x3e, 0x3e, 0x1e, 0x1f, 0x9e, 0x1b, 0xcf,
    0xc, 0xf7, 0x86, 0x7f, 0xc3, 0x3f, 0xc1, 0x1,
    0xe1, 0x80, 0xf0, 0xc0, 0x78, 0x60, 0x3c, 0x30,
    0x1e, 0x10, 0xf, 0x18, 0x7, 0x8c, 0x3, 0xc6,
    0x1, 0xe3, 0xf, 0xf3, 0x7, 0xbd, 0x83, 0xde,
    0xc3, 0xef, 0x61, 0xe3, 0xf1, 0xf1, 0xfb, 0xf8,
    0x7f, 0xf8, 0x1f, 0xf8, 0x6, 0x40, 0x7, 0x0,
    0x3, 0x0, 0x1, 0x80, 0x0, 0xc0, 0x0, 0xe0,
    0x0, 0x70, 0x0,

    /* U+00A3 "£" */
    0x0, 0xfe, 0x0, 0x1f, 0xfe, 0x0, 0xff, 0xfc,
    0x7, 0xc0, 0xf8, 0x3e, 0x1, 0xf0, 0xf0, 0x3,
    0xc7, 0x80, 0x7, 0x1e, 0x0, 0x1e, 0x78, 0x0,
    0x79, 0xe0, 0x1, 0xe7, 0x80, 0x7, 0x9e, 0x0,
    0x0, 0x78, 0x0, 0x0, 0xf0, 0x0, 0x3, 0xc0,
    0x0, 0xf, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x78,
    0x0, 0xf, 0xff, 0xf0, 0x3f, 0xff, 0xc0, 0x7,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x78, 0x0, 0x1,
    0xe0, 0x0, 0x7, 0x80, 0x0, 0x1e, 0x0, 0x0,
    0x78, 0x0, 0x1, 0xc0, 0x0, 0xf, 0x0, 0x0,
    0x38, 0x0, 0x1, 0xe0, 0x0, 0x7, 0x0, 0x0,
    0x38, 0x0, 0x9, 0xff, 0xf0, 0xef, 0xff, 0xff,
    0x9f, 0xff, 0xff, 0x70, 0x1f, 0xf0, 0x0, 0x4,
    0x0,

    /* U+00A4 "¤" */
    0x20, 0xfe, 0x11, 0xdf, 0xfe, 0xef, 0xff, 0xff,
    0xdf, 0xc1, 0xfe, 0x3e, 0x1, 0xf0, 0xf0, 0x3,
    0xe7, 0x80, 0x7, 0x9e, 0x0, 0x1e, 0xf0, 0x0,
    0x7f, 0xc0, 0x0, 0xff, 0x0, 0x3, 0xfc, 0x0,
    0xf, 0xf0, 0x0, 0x3f, 0xc0, 0x0, 0xff, 0x0,
    0x3, 0xde, 0x0, 0x1e, 0x78, 0x0, 0x79, 0xe0,
    0x3, 0xe3, 0xc0, 0xf, 0xf, 0xc0, 0xfe, 0x7f,
    0xff, 0xf9, 0xdf, 0xfe, 0xe3, 0x3f, 0xf1, 0x0,
    0x3f, 0x0,

    /* U+00A5 "¥" */
    0x78, 0x0, 0x7, 0x9e, 0x0, 0x3, 0xe3, 0xc0,
    0x0, 0xf0, 0xf0, 0x0, 0x3c, 0x1e, 0x0, 0x1e,
    0x7, 0x80, 0x7, 0x81, 0xf0, 0x3, 0xe0, 0x3c,
    0x0, 0xf0, 0xf, 0x80, 0x7c, 0x1, 0xe0, 0x1e,
    0x0, 0x7c, 0x7, 0x80, 0xf, 0x3, 0xc0, 0x3,
    0xe0, 0xf0, 0x0, 0x78, 0x78, 0x0, 0x1e, 0x1e,
    0x0, 0x3, 0xcf, 0x0, 0x0, 0xf3, 0xc0, 0x0,
    0x1e, 0xe0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x78, 0x0, 0xf, 0xff,
    0xf8, 0x3, 0xff, 0xfe, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x7,
    0x80, 0x0, 0xff, 0xff, 0x80, 0x3f, 0xff, 0xe0,
    0x0, 0x1e, 0x0, 0x0, 0x7, 0x80, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x1e, 0x0,
    0x0,

    /* U+00A6 "¦" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+00A7 "§" */
    0x0, 0xfe, 0x0, 0xf, 0xfe, 0x0, 0xff, 0xfc,
    0x3, 0xe1, 0xf0, 0x1f, 0x3, 0xe0, 0x78, 0x7,
    0x81, 0xe0, 0x1e, 0x7, 0x80, 0x78, 0x1e, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0xf8, 0x0, 0x3, 0xf0,
    0x0, 0x7, 0xf0, 0x0, 0xf, 0xe0, 0x0, 0xff,
    0xe0, 0x7, 0x9f, 0xc0, 0x3c, 0x3f, 0xc1, 0xe0,
    0x7f, 0x87, 0x0, 0x7f, 0x1c, 0x0, 0x7e, 0xf0,
    0x0, 0xfb, 0xc0, 0x1, 0xf7, 0x80, 0x3, 0xdf,
    0x0, 0xf, 0x3e, 0x0, 0x3c, 0xfe, 0x1, 0xe1,
    0xfc, 0x7, 0x81, 0xf8, 0x3c, 0x3, 0xfb, 0xe0,
    0x3, 0xff, 0x0, 0x3, 0xf8, 0x0, 0x7, 0xf0,
    0x0, 0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0x1f,
    0x0, 0x0, 0x3c, 0x3c, 0x0, 0xf0, 0xf0, 0x3,
    0xc3, 0xe0, 0xf, 0x7, 0x80, 0x7c, 0x1f, 0x83,
    0xe0, 0x3f, 0xff, 0x0, 0x7f, 0xf8, 0x0, 0x7f,
    0x80,

    /* U+00A8 "¨" */
    0xf1, 0xfe, 0x3f, 0xc7, 0xf8, 0xff, 0x1e,

    /* U+00A9 "©" */
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0xff, 0x81, 0xff, 0x0, 0x0,
    0x3, 0xf0, 0x0, 0x3f, 0x0, 0x0, 0x1f, 0x80,
    0x0, 0x1f, 0x80, 0x0, 0x7c, 0x0, 0x0, 0xf,
    0x80, 0x1, 0xe0, 0x0, 0x0, 0x7, 0x80, 0x7,
    0x80, 0x0, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x38, 0x0, 0x7f, 0xc0, 0x7,
    0x0, 0xf0, 0x3, 0xff, 0xf0, 0x7, 0x1, 0xc0,
    0x1f, 0xff, 0xf0, 0xf, 0x7, 0x0, 0x7e, 0x3,
    0xf0, 0xe, 0xe, 0x1, 0xf0, 0x1, 0xf0, 0x1c,
    0x38, 0x3, 0xc0, 0x1, 0xf0, 0x1c, 0x70, 0xf,
    0x80, 0x3, 0xe0, 0x38, 0xe0, 0x1e, 0x0, 0x3,
    0xc0, 0x33, 0x80, 0x3c, 0x0, 0x0, 0x0, 0x77,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0xee, 0x1, 0xe0,
    0x0, 0x0, 0x1, 0xdc, 0x3, 0xc0, 0x0, 0x0,
    0x1, 0xb8, 0x7, 0x80, 0x0, 0x0, 0x3, 0xe0,
    0xf, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0xc0, 0x3c, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x78, 0x0, 0x0, 0x0, 0x77, 0x0,
    0xf0, 0x0, 0xf, 0x80, 0xee, 0x1, 0xe0, 0x0,
    0x1f, 0x1, 0xdc, 0x1, 0xe0, 0x0, 0x3c, 0x3,
    0x9c, 0x3, 0xc0, 0x0, 0x78, 0xe, 0x38, 0x7,
    0xc0, 0x1, 0xf0, 0x1c, 0x70, 0x7, 0x80, 0x7,
    0xc0, 0x38, 0x70, 0xf, 0x80, 0x1f, 0x80, 0xe0,
    0xe0, 0xf, 0xc0, 0x7e, 0x1, 0xc0, 0xe0, 0xf,
    0xff, 0xf8, 0x7, 0x1, 0xe0, 0x7, 0xff, 0xc0,
    0x1e, 0x1, 0xe0, 0x3, 0xfe, 0x0, 0x38, 0x1,
    0xe0, 0x0, 0x0, 0x0, 0xe0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xc0, 0x3, 0xe0, 0x0, 0x0, 0x1f,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x7c, 0x0, 0x1,
    0xf8, 0x0, 0x3, 0xe0, 0x0, 0x1, 0xfe, 0x0,
    0x3f, 0x80, 0x0, 0x0, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x7f, 0xff, 0xe0, 0x0, 0x0, 0x0,
    0xf, 0xfc, 0x0, 0x0, 0x0,

    /* U+00AA "ª" */
    0x1f, 0x81, 0x86, 0x18, 0x38, 0x1, 0xc0, 0xe,
    0x0, 0xf0, 0x3f, 0x8f, 0x9c, 0x70, 0xe7, 0x7,
    0x38, 0x39, 0xc1, 0xcf, 0x1e, 0x3f, 0xbc, 0xf8,
    0xc0, 0x0, 0x0, 0x3, 0xff, 0x9f, 0xfc,

    /* U+00AB "«" */
    0x2, 0x1, 0x6, 0x3, 0xe, 0x7, 0x1e, 0xf,
    0x3c, 0x1e, 0x78, 0x3c, 0x78, 0x78, 0xf0, 0xf0,
    0xe0, 0xe0, 0xe0, 0xf0, 0xf0, 0x78, 0x78, 0x3c,
    0x3c, 0x1e, 0x1e, 0xf, 0xe, 0x7, 0x6, 0x3,
    0x2, 0x1, 0x0, 0x0,

    /* U+00AC "¬" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0xf0, 0x0, 0x7, 0x80, 0x0, 0x3c,
    0x0, 0x1, 0xe0, 0x0, 0xf, 0x0, 0x0, 0x78,
    0x0, 0x3, 0xc0, 0x0, 0x1e, 0x0, 0x0, 0xf0,
    0x0, 0x7, 0x80,

    /* U+00AD "­" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+00AE "®" */
    0x0, 0x0, 0x3f, 0xf8, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xfe, 0x0, 0x0, 0x0, 0x1f, 0xfb, 0xff,
    0x80, 0x0, 0x0, 0xfe, 0x0, 0x3f, 0x80, 0x0,
    0x7, 0xe0, 0x0, 0xf, 0xc0, 0x0, 0x1f, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x7c, 0x0, 0x0, 0x3,
    0xc0, 0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x7,
    0x80, 0x0, 0x0, 0x3, 0xc0, 0xe, 0xf, 0xff,
    0xe0, 0x3, 0xc0, 0x38, 0x1f, 0xff, 0xf8, 0x3,
    0x80, 0xf0, 0x3f, 0xff, 0xf8, 0x3, 0x81, 0xc0,
    0x7f, 0xff, 0xf8, 0x7, 0x7, 0x80, 0xf0, 0x3,
    0xf0, 0x7, 0xe, 0x1, 0xe0, 0x1, 0xf0, 0xe,
    0x1c, 0x3, 0xc0, 0x1, 0xe0, 0xe, 0x70, 0x7,
    0x80, 0x3, 0xc0, 0x1c, 0xe0, 0xf, 0x0, 0x7,
    0x80, 0x39, 0xc0, 0x1e, 0x0, 0xf, 0x0, 0x3b,
    0x0, 0x3c, 0x0, 0x3e, 0x0, 0x7e, 0x0, 0x78,
    0x0, 0x78, 0x0, 0xfc, 0x0, 0xf0, 0x3, 0xe0,
    0x1, 0xf8, 0x1, 0xff, 0xff, 0x80, 0x3, 0xf0,
    0x3, 0xff, 0xfc, 0x0, 0x7, 0xe0, 0x7, 0xff,
    0xfe, 0x0, 0xf, 0xc0, 0xf, 0x0, 0x7e, 0x0,
    0x1f, 0x80, 0x1e, 0x0, 0x3e, 0x0, 0x3b, 0x80,
    0x3c, 0x0, 0x3c, 0x0, 0x77, 0x0, 0x78, 0x0,
    0x78, 0x0, 0xce, 0x0, 0xf0, 0x0, 0xf0, 0x3,
    0x9c, 0x1, 0xe0, 0x1, 0xe0, 0x7, 0x1c, 0x3,
    0xc0, 0x3, 0xc0, 0xe, 0x38, 0x7, 0x80, 0x7,
    0x80, 0x38, 0x38, 0xf, 0x0, 0xf, 0x0, 0x70,
    0x70, 0x1e, 0x0, 0xf, 0x1, 0xc0, 0x70, 0x3c,
    0x0, 0x1e, 0x7, 0x80, 0xf0, 0x78, 0x0, 0x1f,
    0xe, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x38, 0x0,
    0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0xf0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0xf0, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0xfe, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x7f, 0xc1,
    0xff, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf8, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x0,

    /* U+00AF "¯" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+00B0 "°" */
    0x1e, 0x1f, 0xc6, 0x1b, 0x3, 0xc0, 0xf0, 0x3e,
    0x1d, 0xc6, 0x3f, 0x7, 0x0,

    /* U+00B1 "±" */
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0xf, 0x0, 0x0, 0xf0,
    0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+00B2 "²" */
    0x1f, 0x81, 0xff, 0x1e, 0x39, 0xe0, 0xee, 0x7,
    0x70, 0x3b, 0x81, 0xc0, 0xe, 0x0, 0xf0, 0x7,
    0x0, 0x78, 0x7, 0x80, 0xf8, 0xf, 0x80, 0xf8,
    0x7, 0x80, 0x78, 0x3, 0x80, 0x38, 0x1, 0xc0,
    0xf, 0xff, 0xff, 0xfc,

    /* U+00B3 "³" */
    0xf, 0xc0, 0xff, 0x8e, 0x1c, 0xe0, 0x77, 0x3,
    0xb8, 0x1c, 0x0, 0xe0, 0x7, 0x0, 0x70, 0x3f,
    0x1, 0xf0, 0xf, 0xe0, 0xf, 0x0, 0x3c, 0x0,
    0xe0, 0x7, 0x70, 0x3b, 0x81, 0xdc, 0xe, 0xe0,
    0xe3, 0xff, 0xf, 0xf0, 0x8, 0x0,

    /* U+00B4 "´" */
    0xf, 0x8f, 0x87, 0x87, 0x87, 0x83, 0x83, 0xc0,

    /* U+00B5 "µ" */
    0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1, 0xfe, 0x0,
    0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f, 0xe0,
    0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1, 0xfe,
    0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x7f, 0xc0,
    0x7f, 0xf0, 0x7f, 0xff, 0xf7, 0xff, 0xf3, 0xff,
    0xf1, 0xfe, 0x40, 0xf, 0x0, 0x7, 0x80, 0x3,
    0xc0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0x78, 0x0,
    0x0,

    /* U+00B6 "¶" */
    0x3, 0xff, 0xe1, 0xff, 0xfc, 0x7f, 0xff, 0x9f,
    0xf8, 0xf3, 0xff, 0x1e, 0xff, 0xe3, 0xdf, 0xfc,
    0x7b, 0xff, 0x8f, 0x7f, 0xf1, 0xef, 0xfe, 0x3d,
    0xff, 0xc7, 0xbf, 0xf8, 0xf7, 0xff, 0x1e, 0xff,
    0xe3, 0xcf, 0xfc, 0x79, 0xff, 0x8f, 0x1f, 0xf1,
    0xe1, 0xfe, 0x3c, 0x3, 0xc7, 0x80, 0x78, 0xf0,
    0xf, 0x1e, 0x1, 0xe3, 0xc0, 0x3c, 0x78, 0x7,
    0x8f, 0x0, 0xf1, 0xe0, 0x1e, 0x3c, 0x3, 0xc7,
    0x80, 0x78, 0xf0, 0xf, 0x1e, 0x1, 0xe3, 0xc0,
    0x3c, 0x78, 0x7, 0x8f, 0x0, 0xf1, 0xe0, 0x1e,
    0x3c, 0x3, 0xc7, 0x80, 0x78, 0xf0, 0xf, 0x1e,
    0x1, 0xe3, 0xc0, 0x3c, 0x78, 0x7, 0x8f, 0x0,
    0xf1, 0xe0, 0x1e, 0x3c,

    /* U+00B7 "·" */
    0x3c, 0x3f, 0xbf, 0xdf, 0xff, 0xff, 0xff, 0xfe,
    0xfe, 0x3e, 0x0,

    /* U+00B8 "¸" */
    0xc, 0x3, 0xe0, 0xff, 0x0, 0xe0, 0x1c, 0x3,
    0xbf, 0xc0,

    /* U+00B9 "¹" */
    0x7, 0x7, 0x7, 0x1f, 0xff, 0xff, 0x7, 0x7,
    0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7, 0x7,
    0x7, 0x7, 0x7, 0x7, 0x7, 0x7,

    /* U+00BA "º" */
    0x1f, 0x81, 0x87, 0x18, 0x1d, 0xc0, 0xec, 0x3,
    0xe0, 0x1f, 0x0, 0xf8, 0x7, 0xc0, 0x3e, 0x1,
    0xd0, 0xc, 0xc0, 0xe3, 0xe, 0x7, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xff, 0xbf, 0xfc,

    /* U+00BB "»" */
    0x80, 0x80, 0xc0, 0xc0, 0xe0, 0xe0, 0xf0, 0xf0,
    0x70, 0x78, 0x38, 0x3c, 0x3c, 0x1e, 0x1e, 0xf,
    0xe, 0x7, 0xe, 0x7, 0x1e, 0xf, 0x3c, 0x1e,
    0x78, 0x3c, 0xf0, 0x78, 0xe0, 0xf0, 0xc0, 0xe0,
    0x80, 0xc0, 0x0, 0x80,

    /* U+00BC "¼" */
    0x7, 0x0, 0x0, 0x1c, 0x3, 0x80, 0x0, 0x1c,
    0x1, 0xc0, 0x0, 0x1c, 0x1, 0xe0, 0x0, 0xe,
    0xf, 0xf0, 0x0, 0xe, 0x7, 0xf8, 0x0, 0x7,
    0x0, 0x1c, 0x0, 0x7, 0x0, 0xe, 0x0, 0x3,
    0x80, 0x7, 0x0, 0x3, 0x80, 0x3, 0x80, 0x3,
    0x80, 0x1, 0xc0, 0x1, 0xc0, 0x0, 0xe0, 0x1,
    0xc0, 0x0, 0x70, 0x0, 0xe0, 0x0, 0x38, 0x0,
    0xe0, 0x0, 0x1c, 0x0, 0xe0, 0x0, 0xe, 0x0,
    0x70, 0x1c, 0x7, 0x0, 0x70, 0x1e, 0x3, 0x80,
    0x38, 0xf, 0x1, 0xc0, 0x38, 0xf, 0x80, 0xe0,
    0x1c, 0x7, 0xc0, 0x70, 0x1c, 0x6, 0xe0, 0x38,
    0x1c, 0x6, 0x70, 0x0, 0xe, 0x3, 0x38, 0x0,
    0xe, 0x3, 0x1c, 0x0, 0x7, 0x1, 0x8e, 0x0,
    0x7, 0x1, 0x87, 0x0, 0x7, 0x1, 0x83, 0x80,
    0x3, 0x80, 0xc1, 0xc0, 0x3, 0x80, 0xc0, 0xe0,
    0x1, 0xc0, 0x7f, 0xfc, 0x1, 0xc0, 0x3f, 0xfe,
    0x0, 0xe0, 0x1f, 0xff, 0x0, 0xe0, 0x0, 0xe,
    0x0, 0xe0, 0x0, 0x7, 0x0, 0x70, 0x0, 0x3,
    0x80, 0x70, 0x0, 0x1, 0xc0, 0x38, 0x0, 0x0,
    0xe0,

    /* U+00BD "½" */
    0x7, 0x0, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xe0,
    0x7, 0x0, 0x1, 0xc0, 0xf, 0x0, 0x3, 0x80,
    0xff, 0x0, 0x3, 0x80, 0xff, 0x0, 0x7, 0x0,
    0x7, 0x0, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x38, 0x0, 0x7, 0x0, 0x38, 0x0,
    0x7, 0x0, 0x70, 0x0, 0x7, 0x0, 0xe0, 0x0,
    0x7, 0x0, 0xe0, 0x0, 0x7, 0x1, 0xc1, 0xf8,
    0x7, 0x1, 0xc3, 0xfe, 0x7, 0x3, 0x87, 0xfe,
    0x7, 0x7, 0xf, 0xf, 0x7, 0x7, 0xe, 0x7,
    0x7, 0xe, 0xe, 0x7, 0x7, 0xe, 0xe, 0x7,
    0x0, 0x1c, 0x0, 0x7, 0x0, 0x38, 0x0, 0x6,
    0x0, 0x38, 0x0, 0xe, 0x0, 0x70, 0x0, 0x1c,
    0x0, 0x70, 0x0, 0x38, 0x0, 0xe0, 0x0, 0x70,
    0x1, 0xc0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0xc0,
    0x3, 0x80, 0x7, 0x80, 0x3, 0x80, 0xf, 0x0,
    0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1e, 0x0,
    0xe, 0x0, 0x1f, 0xff, 0x1c, 0x0, 0x1f, 0xff,
    0x1c, 0x0, 0x1f, 0xff,

    /* U+00BE "¾" */
    0xf, 0xc0, 0x0, 0x7, 0x3, 0xfc, 0x0, 0x1,
    0xc0, 0xff, 0xc0, 0x0, 0x78, 0x3c, 0x3c, 0x0,
    0xe, 0x7, 0x3, 0x80, 0x3, 0x80, 0xe0, 0x70,
    0x0, 0x70, 0x1c, 0xe, 0x0, 0x1c, 0x0, 0x1,
    0xc0, 0x7, 0x80, 0x0, 0x70, 0x0, 0xe0, 0x0,
    0xfc, 0x0, 0x38, 0x0, 0x1f, 0x0, 0x7, 0x0,
    0x3, 0xf8, 0x1, 0xc0, 0x0, 0xf, 0x0, 0x38,
    0x0, 0x0, 0xf0, 0xe, 0x0, 0x0, 0xe, 0x3,
    0x80, 0x0, 0x1, 0xc0, 0x70, 0x1c, 0x70, 0x38,
    0x1c, 0x7, 0x8e, 0x7, 0x3, 0x81, 0xf1, 0xc0,
    0xe0, 0xe0, 0x3e, 0x3c, 0x38, 0x18, 0xd, 0xc3,
    0xff, 0x7, 0x1, 0xb8, 0x7f, 0xc1, 0xc0, 0x67,
    0x3, 0xf0, 0x38, 0x18, 0xe0, 0x0, 0xe, 0x3,
    0x1c, 0x0, 0x1, 0x80, 0xc3, 0x80, 0x0, 0x70,
    0x38, 0x70, 0x0, 0x1c, 0x6, 0xe, 0x0, 0x3,
    0x81, 0x81, 0xc0, 0x0, 0xe0, 0x30, 0x38, 0x0,
    0x18, 0xf, 0xff, 0xc0, 0x7, 0x1, 0xff, 0xf8,
    0x0, 0xc0, 0x3f, 0xff, 0x0, 0x38, 0x0, 0x3,
    0x80, 0xe, 0x0, 0x0, 0x70, 0x1, 0xc0, 0x0,
    0xe, 0x0, 0x70, 0x0, 0x1, 0xc0, 0xc, 0x0,
    0x0, 0x38,

    /* U+00BF "¿" */
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x3, 0xc0, 0x0,
    0x78, 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1e, 0x0,
    0x3, 0xc0, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3,
    0xe0, 0x0, 0xf8, 0x0, 0x1f, 0x0, 0x7, 0xc0,
    0x1, 0xf0, 0x0, 0x7c, 0x0, 0x1f, 0x0, 0x3,
    0xc0, 0x0, 0xf8, 0x0, 0x1e, 0x0, 0x7, 0xc0,
    0x0, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x1, 0xff, 0x0, 0x3c, 0xf0, 0xf, 0x9f,
    0x3, 0xe1, 0xff, 0xfc, 0x1f, 0xfe, 0x0, 0xff,
    0x0,

    /* U+00C0 "À" */
    0x1, 0xf0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x38, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0xf, 0xe0, 0x0, 0x7, 0xf0,
    0x0, 0x3, 0xf8, 0x0, 0x1, 0xdc, 0x0, 0x1,
    0xef, 0x0, 0x0, 0xe7, 0x80, 0x0, 0x73, 0xc0,
    0x0, 0x78, 0xe0, 0x0, 0x3c, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0xe, 0x1e, 0x0, 0xf, 0x7, 0x80,
    0x7, 0x83, 0xc0, 0x3, 0xc1, 0xe0, 0x1, 0xc0,
    0xf0, 0x1, 0xe0, 0x7c, 0x0, 0xf0, 0x1e, 0x0,
    0x78, 0xf, 0x0, 0x78, 0x7, 0x80, 0x3c, 0x3,
    0xe0, 0x1e, 0x0, 0xf0, 0xf, 0x0, 0x78, 0xf,
    0xff, 0xfe, 0x7, 0xff, 0xff, 0x3, 0xff, 0xff,
    0x83, 0xc0, 0x3, 0xc1, 0xe0, 0x1, 0xf0, 0xf0,
    0x0, 0x78, 0x78, 0x0, 0x3c, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0xf, 0x9e, 0x0, 0x3, 0xcf, 0x0,
    0x1, 0xef, 0x0, 0x0, 0xff, 0x80, 0x0, 0x7f,
    0xc0, 0x0, 0x1e,

    /* U+00C1 "Á" */
    0x0, 0x7, 0xc0, 0x0, 0x3, 0xc0, 0x0, 0x3,
    0xc0, 0x0, 0x3, 0xe0, 0x0, 0x1, 0xe0, 0x0,
    0x1, 0xe0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0xf, 0xe0, 0x0, 0x7, 0xf0,
    0x0, 0x3, 0xf8, 0x0, 0x1, 0xdc, 0x0, 0x1,
    0xef, 0x0, 0x0, 0xe7, 0x80, 0x0, 0x73, 0xc0,
    0x0, 0x78, 0xe0, 0x0, 0x3c, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0xe, 0x1e, 0x0, 0xf, 0x7, 0x80,
    0x7, 0x83, 0xc0, 0x3, 0xc1, 0xe0, 0x1, 0xc0,
    0xf0, 0x1, 0xe0, 0x7c, 0x0, 0xf0, 0x1e, 0x0,
    0x78, 0xf, 0x0, 0x78, 0x7, 0x80, 0x3c, 0x3,
    0xe0, 0x1e, 0x0, 0xf0, 0xf, 0x0, 0x78, 0xf,
    0xff, 0xfe, 0x7, 0xff, 0xff, 0x3, 0xff, 0xff,
    0x83, 0xc0, 0x3, 0xc1, 0xe0, 0x1, 0xf0, 0xf0,
    0x0, 0x78, 0x78, 0x0, 0x3c, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0xf, 0x9e, 0x0, 0x3, 0xcf, 0x0,
    0x1, 0xef, 0x0, 0x0, 0xff, 0x80, 0x0, 0x7f,
    0xc0, 0x0, 0x1e,

    /* U+00C2 "Â" */
    0x0, 0x3e, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x3f,
    0xc0, 0x0, 0x1e, 0xf0, 0x0, 0x1e, 0x3c, 0x0,
    0x1e, 0x1e, 0x0, 0xf, 0x7, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0xf, 0xe0, 0x0, 0x7, 0xf0,
    0x0, 0x3, 0xf8, 0x0, 0x1, 0xdc, 0x0, 0x1,
    0xef, 0x0, 0x0, 0xe7, 0x80, 0x0, 0x73, 0xc0,
    0x0, 0x78, 0xe0, 0x0, 0x3c, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0xe, 0x1e, 0x0, 0xf, 0x7, 0x80,
    0x7, 0x83, 0xc0, 0x3, 0xc1, 0xe0, 0x1, 0xc0,
    0xf0, 0x1, 0xe0, 0x7c, 0x0, 0xf0, 0x1e, 0x0,
    0x78, 0xf, 0x0, 0x78, 0x7, 0x80, 0x3c, 0x3,
    0xe0, 0x1e, 0x0, 0xf0, 0xf, 0x0, 0x78, 0xf,
    0xff, 0xfe, 0x7, 0xff, 0xff, 0x3, 0xff, 0xff,
    0x83, 0xc0, 0x3, 0xc1, 0xe0, 0x1, 0xf0, 0xf0,
    0x0, 0x78, 0x78, 0x0, 0x3c, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0xf, 0x9e, 0x0, 0x3, 0xcf, 0x0,
    0x1, 0xef, 0x0, 0x0, 0xff, 0x80, 0x0, 0x7f,
    0xc0, 0x0, 0x1e,

    /* U+00C3 "Ã" */
    0x1, 0xe0, 0x30, 0x1, 0xfc, 0x38, 0x1, 0xff,
    0xfc, 0x0, 0xe3, 0xfc, 0x0, 0xe0, 0x7c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x1f, 0xc0, 0x0, 0xf, 0xe0, 0x0, 0x7, 0xf0,
    0x0, 0x3, 0xb8, 0x0, 0x3, 0xde, 0x0, 0x1,
    0xcf, 0x0, 0x0, 0xe7, 0x80, 0x0, 0xf1, 0xc0,
    0x0, 0x78, 0xf0, 0x0, 0x3c, 0x78, 0x0, 0x1c,
    0x3c, 0x0, 0x1e, 0xf, 0x0, 0xf, 0x7, 0x80,
    0x7, 0x83, 0xc0, 0x3, 0x81, 0xe0, 0x3, 0xc0,
    0xf8, 0x1, 0xe0, 0x3c, 0x0, 0xf0, 0x1e, 0x0,
    0xf0, 0xf, 0x0, 0x78, 0x7, 0xc0, 0x3c, 0x1,
    0xe0, 0x1e, 0x0, 0xf0, 0x1f, 0xff, 0xfc, 0xf,
    0xff, 0xfe, 0x7, 0xff, 0xff, 0x7, 0x80, 0x7,
    0x83, 0xc0, 0x3, 0xe1, 0xe0, 0x0, 0xf0, 0xf0,
    0x0, 0x78, 0xf0, 0x0, 0x3c, 0x78, 0x0, 0x1f,
    0x3c, 0x0, 0x7, 0x9e, 0x0, 0x3, 0xde, 0x0,
    0x1, 0xff, 0x0, 0x0, 0xff, 0x80, 0x0, 0x3c,

    /* U+00C4 "Ä" */
    0x1, 0xe3, 0xc0, 0x0, 0xf1, 0xe0, 0x0, 0x78,
    0xf0, 0x0, 0x3c, 0x78, 0x0, 0x1e, 0x3c, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0xf, 0xe0, 0x0, 0x7, 0x70,
    0x0, 0x3, 0xb8, 0x0, 0x1, 0xde, 0x0, 0x1,
    0xef, 0x0, 0x0, 0xe3, 0x80, 0x0, 0x71, 0xc0,
    0x0, 0x78, 0xf0, 0x0, 0x3c, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0xe, 0xf, 0x0, 0xf, 0x7, 0x80,
    0x7, 0x83, 0xc0, 0x3, 0xc1, 0xe0, 0x3, 0xc0,
    0x78, 0x1, 0xe0, 0x3c, 0x0, 0xf0, 0x1e, 0x0,
    0x78, 0xf, 0x80, 0x78, 0x7, 0xc0, 0x3c, 0x1,
    0xe0, 0x1e, 0x0, 0xf0, 0xf, 0xff, 0xfc, 0xf,
    0xff, 0xfe, 0x7, 0xff, 0xff, 0x3, 0xc0, 0x7,
    0x83, 0xc0, 0x3, 0xe1, 0xe0, 0x0, 0xf0, 0xf0,
    0x0, 0x78, 0x78, 0x0, 0x3e, 0x78, 0x0, 0x1f,
    0x3c, 0x0, 0x7, 0x9e, 0x0, 0x3, 0xdf, 0x0,
    0x1, 0xff, 0x0, 0x0, 0xff, 0x80, 0x0, 0x3c,

    /* U+00C5 "Å" */
    0x0, 0x3f, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x6,
    0x18, 0x0, 0x3, 0x3, 0x0, 0x0, 0xc0, 0xc0,
    0x0, 0x30, 0x30, 0x0, 0x6, 0x18, 0x0, 0x1,
    0xfe, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0x3f, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x3, 0xf8,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x73, 0x80, 0x0,
    0x1c, 0xf0, 0x0, 0xf, 0x3c, 0x0, 0x3, 0xcf,
    0x0, 0x0, 0xe1, 0xc0, 0x0, 0x38, 0x78, 0x0,
    0x1e, 0x1e, 0x0, 0x7, 0x87, 0x80, 0x1, 0xe1,
    0xf0, 0x0, 0x70, 0x3c, 0x0, 0x3c, 0xf, 0x0,
    0xf, 0x3, 0xc0, 0x3, 0xc0, 0xf8, 0x1, 0xe0,
    0x1e, 0x0, 0x78, 0x7, 0x80, 0x1e, 0x1, 0xe0,
    0x7, 0x80, 0x7c, 0x3, 0xc0, 0xf, 0x0, 0xff,
    0xff, 0xc0, 0x3f, 0xff, 0xf8, 0x1f, 0xff, 0xfe,
    0x7, 0x80, 0x7, 0x81, 0xe0, 0x1, 0xe0, 0x78,
    0x0, 0x7c, 0x3c, 0x0, 0xf, 0xf, 0x0, 0x3,
    0xc3, 0xc0, 0x0, 0xf1, 0xf0, 0x0, 0x3e, 0x78,
    0x0, 0x7, 0x9e, 0x0, 0x1, 0xe7, 0x80, 0x0,
    0x7f, 0xe0, 0x0, 0x1f,

    /* U+00C6 "Æ" */
    0x0, 0x0, 0x7f, 0xff, 0xfc, 0x0, 0x3, 0xff,
    0xff, 0xf0, 0x0, 0xf, 0xff, 0xff, 0xc0, 0x0,
    0x3b, 0xc0, 0x0, 0x0, 0x1, 0xef, 0x0, 0x0,
    0x0, 0x7, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0xf0,
    0x0, 0x0, 0x0, 0xe3, 0xc0, 0x0, 0x0, 0x7,
    0x8f, 0x0, 0x0, 0x0, 0x1c, 0x3c, 0x0, 0x0,
    0x0, 0xf0, 0xf0, 0x0, 0x0, 0x3, 0xc3, 0xc0,
    0x0, 0x0, 0x1e, 0xf, 0x0, 0x0, 0x0, 0x78,
    0x3c, 0x0, 0x0, 0x3, 0xc0, 0xf0, 0x0, 0x0,
    0xf, 0x3, 0xc0, 0x0, 0x0, 0x78, 0xf, 0xff,
    0xf8, 0x1, 0xe0, 0x3f, 0xff, 0xe0, 0xf, 0x80,
    0xff, 0xff, 0x80, 0x3c, 0x3, 0xc0, 0x0, 0x1,
    0xf0, 0xf, 0x0, 0x0, 0x7, 0x80, 0x3c, 0x0,
    0x0, 0x3e, 0x0, 0xf0, 0x0, 0x0, 0xff, 0xff,
    0xc0, 0x0, 0x7, 0xff, 0xff, 0x0, 0x0, 0x1f,
    0xff, 0xfc, 0x0, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0x3, 0xc0, 0x3, 0xc0, 0x0, 0xf, 0x0, 0xf,
    0x0, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x1, 0xe0,
    0x0, 0xf0, 0x0, 0xf, 0x80, 0x3, 0xc0, 0x0,
    0x3c, 0x0, 0xf, 0x0, 0x1, 0xf0, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x0, 0xff, 0xff, 0xbe, 0x0,
    0x3, 0xff, 0xfe, 0xf0, 0x0, 0xf, 0xff, 0xf8,

    /* U+00C7 "Ç" */
    0x0, 0xff, 0x0, 0xf, 0xff, 0x0, 0x7f, 0xfe,
    0x3, 0xe0, 0xfc, 0x1e, 0x0, 0xf8, 0xf8, 0x1,
    0xe3, 0xc0, 0x7, 0x8f, 0x0, 0xf, 0x78, 0x0,
    0x3d, 0xe0, 0x0, 0xf7, 0x80, 0x3, 0xdc, 0x0,
    0x0, 0xf0, 0x0, 0x3, 0xc0, 0x0, 0xf, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0xf0, 0x0, 0x3, 0xc0,
    0x0, 0xf, 0x0, 0x0, 0x3c, 0x0, 0x0, 0xf0,
    0x0, 0x3, 0xc0, 0x0, 0xf, 0x0, 0x0, 0x3c,
    0x0, 0xf, 0xf0, 0x0, 0x3f, 0xe0, 0x0, 0xf7,
    0x80, 0x3, 0xde, 0x0, 0xf, 0x78, 0x0, 0x3d,
    0xf0, 0x1, 0xf3, 0xc0, 0x7, 0x8f, 0x80, 0x3e,
    0x1f, 0x0, 0xf0, 0x7e, 0xf, 0xc0, 0xff, 0xfe,
    0x1, 0xff, 0xf0, 0x1, 0xff, 0x0, 0x0, 0xc0,
    0x0, 0x7, 0xe0, 0x0, 0x33, 0xc0, 0x0, 0x7,
    0x80, 0x4, 0x1c, 0x0, 0x1f, 0xf0, 0x0, 0x7f,
    0x0,

    /* U+00C8 "È" */
    0x1f, 0x0, 0x7, 0xc0, 0x0, 0xf8, 0x0, 0x1e,
    0x0, 0x3, 0xc0, 0x0, 0x78, 0x0, 0xe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0xf,
    0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0,
    0x3c, 0x0, 0xf, 0xff, 0xfb, 0xff, 0xfe, 0xff,
    0xff, 0xbc, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc,

    /* U+00C9 "É" */
    0x0, 0x7c, 0x0, 0x1e, 0x0, 0xf, 0x80, 0x7,
    0xc0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0x38, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0xf,
    0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0,
    0x3c, 0x0, 0xf, 0xff, 0xfb, 0xff, 0xfe, 0xff,
    0xff, 0xbc, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc,

    /* U+00CA "Ê" */
    0x3, 0xe0, 0x1, 0xfc, 0x0, 0x7f, 0x0, 0x3d,
    0xe0, 0x1e, 0x3c, 0x7, 0x7, 0x3, 0xc1, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0, 0xf,
    0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0,
    0x3c, 0x0, 0xf, 0xff, 0xfb, 0xff, 0xfe, 0xff,
    0xff, 0xbc, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc,

    /* U+00CB "Ë" */
    0x1e, 0x3c, 0x7, 0x8f, 0x1, 0xe3, 0xc0, 0x78,
    0xf0, 0x1e, 0x3c, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x3, 0xc0, 0x0, 0xf0, 0x0,
    0x3f, 0xff, 0xef, 0xff, 0xfb, 0xff, 0xfe, 0xf0,
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+00CC "Ì" */
    0xf8, 0x3e, 0xf, 0x83, 0xc0, 0xf0, 0x38, 0xe,
    0x0, 0x0, 0x0, 0x3, 0xc1, 0xe0, 0xf0, 0x78,
    0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1, 0xe0, 0xf0,
    0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1, 0xe0,
    0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1,
    0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83,
    0xc1, 0xe0, 0xf0, 0x78, 0x3c,

    /* U+00CD "Í" */
    0xf, 0x8f, 0x87, 0x87, 0x87, 0x83, 0x83, 0xc0,
    0x0, 0x0, 0x0, 0x1e, 0xf, 0x7, 0x83, 0xc1,
    0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83,
    0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7,
    0x83, 0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf,
    0x7, 0x83, 0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e,
    0xf, 0x7, 0x83, 0xc1, 0xe0,

    /* U+00CE "Î" */
    0xf, 0xc0, 0x3f, 0x1, 0xfe, 0x7, 0x3c, 0x3c,
    0x71, 0xe1, 0xe7, 0x3, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x78, 0x1, 0xe0, 0x7, 0x80, 0x1e,
    0x0, 0x78, 0x1, 0xe0, 0x7, 0x80, 0x1e, 0x0,
    0x78, 0x1, 0xe0, 0x7, 0x80, 0x1e, 0x0, 0x78,
    0x1, 0xe0, 0x7, 0x80, 0x1e, 0x0, 0x78, 0x1,
    0xe0, 0x7, 0x80, 0x1e, 0x0, 0x78, 0x1, 0xe0,
    0x7, 0x80, 0x1e, 0x0, 0x78, 0x1, 0xe0, 0x7,
    0x80, 0x1e, 0x0, 0x78, 0x1, 0xe0, 0x7, 0x80,
    0x1e, 0x0, 0x78, 0x1, 0xe0, 0x7, 0x80, 0x1e,
    0x0, 0x78, 0x0,

    /* U+00CF "Ï" */
    0xf1, 0xfe, 0x3f, 0xc7, 0xf8, 0xff, 0x1e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe0, 0x3c, 0x7,
    0x80, 0xf0, 0x1e, 0x3, 0xc0, 0x78, 0xf, 0x1,
    0xe0, 0x3c, 0x7, 0x80, 0xf0, 0x1e, 0x3, 0xc0,
    0x78, 0xf, 0x1, 0xe0, 0x3c, 0x7, 0x80, 0xf0,
    0x1e, 0x3, 0xc0, 0x78, 0xf, 0x1, 0xe0, 0x3c,
    0x7, 0x80, 0xf0, 0x1e, 0x3, 0xc0, 0x78, 0xf,
    0x1, 0xe0, 0x3c, 0x7, 0x80, 0xf0, 0x1e, 0x0,

    /* U+00D0 "Ð" */
    0xf, 0xff, 0x80, 0x3, 0xff, 0xfc, 0x0, 0xff,
    0xff, 0x80, 0x3c, 0x1, 0xf0, 0xf, 0x0, 0x3e,
    0x3, 0xc0, 0x7, 0x80, 0xf0, 0x0, 0xf0, 0x3c,
    0x0, 0x3c, 0xf, 0x0, 0x7, 0x83, 0xc0, 0x1,
    0xe0, 0xf0, 0x0, 0x78, 0x3c, 0x0, 0xe, 0xf,
    0x0, 0x3, 0xc3, 0xc0, 0x0, 0xff, 0xff, 0xe0,
    0x3f, 0xff, 0xf8, 0xf, 0xff, 0xfe, 0x3, 0xc3,
    0xc0, 0x0, 0xf0, 0xf0, 0x0, 0x3c, 0x3c, 0x0,
    0xf, 0xf, 0x0, 0x3, 0xc3, 0xc0, 0x0, 0xf0,
    0xf0, 0x0, 0x3c, 0x3c, 0x0, 0xf, 0xf, 0x0,
    0x3, 0xc3, 0xc0, 0x1, 0xf0, 0xf0, 0x0, 0x78,
    0x3c, 0x0, 0x1e, 0xf, 0x0, 0x7, 0x83, 0xc0,
    0x3, 0xc0, 0xf0, 0x0, 0xf0, 0x3c, 0x0, 0x7c,
    0xf, 0x0, 0x1e, 0x3, 0xc0, 0x1f, 0x0, 0xff,
    0xff, 0x80, 0x3f, 0xff, 0xc0, 0xf, 0xff, 0xc0,
    0x0,

    /* U+00D1 "Ñ" */
    0x3, 0xc0, 0x60, 0x3f, 0xc3, 0x80, 0xff, 0xfe,
    0x7, 0x1f, 0xf0, 0x18, 0xf, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xf8, 0x0, 0xff, 0xe0, 0x3, 0xff, 0x80,
    0xf, 0xff, 0x0, 0x3f, 0xfc, 0x0, 0xff, 0x70,
    0x3, 0xfd, 0xe0, 0xf, 0xf7, 0x80, 0x3f, 0xce,
    0x0, 0xff, 0x3c, 0x3, 0xfc, 0xf0, 0xf, 0xf1,
    0xc0, 0x3f, 0xc7, 0x80, 0xff, 0x1e, 0x3, 0xfc,
    0x38, 0xf, 0xf0, 0xf0, 0x3f, 0xc3, 0xc0, 0xff,
    0x7, 0x3, 0xfc, 0x1e, 0xf, 0xf0, 0x38, 0x3f,
    0xc0, 0xf0, 0xff, 0x3, 0xc3, 0xfc, 0x7, 0xf,
    0xf0, 0x1e, 0x3f, 0xc0, 0x78, 0xff, 0x0, 0xe3,
    0xfc, 0x3, 0xcf, 0xf0, 0xf, 0x3f, 0xc0, 0x1c,
    0xff, 0x0, 0x7b, 0xfc, 0x1, 0xef, 0xf0, 0x3,
    0xbf, 0xc0, 0xe, 0xff, 0x0, 0x3f, 0xfc, 0x0,
    0x7f, 0xf0, 0x1, 0xff, 0xc0, 0x7, 0xf0,

    /* U+00D2 "Ò" */
    0x3, 0xe0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x1e, 0x0, 0x0, 0xe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x0, 0x1, 0xff, 0x80, 0x7, 0xff, 0xe0, 0xf,
    0xff, 0xf0, 0x1f, 0x0, 0xf8, 0x1e, 0x0, 0x78,
    0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c, 0x78, 0x0,
    0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c, 0x3e, 0x0,
    0x7c, 0x1f, 0x0, 0xf8, 0xf, 0xc3, 0xf0, 0xf,
    0xff, 0xf0, 0x3, 0xff, 0xc0, 0x1, 0xff, 0x80,
    0x0, 0x10, 0x0,

    /* U+00D3 "Ó" */
    0x0, 0x7, 0xc0, 0x0, 0xf, 0x80, 0x0, 0xf,
    0x80, 0x0, 0x1f, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x78, 0x0, 0x0, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x0, 0x1, 0xff, 0x80, 0x7, 0xff, 0xe0, 0xf,
    0xff, 0xf0, 0x1f, 0x0, 0xf8, 0x1e, 0x0, 0x78,
    0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c, 0x78, 0x0,
    0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c, 0x3e, 0x0,
    0x7c, 0x1f, 0x0, 0xf8, 0xf, 0xc3, 0xf0, 0xf,
    0xff, 0xf0, 0x3, 0xff, 0xc0, 0x1, 0xff, 0x80,
    0x0, 0x10, 0x0,

    /* U+00D4 "Ô" */
    0x0, 0x3c, 0x0, 0x0, 0x7e, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xff, 0x0, 0x1, 0xe7, 0x80, 0x3,
    0xc3, 0xc0, 0x3, 0xc3, 0xc0, 0x7, 0x81, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x0, 0x1, 0xff, 0x80, 0x7, 0xff, 0xe0, 0xf,
    0xff, 0xf0, 0x1f, 0x0, 0xf8, 0x1e, 0x0, 0x78,
    0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c, 0x78, 0x0,
    0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e,
    0x3c, 0x0, 0x3c, 0x3c, 0x0, 0x3c, 0x3e, 0x0,
    0x7c, 0x1f, 0x0, 0xf8, 0xf, 0xc3, 0xf0, 0xf,
    0xff, 0xf0, 0x3, 0xff, 0xc0, 0x1, 0xff, 0x80,
    0x0, 0x10, 0x0,

    /* U+00D5 "Õ" */
    0x0, 0x0, 0x30, 0x1, 0xe0, 0x30, 0x3, 0xf8,
    0x70, 0x7, 0xff, 0xe0, 0xe, 0x3f, 0xe0, 0xe,
    0x7, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x1, 0xff,
    0x80, 0x7, 0xff, 0xe0, 0xf, 0xff, 0xf0, 0x1f,
    0x0, 0xf8, 0x1e, 0x0, 0x78, 0x3c, 0x0, 0x3c,
    0x3c, 0x0, 0x3c, 0x78, 0x0, 0x1e, 0x78, 0x0,
    0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0x78, 0x0, 0x1e, 0x3c, 0x0, 0x3c,
    0x3c, 0x0, 0x3c, 0x3e, 0x0, 0x7c, 0x1f, 0x0,
    0xf8, 0xf, 0xc3, 0xf0, 0xf, 0xff, 0xf0, 0x3,
    0xff, 0xc0, 0x1, 0xff, 0x80, 0x0, 0x10, 0x0,

    /* U+00D6 "Ö" */
    0x3, 0xc3, 0xc0, 0x3, 0xc3, 0xc0, 0x3, 0xc3,
    0xc0, 0x3, 0xc3, 0xc0, 0x3, 0xc3, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0x0, 0x1, 0xff,
    0x80, 0x7, 0xff, 0xe0, 0xf, 0xff, 0xf0, 0x1f,
    0x0, 0xf8, 0x1e, 0x0, 0x78, 0x3c, 0x0, 0x3c,
    0x3c, 0x0, 0x3c, 0x78, 0x0, 0x1e, 0x78, 0x0,
    0x1e, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0,
    0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf,
    0xf0, 0x0, 0xf, 0xf0, 0x0, 0xf, 0xf0, 0x0,
    0xf, 0x78, 0x0, 0x1e, 0x78, 0x0, 0x1e, 0x78,
    0x0, 0x1e, 0x78, 0x0, 0x1e, 0x3c, 0x0, 0x3c,
    0x3c, 0x0, 0x3c, 0x3e, 0x0, 0x7c, 0x1f, 0x0,
    0xf8, 0xf, 0xc3, 0xf0, 0xf, 0xff, 0xf0, 0x3,
    0xff, 0xc0, 0x1, 0xff, 0x80, 0x0, 0x10, 0x0,

    /* U+00D7 "×" */
    0x20, 0x0, 0x47, 0x0, 0xe, 0xf8, 0x1, 0xf7,
    0xc0, 0x3e, 0x3e, 0x7, 0xc1, 0xf0, 0xf8, 0xf,
    0x9f, 0x0, 0x79, 0xe0, 0x3, 0xfc, 0x0, 0x1f,
    0x80, 0x0, 0xf0, 0x0, 0x1f, 0x80, 0x3, 0xfc,
    0x0, 0x7f, 0xe0, 0xf, 0x9f, 0x1, 0xf0, 0xf8,
    0x3e, 0x7, 0xc7, 0xc0, 0x3e, 0xf8, 0x1, 0xf7,
    0x0, 0xe, 0x20, 0x0, 0x40,

    /* U+00D8 "Ø" */
    0x0, 0x0, 0x0, 0x80, 0x1, 0x0, 0x70, 0xf,
    0xfe, 0x38, 0xf, 0xff, 0xcc, 0x7, 0xff, 0xff,
    0x3, 0xe0, 0x1f, 0x80, 0xf0, 0x3, 0xe0, 0x78,
    0x0, 0x78, 0x1e, 0x0, 0x3f, 0xf, 0x0, 0xf,
    0xc3, 0xc0, 0x7, 0xf0, 0xf0, 0x3, 0xfc, 0x3c,
    0x0, 0xef, 0x9e, 0x0, 0x7b, 0xe7, 0x80, 0x1c,
    0x79, 0xe0, 0xe, 0x1e, 0x78, 0x7, 0x87, 0x9e,
    0x1, 0xc1, 0xe7, 0x80, 0xf0, 0x79, 0xe0, 0x38,
    0x1e, 0x78, 0x1c, 0x7, 0x9e, 0xf, 0x1, 0xe7,
    0x83, 0x80, 0x79, 0xe1, 0xc0, 0x1e, 0x78, 0x70,
    0x7, 0x9e, 0x38, 0x1, 0xe7, 0x9e, 0x0, 0x79,
    0xe7, 0x0, 0x3c, 0x3f, 0x80, 0xf, 0xf, 0xe0,
    0x3, 0xc3, 0xf0, 0x0, 0xf0, 0xfc, 0x0, 0x38,
    0x1e, 0x0, 0x1e, 0x7, 0x80, 0x7, 0x1, 0xf0,
    0x3, 0xc0, 0xfe, 0x1, 0xe0, 0x37, 0xfb, 0xf0,
    0x1c, 0xff, 0xf8, 0xe, 0xf, 0xfc, 0x3, 0x0,
    0x20, 0x0, 0x40, 0x0, 0x0, 0x0,

    /* U+00D9 "Ù" */
    0x7, 0xc0, 0x0, 0x1e, 0x0, 0x0, 0x78, 0x0,
    0x1, 0xc0, 0x0, 0xf, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x1f, 0xe0, 0x0, 0xff,
    0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe,
    0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80, 0x3, 0xfc,
    0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0, 0x7, 0xf8,
    0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0, 0xf, 0xf0,
    0x0, 0x7f, 0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0,
    0x0, 0xff, 0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0,
    0x1, 0xfe, 0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80,
    0x3, 0xfc, 0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0,
    0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0,
    0xf, 0xf8, 0x0, 0xff, 0xc0, 0x7, 0xdf, 0x0,
    0x7c, 0xfc, 0x7, 0xe3, 0xff, 0xfe, 0xf, 0xff,
    0xe0, 0x1f, 0xfc, 0x0, 0xc, 0x0,

    /* U+00DA "Ú" */
    0x0, 0x1f, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0,
    0x0, 0x78, 0x0, 0x7, 0x80, 0x0, 0x78, 0x0,
    0x3, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x1f, 0xe0, 0x0, 0xff,
    0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe,
    0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80, 0x3, 0xfc,
    0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0, 0x7, 0xf8,
    0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0, 0xf, 0xf0,
    0x0, 0x7f, 0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0,
    0x0, 0xff, 0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0,
    0x1, 0xfe, 0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80,
    0x3, 0xfc, 0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0,
    0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0,
    0xf, 0xf8, 0x0, 0xff, 0xc0, 0x7, 0xdf, 0x0,
    0x7c, 0xfc, 0x7, 0xe3, 0xff, 0xfe, 0xf, 0xff,
    0xe0, 0x1f, 0xfc, 0x0, 0xc, 0x0,

    /* U+00DB "Û" */
    0x0, 0xf8, 0x0, 0xf, 0xe0, 0x0, 0x77, 0x0,
    0x7, 0xbc, 0x0, 0x38, 0xf0, 0x3, 0xc7, 0x80,
    0x3c, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x1f, 0xe0, 0x0, 0xff,
    0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe,
    0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80, 0x3, 0xfc,
    0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0, 0x7, 0xf8,
    0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0, 0xf, 0xf0,
    0x0, 0x7f, 0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0,
    0x0, 0xff, 0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0,
    0x1, 0xfe, 0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80,
    0x3, 0xfc, 0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0,
    0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0,
    0xf, 0xf8, 0x0, 0xff, 0xc0, 0x7, 0xdf, 0x0,
    0x7c, 0xfc, 0x7, 0xe3, 0xff, 0xfe, 0xf, 0xff,
    0xe0, 0x1f, 0xfc, 0x0, 0xc, 0x0,

    /* U+00DC "Ü" */
    0x7, 0x8f, 0x0, 0x3c, 0x78, 0x1, 0xe3, 0xc0,
    0xf, 0x1e, 0x0, 0x78, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0, 0x0, 0xff,
    0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe,
    0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80, 0x3, 0xfc,
    0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0, 0x7, 0xf8,
    0x0, 0x3f, 0xc0, 0x1, 0xfe, 0x0, 0xf, 0xf0,
    0x0, 0x7f, 0x80, 0x3, 0xfc, 0x0, 0x1f, 0xe0,
    0x0, 0xff, 0x0, 0x7, 0xf8, 0x0, 0x3f, 0xc0,
    0x1, 0xfe, 0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80,
    0x3, 0xfc, 0x0, 0x1f, 0xe0, 0x0, 0xff, 0x0,
    0x7, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xff, 0x0,
    0x1f, 0xf8, 0x0, 0xfb, 0xe0, 0xf, 0x9f, 0x80,
    0xfc, 0x7f, 0xff, 0xc1, 0xff, 0xfc, 0x3, 0xff,
    0x80, 0x1, 0x80, 0x0,

    /* U+00DD "Ý" */
    0x0, 0x7, 0xc0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0xe, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x7d, 0xe0, 0x0, 0x1e, 0x7c,
    0x0, 0xf, 0x8f, 0x0, 0x3, 0xc3, 0xe0, 0x1,
    0xf0, 0x78, 0x0, 0x78, 0x1f, 0x0, 0x3e, 0x3,
    0xc0, 0xf, 0x0, 0xf0, 0x3, 0xc0, 0x1e, 0x1,
    0xe0, 0x7, 0x80, 0x78, 0x0, 0xf0, 0x3c, 0x0,
    0x3c, 0xf, 0x0, 0x7, 0x87, 0x80, 0x1, 0xe1,
    0xe0, 0x0, 0x3c, 0xf0, 0x0, 0xf, 0x3c, 0x0,
    0x1, 0xff, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x1f,
    0xe0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x7, 0x80, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x7, 0x80, 0x0, 0x1, 0xe0,
    0x0,

    /* U+00DE "Þ" */
    0xf0, 0x0, 0x7, 0x80, 0x0, 0x3c, 0x0, 0x1,
    0xe0, 0x0, 0xf, 0x0, 0x0, 0x78, 0x0, 0x3,
    0xff, 0xf0, 0x1f, 0xff, 0xf0, 0xff, 0xff, 0xc7,
    0x80, 0x7f, 0x3c, 0x0, 0xfd, 0xe0, 0x3, 0xef,
    0x0, 0xf, 0xf8, 0x0, 0x3f, 0xc0, 0x1, 0xfe,
    0x0, 0xf, 0xf0, 0x0, 0x7f, 0x80, 0x3, 0xfc,
    0x0, 0x1f, 0xe0, 0x1, 0xff, 0x0, 0xf, 0x78,
    0x0, 0xfb, 0xc0, 0xf, 0xde, 0x1, 0xfc, 0xff,
    0xff, 0xc7, 0xff, 0xfc, 0x3f, 0xfe, 0x1, 0xe0,
    0x0, 0xf, 0x0, 0x0, 0x78, 0x0, 0x3, 0xc0,
    0x0, 0x1e, 0x0, 0x0, 0xf0, 0x0, 0x7, 0x80,
    0x0, 0x3c, 0x0, 0x1, 0xe0, 0x0, 0xf, 0x0,
    0x0, 0x0,

    /* U+00DF "ß" */
    0x0, 0x40, 0x1, 0xfe, 0x1, 0xff, 0xe0, 0xff,
    0xfc, 0x3c, 0x1f, 0x1e, 0x3, 0xc7, 0x0, 0x7b,
    0xc0, 0x1e, 0xf0, 0x7, 0xbc, 0x1, 0xef, 0x0,
    0x7b, 0xc0, 0x1e, 0xf0, 0x7, 0xbc, 0x3, 0xcf,
    0x0, 0xf3, 0xc0, 0xf8, 0xf0, 0xfc, 0x3c, 0x3f,
    0xf, 0xf, 0xe3, 0xc0, 0x3c, 0xf0, 0x7, 0xbc,
    0x1, 0xef, 0x0, 0x3b, 0xc0, 0xf, 0xf0, 0x3,
    0xfc, 0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0,
    0x3, 0xfc, 0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf,
    0xf0, 0x7, 0xbc, 0x1, 0xef, 0x18, 0xfb, 0xc7,
    0xfc, 0xf1, 0xfe, 0x3c, 0x3e, 0x0,

    /* U+00E0 "à" */
    0x7, 0xc0, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x7,
    0x80, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x3, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0x3c, 0x3f, 0xcf, 0x1f, 0xfb, 0xcf, 0x87, 0xf7,
    0xc0, 0xfd, 0xe0, 0x1f, 0x78, 0x7, 0xde, 0x1,
    0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc,
    0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3,
    0xfc, 0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0,
    0x3, 0xfc, 0x0, 0xff, 0x80, 0x3d, 0xe0, 0x1f,
    0x78, 0x7, 0xdf, 0x3, 0xf3, 0xc0, 0xfc, 0xfd,
    0xef, 0x1f, 0xfb, 0xc3, 0xf8, 0xf0, 0x10, 0x0,

    /* U+00E1 "á" */
    0x0, 0xe, 0x0, 0x7, 0x0, 0x3, 0x80, 0x1,
    0xe0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7c,
    0x3c, 0x3f, 0xcf, 0x1f, 0xfb, 0xcf, 0x87, 0xf7,
    0xc0, 0xfd, 0xe0, 0x1f, 0x78, 0x7, 0xde, 0x1,
    0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc,
    0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3,
    0xfc, 0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0,
    0x3, 0xfc, 0x0, 0xff, 0x80, 0x3d, 0xe0, 0x1f,
    0x78, 0x7, 0xdf, 0x3, 0xf3, 0xc0, 0xfc, 0xfd,
    0xef, 0x1f, 0xfb, 0xc3, 0xf8, 0xf0, 0x10, 0x0,

    /* U+00E2 "â" */
    0x1, 0xe0, 0x0, 0x7e, 0x0, 0xf, 0xe0, 0x3,
    0xde, 0x0, 0xf1, 0xc0, 0x1c, 0x3c, 0x7, 0x83,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xc0, 0x7, 0xfe, 0x1, 0xff, 0xe0, 0x78,
    0x3c, 0xe, 0x3, 0xc3, 0xc0, 0x78, 0x78, 0xf,
    0xf, 0x0, 0xe0, 0x0, 0x1c, 0x0, 0x7, 0x80,
    0x0, 0xf0, 0x0, 0x7e, 0x0, 0x3f, 0xc0, 0x3f,
    0x78, 0x1f, 0x8f, 0x7, 0xc1, 0xe1, 0xf0, 0x3c,
    0x3c, 0x7, 0x8f, 0x0, 0xf1, 0xe0, 0x1e, 0x3c,
    0x3, 0xc7, 0x80, 0x78, 0xf0, 0xf, 0x1e, 0x3,
    0xe1, 0xe0, 0xfc, 0x3f, 0xfb, 0xf3, 0xfe, 0x3e,
    0x3f, 0x87, 0xc0, 0x80, 0x0,

    /* U+00E3 "ã" */
    0xf, 0x1, 0xc3, 0xf8, 0x70, 0xff, 0xfe, 0x1c,
    0xff, 0x87, 0x3, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0,
    0x3f, 0xf0, 0xf, 0xff, 0x3, 0xc1, 0xe0, 0x70,
    0x1e, 0x1e, 0x3, 0xc3, 0xc0, 0x78, 0x78, 0x7,
    0x0, 0x0, 0xe0, 0x0, 0x3c, 0x0, 0x7, 0x80,
    0x3, 0xf0, 0x1, 0xfe, 0x1, 0xfb, 0xc0, 0xfc,
    0x78, 0x3e, 0xf, 0xf, 0x81, 0xe1, 0xe0, 0x3c,
    0x78, 0x7, 0x8f, 0x0, 0xf1, 0xe0, 0x1e, 0x3c,
    0x3, 0xc7, 0x80, 0x78, 0xf0, 0x1f, 0xf, 0x7,
    0xe1, 0xff, 0xdf, 0x9f, 0xf1, 0xf1, 0xfc, 0x3e,
    0x4, 0x0, 0x0,

    /* U+00E4 "ä" */
    0xf, 0x1e, 0x1, 0xe3, 0xc0, 0x3c, 0x78, 0x7,
    0x8f, 0x0, 0xf1, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7e, 0x0,
    0x3f, 0xf0, 0xf, 0xff, 0x3, 0xc1, 0xe0, 0x70,
    0x1e, 0x1e, 0x3, 0xc3, 0xc0, 0x78, 0x78, 0x7,
    0x0, 0x0, 0xe0, 0x0, 0x3c, 0x0, 0x7, 0x80,
    0x3, 0xf0, 0x1, 0xfe, 0x1, 0xfb, 0xc0, 0xfc,
    0x78, 0x3e, 0xf, 0xf, 0x81, 0xe1, 0xe0, 0x3c,
    0x78, 0x7, 0x8f, 0x0, 0xf1, 0xe0, 0x1e, 0x3c,
    0x3, 0xc7, 0x80, 0x78, 0xf8, 0x1f, 0xf, 0x3,
    0xe1, 0xff, 0xdf, 0x9f, 0xf1, 0xf1, 0xfc, 0x3e,
    0x0, 0x0, 0x0,

    /* U+00E5 "å" */
    0x3, 0xe0, 0x0, 0xfe, 0x0, 0x30, 0x60, 0x6,
    0xc, 0x0, 0xc1, 0xc0, 0x18, 0x30, 0x3, 0x6,
    0x0, 0x3f, 0xc0, 0x3, 0xf0, 0x0, 0x18, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0x0, 0x1f,
    0xf8, 0x7, 0xff, 0x81, 0xe0, 0xf0, 0x38, 0xf,
    0xf, 0x1, 0xe1, 0xe0, 0x3c, 0x3c, 0x3, 0x80,
    0x0, 0x70, 0x0, 0x1e, 0x0, 0x3, 0xc0, 0x1,
    0xf8, 0x0, 0xff, 0x0, 0xfd, 0xe0, 0x7e, 0x3c,
    0x1f, 0x7, 0x87, 0xc0, 0xf0, 0xf0, 0x1e, 0x3c,
    0x3, 0xc7, 0x80, 0x78, 0xf0, 0xf, 0x1e, 0x1,
    0xe3, 0xc0, 0x3c, 0x78, 0xf, 0x87, 0x83, 0xf0,
    0xff, 0xef, 0xcf, 0xf8, 0xf8, 0xfe, 0x1f, 0x2,
    0x0, 0x0,

    /* U+00E6 "æ" */
    0x3, 0xf0, 0x1f, 0x0, 0x7f, 0xe3, 0xfc, 0x7,
    0xff, 0xff, 0xf0, 0x7c, 0x1f, 0xe3, 0xc3, 0xc0,
    0x7e, 0xe, 0x1c, 0x1, 0xe0, 0x79, 0xe0, 0xf,
    0x3, 0xcf, 0x0, 0x70, 0xe, 0x0, 0x3, 0x80,
    0x78, 0x0, 0x1c, 0x3, 0xc0, 0x1, 0xe0, 0x1e,
    0x0, 0x3f, 0x0, 0xf0, 0x7, 0xff, 0xff, 0x81,
    0xff, 0xff, 0xfc, 0x3f, 0x9f, 0xff, 0xe7, 0xf0,
    0xf0, 0x0, 0x7e, 0x7, 0x80, 0x3, 0xc0, 0x3c,
    0x0, 0x3e, 0x1, 0xe0, 0x1, 0xe0, 0xf, 0x0,
    0xff, 0x0, 0x78, 0x7, 0xf8, 0x3, 0xc0, 0x3f,
    0xc0, 0x1f, 0x1, 0xfe, 0x1, 0xf8, 0x1f, 0xf8,
    0x1f, 0xc0, 0xf3, 0xfb, 0xe7, 0xbf, 0x8f, 0xfe,
    0x3f, 0xf8, 0x3f, 0xe0, 0x7f, 0x80, 0x20, 0x0,
    0x40, 0x0,

    /* U+00E7 "ç" */
    0x3, 0xf8, 0x7, 0xfe, 0x7, 0xff, 0x87, 0xc3,
    0xe3, 0xc0, 0xf3, 0xc0, 0x3d, 0xe0, 0x1e, 0xf0,
    0xf, 0xf0, 0x7, 0xf8, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0xf, 0x0, 0x7, 0x80, 0x3, 0xc0, 0x1,
    0xe0, 0x0, 0xf0, 0x0, 0x78, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xf7, 0x80, 0x7b, 0xc0, 0x7d, 0xe0,
    0x3c, 0x78, 0x3e, 0x1f, 0x7e, 0x7, 0xff, 0x1,
    0xfe, 0x0, 0x18, 0x0, 0x3e, 0x0, 0x1f, 0xc0,
    0x0, 0xf0, 0x0, 0x70, 0xf, 0xf8, 0x3, 0xf0,
    0x0,

    /* U+00E8 "è" */
    0x3f, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0xf8,
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0x80, 0x0,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x1,
    0xff, 0x1, 0xff, 0xc1, 0xf0, 0xf0, 0xf0, 0x3c,
    0xf0, 0x1e, 0x78, 0xf, 0x3c, 0x3, 0xbe, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x3c,
    0x0, 0x1e, 0x0, 0xf, 0x0, 0x7, 0x80, 0x3d,
    0xc0, 0x1e, 0xf0, 0xf, 0x78, 0x7, 0xbc, 0x7,
    0x8f, 0x7, 0xc3, 0xff, 0xc1, 0xff, 0xe0, 0x3f,
    0xc0, 0x3, 0x0,

    /* U+00E9 "é" */
    0x0, 0x3e, 0x0, 0x3e, 0x0, 0x1e, 0x0, 0x1f,
    0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0x7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x1,
    0xff, 0x1, 0xff, 0xc1, 0xf0, 0xf0, 0xf0, 0x3c,
    0xf0, 0x1e, 0x78, 0xf, 0x3c, 0x3, 0xbe, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x3c,
    0x0, 0x1e, 0x0, 0xf, 0x0, 0x7, 0x80, 0x3d,
    0xc0, 0x1e, 0xf0, 0xf, 0x78, 0x7, 0xbc, 0x7,
    0x8f, 0x7, 0xc3, 0xff, 0xc1, 0xff, 0xe0, 0x3f,
    0xc0, 0x3, 0x0,

    /* U+00EA "ê" */
    0x1, 0xe0, 0x1, 0xf8, 0x1, 0xfc, 0x0, 0xef,
    0x0, 0xf3, 0xc0, 0xf0, 0xf0, 0xf0, 0x78, 0x78,
    0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x1,
    0xff, 0x1, 0xff, 0xc1, 0xf0, 0xf0, 0xf0, 0x3c,
    0xf0, 0x1e, 0x78, 0xf, 0x3c, 0x3, 0xbe, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x3c,
    0x0, 0x1e, 0x0, 0xf, 0x0, 0x7, 0x80, 0x3d,
    0xc0, 0x1e, 0xf0, 0xf, 0x78, 0x7, 0xbc, 0x7,
    0x8f, 0x7, 0xc3, 0xff, 0xc1, 0xff, 0xe0, 0x3f,
    0xc0, 0x3, 0x0,

    /* U+00EB "ë" */
    0x1e, 0x3c, 0xf, 0x1e, 0x7, 0x8f, 0x3, 0xc7,
    0x81, 0xe3, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xf8, 0x3, 0xfe, 0x3,
    0xff, 0x83, 0xe1, 0xe1, 0xe0, 0x79, 0xe0, 0x3c,
    0xf0, 0x1e, 0x78, 0x7, 0x7c, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x78, 0x0, 0x3c,
    0x0, 0x1e, 0x0, 0xf, 0x0, 0x7b, 0x80, 0x3d,
    0xe0, 0x1e, 0xf0, 0xf, 0x78, 0xf, 0x1e, 0xf,
    0x87, 0xff, 0x83, 0xff, 0xc0, 0x7f, 0x80, 0x6,
    0x0,

    /* U+00EC "ì" */
    0xf8, 0x3e, 0xf, 0x3, 0xc1, 0xe0, 0x78, 0x1e,
    0x7, 0x0, 0x0, 0x0, 0x1, 0xe0, 0xf0, 0x78,
    0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1, 0xe0, 0xf0,
    0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1, 0xe0,
    0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83, 0xc1,
    0xe0, 0xf0, 0x78,

    /* U+00ED "í" */
    0xf, 0x8f, 0x87, 0xc7, 0xc3, 0xc3, 0xc3, 0xc1,
    0xc0, 0x0, 0x0, 0x0, 0xf, 0x7, 0x83, 0xc1,
    0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7, 0x83,
    0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7,
    0x83, 0xc1, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf,
    0x7, 0x83, 0xc0,

    /* U+00EE "î" */
    0x7, 0x80, 0x3f, 0x0, 0xfe, 0x7, 0xb8, 0x3c,
    0xf0, 0xe1, 0xe7, 0x83, 0xbc, 0xf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x1e,
    0x0, 0x78, 0x1, 0xe0, 0x7, 0x80, 0x1e, 0x0,
    0x78, 0x1, 0xe0, 0x7, 0x80, 0x1e, 0x0, 0x78,
    0x1, 0xe0, 0x7, 0x80, 0x1e, 0x0, 0x78, 0x1,
    0xe0, 0x7, 0x80, 0x1e, 0x0, 0x78, 0x1, 0xe0,
    0x7, 0x80, 0x1e, 0x0, 0x78, 0x1, 0xe0, 0x7,
    0x80, 0x1e, 0x0,

    /* U+00EF "ï" */
    0xf1, 0xfe, 0x3f, 0xc7, 0xf8, 0xff, 0x1e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78, 0xf,
    0x1, 0xe0, 0x3c, 0x7, 0x80, 0xf0, 0x1e, 0x3,
    0xc0, 0x78, 0xf, 0x1, 0xe0, 0x3c, 0x7, 0x80,
    0xf0, 0x1e, 0x3, 0xc0, 0x78, 0xf, 0x1, 0xe0,
    0x3c, 0x7, 0x80, 0xf0, 0x1e, 0x3, 0xc0, 0x78,
    0xf, 0x1, 0xe0,

    /* U+00F0 "ð" */
    0x4, 0x0, 0x1, 0xc2, 0x0, 0x7c, 0xe0, 0x7,
    0xf8, 0x0, 0x7e, 0x0, 0x7, 0x80, 0x3, 0xf8,
    0x0, 0xe7, 0x80, 0x18, 0x78, 0x0, 0x7, 0x80,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xe0, 0x7,
    0xfe, 0x3, 0xff, 0xc0, 0xff, 0xfc, 0x3f, 0xf,
    0x87, 0x80, 0xf9, 0xf0, 0x1f, 0x3c, 0x1, 0xe7,
    0x80, 0x3d, 0xf0, 0x7, 0xfc, 0x0, 0x7f, 0x80,
    0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x1f, 0xe0, 0x3, 0xfc,
    0x0, 0x7f, 0x80, 0xf, 0xf0, 0x1, 0xcf, 0x0,
    0x79, 0xe0, 0xf, 0x3c, 0x1, 0xe3, 0xc0, 0x78,
    0x7c, 0x1f, 0x7, 0xff, 0xc0, 0x7f, 0xf0, 0x7,
    0xfc, 0x0, 0x8, 0x0,

    /* U+00F1 "ñ" */
    0xf, 0x3, 0x9f, 0xe3, 0x9f, 0xff, 0xce, 0x3f,
    0xc6, 0x7, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7e, 0x3c, 0xff, 0x9e,
    0xff, 0xef, 0xe1, 0xf7, 0xe0, 0x7f, 0xe0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f,
    0xc0, 0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3,
    0xfc, 0x1, 0xfe, 0x0, 0xff, 0x0, 0x78,

    /* U+00F2 "ò" */
    0x1f, 0x80, 0x1, 0xf0, 0x0, 0x1f, 0x0, 0x1,
    0xe0, 0x0, 0x1e, 0x0, 0x1, 0xe0, 0x0, 0x1c,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xe0, 0x7, 0xff, 0x1, 0xff, 0xf0, 0x7e,
    0x1f, 0xf, 0x1, 0xe3, 0xe0, 0x3e, 0x78, 0x3,
    0xcf, 0x0, 0x7b, 0xe0, 0xf, 0xf8, 0x0, 0xff,
    0x0, 0x1f, 0xe0, 0x3, 0xfc, 0x0, 0x7f, 0x80,
    0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x1f, 0xe0, 0x3, 0x9e,
    0x0, 0xf3, 0xc0, 0x1e, 0x78, 0x3, 0xc7, 0x80,
    0xf0, 0xf8, 0x3e, 0xf, 0xff, 0x80, 0xff, 0xe0,
    0xf, 0xf8, 0x0, 0x10, 0x0,

    /* U+00F3 "ó" */
    0x0, 0x1f, 0x0, 0x7, 0xc0, 0x1, 0xf0, 0x0,
    0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0, 0x0, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xe0, 0x7, 0xff, 0x1, 0xff, 0xf0, 0x7e,
    0x1f, 0xf, 0x1, 0xe3, 0xe0, 0x3e, 0x78, 0x3,
    0xcf, 0x0, 0x7b, 0xe0, 0xf, 0xf8, 0x0, 0xff,
    0x0, 0x1f, 0xe0, 0x3, 0xfc, 0x0, 0x7f, 0x80,
    0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x1f, 0xe0, 0x3, 0x9e,
    0x0, 0xf3, 0xc0, 0x1e, 0x78, 0x3, 0xc7, 0x80,
    0xf0, 0xf8, 0x3e, 0xf, 0xff, 0x80, 0xff, 0xe0,
    0xf, 0xf8, 0x0, 0x10, 0x0,

    /* U+00F4 "ô" */
    0x1, 0xf0, 0x0, 0x3e, 0x0, 0xf, 0xe0, 0x3,
    0xde, 0x0, 0x71, 0xe0, 0x1e, 0x1c, 0x7, 0x83,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xe0, 0x7, 0xff, 0x1, 0xff, 0xf0, 0x7e,
    0x1f, 0xf, 0x1, 0xe3, 0xe0, 0x3e, 0x78, 0x3,
    0xcf, 0x0, 0x7b, 0xe0, 0xf, 0xf8, 0x0, 0xff,
    0x0, 0x1f, 0xe0, 0x3, 0xfc, 0x0, 0x7f, 0x80,
    0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x1f, 0xe0, 0x3, 0x9e,
    0x0, 0xf3, 0xc0, 0x1e, 0x78, 0x3, 0xc7, 0x80,
    0xf0, 0xf8, 0x3e, 0xf, 0xff, 0x80, 0xff, 0xe0,
    0xf, 0xf8, 0x0, 0x10, 0x0,

    /* U+00F5 "õ" */
    0x7, 0x81, 0xc3, 0xfc, 0x70, 0x7f, 0xfe, 0x1c,
    0x7f, 0x83, 0x3, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0,
    0x3f, 0xf8, 0xf, 0xff, 0x83, 0xf0, 0xf8, 0x78,
    0xf, 0x1f, 0x1, 0xf3, 0xc0, 0x1e, 0x78, 0x3,
    0xdf, 0x0, 0x7f, 0xc0, 0x7, 0xf8, 0x0, 0xff,
    0x0, 0x1f, 0xe0, 0x3, 0xfc, 0x0, 0x7f, 0x80,
    0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x1c, 0xf0, 0x7, 0x9e,
    0x0, 0xf3, 0xc0, 0x1e, 0x3c, 0x7, 0x87, 0xc1,
    0xf0, 0x7f, 0xfc, 0x7, 0xff, 0x0, 0x7f, 0xc0,
    0x0, 0x80, 0x0,

    /* U+00F6 "ö" */
    0xf, 0x1e, 0x1, 0xe3, 0xc0, 0x3c, 0x78, 0x7,
    0x8f, 0x0, 0xf1, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x0,
    0x3f, 0xf8, 0xf, 0xff, 0x83, 0xf0, 0xf8, 0x78,
    0xf, 0x1f, 0x1, 0xf3, 0xc0, 0x1e, 0x78, 0x3,
    0xdf, 0x0, 0x7f, 0xc0, 0x7, 0xf8, 0x0, 0xff,
    0x0, 0x1f, 0xe0, 0x3, 0xfc, 0x0, 0x7f, 0x80,
    0xf, 0xf0, 0x1, 0xfe, 0x0, 0x3f, 0xc0, 0x7,
    0xf8, 0x0, 0xff, 0x0, 0x1c, 0xf0, 0x7, 0x9e,
    0x0, 0xf3, 0xc0, 0x1e, 0x3c, 0x7, 0x87, 0xc1,
    0xf0, 0x7f, 0xfc, 0x7, 0xff, 0x0, 0x7f, 0xc0,
    0x0, 0x80, 0x0,

    /* U+00F7 "÷" */
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,

    /* U+00F8 "ø" */
    0x0, 0x0, 0x0, 0xf, 0xe0, 0xc1, 0xff, 0xce,
    0x1f, 0xff, 0x61, 0xf8, 0x7e, 0xf, 0x1, 0xe0,
    0xf8, 0x7, 0x87, 0x80, 0x3c, 0x3c, 0x3, 0xe3,
    0xe0, 0x1f, 0x9e, 0x1, 0xbc, 0xf0, 0x19, 0xe7,
    0x80, 0xcf, 0x3c, 0xc, 0x79, 0xe0, 0xc3, 0xcf,
    0x6, 0x1e, 0x78, 0x60, 0xf3, 0xc6, 0x7, 0x9e,
    0x30, 0x3c, 0xf3, 0x1, 0xe3, 0xf0, 0xf, 0x1f,
    0x80, 0xf0, 0xf8, 0x7, 0x87, 0x80, 0x3c, 0x1e,
    0x3, 0xc0, 0xf8, 0x3e, 0xf, 0xff, 0xe0, 0x7f,
    0xfe, 0x6, 0x3f, 0xe0, 0x60, 0x18, 0x1, 0x0,
    0x0, 0x0,

    /* U+00F9 "ù" */
    0x3e, 0x0, 0xf, 0x80, 0x3, 0xe0, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0x80, 0x0,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f,
    0xc0, 0x1f, 0xe0, 0xf, 0xf0, 0xf, 0xf8, 0x7,
    0xfe, 0x7, 0xef, 0xfe, 0xf7, 0xfe, 0x79, 0xfe,
    0x3c, 0x8, 0x0,

    /* U+00FA "ú" */
    0x0, 0x3e, 0x0, 0x3e, 0x0, 0x3e, 0x0, 0x1e,
    0x0, 0x1e, 0x0, 0xe, 0x0, 0xf, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f,
    0xc0, 0x1f, 0xe0, 0xf, 0xf0, 0xf, 0xf8, 0x7,
    0xfe, 0x7, 0xef, 0xfe, 0xf7, 0xfe, 0x79, 0xfe,
    0x3c, 0x8, 0x0,

    /* U+00FB "û" */
    0x3, 0xe0, 0x1, 0xf0, 0x1, 0xfc, 0x1, 0xef,
    0x0, 0xe3, 0xc0, 0xf1, 0xe0, 0xf0, 0x78, 0x70,
    0x1e, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f,
    0xc0, 0x1f, 0xe0, 0xf, 0xf0, 0xf, 0xf8, 0x7,
    0xfe, 0x7, 0xef, 0xfe, 0xf7, 0xfe, 0x79, 0xfe,
    0x3c, 0x8, 0x0,

    /* U+00FC "ü" */
    0x1e, 0x3c, 0xf, 0x1e, 0x7, 0x8f, 0x3, 0xc7,
    0x81, 0xe3, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3c, 0x1, 0xfe,
    0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0, 0x1f,
    0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc, 0x1,
    0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xe0, 0xf, 0xf0, 0x7, 0xf8, 0x3, 0xfc,
    0x1, 0xfe, 0x0, 0xff, 0x0, 0x7f, 0x80, 0x3f,
    0xc0, 0x1f, 0xe0, 0x1f, 0xf0, 0xf, 0xfc, 0xf,
    0xdf, 0xfd, 0xef, 0xfc, 0xf3, 0xfc, 0x78, 0x10,
    0x0,

    /* U+00FD "ý" */
    0x0, 0x3f, 0x0, 0x3, 0xe0, 0x0, 0x7c, 0x0,
    0x7, 0x80, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x1,
    0xc0, 0x0, 0x38, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0xff, 0x0, 0xf, 0x78, 0x0,
    0xe7, 0x80, 0x1e, 0x78, 0x1, 0xe3, 0x80, 0x1c,
    0x3c, 0x3, 0xc3, 0xc0, 0x3c, 0x3c, 0x3, 0xc1,
    0xc0, 0x38, 0x1e, 0x7, 0x81, 0xe0, 0x78, 0xe,
    0x7, 0x0, 0xe0, 0x70, 0xf, 0xf, 0x0, 0xf0,
    0xe0, 0x7, 0xe, 0x0, 0x70, 0xe0, 0x7, 0x9e,
    0x0, 0x39, 0xc0, 0x3, 0x9c, 0x0, 0x3f, 0xc0,
    0x3, 0xf8, 0x0, 0x1f, 0x80, 0x1, 0xf8, 0x0,
    0x1f, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xe0, 0x0, 0xe, 0x0, 0x1, 0xc0, 0x0, 0x3c,
    0x0, 0x7f, 0x80, 0x7, 0xf0, 0x0, 0x7e, 0x0,
    0x0,

    /* U+00FE "þ" */
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x7e, 0xf, 0x3f,
    0xc3, 0xdf, 0xf8, 0xfe, 0x1f, 0x3f, 0x3, 0xcf,
    0x80, 0x7b, 0xe0, 0x1e, 0xf8, 0x7, 0xbc, 0x0,
    0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3, 0xfc,
    0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0, 0x3,
    0xfc, 0x0, 0xff, 0x0, 0x3f, 0xc0, 0xf, 0xf0,
    0x3, 0xfe, 0x1, 0xef, 0x80, 0x7b, 0xe0, 0x1e,
    0xfc, 0xf, 0xbf, 0x83, 0xcf, 0xfb, 0xf3, 0xdf,
    0xf8, 0xf3, 0xfc, 0x3c, 0x10, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x3, 0xc0, 0x0,

    /* U+00FF "ÿ" */
    0x7, 0x8f, 0x0, 0x78, 0xf0, 0x7, 0x8f, 0x0,
    0x78, 0xf0, 0x7, 0x8f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x0,
    0xf, 0x70, 0x0, 0xf7, 0x80, 0x1e, 0x78, 0x1,
    0xe7, 0x80, 0x1e, 0x38, 0x1, 0xc3, 0xc0, 0x3c,
    0x3c, 0x3, 0xc1, 0xc0, 0x38, 0x1c, 0x3, 0x81,
    0xe0, 0x78, 0x1e, 0x7, 0x80, 0xe0, 0x70, 0xe,
    0x7, 0x0, 0xf0, 0xf0, 0x7, 0xe, 0x0, 0x70,
    0xe0, 0x7, 0x9e, 0x0, 0x79, 0xc0, 0x3, 0x9c,
    0x0, 0x39, 0xc0, 0x3, 0xfc, 0x0, 0x1f, 0x80,
    0x1, 0xf8, 0x0, 0x1f, 0x80, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xe, 0x0, 0x0,
    0xe0, 0x0, 0x1c, 0x0, 0x3, 0xc0, 0x7, 0xf8,
    0x0, 0x7f, 0x0, 0x7, 0xe0, 0x0,

    /* U+2010 "‐" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+2013 "–" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff,

    /* U+2014 "—" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+2015 "―" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0,

    /* U+2016 "‖" */
    0xc0, 0xf0, 0x3c, 0xf, 0x3, 0xc0, 0xf0, 0x3c,
    0xf, 0x3, 0xc0, 0xf0, 0x3c, 0xf, 0x3, 0xc0,
    0xf0, 0x3c, 0xf, 0x3, 0xc0, 0xf0, 0x3c, 0xf,
    0x3, 0xc0, 0xf0, 0x3c, 0xf, 0x3, 0xc0, 0xf0,
    0x3c, 0xf, 0x3, 0xc0, 0xf0, 0x3c, 0xf, 0x3,
    0xc0, 0xf0, 0x3c, 0xf, 0x3, 0xc0, 0xf0, 0x3c,
    0xf, 0x3, 0xc0, 0xf0, 0x3c, 0xf, 0x3, 0xc0,
    0xc0,

    /* U+2018 "‘" */
    0xc, 0xf7, 0x9c, 0xe3, 0x8e, 0x3f, 0xff, 0xff,
    0xff, 0xfc,

    /* U+2019 "’" */
    0xff, 0xff, 0xff, 0xff, 0xf1, 0xc7, 0x1c, 0xe7,
    0xbc, 0xc0,

    /* U+201A "‚" */
    0xff, 0xff, 0xf3, 0x33, 0x7e, 0xc8,

    /* U+201C "“" */
    0x8, 0x8, 0xe0, 0x67, 0x83, 0x9c, 0x1c, 0xe0,
    0xe3, 0x3, 0x8c, 0xe, 0x3e, 0x3f, 0xf8, 0xff,
    0xe3, 0xff, 0x8f, 0xfe, 0x3f, 0xf8, 0xfc,

    /* U+201D "”" */
    0xf8, 0x7f, 0xe1, 0xff, 0x87, 0xfe, 0x1f, 0xf8,
    0x7f, 0xe1, 0xf1, 0x80, 0xc6, 0x3, 0x38, 0x1c,
    0xc0, 0x6f, 0x3, 0xb8, 0xc, 0xc0, 0x20,

    /* U+201E "„" */
    0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0, 0xf3,
    0x3, 0x30, 0x33, 0x3, 0x60, 0x6e, 0xe, 0xc0,
    0xc0, 0x8,

    /* U+2020 "†" */
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0xf0, 0x0, 0xf, 0x0,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0,
    0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0xf0, 0x0, 0xf, 0x0,

    /* U+2021 "‡" */
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0,
    0x0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0xf0, 0x0, 0xf, 0x0,

    /* U+2022 "•" */
    0x7, 0x80, 0x7f, 0x83, 0xff, 0x1f, 0xfe, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xdf, 0xfe, 0x7f, 0xf0, 0xff,
    0x80, 0xf8, 0x0,

    /* U+2025 "‥" */
    0x60, 0x0, 0x13, 0xc0, 0x1, 0xff, 0x80, 0x7,
    0xfe, 0x0, 0x1f, 0xf8, 0x0, 0x7d, 0xc0, 0x0,
    0xe0,

    /* U+2026 "…" */
    0x78, 0x0, 0x78, 0x0, 0x7b, 0xf0, 0x3, 0xf0,
    0x3, 0xff, 0xc0, 0xf, 0xc0, 0xf, 0xff, 0x0,
    0x3f, 0x0, 0x3f, 0xfc, 0x0, 0xfc, 0x0, 0xfd,
    0xe0, 0x1, 0xe0, 0x1, 0xe0,

    /* U+2030 "‰" */
    0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x7, 0xc0,
    0x1, 0xc0, 0x0, 0x0, 0xf, 0xf0, 0x1, 0xc0,
    0x0, 0x0, 0xf, 0xfc, 0x0, 0xe0, 0x0, 0x0,
    0x7, 0x9e, 0x0, 0x60, 0x0, 0x0, 0x7, 0x87,
    0x80, 0x70, 0x0, 0x0, 0x3, 0x81, 0xc0, 0x30,
    0x0, 0x0, 0x1, 0xc0, 0xe0, 0x38, 0x0, 0x0,
    0x0, 0xe0, 0x70, 0x18, 0x0, 0x0, 0x0, 0x70,
    0x38, 0x1c, 0x0, 0x0, 0x0, 0x38, 0x1c, 0xe,
    0x0, 0x0, 0x0, 0x1c, 0xe, 0xe, 0x0, 0x0,
    0x0, 0xe, 0x7, 0x7, 0x0, 0x0, 0x0, 0x7,
    0x87, 0x83, 0x0, 0x0, 0x0, 0x1, 0xc3, 0x83,
    0x80, 0x0, 0x0, 0x0, 0xff, 0xc1, 0x80, 0x0,
    0x0, 0x0, 0x3f, 0xc1, 0xc0, 0x0, 0x0, 0x0,
    0xf, 0xc0, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x3e,
    0x0, 0x1f, 0x0, 0x0, 0x70, 0x7f, 0xc0, 0x3f,
    0xe0, 0x0, 0x38, 0x7f, 0xf0, 0x3f, 0xf8, 0x0,
    0x18, 0x3c, 0x78, 0x1e, 0x3c, 0x0, 0x1c, 0x3c,
    0x1e, 0xe, 0xf, 0x0, 0xc, 0x1e, 0xf, 0xf,
    0x7, 0x80, 0xe, 0xe, 0x3, 0x87, 0x1, 0xc0,
    0x6, 0x7, 0x1, 0xc3, 0x80, 0xe0, 0x7, 0x3,
    0x80, 0xe1, 0xc0, 0x70, 0x3, 0x1, 0xc0, 0x70,
    0xe0, 0x38, 0x3, 0x80, 0xe0, 0x38, 0x70, 0x1c,
    0x1, 0x80, 0x70, 0x1c, 0x38, 0xe, 0x0, 0xc0,
    0x38, 0xe, 0x1c, 0x7, 0x0, 0xe0, 0xe, 0xe,
    0x7, 0x7, 0x0, 0x60, 0x7, 0x8f, 0x3, 0xc7,
    0x80, 0x70, 0x3, 0xff, 0x0, 0xff, 0x80, 0x30,
    0x0, 0xff, 0x80, 0x7f, 0xc0, 0x38, 0x0, 0x1f,
    0x0, 0xf, 0x80,

    /* U+2032 "′" */
    0xc, 0x3c, 0x79, 0xf3, 0xc7, 0x8e, 0x1c, 0x70,
    0xe1, 0x83, 0x4, 0x8, 0x0,

    /* U+2033 "″" */
    0x18, 0x38, 0xf0, 0xf3, 0xc7, 0xcf, 0x1e, 0x78,
    0x79, 0xe1, 0xc7, 0x7, 0x1c, 0x38, 0x60, 0xe3,
    0x83, 0xc, 0xc, 0x30, 0x20, 0x81, 0x82, 0x6,
    0x0,

    /* U+2035 "‵" */
    0x60, 0x3c, 0x7, 0x1, 0xe0, 0x38, 0xe, 0x1,
    0xc0, 0x70, 0xc, 0x1, 0x80, 0x60, 0xc, 0x3,
    0x0, 0x40, 0x18, 0x2, 0x0, 0xc0, 0x10, 0x4,

    /* U+2039 "‹" */
    0x1, 0x3, 0x7, 0xf, 0x1e, 0x3c, 0x78, 0xf0,
    0xe0, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf, 0x7,
    0x3, 0x1,

    /* U+203A "›" */
    0x80, 0xc0, 0xe0, 0xf0, 0x78, 0x3c, 0x1e, 0xf,
    0x7, 0xf, 0x1e, 0x3c, 0x78, 0xf0, 0xe0, 0xc0,
    0x80, 0x0,

    /* U+203B "※" */
    0x0, 0x0, 0xc0, 0x0, 0x98, 0x0, 0xfc, 0x0,
    0x67, 0x0, 0x3f, 0x0, 0x38, 0xe0, 0x1f, 0xe0,
    0x1c, 0x1c, 0x3, 0xf8, 0xe, 0x3, 0x80, 0xfc,
    0x7, 0x0, 0x70, 0x3f, 0x3, 0x80, 0xe, 0x0,
    0x1, 0xc0, 0x1, 0xc0, 0x0, 0xe0, 0x0, 0x38,
    0x0, 0x70, 0x0, 0x7, 0x0, 0x38, 0x0, 0x0,
    0xe0, 0x1c, 0x0, 0x0, 0x1c, 0xe, 0x0, 0x0,
    0x3, 0x87, 0x0, 0x3, 0xe0, 0x73, 0x81, 0xf1,
    0xfc, 0xf, 0xc0, 0xfe, 0x7f, 0x1, 0xe0, 0x3f,
    0x9f, 0xc0, 0x38, 0xf, 0xe7, 0xf0, 0x1f, 0x3,
    0xf9, 0xf8, 0xc, 0xe0, 0xfc, 0x3c, 0x6, 0x1c,
    0x1e, 0x0, 0x3, 0x3, 0x80, 0x0, 0x1, 0x80,
    0x70, 0x0, 0x0, 0xc0, 0xe, 0x0, 0x0, 0x60,
    0x1, 0x80, 0x0, 0x30, 0x0, 0x30, 0x0, 0x18,
    0x0, 0x6, 0x0, 0xc, 0x7, 0x80, 0xc0, 0x6,
    0x3, 0xf0, 0x18, 0x3, 0x0, 0xfe, 0x3, 0x1,
    0xc0, 0x7f, 0x80, 0x60, 0xe0, 0xf, 0xc0, 0xc,
    0x70, 0x3, 0xf0, 0x1, 0x98, 0x0, 0x78, 0x0,
    0x20, 0x0, 0x0, 0x0, 0x0,

    /* U+3000 "　" */
    0x0,

    /* U+3001 "、" */
    0x40, 0x1c, 0x3, 0xc0, 0x3c, 0x3, 0xc0, 0x3c,
    0x3, 0xc0, 0x3c, 0x3, 0xc0, 0x38, 0x2, 0x0,

    /* U+3002 "。" */
    0x7, 0xe0, 0x1f, 0xf8, 0x38, 0x1c, 0x70, 0xe,
    0x60, 0x6, 0x60, 0x6, 0xc0, 0x3, 0xc0, 0x3,
    0xc0, 0x3, 0x60, 0x6, 0x60, 0x6, 0x30, 0xc,
    0x3c, 0x3c, 0xf, 0xf0, 0x3, 0xc0,

    /* U+3003 "〃" */
    0x3, 0x83, 0xc0, 0xe0, 0xf0, 0x78, 0x38, 0x1c,
    0x1e, 0x7, 0x7, 0x3, 0x81, 0xc0, 0xe0, 0xe0,
    0x30, 0x38, 0x1c, 0xc, 0x6, 0x7, 0x1, 0x81,
    0x80, 0xc0, 0x60, 0x30, 0x30, 0x8, 0x8, 0x6,
    0x2, 0x1, 0x1, 0x0, 0x40, 0x40, 0x20, 0x0,
    0x0,

    /* U+3005 "々" */
    0x0, 0x20, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0xe, 0x0, 0x18, 0x1, 0xff, 0xff, 0xc0, 0x3f,
    0xff, 0xfe, 0x7, 0x80, 0x1, 0xf0, 0x70, 0x0,
    0x1f, 0xe, 0x0, 0x3, 0xc1, 0xc0, 0x0, 0x38,
    0x30, 0x0, 0x7, 0x6, 0x0, 0x0, 0xe0, 0xc0,
    0x0, 0xe, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,
    0x38, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x70,
    0x0, 0x8, 0xe, 0x0, 0x0, 0x61, 0xc0, 0x0,
    0x3, 0xb8, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xe0, 0x0,

    /* U+3006 "〆" */
    0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x7c, 0x0, 0x70, 0x7, 0x80,
    0x3f, 0xc0, 0xf0, 0x7, 0xfe, 0x1e, 0x0, 0xf3,
    0xf3, 0xc0, 0x1c, 0x7, 0xfc, 0x3, 0x80, 0x3f,
    0x80, 0x30, 0x1, 0xf0, 0x3, 0x0, 0x1f, 0x0,
    0x60, 0x3, 0xf8, 0x6, 0x0, 0x7f, 0x80, 0x60,
    0xf, 0x7c, 0x6, 0x1, 0xf3, 0xc0, 0x40, 0x3e,
    0x38, 0xc, 0x7, 0xc1, 0x0, 0xc0, 0xf8, 0x0,
    0xc, 0x1f, 0x0, 0x0, 0xc3, 0xe0, 0x0, 0xc,
    0x7c, 0x0, 0x0, 0xcf, 0x80, 0x0, 0xd, 0xf0,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xe0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0,

    /* U+3007 "〇" */
    0x0, 0x1f, 0xe0, 0x0, 0x3, 0xff, 0xf0, 0x0,
    0x3f, 0x3, 0xf0, 0x1, 0xf0, 0x3, 0xe0, 0xf,
    0x80, 0x7, 0xc0, 0x3c, 0x0, 0xf, 0x81, 0xf0,
    0x0, 0x1e, 0xf, 0x80, 0x0, 0x7c, 0x3e, 0x0,
    0x0, 0xf0, 0xf0, 0x0, 0x3, 0xc7, 0xc0, 0x0,
    0xf, 0x9f, 0x0, 0x0, 0x1e, 0x7c, 0x0, 0x0,
    0x79, 0xf0, 0x0, 0x1, 0xef, 0x80, 0x0, 0x7,
    0xbe, 0x0, 0x0, 0x1f, 0xf8, 0x0, 0x0, 0x7f,
    0xe0, 0x0, 0x1, 0xff, 0x80, 0x0, 0x7, 0xfe,
    0x0, 0x0, 0x1f, 0xf8, 0x0, 0x0, 0x7f, 0xe0,
    0x0, 0x1, 0xff, 0x80, 0x0, 0x7, 0xfe, 0x0,
    0x0, 0x1f, 0xf8, 0x0, 0x0, 0x7f, 0xe0, 0x0,
    0x1, 0xff, 0x80, 0x0, 0x7, 0xfe, 0x0, 0x0,
    0x1f, 0xf8, 0x0, 0x0, 0x7f, 0xe0, 0x0, 0x1,
    0xff, 0x80, 0x0, 0x7, 0xfe, 0x0, 0x0, 0x1f,
    0xf8, 0x0, 0x0, 0x7b, 0xf0, 0x0, 0x1, 0xe7,
    0xc0, 0x0, 0x7, 0x9f, 0x0, 0x0, 0x1e, 0x7c,
    0x0, 0x0, 0xf9, 0xf8, 0x0, 0x3, 0xc3, 0xe0,
    0x0, 0x1f, 0xf, 0xc0, 0x0, 0x78, 0x1f, 0x80,
    0x3, 0xe0, 0x3e, 0x0, 0x1f, 0x0, 0x7e, 0x0,
    0xf8, 0x0, 0xfe, 0xf, 0xc0, 0x0, 0xff, 0xfc,
    0x0, 0x0, 0xff, 0xc0, 0x0,

    /* U+3008 "〈" */
    0x0, 0xc, 0x0, 0x3c, 0x0, 0x70, 0x1, 0xe0,
    0x3, 0x80, 0xf, 0x0, 0x1c, 0x0, 0x78, 0x0,
    0xe0, 0x3, 0xc0, 0x7, 0x0, 0x1e, 0x0, 0x38,
    0x0, 0xf0, 0x1, 0xc0, 0x7, 0x80, 0xe, 0x0,
    0x3c, 0x0, 0x70, 0x1, 0xe0, 0x3, 0x80, 0xf,
    0x0, 0x1c, 0x0, 0x38, 0x0, 0x70, 0x0, 0x70,
    0x0, 0xe0, 0x0, 0xe0, 0x1, 0xc0, 0x1, 0xc0,
    0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x7, 0x0,
    0xe, 0x0, 0xe, 0x0, 0x1e, 0x0, 0x1c, 0x0,
    0x3c, 0x0, 0x38, 0x0, 0x78, 0x0, 0x70, 0x0,
    0xf0, 0x0, 0xe0, 0x1, 0xe0, 0x1, 0x80,

    /* U+3009 "〉" */
    0x20, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0xc0, 0x3,
    0x80, 0x7, 0x80, 0x7, 0x0, 0xf, 0x0, 0xe,
    0x0, 0x1e, 0x0, 0x1c, 0x0, 0x3c, 0x0, 0x38,
    0x0, 0x78, 0x0, 0x70, 0x0, 0xf0, 0x0, 0xe0,
    0x1, 0xe0, 0x1, 0xc0, 0x3, 0xc0, 0x3, 0x80,
    0x7, 0x80, 0x7, 0x0, 0xf, 0x0, 0x1c, 0x0,
    0x70, 0x0, 0xe0, 0x3, 0x80, 0x7, 0x0, 0x1c,
    0x0, 0x38, 0x0, 0xe0, 0x1, 0xc0, 0x7, 0x0,
    0xe, 0x0, 0x38, 0x0, 0xf0, 0x1, 0xc0, 0x7,
    0x80, 0xe, 0x0, 0x3c, 0x0, 0x70, 0x1, 0xe0,
    0x3, 0x80, 0xf, 0x0, 0xc, 0x0, 0x0,

    /* U+300A "《" */
    0x0, 0x8, 0x30, 0x0, 0xe1, 0xc0, 0x7, 0x1e,
    0x0, 0x70, 0xe0, 0x3, 0x8f, 0x0, 0x38, 0x70,
    0x1, 0xc7, 0x80, 0x1c, 0x38, 0x0, 0xe3, 0xc0,
    0xe, 0x1c, 0x0, 0xf1, 0xe0, 0x7, 0xe, 0x0,
    0x78, 0xe0, 0x3, 0x87, 0x0, 0x3c, 0x70, 0x1,
    0xc3, 0x80, 0x1e, 0x38, 0x0, 0xe1, 0xc0, 0xf,
    0x1c, 0x0, 0x70, 0xe0, 0x7, 0x8e, 0x0, 0x38,
    0x70, 0x3, 0xc7, 0x0, 0x1e, 0x38, 0x0, 0x71,
    0xe0, 0x3, 0xc7, 0x0, 0xe, 0x3c, 0x0, 0x78,
    0xe0, 0x1, 0xc3, 0x80, 0xf, 0x1c, 0x0, 0x38,
    0x70, 0x1, 0xe3, 0x80, 0x7, 0xe, 0x0, 0x3c,
    0x70, 0x0, 0xe1, 0xc0, 0x7, 0x8e, 0x0, 0x1c,
    0x38, 0x0, 0xf1, 0xc0, 0x3, 0x87, 0x0, 0xe,
    0x38, 0x0, 0x70, 0xe0, 0x1, 0xc7, 0x0, 0xe,
    0x1c, 0x0, 0x38, 0xf0, 0x1, 0xc3, 0x80, 0x4,
    0x18,

    /* U+300B "》" */
    0x60, 0x80, 0x7, 0xe, 0x0, 0x3c, 0x70, 0x0,
    0xe1, 0xc0, 0x7, 0x8e, 0x0, 0x1c, 0x38, 0x0,
    0xf1, 0xc0, 0x3, 0x87, 0x0, 0xe, 0x38, 0x0,
    0x70, 0xe0, 0x1, 0xc7, 0x80, 0xe, 0x1c, 0x0,
    0x38, 0xf0, 0x1, 0xc3, 0x80, 0x7, 0x1e, 0x0,
    0x38, 0x70, 0x0, 0xe3, 0xc0, 0x7, 0xe, 0x0,
    0x1c, 0x78, 0x0, 0xe1, 0xc0, 0x3, 0x8f, 0x0,
    0x1c, 0x38, 0x0, 0x71, 0xe0, 0x3, 0x8f, 0x0,
    0x3c, 0x70, 0x1, 0xc7, 0x80, 0x1e, 0x38, 0x0,
    0xe3, 0xc0, 0xf, 0x1c, 0x0, 0x71, 0xe0, 0x7,
    0xe, 0x0, 0x38, 0xf0, 0x3, 0x87, 0x0, 0x1c,
    0x78, 0x1, 0xc3, 0x80, 0xe, 0x3c, 0x0, 0xe1,
    0xc0, 0x7, 0x1e, 0x0, 0x70, 0xe0, 0x3, 0x8e,
    0x0, 0x38, 0x70, 0x3, 0xc7, 0x0, 0x1c, 0x38,
    0x1, 0xe3, 0x80, 0xe, 0x1c, 0x0, 0x30, 0x40,
    0x0,

    /* U+300C "「" */
    0xff, 0xff, 0xff, 0xff, 0x80, 0x7, 0x0, 0xe,
    0x0, 0x1c, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0,
    0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0,
    0x1c, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x1,
    0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c,
    0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0,
    0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0,
    0x38, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3,
    0x80, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x38,
    0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80,
    0x7, 0x0, 0xe, 0x0, 0x1c, 0x0, 0x0,

    /* U+300D "」" */
    0x0, 0xe, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x70,
    0x0, 0xe0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0,
    0xe, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x70, 0x0,
    0xe0, 0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe,
    0x0, 0x1c, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0,
    0x1, 0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0,
    0x1c, 0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x1,
    0xc0, 0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c,
    0x0, 0x38, 0x0, 0x70, 0x0, 0xe0, 0x1, 0xc0,
    0x3, 0x80, 0x7, 0x0, 0xe, 0x0, 0x1c, 0x0,
    0x38, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xc0,

    /* U+300E "『" */
    0xff, 0xfe, 0x0, 0x18, 0x0, 0x60, 0x1, 0x8f,
    0xfe, 0x20, 0x8, 0x80, 0x22, 0x0, 0x88, 0x2,
    0x20, 0x8, 0x80, 0x22, 0x0, 0x88, 0x2, 0x20,
    0x8, 0x80, 0x22, 0x0, 0x88, 0x2, 0x20, 0x8,
    0x80, 0x22, 0x0, 0x88, 0x2, 0x20, 0x8, 0x80,
    0x22, 0x0, 0x88, 0x2, 0x20, 0x8, 0x80, 0x22,
    0x0, 0x88, 0x2, 0x20, 0x8, 0x80, 0x22, 0x0,
    0x88, 0x2, 0x20, 0x8, 0x80, 0x22, 0x0, 0x88,
    0x2, 0x20, 0x8, 0x80, 0x22, 0x0, 0x88, 0x2,
    0x20, 0x8, 0x80, 0x3e, 0x0,

    /* U+300F "』" */
    0x0, 0x7c, 0x1, 0x10, 0x4, 0x40, 0x11, 0x0,
    0x44, 0x1, 0x10, 0x4, 0x40, 0x11, 0x0, 0x44,
    0x1, 0x10, 0x4, 0x40, 0x11, 0x0, 0x44, 0x1,
    0x10, 0x4, 0x40, 0x11, 0x0, 0x44, 0x1, 0x10,
    0x4, 0x40, 0x11, 0x0, 0x44, 0x1, 0x10, 0x4,
    0x40, 0x11, 0x0, 0x44, 0x1, 0x10, 0x4, 0x40,
    0x11, 0x0, 0x44, 0x1, 0x10, 0x4, 0x40, 0x11,
    0x0, 0x44, 0x1, 0x10, 0x4, 0x40, 0x11, 0x0,
    0x44, 0x1, 0x10, 0x4, 0x7f, 0xf1, 0x80, 0x6,
    0x0, 0x18, 0x0, 0x7f, 0xff,

    /* U+3010 "【" */
    0xff, 0xff, 0xfb, 0xff, 0x7f, 0xcf, 0xf1, 0xfe,
    0x3f, 0xc7, 0xf0, 0xfe, 0x1f, 0xc3, 0xf0, 0x7e,
    0xf, 0xc1, 0xf8, 0x3f, 0x7, 0xc0, 0xf8, 0x1f,
    0x3, 0xe0, 0x7c, 0xf, 0x81, 0xf0, 0x3e, 0x7,
    0xc0, 0xf8, 0x1f, 0x3, 0xe0, 0x7c, 0xf, 0x81,
    0xf0, 0x3f, 0x7, 0xe0, 0xfc, 0x1f, 0x83, 0xf0,
    0x7f, 0xf, 0xe1, 0xfc, 0x3f, 0xc7, 0xf8, 0xff,
    0x9f, 0xf3, 0xfe, 0x7f, 0xef, 0xfd, 0xff, 0xc0,

    /* U+3011 "】" */
    0xff, 0xef, 0xfc, 0xff, 0x9f, 0xf1, 0xfe, 0x3f,
    0xc7, 0xf8, 0x7f, 0xf, 0xe1, 0xfc, 0x1f, 0x83,
    0xf0, 0x7e, 0xf, 0xc1, 0xf8, 0x1f, 0x3, 0xe0,
    0x7c, 0xf, 0x81, 0xf0, 0x3e, 0x7, 0xc0, 0xf8,
    0x1f, 0x3, 0xe0, 0x7c, 0xf, 0x81, 0xf0, 0x3e,
    0x7, 0xc1, 0xf8, 0x3f, 0x7, 0xe0, 0xfc, 0x1f,
    0x87, 0xf0, 0xfe, 0x1f, 0xc7, 0xf8, 0xff, 0x1f,
    0xe7, 0xfc, 0xff, 0xbf, 0xf7, 0xff, 0xff, 0xc0,

    /* U+3012 "〒" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,

    /* U+3013 "〓" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xc0,

    /* U+3014 "〔" */
    0x0, 0x0, 0x7, 0x1, 0xf0, 0xfe, 0x3f, 0x8f,
    0xe0, 0xf0, 0xe, 0x0, 0xe0, 0xe, 0x0, 0xe0,
    0xe, 0x0, 0xe0, 0xe, 0x0, 0xe0, 0xe, 0x0,
    0xe0, 0xe, 0x0, 0xe0, 0xe, 0x0, 0xe0, 0xe,
    0x0, 0xe0, 0xe, 0x0, 0xe0, 0xe, 0x0, 0xe0,
    0xe, 0x0, 0xe0, 0xe, 0x0, 0xe0, 0xe, 0x0,
    0xe0, 0xe, 0x0, 0xe0, 0xe, 0x0, 0xe0, 0xe,
    0x0, 0xe0, 0xf, 0x0, 0xfc, 0x3, 0xf0, 0xf,
    0xc0, 0x3f, 0x0, 0xf0, 0x0,

    /* U+3015 "〕" */
    0x0, 0xe, 0x0, 0xf8, 0x7, 0xf0, 0x1f, 0xc0,
    0x7f, 0x0, 0xf0, 0x7, 0x0, 0x70, 0x7, 0x0,
    0x70, 0x7, 0x0, 0x70, 0x7, 0x0, 0x70, 0x7,
    0x0, 0x70, 0x7, 0x0, 0x70, 0x7, 0x0, 0x70,
    0x7, 0x0, 0x70, 0x7, 0x0, 0x70, 0x7, 0x0,
    0x70, 0x7, 0x0, 0x70, 0x7, 0x0, 0x70, 0x7,
    0x0, 0x70, 0x7, 0x0, 0x70, 0x7, 0x0, 0x70,
    0x7, 0x0, 0x70, 0xf, 0x3, 0xf0, 0xfc, 0x3f,
    0xf, 0xc0, 0xe0, 0x0, 0x0,

    /* U+3016 "〖" */
    0xff, 0xf8, 0x2, 0x80, 0x48, 0x4, 0x80, 0x88,
    0x8, 0x80, 0x88, 0x10, 0x81, 0x8, 0x20, 0x82,
    0x8, 0x20, 0x84, 0x8, 0x40, 0x84, 0x8, 0x40,
    0x84, 0x8, 0x80, 0x88, 0x8, 0x80, 0x88, 0x8,
    0x80, 0x88, 0x8, 0x80, 0x88, 0x8, 0x80, 0x88,
    0x8, 0x80, 0x88, 0x8, 0x80, 0x8c, 0x8, 0x40,
    0x84, 0x8, 0x40, 0x86, 0x8, 0x20, 0x82, 0x8,
    0x20, 0x83, 0x8, 0x10, 0x81, 0x88, 0x8, 0x80,
    0xc8, 0x4, 0x80, 0x2f, 0xff,

    /* U+3017 "〗" */
    0x7f, 0xf4, 0x1, 0x20, 0x12, 0x1, 0x10, 0x11,
    0x1, 0x10, 0x10, 0x81, 0x8, 0x10, 0x41, 0x4,
    0x10, 0x41, 0x2, 0x10, 0x21, 0x2, 0x10, 0x21,
    0x2, 0x10, 0x11, 0x1, 0x10, 0x11, 0x1, 0x10,
    0x11, 0x1, 0x10, 0x11, 0x1, 0x10, 0x11, 0x1,
    0x10, 0x11, 0x1, 0x10, 0x11, 0x3, 0x10, 0x21,
    0x2, 0x10, 0x21, 0x2, 0x10, 0x61, 0x4, 0x10,
    0x41, 0xc, 0x10, 0x81, 0x18, 0x11, 0x1, 0x30,
    0x12, 0x1, 0x40, 0x17, 0xff,

    /* U+301D "〝" */
    0xfc, 0x7c, 0xf, 0xf, 0x81, 0xe1, 0xe0, 0x3c,
    0x3c, 0x7, 0x87, 0x80, 0xe0, 0xe0,

    /* U+301E "〞" */
    0xf, 0x8f, 0x87, 0xc7, 0xc1, 0xe1, 0xe0, 0xf0,
    0xf0, 0x78, 0x78, 0x3c, 0x1c, 0x0,

    /* U+3021 "〡" */
    0xce, 0xec, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0x0,

    /* U+3022 "〢" */
    0x0, 0x10, 0x0, 0x38, 0x0, 0x78, 0x0, 0xc0,
    0x1, 0x80, 0x3, 0x0, 0x6, 0x40, 0xc, 0xe0,
    0x19, 0xe0, 0x33, 0x0, 0x66, 0x0, 0xcc, 0x1,
    0x98, 0x3, 0x30, 0x6, 0x60, 0xc, 0xc0, 0x19,
    0x80, 0x33, 0x0, 0x66, 0x0, 0xcc, 0x1, 0x98,
    0x3, 0x30, 0x6, 0x60, 0xc, 0xc0, 0x19, 0x80,
    0x33, 0x0, 0x66, 0x0, 0xcc, 0x1, 0x98, 0x3,
    0x30, 0x6, 0x40, 0xc, 0x0, 0x18, 0x0, 0x30,
    0x0, 0x60, 0x0, 0xc0, 0x1, 0x80, 0x3, 0x0,
    0x6, 0x0, 0xc, 0x0, 0x10,

    /* U+3023 "〣" */
    0x0, 0x0, 0x8, 0x0, 0x0, 0xe, 0x0, 0x0,
    0xf, 0x0, 0x0, 0xc, 0x0, 0x0, 0xc, 0xc0,
    0x0, 0xc, 0xe0, 0x0, 0xc, 0xe0, 0x0, 0xc,
    0xc0, 0x0, 0xc, 0xc0, 0x0, 0xc, 0xc0, 0x60,
    0xc, 0xc0, 0x78, 0xc, 0xc0, 0x60, 0xc, 0xc0,
    0x60, 0xc, 0xc0, 0x60, 0xc, 0xc0, 0x60, 0xc,
    0xc0, 0x60, 0xc, 0xc0, 0x60, 0xc, 0xc0, 0x60,
    0xc, 0xc0, 0x60, 0xc, 0xc0, 0x60, 0xc, 0xc0,
    0x60, 0xc, 0xc0, 0x60, 0xc, 0xc0, 0x60, 0xc,
    0xc0, 0x60, 0xc, 0xc0, 0x60, 0xc, 0xc0, 0x60,
    0xc, 0xc0, 0x60, 0xc, 0xc0, 0x60, 0xc, 0xc0,
    0x60, 0xc, 0xc0, 0x40, 0xc, 0xc0, 0x0, 0xc,
    0xc0, 0x0, 0xc, 0xc0, 0x0, 0xc, 0x80, 0x0,
    0xc, 0x0, 0x0, 0xc, 0x0, 0x0, 0xc, 0x0,
    0x0, 0xc, 0x0, 0x0, 0xc, 0x0, 0x0, 0xc,
    0x0, 0x0, 0x8,

    /* U+3024 "〤" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x6,
    0x0, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0, 0x0,
    0xc, 0x1, 0x0, 0x0, 0x3, 0x0, 0x30, 0x0,
    0x1, 0xc0, 0x2, 0x0, 0x0, 0x60, 0x0, 0x40,
    0x0, 0x18, 0x0, 0xc, 0x0, 0xe, 0x0, 0x1,
    0x80, 0x3, 0x0, 0x0, 0x10, 0x1, 0xc0, 0x0,
    0x2, 0x0, 0x60, 0x0, 0x0, 0x40, 0x38, 0x0,
    0x0, 0xc, 0xc, 0x0, 0x0, 0x1, 0x87, 0x0,
    0x0, 0x0, 0x31, 0x80, 0x0, 0x0, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x18,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x1, 0x9c, 0x0, 0x0, 0x0,
    0xc3, 0x80, 0x0, 0x0, 0x70, 0x70, 0x0, 0x0,
    0x18, 0xe, 0x0, 0x0, 0xc, 0x3, 0xc0, 0x0,
    0x6, 0x0, 0x70, 0x0, 0x3, 0x0, 0xe, 0x0,
    0x1, 0x80, 0x1, 0xc0, 0x0, 0xc0, 0x0, 0x78,
    0x0, 0x60, 0x0, 0xf, 0x0, 0x30, 0x0, 0x3,
    0xc0, 0x10, 0x0, 0x0, 0x78, 0x8, 0x0, 0x0,
    0xe, 0xc, 0x0, 0x0, 0x3, 0xc4, 0x0, 0x0,
    0x0, 0x72, 0x0, 0x0, 0x0, 0x1b, 0x0, 0x0,
    0x0, 0x0,

    /* U+3025 "〥" */
    0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x20, 0x0,
    0x0, 0x10, 0x3, 0x80, 0x8, 0x1, 0xe0, 0xc,
    0x0, 0xf0, 0x6, 0x0, 0x70, 0x3, 0x0, 0x18,
    0x1, 0x80, 0xc, 0x0, 0xc0, 0x2, 0x0, 0x60,
    0x1, 0x80, 0x30, 0x0, 0x60, 0x18, 0x0, 0x18,
    0xc, 0x0, 0x3, 0x86, 0x0, 0x0, 0x3b, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x70, 0xe0, 0x0, 0x38, 0xc, 0x0, 0xc, 0x1,
    0x80, 0x6, 0x0, 0x30, 0x3, 0x80, 0x6, 0x0,
    0xc0, 0x0, 0xc0, 0x60, 0x0, 0x30, 0x18, 0x0,
    0x6, 0xc, 0x0, 0x1, 0x83, 0x0, 0x0, 0x61,
    0x80, 0x0, 0x18, 0x60, 0x0, 0x6, 0x18, 0x0,
    0x1, 0x8c, 0x0, 0x0, 0x63, 0x0, 0x0, 0x38,
    0xc0, 0x0, 0xe, 0x30, 0x0, 0x3, 0xc, 0x0,
    0x0, 0xc3, 0x0, 0x0, 0x70, 0xc0, 0x0, 0x18,
    0x30, 0x0, 0xe, 0x6, 0x0, 0x7, 0x1, 0x80,
    0x1, 0x80, 0x30, 0x0, 0xc0, 0x6, 0x0, 0xe0,
    0x0, 0xe0, 0xf0, 0x0, 0xf, 0xe0, 0x0,

    /* U+3026 "〦" */
    0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x60, 0x0, 0x30, 0x0, 0x0, 0x30,
    0x0, 0x3c, 0x7f, 0xff, 0xff, 0xff, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3027 "〧" */
    0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x0, 0x1, 0x0, 0x0, 0x1,
    0x80, 0x1, 0xc0, 0x0, 0x0, 0xc0, 0x0, 0xf9,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0xf,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+3028 "〨" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80,
    0x0, 0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x18, 0x0, 0x8, 0x0, 0x0,
    0xc, 0x0, 0xe, 0x0, 0x0, 0x6, 0x0, 0x7,
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x0, 0x3e, 0x7, 0xff, 0xff, 0xff, 0xff,
    0x81, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+3029 "〩" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x0,
    0xe, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0,
    0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x0, 0x18,
    0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x70, 0x0, 0x0, 0x0, 0x0, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xe0, 0x0, 0x6, 0x0, 0x1,
    0xc0, 0x0, 0xf, 0x0, 0x3, 0xff, 0xff, 0xff,
    0x80, 0x1, 0xc0, 0x0, 0xf, 0x0, 0x0, 0x80,
    0x0, 0xe, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0,
    0x0, 0x0, 0x0, 0xc, 0x0, 0x0, 0x40, 0x0,
    0xc, 0x0, 0x0, 0x40, 0x0, 0x1c, 0x0, 0x0,
    0x20, 0x0, 0x18, 0x0, 0x0, 0x20, 0x0, 0x18,
    0x0, 0x0, 0x10, 0x0, 0x38, 0x0, 0x0, 0x10,
    0x0, 0x30, 0x0, 0x0, 0x8, 0x0, 0x70, 0x0,
    0x0, 0xc, 0x0, 0x60, 0x0, 0x0, 0x4, 0x0,
    0xe0, 0x0, 0x0, 0x6, 0x1, 0xc0, 0x0, 0x0,
    0x3, 0x1, 0x80, 0x0, 0x0, 0x1, 0x83, 0x80,
    0x0, 0x0, 0x0, 0xc7, 0x0, 0x0, 0x0, 0x0,
    0xe6, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0x0, 0x38, 0x0, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x0, 0x67, 0x0, 0x0, 0x0,
    0x1, 0xc3, 0x80, 0x0, 0x0, 0x3, 0x1, 0xe0,
    0x0, 0x0, 0x6, 0x0, 0xf8, 0x0, 0x0, 0x18,
    0x0, 0x3e, 0x0, 0x0, 0x70, 0x0, 0xf, 0xc0,
    0x0, 0xc0, 0x0, 0x7, 0xfc, 0x3, 0x0, 0x0,
    0x1, 0xfe, 0xc, 0x0, 0x0, 0x0, 0x30, 0x70,
    0x0, 0x0, 0x0, 0x0,

    /* U+4E00 "一" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+4E01 "丁" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0,

    /* U+4E03 "七" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0xe,
    0x0, 0xf, 0x1, 0xfe, 0x0, 0xf, 0x7f, 0xfc,
    0x0, 0x3f, 0xff, 0x0, 0xf, 0xff, 0xe0, 0x0,
    0xff, 0xff, 0x0, 0x0, 0xfe, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x8, 0x0, 0xf, 0x0, 0x8,
    0x0, 0xf, 0x0, 0x8, 0x0, 0xf, 0x0, 0x8,
    0x0, 0xf, 0x0, 0x8, 0x0, 0xf, 0x0, 0x18,
    0x0, 0xf, 0x0, 0x18, 0x0, 0xf, 0x0, 0x1e,
    0x0, 0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x3c,
    0x0, 0xf, 0xff, 0xfc, 0x0, 0xf, 0xff, 0xfc,
    0x0, 0x7, 0xff, 0xf8, 0x0, 0x3, 0xff, 0xf0,

    /* U+4E07 "万" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1,
    0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7,
    0x80, 0xf, 0x0, 0xf, 0xff, 0xfe, 0x0, 0x1f,
    0xff, 0xfc, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x78,
    0x0, 0xf0, 0x0, 0xf0, 0x1, 0xe0, 0x1, 0xe0,
    0x3, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7, 0x80,
    0xf, 0x0, 0xf, 0x0, 0x1e, 0x0, 0x1e, 0x0,
    0x3c, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x78, 0x0,
    0xf0, 0x0, 0xf0, 0x1, 0xe0, 0x1, 0xe0, 0x3,
    0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7, 0x80, 0xf,
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x78, 0x0, 0xf0,
    0x0, 0xf0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0xc0,
    0x7, 0x80, 0x7, 0x80, 0xf, 0x0, 0xf, 0x0,
    0x1c, 0x0, 0x1e, 0x0, 0x38, 0x0, 0x3c, 0x0,
    0xe0, 0x0, 0x78, 0x1, 0x80, 0x0, 0xf0, 0x7,
    0x0, 0x1, 0xe0, 0xc, 0x0, 0x3, 0xc0, 0x30,
    0x0, 0xf, 0x0, 0xc0, 0x0, 0x7c, 0x3, 0x0,
    0x3, 0xf0, 0xc, 0x0, 0x19, 0x0, 0x0,

    /* U+4E08 "丈" */
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x80, 0x3e, 0x0,
    0x0, 0x80, 0x3e, 0x0, 0x0, 0x80, 0x3e, 0x0,
    0x0, 0x80, 0x3e, 0x0, 0x0, 0x80, 0x3e, 0x0,
    0x0, 0x80, 0x3e, 0x0, 0x0, 0xc0, 0x3e, 0x0,
    0x0, 0xc0, 0x3e, 0x0, 0x0, 0xc0, 0x3c, 0x0,
    0x0, 0x40, 0x3c, 0x0, 0x0, 0x60, 0x3c, 0x0,
    0x0, 0x60, 0x3c, 0x0, 0x0, 0x60, 0x3c, 0x0,
    0x0, 0x70, 0x3c, 0x0, 0x0, 0x30, 0x38, 0x0,
    0x0, 0x38, 0x78, 0x0, 0x0, 0x38, 0x78, 0x0,
    0x0, 0x1c, 0x78, 0x0, 0x0, 0x1e, 0xf0, 0x0,
    0x0, 0xe, 0xf0, 0x0, 0x0, 0xf, 0xe0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0xe, 0xfe, 0x0, 0x0, 0x1c, 0x3f, 0x80,
    0x0, 0x30, 0x1f, 0xe0, 0x0, 0x60, 0xf, 0xfc,
    0x0, 0xc0, 0x3, 0xfe, 0x3, 0x0, 0x1, 0xfe,
    0x6, 0x0, 0x0, 0x7c, 0xc, 0x0, 0x0, 0x1c,
    0x10, 0x0, 0x0, 0x4, 0x60, 0x0, 0x0, 0x0,

    /* U+4E09 "三" */
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,

    /* U+4E0A "上" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xe0, 0x0, 0x1f, 0xff, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x3f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+4E0B "下" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x88, 0x0, 0x0, 0x7, 0x88, 0x0,
    0x0, 0x7, 0x8c, 0x0, 0x0, 0x7, 0x8c, 0x0,
    0x0, 0x7, 0x86, 0x0, 0x0, 0x7, 0x86, 0x0,
    0x0, 0x7, 0x87, 0x0, 0x0, 0x7, 0x87, 0x80,
    0x0, 0x7, 0x87, 0x80, 0x0, 0x7, 0x83, 0xe0,
    0x0, 0x7, 0x83, 0xf0, 0x0, 0x7, 0x81, 0xfc,
    0x0, 0x7, 0x81, 0xfc, 0x0, 0x7, 0x80, 0xfc,
    0x0, 0x7, 0x80, 0xfc, 0x0, 0x7, 0x80, 0x7c,
    0x0, 0x7, 0x80, 0x1c, 0x0, 0x7, 0x80, 0xc,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,

    /* U+4E0C "丌" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x7, 0x80, 0x38, 0x0, 0xf, 0x0, 0x70, 0x0,
    0x1e, 0x0, 0xe0, 0x0, 0x3c, 0x1, 0xc0, 0x0,
    0x78, 0x3, 0x80, 0x0, 0xf0, 0x7, 0x0, 0x1,
    0xe0, 0xe, 0x0, 0x3, 0xc0, 0x1c, 0x0, 0x7,
    0x80, 0x38, 0x0, 0xf, 0x0, 0x70, 0x0, 0x1e,
    0x0, 0xe0, 0x0, 0x3c, 0x1, 0xc0, 0x0, 0x78,
    0x3, 0x80, 0x0, 0xf0, 0x7, 0x0, 0x1, 0xe0,
    0xe, 0x0, 0x3, 0xc0, 0x1c, 0x0, 0x7, 0x80,
    0x38, 0x0, 0xf, 0x0, 0x70, 0x0, 0x1e, 0x0,
    0xe0, 0x0, 0x3c, 0x1, 0xc0, 0x0, 0x78, 0x3,
    0x80, 0x0, 0xf0, 0x7, 0x0, 0x1, 0xe0, 0xe,
    0x0, 0x3, 0xc0, 0x1c, 0x0, 0xf, 0x0, 0x38,
    0x0, 0x1e, 0x0, 0x70, 0x0, 0x3c, 0x0, 0xe0,
    0x0, 0x78, 0x1, 0xc0, 0x0, 0xe0, 0x3, 0x80,
    0x3, 0xc0, 0x7, 0x0, 0x7, 0x0, 0xe, 0x0,
    0x1e, 0x0, 0x1c, 0x0, 0x38, 0x0, 0x38, 0x0,
    0xe0, 0x0, 0x70, 0x1, 0xc0, 0x0, 0xe0, 0x7,
    0x0, 0x1, 0xc0, 0x18, 0x0, 0x3, 0x80, 0x0,

    /* U+4E0D "不" */
    0x7f, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x7, 0xc2, 0x0, 0x0, 0x3, 0xe1,
    0x0, 0x0, 0x3, 0xe0, 0x80, 0x0, 0x1, 0xfc,
    0x40, 0x0, 0x0, 0xfe, 0x20, 0x0, 0x0, 0x7f,
    0x10, 0x0, 0x0, 0x7f, 0x8c, 0x0, 0x0, 0x3f,
    0xc6, 0x0, 0x0, 0x3f, 0xe3, 0x0, 0x0, 0x1f,
    0xf1, 0x80, 0x0, 0xe, 0xf8, 0xe0, 0x0, 0xf,
    0x7c, 0x70, 0x0, 0x7, 0x3e, 0x38, 0x0, 0x7,
    0x1f, 0x1c, 0x0, 0x3, 0x8f, 0x87, 0x0, 0x3,
    0x87, 0xc3, 0x80, 0x1, 0x83, 0xe1, 0xe0, 0x1,
    0xc1, 0xf0, 0xf0, 0x0, 0xc0, 0xf8, 0x7c, 0x0,
    0xc0, 0x7c, 0x1f, 0x0, 0x60, 0x3e, 0xf, 0xc0,
    0x60, 0x1f, 0x7, 0xf0, 0x60, 0xf, 0x81, 0xf8,
    0x30, 0x7, 0xc0, 0xf8, 0x30, 0x3, 0xe0, 0x3c,
    0x30, 0x1, 0xf0, 0x1e, 0x10, 0x0, 0xf8, 0x7,
    0x18, 0x0, 0x7c, 0x1, 0x80, 0x0, 0x3e, 0x0,
    0x40, 0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,

    /* U+4E0E "与" */
    0x1, 0xe0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x1f,
    0xff, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0x1, 0xe0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x3e, 0x1, 0xe0, 0x0, 0xf8,
    0x7, 0x80, 0x3, 0xe0, 0x1f, 0xff, 0xff, 0x80,
    0x7f, 0xff, 0xfe, 0x1, 0xe0, 0x0, 0xf8, 0x7,
    0x80, 0x3, 0xe0, 0x1e, 0x0, 0xf, 0x80, 0x78,
    0x0, 0x3e, 0x1, 0xe0, 0x0, 0xf8, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0xf, 0xbf, 0xff, 0xff, 0xbe,
    0xff, 0xff, 0xfe, 0xf8, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x3f, 0x0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0x3f,
    0x0, 0x0, 0x3, 0x10, 0x0,

    /* U+4E0F "丏" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0xf, 0x83, 0x80, 0x0,
    0xf, 0x83, 0x80, 0x0, 0xf, 0x3, 0xff, 0xf8,
    0xf, 0x3, 0xff, 0xf8, 0xf, 0x3, 0x80, 0x78,
    0xf, 0x3, 0x80, 0x78, 0xf, 0x3, 0x80, 0x78,
    0xe, 0x3, 0x80, 0x78, 0xe, 0x3, 0x80, 0x78,
    0xe, 0x3, 0x80, 0x78, 0x1c, 0x3, 0x80, 0x78,
    0x18, 0x3, 0x80, 0x78, 0x30, 0x3, 0x80, 0x78,
    0x3f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf8,
    0x20, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3, 0xf0,
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x3f, 0x80,
    0x0, 0x1, 0xfe, 0x0,

    /* U+4E10 "丐" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0xf, 0x83, 0x80, 0x0,
    0xf, 0x83, 0x80, 0x0, 0xf, 0x3, 0xff, 0xfc,
    0xf, 0x3, 0xff, 0xfc, 0xf, 0x3, 0x80, 0x0,
    0xf, 0x3, 0x80, 0x0, 0xf, 0x3, 0x80, 0x0,
    0xe, 0x3, 0x80, 0x0, 0xe, 0x3, 0x80, 0x0,
    0xe, 0x3, 0x80, 0x0, 0x1c, 0x3, 0x80, 0x0,
    0x18, 0x3, 0x80, 0x78, 0x30, 0x3, 0x80, 0x78,
    0x3f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf8,
    0x20, 0x0, 0x0, 0x78, 0x20, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4E11 "丑" */
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x7, 0xff, 0xff, 0xfc, 0x3, 0xff, 0xff, 0xfe,
    0x0, 0x3, 0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7,
    0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1,
    0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e, 0x0,
    0x78, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x7, 0x80,
    0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0, 0x1, 0xe0,
    0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78,
    0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e,
    0x0, 0x78, 0x7, 0xff, 0xff, 0xfc, 0x3, 0xff,
    0xff, 0xfe, 0x0, 0x3, 0xc0, 0xf, 0x0, 0x1,
    0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0,
    0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x1, 0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0,
    0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0,
    0x0, 0x1c, 0x0, 0x78, 0x0, 0xe, 0x0, 0x3c,
    0x0, 0x7, 0x0, 0x1e, 0x0, 0x3, 0x0, 0x1e,
    0x0, 0x3, 0x80, 0xf, 0x0, 0x1, 0x80, 0x7,
    0x0, 0x0, 0xc0, 0x3, 0x0, 0x0, 0x40, 0x3,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0,

    /* U+4E13 "专" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x1f, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfc,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x0, 0x1c, 0x0, 0x0, 0x0, 0x18, 0x1, 0xe0,
    0x0, 0x20, 0x1, 0xe0, 0x0, 0xc0, 0x1, 0xe0,
    0x1, 0xff, 0xff, 0xe0, 0x1, 0xff, 0xff, 0xe0,
    0x1, 0x0, 0x3, 0xe0, 0x1, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x7, 0x80, 0x2, 0x0, 0xf, 0x0,
    0x1, 0xc0, 0xe, 0x0, 0x0, 0x70, 0x18, 0x0,
    0x0, 0x3e, 0x70, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x0, 0x1, 0xfe, 0x0,
    0x0, 0x0, 0xff, 0x80, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xc0,

    /* U+4E14 "且" */
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xff, 0xff, 0xe0, 0x1, 0xff, 0xff, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xff, 0xf9, 0xe0, 0x1, 0xff, 0xf9, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xff, 0xf9, 0xe0,
    0x1, 0xff, 0xf9, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,

    /* U+4E15 "丕" */
    0x3f, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0x84, 0x0, 0x0, 0x7, 0x82, 0x0,
    0x0, 0xf, 0xe2, 0x0, 0x0, 0xf, 0xe2, 0x0,
    0x0, 0xf, 0xe2, 0x0, 0x0, 0x1f, 0xe3, 0x0,
    0x0, 0x1f, 0xe3, 0x0, 0x0, 0x1f, 0xe3, 0x0,
    0x0, 0x3b, 0xe3, 0x0, 0x0, 0x3b, 0xe1, 0x80,
    0x0, 0x73, 0xe1, 0x80, 0x0, 0x73, 0xe1, 0xc0,
    0x0, 0xe3, 0xe1, 0xc0, 0x0, 0xe3, 0xe1, 0xe0,
    0x0, 0xc3, 0xe1, 0xe0, 0x1, 0x83, 0xe0, 0xf0,
    0x1, 0x83, 0xe0, 0xf8, 0x3, 0x3, 0xe0, 0xf8,
    0x7, 0x3, 0xe0, 0xfc, 0x6, 0x3, 0xe0, 0x78,
    0xc, 0x3, 0xe0, 0x78, 0x8, 0x3, 0xe0, 0x38,
    0x18, 0x3, 0xe0, 0x38, 0x30, 0x3, 0xe0, 0x18,
    0x20, 0x3, 0xe0, 0x8, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,

    /* U+4E16 "世" */
    0x0, 0x3, 0xc1, 0xe0, 0x0, 0x1, 0xe0, 0xf0,
    0x1, 0xe0, 0xf0, 0x78, 0x0, 0xf0, 0x78, 0x3c,
    0x0, 0x78, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0xf,
    0x0, 0x1e, 0xf, 0x7, 0x80, 0xf, 0x7, 0x83,
    0xc0, 0x7, 0x83, 0xc1, 0xe0, 0x3, 0xc1, 0xe0,
    0xf0, 0x1, 0xe0, 0xf0, 0x78, 0x0, 0xf0, 0x78,
    0x3c, 0x0, 0x78, 0x3c, 0x1e, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xf, 0x7,
    0x83, 0xc0, 0x7, 0x83, 0xc1, 0xe0, 0x3, 0xc1,
    0xe0, 0xf0, 0x1, 0xe0, 0xf0, 0x78, 0x0, 0xf0,
    0x78, 0x3c, 0x0, 0x78, 0x3c, 0x1e, 0x0, 0x3c,
    0x1e, 0xf, 0x0, 0x1e, 0xf, 0x7, 0x80, 0xf,
    0x7, 0x83, 0xc0, 0x7, 0x83, 0xc1, 0xe0, 0x3,
    0xc1, 0xe0, 0xf0, 0x1, 0xe0, 0xf0, 0x78, 0x0,
    0xf0, 0x78, 0x3c, 0x0, 0x78, 0x3c, 0x1e, 0x0,
    0x3c, 0x1e, 0xf, 0x0, 0x1e, 0xf, 0x7, 0x80,
    0xf, 0x7, 0xff, 0xc0, 0x7, 0x83, 0xff, 0xe0,
    0x3, 0xc1, 0xe0, 0xf0, 0x1, 0xe0, 0xf0, 0x78,
    0x0, 0xf0, 0x78, 0x3c, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xfe, 0x1, 0xff, 0xff,
    0xff, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,

    /* U+4E18 "丘" */
    0x0, 0x0, 0x0, 0xc0, 0x1, 0xe0, 0x3, 0xf8,
    0x0, 0xf0, 0xf, 0xff, 0x0, 0x78, 0x7f, 0xff,
    0xc0, 0x3f, 0xff, 0xe0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xfc, 0x1, 0xff,
    0xff, 0xfe, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78,
    0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e,
    0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x7,
    0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0, 0x1,
    0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0,
    0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x1, 0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0,
    0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0,

    /* U+4E19 "丙" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x3c,
    0x7, 0x80, 0x78, 0x78, 0xf, 0x0, 0xf0, 0xf0,
    0x1e, 0x1, 0xe1, 0xff, 0xff, 0xff, 0xc3, 0xff,
    0xff, 0xff, 0x87, 0x80, 0xf0, 0xf, 0xf, 0x1,
    0xe0, 0x1e, 0x1e, 0x3, 0xc0, 0x3c, 0x3c, 0x7,
    0x80, 0x78, 0x78, 0xf, 0x0, 0xf0, 0xf0, 0x1f,
    0x1, 0xe1, 0xe0, 0x3e, 0x3, 0xc3, 0xc0, 0x7c,
    0x7, 0x87, 0x80, 0xe8, 0xf, 0xf, 0x3, 0xd8,
    0x1e, 0x1e, 0x7, 0x38, 0x3c, 0x3c, 0xe, 0x70,
    0x78, 0x78, 0x38, 0x70, 0xf0, 0xf0, 0x70, 0xf9,
    0xe1, 0xe1, 0xc1, 0xfb, 0xc3, 0xc3, 0x1, 0xff,
    0x87, 0x8c, 0x3, 0xef, 0xf, 0x10, 0x3, 0x9e,
    0x1e, 0x40, 0x3, 0x3c, 0x3d, 0x0, 0x2, 0x78,
    0x7c, 0x0, 0x0, 0xf0, 0xf0, 0x0, 0x1, 0xe1,
    0xe0, 0x0, 0x3, 0xc3, 0xc0, 0x0, 0x7, 0x87,
    0x80, 0x0, 0xf, 0xf, 0x0, 0x0, 0x1e, 0x1e,
    0x0, 0x0, 0x38, 0x3c, 0x0, 0x0, 0xf0, 0x78,
    0x0, 0x3, 0xc0, 0xf0, 0x0, 0x1f, 0x1, 0xe0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4E1A "业" */
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x7, 0x20, 0x3c, 0x1c, 0x6,
    0x20, 0x3c, 0x1c, 0xe, 0x10, 0x3c, 0x1c, 0xc,
    0x10, 0x3c, 0x1c, 0xc, 0x18, 0x3c, 0x1c, 0x18,
    0x18, 0x3c, 0x1c, 0x18, 0x1c, 0x3c, 0x1c, 0x38,
    0xc, 0x3c, 0x1c, 0x30, 0xe, 0x3c, 0x1c, 0x30,
    0xe, 0x3c, 0x1c, 0x60, 0xe, 0x3c, 0x1c, 0x60,
    0xf, 0x3c, 0x1c, 0xc0, 0x7, 0x3c, 0x1c, 0xc0,
    0x7, 0xbc, 0x1c, 0xc0, 0x7, 0xbc, 0x1d, 0x80,
    0x7, 0xbc, 0x1d, 0x80, 0x3, 0xbc, 0x1f, 0x0,
    0x3, 0x3c, 0x1f, 0x0, 0x3, 0x3c, 0x1f, 0x0,
    0x2, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x3c, 0x1c, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,

    /* U+4E1B "丛" */
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0xf, 0x0, 0x78, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0, 0xf,
    0x0, 0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3,
    0xc0, 0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x78, 0x0, 0x7, 0x80,
    0x3c, 0x0, 0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0,
    0xf, 0x0, 0x0, 0xf0, 0x7, 0x80, 0x0, 0x7c,
    0x3, 0xc0, 0x0, 0x3e, 0x1, 0xe0, 0x0, 0x1f,
    0x80, 0xf0, 0x0, 0xf, 0x60, 0x78, 0x0, 0x7,
    0xb8, 0x3c, 0x0, 0x3, 0xdc, 0x3e, 0x0, 0x1,
    0xcf, 0x1f, 0x0, 0x0, 0xe3, 0xcf, 0x40, 0x0,
    0xf1, 0xe7, 0xa0, 0x0, 0x78, 0x73, 0xd0, 0x0,
    0x38, 0x33, 0xcc, 0x0, 0x1c, 0x19, 0xe6, 0x0,
    0xc, 0x0, 0xe3, 0x80, 0xe, 0x0, 0xe1, 0xc0,
    0x7, 0x0, 0x70, 0xf0, 0x3, 0x0, 0x30, 0x3c,
    0x3, 0x0, 0x30, 0x1f, 0x1, 0x80, 0x18, 0xf,
    0xe0, 0x80, 0x18, 0x3, 0xe0, 0xc0, 0x18, 0x1,
    0xf0, 0x40, 0x8, 0x0, 0x78, 0x40, 0x8, 0x0,
    0x1c, 0x60, 0x8, 0x0, 0xe, 0x20, 0xc, 0x0,
    0x1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8,

    /* U+4E1C "东" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0x7f, 0xff, 0xff, 0xff, 0x80, 0xe, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x0,
    0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x8f,
    0x0, 0x0, 0x1, 0xc7, 0x80, 0x0, 0x1, 0xc3,
    0xc0, 0x0, 0x0, 0xc1, 0xe0, 0x0, 0x0, 0xc0,
    0xf0, 0x0, 0x0, 0x40, 0x78, 0x0, 0x0, 0x40,
    0x3c, 0x0, 0x0, 0x40, 0x1e, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xf0, 0x7f, 0xff, 0xff, 0xf8, 0x30,
    0x3, 0xc0, 0x0, 0x10, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0xf0, 0x80, 0x0, 0x7c, 0x78, 0x40, 0x0,
    0x3e, 0x3c, 0x10, 0x0, 0x1f, 0x1e, 0x8, 0x0,
    0xf, 0xf, 0x4, 0x0, 0x7, 0x87, 0x83, 0x0,
    0x7, 0xc3, 0xc1, 0xc0, 0x3, 0xe1, 0xe0, 0xe0,
    0x1, 0xe0, 0xf0, 0x78, 0x0, 0xf0, 0x78, 0x1e,
    0x0, 0xf0, 0x3c, 0xf, 0x80, 0x70, 0x1e, 0x7,
    0xf0, 0x38, 0xf, 0x1, 0xf8, 0x38, 0x7, 0x80,
    0xf8, 0x38, 0x3, 0xc0, 0x3c, 0x18, 0x1, 0xe0,
    0xe, 0x18, 0x0, 0xf0, 0x3, 0x10, 0x0, 0x78,
    0x0, 0xc0, 0x0, 0x78, 0x0, 0x20, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x1, 0x90,
    0x0, 0x0,

    /* U+4E1D "丝" */
    0x0, 0x0, 0x7, 0xc0, 0x1, 0xf0, 0x3, 0xe0,
    0x0, 0xf8, 0x1, 0xf0, 0x0, 0x7c, 0x0, 0xf0,
    0x0, 0x3e, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0x0, 0x1, 0xe0, 0x3,
    0x80, 0x1, 0xe7, 0xc3, 0xc7, 0xc0, 0xf3, 0xe1,
    0xc3, 0xe0, 0x71, 0xf0, 0xe1, 0xf0, 0x78, 0xf0,
    0xe0, 0xf8, 0x38, 0x78, 0x60, 0x7c, 0x38, 0x3c,
    0x60, 0x7c, 0x18, 0x7e, 0x30, 0xfe, 0x18, 0xef,
    0x21, 0xef, 0x1f, 0xe7, 0x3f, 0xef, 0xf, 0xe7,
    0x9f, 0xe7, 0x83, 0xc3, 0xc7, 0xc7, 0x81, 0x81,
    0xc3, 0x83, 0xc0, 0x1, 0xe0, 0x3, 0xc0, 0x0,
    0xe0, 0x1, 0xc0, 0x0, 0xf0, 0x1, 0xc0, 0x0,
    0x70, 0x0, 0xc0, 0x0, 0x70, 0x40, 0xc0, 0x0,
    0x70, 0x40, 0xc0, 0x20, 0x60, 0xc0, 0xc0, 0x60,
    0x61, 0xc0, 0xc0, 0xe1, 0xff, 0xc0, 0x87, 0xf0,
    0xff, 0xc1, 0xff, 0xe0, 0x3f, 0x80, 0x7f, 0xe0,
    0x1f, 0x0, 0x3f, 0xe0, 0xe, 0x0, 0x1f, 0xc0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xe0,

    /* U+4E1E "丞" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0x3f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x3, 0x80,
    0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0x38, 0x0,
    0x0, 0x0, 0xe0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0xf, 0xc0, 0x0, 0x0, 0x1, 0xc8, 0x0,
    0x0, 0x1, 0xc8, 0x0, 0x0, 0x79, 0xc8, 0xc,
    0x0, 0x79, 0xc8, 0x1c, 0x7f, 0xf9, 0xc8, 0x38,
    0x7f, 0xf9, 0xc4, 0x30, 0x0, 0x79, 0xc4, 0x60,
    0x0, 0x79, 0xc4, 0xe0, 0x0, 0x79, 0xc5, 0xc0,
    0x0, 0x71, 0xc7, 0x80, 0x0, 0x71, 0xc7, 0x0,
    0x0, 0xf1, 0xc6, 0x0, 0x0, 0xf1, 0xc3, 0x0,
    0x0, 0xe1, 0xc3, 0x0, 0x0, 0xe1, 0xc3, 0x80,
    0x0, 0xe1, 0xc3, 0xc0, 0x1, 0xc1, 0xc1, 0xc0,
    0x1, 0x81, 0xc1, 0xe0, 0x1, 0x81, 0xc0, 0xf0,
    0x3, 0x1, 0xc0, 0xf8, 0x3, 0x1, 0xc0, 0xfe,
    0x6, 0x1, 0xc0, 0x7e, 0x4, 0x1, 0xc0, 0x3e,
    0x8, 0x1, 0xc0, 0x3c, 0x18, 0x1, 0xc0, 0x1c,
    0x30, 0x3, 0xc0, 0xc, 0x60, 0x3, 0xc0, 0x4,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x0, 0x48, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+4E22 "丢" */
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x7f, 0xfc, 0x0, 0x3, 0xff, 0xff,
    0x0, 0x7f, 0xff, 0xf8, 0x1, 0xfc, 0x1f, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xe0, 0x7f, 0xff, 0xff, 0xf0, 0x0, 0x7,
    0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x0, 0xf, 0x80, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8, 0x80, 0x0,
    0x0, 0x78, 0x20, 0x0, 0x0, 0x3c, 0x10, 0x0,
    0x0, 0x1e, 0xc, 0x0, 0x0, 0x1e, 0x6, 0x0,
    0x0, 0xf, 0x3, 0x80, 0x0, 0xf, 0x0, 0xc0,
    0x0, 0x7, 0x0, 0x70, 0x0, 0x7, 0x0, 0x3c,
    0x0, 0x7, 0x0, 0xf, 0x0, 0x7, 0x0, 0x1f,
    0xc0, 0x7, 0x0, 0x33, 0xf8, 0x6, 0x1, 0xf0,
    0xfc, 0x1f, 0xff, 0xe0, 0x3e, 0x7, 0xff, 0xc0,
    0x1f, 0x3, 0xff, 0x0, 0x7, 0x83, 0xf8, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x0, 0x20,

    /* U+4E24 "两" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0xf, 0xf, 0x0, 0x0, 0x7, 0x87, 0x80,
    0x0, 0x3, 0xc3, 0xc0, 0x0, 0x1, 0xe1, 0xe0,
    0x0, 0x0, 0xf0, 0xf0, 0x0, 0x0, 0x78, 0x78,
    0x0, 0x0, 0x3c, 0x3c, 0x0, 0x1e, 0x1e, 0x1e,
    0xe, 0xf, 0xf, 0xf, 0x7, 0x7, 0x87, 0x87,
    0x83, 0x83, 0xff, 0xff, 0xff, 0xc1, 0xe1, 0xe1,
    0xe0, 0xe0, 0xf0, 0xf0, 0xf0, 0x70, 0x78, 0x78,
    0x78, 0x38, 0x3c, 0x3c, 0x3c, 0x1c, 0x1e, 0x1e,
    0x1e, 0xe, 0xf, 0xf, 0xf, 0x7, 0x7, 0x87,
    0x87, 0x83, 0x83, 0xc3, 0xc3, 0xc1, 0xc1, 0xe1,
    0xf1, 0xe0, 0xe0, 0xf0, 0xfc, 0xf8, 0x70, 0x78,
    0x7e, 0x74, 0x38, 0x3c, 0x7b, 0xbb, 0x1c, 0x1e,
    0x39, 0xdd, 0xce, 0xf, 0x1c, 0x7c, 0xf7, 0x7,
    0x8c, 0x3e, 0x7f, 0x83, 0xce, 0xe, 0x3d, 0xc1,
    0xe6, 0x7, 0xc, 0xe0, 0xf6, 0x3, 0x6, 0x70,
    0x7b, 0x3, 0x1, 0x38, 0x3d, 0x1, 0x80, 0x9c,
    0x1f, 0x1, 0x80, 0xe, 0xf, 0x80, 0x80, 0x7,
    0x7, 0x80, 0x80, 0x3, 0x83, 0xc0, 0x0, 0x1,
    0xc1, 0xe0, 0x0, 0x0, 0xe0, 0xf0, 0x0, 0x0,
    0x70, 0x78, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0,
    0x3c, 0x1e, 0x0, 0x0, 0xfc, 0xf, 0x0, 0x7,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4E25 "严" */
    0x3f, 0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff,
    0xc0, 0x3, 0x87, 0x80, 0x0, 0x1, 0xc3, 0xc0,
    0x0, 0x0, 0xe1, 0xe0, 0x0, 0x40, 0x70, 0xf0,
    0x60, 0x30, 0x38, 0x78, 0x60, 0xc, 0x1c, 0x3c,
    0x30, 0x7, 0xe, 0x1e, 0x30, 0x3, 0xc7, 0xf,
    0x18, 0x0, 0xf3, 0x87, 0x98, 0x0, 0x71, 0xc3,
    0xc8, 0x0, 0x18, 0xe1, 0xec, 0x0, 0x8, 0x70,
    0xfc, 0x0, 0x0, 0x38, 0x7e, 0x0, 0x0, 0x1c,
    0x3e, 0x0, 0xe, 0xe, 0x1e, 0x0, 0x7, 0x7,
    0xf, 0x0, 0x3, 0xff, 0xff, 0xff, 0xc1, 0xff,
    0xff, 0xff, 0xe0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x1c, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0, 0x3, 0x80, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0x0, 0xe0, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0,
    0x0, 0x30, 0x0, 0x0, 0x0, 0x18, 0x0, 0x0,
    0x0, 0x18, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0,
    0x0, 0xc, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
    0x0, 0x0,

    /* U+4E26 "並" */
    0x1, 0x0, 0x3, 0x0, 0x3, 0x0, 0x6, 0x0,
    0x3, 0x0, 0xc, 0x0, 0x7, 0x0, 0x30, 0x0,
    0xf, 0x0, 0x60, 0x0, 0xf, 0x1, 0x80, 0x0,
    0x1e, 0x3, 0x0, 0x0, 0x3c, 0xc, 0x0, 0x0,
    0x38, 0x18, 0x0, 0x0, 0x60, 0x60, 0x1, 0xff,
    0xff, 0xff, 0xf3, 0xff, 0xff, 0xff, 0xe0, 0x7,
    0x83, 0xc0, 0x0, 0xf, 0x7, 0x80, 0x0, 0x1e,
    0xf, 0x2, 0x20, 0x3c, 0x1e, 0x6, 0x20, 0x78,
    0x3c, 0x1c, 0x40, 0xf0, 0x78, 0x38, 0xc1, 0xe0,
    0xf0, 0xe1, 0xc3, 0xc1, 0xe1, 0xc1, 0x87, 0x83,
    0xc7, 0x3, 0x8f, 0x7, 0x8e, 0x7, 0x9e, 0xf,
    0x38, 0x7, 0x3c, 0x1e, 0x70, 0xf, 0x78, 0x3d,
    0xc0, 0x1e, 0xf0, 0x7b, 0x80, 0x1f, 0xe0, 0xf6,
    0x0, 0x3f, 0xc1, 0xfc, 0x0, 0x7f, 0x83, 0xf0,
    0x0, 0x6f, 0x7, 0xe0, 0x0, 0xde, 0xf, 0x80,
    0x0, 0xbc, 0x1f, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0xf0, 0x78, 0x0, 0x1, 0xe0, 0xf0, 0x0,
    0x3, 0xc1, 0xe0, 0x0, 0x7, 0x83, 0xc0, 0x0,
    0xf, 0x7, 0x80, 0x0, 0x1e, 0xf, 0x0, 0x0,
    0x3c, 0x1e, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0,
    0xf0, 0x78, 0x0, 0x1, 0xe0, 0xf0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,

    /* U+4E27 "丧" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x3f, 0xff, 0xff, 0xf8,
    0x3f, 0xff, 0xff, 0xf8, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x60,
    0x2, 0x3, 0xc0, 0x40, 0x3, 0x3, 0xc0, 0xc0,
    0x1, 0xc3, 0xc0, 0x80, 0x1, 0xe3, 0xc1, 0x80,
    0x1, 0xe3, 0xc1, 0x0, 0x0, 0xe3, 0xc3, 0x0,
    0x0, 0xc3, 0xc6, 0x0, 0x0, 0x43, 0xc6, 0x0,
    0x0, 0x3, 0xc4, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x1, 0xc1, 0x0, 0x0, 0x1, 0xc0, 0x80, 0x0,
    0x1, 0xc0, 0x80, 0x30, 0x1, 0xc0, 0x80, 0x60,
    0x1, 0xc0, 0x80, 0xe0, 0x1, 0xc0, 0xc0, 0xc0,
    0x1, 0xc0, 0xc1, 0x80, 0x1, 0xc0, 0x63, 0x0,
    0x1, 0xc0, 0x67, 0x0, 0x1, 0xc0, 0x76, 0x0,
    0x1, 0xc0, 0x7c, 0x0, 0x1, 0xc0, 0x3c, 0x0,
    0x1, 0xc0, 0x3e, 0x0, 0x1, 0xc0, 0x1f, 0x0,
    0x1, 0xc0, 0xf, 0xc0, 0x1, 0xc0, 0xf, 0xf0,
    0x1, 0xc0, 0xc7, 0xfc, 0x1, 0xc3, 0x3, 0xff,
    0x1, 0xde, 0x1, 0xfe, 0x1, 0xfc, 0x0, 0xfc,
    0x1f, 0xf8, 0x0, 0x7c, 0xf, 0xe0, 0x0, 0x18,
    0xf, 0xc0, 0x0, 0x8, 0xe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+4E28 "丨" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0,

    /* U+4E2A "个" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0x0, 0xf, 0xb0, 0x0,
    0x0, 0xf, 0x10, 0x0, 0x0, 0x1e, 0x18, 0x0,
    0x0, 0x1e, 0x1c, 0x0, 0x0, 0x3c, 0xe, 0x0,
    0x0, 0x78, 0xf, 0x0, 0x0, 0x70, 0x7, 0x80,
    0x0, 0xe0, 0x7, 0xc0, 0x1, 0xc0, 0x3, 0xf0,
    0x1, 0x83, 0xc1, 0xfc, 0x3, 0x3, 0xc0, 0xff,
    0x6, 0x3, 0xc0, 0x7f, 0xc, 0x3, 0xc0, 0x3e,
    0x18, 0x3, 0xc0, 0x1e, 0x30, 0x3, 0xc0, 0x6,
    0x40, 0x3, 0xc0, 0x1, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+4E2B "丫" */
    0x0, 0x0, 0x0, 0x34, 0x0, 0x0, 0x7, 0x60,
    0x0, 0x0, 0xe3, 0x0, 0x0, 0xc, 0x1c, 0x0,
    0x1, 0x80, 0xe0, 0x0, 0x30, 0xf, 0x0, 0x6,
    0x0, 0x7c, 0x0, 0xc0, 0x3, 0xe0, 0x1c, 0x0,
    0x1f, 0x3, 0x80, 0x0, 0xf0, 0x70, 0x0, 0xf,
    0xe, 0x0, 0x0, 0x71, 0xc0, 0x0, 0x3, 0x38,
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0,

    /* U+4E2C "丬" */
    0x0, 0x1e, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0,
    0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0,
    0x1e, 0x0, 0x3c, 0x80, 0x78, 0xc0, 0xf1, 0xc1,
    0xe3, 0xc3, 0xc3, 0xc7, 0x87, 0xf, 0x6, 0x1e,
    0x8, 0x3c, 0x0, 0x78, 0x0, 0xf0, 0x1, 0xe0,
    0x3, 0xc0, 0x7, 0x80, 0xf, 0x0, 0x3e, 0x1,
    0xfc, 0xf, 0x7b, 0xfc, 0xf7, 0xf1, 0xef, 0xc3,
    0xde, 0x7, 0xb8, 0xf, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0x78, 0x0, 0xf0, 0x1, 0xe0, 0x3, 0xc0,
    0x7, 0x80, 0xf, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x78, 0x0, 0xf0, 0x1, 0xe0, 0x3, 0xc0,

    /* U+4E2D "中" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0xf0, 0xf, 0x0,
    0xff, 0x0, 0xf0, 0xf, 0xf0, 0xf, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xf0, 0xf, 0xf0, 0xf, 0x0, 0xff, 0x0, 0xf0,
    0xf, 0xf0, 0xf, 0x0, 0xff, 0x0, 0xf0, 0xf,
    0xf0, 0xf, 0x0, 0xff, 0x0, 0xf0, 0xf, 0xf0,
    0xf, 0x0, 0xff, 0x0, 0xf0, 0xf, 0xf0, 0xf,
    0x0, 0xff, 0x0, 0xf0, 0xf, 0xf0, 0xf, 0x0,
    0xff, 0x0, 0xf0, 0xf, 0xf0, 0xf, 0x0, 0xff,
    0x0, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0xf, 0x0, 0xff, 0x0, 0xf0,
    0xf, 0xf0, 0xf, 0x0, 0xf0, 0x0, 0xf0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0,

    /* U+4E2E "丮" */
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x1e, 0x7, 0xff, 0xff, 0xfc, 0xf,
    0xff, 0xff, 0xf8, 0x0, 0x3c, 0x0, 0xf0, 0x0,
    0x78, 0x1, 0xe0, 0x0, 0xf0, 0x3, 0xc0, 0x1,
    0xe0, 0x7, 0x80, 0x3, 0xc0, 0xf, 0x0, 0x7,
    0x80, 0x1e, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0x78, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x78,
    0x1, 0xe0, 0x0, 0xf0, 0x3, 0xc0, 0x7f, 0xff,
    0x87, 0x80, 0xff, 0xff, 0xf, 0x0, 0x7, 0x80,
    0x1e, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x1e, 0x0,
    0x78, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x78, 0x1,
    0xe0, 0x0, 0xf0, 0x3, 0xc0, 0x1, 0xe0, 0x7,
    0x80, 0x3, 0xc0, 0xf, 0x0, 0x7, 0x80, 0x1e,
    0x0, 0xf, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x78,
    0xf, 0xff, 0xf0, 0x78, 0x1f, 0xff, 0xe0, 0xf1,
    0x0, 0xf0, 0x1, 0xe2, 0x1, 0xe0, 0x3, 0xc4,
    0x3, 0xc0, 0x7, 0x88, 0x7, 0x80, 0x7, 0x90,
    0xf, 0x0, 0xf, 0x20, 0x1e, 0x0, 0x1f, 0x40,
    0x3c, 0x0, 0x3e, 0x80, 0x78, 0x0, 0x3f, 0x0,
    0xf0, 0x0, 0x7f, 0x1, 0xe0, 0x0, 0xfe, 0x3,
    0xc0, 0x0, 0xfc, 0x7, 0x80, 0x0, 0xf8, 0xf,
    0x0, 0x0, 0xf0, 0x1e, 0x0, 0x0, 0xe0, 0x3c,
    0x0, 0x0, 0x40,

    /* U+4E30 "丰" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x3f, 0xff, 0xff, 0xfe,
    0x3f, 0xff, 0xff, 0xfe, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+4E32 "串" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x3, 0xc0,
    0xf0, 0x1e, 0x1f, 0xff, 0xff, 0xf0, 0xff, 0xff,
    0xff, 0x87, 0x81, 0xe0, 0x3c, 0x3c, 0xf, 0x1,
    0xe1, 0xe0, 0x78, 0xf, 0xf, 0x3, 0xc0, 0x78,
    0x78, 0x1e, 0x3, 0xc3, 0xc0, 0xf0, 0x1e, 0x1e,
    0x7, 0x80, 0xf0, 0xf0, 0x3c, 0x7, 0x87, 0xff,
    0xff, 0xfc, 0x3c, 0xf, 0x1, 0xe1, 0xe0, 0x78,
    0xf, 0xf, 0x3, 0xc0, 0x78, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x78, 0x7, 0x80, 0x3,
    0xc0, 0x3c, 0x1, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80, 0x78, 0x3, 0xfc, 0x3,
    0xc0, 0x1f, 0xe0, 0x1e, 0x0, 0xff, 0x0, 0xf0,
    0x7, 0xf8, 0x7, 0x80, 0x3f, 0xc0, 0x3c, 0x1,
    0xfe, 0x1, 0xe0, 0xf, 0xf0, 0xf, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xe0,
    0x1e, 0x0, 0xff, 0x0, 0xf0, 0x7, 0xf8, 0x7,
    0x80, 0x3c, 0x0, 0x3c, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x7, 0x80, 0x0,

    /* U+4E34 "临" */
    0x3, 0xc0, 0xf0, 0x0, 0x7, 0x81, 0xe0, 0x0,
    0xf, 0x3, 0xc0, 0x0, 0x1e, 0xf, 0x80, 0x0,
    0x3c, 0x1e, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0,
    0xf0, 0x7f, 0xff, 0xf9, 0xe0, 0xff, 0xff, 0xf3,
    0xc1, 0xff, 0xff, 0xe7, 0x83, 0x80, 0x3, 0xcf,
    0x6, 0x0, 0x7, 0x9e, 0x1c, 0x40, 0xf, 0x3c,
    0x30, 0xc0, 0x1e, 0x78, 0x60, 0xc0, 0x3c, 0xf1,
    0x81, 0xc0, 0x79, 0xe2, 0x3, 0x80, 0xf3, 0xcc,
    0x7, 0x1, 0xe7, 0x90, 0xe, 0x3, 0xcf, 0x0,
    0xc, 0x7, 0x9e, 0x0, 0x10, 0xf, 0x3c, 0x0,
    0x0, 0x1e, 0x79, 0xe0, 0xf, 0x3c, 0xf3, 0xc0,
    0x1e, 0x79, 0xe7, 0xff, 0xfc, 0xf3, 0xcf, 0xff,
    0xf9, 0xe7, 0x9e, 0x3c, 0xf3, 0xcf, 0x3c, 0x79,
    0xe7, 0x9e, 0x78, 0xf3, 0xcf, 0x3c, 0xf1, 0xe7,
    0x9e, 0x79, 0xe3, 0xcf, 0x3c, 0xf3, 0xc7, 0x9e,
    0x79, 0xe7, 0x8f, 0x3c, 0xf3, 0xcf, 0x1e, 0x79,
    0xe7, 0x9e, 0x3c, 0xf3, 0xcf, 0x3c, 0x79, 0xe7,
    0x9e, 0x78, 0xf3, 0xcf, 0x3c, 0xf1, 0xe7, 0x9e,
    0x79, 0xe3, 0xcf, 0x3c, 0xf3, 0xc7, 0x9e, 0x79,
    0xe7, 0x8f, 0x3c, 0xf3, 0xcf, 0xff, 0xf9, 0xe7,
    0x9f, 0xff, 0xf3, 0xcf, 0x3c, 0x1, 0xe0, 0x1e,
    0x78, 0x3, 0xc0, 0x3c, 0xf0, 0x7, 0x80, 0x79,
    0xe0, 0xf, 0x0,

    /* U+4E36 "丶" */
    0x80, 0x81, 0x83, 0x87, 0x87, 0xf, 0xf, 0x1e,
    0x1c, 0x38, 0x20, 0x40,

    /* U+4E38 "丸" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x78, 0x7, 0xc0, 0x0, 0x78, 0x7, 0x80,
    0x0, 0x78, 0x7, 0x80, 0xff, 0xff, 0xff, 0x80,
    0xff, 0xff, 0xff, 0x80, 0x0, 0x78, 0x7, 0x80,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x78, 0x7, 0x80,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x78, 0x7, 0x80,
    0x0, 0x78, 0x7, 0x80, 0x20, 0x78, 0x7, 0x80,
    0x10, 0x78, 0x7, 0x80, 0x18, 0x78, 0x7, 0x80,
    0xe, 0x78, 0x7, 0x80, 0x7, 0x78, 0x7, 0x80,
    0x7, 0xf8, 0x7, 0x80, 0x3, 0xf8, 0x7, 0x80,
    0x1, 0xf8, 0x7, 0x80, 0x1, 0xf8, 0x7, 0x80,
    0x0, 0xfc, 0x7, 0x80, 0x0, 0xfe, 0x7, 0x80,
    0x0, 0xff, 0x7, 0x80, 0x0, 0xff, 0x87, 0x82,
    0x0, 0xef, 0xc7, 0x82, 0x1, 0xe7, 0xc7, 0xc2,
    0x1, 0xe3, 0xc3, 0xc2, 0x1, 0xc3, 0xc3, 0xc6,
    0x1, 0xc1, 0xc3, 0xc6, 0x3, 0x80, 0xc3, 0xe6,
    0x3, 0x0, 0x41, 0xe6, 0x7, 0x0, 0x1, 0xf6,
    0x6, 0x0, 0x0, 0xfe, 0xe, 0x0, 0x0, 0xff,
    0xc, 0x0, 0x0, 0x7f, 0x18, 0x0, 0x0, 0x7f,
    0x30, 0x0, 0x0, 0x3f, 0x20, 0x0, 0x0, 0x1f,
    0x40, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x1,

    /* U+4E39 "丹" */
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xff, 0xff, 0xc0, 0x3, 0xff, 0xff, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc4, 0x3, 0xc0,
    0x3, 0xc2, 0x3, 0xc0, 0x3, 0xc3, 0x3, 0xc0,
    0x3, 0xc3, 0x3, 0xc0, 0x3, 0xc3, 0x83, 0xc0,
    0x3, 0xc3, 0xc3, 0xc0, 0x3, 0xc1, 0xe3, 0xc0,
    0x3, 0xc1, 0xe3, 0xc0, 0x3, 0xc1, 0xc3, 0xc0,
    0x3, 0xc0, 0xc3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0x80, 0x3, 0xc0,
    0x7, 0x80, 0x3, 0xc0, 0x7, 0x80, 0x3, 0xc0,
    0x7, 0x0, 0x3, 0xc0, 0x6, 0x0, 0x3, 0xc0,
    0xe, 0x0, 0x3, 0xc0, 0xc, 0x0, 0x3, 0xc0,
    0x18, 0x0, 0x3, 0xc0, 0x18, 0x0, 0x7, 0xc0,
    0x30, 0x0, 0xf, 0x80, 0x20, 0x0, 0x1f, 0x0,
    0x40, 0x0, 0x7c, 0x0, 0x80, 0x1, 0x90, 0x0,

    /* U+4E3A "为" */
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x20, 0x78, 0x0, 0x0, 0x60, 0xf0, 0x0, 0x0,
    0xe1, 0xe0, 0x0, 0x0, 0xe3, 0xc0, 0x0, 0x1,
    0xc7, 0x80, 0x0, 0x3, 0xcf, 0x0, 0x0, 0x3,
    0x1e, 0x0, 0x3c, 0x6, 0x3c, 0x0, 0x78, 0x8,
    0x78, 0x0, 0xf3, 0xff, 0xff, 0xff, 0xe7, 0xff,
    0xff, 0xff, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7,
    0x80, 0xf, 0x0, 0xf, 0x0, 0x1e, 0x0, 0x1e,
    0x0, 0x3c, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x78,
    0x0, 0xf0, 0x0, 0xf0, 0x1, 0xe0, 0x1, 0xe2,
    0x3, 0xc0, 0x3, 0xc6, 0x7, 0x80, 0x7, 0x86,
    0xf, 0x0, 0xf, 0xe, 0x1e, 0x0, 0x1e, 0x1f,
    0x3c, 0x0, 0x3c, 0x1e, 0x78, 0x0, 0x78, 0x38,
    0xf0, 0x0, 0xf0, 0x31, 0xe0, 0x1, 0xe0, 0x43,
    0xc0, 0x3, 0xc0, 0x87, 0x80, 0x7, 0x0, 0xf,
    0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x3c,
    0x0, 0x70, 0x0, 0x78, 0x0, 0xe0, 0x0, 0xf0,
    0x3, 0x80, 0x1, 0xe0, 0x7, 0x0, 0x3, 0xc0,
    0x1c, 0x0, 0x7, 0x80, 0x70, 0x0, 0xf, 0x0,
    0xc0, 0x0, 0x1e, 0x3, 0x0, 0x0, 0x3c, 0xc,
    0x0, 0x0, 0x78, 0x30, 0x0, 0x1, 0xe0, 0xc0,
    0x0, 0xf, 0x83, 0x0, 0x0, 0x7e, 0x18, 0x0,
    0x1, 0x30, 0x0,

    /* U+4E3B "主" */
    0x0, 0x8, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0x80, 0x0, 0x0, 0x1, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x3f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf8,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+4E3D "丽" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x7f, 0xfc, 0xff, 0xf8,
    0x7f, 0xfc, 0xff, 0xf8, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf8, 0x78, 0x7c, 0x3c, 0xf8, 0x78,
    0x7e, 0x3c, 0xfc, 0x78, 0x7b, 0x3c, 0xf6, 0x78,
    0x7b, 0x3c, 0xf6, 0x78, 0x7b, 0xbc, 0xf7, 0x78,
    0x7b, 0xbc, 0xf7, 0x78, 0x7b, 0xfc, 0xf7, 0xf8,
    0x79, 0xfc, 0xf3, 0xf8, 0x79, 0xfc, 0xf3, 0xf8,
    0x79, 0xbc, 0xf3, 0xf8, 0x79, 0xbc, 0xf3, 0x78,
    0x78, 0x3c, 0xf1, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x3c, 0xf0, 0x78,
    0x78, 0x3c, 0xf0, 0x78, 0x78, 0x38, 0xf0, 0xf0,
    0x78, 0xf8, 0xf1, 0xe0, 0x7b, 0xe0, 0xf6, 0x0,

    /* U+4E3E "举" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x18,
    0x0, 0x80, 0xc0, 0x18, 0x0, 0x60, 0x60, 0xc,
    0x0, 0x38, 0x18, 0xe, 0x0, 0xe, 0xe, 0x6,
    0x0, 0x7, 0x7, 0x83, 0x0, 0x3, 0xc3, 0xc3,
    0x0, 0x0, 0xf1, 0xc1, 0x80, 0x0, 0x70, 0x41,
    0xc0, 0x0, 0x18, 0x20, 0xc0, 0x0, 0xc, 0x0,
    0x60, 0x7, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff,
    0xff, 0xf8, 0x1, 0xf0, 0x8, 0x0, 0x0, 0xf0,
    0x4, 0x0, 0x0, 0xf8, 0x3, 0x0, 0x0, 0x78,
    0x0, 0x80, 0x0, 0x3c, 0x78, 0x60, 0x0, 0x3c,
    0x3c, 0x38, 0x0, 0x1c, 0x1e, 0xe, 0x0, 0x1e,
    0xf, 0x7, 0x80, 0xe, 0x7, 0x81, 0xe0, 0xe,
    0x3, 0xc0, 0xfc, 0xe, 0x1, 0xe0, 0x3f, 0x87,
    0xff, 0xff, 0xff, 0x86, 0xff, 0xff, 0xff, 0xc6,
    0x0, 0x3c, 0x1, 0xe6, 0x0, 0x1e, 0x0, 0x30,
    0x0, 0xf, 0x0, 0x8, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0xf, 0xff, 0xff, 0xfe, 0x7, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x0,

    /* U+4E3F "丿" */
    0x1, 0xe0, 0x3c, 0x7, 0x80, 0xf0, 0x1e, 0x3,
    0xc0, 0x78, 0xf, 0x1, 0xe0, 0x3c, 0x7, 0x80,
    0xf0, 0x1e, 0x3, 0xc0, 0x78, 0xf, 0x1, 0xe0,
    0x3c, 0x7, 0x80, 0xf0, 0x1e, 0x3, 0xc0, 0x78,
    0xf, 0x1, 0xe0, 0x3c, 0x7, 0x80, 0xf0, 0x1e,
    0x3, 0xc0, 0xf0, 0x1e, 0x3, 0xc0, 0x78, 0xe,
    0x3, 0xc0, 0x78, 0xe, 0x3, 0xc0, 0x70, 0x1c,
    0x3, 0x80, 0xe0, 0x18, 0x6, 0x1, 0x80, 0x0,

    /* U+4E42 "乂" */
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0,
    0x2, 0x0, 0x3, 0xc0, 0x2, 0x0, 0x3, 0xc0,
    0x2, 0x0, 0x3, 0xc0, 0x2, 0x0, 0x3, 0xc0,
    0x1, 0x0, 0x3, 0xc0, 0x1, 0x0, 0x3, 0xc0,
    0x1, 0x0, 0x3, 0xc0, 0x1, 0x0, 0x3, 0xc0,
    0x1, 0x0, 0x3, 0xc0, 0x1, 0x0, 0x3, 0xc0,
    0x1, 0x80, 0x3, 0xc0, 0x1, 0x80, 0x3, 0xc0,
    0x1, 0x80, 0x3, 0x80, 0x1, 0x80, 0x7, 0x80,
    0x0, 0x80, 0x7, 0x80, 0x0, 0xc0, 0x7, 0x80,
    0x0, 0xc0, 0x7, 0x80, 0x0, 0xc0, 0x7, 0x80,
    0x0, 0x60, 0xf, 0x0, 0x0, 0x60, 0xf, 0x0,
    0x0, 0x70, 0xf, 0x0, 0x0, 0x30, 0x1e, 0x0,
    0x0, 0x38, 0x1e, 0x0, 0x0, 0x38, 0x1c, 0x0,
    0x0, 0x1c, 0x3c, 0x0, 0x0, 0x1e, 0x38, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0xe, 0xfc, 0x0, 0x0, 0x18, 0x7f, 0x0,
    0x0, 0x30, 0x3f, 0xc0, 0x0, 0x60, 0x1f, 0xf8,
    0x1, 0xc0, 0x7, 0xff, 0x3, 0x0, 0x3, 0xfe,
    0x6, 0x0, 0x1, 0xfe, 0x8, 0x0, 0x0, 0x7e,
    0x30, 0x0, 0x0, 0x1e, 0x60, 0x0, 0x0, 0x2,

    /* U+4E43 "乃" */
    0x0, 0x0, 0x3, 0xe3, 0xff, 0xff, 0xff, 0x1f,
    0xff, 0xff, 0xf8, 0x3, 0xc0, 0x7, 0xc0, 0x1e,
    0x0, 0x3e, 0x0, 0xf0, 0x1, 0xf0, 0x7, 0x80,
    0xf, 0x80, 0x3c, 0x0, 0x78, 0x1, 0xe0, 0x3,
    0xc0, 0xf, 0x0, 0x1c, 0x0, 0x78, 0x1, 0xe0,
    0x3, 0xc0, 0xe, 0x0, 0x1e, 0x0, 0xe0, 0x0,
    0xf0, 0x6, 0x0, 0x7, 0x80, 0x61, 0xe0, 0x3c,
    0xe, 0xf, 0x1, 0xe0, 0x7f, 0xf8, 0xf, 0x3,
    0xff, 0xc0, 0x78, 0x10, 0x1e, 0x3, 0xc0, 0x0,
    0xf0, 0x1e, 0x0, 0x7, 0x80, 0xf0, 0x0, 0x3c,
    0x7, 0x80, 0x1, 0xe0, 0x3c, 0x0, 0xf, 0x1,
    0xe0, 0x0, 0x78, 0xf, 0x0, 0x3, 0xc0, 0x78,
    0x0, 0x1e, 0x3, 0xc0, 0x0, 0xf0, 0x1e, 0x0,
    0x7, 0x80, 0xf0, 0x0, 0x3c, 0x7, 0x0, 0x1,
    0xe0, 0x38, 0x0, 0xf, 0x3, 0xc0, 0x0, 0x78,
    0x1e, 0x0, 0x3, 0xc0, 0xe0, 0x0, 0x1e, 0x7,
    0x0, 0x0, 0xf0, 0x78, 0x0, 0x7, 0x83, 0x80,
    0x0, 0x3c, 0x18, 0x0, 0x1, 0xe1, 0xc0, 0x0,
    0xf, 0xc, 0x0, 0x0, 0x78, 0xc0, 0x0, 0x7,
    0xcc, 0x0, 0x0, 0x7c, 0x60, 0x0, 0xf, 0xc6,
    0x0, 0x3, 0xfc, 0x60, 0x0, 0x33, 0x0,

    /* U+4E45 "久" */
    0x0, 0x7c, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x7c,
    0x0, 0x1, 0xe0, 0x3e, 0x0, 0x0, 0xf0, 0x1f,
    0x0, 0x0, 0xff, 0xff, 0x80, 0x0, 0x7f, 0xff,
    0xc0, 0x0, 0x3c, 0x7, 0xc0, 0x0, 0x3c, 0x3,
    0xe0, 0x0, 0x1c, 0x1, 0xf0, 0x0, 0xe, 0x0,
    0xf8, 0x0, 0xe, 0x0, 0x7c, 0x0, 0x6, 0x0,
    0x3c, 0x0, 0x7, 0x0, 0x1e, 0x0, 0x3, 0x0,
    0x1f, 0x0, 0x3, 0x0, 0xf, 0x0, 0x1, 0x0,
    0x7, 0x80, 0x1, 0x80, 0x7, 0xc0, 0x0, 0x80,
    0x3, 0xc0, 0x0, 0x80, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0xf4, 0x0, 0x0, 0x0, 0x7a, 0x0, 0x0,
    0x0, 0x79, 0x80, 0x0, 0x0, 0x38, 0xc0, 0x0,
    0x0, 0x3c, 0x30, 0x0, 0x0, 0x1c, 0x18, 0x0,
    0x0, 0x1c, 0xe, 0x0, 0x0, 0x1e, 0x3, 0x80,
    0x0, 0xe, 0x1, 0xe0, 0x0, 0xe, 0x0, 0xf0,
    0x0, 0xe, 0x0, 0x3c, 0x0, 0xe, 0x0, 0x1f,
    0x80, 0x6, 0x0, 0x7, 0xe0, 0x6, 0x0, 0x1,
    0xf8, 0x7, 0x0, 0x0, 0xff, 0x7, 0x0, 0x0,
    0x3f, 0x87, 0x0, 0x0, 0xf, 0x83, 0x0, 0x0,
    0x3, 0xc3, 0x0, 0x0, 0x0, 0xe3, 0x0, 0x0,
    0x0, 0x13, 0x0, 0x0, 0x0, 0x0,

    /* U+4E47 "乇" */
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0x1f, 0xfc, 0x0, 0x7, 0xff, 0xe0, 0x1,
    0xff, 0xf8, 0x0, 0x7f, 0xfc, 0x0, 0x2, 0x0,
    0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x3, 0xc3, 0xff, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xff, 0xe0, 0xf, 0xf0, 0xf0, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0xf, 0x0, 0x8, 0x0, 0x3c, 0x0, 0x20,
    0x0, 0xf0, 0x1, 0x80, 0x3, 0xc0, 0x6, 0x0,
    0xf, 0x0, 0x18, 0x0, 0x3c, 0x0, 0x60, 0x0,
    0xf0, 0x1, 0x80, 0x3, 0xc0, 0xf, 0x0, 0xf,
    0x0, 0x3c, 0x0, 0x3e, 0x0, 0xf0, 0x0, 0xff,
    0xff, 0x80, 0x3, 0xff, 0xfe, 0x0, 0x7, 0xff,
    0xf8, 0x0, 0x7, 0xff, 0xc0,

    /* U+4E48 "么" */
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x71, 0xf0, 0x0,
    0x0, 0xf1, 0xe0, 0x0, 0x0, 0xe1, 0xe0, 0x0,
    0x1, 0xc1, 0xe0, 0x0, 0x1, 0x81, 0xe0, 0x0,
    0x3, 0x81, 0xe0, 0x0, 0x7, 0x3, 0xe4, 0x0,
    0x6, 0x3, 0xc2, 0x0, 0xc, 0x3, 0xc2, 0x0,
    0x18, 0x3, 0xc2, 0x0, 0x30, 0x3, 0x82, 0x0,
    0x20, 0x3, 0x83, 0x0, 0x40, 0x3, 0x83, 0x0,
    0x0, 0x7, 0x3, 0x0, 0x0, 0x7, 0x3, 0x80,
    0x0, 0x7, 0x3, 0x80, 0x0, 0x6, 0x3, 0x80,
    0x0, 0xe, 0x1, 0xc0, 0x0, 0xc, 0x1, 0xc0,
    0x0, 0xc, 0x1, 0xc0, 0x0, 0x18, 0x1, 0xe0,
    0x0, 0x18, 0x1, 0xe0, 0x0, 0x30, 0x0, 0xf0,
    0x0, 0x30, 0x1, 0xf8, 0x0, 0x60, 0x3, 0xf8,
    0x0, 0x40, 0x1e, 0x7c, 0x0, 0xc0, 0xf8, 0x7e,
    0x40, 0x8f, 0xe0, 0x7f, 0x3f, 0xff, 0x80, 0x3e,
    0x3f, 0xfc, 0x0, 0x1e, 0x3f, 0xe0, 0x0, 0x1c,
    0x3f, 0x0, 0x0, 0xc, 0x30, 0x0, 0x0, 0x4,

    /* U+4E49 "义" */
    0x0, 0x8, 0x0, 0x0, 0x0, 0x8, 0x0, 0x0,
    0x0, 0xc, 0x3, 0xc0, 0x0, 0xe, 0x3, 0xc0,
    0x2, 0x6, 0x3, 0xc0, 0x2, 0x7, 0x3, 0xc0,
    0x2, 0x7, 0x83, 0xc0, 0x2, 0x7, 0x83, 0xc0,
    0x1, 0x3, 0xc3, 0xc0, 0x1, 0x3, 0xc3, 0xc0,
    0x1, 0x3, 0x83, 0xc0, 0x1, 0x1, 0x83, 0xc0,
    0x1, 0x1, 0x3, 0xc0, 0x1, 0x0, 0x3, 0xc0,
    0x1, 0x80, 0x3, 0xc0, 0x1, 0x80, 0x3, 0xc0,
    0x1, 0x80, 0x3, 0x80, 0x0, 0x80, 0x7, 0x80,
    0x0, 0x80, 0x7, 0x80, 0x0, 0xc0, 0x7, 0x80,
    0x0, 0xc0, 0x7, 0x80, 0x0, 0xc0, 0x7, 0x80,
    0x0, 0x60, 0xf, 0x0, 0x0, 0x60, 0xf, 0x0,
    0x0, 0x70, 0xf, 0x0, 0x0, 0x30, 0x1e, 0x0,
    0x0, 0x38, 0x1e, 0x0, 0x0, 0x38, 0x1c, 0x0,
    0x0, 0x1c, 0x3c, 0x0, 0x0, 0x1e, 0x38, 0x0,
    0x0, 0xf, 0x70, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0xe, 0xfc, 0x0, 0x0, 0x18, 0x7f, 0x0,
    0x0, 0x30, 0x3f, 0xc0, 0x0, 0x60, 0xf, 0xf8,
    0x1, 0xc0, 0x7, 0xff, 0x3, 0x0, 0x3, 0xfe,
    0x6, 0x0, 0x1, 0xfe, 0x8, 0x0, 0x0, 0x7e,
    0x30, 0x0, 0x0, 0x1e, 0x60, 0x0, 0x0, 0x2,

    /* U+4E4B "之" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0,
    0x0, 0xe, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x1, 0x80, 0xf8, 0x0, 0x0, 0x80, 0xf8,
    0x3f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x4, 0x18, 0x0, 0x0, 0x4, 0x70, 0x0, 0x0,
    0xc, 0xc0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x7a, 0x0, 0x0, 0x0,
    0xfb, 0x80, 0x0, 0x0, 0x73, 0xff, 0xff, 0xfe,
    0x71, 0xff, 0xff, 0xfe, 0x61, 0xff, 0xff, 0xfe,
    0x60, 0xff, 0xff, 0xfe, 0x40, 0x3f, 0xff, 0xfe,

    /* U+4E4C "乌" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x1, 0xc0, 0x0, 0xf,
    0x6, 0x3, 0xc0, 0x3c, 0x10, 0xf, 0x0, 0xff,
    0xff, 0xfc, 0x3, 0xff, 0xff, 0xf0, 0xf, 0x0,
    0x3, 0xc0, 0x3c, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0x3c, 0x3, 0xc0, 0x0, 0xf0, 0xf, 0x0, 0x3,
    0xc0, 0x3c, 0x0, 0xf, 0x0, 0xf0, 0x0, 0x3c,
    0x3, 0xc0, 0x0, 0xf0, 0xf, 0x0, 0x3, 0xc0,
    0x3c, 0x0, 0xf, 0x0, 0xf0, 0x0, 0xf8, 0x3,
    0xc0, 0xf, 0xc0, 0xf, 0x0, 0xc8, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x1f, 0xf, 0x0, 0x0, 0x7c, 0x3f, 0xff,
    0xff, 0xf0, 0xff, 0xff, 0xff, 0xc3, 0xc0, 0x0,
    0x1f, 0xf, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0x9f, 0x0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0xfe, 0x0,

    /* U+4E4D "乍" */
    0x1, 0xf0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff,
    0x3, 0xff, 0xff, 0xff, 0x3, 0xc3, 0xc0, 0x0,
    0x3, 0x83, 0xc0, 0x0, 0x7, 0x3, 0xc0, 0x0,
    0x6, 0x3, 0xc0, 0x0, 0xe, 0x3, 0xc0, 0x0,
    0xc, 0x3, 0xc0, 0x0, 0x18, 0x3, 0xc0, 0x0,
    0x10, 0x3, 0xc0, 0x0, 0x30, 0x3, 0xc0, 0x0,
    0x60, 0x3, 0xff, 0xfe, 0x40, 0x3, 0xff, 0xfe,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xff, 0xfe,
    0x0, 0x3, 0xff, 0xfe, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+4E4E "乎" */
    0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0x3f, 0xfc, 0x0, 0x1, 0xff, 0xff,
    0x0, 0x1f, 0xff, 0xf0, 0x3, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0,
    0x8, 0x2, 0x0, 0x78, 0x6, 0x1, 0x80, 0x3c,
    0x6, 0x0, 0x60, 0x1e, 0x3, 0x0, 0x38, 0xf,
    0x3, 0x0, 0xf, 0x7, 0x81, 0x80, 0x7, 0xc3,
    0xc1, 0x80, 0x1, 0xe1, 0xe0, 0xc0, 0x0, 0x70,
    0xf0, 0xc0, 0x0, 0x30, 0x78, 0x60, 0x0, 0x8,
    0x3c, 0x60, 0x0, 0x4, 0x1e, 0x30, 0x0, 0x0,
    0xf, 0x30, 0x0, 0x0, 0x7, 0x98, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x2, 0x60,
    0x0, 0x0,

    /* U+4E4F "乏" */
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x7, 0xfc,
    0x0, 0x0, 0xff, 0xff, 0x0, 0x3f, 0xff, 0xff,
    0xc7, 0xff, 0xff, 0xe0, 0x0, 0x0, 0x18, 0x0,
    0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0x3, 0x80,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xe, 0x7, 0xc0, 0x0, 0x6,
    0x3, 0xe0, 0x0, 0x1, 0x1, 0xf0, 0x3f, 0xff,
    0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x42, 0x0, 0x0, 0x0, 0x36, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0xfb, 0x0, 0x0, 0x0, 0x7c, 0xc0, 0x0,
    0x0, 0x3c, 0x70, 0x0, 0x0, 0x1c, 0x1f, 0xff,
    0xff, 0xcc, 0xf, 0xff, 0xff, 0xc4, 0x3, 0xff,
    0xff, 0xe0, 0x0, 0x7f, 0xff, 0xf0,

    /* U+4E50 "乐" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1f, 0x80,
    0x3c, 0x1, 0xff, 0xc0, 0x78, 0x1f, 0xfe, 0x0,
    0xf3, 0xff, 0x80, 0x1, 0xf8, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0xf,
    0x1, 0xe0, 0x0, 0x1e, 0x3, 0xc0, 0x0, 0x3c,
    0x7, 0x80, 0x0, 0x78, 0xf, 0x0, 0x0, 0xf0,
    0x1e, 0x0, 0x1, 0xe0, 0x3c, 0x0, 0x3, 0x80,
    0x78, 0x0, 0x7, 0x0, 0xf0, 0x0, 0xc, 0x1,
    0xe0, 0x0, 0x18, 0x3, 0xc0, 0x0, 0x60, 0x7,
    0x80, 0x0, 0x80, 0xf, 0x0, 0x7, 0xff, 0xff,
    0xff, 0xef, 0xff, 0xff, 0xff, 0xd0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1, 0xe2,
    0x0, 0x7, 0xc3, 0xc4, 0x0, 0xf, 0x87, 0x8c,
    0x0, 0x1f, 0xf, 0x18, 0x0, 0x3e, 0x1e, 0x10,
    0x0, 0x7c, 0x3c, 0x30, 0x0, 0xf0, 0x78, 0x60,
    0x1, 0xe0, 0xf0, 0xe0, 0x3, 0xc1, 0xe1, 0xc0,
    0xf, 0x3, 0xc3, 0xc0, 0x1e, 0x7, 0x83, 0xc0,
    0x3c, 0xf, 0x7, 0x80, 0x70, 0x1e, 0xf, 0xc1,
    0xe0, 0x3c, 0xf, 0xc3, 0x80, 0x78, 0x1f, 0x8e,
    0x0, 0xf0, 0x1f, 0x18, 0x1, 0xe0, 0x3e, 0x70,
    0x3, 0xc0, 0x38, 0xc0, 0x7, 0x80, 0x33, 0x0,
    0x1f, 0x0, 0x2c, 0x0, 0x7c, 0x0, 0x0, 0x7,
    0xf0, 0x0, 0x0, 0x19, 0x0, 0x0, 0x0,

    /* U+4E52 "乒" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0xf8,
    0x0, 0xf8, 0x7, 0xfe, 0x0, 0x7c, 0x3f, 0xff,
    0xc0, 0x3f, 0xff, 0xfe, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xe0, 0x1f, 0xff,
    0xff, 0xf0, 0xf, 0x80, 0x3e, 0x0, 0x7, 0xc0,
    0x1f, 0x0, 0x3, 0xe0, 0xf, 0x80, 0x1, 0xf0,
    0x7, 0xc0, 0x0, 0xf8, 0x3, 0xe0, 0x0, 0x7c,
    0x1, 0xf0, 0x0, 0x3e, 0x0, 0xf8, 0x0, 0x1f,
    0x0, 0x7c, 0x0, 0xf, 0x80, 0x3e, 0x0, 0x7,
    0xc0, 0x1f, 0x0, 0x3, 0xe0, 0xf, 0x80, 0x1,
    0xf0, 0x7, 0xc0, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x1, 0x80, 0x0, 0x0, 0x1, 0x80, 0x0,
    0x0, 0x1, 0x80, 0x0, 0x0, 0x0, 0x80, 0x0,
    0x0, 0x0,

    /* U+4E53 "乓" */
    0x0, 0x0, 0x0, 0x80, 0x0, 0xf0, 0x3, 0xf0,
    0x0, 0x78, 0xf, 0xfc, 0x0, 0x3c, 0x3f, 0xff,
    0x80, 0x1f, 0xff, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xe0, 0xf, 0xff,
    0xff, 0xf0, 0x7, 0x80, 0x3c, 0x0, 0x3, 0xc0,
    0x1e, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x0, 0xf0,
    0x7, 0x80, 0x0, 0x78, 0x3, 0xc0, 0x0, 0x3c,
    0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x78, 0x0, 0x7, 0x80, 0x3c, 0x0, 0x3,
    0xc0, 0x1e, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x0,
    0xf0, 0x7, 0x80, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x6, 0x0,
    0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0, 0xc0,
    0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x38,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x0, 0x60, 0x0, 0x0,
    0x0, 0x0,

    /* U+4E54 "乔" */
    0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x1f, 0xf0, 0x0, 0x0, 0xff, 0xfe,
    0x0, 0xf, 0xff, 0xfc, 0x1, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0xf0, 0x40, 0x0, 0x0, 0x78,
    0x30, 0x0, 0x0, 0x78, 0xc, 0x0, 0x0, 0x38,
    0x6, 0x0, 0x0, 0x3c, 0x3, 0x80, 0x0, 0x3c,
    0x0, 0xe0, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x1c,
    0x0, 0x1f, 0x0, 0x1f, 0xc0, 0x3f, 0xe0, 0x1d,
    0xe0, 0x1f, 0xfc, 0x1c, 0xf0, 0xf, 0x7f, 0x1c,
    0x78, 0x7, 0x9f, 0x9c, 0x3c, 0x3, 0xc7, 0x98,
    0x1e, 0x1, 0xe0, 0xc0, 0xf, 0x0, 0xf0, 0x10,
    0x7, 0x80, 0x78, 0x0, 0x3, 0xc0, 0x3c, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x3c, 0x3, 0xc0,
    0x0, 0x1e, 0x1, 0xe0, 0x0, 0xf, 0x0, 0xf0,
    0x0, 0x7, 0x80, 0x78, 0x0, 0x3, 0xc0, 0x3c,
    0x0, 0x1, 0xc0, 0x1e, 0x0, 0x0, 0xe0, 0xf,
    0x0, 0x0, 0xe0, 0x7, 0x80, 0x0, 0x70, 0x3,
    0xc0, 0x0, 0x70, 0x1, 0xe0, 0x0, 0x70, 0x0,
    0xf0, 0x0, 0x70, 0x0, 0x78, 0x0, 0x70, 0x0,
    0x0, 0x0,

    /* U+4E56 "乖" */
    0x0, 0x0, 0x0, 0x80, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0xf, 0xfe, 0x0, 0x0, 0x7f, 0xff,
    0x80, 0xf, 0xff, 0xfc, 0x1, 0xff, 0xef, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x1, 0xe3,
    0xcf, 0x0, 0x0, 0xf1, 0xe7, 0x80, 0x0, 0x78,
    0xf3, 0xc0, 0x0, 0x3c, 0x79, 0xe0, 0xc0, 0x1e,
    0x3c, 0xf0, 0xc0, 0xf, 0x1e, 0x78, 0xc3, 0xff,
    0x8f, 0x3c, 0xc1, 0xff, 0xc7, 0x9e, 0xc0, 0x1,
    0xe3, 0xcf, 0xc0, 0x0, 0xf1, 0xe7, 0xc0, 0x0,
    0x78, 0xf3, 0xe0, 0x80, 0x3c, 0x79, 0xe0, 0x40,
    0x1e, 0x3c, 0xf0, 0x20, 0xf, 0x1e, 0x78, 0x10,
    0x7, 0x8f, 0x3c, 0x8, 0xf, 0xc7, 0x9e, 0xf,
    0xfd, 0xe3, 0xcf, 0x7, 0x7c, 0xf1, 0xe7, 0x83,
    0xbc, 0x78, 0xf3, 0xff, 0xd0, 0x3c, 0x79, 0xff,
    0xe0, 0x1e, 0x3c, 0x7f, 0xe0, 0xf, 0x1e, 0x8,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x0,

    /* U+4E58 "乘" */
    0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0xf, 0xe0,
    0x0, 0x1, 0xff, 0xf0, 0x0, 0xff, 0xff, 0xf8,
    0x3f, 0xff, 0xff, 0xf8, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x1, 0xe3, 0xcf, 0x0,
    0x1, 0xe3, 0xcf, 0xc, 0x1, 0xe3, 0xcf, 0x18,
    0x7f, 0xe3, 0xcf, 0x30, 0x7f, 0xe3, 0xcf, 0x64,
    0x1, 0xe3, 0xcf, 0xc4, 0x1, 0xe3, 0xcf, 0x84,
    0x1, 0xe3, 0xcf, 0x84, 0x1, 0xe3, 0xcf, 0x4,
    0x3, 0xe3, 0xcf, 0x6, 0xf, 0xe3, 0xcf, 0x6,
    0xfd, 0xe3, 0xcf, 0xe, 0xf9, 0xe3, 0xcf, 0xfe,
    0xe1, 0xff, 0xcf, 0xfc, 0x81, 0xff, 0xc7, 0xfc,
    0x0, 0x7b, 0xe0, 0x0, 0x0, 0x7b, 0xf0, 0x0,
    0x0, 0x73, 0xd8, 0x0, 0x0, 0xf3, 0xdc, 0x0,
    0x0, 0xe3, 0xde, 0x0, 0x1, 0xc3, 0xcf, 0x0,
    0x1, 0x83, 0xc7, 0x80, 0x3, 0x83, 0xc7, 0xe0,
    0x3, 0x3, 0xc3, 0xf0, 0x6, 0x3, 0xc1, 0xfe,
    0xc, 0x3, 0xc0, 0xff, 0x8, 0x3, 0xc0, 0x7e,
    0x10, 0x3, 0xc0, 0x3c, 0x20, 0x3, 0xc0, 0x1c,
    0x40, 0x3, 0xc0, 0x4, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+4E59 "乙" */
    0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0x80,
    0xff, 0xff, 0xff, 0x1, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x1f, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x38,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x41, 0xe0, 0x0, 0x0, 0x87, 0xc0, 0x0, 0x1,
    0xf, 0x0, 0x0, 0x2, 0x3c, 0x0, 0x0, 0x4,
    0xf8, 0x0, 0x0, 0x19, 0xe0, 0x0, 0x0, 0x23,
    0xc0, 0x0, 0x0, 0x67, 0x0, 0x0, 0x1, 0xde,
    0x0, 0x0, 0x3, 0x9c, 0x0, 0x0, 0xf, 0x3e,
    0x0, 0x0, 0x7e, 0x3f, 0xff, 0xff, 0xf8, 0x1f,
    0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0x0,

    /* U+4E5C "乜" */
    0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x0, 0xf0, 0x0, 0xf0, 0x1,
    0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x7,
    0x80, 0x7, 0x80, 0xf, 0x0, 0x1f, 0x0, 0x1e,
    0x3, 0xfe, 0x0, 0x3c, 0x7f, 0xbc, 0x0, 0x7f,
    0xf0, 0x78, 0x1, 0xfe, 0x0, 0xf0, 0x3f, 0xe0,
    0x1, 0xe1, 0xfb, 0xc0, 0x3, 0xc0, 0x7, 0x80,
    0x7, 0x80, 0xf, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x78, 0x0,
    0x78, 0x0, 0xf0, 0x0, 0xf0, 0x1, 0xe0, 0x1,
    0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7,
    0x80, 0xf, 0x0, 0xf, 0x0, 0x1e, 0x0, 0x1e,
    0x0, 0x3c, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x78,
    0x0, 0xf0, 0x0, 0xf0, 0x1, 0xe0, 0x3, 0xe2,
    0x3, 0xc0, 0xf, 0x84, 0x7, 0x80, 0x7e, 0x8,
    0xf, 0x1, 0x90, 0x10, 0x1e, 0x0, 0x0, 0x20,
    0x3c, 0x0, 0x0, 0xc0, 0x78, 0x0, 0x1, 0x80,
    0xf0, 0x0, 0x3, 0x1, 0xe0, 0x0, 0x6, 0x3,
    0xc0, 0x0, 0x1c, 0x7, 0xff, 0xff, 0xf8, 0xf,
    0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xc0,

    /* U+4E5D "九" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0xf, 0x0, 0x0,
    0x78, 0x1e, 0x0, 0x0, 0xff, 0xfc, 0x3, 0xff,
    0xff, 0xf8, 0x7, 0xff, 0xe0, 0xf0, 0x0, 0x7,
    0xc1, 0xe0, 0x0, 0xf, 0x83, 0xc0, 0x0, 0x1f,
    0x7, 0x80, 0x0, 0x3e, 0xf, 0x0, 0x0, 0x7c,
    0x1e, 0x0, 0x0, 0xf8, 0x3c, 0x0, 0x1, 0xf0,
    0x78, 0x0, 0x3, 0xe0, 0xf0, 0x0, 0x7, 0xc1,
    0xe0, 0x0, 0xf, 0x3, 0xc0, 0x0, 0x1e, 0x7,
    0x80, 0x0, 0x3c, 0xf, 0x0, 0x0, 0x78, 0x1e,
    0x0, 0x0, 0xf0, 0x3c, 0x0, 0x1, 0xe0, 0x78,
    0x0, 0x3, 0xc0, 0xf0, 0x0, 0x7, 0x81, 0xe0,
    0x0, 0x1e, 0x3, 0xc0, 0x80, 0x3c, 0x7, 0x81,
    0x0, 0x78, 0xf, 0x2, 0x0, 0xe0, 0x1e, 0x4,
    0x1, 0xc0, 0x3c, 0x8, 0x7, 0x80, 0x78, 0x10,
    0xe, 0x0, 0xf0, 0x60, 0x1c, 0x1, 0xe0, 0xc0,
    0x70, 0x3, 0xc1, 0x80, 0xe0, 0x7, 0x83, 0x83,
    0x80, 0xf, 0x7, 0x6, 0x0, 0x1e, 0xe, 0x18,
    0x0, 0x3c, 0x38, 0x30, 0x0, 0x7f, 0xf0, 0xc0,
    0x0, 0xff, 0xe3, 0x0, 0x0, 0xff, 0xcc, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4E5E "乞" */
    0x1, 0xf0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0x3, 0x80,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x70, 0x0,
    0x0, 0x1, 0x80, 0x0, 0x0, 0xc, 0x0, 0x0,
    0x0, 0x30, 0x0, 0x2, 0x1, 0x80, 0x0, 0x18,
    0x4, 0xff, 0xff, 0xe0, 0x33, 0xff, 0xff, 0x81,
    0x80, 0x0, 0xfc, 0x4, 0x0, 0x3, 0xe0, 0x20,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x1,
    0x0, 0xf8, 0x0, 0x4, 0x3, 0xc0, 0x0, 0x20,
    0x1e, 0x0, 0x0, 0x80, 0x78, 0x0, 0x2, 0x3,
    0xc0, 0x0, 0x8, 0xf, 0x0, 0x0, 0x20, 0x78,
    0x0, 0x1, 0xc1, 0xe0, 0x0, 0x7, 0x7, 0x80,
    0x0, 0x1c, 0x1f, 0x0, 0x0, 0xf0, 0x7f, 0xff,
    0xff, 0xc0, 0xff, 0xff, 0xff, 0x1, 0xff, 0xff,
    0xf8, 0x1, 0xff, 0xff, 0xc0,

    /* U+4E5F "也" */
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x7, 0x81, 0xe0, 0x0,
    0x7, 0x81, 0xe0, 0x0, 0x7, 0x81, 0xe0, 0x0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe1, 0xf0, 0x7, 0x81, 0xff, 0xf0,
    0x7, 0x83, 0xfc, 0xf0, 0x7, 0xff, 0xe0, 0xf0,
    0xf, 0xf9, 0xe0, 0xf0, 0xff, 0x81, 0xe0, 0xf0,
    0xf7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x81, 0xe0, 0xe0,
    0x7, 0x81, 0xe1, 0xe2, 0x7, 0x81, 0xe3, 0xc2,
    0x7, 0x81, 0xef, 0x82, 0x7, 0x81, 0xe0, 0x6,
    0x7, 0x81, 0xe0, 0x6, 0x7, 0x81, 0xe0, 0x6,
    0x7, 0x80, 0x0, 0x6, 0x7, 0x80, 0x0, 0x7,
    0x7, 0x80, 0x0, 0x7, 0x7, 0x80, 0x0, 0xf,
    0x7, 0xff, 0xff, 0xff, 0x7, 0xff, 0xff, 0xff,
    0x3, 0xff, 0xff, 0xfe, 0x1, 0xff, 0xff, 0xfc,

    /* U+4E60 "习" */
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x7f,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x1, 0x0, 0x0, 0xf0,
    0x10, 0x0, 0xf, 0x0, 0x80, 0x0, 0xf0, 0xc,
    0x0, 0xf, 0x0, 0xe0, 0x0, 0xf0, 0x7, 0x0,
    0xf, 0x0, 0x78, 0x0, 0xf0, 0x7, 0xc0, 0xf,
    0x0, 0x3e, 0x0, 0xf0, 0x3, 0xe0, 0xf, 0x0,
    0x1e, 0x0, 0xf0, 0x1, 0xc0, 0xf, 0x0, 0xc,
    0x0, 0xf0, 0x0, 0x80, 0xcf, 0x0, 0x0, 0x8,
    0xf0, 0x0, 0x1, 0xf, 0x0, 0x0, 0x60, 0xf0,
    0x0, 0xe, 0xf, 0x0, 0x3, 0xc0, 0xf0, 0x0,
    0x78, 0xf, 0x0, 0x1f, 0x0, 0xf0, 0xf, 0xc0,
    0xf, 0xf, 0xf8, 0x0, 0xf7, 0xff, 0x0, 0xf,
    0x7f, 0xc0, 0x0, 0xf3, 0xf0, 0x0, 0xf, 0x3c,
    0x0, 0x0, 0xf6, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x18,
    0x80,

    /* U+4E61 "乡" */
    0x0, 0x3e, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x78, 0xf, 0x0, 0x1e, 0x1, 0xe0,
    0x3, 0xc0, 0x7c, 0x0, 0x70, 0xf, 0x80, 0x1e,
    0x1, 0xe0, 0x3, 0x80, 0x3c, 0x0, 0xe0, 0xf,
    0x80, 0x18, 0x3, 0xf0, 0x6, 0x1, 0xbc, 0x1,
    0x80, 0xef, 0x80, 0x61, 0xf9, 0xe0, 0x3f, 0xfc,
    0x78, 0x3, 0xfe, 0x1f, 0x0, 0x7e, 0x3, 0xc7,
    0x8e, 0x0, 0xf0, 0xf0, 0x0, 0x3c, 0x1e, 0x0,
    0xf, 0x3, 0xc0, 0x7, 0xc0, 0xf8, 0x1, 0xe0,
    0x2f, 0x0, 0x78, 0xd, 0xe0, 0x3c, 0x7, 0x3c,
    0xe, 0x3, 0xc7, 0x87, 0x3, 0xe0, 0xe3, 0xff,
    0xf8, 0x3c, 0x3f, 0xfc, 0x7, 0x87, 0xfe, 0x1,
    0xe0, 0xfc, 0x0, 0x3c, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0xf, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x1c, 0x0, 0x0, 0xe, 0x0, 0x0, 0x7, 0x0,
    0x0, 0x1, 0x80, 0x0, 0x0, 0xc0, 0x0, 0x0,
    0xe0, 0x0, 0x0, 0x0,

    /* U+4E66 "书" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x40,
    0x0, 0x7, 0x80, 0x70, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x81, 0xff, 0x0, 0x7, 0x81, 0xfe,
    0x0, 0x7, 0x81, 0xee, 0x3f, 0xff, 0xff, 0xe6,
    0x3f, 0xff, 0xff, 0xe6, 0x0, 0x7, 0x81, 0xe0,
    0x0, 0x7, 0x81, 0xe0, 0x0, 0x7, 0x81, 0xe0,
    0x0, 0x7, 0x81, 0xe0, 0x0, 0x7, 0x81, 0xc0,
    0x0, 0x7, 0x81, 0xc0, 0x0, 0x7, 0x81, 0xc0,
    0x0, 0x7, 0x81, 0xc0, 0x0, 0x7, 0x81, 0x80,
    0x0, 0x7, 0x83, 0x80, 0x0, 0x7, 0x83, 0x3c,
    0x0, 0x7, 0x82, 0x3c, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x7, 0x80, 0x7c, 0x0, 0x7, 0x80, 0xf8,
    0x0, 0x7, 0x8f, 0xe0, 0x0, 0x7, 0x80, 0x80,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,

    /* U+4E69 "乩" */
    0x3, 0x80, 0x38, 0x0, 0x1c, 0x1, 0xc0, 0x0,
    0xe0, 0xe, 0x0, 0x7, 0x0, 0x70, 0x0, 0x38,
    0x3, 0x80, 0x1, 0xc0, 0x1c, 0x0, 0xe, 0x0,
    0xe0, 0x0, 0x70, 0x7, 0x0, 0x3, 0x80, 0x38,
    0x0, 0x1f, 0xfd, 0xc0, 0x0, 0xff, 0xee, 0x0,
    0x7, 0x0, 0x70, 0x0, 0x38, 0x3, 0x80, 0x1,
    0xc0, 0x1c, 0x0, 0xe, 0x0, 0xe0, 0x0, 0x70,
    0x7, 0x0, 0x3, 0x80, 0x38, 0x0, 0x1c, 0x1,
    0xc0, 0x0, 0xe0, 0xe, 0x0, 0x7, 0x0, 0x70,
    0xf, 0x3b, 0xc3, 0x80, 0x79, 0xde, 0x1c, 0x3,
    0xce, 0xf0, 0xe0, 0x1f, 0xff, 0x87, 0x0, 0xff,
    0xfc, 0x38, 0x7, 0x81, 0xe1, 0xc0, 0x3c, 0xf,
    0xe, 0x1, 0xe0, 0x78, 0x70, 0xf, 0x3, 0xc3,
    0x80, 0x78, 0x1e, 0x1c, 0x3, 0xc0, 0xf0, 0xe0,
    0x1e, 0x7, 0x87, 0x1, 0xf0, 0x3c, 0x38, 0xf,
    0x81, 0xe1, 0xc0, 0x7c, 0xf, 0xe, 0x3, 0xe0,
    0x78, 0x70, 0x1f, 0x3, 0xc3, 0x80, 0xf8, 0x1e,
    0x1c, 0x7, 0xc0, 0xf0, 0xe0, 0x7f, 0xff, 0x87,
    0x3, 0xf0, 0x3c, 0x38, 0x1f, 0x81, 0xe1, 0xc0,
    0xfc, 0xf, 0xf, 0xff, 0xe0, 0x78, 0x7f, 0xff,
    0x3, 0xc3, 0xff, 0x0,

    /* U+4E70 "买" */
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e,
    0x1f, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0xf8, 0x1e,
    0x0, 0x0, 0xf8, 0x1e, 0x0, 0x0, 0xf8, 0x1e,
    0x0, 0xc0, 0xf8, 0x10, 0x0, 0xe0, 0xf8, 0x20,
    0x0, 0x78, 0xf8, 0x0, 0x0, 0x7c, 0xf8, 0x0,
    0x0, 0x38, 0xf8, 0x0, 0x0, 0x18, 0xf8, 0x0,
    0x0, 0x10, 0xf8, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x3, 0x0, 0xf8, 0x0, 0x1, 0x80, 0xf8, 0x0,
    0x1, 0xe0, 0xf8, 0x0, 0x0, 0xf0, 0xf8, 0x0,
    0x0, 0xf8, 0xf8, 0x0, 0x0, 0x70, 0xf8, 0x0,
    0x0, 0x70, 0xf8, 0x0, 0x0, 0x20, 0xf8, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x1, 0xe8, 0x0,
    0x0, 0x1, 0xe8, 0x0, 0x0, 0x3, 0xec, 0x0,
    0x0, 0x3, 0xcc, 0x0, 0x0, 0x7, 0xce, 0x0,
    0x0, 0x7, 0x87, 0x0, 0x0, 0xf, 0x7, 0x80,
    0x0, 0x1e, 0x3, 0xc0, 0x0, 0x1c, 0x3, 0xe0,
    0x0, 0x38, 0x1, 0xf0, 0x0, 0x70, 0x1, 0xfe,
    0x0, 0xe0, 0x0, 0xff, 0x1, 0xc0, 0x0, 0x7e,
    0x3, 0x0, 0x0, 0x3e, 0xe, 0x0, 0x0, 0x1e,
    0x1c, 0x0, 0x0, 0xe, 0x30, 0x0, 0x0, 0x2,

    /* U+4E71 "乱" */
    0x0, 0x6, 0xf, 0x0, 0x0, 0x1f, 0xf, 0x0,
    0x0, 0xff, 0x8f, 0x0, 0x7, 0xff, 0xf, 0x0,
    0xfc, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0xff, 0xff, 0xef, 0x0, 0xff, 0xff, 0xef, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0xf, 0x0,
    0x0, 0xe0, 0xf, 0x0, 0x0, 0xc0, 0xf, 0x0,
    0x0, 0xc7, 0xf, 0x0, 0x3c, 0x87, 0xf, 0x0,
    0x3d, 0x7, 0xf, 0x0, 0x3f, 0xff, 0xf, 0x0,
    0x3f, 0xff, 0xf, 0x0, 0x3c, 0x7, 0xf, 0x0,
    0x3c, 0x7, 0xf, 0x0, 0x3c, 0x7, 0xf, 0x0,
    0x3c, 0x7, 0xf, 0x0, 0x3c, 0x7, 0xf, 0x2,
    0x3c, 0x7, 0xf, 0x2, 0x3c, 0x7, 0xf, 0x2,
    0x3c, 0x7, 0xf, 0x2, 0x3c, 0x7, 0xf, 0x2,
    0x3c, 0x7, 0xf, 0x6, 0x3c, 0x7, 0xf, 0x6,
    0x3c, 0x7, 0xf, 0x7, 0x3c, 0x7, 0xf, 0x7,
    0x3f, 0xff, 0xf, 0x7, 0x3f, 0xff, 0xf, 0x7,
    0x3c, 0x7, 0xf, 0xff, 0x3c, 0x7, 0xf, 0xfe,
    0x3c, 0x0, 0x7, 0xfe, 0x3c, 0x0, 0x3, 0xfc,

    /* U+4E73 "乳" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf, 0x0,
    0x0, 0xf, 0x8f, 0x0, 0x0, 0x7f, 0xcf, 0x0,
    0x1, 0xff, 0x8f, 0x0, 0xf, 0xf0, 0xf, 0x0,
    0x7c, 0x0, 0xcf, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0x20, 0x40, 0xcf, 0x0, 0x10, 0x61, 0x8f, 0x0,
    0x18, 0x61, 0x8f, 0x0, 0x1c, 0x71, 0x8f, 0x0,
    0x1c, 0x73, 0xf, 0x0, 0xe, 0x73, 0xf, 0x0,
    0xe, 0x33, 0xf, 0x0, 0xe, 0x36, 0xf, 0x0,
    0x4, 0x6, 0x4f, 0x0, 0x4, 0x6, 0xcf, 0x0,
    0x3f, 0xff, 0xcf, 0x0, 0x3f, 0xff, 0xcf, 0x0,
    0x0, 0x3, 0xcf, 0x0, 0x0, 0xf, 0xf, 0x0,
    0x0, 0x1c, 0xf, 0x0, 0x0, 0x38, 0xf, 0x0,
    0x0, 0x60, 0x2f, 0x0, 0x0, 0xf0, 0x4f, 0x0,
    0x3, 0xf0, 0xcf, 0x0, 0x0, 0xf1, 0x8f, 0x0,
    0x0, 0xf7, 0xf, 0x0, 0x0, 0xfe, 0xf, 0x0,
    0x0, 0xfc, 0xf, 0x2, 0xf, 0xf8, 0xf, 0x2,
    0xff, 0xf0, 0xf, 0x2, 0x7f, 0xf0, 0xf, 0x2,
    0x7f, 0xf0, 0xf, 0x2, 0x7c, 0xf0, 0xf, 0x2,
    0x70, 0xf0, 0xf, 0x2, 0x0, 0xf0, 0xf, 0x2,
    0x0, 0xf0, 0xf, 0x2, 0x0, 0xf0, 0xf, 0x7,
    0x0, 0xf0, 0xf, 0x7, 0x0, 0xf0, 0xf, 0x7,
    0x0, 0xf0, 0xf, 0x7, 0x0, 0xf0, 0xf, 0xff,
    0x1, 0xe0, 0xf, 0xff, 0x7, 0xe0, 0xf, 0xfe,
    0x3f, 0x80, 0x7, 0xfe, 0x0, 0x0, 0x0, 0x0,

    /* U+4E7E "乾" */
    0x0, 0xe0, 0xf, 0x80, 0x0, 0xe0, 0xf, 0x0,
    0x0, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0xf, 0x0,
    0x0, 0xe0, 0xf, 0x0, 0x7f, 0xff, 0x9f, 0x0,
    0x7f, 0xff, 0x9e, 0x0, 0x0, 0xe0, 0x1e, 0x0,
    0x0, 0xc0, 0x1f, 0xff, 0x1, 0xc0, 0x1f, 0xff,
    0x1, 0x80, 0x3c, 0x0, 0x79, 0x80, 0x38, 0x0,
    0x79, 0xf, 0x30, 0x0, 0x7f, 0xff, 0x70, 0x0,
    0x7f, 0xff, 0x60, 0x0, 0x78, 0xf, 0x40, 0x0,
    0x78, 0xf, 0xc0, 0x0, 0x78, 0xf, 0x80, 0x4,
    0x78, 0xf, 0x3f, 0xfc, 0x7f, 0xef, 0x3f, 0xfc,
    0x7f, 0xef, 0x0, 0x7c, 0x78, 0xf, 0x0, 0x78,
    0x78, 0xf, 0x0, 0x78, 0x78, 0xf, 0x0, 0xf0,
    0x78, 0xf, 0x0, 0xe0, 0x7f, 0xff, 0x1, 0xe0,
    0x79, 0xef, 0x1, 0xc0, 0x79, 0xef, 0x3, 0xc0,
    0x79, 0xef, 0x3, 0x80, 0x1, 0xe0, 0x7, 0x80,
    0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0, 0xf, 0x0,
    0x1, 0xe0, 0xf, 0x1, 0xff, 0xff, 0x9e, 0x3,
    0xff, 0xff, 0x9e, 0x3, 0x1, 0xe0, 0x1c, 0x2,
    0x1, 0xe0, 0x3c, 0x2, 0x1, 0xe0, 0x38, 0x2,
    0x1, 0xe0, 0x78, 0x6, 0x1, 0xe0, 0x78, 0x7,
    0x1, 0xe0, 0x70, 0x7, 0x1, 0xe0, 0x78, 0xf,
    0x1, 0xe0, 0x7f, 0xff, 0x1, 0xe0, 0x7f, 0xff,
    0x1, 0xe0, 0x3f, 0xfe, 0x1, 0xe0, 0x1f, 0xfc,
    0x0, 0x0, 0x0, 0x0,

    /* U+4E82 "亂" */
    0x0, 0x1, 0x87, 0x80, 0x0, 0x1f, 0x8f, 0x0,
    0x7, 0xff, 0x9e, 0x1, 0xff, 0xfe, 0x3c, 0x5,
    0x10, 0x30, 0x78, 0x2, 0x30, 0xe0, 0xf0, 0x6,
    0x31, 0x81, 0xe0, 0x6, 0x73, 0x3, 0xc0, 0xc,
    0xec, 0x7, 0x80, 0x18, 0x98, 0xf, 0x0, 0x20,
    0x2f, 0x1e, 0x7, 0xff, 0xfe, 0x3c, 0xf, 0xff,
    0xf8, 0x78, 0x0, 0x0, 0xe0, 0xf0, 0x0, 0x63,
    0x81, 0xe0, 0x0, 0xfc, 0x3, 0xc0, 0x0, 0xf0,
    0x7, 0x80, 0xf0, 0xe7, 0x8f, 0x1, 0xff, 0xff,
    0x1e, 0x3, 0xff, 0xfe, 0x3c, 0x7, 0x9c, 0x3c,
    0x78, 0xf, 0x3c, 0x78, 0xf0, 0x1e, 0x68, 0xf1,
    0xe0, 0x3d, 0xc9, 0xe3, 0xc0, 0x7a, 0x1f, 0xc7,
    0x80, 0xf8, 0x7f, 0x8f, 0x1, 0xff, 0x2f, 0x1e,
    0x3, 0xfc, 0x5e, 0x3c, 0x7, 0xc0, 0x3c, 0x78,
    0xf, 0x7, 0x78, 0xf0, 0x1f, 0xfe, 0xf1, 0xe0,
    0x3f, 0xfd, 0xe3, 0xc0, 0x78, 0x7b, 0xc7, 0x82,
    0xf0, 0xe7, 0x8f, 0x5, 0xe9, 0xcf, 0x1e, 0xb,
    0xdf, 0x1e, 0x3c, 0x17, 0x9e, 0x3c, 0x78, 0x2f,
    0x1f, 0x78, 0xf0, 0xde, 0x5e, 0xf1, 0xe1, 0xbd,
    0x1d, 0xe3, 0xc3, 0x7c, 0xb, 0xc7, 0x86, 0xf0,
    0x7, 0x8f, 0xd, 0xe0, 0xf, 0x1f, 0xfb, 0xc0,
    0x7c, 0x3f, 0xf7, 0x87, 0xf0, 0x3f, 0xef, 0x0,
    0x0, 0x0, 0x0,

    /* U+4E86 "了" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x7,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x38, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,
    0x38, 0x0, 0x0, 0xe, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x3,
    0xf0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x39, 0x0,
    0x0,

    /* U+4E88 "予" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10,
    0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xc0,
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x1c, 0x0,
    0x0, 0x0, 0xe0, 0x0, 0x4, 0x3, 0x80, 0x0,
    0xc, 0x1c, 0x0, 0x0, 0xc, 0x70, 0x0, 0x0,
    0x1d, 0x80, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0,
    0x70, 0x7, 0x80, 0x0, 0xe0, 0xf, 0x0, 0x0,
    0x80, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x1e, 0x0, 0xf0, 0x0, 0x3c,
    0x1, 0xe0, 0x0, 0x78, 0x3, 0xc0, 0x0, 0xf0,
    0x7, 0x80, 0x1, 0xe0, 0x8, 0x0, 0x3, 0xc0,
    0x10, 0x0, 0x7, 0x80, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0xf,
    0x80, 0x0, 0x0, 0x64, 0x0, 0x0, 0x0,

    /* U+4E89 "争" */
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x1f, 0x1, 0xf0, 0x0, 0xf, 0x0, 0xf8,
    0x0, 0x7, 0xff, 0xfc, 0x0, 0x7, 0xff, 0xfe,
    0x0, 0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e,
    0x0, 0x1, 0xc0, 0xe, 0x0, 0x1, 0xc0, 0xe,
    0x0, 0x0, 0xe0, 0x6, 0x0, 0x0, 0xe0, 0xe,
    0xf, 0x0, 0xe0, 0xc, 0x7, 0x80, 0xff, 0xff,
    0xff, 0xc0, 0xcf, 0xff, 0xff, 0xe0, 0xc0, 0x7,
    0x80, 0xf0, 0xc0, 0x3, 0xc0, 0x78, 0x0, 0x1,
    0xe0, 0x3c, 0x0, 0x0, 0xf0, 0x1e, 0x0, 0x0,
    0x78, 0xf, 0x7, 0xff, 0xff, 0xff, 0xfb, 0xff,
    0xff, 0xff, 0xfc, 0x0, 0xf, 0x1, 0xe0, 0x0,
    0x7, 0x80, 0xf0, 0x0, 0x3, 0xc0, 0x78, 0x0,
    0x1, 0xe0, 0x3c, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0x78, 0xf, 0x0, 0x7f, 0xff, 0xff, 0x80,
    0x3f, 0xff, 0xff, 0xc0, 0x0, 0xf, 0x1, 0xe0,
    0x0, 0x7, 0x80, 0xf0, 0x0, 0x3, 0xc0, 0x78,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7, 0xe0,
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0,

    /* U+4E8B "事" */
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x38, 0x0,
    0x0, 0x0, 0x1c, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xfd, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x3, 0x80,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0xf, 0x0, 0xe0,
    0x1e, 0x7, 0xff, 0xff, 0xff, 0x3, 0xff, 0xff,
    0xff, 0x81, 0xe0, 0x1c, 0x3, 0xc0, 0xf0, 0xe,
    0x1, 0xe0, 0x78, 0x7, 0x0, 0xf0, 0x3c, 0x3,
    0x80, 0x78, 0x1f, 0xff, 0xff, 0xfc, 0xf, 0xff,
    0xff, 0xfe, 0x7, 0xff, 0xff, 0xff, 0x3, 0xc0,
    0x38, 0x7, 0x80, 0x0, 0x1c, 0x0, 0x0, 0x0,
    0xe, 0x0, 0x0, 0x0, 0x7, 0x0, 0xf0, 0x3f,
    0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0xe0, 0x1e, 0x0, 0x0, 0x70, 0xf, 0x0,
    0x0, 0x38, 0x7, 0x80, 0x0, 0x1c, 0x3, 0xc7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x3, 0x80, 0x78, 0x0, 0x1, 0xc0, 0x3c,
    0x0, 0x0, 0xe0, 0x1e, 0x7, 0xff, 0xff, 0xff,
    0x3, 0xff, 0xff, 0xff, 0x80, 0x0, 0x1c, 0x3,
    0xc0, 0x0, 0xe, 0x1, 0xe0, 0x0, 0x7, 0x0,
    0xf0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0x6, 0xe0, 0x0, 0x0,

    /* U+4E8C "二" */
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+4E8D "亍" */
    0x1f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x3, 0xe0, 0x0, 0x0, 0x7,
    0xc0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x7c,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x6, 0xf0, 0x0, 0x0,

    /* U+4E8E "于" */
    0x1f, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfc,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x1, 0xb0, 0x0, 0x0,

    /* U+4E8F "亏" */
    0xf, 0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x0, 0xe0, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0x0, 0xc0, 0x0, 0x0, 0x1, 0x80, 0x1, 0xc0,
    0x3, 0x0, 0x1, 0xc0, 0x3, 0xff, 0xff, 0xc0,
    0x3, 0xff, 0xff, 0xc0, 0x2, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x3f, 0x80, 0x0, 0x1, 0xfe, 0x0,
    0x0, 0x0, 0x8, 0x0,

    /* U+4E91 "云" */
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x8, 0x0,
    0x0, 0x1e, 0x8, 0x0, 0x0, 0x3e, 0x8, 0x0,
    0x0, 0x3e, 0xc, 0x0, 0x0, 0x3c, 0xc, 0x0,
    0x0, 0x3c, 0xc, 0x0, 0x0, 0x38, 0x6, 0x0,
    0x0, 0x78, 0x6, 0x0, 0x0, 0x70, 0x7, 0x0,
    0x0, 0x70, 0x7, 0x0, 0x0, 0xe0, 0x3, 0x80,
    0x0, 0xe0, 0x3, 0xc0, 0x0, 0xc0, 0x3, 0xe0,
    0x1, 0x80, 0x3, 0xe0, 0x3, 0x80, 0xd, 0xf0,
    0x3, 0x0, 0x38, 0xfc, 0x6, 0x1, 0xe0, 0xfe,
    0x3c, 0x7f, 0x80, 0x7c, 0x3f, 0xfe, 0x0, 0x3c,
    0x1f, 0xf0, 0x0, 0x38, 0x3f, 0x80, 0x0, 0x18,
    0x38, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 0x4,

    /* U+4E92 "互" */
    0x3f, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfc,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x38, 0x7, 0x80, 0x0, 0x38, 0x7, 0x80,
    0x0, 0x3f, 0xff, 0x80, 0x0, 0x7f, 0xff, 0x80,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x78, 0x7, 0x80,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x70, 0x7, 0x80,
    0x0, 0x70, 0x7, 0x80, 0x0, 0x70, 0x7, 0x80,
    0x0, 0xe0, 0x7, 0x80, 0x0, 0xe0, 0x7, 0x80,
    0x0, 0xc0, 0x7, 0x80, 0x1, 0xc0, 0x7, 0x80,
    0x1, 0x80, 0x7, 0x80, 0x2, 0x0, 0x7, 0x80,
    0x7, 0xff, 0xff, 0x80, 0x7, 0xff, 0xff, 0x80,
    0x6, 0x0, 0x7, 0x80, 0x4, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xe, 0x0,
    0x0, 0x0, 0xc, 0x0, 0x0, 0x0, 0x1c, 0x0,
    0x0, 0x0, 0x18, 0x0, 0x0, 0x0, 0x20, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+4E93 "亓" */
    0x1f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xf0, 0x7,
    0x1, 0xc0, 0x0, 0xe, 0x3, 0x80, 0x0, 0x1c,
    0x7, 0x0, 0x0, 0x38, 0xe, 0x0, 0x0, 0x70,
    0x1c, 0x0, 0x0, 0xe0, 0x38, 0x0, 0x1, 0xc0,
    0x70, 0x0, 0x3, 0x80, 0xe0, 0x0, 0x7, 0x1,
    0xc0, 0x0, 0xe, 0x3, 0x80, 0x0, 0x1c, 0x7,
    0x0, 0x0, 0x38, 0xe, 0x0, 0x0, 0x70, 0x1c,
    0x0, 0x0, 0xe0, 0x38, 0x0, 0x3, 0xc0, 0x70,
    0x0, 0x7, 0x80, 0xe0, 0x0, 0xf, 0x1, 0xc0,
    0x0, 0x1c, 0x3, 0x80, 0x0, 0x38, 0x7, 0x0,
    0x0, 0xf0, 0xe, 0x0, 0x1, 0xc0, 0x1c, 0x0,
    0x3, 0x80, 0x38, 0x0, 0xe, 0x0, 0x70, 0x0,
    0x1c, 0x0, 0xe0, 0x0, 0x70, 0x1, 0xc0, 0x0,
    0xc0, 0x3, 0x80, 0x3, 0x80, 0x7, 0x0, 0x6,
    0x0, 0xe, 0x0, 0x18, 0x0, 0x1c, 0x0, 0x60,
    0x0, 0x38, 0x1, 0x80, 0x0, 0x70, 0x6, 0x0,
    0x0, 0x0, 0x0,

    /* U+4E94 "五" */
    0x3f, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xfe,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x1, 0xe0,
    0x0, 0x1e, 0x1, 0xe0, 0x1f, 0xff, 0xff, 0xe0,
    0x1f, 0xff, 0xff, 0xe0, 0x0, 0x1c, 0x1, 0xe0,
    0x0, 0x1c, 0x1, 0xe0, 0x0, 0x1c, 0x1, 0xe0,
    0x0, 0x1c, 0x1, 0xe0, 0x0, 0x1c, 0x1, 0xe0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x38, 0x1, 0xe0,
    0x0, 0x38, 0x1, 0xe0, 0x0, 0x38, 0x1, 0xe0,
    0x0, 0x38, 0x1, 0xe0, 0x0, 0x30, 0x1, 0xc0,
    0x0, 0x70, 0x1, 0xc0, 0x0, 0x60, 0x1, 0xc0,
    0x0, 0x60, 0x1, 0x80, 0x0, 0x40, 0x3, 0x80,
    0x0, 0xc0, 0x3, 0x0, 0x0, 0x80, 0x3, 0x0,
    0x1, 0x0, 0x2, 0x0, 0x3, 0x0, 0x4, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+4E95 "井" */
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x3f, 0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfc,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x1, 0xe0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0x80, 0xf, 0x0,
    0x7, 0x0, 0xf, 0x0, 0x7, 0x0, 0xf, 0x0,
    0xe, 0x0, 0xf, 0x0, 0xc, 0x0, 0xf, 0x0,
    0x18, 0x0, 0xf, 0x0, 0x30, 0x0, 0xf, 0x0,
    0x60, 0x0, 0xf, 0x0, 0x40, 0x0, 0xf, 0x0,

    /* U+4E98 "亘" */
    0x7f, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0xff, 0xff, 0xf0,
    0x7, 0xff, 0xff, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0xff, 0xfc, 0xf0,
    0x7, 0xff, 0xfc, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0xff, 0xff, 0xf0, 0x7, 0xff, 0xff, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x7, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+4E9A "亚" */
    0x7f, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xf8,
    0x1, 0xe0, 0xf0, 0x0, 0x3, 0xc1, 0xe0, 0x0,
    0x7, 0x83, 0xc0, 0x0, 0xf, 0x7, 0x80, 0x0,
    0x1e, 0xf, 0x0, 0x0, 0x3c, 0x1e, 0x0, 0x0,
    0x78, 0x3c, 0x0, 0x0, 0xf0, 0x78, 0x0, 0x41,
    0xe0, 0xf0, 0x0, 0x83, 0xc1, 0xe0, 0x61, 0x7,
    0x83, 0xc1, 0x83, 0xf, 0x7, 0x83, 0x6, 0x1e,
    0xf, 0xe, 0x6, 0x3c, 0x1e, 0x18, 0xc, 0x78,
    0x3c, 0x70, 0x1c, 0xf0, 0x78, 0xc0, 0x39, 0xe0,
    0xf1, 0x80, 0x73, 0xc1, 0xe6, 0x0, 0xf7, 0x83,
    0xcc, 0x0, 0xef, 0x7, 0xb0, 0x1, 0xfe, 0xf,
    0x60, 0x3, 0xbc, 0x1f, 0x80, 0x7, 0x78, 0x3f,
    0x0, 0xe, 0xf0, 0x7c, 0x0, 0x9, 0xe0, 0xf8,
    0x0, 0x3, 0xc1, 0xe0, 0x0, 0x7, 0x83, 0xc0,
    0x0, 0xf, 0x7, 0x80, 0x0, 0x1e, 0xf, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0xf0, 0x78, 0x0, 0x1, 0xe0, 0xf0, 0x0,
    0x3, 0xc1, 0xe0, 0x0, 0x7, 0x83, 0xc0, 0x0,
    0xf, 0x7, 0x80, 0x0, 0x1e, 0xf, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,

    /* U+4E9B "些" */
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x1e, 0x3c, 0x1e, 0x0,
    0x1e, 0x3c, 0x1e, 0x6, 0x1e, 0x3c, 0x1e, 0xe,
    0x1e, 0x3c, 0x1e, 0x1c, 0x1e, 0x3c, 0x1e, 0x18,
    0x1e, 0x3f, 0xde, 0x30, 0x1e, 0x3f, 0xde, 0x60,
    0x1e, 0x3c, 0x1e, 0x40, 0x1e, 0x3c, 0x1e, 0x80,
    0x1e, 0x3c, 0x1f, 0x80, 0x1e, 0x3c, 0x1f, 0x0,
    0x1e, 0x3c, 0x1e, 0x1, 0x1e, 0x3c, 0x1e, 0x3,
    0x1e, 0x3c, 0x1e, 0x2, 0x1e, 0x3c, 0x5e, 0x2,
    0x1e, 0x3c, 0x9e, 0x2, 0x1e, 0x3f, 0x1e, 0x2,
    0x1e, 0x3e, 0x1e, 0x3, 0x1e, 0x3c, 0x1e, 0x7,
    0x1f, 0xf0, 0x1e, 0x7, 0xff, 0xe0, 0x1f, 0xff,
    0xff, 0x80, 0x1f, 0xff, 0xfe, 0x0, 0xf, 0xff,
    0xf0, 0x0, 0xf, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,

    /* U+4E9E "亞" */
    0x7f, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xf8,
    0x0, 0xf0, 0xe0, 0x0, 0x1, 0xe1, 0xc0, 0x0,
    0x3, 0xc3, 0x80, 0x0, 0x7, 0x87, 0x0, 0x0,
    0xf, 0xe, 0x0, 0x0, 0x1e, 0x1c, 0x0, 0x0,
    0x3c, 0x38, 0x0, 0x0, 0x78, 0x70, 0x0, 0x78,
    0xf0, 0xe1, 0xc0, 0xf1, 0xe1, 0xc3, 0x81, 0xe3,
    0xc3, 0x87, 0x3, 0xff, 0x87, 0xfe, 0x7, 0xff,
    0xf, 0xfc, 0xf, 0x1e, 0x1c, 0x38, 0x1e, 0x0,
    0x0, 0x70, 0x3c, 0x0, 0x0, 0xe0, 0x78, 0x0,
    0x1, 0xc0, 0xf0, 0x0, 0x3, 0x81, 0xe0, 0x0,
    0x7, 0x3, 0xc0, 0x0, 0xe, 0x7, 0x80, 0x0,
    0x1c, 0xf, 0x0, 0x0, 0x38, 0x1e, 0x0, 0x0,
    0x70, 0x3c, 0x78, 0x70, 0xe0, 0x7f, 0xf0, 0xff,
    0xc0, 0xff, 0xe1, 0xff, 0x81, 0xe3, 0xc3, 0x87,
    0x3, 0xc7, 0x87, 0xe, 0x7, 0x8f, 0xe, 0x1c,
    0xf, 0x1e, 0x1c, 0x38, 0x0, 0x3c, 0x38, 0x0,
    0x0, 0x78, 0x70, 0x0, 0x0, 0xf0, 0xe0, 0x0,
    0x1, 0xe1, 0xc0, 0x0, 0x3, 0xc3, 0x80, 0x0,
    0x7, 0x87, 0x0, 0x0, 0xf, 0xe, 0x0, 0x0,
    0x1e, 0x1c, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfc,

    /* U+4E9F "亟" */
    0x0, 0x0, 0x0, 0x4, 0x3f, 0xff, 0xff, 0xfc,
    0x3f, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x78, 0x3c, 0xf3, 0xc0, 0x78,
    0x3c, 0xf3, 0xdf, 0xf8, 0x3f, 0xf3, 0xdf, 0xf8,
    0x3c, 0xf3, 0xc8, 0x78, 0x3c, 0xf3, 0xc8, 0x78,
    0x3c, 0xf3, 0xcc, 0x78, 0x3c, 0xf3, 0xcc, 0x78,
    0x3c, 0xf3, 0xcc, 0x78, 0x3c, 0xf3, 0xcc, 0x78,
    0x3c, 0xf3, 0xc4, 0x78, 0x3c, 0xf3, 0xc6, 0x78,
    0x3c, 0xf3, 0xc6, 0x78, 0x3c, 0xf3, 0xc6, 0x70,
    0x3c, 0xf3, 0xc7, 0x70, 0x3c, 0xf3, 0xc7, 0xe0,
    0x3c, 0xf3, 0xc3, 0xe0, 0x3c, 0xf3, 0xc3, 0xc0,
    0x3f, 0xf3, 0xc3, 0xe0, 0x3f, 0xf3, 0xc1, 0xf0,
    0x3c, 0xf3, 0xc3, 0xfc, 0x3c, 0xf3, 0xc3, 0xff,
    0x3c, 0xf3, 0xc6, 0xfe, 0x3c, 0x3, 0xc6, 0x7e,
    0x0, 0x3, 0xcc, 0x3c, 0x0, 0x7, 0x88, 0x1c,
    0x0, 0xf, 0x98, 0xc, 0x0, 0x1f, 0x10, 0x4,
    0x0, 0xfc, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff,

    /* U+4EA0 "亠" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x60, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,
    0x3, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x1,
    0xc0, 0x0, 0x0, 0x2, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0,

    /* U+4EA1 "亡" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xf8, 0x3, 0xff, 0xff, 0xf8,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,

    /* U+4EA2 "亢" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x1, 0x80, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0x60, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xff, 0xff, 0x0, 0x0, 0xff, 0xff, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x2,
    0x0, 0xe0, 0xf, 0x2, 0x1, 0xe0, 0xf, 0x2,
    0x1, 0xe0, 0xf, 0x2, 0x1, 0xc0, 0xf, 0x2,
    0x3, 0x80, 0xf, 0x2, 0x3, 0x80, 0xf, 0x2,
    0x7, 0x0, 0xf, 0x3, 0x6, 0x0, 0xf, 0x7,
    0xe, 0x0, 0xf, 0x7, 0xc, 0x0, 0xf, 0xff,
    0x18, 0x0, 0xf, 0xff, 0x30, 0x0, 0x7, 0xfe,
    0x60, 0x0, 0x3, 0xfc,

    /* U+4EA4 "交" */
    0x0, 0x8, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x1, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf8, 0x10, 0x0, 0x1, 0xf0, 0x10, 0x0,
    0x1, 0xf0, 0x8, 0x0, 0x1, 0xf0, 0xc, 0x0,
    0x1, 0xe0, 0xe, 0x0, 0x3, 0xc0, 0x7, 0x0,
    0x3, 0xc0, 0x7, 0xc0, 0x3, 0x80, 0x1f, 0xf0,
    0x7, 0x80, 0x1f, 0xfc, 0x7, 0x80, 0x1e, 0xf8,
    0xe, 0x80, 0x3e, 0x78, 0xc, 0x80, 0x3e, 0x38,
    0x18, 0xc0, 0x3e, 0x18, 0x30, 0x40, 0x3c, 0x0,
    0x60, 0x40, 0x3c, 0x0, 0xc0, 0x60, 0x3c, 0x0,
    0x0, 0x60, 0x3c, 0x0, 0x0, 0x30, 0x78, 0x0,
    0x0, 0x30, 0x78, 0x0, 0x0, 0x18, 0x78, 0x0,
    0x0, 0x1c, 0x70, 0x0, 0x0, 0x1e, 0xf0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0xf, 0xf8, 0x0, 0x0, 0x1e, 0xfe, 0x0,
    0x0, 0x3c, 0x7f, 0xc0, 0x0, 0x70, 0x1f, 0xfc,
    0x0, 0xe0, 0xf, 0xfe, 0x3, 0xc0, 0x3, 0xfc,
    0x7, 0x0, 0x1, 0xfc, 0xe, 0x0, 0x0, 0x7c,
    0x38, 0x0, 0x0, 0x1c, 0xe0, 0x0, 0x0, 0x0,

    /* U+4EA5 "亥" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xc0, 0x0,
    0x0, 0x0, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x3c, 0xf, 0x80, 0x0, 0x38, 0xf, 0x80,
    0x0, 0x38, 0xf, 0x80, 0x0, 0x70, 0xf, 0x80,
    0x0, 0x70, 0xf, 0x0, 0x0, 0x60, 0x1f, 0x0,
    0x0, 0xc0, 0x3f, 0x0, 0x1, 0x81, 0xff, 0x0,
    0x7, 0x1f, 0x9e, 0x0, 0x7, 0xfe, 0x1e, 0x0,
    0x3, 0xf8, 0x3c, 0x0, 0x3, 0xc0, 0x3c, 0x0,
    0x6, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x1, 0xe7, 0x80, 0x0, 0x1, 0xc7, 0x80,
    0x0, 0x3, 0x87, 0x80, 0x0, 0x7, 0x7, 0x80,
    0x0, 0xe, 0x7, 0x0, 0x0, 0x18, 0xf, 0x0,
    0x0, 0x30, 0xf, 0x0, 0x0, 0xe0, 0xf, 0x0,
    0x1, 0xc0, 0x1f, 0x0, 0x3, 0x0, 0x3d, 0x0,
    0x6, 0x0, 0x79, 0x80, 0x1c, 0x0, 0x71, 0xc0,
    0x30, 0x0, 0xe1, 0xc0, 0x0, 0x1, 0x80, 0xe0,
    0x0, 0x7, 0x0, 0xf0, 0x0, 0xe, 0x0, 0xfc,
    0x0, 0x18, 0x0, 0x78, 0x0, 0x30, 0x0, 0x78,
    0x0, 0xc0, 0x0, 0x38, 0x1, 0x0, 0x0, 0x18,
    0x6, 0x0, 0x0, 0x8,

    /* U+4EA6 "亦" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x7, 0x0,
    0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x0, 0x80,
    0x0, 0x7f, 0xff, 0xff, 0xff, 0xbf, 0xff, 0xff,
    0xff, 0xc0, 0x7, 0x87, 0x80, 0x0, 0x3, 0xc3,
    0xc0, 0x0, 0x1, 0xe1, 0xe0, 0x0, 0x0, 0xf0,
    0xf0, 0x0, 0x1e, 0x78, 0x79, 0x0, 0xf, 0x3c,
    0x3c, 0x80, 0x7, 0x9e, 0x1e, 0x40, 0x3, 0xcf,
    0xf, 0x20, 0x1, 0xe7, 0x87, 0x90, 0x0, 0xf3,
    0xc3, 0xc4, 0x0, 0x79, 0xe1, 0xe2, 0x0, 0x3c,
    0xf0, 0xf1, 0x0, 0x1e, 0x78, 0x78, 0x80, 0xf,
    0x3c, 0x3c, 0x60, 0x7, 0x9e, 0x1e, 0x30, 0x3,
    0x8f, 0xf, 0x1c, 0x1, 0xc7, 0x87, 0x8e, 0x0,
    0xe3, 0xc3, 0xc3, 0x80, 0x61, 0xe1, 0xe1, 0xe0,
    0x70, 0xf0, 0xf0, 0xf8, 0x30, 0x78, 0x78, 0x7e,
    0x18, 0x3c, 0x3c, 0x1e, 0x18, 0x1e, 0x1e, 0xf,
    0xc, 0xf, 0xf, 0x3, 0x84, 0x7, 0x7, 0x81,
    0xc6, 0x7, 0x83, 0xc0, 0x62, 0x3, 0xc1, 0xe0,
    0x33, 0x1, 0xc0, 0xf0, 0xb, 0x1, 0xc0, 0x78,
    0x0, 0x0, 0xe0, 0x3c, 0x0, 0x0, 0xe0, 0x1e,
    0x0, 0x0, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0x7,
    0x0, 0x0, 0x60, 0x7, 0x80, 0x0, 0x60, 0x7,
    0x80, 0x0, 0x60, 0xf, 0x80, 0x0, 0xc0, 0x1b,
    0x0, 0x0,

    /* U+4EA7 "产" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x40, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x60, 0x0, 0xc, 0x0, 0x60, 0x0, 0x7, 0x0,
    0x30, 0x0, 0x1, 0xc0, 0x30, 0x0, 0x0, 0xf0,
    0x18, 0x0, 0x0, 0x7c, 0x18, 0x0, 0x0, 0x1c,
    0x8, 0x0, 0x0, 0xe, 0xc, 0x0, 0xf, 0x3,
    0x4, 0x0, 0x7, 0x80, 0x86, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xe1, 0xff, 0xff, 0xff, 0xf0, 0xf0,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x1c, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x0, 0x6, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x2, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x0, 0x0,

    /* U+4EA8 "亨" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1c, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe0, 0x0, 0x78, 0x0, 0x70, 0x0,
    0x3c, 0x0, 0x3f, 0xff, 0xfe, 0x0, 0x1f, 0xff,
    0xff, 0x0, 0xe, 0x0, 0x7, 0x80, 0x7, 0x0,
    0x3, 0xc0, 0x3, 0x80, 0x1, 0xe0, 0x1, 0xc0,
    0x0, 0xf0, 0x0, 0xe0, 0x0, 0x78, 0x0, 0x7f,
    0xff, 0xfc, 0x0, 0x3f, 0xff, 0xfe, 0x0, 0x1c,
    0x0, 0xf, 0x0, 0xe, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0x1f,
    0xff, 0xff, 0xfe, 0xf, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x2, 0x70,
    0x0, 0x0,

    /* U+4EA9 "亩" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0, 0xf0,
    0x1f, 0x0, 0x0, 0xf0, 0x1f, 0xff, 0xff, 0xf0,
    0x1f, 0xff, 0xff, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0xff, 0xff, 0xf0,
    0x1f, 0xff, 0xff, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0x3, 0xc0, 0xf0,
    0x1f, 0x3, 0xc0, 0xf0, 0x1f, 0xff, 0xff, 0xf0,
    0x1f, 0xff, 0xff, 0xf0, 0x1f, 0x0, 0x0, 0xf0,
    0x1f, 0x0, 0x0, 0xf0, 0x1f, 0x0, 0x0, 0xf0,
    0x1f, 0x0, 0x0, 0xf0,

    /* U+4EAB "享" */
    0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x1c, 0x0,
    0x0, 0x0, 0xe, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xfd, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x78, 0x0, 0xff, 0xff, 0xfc, 0x0, 0x7f, 0xff,
    0xfe, 0x0, 0x38, 0x0, 0xf, 0x0, 0x1c, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x3, 0xc0, 0x7, 0x0,
    0x1, 0xe0, 0x3, 0x80, 0x0, 0xf0, 0x1, 0xff,
    0xff, 0xf8, 0x0, 0xff, 0xff, 0xfc, 0x0, 0x70,
    0x0, 0x1e, 0x0, 0x38, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x40, 0x1f,
    0xff, 0xff, 0xe0, 0xf, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+4EAC "京" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x0, 0x3, 0xc4, 0x0,
    0x0, 0x3, 0xc4, 0x0, 0x3, 0xc3, 0xc2, 0x0,
    0x3, 0xc3, 0xc2, 0x0, 0x3, 0xc3, 0xc3, 0x0,
    0x3, 0xc3, 0xc3, 0x0, 0x3, 0x83, 0xc3, 0x80,
    0x7, 0x83, 0xc1, 0xc0, 0x7, 0x3, 0xc1, 0xe0,
    0x7, 0x3, 0xc1, 0xf0, 0xe, 0x3, 0xc0, 0xfc,
    0xc, 0x3, 0xc0, 0x7e, 0xc, 0x3, 0xc0, 0x7e,
    0x18, 0x3, 0xc0, 0x3e, 0x30, 0x3, 0xc0, 0x1e,
    0x60, 0x3, 0xc0, 0x6, 0xc0, 0x7, 0xc0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x6e, 0x0, 0x0,

    /* U+4EAD "亭" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x80, 0x1, 0xe0,
    0x3, 0xff, 0xff, 0xe0, 0x3, 0xff, 0xff, 0xe0,
    0x3, 0x80, 0x1, 0xe0, 0x3, 0x80, 0x1, 0xe0,
    0x3, 0x80, 0x1, 0xe0, 0x3, 0x80, 0x1, 0xe0,
    0x3, 0xff, 0xff, 0xe0, 0x3, 0xff, 0xff, 0xe0,
    0x3, 0x80, 0x1, 0xe0, 0x3, 0x80, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0xd, 0x3, 0xff, 0xff, 0xc8,
    0x3, 0xff, 0xff, 0xc0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x7f, 0x0, 0x0,
    0x0, 0x8, 0x0, 0x0,

    /* U+4EAE "亮" */
    0x0, 0x8, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x80, 0x0,
    0x7f, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xc0, 0x7, 0x80, 0x1, 0xc0, 0x7, 0x80,
    0x1, 0xff, 0xff, 0x80, 0x1, 0xff, 0xff, 0x80,
    0x1, 0xc0, 0x7, 0x80, 0x1, 0xc0, 0x7, 0x80,
    0x1, 0xc0, 0x7, 0x80, 0x1, 0xc0, 0x7, 0x80,
    0x1, 0xff, 0xff, 0x80, 0x1, 0xff, 0xff, 0x80,
    0x1, 0xc0, 0x7, 0x80, 0x78, 0x0, 0x0, 0x3c,
    0x78, 0x0, 0x0, 0x3c, 0x7f, 0xff, 0xff, 0xfc,
    0x78, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c,
    0x78, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x1c, 0x3c,
    0x78, 0x78, 0x1c, 0x30, 0x0, 0x7f, 0xfc, 0x20,
    0x0, 0x7f, 0xfc, 0x0, 0x0, 0x78, 0x1c, 0x0,
    0x0, 0x78, 0x1c, 0x0, 0x0, 0x78, 0x1c, 0x0,
    0x0, 0x78, 0x1c, 0x0, 0x0, 0x78, 0x1c, 0x4,
    0x0, 0x78, 0x1c, 0x4, 0x0, 0x70, 0x1c, 0x4,
    0x0, 0xf0, 0x1c, 0x4, 0x0, 0xe0, 0x1c, 0x4,
    0x1, 0xc0, 0x1c, 0x4, 0x1, 0xc0, 0x1c, 0x4,
    0x3, 0x80, 0x1c, 0x7, 0x7, 0x0, 0x1e, 0xf,
    0xc, 0x0, 0x1f, 0xff, 0x18, 0x0, 0x1f, 0xff,
    0x60, 0x0, 0xf, 0xfe,

    /* U+4EB2 "亲" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xc0, 0x0,
    0x1f, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x40, 0x1, 0x80, 0x0, 0x60, 0x3, 0x80,
    0x0, 0x70, 0x3, 0x0, 0x0, 0x38, 0x7, 0x0,
    0x0, 0x3c, 0x6, 0x0, 0x0, 0x38, 0xe, 0x0,
    0x0, 0x38, 0xc, 0x0, 0x0, 0x10, 0x18, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x3, 0xc3, 0xe4, 0x0, 0x3, 0xc3, 0xe4, 0x0,
    0x3, 0xc3, 0xe4, 0x0, 0x3, 0xc3, 0xe6, 0x0,
    0x3, 0xc3, 0xe6, 0x0, 0x3, 0x83, 0xe3, 0x0,
    0x7, 0x83, 0xe3, 0x80, 0x7, 0x3, 0xe3, 0xc0,
    0x7, 0x3, 0xe1, 0xf0, 0x6, 0x3, 0xe1, 0xfc,
    0xc, 0x3, 0xe0, 0xfc, 0x8, 0x3, 0xe0, 0xfc,
    0x10, 0x3, 0xc0, 0x7c, 0x30, 0x7, 0xc0, 0x3c,
    0x20, 0xf, 0x80, 0xc, 0x40, 0x3f, 0x0, 0x0,
    0x0, 0xc8, 0x0, 0x0,

    /* U+4EB3 "亳" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0xf0, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x6, 0xf, 0xf0, 0x0, 0x3f, 0xf,
    0x0, 0x3, 0xff, 0x88, 0x0, 0x3f, 0xff, 0xc0,
    0x7, 0xff, 0xc0, 0x0, 0xff, 0xc7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xfa,
    0xff, 0xff, 0x80, 0x2, 0x0, 0x7, 0x80, 0x2,
    0x0, 0x7, 0x80, 0x2, 0x0, 0x7, 0x80, 0x2,
    0x0, 0x7, 0x80, 0x6, 0x0, 0x7, 0x80, 0x6,
    0x0, 0x7, 0x80, 0x6, 0x0, 0x7, 0x80, 0xe,
    0x0, 0x7, 0xff, 0xfe, 0x0, 0x7, 0xff, 0xfe,
    0x0, 0x3, 0xff, 0xfc,

    /* U+4EB5 "亵" */
    0x0, 0x1, 0x80, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1c, 0x0,
    0x0, 0x0, 0x6, 0x0, 0x3, 0xff, 0xff, 0xff,
    0xfd, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe0, 0x3c, 0x0, 0x0, 0x70, 0x1e,
    0x0, 0x0, 0x38, 0xf, 0x1c, 0x0, 0x1c, 0x7,
    0x8e, 0x3, 0xff, 0xc3, 0xc7, 0x1, 0xff, 0xef,
    0xff, 0x80, 0x3, 0x80, 0xf1, 0xc0, 0x1, 0xc0,
    0x78, 0xe0, 0x0, 0xe6, 0x38, 0x70, 0x0, 0x7e,
    0x5c, 0x38, 0x0, 0x3c, 0x3e, 0x1c, 0x87, 0xfc,
    0xf, 0xe, 0x43, 0xfe, 0x3, 0xc7, 0xa1, 0xf7,
    0x3, 0xfb, 0xd0, 0x43, 0x81, 0xbc, 0xf8, 0x1,
    0xc1, 0x8e, 0x7e, 0x0, 0xe0, 0x83, 0x1f, 0x0,
    0x70, 0xc0, 0xf, 0x80, 0xf0, 0xc4, 0x3, 0xc1,
    0xf1, 0xf2, 0x0, 0x60, 0x0, 0xf1, 0x0, 0x0,
    0x0, 0xf8, 0x80, 0xc0, 0x0, 0x78, 0x40, 0xe0,
    0x0, 0x7c, 0x30, 0x60, 0x0, 0x3c, 0x18, 0x60,
    0x0, 0x3e, 0x6, 0x60, 0x0, 0x3f, 0x3, 0x60,
    0x0, 0x1f, 0x81, 0xe0, 0x0, 0x1d, 0xc0, 0x70,
    0x0, 0x18, 0xe0, 0x3e, 0x0, 0x38, 0x70, 0xf,
    0x80, 0x38, 0x38, 0x67, 0xf8, 0x30, 0x1c, 0xe1,
    0xff, 0xe0, 0xf, 0xe0, 0x7f, 0x80, 0x3f, 0xc0,
    0x1f, 0xc0, 0x1f, 0xc0, 0x3, 0xe0, 0xf, 0x80,
    0x0, 0x70, 0x7, 0x0, 0x0, 0x0,

    /* U+4EB6 "亶" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x0, 0xc0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0x7f, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x78, 0x1f, 0xff, 0xff, 0xf8,
    0x1f, 0xff, 0xff, 0xf8, 0x1e, 0x0, 0x0, 0x78,
    0x1e, 0x38, 0x1c, 0x78, 0x1e, 0x3f, 0xfc, 0x78,
    0x1e, 0x3f, 0xfc, 0x78, 0x1e, 0x38, 0x1c, 0x78,
    0x1e, 0x38, 0x1c, 0x78, 0x1e, 0x38, 0x1c, 0x78,
    0x1e, 0x3f, 0xfc, 0x78, 0x1e, 0x3f, 0xfc, 0x78,
    0x1e, 0x38, 0x1c, 0x78, 0x1e, 0x0, 0x0, 0x78,
    0x1e, 0x0, 0x0, 0x78, 0x1f, 0xff, 0xff, 0xf8,
    0x1f, 0xff, 0xff, 0xf8, 0x1e, 0x0, 0x0, 0x78,
    0x3, 0xc0, 0x1, 0xc0, 0x3, 0xff, 0xff, 0xc0,
    0x3, 0xff, 0xff, 0xc0, 0x3, 0xc0, 0x1, 0xc0,
    0x3, 0xc0, 0x1, 0xc0, 0x3, 0xc0, 0x1, 0xc0,
    0x3, 0xff, 0xf9, 0xc0, 0x3, 0xff, 0xf9, 0xc0,
    0x3, 0xc0, 0x1, 0xc0, 0x3, 0xc0, 0x1, 0xc0,
    0x3, 0xc0, 0x1, 0xc0, 0x3, 0xc0, 0x1, 0xc0,
    0x3, 0xff, 0xff, 0xc0, 0x3, 0xff, 0xff, 0xc0,
    0x3, 0xc0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+4EBA "人" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x7, 0x30, 0x0,
    0x0, 0x7, 0x30, 0x0, 0x0, 0xf, 0x38, 0x0,
    0x0, 0xe, 0x38, 0x0, 0x0, 0xe, 0x3c, 0x0,
    0x0, 0x1c, 0x1c, 0x0, 0x0, 0x1c, 0x1e, 0x0,
    0x0, 0x38, 0xf, 0x0, 0x0, 0x70, 0xf, 0x80,
    0x0, 0x60, 0x7, 0xc0, 0x0, 0xe0, 0x7, 0xe0,
    0x1, 0xc0, 0x3, 0xf0, 0x3, 0x80, 0x3, 0xfc,
    0x7, 0x0, 0x1, 0xff, 0x6, 0x0, 0x0, 0xfe,
    0xc, 0x0, 0x0, 0x7e, 0x18, 0x0, 0x0, 0x3e,
    0x60, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x6,

    /* U+4EBB "亻" */
    0x3, 0xe0, 0x7c, 0xf, 0x1, 0xe0, 0x3c, 0x7,
    0x80, 0xf0, 0x3c, 0x7, 0x80, 0xf0, 0x1c, 0x3,
    0x80, 0xe0, 0x1f, 0x3, 0xe0, 0x7c, 0x1f, 0x83,
    0xf0, 0xde, 0x1b, 0xc2, 0x78, 0xcf, 0x11, 0xe0,
    0x3c, 0x7, 0x80, 0xf0, 0x1e, 0x3, 0xc0, 0x78,
    0xf, 0x1, 0xe0, 0x3c, 0x7, 0x80, 0xf0, 0x1e,
    0x3, 0xc0, 0x78, 0xf, 0x1, 0xe0, 0x3c, 0x7,
    0x80, 0xf0, 0x1e, 0x3, 0xc0, 0x78, 0xf, 0x0,

    /* U+4EBF "亿" */
    0x1, 0xf0, 0x0, 0x2, 0x1, 0xf0, 0x0, 0x2,
    0x3, 0xf0, 0x0, 0x6, 0x3, 0xe3, 0xff, 0xfe,
    0x3, 0xe3, 0xff, 0xfe, 0x3, 0xe0, 0x0, 0x3e,
    0x3, 0xe0, 0x0, 0x7c, 0x3, 0xc0, 0x0, 0x78,
    0x3, 0xc0, 0x0, 0xf8, 0x7, 0x80, 0x0, 0xf0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x0, 0x1, 0xe0,
    0x7, 0x0, 0x3, 0xc0, 0xf, 0x80, 0x3, 0xc0,
    0xf, 0x80, 0x3, 0x80, 0xf, 0x80, 0x7, 0x80,
    0x1f, 0x80, 0x7, 0x0, 0x1f, 0x80, 0xf, 0x0,
    0x37, 0x80, 0xe, 0x0, 0x37, 0x80, 0x1e, 0x0,
    0x27, 0x80, 0x1c, 0x0, 0x47, 0x80, 0x3c, 0x0,
    0x47, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x38, 0x0,
    0x7, 0x80, 0x78, 0x0, 0x7, 0x80, 0x70, 0x0,
    0x7, 0x80, 0xf0, 0x0, 0x7, 0x80, 0xf0, 0x0,
    0x7, 0x80, 0xe0, 0x0, 0x7, 0x81, 0xe0, 0x0,
    0x7, 0x81, 0xe0, 0x0, 0x7, 0x81, 0xc0, 0x2,
    0x7, 0x83, 0xc0, 0x2, 0x7, 0x83, 0xc0, 0x2,
    0x7, 0x83, 0x80, 0x2, 0x7, 0x87, 0x80, 0x2,
    0x7, 0x87, 0x80, 0x2, 0x7, 0x87, 0x80, 0x6,
    0x7, 0x87, 0x0, 0x7, 0x7, 0x87, 0x0, 0x7,
    0x7, 0x87, 0x0, 0x7, 0x7, 0x87, 0x80, 0xf,
    0x7, 0x87, 0xff, 0xff, 0x7, 0x83, 0xff, 0xff,
    0x7, 0x81, 0xff, 0xfe, 0x7, 0x80, 0x7f, 0xfc,

    /* U+4EC0 "什" */
    0x0, 0xf8, 0xf, 0x0, 0x0, 0x78, 0x7, 0x80,
    0x0, 0x3c, 0x3, 0xc0, 0x0, 0x1e, 0x1, 0xe0,
    0x0, 0xf, 0x0, 0xf0, 0x0, 0x7, 0x80, 0x78,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x3, 0xc0, 0x1e,
    0x0, 0x1, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0x7,
    0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1,
    0xe0, 0x0, 0x38, 0x0, 0xf0, 0x0, 0x3e, 0x0,
    0x78, 0x0, 0x1f, 0x3f, 0xff, 0xfe, 0xf, 0x9f,
    0xff, 0xff, 0xf, 0xc0, 0xf, 0x0, 0x7, 0xe0,
    0x7, 0x80, 0x6, 0xf0, 0x3, 0xc0, 0x2, 0x78,
    0x1, 0xe0, 0x3, 0x3c, 0x0, 0xf0, 0x3, 0x1e,
    0x0, 0x78, 0x1, 0xf, 0x0, 0x3c, 0x0, 0x7,
    0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0, 0x1,
    0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0,
    0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x1, 0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0,
    0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x1, 0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3,
    0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0,
    0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0,

    /* U+4EC1 "仁" */
    0x1, 0xf0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe3, 0xff, 0xfe,
    0x1, 0xe3, 0xff, 0xfe, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x0, 0xf, 0xc0, 0x0, 0x0,
    0xb, 0xc0, 0x0, 0x0, 0x1b, 0xc0, 0x0, 0x0,
    0x33, 0xc0, 0x0, 0x0, 0x23, 0xc0, 0x0, 0x0,
    0x63, 0xc0, 0x0, 0x0, 0xc3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xdf, 0xff, 0xff, 0x3, 0xdf, 0xff, 0xff,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,

    /* U+4EC2 "仂" */
    0x3, 0xc0, 0xf0, 0x0, 0xf, 0x3, 0xc0, 0x0,
    0x3c, 0xf, 0x0, 0x0, 0xf0, 0x3c, 0x0, 0x3,
    0xc0, 0xf0, 0x0, 0x1e, 0x3, 0xc0, 0x0, 0x78,
    0xf, 0x0, 0x1, 0xe0, 0x3c, 0xf, 0x7, 0x0,
    0xf0, 0x3c, 0x1c, 0x3, 0xc0, 0xf0, 0xf1, 0xff,
    0xff, 0xc3, 0x87, 0xff, 0xff, 0xe, 0x0, 0xf0,
    0x3c, 0x3c, 0x3, 0xc0, 0xf1, 0xf0, 0xf, 0x3,
    0xc7, 0xc0, 0x3c, 0xf, 0x1f, 0x0, 0xf0, 0x3c,
    0xfc, 0x3, 0xc0, 0xf3, 0x70, 0xf, 0x3, 0xd9,
    0xc0, 0x3c, 0xf, 0x67, 0x0, 0xf0, 0x3d, 0x1c,
    0x3, 0xc0, 0xfc, 0x70, 0xf, 0x3, 0xc1, 0xc0,
    0x3c, 0xf, 0x7, 0x0, 0xf0, 0x3c, 0x1c, 0x3,
    0xc0, 0xf0, 0x70, 0xf, 0x3, 0xc1, 0xc0, 0x3c,
    0xf, 0x7, 0x0, 0xf0, 0x3c, 0x1c, 0x3, 0xc0,
    0xf0, 0x70, 0x1e, 0x3, 0xc1, 0xc0, 0x78, 0xf,
    0x7, 0x1, 0xe0, 0x3c, 0x1c, 0x7, 0x0, 0xf0,
    0x70, 0x1c, 0x3, 0xc1, 0xc0, 0xe0, 0xf, 0x7,
    0x3, 0x80, 0x3c, 0x1c, 0xc, 0x0, 0xf0, 0x70,
    0x30, 0x3, 0xc1, 0xc1, 0x80, 0xf, 0x7, 0x6,
    0x0, 0x3c, 0x1c, 0x30, 0x0, 0xf0, 0x70, 0x80,
    0x7, 0xc1, 0xc6, 0x0, 0x3e, 0x7, 0x10, 0x3,
    0xe0, 0x1c, 0x80, 0x72, 0x0,

    /* U+4EC3 "仃" */
    0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x3, 0xcf, 0xff, 0xff,
    0x3, 0xcf, 0xff, 0xff, 0x3, 0xc0, 0x7, 0x80,
    0x3, 0xc0, 0x7, 0x80, 0x3, 0xc0, 0x7, 0x80,
    0x3, 0xc0, 0x7, 0x80, 0x3, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x0, 0x7, 0x80,
    0x7, 0x0, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0xf, 0x80, 0x7, 0x80, 0xf, 0x80, 0x7, 0x80,
    0x1f, 0x80, 0x7, 0x80, 0x1f, 0x80, 0x7, 0x80,
    0x1f, 0x80, 0x7, 0x80, 0x37, 0x80, 0x7, 0x80,
    0x27, 0x80, 0x7, 0x80, 0x67, 0x80, 0x7, 0x80,
    0x47, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0x7, 0x80,
    0x7, 0x80, 0xf, 0x80, 0x7, 0x80, 0x3e, 0x0,
    0x7, 0x80, 0xfc, 0x0, 0x0, 0x1, 0x30, 0x0,

    /* U+4EC4 "仄" */
    0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff,
    0xf0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78,
    0x0, 0xf, 0x0, 0x3c, 0x0, 0x7, 0x80, 0x1e,
    0x0, 0x3, 0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7,
    0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1,
    0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e, 0x0,
    0x78, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x7, 0x80,
    0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0, 0x1, 0xe0,
    0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78,
    0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e,
    0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x7,
    0x80, 0x3e, 0x0, 0x3, 0xc0, 0x1e, 0x80, 0x1,
    0xe0, 0xf, 0x40, 0x0, 0xf0, 0x7, 0xa0, 0x0,
    0x70, 0x3, 0xd8, 0x0, 0x38, 0x3, 0xcc, 0x0,
    0x1c, 0x1, 0xe2, 0x0, 0xe, 0x0, 0xe1, 0x80,
    0x7, 0x0, 0xf0, 0xe0, 0x7, 0x0, 0x70, 0x70,
    0x3, 0x80, 0x78, 0x1c, 0x1, 0xc0, 0x38, 0xf,
    0x0, 0xc0, 0x38, 0x3, 0xc0, 0x60, 0x18, 0x1,
    0xf8, 0x30, 0x18, 0x0, 0x7e, 0x30, 0x18, 0x0,
    0x3f, 0x18, 0x18, 0x0, 0xf, 0x8, 0x18, 0x0,
    0x3, 0x8c, 0x18, 0x0, 0x1, 0xc6, 0x18, 0x0,
    0x0, 0x62, 0x18, 0x0, 0x0, 0x10,

    /* U+4EC5 "仅" */
    0x3, 0xe0, 0x0, 0xf0, 0x7, 0xc0, 0x1, 0xe0,
    0xf, 0x80, 0x3, 0xc0, 0x1e, 0x7f, 0xff, 0x80,
    0x3c, 0xff, 0xff, 0x0, 0x78, 0xc0, 0x1e, 0x0,
    0xf1, 0x80, 0x3c, 0x3, 0xc3, 0x0, 0x78, 0x7,
    0x86, 0x0, 0xf0, 0xf, 0xc, 0x1, 0xe0, 0x1c,
    0x18, 0x3, 0xc0, 0x38, 0x30, 0x7, 0x80, 0x70,
    0x60, 0xf, 0x1, 0xe0, 0xc0, 0x1e, 0x3, 0xc1,
    0x80, 0x3c, 0x7, 0x83, 0x0, 0x78, 0x1f, 0x7,
    0x0, 0xf0, 0x3e, 0xe, 0x1, 0xe0, 0xfc, 0xc,
    0x3, 0xc1, 0x78, 0x18, 0x7, 0x2, 0xf0, 0x30,
    0x1e, 0x9, 0xe0, 0x60, 0x3c, 0x33, 0xc0, 0xc0,
    0x78, 0x7, 0x81, 0xc0, 0xe0, 0xf, 0x3, 0x81,
    0xc0, 0x1e, 0x3, 0x7, 0x80, 0x3c, 0x6, 0xe,
    0x0, 0x78, 0xe, 0x1c, 0x0, 0xf0, 0x1c, 0x78,
    0x1, 0xe0, 0x1c, 0xe0, 0x3, 0xc0, 0x39, 0xc0,
    0x7, 0x80, 0x7f, 0x0, 0xf, 0x0, 0x7e, 0x0,
    0x1e, 0x0, 0xf8, 0x0, 0x3c, 0x1, 0xf0, 0x0,
    0x78, 0x1, 0xf0, 0x0, 0xf0, 0x7, 0xf0, 0x1,
    0xe0, 0xd, 0xf8, 0x3, 0xc0, 0x33, 0xf8, 0x7,
    0x80, 0xc3, 0xfc, 0xf, 0x1, 0x3, 0xfe, 0x1e,
    0x4, 0x3, 0xfc, 0x3c, 0x10, 0x1, 0xf0, 0x78,
    0x40, 0x1, 0xe0, 0xf1, 0x0, 0x1, 0xc1, 0xe4,
    0x0, 0x0, 0x80,

    /* U+4EC6 "仆" */
    0x0, 0x78, 0xf, 0x0, 0x0, 0x7c, 0x7, 0x80,
    0x0, 0x3e, 0x3, 0xc0, 0x0, 0x1f, 0x1, 0xe0,
    0x0, 0xf, 0x0, 0xf0, 0x0, 0x7, 0x80, 0x78,
    0x0, 0x3, 0x80, 0x3c, 0x0, 0x3, 0xc0, 0x1e,
    0x0, 0x1, 0xe0, 0xf, 0x40, 0x0, 0xe0, 0x7,
    0xb0, 0x0, 0xf0, 0x3, 0xd8, 0x0, 0x70, 0x1,
    0xec, 0x0, 0x38, 0x0, 0xf6, 0x0, 0x3f, 0x0,
    0x7b, 0x0, 0x1f, 0x80, 0x3c, 0xc0, 0xf, 0xc0,
    0x1e, 0x60, 0xd, 0xe0, 0xf, 0x30, 0x4, 0xf0,
    0x7, 0x9c, 0x6, 0x78, 0x3, 0xce, 0x6, 0x3c,
    0x1, 0xe7, 0x2, 0x1e, 0x0, 0xf3, 0xc2, 0xf,
    0x0, 0x79, 0xf0, 0x7, 0x80, 0x3c, 0x78, 0x3,
    0xc0, 0x1e, 0x3e, 0x1, 0xe0, 0xf, 0x1f, 0x80,
    0xf0, 0x7, 0x87, 0x80, 0x78, 0x3, 0xc3, 0xc0,
    0x3c, 0x1, 0xe1, 0xe0, 0x1e, 0x0, 0xf0, 0x70,
    0xf, 0x0, 0x78, 0x18, 0x7, 0x80, 0x3c, 0x4,
    0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0xf, 0x0, 0x78, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0, 0xf,
    0x0, 0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3,
    0xc0, 0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0,
    0xf0, 0x0, 0xf, 0x0, 0x78, 0x0,

    /* U+4EC7 "仇" */
    0x3, 0xe0, 0xf0, 0x0, 0x1, 0xf0, 0x78, 0x0,
    0x0, 0xf8, 0x3c, 0x0, 0x0, 0x7c, 0x1e, 0x0,
    0x0, 0x3e, 0xf, 0x0, 0x0, 0x1e, 0x7, 0x80,
    0x0, 0xf, 0x3, 0xc0, 0x0, 0xf, 0x81, 0xe0,
    0x0, 0x7, 0x80, 0xf0, 0x0, 0x3, 0xc0, 0x78,
    0x78, 0x1, 0xe0, 0x3c, 0x3c, 0x0, 0xe0, 0x1e,
    0x1e, 0x0, 0xf1, 0xff, 0xff, 0x0, 0x7c, 0xff,
    0xff, 0x80, 0x3e, 0x3, 0xc3, 0xc0, 0x3f, 0x1,
    0xe1, 0xe0, 0x1f, 0x80, 0xf0, 0xf0, 0xb, 0xc0,
    0x78, 0x78, 0xd, 0xe0, 0x3c, 0x3c, 0x4, 0xf0,
    0x1e, 0x1e, 0x6, 0x78, 0xf, 0xf, 0x2, 0x3c,
    0x7, 0x87, 0x80, 0x1e, 0x3, 0xc3, 0xc0, 0xf,
    0x1, 0xe1, 0xe0, 0x7, 0x80, 0xf0, 0xf0, 0x3,
    0xc0, 0x78, 0x78, 0x1, 0xe0, 0x3c, 0x3c, 0x0,
    0xf0, 0x1e, 0x1e, 0x0, 0x78, 0xf, 0xf, 0x0,
    0x3c, 0x7, 0x7, 0x80, 0x1e, 0x3, 0x83, 0xc0,
    0xf, 0x1, 0xc1, 0xe0, 0x7, 0x81, 0xe0, 0xf0,
    0x3, 0xc0, 0xe0, 0x78, 0x81, 0xe0, 0x70, 0x3c,
    0x40, 0xf0, 0x38, 0x1e, 0x20, 0x78, 0x18, 0xf,
    0x10, 0x3c, 0x1c, 0x7, 0x88, 0x1e, 0xc, 0x3,
    0xc4, 0xf, 0x6, 0x1, 0xe3, 0x7, 0x86, 0x0,
    0xf1, 0x83, 0xc2, 0x0, 0x79, 0xc1, 0xe2, 0x0,
    0x3c, 0xe0, 0xf1, 0x0, 0x1f, 0xf0, 0x79, 0x0,
    0xf, 0xf0, 0x3d, 0x0, 0x3, 0xf0,

    /* U+4EC8 "仈" */
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x1e, 0x10, 0x0, 0x1e, 0xf, 0x8,
    0x0, 0x1e, 0x7, 0x84, 0x0, 0xf, 0x3, 0xc6,
    0x0, 0x7, 0x81, 0xe3, 0x0, 0x3, 0x80, 0xf1,
    0x80, 0x1, 0xc0, 0x78, 0xc0, 0x1, 0xe0, 0x3c,
    0x60, 0x0, 0xe0, 0x1e, 0x30, 0x0, 0x70, 0xf,
    0x18, 0x0, 0x7c, 0x7, 0x8c, 0x0, 0x3e, 0x3,
    0xc6, 0x0, 0x1f, 0x1, 0xe3, 0x0, 0x1f, 0x80,
    0xf1, 0x80, 0xf, 0xc0, 0x78, 0xc0, 0xd, 0xe0,
    0x3c, 0x60, 0x4, 0xf0, 0x1e, 0x30, 0x6, 0x78,
    0xf, 0x18, 0x2, 0x3c, 0x7, 0x8c, 0x2, 0x1e,
    0x3, 0xc7, 0x3, 0xf, 0x1, 0xe3, 0x80, 0x7,
    0x80, 0xf1, 0xc0, 0x3, 0xc0, 0x78, 0xe0, 0x1,
    0xe0, 0x38, 0x70, 0x0, 0xf0, 0x1c, 0x38, 0x0,
    0x78, 0xe, 0x1e, 0x0, 0x3c, 0x7, 0xf, 0x0,
    0x1e, 0x7, 0x87, 0x80, 0xf, 0x3, 0x83, 0xc0,
    0x7, 0x81, 0xc0, 0xf0, 0x3, 0xc0, 0xe0, 0x78,
    0x1, 0xe0, 0x60, 0x3c, 0x0, 0xf0, 0x30, 0x1f,
    0x0, 0x78, 0x38, 0xf, 0x80, 0x3c, 0x18, 0x3,
    0xe0, 0x1e, 0xc, 0x1, 0xf8, 0xf, 0xc, 0x0,
    0xfc, 0x7, 0x86, 0x0, 0x3f, 0x3, 0xc6, 0x0,
    0x1f, 0x1, 0xe2, 0x0, 0x7, 0x80, 0xf3, 0x0,
    0x3, 0xc0, 0x79, 0x0, 0x0, 0xe0, 0x3d, 0x0,
    0x0, 0x30, 0x1f, 0x80, 0x0, 0x8,

    /* U+4EC9 "仉" */
    0x3, 0x83, 0xc3, 0xc0, 0x7, 0x7, 0x87, 0x80,
    0xe, 0xf, 0xff, 0x0, 0x1c, 0x1f, 0xfe, 0x0,
    0x78, 0x3c, 0x3c, 0x0, 0xf0, 0x78, 0x78, 0x1,
    0xc0, 0xf0, 0xf0, 0x3, 0x81, 0xe1, 0xe0, 0x7,
    0x3, 0xc3, 0xc0, 0xc, 0x7, 0x87, 0x80, 0x38,
    0xf, 0xf, 0x0, 0x70, 0x1e, 0x1e, 0x0, 0xf0,
    0x3c, 0x3c, 0x1, 0xe0, 0x78, 0x78, 0x7, 0xc0,
    0xf0, 0xf0, 0xf, 0x81, 0xe1, 0xe0, 0x3f, 0x3,
    0xc3, 0xc0, 0x6e, 0x7, 0x87, 0x80, 0x9c, 0xf,
    0xf, 0x3, 0x38, 0x1e, 0x1e, 0x4, 0x70, 0x3c,
    0x3c, 0x0, 0xe0, 0x78, 0x78, 0x1, 0xc0, 0xf0,
    0xf0, 0x3, 0x81, 0xe1, 0xe0, 0x7, 0x3, 0xc3,
    0xc0, 0xe, 0x7, 0x87, 0x80, 0x1c, 0xf, 0xf,
    0x0, 0x38, 0x1e, 0x1e, 0x20, 0x70, 0x3c, 0x3c,
    0x40, 0xe0, 0x78, 0x78, 0x81, 0xc0, 0xe0, 0xf1,
    0x3, 0x81, 0xc1, 0xe2, 0x7, 0x3, 0x83, 0xc4,
    0xe, 0xf, 0x7, 0x88, 0x1c, 0x1e, 0xf, 0x10,
    0x38, 0x38, 0x1e, 0x20, 0x70, 0x70, 0x3c, 0x60,
    0xe1, 0xe0, 0x79, 0xc1, 0xc3, 0x80, 0xf3, 0x83,
    0x87, 0x1, 0xe7, 0x7, 0x1c, 0x3, 0xfe, 0xe,
    0x30, 0x7, 0xfc, 0x1c, 0xe0, 0xf, 0xf8, 0x39,
    0x80, 0xf, 0xe0, 0x6, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0,

    /* U+4ECA "今" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x0, 0x7a, 0x0, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0x0, 0x3c, 0xc0, 0x0, 0x0, 0x3c, 0x30,
    0x0, 0x0, 0x1e, 0x18, 0x0, 0x0, 0x1e, 0x6,
    0x0, 0x0, 0xe, 0x3, 0x80, 0x0, 0xf, 0x1,
    0xe0, 0x0, 0xf, 0x0, 0x78, 0x0, 0x7, 0x0,
    0x1e, 0x0, 0x7, 0x10, 0xf, 0x80, 0x7, 0x6,
    0x3, 0xf0, 0x3, 0x3, 0x80, 0xfe, 0x3, 0x1,
    0xe0, 0x7f, 0x83, 0x0, 0x78, 0x1f, 0xc3, 0x0,
    0x3c, 0x3, 0xe3, 0x0, 0xe, 0x0, 0xf3, 0x0,
    0x6, 0x0, 0x3b, 0x0, 0x1, 0x0, 0x4, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xe0, 0x3, 0xff, 0xff, 0xf0, 0x1,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x70,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x38,
    0x0, 0x0, 0x0, 0x38, 0x0, 0x0, 0x0, 0x1c,
    0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x1c,
    0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x8,
    0x0, 0x0, 0x0, 0x8, 0x0, 0x0,

    /* U+4ECB "介" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf, 0xc0, 0x0, 0x0, 0xf, 0xa0, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0x0, 0x1f, 0x30, 0x0,
    0x0, 0x1f, 0x30, 0x0, 0x0, 0x1e, 0x18, 0x0,
    0x0, 0x3e, 0x1c, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x78, 0xf, 0x0, 0x0, 0xf8, 0xf, 0x80,
    0x0, 0xf0, 0x7, 0xe0, 0x1, 0xe0, 0x3, 0xf8,
    0x3, 0xc0, 0x3, 0xfe, 0x7, 0x80, 0x1, 0xff,
    0xe, 0xf0, 0xf, 0xfe, 0x1c, 0xf0, 0xf, 0x7e,
    0x38, 0xf0, 0xf, 0x1e, 0x60, 0xf0, 0xf, 0xe,
    0xc0, 0xf0, 0xf, 0x1, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xe0, 0xf, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x1, 0xe0, 0xf, 0x0, 0x1, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0x80, 0xf, 0x0,
    0x7, 0x0, 0xf, 0x0, 0x6, 0x0, 0xf, 0x0,
    0xe, 0x0, 0xf, 0x0, 0xc, 0x0, 0xf, 0x0,
    0x18, 0x0, 0xf, 0x0, 0x30, 0x0, 0xf, 0x0,

    /* U+4ECD "仍" */
    0x3, 0xe0, 0x0, 0xf0, 0x3, 0xe0, 0x0, 0xf0,
    0x3, 0xe0, 0x0, 0xf0, 0x3, 0xcf, 0xff, 0xf0,
    0x3, 0xcf, 0xff, 0xf0, 0x3, 0xc3, 0xc0, 0xf0,
    0x3, 0xc3, 0xc0, 0xe0, 0x3, 0x83, 0xc0, 0xe0,
    0x7, 0x83, 0xc0, 0xe0, 0x7, 0x3, 0xc0, 0xe0,
    0x7, 0x3, 0xc1, 0xc0, 0xf, 0x3, 0xc1, 0xc0,
    0xe, 0x3, 0xc1, 0x80, 0xf, 0x83, 0xc3, 0x0,
    0x1f, 0x83, 0xc2, 0x1e, 0x1f, 0x83, 0xc4, 0x1e,
    0x37, 0x83, 0xcf, 0xfe, 0x27, 0x83, 0xcc, 0x1e,
    0x67, 0x83, 0xc8, 0x1e, 0x47, 0x83, 0xc0, 0x1e,
    0x87, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0x80, 0x1e,
    0x7, 0x83, 0x80, 0x1e, 0x7, 0x83, 0x80, 0x1e,
    0x7, 0x87, 0x0, 0x1e, 0x7, 0x87, 0x0, 0x1e,
    0x7, 0x86, 0x0, 0x1e, 0x7, 0x8e, 0x0, 0x1e,
    0x7, 0x8c, 0x0, 0x1e, 0x7, 0x8c, 0x0, 0x1e,
    0x7, 0x98, 0x0, 0x3c, 0x7, 0x90, 0x0, 0xf8,
    0x7, 0xa0, 0x3, 0xf0, 0x7, 0x80, 0xe, 0x40,

    /* U+4ECE "从" */
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x7, 0xe0, 0xf, 0x0, 0x7, 0xa0, 0xf, 0x0,
    0x7, 0xb0, 0xf, 0x80, 0x7, 0xb8, 0x1e, 0x80,
    0x7, 0x9c, 0x1c, 0x80, 0x7, 0x1e, 0x1c, 0xc0,
    0x7, 0x1f, 0x18, 0xc0, 0x6, 0xf, 0x38, 0xe0,
    0xe, 0xf, 0x30, 0x70, 0xc, 0x7, 0x30, 0x78,
    0xc, 0x6, 0x60, 0x7c, 0x18, 0x2, 0x40, 0x3e,
    0x18, 0x0, 0xc0, 0x3f, 0x30, 0x0, 0x80, 0x1e,
    0x20, 0x1, 0x0, 0x1e, 0x60, 0x2, 0x0, 0xe,
    0x40, 0x4, 0x0, 0x6, 0x80, 0x8, 0x0, 0x2,

    /* U+4ED1 "仑" */
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x1, 0xf4, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x79, 0x80,
    0x0, 0x0, 0x78, 0x40, 0x0, 0x0, 0x3c, 0x30,
    0x0, 0x0, 0x3c, 0x1c, 0x0, 0x0, 0x1e, 0x7,
    0x0, 0x0, 0x1e, 0x3, 0x80, 0x0, 0xe, 0x0,
    0xf0, 0x0, 0xe, 0x0, 0x7c, 0x0, 0xe, 0x0,
    0x1f, 0x0, 0x6, 0x0, 0x7, 0xe0, 0x7, 0xf0,
    0x3, 0xfc, 0x7, 0x78, 0x0, 0xff, 0x7, 0x3c,
    0x0, 0x3f, 0x83, 0x1e, 0x0, 0xf, 0xc3, 0xf,
    0x0, 0x3, 0xc3, 0x7, 0x80, 0x8, 0x63, 0x3,
    0xc0, 0xe, 0x13, 0x1, 0xe0, 0xe, 0x0, 0x0,
    0xf0, 0xe, 0x0, 0x0, 0x78, 0xe, 0x0, 0x0,
    0x3c, 0xc, 0x0, 0x0, 0x1e, 0x1c, 0x0, 0x0,
    0xf, 0x1c, 0x0, 0x0, 0x7, 0x9c, 0x0, 0x0,
    0x3, 0xdc, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0x0, 0xfc, 0x0, 0x0, 0x0, 0x78, 0x0, 0x8,
    0x0, 0x3c, 0x0, 0x4, 0x0, 0x1e, 0x0, 0x2,
    0x0, 0xf, 0x0, 0x1, 0x0, 0x7, 0x80, 0x0,
    0x80, 0x3, 0xc0, 0x0, 0xc0, 0x1, 0xe0, 0x0,
    0x60, 0x0, 0xf0, 0x0, 0x38, 0x0, 0x78, 0x0,
    0x1c, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x1f, 0xff,
    0xfe, 0x0, 0xf, 0xff, 0xff, 0x0, 0x3, 0xff,
    0xff, 0x80, 0x0, 0xff, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0,

    /* U+4ED3 "仓" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x1e, 0x80,
    0x0, 0x0, 0xf, 0xb0, 0x0, 0x0, 0x3, 0xc6,
    0x0, 0x0, 0x1, 0xf1, 0x80, 0x0, 0x0, 0x78,
    0x70, 0x0, 0x0, 0x1c, 0xe, 0x0, 0x0, 0xe,
    0x3, 0xc0, 0x0, 0x7, 0x80, 0x78, 0x0, 0x1,
    0xc0, 0x1f, 0x80, 0x0, 0xe0, 0x3, 0xf0, 0x0,
    0x70, 0x0, 0x7f, 0x0, 0x18, 0x0, 0xf, 0xf8,
    0xc, 0x0, 0x1, 0xfe, 0x6, 0x0, 0x0, 0x3f,
    0x3, 0x78, 0x0, 0xff, 0xc1, 0x9f, 0xff, 0xfd,
    0xf0, 0xc7, 0xff, 0xff, 0x1c, 0x61, 0xe0, 0x3,
    0xc3, 0x20, 0x78, 0x0, 0xf0, 0x0, 0x1e, 0x0,
    0x3c, 0x0, 0x7, 0x80, 0xf, 0x0, 0x1, 0xe0,
    0x3, 0xc0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0x1e,
    0x0, 0x3c, 0x0, 0x7, 0x80, 0xf, 0x0, 0x1,
    0xe0, 0x3, 0xc0, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0x1e, 0x0, 0x7c, 0x0, 0x7, 0x80, 0x3e, 0x0,
    0x1, 0xe0, 0x7f, 0x8, 0x0, 0x78, 0x26, 0x2,
    0x0, 0x1e, 0x0, 0x0, 0x80, 0x7, 0x80, 0x0,
    0x20, 0x1, 0xe0, 0x0, 0x8, 0x0, 0x78, 0x0,
    0x2, 0x0, 0x1e, 0x0, 0x0, 0x80, 0x7, 0x80,
    0x0, 0x30, 0x1, 0xe0, 0x0, 0x1c, 0x0, 0x78,
    0x0, 0x7, 0x0, 0x1e, 0x0, 0x1, 0xc0, 0x7,
    0xff, 0xff, 0xf0, 0x0, 0xff, 0xff, 0xf8, 0x0,
    0x1f, 0xff, 0xfe, 0x0,

    /* U+4ED4 "仔" */
    0x3, 0xf0, 0x0, 0x0, 0x1, 0xf8, 0x0, 0x1,
    0x0, 0xf8, 0x7f, 0xff, 0x80, 0x7c, 0x3f, 0xff,
    0xc0, 0x3e, 0x0, 0x1, 0xc0, 0x1e, 0x0, 0x1,
    0xc0, 0xf, 0x0, 0x1, 0xc0, 0x7, 0x80, 0x0,
    0xc0, 0x7, 0xc0, 0x0, 0xc0, 0x3, 0xc0, 0x0,
    0xc0, 0x1, 0xe0, 0x0, 0xc0, 0x0, 0xe0, 0x0,
    0xc0, 0x0, 0x70, 0x0, 0xc0, 0x0, 0x7e, 0x0,
    0xbc, 0x0, 0x3f, 0x0, 0x1e, 0x0, 0x1f, 0x80,
    0xf, 0x0, 0x1f, 0xc0, 0x7, 0x80, 0xb, 0xe0,
    0x3, 0xc0, 0xd, 0xf0, 0x1, 0xe0, 0x4, 0xf8,
    0x0, 0xf0, 0x4, 0x7c, 0xff, 0xff, 0xfa, 0x3e,
    0x7f, 0xff, 0xfe, 0x1f, 0x0, 0x1e, 0x0, 0xf,
    0x80, 0xf, 0x0, 0x7, 0xc0, 0x7, 0x80, 0x3,
    0xe0, 0x3, 0xc0, 0x1, 0xf0, 0x1, 0xe0, 0x0,
    0xf8, 0x0, 0xf0, 0x0, 0x7c, 0x0, 0x78, 0x0,
    0x3e, 0x0, 0x3c, 0x0, 0x1f, 0x0, 0x1e, 0x0,
    0xf, 0x80, 0xf, 0x0, 0x7, 0xc0, 0x7, 0x80,
    0x3, 0xe0, 0x3, 0xc0, 0x1, 0xf0, 0x1, 0xe0,
    0x0, 0xf8, 0x0, 0xf0, 0x0, 0x7c, 0x0, 0x78,
    0x0, 0x3e, 0x0, 0x3c, 0x0, 0x1f, 0x0, 0x1e,
    0x0, 0xf, 0x80, 0xf, 0x0, 0x7, 0xc0, 0x7,
    0x80, 0x3, 0xe0, 0x3, 0xc0, 0x1, 0xf0, 0x1,
    0xc0, 0x0, 0xf8, 0x1, 0xc0, 0x0, 0x7c, 0x7,
    0xc0, 0x0, 0x3e, 0xf, 0x80, 0x0,

    /* U+4ED5 "仕" */
    0x1, 0xe0, 0xf, 0x0, 0x0, 0xf0, 0x7, 0x80,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x78, 0x1, 0xe0,
    0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78,
    0x0, 0xf, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x1e,
    0x0, 0x7, 0x80, 0xf, 0x0, 0x3, 0xc0, 0x7,
    0x80, 0x1, 0xc0, 0x3, 0xc0, 0x1, 0xe0, 0x1,
    0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x7c, 0x0,
    0x78, 0x0, 0x7e, 0x0, 0x3c, 0x0, 0x3f, 0x0,
    0x1e, 0x0, 0x1f, 0xbf, 0xff, 0xff, 0x9b, 0xdf,
    0xff, 0xff, 0xcd, 0xe0, 0x3, 0xc0, 0xc, 0xf0,
    0x1, 0xe0, 0x6, 0x78, 0x0, 0xf0, 0x2, 0x3c,
    0x0, 0x78, 0x3, 0x1e, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x0, 0x3,
    0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3, 0xc0, 0x0,
    0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0x3c, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3, 0xc0,
    0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0x80, 0x1, 0xe7, 0xff,
    0xff, 0xc0, 0xf3, 0xff, 0xff, 0xe0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,

    /* U+4ED6 "他" */
    0x1, 0xf0, 0xf, 0x0, 0x0, 0x7c, 0x3, 0xc0,
    0x0, 0x1f, 0x0, 0xf0, 0x0, 0x7, 0xc0, 0x3c,
    0x0, 0x1, 0xe0, 0xf, 0x0, 0x0, 0x78, 0x3,
    0xc0, 0x0, 0x1e, 0x78, 0xf0, 0x0, 0xf, 0x1e,
    0x3c, 0x0, 0x3, 0xc7, 0x8f, 0x0, 0x0, 0xf1,
    0xe3, 0xc3, 0xc0, 0x38, 0x78, 0xf0, 0xf0, 0xe,
    0x1e, 0x3c, 0x3c, 0x7, 0x7, 0x8f, 0xf, 0x1,
    0xe1, 0xe3, 0xc3, 0xc0, 0x78, 0x78, 0xff, 0xf0,
    0x1e, 0x1e, 0x3f, 0xfc, 0xf, 0x87, 0xff, 0x8f,
    0x3, 0xe1, 0xff, 0xc3, 0xc1, 0x7b, 0xfc, 0xf0,
    0xf0, 0x5f, 0xfe, 0x3c, 0x3c, 0x27, 0xa7, 0x8f,
    0xf, 0x9, 0xe1, 0xe3, 0xc3, 0xc4, 0x78, 0x78,
    0xf0, 0xf0, 0x1e, 0x1e, 0x3c, 0x3c, 0x7, 0x87,
    0x8f, 0xf, 0x1, 0xe1, 0xe3, 0xc3, 0xc0, 0x78,
    0x78, 0xf0, 0xf0, 0x1e, 0x1e, 0x3c, 0x3c, 0x7,
    0x87, 0x8f, 0xf, 0x1, 0xe1, 0xe3, 0xc3, 0xc0,
    0x78, 0x78, 0xf0, 0xf0, 0x1e, 0x1e, 0x3c, 0x3c,
    0x7, 0x87, 0x8f, 0xe, 0x1, 0xe1, 0xe3, 0xc7,
    0x80, 0x78, 0x78, 0xff, 0xc8, 0x1e, 0x1e, 0x3c,
    0x42, 0x7, 0x87, 0x8f, 0x0, 0x81, 0xe1, 0xe3,
    0xc0, 0x20, 0x78, 0x78, 0xf0, 0x18, 0x1e, 0x1e,
    0x0, 0x6, 0x7, 0x87, 0x80, 0x1, 0xc1, 0xe1,
    0xe0, 0x0, 0x70, 0x78, 0x78, 0x0, 0x1c, 0x1e,
    0x1f, 0xff, 0xff, 0x7, 0x83, 0xff, 0xff, 0xc1,
    0xe0, 0x7f, 0xff, 0xe0,

    /* U+4ED7 "仗" */
    0x1, 0xf0, 0x1, 0xe0, 0x1, 0xf0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xc0, 0x1, 0xe0, 0x3, 0xc0, 0x1, 0xe0,
    0x3, 0xc0, 0x1, 0xe0, 0x3, 0x80, 0x1, 0xe0,
    0x3, 0x9f, 0xff, 0xff, 0x7, 0x9f, 0xff, 0xff,
    0x7, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0xf, 0x81, 0x1, 0xe0, 0xf, 0x81, 0x1, 0xe0,
    0xf, 0x81, 0x1, 0xe0, 0x17, 0x81, 0x1, 0xe0,
    0x17, 0x81, 0x1, 0xe0, 0x27, 0x81, 0x81, 0xe0,
    0x67, 0x81, 0x81, 0xe0, 0x47, 0x81, 0x81, 0xe0,
    0x87, 0x81, 0x81, 0xe0, 0x7, 0x80, 0x81, 0xc0,
    0x7, 0x80, 0xc1, 0xc0, 0x7, 0x80, 0xc1, 0xc0,
    0x7, 0x80, 0xc1, 0xc0, 0x7, 0x80, 0xe3, 0xc0,
    0x7, 0x80, 0x63, 0x80, 0x7, 0x80, 0x73, 0x80,
    0x7, 0x80, 0x73, 0x80, 0x7, 0x80, 0x3f, 0x0,
    0x7, 0x80, 0x3f, 0x0, 0x7, 0x80, 0x1f, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0x1f, 0x80, 0x7, 0x80, 0x37, 0xc0,
    0x7, 0x80, 0x63, 0xe0, 0x7, 0x80, 0xc3, 0xf8,
    0x7, 0x81, 0x81, 0xfe, 0x7, 0x83, 0x0, 0xfe,
    0x7, 0x86, 0x0, 0x7c, 0x7, 0x8c, 0x0, 0x1c,
    0x7, 0x98, 0x0, 0xc, 0x7, 0xa0, 0x0, 0x6,

    /* U+4ED8 "付" */
    0x1, 0xf0, 0x1, 0xe0, 0x0, 0xf8, 0x0, 0xf0,
    0x0, 0x78, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x3c,
    0x0, 0x1e, 0x0, 0x1e, 0x0, 0xf, 0x0, 0xf,
    0x0, 0xf, 0x0, 0x7, 0x80, 0x7, 0x80, 0x3,
    0xc0, 0x3, 0x80, 0x1, 0xe0, 0x1, 0xc0, 0x0,
    0xf0, 0x1, 0xe7, 0xff, 0xff, 0xe0, 0xe3, 0xff,
    0xff, 0xf0, 0x78, 0x0, 0x1e, 0x0, 0x7c, 0x0,
    0xf, 0x0, 0x3e, 0x0, 0x7, 0x80, 0x1f, 0x0,
    0x3, 0xc0, 0x1f, 0x80, 0x1, 0xe0, 0xb, 0xc0,
    0x0, 0xf0, 0xd, 0xe0, 0x0, 0x78, 0x4, 0xf0,
    0x40, 0x3c, 0x4, 0x78, 0x30, 0x1e, 0x6, 0x3c,
    0x18, 0xf, 0x2, 0x1e, 0xe, 0x7, 0x80, 0xf,
    0x7, 0x3, 0xc0, 0x7, 0x83, 0xc1, 0xe0, 0x3,
    0xc0, 0xf0, 0xf0, 0x1, 0xe0, 0x78, 0x78, 0x0,
    0xf0, 0x38, 0x3c, 0x0, 0x78, 0x1c, 0x1e, 0x0,
    0x3c, 0x4, 0xf, 0x0, 0x1e, 0x0, 0x7, 0x80,
    0xf, 0x0, 0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0,
    0x3, 0xc0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0x78, 0x0, 0x1e,
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x1e, 0x0, 0x7,
    0x80, 0xf, 0x0, 0x3, 0xc0, 0x7, 0x80, 0x1,
    0xe0, 0x3, 0xc0, 0x0, 0xf0, 0x1, 0xe0, 0x0,
    0x78, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x78, 0x0,
    0xf8, 0x0, 0x3c, 0x1, 0xf0, 0x0,

    /* U+4ED9 "仙" */
    0x0, 0xf0, 0xf, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x3, 0x80, 0x3c, 0x0, 0x7, 0x0, 0x78, 0x0,
    0x1e, 0x0, 0xf0, 0x0, 0x3c, 0x1, 0xe0, 0x0,
    0x70, 0x3, 0xc0, 0x0, 0xe0, 0x7, 0x80, 0x3,
    0xcf, 0xf, 0x0, 0x7, 0x9e, 0x1e, 0x0, 0xe,
    0x3c, 0x3c, 0x78, 0x1c, 0x78, 0x78, 0xf0, 0x78,
    0xf0, 0xf1, 0xe0, 0xf1, 0xe1, 0xe3, 0xc3, 0xe3,
    0xc3, 0xc7, 0x87, 0xc7, 0x87, 0x8f, 0x1f, 0x8f,
    0xf, 0x1e, 0x3f, 0x1e, 0x1e, 0x3c, 0xde, 0x3c,
    0x3c, 0x79, 0x3c, 0x78, 0x78, 0xf6, 0x78, 0xf0,
    0xf1, 0xf8, 0xf1, 0xe1, 0xe3, 0xc1, 0xe3, 0xc3,
    0xc7, 0x83, 0xc7, 0x87, 0x8f, 0x7, 0x8f, 0xf,
    0x1e, 0xf, 0x1e, 0x1e, 0x3c, 0x1e, 0x3c, 0x3c,
    0x78, 0x3c, 0x78, 0x78, 0xf0, 0x78, 0xf0, 0xf1,
    0xe0, 0xf1, 0xe1, 0xe3, 0xc1, 0xe3, 0xc3, 0xc7,
    0x83, 0xc7, 0x87, 0x8f, 0x7, 0x8f, 0xf, 0x1e,
    0xf, 0x1e, 0x1e, 0x3c, 0x1e, 0x3c, 0x3c, 0x78,
    0x3c, 0x78, 0x78, 0xf0, 0x78, 0xf0, 0xf1, 0xe0,
    0xf1, 0xe1, 0xe3, 0xc1, 0xe3, 0xc3, 0xc7, 0x83,
    0xc7, 0xff, 0xff, 0x7, 0x8f, 0xff, 0xfe, 0xf,
    0x1e, 0x0, 0x3c, 0x1e, 0x3c, 0x0, 0x78, 0x3c,
    0x78, 0x0, 0xf0, 0x78, 0x0, 0x1, 0xe0, 0xf0,
    0x0, 0x3, 0xc0,

    /* U+4EDD "仝" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0xfc, 0x0, 0x0, 0x1, 0xec, 0x0, 0x0,
    0x3, 0xd8, 0x0, 0x0, 0xf, 0x18, 0x0, 0x0,
    0x1e, 0x30, 0x0, 0x0, 0x78, 0x70, 0x0, 0x0,
    0xf0, 0x70, 0x0, 0x3, 0xc0, 0xf0, 0x0, 0x7,
    0x0, 0xf0, 0x0, 0x1c, 0x1, 0xf0, 0x0, 0x78,
    0x1, 0xf8, 0x0, 0xe0, 0x3, 0xfc, 0x3, 0x80,
    0x3, 0xfe, 0xe, 0x0, 0x3, 0xf8, 0x38, 0x0,
    0x3, 0xf0, 0xe0, 0x0, 0x3, 0xe3, 0x0, 0x0,
    0x3, 0xcc, 0x0, 0x0, 0x3, 0xb1, 0xff, 0xff,
    0xf0, 0x83, 0xff, 0xff, 0xe0, 0x0, 0x3, 0x80,
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0xe, 0x0,
    0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x38, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x0, 0x1c, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x70, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x3, 0x80, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x0,
    0x1c, 0x0, 0x3, 0xff, 0xff, 0xff, 0x87, 0xff,
    0xff, 0xff, 0x0,

    /* U+4EDE "仞" */
    0x3, 0xe0, 0x0, 0xf, 0x3, 0xe0, 0x0, 0xf,
    0x3, 0xef, 0xff, 0xff, 0x3, 0xef, 0xff, 0xff,
    0x3, 0xe0, 0x1e, 0xf, 0x3, 0xc0, 0x1e, 0xf,
    0x3, 0xc0, 0x1e, 0xf, 0x7, 0xc0, 0x1e, 0xf,
    0x7, 0x80, 0x1e, 0xf, 0x7, 0x80, 0x1e, 0xf,
    0x7, 0x80, 0x1e, 0xf, 0x7, 0x0, 0x1e, 0xf,
    0x7, 0x7, 0x9e, 0xf, 0xf, 0x87, 0x9e, 0xf,
    0xf, 0x87, 0x9e, 0xf, 0xf, 0x87, 0x9e, 0xf,
    0x1f, 0x87, 0x9e, 0xf, 0x1f, 0x87, 0x9e, 0xf,
    0x37, 0x87, 0x9e, 0xf, 0x37, 0x87, 0x9e, 0xf,
    0x67, 0x87, 0x1e, 0xf, 0x67, 0x87, 0x1e, 0xf,
    0xc7, 0x87, 0x1e, 0xf, 0x7, 0x86, 0x1e, 0xf,
    0x7, 0x8e, 0x1e, 0xf, 0x7, 0x8e, 0x1e, 0xf,
    0x7, 0x8c, 0x1e, 0xf, 0x7, 0x8c, 0x1e, 0xf,
    0x7, 0x88, 0x1e, 0xf, 0x7, 0x90, 0x3c, 0xf,
    0x7, 0x90, 0x3c, 0xf, 0x7, 0x80, 0x3c, 0xf,
    0x7, 0x80, 0x38, 0xf, 0x7, 0x80, 0x78, 0xf,
    0x7, 0x80, 0x70, 0xf, 0x7, 0x80, 0x60, 0xf,
    0x7, 0x80, 0xe0, 0xf, 0x7, 0x80, 0xc0, 0xf,
    0x7, 0x81, 0x80, 0xf, 0x7, 0x81, 0x80, 0xf,
    0x7, 0x83, 0x0, 0xf, 0x7, 0x86, 0x0, 0xf,
    0x7, 0x84, 0x0, 0x1e, 0x7, 0x8c, 0x0, 0x7e,
    0x7, 0x98, 0x1, 0xf8, 0x7, 0xb0, 0x2, 0x20,

    /* U+4EDF "仟" */
    0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x38,
    0x0, 0xf8, 0x0, 0x7f, 0x0, 0x78, 0x1, 0xff,
    0xc0, 0x3c, 0xf, 0xff, 0xc0, 0x1e, 0x7f, 0xf8,
    0x0, 0xf, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x1e,
    0x0, 0x7, 0x80, 0xf, 0x0, 0x3, 0xc0, 0x7,
    0x80, 0x1, 0xc0, 0x3, 0xc0, 0x0, 0xe0, 0x1,
    0xe0, 0x0, 0xe0, 0x0, 0xf0, 0x0, 0x7c, 0x0,
    0x78, 0x0, 0x3e, 0x0, 0x3c, 0x0, 0x1f, 0x0,
    0x1e, 0x0, 0x1f, 0x80, 0xf, 0x0, 0xb, 0xc0,
    0x7, 0x80, 0xd, 0xe0, 0x3, 0xc0, 0x4, 0xf3,
    0xff, 0xff, 0xf4, 0x79, 0xff, 0xff, 0xfa, 0x3c,
    0x0, 0x78, 0x2, 0x1e, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x0, 0x3,
    0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3, 0xc0, 0x0,
    0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0x3c, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3, 0xc0,
    0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3,
    0xc0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0x78, 0x0,

    /* U+4EE1 "仡" */
    0x3, 0xe0, 0xf8, 0x0, 0x3, 0xe0, 0xf8, 0x0,
    0x3, 0xe0, 0xf0, 0x0, 0x3, 0xc0, 0xf0, 0x0,
    0x3, 0xc0, 0xf0, 0x0, 0x3, 0xc0, 0xe0, 0x0,
    0x3, 0xc1, 0xe0, 0x0, 0x3, 0x81, 0xc0, 0x0,
    0x7, 0x81, 0xff, 0xff, 0x7, 0x81, 0xff, 0xff,
    0x7, 0x3, 0x80, 0x0, 0x7, 0x3, 0x0, 0x0,
    0x7, 0x6, 0x0, 0x0, 0xf, 0x86, 0x0, 0x0,
    0xf, 0x8c, 0x0, 0x0, 0xf, 0x98, 0x0, 0x0,
    0x1f, 0x90, 0x0, 0x10, 0x1f, 0x80, 0x0, 0x30,
    0x17, 0x87, 0xff, 0xf0, 0x37, 0x87, 0xff, 0xf0,
    0x27, 0x80, 0x0, 0xf0, 0x47, 0x80, 0x1, 0xe0,
    0x47, 0x80, 0x3, 0xc0, 0x7, 0x80, 0x3, 0x80,
    0x7, 0x80, 0x7, 0x80, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c, 0x0,
    0x7, 0x80, 0x78, 0x2, 0x7, 0x80, 0x78, 0x2,
    0x7, 0x80, 0xf0, 0x2, 0x7, 0x80, 0xe0, 0x2,
    0x7, 0x81, 0xe0, 0x6, 0x7, 0x83, 0xc0, 0x6,
    0x7, 0x83, 0xc0, 0x6, 0x7, 0x83, 0x80, 0x6,
    0x7, 0x87, 0x80, 0x6, 0x7, 0x87, 0x0, 0x7,
    0x7, 0x87, 0x0, 0x7, 0x7, 0x87, 0x0, 0x7,
    0x7, 0x87, 0x0, 0xf, 0x7, 0x87, 0xff, 0xff,
    0x7, 0x87, 0xff, 0xfe, 0x7, 0x81, 0xff, 0xfc,

    /* U+4EE3 "代" */
    0x1, 0xe0, 0x3c, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf8, 0xf, 0x0, 0x0, 0x7c, 0x7, 0x98,
    0x0, 0x3e, 0x3, 0xce, 0x0, 0x1e, 0x1, 0xe3,
    0x80, 0xf, 0x0, 0xf1, 0xe0, 0x7, 0x80, 0x78,
    0xf0, 0x3, 0x80, 0x3c, 0x38, 0x1, 0xc0, 0x1e,
    0x18, 0x1, 0xe0, 0xf, 0x4, 0x0, 0xe0, 0x7,
    0x80, 0x0, 0x70, 0x3, 0xc0, 0x0, 0x7c, 0x1,
    0xe0, 0x8, 0x3e, 0x7, 0xff, 0xfc, 0x1f, 0x7f,
    0xff, 0xfe, 0x1f, 0xbf, 0xfc, 0x0, 0xb, 0xc0,
    0x1e, 0x0, 0xd, 0xe0, 0xf, 0x0, 0x4, 0xf0,
    0x7, 0x80, 0x4, 0x78, 0x3, 0xc0, 0x6, 0x3c,
    0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0x78, 0x0, 0x7, 0x80, 0x3e, 0x0, 0x3,
    0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0,
    0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0,
    0x3c, 0x0, 0xf8, 0x0, 0x1e, 0x0, 0x7c, 0x0,
    0xf, 0x0, 0x1e, 0x4, 0x7, 0x80, 0xf, 0x82,
    0x3, 0xc0, 0x7, 0xc1, 0x1, 0xe0, 0x1, 0xf0,
    0x80, 0xf0, 0x0, 0xf8, 0x40, 0x78, 0x0, 0x3e,
    0x20, 0x3c, 0x0, 0x1f, 0x90, 0x1e, 0x0, 0x7,
    0xd8, 0xf, 0x0, 0x1, 0xfe, 0x7, 0x80, 0x0,
    0xff, 0x83, 0xc0, 0x0, 0x3f, 0xc1, 0xe0, 0x0,
    0xf, 0xe0, 0xf0, 0x0, 0x1, 0xf0, 0x78, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0xc,

    /* U+4EE4 "令" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x1, 0xf8, 0x0,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0xf9, 0x0,
    0x0, 0x0, 0x7c, 0xc0, 0x0, 0x0, 0x7c, 0x70,
    0x0, 0x0, 0x3c, 0x1c, 0x0, 0x0, 0x3c, 0xf,
    0x0, 0x0, 0x1e, 0x3, 0xc0, 0x0, 0x1e, 0x0,
    0xf8, 0x0, 0xe, 0x0, 0x7f, 0x0, 0xe, 0x18,
    0x1f, 0xf0, 0xe, 0xe, 0x7, 0xfc, 0xe, 0x3,
    0x1, 0xfe, 0xe, 0x1, 0xc0, 0x7f, 0xe, 0x0,
    0xe0, 0xf, 0x8c, 0x0, 0x30, 0x3, 0xcc, 0x0,
    0x10, 0x0, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80, 0x3f,
    0xff, 0xff, 0xc0, 0x1f, 0xff, 0xff, 0xe0, 0x0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x1, 0x0, 0x1c, 0x0, 0x0, 0x70, 0x1c, 0x0,
    0x0, 0x1e, 0x18, 0x0, 0x0, 0x3, 0xd0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x1f,
    0x80, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x0,
    0xe0, 0x0, 0x0, 0x0, 0x30, 0x0,

    /* U+4EE5 "以" */
    0x0, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x84, 0x1, 0xe0, 0x7, 0x84, 0x1, 0xe0,
    0x7, 0x86, 0x1, 0xe0, 0x7, 0x83, 0x1, 0xe0,
    0x7, 0x83, 0x81, 0xe0, 0x7, 0x83, 0x81, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x81, 0xe1, 0xe0,
    0x7, 0x81, 0xe1, 0xe0, 0x7, 0x81, 0xe1, 0xe0,
    0x7, 0x80, 0xe1, 0xe0, 0x7, 0x80, 0xe1, 0xe0,
    0x7, 0x80, 0x41, 0xe0, 0x7, 0x80, 0x41, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xc0, 0x7, 0x80, 0x3, 0xc0,
    0x7, 0x81, 0x83, 0xc0, 0x7, 0x81, 0x3, 0xc0,
    0x7, 0x82, 0x3, 0x80, 0x7, 0x86, 0x7, 0xc0,
    0x7, 0x8c, 0x7, 0x40, 0x7, 0x98, 0x6, 0x40,
    0x7, 0xb8, 0xe, 0x60, 0x7, 0xf0, 0x1c, 0x30,
    0x7, 0xe0, 0x18, 0x30, 0x7, 0xc0, 0x30, 0x3c,
    0xff, 0x80, 0x60, 0x1f, 0x7f, 0x0, 0x40, 0x1f,
    0x7e, 0x0, 0x80, 0xe, 0x78, 0x1, 0x80, 0xe,
    0x40, 0x3, 0x0, 0x6, 0x0, 0x6, 0x0, 0x3,

    /* U+4EE8 "仨" */
    0x0, 0xf8, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x0, 0xf1, 0xff, 0xfc, 0x1, 0xe1, 0xff, 0xfc,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x7, 0xe0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0,
    0xd, 0xe0, 0x0, 0x0, 0x19, 0xe0, 0x0, 0x0,
    0x31, 0xe1, 0xff, 0xfc, 0x21, 0xe1, 0xff, 0xfc,
    0x41, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xef, 0xff, 0xff, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,

    /* U+4EEA "仪" */
    0x1, 0xf0, 0x10, 0x3c, 0x1, 0xf0, 0x10, 0x3c,
    0x1, 0xe2, 0x18, 0x3c, 0x1, 0xe2, 0x1c, 0x3c,
    0x1, 0xe2, 0x1c, 0x3c, 0x3, 0xc2, 0xe, 0x3c,
    0x3, 0xc2, 0xe, 0x3c, 0x3, 0xc2, 0xf, 0x3c,
    0x3, 0x82, 0xf, 0x3c, 0x3, 0x82, 0xf, 0x3c,
    0x7, 0x2, 0xe, 0x3c, 0x7, 0x2, 0x6, 0x3c,
    0x7, 0x82, 0x4, 0x3c, 0xf, 0x82, 0x0, 0x3c,
    0xf, 0x82, 0x0, 0x3c, 0x1f, 0x82, 0x0, 0x3c,
    0x1f, 0x81, 0x0, 0x3c, 0x37, 0x81, 0x0, 0x3c,
    0x27, 0x81, 0x0, 0x3c, 0x67, 0x81, 0x0, 0x3c,
    0x47, 0x81, 0x0, 0x38, 0x87, 0x81, 0x80, 0x78,
    0x7, 0x81, 0x80, 0x78, 0x7, 0x80, 0x80, 0x78,
    0x7, 0x80, 0xc0, 0x78, 0x7, 0x80, 0xc0, 0x70,
    0x7, 0x80, 0xe0, 0xf0, 0x7, 0x80, 0xe0, 0xe0,
    0x7, 0x80, 0x70, 0xe0, 0x7, 0x80, 0x70, 0xc0,
    0x7, 0x80, 0x79, 0xc0, 0x7, 0x80, 0x3d, 0x80,
    0x7, 0x80, 0x3f, 0x80, 0x7, 0x80, 0x1f, 0x0,
    0x7, 0x80, 0x1f, 0x80, 0x7, 0x80, 0xf, 0xc0,
    0x7, 0x80, 0x1f, 0xe0, 0x7, 0x80, 0x3f, 0xf0,
    0x7, 0x80, 0x73, 0xf8, 0x7, 0x80, 0xc1, 0xfe,
    0x7, 0x81, 0x80, 0xff, 0x7, 0x83, 0x0, 0x7f,
    0x7, 0x86, 0x0, 0x3f, 0x7, 0x8c, 0x0, 0x1e,
    0x7, 0x98, 0x0, 0x6, 0x7, 0xb0, 0x0, 0x0,

    /* U+4EEB "仫" */
    0x3, 0xe1, 0xf0, 0x0, 0x3, 0xe1, 0xf0, 0x0,
    0x3, 0xc1, 0xf0, 0x0, 0x3, 0xc1, 0xf0, 0x0,
    0x3, 0xc1, 0xf0, 0x0, 0x3, 0xc1, 0xe3, 0xc0,
    0x3, 0x81, 0xe3, 0xc0, 0x7, 0x81, 0xe3, 0xc0,
    0x7, 0x81, 0xe3, 0xc0, 0x7, 0x3, 0xc3, 0xc0,
    0x7, 0x3, 0xc3, 0xc0, 0x7, 0x3, 0xc3, 0xc0,
    0xe, 0x3, 0x83, 0x80, 0xf, 0x3, 0x87, 0x80,
    0xf, 0x3, 0x87, 0x80, 0x1f, 0x7, 0x7, 0x80,
    0x1f, 0x7, 0x7, 0x80, 0x37, 0x6, 0x7, 0x0,
    0x37, 0x6, 0x7, 0x0, 0x67, 0xc, 0x7, 0x40,
    0x47, 0xc, 0x7, 0x40, 0x87, 0x8, 0xe, 0x40,
    0x87, 0x10, 0xe, 0x40, 0x7, 0x10, 0xe, 0x40,
    0x7, 0x20, 0xc, 0x40, 0x7, 0x0, 0x1c, 0x60,
    0x7, 0x0, 0x18, 0x60, 0x7, 0x0, 0x18, 0x60,
    0x7, 0x0, 0x30, 0x60, 0x7, 0x0, 0x30, 0x60,
    0x7, 0x0, 0x20, 0x70, 0x7, 0x0, 0x60, 0x70,
    0x7, 0x0, 0x40, 0x38, 0x7, 0x0, 0x80, 0x38,
    0x7, 0x0, 0x80, 0x7c, 0x7, 0x1, 0x0, 0xfc,
    0x7, 0x2, 0x1, 0xbe, 0x7, 0x4, 0x7, 0x1f,
    0x7, 0x8, 0x3e, 0x1f, 0x7, 0x3f, 0xf8, 0x1e,
    0x7, 0x1f, 0xf0, 0xe, 0x7, 0x1f, 0xc0, 0xe,
    0x7, 0x1f, 0x0, 0x6, 0x7, 0xc, 0x0, 0x6,
    0x7, 0x0, 0x0, 0x2, 0x7, 0x0, 0x0, 0x0,

    /* U+4EEC "们" */
    0x3, 0xe0, 0x0, 0x0, 0x7, 0x81, 0x0, 0x0,
    0x1f, 0x3, 0x0, 0x0, 0x3e, 0x2, 0x0, 0x0,
    0x78, 0x6, 0x3, 0xc0, 0xf3, 0xce, 0xff, 0x81,
    0xe7, 0x9d, 0xff, 0x3, 0x8f, 0x18, 0x1e, 0x7,
    0x1e, 0x30, 0x3c, 0x1e, 0x3c, 0x40, 0x78, 0x38,
    0x78, 0x0, 0xf0, 0x70, 0xf0, 0x1, 0xe0, 0xf1,
    0xe0, 0x3, 0xc3, 0xe3, 0xc0, 0x7, 0x87, 0xc7,
    0x80, 0xf, 0xf, 0x8f, 0x0, 0x1e, 0x3f, 0x1e,
    0x0, 0x3c, 0x5e, 0x3c, 0x0, 0x79, 0xbc, 0x78,
    0x0, 0xf2, 0x78, 0xf0, 0x1, 0xec, 0xf1, 0xe0,
    0x3, 0xc1, 0xe3, 0xc0, 0x7, 0x83, 0xc7, 0x80,
    0xf, 0x7, 0x8f, 0x0, 0x1e, 0xf, 0x1e, 0x0,
    0x3c, 0x1e, 0x3c, 0x0, 0x78, 0x3c, 0x78, 0x0,
    0xf0, 0x78, 0xf0, 0x1, 0xe0, 0xf1, 0xe0, 0x3,
    0xc1, 0xe3, 0xc0, 0x7, 0x83, 0xc7, 0x80, 0xf,
    0x7, 0x8f, 0x0, 0x1e, 0xf, 0x1e, 0x0, 0x3c,
    0x1e, 0x3c, 0x0, 0x78, 0x3c, 0x78, 0x0, 0xf0,
    0x78, 0xf0, 0x1, 0xe0, 0xf1, 0xe0, 0x3, 0xc1,
    0xe3, 0xc0, 0x7, 0x83, 0xc7, 0x80, 0xf, 0x7,
    0x8f, 0x0, 0x1e, 0xf, 0x1e, 0x0, 0x3c, 0x1e,
    0x3c, 0x0, 0x78, 0x3c, 0x78, 0x0, 0xf0, 0x78,
    0xf0, 0x7, 0xc0, 0xf1, 0xe0, 0x3f, 0x1, 0xe3,
    0xc1, 0xf8, 0x0,

    /* U+4EF0 "仰" */
    0x3, 0xc0, 0x18, 0x0, 0x3, 0xc0, 0x1c, 0x0,
    0x3, 0xcf, 0x3e, 0x0, 0x3, 0xcf, 0x7f, 0xf,
    0x3, 0xcf, 0xcf, 0xf, 0x3, 0x8f, 0xf, 0xff,
    0x3, 0x8f, 0xf, 0xff, 0x3, 0x8f, 0xf, 0xf,
    0x7, 0x8f, 0xf, 0xf, 0x7, 0xf, 0xf, 0xf,
    0x7, 0xf, 0xf, 0xf, 0x7, 0xf, 0xf, 0xf,
    0x6, 0xf, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0xf, 0x8f, 0xf, 0xf, 0xf, 0x8f, 0xf, 0xf,
    0xf, 0x8f, 0xf, 0xf, 0x1f, 0x8f, 0xf, 0xf,
    0x17, 0x8f, 0xf, 0xf, 0x37, 0x8f, 0xf, 0xf,
    0x27, 0x8f, 0xf, 0xf, 0x67, 0x8f, 0xf, 0xf,
    0x47, 0x8f, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0x7, 0x8f, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0x7, 0x8f, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0x7, 0x8f, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0x7, 0x8f, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0x7, 0x8f, 0x1f, 0xf, 0x7, 0x8f, 0x2f, 0xf,
    0x7, 0x8f, 0xcf, 0xf, 0x7, 0x8f, 0xcf, 0xf,
    0x7, 0xbf, 0x8f, 0xf, 0x7, 0xbf, 0xf, 0xe,
    0x7, 0x9c, 0xf, 0x1c, 0x7, 0x98, 0xf, 0x38,
    0x7, 0x80, 0xf, 0xc0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,

    /* U+4EF2 "仲" */
    0x7, 0xc0, 0xf, 0x0, 0xf, 0x80, 0x1e, 0x0,
    0x1f, 0x0, 0x3c, 0x0, 0x3e, 0x0, 0x78, 0x0,
    0x7c, 0x0, 0xf0, 0x0, 0xf8, 0x1, 0xe0, 0x1,
    0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0x80, 0x7,
    0x80, 0xf, 0x0, 0xf, 0x1e, 0x1e, 0x3c, 0x3c,
    0x3c, 0x3c, 0x78, 0x78, 0x7f, 0xff, 0xf0, 0xf0,
    0xff, 0xff, 0xe1, 0xf1, 0xe1, 0xe3, 0xc3, 0xe3,
    0xc3, 0xc7, 0x8f, 0xc7, 0x87, 0x8f, 0x1f, 0x8f,
    0xf, 0x1e, 0x3f, 0x1e, 0x1e, 0x3c, 0xde, 0x3c,
    0x3c, 0x79, 0xbc, 0x78, 0x78, 0xf2, 0x78, 0xf0,
    0xf1, 0xec, 0xf1, 0xe1, 0xe3, 0xd1, 0xe3, 0xc3,
    0xc7, 0x83, 0xc7, 0x87, 0x8f, 0x7, 0x8f, 0xf,
    0x1e, 0xf, 0x1e, 0x1e, 0x3c, 0x1e, 0x3f, 0xff,
    0xf8, 0x3c, 0x7f, 0xff, 0xf0, 0x78, 0xf0, 0xf1,
    0xe0, 0xf1, 0xe1, 0xe3, 0xc1, 0xe3, 0xc3, 0xc7,
    0x83, 0xc7, 0x87, 0x80, 0x7, 0x80, 0xf, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x3c, 0x0, 0x78, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0xf0, 0x1, 0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x3,
    0xc0, 0x7, 0x80, 0x7, 0x80, 0xf, 0x0, 0xf,
    0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x3c,
    0x0, 0x78, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xf0,
    0x1, 0xe0, 0x0,

    /* U+4EF3 "仳" */
    0x7, 0xc0, 0x3, 0xc0, 0x7, 0xc7, 0x83, 0xc0,
    0x7, 0xc7, 0x83, 0xc0, 0x7, 0x87, 0x83, 0xc0,
    0x7, 0x87, 0x83, 0xc0, 0x7, 0x87, 0x83, 0xc0,
    0x7, 0x87, 0x83, 0xc0, 0x7, 0x87, 0x83, 0xc0,
    0x7, 0x7, 0x83, 0xc0, 0xf, 0x7, 0x83, 0xc0,
    0xf, 0x7, 0x83, 0xc0, 0xe, 0x7, 0x83, 0xc0,
    0xe, 0x7, 0x83, 0xc0, 0x1f, 0x7, 0x83, 0xc3,
    0x1f, 0x7, 0x83, 0xc6, 0x1f, 0x7, 0x83, 0xc6,
    0x3f, 0x7, 0xfb, 0xcc, 0x37, 0x7, 0xfb, 0xd8,
    0x27, 0x7, 0x83, 0xd8, 0x67, 0x7, 0x83, 0xf0,
    0x47, 0x7, 0x83, 0xe0, 0x87, 0x7, 0x83, 0xe0,
    0x7, 0x7, 0x83, 0xc0, 0x7, 0x7, 0x83, 0xc0,
    0x7, 0x7, 0x83, 0xc0, 0x7, 0x7, 0x83, 0xc0,
    0x7, 0x7, 0x83, 0xc0, 0x7, 0x7, 0x83, 0xc0,
    0x7, 0x7, 0x83, 0xc0, 0x7, 0x7, 0x83, 0xc0,
    0x7, 0x7, 0x83, 0xc1, 0x7, 0x7, 0x83, 0xc1,
    0x7, 0x7, 0x83, 0xc1, 0x7, 0x7, 0x87, 0xc1,
    0x7, 0x7, 0x8b, 0xc3, 0x7, 0x7, 0x9b, 0xc2,
    0x7, 0x7, 0xb3, 0xc2, 0x7, 0x7, 0xe3, 0xc2,
    0x7, 0x7, 0xc3, 0xc3, 0x7, 0x3f, 0xc3, 0xc3,
    0x7, 0x1f, 0x3, 0xc7, 0x7, 0x1e, 0x3, 0xff,
    0x7, 0x1c, 0x3, 0xff, 0x7, 0x20, 0x3, 0xff,
    0x7, 0x0, 0x1, 0xff, 0x7, 0x0, 0x0, 0x0,

    /* U+4EF5 "仵" */
    0x1, 0xf0, 0xf0, 0x0, 0x0, 0xf8, 0x78, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x1e, 0xf, 0x0, 0x0, 0xf, 0x7, 0x80,
    0x0, 0xf, 0x3, 0x80, 0x0, 0x7, 0x81, 0xff,
    0xfe, 0x3, 0xc1, 0xff, 0xff, 0x1, 0xc0, 0xe1,
    0xe0, 0x1, 0xe0, 0x70, 0xf0, 0x0, 0xe0, 0x30,
    0x78, 0x0, 0x70, 0x38, 0x3c, 0x0, 0x3e, 0x18,
    0x1e, 0x0, 0x3f, 0x8, 0xf, 0x0, 0x1f, 0x8c,
    0x7, 0x80, 0xf, 0xc4, 0x3, 0xc0, 0xd, 0xe6,
    0x1, 0xe0, 0x6, 0xf0, 0x0, 0xf0, 0x6, 0x78,
    0x0, 0x78, 0x3, 0x3c, 0x0, 0x3c, 0x3, 0x1e,
    0x0, 0x1e, 0x1, 0xf, 0x0, 0xf, 0x0, 0x7,
    0xbf, 0xff, 0xff, 0x3, 0xdf, 0xff, 0xff, 0x81,
    0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0xf0, 0x0,
    0x78, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x1e, 0x0, 0xf, 0x0, 0xf, 0x0,
    0x7, 0x80, 0x7, 0x80, 0x3, 0xc0, 0x3, 0xc0,
    0x1, 0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0xf0,
    0x0, 0x78, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x3c,
    0x0, 0x1e, 0x0, 0x1e, 0x0, 0xf, 0x0, 0xf,
    0x0, 0x7, 0x80, 0x7, 0x80, 0x3, 0xc0, 0x3,
    0xc0, 0x1, 0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0,
    0xf0, 0x0, 0x78, 0x0, 0x78, 0x0, 0x3c, 0x0,
    0x3c, 0x0, 0x1e, 0x0, 0x1e, 0x0,

    /* U+4EF6 "件" */
    0x7, 0xc0, 0x7, 0x80, 0x3, 0xc0, 0x3, 0xc0,
    0x1, 0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0xf0,
    0x0, 0x78, 0x78, 0x78, 0x0, 0x3c, 0x3c, 0x3c,
    0x0, 0x1e, 0x1e, 0x1e, 0x0, 0x1e, 0xf, 0xf,
    0x0, 0xf, 0x7, 0x87, 0x80, 0x7, 0x83, 0xc3,
    0xc0, 0x3, 0xc1, 0xe1, 0xe0, 0x1, 0xc1, 0xff,
    0xff, 0xc1, 0xe0, 0xff, 0xff, 0xe0, 0xf8, 0x78,
    0x3c, 0x0, 0x7c, 0x3c, 0x1e, 0x0, 0x7e, 0x1c,
    0xf, 0x0, 0x3f, 0xe, 0x7, 0x80, 0x1f, 0x86,
    0x3, 0xc0, 0x1b, 0xc3, 0x1, 0xe0, 0x9, 0xe3,
    0x0, 0xf0, 0x8, 0xf1, 0x0, 0x78, 0x4, 0x79,
    0x80, 0x3c, 0x0, 0x3c, 0x80, 0x1e, 0x0, 0x1e,
    0x0, 0xf, 0x0, 0xf, 0x0, 0x7, 0x80, 0x7,
    0x9f, 0xff, 0xff, 0xc3, 0xcf, 0xff, 0xff, 0xe1,
    0xe0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0x78, 0x0,
    0x78, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x1e, 0x0,
    0x1e, 0x0, 0xf, 0x0, 0xf, 0x0, 0x7, 0x80,
    0x7, 0x80, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0xe0,
    0x1, 0xe0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0x78,
    0x0, 0x78, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0x1e, 0x0, 0xf, 0x0, 0xf, 0x0, 0x7,
    0x80, 0x7, 0x80, 0x3, 0xc0, 0x3, 0xc0, 0x1,
    0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0xf0, 0x0,
    0x78, 0x0, 0x78, 0x0, 0x3c, 0x0,

    /* U+4EF7 "价" */
    0x1, 0xf0, 0x3f, 0x0, 0x0, 0x7c, 0xf, 0xc0,
    0x0, 0x3e, 0x3, 0xf0, 0x0, 0xf, 0x80, 0xfc,
    0x0, 0x3, 0xe0, 0x3f, 0x0, 0x0, 0xf0, 0xf,
    0x60, 0x0, 0x3c, 0x7, 0xc8, 0x0, 0xf, 0x1,
    0xe3, 0x0, 0x3, 0x80, 0x70, 0xc0, 0x1, 0xe0,
    0x1c, 0x38, 0x0, 0x70, 0xe, 0x7, 0x0, 0x1c,
    0x3, 0x1, 0xe0, 0xe, 0x1, 0xc0, 0x7e, 0x3,
    0xe0, 0x60, 0xf, 0xc0, 0xf8, 0x30, 0x3, 0xf8,
    0x7e, 0x18, 0x0, 0x7e, 0x1f, 0x84, 0x0, 0xff,
    0x8d, 0xe2, 0x78, 0x3d, 0xe6, 0x79, 0x1e, 0xf,
    0x39, 0x9e, 0x87, 0x83, 0xc0, 0xc7, 0x81, 0xe0,
    0xf0, 0x1, 0xe0, 0x78, 0x3c, 0x0, 0x78, 0x1e,
    0xf, 0x0, 0x1e, 0x7, 0x83, 0xc0, 0x7, 0x81,
    0xe0, 0xf0, 0x1, 0xe0, 0x78, 0x3c, 0x0, 0x78,
    0x1e, 0xf, 0x0, 0x1e, 0x7, 0x83, 0xc0, 0x7,
    0x81, 0xe0, 0xf0, 0x1, 0xe0, 0x78, 0x3c, 0x0,
    0x78, 0x1e, 0xf, 0x0, 0x1e, 0x7, 0x83, 0xc0,
    0x7, 0x81, 0xe0, 0xf0, 0x1, 0xe0, 0x78, 0x3c,
    0x0, 0x78, 0x1e, 0xf, 0x0, 0x1e, 0x7, 0x83,
    0xc0, 0x7, 0x81, 0xe0, 0xf0, 0x1, 0xe0, 0x70,
    0x3c, 0x0, 0x78, 0x1c, 0xf, 0x0, 0x1e, 0x7,
    0x3, 0xc0, 0x7, 0x83, 0x80, 0xf0, 0x1, 0xe0,
    0xc0, 0x3c, 0x0, 0x78, 0x30, 0xf, 0x0, 0x1e,
    0x18, 0x3, 0xc0, 0x7, 0x8c, 0x0, 0xf0, 0x1,
    0xe2, 0x0, 0x3c, 0x0,

    /* U+4EFB "任" */
    0x3, 0xe0, 0x0, 0x20, 0x3, 0xe0, 0x0, 0xf0,
    0x3, 0xc0, 0x3, 0xf8, 0x3, 0xc0, 0x1f, 0xfc,
    0x3, 0xc1, 0xff, 0x80, 0x3, 0xc6, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x0, 0xf, 0x0, 0x7, 0x0, 0xf, 0x0,
    0x7, 0x0, 0xf, 0x0, 0xf, 0x80, 0xf, 0x0,
    0xf, 0x80, 0xf, 0x0, 0xf, 0x80, 0xf, 0x0,
    0x1f, 0x80, 0xf, 0x0, 0x1f, 0x80, 0xf, 0x0,
    0x37, 0x80, 0xf, 0x0, 0x37, 0x80, 0xf, 0x0,
    0x27, 0x80, 0xf, 0x0, 0x47, 0x9f, 0xff, 0xff,
    0xc7, 0x9f, 0xff, 0xff, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x8f, 0xff, 0xfe,
    0x7, 0x8f, 0xff, 0xfe, 0x7, 0x80, 0x0, 0x0,

    /* U+4EFD "份" */
    0x3, 0xe0, 0xf0, 0x0, 0x0, 0xf8, 0x3c, 0x40,
    0x0, 0x3c, 0xf, 0x10, 0x0, 0xf, 0x3, 0xc2,
    0x0, 0x3, 0xc0, 0xf0, 0x80, 0x0, 0xf0, 0x38,
    0x20, 0x0, 0x78, 0x1e, 0xc, 0x0, 0x1e, 0x7,
    0x83, 0x0, 0x7, 0x81, 0xc0, 0xe0, 0x1, 0xc0,
    0x70, 0x18, 0x0, 0xf0, 0x38, 0x7, 0x0, 0x3e,
    0xe, 0x1, 0xe0, 0xf, 0x83, 0x0, 0x3c, 0x7,
    0xe1, 0x80, 0xf, 0x81, 0xf8, 0x60, 0x1, 0xf8,
    0x7e, 0x30, 0x0, 0x7e, 0x37, 0x88, 0x0, 0xf,
    0x89, 0xe6, 0x0, 0x1f, 0xe4, 0x7b, 0xff, 0xff,
    0xb9, 0x1e, 0xbf, 0xff, 0xe6, 0x7, 0xc1, 0xe0,
    0x78, 0x1, 0xe0, 0x78, 0x1e, 0x0, 0x78, 0x1e,
    0x7, 0x80, 0x1e, 0x7, 0x81, 0xe0, 0x7, 0x81,
    0xe0, 0x78, 0x1, 0xe0, 0x78, 0x1e, 0x0, 0x78,
    0x1e, 0x7, 0x80, 0x1e, 0x7, 0x81, 0xe0, 0x7,
    0x81, 0xe0, 0x78, 0x1, 0xe0, 0x78, 0x1e, 0x0,
    0x78, 0x1e, 0x7, 0x80, 0x1e, 0x7, 0x81, 0xe0,
    0x7, 0x81, 0xe0, 0x78, 0x1, 0xe0, 0x78, 0x1e,
    0x0, 0x78, 0x1c, 0x7, 0x80, 0x1e, 0x7, 0x1,
    0xe0, 0x7, 0x83, 0xc0, 0x78, 0x1, 0xe0, 0xe0,
    0x1e, 0x0, 0x78, 0x38, 0x7, 0x80, 0x1e, 0xc,
    0x1, 0xe0, 0x7, 0x86, 0x0, 0x78, 0x1, 0xe1,
    0x80, 0x1e, 0x0, 0x78, 0xc0, 0xf, 0x80, 0x1e,
    0x20, 0x7, 0xc0, 0x7, 0x90, 0x3, 0xe0, 0x1,
    0xe8, 0x3, 0xe0, 0x0,

    /* U+4EFF "仿" */
    0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x18, 0x0,
    0x3, 0xc0, 0x1c, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0xe, 0x0, 0x3, 0xc0, 0xe, 0x0,
    0x3, 0xc0, 0x6, 0x0, 0x7, 0xff, 0xff, 0xff,
    0x7, 0xff, 0xff, 0xff, 0x7, 0x81, 0xe0, 0x0,
    0x7, 0x1, 0xe0, 0x0, 0x7, 0x1, 0xe0, 0x0,
    0xf, 0x81, 0xe0, 0x0, 0xf, 0x81, 0xe0, 0x0,
    0xf, 0x81, 0xe0, 0x0, 0x1f, 0x81, 0xe0, 0x78,
    0x1f, 0x81, 0xe0, 0x78, 0x17, 0x81, 0xff, 0xf8,
    0x37, 0x81, 0xff, 0xf8, 0x27, 0x81, 0xe0, 0x78,
    0x47, 0x81, 0xe0, 0x78, 0xc7, 0x81, 0xe0, 0x78,
    0x87, 0x81, 0xe0, 0x78, 0x7, 0x81, 0xe0, 0x78,
    0x7, 0x81, 0xe0, 0x78, 0x7, 0x81, 0xe0, 0x78,
    0x7, 0x81, 0xe0, 0x78, 0x7, 0x81, 0xe0, 0x78,
    0x7, 0x81, 0xe0, 0x78, 0x7, 0x81, 0xe0, 0x78,
    0x7, 0x81, 0xe0, 0x78, 0x7, 0x81, 0xe0, 0x78,
    0x7, 0x81, 0xe0, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x83, 0x80, 0x78, 0x7, 0x83, 0x80, 0x78,
    0x7, 0x83, 0x80, 0x78, 0x7, 0x87, 0x0, 0x78,
    0x7, 0x86, 0x0, 0x78, 0x7, 0x8c, 0x0, 0x78,
    0x7, 0x8c, 0x0, 0xf0, 0x7, 0x98, 0x1, 0xe0,
    0x7, 0xb0, 0x3, 0xc0, 0x7, 0xc0, 0xf, 0x0,

    /* U+4F01 "企" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x7d, 0x80,
    0x0, 0x0, 0x3c, 0xc0, 0x0, 0x0, 0x3e, 0x30,
    0x0, 0x0, 0x1e, 0x1c, 0x0, 0x0, 0x1e, 0x6,
    0x0, 0x0, 0xf, 0x3, 0x80, 0x0, 0xf, 0x0,
    0xe0, 0x0, 0xf, 0x0, 0x78, 0x0, 0x7, 0x0,
    0x1f, 0x0, 0x7, 0x0, 0xf, 0xc0, 0x7, 0x1,
    0xe3, 0xf8, 0x7, 0x0, 0xf0, 0xff, 0x7, 0x0,
    0x78, 0x3f, 0x86, 0x0, 0x3c, 0xf, 0x86, 0x0,
    0x1e, 0x3, 0xc6, 0x0, 0xf, 0x0, 0xe6, 0x0,
    0x7, 0x80, 0x18, 0x7, 0x3, 0xc0, 0x0, 0x3,
    0x81, 0xe0, 0x0, 0x1, 0xc0, 0xf0, 0x0, 0x0,
    0xe0, 0x7f, 0xfc, 0x0, 0x70, 0x3f, 0xfe, 0x0,
    0x38, 0x1e, 0x0, 0x0, 0x1c, 0xf, 0x0, 0x0,
    0xe, 0x7, 0x80, 0x0, 0x7, 0x3, 0xc0, 0x0,
    0x3, 0x81, 0xe0, 0x0, 0x1, 0xc0, 0xf0, 0x0,
    0x0, 0xe0, 0x78, 0x0, 0x0, 0x70, 0x3c, 0x0,
    0x0, 0x38, 0x1e, 0x0, 0x0, 0x1c, 0xf, 0x0,
    0x0, 0xe, 0x7, 0x80, 0x0, 0x7, 0x3, 0xc0,
    0x0, 0x3, 0x81, 0xe0, 0x0, 0x1, 0xc0, 0xf0,
    0x0, 0x0, 0xe0, 0x78, 0x0, 0x0, 0x70, 0x3c,
    0x0, 0x0, 0x38, 0x1e, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xe7, 0xff, 0xff, 0xff, 0xf0,

    /* U+4F09 "伉" */
    0x3, 0xc0, 0x10, 0x0, 0x3, 0xc0, 0x18, 0x0,
    0x3, 0xc0, 0x1c, 0x0, 0x7, 0xc0, 0x1e, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0x6, 0x0, 0x7, 0x80, 0x6, 0x0,
    0x7, 0x9f, 0xff, 0xff, 0x7, 0x1f, 0xff, 0xff,
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xe, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x0, 0x0, 0x1f, 0x83, 0xc1, 0xe0,
    0x1f, 0x83, 0xc1, 0xe0, 0x1f, 0x83, 0xff, 0xe0,
    0x37, 0x83, 0xff, 0xe0, 0x37, 0x83, 0xc1, 0xe0,
    0x67, 0x83, 0xc1, 0xe0, 0x67, 0x83, 0xc1, 0xe0,
    0x47, 0x83, 0xc1, 0xe0, 0xc7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe1,
    0x7, 0x83, 0xc1, 0xe1, 0x7, 0x83, 0xc1, 0xe1,
    0x7, 0x83, 0xc1, 0xe1, 0x7, 0x83, 0x81, 0xe1,
    0x7, 0x83, 0x81, 0xe1, 0x7, 0x83, 0x1, 0xe1,
    0x7, 0x83, 0x1, 0xe3, 0x7, 0x86, 0x1, 0xe3,
    0x7, 0x86, 0x1, 0xe3, 0x7, 0x8c, 0x1, 0xe3,
    0x7, 0x88, 0x1, 0xe3, 0x7, 0x90, 0x1, 0xff,
    0x7, 0xb0, 0x1, 0xff, 0x7, 0xa0, 0x1, 0xfe,

    /* U+4F0A "伊" */
    0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x3c,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x79, 0xff, 0xff,
    0x0, 0x3c, 0xe, 0x7, 0x80, 0x1e, 0x7, 0x3,
    0xc0, 0xf, 0x3, 0x81, 0xe0, 0xf, 0x1, 0xc0,
    0xf0, 0x7, 0x80, 0xe0, 0x78, 0x3, 0xc0, 0x70,
    0x3c, 0x1, 0xe0, 0x38, 0x1e, 0x0, 0xe0, 0x1c,
    0xf, 0x0, 0x70, 0xe, 0x7, 0x80, 0x7d, 0xff,
    0xff, 0xfc, 0x3e, 0xff, 0xff, 0xfe, 0x1f, 0x1,
    0xc0, 0xf0, 0x1f, 0x80, 0xe0, 0x78, 0xf, 0xc0,
    0x70, 0x3c, 0xd, 0xe0, 0x38, 0x1e, 0x4, 0xf0,
    0x1c, 0xf, 0x6, 0x78, 0xe, 0x7, 0x82, 0x3c,
    0x7, 0x3, 0xc0, 0x1e, 0x3, 0x81, 0xe0, 0xf,
    0x1, 0xc0, 0xf0, 0x7, 0x9f, 0xff, 0xf8, 0x3,
    0xcf, 0xff, 0xfc, 0x1, 0xe0, 0x78, 0x1e, 0x0,
    0xf0, 0x3c, 0xf, 0x0, 0x78, 0x1e, 0x0, 0x0,
    0x3c, 0xf, 0x0, 0x0, 0x1e, 0x7, 0x80, 0x0,
    0xf, 0x3, 0xc0, 0x0, 0x7, 0x81, 0xe0, 0x0,
    0x3, 0xc0, 0xf0, 0x0, 0x1, 0xe0, 0x78, 0x0,
    0x0, 0xf0, 0x38, 0x0, 0x0, 0x78, 0x1c, 0x0,
    0x0, 0x3c, 0xc, 0x0, 0x0, 0x1e, 0xe, 0x0,
    0x0, 0xf, 0x6, 0x0, 0x0, 0x7, 0x86, 0x0,
    0x0, 0x3, 0xc3, 0x0, 0x0, 0x1, 0xe3, 0x0,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0x0, 0x79, 0x0,
    0x0, 0x0, 0x3d, 0x80, 0x0, 0x0,

    /* U+4F0B "伋" */
    0x1, 0xf0, 0x0, 0x1f, 0x0, 0xf, 0x80, 0x0,
    0xf8, 0x0, 0x78, 0x0, 0x7, 0xc0, 0x3, 0xdf,
    0xff, 0xfe, 0x0, 0x1e, 0xff, 0xff, 0xf0, 0x0,
    0xe0, 0x78, 0xf, 0x0, 0x7, 0x3, 0xc0, 0x78,
    0x0, 0x78, 0x1e, 0x3, 0xc0, 0x3, 0x80, 0xf0,
    0x1e, 0x0, 0x1c, 0x7, 0x80, 0xe0, 0x0, 0xe0,
    0x3c, 0x7, 0x0, 0x6, 0x1, 0xe0, 0x30, 0x0,
    0x70, 0xf, 0x3, 0x80, 0x3, 0xc0, 0x78, 0x1b,
    0xc0, 0x1e, 0x3, 0xc1, 0x9e, 0x1, 0xf0, 0x1e,
    0x8, 0xf0, 0xf, 0x80, 0xf0, 0xff, 0x80, 0xdc,
    0x7, 0x87, 0xfc, 0x4, 0xe0, 0x3c, 0x3f, 0xe0,
    0x67, 0x1, 0xe0, 0xf, 0x6, 0x38, 0xf, 0x80,
    0x78, 0x21, 0xc0, 0x7c, 0x3, 0xc0, 0xe, 0x3,
    0xe0, 0x1e, 0x0, 0x70, 0x1f, 0x80, 0xf0, 0x3,
    0x80, 0xf4, 0x7, 0x80, 0x1c, 0xf, 0x20, 0x3c,
    0x0, 0xe0, 0x79, 0x83, 0xc0, 0x7, 0x3, 0xcc,
    0x1e, 0x0, 0x38, 0x1e, 0x70, 0xe0, 0x1, 0xc0,
    0xf1, 0x8f, 0x0, 0xe, 0x7, 0xe, 0x70, 0x0,
    0x70, 0x38, 0x77, 0x80, 0x3, 0x83, 0xc1, 0xf8,
    0x0, 0x1c, 0x1c, 0xf, 0x80, 0x0, 0xe0, 0xe0,
    0x78, 0x0, 0x7, 0x6, 0x1, 0xe0, 0x0, 0x38,
    0x70, 0x1f, 0xc0, 0x1, 0xc3, 0x81, 0xbf, 0x0,
    0xe, 0x18, 0x18, 0xfc, 0x0, 0x70, 0xc1, 0x83,
    0xf8, 0x3, 0x8c, 0x18, 0xf, 0xf0, 0x1c, 0x61,
    0x80, 0x3f, 0x80, 0xe6, 0x38, 0x0, 0xfc, 0x7,
    0x23, 0x0, 0x3, 0xc0, 0x3b, 0x30, 0x0, 0x6,
    0x1, 0xd2, 0x0, 0x0, 0x10,

    /* U+4F0D "伍" */
    0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x1, 0xf7, 0xff, 0xff, 0xc0, 0xf3, 0xff, 0xff,
    0xe0, 0x78, 0xf, 0x0, 0x0, 0x3c, 0x7, 0x80,
    0x0, 0x1e, 0x3, 0xc0, 0x0, 0xe, 0x1, 0xe0,
    0x0, 0xf, 0x0, 0xf0, 0x0, 0x7, 0x80, 0x78,
    0x0, 0x3, 0x80, 0x3c, 0x0, 0x1, 0xc0, 0x1e,
    0x0, 0x0, 0xf0, 0xf, 0x0, 0x0, 0xf8, 0x7,
    0x80, 0x0, 0x7c, 0x3, 0xc0, 0xe0, 0x3e, 0x1,
    0xe0, 0x70, 0x3f, 0x0, 0xf0, 0x38, 0x1f, 0x8f,
    0xff, 0xfc, 0xb, 0xc7, 0xff, 0xfe, 0xd, 0xe0,
    0x1e, 0xf, 0x4, 0xf0, 0xf, 0x7, 0x84, 0x78,
    0x7, 0x83, 0xc2, 0x3c, 0x3, 0xc1, 0xe0, 0x1e,
    0x1, 0xe0, 0xf0, 0xf, 0x0, 0xf0, 0x78, 0x7,
    0x80, 0x78, 0x3c, 0x3, 0xc0, 0x3c, 0x1e, 0x1,
    0xe0, 0x1e, 0xf, 0x0, 0xf0, 0xf, 0x7, 0x80,
    0x78, 0x7, 0x83, 0xc0, 0x3c, 0x3, 0xc1, 0xe0,
    0x1e, 0x1, 0xe0, 0xf0, 0xf, 0x0, 0xe0, 0x78,
    0x7, 0x80, 0x70, 0x3c, 0x3, 0xc0, 0x38, 0x1e,
    0x1, 0xe0, 0x1c, 0xf, 0x0, 0xf0, 0xc, 0x7,
    0x80, 0x78, 0xe, 0x3, 0x80, 0x3c, 0x6, 0x1,
    0xc0, 0x1e, 0x3, 0x0, 0xc0, 0xf, 0x3, 0x0,
    0xc0, 0x7, 0x81, 0x0, 0x60, 0x3, 0xcf, 0xff,
    0xff, 0xe1, 0xe7, 0xff, 0xff, 0xf0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0,

    /* U+4F0E "伎" */
    0x3, 0xc0, 0x3c, 0x0, 0x3, 0xc0, 0x3c, 0x0,
    0x3, 0xc0, 0x3c, 0x0, 0x3, 0xc0, 0x3c, 0x0,
    0x3, 0xc0, 0x3c, 0x0, 0x3, 0x80, 0x3c, 0x0,
    0x3, 0x80, 0x3c, 0x0, 0x7, 0x9f, 0xff, 0xfe,
    0x7, 0x9f, 0xff, 0xfe, 0x7, 0x0, 0x3c, 0x0,
    0x7, 0x0, 0x3c, 0x0, 0x7, 0x0, 0x3c, 0x0,
    0xe, 0x0, 0x3c, 0x0, 0xf, 0x80, 0x3c, 0x0,
    0xf, 0x80, 0x3c, 0x0, 0xf, 0x80, 0x3c, 0x0,
    0x1f, 0x80, 0x3c, 0x78, 0x17, 0x80, 0x3c, 0x78,
    0x37, 0x8f, 0xff, 0xf8, 0x27, 0x8f, 0xff, 0xf8,
    0x67, 0x82, 0x0, 0x78, 0x47, 0x82, 0x0, 0x78,
    0x87, 0x83, 0x0, 0x78, 0x7, 0x83, 0x0, 0x78,
    0x7, 0x81, 0x0, 0x78, 0x7, 0x81, 0x80, 0xf0,
    0x7, 0x81, 0x80, 0xf0, 0x7, 0x81, 0xc0, 0xf0,
    0x7, 0x80, 0xc0, 0xf0, 0x7, 0x80, 0xe1, 0xe0,
    0x7, 0x80, 0x61, 0xe0, 0x7, 0x80, 0x71, 0xc0,
    0x7, 0x80, 0x7b, 0xc0, 0x7, 0x80, 0x3f, 0x80,
    0x7, 0x80, 0x1f, 0x0, 0x7, 0x80, 0x1f, 0x0,
    0x7, 0x80, 0x1f, 0x80, 0x7, 0x80, 0x3f, 0xc0,
    0x7, 0x80, 0x77, 0xf0, 0x7, 0x80, 0xe3, 0xfc,
    0x7, 0x81, 0xc1, 0xfe, 0x7, 0x83, 0x0, 0xfe,
    0x7, 0x86, 0x0, 0x3e, 0x7, 0x88, 0x0, 0x1e,
    0x7, 0xb0, 0x0, 0x6, 0x7, 0xe0, 0x0, 0x0,

    /* U+4F0F "伏" */
    0x1, 0xe0, 0x1c, 0x0, 0x1, 0xe0, 0x1c, 0x0,
    0x1, 0xe0, 0x1c, 0x0, 0x1, 0xc0, 0x1c, 0xc0,
    0x1, 0xc0, 0x1c, 0x60, 0x1, 0xc0, 0x1c, 0x70,
    0x3, 0xc0, 0x1c, 0x3c, 0x3, 0x80, 0x1c, 0x3c,
    0x3, 0x80, 0x1c, 0x1c, 0x3, 0x80, 0x1c, 0x1c,
    0x3, 0x0, 0x1c, 0x8, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x80, 0x1c, 0x0, 0x7, 0xbf, 0xff, 0xff,
    0xf, 0xbf, 0xff, 0xff, 0xf, 0x80, 0x3e, 0x0,
    0x1f, 0x80, 0x3e, 0x0, 0x17, 0x80, 0x3e, 0x0,
    0x37, 0x80, 0x3e, 0x0, 0x27, 0x80, 0x3e, 0x0,
    0x47, 0x80, 0x3e, 0x0, 0x47, 0x80, 0x3e, 0x0,
    0x87, 0x80, 0x3e, 0x0, 0x7, 0x80, 0x3e, 0x0,
    0x7, 0x80, 0x3e, 0x0, 0x7, 0x80, 0x3e, 0x0,
    0x7, 0x80, 0x3e, 0x0, 0x7, 0x80, 0x3e, 0x0,
    0x7, 0x80, 0x3a, 0x0, 0x7, 0x80, 0x3a, 0x0,
    0x7, 0x80, 0x7b, 0x0, 0x7, 0x80, 0x73, 0x0,
    0x7, 0x80, 0x71, 0x0, 0x7, 0x80, 0x61, 0x80,
    0x7, 0x80, 0xe1, 0xc0, 0x7, 0x80, 0xc1, 0xe0,
    0x7, 0x81, 0xc0, 0xe0, 0x7, 0x81, 0x80, 0xf8,
    0x7, 0x83, 0x0, 0x7c, 0x7, 0x83, 0x0, 0x7e,
    0x7, 0x86, 0x0, 0x3e, 0x7, 0x8c, 0x0, 0x1e,
    0x7, 0x88, 0x0, 0xe, 0x7, 0x90, 0x0, 0xe,
    0x7, 0xa0, 0x0, 0x2, 0x7, 0xc0, 0x0, 0x0,

    /* U+4F10 "伐" */
    0x1, 0xe0, 0x78, 0x0, 0x1, 0xe0, 0x78, 0x0,
    0x3, 0xe0, 0x78, 0x80, 0x3, 0xe0, 0x78, 0xc0,
    0x3, 0xe0, 0x78, 0xe0, 0x3, 0xe0, 0x78, 0x78,
    0x3, 0xc0, 0x78, 0x7c, 0x3, 0xc0, 0x78, 0x38,
    0x3, 0xc0, 0x78, 0x38, 0x3, 0xc0, 0x78, 0x10,
    0x7, 0x80, 0x78, 0x0, 0x7, 0x80, 0x78, 0x0,
    0x7, 0x0, 0x78, 0x3, 0x7, 0x80, 0x79, 0xff,
    0xf, 0x83, 0xff, 0xf8, 0xf, 0xbf, 0xfc, 0x0,
    0x1f, 0xb8, 0x78, 0x0, 0x1f, 0x80, 0x78, 0x0,
    0x17, 0x80, 0x78, 0x78, 0x37, 0x80, 0x78, 0x78,
    0x67, 0x80, 0x78, 0x78, 0x47, 0x80, 0x78, 0x78,
    0x87, 0x80, 0x78, 0x78, 0x7, 0x80, 0x78, 0x78,
    0x7, 0x80, 0x78, 0x70, 0x7, 0x80, 0x38, 0x70,
    0x7, 0x80, 0x3c, 0xf0, 0x7, 0x80, 0x3c, 0xf0,
    0x7, 0x80, 0x3c, 0xe0, 0x7, 0x80, 0x3c, 0xe0,
    0x7, 0x80, 0x3f, 0xe0, 0x7, 0x80, 0x1f, 0xc2,
    0x7, 0x80, 0x1f, 0xc2, 0x7, 0x80, 0x1f, 0x82,
    0x7, 0x80, 0xf, 0x2, 0x7, 0x80, 0xf, 0x2,
    0x7, 0x80, 0xf, 0x86, 0x7, 0x80, 0x1f, 0xc6,
    0x7, 0x80, 0x33, 0xe6, 0x7, 0x80, 0x61, 0xfe,
    0x7, 0x80, 0x80, 0xfe, 0x7, 0x83, 0x0, 0x7f,
    0x7, 0x84, 0x0, 0x3f, 0x7, 0x88, 0x0, 0x1f,
    0x7, 0x80, 0x0, 0xf, 0x7, 0x80, 0x0, 0x3,

    /* U+4F11 "休" */
    0x3, 0xf0, 0x7, 0x0, 0x0, 0xfc, 0x1, 0xc0,
    0x0, 0x3f, 0x0, 0x70, 0x0, 0xf, 0xc0, 0x1c,
    0x0, 0x3, 0xe0, 0x7, 0x0, 0x0, 0xf8, 0x1,
    0xc0, 0x0, 0x3e, 0x0, 0x70, 0x0, 0xf, 0x80,
    0x1c, 0x0, 0x3, 0xc0, 0x7, 0x0, 0x0, 0xf0,
    0x1, 0xc0, 0x0, 0x7c, 0xff, 0xff, 0xf8, 0x1e,
    0x3f, 0xff, 0xfe, 0x7, 0x80, 0x3f, 0x40, 0x1,
    0xe0, 0xf, 0xd0, 0x0, 0x7c, 0x3, 0xf4, 0x0,
    0x3f, 0x0, 0xfd, 0x0, 0xf, 0xc0, 0x3f, 0x60,
    0x3, 0xf0, 0x1f, 0xd8, 0x1, 0xbc, 0x7, 0xf6,
    0x0, 0x6f, 0x1, 0xfd, 0x80, 0x33, 0xc0, 0x7f,
    0x20, 0x8, 0xf0, 0x1d, 0xcc, 0x2, 0x3c, 0xf,
    0x73, 0x1, 0xf, 0x3, 0xdc, 0xc0, 0xc3, 0xc0,
    0xe7, 0x38, 0x0, 0xf0, 0x39, 0xce, 0x0, 0x3c,
    0x1c, 0x73, 0x80, 0xf, 0x7, 0x1c, 0xf0, 0x3,
    0xc1, 0xc7, 0x3c, 0x0, 0xf0, 0xe1, 0xc7, 0x0,
    0x3c, 0x38, 0x71, 0xe0, 0xf, 0xc, 0x1c, 0x78,
    0x3, 0xc7, 0x7, 0x1f, 0x0, 0xf1, 0x81, 0xc3,
    0xe0, 0x3c, 0x60, 0x70, 0xfc, 0xf, 0x30, 0x1c,
    0x3e, 0x3, 0xcc, 0x7, 0x7, 0x80, 0xf6, 0x1,
    0xc1, 0xc0, 0x3d, 0x80, 0x70, 0x30, 0xf, 0xc0,
    0x1c, 0x4, 0x3, 0xf0, 0x7, 0x1, 0x0, 0xf0,
    0x1, 0xc0, 0x0, 0x3c, 0x0, 0x70, 0x0, 0xf,
    0x0, 0x1c, 0x0, 0x3, 0xc0, 0x7, 0x0, 0x0,
    0xf0, 0x1, 0xc0, 0x0,

    /* U+4F15 "伕" */
    0x1, 0xf0, 0x1e, 0x0, 0x0, 0x7c, 0x7, 0x80,
    0x0, 0x1e, 0x1, 0xe0, 0x0, 0x7, 0x80, 0x78,
    0x0, 0x1, 0xe0, 0x1e, 0x0, 0x0, 0x70, 0x7,
    0x80, 0x0, 0x1c, 0x1, 0xe0, 0x0, 0xf, 0x0,
    0x78, 0x0, 0x3, 0x80, 0x1e, 0x0, 0x0, 0xe0,
    0x7, 0x80, 0x0, 0x38, 0xff, 0xff, 0xe0, 0xc,
    0x3f, 0xff, 0xf8, 0x7, 0x0, 0x1e, 0x0, 0x1,
    0xe0, 0x7, 0x80, 0x0, 0x78, 0x1, 0xe0, 0x0,
    0x3e, 0x0, 0x78, 0x0, 0xf, 0x80, 0x1e, 0x0,
    0x6, 0xe0, 0x7, 0x80, 0x1, 0x38, 0x1, 0xe0,
    0x0, 0xce, 0x0, 0x78, 0x0, 0x23, 0x80, 0x1e,
    0x0, 0x10, 0xe0, 0x7, 0x80, 0x0, 0x3b, 0xff,
    0xff, 0xf0, 0xe, 0xff, 0xff, 0xfc, 0x3, 0x80,
    0x3e, 0x0, 0x0, 0xe0, 0xf, 0x0, 0x0, 0x38,
    0x3, 0xc0, 0x0, 0xe, 0x0, 0xf8, 0x0, 0x3,
    0x80, 0x3e, 0x0, 0x0, 0xe0, 0xf, 0xc0, 0x0,
    0x38, 0x3, 0xb0, 0x0, 0xe, 0x0, 0xee, 0x0,
    0x3, 0x80, 0x79, 0x80, 0x0, 0xe0, 0x1c, 0x70,
    0x0, 0x38, 0x7, 0x1c, 0x0, 0xe, 0x1, 0x83,
    0x80, 0x3, 0x80, 0xc0, 0xf0, 0x0, 0xe0, 0x30,
    0x1e, 0x0, 0x38, 0x18, 0x7, 0xe0, 0xe, 0x6,
    0x0, 0xfc, 0x3, 0x83, 0x0, 0x1f, 0xc0, 0xe0,
    0x80, 0x7, 0xe0, 0x38, 0x40, 0x0, 0xf8, 0xe,
    0x30, 0x0, 0x1c, 0x3, 0x98, 0x0, 0x3, 0x0,
    0xec, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0x0,

    /* U+4F17 "众" */
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x0, 0x1e, 0xc0,
    0x0, 0x0, 0x1f, 0x30, 0x0, 0x0, 0xf, 0x1c,
    0x0, 0x0, 0xf, 0xe, 0x0, 0x0, 0x7, 0x3,
    0xc0, 0x0, 0x7, 0x0, 0xf0, 0x0, 0x7, 0x0,
    0x7c, 0x0, 0x7, 0x0, 0x1f, 0x80, 0x7, 0x0,
    0x7, 0xf8, 0x6, 0x0, 0x1, 0xfc, 0x6, 0x0,
    0x0, 0x7e, 0x6, 0x0, 0x0, 0x1f, 0x4, 0x0,
    0x0, 0x3, 0x8c, 0x3c, 0x0, 0xf0, 0x40, 0x1e,
    0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x7,
    0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0, 0x1,
    0xe0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0,
    0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0xf, 0x80, 0x1e, 0x0, 0x7, 0xe0, 0xf, 0x0,
    0x3, 0xd8, 0x7, 0x80, 0x1, 0xee, 0x7, 0xc0,
    0x0, 0xf3, 0x83, 0xf0, 0x0, 0xf1, 0xe1, 0xd8,
    0x0, 0x78, 0x70, 0xee, 0x0, 0x38, 0x38, 0xe3,
    0x80, 0x1c, 0x1c, 0x71, 0xe0, 0x1c, 0x4, 0x70,
    0xf8, 0xc, 0x2, 0x30, 0x3e, 0xc, 0x0, 0x30,
    0x1f, 0x84, 0x0, 0x30, 0xf, 0x86, 0x0, 0x30,
    0x3, 0xc6, 0x0, 0x30, 0x0, 0xe4, 0x0, 0x30,
    0x0, 0x30, 0x0, 0x30, 0x0, 0x8,

    /* U+4F18 "优" */
    0x3, 0xe0, 0xf0, 0x0, 0x1, 0xe0, 0x78, 0xc0,
    0x0, 0xf0, 0x3c, 0x30, 0x0, 0x78, 0x1e, 0x1c,
    0x0, 0x3c, 0xf, 0xf, 0x0, 0x1c, 0x7, 0x83,
    0xc0, 0xe, 0x3, 0xc1, 0xe0, 0xf, 0x1, 0xe0,
    0x60, 0x7, 0x80, 0xf0, 0x30, 0x3, 0x80, 0x78,
    0x8, 0x1, 0xc0, 0x3c, 0x0, 0x0, 0xe7, 0xff,
    0xff, 0xf0, 0x63, 0xff, 0xff, 0xf8, 0x7c, 0x7,
    0x9e, 0x0, 0x3e, 0x3, 0xcf, 0x0, 0x1f, 0x1,
    0xe7, 0x80, 0x1f, 0x80, 0xf3, 0xc0, 0xb, 0xc0,
    0x79, 0xe0, 0xd, 0xe0, 0x3c, 0xf0, 0x4, 0xf0,
    0x1e, 0x78, 0x6, 0x78, 0xf, 0x3c, 0x2, 0x3c,
    0x7, 0x9e, 0x3, 0x1e, 0x3, 0xcf, 0x0, 0xf,
    0x1, 0xe7, 0x80, 0x7, 0x80, 0xf3, 0xc0, 0x3,
    0xc0, 0x79, 0xe0, 0x1, 0xe0, 0x3c, 0xf0, 0x0,
    0xf0, 0x1e, 0x78, 0x0, 0x78, 0xf, 0x3c, 0x0,
    0x3c, 0x7, 0x1e, 0x0, 0x1e, 0x3, 0x8f, 0x0,
    0xf, 0x1, 0xc7, 0x81, 0x7, 0x81, 0xe3, 0xc1,
    0x83, 0xc0, 0xe1, 0xe0, 0xc1, 0xe0, 0x70, 0xf0,
    0x60, 0xf0, 0x38, 0x78, 0x30, 0x78, 0x18, 0x3c,
    0x18, 0x3c, 0x1c, 0x1e, 0xc, 0x1e, 0xc, 0xf,
    0xe, 0xf, 0x6, 0x7, 0x87, 0x7, 0x86, 0x3,
    0xc3, 0x83, 0xc2, 0x1, 0xe1, 0xc1, 0xe3, 0x0,
    0xff, 0xe0, 0xf3, 0x0, 0x7f, 0xf0, 0x79, 0x0,
    0x3f, 0xf8, 0x3d, 0x80, 0xf, 0xf8,

    /* U+4F19 "伙" */
    0x1, 0xf0, 0x1e, 0x0, 0x0, 0xf8, 0xf, 0x0,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x3c, 0x3, 0xc0,
    0x0, 0x1e, 0x1, 0xe0, 0x0, 0xf, 0x0, 0xf0,
    0x0, 0x7, 0x80, 0x78, 0x0, 0x7, 0xc0, 0x3c,
    0x0, 0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0, 0xf,
    0x0, 0x0, 0xf0, 0x7, 0x81, 0x0, 0x79, 0x3,
    0xc1, 0x80, 0x78, 0x41, 0xe0, 0xc0, 0x3e, 0x30,
    0xf0, 0xc0, 0x1f, 0x18, 0x78, 0x60, 0x1f, 0x8e,
    0x3c, 0x60, 0xf, 0xc3, 0x1e, 0x30, 0x7, 0xe1,
    0xcf, 0x30, 0x6, 0xf0, 0xe7, 0x98, 0x2, 0x78,
    0x3b, 0xc8, 0x3, 0x3c, 0x1d, 0xec, 0x3, 0x1e,
    0xc, 0xf4, 0x1, 0xf, 0x6, 0x7e, 0x0, 0x7,
    0x82, 0x3e, 0x0, 0x3, 0xc0, 0x1e, 0x0, 0x1,
    0xe0, 0xf, 0x0, 0x0, 0xf0, 0x7, 0x80, 0x0,
    0x78, 0x3, 0xc0, 0x0, 0x3c, 0x3, 0xe0, 0x0,
    0x1e, 0x1, 0xf0, 0x0, 0xf, 0x0, 0xf4, 0x0,
    0x7, 0x80, 0x7a, 0x0, 0x3, 0xc0, 0x79, 0x80,
    0x1, 0xe0, 0x3c, 0xe0, 0x0, 0xf0, 0x1c, 0x70,
    0x0, 0x78, 0x1e, 0x1c, 0x0, 0x3c, 0xe, 0xf,
    0x0, 0x1e, 0xf, 0x3, 0xc0, 0xf, 0x7, 0x1,
    0xf0, 0x7, 0x87, 0x0, 0xfe, 0x3, 0xc3, 0x0,
    0x3f, 0x81, 0xe3, 0x80, 0xf, 0x80, 0xf3, 0x80,
    0x7, 0xc0, 0x79, 0x80, 0x1, 0xe0, 0x3d, 0x80,
    0x0, 0x70, 0x1f, 0x80, 0x0, 0x18, 0x0, 0x0,
    0x0, 0x0,

    /* U+4F1A "会" */
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0xf4, 0x0,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x78, 0xc0,
    0x0, 0x0, 0x7c, 0x70, 0x0, 0x0, 0x3c, 0x38,
    0x0, 0x0, 0x3c, 0xe, 0x0, 0x0, 0x1e, 0x7,
    0x80, 0x0, 0x1e, 0x1, 0xe0, 0x0, 0x1e, 0x0,
    0x7c, 0x0, 0xe, 0x0, 0x3f, 0x0, 0xe, 0x0,
    0xf, 0xe0, 0xe, 0x0, 0x3, 0xfe, 0xe, 0x0,
    0x0, 0xff, 0xf, 0xff, 0xff, 0xff, 0xc, 0xff,
    0xff, 0xef, 0x8c, 0x0, 0x0, 0x1, 0xcc, 0x0,
    0x0, 0x0, 0x28, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xfe, 0x1f,
    0xff, 0xff, 0xff, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x78, 0x10, 0x0,
    0x0, 0x3c, 0x8, 0x0, 0x0, 0x3c, 0x6, 0x0,
    0x0, 0x1e, 0x3, 0x0, 0x0, 0xe, 0x1, 0xc0,
    0x0, 0xe, 0x0, 0x60, 0x0, 0x7, 0x0, 0x38,
    0x0, 0x7, 0x0, 0x1e, 0x0, 0x6, 0x0, 0x77,
    0xc0, 0x6, 0x3, 0xe3, 0xf8, 0x3f, 0xff, 0xe0,
    0xfc, 0x1f, 0xff, 0x80, 0x7e, 0x7, 0xff, 0x0,
    0x1f, 0x3, 0xf8, 0x0, 0x7, 0x3, 0x80, 0x0,
    0x1, 0x80, 0x0, 0x0, 0x0, 0x60,

    /* U+4F1B "伛" */
    0x7, 0xcf, 0x0, 0x0, 0xf, 0x9e, 0x0, 0x0,
    0x1e, 0x3f, 0xff, 0xf8, 0x3c, 0x7f, 0xff, 0xf0,
    0x78, 0xf0, 0x0, 0x0, 0xf1, 0xe0, 0x0, 0x3,
    0xe3, 0xc0, 0x0, 0x7, 0x87, 0x80, 0x78, 0xf,
    0xf, 0x0, 0xf0, 0x1e, 0x1e, 0x1, 0xe0, 0x38,
    0x3d, 0x3, 0xc0, 0x70, 0x7a, 0x7, 0x81, 0xc0,
    0xf2, 0xf, 0x3, 0xe1, 0xe4, 0x1e, 0x7, 0xc3,
    0xcc, 0x3c, 0xf, 0x87, 0x8c, 0x78, 0x3f, 0xf,
    0x18, 0xf0, 0x6e, 0x1e, 0x39, 0xc0, 0xdc, 0x3c,
    0x33, 0x83, 0x38, 0x78, 0x77, 0x4, 0x70, 0xf0,
    0xfe, 0x18, 0xe1, 0xe0, 0xf8, 0x21, 0xc3, 0xc1,
    0xf0, 0x3, 0x87, 0x83, 0xe0, 0x7, 0xf, 0x3,
    0x80, 0xe, 0x1e, 0x7, 0x80, 0x1c, 0x3c, 0xf,
    0x0, 0x38, 0x78, 0x1f, 0x0, 0x70, 0xf0, 0x7f,
    0x0, 0xe1, 0xe0, 0xde, 0x1, 0xc3, 0xc3, 0x3e,
    0x3, 0x87, 0x84, 0x7c, 0x7, 0xf, 0x18, 0x7c,
    0xe, 0x1e, 0x20, 0xf8, 0x1c, 0x3c, 0xc0, 0xe0,
    0x38, 0x79, 0x1, 0xc0, 0x70, 0xf4, 0x1, 0x0,
    0xe1, 0xf8, 0x2, 0x1, 0xc3, 0xc0, 0x0, 0x3,
    0x87, 0x80, 0x0, 0x7, 0xf, 0x0, 0x0, 0xe,
    0x1f, 0xff, 0xfc, 0x1c, 0x3f, 0xff, 0xf8, 0x38,
    0x78, 0x0, 0x0, 0x70, 0xf0, 0x0, 0x0, 0xe1,
    0xe0, 0x0, 0x0,

    /* U+4F1E "伞" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0xf, 0xc0, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x1e, 0x30, 0x0,
    0x0, 0x1e, 0x38, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x38, 0x1e, 0x0, 0x0, 0x70, 0xf, 0x0,
    0x0, 0x73, 0xcf, 0xc0, 0x0, 0xe3, 0xc7, 0xe0,
    0x1, 0xc3, 0xc3, 0xf8, 0x3, 0x83, 0xc1, 0xff,
    0x3, 0x3, 0xc0, 0xff, 0x6, 0x3, 0xc0, 0x7e,
    0xc, 0x3, 0xc0, 0x3e, 0x12, 0x3, 0xc0, 0xe,
    0x22, 0x3, 0xc0, 0x62, 0x43, 0x3, 0xc0, 0xc0,
    0x1, 0x83, 0xc0, 0xc0, 0x1, 0xc3, 0xc1, 0x80,
    0x1, 0xe3, 0xc1, 0x80, 0x0, 0xe3, 0xc3, 0x0,
    0x0, 0xf3, 0xc3, 0x0, 0x0, 0x73, 0xc2, 0x0,
    0x0, 0x63, 0xc6, 0x0, 0x0, 0x23, 0xc4, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+4F1F "伟" */
    0x3, 0xc0, 0x3c, 0x0, 0x7, 0x80, 0x78, 0x0,
    0xf, 0x0, 0xf0, 0x0, 0x1c, 0x1, 0xe0, 0x0,
    0x38, 0x3, 0xc0, 0x0, 0x70, 0x7, 0x80, 0x0,
    0xe0, 0xf, 0x0, 0x1, 0xdf, 0xff, 0xff, 0x7,
    0x3f, 0xff, 0xfe, 0xe, 0x0, 0x78, 0x0, 0x1c,
    0x0, 0xf0, 0x0, 0x38, 0x1, 0xe0, 0x0, 0x60,
    0x3, 0xc0, 0x1, 0xf0, 0x7, 0x80, 0x3, 0xe0,
    0xf, 0x0, 0x7, 0xcf, 0xff, 0xfc, 0x1f, 0x9f,
    0xff, 0xf8, 0x2f, 0x0, 0x78, 0x0, 0x5e, 0x0,
    0xf0, 0x1, 0x3c, 0x1, 0xe0, 0x2, 0x78, 0x3,
    0xc0, 0x8, 0xf0, 0x7, 0x83, 0xe1, 0xe0, 0xf,
    0x7, 0x83, 0xdf, 0xff, 0xff, 0x7, 0xbf, 0xff,
    0xfe, 0xf, 0x0, 0x78, 0x3c, 0x1e, 0x0, 0xf0,
    0x78, 0x3c, 0x1, 0xe0, 0xf0, 0x78, 0x3, 0xc1,
    0xe0, 0xf0, 0x7, 0x83, 0xc1, 0xe0, 0xf, 0x7,
    0x83, 0xc0, 0x1e, 0xf, 0x7, 0x80, 0x3c, 0x1e,
    0xf, 0x0, 0x78, 0x3c, 0x1e, 0x0, 0xf0, 0x78,
    0x3c, 0x1, 0xe0, 0xf0, 0x78, 0x3, 0xc1, 0xe0,
    0xf0, 0x7, 0x87, 0x81, 0xe0, 0xf, 0x1e, 0x3,
    0xc0, 0x1f, 0xf8, 0x7, 0x80, 0x3c, 0x0, 0xf,
    0x0, 0x78, 0x0, 0x1e, 0x0, 0xf0, 0x0, 0x3c,
    0x1, 0xe0, 0x0, 0x78, 0x3, 0xc0, 0x0, 0xf0,
    0x7, 0x80, 0x0,

    /* U+4F20 "传" */
    0x3, 0xe0, 0x1e, 0x0, 0x1, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0xf, 0x7f, 0xff, 0xfc, 0x7, 0x3f, 0xff,
    0xfe, 0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x1, 0xc0, 0x7, 0x80, 0x0, 0xe0, 0x3,
    0xc0, 0x0, 0x60, 0x1, 0xe0, 0x0, 0x7c, 0x0,
    0xf0, 0x0, 0x3e, 0x0, 0x78, 0x0, 0x1f, 0x7f,
    0xff, 0xff, 0x1f, 0xbf, 0xff, 0xff, 0x8b, 0xc0,
    0xf, 0x0, 0x5, 0xe0, 0x7, 0x0, 0x4, 0xf0,
    0x7, 0x80, 0x2, 0x78, 0x3, 0xc0, 0x2, 0x3c,
    0x1, 0xc0, 0x3, 0x1e, 0x1, 0xc0, 0x0, 0xf,
    0x0, 0xc0, 0x0, 0x7, 0x80, 0xc0, 0x3c, 0x3,
    0xc0, 0xc0, 0x1e, 0x1, 0xe0, 0xff, 0xff, 0x0,
    0xf0, 0x7f, 0xff, 0x0, 0x78, 0x40, 0x7, 0x80,
    0x3c, 0x0, 0x3, 0xc0, 0x1e, 0x0, 0x1, 0xc0,
    0xf, 0x0, 0x1, 0xc0, 0x7, 0x80, 0x0, 0xe0,
    0x3, 0xc0, 0x0, 0xe0, 0x1, 0xe0, 0x0, 0x60,
    0x0, 0xf0, 0x60, 0x60, 0x0, 0x78, 0x1c, 0x60,
    0x0, 0x3c, 0x7, 0xa0, 0x0, 0x1e, 0x1, 0xf0,
    0x0, 0xf, 0x0, 0x3e, 0x0, 0x7, 0x80, 0xf,
    0xc0, 0x3, 0xc0, 0x3, 0xf8, 0x1, 0xe0, 0x0,
    0x7c, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0,
    0x7, 0x0, 0x3c, 0x0, 0x0, 0x80, 0x0, 0x0,
    0x0, 0x0,

    /* U+4F22 "伢" */
    0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x1e, 0x3f, 0xff, 0xf0, 0x3c, 0x7f, 0xff, 0xe0,
    0x70, 0x0, 0x1c, 0x0, 0xe0, 0x0, 0x38, 0x1,
    0xc1, 0xf0, 0x70, 0x3, 0x83, 0xe0, 0xe0, 0xe,
    0x7, 0x81, 0xc0, 0x1c, 0xf, 0x3, 0x80, 0x38,
    0x1c, 0x7, 0x0, 0x70, 0x38, 0xe, 0x0, 0xc0,
    0x60, 0x1c, 0x1, 0xe0, 0xc0, 0x38, 0x7, 0xc1,
    0x0, 0x70, 0xf, 0x84, 0x0, 0xe0, 0x1f, 0x1f,
    0xff, 0xfe, 0x2e, 0x3f, 0xff, 0xfc, 0xdc, 0x60,
    0x7, 0x1, 0x38, 0x80, 0xe, 0x6, 0x70, 0x0,
    0x1c, 0x8, 0xe0, 0x0, 0x38, 0x11, 0xc0, 0xf,
    0xf0, 0x43, 0x80, 0x1f, 0xe0, 0x7, 0x0, 0x3f,
    0xc0, 0xe, 0x0, 0x7b, 0x80, 0x1c, 0x0, 0xf7,
    0x0, 0x38, 0x1, 0xee, 0x0, 0x70, 0x7, 0x9c,
    0x0, 0xe0, 0xf, 0x38, 0x1, 0xc0, 0x1c, 0x70,
    0x3, 0x80, 0x78, 0xe0, 0x7, 0x0, 0xe1, 0xc0,
    0xe, 0x3, 0x83, 0x80, 0x1c, 0x7, 0x7, 0x0,
    0x38, 0x1c, 0xe, 0x0, 0x70, 0x30, 0x1c, 0x0,
    0xe0, 0xc0, 0x38, 0x1, 0xc3, 0x0, 0x70, 0x3,
    0x8c, 0x0, 0xe0, 0x7, 0x10, 0x1, 0xc0, 0xe,
    0x40, 0x3, 0x80, 0x1d, 0x0, 0xf, 0x0, 0x38,
    0x0, 0x3c, 0x0, 0x70, 0x0, 0xf0, 0x0, 0xe0,
    0x7, 0x80, 0x0,

    /* U+4F24 "伤" */
    0x3, 0xe1, 0xf0, 0x0, 0x3, 0xe1, 0xf0, 0x0,
    0x3, 0xc1, 0xe0, 0x0, 0x3, 0xc1, 0xe0, 0x0,
    0x3, 0xc1, 0xe0, 0x0, 0x7, 0xc1, 0xff, 0xff,
    0x7, 0x83, 0xff, 0xff, 0x7, 0x83, 0xc0, 0x0,
    0x7, 0x83, 0x80, 0x0, 0x7, 0x83, 0x80, 0x0,
    0xf, 0x7, 0x78, 0x0, 0xf, 0x6, 0x78, 0x0,
    0xe, 0x6, 0x78, 0x0, 0xf, 0x8c, 0x78, 0x0,
    0x1f, 0x88, 0x78, 0x0, 0x1f, 0x98, 0x78, 0x3c,
    0x1f, 0x90, 0x78, 0x3c, 0x37, 0x80, 0x78, 0x3c,
    0x37, 0x9f, 0xff, 0xfc, 0x27, 0x9f, 0xff, 0xfc,
    0x67, 0x80, 0x78, 0x3c, 0x47, 0x80, 0x78, 0x3c,
    0x87, 0x80, 0x78, 0x3c, 0x7, 0x80, 0x78, 0x3c,
    0x7, 0x80, 0x78, 0x3c, 0x7, 0x80, 0x78, 0x3c,
    0x7, 0x80, 0x78, 0x3c, 0x7, 0x80, 0x78, 0x3c,
    0x7, 0x80, 0x78, 0x3c, 0x7, 0x80, 0x78, 0x3c,
    0x7, 0x80, 0x78, 0x3c, 0x7, 0x80, 0x78, 0x3c,
    0x7, 0x80, 0x78, 0x3c, 0x7, 0x80, 0x78, 0x3c,
    0x7, 0x80, 0x78, 0x3c, 0x7, 0x80, 0x70, 0x3c,
    0x7, 0x80, 0xf0, 0x3c, 0x7, 0x80, 0xe0, 0x3c,
    0x7, 0x80, 0xe0, 0x3c, 0x7, 0x81, 0xc0, 0x3c,
    0x7, 0x81, 0x80, 0x3c, 0x7, 0x83, 0x0, 0x3c,
    0x7, 0x83, 0x0, 0x7c, 0x7, 0x86, 0x0, 0xf8,
    0x7, 0x8c, 0x3, 0xf0, 0x7, 0x98, 0xf, 0xe0,

    /* U+4F25 "伥" */
    0x3, 0xc1, 0xe0, 0x0, 0x3, 0xc1, 0xe0, 0x0,
    0x3, 0xc1, 0xe0, 0x18, 0x3, 0xc1, 0xe0, 0x1c,
    0x3, 0xc1, 0xe0, 0x38, 0x3, 0xc1, 0xe0, 0x30,
    0x3, 0x81, 0xe0, 0x70, 0x7, 0x81, 0xe0, 0xe0,
    0x7, 0x81, 0xe0, 0xc0, 0x7, 0x81, 0xe1, 0xc0,
    0x7, 0x1, 0xe3, 0x80, 0x7, 0x1, 0xe3, 0x0,
    0xf, 0x1, 0xe7, 0x0, 0xf, 0x81, 0xee, 0x0,
    0xf, 0x81, 0xee, 0x0, 0xf, 0x81, 0xfc, 0x0,
    0x1f, 0x81, 0xf8, 0x0, 0x1f, 0x81, 0xf8, 0x0,
    0x37, 0xbf, 0xff, 0xff, 0x37, 0xbf, 0xff, 0xff,
    0x67, 0x81, 0xe6, 0x0, 0x47, 0x81, 0xe6, 0x0,
    0xc7, 0x81, 0xe6, 0x0, 0x7, 0x81, 0xe6, 0x0,
    0x7, 0x81, 0xe2, 0x0, 0x7, 0x81, 0xe2, 0x0,
    0x7, 0x81, 0xe2, 0x0, 0x7, 0x81, 0xe3, 0x0,
    0x7, 0x81, 0xe3, 0x0, 0x7, 0x81, 0xe3, 0x0,
    0x7, 0x81, 0xe3, 0x80, 0x7, 0x81, 0xe1, 0x80,
    0x7, 0x81, 0xe1, 0xc0, 0x7, 0x81, 0xe1, 0xe0,
    0x7, 0x81, 0xe0, 0xe0, 0x7, 0x81, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf8, 0x7, 0x81, 0xe1, 0x7c,
    0x7, 0x81, 0xe2, 0x3e, 0x7, 0x81, 0xec, 0x3f,
    0x7, 0x81, 0xf8, 0x1e, 0x7, 0x8f, 0xf0, 0x1e,
    0x7, 0x8f, 0xe0, 0xe, 0x7, 0x8f, 0xc0, 0x6,
    0x7, 0x8f, 0x0, 0x2, 0x7, 0x8c, 0x0, 0x0,

    /* U+4F26 "伦" */
    0x3, 0xe0, 0x3c, 0x0, 0x3, 0xe0, 0x7c, 0x0,
    0x3, 0xe0, 0x7c, 0x0, 0x3, 0xc0, 0x7e, 0x0,
    0x3, 0xc0, 0x7a, 0x0, 0x3, 0xc0, 0x7a, 0x0,
    0x3, 0x80, 0xf3, 0x0, 0x7, 0x80, 0xf3, 0x80,
    0x7, 0x80, 0xe1, 0x80, 0x7, 0x1, 0xe1, 0xc0,
    0x7, 0x1, 0xc0, 0xe0, 0x7, 0x3, 0x80, 0xe0,
    0xe, 0x3, 0x80, 0xf0, 0xf, 0x87, 0x0, 0x7c,
    0xf, 0x86, 0x0, 0x7e, 0x1f, 0x8e, 0x0, 0x3f,
    0x1f, 0x8c, 0xf0, 0x1f, 0x17, 0x98, 0xf0, 0xe,
    0x37, 0xb0, 0xf0, 0x6, 0x27, 0xe0, 0xf0, 0x22,
    0x47, 0xc0, 0xf0, 0x70, 0xc7, 0x80, 0xf0, 0x60,
    0x87, 0x80, 0xf0, 0xc0, 0x7, 0x80, 0xf1, 0xc0,
    0x7, 0x80, 0xf1, 0x80, 0x7, 0x80, 0xf3, 0x0,
    0x7, 0x80, 0xf3, 0x0, 0x7, 0x80, 0xf6, 0x0,
    0x7, 0x80, 0xfc, 0x0, 0x7, 0x80, 0xfc, 0x0,
    0x7, 0x80, 0xf8, 0x0, 0x7, 0x80, 0xf8, 0x0,
    0x7, 0x80, 0xf0, 0x8, 0x7, 0x80, 0xf0, 0x8,
    0x7, 0x80, 0xf0, 0x8, 0x7, 0x80, 0xf0, 0x8,
    0x7, 0x80, 0xf0, 0x8, 0x7, 0x80, 0xf0, 0x8,
    0x7, 0x80, 0xf0, 0x8, 0x7, 0x80, 0xf0, 0xc,
    0x7, 0x80, 0xf0, 0x1c, 0x7, 0x80, 0xf8, 0x1c,
    0x7, 0x80, 0xff, 0xfc, 0x7, 0x80, 0xff, 0xfc,
    0x7, 0x80, 0x7f, 0xfc, 0x7, 0x80, 0x3f, 0xf0,

    /* U+4F27 "伧" */
    0x3, 0xf0, 0x3e, 0x0, 0x1, 0xf0, 0x1f, 0x0,
    0x0, 0xf8, 0xf, 0x80, 0x0, 0x7c, 0x7, 0xa0,
    0x0, 0x3e, 0x3, 0xd0, 0x0, 0x1f, 0x3, 0xc8,
    0x0, 0xf, 0x1, 0xe6, 0x0, 0x7, 0x80, 0xe3,
    0x0, 0x3, 0xc0, 0x70, 0xc0, 0x3, 0xc0, 0x70,
    0x60, 0x1, 0xe0, 0x38, 0x38, 0x0, 0xe0, 0x18,
    0xe, 0x0, 0x70, 0x18, 0x7, 0x80, 0x7e, 0xc,
    0x1, 0xe0, 0x3f, 0xc, 0x0, 0xfc, 0x1f, 0x84,
    0x0, 0x3f, 0x1f, 0xc6, 0x0, 0xf, 0xd, 0xe6,
    0xf0, 0x7f, 0x84, 0xf2, 0x7f, 0xfd, 0xc6, 0x7a,
    0x3f, 0xfe, 0x62, 0x3c, 0x1e, 0xf, 0x2, 0x1e,
    0xf, 0x7, 0x83, 0xf, 0x7, 0x83, 0xc0, 0x7,
    0x83, 0xc1, 0xe0, 0x3, 0xc1, 0xe0, 0xf0, 0x1,
    0xe0, 0xf0, 0x78, 0x0, 0xf0, 0x78, 0x3c, 0x0,
    0x78, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0xf, 0x0,
    0x1e, 0xf, 0x7, 0x80, 0xf, 0x7, 0x83, 0xc0,
    0x7, 0x83, 0xc3, 0xe0, 0x3, 0xc1, 0xe3, 0xe0,
    0x1, 0xe0, 0xf6, 0xc0, 0x0, 0xf0, 0x78, 0x0,
    0x80, 0x78, 0x3c, 0x0, 0x40, 0x3c, 0x1e, 0x0,
    0x20, 0x1e, 0xf, 0x0, 0x10, 0xf, 0x7, 0x80,
    0x8, 0x7, 0x83, 0xc0, 0xc, 0x3, 0xc1, 0xe0,
    0x7, 0x1, 0xe0, 0xf0, 0x3, 0x80, 0xf0, 0x78,
    0x1, 0xc0, 0x78, 0x3f, 0xff, 0xe0, 0x3c, 0x1f,
    0xff, 0xe0, 0x1e, 0xf, 0xff, 0xf0,

    /* U+4F2A "伪" */
    0x3, 0xe0, 0x78, 0x0, 0x7, 0xc0, 0xf0, 0x0,
    0xf, 0x1, 0xe0, 0x0, 0x1e, 0x43, 0xc0, 0x0,
    0x3c, 0xc7, 0x80, 0x0, 0x78, 0xcf, 0x0, 0x0,
    0xe1, 0xde, 0x0, 0x3, 0xc3, 0xfc, 0xf, 0x7,
    0x83, 0x78, 0x1e, 0xe, 0x0, 0xf0, 0x3c, 0x1c,
    0x1, 0xe0, 0x78, 0x70, 0xff, 0xff, 0xf0, 0xf9,
    0xff, 0xff, 0xe1, 0xf0, 0xf, 0x3, 0xc3, 0xe0,
    0x1e, 0x7, 0x8f, 0xc0, 0x3c, 0xf, 0x17, 0x80,
    0x78, 0x1e, 0x2f, 0x0, 0xf0, 0x3c, 0x9e, 0x1,
    0xe0, 0x79, 0x3c, 0x3, 0xe0, 0xf4, 0x78, 0x7,
    0x41, 0xe8, 0xf0, 0xe, 0xc3, 0xe1, 0xe0, 0x1c,
    0xc7, 0x83, 0xc0, 0x39, 0xcf, 0x7, 0x80, 0x73,
    0x9e, 0xf, 0x0, 0xe3, 0xbc, 0x1e, 0x1, 0xc7,
    0xf8, 0x3c, 0x3, 0x8f, 0xf0, 0x78, 0x7, 0xd,
    0xe0, 0xf0, 0x1e, 0x1b, 0xc1, 0xe0, 0x3c, 0x7,
    0x83, 0xc0, 0x70, 0xf, 0x7, 0x80, 0xe0, 0x1e,
    0xf, 0x1, 0xc0, 0x3c, 0x1e, 0x3, 0x0, 0x78,
    0x3c, 0xe, 0x0, 0xf0, 0x78, 0x1c, 0x1, 0xe0,
    0xf0, 0x30, 0x3, 0xc1, 0xe0, 0xe0, 0x7, 0x83,
    0xc1, 0x80, 0xf, 0x7, 0x82, 0x0, 0x1e, 0xf,
    0xc, 0x0, 0x3c, 0x1e, 0x10, 0x0, 0xf0, 0x3c,
    0x60, 0x7, 0xc0, 0x78, 0x80, 0x3e, 0x0, 0xf2,
    0x0, 0x0, 0x0,

    /* U+4F2B "伫" */
    0x3, 0xe0, 0x10, 0x0, 0x3, 0xe0, 0x18, 0x0,
    0x3, 0xe0, 0xe, 0x0, 0x3, 0xe0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0x7, 0x0,
    0x3, 0xc0, 0x7, 0x0, 0x7, 0x8f, 0x2, 0xf,
    0x7, 0x8f, 0xff, 0xff, 0x7, 0x8f, 0xff, 0xff,
    0x7, 0xf, 0x0, 0xf, 0x7, 0xf, 0x0, 0xf,
    0xe, 0xf, 0x0, 0xf, 0xf, 0x8f, 0x0, 0xf,
    0xf, 0x8f, 0x0, 0xf, 0x1f, 0x8f, 0x0, 0x8,
    0x1f, 0x8f, 0x0, 0x8, 0x1f, 0x80, 0x0, 0x0,
    0x37, 0x80, 0x0, 0x0, 0x37, 0x80, 0x0, 0x0,
    0x67, 0x80, 0x0, 0x0, 0x67, 0x80, 0x0, 0x0,
    0xc7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x9f, 0xff, 0xff, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,

    /* U+4F2F "伯" */
    0x3, 0xe0, 0xf, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0x3c, 0x1, 0xe0, 0x0, 0xf0, 0x7, 0x80, 0x3,
    0xc0, 0x1c, 0x0, 0xe, 0x0, 0x70, 0x0, 0x38,
    0x1, 0x80, 0x1, 0xe3, 0xc4, 0xf, 0x7, 0x8f,
    0xff, 0xfc, 0x1c, 0x3f, 0xff, 0xf0, 0x70, 0xf0,
    0x3, 0xc1, 0x83, 0xc0, 0xf, 0xe, 0xf, 0x0,
    0x3c, 0x3c, 0x3c, 0x0, 0xf0, 0xf0, 0xf0, 0x3,
    0xc7, 0xc3, 0xc0, 0xf, 0x1f, 0xf, 0x0, 0x3c,
    0xdc, 0x3c, 0x0, 0xf2, 0x70, 0xf0, 0x3, 0xd9,
    0xc3, 0xc0, 0xf, 0x47, 0xf, 0x0, 0x3e, 0x1c,
    0x3c, 0x0, 0xf0, 0x70, 0xff, 0xf3, 0xc1, 0xc3,
    0xff, 0xcf, 0x7, 0xf, 0x0, 0x3c, 0x1c, 0x3c,
    0x0, 0xf0, 0x70, 0xf0, 0x3, 0xc1, 0xc3, 0xc0,
    0xf, 0x7, 0xf, 0x0, 0x3c, 0x1c, 0x3c, 0x0,
    0xf0, 0x70, 0xf0, 0x3, 0xc1, 0xc3, 0xc0, 0xf,
    0x7, 0xf, 0x0, 0x3c, 0x1c, 0x3c, 0x0, 0xf0,
    0x70, 0xf0, 0x3, 0xc1, 0xc3, 0xc0, 0xf, 0x7,
    0xf, 0x0, 0x3c, 0x1c, 0x3c, 0x0, 0xf0, 0x70,
    0xf0, 0x3, 0xc1, 0xc3, 0xff, 0xff, 0x7, 0xf,
    0xff, 0xfc, 0x1c, 0x3c, 0x0, 0xf0, 0x70, 0xf0,
    0x3, 0xc1, 0xc3, 0xc0, 0xf, 0x7, 0xf, 0x0,
    0x3c, 0x1c, 0x3c, 0x0, 0xf0,

    /* U+4F30 "估" */
    0x3, 0xf0, 0x7, 0x0, 0x1, 0xf8, 0x3, 0x80,
    0x0, 0xfc, 0x1, 0xc0, 0x0, 0x7c, 0x0, 0xe0,
    0x0, 0x3e, 0x0, 0x70, 0x0, 0x1f, 0x0, 0x38,
    0x0, 0xf, 0x80, 0x1c, 0x0, 0x7, 0x80, 0xe,
    0x0, 0x7, 0xcf, 0xff, 0xff, 0x83, 0xe7, 0xff,
    0xff, 0xc1, 0xe0, 0x3, 0xe0, 0x0, 0xf0, 0x1,
    0xf0, 0x0, 0x70, 0x0, 0xf0, 0x0, 0x7c, 0x0,
    0x78, 0x0, 0x3e, 0x0, 0x3c, 0x0, 0x1f, 0x0,
    0x1e, 0x0, 0x1f, 0x80, 0xf, 0x0, 0xf, 0xc0,
    0x7, 0x80, 0x7, 0xe0, 0x3, 0x80, 0x6, 0xf0,
    0x1, 0xc0, 0x6, 0x78, 0x0, 0xc0, 0x2, 0x3c,
    0x0, 0x60, 0x0, 0x1e, 0xf, 0x20, 0x70, 0xf,
    0x7, 0xff, 0xf8, 0x7, 0x83, 0xff, 0xfc, 0x3,
    0xc1, 0xe0, 0xe, 0x1, 0xe0, 0xf0, 0x7, 0x0,
    0xf0, 0x78, 0x3, 0x80, 0x78, 0x3c, 0x1, 0xc0,
    0x3c, 0x1e, 0x0, 0xe0, 0x1e, 0xf, 0x0, 0x70,
    0xf, 0x7, 0x80, 0x38, 0x7, 0x83, 0xc0, 0x1c,
    0x3, 0xc1, 0xe0, 0xe, 0x1, 0xe0, 0xf0, 0x7,
    0x0, 0xf0, 0x78, 0x3, 0x80, 0x78, 0x3c, 0x1,
    0xc0, 0x3c, 0x1e, 0x0, 0xe0, 0x1e, 0xf, 0x0,
    0x70, 0xf, 0x7, 0x80, 0x38, 0x7, 0x83, 0xff,
    0xfc, 0x3, 0xc1, 0xff, 0xfe, 0x1, 0xe0, 0xf0,
    0x7, 0x0, 0xf0, 0x78, 0x3, 0x80, 0x78, 0x3c,
    0x1, 0xc0, 0x3c, 0x1e, 0x0, 0xe0,

    /* U+4F32 "伲" */
    0x1, 0xe7, 0x80, 0x3c, 0x7, 0x8f, 0x0, 0x78,
    0xf, 0x1f, 0xff, 0xf0, 0x1e, 0x3f, 0xff, 0xe0,
    0x3c, 0x78, 0x3, 0xc0, 0x78, 0xf0, 0x7, 0x80,
    0xe1, 0xe0, 0xf, 0x3, 0xc3, 0xc0, 0x1e, 0x7,
    0x87, 0x80, 0x3c, 0xe, 0xf, 0x0, 0x78, 0x1c,
    0x1e, 0x0, 0xf0, 0x38, 0x3c, 0x1, 0xe0, 0xe0,
    0x7f, 0xff, 0xc1, 0xe0, 0xff, 0xff, 0x83, 0xc1,
    0xe0, 0xf, 0xf, 0x83, 0xc0, 0x1e, 0x1f, 0x7,
    0xbc, 0x0, 0x6e, 0xf, 0x78, 0x0, 0xdc, 0x1e,
    0xf0, 0x3, 0x38, 0x3d, 0xe0, 0x6, 0x70, 0x7b,
    0xc0, 0x18, 0xe0, 0xf7, 0x80, 0xc1, 0xc1, 0xef,
    0x3, 0x3, 0x83, 0xde, 0xc, 0x7, 0x7, 0xbc,
    0x30, 0xe, 0xf, 0x78, 0xc0, 0x1c, 0x1e, 0xf3,
    0x0, 0x38, 0x3d, 0xe4, 0x0, 0x70, 0x7b, 0xd0,
    0x0, 0xe0, 0xe7, 0xc0, 0x1, 0xc1, 0xcf, 0x0,
    0x3, 0x83, 0x9e, 0x2, 0x7, 0x7, 0x3c, 0x4,
    0xe, 0x1c, 0x78, 0x8, 0x1c, 0x38, 0xf0, 0x10,
    0x38, 0x71, 0xe0, 0x20, 0x70, 0xc3, 0xc0, 0x40,
    0xe1, 0x87, 0x80, 0x81, 0xc6, 0xf, 0x1, 0x3,
    0x8c, 0x1e, 0x3, 0x7, 0x10, 0x3c, 0xe, 0xe,
    0x60, 0x7f, 0xfc, 0x1c, 0x80, 0xff, 0xf8, 0x39,
    0x1, 0xff, 0xf0, 0x74, 0x1, 0xff, 0xc0, 0xf0,
    0x0, 0x0, 0x0,

    /* U+4F34 "伴" */
    0x3, 0xe0, 0xe, 0x0, 0x1, 0xe0, 0x7, 0x0,
    0x0, 0xf0, 0x3, 0x80, 0x0, 0x78, 0x1, 0xc0,
    0x0, 0x3c, 0x40, 0xe0, 0x20, 0x1e, 0x20, 0x70,
    0x38, 0xe, 0x18, 0x38, 0x18, 0xf, 0xc, 0x1c,
    0x18, 0x7, 0x87, 0xe, 0xc, 0x3, 0x83, 0xc7,
    0xc, 0x1, 0xc1, 0xe3, 0x8c, 0x0, 0xe0, 0x79,
    0xc6, 0x0, 0x60, 0x3c, 0xe6, 0x0, 0x7c, 0x1e,
    0x72, 0x0, 0x3e, 0x7, 0x3b, 0x0, 0x1f, 0x3,
    0x1d, 0x0, 0x1f, 0x80, 0xf, 0x80, 0xf, 0xc0,
    0x7, 0x80, 0xd, 0xe0, 0x3, 0x80, 0x4, 0xf3,
    0xff, 0xff, 0xe6, 0x79, 0xff, 0xff, 0xf2, 0x3c,
    0x0, 0x70, 0x0, 0x1e, 0x0, 0x38, 0x0, 0xf,
    0x0, 0x1c, 0x0, 0x7, 0x80, 0xe, 0x0, 0x3,
    0xc0, 0x7, 0x0, 0x1, 0xe0, 0x3, 0x80, 0x0,
    0xf0, 0x1, 0xc0, 0x0, 0x78, 0x0, 0xe0, 0x0,
    0x3d, 0xff, 0xff, 0xfc, 0x1e, 0xff, 0xff, 0xfe,
    0xf, 0x0, 0x1c, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x3, 0xc0, 0x7, 0x0, 0x1, 0xe0, 0x3, 0x80,
    0x0, 0xf0, 0x1, 0xc0, 0x0, 0x78, 0x0, 0xe0,
    0x0, 0x3c, 0x0, 0x70, 0x0, 0x1e, 0x0, 0x38,
    0x0, 0xf, 0x0, 0x1c, 0x0, 0x7, 0x80, 0xe,
    0x0, 0x3, 0xc0, 0x7, 0x0, 0x1, 0xe0, 0x3,
    0x80, 0x0, 0xf0, 0x1, 0xc0, 0x0, 0x78, 0x0,
    0xe0, 0x0, 0x3c, 0x0, 0x70, 0x0,

    /* U+4F36 "伶" */
    0x3, 0xe0, 0x3e, 0x0, 0x1, 0xf0, 0x1f, 0x0,
    0x0, 0xf8, 0xf, 0x80, 0x0, 0x78, 0xf, 0x40,
    0x0, 0x3c, 0x7, 0xa0, 0x0, 0x1e, 0x3, 0xd8,
    0x0, 0xf, 0x3, 0xcc, 0x0, 0x7, 0x1, 0xc3,
    0x0, 0x3, 0x80, 0xe1, 0x80, 0x3, 0xc0, 0xe0,
    0xe0, 0x1, 0xc0, 0x70, 0x78, 0x0, 0xe0, 0x70,
    0x1c, 0x0, 0x70, 0x30, 0xf, 0x0, 0x7c, 0x19,
    0x3, 0xc0, 0x3e, 0x18, 0xc1, 0xf8, 0x1f, 0x18,
    0x30, 0x7f, 0x1f, 0x8c, 0x18, 0x3f, 0xf, 0xcc,
    0xe, 0xf, 0x8d, 0xe4, 0x7, 0x3, 0xc4, 0xf4,
    0x1, 0x80, 0xc6, 0x7c, 0x0, 0x80, 0x12, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf,
    0x1f, 0xff, 0xe0, 0x7, 0x8f, 0xff, 0xf0, 0x3,
    0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0,
    0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0, 0xe, 0x0,
    0x3c, 0x0, 0x7, 0x0, 0x1e, 0x0, 0x7, 0x80,
    0xf, 0x4, 0x3, 0x80, 0x7, 0x83, 0x1, 0x80,
    0x3, 0xc0, 0xc1, 0xc0, 0x1, 0xe0, 0x30, 0xc0,
    0x0, 0xf0, 0x1c, 0xc0, 0x0, 0x78, 0x7, 0xc0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf8,
    0x0, 0xf, 0x0, 0x3f, 0x0, 0x7, 0x80, 0xf,
    0xc0, 0x3, 0xc0, 0x3, 0xe0, 0x1, 0xe0, 0x0,
    0xf0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x78, 0x0,
    0x1c, 0x0, 0x3c, 0x0, 0x4, 0x0,

    /* U+4F38 "伸" */
    0x1, 0xe0, 0xf, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x7, 0x80, 0x3c, 0x0, 0xf, 0x0, 0x78, 0x0,
    0x1e, 0x0, 0xf0, 0x0, 0x38, 0x1, 0xe0, 0x0,
    0x70, 0x3, 0xc0, 0x1, 0xe7, 0x87, 0x8f, 0x3,
    0x8f, 0xf, 0x1e, 0x7, 0x1f, 0xff, 0xfc, 0xe,
    0x3f, 0xff, 0xf8, 0x3c, 0x78, 0x78, 0xf0, 0x70,
    0xf0, 0xf1, 0xe0, 0xf1, 0xe1, 0xe3, 0xc3, 0xe3,
    0xc3, 0xc7, 0x87, 0xc7, 0x87, 0x8f, 0xf, 0x8f,
    0xf, 0x1e, 0x37, 0x1e, 0x1e, 0x3c, 0x6e, 0x3f,
    0xff, 0xf9, 0x9c, 0x7f, 0xff, 0xf6, 0x38, 0xf0,
    0xf1, 0xe8, 0x71, 0xe1, 0xe3, 0xc0, 0xe3, 0xc3,
    0xc7, 0x81, 0xc7, 0x87, 0x8f, 0x3, 0x8f, 0xf,
    0x1e, 0x7, 0x1e, 0x1e, 0x3c, 0xe, 0x3c, 0x3c,
    0x78, 0x1c, 0x78, 0x78, 0xf0, 0x38, 0xff, 0xff,
    0xe0, 0x71, 0xe1, 0xe3, 0xc0, 0xe3, 0xc3, 0xc7,
    0x81, 0xc7, 0x87, 0x8f, 0x3, 0x80, 0xf, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0xe, 0x0, 0x3c, 0x0,
    0x1c, 0x0, 0x78, 0x0, 0x38, 0x0, 0xf0, 0x0,
    0x70, 0x1, 0xe0, 0x0, 0xe0, 0x3, 0xc0, 0x1,
    0xc0, 0x7, 0x80, 0x3, 0x80, 0xf, 0x0, 0x7,
    0x0, 0x1e, 0x0, 0xe, 0x0, 0x3c, 0x0, 0x1c,
    0x0, 0x78, 0x0, 0x38, 0x0, 0xf0, 0x0, 0x70,
    0x1, 0xe0, 0x0,

    /* U+4F3A "伺" */
    0x3, 0xe0, 0x0, 0x1e, 0x7, 0x80, 0x0, 0x3c,
    0xf, 0x3f, 0xff, 0xf8, 0x1e, 0x7f, 0xff, 0xf0,
    0x3c, 0x0, 0x1, 0xe0, 0x78, 0x0, 0x3, 0xc0,
    0xe0, 0x0, 0x7, 0x81, 0xc0, 0x0, 0xf, 0x3,
    0x80, 0x0, 0x1e, 0xf, 0x0, 0x0, 0x3c, 0x1c,
    0x7f, 0xff, 0x78, 0x38, 0xff, 0xfe, 0xf0, 0x70,
    0x0, 0x1, 0xe1, 0xf0, 0x0, 0x3, 0xc3, 0xe0,
    0x0, 0x7, 0x8f, 0xc0, 0x0, 0xf, 0x1f, 0x87,
    0xf, 0x1e, 0x3f, 0xe, 0x1e, 0x3c, 0xde, 0x1f,
    0xfc, 0x79, 0x3c, 0x3f, 0xf8, 0xf6, 0x78, 0x70,
    0xf1, 0xe8, 0xf0, 0xe1, 0xe3, 0xc1, 0xe1, 0xc3,
    0xc7, 0x83, 0xc3, 0x87, 0x8f, 0x7, 0x87, 0xf,
    0x1e, 0xf, 0xe, 0x1e, 0x3c, 0x1e, 0x1c, 0x3c,
    0x78, 0x3c, 0x38, 0x78, 0xf0, 0x78, 0x70, 0xf1,
    0xe0, 0xf0, 0xe1, 0xe3, 0xc1, 0xe1, 0xc3, 0xc7,
    0x83, 0xc3, 0xff, 0x8f, 0x7, 0x87, 0xff, 0x1e,
    0xf, 0xe, 0x1e, 0x3c, 0x1e, 0x1c, 0x3c, 0x78,
    0x3c, 0x38, 0x78, 0xf0, 0x78, 0x70, 0xf1, 0xe0,
    0xf0, 0xe0, 0x3, 0xc1, 0xe0, 0x0, 0x7, 0x83,
    0xc0, 0x0, 0xf, 0x7, 0x80, 0x0, 0x1e, 0xf,
    0x0, 0x0, 0x3c, 0x1e, 0x0, 0x0, 0xf0, 0x3c,
    0x0, 0x3, 0xe0, 0x78, 0x0, 0x1f, 0x0, 0xf0,
    0x0, 0xc8, 0x0,

    /* U+4F3B "伻" */
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xcf, 0xff, 0xfe, 0x3, 0xcf, 0xff, 0xfe,
    0x3, 0xc0, 0xe, 0x0, 0x7, 0xc0, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x4,
    0x7, 0x84, 0xe, 0x4, 0x7, 0x86, 0xe, 0xc,
    0x7, 0x6, 0xe, 0xc, 0xf, 0x7, 0xe, 0x8,
    0xf, 0x7, 0xe, 0x18, 0xf, 0x83, 0x8e, 0x18,
    0xf, 0x83, 0x8e, 0x10, 0x1f, 0x83, 0xce, 0x30,
    0x1f, 0x83, 0xce, 0x30, 0x1f, 0x81, 0xce, 0x20,
    0x37, 0x81, 0x8e, 0x60, 0x37, 0x81, 0x8e, 0x60,
    0x67, 0x81, 0xe, 0x40, 0x67, 0x80, 0xe, 0x0,
    0x47, 0x80, 0xe, 0x0, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,

    /* U+4F3C "似" */
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x8, 0xf,
    0x0, 0x1e, 0x2, 0x3, 0xc0, 0x7, 0x80, 0xc0,
    0xf0, 0x1, 0xe0, 0x18, 0x3c, 0x0, 0x70, 0x6,
    0xf, 0x0, 0x1c, 0x1, 0xc3, 0xc0, 0xf, 0x0,
    0x78, 0xf0, 0x3, 0x87, 0x8e, 0x3c, 0x0, 0xe1,
    0xe3, 0x8f, 0x0, 0x38, 0x78, 0xe3, 0xc0, 0x1c,
    0x1e, 0x18, 0xf0, 0x7, 0x7, 0x84, 0x3c, 0x1,
    0xf1, 0xe1, 0xf, 0x0, 0xfc, 0x78, 0x3, 0xc0,
    0x3f, 0x1e, 0x0, 0xf0, 0xf, 0xc7, 0x80, 0x3c,
    0x6, 0xf1, 0xe0, 0xf, 0x1, 0x3c, 0x78, 0x3,
    0xc0, 0xcf, 0x1e, 0x0, 0xf0, 0x23, 0xc7, 0x80,
    0x3c, 0x10, 0xf1, 0xe0, 0xf, 0x0, 0x3c, 0x78,
    0x3, 0xc0, 0xf, 0x1e, 0x0, 0xf0, 0x3, 0xc7,
    0x80, 0x3c, 0x0, 0xf1, 0xe0, 0xf, 0x0, 0x3c,
    0x78, 0x7, 0xc0, 0xf, 0x1e, 0x1, 0xe0, 0x3,
    0xc7, 0x80, 0x78, 0x0, 0xf1, 0xe0, 0x1e, 0x0,
    0x3c, 0x78, 0x7, 0x80, 0xf, 0x1e, 0x9, 0xe0,
    0x3, 0xc7, 0x82, 0x78, 0x0, 0xf1, 0xe1, 0x1e,
    0x0, 0x3c, 0x78, 0xcf, 0x80, 0xf, 0x1e, 0x63,
    0xe0, 0x3, 0xc7, 0xb8, 0xec, 0x0, 0xf1, 0xfc,
    0x7b, 0x80, 0x3c, 0x7e, 0x3c, 0xe0, 0xf, 0x7f,
    0xe, 0x1c, 0x3, 0xdf, 0x87, 0x7, 0xc0, 0xf7,
    0xc3, 0x81, 0xe0, 0x3c, 0xc1, 0xc0, 0x38, 0xf,
    0x0, 0x60, 0xe, 0x3, 0xc0, 0x30, 0x1, 0x80,
    0xf0, 0x30, 0x0, 0x20,

    /* U+4F3D "伽" */
    0x3, 0xce, 0x0, 0x0, 0x3, 0xce, 0x0, 0x0,
    0x3, 0xce, 0x0, 0x0, 0x3, 0xce, 0x0, 0x0,
    0x3, 0xce, 0x1, 0xc7, 0x3, 0xce, 0x1, 0xc7,
    0x3, 0x8e, 0x39, 0xc7, 0x3, 0x8e, 0x39, 0xff,
    0x3, 0x8e, 0x39, 0xff, 0x7, 0xbf, 0xf9, 0xc7,
    0x7, 0x3f, 0xf9, 0xc7, 0x7, 0xe, 0x39, 0xc7,
    0x7, 0xe, 0x39, 0xc7, 0xf, 0x8e, 0x39, 0xc7,
    0xf, 0x8e, 0x39, 0xc7, 0xf, 0x8e, 0x39, 0xc7,
    0x1f, 0x8e, 0x39, 0xc7, 0x1f, 0x8e, 0x39, 0xc7,
    0x37, 0x8e, 0x39, 0xc7, 0x37, 0x8e, 0x39, 0xc7,
    0x27, 0x8e, 0x39, 0xc7, 0x47, 0x8e, 0x39, 0xc7,
    0x47, 0x8e, 0x39, 0xc7, 0x7, 0x8e, 0x39, 0xc7,
    0x7, 0x8e, 0x39, 0xc7, 0x7, 0x8e, 0x39, 0xc7,
    0x7, 0x8e, 0x39, 0xc7, 0x7, 0x8e, 0x39, 0xc7,
    0x7, 0x8e, 0x39, 0xc7, 0x7, 0x8e, 0x39, 0xc7,
    0x7, 0x8e, 0x39, 0xc7, 0x7, 0x8e, 0x39, 0xc7,
    0x7, 0x8e, 0x39, 0xc7, 0x7, 0x8e, 0x39, 0xc7,
    0x7, 0x8e, 0x39, 0xc7, 0x7, 0x8c, 0x39, 0xc7,
    0x7, 0x8c, 0x39, 0xc7, 0x7, 0x8c, 0x39, 0xc7,
    0x7, 0x88, 0x39, 0xc7, 0x7, 0x98, 0x39, 0xff,
    0x7, 0x98, 0x39, 0xc7, 0x7, 0x90, 0x71, 0xc7,
    0x7, 0xb0, 0xf1, 0xc7, 0x7, 0xa3, 0xe1, 0xc7,
    0x7, 0xa7, 0x80, 0x0, 0x7, 0xc0, 0x0, 0x0,

    /* U+4F43 "佃" */
    0x3, 0xc0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0xf, 0x3c, 0x0, 0x78, 0x1e, 0x78, 0x0, 0xf0,
    0x3c, 0xff, 0xff, 0xe0, 0x71, 0xff, 0xff, 0xc0,
    0xe3, 0xc7, 0x87, 0x81, 0xc7, 0x8f, 0xf, 0x7,
    0x8f, 0x1e, 0x1e, 0xe, 0x1e, 0x3c, 0x3c, 0x1c,
    0x3c, 0x78, 0x78, 0x38, 0x78, 0xf0, 0xf0, 0x60,
    0xf1, 0xe1, 0xe1, 0xe1, 0xe3, 0xc3, 0xc3, 0xc3,
    0xc7, 0x87, 0x87, 0x87, 0x8f, 0xf, 0x1f, 0xf,
    0x1e, 0x1e, 0x3e, 0x1e, 0x3c, 0x3c, 0xfc, 0x3c,
    0x78, 0x79, 0x78, 0x78, 0xf0, 0xf6, 0xf0, 0xf1,
    0xe1, 0xe9, 0xe1, 0xff, 0xff, 0xe3, 0xc3, 0xff,
    0xff, 0x87, 0x87, 0x8f, 0xf, 0xf, 0xf, 0x1e,
    0x1e, 0x1e, 0x1e, 0x3c, 0x3c, 0x3c, 0x3c, 0x78,
    0x78, 0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf1, 0xe1,
    0xe1, 0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7, 0x87,
    0x87, 0x87, 0x8f, 0xf, 0xf, 0xf, 0x1e, 0x1e,
    0x1e, 0x1e, 0x3c, 0x3c, 0x3c, 0x3c, 0x78, 0x78,
    0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf1, 0xe1, 0xe1,
    0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7, 0x87, 0x87,
    0x87, 0x8f, 0xf, 0xf, 0xf, 0xff, 0xfe, 0x1e,
    0x1e, 0x0, 0x3c, 0x3c, 0x3c, 0x0, 0x78, 0x78,
    0x78, 0x0, 0xf0, 0xf0, 0xf0, 0x1, 0xe1, 0xe1,
    0xe0, 0x3, 0xc0,

    /* U+4F46 "但" */
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xcf, 0x0, 0x78, 0x3, 0xcf, 0x0, 0x78,
    0x3, 0xcf, 0xff, 0xf8, 0x3, 0x8f, 0x0, 0x78,
    0x3, 0x8f, 0x0, 0x78, 0x7, 0x8f, 0x0, 0x78,
    0x7, 0x8f, 0x0, 0x78, 0x7, 0xf, 0x0, 0x78,
    0x7, 0xf, 0x0, 0x78, 0x7, 0xf, 0x0, 0x78,
    0xe, 0xf, 0x0, 0x78, 0xf, 0xf, 0x0, 0x78,
    0xf, 0xf, 0x0, 0x78, 0x1f, 0xf, 0x0, 0x78,
    0x1f, 0xf, 0x0, 0x78, 0x1f, 0xf, 0xff, 0x78,
    0x3f, 0xf, 0xff, 0x78, 0x2f, 0xf, 0x0, 0x78,
    0x4f, 0xf, 0x0, 0x78, 0x4f, 0xf, 0x0, 0x78,
    0x8f, 0xf, 0x0, 0x78, 0xf, 0xf, 0x0, 0x78,
    0xf, 0xf, 0x0, 0x78, 0xf, 0xf, 0x0, 0x78,
    0xf, 0xf, 0x0, 0x78, 0xf, 0xf, 0x0, 0x78,
    0xf, 0xf, 0x0, 0x78, 0xf, 0xf, 0x0, 0x78,
    0xf, 0xf, 0x0, 0x78, 0xf, 0xf, 0x0, 0x78,
    0xf, 0xf, 0xff, 0xf8, 0xf, 0xf, 0xff, 0xf8,
    0xf, 0xf, 0x0, 0x78, 0xf, 0xf, 0x0, 0x78,
    0xf, 0xf, 0x0, 0x78, 0xf, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf, 0x7f, 0xff, 0xff, 0xf, 0x7f, 0xff, 0xff,
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,

    /* U+4F47 "佇" */
    0x3, 0xe0, 0x8, 0x0, 0x1, 0xf0, 0x6, 0x0,
    0x0, 0xf8, 0x3, 0xc0, 0x0, 0x78, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x3e, 0x1c, 0x18,
    0x78, 0x1f, 0xe, 0xc, 0x3c, 0xf, 0x7, 0xff,
    0xfe, 0x7, 0x83, 0xff, 0xff, 0x3, 0xc1, 0xc0,
    0x7, 0x83, 0xc0, 0xe0, 0x3, 0xc1, 0xe0, 0x70,
    0x1, 0xe0, 0xe0, 0x38, 0x0, 0xc0, 0x7c, 0x0,
    0x0, 0x40, 0x7e, 0x0, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0x1b, 0xc0,
    0x0, 0x0, 0xd, 0xe1, 0xff, 0xff, 0xe4, 0xf0,
    0xff, 0xff, 0xf6, 0x78, 0x0, 0x78, 0x2, 0x3c,
    0x0, 0x3c, 0x2, 0x1e, 0x0, 0x1e, 0x0, 0xf,
    0x0, 0xf, 0x0, 0x7, 0x80, 0x7, 0x80, 0x3,
    0xc0, 0x3, 0xc0, 0x1, 0xe0, 0x1, 0xe0, 0x0,
    0xf0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x78, 0x0,
    0x3c, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0xf, 0x0, 0x7, 0x80, 0x7, 0x80,
    0x3, 0xc0, 0x3, 0xc0, 0x1, 0xe0, 0x1, 0xe0,
    0x0, 0xf0, 0x0, 0xf0, 0x0, 0x78, 0x0, 0x78,
    0x0, 0x3c, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x1e,
    0x0, 0xf, 0x0, 0xf, 0x0, 0x7, 0x80, 0x7,
    0x80, 0x3, 0xc0, 0x3, 0xc0, 0x1, 0xe0, 0x3,
    0xe0, 0x0, 0xf0, 0x7, 0xe0, 0x0, 0x78, 0xf,
    0xe0, 0x0, 0x3c, 0x18, 0xc0, 0x0,

    /* U+4F48 "佈" */
    0x7, 0xc0, 0xf8, 0x0, 0xf, 0x81, 0xf0, 0x0,
    0x1f, 0x3, 0xe0, 0x0, 0x3c, 0x7, 0x80, 0x0,
    0x78, 0xf, 0x0, 0x0, 0xf0, 0x1e, 0x0, 0x1,
    0xe0, 0x3c, 0x0, 0x3, 0x9f, 0xff, 0xff, 0xf,
    0x3f, 0xff, 0xfe, 0x1e, 0x3, 0xc0, 0x0, 0x3c,
    0x7, 0x0, 0x0, 0x70, 0xe, 0x0, 0x0, 0xe0,
    0x38, 0x0, 0x1, 0x80, 0x73, 0x80, 0x7, 0xc0,
    0xc7, 0x0, 0xf, 0x83, 0x8e, 0x0, 0x1f, 0x6,
    0x1c, 0x0, 0x6e, 0x1c, 0x38, 0x78, 0xdc, 0x38,
    0x70, 0xf1, 0x38, 0xf0, 0xe1, 0xe4, 0x71, 0xff,
    0xff, 0xc8, 0xe7, 0xc3, 0x87, 0xa1, 0xdb, 0x87,
    0xf, 0x3, 0xb7, 0xe, 0x1e, 0x7, 0xce, 0x1c,
    0x3c, 0xe, 0x1c, 0x38, 0x78, 0x1c, 0x38, 0x70,
    0xf0, 0x38, 0x70, 0xe1, 0xe0, 0x70, 0xe1, 0xc3,
    0xc0, 0xe1, 0xc3, 0x87, 0x81, 0xc3, 0x87, 0xf,
    0x3, 0x87, 0xe, 0x1e, 0x7, 0xe, 0x1c, 0x3c,
    0xe, 0x1c, 0x38, 0x78, 0x1c, 0x38, 0x70, 0xf0,
    0x38, 0x70, 0xe1, 0xe0, 0x70, 0xe1, 0xc3, 0xc0,
    0xe1, 0xc3, 0x87, 0x1, 0xc3, 0x87, 0x1e, 0x3,
    0x87, 0xe, 0x70, 0x7, 0xe, 0x1f, 0x0, 0xe,
    0x0, 0x38, 0x0, 0x1c, 0x0, 0x70, 0x0, 0x38,
    0x0, 0xe0, 0x0, 0x70, 0x1, 0xc0, 0x0, 0xe0,
    0x3, 0x80, 0x0,

    /* U+4F4D "位" */
    0x1, 0xf0, 0x8, 0x0, 0x0, 0xf8, 0x6, 0x0,
    0x0, 0x78, 0x3, 0x80, 0x0, 0x3c, 0x0, 0xe0,
    0x0, 0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x38,
    0x0, 0x7, 0x0, 0x1c, 0x0, 0x7, 0x80, 0x6,
    0x0, 0x3, 0xc0, 0x2, 0x0, 0x1, 0xc7, 0xff,
    0xff, 0xc0, 0xe3, 0xff, 0xff, 0xe0, 0x60, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x60, 0x1f, 0x80,
    0x0, 0x30, 0xf, 0xc0, 0x0, 0x18, 0xd, 0xe0,
    0x80, 0x18, 0x4, 0xf0, 0x20, 0xc, 0x4, 0x78,
    0x10, 0x6, 0x2, 0x3c, 0xc, 0x3, 0x2, 0x1e,
    0x6, 0x1, 0x80, 0xf, 0x3, 0x0, 0x80, 0x7,
    0x81, 0xc0, 0xc0, 0x3, 0xc0, 0xe0, 0x60, 0x1,
    0xe0, 0x78, 0x30, 0x0, 0xf0, 0x3c, 0x18, 0x0,
    0x78, 0xe, 0x8, 0x0, 0x3c, 0x7, 0x84, 0x0,
    0x1e, 0x3, 0xc6, 0x0, 0xf, 0x1, 0xe3, 0x0,
    0x7, 0x80, 0xf1, 0x80, 0x3, 0xc0, 0x30, 0xc0,
    0x1, 0xe0, 0x18, 0x40, 0x0, 0xf0, 0x8, 0x60,
    0x0, 0x78, 0x4, 0x30, 0x0, 0x3c, 0x0, 0x18,
    0x0, 0x1e, 0x0, 0xc, 0x0, 0xf, 0x0, 0x4,
    0x0, 0x7, 0x80, 0x2, 0x0, 0x3, 0xc0, 0x3,
    0x0, 0x1, 0xe0, 0x1, 0x80, 0x0, 0xf7, 0xff,
    0xff, 0xe0, 0x7b, 0xff, 0xff, 0xf0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,

    /* U+4F4E "低" */
    0x7, 0xc0, 0x0, 0x10, 0x7, 0xc0, 0x0, 0x78,
    0x7, 0xcf, 0x1, 0xfc, 0x7, 0x8f, 0x7, 0xfe,
    0x7, 0x8f, 0x7f, 0x80, 0x7, 0x8f, 0x87, 0x80,
    0x7, 0x8f, 0x7, 0x80, 0x7, 0x8f, 0x7, 0x80,
    0xf, 0xf, 0x7, 0x80, 0xf, 0xf, 0x7, 0x80,
    0xf, 0xf, 0x7, 0x80, 0xe, 0xf, 0x7, 0x80,
    0xe, 0xf, 0x7, 0x80, 0x1c, 0xf, 0x7, 0x80,
    0x1f, 0xf, 0x7, 0x80, 0x1f, 0xf, 0x7, 0x80,
    0x3f, 0xf, 0xff, 0xff, 0x3f, 0xf, 0xff, 0xff,
    0x2f, 0xf, 0x7, 0x80, 0x6f, 0xf, 0x7, 0x80,
    0x4f, 0xf, 0x7, 0x80, 0x8f, 0xf, 0x7, 0x80,
    0x8f, 0xf, 0x7, 0x80, 0xf, 0xf, 0x7, 0x80,
    0xf, 0xf, 0x7, 0x80, 0xf, 0xf, 0x7, 0x80,
    0xf, 0xf, 0x7, 0x80, 0xf, 0xf, 0x7, 0x80,
    0xf, 0xf, 0x7, 0x80, 0xf, 0xf, 0x7, 0x80,
    0xf, 0xf, 0x7, 0x80, 0xf, 0xf, 0x3, 0xc0,
    0xf, 0xf, 0x3, 0xc0, 0xf, 0xf, 0x13, 0xc2,
    0xf, 0xf, 0x13, 0xe2, 0xf, 0xf, 0x21, 0xe2,
    0xf, 0xf, 0x61, 0xe2, 0xf, 0xf, 0xe1, 0xf2,
    0xf, 0xf, 0xf0, 0xfa, 0xf, 0xf, 0x98, 0xfe,
    0xf, 0x3f, 0x1c, 0x7f, 0xf, 0x3e, 0x1e, 0x3f,
    0xf, 0x3c, 0xe, 0x1f, 0xf, 0x38, 0xc, 0xf,
    0xf, 0x20, 0xc, 0x7, 0xf, 0x0, 0x4, 0x3,

    /* U+4F4F "住" */
    0x3, 0xe0, 0x10, 0x0, 0x3, 0xc0, 0x18, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0x6, 0x0, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xe, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0x1f, 0x0, 0x1e, 0x0,
    0x1f, 0x0, 0x1e, 0x0, 0x1f, 0x0, 0x1e, 0x0,
    0x37, 0x0, 0x1e, 0x0, 0x37, 0x0, 0x1e, 0x0,
    0x67, 0x0, 0x1e, 0x0, 0x67, 0x0, 0x1e, 0x0,
    0xc7, 0xf, 0xff, 0xfc, 0x87, 0xf, 0xff, 0xfc,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x3f, 0xff, 0xff, 0x7, 0x3f, 0xff, 0xff,
    0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0,

    /* U+4F50 "佐" */
    0x1, 0xf0, 0x1e, 0x0, 0x0, 0xf8, 0xf, 0x0,
    0x0, 0x7c, 0x7, 0x80, 0x0, 0x3c, 0x3, 0xc0,
    0x0, 0x1e, 0x1, 0xe0, 0x0, 0xf, 0x0, 0xe0,
    0x0, 0x7, 0x0, 0x70, 0x0, 0x7, 0x9f, 0xff,
    0xff, 0x3, 0xcf, 0xff, 0xff, 0x81, 0xc0, 0x1e,
    0x0, 0x0, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0x7,
    0x0, 0x0, 0x70, 0x3, 0x80, 0x0, 0x3c, 0x3,
    0xc0, 0x0, 0x1e, 0x1, 0xe0, 0x0, 0x1f, 0x0,
    0xf0, 0x0, 0xf, 0x80, 0x70, 0x0, 0xf, 0xc0,
    0x38, 0x0, 0x7, 0xe0, 0x3c, 0x0, 0x6, 0xf0,
    0x1c, 0x0, 0x2, 0x78, 0xe, 0x0, 0x3, 0x3c,
    0x7, 0x0, 0x3, 0x1e, 0x7, 0xff, 0xf8, 0xf,
    0x3, 0xff, 0xfc, 0x7, 0x81, 0xc3, 0x80, 0x3,
    0xc1, 0xc1, 0xc0, 0x1, 0xe0, 0xe0, 0xe0, 0x0,
    0xf0, 0x60, 0x70, 0x0, 0x78, 0x70, 0x38, 0x0,
    0x3c, 0x30, 0x1c, 0x0, 0x1e, 0x18, 0xe, 0x0,
    0xf, 0x18, 0x7, 0x0, 0x7, 0x8c, 0x3, 0x80,
    0x3, 0xcc, 0x1, 0xc0, 0x1, 0xe6, 0x0, 0xe0,
    0x0, 0xf6, 0x0, 0x70, 0x0, 0x7b, 0x0, 0x38,
    0x0, 0x3f, 0x0, 0x1c, 0x0, 0x1f, 0x80, 0xe,
    0x0, 0xf, 0x0, 0x7, 0x0, 0x7, 0x80, 0x3,
    0x80, 0x3, 0xc0, 0x1, 0xc0, 0x1, 0xe3, 0xff,
    0xff, 0xe0, 0xf1, 0xff, 0xff, 0xf0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,

    /* U+4F51 "佑" */
    0x1, 0xf0, 0x7c, 0x0, 0x3, 0xe0, 0x7c, 0x0,
    0x3, 0xe0, 0x7c, 0x0, 0x3, 0xe0, 0x7c, 0x0,
    0x3, 0xc0, 0x7c, 0x0, 0x3, 0xc0, 0x78, 0x0,
    0x3, 0x80, 0x78, 0x0, 0x3, 0x9f, 0xff, 0xff,
    0x7, 0x9f, 0xff, 0xff, 0x7, 0x0, 0x78, 0x0,
    0x7, 0x0, 0x78, 0x0, 0xe, 0x0, 0xf0, 0x0,
    0xe, 0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0x1f, 0x0, 0xe0, 0x0, 0x1f, 0x0, 0xe0, 0x0,
    0x1f, 0x1, 0xe0, 0x0, 0x37, 0x1, 0xc0, 0x0,
    0x27, 0x1, 0xc0, 0x0, 0x67, 0x1, 0xc0, 0x0,
    0x47, 0x3, 0xe0, 0x38, 0x87, 0x3, 0xff, 0xf8,
    0x7, 0x7, 0xff, 0xf8, 0x7, 0x7, 0xe0, 0x38,
    0x7, 0x7, 0xe0, 0x38, 0x7, 0xd, 0xe0, 0x38,
    0x7, 0xd, 0xe0, 0x38, 0x7, 0x19, 0xe0, 0x38,
    0x7, 0x19, 0xe0, 0x38, 0x7, 0x31, 0xe0, 0x38,
    0x7, 0x61, 0xe0, 0x38, 0x7, 0x61, 0xe0, 0x38,
    0x7, 0xc1, 0xe0, 0x38, 0x7, 0x1, 0xe0, 0x38,
    0x7, 0x1, 0xe0, 0x38, 0x7, 0x1, 0xe0, 0x38,
    0x7, 0x1, 0xe0, 0x38, 0x7, 0x1, 0xe0, 0x38,
    0x7, 0x1, 0xe0, 0x38, 0x7, 0x1, 0xe0, 0x38,
    0x7, 0x1, 0xff, 0xf8, 0x7, 0x1, 0xff, 0xf8,
    0x7, 0x1, 0xe0, 0x38, 0x7, 0x1, 0xe0, 0x38,
    0x7, 0x1, 0xe0, 0x38, 0x7, 0x1, 0xe0, 0x38,

    /* U+4F53 "体" */
    0x3, 0xe0, 0x1e, 0x0, 0x1, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c,
    0x0, 0x7, 0x9f, 0xff, 0xff, 0x83, 0xcf, 0xff,
    0xff, 0xc1, 0xc0, 0x1f, 0xa0, 0x0, 0xe0, 0xf,
    0xd0, 0x0, 0xf0, 0x7, 0xe8, 0x0, 0x7c, 0x3,
    0xf4, 0x0, 0x3e, 0x1, 0xfb, 0x0, 0x3f, 0x0,
    0xfd, 0x80, 0x1f, 0x80, 0x7e, 0xc0, 0xf, 0xc0,
    0x3f, 0x20, 0xd, 0xe0, 0x1f, 0x90, 0x6, 0xf0,
    0xf, 0xc8, 0x6, 0x78, 0x7, 0xe4, 0x2, 0x3c,
    0x7, 0xf3, 0x1, 0x1e, 0x3, 0xf9, 0x80, 0xf,
    0x1, 0xfc, 0xc0, 0x7, 0x80, 0xfe, 0x60, 0x3,
    0xc0, 0xef, 0x18, 0x1, 0xe0, 0x77, 0x8c, 0x0,
    0xf0, 0x3b, 0xc7, 0x0, 0x78, 0x39, 0xe3, 0x80,
    0x3c, 0x1c, 0xf1, 0xe0, 0x1e, 0xc, 0x78, 0xf0,
    0xf, 0xe, 0x3c, 0x3c, 0x7, 0x86, 0x1e, 0x1f,
    0x3, 0xc7, 0xf, 0xf, 0xc1, 0xe3, 0xff, 0xff,
    0xe0, 0xf3, 0xff, 0xff, 0xf0, 0x79, 0x81, 0xe0,
    0xf0, 0x3d, 0x80, 0xf0, 0x38, 0x1e, 0x80, 0x78,
    0xc, 0xf, 0xc0, 0x3c, 0x0, 0x7, 0x80, 0x1e,
    0x0, 0x3, 0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7,
    0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1,
    0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0,

    /* U+4F54 "佔" */
    0x7, 0xc0, 0x3c, 0x0, 0xf, 0x80, 0x78, 0x0,
    0x1f, 0x0, 0xf0, 0x0, 0x3e, 0x1, 0xe0, 0x0,
    0x7c, 0x3, 0xc0, 0x0, 0xf0, 0x7, 0x80, 0x1,
    0xe0, 0xf, 0x0, 0x3, 0xc0, 0x1e, 0x0, 0x7,
    0x0, 0x3c, 0x0, 0xe, 0x0, 0x7f, 0xfc, 0x3c,
    0x0, 0xff, 0xf8, 0x70, 0x1, 0xe0, 0x0, 0xe0,
    0x3, 0xc0, 0x1, 0xf0, 0x7, 0x80, 0x7, 0xe0,
    0xf, 0x0, 0xf, 0xc0, 0x1e, 0x0, 0x1f, 0x80,
    0x3c, 0x0, 0x6f, 0x0, 0x78, 0x0, 0xde, 0x0,
    0xf0, 0x1, 0x3c, 0x79, 0xe3, 0xc6, 0x78, 0xf3,
    0xc7, 0x88, 0xf1, 0xe7, 0x8f, 0x31, 0xe3, 0xff,
    0xfe, 0x3, 0xc7, 0xff, 0xfc, 0x7, 0x8f, 0x0,
    0x78, 0xf, 0x1e, 0x0, 0xf0, 0x1e, 0x3c, 0x1,
    0xe0, 0x3c, 0x78, 0x3, 0xc0, 0x78, 0xf0, 0x7,
    0x80, 0xf1, 0xe0, 0xf, 0x1, 0xe3, 0xc0, 0x1e,
    0x3, 0xc7, 0x80, 0x3c, 0x7, 0x8f, 0x0, 0x78,
    0xf, 0x1e, 0x0, 0xf0, 0x1e, 0x3c, 0x1, 0xe0,
    0x3c, 0x78, 0x3, 0xc0, 0x78, 0xf0, 0x7, 0x80,
    0xf1, 0xe0, 0xf, 0x1, 0xe3, 0xc0, 0x1e, 0x3,
    0xc7, 0x80, 0x3c, 0x7, 0x8f, 0xff, 0xf8, 0xf,
    0x1f, 0xff, 0xf0, 0x1e, 0x3c, 0x1, 0xe0, 0x3c,
    0x78, 0x3, 0xc0, 0x78, 0xf0, 0x7, 0x80, 0xf1,
    0xe0, 0xf, 0x0,

    /* U+4F55 "何" */
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xdf, 0xff, 0xff, 0x3, 0xdf, 0xff, 0xff,
    0x3, 0x80, 0x0, 0x78, 0x3, 0x80, 0x0, 0x78,
    0x3, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x0, 0x0, 0x78, 0x7, 0x0, 0x0, 0x78,
    0x7, 0xe, 0x1c, 0x78, 0x6, 0xe, 0x1c, 0x78,
    0xe, 0xf, 0xfc, 0x78, 0xf, 0x8f, 0xfc, 0x78,
    0xf, 0x8e, 0x1c, 0x78, 0x1f, 0x8e, 0x1c, 0x78,
    0x1f, 0x8e, 0x1c, 0x78, 0x17, 0x8e, 0x1c, 0x78,
    0x37, 0x8e, 0x1c, 0x78, 0x27, 0x8e, 0x1c, 0x78,
    0x47, 0x8e, 0x1c, 0x78, 0x47, 0x8e, 0x1c, 0x78,
    0x87, 0x8e, 0x1c, 0x78, 0x7, 0x8e, 0x1c, 0x78,
    0x7, 0x8e, 0x1c, 0x78, 0x7, 0x8e, 0x1c, 0x78,
    0x7, 0x8e, 0x1c, 0x78, 0x7, 0x8f, 0xfc, 0x78,
    0x7, 0x8e, 0x1c, 0x78, 0x7, 0x8e, 0x1c, 0x78,
    0x7, 0x8e, 0x1c, 0x78, 0x7, 0x8e, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x70, 0x7, 0x80, 0x0, 0xe0,
    0x7, 0x80, 0x3, 0xc0, 0x7, 0x80, 0x1f, 0x0,

    /* U+4F57 "佗" */
    0x0, 0x0, 0x8, 0x0, 0x1, 0xe0, 0xc, 0x0,
    0x1, 0xe0, 0xe, 0x0, 0x3, 0xe0, 0x7, 0x0,
    0x3, 0xc0, 0x7, 0x0, 0x3, 0xc0, 0x7, 0x0,
    0x3, 0xcf, 0x2, 0xf, 0x3, 0x8f, 0x2, 0xf,
    0x3, 0x8f, 0xff, 0xff, 0x7, 0x8f, 0xff, 0xff,
    0x7, 0xf, 0x0, 0xf, 0x7, 0xf, 0x0, 0xf,
    0xf, 0xf, 0x0, 0x8, 0xf, 0xc0, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x0, 0x1f, 0xc0, 0xf0, 0x0,
    0x1b, 0xc0, 0xf0, 0x0, 0x1b, 0xc0, 0xf0, 0x0,
    0x33, 0xc0, 0xf0, 0x18, 0x33, 0xc0, 0xf0, 0x18,
    0x63, 0xc0, 0xf0, 0x38, 0x43, 0xc0, 0xf0, 0x70,
    0x83, 0xc0, 0xf0, 0x60, 0x83, 0xc0, 0xf0, 0xc0,
    0x3, 0xc0, 0xf1, 0xc0, 0x3, 0xc0, 0xf1, 0x80,
    0x3, 0xc0, 0xf3, 0x0, 0x3, 0xc0, 0xf6, 0x0,
    0x3, 0xc0, 0xfe, 0x0, 0x3, 0xc0, 0xfc, 0x0,
    0x3, 0xc0, 0xf8, 0x0, 0x3, 0xc0, 0xf8, 0x0,
    0x3, 0xc0, 0xf0, 0x2, 0x3, 0xc0, 0xf0, 0x2,
    0x3, 0xc0, 0xf0, 0x2, 0x3, 0xc0, 0xf0, 0x2,
    0x3, 0xc0, 0xf0, 0x2, 0x3, 0xc0, 0xf0, 0x2,
    0x3, 0xc0, 0xf0, 0x6, 0x3, 0xc0, 0xf0, 0x7,
    0x3, 0xc0, 0xf0, 0x7, 0x3, 0xc0, 0xf0, 0x7,
    0x3, 0xc0, 0xf0, 0xf, 0x3, 0xc0, 0xff, 0xfe,
    0x3, 0xc0, 0xff, 0xfe, 0x3, 0xc0, 0x7f, 0xfc,

    /* U+4F58 "佘" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x1, 0xf4, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0xf9, 0x80,
    0x0, 0x0, 0x7c, 0x60, 0x0, 0x0, 0x3c, 0x30,
    0x0, 0x0, 0x3c, 0xc, 0x0, 0x0, 0x1c, 0x7,
    0x0, 0x0, 0x1e, 0x1, 0xc0, 0x0, 0x1e, 0x0,
    0xf8, 0x0, 0xe, 0x0, 0x3f, 0x0, 0xe, 0x0,
    0xf, 0xe0, 0xe, 0x0, 0x3, 0xfe, 0xf, 0xff,
    0xff, 0xfe, 0x6, 0xff, 0xff, 0xbf, 0x4, 0x0,
    0x0, 0xf, 0x84, 0x0, 0x0, 0x1, 0xc4, 0x0,
    0x0, 0x0, 0x2c, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x0,
    0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x78, 0x7c, 0x40, 0x0, 0x3c, 0x3e, 0x10, 0x0,
    0x1e, 0x1f, 0x8, 0x0, 0xf, 0xf, 0x84, 0x0,
    0x7, 0x87, 0xc3, 0x0, 0x3, 0xc3, 0xe1, 0x80,
    0x1, 0xc1, 0xf0, 0xe0, 0x1, 0xe0, 0xf8, 0x38,
    0x0, 0xe0, 0x7c, 0x1e, 0x0, 0x70, 0x3e, 0xf,
    0x80, 0x30, 0x1f, 0x3, 0xf0, 0x38, 0xf, 0x81,
    0xf8, 0x18, 0x7, 0xc0, 0x78, 0x18, 0x3, 0xe0,
    0x3c, 0xc, 0x1, 0xf0, 0xe, 0xc, 0x0, 0xf8,
    0x3, 0x4, 0x0, 0x78, 0x0, 0x80, 0x0, 0x7c,
    0x0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+4F59 "余" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0xfb, 0x0, 0x0, 0x0, 0x7c, 0xc0,
    0x0, 0x0, 0x3c, 0x70, 0x0, 0x0, 0x3c, 0x38,
    0x0, 0x0, 0x1e, 0xe, 0x0, 0x0, 0x1e, 0x7,
    0xc0, 0x0, 0x1e, 0x1, 0xf0, 0x0, 0xe, 0x0,
    0x7c, 0x0, 0xe, 0x0, 0x1f, 0x80, 0xe, 0x0,
    0xf, 0xf8, 0xc, 0x0, 0x3, 0xfe, 0xf, 0xff,
    0xff, 0xfe, 0x1d, 0xff, 0xff, 0xdf, 0x18, 0x0,
    0xf0, 0x7, 0x98, 0x0, 0x78, 0x0, 0xd0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x7f,
    0xff, 0xff, 0xfc, 0x3f, 0xff, 0xff, 0xfe, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x40, 0x0, 0x3e, 0x1e, 0x10, 0x0,
    0x1f, 0xf, 0x8, 0x0, 0xf, 0x87, 0x86, 0x0,
    0x7, 0x83, 0xc3, 0x0, 0x3, 0xc1, 0xe1, 0x80,
    0x1, 0xe0, 0xf0, 0xe0, 0x0, 0xe0, 0x78, 0x78,
    0x0, 0x70, 0x3c, 0x1c, 0x0, 0x70, 0x1e, 0xf,
    0x0, 0x38, 0xf, 0x7, 0xc0, 0x18, 0x7, 0x81,
    0xf0, 0x18, 0x3, 0xc0, 0xfc, 0x8, 0x1, 0xe0,
    0x3c, 0xc, 0x0, 0xf0, 0x1e, 0xc, 0x0, 0xf0,
    0x7, 0xc, 0x1, 0xf0, 0x1, 0x0, 0x3, 0xf0,
    0x0, 0x0, 0x6, 0x40, 0x0, 0x0,

    /* U+4F5A "佚" */
    0x1, 0xf0, 0xf, 0x0, 0x0, 0xf8, 0x7, 0x80,
    0x0, 0x7c, 0x3, 0xc0, 0x0, 0x3c, 0x3d, 0xe0,
    0x0, 0x1e, 0x1e, 0xf0, 0x0, 0xf, 0xf, 0x78,
    0x0, 0x7, 0x7, 0x3c, 0x0, 0x7, 0x83, 0x9e,
    0x0, 0x3, 0xc3, 0xcf, 0x0, 0x1, 0xc1, 0xe7,
    0x80, 0x0, 0xe0, 0xff, 0xff, 0xc0, 0x60, 0x7f,
    0xff, 0xe0, 0x70, 0x38, 0xf0, 0x0, 0x3c, 0x18,
    0x78, 0x0, 0x1e, 0x1c, 0x3c, 0x0, 0x1f, 0xe,
    0x1e, 0x0, 0xf, 0x86, 0xf, 0x0, 0xd, 0xc3,
    0x7, 0x80, 0x4, 0xe3, 0x3, 0xc0, 0x6, 0x71,
    0x1, 0xe0, 0x6, 0x38, 0x0, 0xf0, 0x6, 0x1c,
    0x0, 0x78, 0x0, 0xe, 0x7f, 0xff, 0xfe, 0x7,
    0x3f, 0xff, 0xff, 0x3, 0x80, 0xf, 0x0, 0x1,
    0xc0, 0x7, 0x80, 0x0, 0xe0, 0x3, 0xc0, 0x0,
    0x70, 0x1, 0xe0, 0x0, 0x38, 0x1, 0xf0, 0x0,
    0x1c, 0x0, 0xfc, 0x0, 0xe, 0x0, 0x7e, 0x0,
    0x7, 0x0, 0x3b, 0x0, 0x3, 0x80, 0x1c, 0xc0,
    0x1, 0xc0, 0x1c, 0x60, 0x0, 0xe0, 0xe, 0x38,
    0x0, 0x70, 0x6, 0x1c, 0x0, 0x38, 0x7, 0x7,
    0x0, 0x1c, 0x3, 0x3, 0xc0, 0xe, 0x3, 0x1,
    0xf0, 0x7, 0x1, 0x80, 0x7e, 0x3, 0x81, 0x80,
    0x3f, 0x1, 0xc1, 0x80, 0xf, 0x0, 0xe0, 0x80,
    0x3, 0x80, 0x70, 0x80, 0x1, 0xc0, 0x38, 0x80,
    0x0, 0x60, 0x1c, 0x80, 0x0, 0x10,

    /* U+4F5B "佛" */
    0x3, 0xc0, 0xf7, 0x0, 0x7, 0x81, 0xee, 0x0,
    0xf, 0x3, 0xdc, 0x0, 0x1e, 0x7, 0xb8, 0x0,
    0x3c, 0xf, 0x70, 0x0, 0x78, 0x1e, 0xe3, 0x80,
    0xf0, 0x3d, 0xc7, 0x3, 0xcf, 0xff, 0xfe, 0x7,
    0x9f, 0xff, 0xfc, 0xf, 0x1, 0xee, 0x38, 0x1c,
    0x3, 0xdc, 0x70, 0x38, 0x7, 0xb8, 0xe0, 0x70,
    0xf, 0x71, 0xc1, 0xc3, 0x9e, 0xe3, 0x83, 0xc7,
    0x3d, 0xc7, 0x7, 0x8f, 0xff, 0xfe, 0x1f, 0x1f,
    0xff, 0xfc, 0x3e, 0x39, 0xee, 0x38, 0x5c, 0x73,
    0xdc, 0x71, 0xb8, 0xe7, 0xb8, 0x2, 0x71, 0xcf,
    0x70, 0x8, 0xe3, 0x9e, 0xe0, 0x21, 0xc7, 0x3d,
    0xc3, 0x83, 0x8e, 0x7b, 0x87, 0x7, 0x1f, 0xff,
    0xfe, 0xe, 0x3f, 0xff, 0xfc, 0x1c, 0x73, 0xdc,
    0x38, 0x38, 0xe7, 0xb8, 0x70, 0x71, 0xcf, 0x70,
    0xe0, 0xe0, 0x1e, 0xe1, 0xc1, 0xc0, 0x3d, 0xc3,
    0x83, 0x80, 0x7b, 0x87, 0x7, 0x0, 0xf7, 0xe,
    0xe, 0x1, 0xee, 0x1c, 0x1c, 0x3, 0x9c, 0x38,
    0x38, 0x7, 0x38, 0x70, 0x70, 0x1e, 0x70, 0xe0,
    0xe0, 0x38, 0xe1, 0xc1, 0xc0, 0x71, 0xc7, 0x3,
    0x81, 0xc3, 0x8e, 0x7, 0x3, 0x7, 0xf0, 0xe,
    0xe, 0xe, 0x0, 0x1c, 0x18, 0x1c, 0x0, 0x38,
    0x60, 0x38, 0x0, 0x70, 0x80, 0x70, 0x0, 0xe2,
    0x0, 0xe0, 0x0,

    /* U+4F5C "作" */
    0x1, 0xf0, 0x3e, 0x0, 0x1, 0xf0, 0x3e, 0x0,
    0x3, 0xe0, 0x3e, 0x0, 0x3, 0xe0, 0x3c, 0x0,
    0x3, 0xe0, 0x7c, 0x0, 0x3, 0xe0, 0x7c, 0x0,
    0x3, 0xe0, 0x78, 0x0, 0x3, 0xc0, 0x78, 0x0,
    0x3, 0xc0, 0xf0, 0x0, 0x3, 0x80, 0xff, 0xff,
    0x7, 0x80, 0xff, 0xff, 0x7, 0x81, 0xfe, 0x0,
    0x7, 0xc1, 0xde, 0x0, 0xf, 0xc1, 0xde, 0x0,
    0xf, 0xc3, 0x9e, 0x0, 0xf, 0xc7, 0x1e, 0x0,
    0x1b, 0xc6, 0x1e, 0x0, 0x1b, 0xcc, 0x1e, 0x0,
    0x33, 0xd8, 0x1e, 0x0, 0x23, 0xf0, 0x1e, 0x0,
    0x63, 0xc0, 0x1f, 0xfe, 0xc3, 0xc0, 0x1f, 0xfe,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1f, 0xff, 0x3, 0xc0, 0x1f, 0xff,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,

    /* U+4F5D "佝" */
    0x7, 0xe1, 0xe0, 0x0, 0xf, 0xc3, 0xc0, 0x0,
    0x1f, 0x87, 0x80, 0x0, 0x3e, 0xf, 0x0, 0x0,
    0x7c, 0x1c, 0x1, 0xe0, 0xf8, 0x78, 0x3, 0xc1,
    0xf0, 0xf0, 0x7, 0x83, 0xe1, 0xff, 0xff, 0x7,
    0x83, 0xff, 0xfe, 0xf, 0x7, 0x0, 0x3c, 0x3e,
    0x1c, 0x0, 0x78, 0x78, 0x38, 0x0, 0xf0, 0xf0,
    0x60, 0x1, 0xe1, 0xf1, 0xc0, 0x3, 0xc7, 0xe3,
    0x0, 0x7, 0x8f, 0xcf, 0x87, 0xf, 0x1f, 0x9f,
    0xe, 0x1e, 0x7f, 0x6f, 0xfc, 0x3c, 0xdf, 0x9f,
    0xf8, 0x7b, 0x3c, 0x38, 0x70, 0xf6, 0x78, 0x70,
    0xe1, 0xe8, 0xf0, 0xe1, 0xc3, 0xc1, 0xe1, 0xc3,
    0x87, 0x83, 0xc3, 0x87, 0xf, 0x7, 0x87, 0xe,
    0x1e, 0xf, 0xe, 0x1c, 0x3c, 0x1e, 0x1c, 0x38,
    0x78, 0x3c, 0x38, 0x70, 0xf0, 0x78, 0x70, 0xe1,
    0xe0, 0xf0, 0xff, 0xc3, 0xc1, 0xe1, 0xff, 0x87,
    0x83, 0xc3, 0x87, 0xf, 0x7, 0x87, 0xe, 0x1e,
    0xf, 0xe, 0x1c, 0x3c, 0x1e, 0x1c, 0x38, 0x78,
    0x3c, 0x0, 0x0, 0xf0, 0x78, 0x0, 0x1, 0xe0,
    0xf0, 0x0, 0x3, 0xc1, 0xe0, 0x0, 0x7, 0x83,
    0xc0, 0x0, 0xf, 0x7, 0x80, 0x0, 0x1e, 0xf,
    0x0, 0x0, 0x3c, 0x1e, 0x0, 0x0, 0xf8, 0x3c,
    0x0, 0x3, 0xe0, 0x78, 0x0, 0x1f, 0x80, 0xf0,
    0x0, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4F5E "佞" */
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x1, 0xf1, 0xff, 0xff, 0x0, 0xf8, 0xff, 0xff,
    0x80, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x0, 0xe3, 0xff, 0xff, 0xf0, 0xfd, 0xff,
    0xff, 0xf8, 0x7e, 0x0, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x0, 0x37, 0x80, 0x3c, 0x0, 0x1b, 0xc0,
    0x1e, 0x0, 0x9, 0xe0, 0x1f, 0x0, 0xc, 0xf0,
    0xf, 0x0, 0x4, 0x78, 0x7, 0x80, 0x6, 0x3c,
    0x3, 0xc0, 0x2, 0x1e, 0x3, 0xe0, 0x0, 0xf,
    0x7f, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff, 0x83,
    0xc0, 0x78, 0x38, 0x1, 0xe0, 0x3c, 0x1c, 0x0,
    0xf0, 0x3c, 0xe, 0x0, 0x78, 0x1e, 0x7, 0x0,
    0x3c, 0xf, 0x7, 0x80, 0x1e, 0xf, 0x3, 0xc0,
    0xf, 0x7, 0x81, 0xe0, 0x7, 0x83, 0xc0, 0xe0,
    0x3, 0xc1, 0xf0, 0xf0, 0x1, 0xe1, 0xec, 0x70,
    0x0, 0xf0, 0xf3, 0xf8, 0x0, 0x78, 0x0, 0xf8,
    0x0, 0x3c, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3f,
    0x0, 0xf, 0x0, 0x3b, 0xe0, 0x7, 0x80, 0x38,
    0xf8, 0x3, 0xc0, 0x30, 0x3f, 0x1, 0xe0, 0x60,
    0xf, 0xc0, 0xf0, 0x60, 0x1, 0xe0, 0x78, 0xc0,
    0x0, 0x70, 0x3c, 0xc0, 0x0, 0x8,

    /* U+4F5F "佟" */
    0x7, 0xc0, 0xf8, 0x0, 0x7, 0xc0, 0xf8, 0x0,
    0x7, 0x80, 0xf0, 0x0, 0x7, 0x80, 0xf0, 0x7c,
    0x7, 0x80, 0xf0, 0x7c, 0x7, 0x80, 0xff, 0xfc,
    0x7, 0x1, 0xff, 0xfc, 0xf, 0x1, 0xe0, 0x7c,
    0xf, 0x1, 0xc0, 0x7c, 0xf, 0x1, 0xc0, 0x78,
    0xe, 0x3, 0x80, 0x78, 0xe, 0x3, 0x80, 0x78,
    0xc, 0x7, 0x40, 0xf8, 0x1f, 0x6, 0x40, 0xf0,
    0x1f, 0xc, 0x60, 0xf0, 0x1f, 0x8, 0x21, 0xe0,
    0x3f, 0x10, 0x31, 0xe0, 0x37, 0x20, 0x1b, 0xc0,
    0x37, 0x0, 0x1f, 0x80, 0x67, 0x0, 0xf, 0x80,
    0x47, 0x0, 0xf, 0x0, 0xc7, 0x0, 0x1f, 0xc0,
    0x7, 0x0, 0x3b, 0xf8, 0x7, 0x0, 0x71, 0xff,
    0x7, 0x1, 0xe0, 0xff, 0x7, 0x3, 0x80, 0x7e,
    0x7, 0x7, 0x0, 0x3e, 0x7, 0xc, 0x10, 0xf,
    0x7, 0x38, 0xc, 0x3, 0x7, 0x70, 0xe, 0x0,
    0x7, 0x0, 0xf, 0x80, 0x7, 0x0, 0x7, 0x80,
    0x7, 0x0, 0x3, 0x80, 0x7, 0x0, 0x3, 0x80,
    0x7, 0x0, 0x1, 0x0, 0x7, 0x1, 0x0, 0x0,
    0x7, 0x0, 0xc0, 0x0, 0x7, 0x0, 0x78, 0x0,
    0x7, 0x0, 0x3e, 0x0, 0x7, 0x0, 0x1f, 0xc0,
    0x7, 0x0, 0xf, 0xe0, 0x7, 0x0, 0x7, 0xe0,
    0x7, 0x0, 0x3, 0xe0, 0x7, 0x0, 0x0, 0xe0,
    0x7, 0x0, 0x0, 0x60, 0x7, 0x0, 0x0, 0x0,

    /* U+4F60 "你" */
    0x3, 0xe0, 0xf8, 0x0, 0x1, 0xf0, 0x7c, 0x0,
    0x0, 0xf8, 0x3e, 0x0, 0x0, 0x7c, 0x1f, 0x0,
    0x0, 0x3c, 0xf, 0x0, 0x0, 0x1e, 0x7, 0x80,
    0x0, 0xf, 0x3, 0xc0, 0x78, 0x7, 0x3, 0xc0,
    0x3c, 0x7, 0x81, 0xff, 0xfe, 0x3, 0xc0, 0xff,
    0xff, 0x1, 0xc0, 0x70, 0x7, 0x80, 0xe0, 0x78,
    0x3, 0xc0, 0x70, 0x38, 0x1, 0xe0, 0x7c, 0x18,
    0x0, 0xf0, 0x3e, 0x18, 0x3c, 0x40, 0x3f, 0x1c,
    0x1e, 0x20, 0x1f, 0x8c, 0xf, 0x0, 0xb, 0xcc,
    0x7, 0x80, 0xd, 0xec, 0x3, 0xc4, 0x4, 0xfc,
    0x1, 0xe2, 0x4, 0x78, 0x3c, 0xf1, 0x4, 0x3c,
    0x1e, 0x78, 0x80, 0x1e, 0xf, 0x3c, 0x40, 0xf,
    0x7, 0x9e, 0x20, 0x7, 0x83, 0xcf, 0x10, 0x3,
    0xc1, 0xc7, 0x88, 0x1, 0xe0, 0xe3, 0xc6, 0x0,
    0xf0, 0xf1, 0xe3, 0x0, 0x78, 0x78, 0xf1, 0xc0,
    0x3c, 0x38, 0x78, 0xe0, 0x1e, 0x1c, 0x3c, 0x78,
    0xf, 0xc, 0x1e, 0x3e, 0x7, 0x8e, 0xf, 0xf,
    0x83, 0xc6, 0x7, 0x87, 0xc1, 0xe3, 0x3, 0xc3,
    0xe0, 0xf3, 0x1, 0xe0, 0xe0, 0x79, 0x0, 0xf0,
    0x70, 0x3d, 0x80, 0x78, 0x18, 0x1f, 0x80, 0x3c,
    0x4, 0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x7,
    0xc0, 0x0, 0xf0, 0x7, 0xc0, 0x0, 0x78, 0x7,
    0xc0, 0x0, 0x3c, 0x1f, 0x80, 0x0, 0x0, 0x10,
    0x0, 0x0,

    /* U+4F63 "佣" */
    0x7, 0xcf, 0x0, 0x1e, 0xf, 0x9e, 0x0, 0x3c,
    0x1f, 0x3f, 0xff, 0xf8, 0x3e, 0x7f, 0xff, 0xf0,
    0x78, 0xf1, 0xe1, 0xe0, 0xf1, 0xe3, 0xc3, 0xc1,
    0xe3, 0xc7, 0x87, 0x83, 0xc7, 0x8f, 0xf, 0xf,
    0xf, 0x1e, 0x1e, 0x1e, 0x1e, 0x3c, 0x3c, 0x3c,
    0x3c, 0x78, 0x78, 0x70, 0x78, 0xf0, 0xf0, 0xe0,
    0xf1, 0xe1, 0xe3, 0xe1, 0xe3, 0xc3, 0xc7, 0xc3,
    0xff, 0xff, 0x8f, 0x87, 0xff, 0xff, 0x1f, 0xf,
    0x1e, 0x1e, 0x5e, 0x1e, 0x3c, 0x3c, 0xbc, 0x3c,
    0x78, 0x7a, 0x78, 0x78, 0xf0, 0xf4, 0xf0, 0xf1,
    0xe1, 0xf1, 0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7,
    0x87, 0x87, 0x87, 0x8f, 0xf, 0xf, 0xf, 0x1e,
    0x1e, 0x1e, 0x1f, 0xff, 0xfc, 0x3c, 0x3f, 0xff,
    0xf8, 0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf1, 0xe1,
    0xe1, 0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7, 0x87,
    0x87, 0x87, 0x8f, 0xf, 0xf, 0xf, 0x1e, 0x1e,
    0x1e, 0x1e, 0x3c, 0x3c, 0x3c, 0x3c, 0x78, 0x78,
    0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf1, 0xe1, 0xe1,
    0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0x87, 0x87, 0x87,
    0x87, 0xf, 0xf, 0xf, 0xe, 0x1e, 0x1e, 0x1e,
    0x38, 0x3c, 0x3c, 0x3c, 0x70, 0x78, 0x78, 0x78,
    0xc0, 0xf1, 0xe0, 0xf3, 0x0, 0x7, 0x81, 0xe4,
    0x0, 0x7c, 0x0,

    /* U+4F64 "佤" */
    0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x7, 0x9f, 0xff, 0xfe, 0x7, 0x9f, 0xff, 0xfe,
    0x7, 0x83, 0xc0, 0x0, 0x7, 0x83, 0xc0, 0x0,
    0x7, 0x83, 0xc0, 0x0, 0x7, 0x3, 0xc0, 0x0,
    0x7, 0x3, 0xc0, 0x0, 0x7, 0x3, 0xc0, 0xf0,
    0xf, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xff, 0xf0,
    0xe, 0x3, 0xff, 0xf0, 0xc, 0x3, 0x80, 0xf0,
    0xf, 0x3, 0x80, 0xf0, 0x1f, 0x3, 0x80, 0xf0,
    0x1f, 0x3, 0x80, 0xf0, 0x17, 0x3, 0x90, 0xf0,
    0x37, 0x3, 0x90, 0xf0, 0x27, 0x3, 0x98, 0xf0,
    0x67, 0x3, 0x98, 0xf0, 0x47, 0x3, 0x9c, 0xf0,
    0x87, 0x3, 0x8c, 0xf0, 0x7, 0x3, 0x8e, 0xf0,
    0x7, 0x3, 0x8e, 0xf0, 0x7, 0x3, 0x8c, 0xf0,
    0x7, 0x3, 0x8c, 0xf0, 0x7, 0x3, 0x84, 0xf0,
    0x7, 0x3, 0x80, 0xf0, 0x7, 0x3, 0x80, 0xf0,
    0x7, 0x3, 0x80, 0xf2, 0x7, 0x3, 0x80, 0xf2,
    0x7, 0x3, 0x80, 0xf2, 0x7, 0x7, 0x81, 0xf2,
    0x7, 0x7, 0x3, 0xf2, 0x7, 0x7, 0x6, 0xf2,
    0x7, 0x6, 0xc, 0xf3, 0x7, 0x4, 0x38, 0xf3,
    0x7, 0xc, 0xf0, 0xf3, 0x7, 0xf, 0xe0, 0xf3,
    0x7, 0x1f, 0xc0, 0xf3, 0x7, 0xf, 0x80, 0xff,
    0x7, 0xe, 0x0, 0xff, 0x7, 0xc, 0x0, 0xff,
    0x7, 0x10, 0x0, 0x7e, 0x7, 0x0, 0x0, 0x0,

    /* U+4F65 "佥" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x0, 0x7f, 0x0, 0x0, 0x0, 0x3c, 0xc0,
    0x0, 0x0, 0x3e, 0x60, 0x0, 0x0, 0x1e, 0x18,
    0x0, 0x0, 0xf, 0xe, 0x0, 0x0, 0xf, 0x7,
    0x80, 0x0, 0x7, 0x81, 0xe0, 0x0, 0x7, 0x80,
    0x78, 0x0, 0x3, 0x80, 0x3f, 0x0, 0x3, 0x80,
    0xf, 0xf0, 0x1, 0xc0, 0x3, 0xfe, 0x1, 0xc0,
    0x1, 0xff, 0x1, 0xc0, 0x0, 0x7f, 0x81, 0xc0,
    0x0, 0xf, 0x80, 0xff, 0xff, 0xfb, 0xc0, 0xdf,
    0xff, 0xfc, 0xe0, 0xc0, 0x0, 0x0, 0x18, 0xc0,
    0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0xc0,
    0x2, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x80, 0x3c, 0x0, 0x0, 0x60, 0x1e, 0x0,
    0x20, 0x30, 0xf, 0x0, 0x10, 0x1c, 0x7, 0x80,
    0xc, 0xe, 0x3, 0xc0, 0x6, 0x7, 0x81, 0xc0,
    0x3, 0x83, 0xc1, 0xe0, 0x1, 0xc1, 0xf0, 0xf0,
    0x0, 0xf0, 0xf8, 0x78, 0x0, 0x78, 0x3c, 0x3c,
    0x0, 0x1e, 0x1e, 0x1c, 0x0, 0xf, 0xf, 0xe,
    0x0, 0x7, 0x87, 0xf, 0x0, 0x3, 0xe1, 0x7,
    0x0, 0x1, 0xe0, 0x83, 0x0, 0x0, 0x70, 0x3,
    0x80, 0x0, 0x30, 0x1, 0x80, 0x0, 0x10, 0x1,
    0x80, 0x0, 0x0, 0x0, 0x80, 0x3, 0xff, 0xff,
    0xff, 0xf1, 0xff, 0xff, 0xff, 0xf8,

    /* U+4F67 "佧" */
    0x3, 0xc0, 0x78, 0x0, 0x3, 0xc0, 0x78, 0x0,
    0x3, 0xc0, 0x78, 0x0, 0x3, 0xc0, 0x78, 0x0,
    0x3, 0x80, 0x78, 0x0, 0x3, 0x80, 0x78, 0x0,
    0x3, 0x80, 0x78, 0x0, 0x7, 0x80, 0x78, 0x0,
    0x7, 0x80, 0x7f, 0xf8, 0x7, 0x0, 0x7f, 0xf8,
    0x7, 0x0, 0x78, 0x0, 0x7, 0x0, 0x78, 0x0,
    0xe, 0x0, 0x78, 0x0, 0xf, 0x0, 0x78, 0x0,
    0xf, 0x0, 0x78, 0x0, 0x1f, 0x0, 0x78, 0x0,
    0x1f, 0x0, 0x78, 0x0, 0x1f, 0x0, 0x78, 0x0,
    0x37, 0x7f, 0xff, 0xff, 0x27, 0x7f, 0xff, 0xff,
    0x67, 0x0, 0x78, 0x0, 0xc7, 0x0, 0x78, 0x0,
    0x87, 0x0, 0x78, 0x0, 0x7, 0x0, 0x79, 0x0,
    0x7, 0x0, 0x79, 0x0, 0x7, 0x0, 0x79, 0x0,
    0x7, 0x0, 0x78, 0x80, 0x7, 0x0, 0x78, 0x80,
    0x7, 0x0, 0x78, 0xc0, 0x7, 0x0, 0x78, 0xc0,
    0x7, 0x0, 0x78, 0xe0, 0x7, 0x0, 0x78, 0xf0,
    0x7, 0x0, 0x78, 0xf8, 0x7, 0x0, 0x78, 0x7c,
    0x7, 0x0, 0x78, 0x7c, 0x7, 0x0, 0x78, 0x3c,
    0x7, 0x0, 0x78, 0x3c, 0x7, 0x0, 0x78, 0x1c,
    0x7, 0x0, 0x78, 0xc, 0x7, 0x0, 0x78, 0x4,
    0x7, 0x0, 0x78, 0x0, 0x7, 0x0, 0x78, 0x0,
    0x7, 0x0, 0x78, 0x0, 0x7, 0x0, 0x78, 0x0,
    0x7, 0x0, 0x78, 0x0, 0x7, 0x0, 0x78, 0x0,

    /* U+4F69 "佩" */
    0x1e, 0xf0, 0x0, 0x3c, 0x1e, 0xf0, 0x0, 0x3c,
    0x1e, 0xff, 0xff, 0xfc, 0x1e, 0xff, 0xff, 0xfc,
    0x1e, 0xf0, 0x0, 0x3c, 0x1c, 0xf0, 0x0, 0x3c,
    0x1c, 0xf0, 0x0, 0x3c, 0x1c, 0xf0, 0x0, 0x3c,
    0x1c, 0xf0, 0x0, 0x3c, 0x18, 0xf7, 0xff, 0xbc,
    0x3c, 0xf7, 0xff, 0xbc, 0x3c, 0xf0, 0x70, 0x3c,
    0x3c, 0xf0, 0x70, 0x3c, 0x3c, 0xf0, 0x70, 0x3c,
    0x3c, 0xf0, 0x70, 0x3c, 0x7c, 0xf0, 0x70, 0x3c,
    0x5c, 0xf7, 0x73, 0xbc, 0x5c, 0xf7, 0x73, 0xbc,
    0x9c, 0xf7, 0xff, 0xbc, 0x9c, 0xf7, 0xff, 0xbc,
    0x1c, 0xf7, 0x73, 0xbc, 0x1c, 0xf7, 0x73, 0xbc,
    0x1c, 0xf7, 0x73, 0xbc, 0x1c, 0xf7, 0x73, 0xbc,
    0x1c, 0xf7, 0x73, 0xbc, 0x1c, 0xf7, 0x73, 0xbc,
    0x1c, 0xf7, 0x73, 0xbc, 0x1c, 0xf7, 0x73, 0xbc,
    0x1c, 0xf7, 0x73, 0xbc, 0x1c, 0xf7, 0x73, 0xbc,
    0x1c, 0xf7, 0x73, 0xbc, 0x1c, 0xf7, 0x73, 0xbc,
    0x1c, 0xf7, 0x73, 0xbd, 0x1c, 0xf7, 0x73, 0xbd,
    0x1c, 0xf7, 0x73, 0xb9, 0x1c, 0xf7, 0x73, 0xb9,
    0x1c, 0xe7, 0x73, 0xbd, 0x1c, 0xe7, 0x7f, 0x3f,
    0x1c, 0xe0, 0x70, 0x3e, 0x1c, 0xc0, 0x70, 0x3e,
    0x1c, 0xc0, 0x70, 0x1f, 0x1d, 0x80, 0x70, 0x1f,
    0x1d, 0x80, 0x70, 0xf, 0x1d, 0x0, 0x70, 0x7,
    0x1f, 0x0, 0x70, 0x3, 0x1e, 0x0, 0x70, 0x1,

    /* U+4F6C "佬" */
    0x1, 0xf0, 0x1c, 0x0, 0x0, 0xf8, 0xe, 0x0,
    0x0, 0x78, 0x7, 0x0, 0x0, 0x7c, 0x3, 0x80,
    0x0, 0x3e, 0x1, 0xc1, 0xe0, 0x1f, 0x0, 0xe0,
    0xf0, 0xf, 0x0, 0x70, 0x78, 0x7, 0x87, 0xff,
    0xfc, 0x3, 0xc3, 0xff, 0xfe, 0x1, 0xc0, 0xe,
    0x1e, 0x0, 0xe0, 0x7, 0xf, 0x0, 0xf0, 0x3,
    0x87, 0x0, 0x70, 0x1, 0xc7, 0x80, 0x3c, 0x0,
    0xe3, 0xc0, 0x3e, 0x0, 0x71, 0xc0, 0x1f, 0x0,
    0x39, 0xc0, 0xf, 0x80, 0x1d, 0xe0, 0xf, 0xcf,
    0xff, 0xff, 0xc5, 0xe7, 0xff, 0xff, 0xe6, 0xf0,
    0x0, 0xf0, 0x2, 0x78, 0x0, 0x70, 0x3, 0x3c,
    0x0, 0x70, 0x3, 0x1e, 0x0, 0x70, 0x0, 0xf,
    0x3, 0xf0, 0x0, 0x7, 0x81, 0xf0, 0x0, 0x3,
    0xc0, 0xf0, 0x0, 0x1, 0xe0, 0xf8, 0x8, 0x0,
    0xf0, 0xfc, 0xe, 0x0, 0x78, 0xfe, 0xe, 0x0,
    0x3c, 0xef, 0xc, 0x0, 0x1e, 0xe7, 0x8c, 0x0,
    0xf, 0xe3, 0xcc, 0x0, 0x7, 0xc1, 0xec, 0x4,
    0x3, 0xc0, 0xfc, 0x2, 0x1, 0xe0, 0x7c, 0x1,
    0x0, 0xf0, 0x3c, 0x0, 0x80, 0x78, 0x1e, 0x0,
    0x40, 0x3c, 0xf, 0x0, 0x20, 0x1e, 0x7, 0x80,
    0x30, 0xf, 0x3, 0xc0, 0x18, 0x7, 0x81, 0xe0,
    0xc, 0x3, 0xc0, 0xf0, 0x6, 0x1, 0xe0, 0x7c,
    0x7, 0x0, 0xf0, 0x3f, 0xff, 0x80, 0x78, 0xf,
    0xff, 0xc0, 0x3c, 0x3, 0xff, 0xc0,

    /* U+4F6F "佯" */
    0x1, 0xe0, 0x0, 0x10, 0x1, 0xe1, 0x0, 0x30,
    0x1, 0xc1, 0x80, 0x70, 0x3, 0xc1, 0xc0, 0x60,
    0x3, 0xc0, 0xe0, 0xe0, 0x3, 0xc0, 0xf0, 0xc0,
    0x3, 0x80, 0x61, 0xc0, 0x3, 0x80, 0x61, 0x80,
    0x7, 0x80, 0x23, 0x80, 0x7, 0x1f, 0xff, 0xfe,
    0x7, 0x1f, 0xff, 0xfe, 0x7, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x80, 0x1e, 0x0,
    0x1f, 0x80, 0x1e, 0x0, 0x1f, 0x80, 0x1e, 0x0,
    0x1f, 0x80, 0x1e, 0x0, 0x37, 0x80, 0x1e, 0x0,
    0x37, 0x80, 0x1e, 0x0, 0x67, 0x8f, 0xff, 0xfc,
    0x67, 0x8f, 0xff, 0xfc, 0xc7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,

    /* U+4F70 "佰" */
    0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0,
    0x0, 0xfb, 0xff, 0xff, 0xe0, 0x7d, 0xff, 0xff,
    0xf0, 0x3c, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x70,
    0x0, 0xf, 0x0, 0x38, 0x0, 0x7, 0x80, 0x1c,
    0x0, 0x7, 0x80, 0xe, 0x0, 0x3, 0xc0, 0x6,
    0x0, 0x1, 0xe0, 0x2, 0x0, 0x0, 0xe0, 0x2,
    0x0, 0x0, 0xf0, 0x79, 0xff, 0xc0, 0x7c, 0x3f,
    0xff, 0xe0, 0x3e, 0x1e, 0x0, 0xf0, 0x3f, 0xf,
    0x0, 0x78, 0x17, 0x87, 0x80, 0x3c, 0x1b, 0xc3,
    0xc0, 0x1e, 0x9, 0xe1, 0xe0, 0xf, 0xc, 0xf0,
    0xf0, 0x7, 0x84, 0x78, 0x78, 0x3, 0xc0, 0x3c,
    0x3c, 0x1, 0xe0, 0x1e, 0x1e, 0x0, 0xf0, 0xf,
    0xf, 0x0, 0x78, 0x7, 0x87, 0x80, 0x3c, 0x3,
    0xc3, 0xff, 0xde, 0x1, 0xe1, 0xff, 0xef, 0x0,
    0xf0, 0xf0, 0x7, 0x80, 0x78, 0x78, 0x3, 0xc0,
    0x3c, 0x3c, 0x1, 0xe0, 0x1e, 0x1e, 0x0, 0xf0,
    0xf, 0xf, 0x0, 0x78, 0x7, 0x87, 0x80, 0x3c,
    0x3, 0xc3, 0xc0, 0x1e, 0x1, 0xe1, 0xe0, 0xf,
    0x0, 0xf0, 0xf0, 0x7, 0x80, 0x78, 0x78, 0x3,
    0xc0, 0x3c, 0x3c, 0x1, 0xe0, 0x1e, 0x1e, 0x0,
    0xf0, 0xf, 0xf, 0x0, 0x78, 0x7, 0x87, 0xff,
    0xfc, 0x3, 0xc3, 0xff, 0xfe, 0x1, 0xe1, 0xe0,
    0xf, 0x0, 0xf0, 0xf0, 0x7, 0x80, 0x78, 0x78,
    0x3, 0xc0, 0x3c, 0x3c, 0x1, 0xe0,

    /* U+4F73 "佳" */
    0x1, 0xe0, 0xf, 0x0, 0x0, 0xf0, 0x7, 0x80,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0x1c, 0x0, 0xf0, 0x0, 0xe, 0x0, 0x78,
    0x0, 0x7, 0x0, 0x3c, 0x0, 0x7, 0x80, 0x1e,
    0x0, 0x3, 0x8f, 0xff, 0xfe, 0x1, 0xc7, 0xff,
    0xff, 0x0, 0xe0, 0x3, 0xc0, 0x0, 0x70, 0x1,
    0xe0, 0x0, 0x70, 0x0, 0xf0, 0x0, 0x38, 0x0,
    0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x1f, 0x0,
    0x1e, 0x0, 0xf, 0x80, 0xf, 0x0, 0xf, 0xc0,
    0x7, 0x80, 0x7, 0xe0, 0x3, 0xc0, 0x6, 0xf7,
    0xff, 0xff, 0xf2, 0x7b, 0xff, 0xff, 0xfb, 0x3c,
    0x0, 0x0, 0x3, 0x1e, 0x0, 0x38, 0x0, 0xf,
    0x0, 0x1c, 0x0, 0x7, 0x80, 0xe, 0x0, 0x3,
    0xc0, 0x7, 0x0, 0x1, 0xe0, 0x3, 0x80, 0x0,
    0xf0, 0x1, 0xc0, 0x0, 0x78, 0x0, 0xe0, 0x0,
    0x3c, 0x0, 0x70, 0x0, 0x1e, 0x3f, 0xff, 0xf8,
    0xf, 0x1f, 0xff, 0xfc, 0x7, 0x80, 0xe, 0x0,
    0x3, 0xc0, 0x7, 0x0, 0x1, 0xe0, 0x3, 0x80,
    0x0, 0xf0, 0x1, 0xc0, 0x0, 0x78, 0x0, 0xe0,
    0x0, 0x3c, 0x0, 0x70, 0x0, 0x1e, 0x0, 0x38,
    0x0, 0xf, 0x0, 0x1c, 0x0, 0x7, 0x80, 0xe,
    0x0, 0x3, 0xc0, 0x7, 0x0, 0x1, 0xef, 0xff,
    0xff, 0xe0, 0xf7, 0xff, 0xff, 0xf0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,

    /* U+4F74 "佴" */
    0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x7f, 0xff,
    0xf0, 0x1e, 0x3f, 0xff, 0xf8, 0xe, 0x7, 0x81,
    0xc0, 0x7, 0x3, 0xc0, 0xe0, 0x3, 0x81, 0xe0,
    0x70, 0x3, 0xc0, 0xf0, 0x38, 0x1, 0xc0, 0x78,
    0x1c, 0x0, 0xe0, 0x3c, 0xe, 0x0, 0x70, 0x1e,
    0x7, 0x0, 0x70, 0xf, 0xf3, 0x80, 0x3c, 0x7,
    0xf9, 0xc0, 0x1e, 0x3, 0xc0, 0xe0, 0x1f, 0x1,
    0xe0, 0x70, 0xf, 0x80, 0xf0, 0x38, 0xf, 0xc0,
    0x78, 0x1c, 0x6, 0xe0, 0x3c, 0xe, 0x7, 0x70,
    0x1e, 0x7, 0x3, 0x38, 0xf, 0x3, 0x83, 0x1c,
    0x7, 0x81, 0xc1, 0xe, 0x3, 0xfc, 0xe1, 0x7,
    0x1, 0xfe, 0x70, 0x3, 0x80, 0xf0, 0x38, 0x1,
    0xc0, 0x78, 0x1c, 0x0, 0xe0, 0x3c, 0xe, 0x0,
    0x70, 0x1e, 0x7, 0x0, 0x38, 0xf, 0x3, 0x80,
    0x1c, 0x7, 0x81, 0xc0, 0xe, 0x3, 0xc0, 0xe0,
    0x7, 0x1, 0xe0, 0x70, 0x3, 0x80, 0xf0, 0x38,
    0x1, 0xc3, 0xff, 0xff, 0x80, 0xe1, 0xff, 0xff,
    0xc0, 0x70, 0x0, 0x7, 0x0, 0x38, 0x0, 0x3,
    0x80, 0x1c, 0x0, 0x1, 0xc0, 0xe, 0x0, 0x0,
    0xe0, 0x7, 0x0, 0x0, 0x70, 0x3, 0x80, 0x0,
    0x38, 0x1, 0xc0, 0x0, 0x1c, 0x0, 0xe0, 0x0,
    0xe, 0x0, 0x70, 0x0, 0x7, 0x0, 0x38, 0x0,
    0x3, 0x80, 0x1c, 0x0, 0x0, 0x0,

    /* U+4F75 "併" */
    0x7, 0xc4, 0x0, 0x20, 0xf, 0x4, 0x0, 0xe0,
    0x1e, 0xc, 0x1, 0x80, 0x3c, 0x1c, 0x7, 0x0,
    0x78, 0x3c, 0xc, 0x0, 0xf0, 0x3c, 0x38, 0x1,
    0xc0, 0x70, 0x60, 0x3, 0x80, 0x41, 0x80, 0xf,
    0x0, 0x83, 0x0, 0x1e, 0x7f, 0xff, 0xf8, 0x38,
    0xff, 0xff, 0xf0, 0x70, 0x1e, 0x1e, 0x0, 0xe0,
    0x3c, 0x3c, 0x3, 0x80, 0x78, 0x78, 0x7, 0xc0,
    0xf0, 0xf0, 0xf, 0x81, 0xe1, 0xe0, 0x1f, 0x3,
    0xc3, 0xc0, 0x7e, 0x7, 0x87, 0x80, 0xfc, 0xf,
    0xf, 0x3, 0x78, 0x1e, 0x1e, 0x6, 0xf0, 0x3c,
    0x3c, 0x9, 0xe0, 0x78, 0x78, 0x23, 0xc0, 0xf0,
    0xf0, 0x7, 0x81, 0xe1, 0xe0, 0xf, 0x7f, 0xff,
    0xfe, 0x1e, 0xff, 0xff, 0xfc, 0x3c, 0xe, 0xf,
    0x0, 0x78, 0x1c, 0x1e, 0x0, 0xf0, 0x38, 0x3c,
    0x1, 0xe0, 0x70, 0x78, 0x3, 0xc0, 0xe0, 0xf0,
    0x7, 0x81, 0xc1, 0xe0, 0xf, 0x3, 0x3, 0xc0,
    0x1e, 0xe, 0x7, 0x80, 0x3c, 0x1c, 0xf, 0x0,
    0x78, 0x30, 0x1e, 0x0, 0xf0, 0x60, 0x3c, 0x1,
    0xe1, 0x80, 0x78, 0x3, 0xc3, 0x0, 0xf0, 0x7,
    0x8c, 0x1, 0xe0, 0xf, 0x10, 0x3, 0xc0, 0x1e,
    0x60, 0x7, 0x80, 0x3c, 0x80, 0xf, 0x0, 0x7a,
    0x0, 0x1e, 0x0, 0xfc, 0x0, 0x3c, 0x0,

    /* U+4F76 "佶" */
    0x1, 0xe0, 0xf, 0x0, 0x3, 0xe0, 0xf, 0x0,
    0x3, 0xe0, 0xf, 0x0, 0x3, 0xe0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x7, 0xcf, 0xff, 0xff,
    0x7, 0x8f, 0xff, 0xff, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0,
    0xf, 0x0, 0xf, 0x0, 0xf, 0x80, 0xf, 0x0,
    0x1f, 0x80, 0xf, 0x0, 0x1f, 0x80, 0xf, 0x0,
    0x1f, 0x80, 0xf, 0x0, 0x3f, 0x80, 0xf, 0x0,
    0x37, 0x87, 0xff, 0xfe, 0x67, 0x87, 0xff, 0xfe,
    0x47, 0x80, 0x0, 0x0, 0xc7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xff, 0xf8, 0x7, 0x83, 0xff, 0xf8,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xff, 0xf8, 0x7, 0x83, 0xff, 0xf8,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0xc0, 0x78,

    /* U+4F7A "佺" */
    0x1, 0xe0, 0x1f, 0x0, 0x0, 0x78, 0x7, 0xc0,
    0x0, 0x3e, 0x1, 0xe0, 0x0, 0xf, 0x80, 0x7c,
    0x0, 0x3, 0xe0, 0x3f, 0x0, 0x0, 0xf0, 0xf,
    0xc0, 0x0, 0x3c, 0x3, 0xd8, 0x0, 0xf, 0x0,
    0xf6, 0x0, 0x3, 0xc0, 0x79, 0xc0, 0x0, 0xe0,
    0x1e, 0x70, 0x0, 0x78, 0x7, 0xe, 0x0, 0x1c,
    0x3, 0xc3, 0xc0, 0x7, 0x0, 0xe0, 0xf8, 0x3,
    0xc0, 0x38, 0x1f, 0x0, 0xf8, 0x1c, 0x7, 0xe0,
    0x3e, 0x7, 0x0, 0xfc, 0x1f, 0x83, 0x80, 0x3f,
    0xc7, 0xe0, 0xe0, 0x7, 0xf3, 0x78, 0x7f, 0xff,
    0xf8, 0x9e, 0x3b, 0xff, 0xde, 0x47, 0x8c, 0xf,
    0x3, 0xa1, 0xe6, 0x3, 0xc0, 0x60, 0x7b, 0x0,
    0xf0, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x7, 0x80,
    0xf, 0x0, 0x1, 0xe0, 0x3, 0xc0, 0x0, 0x78,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x7,
    0x80, 0xf, 0x0, 0x1, 0xe0, 0xff, 0xff, 0x0,
    0x78, 0x3f, 0xff, 0xc0, 0x1e, 0x0, 0x3c, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x1, 0xe0, 0x3, 0xc0,
    0x0, 0x78, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0xf, 0x0, 0x1, 0xe0, 0x3,
    0xc0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0x1e, 0x0,
    0x3c, 0x0, 0x7, 0x80, 0xf, 0x0, 0x1, 0xe0,
    0x3, 0xc0, 0x0, 0x78, 0xff, 0xff, 0xf8, 0x1e,
    0x3f, 0xff, 0xfe, 0x7, 0x80, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x0,

    /* U+4F7B "佻" */
    0x1, 0xe0, 0x79, 0xc0, 0x0, 0xf0, 0x3c, 0xe0,
    0x0, 0x78, 0x1e, 0x70, 0x0, 0x3c, 0xf, 0x38,
    0x0, 0x3e, 0x7, 0x9c, 0x0, 0x1e, 0x3, 0xce,
    0x0, 0xf, 0x1, 0xe7, 0x8, 0x7, 0x80, 0xf3,
    0x86, 0x3, 0xc8, 0x79, 0xc3, 0x1, 0xc4, 0x3c,
    0xe3, 0x1, 0xe3, 0x1e, 0x71, 0x80, 0xe1, 0x8f,
    0x39, 0x80, 0x70, 0xe7, 0x9c, 0xc0, 0x3c, 0x73,
    0xce, 0xe0, 0x3e, 0x1d, 0xe7, 0x60, 0x1f, 0xe,
    0xf3, 0xb0, 0xf, 0x87, 0x79, 0xf0, 0xf, 0xc3,
    0xbc, 0xf8, 0x5, 0xe1, 0x9e, 0x78, 0x6, 0xf0,
    0xcf, 0x3c, 0x2, 0x78, 0x47, 0x9c, 0x2, 0x3c,
    0x7, 0xcf, 0x1, 0x1e, 0x3, 0xe7, 0x60, 0xf,
    0x3, 0xf3, 0xb8, 0x7, 0x83, 0xf9, 0xde, 0x3,
    0xc7, 0xbc, 0xe7, 0x81, 0xe7, 0x9e, 0x73, 0xc0,
    0xf3, 0xce, 0x39, 0xe0, 0x78, 0xc7, 0x1c, 0x60,
    0x3c, 0x43, 0x8e, 0x30, 0x1e, 0x43, 0xc7, 0x10,
    0xf, 0x1, 0xc3, 0x80, 0x7, 0x80, 0xe1, 0xc0,
    0x3, 0xc0, 0x70, 0xe0, 0x81, 0xe0, 0x70, 0x70,
    0x40, 0xf0, 0x38, 0x38, 0x20, 0x78, 0x18, 0x1c,
    0x10, 0x3c, 0x1c, 0xe, 0x8, 0x1e, 0xc, 0x7,
    0xe, 0xf, 0xe, 0x3, 0x87, 0x7, 0x86, 0x1,
    0xc3, 0x83, 0xc6, 0x0, 0xe3, 0xc1, 0xe3, 0x0,
    0x7f, 0xc0, 0xf3, 0x0, 0x3f, 0xe0, 0x7b, 0x0,
    0xf, 0xe0, 0x3f, 0x0, 0x0, 0x0,

    /* U+4F7C "佼" */
    0x7, 0xc0, 0x10, 0x0, 0x7, 0xc0, 0x1c, 0x0,
    0x7, 0xc0, 0x1e, 0x0, 0x7, 0xc0, 0xe, 0x0,
    0x7, 0xc0, 0xe, 0x0, 0x7, 0x80, 0x6, 0x0,
    0x7, 0x9f, 0xff, 0xff, 0x7, 0x9f, 0xff, 0xff,
    0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x1, 0x0,
    0xf, 0x1, 0xe0, 0x80, 0xe, 0x1, 0xe0, 0x80,
    0xe, 0x1, 0xe0, 0xc0, 0xf, 0x1, 0xe0, 0x40,
    0x1f, 0x1, 0xe0, 0x60, 0x1f, 0x1, 0xe0, 0x70,
    0x1f, 0x3, 0xc0, 0x78, 0x3f, 0x3, 0xc0, 0x3e,
    0x37, 0x3, 0x81, 0xfe, 0x67, 0x7, 0x81, 0xfe,
    0x67, 0x7, 0x1, 0xfe, 0xc7, 0xf, 0x1, 0xec,
    0x7, 0xd, 0x1, 0xe6, 0x7, 0x19, 0x1, 0xe2,
    0x7, 0x31, 0x81, 0xe0, 0x7, 0x21, 0x83, 0xe0,
    0x7, 0x0, 0x83, 0xc0, 0x7, 0x0, 0x83, 0xc0,
    0x7, 0x0, 0xc3, 0xc0, 0x7, 0x0, 0xc3, 0xc0,
    0x7, 0x0, 0x67, 0x80, 0x7, 0x0, 0x67, 0x80,
    0x7, 0x0, 0x77, 0x0, 0x7, 0x0, 0x3f, 0x0,
    0x7, 0x0, 0x3e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x3e, 0x0, 0x7, 0x0, 0x7f, 0x0,
    0x7, 0x0, 0xf7, 0xc0, 0x7, 0x1, 0xe3, 0xf0,
    0x7, 0x3, 0xc1, 0xfe, 0x7, 0x7, 0x0, 0xff,
    0x7, 0xe, 0x0, 0x7e, 0x7, 0x18, 0x0, 0x1e,
    0x7, 0x70, 0x0, 0x6, 0x7, 0xc0, 0x0, 0x1,

    /* U+4F7E "佾" */
    0x3, 0xe0, 0x1, 0x0, 0x1, 0xf0, 0x78, 0x80,
    0x0, 0xf8, 0x3c, 0x20, 0x0, 0x7c, 0x1e, 0x10,
    0x0, 0x3e, 0x1e, 0x8, 0x0, 0x1e, 0xf, 0x6,
    0x0, 0xf, 0x7, 0x83, 0x0, 0xf, 0x83, 0xc1,
    0x80, 0x7, 0x81, 0xe0, 0xe0, 0x3, 0xc0, 0xe0,
    0x30, 0x1, 0xe0, 0x70, 0x1c, 0x1, 0xe0, 0x78,
    0xf, 0x0, 0xf0, 0x38, 0x7, 0xc0, 0x7c, 0x1c,
    0x1, 0xf0, 0x7e, 0x1c, 0x0, 0xfe, 0x3f, 0xe,
    0x0, 0x3e, 0x1f, 0x86, 0x0, 0xf, 0x1f, 0xc7,
    0xc0, 0x3f, 0xd, 0xe7, 0xff, 0xfe, 0x8c, 0xf6,
    0xff, 0xff, 0xc, 0x7e, 0x78, 0x7, 0x84, 0x3c,
    0x3c, 0x3, 0xc0, 0x1e, 0x1e, 0x1, 0xe0, 0xf,
    0xf, 0x0, 0xf0, 0x7, 0x87, 0x80, 0x78, 0x3,
    0xc3, 0xff, 0x3c, 0x1, 0xe1, 0xff, 0x9e, 0x0,
    0xf0, 0xf0, 0xf, 0x0, 0x78, 0x78, 0x7, 0x80,
    0x3c, 0x3c, 0x3, 0xc0, 0x1e, 0x1e, 0x1, 0xe0,
    0xf, 0xf, 0x0, 0xf0, 0x7, 0x87, 0xfe, 0x78,
    0x3, 0xc3, 0xff, 0x3c, 0x1, 0xe1, 0xe0, 0x1e,
    0x0, 0xf0, 0xf0, 0xf, 0x0, 0x78, 0x78, 0x7,
    0x80, 0x3c, 0x3c, 0x3, 0xc0, 0x1e, 0x1e, 0x1,
    0xe0, 0xf, 0xf, 0x0, 0xf0, 0x7, 0x87, 0x80,
    0x78, 0x3, 0xc3, 0xc0, 0x3c, 0x1, 0xe1, 0xe0,
    0x1e, 0x0, 0xf0, 0xf0, 0xe, 0x0, 0x78, 0x78,
    0x1e, 0x0, 0x3c, 0x3c, 0x3c, 0x0,

    /* U+4F7F "使" */
    0x3, 0xe0, 0x1e, 0x0, 0x1, 0xf0, 0xf, 0x0,
    0x0, 0xf8, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x3e, 0xff, 0xff,
    0xfc, 0x1e, 0x7f, 0xff, 0xfe, 0xf, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0x80, 0xf,
    0x0, 0x3, 0xc7, 0x87, 0x87, 0x81, 0xc3, 0xc3,
    0xc3, 0xc0, 0xe1, 0xe1, 0xe1, 0xe0, 0x78, 0xff,
    0xff, 0xf0, 0x7c, 0x7f, 0xff, 0xf8, 0x3e, 0x3c,
    0x3c, 0x3c, 0x1f, 0x1e, 0x1e, 0x1e, 0x1b, 0x8f,
    0xf, 0xf, 0xd, 0xc7, 0x87, 0x87, 0x8c, 0xe3,
    0xc3, 0xc3, 0xc4, 0x71, 0xe1, 0xe1, 0xe0, 0x38,
    0xf0, 0xf0, 0xf0, 0x1c, 0x78, 0x78, 0x78, 0xe,
    0x3f, 0xff, 0xfc, 0x7, 0x1f, 0xff, 0xfe, 0x3,
    0x8f, 0xf, 0xf, 0x1, 0xc7, 0x87, 0x87, 0x80,
    0xe3, 0xc3, 0xc3, 0xc0, 0x70, 0x41, 0xe0, 0x0,
    0x38, 0x10, 0xf0, 0x0, 0x1c, 0x8, 0x78, 0x0,
    0xe, 0x6, 0x38, 0x0, 0x7, 0x3, 0x1c, 0x0,
    0x3, 0x80, 0xce, 0x0, 0x1, 0xc0, 0x7f, 0x0,
    0x0, 0xe0, 0x1f, 0x0, 0x0, 0x70, 0xf, 0x80,
    0x0, 0x38, 0x3, 0xe0, 0x0, 0x1c, 0x3, 0xfc,
    0x0, 0xe, 0x3, 0xff, 0x80, 0x7, 0x1, 0xcf,
    0xff, 0x3, 0x81, 0xc3, 0xff, 0x81, 0xc1, 0x80,
    0x7f, 0x80, 0xe3, 0x80, 0xf, 0xc0, 0x73, 0x80,
    0x1, 0xe0, 0x3b, 0x0, 0x0, 0x10,

    /* U+4F83 "侃" */
    0x3, 0xce, 0x0, 0x38, 0x3, 0xce, 0x0, 0x38,
    0x3, 0xcf, 0xff, 0xf8, 0x3, 0xcf, 0xff, 0xf8,
    0x3, 0xce, 0x0, 0x38, 0x7, 0x8e, 0x0, 0x38,
    0x7, 0x8e, 0x0, 0x38, 0x7, 0x8e, 0x0, 0x38,
    0x7, 0x8e, 0x0, 0x38, 0x7, 0xe, 0x0, 0x38,
    0x7, 0xe, 0x0, 0x38, 0xf, 0xe, 0x0, 0x38,
    0xe, 0xe, 0x0, 0x38, 0xf, 0xe, 0x0, 0x38,
    0xf, 0xf, 0xff, 0xf8, 0x1f, 0xf, 0xff, 0xf8,
    0x1f, 0xe, 0x0, 0x38, 0x1f, 0xe, 0x0, 0x38,
    0x37, 0x0, 0x0, 0x38, 0x27, 0x0, 0x0, 0x0,
    0x67, 0x0, 0x0, 0x0, 0x47, 0x0, 0x0, 0x0,
    0x87, 0x7, 0x1c, 0xe0, 0x7, 0x7, 0x1c, 0xe0,
    0x7, 0x7, 0x1c, 0xe0, 0x7, 0x7, 0x1c, 0xe0,
    0x7, 0x7, 0x1c, 0xe0, 0x7, 0x7, 0x1c, 0xe0,
    0x7, 0x7, 0x1c, 0xe0, 0x7, 0x7, 0x1c, 0xe0,
    0x7, 0x7, 0x1c, 0xe0, 0x7, 0x7, 0x1c, 0xe0,
    0x7, 0xf, 0x1c, 0xe0, 0x7, 0xf, 0x1c, 0xe2,
    0x7, 0xf, 0x1c, 0xe2, 0x7, 0xe, 0x1c, 0xe2,
    0x7, 0xe, 0x1c, 0xe2, 0x7, 0xe, 0x1c, 0xe2,
    0x7, 0xe, 0x1c, 0xe2, 0x7, 0x1c, 0x1c, 0xe3,
    0x7, 0x18, 0x1c, 0xe3, 0x7, 0x18, 0x1c, 0xe7,
    0x7, 0x30, 0x1c, 0xff, 0x7, 0x20, 0x1c, 0xfe,
    0x7, 0x40, 0x1c, 0xfe, 0x7, 0x40, 0x1c, 0x0,

    /* U+4F84 "侄" */
    0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3, 0xdf, 0xff, 0xfe, 0x3, 0xdf, 0xff, 0xfe,
    0x3, 0xc0, 0x78, 0x0, 0x3, 0x80, 0x78, 0x0,
    0x3, 0x80, 0x78, 0x80, 0x3, 0x80, 0x78, 0x80,
    0x3, 0x80, 0x70, 0x40, 0x7, 0x0, 0xf0, 0x40,
    0x7, 0x0, 0xe0, 0x60, 0x6, 0x0, 0xe0, 0x60,
    0x6, 0x1, 0xc0, 0x70, 0xf, 0x1, 0x80, 0xf0,
    0xf, 0x1, 0x81, 0xb8, 0xf, 0x3, 0x3, 0x3e,
    0x1f, 0x6, 0xe, 0x3f, 0x1f, 0x3d, 0xfc, 0x1e,
    0x3f, 0x1f, 0xf8, 0xe, 0x2f, 0x1f, 0xe0, 0xe,
    0x6f, 0x1f, 0x0, 0x6, 0xcf, 0x0, 0x1e, 0x2,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x1f, 0xff, 0xfc,
    0xf, 0x1f, 0xff, 0xfc, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x7f, 0xff, 0xff, 0xf, 0x7f, 0xff, 0xff,
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,

    /* U+4F86 "來" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x7, 0x80, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c,
    0x3c, 0x3e, 0x0, 0x78, 0x78, 0x78, 0x0, 0xf0,
    0xf0, 0xf0, 0x3, 0xc1, 0xe1, 0xe0, 0x7, 0x83,
    0xc3, 0x80, 0xf, 0x7, 0x87, 0x80, 0x1f, 0xf,
    0x1d, 0x0, 0x3b, 0x9e, 0x3b, 0x0, 0xe7, 0xbc,
    0x67, 0x1, 0x87, 0x79, 0x8f, 0x83, 0xe, 0xf3,
    0xf, 0xc, 0x9, 0xfc, 0x1c, 0x30, 0x13, 0xf0,
    0x18, 0x40, 0xff, 0xe0, 0x30, 0x1, 0xff, 0xc0,
    0x20, 0x3, 0xde, 0xc0, 0x0, 0xf, 0xbd, 0x80,
    0x0, 0x1e, 0x7b, 0x80, 0x0, 0x3c, 0xf3, 0x80,
    0x0, 0xf1, 0xe7, 0x80, 0x1, 0xc3, 0xc7, 0x80,
    0x7, 0x87, 0x8f, 0x80, 0xe, 0xf, 0xf, 0x80,
    0x38, 0x1e, 0xf, 0xc0, 0x60, 0x3c, 0x1f, 0xe1,
    0x80, 0x78, 0x1f, 0xc6, 0x0, 0xf0, 0x1f, 0x18,
    0x1, 0xe0, 0x1e, 0x60, 0x3, 0xc0, 0xc, 0x0,
    0x7, 0x80, 0x8, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0,

    /* U+4F88 "侈" */
    0x3, 0xc0, 0xf8, 0x0, 0x3, 0xc0, 0xf0, 0x0,
    0x3, 0xc0, 0xf0, 0x0, 0x3, 0xc0, 0xf0, 0x3c,
    0x3, 0xc1, 0xf0, 0x3c, 0x3, 0xc1, 0xff, 0xfc,
    0x3, 0x81, 0xff, 0xf8, 0x7, 0x81, 0xe0, 0x78,
    0x7, 0x83, 0xc0, 0x78, 0x7, 0x83, 0x80, 0xf0,
    0x7, 0x3, 0x80, 0xf0, 0x7, 0x7, 0x41, 0xe0,
    0xe, 0xe, 0x61, 0xc0, 0xf, 0xc, 0x73, 0x80,
    0xf, 0x10, 0x7f, 0x0, 0x1f, 0x20, 0x3e, 0x0,
    0x1f, 0x0, 0x3c, 0x0, 0x17, 0x0, 0x38, 0x0,
    0x37, 0x0, 0x70, 0x0, 0x27, 0x0, 0xc0, 0x0,
    0x47, 0x1, 0x7c, 0x0, 0xc7, 0x6, 0x78, 0x1f,
    0x7, 0xc, 0x78, 0x1f, 0x7, 0x30, 0x7f, 0xff,
    0x7, 0x0, 0x7f, 0xff, 0x7, 0x0, 0x70, 0x1e,
    0x7, 0x0, 0xf0, 0x1e, 0x7, 0x0, 0xe0, 0x3e,
    0x7, 0x0, 0xe0, 0x3c, 0x7, 0x1, 0xc0, 0x3c,
    0x7, 0x1, 0xe0, 0x78, 0x7, 0x3, 0x70, 0x78,
    0x7, 0x6, 0x30, 0xf0, 0x7, 0x4, 0x38, 0xe0,
    0x7, 0x8, 0x39, 0xe0, 0x7, 0x10, 0x3b, 0xc0,
    0x7, 0x20, 0x17, 0x80, 0x7, 0x0, 0x7, 0x0,
    0x7, 0x0, 0xe, 0x0, 0x7, 0x0, 0x18, 0x0,
    0x7, 0x0, 0x30, 0x0, 0x7, 0x0, 0xe0, 0x0,
    0x7, 0x1, 0x80, 0x0, 0x7, 0x3, 0x0, 0x0,
    0x7, 0xc, 0x0, 0x0, 0x7, 0x18, 0x0, 0x0,

    /* U+4F89 "侉" */
    0x3, 0xe0, 0x1e, 0x0, 0x3, 0xe0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1c, 0x0, 0x3, 0xdf, 0xff, 0xff,
    0x3, 0xdf, 0xff, 0xff, 0x7, 0x80, 0x3c, 0x80,
    0x7, 0x80, 0x38, 0x80, 0x7, 0x80, 0x78, 0xc0,
    0x7, 0x0, 0x70, 0x40, 0x7, 0x0, 0xe0, 0x40,
    0xe, 0x0, 0xe0, 0x60, 0xf, 0x80, 0xc0, 0x70,
    0xf, 0x81, 0xc0, 0x38, 0x1f, 0x81, 0xff, 0xfc,
    0x17, 0x83, 0xff, 0xfe, 0x37, 0x86, 0x0, 0x1f,
    0x27, 0x86, 0x0, 0x1f, 0x67, 0x8c, 0x0, 0xf,
    0x47, 0x98, 0x0, 0xf, 0x87, 0xb0, 0x0, 0x7,
    0x7, 0xaf, 0xff, 0xfb, 0x7, 0x8f, 0xff, 0xf9,
    0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x38, 0x0,
    0x7, 0x80, 0x38, 0x0, 0x7, 0x80, 0x70, 0x0,
    0x7, 0x80, 0x60, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xff, 0xf8, 0x7, 0x81, 0xff, 0xf8,
    0x7, 0x82, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0x78,
    0x7, 0x80, 0x0, 0x78, 0x7, 0x80, 0x0, 0xf0,
    0x7, 0x80, 0x3, 0xe0, 0x7, 0x80, 0xf, 0xc0,
    0x0, 0x0, 0x12, 0x0,

    /* U+4F8B "例" */
    0x7, 0x80, 0x0, 0xe, 0xf, 0x0, 0x0, 0x1c,
    0x1e, 0xff, 0xe0, 0x38, 0x3d, 0xff, 0xc0, 0x70,
    0x78, 0xe0, 0x0, 0xe0, 0xe1, 0xc0, 0x1, 0xc1,
    0xc3, 0x80, 0xf3, 0x83, 0x87, 0x1, 0xe7, 0x7,
    0xe, 0x3, 0xce, 0x1c, 0x1c, 0x7, 0x9c, 0x38,
    0x38, 0xf, 0x38, 0x70, 0x73, 0x9e, 0x70, 0xc0,
    0xe7, 0x3c, 0xe1, 0xe1, 0xfe, 0x79, 0xc7, 0xc3,
    0xfc, 0xf3, 0x8f, 0x87, 0x39, 0xe7, 0x1f, 0xc,
    0x73, 0xce, 0x7e, 0x18, 0xe7, 0x9c, 0xbc, 0x71,
    0xcf, 0x39, 0x78, 0xc3, 0x9e, 0x74, 0xf1, 0x87,
    0x3c, 0xe9, 0xe3, 0xe, 0x79, 0xe3, 0xcd, 0x1c,
    0xf3, 0x87, 0x9a, 0x39, 0xe7, 0xf, 0x26, 0x73,
    0xce, 0x1e, 0xce, 0xe7, 0x9c, 0x3d, 0x1d, 0xcf,
    0x38, 0x7c, 0x1f, 0x9e, 0x70, 0xf0, 0x3f, 0x3c,
    0xe1, 0xe0, 0x7e, 0x79, 0xc3, 0xc0, 0xb8, 0xf3,
    0x87, 0x80, 0x71, 0xe7, 0xf, 0x0, 0xe3, 0xce,
    0x1e, 0x1, 0x87, 0x9c, 0x3c, 0x7, 0x0, 0x38,
    0x78, 0xc, 0x0, 0x70, 0xf0, 0x18, 0x0, 0xe1,
    0xe0, 0x60, 0x1, 0xc3, 0xc0, 0xc0, 0x3, 0x87,
    0x83, 0x0, 0x7, 0xf, 0xc, 0x0, 0xe, 0x1e,
    0x18, 0x0, 0x1c, 0x3c, 0x60, 0x0, 0x78, 0x79,
    0x80, 0x1, 0xe0, 0xf2, 0x0, 0xf, 0x81, 0xe8,
    0x0, 0xe6, 0x0,

    /* U+4F8D "侍" */
    0x3, 0xe0, 0xf, 0x0, 0x1, 0xf0, 0x7, 0x80,
    0x0, 0xf8, 0x3, 0xc0, 0x0, 0x7c, 0x1, 0xe0,
    0x0, 0x3c, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78,
    0x0, 0xf, 0x0, 0x3c, 0x0, 0xf, 0x8f, 0xff,
    0xfc, 0x7, 0x87, 0xff, 0xfe, 0x3, 0xc0, 0x7,
    0x80, 0x1, 0xc0, 0x3, 0xc0, 0x0, 0xe0, 0x1,
    0xe0, 0x0, 0x70, 0x0, 0xf0, 0x0, 0x7c, 0x0,
    0x78, 0x0, 0x3e, 0x0, 0x3c, 0x0, 0x1f, 0x0,
    0x1e, 0x0, 0x1f, 0x9f, 0xff, 0xff, 0x8f, 0xcf,
    0xff, 0xff, 0xcd, 0xe0, 0x0, 0x3c, 0x4, 0xf0,
    0x0, 0x1e, 0x6, 0x78, 0x0, 0xf, 0x2, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x1, 0xe0, 0x7, 0x8f, 0xff, 0xff, 0x3,
    0xc7, 0xff, 0xff, 0x81, 0xe0, 0x0, 0x3c, 0x0,
    0xf0, 0x0, 0x1e, 0x0, 0x78, 0x10, 0xf, 0x0,
    0x3c, 0xc, 0x7, 0x80, 0x1e, 0x3, 0x3, 0xc0,
    0xf, 0x1, 0xc1, 0xe0, 0x7, 0x80, 0xf0, 0xf0,
    0x3, 0xc0, 0x38, 0x78, 0x1, 0xe0, 0x1c, 0x3c,
    0x0, 0xf0, 0x4, 0x1e, 0x0, 0x78, 0x2, 0xf,
    0x0, 0x3c, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x3,
    0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0,
    0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0,
    0x78, 0x0, 0xf0, 0x0, 0x7c, 0x0, 0x78, 0x0,
    0xfc, 0x0, 0x3c, 0x1, 0xf8, 0x0,

    /* U+4F8F "侏" */
    0x3, 0xf0, 0xf, 0x0, 0x1, 0xf0, 0x7, 0x80,
    0x0, 0xf8, 0x3, 0xc0, 0x0, 0x7c, 0x79, 0xe0,
    0x0, 0x3e, 0x3c, 0xf0, 0x0, 0x1e, 0x1e, 0x78,
    0x0, 0xf, 0xf, 0x3c, 0x0, 0x7, 0x87, 0x9e,
    0x0, 0x7, 0x83, 0xff, 0xfe, 0x3, 0xc1, 0xff,
    0xff, 0x1, 0xe0, 0xe3, 0xc0, 0x0, 0xe0, 0x71,
    0xe0, 0x0, 0xf0, 0x38, 0xf0, 0x0, 0x7c, 0x38,
    0x78, 0x0, 0x3e, 0x18, 0x3c, 0x0, 0x3f, 0xc,
    0x1e, 0x0, 0x1f, 0x8c, 0xf, 0x0, 0xf, 0xc4,
    0x7, 0x80, 0xd, 0xe0, 0x3, 0xc0, 0x4, 0xf7,
    0xff, 0xff, 0xf6, 0x7b, 0xff, 0xff, 0xfa, 0x3c,
    0x1, 0xfa, 0x0, 0x1e, 0x0, 0xfd, 0x0, 0xf,
    0x0, 0x7e, 0x80, 0x7, 0x80, 0x3f, 0x40, 0x3,
    0xc0, 0x3f, 0xa0, 0x1, 0xe0, 0x1f, 0xd8, 0x0,
    0xf0, 0xf, 0xec, 0x0, 0x78, 0xe, 0xf6, 0x0,
    0x3c, 0x7, 0x79, 0x80, 0x1e, 0x3, 0xbc, 0xc0,
    0xf, 0x3, 0x9e, 0x70, 0x7, 0x81, 0x8f, 0x38,
    0x3, 0xc1, 0xc7, 0x9e, 0x1, 0xe0, 0xc3, 0xc7,
    0x80, 0xf0, 0xe1, 0xe3, 0xf0, 0x78, 0x60, 0xf0,
    0xf8, 0x3c, 0x60, 0x78, 0x78, 0x1e, 0x20, 0x3c,
    0x1c, 0xf, 0x30, 0x1e, 0xe, 0x7, 0xb0, 0xf,
    0x3, 0x3, 0xf0, 0x7, 0x80, 0x81, 0xe0, 0x3,
    0xc0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0x78, 0x0,

    /* U+4F91 "侑" */
    0x3, 0xe0, 0x3c, 0x0, 0x1, 0xf0, 0x1e, 0x0,
    0x0, 0xf8, 0xf, 0x0, 0x0, 0x78, 0xf, 0x80,
    0x0, 0x3c, 0x7, 0x80, 0x0, 0x1e, 0x3, 0xc0,
    0x0, 0xf, 0x7f, 0xff, 0xfe, 0x7, 0xbf, 0xff,
    0xff, 0x7, 0x80, 0x70, 0x0, 0x3, 0xc0, 0x38,
    0x0, 0x1, 0xe0, 0x3c, 0x0, 0x0, 0xe0, 0x1c,
    0x0, 0x0, 0xf0, 0xe, 0x1, 0xc0, 0x7c, 0xe,
    0x0, 0xe0, 0x3e, 0x7, 0xff, 0xf0, 0x1f, 0x3,
    0xff, 0xf8, 0x1f, 0x83, 0xc0, 0x1c, 0xb, 0xc1,
    0xe0, 0xe, 0xd, 0xe0, 0xf0, 0x7, 0x4, 0xf0,
    0xf8, 0x3, 0x84, 0x78, 0x7c, 0x1, 0xc2, 0x3c,
    0x7e, 0x0, 0xe0, 0x1e, 0x6f, 0x0, 0x70, 0xf,
    0x27, 0xff, 0x38, 0x7, 0xa3, 0xff, 0x9c, 0x3,
    0xe1, 0xe0, 0xe, 0x1, 0xe0, 0xf0, 0x7, 0x0,
    0xf0, 0x78, 0x3, 0x80, 0x78, 0x3c, 0x1, 0xc0,
    0x3c, 0x1e, 0x0, 0xe0, 0x1e, 0xf, 0xfe, 0x70,
    0xf, 0x7, 0xff, 0x38, 0x7, 0x83, 0xc0, 0x1c,
    0x3, 0xc1, 0xe0, 0xe, 0x1, 0xe0, 0xf0, 0x7,
    0x0, 0xf0, 0x78, 0x3, 0x80, 0x78, 0x3c, 0x1,
    0xc0, 0x3c, 0x1e, 0x0, 0xe0, 0x1e, 0xf, 0x0,
    0x70, 0xf, 0x7, 0x80, 0x38, 0x7, 0x83, 0xc0,
    0x1c, 0x3, 0xc1, 0xe0, 0xe, 0x1, 0xe0, 0xf0,
    0x7, 0x0, 0xf0, 0x78, 0x7, 0x0, 0x78, 0x3c,
    0xf, 0x0, 0x3c, 0x1e, 0x3e, 0x0,

    /* U+4F94 "侔" */
    0x3, 0xe0, 0x3e, 0x0, 0x1, 0xf0, 0x1e, 0x20,
    0x0, 0xf8, 0xf, 0x10, 0x0, 0x7c, 0x7, 0x8c,
    0x0, 0x7c, 0x3, 0x82, 0x0, 0x3e, 0x1, 0xc1,
    0x0, 0x1f, 0x1, 0xc0, 0xc0, 0xf, 0x0, 0xe0,
    0x60, 0x7, 0x80, 0x60, 0x38, 0x3, 0xc0, 0x60,
    0x1e, 0x3, 0xc0, 0x60, 0x37, 0xc1, 0xe0, 0x60,
    0xf3, 0xe0, 0xe0, 0xff, 0xe0, 0xe0, 0x7c, 0x7f,
    0xe0, 0x70, 0x7e, 0x3f, 0xc0, 0x18, 0x3f, 0x1f,
    0x0, 0x4, 0x1f, 0x8c, 0xf, 0x0, 0x1b, 0xc1,
    0xf7, 0x80, 0xd, 0xe0, 0xfb, 0xc0, 0xc, 0xf0,
    0x79, 0xe0, 0x4, 0x78, 0x3c, 0xf0, 0x6, 0x3c,
    0x1e, 0x78, 0x0, 0x1e, 0xf, 0xff, 0xf0, 0xf,
    0x7, 0xff, 0xf8, 0x7, 0x83, 0x8f, 0x0, 0x3,
    0xc3, 0x87, 0x80, 0x1, 0xe1, 0x83, 0xc0, 0x0,
    0xf0, 0xc1, 0xe0, 0x0, 0x78, 0xc0, 0xf0, 0x0,
    0x3c, 0xc0, 0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0xf, 0x7f, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff,
    0x83, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3, 0xc0,
    0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3,
    0xc0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0x78, 0x0,

    /* U+4F96 "侖" */
    0x0, 0x1f, 0x80, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x1e, 0x80, 0x0, 0x0, 0x3e, 0xc0, 0x0,
    0x0, 0x3e, 0x40, 0x0, 0x0, 0x3c, 0x60, 0x0,
    0x0, 0x7c, 0x70, 0x0, 0x0, 0x78, 0x38, 0x0,
    0x0, 0xf0, 0x3c, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x1, 0xe0, 0x1f, 0x0, 0x1, 0xc0, 0xf, 0x80,
    0x3, 0x80, 0x7, 0xe0, 0x7, 0x0, 0x3, 0xf8,
    0x6, 0xff, 0xff, 0xfe, 0xc, 0xff, 0xfd, 0xfe,
    0x18, 0x0, 0x0, 0x7c, 0x30, 0x0, 0x0, 0x3c,
    0x60, 0x0, 0x0, 0xc, 0xde, 0x0, 0x0, 0xf0,
    0x1e, 0x0, 0x0, 0xf0, 0x1f, 0xff, 0xff, 0xf0,
    0x1f, 0xff, 0xff, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1f, 0xff, 0xff, 0xf0, 0x1f, 0xff, 0xff, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x70, 0xf0,
    0x1e, 0x38, 0x70, 0xf0, 0x1e, 0x38, 0x71, 0xe0,
    0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x18, 0x0,

    /* U+4F97 "侗" */
    0x1, 0xef, 0x0, 0xf, 0x1, 0xef, 0x0, 0xf,
    0x1, 0xef, 0xff, 0xff, 0x1, 0xef, 0xff, 0xff,
    0x1, 0xef, 0x0, 0xf, 0x3, 0xcf, 0x0, 0xf,
    0x3, 0xcf, 0x0, 0xf, 0x3, 0xcf, 0x0, 0xf,
    0x3, 0xcf, 0x0, 0xf, 0x3, 0x8f, 0x0, 0xf,
    0x7, 0x8f, 0x7f, 0xef, 0x7, 0x8f, 0x7f, 0xef,
    0x7, 0xf, 0x0, 0xf, 0x7, 0x8f, 0x0, 0xf,
    0xf, 0x8f, 0x0, 0xf, 0xf, 0x8f, 0x0, 0xf,
    0xf, 0x8f, 0x0, 0xf, 0x1f, 0x8f, 0x79, 0xcf,
    0x1f, 0x8f, 0x79, 0xcf, 0x37, 0x8f, 0x7f, 0xcf,
    0x27, 0x8f, 0x79, 0xcf, 0x67, 0x8f, 0x79, 0xcf,
    0x47, 0x8f, 0x79, 0xcf, 0x7, 0x8f, 0x79, 0xcf,
    0x7, 0x8f, 0x79, 0xcf, 0x7, 0x8f, 0x79, 0xcf,
    0x7, 0x8f, 0x79, 0xcf, 0x7, 0x8f, 0x79, 0xcf,
    0x7, 0x8f, 0x79, 0xcf, 0x7, 0x8f, 0x79, 0xcf,
    0x7, 0x8f, 0x79, 0xcf, 0x7, 0x8f, 0x79, 0xcf,
    0x7, 0x8f, 0x7f, 0xcf, 0x7, 0x8f, 0x79, 0xcf,
    0x7, 0x8f, 0x79, 0xcf, 0x7, 0x8f, 0x79, 0xcf,
    0x7, 0x8f, 0x78, 0xf, 0x7, 0x8f, 0x0, 0xf,
    0x7, 0x8f, 0x0, 0xf, 0x7, 0x8f, 0x0, 0xf,
    0x7, 0x8f, 0x0, 0xf, 0x7, 0x8f, 0x0, 0xf,
    0x7, 0x8f, 0x0, 0xe, 0x7, 0x8f, 0x0, 0x1e,
    0x7, 0x8f, 0x0, 0x38, 0x7, 0x8f, 0x1, 0xf0,

    /* U+4F9B "供" */
    0x7, 0xc3, 0xc1, 0xe0, 0x3, 0xe1, 0xe0, 0xf0,
    0x1, 0xf0, 0xf0, 0x78, 0x0, 0xf0, 0x78, 0x3c,
    0x0, 0x78, 0x3c, 0x1e, 0x0, 0x3c, 0x1e, 0xf,
    0x0, 0x1e, 0xf, 0x7, 0x80, 0xe, 0x7, 0x83,
    0xc0, 0x7, 0x3, 0xc1, 0xe0, 0x7, 0x81, 0xe0,
    0xf0, 0x3, 0x87, 0xff, 0xff, 0xc1, 0xc3, 0xff,
    0xff, 0xe0, 0xc0, 0x3c, 0x1e, 0x0, 0xf8, 0x1e,
    0xf, 0x0, 0x7c, 0xf, 0x7, 0x80, 0x7e, 0x7,
    0x83, 0xc0, 0x2f, 0x3, 0xc1, 0xe0, 0x27, 0x81,
    0xe0, 0xf0, 0x13, 0xc0, 0xf0, 0x78, 0x11, 0xe0,
    0x78, 0x3c, 0x0, 0xf0, 0x3c, 0x1e, 0x0, 0x78,
    0x1e, 0xf, 0x0, 0x3c, 0xf, 0x7, 0x80, 0x1e,
    0x7, 0x83, 0xc0, 0xf, 0x3, 0xc1, 0xe0, 0x7,
    0x81, 0xe0, 0xf0, 0x3, 0xc0, 0xf0, 0x78, 0x1,
    0xef, 0xff, 0xff, 0xf0, 0xf7, 0xff, 0xff, 0xf8,
    0x78, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x1e, 0x7, 0xc0, 0x0, 0xf, 0x3, 0xe0, 0x80,
    0x7, 0x81, 0xf0, 0x40, 0x3, 0xc0, 0xf0, 0x30,
    0x1, 0xe0, 0x78, 0x18, 0x0, 0xf0, 0x3c, 0x6,
    0x0, 0x78, 0x1c, 0x3, 0x80, 0x3c, 0x1c, 0x1,
    0xe0, 0x1e, 0xe, 0x0, 0xfc, 0xf, 0xe, 0x0,
    0x3f, 0x7, 0x86, 0x0, 0x1f, 0x3, 0xc6, 0x0,
    0x7, 0x81, 0xe3, 0x0, 0x1, 0xc0, 0xf3, 0x0,
    0x0, 0x60, 0x7b, 0x0, 0x0, 0x10,

    /* U+4F9D "依" */
    0x1, 0xf0, 0x30, 0x0, 0x0, 0xf0, 0xc, 0x0,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x3c, 0x3, 0xe0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78,
    0x0, 0xf, 0x0, 0x1c, 0x0, 0x7, 0x80, 0xc,
    0x0, 0x3, 0x9f, 0xff, 0xff, 0x81, 0xcf, 0xff,
    0xff, 0xc0, 0xe0, 0xf, 0x80, 0x0, 0xe0, 0x7,
    0xc0, 0x0, 0x70, 0x7, 0xa0, 0x0, 0x38, 0x3,
    0xd0, 0x0, 0x1e, 0x1, 0xcc, 0x0, 0x1f, 0x0,
    0xe6, 0x4, 0xf, 0x80, 0xe3, 0x7, 0xf, 0xc0,
    0x71, 0x83, 0x5, 0xe0, 0x38, 0xc3, 0x2, 0xf0,
    0x18, 0x63, 0x2, 0x78, 0x1c, 0x31, 0x82, 0x3c,
    0xe, 0x19, 0x81, 0x1e, 0xf, 0xd, 0x80, 0xf,
    0x7, 0x87, 0x80, 0x7, 0x87, 0xc3, 0xc0, 0x3,
    0xc3, 0xe0, 0xc0, 0x1, 0xe3, 0xf0, 0x60, 0x0,
    0xf3, 0x78, 0x38, 0x0, 0x79, 0x3c, 0x1c, 0x0,
    0x3d, 0x1e, 0xe, 0x0, 0x1f, 0xf, 0x7, 0x80,
    0xf, 0x7, 0x81, 0xc0, 0x7, 0x83, 0xc0, 0xe0,
    0x3, 0xc1, 0xe0, 0x78, 0x1, 0xe0, 0xf0, 0x3c,
    0x0, 0xf0, 0x78, 0xf, 0x0, 0x78, 0x3c, 0x47,
    0xc0, 0x3c, 0x1e, 0x61, 0xe0, 0x1e, 0xf, 0x60,
    0xfc, 0xf, 0x7, 0xe0, 0x3f, 0x7, 0x8f, 0xe0,
    0x1f, 0x3, 0xc7, 0xf0, 0x7, 0x81, 0xe3, 0xf0,
    0x3, 0xc0, 0xf1, 0xf0, 0x0, 0xe0, 0x78, 0xe0,
    0x0, 0x30, 0x3c, 0x60, 0x0, 0x8,

    /* U+4FA0 "侠" */
    0x3, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x7c, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0,
    0x0, 0x1e, 0x7f, 0xff, 0xfc, 0xf, 0x3f, 0xff,
    0xfe, 0x7, 0x0, 0x1e, 0x0, 0x3, 0x80, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0x80, 0x1, 0xc1, 0x3,
    0xc0, 0xc0, 0xe0, 0x81, 0xe0, 0x60, 0xfc, 0x20,
    0xf0, 0x60, 0x7e, 0x18, 0x78, 0x30, 0x3f, 0xe,
    0x3c, 0x30, 0x37, 0x87, 0x1e, 0x18, 0x1b, 0xc1,
    0xcf, 0xc, 0x19, 0xe0, 0xe7, 0x8c, 0xc, 0xf0,
    0x63, 0xc6, 0xc, 0x78, 0x11, 0xe2, 0x4, 0x3c,
    0x0, 0xf3, 0x0, 0x1e, 0x0, 0x79, 0x80, 0xf,
    0x7f, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff, 0x83,
    0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0,
    0xf0, 0x3, 0xe0, 0x0, 0x78, 0x1, 0xf0, 0x0,
    0x3c, 0x0, 0xf8, 0x0, 0x1e, 0x0, 0x7c, 0x0,
    0xf, 0x0, 0x7f, 0x0, 0x7, 0x80, 0x39, 0x80,
    0x3, 0xc0, 0x1c, 0xe0, 0x1, 0xe0, 0x1c, 0x70,
    0x0, 0xf0, 0xe, 0x3c, 0x0, 0x78, 0xe, 0xf,
    0x0, 0x3c, 0x6, 0x7, 0xc0, 0x1e, 0x7, 0x1,
    0xf0, 0xf, 0x3, 0x0, 0xfc, 0x7, 0x83, 0x0,
    0x3f, 0x83, 0xc3, 0x0, 0x1f, 0x81, 0xe3, 0x0,
    0x7, 0xc0, 0xf1, 0x0, 0x1, 0xe0, 0x79, 0x0,
    0x0, 0x60, 0x3d, 0x0, 0x0, 0x10,

    /* U+4FA3 "侣" */
    0x3, 0xc0, 0x0, 0x0, 0x1e, 0x1e, 0x7, 0x80,
    0xf0, 0xf0, 0x3c, 0x7, 0x87, 0xff, 0xe0, 0x3c,
    0x3f, 0xff, 0x1, 0xc1, 0xe0, 0x78, 0xe, 0xf,
    0x3, 0xc0, 0xf0, 0x78, 0x1e, 0x7, 0x3, 0xc0,
    0xf0, 0x38, 0x1e, 0x7, 0x81, 0xc0, 0xf0, 0x3c,
    0xc, 0x7, 0x81, 0xe0, 0xe0, 0x3c, 0xf, 0x7,
    0x81, 0xe0, 0x78, 0x3c, 0xf, 0x3, 0xc3, 0xe0,
    0x78, 0x1e, 0x1f, 0x3, 0xc0, 0xf1, 0xf8, 0x1f,
    0xff, 0x8b, 0xc0, 0xf0, 0x3c, 0xde, 0x7, 0x81,
    0xe4, 0xf0, 0x0, 0x0, 0x47, 0x80, 0x0, 0x2,
    0x3c, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xf,
    0xf, 0x0, 0x78, 0x78, 0x78, 0x3, 0xc3, 0xc3,
    0xff, 0xfe, 0x1e, 0x1f, 0xff, 0xf0, 0xf0, 0xf0,
    0x7, 0x87, 0x87, 0x80, 0x3c, 0x3c, 0x3c, 0x1,
    0xe1, 0xe1, 0xe0, 0xf, 0xf, 0xf, 0x0, 0x78,
    0x78, 0x78, 0x3, 0xc3, 0xc3, 0xc0, 0x1e, 0x1e,
    0x1e, 0x0, 0xf0, 0xf0, 0xf0, 0x7, 0x87, 0x87,
    0x80, 0x3c, 0x3c, 0x3c, 0x1, 0xe1, 0xe1, 0xe0,
    0xf, 0xf, 0xf, 0xff, 0xf8, 0x78, 0x7f, 0xff,
    0xc3, 0xc3, 0xc0, 0x1e, 0x1e, 0x1e, 0x0, 0xf0,
    0xf0, 0xf0, 0x7, 0x87, 0x87, 0x80, 0x3c,

    /* U+4FA5 "侥" */
    0x3, 0xc0, 0x70, 0x0, 0x3, 0xc0, 0x70, 0x0,
    0x3, 0xc0, 0x70, 0x0, 0x3, 0xc0, 0x70, 0x0,
    0x3, 0xc0, 0x70, 0x0, 0x3, 0x80, 0x70, 0x1,
    0x3, 0x80, 0x7f, 0xff, 0x3, 0x8f, 0xff, 0xf8,
    0x7, 0x9f, 0xf0, 0x0, 0x7, 0x0, 0x78, 0x38,
    0x7, 0x0, 0x78, 0x78, 0x7, 0x0, 0x78, 0x78,
    0x7, 0x0, 0x3c, 0x70, 0xf, 0x0, 0x3c, 0xf2,
    0xf, 0x0, 0x3c, 0xe2, 0xf, 0x0, 0x1f, 0xc2,
    0x1f, 0x0, 0x1f, 0xc2, 0x1f, 0x0, 0xf, 0x82,
    0x17, 0x0, 0x1f, 0xc2, 0x27, 0x0, 0x3f, 0xf2,
    0x67, 0x0, 0x71, 0xff, 0x47, 0x1, 0xc0, 0xff,
    0x7, 0x7, 0x0, 0x3f, 0x7, 0x8, 0x0, 0x7,
    0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0,
    0x7, 0x3f, 0xff, 0xff, 0x7, 0x3f, 0xff, 0xff,
    0x7, 0x1, 0xe7, 0x80, 0x7, 0x1, 0xe7, 0x80,
    0x7, 0x1, 0xe7, 0x80, 0x7, 0x1, 0xe7, 0x80,
    0x7, 0x1, 0xe7, 0x80, 0x7, 0x1, 0xe7, 0x82,
    0x7, 0x1, 0xe7, 0x82, 0x7, 0x1, 0xe7, 0x82,
    0x7, 0x1, 0xc7, 0x82, 0x7, 0x1, 0xc7, 0x82,
    0x7, 0x3, 0x87, 0x82, 0x7, 0x3, 0x87, 0x82,
    0x7, 0x7, 0x7, 0x87, 0x7, 0xe, 0x7, 0x87,
    0x7, 0xc, 0x7, 0xff, 0x7, 0x18, 0x7, 0xff,
    0x7, 0x30, 0x3, 0xfe, 0x7, 0x60, 0x1, 0xfc,

    /* U+4FA6 "侦" */
    0x7, 0xc0, 0x1e, 0x0, 0x7, 0xc0, 0x1e, 0x0,
    0x7, 0xc0, 0x1e, 0x0, 0x7, 0xc0, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1f, 0xff,
    0x7, 0x80, 0x1f, 0xff, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xe, 0x0, 0x1e, 0x0, 0xe, 0xf, 0x1e, 0x1e,
    0xc, 0xf, 0x1e, 0x1e, 0xf, 0x8f, 0xff, 0xfe,
    0x1f, 0x8f, 0xff, 0xfe, 0x1f, 0x8f, 0x0, 0x1e,
    0x17, 0x8f, 0x0, 0x1e, 0x37, 0x8f, 0x0, 0x1e,
    0x27, 0x8f, 0x1e, 0x1e, 0x67, 0x8f, 0x1e, 0x1e,
    0x47, 0x8f, 0x1e, 0x1e, 0xc7, 0x8f, 0x1e, 0x1e,
    0x7, 0x8f, 0x1e, 0x1e, 0x7, 0x8f, 0x1e, 0x1e,
    0x7, 0x8f, 0x1e, 0x1e, 0x7, 0x8f, 0x1e, 0x1e,
    0x7, 0x8f, 0x1e, 0x1e, 0x7, 0x8f, 0x1e, 0x1e,
    0x7, 0x8f, 0x1e, 0x1e, 0x7, 0x8f, 0x1e, 0x1e,
    0x7, 0x8f, 0x1e, 0x1e, 0x7, 0x8f, 0x1e, 0x1e,
    0x7, 0x8f, 0x1e, 0x1c, 0x7, 0x8f, 0x1e, 0x1c,
    0x7, 0x8f, 0x1e, 0x38, 0x7, 0x80, 0x3d, 0x60,
    0x7, 0x80, 0x39, 0xc0, 0x7, 0x80, 0x30, 0xc0,
    0x7, 0x80, 0x70, 0xe0, 0x7, 0x80, 0xe0, 0x78,
    0x7, 0x80, 0xc0, 0x7e, 0x7, 0x81, 0x80, 0x3f,
    0x7, 0x83, 0x0, 0x1f, 0x7, 0x86, 0x0, 0xf,
    0x7, 0x88, 0x0, 0x6, 0x7, 0x90, 0x0, 0x2,

    /* U+4FA7 "侧" */
    0x7, 0x80, 0x0, 0xe, 0xf, 0x70, 0x38, 0x1c,
    0x1e, 0xff, 0xf0, 0x38, 0x3d, 0xff, 0xe0, 0x70,
    0x7b, 0x81, 0xc0, 0xe0, 0xe7, 0x3, 0x81, 0xc1,
    0xce, 0x7, 0x73, 0x83, 0x9d, 0xce, 0xe7, 0xf,
    0x3b, 0x9d, 0xce, 0x1c, 0x77, 0x3b, 0x9c, 0x38,
    0xee, 0x77, 0x38, 0x71, 0xdc, 0xee, 0x70, 0xc3,
    0xb9, 0xdc, 0xe1, 0xc7, 0x73, 0xb9, 0xc7, 0x8e,
    0xe7, 0x73, 0x8f, 0x1d, 0xce, 0xe7, 0x1e, 0x3b,
    0x9d, 0xce, 0x7c, 0x77, 0x3b, 0x9c, 0xf8, 0xee,
    0x77, 0x3b, 0x71, 0xdc, 0xee, 0x74, 0xe3, 0xb9,
    0xdc, 0xf9, 0xc7, 0x73, 0xb9, 0xc3, 0x8e, 0xe7,
    0x73, 0x87, 0x1d, 0xce, 0xe7, 0xe, 0x3b, 0x9d,
    0xce, 0x1c, 0x77, 0x3b, 0x9c, 0x38, 0xee, 0x77,
    0x38, 0x71, 0xdc, 0xee, 0x70, 0xe3, 0xb9, 0xdc,
    0xe1, 0xc7, 0x73, 0xb9, 0xc3, 0x8e, 0xe7, 0x73,
    0x87, 0x1d, 0xce, 0xe7, 0xe, 0x3b, 0x19, 0xce,
    0x1c, 0x76, 0x33, 0x9c, 0x38, 0xc, 0xc0, 0x38,
    0x70, 0x1f, 0x0, 0x70, 0xe0, 0x6c, 0x0, 0xe1,
    0xc0, 0xdc, 0x1, 0xc3, 0x81, 0xbc, 0x3, 0x87,
    0x6, 0x3c, 0x7, 0xe, 0x8, 0x7c, 0xe, 0x1c,
    0x30, 0x70, 0x1c, 0x38, 0xc0, 0x60, 0x78, 0x71,
    0x0, 0x40, 0xe0, 0xe4, 0x0, 0x7, 0x81, 0xd0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4FA8 "侨" */
    0x3, 0xe0, 0x0, 0x60, 0x1, 0xe0, 0x0, 0xfc,
    0x0, 0xf0, 0x3, 0xff, 0x80, 0xf8, 0xf, 0xfe,
    0x0, 0x7c, 0x7f, 0xe0, 0x0, 0x3c, 0x40, 0xf0,
    0x0, 0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x7c,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x3, 0x80, 0x1e,
    0x0, 0x1, 0xc0, 0xe, 0x0, 0x1, 0xe0, 0xf,
    0x0, 0x0, 0xe3, 0xff, 0xff, 0xf0, 0x7d, 0xff,
    0xff, 0xf8, 0x3e, 0x1, 0xc4, 0x0, 0x3f, 0x1,
    0xc3, 0x0, 0x1f, 0x80, 0xe1, 0x80, 0xb, 0xc0,
    0xe0, 0x60, 0xd, 0xe0, 0x60, 0x38, 0x4, 0xf0,
    0x70, 0xf, 0x6, 0x78, 0x30, 0x7, 0xc2, 0x3c,
    0x3f, 0xf, 0xfa, 0x1e, 0x37, 0x87, 0xfe, 0xf,
    0x33, 0xc3, 0xdf, 0x7, 0xb1, 0xe1, 0xe7, 0x3,
    0xf0, 0xf0, 0xf1, 0x81, 0xe0, 0x78, 0x78, 0x40,
    0xf0, 0x3c, 0x3c, 0x0, 0x78, 0x1e, 0x1e, 0x0,
    0x3c, 0xf, 0xf, 0x0, 0x1e, 0x7, 0x87, 0x80,
    0xf, 0x3, 0xc3, 0xc0, 0x7, 0x81, 0xc1, 0xe0,
    0x3, 0xc0, 0xe0, 0xf0, 0x1, 0xe0, 0x70, 0x78,
    0x0, 0xf0, 0x38, 0x3c, 0x0, 0x78, 0x18, 0x1e,
    0x0, 0x3c, 0x1c, 0xf, 0x0, 0x1e, 0xe, 0x7,
    0x80, 0xf, 0x6, 0x3, 0xc0, 0x7, 0x87, 0x1,
    0xe0, 0x3, 0xc3, 0x0, 0xf0, 0x1, 0xe3, 0x0,
    0x78, 0x0, 0xf1, 0x80, 0x3c, 0x0, 0x79, 0x80,
    0x1e, 0x0, 0x3d, 0x80, 0xf, 0x0,

    /* U+4FA9 "侩" */
    0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0, 0x1f, 0x0,
    0x0, 0xf0, 0xf, 0x80, 0x0, 0x78, 0x7, 0xa0,
    0x0, 0x3c, 0x3, 0xd0, 0x0, 0x1e, 0x1, 0xcc,
    0x0, 0xe, 0x1, 0xe6, 0x0, 0xf, 0x0, 0xe1,
    0x80, 0x7, 0x80, 0x70, 0xe0, 0x3, 0xc0, 0x70,
    0x70, 0x1, 0xc0, 0x38, 0x1c, 0x0, 0xe0, 0x38,
    0xf, 0x0, 0x70, 0x18, 0x7, 0xc0, 0x7c, 0x1c,
    0x1, 0xf0, 0x3e, 0x1c, 0x0, 0xfe, 0x1f, 0xc,
    0x0, 0x3e, 0x1f, 0x8f, 0xff, 0xff, 0xf, 0xcf,
    0xff, 0xfb, 0x8d, 0xec, 0x0, 0x0, 0xc6, 0xfc,
    0x0, 0x0, 0x6, 0x78, 0x0, 0x0, 0x2, 0x3c,
    0x0, 0x0, 0x2, 0x1e, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x9f, 0xff, 0xff, 0x3,
    0xcf, 0xff, 0xff, 0x81, 0xe0, 0xf, 0x0, 0x0,
    0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0, 0x0,
    0x3c, 0x3, 0xc4, 0x0, 0x1e, 0x1, 0xe2, 0x0,
    0xf, 0x0, 0xe1, 0x0, 0x7, 0x80, 0x70, 0xc0,
    0x3, 0xc0, 0x30, 0x60, 0x1, 0xe0, 0x38, 0x18,
    0x0, 0xf0, 0x18, 0xc, 0x0, 0x78, 0x1c, 0xf,
    0x0, 0x3c, 0xc, 0xf, 0xc0, 0x1e, 0xc, 0xd,
    0xf0, 0xf, 0x4, 0x1c, 0x7c, 0x7, 0x84, 0x7c,
    0x3f, 0x3, 0xcf, 0xfc, 0xf, 0x1, 0xe3, 0xf8,
    0x7, 0x0, 0xf1, 0xf0, 0x1, 0x80, 0x78, 0xc0,
    0x0, 0x40, 0x3c, 0x0, 0x0, 0x10,

    /* U+4FAA "侪" */
    0x3, 0xf0, 0x10, 0x0, 0x1, 0xf0, 0xe, 0x0,
    0x0, 0xf8, 0x3, 0xc0, 0x0, 0x7c, 0x1, 0xc0,
    0x0, 0x3e, 0x0, 0x60, 0x0, 0x1f, 0x7f, 0xff,
    0xfc, 0xf, 0x3f, 0xff, 0xfe, 0x7, 0x82, 0x1,
    0xf0, 0x3, 0xc0, 0x80, 0xf8, 0x3, 0xc0, 0x40,
    0x78, 0x1, 0xe0, 0x30, 0x3c, 0x0, 0xe0, 0x8,
    0x1c, 0x0, 0x78, 0x6, 0x1e, 0x0, 0x7c, 0x3,
    0xe, 0x0, 0x3e, 0x0, 0xcf, 0x0, 0x1f, 0x0,
    0x7f, 0x0, 0x1f, 0x80, 0x1f, 0x0, 0xf, 0xc0,
    0x7, 0x80, 0x5, 0xe0, 0xf, 0xe0, 0x6, 0xf0,
    0xf, 0xfc, 0x6, 0x78, 0xe, 0x3f, 0xfa, 0x3c,
    0x1e, 0x7, 0xfb, 0x1e, 0x1c, 0x1, 0xfc, 0xf,
    0x38, 0x0, 0x3e, 0x7, 0xb1, 0xe0, 0xe3, 0x3,
    0xe0, 0xf0, 0x70, 0x1, 0xe0, 0x78, 0x38, 0x0,
    0xf0, 0x3c, 0x1c, 0x0, 0x78, 0x1e, 0xe, 0x0,
    0x3c, 0xf, 0x7, 0x0, 0x1e, 0x7, 0x83, 0x80,
    0xf, 0x3, 0xc1, 0xc0, 0x7, 0x81, 0xc0, 0xe0,
    0x3, 0xc0, 0xe0, 0x70, 0x1, 0xe0, 0x70, 0x38,
    0x0, 0xf0, 0x38, 0x1c, 0x0, 0x78, 0x18, 0xe,
    0x0, 0x3c, 0x1c, 0x7, 0x0, 0x1e, 0xe, 0x3,
    0x80, 0xf, 0x6, 0x1, 0xc0, 0x7, 0x87, 0x0,
    0xe0, 0x3, 0xc3, 0x0, 0x70, 0x1, 0xe3, 0x0,
    0x38, 0x0, 0xf1, 0x0, 0x1c, 0x0, 0x79, 0x0,
    0xe, 0x0, 0x3f, 0x0, 0x7, 0x0,

    /* U+4FAC "侬" */
    0x1, 0xf0, 0xf, 0x0, 0x0, 0xf8, 0x7, 0x80,
    0x0, 0x7c, 0x3, 0xc0, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x78,
    0x0, 0x7, 0x9e, 0x3c, 0x3c, 0x7, 0x8f, 0x1e,
    0x1e, 0x3, 0xc7, 0xff, 0xff, 0x1, 0xe3, 0xff,
    0xff, 0x80, 0xe1, 0xe3, 0x83, 0xc0, 0xf0, 0xf3,
    0xc1, 0xe0, 0x70, 0x79, 0xe0, 0xf0, 0x3c, 0x3c,
    0xf0, 0x60, 0x3e, 0x0, 0x78, 0x20, 0x1f, 0x0,
    0x3c, 0x0, 0xf, 0x80, 0x1a, 0x0, 0xf, 0xc0,
    0x1d, 0x1, 0x8d, 0xe0, 0x3e, 0x80, 0xc4, 0xf0,
    0x1e, 0x40, 0xc6, 0x78, 0xf, 0x30, 0x62, 0x3c,
    0x7, 0x18, 0x60, 0x1e, 0x3, 0x8c, 0x70, 0xf,
    0x1, 0xc6, 0x30, 0x7, 0x80, 0xe3, 0x30, 0x3,
    0xc0, 0xf0, 0xd8, 0x1, 0xe0, 0x78, 0x78, 0x0,
    0xf0, 0x7c, 0x3c, 0x0, 0x78, 0x7e, 0x1c, 0x0,
    0x3c, 0x37, 0xe, 0x0, 0x1e, 0x33, 0x87, 0x80,
    0xf, 0x31, 0xc1, 0xc0, 0x7, 0x98, 0xe0, 0xe0,
    0x3, 0xd8, 0x70, 0x78, 0x1, 0xf8, 0x38, 0x1e,
    0x0, 0xf0, 0x1c, 0xf, 0x0, 0x78, 0xe, 0x7,
    0xc0, 0x3c, 0x7, 0x3, 0xf0, 0x1e, 0x3, 0x82,
    0xfe, 0xf, 0x1, 0xc6, 0x3e, 0x7, 0x80, 0xfe,
    0x1f, 0x3, 0xc3, 0xfe, 0x7, 0x81, 0xe0, 0xfe,
    0x1, 0xc0, 0xf0, 0x7c, 0x0, 0x60, 0x78, 0x3c,
    0x0, 0x10, 0x3c, 0x10, 0x0, 0x0,

    /* U+4FAE "侮" */
    0x1, 0xe1, 0xe0, 0x0, 0x0, 0xf0, 0xf0, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x3c, 0x78, 0x0,
    0x0, 0x1e, 0x3c, 0x0, 0x0, 0xe, 0x1f, 0xff,
    0xfc, 0xf, 0xf, 0xff, 0xfe, 0x7, 0x8e, 0x0,
    0x0, 0x3, 0x87, 0x0, 0x0, 0x1, 0xc7, 0x0,
    0x0, 0x0, 0xe3, 0x70, 0x7, 0x0, 0xe3, 0x38,
    0x3, 0x80, 0x73, 0x3f, 0xff, 0xc0, 0x3f, 0x1f,
    0xff, 0xe0, 0x3e, 0xf, 0x0, 0x70, 0x1f, 0x7,
    0x80, 0x38, 0xf, 0x83, 0x88, 0x1c, 0xf, 0xc1,
    0xc6, 0xe, 0x5, 0xe0, 0xe1, 0x87, 0x6, 0xf0,
    0x70, 0xe3, 0x86, 0x78, 0x38, 0x61, 0xc2, 0x3c,
    0x1c, 0x10, 0xe0, 0x1e, 0x1e, 0x0, 0x70, 0xf,
    0xf, 0x0, 0x38, 0x7, 0xbf, 0xff, 0xff, 0x83,
    0xdf, 0xff, 0xff, 0xc1, 0xe1, 0xe0, 0x7, 0x0,
    0xf0, 0xe0, 0x3, 0x80, 0x78, 0x70, 0x81, 0xc0,
    0x3c, 0x38, 0x60, 0xe0, 0x1e, 0x1c, 0x38, 0x70,
    0xf, 0xe, 0x1e, 0x38, 0x7, 0x87, 0xe, 0x1c,
    0x3, 0xc7, 0x83, 0xe, 0x1, 0xe3, 0xc1, 0x7,
    0x0, 0xf1, 0xc0, 0x3, 0x80, 0x78, 0xe0, 0x1,
    0xc0, 0x3c, 0x7f, 0xff, 0xf8, 0x1e, 0x3f, 0xff,
    0xfc, 0xf, 0x1c, 0x0, 0x38, 0x7, 0x8e, 0x0,
    0x3c, 0x3, 0xcf, 0x0, 0x1e, 0x1, 0xe0, 0x0,
    0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0,
    0x3e, 0x0, 0x3c, 0x0, 0x7c, 0x0,

    /* U+4FAF "侯" */
    0x3, 0xc0, 0x0, 0xf8, 0x3, 0xc0, 0x0, 0xf8,
    0x3, 0xc7, 0xff, 0xf0, 0x3, 0xc7, 0xff, 0xf0,
    0x3, 0x80, 0x0, 0xf0, 0x3, 0x80, 0x0, 0xe0,
    0x3, 0x80, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xc0,
    0x7, 0x0, 0x1, 0x80, 0x7, 0x0, 0x1, 0x0,
    0x6, 0x3f, 0xff, 0xff, 0xf, 0x3f, 0xff, 0xff,
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x1f, 0x3, 0xc0, 0x0, 0x1f, 0x3, 0xc0, 0x0,
    0x17, 0x3, 0xc0, 0x0, 0x37, 0x3, 0xc0, 0x0,
    0x27, 0x3, 0x80, 0x0, 0x47, 0x7, 0xff, 0xfc,
    0xc7, 0x7, 0xff, 0xfc, 0x7, 0x7, 0xf, 0x0,
    0x7, 0xe, 0xf, 0x0, 0x7, 0xc, 0xf, 0x0,
    0x7, 0x18, 0x1f, 0x0, 0x7, 0x30, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x7f, 0xff, 0xff, 0x7, 0x7f, 0xff, 0xff,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x3f, 0x0, 0x7, 0x0, 0x3d, 0x0,
    0x7, 0x0, 0x39, 0x0, 0x7, 0x0, 0x79, 0x80,
    0x7, 0x0, 0x71, 0x80, 0x7, 0x0, 0xf0, 0xc0,
    0x7, 0x0, 0xe0, 0xe0, 0x7, 0x1, 0xc0, 0x70,
    0x7, 0x1, 0x80, 0x7c, 0x7, 0x3, 0x0, 0x3f,
    0x7, 0x6, 0x0, 0x1f, 0x7, 0xc, 0x0, 0x1e,
    0x7, 0x18, 0x0, 0xe, 0x7, 0x30, 0x0, 0x2,

    /* U+4FB5 "侵" */
    0x3, 0xc0, 0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e,
    0x0, 0xf1, 0xff, 0xff, 0x0, 0x78, 0xff, 0xff,
    0x80, 0x3c, 0x0, 0x3, 0xc0, 0x3c, 0x0, 0x1,
    0xe0, 0x1e, 0x0, 0x0, 0xf0, 0xf, 0xf, 0xff,
    0xf8, 0x7, 0x7, 0xff, 0xfc, 0x3, 0x80, 0x0,
    0x1e, 0x1, 0xc0, 0x0, 0xf, 0x1, 0xc0, 0x0,
    0x7, 0x80, 0xe0, 0x0, 0x3, 0xc0, 0x7c, 0x7f,
    0xff, 0xe0, 0x3e, 0x3f, 0xff, 0xf0, 0x3f, 0x0,
    0x0, 0x78, 0x17, 0x80, 0x0, 0x0, 0x1b, 0xde,
    0x0, 0x3, 0xc9, 0xef, 0x0, 0x1, 0xec, 0xf7,
    0xff, 0xff, 0xf4, 0x7b, 0xff, 0xff, 0xf8, 0x3d,
    0xe0, 0x0, 0x3c, 0x1e, 0xf0, 0x0, 0x1e, 0xf,
    0x78, 0x0, 0xc, 0x7, 0x80, 0x0, 0xf0, 0x3,
    0xc0, 0x0, 0x78, 0x1, 0xe1, 0xff, 0xfc, 0x0,
    0xf0, 0xff, 0xfe, 0x0, 0x78, 0x10, 0xf, 0x0,
    0x3c, 0x8, 0x7, 0x0, 0x1e, 0x6, 0x3, 0x80,
    0xf, 0x1, 0x3, 0xc0, 0x7, 0x80, 0xc1, 0xe0,
    0x3, 0xc0, 0x60, 0xe0, 0x1, 0xe0, 0x18, 0xf0,
    0x0, 0xf0, 0xe, 0x70, 0x0, 0x78, 0x3, 0xf0,
    0x0, 0x3c, 0x1, 0xf0, 0x0, 0x1e, 0x0, 0x7c,
    0x0, 0xf, 0x0, 0x3f, 0x0, 0x7, 0x80, 0x77,
    0xf0, 0x3, 0xc0, 0x71, 0xff, 0x1, 0xe0, 0x60,
    0x7f, 0xc0, 0xf0, 0xe0, 0xf, 0xc0, 0x78, 0xc0,
    0x3, 0xe0, 0x3d, 0x80, 0x0, 0x60,

    /* U+4FB7 "侷" */
    0x7, 0x8f, 0x0, 0x1c, 0xf, 0x1e, 0x0, 0x38,
    0x1e, 0x3f, 0xff, 0xf0, 0x3c, 0x7f, 0xff, 0xe0,
    0x78, 0xf0, 0x1, 0xc0, 0xf1, 0xe0, 0x3, 0x81,
    0xc3, 0xc0, 0x7, 0x3, 0x87, 0x80, 0xe, 0xf,
    0xf, 0x0, 0x1c, 0x1e, 0x1e, 0x0, 0x38, 0x38,
    0x3f, 0xff, 0xf0, 0x70, 0x7f, 0xff, 0xe0, 0xe0,
    0xf0, 0x1, 0xc1, 0xe1, 0xe0, 0x3, 0x87, 0xc3,
    0xc0, 0x0, 0xf, 0x87, 0x80, 0x0, 0x1f, 0xf,
    0x0, 0xe, 0x7e, 0x1e, 0x0, 0x1c, 0xfc, 0x3f,
    0xff, 0xfb, 0x78, 0x7f, 0xff, 0xf4, 0xf0, 0xf0,
    0x0, 0xf9, 0xe1, 0xe0, 0x1, 0xe3, 0xc3, 0xc0,
    0x3, 0x87, 0x87, 0xb8, 0xe7, 0xf, 0xf, 0x7f,
    0xce, 0x1e, 0x1e, 0xff, 0x9c, 0x3c, 0x3d, 0xc7,
    0x38, 0x78, 0x7b, 0x8e, 0x70, 0xf0, 0xf7, 0x1c,
    0xe1, 0xe1, 0xee, 0x39, 0xc3, 0xc3, 0xdc, 0x73,
    0x87, 0x87, 0xb8, 0xe7, 0xf, 0xf, 0x71, 0xce,
    0x1e, 0x1e, 0xff, 0x9c, 0x3c, 0x3d, 0xff, 0x38,
    0x78, 0x73, 0x8e, 0x70, 0xf0, 0xe7, 0x1c, 0xe1,
    0xe1, 0xce, 0x1, 0xc3, 0xc7, 0x0, 0x3, 0x87,
    0x8e, 0x0, 0x7, 0xf, 0x18, 0x0, 0xe, 0x1e,
    0x20, 0x0, 0x1c, 0x3c, 0xc0, 0x0, 0x38, 0x79,
    0x0, 0x0, 0xe0, 0xf4, 0x0, 0xf, 0x81, 0xe8,
    0x0, 0x6c, 0x0,

    /* U+4FBF "便" */
    0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x0, 0x7b, 0xff, 0xff, 0xe0, 0x79, 0xff, 0xff,
    0xf0, 0x3c, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78,
    0x0, 0xe, 0x0, 0x3c, 0x0, 0x7, 0x0, 0x1e,
    0x0, 0x7, 0x8f, 0xf, 0xe, 0x3, 0x87, 0x87,
    0x87, 0x1, 0xc3, 0xff, 0xff, 0x81, 0xc1, 0xff,
    0xff, 0xc0, 0xe0, 0xf0, 0xf0, 0xe0, 0x7c, 0x78,
    0x78, 0x70, 0x7e, 0x3c, 0x3c, 0x38, 0x3f, 0x1e,
    0x1e, 0x1c, 0x37, 0x8f, 0xf, 0xe, 0x13, 0xc7,
    0xff, 0xff, 0x19, 0xe3, 0xff, 0xff, 0x98, 0xf1,
    0xe1, 0xe1, 0xc8, 0x78, 0xf0, 0xf0, 0xe0, 0x3c,
    0x78, 0x78, 0x70, 0x1e, 0x3c, 0x3c, 0x38, 0xf,
    0x1e, 0x1e, 0x1c, 0x7, 0x8f, 0xff, 0xfe, 0x3,
    0xc7, 0xff, 0xff, 0x1, 0xe3, 0xc3, 0xc3, 0x80,
    0xf1, 0x1, 0xe1, 0xc0, 0x78, 0x40, 0xf0, 0x0,
    0x3c, 0x20, 0x78, 0x0, 0x1e, 0x18, 0x38, 0x0,
    0xf, 0x6, 0x1c, 0x0, 0x7, 0x83, 0x1e, 0x0,
    0x3, 0xc0, 0xcf, 0x0, 0x1, 0xe0, 0x37, 0x0,
    0x0, 0xf0, 0x1f, 0x80, 0x0, 0x78, 0x7, 0x80,
    0x0, 0x3c, 0x3, 0xe0, 0x0, 0x1e, 0x1, 0xfc,
    0x0, 0xf, 0x1, 0xff, 0x80, 0x7, 0x81, 0xcf,
    0xfc, 0x3, 0xc1, 0x81, 0xff, 0x81, 0xe1, 0x80,
    0x7f, 0xc0, 0xf1, 0x80, 0xf, 0xe0, 0x79, 0x80,
    0x1, 0xe0, 0x3d, 0x0, 0x0, 0x18,

    /* U+4FC2 "係" */
    0x0, 0x0, 0x0, 0x10, 0x3, 0xe0, 0x0, 0x78,
    0x3, 0xc0, 0x1, 0xfc, 0x3, 0xc0, 0xf, 0xfe,
    0x3, 0xc0, 0x7f, 0xf8, 0x3, 0xc3, 0xfe, 0x0,
    0x7, 0x8c, 0x0, 0x0, 0x7, 0x80, 0xfc, 0x0,
    0x7, 0x80, 0xf8, 0x0, 0x7, 0x0, 0xf8, 0x78,
    0x7, 0x1, 0xf0, 0x78, 0xf, 0x1, 0xf0, 0x78,
    0xe, 0x1, 0xc0, 0xf8, 0xe, 0x3, 0x80, 0xf0,
    0xe, 0x3, 0x1, 0xf0, 0x1f, 0x4, 0xe, 0xf0,
    0x1f, 0x18, 0xfd, 0xe0, 0x1f, 0xf, 0xf1, 0xc0,
    0x3f, 0xf, 0xc3, 0xc0, 0x3f, 0xf, 0x7, 0x80,
    0x2f, 0x8, 0xe, 0x40, 0x6f, 0x0, 0x1c, 0x40,
    0x4f, 0x0, 0x30, 0x60, 0xcf, 0x0, 0xe0, 0x70,
    0xf, 0x1, 0x80, 0x3c, 0xf, 0x16, 0x1, 0xff,
    0xf, 0x1f, 0xff, 0x1e, 0xf, 0x1f, 0xfe, 0x1e,
    0xf, 0x1f, 0xde, 0xc, 0xf, 0x1c, 0x1e, 0x4,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x20,
    0xf, 0xf, 0x1e, 0x20, 0xf, 0xf, 0x1e, 0x20,
    0xf, 0xf, 0x1e, 0x30, 0xf, 0xf, 0x1e, 0x30,
    0xf, 0xe, 0x1e, 0x38, 0xf, 0xe, 0x1e, 0x3e,
    0xf, 0xe, 0x1e, 0x1f, 0xf, 0xc, 0x1e, 0x1e,
    0xf, 0x18, 0x1e, 0x1e, 0xf, 0x18, 0x1e, 0xe,
    0xf, 0x30, 0x1e, 0x4, 0xf, 0x20, 0x1e, 0x4,
    0xf, 0x0, 0x3e, 0x0, 0xf, 0x0, 0xf8, 0x0,
    0xf, 0x7, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+4FC3 "促" */
    0x1, 0xe3, 0xc0, 0x1e, 0x3, 0xe3, 0xc0, 0x1e,
    0x3, 0xe3, 0xff, 0xfe, 0x3, 0xe3, 0xff, 0xfe,
    0x3, 0xc3, 0xc0, 0x1e, 0x3, 0xc3, 0xc0, 0x1e,
    0x3, 0xc3, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x83, 0xc0, 0x1e, 0x7, 0x83, 0xc0, 0x1e,
    0x7, 0x3, 0xc0, 0x1e, 0xf, 0x3, 0xc0, 0x1e,
    0xe, 0x3, 0xc0, 0x1e, 0xf, 0x83, 0xc0, 0x1e,
    0x1f, 0x83, 0xc0, 0x1e, 0x1f, 0x83, 0xff, 0xfe,
    0x37, 0x83, 0xff, 0xfe, 0x37, 0x83, 0xcf, 0x1e,
    0x67, 0x83, 0xcf, 0x1e, 0x47, 0x80, 0xf, 0x0,
    0xc7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x87, 0x8f, 0x0,
    0x7, 0x87, 0x8f, 0x0, 0x7, 0x87, 0x8f, 0x0,
    0x7, 0x87, 0x8f, 0xff, 0x7, 0x87, 0x8f, 0xff,
    0x7, 0x87, 0x8f, 0x0, 0x7, 0x87, 0x8f, 0x0,
    0x7, 0x87, 0x8f, 0x0, 0x7, 0x87, 0x8f, 0x0,
    0x7, 0x87, 0x8f, 0x0, 0x7, 0x87, 0x8f, 0x0,
    0x7, 0x87, 0x8f, 0x0, 0x7, 0x87, 0x8f, 0x0,
    0x7, 0x87, 0x8f, 0x0, 0x7, 0x87, 0xcf, 0x0,
    0x7, 0x87, 0x4f, 0x0, 0x7, 0x8e, 0x4f, 0x0,
    0x7, 0x8e, 0x6f, 0x0, 0x7, 0x8c, 0x3f, 0x0,
    0x7, 0x98, 0x3f, 0xff, 0x7, 0x98, 0x1f, 0xfe,
    0x7, 0xb0, 0xf, 0xfe, 0x7, 0xa0, 0x7, 0xff,

    /* U+4FC4 "俄" */
    0x7, 0x80, 0x7, 0x0, 0x3, 0xc0, 0x23, 0x80,
    0x1, 0xe0, 0x79, 0xc8, 0x0, 0xe0, 0xff, 0xe6,
    0x0, 0x71, 0xfe, 0x73, 0x80, 0x3f, 0xb8, 0x38,
    0xc0, 0x1c, 0x1c, 0x1c, 0x70, 0xe, 0xe, 0xe,
    0x3c, 0x6, 0x7, 0x7, 0xc, 0x7, 0x3, 0x83,
    0x86, 0x3, 0x81, 0xc1, 0xc2, 0x1, 0x80, 0xe0,
    0xe0, 0x0, 0xef, 0xff, 0xff, 0xf0, 0xf7, 0xff,
    0xff, 0xf8, 0x78, 0x1c, 0x1c, 0x0, 0x3c, 0xe,
    0xe, 0x0, 0x3e, 0x7, 0x7, 0x3c, 0x17, 0x3,
    0x83, 0x9e, 0xb, 0x81, 0xc1, 0xcf, 0x9, 0xc0,
    0xe0, 0xe7, 0x8c, 0xe0, 0x70, 0xf3, 0xc0, 0x70,
    0x38, 0xb9, 0xe0, 0x38, 0x1d, 0x9c, 0xf0, 0x1c,
    0xf, 0xce, 0x78, 0xe, 0x7, 0xc7, 0x38, 0x7,
    0x3f, 0xc3, 0xbc, 0x3, 0xff, 0xc1, 0xde, 0x1,
    0xdf, 0xe0, 0xef, 0x0, 0xef, 0x70, 0x77, 0x0,
    0x74, 0x38, 0x3f, 0x80, 0x38, 0x1c, 0x1f, 0xc0,
    0x1c, 0xe, 0xf, 0xc2, 0xe, 0x7, 0x7, 0xe1,
    0x7, 0x3, 0x81, 0xe0, 0x83, 0x81, 0xc0, 0xf0,
    0x41, 0xc0, 0xe0, 0x78, 0x20, 0xe0, 0x70, 0x7e,
    0x10, 0x70, 0x38, 0x7f, 0x98, 0x38, 0x1c, 0x33,
    0xec, 0x1c, 0xe, 0x38, 0xfe, 0xe, 0xf, 0x38,
    0x7f, 0x7, 0x7, 0x90, 0x1f, 0xc3, 0x87, 0x90,
    0x7, 0xe1, 0xc7, 0x90, 0x0, 0xf0, 0xe7, 0x90,
    0x0, 0x38, 0x74, 0x0, 0x0, 0x4,

    /* U+4FC5 "俅" */
    0x3, 0xc0, 0x39, 0x0, 0x7, 0x80, 0x71, 0x0,
    0xf, 0x0, 0xe3, 0x0, 0x1e, 0x1, 0xc7, 0x0,
    0x38, 0x3, 0x8e, 0x0, 0xf0, 0x7, 0x1c, 0x1,
    0xe0, 0xe, 0x18, 0x3, 0xc0, 0x1c, 0x20, 0x7,
    0xbf, 0xff, 0xfc, 0xe, 0x7f, 0xff, 0xf8, 0x1c,
    0x0, 0xe8, 0x0, 0x38, 0x1, 0xd0, 0x0, 0x60,
    0x3, 0xa0, 0x1, 0xe2, 0x7, 0x40, 0x3, 0xc4,
    0xe, 0x82, 0x7, 0x84, 0x1d, 0xc, 0x1f, 0x8,
    0x3a, 0x18, 0x3e, 0x18, 0x74, 0x30, 0x7c, 0x30,
    0xec, 0xc1, 0xb8, 0x71, 0xc9, 0x82, 0x70, 0xe3,
    0x93, 0xc, 0xe0, 0xe7, 0x2c, 0x11, 0xc1, 0xce,
    0x58, 0x3, 0x83, 0x1c, 0xf0, 0x7, 0x2, 0x39,
    0xc0, 0xe, 0x0, 0xf3, 0x80, 0x1c, 0x2, 0xe7,
    0x0, 0x38, 0x5, 0xce, 0x0, 0x70, 0x1b, 0x8c,
    0x0, 0xe0, 0x37, 0x1c, 0x1, 0xc0, 0xce, 0x38,
    0x3, 0x83, 0x9c, 0x78, 0x7, 0x1e, 0x38, 0x78,
    0xe, 0x7c, 0x70, 0xf8, 0x1d, 0xf0, 0xe1, 0xf8,
    0x39, 0xe1, 0xc1, 0xe0, 0x73, 0x83, 0x83, 0xc0,
    0xe6, 0x7, 0x3, 0x81, 0xc8, 0xe, 0x3, 0x3,
    0x80, 0x1c, 0x2, 0x7, 0x0, 0x38, 0x0, 0xe,
    0x0, 0x70, 0x0, 0x1c, 0x1, 0xe0, 0x0, 0x38,
    0x7, 0x80, 0x0, 0x70, 0x7c, 0x0, 0x0, 0xe0,
    0x0, 0x0, 0x0,

    /* U+4FCA "俊" */
    0x3, 0xe0, 0x7c, 0x0, 0x1, 0xf0, 0x3e, 0x40,
    0x0, 0xf8, 0x1f, 0x10, 0x0, 0x7c, 0xf, 0x8,
    0x0, 0x3c, 0x7, 0x6, 0x0, 0x1e, 0x3, 0x83,
    0x80, 0xf, 0x3, 0x81, 0xe0, 0xf, 0x1, 0x80,
    0xf8, 0x7, 0x80, 0x87, 0xbf, 0x83, 0xcf, 0xff,
    0x8f, 0xc1, 0xc3, 0xff, 0x87, 0xc0, 0xe1, 0xfe,
    0x1, 0xe0, 0xf0, 0xf8, 0x0, 0x70, 0x7c, 0x0,
    0x4, 0x8, 0x3e, 0x7, 0xc1, 0x0, 0x1f, 0x3,
    0xc0, 0xc0, 0x1f, 0x83, 0xe0, 0x70, 0xf, 0xc1,
    0xe0, 0x1e, 0x5, 0xe0, 0xf0, 0xf, 0xc6, 0xf0,
    0xf0, 0x3, 0xf2, 0x78, 0x7f, 0x81, 0xfb, 0x3c,
    0x77, 0x80, 0x7d, 0x1e, 0x33, 0xc0, 0x1f, 0x8f,
    0x31, 0xe0, 0x7f, 0x7, 0x90, 0xf0, 0x3c, 0x3,
    0xd0, 0x7f, 0xfe, 0x1, 0xe0, 0x78, 0xf, 0x0,
    0xf0, 0x3c, 0x7, 0x80, 0x78, 0x1f, 0x3, 0x80,
    0x3c, 0xf, 0x83, 0xc0, 0x1e, 0x6, 0x41, 0xe0,
    0xf, 0x7, 0x30, 0xe0, 0x7, 0x83, 0x18, 0xf0,
    0x3, 0xc3, 0x8e, 0x70, 0x1, 0xe1, 0x83, 0xf0,
    0x0, 0xf0, 0x81, 0xf8, 0x0, 0x78, 0xc0, 0x78,
    0x0, 0x3c, 0x40, 0x7e, 0x0, 0x1e, 0x40, 0x7f,
    0x80, 0xf, 0x0, 0x7b, 0xf0, 0x7, 0x80, 0x71,
    0xff, 0x83, 0xc0, 0x70, 0x3f, 0xc1, 0xe0, 0x70,
    0xf, 0xc0, 0xf0, 0xe0, 0x3, 0xe0, 0x78, 0xc0,
    0x0, 0x70, 0x3c, 0xc0, 0x0, 0x8,

    /* U+4FCE "俎" */
    0x3, 0x80, 0xf0, 0x3c, 0x3, 0x80, 0xff, 0xfc,
    0x3, 0x80, 0xff, 0xfc, 0x3, 0x80, 0xf0, 0x3c,
    0x7, 0x80, 0xf0, 0x3c, 0x7, 0x80, 0xf0, 0x3c,
    0x7, 0x80, 0xf0, 0x3c, 0x7, 0x80, 0xf0, 0x3c,
    0x7, 0xc0, 0xf0, 0x3c, 0x7, 0xc0, 0xf0, 0x3c,
    0x7, 0x40, 0xf0, 0x3c, 0x7, 0x60, 0xf0, 0x3c,
    0xe, 0x60, 0xf0, 0x3c, 0xe, 0x70, 0xff, 0xbc,
    0xc, 0x38, 0xff, 0xbc, 0x1c, 0x3c, 0xf0, 0x3c,
    0x18, 0x3e, 0xf0, 0x3c, 0x10, 0x1e, 0xf0, 0x3c,
    0x30, 0x1e, 0xf0, 0x3c, 0x67, 0x8e, 0xf0, 0x3c,
    0x47, 0x84, 0xf0, 0x3c, 0x87, 0x80, 0xf0, 0x3c,
    0x7, 0x80, 0xf0, 0x3c, 0x7, 0x80, 0xf0, 0x3c,
    0x7, 0x80, 0xf0, 0x3c, 0x7, 0x80, 0xff, 0xbc,
    0x7, 0x80, 0xff, 0xbc, 0x7, 0x80, 0xf0, 0x3c,
    0x7, 0x80, 0xf0, 0x3c, 0x7, 0xc0, 0xf0, 0x3c,
    0x7, 0xc0, 0xf0, 0x3c, 0x7, 0xc0, 0xf0, 0x3c,
    0x7, 0xe0, 0xf0, 0x3c, 0x7, 0x70, 0xf0, 0x3c,
    0xf, 0x70, 0xf0, 0x3c, 0xe, 0x3c, 0xf0, 0x3c,
    0xe, 0x3e, 0xf0, 0x3c, 0x1c, 0x3e, 0xf0, 0x3c,
    0x18, 0x1c, 0xf0, 0x3c, 0x38, 0x1c, 0xf0, 0x3c,
    0x30, 0x8, 0xf0, 0x3c, 0x60, 0x8, 0xf0, 0x3c,
    0x40, 0xf, 0xff, 0xff, 0x80, 0xf, 0xff, 0xff,

    /* U+4FCF "俏" */
    0x1, 0xe0, 0xf, 0x0, 0x0, 0xf0, 0x7, 0x80,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x38, 0x81, 0xe0,
    0x60, 0x3c, 0x20, 0xf0, 0x30, 0x1e, 0x18, 0x78,
    0x30, 0xf, 0xe, 0x3c, 0x30, 0x7, 0x3, 0x9e,
    0x38, 0x3, 0x81, 0xef, 0x18, 0x1, 0xc0, 0xf7,
    0x98, 0x1, 0xc0, 0x33, 0xd8, 0x0, 0xe0, 0x19,
    0xfc, 0x0, 0x70, 0x0, 0xfc, 0x0, 0x7c, 0x0,
    0x7c, 0x0, 0x3e, 0x0, 0x3c, 0x0, 0x1f, 0x7,
    0xff, 0xfc, 0x1f, 0x83, 0xff, 0xfe, 0xb, 0xc1,
    0xe0, 0xf, 0xd, 0xe0, 0xf0, 0x7, 0x84, 0xf0,
    0x78, 0x3, 0xc6, 0x78, 0x3c, 0x1, 0xe2, 0x3c,
    0x1e, 0x0, 0xf2, 0x1e, 0xf, 0x0, 0x78, 0xf,
    0x7, 0xfe, 0x3c, 0x7, 0x83, 0xff, 0x1e, 0x3,
    0xc1, 0xe0, 0xf, 0x1, 0xe0, 0xf0, 0x7, 0x80,
    0xf0, 0x78, 0x3, 0xc0, 0x78, 0x3c, 0x1, 0xe0,
    0x3c, 0x1e, 0x0, 0xf0, 0x1e, 0xf, 0x0, 0x78,
    0xf, 0x7, 0xfe, 0x3c, 0x7, 0x83, 0xff, 0x1e,
    0x3, 0xc1, 0xe0, 0xf, 0x1, 0xe0, 0xf0, 0x7,
    0x80, 0xf0, 0x78, 0x3, 0xc0, 0x78, 0x3c, 0x1,
    0xe0, 0x3c, 0x1e, 0x0, 0xf0, 0x1e, 0xf, 0x0,
    0x78, 0xf, 0x7, 0x80, 0x3c, 0x7, 0x83, 0xc0,
    0x1e, 0x3, 0xc1, 0xe0, 0xf, 0x1, 0xe0, 0xf0,
    0xf, 0x80, 0xf0, 0x78, 0xf, 0x80, 0x78, 0x3c,
    0xf, 0x80, 0x3c, 0x1e, 0x1f, 0x80, 0x0, 0x0,
    0x10, 0x0,

    /* U+4FD0 "俐" */
    0x3, 0xc0, 0x18, 0xf, 0x3, 0xc0, 0x7c, 0xf,
    0x3, 0xc1, 0xfe, 0xf, 0x3, 0x8f, 0xf8, 0xf,
    0x3, 0xff, 0xc0, 0xf, 0x3, 0x83, 0xc0, 0xf,
    0x3, 0x83, 0xc1, 0xef, 0x3, 0x3, 0xc1, 0xef,
    0x7, 0x3, 0xc1, 0xef, 0x7, 0x3, 0xc1, 0xef,
    0x7, 0x3, 0xc1, 0xef, 0x6, 0x3, 0xc1, 0xef,
    0x6, 0x3, 0xc1, 0xef, 0xf, 0x3, 0xc1, 0xef,
    0xf, 0x3f, 0xfd, 0xef, 0xf, 0x3f, 0xfd, 0xef,
    0x1f, 0x3, 0xc1, 0xef, 0x17, 0x3, 0xc1, 0xef,
    0x17, 0x3, 0xc1, 0xef, 0x27, 0x3, 0xc1, 0xef,
    0x27, 0x7, 0xe1, 0xef, 0x47, 0x7, 0xf9, 0xef,
    0x87, 0x7, 0xdd, 0xef, 0x7, 0x7, 0xdf, 0xef,
    0x7, 0xf, 0xcf, 0xef, 0x7, 0xf, 0xcf, 0xef,
    0x7, 0xf, 0xcd, 0xef, 0x7, 0x1f, 0xc1, 0xef,
    0x7, 0x1b, 0xc1, 0xef, 0x7, 0x1b, 0xc1, 0xef,
    0x7, 0x33, 0xc1, 0xef, 0x7, 0x63, 0xc1, 0xef,
    0x7, 0x63, 0xc1, 0xef, 0x7, 0xc3, 0xc1, 0xef,
    0x7, 0x83, 0xc1, 0xef, 0x7, 0x3, 0xc1, 0xef,
    0x7, 0x3, 0xc0, 0xf, 0x7, 0x3, 0xc0, 0xf,
    0x7, 0x3, 0xc0, 0xf, 0x7, 0x3, 0xc0, 0xf,
    0x7, 0x3, 0xc0, 0xf, 0x7, 0x3, 0xc0, 0xf,
    0x7, 0x3, 0xc0, 0xf, 0x7, 0x3, 0xc0, 0x1e,
    0x7, 0x3, 0xc0, 0x7e, 0x7, 0x3, 0xc3, 0xf8,

    /* U+4FD1 "俑" */
    0x3, 0xe0, 0x0, 0x0, 0x7, 0xdf, 0xff, 0xfc,
    0xf, 0x3f, 0xff, 0xf8, 0x1e, 0x0, 0x0, 0xc0,
    0x3c, 0x0, 0x3, 0x0, 0x78, 0x0, 0xc, 0x0,
    0xf0, 0xc, 0x30, 0x1, 0xc0, 0xe, 0xc0, 0x7,
    0x80, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0, 0x1c,
    0x1c, 0x3c, 0x78, 0x38, 0x3f, 0xff, 0xf0, 0xf0,
    0x7f, 0xff, 0xe1, 0xe0, 0xe1, 0xc3, 0xc3, 0xc1,
    0xc3, 0x87, 0x8f, 0x83, 0x87, 0xf, 0x1f, 0x7,
    0xe, 0x1e, 0x3e, 0xe, 0x1c, 0x3c, 0xfc, 0x1c,
    0x38, 0x79, 0xb8, 0x38, 0x70, 0xf6, 0x70, 0x7f,
    0xff, 0xe8, 0xe0, 0xff, 0xff, 0xf1, 0xc1, 0xc3,
    0x87, 0x83, 0x83, 0x87, 0xf, 0x7, 0x7, 0xe,
    0x1e, 0xe, 0xe, 0x1c, 0x3c, 0x1c, 0x1c, 0x38,
    0x78, 0x38, 0x38, 0x70, 0xf0, 0x70, 0x7f, 0xff,
    0xe0, 0xe0, 0xff, 0xff, 0xc1, 0xc1, 0xc3, 0x87,
    0x83, 0x83, 0x87, 0xf, 0x7, 0x7, 0xe, 0x1e,
    0xe, 0xe, 0x1c, 0x3c, 0x1c, 0x1c, 0x38, 0x78,
    0x38, 0x38, 0x70, 0xf0, 0x70, 0x70, 0xe1, 0xe0,
    0xe0, 0xe1, 0xc3, 0xc1, 0xc1, 0xc3, 0x87, 0x83,
    0x83, 0x87, 0xf, 0x7, 0x7, 0xe, 0x1e, 0xe,
    0xe, 0x1c, 0x3c, 0x1c, 0x1c, 0x38, 0x78, 0x38,
    0x38, 0x1, 0xe0, 0x70, 0x70, 0x7, 0x80, 0xe0,
    0x0, 0x74, 0x0,

    /* U+4FD7 "俗" */
    0x3, 0xe0, 0xf8, 0x80, 0x1, 0xe0, 0x78, 0x60,
    0x1, 0xf0, 0x3c, 0x10, 0x0, 0xf8, 0x3c, 0xc,
    0x0, 0x7c, 0x1e, 0x7, 0x0, 0x3c, 0xe, 0x3,
    0xc0, 0x1e, 0x7, 0x1, 0xf0, 0xf, 0x7, 0x0,
    0xfc, 0x7, 0x3, 0x9e, 0x3e, 0x3, 0x83, 0x8f,
    0x1f, 0x3, 0xc1, 0x87, 0x87, 0x81, 0xc1, 0x87,
    0xc1, 0xc0, 0xe0, 0xc3, 0xe0, 0xe0, 0x7c, 0xc1,
    0xf8, 0x10, 0x7e, 0x0, 0xee, 0x0, 0x3f, 0x0,
    0xf3, 0x0, 0x1f, 0x80, 0x71, 0xc0, 0x1b, 0xc0,
    0x38, 0xf0, 0xd, 0xe0, 0x38, 0x3c, 0xc, 0xf0,
    0x18, 0x1f, 0x4, 0x78, 0x1c, 0x7, 0xc2, 0x3c,
    0x1c, 0x3, 0xfa, 0x1e, 0xc, 0x0, 0xfe, 0xf,
    0xc, 0x0, 0x3f, 0x7, 0x8f, 0xc0, 0x7f, 0x3,
    0xc5, 0xe0, 0x3f, 0x81, 0xe4, 0xff, 0xff, 0xc0,
    0xf6, 0x7f, 0xff, 0x20, 0x78, 0x3c, 0x7, 0x80,
    0x3c, 0x1e, 0x3, 0xc0, 0x1e, 0xf, 0x1, 0xe0,
    0xf, 0x7, 0x80, 0xf0, 0x7, 0x83, 0xc0, 0x78,
    0x3, 0xc1, 0xe0, 0x3c, 0x1, 0xe0, 0xf0, 0x1e,
    0x0, 0xf0, 0x78, 0xf, 0x0, 0x78, 0x3c, 0x7,
    0x80, 0x3c, 0x1e, 0x3, 0xc0, 0x1e, 0xf, 0x1,
    0xe0, 0xf, 0x7, 0x80, 0xf0, 0x7, 0x83, 0xc0,
    0x78, 0x3, 0xc1, 0xff, 0xfc, 0x1, 0xe0, 0xff,
    0xfe, 0x0, 0xf0, 0x78, 0xf, 0x0, 0x78, 0x3c,
    0x7, 0x80, 0x3c, 0x1e, 0x3, 0xc0,

    /* U+4FD8 "俘" */
    0x7, 0xc0, 0x0, 0x20, 0x7, 0xc0, 0x1, 0xf0,
    0x7, 0xc0, 0xf, 0xfc, 0x7, 0x80, 0xff, 0xfe,
    0x7, 0x9f, 0xfe, 0x0, 0x7, 0x80, 0x20, 0x8,
    0x7, 0x80, 0x30, 0xc, 0x7, 0x8, 0x38, 0x1c,
    0xf, 0xc, 0x1c, 0x18, 0xf, 0xe, 0x1e, 0x10,
    0xf, 0x7, 0x1e, 0x30, 0xe, 0x7, 0x8c, 0x20,
    0xe, 0x3, 0x8c, 0x60, 0x1f, 0x3, 0x0, 0x40,
    0x1f, 0x1, 0x0, 0xc6, 0x1f, 0x1f, 0xff, 0xfe,
    0x1f, 0x1f, 0xff, 0xfe, 0x3f, 0x0, 0x0, 0x78,
    0x2f, 0x0, 0x0, 0xf0, 0x6f, 0x0, 0x3, 0xc0,
    0x4f, 0x0, 0x7, 0x0, 0x8f, 0x0, 0x1e, 0x0,
    0x8f, 0x0, 0x38, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x3f, 0xff, 0xff, 0xf, 0x3f, 0xff, 0xff,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0xe, 0x0,
    0xf, 0x0, 0xe, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x78, 0x0,
    0xf, 0x0, 0xf0, 0x0, 0xf, 0x3, 0x40, 0x0,

    /* U+4FDA "俚" */
    0x3, 0xc0, 0x0, 0x0, 0x7, 0x9c, 0x0, 0xf0,
    0xe, 0x3f, 0xff, 0xe0, 0x1c, 0x7f, 0xff, 0xc0,
    0x38, 0xe3, 0xc7, 0x80, 0x71, 0xc7, 0x8f, 0x0,
    0xe3, 0x8f, 0x1e, 0x3, 0xc7, 0x1e, 0x3c, 0x7,
    0xe, 0x3c, 0x78, 0xe, 0x1c, 0x78, 0xf0, 0x1c,
    0x38, 0xf1, 0xe0, 0x38, 0x71, 0xe3, 0xc0, 0xe0,
    0xff, 0xff, 0x81, 0xe1, 0xff, 0xff, 0x3, 0xc3,
    0x8f, 0x1e, 0xf, 0x87, 0x1e, 0x3c, 0x1f, 0xe,
    0x3c, 0x78, 0x3e, 0x1c, 0x78, 0xf0, 0xfc, 0x38,
    0xf1, 0xe1, 0xf8, 0x71, 0xe3, 0xc6, 0xf0, 0xe3,
    0xc7, 0x89, 0xe1, 0xff, 0xff, 0x23, 0xc3, 0xff,
    0xfe, 0x7, 0x87, 0x1e, 0x3c, 0xf, 0xe, 0x3c,
    0x78, 0x1e, 0x1c, 0x78, 0xf0, 0x3c, 0x0, 0xf0,
    0x0, 0x78, 0x1, 0xe0, 0x0, 0xf0, 0x3, 0xc0,
    0x1, 0xe0, 0x7, 0x80, 0x3, 0xc0, 0xf, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0xf, 0x1f, 0xff, 0xf8,
    0x1e, 0x3f, 0xff, 0xf0, 0x3c, 0x0, 0xf0, 0x0,
    0x78, 0x1, 0xe0, 0x0, 0xf0, 0x3, 0xc0, 0x1,
    0xe0, 0x7, 0x80, 0x3, 0xc0, 0xf, 0x0, 0x7,
    0x80, 0x1e, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0x78, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0x7b,
    0xff, 0xff, 0xf0, 0xf7, 0xff, 0xff, 0xe1, 0xe0,
    0x0, 0x0, 0x0,

    /* U+4FDC "俜" */
    0x3, 0xc0, 0x1c, 0x0, 0xf, 0x0, 0x70, 0x0,
    0x3c, 0x1, 0xc0, 0x0, 0xe0, 0x7, 0x0, 0x3,
    0x9c, 0x1c, 0x3c, 0xe, 0x7f, 0xff, 0xf0, 0x79,
    0xff, 0xff, 0xc1, 0xe7, 0x7, 0xf, 0x7, 0x1c,
    0x1c, 0x3c, 0x1c, 0x70, 0x70, 0xf0, 0x61, 0xc1,
    0xc3, 0xc3, 0x87, 0xff, 0xff, 0xe, 0x1f, 0xff,
    0xfc, 0x3c, 0x70, 0x70, 0xf1, 0xf1, 0xc1, 0xc3,
    0xc7, 0xc7, 0x7, 0xf, 0x3f, 0x1c, 0x1c, 0x3c,
    0xdc, 0x70, 0x70, 0xf6, 0x71, 0xff, 0xff, 0xd9,
    0xc7, 0xff, 0xff, 0xc7, 0x1c, 0x0, 0x3c, 0x1c,
    0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x1, 0xc7,
    0xff, 0xff, 0x7, 0x1f, 0xff, 0xfc, 0x1c, 0x1,
    0xc0, 0x0, 0x70, 0x7, 0x0, 0x1, 0xc0, 0x18,
    0x0, 0x7, 0x0, 0xc0, 0x70, 0x1c, 0xf, 0xff,
    0xc0, 0x70, 0x3f, 0xff, 0x1, 0xc0, 0x80, 0x1c,
    0x7, 0x0, 0x0, 0x70, 0x1c, 0x0, 0x1, 0xc0,
    0x70, 0x0, 0x7, 0x1, 0xc0, 0x0, 0x1c, 0x7,
    0x0, 0x0, 0x70, 0x1c, 0x0, 0x1, 0xc0, 0x70,
    0x0, 0x7, 0x1, 0xc0, 0x0, 0x1c, 0x7, 0x0,
    0x0, 0x70, 0x1c, 0x0, 0x1, 0x80, 0x70, 0x0,
    0xe, 0x1, 0xc0, 0x0, 0xf0, 0x7, 0x0, 0xf,
    0x0, 0x1c, 0x0, 0x40, 0x0,

    /* U+4FDD "保" */
    0x3, 0xe7, 0x80, 0x3c, 0x1, 0xf3, 0xc0, 0x1e,
    0x0, 0xf9, 0xff, 0xff, 0x0, 0x78, 0xff, 0xff,
    0x80, 0x3c, 0x78, 0x3, 0xc0, 0x1e, 0x3c, 0x1,
    0xe0, 0xf, 0x1e, 0x0, 0xf0, 0xf, 0xf, 0x0,
    0x78, 0x7, 0x87, 0x80, 0x3c, 0x3, 0xc3, 0xc0,
    0x1e, 0x1, 0xc1, 0xe0, 0xf, 0x0, 0xe0, 0xf0,
    0x7, 0x80, 0x60, 0x78, 0x3, 0xc0, 0x7c, 0x3c,
    0x1, 0xe0, 0x3e, 0x1f, 0xff, 0xf0, 0x1f, 0xf,
    0xff, 0xf8, 0x1f, 0x87, 0x9e, 0x3c, 0xb, 0xc3,
    0xcf, 0x0, 0x9, 0xe0, 0x7, 0x80, 0x4, 0xf0,
    0x3, 0xc0, 0x4, 0x78, 0x1, 0xe0, 0x0, 0x3c,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0, 0xf,
    0x7f, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff, 0x83,
    0xc0, 0x3f, 0x40, 0x1, 0xe0, 0x1f, 0xa0, 0x0,
    0xf0, 0x1f, 0xd0, 0x0, 0x78, 0xf, 0xec, 0x0,
    0x3c, 0x7, 0xf6, 0x0, 0x1e, 0x3, 0xf9, 0x0,
    0xf, 0x3, 0xbc, 0xc0, 0x7, 0x81, 0xde, 0x60,
    0x3, 0xc0, 0xcf, 0x38, 0x1, 0xe0, 0xe7, 0x9e,
    0x0, 0xf0, 0x63, 0xc7, 0x0, 0x78, 0x61, 0xe3,
    0xc0, 0x3c, 0x30, 0xf1, 0xf8, 0x1e, 0x30, 0x78,
    0x7e, 0xf, 0x30, 0x3c, 0x1e, 0x7, 0x90, 0x1e,
    0xf, 0x3, 0xd0, 0xf, 0x3, 0x81, 0xf0, 0x7,
    0x80, 0xc0, 0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1,
    0xe0, 0x0, 0x3c, 0x0, 0xf0, 0x0,

    /* U+4FDE "俞" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x1, 0xf6, 0x0,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0x0, 0xf8, 0xc0,
    0x0, 0x0, 0x78, 0x30, 0x0, 0x0, 0x78, 0x1c,
    0x0, 0x0, 0x38, 0x7, 0x0, 0x0, 0x38, 0x1,
    0xc0, 0x0, 0x38, 0x0, 0xf8, 0x0, 0x38, 0x0,
    0x3f, 0x0, 0x3f, 0xff, 0xff, 0xf0, 0x3b, 0xff,
    0xfb, 0xfc, 0x30, 0x0, 0x0, 0xfc, 0x30, 0x0,
    0x0, 0x3e, 0x30, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0x3, 0xa7, 0x81, 0xe0, 0x1f, 0x43, 0xc0,
    0xf0, 0xf, 0x81, 0xff, 0xf9, 0xe7, 0xc0, 0xf0,
    0x3c, 0xf3, 0xe0, 0x78, 0x1e, 0x79, 0xf0, 0x3c,
    0xf, 0x3c, 0xf8, 0x1e, 0x7, 0x9e, 0x7c, 0xf,
    0x3, 0xcf, 0x3e, 0x7, 0xf9, 0xe7, 0x9f, 0x3,
    0xfc, 0xf3, 0xcf, 0x81, 0xe0, 0x79, 0xe7, 0xc0,
    0xf0, 0x3c, 0xf3, 0xe0, 0x78, 0x1e, 0x79, 0xf0,
    0x3c, 0xf, 0x3c, 0xf8, 0x1e, 0x7, 0x9e, 0x7c,
    0xf, 0xf3, 0xcf, 0x3e, 0x7, 0xf9, 0xe7, 0x9f,
    0x3, 0xc0, 0xf3, 0xcf, 0x81, 0xe0, 0x79, 0xe7,
    0xc0, 0xf0, 0x3c, 0xf3, 0xe0, 0x78, 0x1e, 0x79,
    0xf0, 0x3c, 0xf, 0x3c, 0xf8, 0x1e, 0x7, 0x80,
    0x7c, 0xf, 0x3, 0xc0, 0x3e, 0x7, 0x81, 0xc0,
    0x1f, 0x3, 0xc1, 0xe0, 0x1f, 0x1, 0xe1, 0xe0,
    0x1f, 0x0, 0xf7, 0xc0, 0x7e, 0x0, 0x0, 0x0,
    0x4, 0x0,

    /* U+4FDF "俟" */
    0x1, 0xe0, 0x3c, 0x0, 0x1, 0xe0, 0x3c, 0x0,
    0x1, 0xe0, 0x3c, 0x40, 0x1, 0xe0, 0x38, 0x40,
    0x1, 0xc0, 0x78, 0x60, 0x1, 0xc0, 0x70, 0x20,
    0x1, 0xc0, 0x70, 0x30, 0x3, 0xc0, 0xe0, 0x30,
    0x3, 0x80, 0xc0, 0x38, 0x3, 0x81, 0x80, 0x7c,
    0x3, 0x81, 0x80, 0xde, 0x3, 0x3, 0x3, 0x9f,
    0x7, 0x1f, 0xff, 0x1f, 0x7, 0x8f, 0xfc, 0xe,
    0x7, 0x8f, 0xf0, 0x6, 0xf, 0x8f, 0xf0, 0x2,
    0xf, 0x80, 0xe0, 0x0, 0x1f, 0x81, 0xe0, 0x0,
    0x17, 0x81, 0xc0, 0x0, 0x37, 0x81, 0xff, 0xfc,
    0x27, 0x83, 0xff, 0xfc, 0x67, 0x83, 0x8f, 0x0,
    0x7, 0x87, 0xf, 0x0, 0x7, 0x86, 0xf, 0x0,
    0x7, 0x8c, 0xf, 0x0, 0x7, 0x88, 0xf, 0x0,
    0x7, 0x90, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0x1f, 0x0,
    0x7, 0x80, 0x1d, 0x80, 0x7, 0x80, 0x1d, 0x80,
    0x7, 0x80, 0x39, 0xc0, 0x7, 0x80, 0x30, 0xe0,
    0x7, 0x80, 0x70, 0xf0, 0x7, 0x80, 0x60, 0x78,
    0x7, 0x80, 0xc0, 0x7e, 0x7, 0x81, 0x80, 0x3f,
    0x7, 0x83, 0x0, 0x3f, 0x7, 0x86, 0x0, 0x1e,
    0x7, 0x8c, 0x0, 0xe, 0x7, 0x90, 0x0, 0x2,

    /* U+4FE0 "俠" */
    0x7, 0xc0, 0x3c, 0x0, 0x7, 0xc0, 0x3c, 0x0,
    0x7, 0xc0, 0x3c, 0x0, 0x7, 0xc0, 0x3c, 0x0,
    0x7, 0x80, 0x3c, 0x0, 0x7, 0x80, 0x3c, 0x0,
    0x7, 0x80, 0x3c, 0x0, 0x7, 0xbf, 0xff, 0xff,
    0xf, 0x3f, 0xff, 0xff, 0xf, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x3c, 0x0, 0xe, 0x0, 0x3c, 0x0,
    0xe, 0xf, 0x3c, 0x78, 0xc, 0xf, 0x3c, 0x78,
    0x1f, 0xf, 0x3c, 0x78, 0x1f, 0xf, 0x3c, 0x78,
    0x1f, 0xe, 0x3c, 0x78, 0x3f, 0xe, 0x3c, 0x70,
    0x3f, 0xe, 0x3c, 0x70, 0x2f, 0x1e, 0x3c, 0x78,
    0x6f, 0x1f, 0x3c, 0x68, 0x4f, 0x1d, 0xbc, 0xec,
    0x8f, 0x19, 0xfc, 0xcf, 0xf, 0x18, 0xfc, 0x8f,
    0xf, 0x30, 0xdd, 0x86, 0xf, 0x30, 0x5d, 0x6,
    0xf, 0x20, 0x1e, 0x2, 0xf, 0x60, 0x1c, 0x0,
    0xf, 0x40, 0x3c, 0x0, 0xf, 0x0, 0x3e, 0x0,
    0xf, 0x0, 0x3a, 0x0, 0xf, 0x0, 0x3a, 0x0,
    0xf, 0x0, 0x73, 0x0, 0xf, 0x0, 0x73, 0x0,
    0xf, 0x0, 0x63, 0x80, 0xf, 0x0, 0xe1, 0xc0,
    0xf, 0x0, 0xc1, 0xe0, 0xf, 0x1, 0xc1, 0xf0,
    0xf, 0x1, 0x80, 0xfc, 0xf, 0x3, 0x0, 0x7f,
    0xf, 0x2, 0x0, 0x7f, 0xf, 0x6, 0x0, 0x3e,
    0xf, 0xc, 0x0, 0x1e, 0xf, 0x18, 0x0, 0xe,
    0xf, 0x30, 0x0, 0x6, 0xf, 0x60, 0x0, 0x2,

    /* U+4FE1 "信" */
    0x1, 0xf0, 0x18, 0x0, 0x0, 0xf8, 0xe, 0x0,
    0x0, 0x7c, 0x3, 0x80, 0x0, 0x3e, 0x1, 0xf0,
    0x0, 0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x38,
    0x0, 0x7, 0x80, 0x8, 0x0, 0x7, 0x9f, 0xff,
    0xff, 0x3, 0xcf, 0xff, 0xff, 0x81, 0xe0, 0x0,
    0x0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x3e, 0x1f, 0xff, 0xf0, 0x1f, 0xf,
    0xff, 0xf8, 0x1f, 0x80, 0x0, 0x0, 0xd, 0xc0,
    0x0, 0x0, 0xc, 0xe0, 0x0, 0x0, 0x4, 0x70,
    0x0, 0x0, 0x6, 0x38, 0x0, 0x0, 0x6, 0x1c,
    0x3f, 0xff, 0xe0, 0xe, 0x1f, 0xff, 0xf0, 0x7,
    0x0, 0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x1,
    0xc0, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x0,
    0x70, 0x78, 0x7, 0x80, 0x38, 0x3c, 0x3, 0xc0,
    0x1c, 0x1f, 0xff, 0xe0, 0xe, 0xf, 0xff, 0xf0,
    0x7, 0x7, 0x80, 0x78, 0x3, 0x83, 0xc0, 0x3c,
    0x1, 0xc1, 0xe0, 0x1e, 0x0, 0xe0, 0xf0, 0xf,
    0x0, 0x70, 0x78, 0x7, 0x80, 0x38, 0x3c, 0x3,
    0xc0, 0x1c, 0x1e, 0x1, 0xe0, 0xe, 0xf, 0x0,
    0xf0, 0x7, 0x7, 0x80, 0x78, 0x3, 0x83, 0xc0,
    0x3c, 0x1, 0xc1, 0xff, 0xfe, 0x0, 0xe0, 0xff,
    0xff, 0x0, 0x70, 0x78, 0x7, 0x80, 0x38, 0x3c,
    0x3, 0xc0, 0x1c, 0x1e, 0x1, 0xe0,

    /* U+4FE3 "俣" */
    0x7, 0x0, 0x0, 0x0, 0x1c, 0x38, 0x3, 0xc0,
    0x70, 0xe0, 0xf, 0x1, 0xc3, 0xff, 0xfc, 0x7,
    0xf, 0xff, 0xf0, 0x1c, 0x38, 0x3, 0xc0, 0x70,
    0xe0, 0xf, 0x1, 0x83, 0x80, 0x3c, 0xe, 0xe,
    0x0, 0xf0, 0x38, 0x38, 0x3, 0xc0, 0xe0, 0xe0,
    0xf, 0x3, 0x3, 0x80, 0x3c, 0xe, 0xe, 0x0,
    0xf0, 0x78, 0x3f, 0xff, 0xc1, 0xe0, 0xff, 0xff,
    0x7, 0x83, 0x80, 0x3c, 0x3e, 0xe, 0x0, 0xf0,
    0xf8, 0x0, 0x0, 0x6, 0xe0, 0x0, 0x0, 0x1b,
    0x80, 0x0, 0x0, 0xce, 0x0, 0x0, 0x2, 0x38,
    0x7f, 0xff, 0xe0, 0xe1, 0xff, 0xff, 0x83, 0x80,
    0xf, 0x0, 0xe, 0x0, 0x3c, 0x0, 0x38, 0x0,
    0xf0, 0x0, 0xe0, 0x3, 0xc0, 0x3, 0x80, 0xf,
    0x0, 0xe, 0x3f, 0xff, 0xfc, 0x38, 0xff, 0xff,
    0xf0, 0xe0, 0x3, 0xb0, 0x3, 0x80, 0xe, 0xc0,
    0xe, 0x0, 0x3b, 0x0, 0x38, 0x1, 0xec, 0x0,
    0xe0, 0x7, 0xb8, 0x3, 0x80, 0x1c, 0x60, 0xe,
    0x0, 0xf1, 0x80, 0x38, 0x3, 0x87, 0x0, 0xe0,
    0x1c, 0x1e, 0x3, 0x80, 0x70, 0x3c, 0xe, 0x3,
    0x80, 0xfc, 0x38, 0x18, 0x1, 0xf0, 0xe0, 0xc0,
    0x3, 0x83, 0x86, 0x0, 0xe, 0xe, 0x20, 0x0,
    0x18, 0x39, 0x0, 0x0, 0x20, 0x0, 0x0, 0x0,
    0x0,

    /* U+4FE6 "俦" */
    0x3, 0xe0, 0x3c, 0x0, 0x1, 0xf0, 0x1e, 0x0,
    0x0, 0xf8, 0xf, 0x0, 0x0, 0x7c, 0x7, 0x80,
    0x0, 0x3c, 0x3, 0xc0, 0x0, 0x1e, 0xff, 0xff,
    0xf8, 0xf, 0x7f, 0xff, 0xfc, 0x7, 0x80, 0x78,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0x3, 0xc0, 0x1e,
    0x0, 0x1, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0xff,
    0xff, 0x80, 0xf0, 0x7f, 0xff, 0xc0, 0x7c, 0x1,
    0xe0, 0x0, 0x3e, 0x0, 0xf0, 0x0, 0x3f, 0x0,
    0x78, 0x0, 0x1f, 0x80, 0x3c, 0x0, 0x1f, 0xc0,
    0x1e, 0x0, 0xd, 0xef, 0xff, 0xff, 0xec, 0xf7,
    0xff, 0xff, 0xf6, 0x78, 0x3, 0x80, 0x6, 0x3c,
    0x3, 0xc3, 0xc0, 0x1e, 0x1, 0xe1, 0xe0, 0xf,
    0x0, 0xf0, 0xf0, 0x7, 0x80, 0x70, 0x78, 0x3,
    0xc0, 0x38, 0x3c, 0x1, 0xe0, 0x3f, 0xff, 0xe0,
    0xf0, 0x1f, 0xff, 0xf0, 0x78, 0xe, 0x7, 0x80,
    0x3c, 0x7, 0x3, 0xc0, 0x1e, 0x7, 0x81, 0xe0,
    0xf, 0x3, 0xe0, 0xf0, 0x7, 0x81, 0xb8, 0x78,
    0x3, 0xc1, 0xce, 0x3c, 0x1, 0xe0, 0xc7, 0x1e,
    0x0, 0xf0, 0xc3, 0x8f, 0x0, 0x78, 0x61, 0xc7,
    0x80, 0x3c, 0x60, 0x43, 0xc0, 0x1e, 0x30, 0x1,
    0xe0, 0xf, 0x30, 0x0, 0xf0, 0x7, 0x98, 0x0,
    0x78, 0x3, 0xd8, 0x0, 0x38, 0x1, 0xe8, 0x0,
    0x3c, 0x0, 0xfc, 0x0, 0x3c, 0x0, 0x7c, 0x0,
    0x7c, 0x0, 0x3c, 0x1, 0xf8, 0x0,

    /* U+4FE8 "俨" */
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0xf3, 0xff, 0xff, 0xc0, 0x79, 0xff, 0xff,
    0xe0, 0x38, 0x3, 0x8e, 0x0, 0x1c, 0x1, 0xc7,
    0x0, 0xe, 0x0, 0xe3, 0x80, 0xf, 0x10, 0x71,
    0xc0, 0x7, 0x8, 0x38, 0xe3, 0x83, 0x86, 0x1c,
    0x73, 0x81, 0x83, 0x8e, 0x39, 0x81, 0xc0, 0xc7,
    0x1d, 0xc0, 0xe0, 0x73, 0x8e, 0xc0, 0x78, 0x39,
    0xc7, 0xc0, 0x3c, 0x18, 0xe3, 0xe0, 0x3e, 0x4,
    0x71, 0xe0, 0x1f, 0x0, 0x38, 0xe0, 0x1b, 0x80,
    0x1c, 0x70, 0xd, 0xc3, 0x8e, 0x38, 0xc, 0xe1,
    0xff, 0xff, 0xf4, 0x70, 0xff, 0xff, 0xfe, 0x38,
    0x70, 0x0, 0x2, 0x1c, 0x38, 0x0, 0x0, 0xe,
    0x1c, 0x0, 0x0, 0x7, 0xe, 0x0, 0x0, 0x3,
    0x87, 0x0, 0x0, 0x1, 0xc3, 0x80, 0x0, 0x0,
    0xe1, 0xc0, 0x0, 0x0, 0x70, 0xe0, 0x0, 0x0,
    0x38, 0x70, 0x0, 0x0, 0x1c, 0x38, 0x0, 0x0,
    0xe, 0x1c, 0x0, 0x0, 0x7, 0xe, 0x0, 0x0,
    0x3, 0x87, 0x0, 0x0, 0x1, 0xc3, 0x80, 0x0,
    0x0, 0xe1, 0xc0, 0x0, 0x0, 0x70, 0xe0, 0x0,
    0x0, 0x38, 0x70, 0x0, 0x0, 0x1c, 0x38, 0x0,
    0x0, 0xe, 0x18, 0x0, 0x0, 0x7, 0xc, 0x0,
    0x0, 0x3, 0x8c, 0x0, 0x0, 0x1, 0xc6, 0x0,
    0x0, 0x0, 0xe6, 0x0, 0x0, 0x0, 0x76, 0x0,
    0x0, 0x0, 0x3a, 0x0, 0x0, 0x0,

    /* U+4FE9 "俩" */
    0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xff, 0x7, 0xff, 0xff, 0xff,
    0x7, 0x80, 0xe3, 0x80, 0x7, 0x80, 0xe3, 0x80,
    0x7, 0x80, 0xe3, 0x80, 0x7, 0x0, 0xe3, 0x80,
    0x7, 0x0, 0xe3, 0x80, 0x7, 0x0, 0xe3, 0x80,
    0xf, 0x1c, 0xe3, 0x9c, 0xe, 0x1c, 0xe3, 0x9c,
    0xe, 0x1c, 0xe3, 0x9c, 0xf, 0x1f, 0xff, 0xfc,
    0x1f, 0x1f, 0xff, 0xfc, 0x1f, 0x1c, 0xe3, 0x9c,
    0x1f, 0x1c, 0xe3, 0x9c, 0x3f, 0x1c, 0xe3, 0x9c,
    0x37, 0x1c, 0xe3, 0x9c, 0x27, 0x1c, 0xe3, 0x9c,
    0x67, 0x1c, 0xe3, 0x9c, 0x47, 0x1c, 0xe3, 0x9c,
    0xc7, 0x1c, 0xe3, 0x9c, 0x7, 0x1c, 0xe3, 0x9c,
    0x7, 0x1c, 0xe3, 0x9c, 0x7, 0x1c, 0xe3, 0x9c,
    0x7, 0x1c, 0xf3, 0x9c, 0x7, 0x1c, 0xdb, 0xdc,
    0x7, 0x1c, 0xdb, 0xdc, 0x7, 0x1c, 0xdf, 0xdc,
    0x7, 0x1c, 0xdf, 0x7c, 0x7, 0x1c, 0xd6, 0x7c,
    0x7, 0x1c, 0x86, 0x7c, 0x7, 0x1d, 0x8c, 0x7c,
    0x7, 0x1d, 0x8c, 0x5c, 0x7, 0x1d, 0xc, 0x5c,
    0x7, 0x1f, 0x18, 0x1c, 0x7, 0x1e, 0x18, 0x1c,
    0x7, 0x1e, 0x10, 0x1c, 0x7, 0x1c, 0x0, 0x1c,
    0x7, 0x1c, 0x0, 0x1c, 0x7, 0x1c, 0x0, 0x1c,
    0x7, 0x1c, 0x0, 0x1c, 0x7, 0x1c, 0x0, 0x3c,
    0x7, 0x1c, 0x0, 0x78, 0x7, 0x1c, 0x1, 0xa0,

    /* U+4FEA "俪" */
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0xf7, 0xff, 0xff, 0xe0, 0x7b, 0xff, 0xff,
    0xf0, 0x38, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0x8e, 0x3d,
    0xc3, 0x81, 0xc7, 0x1e, 0xe1, 0xc0, 0xe3, 0xff,
    0x7f, 0xe0, 0x61, 0xff, 0xbf, 0xf0, 0x78, 0xe3,
    0xdc, 0x38, 0x3c, 0x71, 0xee, 0x1c, 0x1e, 0x38,
    0xf7, 0xe, 0x1f, 0x1c, 0x7b, 0x87, 0xf, 0x8e,
    0x3d, 0xc3, 0x8d, 0xc7, 0x1e, 0xe1, 0xc6, 0xe3,
    0xaf, 0x78, 0xe2, 0x71, 0xd7, 0xbe, 0x73, 0x38,
    0xeb, 0xdf, 0x39, 0x1c, 0x77, 0xef, 0xdc, 0xe,
    0x3b, 0xf7, 0xee, 0x7, 0x1d, 0xfb, 0xbf, 0x3,
    0x8e, 0xfd, 0xdf, 0x81, 0xc7, 0x7e, 0xef, 0xc0,
    0xe3, 0xbf, 0x77, 0xe0, 0x71, 0xdf, 0xbb, 0xf0,
    0x38, 0xe7, 0xdd, 0xf8, 0x1c, 0x73, 0xee, 0x5c,
    0xe, 0x38, 0xf7, 0xe, 0x7, 0x1c, 0x7b, 0x87,
    0x3, 0x8e, 0x3d, 0xc3, 0x81, 0xc7, 0x1e, 0xe1,
    0xc0, 0xe3, 0x8f, 0x70, 0xe0, 0x71, 0xc7, 0xb8,
    0x70, 0x38, 0xe3, 0xdc, 0x38, 0x1c, 0x71, 0xee,
    0x1c, 0xe, 0x38, 0xf7, 0xe, 0x7, 0x1c, 0x7b,
    0x87, 0x3, 0x8e, 0x39, 0xc3, 0x81, 0xc7, 0x1c,
    0xe1, 0xc0, 0xe3, 0x8e, 0x71, 0xc0, 0x71, 0xce,
    0x39, 0xc0, 0x38, 0xe8, 0x1d, 0x0,

    /* U+4FED "俭" */
    0x1, 0xe0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x80,
    0x0, 0xf8, 0x7, 0xc0, 0x0, 0x7c, 0x3, 0xe0,
    0x0, 0x3c, 0x1, 0xf0, 0x0, 0x1e, 0x0, 0xf8,
    0x0, 0xf, 0x0, 0xf6, 0x0, 0x7, 0x80, 0x7b,
    0x0, 0x3, 0x80, 0x38, 0xc0, 0x3, 0xc0, 0x1c,
    0x60, 0x1, 0xe0, 0x1c, 0x38, 0x0, 0xe0, 0xc,
    0xe, 0x0, 0xf0, 0xe, 0x7, 0x0, 0x7c, 0x6,
    0x3, 0xc0, 0x3e, 0x6, 0x0, 0xf8, 0x3f, 0x3,
    0x0, 0x7e, 0x1f, 0x83, 0x0, 0x1f, 0x8b, 0xc3,
    0xff, 0xff, 0xcd, 0xe3, 0x7f, 0xff, 0xc4, 0xf1,
    0x0, 0x0, 0x66, 0x79, 0x0, 0x0, 0x12, 0x3f,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x40, 0xf0, 0xf,
    0x0, 0x20, 0x78, 0x7, 0x88, 0x18, 0x3c, 0x3,
    0xc4, 0xc, 0x1e, 0x1, 0xe1, 0x7, 0xf, 0x0,
    0xf0, 0x81, 0x87, 0x80, 0x78, 0x60, 0xc3, 0xc0,
    0x3c, 0x30, 0x71, 0xe0, 0x1e, 0x1c, 0x38, 0xe0,
    0xf, 0x6, 0x1e, 0x70, 0x7, 0x83, 0xf, 0x38,
    0x3, 0xc1, 0xc7, 0x1c, 0x1, 0xe0, 0xe1, 0x1c,
    0x0, 0xf0, 0x38, 0xe, 0x0, 0x78, 0x1c, 0x7,
    0x0, 0x3c, 0xe, 0x3, 0x0, 0x1e, 0x6, 0x3,
    0x0, 0xf, 0x2, 0x1, 0x80, 0x7, 0x80, 0x1,
    0x80, 0x3, 0xc0, 0x0, 0x80, 0x1, 0xe0, 0x0,
    0x80, 0x0, 0xf7, 0xff, 0xff, 0xe0, 0x7b, 0xff,
    0xff, 0xf0, 0x3c, 0x0, 0x0, 0x0,

    /* U+4FEE "修" */
    0x1, 0xe0, 0x1f, 0x0, 0x0, 0x78, 0x7, 0xc0,
    0x0, 0x1e, 0x1, 0xe0, 0x0, 0x7, 0x80, 0x78,
    0x7c, 0x3, 0xe0, 0x3e, 0x1f, 0x0, 0xf0, 0xf,
    0xff, 0xc0, 0x3c, 0x3, 0xff, 0xf0, 0xf, 0x0,
    0xe0, 0x78, 0x3, 0xc0, 0x38, 0x3e, 0x0, 0xe0,
    0x1e, 0xf, 0x0, 0x7b, 0xc7, 0xc3, 0xc0, 0x1e,
    0xf1, 0x91, 0xe0, 0x7, 0x3c, 0xc6, 0x78, 0x1,
    0xef, 0x31, 0xfc, 0x0, 0xfb, 0xd8, 0x3e, 0x0,
    0x3e, 0xf4, 0xf, 0x0, 0x1f, 0xbf, 0x3, 0xe0,
    0x7, 0xef, 0x1, 0xfe, 0x1, 0x7b, 0xc0, 0xef,
    0xe0, 0xde, 0xf0, 0x71, 0xff, 0x27, 0xbc, 0x38,
    0x3f, 0x91, 0xef, 0x18, 0xf7, 0xe0, 0x7b, 0xcc,
    0x3c, 0xf8, 0x1e, 0xfe, 0x1e, 0xe, 0x7, 0xbc,
    0x7, 0x80, 0x81, 0xef, 0x1, 0xc0, 0x0, 0x7b,
    0xc0, 0xf7, 0xc0, 0x1e, 0xf0, 0x39, 0xe0, 0x7,
    0xbc, 0x1c, 0xf8, 0x1, 0xef, 0xe, 0x3c, 0x0,
    0x7b, 0xc3, 0x1e, 0x0, 0x1e, 0xf1, 0x7, 0x80,
    0x7, 0xbc, 0x83, 0x8f, 0x1, 0xef, 0x1, 0xc7,
    0xc0, 0x7b, 0xc0, 0xe1, 0xe0, 0x1e, 0xf0, 0x70,
    0xf8, 0x7, 0x80, 0x30, 0x3c, 0x1, 0xe0, 0x18,
    0x1e, 0x0, 0x78, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0x7, 0x80, 0x7, 0x80, 0x3, 0xc0, 0x1, 0xe0,
    0x1, 0xc0, 0x0, 0x78, 0x0, 0xc0, 0x0, 0x1e,
    0x0, 0x60, 0x0, 0x7, 0x80, 0x60, 0x0, 0x1,
    0xe0, 0x60, 0x0, 0x0,

    /* U+4FEF "俯" */
    0x7, 0x80, 0x10, 0x0, 0x7, 0x80, 0x1c, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0xbc, 0x7, 0x0, 0x7, 0x3f, 0xff, 0xff,
    0x7, 0x3f, 0xff, 0xff, 0xf, 0x3c, 0x0, 0x0,
    0xf, 0x3c, 0x78, 0x0, 0xf, 0x3c, 0x78, 0x78,
    0xe, 0x3c, 0x78, 0x78, 0xe, 0x3c, 0x78, 0x78,
    0xc, 0x3c, 0x70, 0x78, 0x1e, 0x3c, 0xf0, 0x78,
    0x1e, 0x3c, 0xf0, 0x78, 0x1e, 0x3c, 0xe0, 0x78,
    0x3e, 0x3c, 0xe7, 0xff, 0x3e, 0x3c, 0xc7, 0xff,
    0x2e, 0x3c, 0xe0, 0x78, 0x6e, 0x3d, 0xe0, 0x78,
    0x4e, 0x3d, 0xe0, 0x78, 0x8e, 0x3d, 0xe0, 0x78,
    0x8e, 0x3e, 0xe4, 0x78, 0xe, 0x3c, 0xe4, 0x78,
    0xe, 0x3c, 0xe6, 0x78, 0xe, 0x3c, 0xe7, 0x78,
    0xe, 0x3c, 0xe7, 0x78, 0xe, 0x3c, 0xe7, 0xf8,
    0xe, 0x3c, 0xe3, 0xf8, 0xe, 0x3c, 0xe3, 0xf8,
    0xe, 0x3c, 0xe3, 0xf8, 0xe, 0x3c, 0xe3, 0x78,
    0xe, 0x3c, 0xe0, 0x78, 0xe, 0x3c, 0xe0, 0x78,
    0xe, 0x3c, 0xe0, 0x78, 0xe, 0x3c, 0xe0, 0x78,
    0xe, 0x38, 0xe0, 0x78, 0xe, 0x38, 0xe0, 0x78,
    0xe, 0x38, 0xe0, 0x78, 0xe, 0x70, 0xe0, 0x78,
    0xe, 0x70, 0xe0, 0x78, 0xe, 0x60, 0xe0, 0x78,
    0xe, 0x40, 0xe0, 0x70, 0xe, 0xc0, 0xe0, 0xf0,
    0xe, 0x80, 0xe1, 0xe0, 0xf, 0x0, 0xe6, 0x80,

    /* U+4FF1 "俱" */
    0x3, 0xe7, 0x80, 0x3c, 0x1, 0xf3, 0xc0, 0x1e,
    0x0, 0xf1, 0xff, 0xff, 0x0, 0x78, 0xff, 0xff,
    0x80, 0x7c, 0x78, 0x3, 0xc0, 0x3e, 0x3c, 0x1,
    0xe0, 0x1e, 0x1e, 0x0, 0xf0, 0xf, 0xf, 0x0,
    0x78, 0x7, 0x87, 0x80, 0x3c, 0x3, 0x83, 0xff,
    0xde, 0x3, 0xc1, 0xff, 0xef, 0x1, 0xc0, 0xf0,
    0x7, 0x80, 0xe0, 0x78, 0x3, 0xc0, 0xfc, 0x3c,
    0x1, 0xe0, 0x7e, 0x1e, 0x0, 0xf0, 0x3f, 0xf,
    0x0, 0x78, 0x3f, 0x87, 0xff, 0xbc, 0x1b, 0xc3,
    0xff, 0xde, 0xd, 0xe1, 0xe0, 0xf, 0xc, 0xf0,
    0xf0, 0x7, 0x84, 0x78, 0x78, 0x3, 0xc6, 0x3c,
    0x3c, 0x1, 0xe0, 0x1e, 0x1e, 0x0, 0xf0, 0xf,
    0xf, 0xff, 0x78, 0x7, 0x87, 0xff, 0xbc, 0x3,
    0xc3, 0xc0, 0x1e, 0x1, 0xe1, 0xe0, 0xf, 0x0,
    0xf0, 0xf0, 0x7, 0x80, 0x78, 0x78, 0x3, 0xc0,
    0x3c, 0x3c, 0x1, 0xe0, 0x1e, 0xff, 0xff, 0xfe,
    0xf, 0x7f, 0xff, 0xff, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x7c, 0x10,
    0x0, 0xf0, 0x3e, 0x8, 0x0, 0x78, 0x1e, 0x2,
    0x0, 0x3c, 0xf, 0x1, 0x80, 0x1e, 0xf, 0x0,
    0xe0, 0xf, 0x7, 0x0, 0x3c, 0x7, 0x87, 0x80,
    0x1f, 0x3, 0xc3, 0x80, 0xf, 0x81, 0xe3, 0x80,
    0x3, 0xc0, 0xf3, 0x80, 0x0, 0xe0, 0x79, 0x80,
    0x0, 0x30, 0x3d, 0x80, 0x0, 0x8,

    /* U+4FF3 "俳" */
    0x3, 0xc0, 0xf3, 0xc0, 0x3, 0xc0, 0xf3, 0xc0,
    0x3, 0xc0, 0xf3, 0xc0, 0x3, 0xc0, 0xf3, 0xc0,
    0x3, 0x80, 0xf3, 0xc0, 0x3, 0x80, 0xf3, 0xc0,
    0x7, 0x80, 0xf3, 0xc0, 0x7, 0x80, 0xf3, 0xc0,
    0x7, 0x80, 0xf3, 0xc0, 0x7, 0x1f, 0xf3, 0xff,
    0x7, 0x1f, 0xf3, 0xff, 0xf, 0x0, 0xf3, 0xc0,
    0xe, 0x0, 0xf3, 0xc0, 0xf, 0x0, 0xf3, 0xc0,
    0x1f, 0x0, 0xf3, 0xc0, 0x1f, 0x0, 0xf3, 0xc0,
    0x1f, 0x0, 0xf3, 0xc0, 0x3f, 0x0, 0xf3, 0xc0,
    0x37, 0x0, 0xf3, 0xc0, 0x67, 0x1f, 0xf3, 0xfe,
    0x67, 0x1f, 0xf3, 0xfe, 0xc7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x1f, 0xf3, 0xff, 0x7, 0x1f, 0xf3, 0xff,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,
    0x7, 0x0, 0xf3, 0xc0, 0x7, 0x0, 0xf3, 0xc0,

    /* U+4FF5 "俵" */
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xdf, 0xff, 0xff,
    0x3, 0x9f, 0xff, 0xff, 0x3, 0x80, 0x1e, 0x0,
    0x3, 0x80, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0xe, 0xf, 0xff, 0xfc, 0xf, 0xf, 0xff, 0xfc,
    0xf, 0x0, 0x1e, 0x0, 0x1f, 0x0, 0x1e, 0x0,
    0x1f, 0x0, 0x1e, 0x0, 0x37, 0x0, 0x1e, 0x0,
    0x37, 0x0, 0x1e, 0x0, 0x67, 0x0, 0x1e, 0x0,
    0x47, 0x7f, 0xff, 0xff, 0xc7, 0x7f, 0xff, 0xff,
    0x7, 0x0, 0x7a, 0x0, 0x7, 0x0, 0x7a, 0x0,
    0x7, 0x0, 0xf2, 0x4, 0x7, 0x0, 0xe2, 0xc,
    0x7, 0x1, 0xe2, 0x8, 0x7, 0x1, 0xc3, 0x18,
    0x7, 0x3, 0xc3, 0x30, 0x7, 0x3, 0xc3, 0x30,
    0x7, 0x7, 0xc3, 0xe0, 0x7, 0x7, 0xc3, 0xe0,
    0x7, 0xf, 0xc1, 0xc0, 0x7, 0x1b, 0xc1, 0xc0,
    0x7, 0x33, 0xc1, 0xc0, 0x7, 0x63, 0xc1, 0xe0,
    0x7, 0x83, 0xc0, 0xf0, 0x7, 0x3, 0xc0, 0xf8,
    0x7, 0x3, 0xc1, 0xfc, 0x7, 0x3, 0xc6, 0x7e,
    0x7, 0x3, 0xfc, 0x7c, 0x7, 0x1f, 0xf0, 0x3c,
    0x7, 0x1f, 0xe0, 0x1c, 0x7, 0x1f, 0x80, 0xc,
    0x7, 0xe, 0x0, 0x4, 0x7, 0x8, 0x0, 0x0,

    /* U+4FF8 "俸" */
    0x3, 0xe0, 0x1f, 0x0, 0x1, 0xf0, 0xf, 0x80,
    0x0, 0xf0, 0x7, 0xc0, 0x0, 0x78, 0x3, 0xe0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0xff, 0xff,
    0xf8, 0xf, 0x7f, 0xff, 0xfc, 0x7, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x1, 0xc0, 0x7, 0x0, 0x0, 0xe0, 0xff,
    0xff, 0xc0, 0xe0, 0x7f, 0xff, 0xe0, 0x78, 0x1,
    0xe0, 0x0, 0x3c, 0x0, 0xe0, 0x0, 0x3e, 0x0,
    0x70, 0x0, 0x1f, 0x0, 0x78, 0x0, 0x1f, 0x9f,
    0xff, 0xff, 0x8d, 0xcf, 0xff, 0xff, 0xcc, 0xe0,
    0x1c, 0x10, 0x6, 0x70, 0xe, 0xc, 0x6, 0x38,
    0x6, 0x6, 0x0, 0x1c, 0x7, 0x39, 0x80, 0xe,
    0x7, 0x1c, 0xe0, 0x7, 0x3, 0xe, 0x3c, 0x3,
    0x83, 0x7, 0x1f, 0xc1, 0xc3, 0x83, 0x87, 0xc0,
    0xe3, 0x81, 0xc3, 0xe0, 0x71, 0xff, 0xff, 0xf0,
    0x39, 0xbf, 0xff, 0xf8, 0x1f, 0x80, 0x38, 0x0,
    0xe, 0x0, 0x1c, 0x0, 0x7, 0x0, 0xe, 0x0,
    0x3, 0x80, 0x7, 0x0, 0x1, 0xc7, 0xff, 0xff,
    0xc0, 0xe3, 0xff, 0xff, 0xe0, 0x70, 0x0, 0xe0,
    0x0, 0x38, 0x0, 0x70, 0x0, 0x1c, 0x0, 0x38,
    0x0, 0xe, 0x0, 0x1c, 0x0, 0x7, 0x0, 0xe,
    0x0, 0x3, 0x80, 0x7, 0x0, 0x1, 0xc0, 0x3,
    0x80, 0x0, 0xe0, 0x1, 0xc0, 0x0, 0x70, 0x0,
    0xe0, 0x0, 0x38, 0x0, 0x70, 0x0,

    /* U+4FFA "俺" */
    0x3, 0xc0, 0x1f, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3c, 0x3, 0xe0, 0x0, 0x1e, 0xff, 0xff,
    0xf8, 0xe, 0x7f, 0xff, 0xfc, 0x7, 0x0, 0x7a,
    0x0, 0x7, 0x80, 0x79, 0x80, 0x3, 0x80, 0x3c,
    0x40, 0x1, 0xc0, 0x3c, 0x30, 0x0, 0xe0, 0x1e,
    0x18, 0x0, 0xe0, 0x1e, 0x6, 0x0, 0x78, 0xe,
    0x3, 0x80, 0x3c, 0xf, 0x39, 0xe0, 0x3e, 0x7,
    0x1c, 0x78, 0x1f, 0x7, 0xe, 0x3e, 0xb, 0x87,
    0x7, 0xf, 0xcd, 0xc3, 0xc3, 0x8f, 0xc4, 0xe3,
    0xe1, 0xc7, 0xe6, 0x73, 0x7f, 0xff, 0xf2, 0x3b,
    0x38, 0x71, 0xfb, 0x1f, 0x1c, 0x38, 0xf4, 0xe,
    0xe, 0x1c, 0x78, 0x7, 0x7, 0xe, 0x3c, 0x3,
    0x83, 0x87, 0x1e, 0x1, 0xc1, 0xff, 0xff, 0x0,
    0xe0, 0xff, 0xff, 0x80, 0x70, 0x70, 0xe3, 0xc0,
    0x38, 0x38, 0x71, 0xe0, 0x1c, 0x1c, 0x38, 0xf0,
    0xe, 0xe, 0x1c, 0x78, 0x7, 0x7, 0xff, 0xfd,
    0x3, 0x83, 0xff, 0xfe, 0x81, 0xc1, 0xc3, 0x8f,
    0x40, 0xe0, 0xe1, 0xc7, 0xa0, 0x70, 0x70, 0xe0,
    0x10, 0x38, 0x0, 0x70, 0x8, 0x1c, 0x0, 0x38,
    0x4, 0xe, 0x0, 0x1c, 0x7, 0x7, 0x0, 0xe,
    0x3, 0x83, 0x80, 0x7, 0x1, 0xc1, 0xc0, 0x3,
    0x80, 0xe0, 0xe0, 0x1, 0xff, 0xf0, 0x70, 0x0,
    0xff, 0xf8, 0x38, 0x0, 0x3f, 0xf8,

    /* U+4FFE "俾" */
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1c, 0x0, 0x3, 0xc0, 0x1c, 0x0,
    0x3, 0xce, 0x38, 0x1c, 0x3, 0x8e, 0x20, 0x1c,
    0x3, 0x8f, 0xff, 0xfc, 0x7, 0x8f, 0xff, 0xfc,
    0x7, 0x8e, 0x1c, 0x1c, 0x7, 0xe, 0x1c, 0x1c,
    0x7, 0xe, 0x1c, 0x1c, 0x7, 0xe, 0x1c, 0x1c,
    0xe, 0xe, 0x1c, 0x1c, 0xf, 0x8f, 0xff, 0xfc,
    0xf, 0x8f, 0xff, 0xfc, 0x1f, 0x8e, 0x1c, 0x1c,
    0x1f, 0x8e, 0x1c, 0x1c, 0x1f, 0x8e, 0x1c, 0x1c,
    0x37, 0x8e, 0x1c, 0x1c, 0x37, 0x8e, 0x1c, 0x1c,
    0x67, 0x8e, 0x1c, 0x1c, 0x47, 0x8f, 0xff, 0xfc,
    0xc7, 0x8f, 0xff, 0xfc, 0x7, 0x8e, 0x38, 0x1c,
    0x7, 0x8e, 0x38, 0x1c, 0x7, 0x8e, 0x70, 0x1c,
    0x7, 0x80, 0x7f, 0x0, 0x7, 0x80, 0xef, 0x0,
    0x7, 0x80, 0xcf, 0x0, 0x7, 0x81, 0x8f, 0x0,
    0x7, 0x83, 0xf, 0x0, 0x7, 0x84, 0xf, 0x0,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,

    /* U+5000 "倀" */
    0x7, 0xc7, 0x0, 0x0, 0xf, 0x8e, 0x0, 0x0,
    0x1e, 0x1f, 0xff, 0xf8, 0x3c, 0x3f, 0xff, 0xf0,
    0x78, 0x70, 0x0, 0x0, 0xf0, 0xe0, 0x0, 0x1,
    0xc1, 0xc0, 0x0, 0x3, 0x83, 0x80, 0x0, 0xf,
    0x7, 0x0, 0x0, 0x1e, 0xf, 0xff, 0xf0, 0x38,
    0x1f, 0xff, 0xe0, 0x70, 0x38, 0x0, 0x0, 0xc0,
    0x70, 0x0, 0x3, 0x80, 0xe0, 0x0, 0x7, 0xc1,
    0xc0, 0x0, 0xf, 0x83, 0x80, 0x0, 0x1f, 0x7,
    0xff, 0xf8, 0x7e, 0xf, 0xff, 0xf0, 0xbc, 0x1c,
    0x0, 0x3, 0x78, 0x38, 0x0, 0x4, 0xf0, 0x70,
    0x0, 0x11, 0xe0, 0xe0, 0x0, 0x3, 0xdf, 0xff,
    0xff, 0x87, 0xbf, 0xff, 0xff, 0xf, 0x7, 0x10,
    0x0, 0x1e, 0xe, 0x20, 0x0, 0x3c, 0x1c, 0x40,
    0x20, 0x78, 0x38, 0xc0, 0xc0, 0xf0, 0x71, 0x83,
    0x1, 0xe0, 0xe1, 0xc, 0x3, 0xc1, 0xc3, 0x18,
    0x7, 0x83, 0x86, 0x60, 0xf, 0x7, 0xf, 0x80,
    0x1e, 0xe, 0x1e, 0x0, 0x3c, 0x1c, 0x1c, 0x0,
    0x78, 0x38, 0x3c, 0x0, 0xf0, 0x70, 0x7c, 0x1,
    0xe0, 0xe1, 0x7c, 0x3, 0xc1, 0xc6, 0x7c, 0x7,
    0x83, 0x98, 0xfe, 0xf, 0x7, 0xe0, 0xfe, 0x1e,
    0xff, 0x80, 0xf8, 0x3c, 0xfc, 0x0, 0xf0, 0x79,
    0xf0, 0x0, 0xe0, 0xf3, 0x80, 0x0, 0xc1, 0xe0,
    0x0, 0x0, 0x0,

    /* U+5006 "倆" */
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0x80, 0x3c, 0x0, 0x7, 0x0, 0x3c, 0x0,
    0x7, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x3c, 0x0, 0xe, 0x0, 0x3c, 0x0,
    0xe, 0x3c, 0x3c, 0x1e, 0xe, 0x3f, 0xff, 0xfe,
    0xc, 0x3f, 0xff, 0xfe, 0x1c, 0x3c, 0x3c, 0x1e,
    0x1e, 0x3c, 0x3c, 0x1e, 0x1e, 0x3c, 0x3c, 0x1e,
    0x3e, 0x3d, 0x3d, 0x1e, 0x3e, 0x3d, 0x3d, 0x1e,
    0x2e, 0x3d, 0x3d, 0x9e, 0x6e, 0x3c, 0xbc, 0x9e,
    0x4e, 0x3c, 0xbc, 0x9e, 0x4e, 0x3c, 0xbd, 0x9e,
    0xe, 0x3d, 0xbd, 0x9e, 0xe, 0x3d, 0xbd, 0x9e,
    0xe, 0x3d, 0xbd, 0x9e, 0xe, 0x3d, 0xbd, 0xde,
    0xe, 0x3d, 0xbd, 0xde, 0xe, 0x3f, 0xff, 0xde,
    0xe, 0x3f, 0xfe, 0xfe, 0xe, 0x3e, 0xfe, 0xfe,
    0xe, 0x3e, 0xfe, 0x7e, 0xe, 0x3c, 0xfc, 0x7e,
    0xe, 0x3c, 0x7c, 0x5e, 0xe, 0x3c, 0x3c, 0x1e,
    0xe, 0x3c, 0x3c, 0x1e, 0xe, 0x3c, 0x3c, 0x1e,
    0xe, 0x3c, 0x3c, 0x1e, 0xe, 0x3c, 0x3c, 0x1e,
    0xe, 0x3c, 0x3c, 0x1e, 0xe, 0x3c, 0x3c, 0x1e,
    0xe, 0x3c, 0x3c, 0x1e, 0xe, 0x3c, 0x3c, 0x1e,
    0xe, 0x3c, 0x3c, 0x1c, 0xe, 0x3c, 0x0, 0x78,
    0xe, 0x3c, 0x1, 0xf0, 0xe, 0x3c, 0x6, 0xc0,

    /* U+5009 "倉" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x0, 0xf, 0xc0, 0x0, 0x0, 0xf, 0x60, 0x0,
    0x0, 0x1f, 0x20, 0x0, 0x0, 0x1e, 0x30, 0x0,
    0x0, 0x1c, 0x18, 0x0, 0x0, 0x3c, 0x1c, 0x0,
    0x0, 0x7a, 0xe, 0x0, 0x0, 0x73, 0xf, 0x0,
    0x0, 0xe1, 0xc7, 0xc0, 0x1, 0xc1, 0xe3, 0xf0,
    0x1, 0x80, 0xc3, 0xfc, 0x3, 0x0, 0xc1, 0xfe,
    0x7, 0xc0, 0x3, 0xfe, 0xf, 0xff, 0xff, 0xfc,
    0x1b, 0xff, 0xff, 0xdc, 0x63, 0xc0, 0x3, 0xc4,
    0xc3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xff, 0xf3, 0xc0, 0x3, 0xff, 0xf3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xff, 0xff, 0xc0, 0x3, 0xff, 0xff, 0xc0,
    0x3, 0x80, 0x3, 0xc0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xe0, 0x6, 0xff, 0xff, 0xe0,
    0xe, 0xf0, 0x3, 0xe0, 0xc, 0xf0, 0x3, 0xe0,
    0xc, 0xf0, 0x3, 0xe0, 0x18, 0xf0, 0x3, 0xe0,
    0x18, 0xf0, 0x3, 0xe0, 0x10, 0xf0, 0x3, 0xe0,
    0x30, 0xff, 0xff, 0xe0, 0x20, 0xff, 0xff, 0xe0,
    0x60, 0xf0, 0x3, 0xe0, 0x0, 0xf0, 0x3, 0xe0,
    0x0, 0xf0, 0x3, 0xe0, 0x0, 0xf0, 0x3, 0xe0,

    /* U+500B "個" */
    0xf, 0x80, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x0,
    0xf3, 0x80, 0x1, 0xc3, 0xcf, 0xff, 0xff, 0xf,
    0x3f, 0xff, 0xfc, 0x3c, 0xe0, 0x0, 0x70, 0xf3,
    0x83, 0x81, 0xc3, 0x8e, 0xe, 0x7, 0x1e, 0x38,
    0x38, 0x1c, 0x78, 0xe0, 0xe0, 0x71, 0xe3, 0x83,
    0x81, 0xc7, 0xe, 0xe, 0x7, 0x1c, 0x3b, 0xff,
    0x9c, 0x70, 0xef, 0xfe, 0x73, 0xe3, 0x83, 0x81,
    0xcf, 0x8e, 0xe, 0x7, 0x3e, 0x38, 0x38, 0x1c,
    0xf8, 0xe0, 0xc0, 0x76, 0xe3, 0x83, 0x1, 0xdb,
    0x8e, 0x8, 0x7, 0x4e, 0x38, 0x40, 0x1e, 0x38,
    0xe7, 0x1c, 0x78, 0xe3, 0x9f, 0xf1, 0xc3, 0x8e,
    0x7f, 0xc7, 0xe, 0x39, 0xc7, 0x1c, 0x38, 0xe7,
    0x1c, 0x70, 0xe3, 0x9c, 0x71, 0xc3, 0x8e, 0x71,
    0xc7, 0xe, 0x39, 0xc7, 0x1c, 0x38, 0xe7, 0x1c,
    0x70, 0xe3, 0x9c, 0x71, 0xc3, 0x8e, 0x71, 0xc7,
    0xe, 0x39, 0xc7, 0x1c, 0x38, 0xe7, 0x1c, 0x70,
    0xe3, 0x9f, 0xf1, 0xc3, 0x8e, 0x71, 0xc7, 0xe,
    0x39, 0xc7, 0x1c, 0x38, 0xe7, 0x1c, 0x70, 0xe3,
    0x9c, 0x71, 0xc3, 0x8e, 0x0, 0x7, 0xe, 0x38,
    0x0, 0x1c, 0x38, 0xff, 0xff, 0xf0, 0xe3, 0xff,
    0xff, 0xc3, 0x8e, 0x0, 0x7, 0xe, 0x38, 0x0,
    0x1c, 0x38, 0xe0, 0x0, 0x70,

    /* U+500C "倌" */
    0x3, 0xc0, 0x10, 0x0, 0x7, 0x80, 0x30, 0x0,
    0xf, 0x0, 0x70, 0x0, 0x1e, 0x0, 0xf8, 0x0,
    0x78, 0x0, 0xe0, 0x0, 0xf1, 0xc1, 0xc3, 0xc1,
    0xe3, 0xff, 0xff, 0x83, 0xc7, 0xff, 0xff, 0x7,
    0xe, 0x0, 0x1e, 0xe, 0x1c, 0x0, 0x3c, 0x3c,
    0x38, 0x0, 0x78, 0x70, 0x70, 0x0, 0x80, 0xe0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x7, 0xc1,
    0xc0, 0x1c, 0xf, 0x83, 0xff, 0xf8, 0x1f, 0x7,
    0xff, 0xf0, 0x7e, 0xe, 0x0, 0xe0, 0xdc, 0x1c,
    0x1, 0xc3, 0x38, 0x38, 0x3, 0x86, 0x70, 0x70,
    0x7, 0x8, 0xe0, 0xe0, 0xe, 0x21, 0xc1, 0xc0,
    0x1c, 0x3, 0x83, 0xff, 0xf8, 0x7, 0x7, 0xff,
    0xf0, 0xe, 0xf, 0xff, 0xe0, 0x1c, 0x1c, 0x1,
    0xc0, 0x38, 0x38, 0x0, 0x0, 0x70, 0x70, 0x0,
    0x0, 0xe0, 0xe0, 0x0, 0x1, 0xc1, 0xc0, 0xe,
    0x3, 0x83, 0xff, 0xfc, 0x7, 0x7, 0xff, 0xf8,
    0xe, 0xe, 0x0, 0x70, 0x1c, 0x1c, 0x0, 0xe0,
    0x38, 0x38, 0x1, 0xc0, 0x70, 0x70, 0x3, 0x80,
    0xe0, 0xe0, 0x7, 0x1, 0xc1, 0xc0, 0xe, 0x3,
    0x83, 0x80, 0x1c, 0x7, 0x7, 0x0, 0x38, 0xe,
    0xf, 0xff, 0xf0, 0x1c, 0x1f, 0xff, 0xe0, 0x38,
    0x38, 0x1, 0xc0, 0x70, 0x70, 0x3, 0x80, 0xe0,
    0xe0, 0x7, 0x0,

    /* U+500D "倍" */
    0x3, 0xe0, 0x8, 0x0, 0x3, 0xe0, 0xc, 0x0,
    0x3, 0xe0, 0xf, 0x0, 0x3, 0xe0, 0xf, 0x0,
    0x3, 0xe0, 0x7, 0x0, 0x3, 0xc0, 0x6, 0x0,
    0x3, 0xcf, 0xff, 0xfe, 0x7, 0xcf, 0xff, 0xfe,
    0x7, 0xc0, 0x0, 0x20, 0x7, 0x80, 0x0, 0x30,
    0x7, 0x80, 0x0, 0x70, 0x7, 0x1, 0x0, 0x60,
    0xf, 0x1, 0x80, 0x60, 0xf, 0x80, 0xc0, 0xe0,
    0xf, 0x80, 0xe0, 0xc0, 0x1f, 0x80, 0xf0, 0xc0,
    0x1f, 0x80, 0x78, 0xc0, 0x37, 0x80, 0x71, 0x80,
    0x37, 0x80, 0x71, 0x80, 0x27, 0x80, 0x21, 0x80,
    0x47, 0xbf, 0xff, 0xff, 0xc7, 0xbf, 0xff, 0xff,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0x80, 0x38,
    0x7, 0x87, 0xff, 0xf8, 0x7, 0x87, 0xff, 0xf8,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0x80, 0x38,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0x80, 0x38,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0x80, 0x38,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0x80, 0x38,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0x80, 0x38,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0xff, 0xf8,
    0x7, 0x87, 0xff, 0xf8, 0x7, 0x87, 0x80, 0x38,
    0x7, 0x87, 0x80, 0x38, 0x7, 0x87, 0x80, 0x38,

    /* U+500F "倏" */
    0x3, 0xe0, 0x78, 0x0, 0x1, 0xe0, 0x3c, 0x0,
    0x0, 0xf0, 0x1e, 0x7, 0x80, 0x78, 0xe, 0x3,
    0xc0, 0x3c, 0x7, 0xff, 0xe0, 0x1e, 0x3, 0xff,
    0xf0, 0xe, 0x3, 0x80, 0xf0, 0x7, 0x1, 0xc0,
    0x78, 0x3, 0x80, 0xe0, 0x3c, 0x3, 0xc0, 0x70,
    0x1c, 0x1, 0xc0, 0x34, 0x1e, 0x0, 0xe3, 0xb3,
    0xe, 0x0, 0x71, 0xd8, 0xcf, 0x0, 0x78, 0xe8,
    0x77, 0x0, 0x3c, 0x78, 0x1f, 0x0, 0x1e, 0x38,
    0x7, 0x80, 0x1f, 0x1c, 0x7, 0xf8, 0xf, 0x8e,
    0x7, 0x7f, 0xcd, 0xc7, 0x6, 0x1f, 0xe6, 0xe3,
    0x86, 0x3, 0xe6, 0x71, 0xc6, 0x0, 0x72, 0x38,
    0xec, 0x3c, 0x8, 0x1c, 0x7c, 0x1e, 0x80, 0xe,
    0x38, 0xf, 0x20, 0x7, 0x1c, 0x7, 0x9c, 0x3,
    0x8e, 0x3, 0xc7, 0x1, 0xc7, 0x1, 0xe3, 0x0,
    0xe3, 0x80, 0xf1, 0x0, 0x71, 0xff, 0xff, 0xf8,
    0x38, 0xff, 0xff, 0xfc, 0x1c, 0x70, 0x3e, 0x0,
    0xe, 0x38, 0x1f, 0x0, 0x7, 0x1c, 0xf, 0xc0,
    0x3, 0x8e, 0x7, 0xe0, 0x1, 0xc7, 0x3, 0x90,
    0x0, 0xe3, 0x83, 0xcc, 0x0, 0x71, 0xc1, 0xc7,
    0x0, 0x38, 0x1, 0xc1, 0x80, 0x1c, 0x0, 0xe0,
    0xf0, 0xe, 0x0, 0xe0, 0x7c, 0x7, 0x0, 0x60,
    0x1f, 0x83, 0x80, 0x60, 0xf, 0x81, 0xc0, 0x60,
    0x3, 0xc0, 0xe0, 0x60, 0x0, 0xe0, 0x70, 0x20,
    0x0, 0x30, 0x38, 0x20, 0x0, 0x8,

    /* U+5011 "們" */
    0x0, 0x0, 0x73, 0x9e, 0xf, 0xb8, 0xe7, 0x3c,
    0x1f, 0x71, 0xce, 0x78, 0x3c, 0xff, 0x9f, 0xf0,
    0x79, 0xff, 0x3f, 0xe0, 0xf3, 0x8e, 0x73, 0xc1,
    0xe7, 0x1c, 0xe7, 0x83, 0xce, 0x39, 0xcf, 0x7,
    0x1c, 0x73, 0x9e, 0x1e, 0x38, 0xe7, 0x3c, 0x3c,
    0x71, 0xce, 0x78, 0x70, 0xe3, 0x9c, 0xf0, 0xe1,
    0xff, 0x3f, 0xe1, 0xe3, 0xfe, 0x7f, 0xc7, 0xc7,
    0x1c, 0xe7, 0x8f, 0x8e, 0x39, 0xcf, 0x1f, 0x1c,
    0x73, 0x9e, 0x7e, 0x38, 0xe7, 0x3c, 0xbc, 0x71,
    0xce, 0x7b, 0x78, 0xe3, 0x9f, 0xf4, 0xf1, 0xff,
    0x3f, 0xe1, 0xe3, 0x8e, 0x7f, 0xc3, 0xc7, 0x1c,
    0xe7, 0x87, 0x8e, 0x39, 0xcf, 0xf, 0x1c, 0x0,
    0x1e, 0x1e, 0x38, 0x0, 0x3c, 0x3c, 0x70, 0x0,
    0x78, 0x78, 0xe0, 0x0, 0xf0, 0xf1, 0xc0, 0x1,
    0xe1, 0xe3, 0x80, 0x3, 0xc3, 0xc7, 0x0, 0x7,
    0x87, 0x8e, 0x0, 0xf, 0xf, 0x1c, 0x0, 0x1e,
    0x1e, 0x38, 0x0, 0x3c, 0x3c, 0x70, 0x0, 0x78,
    0x78, 0xe0, 0x0, 0xf0, 0xf1, 0xc0, 0x1, 0xe1,
    0xe3, 0x80, 0x3, 0xc3, 0xc7, 0x0, 0x7, 0x87,
    0x8e, 0x0, 0xf, 0xf, 0x1c, 0x0, 0x1e, 0x1e,
    0x38, 0x0, 0x3c, 0x3c, 0x70, 0x0, 0xf0, 0x78,
    0xe0, 0x7, 0xc0, 0xf1, 0xc0, 0x36, 0x0,

    /* U+5012 "倒" */
    0x7, 0xc0, 0x0, 0xe, 0xf, 0x80, 0x0, 0x1c,
    0x1f, 0xff, 0xf0, 0x38, 0x3f, 0xff, 0xe0, 0x70,
    0x78, 0x78, 0x0, 0xe0, 0xf0, 0xf0, 0x1, 0xc1,
    0xc1, 0xe0, 0x3, 0x87, 0x83, 0xc1, 0xc7, 0xf,
    0x7, 0x3, 0x8e, 0x1c, 0x1e, 0x87, 0x1c, 0x38,
    0x39, 0xe, 0x38, 0x60, 0x73, 0x1c, 0x71, 0xe0,
    0xc6, 0x38, 0xe3, 0xc1, 0x8c, 0x71, 0xc7, 0x86,
    0x1c, 0xe3, 0x9f, 0xc, 0x3d, 0xc7, 0x2e, 0x10,
    0xfb, 0x8e, 0xdc, 0xff, 0x77, 0x1d, 0x39, 0xfc,
    0xce, 0x3c, 0x71, 0xe0, 0x9c, 0x70, 0xe3, 0x1,
    0x38, 0xe1, 0xc0, 0xf0, 0x71, 0xc3, 0x81, 0xe0,
    0xe3, 0x87, 0x3, 0xc1, 0xc7, 0xe, 0x7, 0x83,
    0x8e, 0x1c, 0xf, 0x7, 0x1c, 0x38, 0x1e, 0xe,
    0x38, 0x70, 0x3c, 0x1c, 0x70, 0xe7, 0xff, 0xb8,
    0xe1, 0xcf, 0xff, 0x71, 0xc3, 0x81, 0xe0, 0xe3,
    0x87, 0x3, 0xc1, 0xc7, 0xe, 0x7, 0x83, 0x8e,
    0x1c, 0xf, 0x7, 0x1c, 0x38, 0x1e, 0xe, 0x38,
    0x70, 0x3c, 0x0, 0x70, 0xe0, 0x78, 0x0, 0xe1,
    0xc0, 0xf1, 0x1, 0xc3, 0x81, 0xee, 0x3, 0x87,
    0x3, 0xf0, 0x7, 0xe, 0x7f, 0xc0, 0xe, 0x1c,
    0xfe, 0x0, 0x1c, 0x38, 0xf0, 0x0, 0x78, 0x71,
    0x0, 0x1, 0xe0, 0xe0, 0x0, 0xf, 0x81, 0xc0,
    0x0, 0x20, 0x0,

    /* U+5014 "倔" */
    0x3, 0x9e, 0x0, 0x1e, 0x7, 0x3c, 0x0, 0x3c,
    0xe, 0x7f, 0xff, 0xf8, 0x1c, 0xff, 0xff, 0xf0,
    0x39, 0xe0, 0x1, 0xe0, 0x73, 0xc0, 0x3, 0xc0,
    0xe7, 0x80, 0x7, 0x83, 0xcf, 0x0, 0xf, 0x7,
    0x1e, 0x0, 0x1e, 0xe, 0x3f, 0xff, 0xfc, 0x1c,
    0x7f, 0xff, 0xf8, 0x30, 0xf0, 0x0, 0xf0, 0xe1,
    0xe0, 0x1, 0xe1, 0xe3, 0xc0, 0x70, 0x3, 0xc7,
    0x80, 0xe0, 0xf, 0x8f, 0x39, 0xcf, 0x1f, 0x1e,
    0x73, 0x9e, 0x2e, 0x3c, 0xe7, 0x3c, 0xdc, 0x79,
    0xce, 0x79, 0x38, 0xf3, 0x9c, 0xf6, 0x71, 0xe7,
    0x39, 0xe8, 0xe3, 0xce, 0x73, 0xf1, 0xc7, 0x9c,
    0xe7, 0x83, 0x8f, 0x39, 0xcf, 0x7, 0x1e, 0x7f,
    0xfe, 0xe, 0x3c, 0xff, 0xfc, 0x1c, 0x79, 0xce,
    0x78, 0x38, 0xf3, 0x9c, 0xf0, 0x71, 0xe0, 0x38,
    0x0, 0xe3, 0xc0, 0x70, 0x1, 0xc7, 0x80, 0xe3,
    0x83, 0x8f, 0x39, 0xc7, 0x7, 0x1e, 0x73, 0x8e,
    0xe, 0x3c, 0xe7, 0x1c, 0x1c, 0x79, 0xce, 0x38,
    0x38, 0xf3, 0x9c, 0x70, 0x71, 0xc7, 0x38, 0xe0,
    0xe3, 0x8e, 0x71, 0xc1, 0xc6, 0x1c, 0xe3, 0x83,
    0x9c, 0x39, 0xc7, 0x7, 0x30, 0x73, 0x8e, 0xe,
    0x60, 0xff, 0xfc, 0x1d, 0x81, 0xff, 0xf8, 0x3a,
    0x3, 0x80, 0x70, 0x78, 0x7, 0x0, 0xe0, 0xe0,
    0xe, 0x1, 0xc0,

    /* U+5016 "倖" */
    0x1, 0xf0, 0x7, 0x80, 0x0, 0xf8, 0x3, 0xc0,
    0x0, 0x7c, 0x1, 0xe0, 0x0, 0x3e, 0x0, 0xf0,
    0x0, 0x1f, 0x0, 0x78, 0x0, 0xf, 0xf, 0xff,
    0xf8, 0x7, 0x87, 0xff, 0xfc, 0x7, 0xc0, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3,
    0xc0, 0x0, 0xe0, 0x1, 0xe0, 0x0, 0xf0, 0x0,
    0xf0, 0x0, 0x70, 0x0, 0x78, 0x0, 0x3c, 0x0,
    0x3c, 0x0, 0x3e, 0x1f, 0xff, 0xfe, 0x1f, 0xf,
    0xff, 0xff, 0xf, 0x80, 0xc0, 0x10, 0xd, 0xc0,
    0x20, 0x1c, 0x4, 0xe0, 0x18, 0xc, 0x6, 0x70,
    0xe, 0xe, 0x6, 0x38, 0x7, 0x86, 0x2, 0x1c,
    0x1, 0xc3, 0x0, 0xe, 0x0, 0xc3, 0x0, 0x7,
    0x0, 0x61, 0x80, 0x3, 0x83, 0xff, 0xff, 0x1,
    0xc1, 0xff, 0xff, 0x80, 0xe0, 0x1, 0xe0, 0x0,
    0x70, 0x0, 0xf0, 0x0, 0x38, 0x0, 0x78, 0x0,
    0x1c, 0x0, 0x3c, 0x0, 0xe, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0xf, 0x0, 0x3, 0x8f, 0xff, 0xff,
    0x81, 0xc7, 0xff, 0xff, 0xc0, 0xe0, 0x1, 0xe0,
    0x0, 0x70, 0x0, 0xf0, 0x0, 0x38, 0x0, 0x78,
    0x0, 0x1c, 0x0, 0x3c, 0x0, 0xe, 0x0, 0x1e,
    0x0, 0x7, 0x0, 0xf, 0x0, 0x3, 0x80, 0x7,
    0x80, 0x1, 0xc0, 0x3, 0xc0, 0x0, 0xe0, 0x1,
    0xe0, 0x0, 0x70, 0x0, 0xf0, 0x0, 0x38, 0x0,
    0x78, 0x0, 0x1c, 0x0, 0x3c, 0x0,

    /* U+5018 "倘" */
    0x3, 0xc0, 0x1e, 0x0, 0x7, 0x80, 0x3c, 0x0,
    0xf, 0x0, 0x78, 0x0, 0x1e, 0x40, 0xf0, 0x70,
    0x38, 0xc1, 0xe0, 0xc0, 0xf0, 0x83, 0xc3, 0x81,
    0xe1, 0x87, 0x86, 0x3, 0xc3, 0x8f, 0x18, 0x7,
    0x87, 0x9e, 0x30, 0xe, 0x7, 0x3c, 0xc0, 0x3c,
    0xf, 0x79, 0x80, 0x70, 0x1c, 0xf2, 0x0, 0xe0,
    0x19, 0xec, 0x1, 0xe0, 0x23, 0xd0, 0x7, 0xc7,
    0x7, 0xe7, 0xf, 0x8f, 0xff, 0xfe, 0x3f, 0x1f,
    0xff, 0xfc, 0x6e, 0x38, 0x0, 0x38, 0x9c, 0x70,
    0x0, 0x73, 0x38, 0xe0, 0x0, 0xe4, 0x71, 0xc0,
    0x1, 0xd8, 0xe3, 0x9c, 0x73, 0x81, 0xc7, 0x3f,
    0xe7, 0x3, 0x8e, 0x7f, 0xce, 0x7, 0x1c, 0xe3,
    0x9c, 0xe, 0x39, 0xc7, 0x38, 0x1c, 0x73, 0x8e,
    0x70, 0x38, 0xe7, 0x1c, 0xe0, 0x71, 0xce, 0x39,
    0xc0, 0xe3, 0x9c, 0x73, 0x81, 0xc7, 0x38, 0xe7,
    0x3, 0x8e, 0x71, 0xce, 0x7, 0x1c, 0xe3, 0x9c,
    0xe, 0x39, 0xff, 0x38, 0x1c, 0x73, 0x8e, 0x70,
    0x38, 0xe7, 0x1c, 0xe0, 0x71, 0xce, 0x39, 0xc0,
    0xe3, 0x80, 0x3, 0x81, 0xc7, 0x0, 0x7, 0x3,
    0x8e, 0x0, 0xe, 0x7, 0x1c, 0x0, 0x1c, 0xe,
    0x38, 0x0, 0x38, 0x1c, 0x70, 0x0, 0x70, 0x38,
    0xe0, 0x1, 0xc0, 0x71, 0xc0, 0x7, 0x0, 0xe3,
    0x80, 0x78, 0x0,

    /* U+5019 "候" */
    0x7, 0xc0, 0x0, 0xf0, 0x7, 0xc0, 0x0, 0xf0,
    0x7, 0xc0, 0xff, 0xf0, 0x7, 0xc0, 0xff, 0xf0,
    0x7, 0x80, 0x0, 0xf0, 0x7, 0x80, 0x0, 0xf0,
    0x7, 0x80, 0x0, 0xe0, 0xf, 0x0, 0x0, 0xe0,
    0xf, 0x38, 0x0, 0xc0, 0xe, 0x38, 0x1, 0x80,
    0xe, 0x38, 0x1, 0x0, 0xc, 0x3b, 0xff, 0xff,
    0x1e, 0x3b, 0xff, 0xff, 0x1e, 0x38, 0x0, 0x0,
    0x1e, 0x38, 0x0, 0x0, 0x3e, 0x38, 0x78, 0x0,
    0x3e, 0x38, 0x78, 0x0, 0x2e, 0x38, 0x70, 0x0,
    0x6e, 0x38, 0xff, 0xfe, 0x4e, 0x38, 0xff, 0xfe,
    0x8e, 0x38, 0xef, 0x0, 0x8e, 0x39, 0xcf, 0x0,
    0xe, 0x39, 0x8f, 0x0, 0xe, 0x3b, 0x8f, 0x0,
    0xe, 0x3b, 0xf, 0x0, 0xe, 0x3e, 0xf, 0x0,
    0xe, 0x38, 0xf, 0x0, 0xe, 0x38, 0xf, 0x0,
    0xe, 0x3b, 0xff, 0xff, 0xe, 0x3b, 0xff, 0xff,
    0xe, 0x38, 0xf, 0x80, 0xe, 0x38, 0xf, 0x80,
    0xe, 0x38, 0xf, 0x80, 0xe, 0x38, 0xf, 0x80,
    0xe, 0x38, 0xf, 0x80, 0xe, 0x38, 0xe, 0xc0,
    0xe, 0x38, 0x1e, 0xe0, 0xe, 0x0, 0x1c, 0x70,
    0xe, 0x0, 0x18, 0x78, 0xe, 0x0, 0x38, 0x3e,
    0xe, 0x0, 0x70, 0x3f, 0xe, 0x0, 0x60, 0x1f,
    0xe, 0x0, 0xc0, 0x1f, 0xe, 0x1, 0x80, 0xf,
    0xe, 0x3, 0x0, 0x7, 0xe, 0x4, 0x0, 0x1,

    /* U+501A "倚" */
    0x7, 0xc0, 0x1e, 0x0, 0x3, 0xe0, 0xf, 0x0,
    0x1, 0xf0, 0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0,
    0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c, 0xff, 0xff,
    0xf0, 0x1e, 0x7f, 0xff, 0xf8, 0xf, 0x0, 0x7c,
    0x0, 0x7, 0x0, 0x3e, 0x0, 0x7, 0x80, 0x1d,
    0x80, 0x3, 0xc0, 0x1c, 0x60, 0x1, 0xc0, 0xe,
    0x3c, 0x0, 0xe0, 0xe, 0xf, 0xc0, 0x78, 0xe,
    0x3, 0xe0, 0x7c, 0xc, 0x0, 0xe0, 0x3e, 0xc,
    0x0, 0x38, 0x3f, 0x8, 0x0, 0x4, 0x1f, 0xbf,
    0xff, 0xff, 0xcb, 0xdf, 0xff, 0xff, 0xed, 0xe0,
    0x0, 0x7, 0x4, 0xf0, 0x0, 0x3, 0x84, 0x78,
    0x0, 0x1, 0xc2, 0x3c, 0x3c, 0x38, 0xe0, 0x1e,
    0x1e, 0x1c, 0x70, 0xf, 0xf, 0xfe, 0x38, 0x7,
    0x87, 0xff, 0x1c, 0x3, 0xc3, 0xc3, 0x8e, 0x1,
    0xe1, 0xe1, 0xc7, 0x0, 0xf0, 0xf0, 0xe3, 0x80,
    0x78, 0x78, 0x71, 0xc0, 0x3c, 0x3c, 0x38, 0xe0,
    0x1e, 0x1e, 0x1c, 0x70, 0xf, 0xf, 0xe, 0x38,
    0x7, 0x87, 0x87, 0x1c, 0x3, 0xc3, 0xff, 0x8e,
    0x1, 0xe1, 0xff, 0xc7, 0x0, 0xf0, 0xf0, 0xe3,
    0x80, 0x78, 0x78, 0x71, 0xc0, 0x3c, 0x3c, 0x0,
    0xe0, 0x1e, 0x0, 0x0, 0x70, 0xf, 0x0, 0x0,
    0x38, 0x7, 0x80, 0x0, 0x1c, 0x3, 0xc0, 0x0,
    0x1e, 0x1, 0xe0, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0x1f, 0x0, 0x78, 0x0, 0x7e, 0x0,

    /* U+501C "倜" */
    0x3, 0xce, 0x0, 0xe, 0x7, 0x9c, 0x0, 0x1c,
    0xf, 0x3f, 0xff, 0xf8, 0x1e, 0x7f, 0xff, 0xf0,
    0x38, 0xe0, 0x0, 0xe0, 0x71, 0xc1, 0xc1, 0xc0,
    0xe3, 0x83, 0x83, 0x81, 0xc7, 0x7, 0x7, 0x7,
    0xe, 0xe, 0xe, 0xe, 0x1d, 0xff, 0x9c, 0x1c,
    0x3b, 0xff, 0x38, 0x38, 0x70, 0x70, 0x70, 0x60,
    0xe0, 0xe0, 0xe1, 0xe1, 0xc1, 0xc1, 0xc3, 0xc3,
    0x83, 0x83, 0x87, 0x87, 0x7, 0x7, 0x1f, 0xe,
    0xe, 0xe, 0x3e, 0x1d, 0xff, 0xdc, 0x5c, 0x3b,
    0xff, 0xb9, 0xb8, 0x70, 0x0, 0x72, 0x70, 0xe0,
    0x0, 0xe8, 0xe1, 0xc0, 0x1, 0xd1, 0xc3, 0x9c,
    0x73, 0x83, 0x87, 0x38, 0xe7, 0x7, 0xe, 0x7f,
    0xce, 0xe, 0x1c, 0xff, 0x9c, 0x1c, 0x39, 0xc7,
    0x38, 0x38, 0x73, 0x8e, 0x70, 0x70, 0xe7, 0x1c,
    0xe0, 0xe1, 0xce, 0x39, 0xc1, 0xc3, 0x9c, 0x73,
    0x83, 0x87, 0x38, 0xe7, 0x7, 0xe, 0x71, 0xce,
    0xe, 0x1c, 0xe3, 0x9c, 0x1c, 0x39, 0xff, 0x38,
    0x38, 0x73, 0xfe, 0x70, 0x70, 0xc7, 0x1c, 0xe0,
    0xe1, 0x8e, 0x39, 0xc1, 0xc7, 0x0, 0x3, 0x83,
    0x8c, 0x0, 0x7, 0x7, 0x18, 0x0, 0xe, 0xe,
    0x60, 0x0, 0x1c, 0x1c, 0xc0, 0x0, 0x78, 0x39,
    0x0, 0x1, 0xe0, 0x76, 0x0, 0x7, 0x80, 0xe8,
    0x0, 0x3c, 0x0,

    /* U+501F "借" */
    0x3, 0xc1, 0xe0, 0xf0, 0x1, 0xe0, 0xf0, 0x78,
    0x0, 0xf0, 0x78, 0x3c, 0x0, 0x78, 0x3c, 0x1e,
    0x0, 0x38, 0x1e, 0xf, 0x0, 0x3c, 0xf, 0x7,
    0x80, 0x1e, 0x7, 0x83, 0xc0, 0xf, 0x3f, 0xff,
    0xfe, 0x7, 0x1f, 0xff, 0xff, 0x3, 0x80, 0xf0,
    0x78, 0x1, 0xc0, 0x78, 0x3c, 0x1, 0xe0, 0x3c,
    0x1e, 0x0, 0xe0, 0x1e, 0xf, 0x0, 0x7c, 0xf,
    0x7, 0x80, 0x7e, 0x7, 0x83, 0xc0, 0x3f, 0x3,
    0xc1, 0xe0, 0x1f, 0x81, 0xe0, 0xf0, 0x1f, 0xdf,
    0xff, 0xff, 0xcd, 0xef, 0xff, 0xff, 0xe6, 0xf0,
    0x0, 0x0, 0x6, 0x78, 0x0, 0x0, 0x2, 0x3c,
    0x0, 0x0, 0x0, 0x1e, 0xe, 0x0, 0xf0, 0xf,
    0x7, 0x0, 0x78, 0x7, 0x83, 0xff, 0xfc, 0x3,
    0xc1, 0xff, 0xfe, 0x1, 0xe0, 0xe0, 0xf, 0x0,
    0xf0, 0x70, 0x7, 0x80, 0x78, 0x38, 0x3, 0xc0,
    0x3c, 0x1c, 0x1, 0xe0, 0x1e, 0xe, 0x0, 0xf0,
    0xf, 0x7, 0xff, 0x78, 0x7, 0x83, 0xff, 0xbc,
    0x3, 0xc1, 0xc0, 0x1e, 0x1, 0xe0, 0xe0, 0xf,
    0x0, 0xf0, 0x70, 0x7, 0x80, 0x78, 0x38, 0x3,
    0xc0, 0x3c, 0x1c, 0x1, 0xe0, 0x1e, 0xe, 0x0,
    0xf0, 0xf, 0x7, 0x0, 0x78, 0x7, 0x83, 0x80,
    0x3c, 0x3, 0xc1, 0xff, 0xfe, 0x1, 0xe0, 0xff,
    0xff, 0x0, 0xf0, 0x70, 0x7, 0x80, 0x78, 0x38,
    0x3, 0xc0, 0x3c, 0x1c, 0x1, 0xe0,

    /* U+5021 "倡" */
    0x3, 0xcf, 0x0, 0x3c, 0x7, 0x9e, 0x0, 0x78,
    0xf, 0x3f, 0xff, 0xf0, 0x1e, 0x7f, 0xff, 0xe0,
    0x38, 0xf0, 0x3, 0xc0, 0x71, 0xe0, 0x7, 0x80,
    0xe3, 0xc0, 0xf, 0x3, 0xc7, 0x80, 0x1e, 0x7,
    0xf, 0x0, 0x3c, 0xe, 0x1f, 0xfe, 0x78, 0x1c,
    0x3f, 0xfc, 0xf0, 0x30, 0x78, 0x1, 0xe0, 0x60,
    0xf0, 0x3, 0xc1, 0xe1, 0xe0, 0x7, 0x83, 0xc3,
    0xc0, 0xf, 0x7, 0x87, 0x80, 0x1e, 0x1f, 0xf,
    0x0, 0x3c, 0x2e, 0x1f, 0xff, 0xf8, 0x5c, 0x3f,
    0xff, 0xf1, 0x38, 0x78, 0x1, 0xe2, 0x70, 0x0,
    0x0, 0x8, 0xe0, 0x0, 0x0, 0x11, 0xc0, 0x0,
    0x0, 0x43, 0x80, 0x0, 0x0, 0x7, 0x1e, 0x0,
    0x1e, 0xe, 0x3f, 0xff, 0xfc, 0x1c, 0x7f, 0xff,
    0xf8, 0x38, 0xf0, 0x0, 0xf0, 0x71, 0xe0, 0x1,
    0xe0, 0xe3, 0xc0, 0x3, 0xc1, 0xc7, 0x80, 0x7,
    0x83, 0x8f, 0x0, 0xf, 0x7, 0x1f, 0xff, 0x9e,
    0xe, 0x3f, 0xff, 0x3c, 0x1c, 0x78, 0x0, 0x78,
    0x38, 0xf0, 0x0, 0xf0, 0x71, 0xe0, 0x1, 0xe0,
    0xe3, 0xc0, 0x3, 0xc1, 0xc7, 0x80, 0x7, 0x83,
    0x8f, 0x0, 0xf, 0x7, 0x1e, 0x0, 0x1e, 0xe,
    0x3f, 0xff, 0xfc, 0x1c, 0x7f, 0xff, 0xf8, 0x38,
    0xf0, 0x0, 0xf0, 0x71, 0xe0, 0x1, 0xe0, 0xe3,
    0xc0, 0x3, 0xc0,

    /* U+5023 "倣" */
    0x7, 0xc0, 0x1, 0xe0, 0x7, 0xc8, 0x1, 0xe0,
    0x7, 0xcc, 0x1, 0xe0, 0x7, 0x8e, 0x1, 0xc0,
    0x7, 0x87, 0x1, 0xc0, 0x7, 0x86, 0x3, 0xc0,
    0x7, 0x6, 0x3, 0xc0, 0xf, 0x4, 0x3, 0xc0,
    0xf, 0xff, 0xf3, 0xc0, 0xe, 0xff, 0xf3, 0x80,
    0xe, 0x38, 0x3, 0xff, 0xc, 0x38, 0x3, 0xff,
    0x1e, 0x38, 0x3, 0x1c, 0x1e, 0x38, 0xe7, 0x1c,
    0x1e, 0x38, 0xe6, 0x1c, 0x3e, 0x3f, 0xe6, 0x1c,
    0x3e, 0x3f, 0xee, 0x1c, 0x2e, 0x38, 0xea, 0x1c,
    0x6e, 0x38, 0xf2, 0x1c, 0x4e, 0x38, 0xe2, 0x1c,
    0x8e, 0x38, 0xe2, 0x1c, 0xe, 0x38, 0xe2, 0x1c,
    0xe, 0x38, 0xe2, 0x1c, 0xe, 0x38, 0xe2, 0x1c,
    0xe, 0x38, 0xe2, 0x1c, 0xe, 0x38, 0xe2, 0x1c,
    0xe, 0x38, 0xe3, 0x18, 0xe, 0x38, 0xe3, 0x38,
    0xe, 0x38, 0xe3, 0x38, 0xe, 0x38, 0xe3, 0x38,
    0xe, 0x38, 0xe3, 0x38, 0xe, 0x30, 0xe3, 0xb8,
    0xe, 0x30, 0xe1, 0xb8, 0xe, 0x30, 0xe1, 0xf0,
    0xe, 0x30, 0xe1, 0xf0, 0xe, 0x70, 0xe1, 0xf0,
    0xe, 0x70, 0xe0, 0xf0, 0xe, 0x60, 0xe1, 0xf8,
    0xe, 0x60, 0xe1, 0xf8, 0xe, 0x60, 0xe3, 0x7e,
    0xe, 0x40, 0xe6, 0x3e, 0xe, 0x41, 0xee, 0x1e,
    0xe, 0xc3, 0xcc, 0x1e, 0xe, 0x8f, 0x98, 0xe,
    0xe, 0x90, 0x30, 0x4, 0xf, 0x80, 0x60, 0x2,

    /* U+5025 "倥" */
    0x3, 0xc0, 0x10, 0x0, 0x1, 0xe0, 0xe, 0x0,
    0x0, 0xf0, 0x3, 0x80, 0x0, 0x78, 0x1, 0xc0,
    0x0, 0x3d, 0xe0, 0xe0, 0xf0, 0x1c, 0xf0, 0x20,
    0x78, 0xe, 0x7f, 0xff, 0xfc, 0x7, 0x3f, 0xff,
    0xfe, 0x7, 0x9e, 0x0, 0xf, 0x3, 0x8f, 0x0,
    0x7, 0x81, 0xc7, 0x80, 0x3, 0xc0, 0xe3, 0xc0,
    0x41, 0xe0, 0x61, 0xef, 0x10, 0x80, 0x38, 0x7,
    0x88, 0x0, 0x3c, 0x7, 0xc6, 0x0, 0x1e, 0x3,
    0xc3, 0x0, 0xf, 0x1, 0xe0, 0xc0, 0xf, 0x80,
    0xf0, 0x70, 0x7, 0xc0, 0x70, 0x3e, 0x6, 0xe0,
    0x70, 0xf, 0xc2, 0x70, 0x38, 0x7, 0xc3, 0x38,
    0x38, 0x1, 0xe3, 0x1c, 0x18, 0x0, 0x70, 0xe,
    0x18, 0x0, 0x18, 0x7, 0x18, 0x0, 0x4, 0x3,
    0x80, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x0,
    0xe1, 0xff, 0xff, 0xc0, 0x70, 0xff, 0xff, 0xe0,
    0x38, 0x0, 0x70, 0x0, 0x1c, 0x0, 0x38, 0x0,
    0xe, 0x0, 0x1c, 0x0, 0x7, 0x0, 0xe, 0x0,
    0x3, 0x80, 0x7, 0x0, 0x1, 0xc0, 0x3, 0x80,
    0x0, 0xe0, 0x1, 0xc0, 0x0, 0x70, 0x0, 0xe0,
    0x0, 0x38, 0x0, 0x70, 0x0, 0x1c, 0x0, 0x38,
    0x0, 0xe, 0x0, 0x1c, 0x0, 0x7, 0x0, 0xe,
    0x0, 0x3, 0x80, 0x7, 0x0, 0x1, 0xc0, 0x3,
    0x80, 0x0, 0xe7, 0xff, 0xff, 0xf0, 0x73, 0xff,
    0xff, 0xf8, 0x38, 0x0, 0x0, 0x0,

    /* U+5026 "倦" */
    0x3, 0xe0, 0xf, 0x0, 0x1, 0xe0, 0x7, 0x80,
    0x0, 0xf0, 0x3, 0x81, 0x0, 0x79, 0x1, 0xc0,
    0xc0, 0x3c, 0x60, 0xe0, 0xc0, 0x1e, 0x38, 0x70,
    0xc0, 0xf, 0x1e, 0x78, 0x60, 0xf, 0x7, 0x3c,
    0x60, 0x7, 0x81, 0x1e, 0x30, 0x3, 0xc0, 0x8f,
    0x30, 0x1, 0xe7, 0xff, 0xff, 0x80, 0xe3, 0xff,
    0xff, 0xc0, 0x70, 0x1, 0xe0, 0x0, 0x7c, 0x0,
    0xf0, 0x0, 0x3e, 0x0, 0x70, 0x0, 0x1f, 0x0,
    0x78, 0x0, 0x1f, 0x80, 0x3c, 0x0, 0xf, 0xdf,
    0xff, 0xff, 0x8d, 0xef, 0xff, 0xff, 0xc6, 0xf0,
    0xf, 0x10, 0x2, 0x78, 0x7, 0x8, 0x2, 0x3c,
    0x7, 0x86, 0x3, 0x1e, 0x3, 0x81, 0x80, 0xf,
    0x3, 0x80, 0xe0, 0x7, 0x83, 0x80, 0x3c, 0x3,
    0xc1, 0xe0, 0x7f, 0x81, 0xe1, 0xff, 0xff, 0xc0,
    0xf1, 0xff, 0xff, 0xe0, 0x79, 0xbc, 0xf, 0x70,
    0x3d, 0x9e, 0x7, 0x98, 0x1f, 0x8f, 0x3, 0xc4,
    0xf, 0x7, 0x81, 0xe0, 0x7, 0x83, 0xc0, 0xf2,
    0x3, 0xc1, 0xe0, 0x71, 0x1, 0xe0, 0xf0, 0x78,
    0x80, 0xf0, 0x78, 0xf8, 0x40, 0x78, 0x3d, 0x90,
    0x20, 0x3c, 0x1e, 0x0, 0x10, 0x1e, 0xf, 0x0,
    0x18, 0xf, 0x7, 0x80, 0xe, 0x7, 0x83, 0xc0,
    0x7, 0x3, 0xc1, 0xf0, 0x7, 0x81, 0xe0, 0xff,
    0xff, 0xc0, 0xf0, 0x7f, 0xff, 0xc0, 0x78, 0x1f,
    0xff, 0xe0, 0x3c, 0x7, 0xff, 0xc0,

    /* U+5028 "倨" */
    0x3, 0xe7, 0x80, 0x1e, 0x3, 0xe7, 0x80, 0x1e,
    0x3, 0xe7, 0xff, 0xfe, 0x3, 0xe7, 0xff, 0xfe,
    0x3, 0xc7, 0x80, 0x1e, 0x3, 0xc7, 0x80, 0x1e,
    0x3, 0xc7, 0x80, 0x1e, 0x3, 0xc7, 0x80, 0x1e,
    0x3, 0xc7, 0x80, 0x1e, 0x7, 0x87, 0x80, 0x1e,
    0x7, 0x87, 0xff, 0xfe, 0x7, 0x87, 0xff, 0xfe,
    0x7, 0x7, 0x80, 0x1e, 0xf, 0x87, 0x81, 0xde,
    0xf, 0x87, 0x81, 0xc0, 0xf, 0x87, 0x81, 0xc0,
    0x1f, 0x87, 0x81, 0xc0, 0x1f, 0x87, 0x81, 0xc0,
    0x1f, 0x87, 0x81, 0xc0, 0x37, 0x87, 0xff, 0xff,
    0x27, 0x87, 0xff, 0xff, 0x67, 0x87, 0x81, 0xc0,
    0x47, 0x87, 0x81, 0xc0, 0x7, 0x87, 0x81, 0x80,
    0x7, 0x87, 0x81, 0x80, 0x7, 0x87, 0x83, 0x80,
    0x7, 0x87, 0x83, 0x0, 0x7, 0x87, 0xbe, 0x1e,
    0x7, 0x87, 0xbc, 0x1e, 0x7, 0x87, 0xbf, 0xfe,
    0x7, 0x87, 0xbf, 0xfe, 0x7, 0x87, 0xbc, 0x1e,
    0x7, 0x87, 0xbc, 0x1e, 0x7, 0x87, 0xbc, 0x1e,
    0x7, 0x87, 0xbc, 0x1e, 0x7, 0x87, 0x3c, 0x1e,
    0x7, 0x87, 0x3c, 0x1e, 0x7, 0x87, 0x3c, 0x1e,
    0x7, 0x8e, 0x3c, 0x1e, 0x7, 0x8e, 0x3c, 0x1e,
    0x7, 0x8c, 0x3c, 0x1e, 0x7, 0x8c, 0x3f, 0xfe,
    0x7, 0x98, 0x3f, 0xfe, 0x7, 0x98, 0x3c, 0x1e,
    0x7, 0x90, 0x3c, 0x1e, 0x7, 0xb0, 0x3c, 0x1e,

    /* U+5029 "倩" */
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xdf, 0xff, 0xfe,
    0x3, 0x9f, 0xff, 0xfe, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0xf, 0xff, 0xfc, 0x7, 0xf, 0xff, 0xfc,
    0xe, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0x1f, 0x7f, 0xff, 0xff,
    0x1f, 0x7f, 0xff, 0xff, 0x1f, 0x0, 0x0, 0x0,
    0x37, 0x0, 0x0, 0x0, 0x37, 0x0, 0x0, 0x0,
    0x67, 0x7, 0x80, 0x3c, 0xc7, 0x7, 0xff, 0xfc,
    0x7, 0x7, 0xff, 0xfc, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0xff, 0x3c,
    0x7, 0x7, 0xff, 0x3c, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0xff, 0x3c,
    0x7, 0x7, 0xff, 0x3c, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0x80, 0x3c,
    0x7, 0x7, 0x80, 0x3c, 0x7, 0x7, 0x80, 0xf8,
    0x7, 0x7, 0x83, 0xf0, 0x7, 0x7, 0x8c, 0xc0,

    /* U+502A "倪" */
    0x3, 0xe7, 0x88, 0x0, 0x0, 0xf9, 0xe7, 0x7,
    0x80, 0x3c, 0x7b, 0xe1, 0xe0, 0xf, 0x1f, 0xef,
    0xf8, 0x3, 0xc7, 0x80, 0x1e, 0x0, 0xf1, 0xe0,
    0x7, 0x80, 0x3c, 0x78, 0x1, 0xe0, 0xe, 0x1e,
    0x0, 0x78, 0x7, 0x87, 0x80, 0x1e, 0x1, 0xe1,
    0xe0, 0x7, 0x80, 0x70, 0x78, 0x1, 0xe0, 0x1c,
    0x1e, 0x0, 0x78, 0x7, 0x7, 0xf1, 0xfe, 0x3,
    0xe1, 0xfc, 0x7f, 0x80, 0xf8, 0x78, 0x1, 0xe0,
    0x3e, 0x1e, 0x0, 0x78, 0x1f, 0x87, 0x80, 0x1e,
    0x7, 0xe1, 0xe0, 0x7, 0x83, 0x78, 0x78, 0x1,
    0xe0, 0xde, 0x1e, 0x0, 0x78, 0x67, 0x87, 0xff,
    0xfe, 0x11, 0xe1, 0xff, 0xff, 0x80, 0x78, 0x78,
    0x1, 0xe0, 0x1e, 0x1e, 0x0, 0x78, 0x7, 0x80,
    0xf1, 0xe0, 0x1, 0xe0, 0x3c, 0x78, 0x0, 0x78,
    0xf, 0x1e, 0x0, 0x1e, 0x3, 0xc7, 0x80, 0x7,
    0x80, 0xf1, 0xe0, 0x1, 0xe0, 0x3c, 0x78, 0x0,
    0x78, 0xf, 0x1e, 0x0, 0x1e, 0x3, 0xc7, 0x80,
    0x7, 0x80, 0xf1, 0xe0, 0x1, 0xe0, 0x38, 0x78,
    0x20, 0x78, 0xe, 0x1e, 0x8, 0x1e, 0x3, 0x87,
    0x82, 0x7, 0x80, 0xe1, 0xe0, 0x81, 0xe0, 0x70,
    0x78, 0x20, 0x78, 0x1c, 0x1e, 0x18, 0x1e, 0x6,
    0x7, 0x86, 0x7, 0x83, 0x81, 0xe1, 0xc1, 0xe0,
    0xc0, 0x78, 0x70, 0x78, 0x60, 0x1f, 0xfc, 0x1e,
    0x30, 0x7, 0xff, 0x7, 0x98, 0x1, 0xff, 0x81,
    0xec, 0x0, 0x1f, 0xc0,

    /* U+502B "倫" */
    0x7, 0xc0, 0x7c, 0x0, 0x7, 0xc0, 0x78, 0x0,
    0x7, 0xc0, 0xfc, 0x0, 0x7, 0x80, 0xfc, 0x0,
    0x7, 0x80, 0xf6, 0x0, 0x7, 0x80, 0xf6, 0x0,
    0x7, 0x80, 0xe3, 0x0, 0x7, 0x1, 0xe3, 0x80,
    0xf, 0x1, 0xc3, 0x80, 0xf, 0x1, 0xc1, 0xc0,
    0xf, 0x3, 0x81, 0xe0, 0xe, 0x3, 0x0, 0xf8,
    0xe, 0x3, 0x0, 0xfc, 0x1f, 0x6, 0x0, 0x7f,
    0x1f, 0xc, 0x0, 0x3f, 0x1f, 0xf, 0xff, 0xde,
    0x1f, 0x1b, 0xff, 0xce, 0x3f, 0x30, 0x0, 0x6,
    0x2f, 0x20, 0x0, 0x2, 0x6f, 0x40, 0x0, 0x0,
    0x4f, 0x1c, 0x0, 0x3c, 0xcf, 0x1c, 0x0, 0x3c,
    0xf, 0x1f, 0xff, 0xfc, 0xf, 0x1f, 0xff, 0xfc,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1f, 0xff, 0xfc,
    0xf, 0x1f, 0xff, 0xfc, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0xe7, 0x3c,
    0xf, 0x1c, 0xe7, 0x3c, 0xf, 0x1c, 0x0, 0x78,
    0xf, 0x1c, 0x1, 0xf0, 0x0, 0x0, 0x0, 0x0,

    /* U+502C "倬" */
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1f, 0xff, 0x3, 0x80, 0x1f, 0xff,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0xf, 0x1e, 0x3c, 0xe, 0xf, 0x1e, 0x3c,
    0xe, 0xf, 0xff, 0xfc, 0xf, 0xf, 0xff, 0xfc,
    0x1f, 0xf, 0x0, 0x3c, 0x1f, 0xf, 0x0, 0x3c,
    0x1f, 0xf, 0x0, 0x3c, 0x37, 0xf, 0x0, 0x3c,
    0x37, 0xf, 0xff, 0x3c, 0x67, 0xf, 0xff, 0x3c,
    0x47, 0xf, 0x0, 0x3c, 0xc7, 0xf, 0x0, 0x3c,
    0x7, 0xf, 0x0, 0x3c, 0x7, 0xf, 0x0, 0x3c,
    0x7, 0xf, 0x0, 0x3c, 0x7, 0xf, 0xff, 0xfc,
    0x7, 0xf, 0xff, 0xfc, 0x7, 0xf, 0x1c, 0x3c,
    0x7, 0xf, 0x1c, 0x3c, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x7f, 0xff, 0xff,
    0x7, 0x7f, 0xff, 0xff, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,

    /* U+502D "倭" */
    0x3, 0xc0, 0x1, 0xe0, 0x3, 0xc0, 0xf, 0xf0,
    0x3, 0xc0, 0x7f, 0xf8, 0x3, 0xc7, 0xfe, 0x0,
    0x3, 0xd8, 0x1e, 0x0, 0x3, 0x80, 0x1e, 0x0,
    0x3, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x3f, 0xff, 0xfe,
    0x7, 0x3f, 0xff, 0xfe, 0x7, 0x0, 0xfe, 0x80,
    0xe, 0x0, 0xfe, 0x80, 0xf, 0x1, 0xfe, 0xc0,
    0xf, 0x1, 0xde, 0x40, 0x1f, 0x3, 0xde, 0x60,
    0x1f, 0x3, 0x9e, 0x70, 0x1f, 0x7, 0x1e, 0x3c,
    0x37, 0x6, 0x1e, 0x3f, 0x27, 0xc, 0x1e, 0x1e,
    0x67, 0x18, 0x1e, 0xe, 0x47, 0x10, 0x78, 0x6,
    0x7, 0x20, 0x70, 0x2, 0x7, 0x40, 0xf0, 0x0,
    0x7, 0x0, 0xf0, 0x0, 0x7, 0x0, 0xf0, 0x0,
    0x7, 0x7f, 0xff, 0xff, 0x7, 0x7f, 0xff, 0xff,
    0x7, 0x1, 0xc1, 0xf0, 0x7, 0x1, 0xc1, 0xf0,
    0x7, 0x3, 0xc1, 0xe0, 0x7, 0x3, 0xc1, 0xe0,
    0x7, 0x3, 0x81, 0xe0, 0x7, 0x7, 0x81, 0xe0,
    0x7, 0x7, 0xc1, 0xc0, 0x7, 0x7, 0x73, 0xc0,
    0x7, 0x0, 0x3f, 0x80, 0x7, 0x0, 0x1f, 0x0,
    0x7, 0x0, 0xf, 0xc0, 0x7, 0x0, 0x1f, 0xe0,
    0x7, 0x0, 0x39, 0xf8, 0x7, 0x0, 0xe0, 0xfe,
    0x7, 0x1, 0xc0, 0x3e, 0x7, 0x7, 0x0, 0x1e,
    0x7, 0xc, 0x0, 0x6, 0x7, 0x30, 0x0, 0x2,

    /* U+502E "倮" */
    0x3, 0xcf, 0x0, 0x1c, 0x3, 0xcf, 0xff, 0xfc,
    0x3, 0xcf, 0xff, 0xfc, 0x3, 0xcf, 0xe, 0x1c,
    0x3, 0x8f, 0xe, 0x1c, 0x3, 0x8f, 0xe, 0x1c,
    0x3, 0x8f, 0xe, 0x1c, 0x7, 0x8f, 0xe, 0x1c,
    0x7, 0x8f, 0xe, 0x1c, 0x7, 0xf, 0xff, 0xfc,
    0x7, 0xf, 0xff, 0xfc, 0x7, 0xf, 0xe, 0x1c,
    0xe, 0xf, 0xe, 0x1c, 0xf, 0xf, 0xe, 0x1c,
    0xf, 0xf, 0xe, 0x1c, 0xf, 0xf, 0xe, 0x1c,
    0x1f, 0xf, 0xe, 0x1c, 0x1f, 0xf, 0xff, 0xfc,
    0x37, 0xf, 0xff, 0xfc, 0x27, 0xf, 0xe, 0x1c,
    0x67, 0xf, 0xe, 0x1c, 0x47, 0x0, 0xe, 0x1c,
    0xc7, 0x0, 0xe, 0x0, 0x7, 0x0, 0xe, 0x0,
    0x7, 0x3f, 0xff, 0xff, 0x7, 0x3f, 0xff, 0xff,
    0x7, 0x0, 0x7e, 0x80, 0x7, 0x0, 0x7e, 0x80,
    0x7, 0x0, 0x7e, 0x80, 0x7, 0x0, 0xfe, 0xc0,
    0x7, 0x0, 0xee, 0xc0, 0x7, 0x0, 0xee, 0x60,
    0x7, 0x1, 0xce, 0x60, 0x7, 0x1, 0x8e, 0x70,
    0x7, 0x3, 0x8e, 0x78, 0x7, 0x3, 0xe, 0x3c,
    0x7, 0x7, 0xe, 0x3e, 0x7, 0xe, 0xe, 0x3f,
    0x7, 0xc, 0xe, 0x1f, 0x7, 0x18, 0xe, 0x1f,
    0x7, 0x30, 0xe, 0xf, 0x7, 0x20, 0xe, 0x7,
    0x7, 0x40, 0xe, 0x3, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x0, 0xe, 0x0, 0x7, 0x0, 0xe, 0x0,

    /* U+503A "债" */
    0x3, 0xe0, 0x1e, 0x0, 0x1, 0xf0, 0xf, 0x0,
    0x0, 0xf8, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x7f, 0xff,
    0xf8, 0xf, 0x3f, 0xff, 0xfc, 0xf, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x1, 0xc3, 0xff, 0xff, 0x80, 0xe1, 0xff,
    0xff, 0xc0, 0xe0, 0x1, 0xe0, 0x0, 0x7c, 0x0,
    0xf0, 0x0, 0x3e, 0x0, 0x78, 0x0, 0x3f, 0x7f,
    0xff, 0xff, 0x1f, 0xbf, 0xff, 0xff, 0x8b, 0xc0,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0x4, 0x78, 0xf0, 0x1, 0xe6, 0x3c,
    0x7f, 0xff, 0xf0, 0x1e, 0x3f, 0xff, 0xf8, 0xf,
    0x1e, 0x0, 0x3c, 0x7, 0x8f, 0x0, 0x1e, 0x3,
    0xc7, 0x8f, 0xf, 0x1, 0xe3, 0xc7, 0x87, 0x80,
    0xf1, 0xe3, 0xc3, 0xc0, 0x78, 0xf1, 0xe1, 0xe0,
    0x3c, 0x78, 0xf0, 0xf0, 0x1e, 0x3c, 0x78, 0x78,
    0xf, 0x1e, 0x3c, 0x3c, 0x7, 0x8f, 0x1e, 0x1e,
    0x3, 0xc7, 0x8f, 0xf, 0x1, 0xe3, 0xc7, 0xc7,
    0x80, 0xf1, 0xe3, 0xa3, 0x80, 0x78, 0xf1, 0xdb,
    0x80, 0x3c, 0x0, 0xcf, 0x80, 0x1e, 0x0, 0xe3,
    0x80, 0xf, 0x0, 0x61, 0xe0, 0x7, 0x80, 0x60,
    0x7f, 0x3, 0xc0, 0x70, 0x1f, 0x81, 0xe0, 0x70,
    0xf, 0xc0, 0xf0, 0x60, 0x3, 0xe0, 0x78, 0x60,
    0x0, 0x70, 0x3c, 0x60, 0x0, 0x18,

    /* U+503C "值" */
    0x3, 0xe0, 0x7, 0x0, 0x1, 0xf0, 0x3, 0x80,
    0x0, 0xf0, 0x1, 0xc0, 0x0, 0x78, 0x0, 0xe0,
    0x0, 0x3c, 0x0, 0x70, 0x0, 0x1e, 0x7f, 0xff,
    0xfc, 0xe, 0x3f, 0xff, 0xfe, 0xf, 0x0, 0x1e,
    0x0, 0x7, 0x80, 0xe, 0x0, 0x3, 0x80, 0x7,
    0x0, 0x1, 0xc0, 0x3, 0x0, 0x0, 0xc0, 0xf1,
    0x87, 0x80, 0xf8, 0x78, 0x83, 0xc0, 0x7c, 0x3f,
    0xff, 0xe0, 0x3e, 0x1f, 0xff, 0xf0, 0x3f, 0xf,
    0x0, 0x78, 0x1f, 0x87, 0x80, 0x3c, 0x1b, 0xc3,
    0xc0, 0x1e, 0xd, 0xe1, 0xe0, 0xf, 0xc, 0xf0,
    0xf0, 0x7, 0x84, 0x78, 0x7f, 0xfb, 0xc6, 0x3c,
    0x3f, 0xfd, 0xe0, 0x1e, 0x1e, 0x0, 0xf0, 0xf,
    0xf, 0x0, 0x78, 0x7, 0x87, 0x80, 0x3c, 0x3,
    0xc3, 0xc0, 0x1e, 0x1, 0xe1, 0xe0, 0xf, 0x0,
    0xf0, 0xff, 0xf7, 0x80, 0x78, 0x7f, 0xfb, 0xc0,
    0x3c, 0x3c, 0x1, 0xe0, 0x1e, 0x1e, 0x0, 0xf0,
    0xf, 0xf, 0x0, 0x78, 0x7, 0x87, 0x80, 0x3c,
    0x3, 0xc3, 0xc0, 0x1e, 0x1, 0xe1, 0xff, 0xef,
    0x0, 0xf0, 0xff, 0xf7, 0x80, 0x78, 0x78, 0x3,
    0xc0, 0x3c, 0x3c, 0x1, 0xe0, 0x1e, 0x1e, 0x0,
    0xf0, 0xf, 0xf, 0x0, 0x78, 0x7, 0x87, 0x80,
    0x3c, 0x3, 0xc3, 0xc0, 0x1e, 0x1, 0xef, 0xff,
    0xff, 0xe0, 0xf7, 0xff, 0xff, 0xf0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,

    /* U+503E "倾" */
    0x7, 0x80, 0x0, 0x0, 0x7, 0x81, 0xff, 0xff,
    0x7, 0x81, 0xff, 0xff, 0x7, 0x80, 0x3, 0xc0,
    0x7, 0x78, 0x3, 0x80, 0x7, 0x78, 0x3, 0x80,
    0x7, 0x78, 0x3, 0x80, 0x7, 0x78, 0x7, 0x0,
    0xf, 0x78, 0x6, 0x0, 0xe, 0x78, 0xf4, 0x1e,
    0xe, 0x78, 0xff, 0xfe, 0xe, 0x78, 0xff, 0xfe,
    0xe, 0x78, 0xf0, 0x1e, 0xe, 0x7e, 0xf0, 0x1e,
    0x1e, 0x7e, 0xf7, 0x9e, 0x1e, 0x78, 0xf7, 0x9e,
    0x1e, 0x78, 0xf7, 0x9e, 0x3e, 0x78, 0xf7, 0x9e,
    0x2e, 0x78, 0xf7, 0x9e, 0x2e, 0x78, 0xf7, 0x9e,
    0x4e, 0x78, 0xf7, 0x9e, 0x4e, 0x78, 0xf7, 0x9e,
    0x8e, 0x78, 0xf7, 0x9e, 0xe, 0x78, 0xf7, 0x9e,
    0xe, 0x78, 0xf7, 0x9e, 0xe, 0x78, 0xf7, 0x9e,
    0xe, 0x78, 0xf7, 0x9e, 0xe, 0x78, 0xf7, 0x9e,
    0xe, 0x78, 0xf7, 0x9e, 0xe, 0x78, 0xf7, 0x9e,
    0xe, 0x78, 0xf7, 0x9e, 0xe, 0x78, 0xf7, 0x9e,
    0xe, 0x79, 0xf7, 0x9c, 0xe, 0x7a, 0xf7, 0x9c,
    0xe, 0x7e, 0xf7, 0x9c, 0xe, 0x7c, 0xf7, 0x98,
    0xf, 0xfc, 0x7, 0x58, 0xf, 0xf8, 0x7, 0x70,
    0xe, 0xf0, 0xe, 0x70, 0xe, 0xe0, 0xc, 0x78,
    0xe, 0x80, 0x1c, 0x3f, 0xe, 0x0, 0x38, 0x3f,
    0xe, 0x0, 0x30, 0x1f, 0xe, 0x0, 0x60, 0xf,
    0xe, 0x0, 0x80, 0x7, 0xe, 0x3, 0x0, 0x3,

    /* U+5043 "偃" */
    0x7, 0x9c, 0x0, 0x0, 0x3, 0xce, 0x0, 0x0,
    0x1, 0xe7, 0xff, 0xff, 0x80, 0xf3, 0xff, 0xff,
    0xc0, 0x79, 0xc0, 0x0, 0x0, 0x3c, 0xe0, 0x0,
    0x0, 0x1c, 0x73, 0xc0, 0xf0, 0xe, 0x39, 0xff,
    0xf8, 0x7, 0x1c, 0xff, 0xfc, 0x3, 0x8e, 0x78,
    0x1e, 0x1, 0x87, 0x3c, 0xf, 0x1, 0xc3, 0x9e,
    0x7, 0x80, 0xe1, 0xcf, 0xfb, 0xc0, 0x78, 0xe7,
    0xfd, 0xe0, 0x3c, 0x73, 0xc0, 0xf0, 0x1e, 0x39,
    0xe0, 0x78, 0x1f, 0x1c, 0xf0, 0x3c, 0xf, 0x8e,
    0x78, 0x1e, 0x5, 0xc7, 0x3f, 0xff, 0x6, 0xe3,
    0x9f, 0xff, 0x82, 0x71, 0xcf, 0x3, 0xc3, 0x38,
    0xe7, 0xf1, 0xe1, 0x1c, 0x70, 0x78, 0x0, 0xe,
    0x38, 0x38, 0x0, 0x7, 0x1c, 0x1c, 0x0, 0x3,
    0x8e, 0xe, 0x0, 0x1, 0xc7, 0xff, 0xff, 0xc0,
    0xe3, 0xff, 0xff, 0xe0, 0x71, 0xc3, 0xc3, 0x80,
    0x38, 0xe1, 0xe3, 0xc0, 0x1c, 0x70, 0xe1, 0xe0,
    0xe, 0x38, 0x70, 0xe0, 0x7, 0x1c, 0x78, 0x70,
    0x3, 0x8e, 0x3c, 0x70, 0x1, 0xc7, 0x1f, 0xb8,
    0x0, 0xe3, 0x8f, 0x78, 0x0, 0x71, 0xc0, 0x1e,
    0x0, 0x38, 0xe0, 0x3f, 0xc0, 0x1c, 0x70, 0x38,
    0xf0, 0xe, 0x38, 0x70, 0x3c, 0x7, 0x1c, 0x60,
    0x6, 0x3, 0x8e, 0xc0, 0x1, 0x1, 0xc7, 0xff,
    0xff, 0xe0, 0xe3, 0xff, 0xff, 0xf0, 0x71, 0xc0,
    0x0, 0x0, 0x38, 0xe0, 0x0, 0x0,

    /* U+5047 "假" */
    0x3, 0xee, 0x1e, 0xf, 0x0, 0xfb, 0x87, 0x83,
    0xc0, 0x3e, 0xff, 0xef, 0xf0, 0xf, 0x3f, 0xfb,
    0xfc, 0x3, 0xce, 0x1e, 0xf, 0x0, 0xf3, 0x87,
    0x83, 0xc0, 0x3c, 0xe1, 0xe0, 0xf0, 0x1e, 0x38,
    0x78, 0x3c, 0x7, 0x8e, 0x1e, 0xf, 0x1, 0xe3,
    0x87, 0x83, 0xc0, 0x70, 0xe1, 0xe0, 0xf0, 0x3c,
    0x38, 0x78, 0x3c, 0xe, 0xe, 0x1e, 0xf, 0x3,
    0xe3, 0xff, 0xbf, 0xc0, 0xf8, 0xff, 0xef, 0xf0,
    0x7e, 0x38, 0x78, 0x3c, 0x17, 0x8e, 0x1e, 0x0,
    0xd, 0xe3, 0x80, 0x0, 0x2, 0x78, 0xe0, 0x0,
    0x1, 0x9e, 0x38, 0x0, 0x3c, 0x47, 0x8e, 0x3,
    0xff, 0x1, 0xe3, 0x80, 0xff, 0xc0, 0x78, 0xe0,
    0x18, 0xf0, 0x1e, 0x3f, 0xe6, 0x3c, 0x7, 0x8f,
    0xf9, 0x8f, 0x1, 0xe3, 0x80, 0x63, 0xc0, 0x78,
    0xe0, 0x18, 0xf0, 0x1e, 0x38, 0x6, 0x3c, 0x7,
    0x8e, 0x1, 0x8f, 0x1, 0xe3, 0x80, 0x23, 0xc0,
    0x78, 0xe0, 0x8, 0xf0, 0x1e, 0x38, 0x3, 0x38,
    0x7, 0x8e, 0x0, 0xce, 0x1, 0xe3, 0xfe, 0x37,
    0x80, 0x78, 0xff, 0x8f, 0xc0, 0x1e, 0x38, 0x1,
    0xf0, 0x7, 0x8e, 0x0, 0x78, 0x1, 0xe3, 0x80,
    0x1e, 0x0, 0x78, 0xe0, 0x7, 0xc0, 0x1e, 0x38,
    0x3, 0xfc, 0x7, 0x8e, 0x1, 0xdf, 0xc1, 0xe3,
    0x80, 0x47, 0xe0, 0x78, 0xe0, 0x20, 0xf8, 0x1e,
    0x38, 0x30, 0x1e, 0x7, 0x8e, 0x18, 0x3, 0x81,
    0xe3, 0x8c, 0x0, 0x20,

    /* U+5048 "偈" */
    0x3, 0xe7, 0x0, 0x3c, 0x7, 0xce, 0x0, 0x78,
    0xf, 0x1f, 0xff, 0xf0, 0x1e, 0x3f, 0xff, 0xe0,
    0x3c, 0x70, 0x3, 0xc0, 0x78, 0xe0, 0x7, 0x80,
    0xf1, 0xc0, 0xf, 0x1, 0xc3, 0x80, 0x1e, 0x3,
    0x87, 0xff, 0x3c, 0x7, 0xf, 0xfe, 0x78, 0x1c,
    0x1c, 0x0, 0xf0, 0x38, 0x38, 0x1, 0xe0, 0x70,
    0x70, 0x3, 0xc0, 0xe0, 0xe0, 0x7, 0x81, 0xc1,
    0xff, 0xff, 0x7, 0x83, 0xff, 0xfe, 0xf, 0x7,
    0x0, 0x3c, 0x3e, 0xe, 0x0, 0x78, 0x7c, 0x0,
    0x0, 0x0, 0xb8, 0x3c, 0x0, 0x2, 0x70, 0x78,
    0x1, 0xec, 0xe0, 0xe0, 0x3, 0xd1, 0xc3, 0xff,
    0xff, 0x83, 0x87, 0xff, 0xff, 0x7, 0xe, 0x0,
    0x1e, 0xe, 0x38, 0x7c, 0x3c, 0x1c, 0x70, 0xf0,
    0x78, 0x39, 0xc1, 0xe0, 0xf0, 0x77, 0xe3, 0xc1,
    0xe0, 0xf9, 0xc7, 0x83, 0xc1, 0xc3, 0x8f, 0x7,
    0x83, 0x87, 0x19, 0xf, 0x7, 0xe, 0x33, 0x9e,
    0xe, 0x1c, 0xc7, 0xfc, 0x1c, 0x39, 0x87, 0x78,
    0x38, 0x72, 0xe, 0xf0, 0x70, 0xe8, 0xd, 0xe0,
    0xe1, 0xd0, 0x1b, 0xc1, 0xc3, 0x80, 0x7, 0x83,
    0x87, 0x0, 0xf, 0x7, 0xf, 0xff, 0xde, 0xe,
    0x1f, 0xff, 0xbc, 0x1c, 0x38, 0x0, 0x70, 0x38,
    0x70, 0x1, 0xe0, 0x70, 0xe0, 0xf, 0x0, 0xe0,
    0x0, 0xec, 0x0,

    /* U+5049 "偉" */
    0x3, 0xe0, 0x78, 0x0, 0x3, 0xe0, 0x78, 0x0,
    0x3, 0xe0, 0x78, 0x0, 0x3, 0xe0, 0x78, 0x3c,
    0x3, 0xcf, 0xff, 0xfc, 0x3, 0xcf, 0xff, 0xf8,
    0x3, 0xc0, 0x70, 0x38, 0x3, 0xc0, 0x70, 0x38,
    0x3, 0x80, 0x60, 0x70, 0x3, 0x80, 0x40, 0x60,
    0x7, 0x80, 0x80, 0x40, 0x7, 0x3f, 0xff, 0xff,
    0x7, 0x3f, 0xff, 0xff, 0x7, 0x0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x0, 0xf, 0x87, 0x0, 0x38,
    0xf, 0x87, 0x0, 0x38, 0x1f, 0x87, 0xff, 0xf8,
    0x17, 0x87, 0x0, 0x38, 0x37, 0x87, 0x0, 0x38,
    0x27, 0x87, 0x0, 0x38, 0x67, 0x87, 0x0, 0x38,
    0x47, 0x87, 0x0, 0x38, 0x7, 0x87, 0xff, 0xf8,
    0x7, 0x87, 0xff, 0xf8, 0x7, 0x87, 0xe, 0x38,
    0x7, 0x87, 0xe, 0x38, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x9f, 0xff, 0xfe,
    0x7, 0x9f, 0xff, 0xfe, 0x7, 0x87, 0x8e, 0x0,
    0x7, 0x87, 0xe, 0x0, 0x7, 0x86, 0xe, 0x0,
    0x7, 0x88, 0xe, 0x0, 0x7, 0x9f, 0xff, 0xff,
    0x7, 0x9f, 0xff, 0xff, 0x7, 0x90, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,

    /* U+504C "偌" */
    0x7, 0x83, 0xc1, 0xc0, 0xf, 0x7, 0x83, 0x80,
    0x1e, 0xf, 0x7, 0x0, 0x3c, 0x1e, 0xe, 0x0,
    0x78, 0x3c, 0x1c, 0x0, 0xe7, 0xff, 0xff, 0xc1,
    0xcf, 0xff, 0xff, 0x83, 0x81, 0xe0, 0xe0, 0x7,
    0x3, 0xc1, 0xc0, 0x1e, 0x7, 0x83, 0x80, 0x38,
    0xf, 0x7, 0x0, 0x70, 0x1e, 0xe, 0x0, 0xe0,
    0x3c, 0x1c, 0x1, 0xe0, 0xf, 0x0, 0x7, 0xc0,
    0x1e, 0x0, 0xf, 0x80, 0x7c, 0x0, 0x1f, 0x0,
    0xf8, 0x0, 0x3e, 0x1, 0xe0, 0x0, 0xfd, 0xff,
    0xff, 0xf9, 0x7b, 0xff, 0xff, 0xf6, 0xf0, 0xe,
    0x0, 0x9, 0xe0, 0x3c, 0x0, 0x23, 0xc0, 0x78,
    0x0, 0x7, 0x80, 0xe0, 0x0, 0xf, 0x3, 0xc0,
    0x0, 0x1e, 0x7, 0x0, 0x0, 0x3c, 0x1f, 0x1,
    0xe0, 0x78, 0x3f, 0xff, 0xc0, 0xf0, 0xff, 0xff,
    0x81, 0xe1, 0xf8, 0xf, 0x3, 0xc6, 0xf0, 0x1e,
    0x7, 0x99, 0xe0, 0x3c, 0xf, 0x23, 0xc0, 0x78,
    0x1e, 0x87, 0x80, 0xf0, 0x3c, 0xf, 0x1, 0xe0,
    0x78, 0x1e, 0x3, 0xc0, 0xf0, 0x3c, 0x7, 0x81,
    0xe0, 0x78, 0xf, 0x3, 0xc0, 0xf0, 0x1e, 0x7,
    0x81, 0xe0, 0x3c, 0xf, 0x3, 0xff, 0xf8, 0x1e,
    0x7, 0xff, 0xf0, 0x3c, 0xf, 0x1, 0xe0, 0x78,
    0x1e, 0x3, 0xc0, 0xf0, 0x3c, 0x7, 0x81, 0xe0,
    0x78, 0xf, 0x0,

    /* U+504E "偎" */
    0x3, 0xc7, 0x80, 0xf, 0x0, 0xf1, 0xe0, 0x3,
    0xc0, 0x3c, 0x7f, 0xff, 0xf0, 0xf, 0x1f, 0xff,
    0xfc, 0x3, 0xc7, 0x87, 0xf, 0x0, 0xf1, 0xe1,
    0xc3, 0xc0, 0x3c, 0x78, 0x70, 0xf0, 0xf, 0x1e,
    0x1c, 0x3c, 0x7, 0x87, 0x87, 0xf, 0x1, 0xe1,
    0xe1, 0xc3, 0xc0, 0x78, 0x7f, 0xff, 0xf0, 0x1c,
    0x1f, 0xff, 0xfc, 0x7, 0x7, 0x87, 0xf, 0x1,
    0xe1, 0xe1, 0xc3, 0xc0, 0xf8, 0x78, 0x70, 0xf0,
    0x3e, 0x1e, 0x1c, 0x3c, 0xf, 0x87, 0x87, 0xf,
    0x7, 0xe1, 0xe1, 0xc3, 0xc1, 0xf8, 0x7f, 0xff,
    0xf0, 0xde, 0x1f, 0xff, 0xfc, 0x27, 0x87, 0x80,
    0xf, 0x19, 0xe1, 0xe0, 0x3, 0xc4, 0x78, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x7, 0xbf,
    0xff, 0xff, 0x81, 0xef, 0xff, 0xff, 0xe0, 0x78,
    0x1c, 0x20, 0x0, 0x1e, 0x7, 0x8, 0x18, 0x7,
    0x81, 0xc2, 0x4, 0x1, 0xe0, 0x70, 0x83, 0x0,
    0x78, 0x1c, 0x31, 0x80, 0x1e, 0x7, 0xc, 0x60,
    0x7, 0x81, 0xc3, 0x30, 0x1, 0xe0, 0x70, 0x6c,
    0x0, 0x78, 0x1c, 0x1e, 0x0, 0x1e, 0x7, 0x7,
    0x80, 0x7, 0x81, 0xc0, 0xf0, 0x1, 0xe0, 0x70,
    0x3e, 0x0, 0x78, 0x1c, 0x17, 0xe0, 0x1e, 0x7,
    0xc, 0xfe, 0x7, 0x81, 0xde, 0x3f, 0xc1, 0xe7,
    0xff, 0x7, 0xe0, 0x79, 0xff, 0x0, 0x78, 0x1e,
    0x3f, 0x80, 0xe, 0x7, 0x8f, 0x80, 0x1, 0x81,
    0xe3, 0x0, 0x0, 0x0,

    /* U+504F "偏" */
    0x3, 0xc0, 0x10, 0x0, 0x7, 0x80, 0x30, 0x0,
    0xf, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x78, 0x0,
    0x38, 0x0, 0xe0, 0x0, 0x77, 0x80, 0xc3, 0xc0,
    0xef, 0xff, 0xff, 0x83, 0xdf, 0xff, 0xff, 0x7,
    0xbc, 0x0, 0x1e, 0xe, 0x78, 0x0, 0x3c, 0x1c,
    0xf0, 0x0, 0x78, 0x39, 0xe0, 0x0, 0xf0, 0x63,
    0xc0, 0x1, 0xe1, 0xe7, 0xff, 0xff, 0xc3, 0xcf,
    0xff, 0xff, 0x87, 0x9e, 0x0, 0xf, 0x1f, 0x3c,
    0x0, 0x1e, 0x3e, 0x78, 0x0, 0x0, 0xdc, 0xf0,
    0x0, 0x1, 0x39, 0xee, 0x0, 0x76, 0x73, 0xdc,
    0x0, 0xe8, 0xe7, 0xbf, 0xff, 0xf1, 0xcf, 0x7f,
    0xff, 0x83, 0x9e, 0xe7, 0x77, 0x7, 0x3d, 0xce,
    0xee, 0xe, 0x7b, 0x9d, 0xdc, 0x1c, 0xf7, 0x3b,
    0xb8, 0x39, 0xee, 0x77, 0x70, 0x73, 0xdc, 0xee,
    0xe0, 0xe7, 0xb9, 0xdd, 0xc1, 0xcf, 0x7f, 0xff,
    0x83, 0x9e, 0xff, 0xff, 0x7, 0x3d, 0xce, 0xee,
    0xe, 0x7b, 0x9d, 0xdc, 0x1c, 0xf7, 0x3b, 0xb8,
    0x39, 0xee, 0x77, 0x70, 0x73, 0x9c, 0xee, 0xe0,
    0xe7, 0x39, 0xdd, 0xc1, 0xce, 0x73, 0xbb, 0x83,
    0x98, 0xe7, 0x77, 0x7, 0x71, 0xce, 0xee, 0xe,
    0xc3, 0x9d, 0xdc, 0x1d, 0x87, 0x3b, 0xb8, 0x3a,
    0xe, 0x0, 0x70, 0x7c, 0x1c, 0x3, 0xc0, 0xf0,
    0x38, 0xa, 0x0,

    /* U+5055 "偕" */
    0x3, 0xcf, 0x1, 0xc0, 0x1, 0xe7, 0x80, 0xe0,
    0x0, 0xf3, 0xc0, 0x70, 0x0, 0x79, 0xe0, 0x38,
    0x20, 0x38, 0xf0, 0x1c, 0x30, 0x1c, 0x78, 0xe,
    0x30, 0xe, 0x3f, 0xe7, 0x18, 0xf, 0x1f, 0xf3,
    0x98, 0x7, 0xf, 0x1, 0xd8, 0x3, 0x87, 0x80,
    0xf8, 0x81, 0xc3, 0xc0, 0x78, 0x40, 0xc1, 0xe0,
    0x3c, 0x20, 0xe0, 0xf0, 0x1c, 0x10, 0x78, 0x78,
    0x1e, 0x8, 0x3c, 0x3c, 0x17, 0xc, 0x3e, 0x1e,
    0x33, 0x87, 0x1f, 0xf, 0xf1, 0xc3, 0x8f, 0x9f,
    0xf0, 0xff, 0xcd, 0xcf, 0xf0, 0x7f, 0xe4, 0xe3,
    0xe0, 0x3f, 0xe6, 0x73, 0x81, 0xe0, 0x2, 0x38,
    0x0, 0xf0, 0x3, 0x1c, 0x0, 0x70, 0x0, 0xe,
    0x0, 0x38, 0x0, 0x7, 0xf, 0x38, 0x3c, 0x3,
    0x87, 0x98, 0x1e, 0x1, 0xc3, 0xff, 0xff, 0x0,
    0xe1, 0xff, 0xff, 0x80, 0x70, 0xf0, 0x3, 0xc0,
    0x38, 0x78, 0x1, 0xe0, 0x1c, 0x3c, 0x0, 0xf0,
    0xe, 0x1e, 0x0, 0x78, 0x7, 0xf, 0x0, 0x3c,
    0x3, 0x87, 0xff, 0x9e, 0x1, 0xc3, 0xff, 0xcf,
    0x0, 0xe1, 0xe0, 0x7, 0x80, 0x70, 0xf0, 0x3,
    0xc0, 0x38, 0x78, 0x1, 0xe0, 0x1c, 0x3c, 0x0,
    0xf0, 0xe, 0x1e, 0x0, 0x78, 0x7, 0xf, 0x0,
    0x3c, 0x3, 0x87, 0xff, 0xfe, 0x1, 0xc3, 0xff,
    0xff, 0x0, 0xe1, 0xe0, 0x7, 0x80, 0x70, 0xf0,
    0x3, 0xc0, 0x38, 0x78, 0x1, 0xe0,

    /* U+505A "做" */
    0x3, 0xe3, 0xc3, 0xe0, 0x3, 0xe1, 0xe1, 0xe0,
    0x1, 0xf0, 0xf0, 0xf0, 0x0, 0xf8, 0x78, 0x78,
    0x0, 0x7c, 0x3c, 0x3c, 0x0, 0x3c, 0x1e, 0x1e,
    0x0, 0x1e, 0xf, 0xe, 0x0, 0xf, 0x7, 0x87,
    0x0, 0x7, 0x3f, 0xfb, 0xff, 0x87, 0x9f, 0xff,
    0xff, 0xc3, 0x80, 0xe1, 0xcf, 0x1, 0xc0, 0x70,
    0xe7, 0x81, 0xc0, 0x38, 0x63, 0xc0, 0xf8, 0x1c,
    0x71, 0xe0, 0x7c, 0xe, 0x38, 0xf0, 0x7e, 0x7,
    0x18, 0x78, 0x3f, 0x3, 0x9c, 0x3c, 0x17, 0x81,
    0x8e, 0x1e, 0x1b, 0xc1, 0xcc, 0x8f, 0x9, 0xe0,
    0xc0, 0x47, 0x80, 0xf0, 0x40, 0x23, 0xc0, 0x79,
    0xc3, 0x91, 0xe0, 0x3c, 0xe1, 0xc8, 0xf0, 0x1e,
    0x7f, 0xe4, 0x78, 0xf, 0x3f, 0xf2, 0x3c, 0x7,
    0x9c, 0x39, 0x1e, 0x3, 0xce, 0x1c, 0xcf, 0x1,
    0xe7, 0xe, 0x67, 0x0, 0xf3, 0x87, 0x33, 0x80,
    0x79, 0xc3, 0x9d, 0xc0, 0x3c, 0xe1, 0xc6, 0xe0,
    0x1e, 0x70, 0xe3, 0xf0, 0xf, 0x38, 0x71, 0xf0,
    0x7, 0x9c, 0x38, 0xf8, 0x3, 0xce, 0x1c, 0x38,
    0x1, 0xe7, 0xe, 0x1e, 0x0, 0xf3, 0x87, 0xf,
    0x0, 0x79, 0xc3, 0x8f, 0xc0, 0x3c, 0xff, 0xc6,
    0xf0, 0x1e, 0x7f, 0xe6, 0x7e, 0xf, 0x38, 0x77,
    0x1f, 0x7, 0x9c, 0x3b, 0xf, 0x83, 0xce, 0x3,
    0x3, 0xc1, 0xe0, 0x3, 0x80, 0xe0, 0xf0, 0x1,
    0x80, 0x30, 0x78, 0x1, 0x80, 0x8,

    /* U+505C "停" */
    0x3, 0xe0, 0x18, 0x0, 0x3, 0xc0, 0xe, 0x0,
    0x3, 0xc0, 0x7, 0x0, 0x3, 0xc0, 0x7, 0x0,
    0x3, 0xc0, 0x2, 0x0, 0x7, 0x9f, 0xff, 0xff,
    0x7, 0x9f, 0xff, 0xff, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0, 0x7, 0x3, 0xc0, 0x38,
    0xf, 0x83, 0xc0, 0x38, 0xf, 0x83, 0xff, 0xf8,
    0xf, 0x83, 0xff, 0xf8, 0x1f, 0x83, 0xc0, 0x38,
    0x1f, 0x83, 0xc0, 0x38, 0x17, 0x83, 0xc0, 0x38,
    0x37, 0x83, 0xff, 0xf8, 0x27, 0x83, 0xff, 0xf8,
    0x67, 0x83, 0xc0, 0x38, 0x47, 0x83, 0xc0, 0x38,
    0xc7, 0x80, 0x0, 0x0, 0x7, 0xbc, 0x0, 0x0,
    0x7, 0xbc, 0x0, 0xf, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0xbc, 0x0, 0xf,
    0x7, 0xbc, 0x0, 0xf, 0x7, 0xbc, 0x0, 0xd,
    0x7, 0x80, 0x0, 0x8, 0x7, 0x8f, 0xff, 0xfe,
    0x7, 0x8f, 0xff, 0xfe, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x3e, 0x0, 0x7, 0x83, 0xf8, 0x0,

    /* U+5065 "健" */
    0x7, 0xc0, 0x7, 0x80, 0x1, 0xf0, 0x1, 0xe0,
    0x0, 0x78, 0xf0, 0x78, 0x0, 0x1e, 0x3c, 0x1e,
    0x78, 0x7, 0x8f, 0x7, 0x9e, 0x1, 0xff, 0xdf,
    0xff, 0x80, 0x7f, 0xf0, 0x79, 0xe0, 0x1c, 0x3c,
    0x1e, 0x78, 0x7, 0xf, 0x7, 0x9e, 0x1, 0xc3,
    0xc1, 0xe7, 0x80, 0xe0, 0xf0, 0x79, 0xe0, 0x38,
    0x3f, 0xff, 0xfe, 0xe, 0xf, 0xff, 0xff, 0x83,
    0xc7, 0x81, 0xe7, 0x81, 0xf1, 0xc0, 0x79, 0xe0,
    0x7c, 0x60, 0x1e, 0x78, 0x1f, 0x30, 0x7, 0x9e,
    0x5, 0xc9, 0xdf, 0xff, 0x83, 0x77, 0xf7, 0xff,
    0xe0, 0x9d, 0xfc, 0x1e, 0x78, 0x67, 0x47, 0x7,
    0x80, 0x11, 0xc1, 0xc1, 0xe0, 0x8, 0x74, 0x70,
    0x78, 0x0, 0x1d, 0x1d, 0xff, 0xf8, 0x7, 0x47,
    0x7f, 0xfe, 0x1, 0xd1, 0xc1, 0xe0, 0x0, 0x74,
    0x70, 0x78, 0x0, 0x1c, 0x9c, 0x1e, 0x0, 0x7,
    0x27, 0x7, 0x80, 0x1, 0xc9, 0xc1, 0xe0, 0x0,
    0x72, 0x7f, 0xff, 0xe0, 0x1c, 0x9f, 0xff, 0xf8,
    0x7, 0x37, 0x7, 0x80, 0x1, 0xcf, 0xc1, 0xe0,
    0x0, 0x73, 0xf0, 0x78, 0x0, 0x1c, 0x78, 0x1e,
    0x0, 0x7, 0x1e, 0x7, 0x80, 0x1, 0xc7, 0x81,
    0xe0, 0x0, 0x71, 0xe0, 0x78, 0x0, 0x1c, 0x7c,
    0x1e, 0x0, 0x7, 0x1f, 0xc0, 0x0, 0x1, 0xcd,
    0xff, 0xff, 0xe0, 0x73, 0x3f, 0xff, 0xf8, 0x1d,
    0x87, 0xff, 0xfe, 0x7, 0x40, 0x7f, 0xff, 0x81,
    0xf0, 0x0, 0x0, 0x0,

    /* U+506A "偪" */
    0xf, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x3c, 0xff, 0xff, 0xf8, 0x79, 0xff, 0xff, 0xf0,
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xc1, 0xc0, 0x3c, 0x7, 0x83, 0x80, 0x78, 0xe,
    0x7, 0xff, 0xf0, 0x3c, 0xf, 0xff, 0xe0, 0x78,
    0x1c, 0x3, 0xc0, 0xf0, 0x38, 0x7, 0x81, 0xc0,
    0x70, 0xf, 0x3, 0x80, 0xe0, 0x1e, 0x7, 0x81,
    0xc0, 0x3c, 0xf, 0x3, 0x80, 0x78, 0x3e, 0x7,
    0x0, 0xf0, 0x7c, 0xf, 0xff, 0xe0, 0xf8, 0x1c,
    0x3, 0xc3, 0xf0, 0x38, 0x7, 0x85, 0xe0, 0x0,
    0x0, 0xb, 0xc0, 0x0, 0x0, 0x27, 0x80, 0x0,
    0x0, 0xf, 0xf, 0xff, 0xfc, 0x1e, 0x1f, 0xff,
    0xf8, 0x3c, 0x38, 0x78, 0x70, 0x78, 0x70, 0xf0,
    0xe0, 0xf0, 0xe1, 0xe1, 0xc1, 0xe1, 0xc3, 0xc3,
    0x83, 0xc3, 0x87, 0x87, 0x7, 0x87, 0xf, 0xe,
    0xf, 0xe, 0x1e, 0x1c, 0x1e, 0x1f, 0xff, 0xf8,
    0x3c, 0x3f, 0xff, 0xf0, 0x78, 0x70, 0xf0, 0xe0,
    0xf0, 0xe1, 0xe1, 0xc1, 0xe1, 0xc3, 0xc3, 0x83,
    0xc3, 0x87, 0x87, 0x7, 0x87, 0xf, 0xe, 0xf,
    0xe, 0x1e, 0x1c, 0x1e, 0x1c, 0x3c, 0x38, 0x3c,
    0x3f, 0xff, 0xf0, 0x78, 0x7f, 0xff, 0xe0, 0xf0,
    0xe0, 0x1, 0xc1, 0xe1, 0xc0, 0x3, 0x83, 0xc3,
    0x80, 0x7, 0x0,

    /* U+506C "偬" */
    0x3, 0xe3, 0xc0, 0x0, 0x0, 0xf8, 0xf0, 0x0,
    0x0, 0x3e, 0x3c, 0x1, 0xe0, 0xf, 0x8f, 0x0,
    0x78, 0x3, 0xc3, 0xc0, 0x1e, 0x0, 0xf0, 0xff,
    0xff, 0x80, 0x3c, 0x3f, 0xff, 0xe0, 0xf, 0xe,
    0x0, 0x78, 0x7, 0x83, 0x80, 0x1e, 0x1, 0xe1,
    0xdc, 0xe7, 0x80, 0x78, 0x77, 0x39, 0xe0, 0x1c,
    0x19, 0xce, 0x78, 0x7, 0xe, 0x73, 0x9e, 0x1,
    0xe3, 0x7c, 0xe7, 0x80, 0xf9, 0x8f, 0x31, 0xe0,
    0x3e, 0x63, 0xfc, 0x78, 0xf, 0xb0, 0xff, 0x1e,
    0x7, 0xe0, 0x37, 0xf7, 0x81, 0x78, 0x18, 0xfd,
    0xe0, 0xde, 0xe, 0x3e, 0x78, 0x27, 0x83, 0x19,
    0x9e, 0x19, 0xe1, 0x84, 0x27, 0x8c, 0x78, 0xc2,
    0x1, 0xc0, 0x1e, 0x61, 0x0, 0xf0, 0x7, 0xb0,
    0x80, 0x78, 0x1, 0xe0, 0x0, 0xfc, 0x0, 0x78,
    0x0, 0x80, 0x0, 0x1e, 0x0, 0x30, 0x0, 0x7,
    0x80, 0xe, 0x0, 0x1, 0xe0, 0x3d, 0xc4, 0x0,
    0x78, 0xf, 0x78, 0x80, 0x1e, 0x3b, 0xce, 0x30,
    0x7, 0x8e, 0xf3, 0x8c, 0x1, 0xe3, 0xbc, 0x61,
    0x80, 0x78, 0xef, 0x10, 0x70, 0x1e, 0x3b, 0xc0,
    0x5e, 0x7, 0x8e, 0xf0, 0x13, 0x81, 0xe3, 0xbc,
    0x4, 0xe0, 0x78, 0xcf, 0x1, 0x38, 0x1e, 0x33,
    0xc0, 0xc4, 0x7, 0x98, 0xf0, 0x39, 0x1, 0xec,
    0x3c, 0xe, 0x0, 0x7e, 0xf, 0xff, 0x80, 0x1e,
    0x3, 0xff, 0xe0, 0x7, 0x80, 0xff, 0xf0, 0x1,
    0xe0, 0x1f, 0xfc, 0x0,

    /* U+506D "偭" */
    0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x18, 0x0,
    0xf, 0x0, 0x10, 0x0, 0xe, 0x1c, 0x30, 0x1e,
    0xe, 0x1f, 0xff, 0xfe, 0xf, 0x1f, 0xff, 0xfe,
    0x1f, 0x1c, 0x63, 0x9e, 0x1f, 0x1c, 0x63, 0x9e,
    0x1f, 0x1c, 0x63, 0x9e, 0x3f, 0x1c, 0x63, 0x9e,
    0x37, 0x1c, 0x63, 0x9e, 0x27, 0x1c, 0x63, 0x9e,
    0x67, 0x1c, 0x63, 0x9e, 0x47, 0x1c, 0x7f, 0x9e,
    0xc7, 0x1c, 0x7f, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x7f, 0x9e, 0x7, 0x1c, 0x7f, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x7, 0x1f, 0xff, 0xfe, 0x7, 0x1f, 0xff, 0xfe,
    0x7, 0x1c, 0x0, 0x1e, 0x7, 0x1c, 0x0, 0x1e,
    0x7, 0x1c, 0x0, 0x1e, 0x7, 0x1c, 0x0, 0x1e,

    /* U+506F "偯" */
    0x3, 0xe0, 0x18, 0x0, 0x0, 0x7c, 0x1, 0xc0,
    0x0, 0xf, 0x80, 0x3e, 0x0, 0x1, 0xf0, 0x3,
    0x80, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x7, 0xbf,
    0xff, 0xff, 0x80, 0xf7, 0xff, 0xff, 0xf0, 0x3e,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x0,
    0xf0, 0xf0, 0x1, 0xe0, 0x1c, 0x1e, 0x0, 0x3c,
    0x3, 0x83, 0xff, 0xff, 0x80, 0x70, 0x7f, 0xff,
    0xf0, 0x1f, 0xf, 0x0, 0x1e, 0x3, 0xe1, 0xe0,
    0x3, 0xc0, 0x7c, 0x3c, 0x0, 0x78, 0x1f, 0x87,
    0x80, 0xf, 0x3, 0xf0, 0xf0, 0x1, 0xe0, 0x5e,
    0x1e, 0x0, 0x3c, 0x1b, 0xc3, 0xc0, 0x7, 0x82,
    0x78, 0x7f, 0xff, 0xf0, 0xcf, 0xf, 0xff, 0xfe,
    0x31, 0xe1, 0xe7, 0x43, 0xc0, 0x3c, 0x3c, 0xe8,
    0x78, 0x7, 0x80, 0x3d, 0x0, 0x0, 0xf0, 0x7,
    0x20, 0x20, 0x1e, 0x0, 0xe6, 0xe, 0x3, 0xc0,
    0x38, 0xc3, 0x0, 0x78, 0x7, 0x18, 0xc0, 0xf,
    0x1, 0xe1, 0x30, 0x1, 0xe0, 0x7c, 0x3c, 0x0,
    0x3c, 0xf, 0x87, 0x0, 0x7, 0x83, 0xf0, 0xe0,
    0x0, 0xf0, 0xee, 0xe, 0x0, 0x1e, 0x31, 0xc1,
    0xe0, 0x3, 0xcc, 0x38, 0x1c, 0x0, 0x7a, 0x7,
    0x3, 0xe0, 0xf, 0x0, 0xe1, 0x3e, 0x1, 0xe0,
    0x1c, 0x43, 0xf8, 0x3c, 0x3, 0xb8, 0x7f, 0x7,
    0x80, 0x7e, 0x7, 0xc0, 0xf0, 0x7f, 0x80, 0x78,
    0x1e, 0xf, 0xe0, 0x7, 0x3, 0xc0, 0xf0, 0x0,
    0x20, 0x78, 0x18, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x0,

    /* U+5072 "偲" */
    0x7, 0xcf, 0x0, 0x3c, 0x7, 0x8f, 0x0, 0x3c,
    0x7, 0x8f, 0xff, 0xfc, 0x7, 0x8f, 0xff, 0xfc,
    0x7, 0x8f, 0x1e, 0x3c, 0x7, 0x8f, 0x1e, 0x3c,
    0x7, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xe, 0xf, 0x1e, 0x3c, 0xe, 0xf, 0xff, 0xfc,
    0xf, 0xf, 0xff, 0xfc, 0x1f, 0xf, 0x1e, 0x3c,
    0x1f, 0xf, 0x1e, 0x3c, 0x1f, 0xf, 0x1e, 0x3c,
    0x3f, 0xf, 0x1e, 0x3c, 0x3f, 0xf, 0x1e, 0x3c,
    0x6f, 0xf, 0x1e, 0x3c, 0x6f, 0xf, 0x1e, 0x3c,
    0x4f, 0xf, 0x1e, 0x3c, 0xcf, 0xf, 0xff, 0xfc,
    0xf, 0xf, 0xff, 0xfc, 0xf, 0xf, 0x0, 0x3c,
    0xf, 0xf, 0x8, 0x3c, 0xf, 0x0, 0x8, 0x0,
    0xf, 0x0, 0x4, 0x0, 0xf, 0x0, 0xf6, 0x0,
    0xf, 0x1c, 0xf6, 0x20, 0xf, 0x1c, 0xf7, 0x10,
    0xf, 0x1c, 0xf7, 0x18, 0xf, 0x1c, 0xf3, 0x98,
    0xf, 0x1c, 0xf3, 0x9c, 0xf, 0x1c, 0xf3, 0x8e,
    0xf, 0x1c, 0xf3, 0xbe, 0xf, 0x1c, 0xf1, 0x2f,
    0xf, 0x1c, 0xf1, 0x27, 0xf, 0x1c, 0xf0, 0x26,
    0xf, 0x1c, 0xf0, 0x26, 0xf, 0x1c, 0xf0, 0x22,
    0xf, 0x18, 0xf0, 0x70, 0xf, 0x38, 0xf0, 0x70,
    0xf, 0x30, 0xff, 0xf0, 0xf, 0x0, 0xff, 0xf0,
    0xf, 0x0, 0xff, 0xf0, 0xf, 0x0, 0xff, 0xe0,

    /* U+5074 "側" */
    0x7, 0xb8, 0x70, 0xe, 0x7, 0x3f, 0xf0, 0xe,
    0x7, 0x3f, 0xf0, 0xe, 0x7, 0x38, 0x73, 0x8e,
    0xf, 0x38, 0x73, 0x8e, 0xf, 0x38, 0x73, 0x8e,
    0xe, 0x38, 0x73, 0x8e, 0xe, 0x38, 0x73, 0x8e,
    0xe, 0x38, 0x73, 0x8e, 0xc, 0x3f, 0x73, 0x8e,
    0xc, 0x3f, 0x73, 0x8e, 0x1c, 0x38, 0x73, 0x8e,
    0x1e, 0x38, 0x73, 0x8e, 0x1e, 0x38, 0x73, 0x8e,
    0x3e, 0x38, 0x73, 0x8e, 0x3e, 0x38, 0x73, 0x8e,
    0x2e, 0x38, 0x73, 0x8e, 0x6e, 0x3f, 0x73, 0x8e,
    0x4e, 0x3f, 0x73, 0x8e, 0x8e, 0x38, 0x73, 0x8e,
    0xe, 0x38, 0x73, 0x8e, 0xe, 0x38, 0x73, 0x8e,
    0xe, 0x38, 0x73, 0x8e, 0xe, 0x38, 0x73, 0x8e,
    0xe, 0x38, 0x73, 0x8e, 0xe, 0x38, 0x73, 0x8e,
    0xe, 0x3f, 0xf3, 0x8e, 0xe, 0x38, 0x73, 0x8e,
    0xe, 0x38, 0x73, 0x8e, 0xe, 0x38, 0x73, 0x8e,
    0xe, 0x0, 0x3, 0x8e, 0xe, 0x1e, 0x3, 0x8e,
    0xe, 0x1e, 0x83, 0x8e, 0xe, 0x1e, 0x83, 0x8e,
    0xe, 0x1e, 0xc3, 0x8e, 0xe, 0x1c, 0xe0, 0xe,
    0xe, 0x1c, 0x70, 0xe, 0xe, 0x18, 0x78, 0xe,
    0xe, 0x38, 0x78, 0xe, 0xe, 0x30, 0x70, 0xe,
    0xe, 0x70, 0x30, 0xe, 0xe, 0x60, 0x10, 0x1c,
    0xe, 0xc0, 0x10, 0x78, 0xe, 0x0, 0x1, 0xe0,

    /* U+5075 "偵" */
    0x7, 0x80, 0x78, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0x1e, 0x1, 0xe0, 0x0, 0x3c, 0x3, 0xc0, 0x0,
    0x70, 0x7, 0x80, 0x0, 0xe0, 0xf, 0xff, 0xc1,
    0xc0, 0x1f, 0xff, 0x83, 0x80, 0x3c, 0x0, 0xf,
    0x0, 0x78, 0x0, 0x1c, 0x0, 0xf0, 0x0, 0x38,
    0x1, 0xe0, 0x0, 0x71, 0xe3, 0xc1, 0xe0, 0xc3,
    0xff, 0x83, 0xc3, 0x87, 0xff, 0xff, 0x87, 0x8f,
    0xff, 0xff, 0xf, 0x1e, 0x0, 0x1e, 0x3e, 0x3c,
    0x0, 0x3c, 0x7c, 0x78, 0x0, 0x78, 0xf8, 0xf0,
    0x0, 0xf3, 0x71, 0xff, 0xf9, 0xe4, 0xe3, 0xc0,
    0x3, 0xd9, 0xc7, 0x80, 0x7, 0x83, 0x8f, 0x0,
    0xf, 0x7, 0x1e, 0x0, 0x1e, 0xe, 0x3f, 0xff,
    0x3c, 0x1c, 0x7f, 0xfe, 0x78, 0x38, 0xf0, 0x0,
    0xf0, 0x71, 0xe0, 0x1, 0xe0, 0xe3, 0xc0, 0x3,
    0xc1, 0xc7, 0x80, 0x7, 0x83, 0x8f, 0x0, 0xf,
    0x7, 0x1f, 0xff, 0xfe, 0xe, 0x3f, 0xff, 0xfc,
    0x1c, 0x78, 0x0, 0x78, 0x38, 0xf0, 0x8, 0xf0,
    0x71, 0xef, 0x91, 0xe0, 0xe0, 0x1f, 0x10, 0x1,
    0xc0, 0x3c, 0x30, 0x3, 0x80, 0xf0, 0x70, 0x7,
    0x1, 0xe0, 0x78, 0xe, 0x3, 0x80, 0xfe, 0x1c,
    0xe, 0x0, 0xfc, 0x38, 0x38, 0x1, 0xf0, 0x70,
    0xc0, 0x1, 0xe0, 0xe3, 0x0, 0x1, 0xc1, 0xcc,
    0x0, 0x0, 0x80,

    /* U+5076 "偶" */
    0x3, 0xe7, 0x0, 0x1e, 0x7, 0xce, 0x0, 0x3c,
    0xf, 0x1f, 0xff, 0xf8, 0x1e, 0x3f, 0xff, 0xf0,
    0x3c, 0x70, 0xe1, 0xe0, 0x78, 0xe1, 0xc3, 0xc0,
    0xf1, 0xc3, 0x87, 0x81, 0xc3, 0x87, 0xf, 0x7,
    0x87, 0xe, 0x1e, 0xf, 0xf, 0xff, 0xfc, 0x1c,
    0x1f, 0xff, 0xf8, 0x38, 0x38, 0x70, 0xf0, 0x60,
    0x70, 0xe1, 0xe1, 0xf0, 0xe1, 0xc3, 0xc3, 0xe1,
    0xc3, 0x87, 0x87, 0xc3, 0x87, 0xf, 0x1f, 0x87,
    0xe, 0x1e, 0x2f, 0xf, 0xff, 0xfc, 0xde, 0x1f,
    0xff, 0xf9, 0x3c, 0x38, 0x70, 0xf2, 0x78, 0x0,
    0xe0, 0x8, 0xf0, 0x1, 0xc0, 0x11, 0xe0, 0x3,
    0x80, 0x3, 0xc0, 0x7, 0x0, 0x7, 0x9f, 0xff,
    0xfe, 0xf, 0x3f, 0xff, 0xfc, 0x1e, 0x78, 0x38,
    0x78, 0x3c, 0xf0, 0x70, 0xf0, 0x79, 0xe0, 0xe9,
    0xe0, 0xf3, 0xc1, 0xd3, 0xc1, 0xe7, 0x83, 0xa7,
    0x83, 0xcf, 0x7, 0x6f, 0x7, 0x9e, 0xf, 0xde,
    0xf, 0x3c, 0x1f, 0xfc, 0x1e, 0x7f, 0xfb, 0xf8,
    0x3c, 0xf7, 0xc7, 0xf0, 0x79, 0xef, 0x5, 0xe0,
    0xf3, 0xd0, 0xb, 0xc1, 0xe7, 0x80, 0x7, 0x83,
    0xcf, 0x0, 0xf, 0x7, 0x9e, 0x0, 0x1e, 0xf,
    0x3c, 0x0, 0x3c, 0x1e, 0x78, 0x0, 0x78, 0x3c,
    0xf0, 0x1, 0xe0, 0x79, 0xe0, 0x7, 0x80, 0xf3,
    0xc0, 0x74, 0x0,

    /* U+5077 "偷" */
    0x7, 0xc0, 0x3c, 0x0, 0x7, 0xc0, 0x7c, 0x0,
    0x7, 0xc0, 0x7c, 0x0, 0x7, 0x80, 0x7a, 0x0,
    0x7, 0x80, 0xf2, 0x0, 0x7, 0x80, 0xf1, 0x0,
    0x7, 0x80, 0xe1, 0x80, 0x7, 0x1, 0xc0, 0xc0,
    0x7, 0x3, 0xc0, 0xe0, 0x7, 0x3, 0x80, 0x70,
    0xe, 0x7, 0x0, 0x38, 0xe, 0xe, 0x0, 0x1e,
    0xe, 0x1f, 0xff, 0xff, 0xf, 0x33, 0xff, 0xff,
    0x1f, 0x60, 0x0, 0x6, 0x1f, 0xc0, 0x0, 0x3,
    0x1f, 0x0, 0x0, 0x1, 0x37, 0x1c, 0x70, 0x1c,
    0x37, 0x1f, 0xf0, 0x1c, 0x67, 0x1f, 0xf3, 0x9c,
    0x67, 0x1c, 0x73, 0x9c, 0xc7, 0x1c, 0x73, 0x9c,
    0x87, 0x1c, 0x73, 0x9c, 0x7, 0x1c, 0x73, 0x9c,
    0x7, 0x1c, 0x73, 0x9c, 0x7, 0x1f, 0xf3, 0x9c,
    0x7, 0x1f, 0xf3, 0x9c, 0x7, 0x1c, 0x73, 0x9c,
    0x7, 0x1c, 0x73, 0x9c, 0x7, 0x1c, 0x73, 0x9c,
    0x7, 0x1c, 0x73, 0x9c, 0x7, 0x1f, 0xf3, 0x9c,
    0x7, 0x1f, 0xf3, 0x9c, 0x7, 0x1c, 0x73, 0x9c,
    0x7, 0x1c, 0x73, 0x9c, 0x7, 0x1c, 0x73, 0x9c,
    0x7, 0x1c, 0x73, 0x9c, 0x7, 0x1c, 0x73, 0x9c,
    0x7, 0x1c, 0x70, 0x1c, 0x7, 0x1c, 0x70, 0x1c,
    0x7, 0x1c, 0x70, 0x1c, 0x7, 0x1c, 0x70, 0x1c,
    0x7, 0x1c, 0x70, 0x1c, 0x7, 0x1c, 0x70, 0x3c,
    0x7, 0x1d, 0xe0, 0x78, 0x7, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x2, 0x80,

    /* U+507A "偺" */
    0x3, 0xe3, 0x81, 0xc0, 0x3, 0xe3, 0x81, 0xc0,
    0x3, 0xe3, 0xb9, 0xc0, 0x3, 0xe3, 0xb9, 0xc0,
    0x3, 0xc3, 0xf9, 0xd0, 0x3, 0xc7, 0xf9, 0xd0,
    0x3, 0xc7, 0x39, 0xd8, 0x7, 0xc7, 0x39, 0xd8,
    0x7, 0x87, 0x39, 0xdc, 0x7, 0x86, 0x39, 0xce,
    0x7, 0x86, 0x39, 0xce, 0x7, 0x7, 0x39, 0xce,
    0xf, 0xd, 0x31, 0xcc, 0xf, 0x89, 0x31, 0xcc,
    0xf, 0x89, 0xb1, 0xc4, 0xf, 0x80, 0xe1, 0xc4,
    0x1f, 0x80, 0xe1, 0xc0, 0x1f, 0x80, 0xe1, 0xc0,
    0x37, 0x80, 0xf9, 0xc1, 0x37, 0x81, 0xbf, 0xfe,
    0x67, 0x83, 0x1f, 0xfe, 0x47, 0x86, 0x7, 0xfe,
    0xc7, 0x8c, 0x0, 0xfe, 0x7, 0x98, 0x0, 0x0,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xff, 0xf8, 0x7, 0x81, 0xff, 0xf8,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xff, 0x78,
    0x7, 0x81, 0xff, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xff, 0xf8,
    0x7, 0x81, 0xff, 0xf8, 0x7, 0x81, 0xc0, 0x78,
    0x7, 0x81, 0xc0, 0x78, 0x7, 0x81, 0xc0, 0x78,

    /* U+507B "偻" */
    0x7, 0x80, 0x38, 0x0, 0x7, 0x90, 0x38, 0x18,
    0x7, 0x98, 0x38, 0x30, 0x7, 0x9c, 0x38, 0x30,
    0x7, 0x8c, 0x38, 0x60, 0x7, 0xe, 0x38, 0xc0,
    0x7, 0xf, 0x39, 0x80, 0x7, 0x7, 0x39, 0x80,
    0xf, 0x6, 0x3b, 0x0, 0xf, 0x2, 0x3e, 0x0,
    0xe, 0x7f, 0xff, 0xfe, 0xe, 0x7f, 0xff, 0xfe,
    0xe, 0x0, 0xfa, 0x0, 0x1e, 0x1, 0xf9, 0x0,
    0x1e, 0x1, 0xf9, 0x0, 0x1e, 0x3, 0xf9, 0x80,
    0x3e, 0x3, 0xb9, 0xc0, 0x3e, 0x7, 0xb8, 0xe0,
    0x3e, 0x7, 0x38, 0xf8, 0x6e, 0xe, 0x38, 0x7e,
    0x6e, 0xc, 0x38, 0x7e, 0xce, 0x18, 0x38, 0x3e,
    0x8e, 0x10, 0x38, 0x1e, 0xe, 0x20, 0xf0, 0xe,
    0xe, 0x60, 0xf0, 0x6, 0xe, 0xc0, 0xe0, 0x0,
    0xe, 0x1, 0xe0, 0x0, 0xe, 0x7f, 0xff, 0xff,
    0xe, 0x7f, 0xff, 0xff, 0xe, 0x3, 0xc1, 0xe0,
    0xe, 0x3, 0xc1, 0xe0, 0xe, 0x3, 0x81, 0xe0,
    0xe, 0x7, 0x83, 0xe0, 0xe, 0x7, 0x83, 0xc0,
    0xe, 0x7, 0x3, 0xc0, 0xe, 0xf, 0x83, 0x80,
    0xe, 0xe, 0x77, 0x80, 0xe, 0x2, 0x3f, 0x0,
    0xe, 0x0, 0x1f, 0x0, 0xe, 0x0, 0x1f, 0xe0,
    0xe, 0x0, 0x7b, 0xfc, 0xe, 0x0, 0xe0, 0xfc,
    0xe, 0x3, 0x80, 0x7c, 0xe, 0x6, 0x0, 0x1e,
    0xe, 0x18, 0x0, 0xe, 0xe, 0x60, 0x0, 0x2,

    /* U+507E "偾" */
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x8f, 0xff, 0xfc, 0x7, 0x8f, 0xff, 0xfc,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x3, 0x9e, 0xf0,
    0x7, 0x3, 0x80, 0xf0, 0x6, 0x3, 0x80, 0xf0,
    0xe, 0x7f, 0xff, 0xff, 0xf, 0x7f, 0xff, 0xff,
    0xf, 0x3, 0x80, 0xf0, 0xf, 0x3, 0x80, 0xf0,
    0xf, 0x3, 0x80, 0xf0, 0x1f, 0x3, 0x80, 0xf0,
    0x1f, 0x3, 0x80, 0xf0, 0x37, 0x0, 0x0, 0x0,
    0x37, 0xf, 0x0, 0x3c, 0x67, 0xf, 0xff, 0xfc,
    0x47, 0xf, 0xff, 0xfc, 0x87, 0xf, 0x0, 0x3c,
    0x7, 0xf, 0x0, 0x3c, 0x7, 0xf, 0x1e, 0x3c,
    0x7, 0xf, 0x1e, 0x3c, 0x7, 0xf, 0x1e, 0x3c,
    0x7, 0xf, 0x1e, 0x3c, 0x7, 0xf, 0x1e, 0x3c,
    0x7, 0xf, 0x1e, 0x3c, 0x7, 0xf, 0x1e, 0x3c,
    0x7, 0xf, 0x1e, 0x3c, 0x7, 0xf, 0x1e, 0x3c,
    0x7, 0xf, 0x1e, 0x38, 0x7, 0xf, 0x3e, 0x38,
    0x7, 0xf, 0x3e, 0x30, 0x7, 0xf, 0x3f, 0x70,
    0x7, 0x0, 0x79, 0xc0, 0x7, 0x0, 0x71, 0xe0,
    0x7, 0x0, 0xf0, 0xfc, 0x7, 0x1, 0xc0, 0x7f,
    0x7, 0x3, 0x80, 0x3e, 0x7, 0x3, 0x0, 0x1e,
    0x7, 0xc, 0x0, 0xe, 0x7, 0x18, 0x0, 0x2,

    /* U+507F "偿" */
    0x3, 0xe0, 0xf, 0x0, 0x1, 0xf0, 0x7, 0x80,
    0x0, 0xf8, 0x83, 0xc0, 0x0, 0x7c, 0x61, 0xe0,
    0xc0, 0x3c, 0x38, 0xf0, 0xe0, 0x1e, 0xe, 0x78,
    0x60, 0xf, 0x7, 0xbc, 0x60, 0x7, 0x1, 0x9e,
    0x30, 0x3, 0x80, 0xcf, 0x30, 0x3, 0xc0, 0x47,
    0xb0, 0x1, 0xc7, 0x83, 0xd8, 0x0, 0xe3, 0xc1,
    0xf8, 0xf0, 0xe1, 0xff, 0xff, 0xf8, 0x7c, 0xff,
    0xff, 0xfc, 0x3e, 0x78, 0x0, 0x1e, 0x3f, 0x3c,
    0x0, 0xf, 0x17, 0x9e, 0x0, 0x4, 0x1b, 0xc0,
    0x0, 0x0, 0x9, 0xe0, 0x0, 0x0, 0x8, 0xf0,
    0x3f, 0xff, 0xc, 0x78, 0x1f, 0xff, 0x80, 0x3c,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x1, 0xe7, 0xff, 0xff, 0xe0,
    0xf3, 0xff, 0xff, 0xf0, 0x78, 0x3, 0xe0, 0x0,
    0x3c, 0x1, 0xf2, 0x0, 0x1e, 0x0, 0xf1, 0x0,
    0xf, 0x0, 0x78, 0x80, 0x7, 0x80, 0x38, 0x60,
    0x3, 0xc0, 0x3c, 0x30, 0x1, 0xe0, 0x1c, 0x18,
    0x0, 0xf0, 0xe, 0xe, 0x0, 0x78, 0xe, 0x7,
    0x0, 0x3c, 0x6, 0x3, 0xc0, 0x1e, 0x6, 0x1,
    0xf0, 0xf, 0x6, 0x3, 0x7c, 0x7, 0x9c, 0xff,
    0x3e, 0x3, 0xc7, 0xff, 0x1f, 0x1, 0xe3, 0xfe,
    0x7, 0x0, 0xf1, 0xfc, 0x1, 0x80, 0x78, 0xe0,
    0x0, 0xc0, 0x3c, 0x0, 0x0, 0x20,

    /* U+5080 "傀" */
    0x3, 0xc0, 0x1f, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x7b, 0xc3, 0x83,
    0xc0, 0x39, 0xe1, 0x1, 0xe0, 0x1c, 0xff, 0xff,
    0xf0, 0xe, 0x7f, 0xff, 0xf8, 0x7, 0x3c, 0x3c,
    0x3c, 0x7, 0x9e, 0x1e, 0x1e, 0x3, 0x8f, 0xf,
    0xf, 0x1, 0xc7, 0x87, 0x87, 0x80, 0xe3, 0xc3,
    0xc3, 0xc0, 0x61, 0xe1, 0xe1, 0xe0, 0x78, 0xf0,
    0xf0, 0xf0, 0x3c, 0x7f, 0xff, 0xf8, 0x1e, 0x3f,
    0xff, 0xfc, 0x1f, 0x1e, 0x1e, 0x1e, 0xf, 0x8f,
    0xf, 0xf, 0xd, 0xc7, 0x87, 0x87, 0x84, 0xe3,
    0xc3, 0xc3, 0xc6, 0x71, 0xe1, 0xe1, 0xe2, 0x38,
    0xf0, 0xf0, 0xf2, 0x1c, 0x7f, 0xff, 0xf8, 0xe,
    0x3f, 0xff, 0xfc, 0x7, 0x1e, 0x3c, 0x1e, 0x3,
    0x8f, 0x1f, 0x8f, 0x1, 0xc0, 0xf, 0xc0, 0x0,
    0xe0, 0x7, 0xe7, 0x0, 0x70, 0x7, 0xf3, 0x80,
    0x38, 0x3, 0xf9, 0xc0, 0x1c, 0x1, 0xfc, 0xe0,
    0xe, 0x1, 0xde, 0x70, 0x7, 0x0, 0xef, 0x78,
    0x3, 0x80, 0x67, 0xb6, 0x1, 0xc0, 0x73, 0xdb,
    0x0, 0xe0, 0x31, 0xf9, 0xc0, 0x70, 0x38, 0xff,
    0xe0, 0x38, 0x18, 0x7f, 0x28, 0x1c, 0x18, 0x3c,
    0x4, 0xe, 0xc, 0x1e, 0x2, 0x7, 0xc, 0xf,
    0x1, 0x3, 0x8c, 0x7, 0x81, 0xc1, 0xc4, 0x3,
    0xc0, 0xe0, 0xe6, 0x1, 0xff, 0xf0, 0x76, 0x0,
    0xff, 0xf0, 0x3a, 0x0, 0x3f, 0xf0,

    /* U+5085 "傅" */
    0x3, 0xc0, 0x1e, 0x40, 0x1, 0xe0, 0xf, 0x3c,
    0x0, 0xf0, 0x7, 0x8e, 0x0, 0x78, 0x3, 0xc7,
    0x0, 0x3c, 0x1, 0xe1, 0x80, 0x1e, 0xff, 0xff,
    0xfc, 0xe, 0x7f, 0xff, 0xfe, 0xf, 0x0, 0x3c,
    0x0, 0x7, 0x80, 0x1e, 0x0, 0x3, 0x87, 0xf,
    0xf, 0x1, 0xc3, 0x87, 0x87, 0x80, 0xe1, 0xff,
    0xff, 0xc0, 0x60, 0xff, 0xff, 0xe0, 0x7c, 0x70,
    0xf0, 0xf0, 0x3e, 0x38, 0x78, 0x78, 0x1f, 0x1c,
    0x3c, 0x3c, 0x1f, 0x8e, 0x1e, 0x1e, 0xf, 0xc7,
    0xff, 0xff, 0x5, 0xe3, 0xff, 0xff, 0x86, 0xf1,
    0xc3, 0xc3, 0xc2, 0x78, 0xe1, 0xe1, 0xe3, 0x3c,
    0x70, 0xf0, 0xf1, 0x1e, 0x38, 0x78, 0x78, 0xf,
    0x1f, 0xff, 0xfc, 0x7, 0x8f, 0xff, 0xfe, 0x3,
    0xc7, 0xf, 0xf, 0x1, 0xe3, 0x87, 0x87, 0x80,
    0xf1, 0xc3, 0xc3, 0xc0, 0x78, 0x0, 0x7, 0x0,
    0x3c, 0x0, 0x3, 0x80, 0x1e, 0x0, 0x1, 0xc0,
    0xf, 0x7f, 0xff, 0xff, 0x7, 0xbf, 0xff, 0xff,
    0x83, 0xc1, 0x0, 0x38, 0x1, 0xe0, 0xc0, 0x1c,
    0x0, 0xf0, 0x30, 0xe, 0x0, 0x78, 0x1e, 0x7,
    0x0, 0x3c, 0x7, 0x83, 0x80, 0x1e, 0x3, 0x81,
    0xc0, 0xf, 0x0, 0xc0, 0xe0, 0x7, 0x80, 0x40,
    0x70, 0x3, 0xc0, 0x0, 0x38, 0x1, 0xe0, 0x0,
    0x3c, 0x0, 0xf0, 0x0, 0x3e, 0x0, 0x78, 0x0,
    0x3e, 0x0, 0x3c, 0x0, 0x7c, 0x0, 0x0, 0x0,
    0x48, 0x0,

    /* U+5088 "傈" */
    0x1, 0xe0, 0x0, 0x0, 0x0, 0xf7, 0xff, 0xff,
    0xc0, 0x7b, 0xff, 0xff, 0xe0, 0x3c, 0x7, 0x38,
    0x0, 0x1c, 0x3, 0x9c, 0x0, 0xe, 0x1, 0xce,
    0x0, 0x7, 0x0, 0xe7, 0x0, 0x7, 0x80, 0x73,
    0x80, 0x3, 0xce, 0x39, 0xc7, 0x1, 0xc7, 0x1c,
    0xe3, 0x80, 0xe3, 0xff, 0xff, 0xc0, 0x71, 0xff,
    0xff, 0xe0, 0x70, 0xe3, 0x9c, 0x70, 0x3c, 0x71,
    0xce, 0x38, 0x1e, 0x38, 0xe7, 0x1c, 0x1f, 0x1c,
    0x73, 0x8e, 0xf, 0x8e, 0x39, 0xc7, 0x7, 0xc7,
    0x1c, 0xe3, 0x87, 0xe3, 0x8e, 0x71, 0xc2, 0xf1,
    0xff, 0xff, 0xe3, 0x78, 0xff, 0xff, 0xf3, 0x3c,
    0x70, 0x0, 0x79, 0x1e, 0x38, 0x0, 0x3c, 0xf,
    0x0, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x0, 0x3,
    0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3, 0xc0, 0x0,
    0xf7, 0xff, 0xff, 0xf0, 0x7b, 0xff, 0xff, 0xf8,
    0x3c, 0x1, 0xfa, 0x0, 0x1e, 0x1, 0xfd, 0x0,
    0xf, 0x0, 0xfe, 0x80, 0x7, 0x80, 0x7f, 0x60,
    0x3, 0xc0, 0x7f, 0xb0, 0x1, 0xe0, 0x3b, 0xcc,
    0x0, 0xf0, 0x39, 0xe7, 0x0, 0x78, 0x1c, 0xf3,
    0xc0, 0x3c, 0x1c, 0x78, 0xf0, 0x1e, 0xc, 0x3c,
    0x7c, 0xf, 0xc, 0x1e, 0x1f, 0x7, 0x8c, 0xf,
    0x7, 0x83, 0xcc, 0x7, 0x81, 0xc1, 0xe4, 0x3,
    0xc0, 0xe0, 0xf4, 0x1, 0xe0, 0x30, 0x78, 0x0,
    0xf0, 0x0, 0x3c, 0x0, 0x78, 0x0,

    /* U+508D "傍" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf8, 0xc, 0x0,
    0x0, 0xf8, 0x7, 0x0, 0x0, 0x7c, 0x1, 0xe0,
    0x0, 0x3e, 0x0, 0xf0, 0x0, 0x1f, 0x0, 0x30,
    0x0, 0xf, 0xbf, 0xff, 0xfe, 0x7, 0x9f, 0xff,
    0xff, 0x7, 0xc0, 0x80, 0x30, 0x3, 0xe0, 0x60,
    0x1c, 0x1, 0xe0, 0x18, 0x1c, 0x0, 0xf0, 0xc,
    0xc, 0x0, 0x70, 0x7, 0xe, 0x0, 0x78, 0x1,
    0xc6, 0x0, 0x3e, 0x38, 0xc7, 0x1e, 0x1f, 0x1c,
    0x23, 0xf, 0xf, 0x8f, 0xff, 0xff, 0x8f, 0xc7,
    0xff, 0xff, 0xc7, 0xe3, 0x82, 0x1, 0xe6, 0xf1,
    0xc1, 0x80, 0xf3, 0x78, 0xe0, 0xe0, 0x7b, 0x3c,
    0x0, 0x78, 0x41, 0x1e, 0x0, 0x1c, 0x1, 0x8f,
    0x0, 0xc, 0x0, 0x7, 0x8f, 0xff, 0xff, 0x83,
    0xc7, 0xff, 0xff, 0xc1, 0xe0, 0x38, 0x0, 0x0,
    0xf0, 0x1c, 0x0, 0x0, 0x78, 0xe, 0x3, 0xc0,
    0x3c, 0x7, 0x1, 0xe0, 0x1e, 0x3, 0xff, 0xf0,
    0xf, 0x1, 0xff, 0xf8, 0x7, 0x80, 0xe0, 0x3c,
    0x3, 0xc0, 0x70, 0x1e, 0x1, 0xe0, 0x38, 0xf,
    0x0, 0xf0, 0x1c, 0x7, 0x80, 0x78, 0xe, 0x3,
    0xc0, 0x3c, 0x7, 0x1, 0xe0, 0x1e, 0x3, 0x80,
    0xf0, 0xf, 0x3, 0xc0, 0x78, 0x7, 0x81, 0xc0,
    0x3c, 0x3, 0xc0, 0xc0, 0x1e, 0x1, 0xe0, 0xe0,
    0xf, 0x0, 0xf0, 0x60, 0x7, 0x80, 0x78, 0x60,
    0x7, 0x80, 0x3c, 0x60, 0x7, 0x0, 0x1e, 0x40,
    0xf, 0x0,

    /* U+5091 "傑" */
    0xf, 0x3c, 0x0, 0xf0, 0x1e, 0x78, 0x1, 0xe0,
    0x3c, 0xf0, 0x3, 0xc0, 0x79, 0xe0, 0x7, 0x80,
    0xf3, 0xde, 0xf, 0x1, 0xe7, 0xbc, 0x1e, 0x3,
    0x8f, 0xff, 0xff, 0x87, 0x1f, 0xff, 0xff, 0xe,
    0x39, 0xe0, 0xf0, 0x1c, 0x63, 0xdd, 0xe0, 0x71,
    0xc7, 0x3b, 0xc0, 0xe3, 0x8e, 0x77, 0x81, 0xc6,
    0x1c, 0xcf, 0x3, 0x8e, 0x71, 0x9e, 0x7, 0x17,
    0xe6, 0x3c, 0xe, 0x6f, 0xcc, 0x78, 0x3c, 0x8f,
    0x3f, 0xfe, 0x7b, 0xc, 0x7f, 0xfc, 0xf0, 0x38,
    0x83, 0xc3, 0xe0, 0x60, 0x7, 0x85, 0xc1, 0x80,
    0xf, 0x1b, 0x86, 0x0, 0x1e, 0x27, 0x18, 0x3c,
    0x3c, 0xe, 0x60, 0x78, 0x78, 0x1d, 0x80, 0xf0,
    0xf0, 0x38, 0x1, 0xe0, 0x0, 0x70, 0x3, 0xc0,
    0x0, 0xef, 0xff, 0xff, 0xf1, 0xdf, 0xff, 0xff,
    0xe3, 0x80, 0x7e, 0x80, 0x7, 0x1, 0xfd, 0x0,
    0xe, 0x3, 0xfb, 0x0, 0x1c, 0x7, 0xf6, 0x0,
    0x38, 0x1f, 0xe6, 0x0, 0x70, 0x3b, 0xce, 0x0,
    0xe0, 0x67, 0x8e, 0x1, 0xc1, 0x8f, 0x1f, 0x3,
    0x86, 0x1e, 0x1f, 0x87, 0x8, 0x3c, 0x3f, 0x8e,
    0x30, 0x78, 0x3e, 0x1c, 0xc0, 0xf0, 0x3c, 0x3b,
    0x1, 0xe0, 0x38, 0x74, 0x3, 0xc0, 0x30, 0xf0,
    0x7, 0x80, 0x21, 0xc0, 0xf, 0x0, 0x3, 0x80,
    0x1e, 0x0, 0x0,

    /* U+5092 "傒" */
    0x3, 0xe0, 0x0, 0x30, 0x3, 0xe0, 0x1, 0xfc,
    0x3, 0xe0, 0xf, 0xfe, 0x3, 0xc0, 0xff, 0xff,
    0x3, 0xcf, 0xf8, 0x0, 0x3, 0xc0, 0xc, 0x4,
    0x3, 0xc4, 0xc, 0xc, 0x3, 0x86, 0x6, 0x8,
    0x7, 0x87, 0x7, 0x18, 0x7, 0x83, 0x86, 0x30,
    0x7, 0x3, 0x82, 0x60, 0x7, 0x3, 0x0, 0x60,
    0x7, 0x1, 0x78, 0x40, 0x7, 0x81, 0x70, 0x78,
    0xf, 0x80, 0xe0, 0x78, 0xf, 0x80, 0xc0, 0x70,
    0xf, 0x81, 0x80, 0xf0, 0x1f, 0x89, 0xf, 0xe0,
    0x1f, 0x87, 0xfd, 0xe0, 0x37, 0x87, 0xe3, 0xe0,
    0x27, 0x8f, 0x7, 0x30, 0x67, 0x80, 0xe, 0x30,
    0xc7, 0x80, 0x18, 0x38, 0x7, 0x80, 0x60, 0x1c,
    0x7, 0x80, 0x80, 0xff, 0x7, 0x9f, 0x1f, 0x8e,
    0x7, 0x8f, 0xfe, 0xe, 0x7, 0x8f, 0xff, 0x4,
    0x7, 0x8f, 0xf, 0x4, 0x7, 0x80, 0xf, 0x2,
    0x7, 0x80, 0xe, 0x0, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1d, 0x0, 0x7, 0x80, 0x1d, 0x0,
    0x7, 0x80, 0x3d, 0x80, 0x7, 0x80, 0x38, 0xc0,
    0x7, 0x80, 0x70, 0xe0, 0x7, 0x80, 0x60, 0x78,
    0x7, 0x80, 0xe0, 0x7f, 0x7, 0x81, 0x80, 0x3f,
    0x7, 0x83, 0x0, 0x1e, 0x7, 0x86, 0x0, 0xe,
    0x7, 0x88, 0x0, 0x6, 0x7, 0xb0, 0x0, 0x2,

    /* U+5096 "傖" */
    0x7, 0x80, 0x78, 0x0, 0xf, 0x1, 0xf0, 0x0,
    0x1e, 0x3, 0xe0, 0x0, 0x3c, 0x7, 0xa0, 0x0,
    0x78, 0x1e, 0x40, 0x0, 0xe0, 0x3c, 0x80, 0x1,
    0xc0, 0x71, 0x80, 0x7, 0x81, 0xe1, 0x0, 0xf,
    0x3, 0x83, 0x0, 0x1c, 0xf, 0x7, 0x0, 0x38,
    0x1c, 0x87, 0x0, 0x70, 0x71, 0x8f, 0x0, 0xc0,
    0xc3, 0x8f, 0x3, 0x83, 0x87, 0x9f, 0x87, 0x8e,
    0x6, 0x1f, 0x8f, 0x3f, 0xc, 0x7e, 0x3e, 0xdf,
    0xff, 0xfc, 0x7f, 0x3f, 0xff, 0xf8, 0xb8, 0x78,
    0x3, 0xd3, 0x70, 0xf0, 0x7, 0x84, 0xe1, 0xff,
    0xef, 0x11, 0xc3, 0xff, 0xde, 0x3, 0x87, 0xff,
    0xbc, 0x7, 0xf, 0x0, 0x78, 0xe, 0x1e, 0x0,
    0xf0, 0x1c, 0x3c, 0x1, 0xe0, 0x38, 0x7f, 0xff,
    0xc0, 0x70, 0xff, 0xff, 0x80, 0xe1, 0xe0, 0xf,
    0x1, 0xc3, 0xc0, 0x0, 0x3, 0x87, 0x0, 0x0,
    0x7, 0xe, 0x0, 0x0, 0xe, 0x3f, 0xff, 0xf0,
    0x1c, 0x7f, 0xff, 0xe0, 0x38, 0xfc, 0x3, 0xc0,
    0x71, 0xf8, 0x7, 0x80, 0xe6, 0xf0, 0xf, 0x1,
    0xcd, 0xe0, 0x1e, 0x3, 0x93, 0xc0, 0x3c, 0x7,
    0x47, 0x80, 0x78, 0xf, 0x8f, 0x0, 0xf0, 0x1e,
    0x1f, 0xff, 0xe0, 0x38, 0x3f, 0xff, 0xc0, 0x70,
    0x78, 0x7, 0x80, 0xe0, 0xf0, 0xf, 0x1, 0xc1,
    0xe0, 0x1e, 0x0,

    /* U+5098 "傘" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x1f, 0x20, 0x0,
    0x0, 0x1e, 0x30, 0x0, 0x0, 0x3e, 0x18, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x78, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0xc0, 0x1, 0xe3, 0xc3, 0xf0,
    0x3, 0xc3, 0xc1, 0xfe, 0x7, 0xf3, 0xc7, 0xfe,
    0xf, 0xe3, 0xc7, 0xfe, 0x19, 0xe3, 0xc7, 0x3c,
    0x71, 0xe3, 0xcf, 0x1c, 0x1, 0xc3, 0xcf, 0x6,
    0x3, 0xe3, 0xcf, 0x82, 0x3, 0xf3, 0xcc, 0xc0,
    0x7, 0x3f, 0xd8, 0xf8, 0x6, 0x1b, 0xd8, 0x70,
    0xc, 0x1b, 0xf0, 0x70, 0x18, 0xb, 0xe0, 0x30,
    0x1, 0xe3, 0xc7, 0x90, 0x1, 0xe3, 0xc7, 0x80,
    0x3, 0xc3, 0xc7, 0x0, 0x3, 0x83, 0xcf, 0x80,
    0x3, 0xc3, 0xce, 0xc0, 0x7, 0x73, 0xcc, 0xf0,
    0x6, 0x7b, 0xcc, 0x78, 0xc, 0x3b, 0xd8, 0x70,
    0x18, 0x1b, 0xd0, 0x30, 0x30, 0x3, 0xe0, 0x10,
    0x0, 0x3, 0xc0, 0x10, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+5099 "備" */
    0x7, 0xc1, 0xe1, 0xc0, 0x7, 0xc1, 0xe1, 0xc0,
    0x7, 0xc1, 0xe1, 0xc0, 0x7, 0x81, 0xe1, 0xc0,
    0x7, 0x81, 0xe1, 0xc0, 0x7, 0x81, 0xe1, 0xc0,
    0x7, 0x9f, 0xff, 0xfe, 0x7, 0x1f, 0xff, 0xfe,
    0xf, 0x1, 0xe1, 0xc0, 0xf, 0x1, 0xe1, 0xc0,
    0xf, 0x1, 0xe1, 0xc0, 0xe, 0x1, 0xe1, 0xc0,
    0xe, 0x1, 0xe1, 0xc0, 0xc, 0x3f, 0xff, 0xff,
    0x1f, 0x3f, 0xff, 0xff, 0x1f, 0x0, 0x0, 0x0,
    0x1f, 0x3, 0xe0, 0x0, 0x3f, 0x3, 0xc0, 0x0,
    0x3f, 0x3, 0xc0, 0x3c, 0x2f, 0x7, 0x80, 0x3c,
    0x6f, 0x7, 0xff, 0xfc, 0x4f, 0x7, 0x1e, 0x3c,
    0xcf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0x1f, 0x1e, 0x3c, 0xf, 0x1f, 0x1e, 0x3c,
    0xf, 0x3f, 0x1e, 0x3c, 0xf, 0x6f, 0xff, 0xfc,
    0xf, 0xcf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0xff, 0xfc,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x3c, 0xf, 0xf, 0x1e, 0x3c,
    0xf, 0xf, 0x1e, 0x38, 0xf, 0xf, 0x1e, 0xe0,
    0x0, 0x0, 0x0, 0x0,

    /* U+509A "傚" */
    0x3, 0x80, 0x0, 0xe0, 0x0, 0xe3, 0x0, 0x38,
    0x0, 0x38, 0x70, 0xe, 0x0, 0xe, 0x1f, 0x3,
    0x80, 0x7, 0x83, 0x80, 0xe0, 0x1, 0xe0, 0xe0,
    0x38, 0x0, 0x70, 0x10, 0xe, 0x0, 0x1d, 0xff,
    0xf3, 0x80, 0x7, 0x7f, 0xfc, 0xc0, 0x1, 0xc0,
    0x0, 0x30, 0x0, 0x60, 0x0, 0xf, 0xfc, 0x38,
    0x79, 0x3, 0xff, 0xe, 0x1e, 0x40, 0xcf, 0x3,
    0xc7, 0x18, 0x73, 0xc0, 0xf1, 0xc2, 0x1c, 0xf0,
    0x7c, 0x60, 0xc6, 0x3c, 0x1f, 0x38, 0x3d, 0x8f,
    0x7, 0xce, 0x3f, 0x63, 0xc3, 0x73, 0xf, 0xd8,
    0xf0, 0xdc, 0x83, 0xfe, 0x3c, 0x27, 0x40, 0xfb,
    0x8f, 0x19, 0xd0, 0x39, 0xe3, 0xc4, 0x71, 0xe,
    0x28, 0xf0, 0x1c, 0xc3, 0x9a, 0x3c, 0x7, 0x18,
    0xe4, 0x8e, 0x1, 0xc3, 0x38, 0x23, 0x80, 0x70,
    0xcc, 0xc, 0xe0, 0x1c, 0x1f, 0x3, 0x38, 0x7,
    0x7, 0xc0, 0xce, 0x1, 0xc0, 0xf0, 0x33, 0x80,
    0x70, 0x1c, 0x5, 0xc0, 0x1c, 0xf, 0x81, 0xf0,
    0x7, 0x3, 0xf0, 0x7c, 0x1, 0xc0, 0xfc, 0x1f,
    0x0, 0x70, 0x67, 0x87, 0x80, 0x1c, 0x19, 0xf0,
    0xe0, 0x7, 0xc, 0x3c, 0x38, 0x1, 0xc3, 0xe,
    0x1f, 0x0, 0x71, 0x81, 0x87, 0xf0, 0x1c, 0x60,
    0x43, 0x7e, 0x7, 0x30, 0x1, 0x8f, 0x81, 0xc8,
    0x0, 0xc1, 0xe0, 0x76, 0x0, 0x60, 0x78, 0x1d,
    0x0, 0x10, 0xe, 0x7, 0x80, 0x8, 0x1, 0x81,
    0xc0, 0x4, 0x0, 0x20,

    /* U+50A2 "傢" */
    0xf, 0x80, 0x20, 0x0, 0x1e, 0x0, 0x60, 0x0,
    0x3c, 0x0, 0x70, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0xf0, 0x1, 0xc0, 0x1, 0xe7, 0x1, 0x83, 0xc3,
    0x8f, 0xff, 0xff, 0x8f, 0x1f, 0xff, 0xff, 0x1e,
    0x38, 0x0, 0x1e, 0x3c, 0x70, 0x0, 0x3c, 0x70,
    0xe0, 0x0, 0x40, 0xe0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x7, 0x7, 0xff, 0xff, 0x8f, 0x8f,
    0xff, 0xff, 0x1f, 0x0, 0x7c, 0x0, 0x3e, 0x0,
    0xf0, 0x0, 0xdc, 0x3, 0xc0, 0x1, 0xb8, 0x7,
    0x0, 0x22, 0x70, 0x1e, 0x0, 0xec, 0xe0, 0x73,
    0x3, 0x11, 0xc1, 0xc7, 0xc, 0x3, 0x86, 0x6,
    0x30, 0x7, 0x19, 0xee, 0xc0, 0xe, 0xc3, 0xdf,
    0x0, 0x1c, 0xf, 0x3e, 0x0, 0x38, 0x1e, 0x76,
    0x0, 0x70, 0x38, 0xec, 0x0, 0xe0, 0xe1, 0xc8,
    0x1, 0xc3, 0xff, 0x98, 0x3, 0x86, 0xf7, 0x30,
    0x7, 0x19, 0xee, 0x70, 0xe, 0x63, 0x9c, 0xf0,
    0x1d, 0x87, 0x39, 0xf0, 0x38, 0x1c, 0x71, 0xf0,
    0x70, 0x30, 0xe3, 0xf0, 0xe0, 0xe1, 0xc3, 0xe1,
    0xc1, 0x83, 0x87, 0x83, 0x86, 0x7, 0x7, 0x7,
    0x18, 0xe, 0xe, 0xe, 0x60, 0x1c, 0xc, 0x1d,
    0x80, 0x38, 0x8, 0x38, 0x0, 0xe0, 0x0, 0x70,
    0x3, 0xc0, 0x0, 0xe0, 0x1e, 0x0, 0x1, 0xc1,
    0xf8, 0x0, 0x0,

    /* U+50A3 "傣" */
    0x3, 0xc0, 0xf, 0x0, 0x0, 0xf0, 0x3, 0xc0,
    0x0, 0x3c, 0x0, 0xf0, 0x0, 0xf, 0x0, 0x3c,
    0x0, 0x3, 0xdf, 0xff, 0xff, 0x0, 0xf7, 0xff,
    0xff, 0xc0, 0x38, 0x0, 0xe0, 0x0, 0xe, 0x0,
    0x38, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x1, 0xe0,
    0x7, 0x80, 0x0, 0x78, 0xff, 0xff, 0xf0, 0x1c,
    0x3f, 0xff, 0xfc, 0x7, 0x0, 0x1c, 0x0, 0x3,
    0xe0, 0xf, 0x0, 0x0, 0xf8, 0x3, 0xc0, 0x0,
    0x3e, 0x0, 0xe0, 0x0, 0x1f, 0x80, 0x38, 0x0,
    0x7, 0xef, 0xff, 0xff, 0xe1, 0xfb, 0xff, 0xff,
    0xf8, 0xde, 0x1, 0xc1, 0x0, 0x27, 0x80, 0xe0,
    0x40, 0x19, 0xe0, 0x30, 0x18, 0x4, 0x78, 0x1c,
    0xf3, 0x0, 0x1e, 0x6, 0x3c, 0xe0, 0x7, 0x83,
    0xf, 0x1e, 0x1, 0xe1, 0x83, 0xc7, 0xf0, 0x78,
    0x40, 0xf0, 0xf8, 0x1e, 0x28, 0x3c, 0x7e, 0x7,
    0x93, 0xe, 0x1b, 0x81, 0xe8, 0xe3, 0xcc, 0xe0,
    0x7c, 0x1c, 0xf6, 0x8, 0x1e, 0x7, 0x3f, 0x0,
    0x7, 0x80, 0x9f, 0xc0, 0x1, 0xe0, 0x7, 0xf0,
    0x0, 0x78, 0x2, 0xf6, 0x0, 0x1e, 0x1, 0xbd,
    0xe0, 0x7, 0x83, 0xcf, 0x3c, 0x1, 0xe7, 0xe3,
    0xcf, 0xc0, 0x78, 0xf8, 0xf1, 0xf0, 0x1e, 0x3c,
    0x3c, 0x3c, 0x7, 0x8c, 0xf, 0x7, 0x1, 0xe0,
    0x3, 0xc0, 0xc0, 0x78, 0x0, 0xf0, 0x0, 0x1e,
    0x0, 0x78, 0x0, 0x7, 0x80, 0x3c, 0x0, 0x1,
    0xe0, 0xfc, 0x0, 0x0,

    /* U+50A5 "傥" */
    0x3, 0xc0, 0x1c, 0x0, 0x3, 0xc0, 0x1c, 0x8,
    0x3, 0xc4, 0x1c, 0x18, 0x3, 0xc2, 0x1c, 0x38,
    0x3, 0xc3, 0x1c, 0x30, 0x3, 0x83, 0x9c, 0x60,
    0x3, 0x83, 0xdc, 0x60, 0x7, 0x81, 0x9c, 0xc0,
    0x7, 0x9d, 0x9c, 0xce, 0x7, 0x1c, 0x9d, 0x8e,
    0x7, 0x1f, 0xff, 0xfe, 0x7, 0x1f, 0xff, 0xfe,
    0x6, 0x1c, 0x0, 0xe, 0xf, 0x1c, 0x0, 0xe,
    0xf, 0x1c, 0x0, 0x8, 0xf, 0x7, 0x80, 0x78,
    0x1f, 0x7, 0x80, 0x78, 0x1f, 0x7, 0xff, 0xf8,
    0x17, 0x7, 0x80, 0x78, 0x37, 0x7, 0x80, 0x78,
    0x27, 0x7, 0x80, 0x78, 0x47, 0x7, 0x80, 0x78,
    0x47, 0x7, 0x80, 0x78, 0x7, 0x7, 0x80, 0x78,
    0x7, 0x7, 0x80, 0x78, 0x7, 0x7, 0xff, 0xf8,
    0x7, 0x7, 0xff, 0xf8, 0x7, 0x7, 0x80, 0x78,
    0x7, 0x7, 0x80, 0x78, 0x7, 0x0, 0xf7, 0x80,
    0x7, 0x0, 0xf7, 0x80, 0x7, 0x0, 0xf7, 0x80,
    0x7, 0x0, 0xf7, 0x80, 0x7, 0x0, 0xf7, 0x80,
    0x7, 0x0, 0xe7, 0x82, 0x7, 0x1, 0xe7, 0x82,
    0x7, 0x1, 0xe7, 0x82, 0x7, 0x1, 0xc7, 0x82,
    0x7, 0x1, 0xc7, 0x82, 0x7, 0x3, 0x87, 0x83,
    0x7, 0x3, 0x7, 0x83, 0x7, 0x7, 0x7, 0x87,
    0x7, 0xe, 0x7, 0xff, 0x7, 0xc, 0x7, 0xff,
    0x7, 0x10, 0x7, 0xfe, 0x7, 0x60, 0x3, 0xfe,

    /* U+50A7 "傧" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf0, 0x6, 0x0,
    0x0, 0x78, 0x3, 0x80, 0x0, 0x3c, 0x0, 0xf0,
    0x0, 0x1c, 0x0, 0x70, 0x0, 0x1e, 0x70, 0x38,
    0x3c, 0xf, 0x3f, 0xff, 0xfe, 0x7, 0x9f, 0xff,
    0xff, 0x3, 0x8e, 0x0, 0x7, 0x81, 0xc7, 0x0,
    0x3, 0xc0, 0xe3, 0x80, 0x1, 0xe0, 0xe1, 0xc0,
    0x1, 0x0, 0x70, 0x0, 0x7, 0x0, 0x30, 0x1e,
    0xf, 0xe0, 0x1e, 0xf, 0x3f, 0xf8, 0x1f, 0x7,
    0xff, 0x0, 0xf, 0x83, 0xc0, 0x0, 0x7, 0xc1,
    0xe0, 0x0, 0x7, 0xe0, 0xf0, 0x0, 0x2, 0xf0,
    0x78, 0x0, 0x3, 0x78, 0x3c, 0x0, 0x1, 0x3c,
    0x1e, 0x0, 0x1, 0x9e, 0xf, 0xff, 0xf8, 0x8f,
    0x7, 0xff, 0xfc, 0x87, 0x83, 0xc1, 0xc0, 0x3,
    0xc1, 0xe0, 0xe0, 0x1, 0xe0, 0xf0, 0x70, 0x0,
    0xf0, 0x78, 0x38, 0x0, 0x78, 0x3c, 0x1c, 0x0,
    0x3c, 0x1e, 0xe, 0x0, 0x1e, 0xf, 0x7, 0x0,
    0xf, 0x7, 0x83, 0x80, 0x7, 0x83, 0xc1, 0xc0,
    0x3, 0xdf, 0xff, 0xff, 0xc1, 0xef, 0xff, 0xff,
    0xe0, 0xf0, 0x0, 0x10, 0x0, 0x78, 0xf, 0x8,
    0x0, 0x3c, 0x7, 0x86, 0x0, 0x1e, 0x7, 0x83,
    0x80, 0xf, 0x3, 0xc0, 0xe0, 0x7, 0x81, 0xc0,
    0x7c, 0x3, 0xc1, 0xc0, 0x1f, 0x81, 0xe0, 0xc0,
    0x7, 0x80, 0xf0, 0xc0, 0x3, 0xc0, 0x78, 0xc0,
    0x0, 0xe0, 0x3c, 0xc0, 0x0, 0x30, 0x1e, 0x80,
    0x0, 0x8,

    /* U+50A8 "储" */
    0x7, 0x80, 0x7, 0x80, 0x3, 0xc0, 0x3, 0xc0,
    0x1, 0xe0, 0x1, 0xe7, 0x80, 0xf0, 0x0, 0xf3,
    0xc0, 0x79, 0x80, 0x79, 0xe0, 0x38, 0xe0, 0x3c,
    0xf0, 0x3c, 0x79, 0xff, 0xf8, 0x1e, 0x1c, 0xff,
    0xfc, 0xf, 0xe, 0x7, 0x9e, 0x7, 0x6, 0x3,
    0xce, 0x3, 0x81, 0x1, 0xe7, 0x1, 0x80, 0x0,
    0xf3, 0x80, 0xc0, 0x0, 0x79, 0x80, 0xf8, 0x0,
    0x3d, 0xc0, 0x7c, 0x78, 0x1e, 0xc0, 0x3f, 0xfd,
    0xff, 0xff, 0x1f, 0xfe, 0xff, 0xff, 0x9f, 0x8f,
    0x0, 0x30, 0xb, 0xc7, 0x80, 0x30, 0xd, 0xe3,
    0xc0, 0x18, 0x4, 0xf1, 0xe0, 0x18, 0x6, 0x78,
    0xf0, 0xc, 0x2, 0x3c, 0x78, 0x7c, 0x78, 0x1e,
    0x3c, 0x3f, 0xfc, 0xf, 0x1e, 0x1f, 0xfe, 0x7,
    0x8f, 0xf, 0xf, 0x3, 0xc7, 0x8f, 0x87, 0x81,
    0xe3, 0xcf, 0xc3, 0xc0, 0xf1, 0xed, 0xe1, 0xe0,
    0x78, 0xfc, 0xf0, 0xf0, 0x3c, 0x78, 0x78, 0x78,
    0x1e, 0x3c, 0x3c, 0x3c, 0xf, 0x1e, 0x1f, 0xfe,
    0x7, 0x8f, 0xf, 0xff, 0x3, 0xc7, 0x8f, 0x87,
    0x81, 0xe3, 0xdb, 0xc3, 0xc0, 0xf1, 0xf9, 0xe1,
    0xe0, 0x7f, 0xf8, 0xf0, 0xf0, 0x3d, 0xf8, 0x78,
    0x78, 0x1e, 0xf0, 0x3c, 0x3c, 0xf, 0x40, 0x1e,
    0x1e, 0x7, 0x80, 0xf, 0xff, 0x3, 0xc0, 0x7,
    0xff, 0x81, 0xe0, 0x3, 0xc3, 0xc0, 0xf0, 0x1,
    0xe1, 0xe0, 0x78, 0x0, 0xf0, 0xf0,

    /* U+50A9 "傩" */
    0x7, 0x80, 0xf, 0x0, 0x3, 0xc0, 0x7, 0x20,
    0x1, 0xe0, 0x3, 0x98, 0x0, 0xf0, 0xe1, 0xce,
    0x0, 0x78, 0x70, 0xe7, 0x80, 0x3b, 0xf8, 0xf1,
    0xc0, 0x3d, 0xfc, 0x78, 0xe0, 0x1e, 0xe, 0x38,
    0x70, 0xf, 0x7, 0x1c, 0x10, 0x7, 0x83, 0x8f,
    0xff, 0x83, 0x81, 0xc7, 0xff, 0xc1, 0xc0, 0xe3,
    0x8e, 0x0, 0xe0, 0x73, 0xc7, 0x0, 0xfc, 0x39,
    0xe3, 0x80, 0x7d, 0x1c, 0xf1, 0xc0, 0x3e, 0x8e,
    0xf8, 0xe0, 0x1f, 0x47, 0x7c, 0x70, 0x1f, 0xb3,
    0xae, 0x38, 0xf, 0xc9, 0xf7, 0x1c, 0x7, 0xe6,
    0xe3, 0xff, 0xe6, 0xf3, 0x71, 0xff, 0xf3, 0x79,
    0xb8, 0xe3, 0x81, 0x3c, 0xfc, 0x71, 0xc0, 0x1e,
    0x3e, 0x38, 0xe0, 0xf, 0x1f, 0x1c, 0x70, 0x7,
    0x8f, 0xe, 0x38, 0x3, 0xc7, 0x87, 0x1c, 0x1,
    0xe1, 0xc3, 0x8e, 0x0, 0xf0, 0xe1, 0xc7, 0x0,
    0x78, 0x70, 0xff, 0xf8, 0x3c, 0x3c, 0x7f, 0xfc,
    0x1e, 0x1e, 0x38, 0xe0, 0xf, 0xf, 0x9c, 0x70,
    0x7, 0x87, 0xce, 0x38, 0x3, 0xc6, 0xe7, 0x1c,
    0x1, 0xe3, 0x7b, 0x8e, 0x0, 0xf1, 0x3d, 0xc7,
    0x0, 0x79, 0x8e, 0xe3, 0x80, 0x3c, 0x87, 0x71,
    0xc0, 0x1e, 0x41, 0x38, 0xe0, 0xf, 0x40, 0x9c,
    0x70, 0x7, 0xa0, 0x4f, 0xff, 0xc3, 0xe0, 0x7,
    0xff, 0xe1, 0xf0, 0x3, 0x80, 0x0, 0xf0, 0x1,
    0xc0, 0x0, 0x78, 0x0, 0xe0, 0x0,

    /* U+50AC "催" */
    0x7, 0xc0, 0xf, 0x0, 0x7, 0xc0, 0xf, 0x0,
    0x7, 0xcf, 0xf, 0xf, 0x7, 0xcf, 0xf, 0xf,
    0x7, 0x8f, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0x7, 0x8f, 0xf, 0xf, 0x7, 0x8f, 0xf, 0xf,
    0xf, 0xf, 0xff, 0xff, 0xf, 0xf, 0xff, 0xff,
    0xf, 0xf, 0x0, 0xf, 0xe, 0xf, 0x0, 0xf,
    0xe, 0x3, 0xe4, 0x0, 0x1f, 0x3, 0xc3, 0x0,
    0x1f, 0x3, 0xc3, 0x80, 0x1f, 0x3, 0xc3, 0x80,
    0x1f, 0x3, 0x81, 0x80, 0x3f, 0x7, 0x81, 0x0,
    0x2f, 0x7, 0xff, 0xff, 0x6f, 0x7, 0xff, 0xff,
    0x4f, 0xf, 0x83, 0x80, 0xcf, 0xf, 0x83, 0x80,
    0xf, 0xf, 0x83, 0x80, 0xf, 0x1f, 0x83, 0x80,
    0xf, 0x1f, 0x83, 0x80, 0xf, 0x37, 0xff, 0xfe,
    0xf, 0x27, 0xff, 0xfe, 0xf, 0x67, 0x83, 0x80,
    0xf, 0x47, 0x83, 0x80, 0xf, 0x7, 0x83, 0x80,
    0xf, 0x7, 0x83, 0x80, 0xf, 0x7, 0x83, 0x80,
    0xf, 0x7, 0x83, 0x80, 0xf, 0x7, 0xff, 0xfe,
    0xf, 0x7, 0xff, 0xfe, 0xf, 0x7, 0x83, 0x80,
    0xf, 0x7, 0x83, 0x80, 0xf, 0x7, 0x83, 0x80,
    0xf, 0x7, 0x83, 0x80, 0xf, 0x7, 0x83, 0x80,
    0xf, 0x7, 0x83, 0x80, 0xf, 0x7, 0xff, 0xff,
    0xf, 0x7, 0xff, 0xff, 0xf, 0x7, 0x80, 0x0,
    0xf, 0x7, 0x80, 0x0, 0xf, 0x7, 0x80, 0x0,

    /* U+50AD "傭" */
    0x0, 0x0, 0x10, 0x0, 0xf, 0x80, 0xc, 0x0,
    0xf, 0x80, 0xf, 0x0, 0xf, 0xb8, 0x7, 0x0,
    0xf, 0x38, 0x6, 0x0, 0xf, 0x3f, 0xff, 0xff,
    0xf, 0x3f, 0xff, 0xff, 0xf, 0x38, 0xf, 0x0,
    0xf, 0x38, 0xf, 0x3c, 0x1e, 0x38, 0xf, 0x3c,
    0x1e, 0x3b, 0xff, 0xfc, 0x1e, 0x3b, 0xff, 0xfc,
    0x1c, 0x3b, 0xff, 0xfc, 0x1c, 0x38, 0xf, 0x3c,
    0x1c, 0x38, 0xf, 0x3c, 0x3e, 0x38, 0xf, 0x3c,
    0x3e, 0x3f, 0xff, 0xff, 0x3e, 0x3f, 0xff, 0xff,
    0x7e, 0x38, 0xf, 0x3c, 0x7e, 0x38, 0xf, 0x3c,
    0x5e, 0x3b, 0xff, 0xfc, 0x9e, 0x3b, 0xff, 0xfc,
    0x1e, 0x38, 0xf, 0x3c, 0x1e, 0x38, 0xf, 0x0,
    0x1e, 0x38, 0xf, 0x0, 0x1e, 0x3b, 0x8f, 0x3c,
    0x1e, 0x3b, 0xff, 0xfc, 0x1e, 0x3b, 0xff, 0xfc,
    0x1e, 0x3b, 0x8f, 0x3c, 0x1e, 0x3b, 0x8f, 0x3c,
    0x1e, 0x3b, 0x8f, 0x3c, 0x1e, 0x3b, 0xff, 0xfc,
    0x1e, 0x3b, 0xff, 0xfc, 0x1e, 0x33, 0x8f, 0x3c,
    0x1e, 0x33, 0x8f, 0x3c, 0x1e, 0x33, 0x8f, 0x3c,
    0x1e, 0x33, 0x8f, 0x3c, 0x1e, 0x33, 0xff, 0xfc,
    0x1e, 0x33, 0xff, 0xfc, 0x1e, 0x63, 0x8f, 0x3c,
    0x1e, 0x63, 0x8f, 0x3c, 0x1e, 0x63, 0x8f, 0x3c,
    0x1e, 0x43, 0x8f, 0x3c, 0x1e, 0xc3, 0x8f, 0x3c,
    0x1e, 0xc3, 0x8f, 0x3c, 0x1e, 0x83, 0x8f, 0x38,
    0x1f, 0x83, 0x8f, 0xe0,

    /* U+50AF "傯" */
    0x3, 0xc0, 0xf, 0x0, 0x0, 0x78, 0x3, 0xe0,
    0x0, 0xf, 0x0, 0x78, 0x0, 0x1, 0xe7, 0x8e,
    0x7, 0x0, 0x3c, 0xf1, 0x0, 0xe0, 0x7, 0x1f,
    0xff, 0xfc, 0x0, 0xe3, 0xc0, 0x3, 0x80, 0x3c,
    0x79, 0xe0, 0x70, 0x7, 0x8f, 0x38, 0xfe, 0x0,
    0xe1, 0xe7, 0x1f, 0xc0, 0x1c, 0x3c, 0xff, 0xb8,
    0x3, 0x87, 0x9f, 0xf7, 0x0, 0xe0, 0xf3, 0x1e,
    0xe0, 0x1f, 0x1e, 0xe3, 0x9c, 0x3, 0xe3, 0xde,
    0x73, 0x80, 0xfc, 0x7e, 0x7c, 0x70, 0x1f, 0x8f,
    0x87, 0x8e, 0x3, 0xf1, 0xe0, 0xfd, 0xc0, 0xde,
    0x3c, 0x33, 0xb8, 0x1b, 0xc7, 0x9c, 0x37, 0x6,
    0x78, 0xf7, 0x2, 0xe1, 0x8f, 0x1f, 0x0, 0x1c,
    0x21, 0xe3, 0xff, 0xff, 0x80, 0x3c, 0x7f, 0xff,
    0xf0, 0x7, 0x8f, 0x0, 0xe, 0x0, 0xf1, 0xe0,
    0x1, 0xc0, 0x1e, 0x0, 0x8, 0x0, 0x3, 0xc0,
    0x0, 0x82, 0x0, 0x78, 0x7, 0x98, 0x40, 0xf,
    0x0, 0xf1, 0x84, 0x1, 0xe3, 0x9e, 0x38, 0x80,
    0x3c, 0x73, 0xc7, 0x98, 0x7, 0x8e, 0x78, 0x73,
    0x0, 0xf1, 0xcf, 0xc, 0x30, 0x1e, 0x39, 0xe0,
    0x86, 0x3, 0xc7, 0x3c, 0x4, 0xe0, 0x78, 0xe7,
    0x80, 0x9c, 0xf, 0x1c, 0xf0, 0x11, 0xc1, 0xe3,
    0x9e, 0x2, 0x38, 0x3c, 0x63, 0xc0, 0x46, 0x7,
    0x8c, 0x78, 0xc, 0x40, 0xf3, 0xf, 0x3, 0x80,
    0x1e, 0x41, 0xff, 0xf0, 0x3, 0xc0, 0x3f, 0xfe,
    0x0, 0x78, 0x7, 0xff, 0xc0, 0xf, 0x0, 0x7f,
    0xf0, 0x0,

    /* U+50B2 "傲" */
    0x3, 0x87, 0x3, 0xc0, 0x1, 0xc3, 0x81, 0xe0,
    0x1, 0xe1, 0xc0, 0xf0, 0x0, 0xf0, 0xe0, 0x78,
    0x0, 0x70, 0x70, 0x3c, 0x0, 0x3f, 0xff, 0xde,
    0x0, 0x1f, 0xff, 0xee, 0x0, 0xe, 0xe, 0x7,
    0x0, 0x7, 0x7, 0x3, 0x80, 0x7, 0x3, 0x81,
    0xc0, 0x3, 0x81, 0xc0, 0xff, 0xe1, 0xdf, 0xfe,
    0xff, 0xf0, 0xcf, 0xff, 0x71, 0xe0, 0xf0, 0x38,
    0x38, 0xf0, 0x78, 0x1c, 0x1c, 0x78, 0x3c, 0xe,
    0xc, 0x3c, 0x3e, 0x7, 0x6, 0x1e, 0x1f, 0x3,
    0x83, 0xf, 0xb, 0xbf, 0xff, 0x87, 0x8d, 0xdf,
    0xff, 0xc3, 0xc4, 0xe3, 0xc0, 0xa1, 0xe6, 0x71,
    0xe0, 0xd0, 0xf2, 0x38, 0xf0, 0x8, 0x78, 0x1c,
    0x78, 0xe4, 0x3c, 0xe, 0x3c, 0x73, 0x1c, 0x7,
    0x1f, 0xf9, 0x8e, 0x3, 0x8f, 0xfc, 0xc7, 0x1,
    0xc7, 0x8e, 0x63, 0x80, 0xe3, 0xc7, 0x11, 0xc0,
    0x71, 0xe3, 0x8c, 0xe0, 0x38, 0xf1, 0xc6, 0xf0,
    0x1c, 0x78, 0xe3, 0x70, 0xe, 0x3c, 0x71, 0xf8,
    0x7, 0x1e, 0x38, 0xfc, 0x3, 0x8f, 0x1c, 0x3c,
    0x1, 0xc7, 0xe, 0x1e, 0x0, 0xe3, 0x87, 0xf,
    0x0, 0x71, 0xc3, 0x87, 0xc0, 0x38, 0xc1, 0xc7,
    0xf0, 0x1c, 0x60, 0xe3, 0x7e, 0xe, 0x60, 0xf3,
    0x1f, 0x87, 0x30, 0x7b, 0xf, 0x83, 0x90, 0x7b,
    0x3, 0xc1, 0xd0, 0x7b, 0x0, 0xe0, 0xe8, 0x7a,
    0x0, 0x30, 0x78, 0xf2, 0x0, 0x8,

    /* U+50B3 "傳" */
    0x7, 0xc0, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0x0, 0x1e, 0x0,
    0xf, 0x1e, 0x1e, 0x1c, 0xf, 0x1e, 0x1e, 0x1c,
    0xe, 0x1f, 0xff, 0xfc, 0xe, 0x1f, 0xff, 0xfc,
    0xe, 0x1e, 0x1e, 0x1c, 0xc, 0x1e, 0x1e, 0x1c,
    0x1f, 0x1e, 0x1e, 0x1c, 0x1f, 0x1f, 0xff, 0xfc,
    0x1f, 0x1f, 0xff, 0xfc, 0x3f, 0x1e, 0x1e, 0x1c,
    0x3f, 0x1e, 0x1e, 0x1c, 0x6f, 0x1e, 0x1e, 0x1c,
    0x6f, 0x1f, 0xff, 0xfc, 0xcf, 0x1f, 0xff, 0xfc,
    0xf, 0x1e, 0x1e, 0x1c, 0xf, 0x1e, 0x1e, 0x9c,
    0xf, 0x0, 0x1e, 0x40, 0xf, 0x0, 0x1e, 0x70,
    0xf, 0x20, 0x1f, 0xbe, 0xf, 0x3f, 0xfe, 0x1e,
    0xf, 0x1f, 0xf8, 0xe, 0xf, 0x1f, 0xc0, 0x7e,
    0xf, 0x3e, 0x0, 0x76, 0xf, 0x0, 0x0, 0x70,
    0xf, 0x7f, 0xff, 0xff, 0xf, 0x7f, 0xff, 0xff,
    0xf, 0x2, 0x0, 0x70, 0xf, 0x1, 0x0, 0x70,
    0xf, 0x1, 0x80, 0x70, 0xf, 0x1, 0xc0, 0x70,
    0xf, 0x0, 0xf0, 0x70, 0xf, 0x0, 0xf0, 0x70,
    0xf, 0x0, 0x60, 0x70, 0xf, 0x0, 0x40, 0x70,
    0xf, 0x0, 0x0, 0x70, 0xf, 0x0, 0x0, 0x70,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0xf, 0x80,

    /* U+50B4 "傴" */
    0xf, 0x38, 0x0, 0x0, 0xf, 0x38, 0x0, 0x0,
    0xf, 0x3f, 0xff, 0xfe, 0xf, 0x3f, 0xff, 0xfe,
    0xf, 0x38, 0x0, 0x0, 0xf, 0x38, 0x0, 0x0,
    0xe, 0x38, 0xf0, 0x70, 0xe, 0x38, 0xff, 0xf0,
    0xe, 0x38, 0xff, 0xf0, 0xe, 0x38, 0xf0, 0x70,
    0x1c, 0x38, 0xf0, 0x70, 0x1c, 0x38, 0xf0, 0x70,
    0x1c, 0x38, 0xf0, 0x70, 0x1e, 0x38, 0xf0, 0x70,
    0x1e, 0x38, 0xf0, 0x70, 0x1e, 0x38, 0xf0, 0x70,
    0x3e, 0x38, 0xff, 0xf0, 0x3e, 0x38, 0xf0, 0x70,
    0x2e, 0x38, 0xf0, 0x70, 0x6e, 0x38, 0x0, 0x0,
    0x4e, 0x38, 0x0, 0x0, 0x4e, 0x3b, 0x9d, 0xce,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x3b, 0xfd, 0xfe,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x3b, 0x9d, 0xce,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x3b, 0x9d, 0xce,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x3b, 0x9d, 0xce,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x3b, 0x9d, 0xce,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x3b, 0x9d, 0xce,
    0xe, 0x3b, 0xfd, 0xfe, 0xe, 0x3b, 0xfd, 0xfe,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x3b, 0x9d, 0xce,
    0xe, 0x3b, 0x9d, 0xce, 0xe, 0x38, 0x0, 0x0,
    0xe, 0x3f, 0xff, 0xff, 0xe, 0x3f, 0xff, 0xff,
    0xe, 0x38, 0x0, 0x0, 0xe, 0x38, 0x0, 0x0,
    0xe, 0x38, 0x0, 0x0,

    /* U+50B5 "債" */
    0x0, 0x0, 0x78, 0x0, 0x1e, 0x0, 0xf0, 0x0,
    0x3c, 0x1, 0xe0, 0x0, 0x78, 0x3, 0xc0, 0x0,
    0xf7, 0xff, 0xff, 0xc1, 0xef, 0xff, 0xff, 0x87,
    0x80, 0x1e, 0x0, 0xf, 0x0, 0x3c, 0x0, 0x1e,
    0x0, 0x78, 0x0, 0x3c, 0x7f, 0xff, 0xf0, 0x70,
    0xff, 0xff, 0xe0, 0xe0, 0x3, 0xc0, 0x1, 0xc0,
    0x7, 0x80, 0x3, 0x0, 0xf, 0x0, 0xf, 0x0,
    0x1e, 0x0, 0x1e, 0x7f, 0xff, 0xff, 0x3c, 0xff,
    0xff, 0xfe, 0x78, 0x0, 0x0, 0x1, 0xf0, 0xe0,
    0x3, 0xc3, 0xe1, 0xff, 0xff, 0x85, 0xc3, 0xff,
    0xff, 0x13, 0x87, 0x0, 0x1e, 0x27, 0xe, 0x0,
    0x3c, 0xe, 0x1c, 0x0, 0x78, 0x1c, 0x3f, 0xfe,
    0xf0, 0x38, 0x7f, 0xfd, 0xe0, 0x70, 0xe0, 0x3,
    0xc0, 0xe1, 0xc0, 0x7, 0x81, 0xc3, 0x80, 0xf,
    0x3, 0x87, 0xff, 0xde, 0x7, 0xf, 0xff, 0xbc,
    0xe, 0x1c, 0x0, 0x78, 0x1c, 0x38, 0x0, 0xf0,
    0x38, 0x70, 0x1, 0xe0, 0x70, 0xff, 0xff, 0xc0,
    0xe1, 0xff, 0xff, 0x81, 0xc3, 0x80, 0xf, 0x3,
    0x87, 0x0, 0x1e, 0x7, 0x1, 0xf1, 0x0, 0xe,
    0x3, 0xc3, 0x0, 0x1c, 0x7, 0x3, 0xc0, 0x38,
    0x1c, 0x3, 0xf8, 0x70, 0x30, 0x7, 0xf0, 0xe0,
    0xc0, 0x3, 0xe1, 0xc6, 0x0, 0x3, 0x83, 0x98,
    0x0, 0x1, 0x0,

    /* U+50B7 "傷" */
    0x7, 0x87, 0xc0, 0x0, 0x7, 0x87, 0x80, 0x0,
    0x7, 0x87, 0x80, 0x0, 0x7, 0x87, 0xff, 0xff,
    0x7, 0x87, 0x0, 0x0, 0x7, 0xf, 0x0, 0x0,
    0x7, 0xe, 0x0, 0x0, 0xf, 0xf, 0x0, 0x38,
    0xf, 0x1f, 0xff, 0xf8, 0xe, 0x1f, 0xff, 0xf8,
    0xe, 0x3f, 0x0, 0x38, 0xe, 0x6f, 0x0, 0x38,
    0xc, 0x4f, 0x0, 0x38, 0x1e, 0x8f, 0xff, 0x38,
    0x1e, 0xf, 0x0, 0x38, 0x1e, 0xf, 0x0, 0x38,
    0x3e, 0xf, 0x0, 0x38, 0x3e, 0xf, 0xff, 0xf8,
    0x2e, 0xf, 0x0, 0x38, 0x6e, 0xf, 0x0, 0x38,
    0x4e, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xe, 0xf, 0x0, 0x0,
    0xe, 0xf, 0x0, 0x0, 0xe, 0xf, 0x0, 0x3c,
    0xe, 0xf, 0x0, 0x3c, 0xe, 0xf, 0xff, 0xfc,
    0xe, 0x1c, 0x0, 0x3c, 0xe, 0x1d, 0xe7, 0xbc,
    0xe, 0x39, 0xe7, 0xbc, 0xe, 0x31, 0xc7, 0xbc,
    0xe, 0x61, 0xc7, 0x3c, 0xe, 0xc3, 0x87, 0x3c,
    0xe, 0x3, 0x8f, 0x3c, 0xe, 0x7, 0xe, 0x3c,
    0xe, 0x6, 0xe, 0x3c, 0xe, 0xc, 0x1c, 0x3c,
    0xe, 0x10, 0x38, 0x3c, 0xe, 0x60, 0x30, 0x3c,
    0xe, 0x0, 0x60, 0x3c, 0xe, 0x0, 0x80, 0x78,
    0xe, 0x3, 0x0, 0xf0, 0xe, 0x4, 0x1, 0xe0,
    0xe, 0x8, 0x7, 0xc0, 0x0, 0x0, 0x8, 0x0,

    /* U+50BA "傺" */
    0x3, 0x8e, 0x72, 0x0, 0x3, 0x8e, 0x72, 0xe,
    0x3, 0x8e, 0x72, 0xe, 0x3, 0x8f, 0xf3, 0xfe,
    0x3, 0x8f, 0xf3, 0xfe, 0x3, 0x8e, 0x73, 0xe,
    0x7, 0x8e, 0x73, 0xe, 0x7, 0x8e, 0x73, 0xe,
    0x7, 0xe, 0x73, 0xe, 0x7, 0x1f, 0x71, 0x8e,
    0x7, 0x1d, 0xf1, 0x8e, 0x6, 0x19, 0x71, 0x8c,
    0xe, 0x18, 0x61, 0xd8, 0xe, 0x30, 0x60, 0xf0,
    0xf, 0x28, 0xe0, 0xe0, 0xf, 0x6e, 0xc0, 0x70,
    0x1f, 0x7, 0xc0, 0x78, 0x1f, 0x3, 0x80, 0x3e,
    0x17, 0x3, 0x0, 0x1f, 0x37, 0x7, 0x0, 0xf,
    0x27, 0xe, 0xff, 0xe7, 0x47, 0x18, 0xff, 0xe3,
    0x47, 0x30, 0x0, 0x1, 0x7, 0x40, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0,
    0x7, 0xf, 0xff, 0xfe, 0x7, 0xf, 0xff, 0xfe,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x80, 0x7, 0x7, 0x1e, 0x80,
    0x7, 0x7, 0x1e, 0x40, 0x7, 0x7, 0x1e, 0x40,
    0x7, 0x7, 0x1e, 0x60, 0x7, 0x7, 0x1e, 0x70,
    0x7, 0xe, 0x1e, 0x38, 0x7, 0xe, 0x1e, 0x3c,
    0x7, 0xe, 0x1e, 0x1e, 0x7, 0x1c, 0x1e, 0x1e,
    0x7, 0x18, 0x1e, 0xe, 0x7, 0x30, 0x1e, 0x6,
    0x7, 0x40, 0x3c, 0x0, 0x7, 0x0, 0x7c, 0x0,
    0x7, 0x1, 0xf0, 0x0,

    /* U+50BB "傻" */
    0x3, 0xe0, 0xf, 0x0, 0x1, 0xf0, 0x7, 0x0,
    0x0, 0xfb, 0xc3, 0x83, 0xc0, 0x7d, 0xe1, 0x81,
    0xe0, 0x3c, 0xff, 0xff, 0xf0, 0x1e, 0x7f, 0xff,
    0xf8, 0xf, 0x3c, 0xf, 0x3c, 0x7, 0x9e, 0x87,
    0x9e, 0x3, 0x8f, 0x23, 0x8f, 0x3, 0xc7, 0x9d,
    0xc7, 0x81, 0xc3, 0xc7, 0xc3, 0xc0, 0xe1, 0xe1,
    0xe1, 0xe0, 0x60, 0xf0, 0x7c, 0xf0, 0x7c, 0x78,
    0x7f, 0x78, 0x3e, 0x3c, 0x67, 0xbc, 0x1f, 0x1e,
    0xe1, 0xde, 0x1f, 0x8f, 0xc0, 0x2f, 0xf, 0xc7,
    0xff, 0xff, 0x8d, 0xe3, 0xc0, 0x13, 0xc6, 0xf1,
    0xe0, 0x9, 0xe2, 0x78, 0x1e, 0x6, 0x3, 0x3c,
    0xe, 0x3, 0x1, 0x1e, 0x7, 0x0, 0xe0, 0xf,
    0x7, 0xf0, 0x38, 0x7, 0x83, 0xf0, 0x7f, 0x83,
    0xc1, 0xb8, 0x3f, 0xc1, 0xe1, 0xbf, 0xff, 0xe0,
    0xf1, 0x9f, 0xff, 0xf0, 0x78, 0x8e, 0x7, 0xb8,
    0x3c, 0x8f, 0x3, 0x84, 0x1e, 0x6, 0x83, 0xc0,
    0xf, 0x6, 0x61, 0xe0, 0x7, 0x83, 0x10, 0xe0,
    0x3, 0xc3, 0xc, 0xf0, 0x1, 0xe1, 0x7, 0x70,
    0x0, 0xf1, 0x81, 0xf0, 0x0, 0x79, 0x80, 0xf8,
    0x0, 0x3d, 0x80, 0x7c, 0x0, 0x1e, 0x0, 0x7f,
    0x0, 0xf, 0x0, 0x7f, 0xe0, 0x7, 0x80, 0x79,
    0xff, 0x3, 0xc0, 0x70, 0x7f, 0xc1, 0xe0, 0x70,
    0x1f, 0xc0, 0xf0, 0x60, 0x3, 0xe0, 0x78, 0xe0,
    0x0, 0xf0, 0x3c, 0xc0, 0x0, 0x18,

    /* U+50BE "傾" */
    0xf, 0x80, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0xf, 0x1, 0xff, 0xfe, 0xf, 0x1, 0xff, 0xfe,
    0xf, 0x38, 0x3, 0xc0, 0xf, 0x38, 0x3, 0x80,
    0xe, 0x38, 0x3, 0x80, 0xe, 0x38, 0x3, 0x0,
    0xe, 0x38, 0x7a, 0x38, 0xe, 0x38, 0x7f, 0xf8,
    0xc, 0x38, 0x7f, 0xf8, 0x1c, 0x38, 0x78, 0x38,
    0x1e, 0x38, 0x78, 0x38, 0x1e, 0x38, 0x78, 0x38,
    0x1e, 0x38, 0x78, 0x38, 0x1e, 0x38, 0x78, 0x38,
    0x3e, 0x3f, 0x7f, 0xb8, 0x3e, 0x3f, 0x7f, 0xb8,
    0x2e, 0x38, 0x78, 0x38, 0x6e, 0x38, 0x78, 0x38,
    0x4e, 0x38, 0x78, 0x38, 0x4e, 0x38, 0x78, 0x38,
    0x8e, 0x38, 0x78, 0x38, 0xe, 0x38, 0x7f, 0xb8,
    0xe, 0x38, 0x7f, 0xb8, 0xe, 0x38, 0x78, 0x38,
    0xe, 0x38, 0x78, 0x38, 0xe, 0x38, 0x78, 0x38,
    0xe, 0x38, 0x78, 0x38, 0xe, 0x38, 0xf8, 0x38,
    0xe, 0x39, 0x78, 0x38, 0xe, 0x3f, 0x7f, 0xf8,
    0xe, 0x3e, 0x7f, 0xf8, 0xe, 0xfc, 0x78, 0x38,
    0xe, 0x78, 0x78, 0x38, 0xe, 0x70, 0x0, 0x80,
    0xe, 0x60, 0x1e, 0xc0, 0xe, 0x40, 0x1e, 0xc0,
    0xe, 0x0, 0x1c, 0x70, 0xe, 0x0, 0x38, 0x7c,
    0xe, 0x0, 0x38, 0x3e, 0xe, 0x0, 0x30, 0x3e,
    0xe, 0x0, 0x60, 0x1e, 0xe, 0x0, 0xc0, 0xc,
    0xe, 0x1, 0x80, 0x4, 0xe, 0x2, 0x0, 0x2,

    /* U+50C2 "僂" */
    0xf, 0x80, 0x38, 0x0, 0xf, 0x80, 0x38, 0x0,
    0xf, 0x80, 0x38, 0x0, 0xf, 0xbc, 0x38, 0x38,
    0xf, 0x3c, 0x38, 0x38, 0xf, 0x3f, 0xff, 0xf8,
    0xf, 0x3c, 0x38, 0x38, 0xf, 0x3c, 0x38, 0x38,
    0xe, 0x3c, 0x38, 0x38, 0xe, 0xff, 0xff, 0xff,
    0xe, 0xff, 0xff, 0xff, 0x1c, 0x3c, 0x38, 0x38,
    0x1c, 0x3c, 0x38, 0x38, 0x1c, 0x3c, 0x38, 0x38,
    0x1e, 0x3c, 0x38, 0x38, 0x1e, 0x3f, 0xff, 0xf8,
    0x3e, 0x3c, 0x38, 0x38, 0x3e, 0x0, 0x38, 0x0,
    0x2e, 0x3c, 0x38, 0x38, 0x6e, 0x3c, 0x38, 0x38,
    0x4e, 0x3f, 0xff, 0xf8, 0xce, 0x3c, 0x38, 0x38,
    0xe, 0x3c, 0x38, 0x38, 0xe, 0x3c, 0x38, 0x38,
    0xe, 0x3c, 0x38, 0x38, 0xe, 0x3f, 0xff, 0xf8,
    0xe, 0x3f, 0xff, 0xf8, 0xe, 0x3c, 0xf0, 0x38,
    0xe, 0x3c, 0xe0, 0x38, 0xe, 0x1, 0xe0, 0x0,
    0xe, 0x1, 0xe0, 0x0, 0xe, 0x1, 0xc0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xe, 0xff, 0xff, 0xff,
    0xe, 0x3, 0x81, 0xe0, 0xe, 0x7, 0x83, 0xc0,
    0xe, 0x7, 0x3, 0xc0, 0xe, 0xf, 0x7, 0x80,
    0xe, 0xe, 0xe7, 0x80, 0xe, 0xe, 0x3f, 0x0,
    0xe, 0x1e, 0x1f, 0xc0, 0xe, 0x0, 0x7b, 0xf0,
    0xe, 0x0, 0xe0, 0xfc, 0xe, 0x3, 0x80, 0x3c,
    0xe, 0xc, 0x0, 0xe, 0xe, 0x70, 0x0, 0x2,

    /* U+50C5 "僅" */
    0x7, 0xc1, 0xc1, 0xe0, 0x7, 0xc1, 0xc1, 0xe0,
    0x7, 0xc1, 0xc1, 0xe0, 0x7, 0xc1, 0xc1, 0xe0,
    0x7, 0x81, 0xc1, 0xe0, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0x81, 0xc1, 0xe0,
    0xf, 0x1, 0xc1, 0xe0, 0xf, 0x1, 0xc1, 0xe0,
    0xf, 0x1, 0xff, 0xe0, 0xe, 0x1, 0xff, 0xe0,
    0xe, 0x1, 0xc1, 0xe0, 0xe, 0x0, 0x0, 0x0,
    0x1f, 0x0, 0x1e, 0x0, 0x1f, 0x1e, 0x1e, 0x1c,
    0x1f, 0x1e, 0x1e, 0x1c, 0x3f, 0x1f, 0xff, 0xfc,
    0x3f, 0x1f, 0xff, 0xfc, 0x2f, 0x1e, 0x1e, 0x1c,
    0x6f, 0x1e, 0x1e, 0x1c, 0x4f, 0x1e, 0x1e, 0x1c,
    0x8f, 0x1e, 0x1e, 0x1c, 0xf, 0x1e, 0x1e, 0x1c,
    0xf, 0x1e, 0x1e, 0x1c, 0xf, 0x1f, 0xff, 0xfc,
    0xf, 0x1f, 0xff, 0xfc, 0xf, 0x1e, 0x1e, 0x1c,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x3f, 0xff, 0xfe, 0xf, 0x3f, 0xff, 0xfe,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x1f, 0xff, 0xfc, 0xf, 0x1f, 0xff, 0xfc,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0xf, 0x7f, 0xff, 0xff, 0xf, 0x7f, 0xff, 0xff,
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,

    /* U+50C7 "僇" */
    0x1, 0xf0, 0x1c, 0xe, 0x3, 0xf0, 0x1c, 0xe,
    0x3, 0xf3, 0xfd, 0xfe, 0x3, 0xe3, 0xfd, 0xfe,
    0x3, 0xe0, 0x1c, 0xe, 0x3, 0xe0, 0x1d, 0xe,
    0x3, 0xc2, 0x1d, 0x8e, 0x3, 0xc3, 0x9d, 0xce,
    0x7, 0xc1, 0x9c, 0xee, 0x7, 0x81, 0xdc, 0xce,
    0x7, 0x81, 0x9c, 0x9e, 0x7, 0x0, 0x3c, 0x3e,
    0xe, 0x0, 0x7c, 0x6e, 0xf, 0x81, 0xdf, 0xce,
    0xf, 0x87, 0x9d, 0x8e, 0x1f, 0x87, 0x1d, 0xe,
    0x1f, 0x80, 0x0, 0x0, 0x37, 0x80, 0x1f, 0x0,
    0x27, 0x80, 0x1f, 0x0, 0x67, 0x80, 0x1f, 0x80,
    0x47, 0x80, 0x3c, 0xc0, 0x87, 0x80, 0x38, 0xe0,
    0x7, 0x80, 0x70, 0x70, 0x7, 0x80, 0xe0, 0x7e,
    0x7, 0x81, 0xc0, 0x3f, 0x7, 0x81, 0x8f, 0x1e,
    0x7, 0x83, 0xe, 0x1e, 0x7, 0x84, 0x1e, 0xe,
    0x7, 0x98, 0x1c, 0x6, 0x7, 0x80, 0x38, 0x0,
    0x7, 0x80, 0x71, 0xe0, 0x7, 0x80, 0x63, 0xc0,
    0x7, 0x80, 0xc3, 0xc0, 0x7, 0x83, 0x7, 0x80,
    0x7, 0x80, 0xf, 0x3c, 0x7, 0x80, 0x1c, 0x3c,
    0x7, 0x80, 0x38, 0x7c, 0x7, 0x80, 0x70, 0x78,
    0x7, 0x80, 0xc0, 0xf0, 0x7, 0x81, 0x1, 0xe0,
    0x7, 0x80, 0x3, 0xc0, 0x7, 0x80, 0x7, 0x0,
    0x7, 0x80, 0x1c, 0x0, 0x7, 0x80, 0x78, 0x0,
    0x7, 0x81, 0xc0, 0x0, 0x7, 0x87, 0x0, 0x0,

    /* U+50C9 "僉" */
    0x0, 0xf, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x3, 0xe4, 0x0, 0x0, 0x7, 0x8c, 0x0, 0x0,
    0xf, 0xc, 0x0, 0x0, 0x3c, 0x1c, 0x0, 0x0,
    0x70, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0, 0x7,
    0x80, 0x1f, 0x0, 0xe, 0x0, 0x1f, 0xc0, 0x3f,
    0xff, 0xff, 0xe0, 0xef, 0xff, 0xdf, 0xc3, 0x0,
    0x0, 0xf, 0xc, 0x0, 0x0, 0xe, 0x30, 0x0,
    0x0, 0xf, 0xdc, 0x38, 0xf0, 0xe0, 0x38, 0x71,
    0xe1, 0xc0, 0x7f, 0xe3, 0xff, 0x80, 0xff, 0xc7,
    0xff, 0x1, 0xc3, 0x8f, 0xe, 0x3, 0x87, 0x1e,
    0x1c, 0x7, 0xe, 0x3c, 0x38, 0xe, 0x1c, 0x78,
    0x70, 0x1c, 0x38, 0xf0, 0xe0, 0x38, 0x71, 0xe1,
    0xc0, 0x70, 0xe3, 0xc3, 0x80, 0xe1, 0xc7, 0xff,
    0x1, 0xff, 0x8f, 0xfe, 0x3, 0xff, 0x1e, 0x1c,
    0x7, 0xe, 0x3c, 0x38, 0xe, 0x1c, 0x78, 0x70,
    0x3, 0xc0, 0x3e, 0x0, 0x7, 0x80, 0x7c, 0x0,
    0xf, 0x0, 0xf0, 0x0, 0x3c, 0x3, 0xe0, 0x0,
    0x7e, 0x7, 0xc0, 0x0, 0xe7, 0x1e, 0x60, 0x1,
    0x8f, 0x38, 0xe0, 0x7, 0xe, 0xe0, 0xfe, 0xc,
    0x9, 0x81, 0xf8, 0x30, 0x6, 0x1, 0xf0, 0xc0,
    0x18, 0x1, 0xc1, 0x0, 0x60, 0x1, 0x86, 0x1,
    0x80, 0x0, 0x80,

    /* U+50CA "僊" */
    0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0, 0x0,
    0x7, 0xdf, 0xff, 0xff, 0x7, 0xdf, 0xff, 0xff,
    0x7, 0x80, 0xe3, 0x80, 0x7, 0x80, 0xe3, 0x80,
    0x7, 0x80, 0xe3, 0x80, 0x7, 0x1c, 0xe3, 0x9e,
    0xf, 0x1c, 0xe3, 0x9e, 0xf, 0x1f, 0xff, 0xfe,
    0xe, 0x1f, 0xff, 0xfe, 0xe, 0x1c, 0xe3, 0x9e,
    0xe, 0x1c, 0xe3, 0x9e, 0xc, 0x1c, 0xe3, 0x9e,
    0x1e, 0x1c, 0xe3, 0x9e, 0x1e, 0x1c, 0xe3, 0x9e,
    0x1e, 0x1f, 0xff, 0xfe, 0x3e, 0x1f, 0xff, 0xfe,
    0x3e, 0x1c, 0x0, 0x1e, 0x2e, 0x1c, 0x78, 0x1e,
    0x6e, 0x0, 0x78, 0x0, 0x4e, 0x0, 0xf0, 0x0,
    0x8e, 0x0, 0xf0, 0x0, 0xe, 0x7f, 0xff, 0xff,
    0xe, 0x7f, 0xff, 0xff, 0xe, 0x1, 0xc1, 0x0,
    0xe, 0x3, 0x81, 0x80, 0xe, 0x3, 0x0, 0xc0,
    0xe, 0x7, 0x1, 0xf0, 0xe, 0xf, 0xff, 0xff,
    0xe, 0x1f, 0xff, 0xff, 0xe, 0x3f, 0x1, 0xfe,
    0xe, 0x6f, 0x1, 0xee, 0xe, 0x8f, 0x1, 0xe6,
    0xe, 0xf, 0x1, 0xe0, 0xe, 0xf, 0x1, 0xe0,
    0xe, 0xf, 0xff, 0xe4, 0xe, 0xf, 0x1, 0xe4,
    0xe, 0xf, 0x1, 0xe4, 0xe, 0xf, 0x0, 0x4,
    0xe, 0xf, 0x0, 0x6, 0xe, 0xf, 0x0, 0xe,
    0xe, 0xf, 0x0, 0xe, 0xe, 0xf, 0xff, 0xfe,
    0xe, 0xf, 0xff, 0xfc, 0xe, 0x7, 0xff, 0xfc,

    /* U+50CE "僎" */
    0x3, 0x9c, 0xf3, 0x9e, 0x3, 0x9c, 0xf3, 0x9e,
    0x3, 0x9f, 0xf3, 0xfe, 0x3, 0x9f, 0xf3, 0xfe,
    0x3, 0x9c, 0xf3, 0x9e, 0x3, 0x9c, 0xf3, 0x9e,
    0x3, 0x9c, 0xf3, 0x9e, 0x7, 0x9c, 0xf3, 0x9e,
    0x7, 0x1c, 0xf3, 0x9e, 0x7, 0x1f, 0xf3, 0xfe,
    0x7, 0x1f, 0xf3, 0xfe, 0x7, 0x1c, 0xfb, 0x80,
    0x6, 0x1c, 0xb, 0x82, 0xe, 0x1c, 0xb, 0x82,
    0xf, 0x1c, 0x1b, 0x81, 0xf, 0x1c, 0x1b, 0x83,
    0x1f, 0x1f, 0xfb, 0xff, 0x1f, 0x1f, 0xfb, 0xff,
    0x17, 0x1f, 0xf1, 0xfe, 0x37, 0x0, 0x0, 0x0,
    0x27, 0x3, 0xc0, 0xe0, 0x47, 0x3, 0xc0, 0xe0,
    0x87, 0x3, 0xc0, 0xe0, 0x7, 0x3, 0xc0, 0xe0,
    0x7, 0x3, 0xc0, 0xe0, 0x7, 0x3f, 0xff, 0xfe,
    0x7, 0x3f, 0xff, 0xfe, 0x7, 0x3, 0xc0, 0xe0,
    0x7, 0x3, 0xc0, 0xe0, 0x7, 0x3, 0xc0, 0xe0,
    0x7, 0x3, 0xc0, 0xe0, 0x7, 0x3, 0xc0, 0xe0,
    0x7, 0x7f, 0xff, 0xff, 0x7, 0x7f, 0xff, 0xff,
    0x7, 0x0, 0x1, 0x0, 0x7, 0x1, 0xe1, 0x0,
    0x7, 0x1, 0xe0, 0x80, 0x7, 0x3, 0xc0, 0x80,
    0x7, 0x3, 0x80, 0xc0, 0x7, 0x7, 0x80, 0xe0,
    0x7, 0x7, 0x0, 0x78, 0x7, 0xe, 0x0, 0x7c,
    0x7, 0xc, 0x0, 0x7c, 0x7, 0x18, 0x0, 0x38,
    0x7, 0x30, 0x0, 0x18, 0x7, 0x60, 0x0, 0xc,

    /* U+50CF "像" */
    0x3, 0xe1, 0xe0, 0x78, 0x1, 0xf0, 0xe0, 0x3c,
    0x0, 0xf8, 0x7f, 0xfe, 0x0, 0x78, 0x7f, 0xfe,
    0x0, 0x3c, 0x38, 0xf, 0x0, 0x1e, 0x1c, 0x7,
    0x0, 0xf, 0xc, 0x7, 0x0, 0xf, 0xe, 0x7,
    0x0, 0x7, 0x87, 0x7, 0xe, 0x3, 0xc7, 0x86,
    0x7, 0x1, 0xc3, 0xff, 0xff, 0x80, 0xe3, 0xff,
    0xff, 0xc0, 0xe3, 0x70, 0xe0, 0xe0, 0x78, 0x38,
    0x70, 0x70, 0x3c, 0x1c, 0x38, 0x38, 0x3e, 0xe,
    0x1c, 0x1c, 0x1f, 0x7, 0xe, 0xe, 0xb, 0x83,
    0xff, 0xff, 0xd, 0xc1, 0xff, 0xff, 0x84, 0xe0,
    0xe3, 0xc1, 0xc4, 0x70, 0x73, 0xc0, 0xe6, 0x38,
    0x3, 0xc0, 0x18, 0x1c, 0x3, 0xf8, 0x1c, 0xe,
    0x3, 0xde, 0x1c, 0x7, 0x3, 0xc7, 0x1c, 0x3,
    0x83, 0xc3, 0xdc, 0x1, 0xc3, 0xff, 0xfc, 0x0,
    0xe3, 0x9e, 0xfc, 0x0, 0x70, 0x1f, 0x7e, 0x0,
    0x38, 0xf, 0x3f, 0x0, 0x1c, 0x7, 0x1e, 0x40,
    0xe, 0x7, 0x8f, 0x20, 0x7, 0x7, 0xff, 0x90,
    0x3, 0x87, 0x3f, 0xcc, 0x1, 0xc3, 0x3d, 0xe6,
    0x0, 0xe3, 0x1e, 0xf3, 0x80, 0x72, 0xe, 0x78,
    0xe0, 0x38, 0xe, 0x3c, 0x7c, 0x1c, 0xe, 0x1e,
    0x3e, 0xe, 0x6, 0xf, 0xe, 0x7, 0x6, 0x7,
    0x87, 0x3, 0x86, 0x3, 0xc1, 0x81, 0xc6, 0x1,
    0xc0, 0x40, 0xe4, 0x1, 0xe0, 0x10, 0x70, 0x3,
    0xe0, 0x0, 0x38, 0xf, 0xe0, 0x0,

    /* U+50D1 "僑" */
    0x3, 0xc0, 0x1, 0xc0, 0x1, 0xe0, 0x3, 0xf8,
    0x0, 0xf0, 0xf, 0xfe, 0x0, 0x70, 0x3f, 0xfc,
    0x0, 0x79, 0xff, 0xc0, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0x1e, 0x0, 0xe0, 0x0, 0xf, 0x0, 0xf0,
    0x0, 0x7, 0x3f, 0xff, 0xff, 0x3, 0x9f, 0xff,
    0xff, 0x83, 0x80, 0x38, 0x40, 0x1, 0xc0, 0x3c,
    0x10, 0x0, 0xe0, 0x3c, 0xe, 0x0, 0x78, 0x1c,
    0x3, 0x80, 0x7c, 0x1e, 0x3, 0xf0, 0x3e, 0x1f,
    0xff, 0xfe, 0x1f, 0x1b, 0xff, 0xff, 0x1f, 0x99,
    0xc0, 0x77, 0x8b, 0xf8, 0xe0, 0x38, 0xcd, 0xe0,
    0x70, 0x1c, 0x4, 0xf0, 0x3f, 0xfe, 0x6, 0x78,
    0x1f, 0xff, 0x2, 0x3c, 0xe, 0x3, 0x80, 0x1e,
    0x7, 0x1, 0xc0, 0xf, 0x0, 0x0, 0x0, 0x7,
    0x8e, 0x0, 0xf, 0x3, 0xc7, 0xff, 0xff, 0x81,
    0xe3, 0x80, 0x3, 0xc0, 0xf1, 0xc0, 0x1, 0xe0,
    0x78, 0xe0, 0x0, 0xf0, 0x3c, 0x73, 0x8e, 0x78,
    0x1e, 0x39, 0xff, 0x3c, 0xf, 0x1c, 0xff, 0x9e,
    0x7, 0x8e, 0x71, 0xcf, 0x3, 0xc7, 0x38, 0xe7,
    0x81, 0xe3, 0x9c, 0x73, 0xc0, 0xf1, 0xce, 0x39,
    0xe0, 0x78, 0xe7, 0x1c, 0xf0, 0x3c, 0x73, 0xfe,
    0x78, 0x1e, 0x39, 0xff, 0x3c, 0xf, 0x1c, 0xe3,
    0x9e, 0x7, 0x8e, 0x71, 0xcf, 0x3, 0xc7, 0x0,
    0x7, 0x81, 0xe3, 0x80, 0x3, 0x80, 0xf1, 0xc0,
    0x7, 0x80, 0x78, 0xe0, 0xf, 0x80, 0x0, 0x0,
    0x0, 0x0,

    /* U+50D5 "僕" */
    0x7, 0x81, 0xc7, 0x0, 0xf, 0x3, 0x8e, 0x0,
    0x1e, 0x7, 0x1c, 0x30, 0x3e, 0xe, 0x38, 0x60,
    0x7a, 0x1c, 0x71, 0x80, 0xf6, 0x38, 0xe3, 0x1,
    0xc6, 0x71, 0xc4, 0x3, 0x8e, 0xe3, 0x98, 0x7,
    0x1d, 0xc7, 0x30, 0xe, 0x13, 0x8e, 0xc0, 0x38,
    0x7, 0x1d, 0x80, 0x73, 0xff, 0xff, 0xf0, 0xe7,
    0xff, 0xff, 0xe1, 0xc0, 0x80, 0x10, 0x3, 0xc1,
    0x80, 0x60, 0xf, 0x81, 0x80, 0xc0, 0x1f, 0x3,
    0x81, 0x0, 0x2e, 0x7, 0x86, 0x0, 0xdc, 0x6,
    0x8, 0x1, 0x38, 0xc, 0x30, 0x2, 0x73, 0xff,
    0xff, 0xc8, 0xe7, 0xff, 0xff, 0x91, 0xc0, 0xe,
    0x0, 0x3, 0x80, 0x1c, 0x0, 0x7, 0x0, 0x38,
    0x0, 0xe, 0x3f, 0xff, 0xf0, 0x1c, 0x7f, 0xff,
    0xe0, 0x38, 0x1, 0xc0, 0x0, 0x70, 0x3, 0x80,
    0x0, 0xe0, 0xf, 0x0, 0x1, 0xc0, 0x1e, 0x0,
    0x3, 0xbf, 0xff, 0xff, 0x7, 0x7f, 0xff, 0xfe,
    0xe, 0x0, 0xf0, 0x0, 0x1c, 0x1, 0xd0, 0x0,
    0x38, 0x3, 0xa0, 0x0, 0x70, 0xe, 0x60, 0x0,
    0xe0, 0x18, 0x60, 0x1, 0xc0, 0x70, 0xe0, 0x3,
    0x81, 0xc0, 0xf0, 0x7, 0x3, 0x1, 0xfc, 0xe,
    0xc, 0x1, 0xf8, 0x1c, 0x30, 0x1, 0xf0, 0x38,
    0xc0, 0x1, 0xe0, 0x73, 0x0, 0x1, 0xc0, 0xec,
    0x0, 0x0, 0x80,

    /* U+50D6 "僖" */
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x7, 0xbf, 0xff, 0xff,
    0x7, 0xbf, 0xff, 0xff, 0x7, 0x0, 0x1e, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x7, 0x0, 0x1e, 0x0,
    0xe, 0x1f, 0xff, 0xfe, 0xe, 0x1f, 0xff, 0xfe,
    0xc, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x1f, 0xf, 0x0, 0x38, 0x1f, 0xf, 0xff, 0xf8,
    0x37, 0xf, 0xff, 0xf8, 0x37, 0xf, 0x0, 0x38,
    0x67, 0xf, 0x0, 0x38, 0x47, 0xf, 0x0, 0x38,
    0xc7, 0xf, 0x0, 0x38, 0x7, 0xf, 0x0, 0x38,
    0x7, 0xf, 0xff, 0xf8, 0x7, 0xf, 0xff, 0xf8,
    0x7, 0xf, 0x0, 0x38, 0x7, 0x2, 0x0, 0x40,
    0x7, 0x3, 0x80, 0x40, 0x7, 0x1, 0xe0, 0xc0,
    0x7, 0x0, 0xc1, 0x80, 0x7, 0x7f, 0xff, 0xff,
    0x7, 0x7f, 0xff, 0xff, 0x7, 0x0, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0, 0x7, 0xe, 0x0, 0x3c,
    0x7, 0xf, 0xff, 0xfc, 0x7, 0xf, 0xff, 0xfc,
    0x7, 0xe, 0x0, 0x3c, 0x7, 0xe, 0x0, 0x3c,
    0x7, 0xe, 0x0, 0x3c, 0x7, 0xe, 0x0, 0x3c,
    0x7, 0xe, 0x0, 0x3c, 0x7, 0xe, 0x0, 0x3c,
    0x7, 0xf, 0xff, 0xfc, 0x7, 0xf, 0xff, 0xfc,
    0x7, 0xe, 0x0, 0x3c, 0x7, 0xe, 0x0, 0x3c,

    /* U+50DA "僚" */
    0x3, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x3d, 0xff, 0xff, 0xf8, 0x1e, 0xff, 0xff,
    0xfc, 0x1e, 0x0, 0xf8, 0x18, 0xf, 0x20, 0x74,
    0x1c, 0x7, 0x88, 0x7b, 0xc, 0x3, 0xc7, 0x38,
    0xcc, 0x1, 0xc3, 0x9c, 0x76, 0x0, 0xe1, 0xdc,
    0x3e, 0x0, 0x60, 0x6e, 0xf, 0x80, 0x7c, 0x3e,
    0x3, 0xe0, 0x3e, 0xe, 0x1, 0xfe, 0x1f, 0xe,
    0x0, 0x7f, 0x1f, 0x8f, 0x80, 0x3f, 0xf, 0xcf,
    0xff, 0xff, 0x85, 0xec, 0xe0, 0xf, 0xc6, 0xfc,
    0x70, 0x7, 0x82, 0x78, 0x38, 0x3, 0xc2, 0x3c,
    0x1f, 0xfd, 0xe3, 0x1e, 0xf, 0xfe, 0xf0, 0xf,
    0x7, 0x0, 0x78, 0x7, 0x83, 0x80, 0x3c, 0x3,
    0xc1, 0xc0, 0x1e, 0x1, 0xe0, 0xe0, 0xf, 0x0,
    0xf0, 0x7f, 0xff, 0x80, 0x78, 0x3f, 0xff, 0xc0,
    0x3c, 0x1c, 0x71, 0xe0, 0x1e, 0x0, 0x38, 0x0,
    0xf, 0x0, 0x1c, 0x80, 0x7, 0x87, 0x8e, 0x40,
    0x3, 0xc3, 0xc7, 0x30, 0x1, 0xe1, 0xe3, 0x98,
    0x0, 0xf0, 0xf1, 0xc6, 0x0, 0x78, 0x70, 0xe3,
    0x80, 0x3c, 0x38, 0x71, 0xe0, 0x1e, 0x38, 0x38,
    0x7c, 0xf, 0x18, 0x1c, 0x3f, 0x7, 0x98, 0xe,
    0xf, 0x3, 0xc8, 0x7, 0x7, 0x81, 0xe8, 0x3,
    0x81, 0xc0, 0xf8, 0x3, 0xc0, 0x60, 0x78, 0x7,
    0xc0, 0x0, 0x3c, 0x1f, 0x80, 0x0,

    /* U+50DC "僜" */
    0x7, 0x80, 0x0, 0x0, 0x1e, 0x3, 0x80, 0x40,
    0x78, 0xe, 0x82, 0x1, 0xc7, 0xf9, 0x10, 0x7,
    0x0, 0xe4, 0x80, 0x1c, 0x3, 0x94, 0x0, 0x70,
    0xe, 0x60, 0x83, 0xc4, 0x39, 0x86, 0xe, 0x18,
    0xe2, 0x30, 0x38, 0x33, 0xd, 0x80, 0xe0, 0xdc,
    0x3c, 0x3, 0x1, 0x70, 0xe0, 0xc, 0x1, 0x81,
    0xc0, 0x70, 0xe, 0x7, 0x1, 0xe0, 0x30, 0xe,
    0x7, 0x81, 0xc0, 0x3c, 0x1e, 0x7, 0xff, 0xf8,
    0xf8, 0x3f, 0xff, 0xf3, 0xe0, 0xc0, 0x3, 0xdb,
    0x86, 0x0, 0xe, 0x6e, 0x30, 0x0, 0x19, 0x39,
    0x3c, 0x7, 0xac, 0xe8, 0xff, 0xfe, 0x3, 0x83,
    0xc0, 0x78, 0xe, 0xf, 0x1, 0xe0, 0x38, 0x3c,
    0x7, 0x80, 0xe0, 0xf0, 0x1e, 0x3, 0x83, 0xc0,
    0x78, 0xe, 0xf, 0x1, 0xe0, 0x38, 0x3f, 0xff,
    0x80, 0xe0, 0xff, 0xfe, 0x3, 0x83, 0xc0, 0x78,
    0xe, 0xf, 0x1, 0xe0, 0x38, 0x0, 0x0, 0x0,
    0xe0, 0x0, 0x8, 0x3, 0x80, 0x80, 0x60, 0xe,
    0x3, 0x1, 0x80, 0x38, 0xe, 0x4, 0x0, 0xe0,
    0x18, 0x30, 0x3, 0x80, 0x70, 0x80, 0xe, 0x1,
    0xc6, 0x0, 0x38, 0x2, 0x18, 0x0, 0xe0, 0x8,
    0x40, 0x3, 0xbf, 0xff, 0xfe, 0xe, 0xff, 0xff,
    0xf8, 0x38, 0x0, 0x0, 0x0,

    /* U+50DE "僞" */
    0x3, 0xe0, 0x0, 0x70, 0x3, 0xc0, 0x3, 0xfc,
    0x3, 0xc0, 0x1f, 0xfe, 0x3, 0xc0, 0xff, 0xfc,
    0x3, 0xdf, 0xf0, 0x0, 0x3, 0x80, 0x20, 0x1c,
    0x7, 0x88, 0x30, 0x18, 0x7, 0x8c, 0x38, 0x38,
    0x7, 0x6, 0x1c, 0x30, 0x7, 0x7, 0x1c, 0x60,
    0x7, 0x7, 0x1c, 0x60, 0xe, 0x3, 0x8, 0x40,
    0xe, 0x1e, 0x1, 0xf0, 0xf, 0x1f, 0xff, 0xf0,
    0xf, 0x1f, 0xff, 0xe0, 0x1f, 0x1e, 0x1, 0xe0,
    0x1f, 0x1e, 0x1, 0xc0, 0x3f, 0x1e, 0x1, 0xfc,
    0x3f, 0x1e, 0x3, 0x7c, 0x2f, 0x1e, 0x2, 0x78,
    0x4f, 0x1f, 0xff, 0xf8, 0x4f, 0x1f, 0xff, 0xf0,
    0xf, 0x1e, 0x0, 0x60, 0xf, 0x1e, 0x0, 0xc0,
    0xf, 0x1e, 0x0, 0x80, 0xf, 0x1e, 0x1, 0x1e,
    0xf, 0x1f, 0xff, 0xfe, 0xf, 0x1f, 0xff, 0xfe,
    0xf, 0x1e, 0x0, 0x1e, 0xf, 0x1c, 0x0, 0x1e,
    0xf, 0x1c, 0x2, 0x1e, 0xf, 0x1f, 0xc9, 0x1e,
    0xf, 0x1f, 0x29, 0x1e, 0xf, 0x1f, 0x29, 0x9e,
    0xf, 0x1b, 0x6d, 0x9e, 0xf, 0x3b, 0x6d, 0xde,
    0xf, 0x3b, 0x6d, 0xfe, 0xf, 0x3b, 0x6d, 0xde,
    0xf, 0x32, 0x6c, 0xde, 0xf, 0x32, 0x4c, 0x9e,
    0xf, 0x34, 0x0, 0x9e, 0xf, 0x60, 0x0, 0x1e,
    0xf, 0x60, 0x0, 0x1e, 0xf, 0x40, 0x0, 0x3c,
    0xf, 0x40, 0x0, 0xf0, 0xf, 0x80, 0x7, 0xc0,

    /* U+50E5 "僥" */
    0xf, 0x0, 0x78, 0x0, 0x1e, 0x0, 0xf0, 0x0,
    0x3c, 0x1, 0xe0, 0x0, 0x78, 0x3, 0xc0, 0x0,
    0xf0, 0x7, 0x80, 0x1, 0xc7, 0xff, 0xff, 0x83,
    0x8f, 0xff, 0xff, 0x7, 0x0, 0x3c, 0x0, 0xe,
    0x0, 0x78, 0x0, 0x1c, 0x0, 0xf0, 0x0, 0x73,
    0xff, 0xff, 0xf8, 0xe7, 0xff, 0xff, 0xf1, 0xc0,
    0xf0, 0x1e, 0x3, 0x81, 0xe0, 0x3c, 0x7, 0x83,
    0xc0, 0x78, 0x1f, 0x7, 0x80, 0xf0, 0x3e, 0xf,
    0x1, 0xe0, 0x7c, 0xff, 0xdf, 0xf9, 0xb9, 0xff,
    0xbf, 0xf3, 0x70, 0x78, 0xf, 0x4, 0xe0, 0xf0,
    0x1e, 0x19, 0xc1, 0xe0, 0x3c, 0x23, 0x83, 0xcc,
    0x78, 0x7, 0x67, 0xf0, 0xf0, 0xe, 0x7f, 0x9f,
    0xfc, 0x1c, 0xfe, 0x3f, 0xf8, 0x39, 0xf0, 0x0,
    0x0, 0x72, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0x1, 0xdf, 0xff, 0xff, 0x83, 0xbf, 0xff, 0xff,
    0x7, 0x3, 0xc3, 0xc0, 0xe, 0x7, 0x87, 0x80,
    0x1c, 0xf, 0xf, 0x0, 0x38, 0x1e, 0x1e, 0x10,
    0x70, 0x3c, 0x3c, 0x20, 0xe0, 0x70, 0x78, 0x41,
    0xc1, 0xe0, 0xf0, 0x83, 0x83, 0x81, 0xe1, 0x7,
    0x7, 0x3, 0xc3, 0xe, 0x1c, 0x7, 0x86, 0x1c,
    0x70, 0xf, 0xfc, 0x38, 0xc0, 0x1f, 0xf8, 0x73,
    0x0, 0x1f, 0xf0, 0xec, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x0,

    /* U+50E6 "僦" */
    0x7, 0x8c, 0x3, 0x80, 0x3, 0xc3, 0x1, 0xc0,
    0x1, 0xe1, 0xe0, 0xe8, 0x0, 0xf0, 0xf0, 0x76,
    0x0, 0x70, 0x38, 0x3b, 0x0, 0x38, 0x8, 0x1c,
    0xc0, 0x3d, 0xff, 0xee, 0x70, 0x1e, 0xff, 0xf7,
    0x3c, 0xf, 0x0, 0x3, 0x9e, 0x7, 0x0, 0x1,
    0xc6, 0x3, 0x80, 0x0, 0xe2, 0x1, 0xcf, 0x1c,
    0x70, 0x1, 0xc7, 0x8e, 0x38, 0x0, 0xf3, 0xff,
    0xff, 0xfc, 0x79, 0xff, 0xff, 0xfe, 0x3c, 0xf1,
    0xc7, 0x70, 0x3e, 0x78, 0xe3, 0xb8, 0x1f, 0x3c,
    0x71, 0xdc, 0xf, 0x9e, 0x38, 0xee, 0x5, 0xcf,
    0x1c, 0x77, 0x6, 0xe7, 0x8e, 0x3b, 0x82, 0x73,
    0xff, 0x1d, 0xc3, 0x39, 0xff, 0x8e, 0xe0, 0x1c,
    0xf1, 0xc7, 0x70, 0xe, 0x0, 0x3, 0xb8, 0x7,
    0x3, 0x81, 0xdc, 0x3, 0x81, 0xd0, 0xee, 0x1,
    0xce, 0xe8, 0x77, 0x0, 0xe7, 0x74, 0x3b, 0x80,
    0x73, 0xba, 0x1d, 0xc0, 0x39, 0xdd, 0x8e, 0xe0,
    0x1c, 0xee, 0xc7, 0x72, 0xe, 0x77, 0x73, 0x39,
    0x7, 0x3b, 0xbd, 0x9c, 0x83, 0x99, 0xdf, 0xce,
    0x41, 0xcc, 0xe6, 0xc7, 0x20, 0xe6, 0x73, 0x63,
    0x90, 0x73, 0x39, 0xb1, 0xc8, 0x3b, 0x1c, 0x70,
    0xe4, 0x1d, 0x8e, 0x18, 0x73, 0xe, 0x87, 0x18,
    0x39, 0x87, 0x43, 0x88, 0x1c, 0xc3, 0xa1, 0xcc,
    0xe, 0x61, 0xc0, 0xe4, 0x7, 0xf0, 0xe0, 0xe4,
    0x3, 0xf0, 0x71, 0xc6, 0x0, 0xf8,

    /* U+50E7 "僧" */
    0x3, 0xc1, 0x0, 0x10, 0x3, 0xc0, 0x80, 0x18,
    0x3, 0xc0, 0xe0, 0x30, 0x3, 0xc0, 0xf0, 0x60,
    0x3, 0xc0, 0x70, 0xc0, 0x3, 0xc0, 0x70, 0xc0,
    0x3, 0xde, 0x21, 0x8f, 0x3, 0x9e, 0x3, 0xf,
    0x7, 0x9f, 0xff, 0xff, 0x7, 0x9f, 0xff, 0xff,
    0x7, 0x1f, 0xe, 0xf, 0x7, 0x1f, 0x8e, 0x1f,
    0xe, 0x1f, 0xce, 0x3f, 0xf, 0x9e, 0xce, 0x7f,
    0xf, 0x9e, 0xee, 0xef, 0x1f, 0x9e, 0xee, 0xcf,
    0x1f, 0x9e, 0x6f, 0x8f, 0x1f, 0x9e, 0x4f, 0xf,
    0x37, 0x9e, 0xe, 0xf, 0x27, 0x9e, 0xe, 0xf,
    0x67, 0x9e, 0xe, 0xf, 0x47, 0x9f, 0xff, 0xff,
    0xc7, 0x9f, 0xff, 0xff, 0x7, 0x9e, 0x0, 0xf,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x87, 0x80, 0x1c, 0x7, 0x87, 0xff, 0xfc,
    0x7, 0x87, 0xff, 0xfc, 0x7, 0x87, 0x80, 0x1c,
    0x7, 0x87, 0x80, 0x1c, 0x7, 0x87, 0x80, 0x1c,
    0x7, 0x87, 0x80, 0x1c, 0x7, 0x87, 0xff, 0x9c,
    0x7, 0x87, 0xff, 0x9c, 0x7, 0x87, 0x80, 0x1c,
    0x7, 0x87, 0x80, 0x1c, 0x7, 0x87, 0x80, 0x1c,
    0x7, 0x87, 0x80, 0x1c, 0x7, 0x87, 0x80, 0x1c,
    0x7, 0x87, 0x80, 0x1c, 0x7, 0x87, 0xff, 0xfc,
    0x7, 0x87, 0xff, 0xfc, 0x7, 0x87, 0x80, 0x1c,
    0x7, 0x87, 0x80, 0x1c, 0x7, 0x87, 0x80, 0x1c,

    /* U+50E8 "僨" */
    0x3, 0x80, 0x1e, 0x0, 0x1, 0xc0, 0xf, 0x0,
    0x0, 0xe0, 0x7, 0x80, 0x0, 0x70, 0x3, 0xc0,
    0x0, 0x7b, 0xff, 0xff, 0xf0, 0x3d, 0xff, 0xff,
    0xf8, 0x1c, 0x0, 0x78, 0x0, 0xe, 0x0, 0x3c,
    0x0, 0x7, 0x7, 0x9e, 0x78, 0x3, 0x83, 0xcf,
    0x3c, 0x1, 0xc1, 0xe0, 0x1e, 0x1, 0xc0, 0xf0,
    0xf, 0x0, 0xe7, 0xff, 0xff, 0xf8, 0x73, 0xff,
    0xff, 0xfc, 0x3c, 0x1e, 0x1, 0xe0, 0x3e, 0xf,
    0x0, 0xf0, 0x1f, 0x7, 0x80, 0x78, 0xf, 0x80,
    0x0, 0x0, 0xf, 0xc7, 0x80, 0x7, 0x5, 0xe3,
    0xff, 0xff, 0x86, 0xf1, 0xff, 0xff, 0xc2, 0x78,
    0xf0, 0x0, 0xe3, 0x3c, 0x78, 0x0, 0x70, 0x1e,
    0x3f, 0xff, 0xb8, 0xf, 0x1f, 0xff, 0xdc, 0x7,
    0x8f, 0x0, 0xe, 0x3, 0xc7, 0x80, 0x7, 0x1,
    0xe3, 0xc0, 0x3, 0x80, 0xf1, 0xff, 0xfd, 0xc0,
    0x78, 0xff, 0xfe, 0xe0, 0x3c, 0x78, 0x0, 0x70,
    0x1e, 0x3c, 0x0, 0x38, 0xf, 0x1e, 0x0, 0x1c,
    0x7, 0x8f, 0xff, 0xfe, 0x3, 0xc7, 0xff, 0xff,
    0x1, 0xe3, 0xc0, 0x3, 0x80, 0xf1, 0xe0, 0x1,
    0xc0, 0x78, 0xf, 0x88, 0x0, 0x3c, 0x7, 0xc6,
    0x0, 0x1e, 0x7, 0xc1, 0xc0, 0xf, 0x3, 0xc0,
    0xfc, 0x7, 0x83, 0x80, 0x3f, 0x83, 0xc3, 0x80,
    0xf, 0x81, 0xe1, 0x80, 0x3, 0xc0, 0xf1, 0x0,
    0x0, 0xe0, 0x7b, 0x0, 0x0, 0x10,

    /* U+50E9 "僩" */
    0x3, 0xc0, 0x0, 0x0, 0x7, 0x81, 0xe7, 0x1c,
    0xf, 0x73, 0xce, 0x38, 0x1e, 0xe7, 0x9c, 0x70,
    0x3d, 0xff, 0x3f, 0xe0, 0x73, 0xfe, 0x7f, 0xc0,
    0xe7, 0x3c, 0xe3, 0x83, 0xce, 0x79, 0xc7, 0x7,
    0x9c, 0xf3, 0x8e, 0xf, 0x3f, 0xe7, 0xfc, 0x1c,
    0x7f, 0xcf, 0xf8, 0x38, 0xe7, 0x9c, 0x70, 0x61,
    0xcf, 0x38, 0xe1, 0xc3, 0x9e, 0x71, 0xc3, 0xc7,
    0x3c, 0xe3, 0x87, 0x8f, 0xf9, 0xff, 0x1f, 0x1c,
    0xf3, 0x8e, 0x3e, 0x39, 0xe7, 0x1c, 0xdc, 0x70,
    0x0, 0x39, 0x38, 0xe7, 0xc, 0x76, 0x71, 0xce,
    0x18, 0xe8, 0xe3, 0x9f, 0xf1, 0xc1, 0xc7, 0x3f,
    0xe3, 0x83, 0x8e, 0x70, 0xc7, 0x7, 0x1c, 0xe1,
    0x8e, 0xe, 0x39, 0xc3, 0x1c, 0x1c, 0x73, 0x86,
    0x38, 0x38, 0xe7, 0xec, 0x70, 0x71, 0xcf, 0xd8,
    0xe0, 0xe3, 0x9c, 0x31, 0xc1, 0xc7, 0x38, 0x63,
    0x83, 0x8e, 0x70, 0xc7, 0x7, 0x1c, 0xfd, 0x8e,
    0xe, 0x39, 0xfb, 0x1c, 0x1c, 0x73, 0x86, 0x38,
    0x38, 0xe7, 0xc, 0x70, 0x71, 0xcc, 0x18, 0xe0,
    0xe3, 0x98, 0x31, 0xc1, 0xc7, 0x30, 0x63, 0x83,
    0x8e, 0xc0, 0xc7, 0x7, 0x1d, 0x81, 0x8e, 0xe,
    0x3b, 0x6, 0x1c, 0x1c, 0x74, 0x38, 0x38, 0x38,
    0xe0, 0x0, 0xe0, 0x71, 0xc0, 0x7, 0x80, 0xe3,
    0x80, 0x7c, 0x0,

    /* U+50EC "僬" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x78, 0x3c, 0x40,
    0x0, 0x1e, 0xf, 0x18, 0x0, 0x7, 0x83, 0xc7,
    0x0, 0x1, 0xe0, 0xf1, 0xe0, 0x0, 0x78, 0x3c,
    0x38, 0x0, 0x1e, 0xf, 0xc, 0x0, 0x7, 0x3,
    0x81, 0x0, 0x3, 0xc1, 0xe0, 0x0, 0x0, 0xf0,
    0x7f, 0xff, 0xe0, 0x3c, 0x1f, 0xff, 0xf8, 0xe,
    0x7, 0x7, 0x0, 0x3, 0x83, 0xc1, 0xc0, 0x1,
    0xc0, 0xf0, 0x70, 0x0, 0x78, 0x3c, 0x1c, 0x0,
    0x1e, 0x1f, 0x7, 0x0, 0xf, 0x87, 0xff, 0xff,
    0x83, 0xe3, 0xff, 0xff, 0xe0, 0xf9, 0xdc, 0x1c,
    0x0, 0x6e, 0xc7, 0x7, 0x0, 0x1b, 0x81, 0xc1,
    0xc0, 0xc, 0xe0, 0x70, 0x70, 0x6, 0x38, 0x1f,
    0xff, 0xf9, 0xe, 0x7, 0xff, 0xfe, 0x3, 0x81,
    0xc1, 0xc0, 0x0, 0xe0, 0x70, 0x70, 0x0, 0x38,
    0x1c, 0x1c, 0x0, 0xe, 0x7, 0x7, 0x0, 0x3,
    0x81, 0xc1, 0xc0, 0x0, 0xe0, 0x70, 0x70, 0x0,
    0x38, 0x1f, 0xff, 0xfc, 0xe, 0x7, 0xff, 0xff,
    0x3, 0x81, 0xc0, 0x0, 0x0, 0xe0, 0x70, 0x2,
    0x0, 0x38, 0x0, 0x0, 0x80, 0xe, 0x0, 0x4,
    0x20, 0x3, 0x83, 0x91, 0xc, 0x0, 0xe0, 0xe4,
    0x63, 0x0, 0x38, 0x39, 0x98, 0xe0, 0xe, 0xe,
    0x67, 0x1c, 0x3, 0x83, 0x9c, 0xe7, 0x80, 0xe0,
    0xe7, 0x39, 0xf0, 0x38, 0x31, 0xcc, 0x7c, 0xe,
    0x1c, 0x22, 0xe, 0x3, 0x86, 0x0, 0x3, 0x80,
    0xe7, 0x0, 0x0, 0x60, 0x39, 0x0, 0x0, 0x0,

    /* U+50ED "僭" */
    0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf, 0x7f, 0xef, 0xff, 0xf, 0x7f, 0xef, 0xff,
    0xf, 0x7, 0x80, 0xe0, 0xf, 0x7, 0x80, 0xe0,
    0xe, 0x3f, 0x8e, 0xe0, 0xe, 0x37, 0x8e, 0xe0,
    0xe, 0x77, 0x8e, 0xe0, 0xe, 0x67, 0x8c, 0xe0,
    0x1c, 0x67, 0x88, 0xe0, 0x1c, 0xc7, 0x88, 0xe0,
    0x1c, 0xff, 0xef, 0xff, 0x1e, 0x87, 0x1, 0xe0,
    0x1e, 0x6, 0x1, 0xc0, 0x1e, 0xf, 0xc1, 0xf0,
    0x3e, 0xf, 0xc3, 0xf1, 0x3e, 0xd, 0xcb, 0xf1,
    0x2e, 0x19, 0xdb, 0x71, 0x6e, 0x11, 0xf6, 0x73,
    0x4e, 0x31, 0xf6, 0x73, 0x4e, 0x67, 0xec, 0x73,
    0x8e, 0x47, 0xd8, 0x7f, 0xe, 0x83, 0x18, 0x7f,
    0xf, 0x0, 0x30, 0x3e, 0xe, 0x0, 0x60, 0x0,
    0xe, 0x1e, 0x0, 0x78, 0xe, 0x1f, 0xff, 0xf8,
    0xe, 0x1f, 0xff, 0xf8, 0xe, 0x1e, 0x0, 0x78,
    0xe, 0x1e, 0x0, 0x78, 0xe, 0x1e, 0x0, 0x78,
    0xe, 0x1e, 0x0, 0x78, 0xe, 0x1e, 0x0, 0x78,
    0xe, 0x1f, 0xfe, 0x78, 0xe, 0x1f, 0xfe, 0x78,
    0xe, 0x1e, 0x0, 0x78, 0xe, 0x1e, 0x0, 0x78,
    0xe, 0x1e, 0x0, 0x78, 0xe, 0x1e, 0x0, 0x78,
    0xe, 0x1e, 0x0, 0x78, 0xe, 0x1e, 0x0, 0x78,
    0xe, 0x1f, 0xff, 0xf8, 0xe, 0x1f, 0xff, 0xf8,
    0xe, 0x1e, 0x0, 0x78, 0xe, 0x1e, 0x0, 0x78,

    /* U+50EE "僮" */
    0x3, 0xe0, 0x8, 0x0, 0x1, 0xf0, 0x7, 0x0,
    0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78, 0x0, 0xe0,
    0x0, 0x3c, 0x0, 0x60, 0x0, 0x1e, 0x7f, 0xff,
    0xf8, 0xf, 0x3f, 0xff, 0xfc, 0x7, 0x1, 0x0,
    0x20, 0x7, 0x80, 0xc0, 0x38, 0x3, 0xc0, 0x78,
    0x38, 0x1, 0xe0, 0x1c, 0x18, 0x0, 0xe0, 0xc,
    0x1c, 0x0, 0x70, 0x2, 0xc, 0x0, 0x7d, 0xff,
    0xff, 0xfc, 0x3e, 0xff, 0xff, 0xfe, 0x1f, 0x0,
    0x0, 0x0, 0x1f, 0x80, 0x0, 0x0, 0xf, 0xc7,
    0x80, 0x7, 0xd, 0xe3, 0xff, 0xff, 0x86, 0xf1,
    0xff, 0xff, 0xc6, 0x78, 0xf0, 0xe0, 0xe2, 0x3c,
    0x78, 0x70, 0x73, 0x1e, 0x3c, 0x38, 0x38, 0xf,
    0x1e, 0x1c, 0x1c, 0x7, 0x8f, 0xff, 0xfe, 0x3,
    0xc7, 0xff, 0xff, 0x1, 0xe3, 0xc3, 0x83, 0x80,
    0xf1, 0xe1, 0xc1, 0xc0, 0x78, 0xf0, 0xe0, 0xe0,
    0x3c, 0x78, 0x70, 0x70, 0x1e, 0x3f, 0xff, 0xf8,
    0xf, 0x1e, 0x1c, 0x1c, 0x7, 0x8f, 0xe, 0xe,
    0x3, 0xc7, 0x87, 0x7, 0x1, 0xe0, 0x3, 0x80,
    0x0, 0xf0, 0x1, 0xc0, 0x0, 0x78, 0xff, 0xff,
    0xe0, 0x3c, 0x7f, 0xff, 0xf0, 0x1e, 0x0, 0x38,
    0x0, 0xf, 0x0, 0x1c, 0x0, 0x7, 0x80, 0xe,
    0x0, 0x3, 0xc0, 0x7, 0x0, 0x1, 0xe0, 0x3,
    0x80, 0x0, 0xf7, 0xff, 0xff, 0xe0, 0x7b, 0xff,
    0xff, 0xf0, 0x3c, 0x0, 0x0, 0x0,

    /* U+50F0 "僰" */
    0x0, 0xe0, 0x1, 0xc0, 0x0, 0x70, 0x0, 0xe0,
    0x0, 0x38, 0x0, 0x70, 0x0, 0x1c, 0x0, 0x38,
    0x0, 0xe, 0x0, 0x1c, 0x3, 0xff, 0xf9, 0xff,
    0xfd, 0xff, 0xfc, 0xff, 0xfe, 0x1, 0xc0, 0x3,
    0x80, 0x0, 0xe0, 0x1, 0xc0, 0xe, 0x73, 0x9c,
    0xe7, 0x7, 0xff, 0xcf, 0xff, 0x83, 0xff, 0xe7,
    0xff, 0xc1, 0xce, 0x73, 0x9c, 0xe0, 0xe7, 0x39,
    0xce, 0x70, 0x73, 0x9c, 0xe7, 0x38, 0x39, 0xce,
    0x73, 0x9c, 0x1c, 0xe7, 0x3b, 0xce, 0xe, 0xf3,
    0x9d, 0xe7, 0x7, 0x79, 0x8e, 0xfb, 0x3, 0xfd,
    0x87, 0xfd, 0x0, 0x3f, 0x0, 0x7d, 0x0, 0x3f,
    0xc0, 0x7e, 0xc0, 0x3b, 0xf0, 0x77, 0x70, 0x19,
    0xdc, 0x33, 0x9c, 0x18, 0xee, 0x31, 0xcf, 0x9c,
    0x73, 0x30, 0xe3, 0x98, 0x39, 0x30, 0x71, 0x88,
    0x1c, 0x30, 0x38, 0x48, 0xe, 0x0, 0x1c, 0x10,
    0x7, 0xf, 0xe, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x1, 0xf4, 0x0,
    0x0, 0x0, 0xf3, 0x0, 0x0, 0x0, 0xf8, 0xc0,
    0x0, 0x0, 0xf8, 0x78, 0x0, 0x0, 0x78, 0x1e,
    0x0, 0x0, 0x78, 0x7, 0xe0, 0x0, 0x70, 0x1,
    0xff, 0x0, 0x70, 0x0, 0x7f, 0x0, 0xe0, 0x0,
    0x1f, 0x80, 0xe0, 0x0, 0x7, 0x81, 0xc0, 0x0,
    0x1, 0xc1, 0x0, 0x0, 0x0, 0x20,

    /* U+50F1 "僱" */
    0x0, 0x0, 0x0, 0x0, 0xf, 0x80, 0xc0, 0x0,
    0x1f, 0x1, 0xc0, 0x0, 0x3e, 0x1, 0xe0, 0x0,
    0x78, 0x3, 0xc0, 0x0, 0xf7, 0x3, 0x87, 0x81,
    0xee, 0x6, 0xf, 0x3, 0xdf, 0xff, 0xfe, 0x7,
    0x3f, 0xff, 0xfc, 0x1e, 0x7f, 0xff, 0xf8, 0x3c,
    0xe0, 0x0, 0xf0, 0x79, 0xc0, 0x1, 0xe0, 0xe3,
    0x80, 0x3, 0xc1, 0xc7, 0x0, 0x7, 0x83, 0x8f,
    0xff, 0xff, 0xf, 0x1f, 0xff, 0xfe, 0x1e, 0x38,
    0x0, 0x3c, 0x3c, 0x70, 0x8, 0x78, 0xf8, 0xe3,
    0xf8, 0x1, 0xf1, 0xc7, 0xdc, 0x3, 0xe3, 0x8f,
    0xbc, 0xf, 0xc7, 0x1e, 0x38, 0x17, 0x8e, 0x3c,
    0x60, 0x6f, 0x1c, 0x78, 0xc0, 0x1e, 0x38, 0xff,
    0xfe, 0x3c, 0x73, 0xff, 0xfc, 0x78, 0xe7, 0x8e,
    0x0, 0xf1, 0xcf, 0x1c, 0x1, 0xe3, 0xbe, 0x38,
    0x3, 0xc7, 0x7c, 0x70, 0x7, 0x8f, 0xff, 0xff,
    0xf, 0x1e, 0xff, 0xfe, 0x1e, 0x3d, 0xe3, 0x80,
    0x3c, 0x73, 0xc7, 0x0, 0x78, 0xe7, 0x8e, 0x0,
    0xf1, 0x8f, 0x1c, 0x1, 0xe3, 0x1f, 0xff, 0xc3,
    0xce, 0x3f, 0xff, 0x87, 0x9c, 0x78, 0xe0, 0xf,
    0x30, 0xf1, 0xc0, 0x1e, 0x61, 0xe3, 0x80, 0x3c,
    0x83, 0xc7, 0x0, 0x7b, 0x7, 0x8e, 0x0, 0xf6,
    0xf, 0xff, 0xf1, 0xe8, 0x1f, 0xff, 0xe3, 0xf0,
    0x3c, 0x0, 0x7, 0xc0, 0x78, 0x0, 0x0,

    /* U+50F3 "僳" */
    0x3, 0xe0, 0x0, 0x0, 0x1, 0xef, 0xff, 0xff,
    0x80, 0xf7, 0xff, 0xff, 0xc0, 0x78, 0xe, 0x70,
    0x0, 0x3c, 0x7, 0x38, 0x0, 0x1e, 0x3, 0x9c,
    0x0, 0xf, 0x1, 0xce, 0x0, 0x7, 0x38, 0xe7,
    0x38, 0x7, 0x9f, 0xff, 0xfc, 0x3, 0xcf, 0xff,
    0xfe, 0x1, 0xc7, 0x1c, 0xe7, 0x0, 0xe3, 0x8e,
    0x73, 0x80, 0x71, 0xc7, 0x39, 0xc0, 0x7c, 0xe3,
    0x9c, 0xe0, 0x3e, 0x71, 0xce, 0x70, 0x1f, 0x38,
    0xe7, 0x38, 0x1f, 0x9c, 0x73, 0x9c, 0xf, 0xcf,
    0xff, 0xfe, 0x5, 0xe7, 0xff, 0xff, 0x6, 0xf3,
    0x80, 0x3, 0x82, 0x78, 0x0, 0x0, 0x3, 0x3c,
    0x0, 0x70, 0x1, 0x1e, 0x10, 0x38, 0x40, 0xf,
    0xe, 0x1c, 0x30, 0x7, 0x83, 0x8e, 0x30, 0x3,
    0xc1, 0xe7, 0x10, 0x1, 0xe0, 0x73, 0x98, 0x0,
    0xf0, 0x11, 0xd8, 0x0, 0x7b, 0xff, 0xff, 0xf0,
    0x3d, 0xff, 0xff, 0xf8, 0x1e, 0x3, 0xfa, 0x0,
    0xf, 0x1, 0xfd, 0x0, 0x7, 0x80, 0xfe, 0xc0,
    0x3, 0xc0, 0xf7, 0x60, 0x1, 0xe0, 0x73, 0xb8,
    0x0, 0xf0, 0x79, 0xde, 0x0, 0x78, 0x38, 0xe7,
    0x80, 0x3c, 0x38, 0x73, 0xe0, 0x1e, 0x18, 0x38,
    0xfe, 0xf, 0x18, 0x1c, 0x3e, 0x7, 0x98, 0xe,
    0x1f, 0x3, 0xc8, 0x7, 0x7, 0x81, 0xe8, 0x3,
    0x80, 0xc0, 0xf8, 0x1, 0xc0, 0x0, 0x78, 0x0,
    0xe0, 0x0, 0x3c, 0x0, 0x70, 0x0,

    /* U+50F5 "僵" */
    0x7, 0x80, 0x0, 0x0, 0x3, 0xdf, 0xff, 0xff,
    0x81, 0xef, 0xff, 0xff, 0xc0, 0xf0, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x38, 0x70, 0x0,
    0xe0, 0x1c, 0x38, 0x0, 0x70, 0xe, 0x1f, 0xff,
    0xf8, 0x7, 0xe, 0x1e, 0x1c, 0x3, 0x7, 0xf,
    0xe, 0x3, 0x83, 0x87, 0x87, 0x1, 0xc1, 0xff,
    0xff, 0x80, 0xe0, 0xff, 0xff, 0xc0, 0x78, 0x70,
    0xf0, 0xe0, 0x3c, 0x38, 0x78, 0x70, 0x3e, 0x1c,
    0x3c, 0x38, 0x1f, 0xf, 0xff, 0xfc, 0xf, 0x87,
    0xff, 0xfe, 0xd, 0xc3, 0x80, 0x7, 0x6, 0xe1,
    0xc0, 0x3, 0x82, 0x70, 0x0, 0x0, 0x3, 0x3b,
    0xff, 0xff, 0xfd, 0x1d, 0xff, 0xff, 0xfe, 0xe,
    0x0, 0x0, 0x0, 0x7, 0x1e, 0x0, 0x1e, 0x3,
    0x8f, 0xff, 0xff, 0x1, 0xc7, 0xff, 0xff, 0x80,
    0xe3, 0xc3, 0xc3, 0xc0, 0x71, 0xe1, 0xe1, 0xe0,
    0x38, 0xf0, 0xf0, 0xf0, 0x1c, 0x78, 0x78, 0x78,
    0xe, 0x3f, 0xff, 0xfc, 0x7, 0x1f, 0xff, 0xfe,
    0x3, 0x8f, 0xf, 0xf, 0x1, 0xc7, 0x87, 0x87,
    0x80, 0xe3, 0xc3, 0xc3, 0xc0, 0x71, 0xe1, 0xe1,
    0xe0, 0x38, 0xff, 0xff, 0xf0, 0x1c, 0x7f, 0xff,
    0xf8, 0xe, 0x3c, 0x0, 0x3c, 0x7, 0x1e, 0x0,
    0x1e, 0x3, 0x80, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xe0, 0x77, 0xff,
    0xff, 0xf0, 0x38, 0x0, 0x0, 0x0,

    /* U+50F9 "價" */
    0xf, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x3e, 0xff, 0xff, 0xf8, 0x7d, 0xff, 0xff, 0xf0,
    0xf0, 0xe, 0x38, 0x1, 0xe0, 0x1c, 0x70, 0x3,
    0xc0, 0x38, 0xe0, 0x7, 0x9e, 0x71, 0xce, 0xf,
    0x3f, 0xff, 0xfc, 0x1c, 0x7f, 0xff, 0xf8, 0x38,
    0xf3, 0x8e, 0x70, 0x71, 0xe7, 0x1c, 0xe1, 0xc3,
    0xce, 0x39, 0xc3, 0xe7, 0x9c, 0x73, 0x87, 0xcf,
    0x38, 0xe7, 0xf, 0x9e, 0x71, 0xce, 0x1f, 0x3c,
    0xe3, 0x9c, 0x7e, 0x7f, 0xff, 0xf8, 0xfc, 0xff,
    0xff, 0xf1, 0x79, 0xe0, 0x0, 0xe6, 0xf1, 0xe0,
    0x3, 0x89, 0xe3, 0xff, 0xff, 0x13, 0xc7, 0xff,
    0xfe, 0x7, 0x8f, 0x0, 0x1c, 0xf, 0x1e, 0x0,
    0x38, 0x1e, 0x3f, 0xfe, 0x70, 0x3c, 0x7f, 0xfc,
    0xe0, 0x78, 0xf0, 0x1, 0xc0, 0xf1, 0xe0, 0x3,
    0x81, 0xe3, 0xc0, 0x7, 0x3, 0xc7, 0xff, 0xce,
    0x7, 0x8f, 0xff, 0x9c, 0xf, 0x1e, 0x0, 0x38,
    0x1e, 0x3c, 0x0, 0x70, 0x3c, 0x7f, 0xff, 0xe0,
    0x78, 0xff, 0xff, 0xc0, 0xf1, 0xe0, 0x3, 0x81,
    0xe3, 0xc0, 0x47, 0x3, 0xc0, 0x3c, 0x40, 0x7,
    0x80, 0xf8, 0xc0, 0xf, 0x1, 0xe0, 0xf0, 0x1e,
    0x7, 0x81, 0xfc, 0x3c, 0x1c, 0x1, 0xf0, 0x78,
    0x30, 0x1, 0xe0, 0xf1, 0x80, 0x1, 0xc1, 0xe6,
    0x0, 0x0, 0x80,

    /* U+50FB "僻" */
    0x3, 0xee, 0x38, 0x40, 0x1, 0xf7, 0x1c, 0x30,
    0x0, 0xf3, 0x8e, 0xc, 0x0, 0x79, 0xff, 0x7,
    0x0, 0x3c, 0xff, 0x83, 0x80, 0x1e, 0x71, 0xc0,
    0xc0, 0xe, 0x38, 0xef, 0xfe, 0x7, 0x1c, 0x77,
    0xff, 0x7, 0x8e, 0x38, 0x0, 0x3, 0x87, 0x1c,
    0x81, 0x81, 0xc3, 0x8e, 0x40, 0xc0, 0xe1, 0xc7,
    0x30, 0xc0, 0x60, 0xe3, 0x88, 0x60, 0x7c, 0x71,
    0xc6, 0x30, 0x3e, 0x38, 0xe3, 0x30, 0x1f, 0x1c,
    0x71, 0xd8, 0xf, 0x8f, 0xf8, 0xcc, 0xf, 0xc7,
    0xfc, 0x24, 0x7, 0xe3, 0x8e, 0x17, 0xe2, 0xf1,
    0xc0, 0xff, 0xf3, 0x78, 0xe0, 0x7, 0x81, 0x3c,
    0x70, 0x3, 0xc1, 0x9e, 0x38, 0x1, 0xe0, 0x8f,
    0x1c, 0x0, 0xf0, 0x7, 0x8e, 0x0, 0x78, 0x3,
    0xc7, 0x9c, 0x3c, 0x1, 0xe7, 0xfe, 0x1e, 0x0,
    0xf3, 0xff, 0xf, 0x0, 0x79, 0xf3, 0xbf, 0xf8,
    0x3c, 0xb9, 0xdf, 0xfc, 0x1e, 0xdc, 0xe1, 0xe0,
    0xf, 0x4e, 0x70, 0xf0, 0x7, 0xe7, 0x38, 0x78,
    0x3, 0xe3, 0x9c, 0x3c, 0x1, 0xe1, 0xce, 0x1e,
    0x0, 0xf0, 0xe7, 0xf, 0x0, 0x78, 0x73, 0x87,
    0x80, 0x3c, 0x39, 0xc3, 0xc0, 0x1e, 0x1c, 0xe1,
    0xe0, 0xf, 0xe, 0x70, 0xf0, 0x7, 0x87, 0xf8,
    0x78, 0x3, 0xc3, 0xfc, 0x3c, 0x1, 0xe1, 0xce,
    0x1e, 0x0, 0xf0, 0xe7, 0xf, 0x0, 0x78, 0x73,
    0x87, 0x80, 0x3c, 0x39, 0xc3, 0xc0,

    /* U+5100 "儀" */
    0x0, 0x2, 0x0, 0x0, 0x7, 0xc3, 0x0, 0x30,
    0x7, 0xc1, 0xc0, 0x60, 0x7, 0xc1, 0xe0, 0xc0,
    0x7, 0xc0, 0xc0, 0xc0, 0x7, 0x80, 0xc1, 0x80,
    0x7, 0x9f, 0xff, 0xfe, 0x7, 0x9f, 0xff, 0xfe,
    0x7, 0x80, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0x7, 0x0, 0x1c, 0x0, 0x7, 0x0, 0x1c, 0x0,
    0xf, 0xf, 0xff, 0xf8, 0xe, 0xf, 0xff, 0xf8,
    0xe, 0x0, 0x1c, 0x0, 0xf, 0x0, 0x1c, 0x0,
    0xf, 0x0, 0x1c, 0x0, 0x1f, 0x3f, 0xff, 0xff,
    0x1f, 0x3f, 0xff, 0xff, 0x1f, 0x0, 0x0, 0x0,
    0x37, 0x0, 0x27, 0x80, 0x27, 0x0, 0xff, 0x80,
    0x67, 0x3, 0xff, 0xb0, 0x47, 0x1f, 0xc3, 0xbc,
    0x7, 0x3, 0xc3, 0x9c, 0x7, 0x3, 0xc3, 0x8c,
    0x7, 0x3, 0xc3, 0x88, 0x7, 0x3f, 0xff, 0xff,
    0x7, 0x3f, 0xff, 0xff, 0x7, 0x3, 0xc3, 0x80,
    0x7, 0x3, 0xc3, 0x80, 0x7, 0x3, 0xc3, 0x9e,
    0x7, 0x3, 0xc3, 0x9e, 0x7, 0x3, 0xc7, 0x9c,
    0x7, 0x3, 0xdb, 0x9c, 0x7, 0x3, 0xf3, 0xbc,
    0x7, 0x3f, 0xc1, 0xfa, 0x7, 0x3f, 0xc1, 0xf2,
    0x7, 0x3f, 0xc1, 0xf2, 0x7, 0x23, 0xc1, 0xe2,
    0x7, 0x3, 0xc1, 0xf2, 0x7, 0x3, 0xc3, 0xfa,
    0x7, 0x3, 0xc6, 0x7f, 0x7, 0x3, 0xcc, 0x3f,
    0x7, 0x7, 0xb0, 0x1f, 0x7, 0x3e, 0x60, 0xf,
    0x7, 0x0, 0x0, 0x3,

    /* U+5102 "儂" */
    0x7, 0xc0, 0xf3, 0x80, 0x3, 0xe0, 0x79, 0xc0,
    0x1, 0xf0, 0x3c, 0xe0, 0x0, 0xf0, 0x1e, 0x70,
    0x0, 0x78, 0xef, 0x38, 0xe0, 0x3c, 0x7f, 0xff,
    0xf0, 0x1e, 0x3f, 0xff, 0xf8, 0xe, 0x1d, 0xe7,
    0x1c, 0x7, 0xe, 0xf3, 0x8e, 0x7, 0x87, 0x79,
    0xc7, 0x3, 0x83, 0xbc, 0xe3, 0x81, 0xc1, 0xff,
    0xff, 0xc0, 0xe0, 0xff, 0xff, 0xe0, 0x60, 0x7f,
    0xff, 0xf0, 0x38, 0x3b, 0xce, 0x38, 0x3c, 0x1d,
    0xe7, 0x1c, 0x1e, 0xe, 0xf3, 0x8e, 0xf, 0x7,
    0x79, 0xc7, 0xf, 0x83, 0xff, 0xff, 0x87, 0xc1,
    0xc0, 0x1, 0xc2, 0xe0, 0x0, 0x0, 0x3, 0x70,
    0xe0, 0x0, 0x1, 0x38, 0x7f, 0xff, 0xfc, 0x1c,
    0x3f, 0xff, 0xfe, 0xe, 0x1c, 0x0, 0x0, 0x7,
    0xe, 0x0, 0x0, 0x3, 0x87, 0x7f, 0xff, 0x1,
    0xc3, 0xbf, 0xff, 0x80, 0xe1, 0xc0, 0x0, 0x0,
    0x70, 0xe0, 0x0, 0x0, 0x38, 0x70, 0x0, 0x0,
    0x1c, 0x3f, 0xff, 0xfe, 0xe, 0x1f, 0xff, 0xff,
    0x7, 0xe, 0xf2, 0x0, 0x3, 0x87, 0x79, 0x1,
    0x81, 0xc3, 0x3c, 0xc1, 0xc0, 0xe1, 0x9e, 0x30,
    0xc0, 0x71, 0xcf, 0x18, 0xc0, 0x38, 0xc7, 0x8f,
    0xe0, 0x1c, 0x63, 0xc3, 0xe0, 0xe, 0x21, 0xe2,
    0xfc, 0x7, 0x30, 0xfe, 0x3f, 0x83, 0x91, 0xfe,
    0xf, 0x81, 0xd0, 0x7e, 0x3, 0xc0, 0xf8, 0x3c,
    0x0, 0x60, 0x70, 0x10, 0x0, 0x0,

    /* U+5104 "億" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18, 0x0,
    0x1, 0xf0, 0x7, 0x0, 0x0, 0xf8, 0x3, 0xc0,
    0x0, 0x7c, 0x0, 0xe0, 0x0, 0x3e, 0x0, 0x70,
    0x0, 0x1e, 0x0, 0x10, 0x0, 0xf, 0x3f, 0xff,
    0xfc, 0x7, 0x9f, 0xff, 0xfe, 0x3, 0xc1, 0x0,
    0x18, 0x3, 0xc0, 0x60, 0xc, 0x1, 0xe0, 0x3c,
    0xc, 0x0, 0xf0, 0xe, 0xe, 0x0, 0x70, 0x7,
    0x6, 0x0, 0x38, 0xff, 0xff, 0xfc, 0x1e, 0x7f,
    0xff, 0xfe, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x7, 0xc3, 0xc0, 0xf, 0x7, 0xe1,
    0xff, 0xff, 0x83, 0xf0, 0xff, 0xff, 0xc1, 0x78,
    0x78, 0x1, 0xe1, 0x3c, 0x3c, 0x0, 0xf0, 0x9e,
    0x1e, 0x0, 0x78, 0xf, 0xf, 0xff, 0xbc, 0x7,
    0x87, 0xff, 0xde, 0x3, 0xc3, 0xc0, 0xf, 0x1,
    0xe1, 0xe0, 0x7, 0x80, 0xf0, 0xf0, 0x3, 0xc0,
    0x78, 0x7f, 0xff, 0xe0, 0x3c, 0x3f, 0xff, 0xf0,
    0x1e, 0x1e, 0x0, 0x78, 0xf, 0xf, 0x0, 0x3c,
    0x7, 0x87, 0x84, 0x1e, 0x3, 0xc0, 0x7b, 0x0,
    0x1, 0xe7, 0xbd, 0xc2, 0x0, 0xf3, 0xde, 0x71,
    0x80, 0x79, 0xef, 0x38, 0xe0, 0x3c, 0xf7, 0x9d,
    0x38, 0x1e, 0x7b, 0xc6, 0x9e, 0xf, 0x39, 0xe2,
    0x47, 0x7, 0x9c, 0xf0, 0x23, 0x83, 0xce, 0x78,
    0x18, 0xc1, 0xe6, 0x3c, 0x1c, 0x40, 0xf6, 0x1f,
    0xfe, 0x0, 0x7a, 0xf, 0xff, 0x0, 0x3c, 0x3,
    0xff, 0x80, 0x1e, 0x0, 0x0, 0x0,

    /* U+5105 "儅" */
    0x3, 0xc0, 0x1e, 0x0, 0x7, 0x80, 0x3c, 0x0,
    0xf, 0x10, 0x78, 0xc0, 0x1e, 0x10, 0xf1, 0x80,
    0x3c, 0x31, 0xe2, 0x0, 0xf0, 0x7b, 0xcc, 0x1,
    0xe0, 0x77, 0x98, 0x3, 0xc0, 0xcf, 0x20, 0x7,
    0x9c, 0x9e, 0xce, 0xe, 0x3f, 0xff, 0xfc, 0x3c,
    0x7f, 0xff, 0xf8, 0x70, 0xe0, 0x0, 0x70, 0xe1,
    0xc0, 0x0, 0xe1, 0xe3, 0xb8, 0x1c, 0x7, 0xc0,
    0x70, 0x38, 0xf, 0x80, 0xff, 0xf0, 0x3f, 0x1,
    0xff, 0xe0, 0x6e, 0x3, 0x81, 0xc0, 0x9c, 0x7,
    0x3, 0x83, 0x38, 0xe, 0x7, 0x4, 0x70, 0x1c,
    0xe, 0x18, 0xe0, 0x3f, 0xfc, 0x1, 0xc0, 0x7f,
    0xf8, 0x3, 0x80, 0xe0, 0x70, 0x7, 0x1, 0xc0,
    0xe0, 0xe, 0x0, 0x0, 0x0, 0x1c, 0x3c, 0x0,
    0xe0, 0x38, 0x78, 0x1, 0xc0, 0x70, 0xff, 0xff,
    0x80, 0xe1, 0xff, 0xff, 0x1, 0xc3, 0xc7, 0x8e,
    0x3, 0x87, 0x8f, 0x1c, 0x7, 0xf, 0x1e, 0x38,
    0xe, 0x1e, 0x3c, 0x70, 0x1c, 0x3f, 0xff, 0xe0,
    0x38, 0x7f, 0xff, 0xc0, 0x70, 0xf1, 0xe3, 0x80,
    0xe1, 0xe3, 0xc7, 0x1, 0xc3, 0xc7, 0x8e, 0x3,
    0x87, 0x8f, 0x1c, 0x7, 0xf, 0x1e, 0x38, 0xe,
    0x1f, 0xff, 0xf0, 0x1c, 0x3f, 0xff, 0xe0, 0x38,
    0x78, 0x1, 0xc0, 0x70, 0xf0, 0x3, 0x80, 0xe1,
    0xe0, 0x7, 0x0,

    /* U+5106 "儆" */
    0x7, 0x8c, 0x70, 0xf0, 0x3, 0xc6, 0x38, 0x78,
    0x1, 0xe3, 0x1c, 0x3c, 0x0, 0xf1, 0x8e, 0x1e,
    0x0, 0x78, 0xc7, 0xf, 0x0, 0x38, 0x63, 0x87,
    0x80, 0x1d, 0xff, 0xfb, 0xc0, 0xe, 0xff, 0xfd,
    0xe0, 0x7, 0xc, 0x70, 0xe0, 0x3, 0x86, 0x38,
    0x7f, 0xc3, 0x83, 0x1c, 0x3f, 0xe1, 0xc1, 0x8e,
    0x19, 0xc0, 0xe0, 0x0, 0x1c, 0xe0, 0x78, 0xf0,
    0xc, 0x70, 0x3c, 0x70, 0x6, 0x38, 0x3e, 0x38,
    0x3a, 0x1c, 0x1f, 0x1f, 0xfd, 0xe, 0xf, 0x8f,
    0xff, 0x87, 0xd, 0xc7, 0x7, 0xc3, 0x86, 0xe3,
    0x3, 0xa1, 0xc2, 0x73, 0x81, 0xd0, 0xe3, 0x39,
    0x80, 0xe8, 0x71, 0x1c, 0xc0, 0x74, 0x38, 0xe,
    0xf3, 0xba, 0x1c, 0x7, 0x7f, 0xdc, 0x8e, 0x3,
    0xdf, 0xee, 0x47, 0x1, 0xce, 0x77, 0x23, 0x80,
    0xe7, 0x3b, 0x93, 0xc0, 0x73, 0x9d, 0xc9, 0xe0,
    0x39, 0xce, 0xe6, 0xe0, 0x1c, 0xe7, 0x73, 0x70,
    0xe, 0x73, 0xb8, 0xb8, 0x7, 0x39, 0xdc, 0x7c,
    0x3, 0x9c, 0xee, 0x3c, 0x1, 0xce, 0x77, 0x1e,
    0x0, 0xe7, 0xfb, 0x8f, 0x0, 0x73, 0xfd, 0xc3,
    0x80, 0x39, 0xce, 0xe3, 0xe0, 0x1c, 0xe7, 0x71,
    0xf8, 0xe, 0x73, 0xb9, 0xbe, 0x7, 0x0, 0x1c,
    0xcf, 0x83, 0x80, 0x1e, 0xc3, 0x81, 0xc0, 0xe,
    0xc1, 0xc0, 0xe0, 0xe, 0x40, 0x60, 0x70, 0x1e,
    0x40, 0x10, 0x38, 0x34, 0x60, 0x0,

    /* U+5107 "儇" */
    0x3, 0xdc, 0x0, 0x1e, 0x3, 0xdf, 0xff, 0xfe,
    0x3, 0x9f, 0xff, 0xfe, 0x3, 0x9c, 0x63, 0x9e,
    0x3, 0x9c, 0x63, 0x9e, 0x3, 0x9c, 0x63, 0x9e,
    0x3, 0x9c, 0x63, 0x9e, 0x3, 0x1c, 0x63, 0x9e,
    0x7, 0x1c, 0x63, 0x9e, 0x7, 0x1c, 0x63, 0x9e,
    0x6, 0x1f, 0xff, 0xfe, 0x6, 0x1f, 0xff, 0xfe,
    0xe, 0x1c, 0x0, 0x1e, 0xf, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x1f, 0x7f, 0xff, 0xff,
    0x1f, 0x7f, 0xff, 0xff, 0x37, 0x0, 0x0, 0x0,
    0x27, 0xe, 0x0, 0x38, 0x67, 0xf, 0xff, 0xf8,
    0xc7, 0xf, 0xff, 0xf8, 0x87, 0xe, 0x0, 0x38,
    0x7, 0xe, 0x0, 0x38, 0x7, 0xe, 0x0, 0x38,
    0x7, 0xe, 0x0, 0x38, 0x7, 0xe, 0x0, 0x38,
    0x7, 0xf, 0xff, 0xf8, 0x7, 0xf, 0xff, 0xf8,
    0x7, 0xe, 0x7c, 0x0, 0x7, 0x0, 0xf2, 0xc,
    0x7, 0x0, 0xe2, 0x18, 0x7, 0x1, 0xc2, 0x18,
    0x7, 0x1, 0xc3, 0x30, 0x7, 0x3, 0xc3, 0x60,
    0x7, 0x3, 0xc1, 0xc0, 0x7, 0x7, 0xc1, 0xc0,
    0x7, 0xd, 0xc1, 0xc0, 0x7, 0x19, 0xc0, 0xe0,
    0x7, 0x31, 0xc0, 0xf0, 0x7, 0x61, 0xc6, 0x7c,
    0x7, 0x1, 0xdc, 0x7e, 0x7, 0x1, 0xf0, 0x3e,
    0x7, 0xf, 0xe0, 0x1e, 0x7, 0x7, 0xc0, 0xe,
    0x7, 0x7, 0x0, 0x6, 0x7, 0x6, 0x0, 0x2,

    /* U+5108 "儈" */
    0x7, 0xc0, 0x7c, 0x0, 0x7, 0xc0, 0xf8, 0x0,
    0x7, 0xc0, 0xfc, 0x0, 0x7, 0x80, 0xf4, 0x0,
    0x7, 0x81, 0xe6, 0x0, 0x7, 0x81, 0xc3, 0x0,
    0x7, 0x83, 0x83, 0x80, 0x7, 0x3, 0x81, 0xe0,
    0x7, 0x7, 0x1, 0xf0, 0xf, 0xe, 0x0, 0xfe,
    0xe, 0xf, 0xff, 0xff, 0xe, 0x1b, 0xff, 0xbe,
    0xe, 0x30, 0x0, 0x1e, 0xf, 0x60, 0x0, 0xe,
    0x1f, 0xdc, 0x0, 0x7a, 0x1f, 0x1f, 0xff, 0xf8,
    0x1f, 0x1f, 0xff, 0xf8, 0x3f, 0x1c, 0x38, 0x78,
    0x2f, 0x1c, 0x39, 0x78, 0x6f, 0x1e, 0x39, 0xf8,
    0x4f, 0x1d, 0x3b, 0x78, 0xcf, 0x1d, 0xbb, 0x78,
    0xf, 0x1d, 0xfa, 0x78, 0xf, 0x1c, 0xbe, 0x78,
    0xf, 0x1c, 0xbc, 0x78, 0xf, 0x1c, 0x38, 0x78,
    0xf, 0x1f, 0xff, 0xf8, 0xf, 0x1f, 0xff, 0xf8,
    0xf, 0xc, 0x0, 0x78, 0xf, 0xe, 0x0, 0xf0,
    0xf, 0xe, 0x0, 0xf0, 0xf, 0xf, 0xff, 0xf0,
    0xf, 0xf, 0xff, 0xf0, 0xf, 0xe, 0x0, 0xf0,
    0xf, 0xe, 0x0, 0xf0, 0xf, 0xe, 0x0, 0xf0,
    0xf, 0xf, 0xfe, 0xf0, 0xf, 0xf, 0xfe, 0xf0,
    0xf, 0xe, 0x0, 0xf0, 0xf, 0xe, 0x0, 0xf0,
    0xf, 0xe, 0x0, 0xf0, 0xf, 0xf, 0xff, 0xf0,
    0xf, 0xf, 0xff, 0xf0, 0xf, 0xe, 0x0, 0xf0,
    0xf, 0xe, 0x0, 0xf0, 0xf, 0xe, 0x0, 0xf0,

    /* U+5109 "儉" */
    0x3, 0xe0, 0x3e, 0x0, 0x1, 0xf0, 0x3e, 0x0,
    0x0, 0xf0, 0x1f, 0x80, 0x0, 0x78, 0xf, 0x40,
    0x0, 0x3c, 0xf, 0xb0, 0x0, 0x1e, 0x7, 0x8c,
    0x0, 0x1e, 0x3, 0x86, 0x0, 0xf, 0x3, 0x83,
    0x80, 0x7, 0x83, 0xc0, 0xe0, 0x3, 0x81, 0xc0,
    0x3c, 0x1, 0xc1, 0xc0, 0x1f, 0x81, 0xe1, 0xc0,
    0x7, 0xe0, 0xe0, 0xff, 0xfd, 0xf0, 0x70, 0xdf,
    0xfe, 0x78, 0x3c, 0xc0, 0x0, 0x18, 0x3f, 0xc0,
    0x0, 0x4, 0x1f, 0x0, 0x0, 0x1, 0xf, 0x8e,
    0x3b, 0xce, 0xd, 0xc7, 0x1d, 0xe7, 0x6, 0xe3,
    0xfe, 0xff, 0x86, 0x71, 0xc7, 0x79, 0xc2, 0x38,
    0xe3, 0xbc, 0xe0, 0x1c, 0x71, 0xde, 0x70, 0xe,
    0x38, 0xef, 0x38, 0x7, 0x1c, 0x77, 0x9c, 0x3,
    0x8e, 0x3b, 0xce, 0x1, 0xc7, 0x1d, 0xe7, 0x0,
    0xe3, 0x8e, 0xf3, 0x80, 0x71, 0xc7, 0x79, 0xc0,
    0x38, 0xff, 0xbf, 0xe0, 0x1c, 0x7f, 0xdf, 0xf0,
    0xe, 0x38, 0xef, 0x38, 0x7, 0x1c, 0x77, 0x9c,
    0x3, 0x80, 0x0, 0x0, 0x1, 0xc1, 0xe0, 0x70,
    0x0, 0xe0, 0xf0, 0x38, 0x0, 0x70, 0xf0, 0x1c,
    0x0, 0x38, 0x7c, 0x1e, 0x0, 0x1c, 0x3b, 0xf,
    0x80, 0xe, 0x1d, 0xe7, 0x60, 0x7, 0xc, 0x77,
    0x3c, 0x3, 0x8e, 0x1b, 0x1f, 0x81, 0xc6, 0x3,
    0x7, 0x80, 0xe6, 0x1, 0x1, 0xc0, 0x73, 0x1,
    0x80, 0x60, 0x3b, 0x1, 0x80, 0x10,

    /* U+510B "儋" */
    0x7, 0xc1, 0xe0, 0x0, 0x3, 0xe0, 0xf0, 0x0,
    0x1, 0xf0, 0x78, 0x3e, 0x0, 0xf8, 0x7f, 0xff,
    0x0, 0x78, 0x3c, 0xf, 0x0, 0x3c, 0x1e, 0x7,
    0x80, 0x1e, 0xe, 0x7, 0x80, 0xf, 0xf, 0x3,
    0x0, 0x7, 0x87, 0x2, 0x0, 0x3, 0x87, 0x0,
    0x0, 0x1, 0xc3, 0xff, 0xff, 0xe1, 0xe3, 0xc0,
    0x8, 0x0, 0xe3, 0xe3, 0xc6, 0x0, 0x7b, 0x71,
    0xe3, 0x80, 0x3f, 0x38, 0xf0, 0xf8, 0x3e, 0x1c,
    0x76, 0x7e, 0x1f, 0xe, 0x7b, 0x9f, 0xf, 0x87,
    0x39, 0xe7, 0xd, 0xc3, 0xb8, 0x71, 0x86, 0xe1,
    0xf0, 0x38, 0x2, 0x70, 0xe0, 0x18, 0x3, 0x38,
    0x7f, 0xff, 0xfd, 0x1c, 0x3f, 0xff, 0xfe, 0xe,
    0x1c, 0x0, 0x0, 0x7, 0xe, 0x0, 0x0, 0x3,
    0x87, 0x3f, 0xff, 0x1, 0xc3, 0x9f, 0xff, 0x80,
    0xe1, 0xc0, 0x0, 0x0, 0x70, 0xe0, 0x0, 0x0,
    0x38, 0x70, 0x0, 0x0, 0x1c, 0x39, 0xff, 0xf8,
    0xe, 0x1c, 0xff, 0xfc, 0x7, 0xe, 0x0, 0x0,
    0x3, 0x87, 0x38, 0xf, 0x1, 0xc3, 0x9c, 0x7,
    0x80, 0xe1, 0xce, 0x3, 0xc0, 0x70, 0xc7, 0xff,
    0xe0, 0x38, 0x63, 0x80, 0xf0, 0x1c, 0x31, 0xc0,
    0x78, 0xe, 0x30, 0xe0, 0x3c, 0x7, 0x18, 0x70,
    0x1e, 0x3, 0x88, 0x38, 0xf, 0x1, 0xc4, 0x1f,
    0xff, 0x80, 0xe4, 0xe, 0x3, 0xc0, 0x72, 0x7,
    0x1, 0xe0, 0x3a, 0x3, 0x80, 0xf0,

    /* U+5110 "儐" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf0, 0x6, 0x0,
    0x0, 0xf8, 0x3, 0xc0, 0x0, 0x7c, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0x70, 0x0, 0x1e, 0x78, 0x18,
    0x3c, 0xf, 0x3f, 0xff, 0xfe, 0x7, 0x9f, 0xff,
    0xff, 0x3, 0xcf, 0x0, 0x7, 0x83, 0xc7, 0x80,
    0x3, 0xc1, 0xe3, 0xc0, 0x1, 0xe0, 0xf1, 0xef,
    0xfe, 0x80, 0x70, 0x7, 0xff, 0x0, 0x78, 0x0,
    0x78, 0x0, 0x3c, 0xf, 0xbc, 0xf8, 0x1f, 0x7,
    0x9e, 0x78, 0xf, 0x83, 0x8f, 0x78, 0xf, 0xc1,
    0x87, 0xb8, 0x7, 0xe1, 0xc3, 0xf8, 0x6, 0xf0,
    0xc1, 0xf0, 0x3, 0x78, 0xfc, 0x61, 0xe3, 0x3c,
    0x1e, 0xc0, 0xf1, 0x1e, 0xf, 0xff, 0xf8, 0xf,
    0x7, 0x80, 0x3c, 0x7, 0x87, 0xc0, 0x1e, 0x3,
    0xcf, 0xe0, 0xf, 0x1, 0xfc, 0xff, 0xe7, 0x80,
    0xf0, 0x7f, 0xf3, 0xc0, 0x78, 0x3c, 0x1, 0xe0,
    0x3c, 0x1e, 0x0, 0xf0, 0x1e, 0xf, 0xfe, 0x78,
    0xf, 0x7, 0xff, 0x3c, 0x7, 0x83, 0xc0, 0x1e,
    0x3, 0xc1, 0xe0, 0xf, 0x1, 0xe0, 0xff, 0xff,
    0x80, 0xf0, 0x7f, 0xff, 0xc0, 0x78, 0x3c, 0x1,
    0xe0, 0x3c, 0x1e, 0x8, 0xf0, 0x1e, 0x1, 0xe2,
    0x0, 0xf, 0x1, 0xf1, 0x80, 0x7, 0x80, 0xf0,
    0x70, 0x3, 0xc0, 0xf0, 0x3e, 0x1, 0xe0, 0x70,
    0xf, 0xe0, 0xf0, 0x70, 0x3, 0xe0, 0x78, 0x70,
    0x0, 0xf0, 0x3c, 0x60, 0x0, 0x38, 0x1e, 0x60,
    0x0, 0xc, 0x0, 0x0, 0x0, 0x0,

    /* U+5112 "儒" */
    0x7, 0x80, 0x0, 0x0, 0x3, 0xcf, 0xff, 0xff,
    0x81, 0xe7, 0xff, 0xff, 0xc0, 0xf0, 0x3, 0x80,
    0x0, 0x78, 0x1, 0xc0, 0x0, 0x3c, 0x0, 0xe0,
    0x0, 0x1c, 0xe0, 0x70, 0xe, 0xe, 0x7f, 0xff,
    0xff, 0xf, 0x3f, 0xff, 0xff, 0x87, 0x9c, 0xe,
    0x1, 0xc3, 0x8e, 0x7, 0x0, 0xe1, 0xc7, 0x3,
    0x82, 0x70, 0xc3, 0xb1, 0xc3, 0x38, 0x78, 0xe,
    0xe3, 0x0, 0x7c, 0x7, 0x73, 0x0, 0x3e, 0x3,
    0x3f, 0x0, 0x1f, 0x0, 0xfd, 0xe0, 0x1f, 0x81,
    0xee, 0x7e, 0xb, 0xc7, 0xe7, 0x1f, 0x5, 0xe3,
    0xe3, 0x83, 0x84, 0xf1, 0xc1, 0xc0, 0xc2, 0x78,
    0x0, 0x0, 0x2, 0x3c, 0x0, 0x0, 0x0, 0x1e,
    0xff, 0xff, 0xff, 0xf, 0x7f, 0xff, 0xff, 0x87,
    0x80, 0xf, 0x0, 0x3, 0xc0, 0x7, 0x0, 0x1,
    0xe7, 0x83, 0x81, 0xc0, 0xf3, 0xc3, 0x0, 0xe0,
    0x79, 0xff, 0xff, 0xf0, 0x3c, 0xff, 0xff, 0xf8,
    0x1e, 0x79, 0xe7, 0x1c, 0xf, 0x3c, 0xf3, 0x8e,
    0x7, 0x9e, 0x79, 0xc7, 0x3, 0xcf, 0x3c, 0xe3,
    0x81, 0xe7, 0x9e, 0x71, 0xc0, 0xf3, 0xcf, 0x38,
    0xe0, 0x79, 0xe7, 0x9c, 0x70, 0x3c, 0xf3, 0xce,
    0x38, 0x1e, 0x79, 0xe7, 0x1c, 0xf, 0x3c, 0xf3,
    0x8e, 0x7, 0x9e, 0x79, 0xc7, 0x3, 0xcf, 0x3c,
    0xe3, 0x81, 0xe7, 0x80, 0x3, 0xc0, 0xf3, 0xc0,
    0x3, 0xc0, 0x79, 0xe0, 0xf, 0xc0,

    /* U+5114 "儔" */
    0xf, 0x80, 0x38, 0x0, 0x1f, 0x0, 0x70, 0x0,
    0x3e, 0x0, 0xe0, 0x0, 0x7c, 0x1, 0xc0, 0x0,
    0xf3, 0xff, 0xff, 0xc1, 0xe7, 0xff, 0xff, 0x83,
    0xc0, 0xe, 0x0, 0xf, 0x80, 0x1c, 0x0, 0x1e,
    0x0, 0x38, 0x0, 0x3c, 0x3f, 0xff, 0xe0, 0x70,
    0x7f, 0xff, 0xc0, 0xe0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0xe3, 0x1f, 0xff, 0xff, 0xcf, 0x3f,
    0xff, 0xff, 0x9e, 0x0, 0x0, 0x7, 0x3c, 0x0,
    0x0, 0xe, 0x78, 0x3f, 0xff, 0xdd, 0xf0, 0x7f,
    0xff, 0xa3, 0xe0, 0x1, 0xc0, 0x5, 0xc0, 0x3,
    0x80, 0x1b, 0x80, 0x7, 0x0, 0x27, 0x1f, 0xff,
    0xfe, 0xe, 0x3f, 0xff, 0xfc, 0x1c, 0x0, 0x0,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x73, 0xff, 0xff,
    0xf8, 0xe7, 0xff, 0xff, 0xf1, 0xc0, 0x0, 0x0,
    0x3, 0x80, 0x0, 0x0, 0x7, 0x1c, 0x78, 0x1e,
    0xe, 0x38, 0xf0, 0x3c, 0x1c, 0x7f, 0xff, 0xfe,
    0x38, 0xff, 0xff, 0xfc, 0x71, 0xc7, 0x81, 0xe0,
    0xe3, 0x8f, 0x3, 0xc1, 0xc7, 0x1e, 0x87, 0x83,
    0x8e, 0x3d, 0xf, 0x7, 0x1c, 0x7b, 0x1e, 0xe,
    0x38, 0xf7, 0x3c, 0x1c, 0x71, 0xe6, 0x78, 0x38,
    0xff, 0xc8, 0xf0, 0x71, 0xff, 0x81, 0xe0, 0xe3,
    0x8f, 0x3, 0x81, 0xc7, 0x1e, 0xf, 0x3, 0x80,
    0x1, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+5115 "儕" */
    0x0, 0x0, 0x0, 0x0, 0x7, 0xc0, 0x30, 0x0,
    0x3, 0xe0, 0xe, 0x0, 0x1, 0xf0, 0x7, 0x80,
    0x0, 0xf8, 0x3, 0xc0, 0x0, 0x78, 0x0, 0xc0,
    0x0, 0x3d, 0xff, 0xff, 0xfc, 0x1e, 0xff, 0xff,
    0xfe, 0xe, 0x0, 0x83, 0x0, 0x7, 0x0, 0x61,
    0x80, 0x7, 0x80, 0x38, 0xc1, 0x3, 0x80, 0x6e,
    0xf9, 0xc1, 0xcf, 0xf6, 0x7d, 0xf0, 0xe7, 0xfb,
    0x2f, 0xc0, 0x60, 0xcc, 0x37, 0xc0, 0x7c, 0x66,
    0x73, 0x90, 0x3e, 0x33, 0x39, 0xc8, 0x1f, 0x19,
    0x9c, 0xe4, 0xf, 0x8c, 0xce, 0x73, 0xd, 0xce,
    0x67, 0x39, 0x84, 0xe7, 0x33, 0x9c, 0xe6, 0x73,
    0x19, 0xce, 0xfa, 0x39, 0x8c, 0xe7, 0xde, 0x1c,
    0x8e, 0x77, 0xce, 0xe, 0x86, 0x3b, 0xc7, 0x7,
    0xc6, 0x1d, 0x81, 0x3, 0x80, 0xe, 0x0, 0x1,
    0xc1, 0xc0, 0xf, 0x0, 0xe0, 0xe0, 0x7, 0x80,
    0x70, 0x70, 0x3, 0xc0, 0x38, 0x3f, 0xff, 0xe0,
    0x1c, 0x1f, 0xff, 0xf0, 0xe, 0xe, 0x0, 0x78,
    0x7, 0x7, 0x0, 0x3c, 0x3, 0x83, 0x80, 0x1e,
    0x1, 0xc1, 0xc0, 0xf, 0x0, 0xe0, 0xe0, 0x7,
    0x80, 0x70, 0x7f, 0xff, 0xc0, 0x38, 0x78, 0x1,
    0xe0, 0x1c, 0x38, 0x0, 0xf0, 0xe, 0x1c, 0x0,
    0x78, 0x7, 0xc, 0x0, 0x3c, 0x3, 0x8c, 0x0,
    0x1e, 0x1, 0xc4, 0x0, 0xf, 0x0, 0xe6, 0x0,
    0x7, 0x80, 0x76, 0x0, 0x3, 0xc0, 0x38, 0x0,
    0x0, 0x0,

    /* U+5118 "儘" */
    0x7, 0xc0, 0x38, 0x0, 0x3, 0xe0, 0x1c, 0x0,
    0x1, 0xf0, 0xe, 0x0, 0x0, 0xf8, 0x7, 0x7,
    0x0, 0x78, 0x3, 0x83, 0x80, 0x3c, 0xff, 0xff,
    0xc0, 0x1e, 0x7f, 0xff, 0xe0, 0xf, 0x0, 0x70,
    0x70, 0x7, 0x0, 0x38, 0x38, 0x3, 0x80, 0x1c,
    0x1c, 0x3, 0xdf, 0xff, 0xff, 0xc1, 0xcf, 0xff,
    0xff, 0xe0, 0xe0, 0x3, 0x83, 0x80, 0x70, 0x1,
    0xc1, 0xc0, 0x38, 0x0, 0xe0, 0xe0, 0x3c, 0x3f,
    0xff, 0xf0, 0x1e, 0x1f, 0xff, 0xf8, 0xf, 0x0,
    0x1c, 0x1c, 0x7, 0x80, 0xe, 0x0, 0x7, 0xc0,
    0x7, 0x0, 0x2, 0xef, 0xff, 0xff, 0xf3, 0x77,
    0xff, 0xff, 0xf9, 0x38, 0x0, 0x10, 0x41, 0x9c,
    0x79, 0xc, 0x20, 0xe, 0x3c, 0xc7, 0x18, 0x7,
    0x1c, 0x71, 0xce, 0x3, 0x8e, 0x1c, 0xe3, 0x81,
    0xc6, 0xc, 0x71, 0xe0, 0xe3, 0x6, 0x10, 0x70,
    0x73, 0xe2, 0x1, 0xf8, 0x3b, 0xff, 0xff, 0xe8,
    0x1c, 0x7f, 0xff, 0xf2, 0xe, 0x3c, 0xe7, 0x38,
    0x7, 0x1e, 0x73, 0x9c, 0x3, 0x8f, 0x39, 0xce,
    0x1, 0xc7, 0x9c, 0xe7, 0x0, 0xe3, 0xce, 0x73,
    0x80, 0x71, 0xe7, 0x39, 0xc0, 0x38, 0xf3, 0x9c,
    0xe0, 0x1c, 0x79, 0xce, 0x70, 0xe, 0x3c, 0xe7,
    0x38, 0x7, 0x1e, 0x73, 0x9c, 0x3, 0x8f, 0x39,
    0xce, 0x1, 0xdf, 0xff, 0xff, 0xe0, 0xef, 0xff,
    0xff, 0xf0, 0x70, 0x0, 0x0, 0x0,

    /* U+511F "償" */
    0xf, 0x80, 0x1c, 0x0, 0x7, 0xc6, 0xe, 0xc,
    0x3, 0xe1, 0xc7, 0xe, 0x1, 0xf0, 0xf3, 0x87,
    0x0, 0xf8, 0x39, 0xc7, 0x0, 0x78, 0x1c, 0xe3,
    0x0, 0x3d, 0xc6, 0x73, 0x9e, 0x1e, 0xe2, 0x39,
    0x8f, 0xf, 0x7f, 0xff, 0xff, 0x87, 0xb8, 0x0,
    0x3, 0xc3, 0x9c, 0x0, 0x1, 0xe1, 0xce, 0xf0,
    0x1c, 0xf1, 0xe7, 0x7f, 0xfe, 0x78, 0xe3, 0xbf,
    0xff, 0x20, 0x7c, 0x1e, 0x3, 0x80, 0x3e, 0xf,
    0x1, 0xc0, 0x3f, 0x7, 0x80, 0xe0, 0x1f, 0x83,
    0xff, 0xf0, 0xf, 0xc1, 0xff, 0xf8, 0x5, 0xe0,
    0xf0, 0x1c, 0x6, 0xf0, 0x0, 0x0, 0x2, 0x78,
    0xf0, 0x1, 0xe3, 0x3c, 0x7f, 0xff, 0xf0, 0x1e,
    0x3f, 0xff, 0xf8, 0xf, 0x1e, 0x0, 0x3c, 0x7,
    0x8f, 0x0, 0x1e, 0x3, 0xc7, 0x80, 0xf, 0x1,
    0xe3, 0xff, 0xf7, 0x80, 0xf1, 0xe0, 0x3, 0xc0,
    0x78, 0xf0, 0x1, 0xe0, 0x3c, 0x78, 0x0, 0xf0,
    0x1e, 0x3f, 0xff, 0x78, 0xf, 0x1f, 0xff, 0xbc,
    0x7, 0x8f, 0x0, 0x1e, 0x3, 0xc7, 0x80, 0xf,
    0x1, 0xe3, 0xff, 0xff, 0x80, 0xf1, 0xff, 0xff,
    0xc0, 0x78, 0xf0, 0x1, 0xe0, 0x3c, 0x7f, 0xc0,
    0xf0, 0x1e, 0x3, 0xc3, 0x0, 0xf, 0x1, 0xe0,
    0xe0, 0x7, 0x81, 0xe0, 0x7e, 0x3, 0xc0, 0xc0,
    0x1f, 0xc1, 0xe0, 0xc0, 0x7, 0xc0, 0xf0, 0xc0,
    0x1, 0xe0, 0x79, 0x80, 0x0, 0x30, 0x0, 0x0,
    0x0, 0x0,

    /* U+5121 "儡" */
    0x7, 0x86, 0x0, 0x1c, 0x7, 0x86, 0x0, 0x1c,
    0x7, 0x87, 0xff, 0xfc, 0x7, 0x87, 0xff, 0xfc,
    0x7, 0x86, 0xc, 0x1c, 0x7, 0x86, 0xc, 0x1c,
    0x7, 0x86, 0xc, 0x1c, 0x7, 0x6, 0xc, 0x1c,
    0x7, 0x6, 0xc, 0x1c, 0x7, 0x6, 0xc, 0x1c,
    0xf, 0x7, 0xff, 0xfc, 0xe, 0x7, 0xff, 0xfc,
    0xe, 0x6, 0xc, 0x1c, 0xf, 0x6, 0xc, 0x1c,
    0x1f, 0x6, 0xc, 0x1c, 0x1f, 0x6, 0xc, 0x1c,
    0x1f, 0x6, 0xc, 0x1c, 0x1f, 0x6, 0xc, 0x1c,
    0x37, 0x7, 0xff, 0xfc, 0x27, 0x7, 0xff, 0xfc,
    0x67, 0x6, 0x0, 0x0, 0x47, 0x0, 0x0, 0x0,
    0x47, 0x38, 0x77, 0x7, 0x7, 0x38, 0x77, 0x7,
    0x7, 0x3f, 0xf7, 0xff, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3b, 0x77, 0x37, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3b, 0x77, 0x37, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3b, 0x77, 0x37, 0x7, 0x3f, 0xf7, 0xff,
    0x7, 0x3f, 0xf7, 0xff, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3b, 0x77, 0x37, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3b, 0x77, 0x37, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3b, 0x77, 0x37, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3b, 0x77, 0x37, 0x7, 0x3b, 0x77, 0x37,
    0x7, 0x3f, 0xf7, 0xff, 0x7, 0x38, 0x77, 0x7,
    0x7, 0x38, 0x77, 0x7, 0x7, 0x38, 0x77, 0x7,

    /* U+512A "優" */
    0xf, 0x0, 0x0, 0x0, 0xf, 0x3f, 0xff, 0xfe,
    0xf, 0x0, 0x78, 0x0, 0xf, 0x0, 0x78, 0x0,
    0xf, 0xf, 0x70, 0xe0, 0xf, 0xf, 0x60, 0xe0,
    0xe, 0xf, 0xff, 0xe0, 0xe, 0xf, 0x0, 0xe0,
    0xe, 0xf, 0x0, 0xe0, 0xe, 0xf, 0x0, 0xe0,
    0x1e, 0xf, 0xfe, 0xe0, 0x1c, 0xf, 0x0, 0xe0,
    0x1c, 0xf, 0x0, 0xe0, 0x1e, 0xf, 0xfe, 0xe0,
    0x1e, 0xf, 0x0, 0xe0, 0x1e, 0xf, 0x0, 0xe0,
    0x3e, 0xef, 0x0, 0xef, 0x3e, 0xff, 0xff, 0xff,
    0x3e, 0xe0, 0x20, 0xf, 0x7e, 0xe0, 0x18, 0xf,
    0x5e, 0xe1, 0xdc, 0x29, 0x5e, 0x39, 0xcc, 0xb0,
    0x1e, 0x39, 0xcc, 0x98, 0x1e, 0x39, 0xc8, 0x9c,
    0x1e, 0x39, 0xc0, 0xce, 0x1e, 0x31, 0xff, 0xcc,
    0x1e, 0x61, 0xff, 0xc4, 0x1e, 0x41, 0xff, 0x80,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x3, 0xc0, 0x0,
    0x1e, 0x3, 0xc1, 0xe0, 0x1e, 0x3, 0xff, 0xe0,
    0x1e, 0x7, 0xff, 0xe0, 0x1e, 0x7, 0x81, 0xc0,
    0x1e, 0x7, 0x43, 0xc0, 0x1e, 0xe, 0x63, 0x80,
    0x1e, 0xc, 0x37, 0x80, 0x1e, 0x18, 0x1f, 0x0,
    0x1e, 0x30, 0x1f, 0xc0, 0x1e, 0x60, 0x3f, 0xfe,
    0x1e, 0x0, 0xe3, 0xfe, 0x1e, 0x1, 0x80, 0xfc,
    0x1e, 0x6, 0x0, 0x7c, 0x1e, 0x18, 0x0, 0x1c,
    0x1e, 0x60, 0x0, 0x4,

    /* U+5132 "儲" */
    0xf, 0x88, 0x7, 0x80, 0x1f, 0x18, 0xf, 0x0,
    0x3c, 0x38, 0x1e, 0x0, 0x78, 0x78, 0x3c, 0x0,
    0xf0, 0x60, 0x78, 0x1, 0xe0, 0xc0, 0xf3, 0xc3,
    0xc1, 0x1, 0xe7, 0x87, 0x80, 0x3, 0xcf, 0xe,
    0xff, 0xdf, 0xfc, 0x1d, 0xff, 0xbf, 0xf8, 0x78,
    0x0, 0x1e, 0x70, 0xe0, 0x0, 0x3c, 0xe1, 0xc0,
    0x0, 0x79, 0xc3, 0x80, 0x0, 0xf7, 0x7, 0x3f,
    0xf1, 0xee, 0xe, 0x7f, 0xe3, 0xdc, 0x3c, 0x0,
    0x7, 0xf0, 0x78, 0x0, 0x7f, 0xfc, 0xf0, 0x0,
    0x3, 0x81, 0xe0, 0x0, 0x6, 0x7, 0xcf, 0xfc,
    0x1c, 0xb, 0x9f, 0xf8, 0x70, 0x37, 0x0, 0x7,
    0xc7, 0xe, 0x0, 0xf, 0xe, 0x1c, 0x0, 0x1f,
    0xfc, 0x38, 0xe7, 0x3f, 0xf8, 0x71, 0xce, 0x70,
    0x70, 0xe3, 0x9d, 0xe0, 0xe1, 0xc7, 0xfb, 0xc1,
    0xc3, 0x8e, 0x7b, 0x83, 0x87, 0x1c, 0xe7, 0x7,
    0xe, 0x39, 0xce, 0xe, 0x1c, 0x73, 0x9f, 0xfc,
    0x38, 0xe7, 0x3f, 0xf8, 0x71, 0xce, 0x70, 0x70,
    0xe3, 0x9c, 0xe0, 0xe1, 0xc7, 0x39, 0xc1, 0xc3,
    0x8e, 0x73, 0x83, 0x87, 0x1c, 0xe7, 0x7, 0xe,
    0x3f, 0xce, 0xe, 0x1c, 0x73, 0x9f, 0xfc, 0x38,
    0xe7, 0x3f, 0xf8, 0x71, 0xce, 0x70, 0x70, 0xe3,
    0x9c, 0xe0, 0xe1, 0xc0, 0x1, 0xc1, 0xc0, 0x0,
    0x0, 0x3, 0x80,

    /* U+5133 "儳" */
    0x7, 0x81, 0xe0, 0x0, 0x7, 0x81, 0xe1, 0xe0,
    0x7, 0x81, 0xe1, 0xe0, 0x7, 0x83, 0xff, 0xc0,
    0x7, 0x83, 0x81, 0x80, 0x7, 0x87, 0x82, 0x3c,
    0x7, 0xf, 0xff, 0xfc, 0x7, 0x1f, 0xff, 0xfc,
    0x7, 0x37, 0x80, 0x3c, 0x6, 0x7, 0x80, 0x3c,
    0xe, 0x7, 0x80, 0x3c, 0xe, 0x7, 0xff, 0xfc,
    0xe, 0x7, 0xff, 0xfc, 0xf, 0xf, 0x0, 0x8,
    0xf, 0xf, 0x3, 0x9c, 0x1f, 0xf, 0xfb, 0xbe,
    0x1f, 0xf, 0x3, 0xf2, 0x1f, 0xf, 0x3, 0xe2,
    0x37, 0xf, 0x3, 0xc2, 0x37, 0xf, 0xb, 0x83,
    0x27, 0x1f, 0xf3, 0xff, 0x67, 0xf, 0xc3, 0xfe,
    0x47, 0xf, 0x0, 0x0, 0x7, 0x1b, 0xe1, 0xe0,
    0x7, 0x3, 0xc1, 0xe0, 0x7, 0x3, 0xff, 0xc0,
    0x7, 0x7, 0x1, 0xc0, 0x7, 0x7, 0x3, 0x80,
    0x7, 0xf, 0x3, 0x3c, 0x7, 0xf, 0xff, 0xfc,
    0x7, 0x1f, 0xff, 0xfc, 0x7, 0x6f, 0xe, 0x3c,
    0x7, 0xf, 0x1e, 0x3c, 0x7, 0xf, 0x1e, 0x3c,
    0x7, 0xf, 0x1c, 0x3c, 0x7, 0xf, 0x1c, 0x3c,
    0x7, 0xf, 0xff, 0xfc, 0x7, 0xf, 0x3f, 0x3c,
    0x7, 0x0, 0x3f, 0x0, 0x7, 0x0, 0x77, 0x62,
    0x7, 0x0, 0xc7, 0x32, 0x7, 0x1, 0x87, 0x32,
    0x7, 0x3, 0x7, 0x13, 0x7, 0xc, 0x7, 0x3,
    0x7, 0x18, 0x7, 0xff, 0x7, 0x60, 0x7, 0xff,

    /* U+5137 "儷" */
    0x1f, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x1f, 0x7f, 0xef, 0xff, 0x1e, 0x7f, 0xef, 0xff,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x38, 0xe7, 0x1c,
    0x1e, 0x3f, 0xe7, 0xfc, 0x1e, 0x3f, 0xe7, 0xfc,
    0x1e, 0x38, 0xe7, 0x1c, 0x1c, 0x38, 0xe7, 0x1c,
    0x1c, 0x3e, 0xe7, 0xdc, 0x1c, 0x3f, 0xe7, 0xfc,
    0x18, 0x3b, 0xe7, 0x7c, 0x1c, 0x3a, 0xe7, 0x5c,
    0x3c, 0x38, 0xe7, 0x1c, 0x3c, 0x38, 0xe7, 0x1c,
    0x3c, 0x39, 0xf7, 0x30, 0x3c, 0x2, 0x3c, 0x0,
    0x3c, 0x70, 0x38, 0x0, 0x7c, 0x70, 0x10, 0x0,
    0x5c, 0x7f, 0xff, 0xfe, 0x5c, 0x7f, 0xff, 0xfe,
    0x9c, 0x71, 0xc7, 0x0, 0x1c, 0x71, 0xc7, 0x0,
    0x1c, 0x71, 0xc7, 0x38, 0x1c, 0x77, 0xff, 0xf8,
    0x1c, 0x77, 0xff, 0xf8, 0x1c, 0x71, 0xc7, 0x38,
    0x1c, 0x71, 0xc7, 0x38, 0x1c, 0x71, 0xc7, 0x38,
    0x1c, 0x71, 0xc7, 0x38, 0x1c, 0x77, 0xff, 0xf8,
    0x1c, 0x77, 0xff, 0xf8, 0x1c, 0x70, 0x0, 0x38,
    0x1c, 0x73, 0x87, 0x0, 0x1c, 0x73, 0x87, 0x8,
    0x1c, 0x63, 0xf7, 0x1c, 0x1c, 0x63, 0xf7, 0x32,
    0x1c, 0x63, 0x87, 0x62, 0x1c, 0xc3, 0x87, 0xc2,
    0x1c, 0xc3, 0x8f, 0x2, 0x1c, 0xc3, 0xb7, 0x2,
    0x1c, 0x9f, 0xe7, 0x86, 0x1d, 0x8f, 0xc7, 0xfe,
    0x1d, 0xf, 0x7, 0xfe, 0x1f, 0x8, 0x3, 0xfc,

    /* U+5138 "儸" */
    0xf, 0x9c, 0x0, 0x3c, 0x1e, 0x38, 0x0, 0x78,
    0x3c, 0x7f, 0xff, 0xf0, 0x78, 0xff, 0xff, 0xe0,
    0xf1, 0xce, 0x73, 0xc1, 0xe3, 0x9c, 0xe7, 0x83,
    0xc7, 0x39, 0xcf, 0x7, 0x8e, 0x73, 0x9e, 0xe,
    0x1c, 0xe7, 0x3c, 0x3c, 0x39, 0xce, 0x78, 0x78,
    0x73, 0x9c, 0xf0, 0xf0, 0xff, 0xff, 0xe1, 0xc1,
    0xc0, 0x3, 0xc3, 0x81, 0x80, 0x8, 0x7, 0x83,
    0x0, 0x18, 0x1f, 0x7, 0x7, 0xb0, 0x3e, 0xe,
    0xf, 0x30, 0x7c, 0x1c, 0x1e, 0x70, 0xf8, 0x70,
    0x38, 0xe3, 0xf0, 0xcf, 0x71, 0x87, 0xe1, 0x9c,
    0xff, 0xfb, 0xc6, 0x7b, 0xce, 0x27, 0x98, 0xe7,
    0x9c, 0xf, 0x3f, 0xcf, 0x38, 0x1e, 0x7b, 0x3e,
    0x70, 0x3c, 0xee, 0x5c, 0xe0, 0x79, 0x3d, 0xb9,
    0xc0, 0xf0, 0x68, 0x7f, 0xe1, 0xe1, 0x98, 0xe7,
    0x3, 0xc6, 0x39, 0xce, 0x7, 0x9f, 0xf3, 0x9c,
    0xf, 0x3e, 0x67, 0x38, 0x1e, 0x38, 0xce, 0x70,
    0x3c, 0xc0, 0x9c, 0xe0, 0x78, 0x1, 0x3f, 0xf0,
    0xf3, 0xa0, 0x7f, 0xe1, 0xe7, 0x48, 0xe7, 0x3,
    0xce, 0x91, 0xce, 0x7, 0x9d, 0xb3, 0x9c, 0xf,
    0x3b, 0x67, 0x38, 0x1e, 0x66, 0xee, 0x70, 0x3c,
    0xcd, 0x9f, 0xfc, 0x7b, 0x92, 0x3f, 0xf8, 0xf6,
    0x0, 0x70, 0x1, 0xe8, 0x0, 0xe0, 0x3, 0xc0,
    0x1, 0xc0, 0x0,

    /* U+513A "儺" */
    0x0, 0x0, 0x0, 0x0, 0x1c, 0x77, 0x80, 0x40,
    0x38, 0xef, 0xe, 0xc0, 0x71, 0xde, 0x1d, 0x80,
    0xe3, 0xbc, 0x3b, 0x81, 0xc7, 0x78, 0x73, 0x83,
    0xff, 0xfc, 0xe7, 0x6, 0x1d, 0xe3, 0x8c, 0xc,
    0x3b, 0xc7, 0x18, 0x18, 0x77, 0x8e, 0x0, 0x70,
    0xef, 0x1f, 0xf8, 0xe1, 0xfe, 0x3f, 0xf1, 0x83,
    0xbc, 0x73, 0x83, 0x87, 0x78, 0xe7, 0x7, 0x3,
    0x83, 0xce, 0xe, 0x77, 0x77, 0x9c, 0x3c, 0xee,
    0xef, 0x38, 0x79, 0xff, 0xfe, 0x70, 0xf3, 0xff,
    0xfc, 0xe3, 0xe7, 0x77, 0xbf, 0xf5, 0xce, 0xee,
    0x7f, 0xeb, 0x9d, 0x9c, 0xe7, 0x7, 0x3b, 0x39,
    0xce, 0xe, 0x76, 0x73, 0x9c, 0x1c, 0xff, 0xe7,
    0x38, 0x39, 0xff, 0xce, 0x70, 0x73, 0xb3, 0x9c,
    0xe0, 0xe7, 0x67, 0x39, 0xc1, 0xc0, 0xc0, 0x73,
    0x83, 0x81, 0x80, 0xff, 0xc7, 0x3f, 0xf9, 0xff,
    0x8e, 0x6, 0x3, 0x9c, 0x1c, 0xc, 0x7, 0x38,
    0x38, 0x18, 0xe, 0x70, 0x77, 0xff, 0xdc, 0xe0,
    0xef, 0xff, 0xb9, 0xc1, 0xc1, 0xa0, 0x73, 0x83,
    0x83, 0x40, 0xe7, 0x7, 0x6, 0xc1, 0xce, 0xe,
    0x18, 0xc3, 0x9c, 0x1c, 0x31, 0xe7, 0x38, 0x38,
    0xc3, 0xcf, 0xfc, 0x71, 0x3, 0x9f, 0xf8, 0xe6,
    0x7, 0x38, 0x1, 0xd8, 0x6, 0x70, 0x3, 0xa0,
    0x4, 0xe0, 0x7, 0xc0, 0x9, 0xc0, 0x0,

    /* U+513B "儻" */
    0xf, 0x80, 0x1c, 0x0, 0x7, 0xc2, 0xe, 0x8,
    0x3, 0xe1, 0x87, 0xc, 0x1, 0xf0, 0x63, 0x86,
    0x0, 0xf0, 0x39, 0xc6, 0x0, 0x78, 0xe, 0xe6,
    0x0, 0x3c, 0xe6, 0x73, 0x3c, 0x1e, 0x71, 0x3b,
    0x1e, 0x1e, 0x3f, 0xff, 0xff, 0xf, 0x1c, 0x0,
    0x7, 0x87, 0x8f, 0xe0, 0x3f, 0xc3, 0x87, 0xf0,
    0x1f, 0x1, 0xc0, 0x7f, 0xff, 0x0, 0xf0, 0x3c,
    0x7, 0x80, 0x78, 0x1e, 0x3, 0xc0, 0x7c, 0xf,
    0x1, 0xe0, 0x3e, 0x7, 0xff, 0xf0, 0x1f, 0x3,
    0xc0, 0x78, 0xb, 0x81, 0xe0, 0x3c, 0xd, 0xc3,
    0x80, 0x3, 0x84, 0xe1, 0xc0, 0x1, 0xc2, 0x70,
    0xff, 0xff, 0xe0, 0x38, 0x70, 0x70, 0x70, 0x1c,
    0x3a, 0x39, 0xb8, 0xe, 0x1c, 0x9c, 0x9c, 0x7,
    0xe, 0x6e, 0xce, 0x3, 0x87, 0x37, 0x47, 0x1,
    0xc3, 0xff, 0xff, 0x80, 0xe1, 0xff, 0xff, 0xc0,
    0x70, 0xe0, 0xe0, 0xe0, 0x38, 0x0, 0x70, 0x0,
    0x1c, 0x0, 0x38, 0x0, 0xe, 0x1f, 0xff, 0xfe,
    0x7, 0x0, 0xe, 0x0, 0x3, 0x80, 0x7, 0x0,
    0x1, 0xcf, 0xff, 0xff, 0xe0, 0xe0, 0x0, 0x0,
    0x0, 0x70, 0x0, 0x1, 0x0, 0x38, 0x71, 0x8,
    0x40, 0x1c, 0x38, 0x84, 0x30, 0xe, 0x1c, 0x63,
    0x1e, 0x7, 0xe, 0x31, 0xcf, 0x83, 0x8e, 0x1c,
    0xe3, 0xc1, 0xc6, 0xc, 0x61, 0xc0, 0xe6, 0x4,
    0x20, 0x60, 0x72, 0x0, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x0,

    /* U+513C "儼" */
    0xf, 0x3c, 0xf3, 0x8e, 0xf, 0x3c, 0xf3, 0x8e,
    0xf, 0x3f, 0xf3, 0xfe, 0xf, 0x3c, 0xf3, 0x8e,
    0xf, 0x3c, 0xf3, 0x8e, 0xf, 0x3c, 0xf3, 0x8e,
    0xf, 0x3c, 0xf3, 0x8e, 0xe, 0x3c, 0xf3, 0x8e,
    0xe, 0x3f, 0xf3, 0xfe, 0x1e, 0x3f, 0xf3, 0xfe,
    0x1e, 0x3c, 0xf3, 0x8e, 0x1e, 0x70, 0x0, 0x0,
    0x1c, 0x70, 0x0, 0x0, 0x1c, 0x70, 0x0, 0x0,
    0x1e, 0x7f, 0xff, 0xff, 0x3e, 0x7f, 0xff, 0xff,
    0x3e, 0x70, 0x1c, 0x0, 0x3e, 0x70, 0x1c, 0xf0,
    0x3e, 0x77, 0xfc, 0xf0, 0x7e, 0x77, 0xfc, 0xf0,
    0x5e, 0x70, 0x18, 0xf0, 0xde, 0x70, 0x30, 0xf0,
    0x9e, 0x70, 0x20, 0xe0, 0x1e, 0x7f, 0xfe, 0xff,
    0x1e, 0x7f, 0xfe, 0xff, 0x1e, 0x73, 0x1d, 0xcc,
    0x1e, 0x73, 0x1d, 0xcc, 0x1e, 0x73, 0x1d, 0x9c,
    0x1e, 0x73, 0xfd, 0x1c, 0x1e, 0x73, 0xfd, 0x1c,
    0x1e, 0x73, 0x1f, 0x1c, 0x1e, 0x73, 0x1f, 0x1c,
    0x1e, 0x73, 0x1c, 0x9c, 0x1e, 0x73, 0xfc, 0x9c,
    0x1e, 0x73, 0xfc, 0xd8, 0x1e, 0x63, 0x1c, 0xd8,
    0x1e, 0x63, 0x1c, 0xf8, 0x1e, 0x63, 0x1e, 0x70,
    0x1e, 0x63, 0x1e, 0x70, 0x1e, 0x63, 0x7c, 0x7c,
    0x1e, 0xdf, 0xfc, 0xff, 0x1e, 0xcf, 0x9c, 0x9f,
    0x1e, 0xce, 0x1d, 0x8e, 0x1e, 0x90, 0x1d, 0xe,
    0x1e, 0x80, 0x1e, 0x6, 0x1f, 0x0, 0x1c, 0x2,

    /* U+513F "儿" */
    0x0, 0xf8, 0x1e, 0x0, 0x0, 0x7c, 0xf, 0x0,
    0x0, 0x3e, 0x7, 0x80, 0x0, 0x1f, 0x3, 0xc0,
    0x0, 0xf, 0x81, 0xe0, 0x0, 0x7, 0xc0, 0xf0,
    0x0, 0x3, 0xe0, 0x78, 0x0, 0x1, 0xf0, 0x3c,
    0x0, 0x0, 0xf8, 0x1e, 0x0, 0x0, 0x7c, 0xf,
    0x0, 0x0, 0x3e, 0x7, 0x80, 0x0, 0x1f, 0x3,
    0xc0, 0x0, 0xf, 0x81, 0xe0, 0x0, 0x7, 0xc0,
    0xf0, 0x0, 0x3, 0xe0, 0x78, 0x0, 0x1, 0xf0,
    0x3c, 0x0, 0x0, 0xf8, 0x1e, 0x0, 0x0, 0x7c,
    0xf, 0x0, 0x0, 0x3e, 0x7, 0x80, 0x0, 0x1f,
    0x3, 0xc0, 0x0, 0xf, 0x81, 0xe0, 0x0, 0x7,
    0xc0, 0xf0, 0x0, 0x3, 0xe0, 0x78, 0x0, 0x1,
    0xf0, 0x3c, 0x0, 0x0, 0xf8, 0x1e, 0x0, 0x0,
    0x7c, 0xf, 0x0, 0x0, 0x3e, 0x7, 0x80, 0x0,
    0x1f, 0x3, 0xc0, 0x0, 0xf, 0x81, 0xe0, 0x0,
    0x7, 0xc0, 0xf0, 0x0, 0x3, 0xe0, 0x78, 0x0,
    0x1, 0xe0, 0x3c, 0x2, 0x0, 0xf0, 0x1e, 0x1,
    0x0, 0xf8, 0xf, 0x0, 0x80, 0x78, 0x7, 0x80,
    0x40, 0x3c, 0x3, 0xc0, 0x60, 0x1c, 0x1, 0xe0,
    0x30, 0x1e, 0x0, 0xf0, 0x1c, 0xe, 0x0, 0x78,
    0xe, 0xe, 0x0, 0x3c, 0x7, 0x6, 0x0, 0x1e,
    0x3, 0x86, 0x0, 0xf, 0x3, 0xc6, 0x0, 0x7,
    0xff, 0xe6, 0x0, 0x3, 0xff, 0xe6, 0x0, 0x0,
    0xff, 0xf6, 0x0, 0x0, 0x3f, 0xf0,

    /* U+5140 "兀" */
    0x7f, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0,
    0x0, 0x78, 0x3c, 0x0, 0x0, 0x70, 0x3c, 0x2,
    0x0, 0xf0, 0x3c, 0x2, 0x0, 0xe0, 0x3c, 0x2,
    0x0, 0xe0, 0x3c, 0x2, 0x1, 0xc0, 0x3c, 0x2,
    0x1, 0xc0, 0x3c, 0x2, 0x3, 0x80, 0x3c, 0x2,
    0x3, 0x0, 0x3c, 0x3, 0x7, 0x0, 0x3c, 0x7,
    0x6, 0x0, 0x3e, 0x7, 0xc, 0x0, 0x3f, 0xff,
    0x18, 0x0, 0x1f, 0xff, 0x30, 0x0, 0x1f, 0xfe,
    0x60, 0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0,

    /* U+5141 "允" */
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1e, 0x8, 0x0, 0x0, 0x1e, 0x8, 0x0,
    0x0, 0x3c, 0xc, 0x0, 0x0, 0x3c, 0xc, 0x0,
    0x0, 0x38, 0xe, 0x0, 0x0, 0x78, 0x6, 0x0,
    0x0, 0xf0, 0x7, 0x0, 0x0, 0xe0, 0x7, 0x80,
    0x1, 0xc0, 0x3, 0xc0, 0x3, 0x80, 0x7, 0xf0,
    0x6, 0x0, 0x39, 0xf8, 0x78, 0x7, 0xe1, 0xf8,
    0x3f, 0xff, 0x80, 0xf8, 0x3f, 0xfc, 0x0, 0x78,
    0x3f, 0x80, 0x0, 0x38, 0x0, 0x0, 0x78, 0x18,
    0x0, 0x7c, 0x78, 0x0, 0x0, 0x7c, 0x78, 0x0,
    0x0, 0x7c, 0x78, 0x0, 0x0, 0x7c, 0x78, 0x0,
    0x0, 0x7c, 0x78, 0x0, 0x0, 0x7c, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0xf8, 0x78, 0x0,
    0x0, 0xf0, 0x78, 0x0, 0x0, 0xf0, 0x78, 0x0,
    0x0, 0xf0, 0x78, 0x0, 0x0, 0xe0, 0x78, 0x2,
    0x1, 0xe0, 0x78, 0x2, 0x1, 0xc0, 0x78, 0x2,
    0x1, 0xc0, 0x78, 0x2, 0x3, 0x80, 0x78, 0x2,
    0x3, 0x0, 0x78, 0x6, 0x7, 0x0, 0x78, 0x7,
    0xe, 0x0, 0x78, 0x7, 0xc, 0x0, 0x7c, 0x7,
    0x18, 0x0, 0x7f, 0xff, 0x30, 0x0, 0x7f, 0xff,
    0x60, 0x0, 0x3f, 0xfe, 0xc0, 0x0, 0x1f, 0xfc,
    0x0, 0x0, 0x0, 0x0,

    /* U+5143 "元" */
    0xf, 0xff, 0xff, 0xf0, 0x7, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xff,
    0xff, 0xf1, 0xff, 0xff, 0xff, 0xf8, 0x0, 0xf0,
    0x78, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0, 0x3c,
    0x1e, 0x0, 0x0, 0x1e, 0xf, 0x0, 0x0, 0xf,
    0x7, 0x80, 0x0, 0x7, 0x83, 0xc0, 0x0, 0x3,
    0xc1, 0xe0, 0x0, 0x1, 0xe0, 0xf0, 0x0, 0x0,
    0xf0, 0x78, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0,
    0x3c, 0x1e, 0x0, 0x0, 0x1e, 0xf, 0x0, 0x0,
    0xf, 0x7, 0x80, 0x0, 0x7, 0x83, 0xc0, 0x10,
    0x3, 0xc1, 0xe0, 0x8, 0x1, 0xc0, 0xf0, 0x4,
    0x1, 0xe0, 0x78, 0x2, 0x0, 0xe0, 0x3c, 0x3,
    0x0, 0x70, 0x1e, 0x1, 0x80, 0x70, 0xf, 0x0,
    0xc0, 0x38, 0x7, 0x80, 0x60, 0x38, 0x3, 0xc0,
    0x38, 0x18, 0x1, 0xe0, 0x1c, 0x18, 0x0, 0xf0,
    0x1e, 0x1c, 0x0, 0x7f, 0xfe, 0x1c, 0x0, 0x3f,
    0xff, 0xc, 0x0, 0x1f, 0xff, 0x8c, 0x0, 0x3,
    0xff, 0x8c, 0x0, 0x0, 0x0, 0x0,

    /* U+5144 "兄" */
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0,
    0xf, 0xff, 0xff, 0xe0, 0xf, 0xff, 0xff, 0xe0,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0,
    0xf, 0x0, 0x1, 0xe0, 0xf, 0xff, 0xff, 0xe0,
    0xf, 0xff, 0xff, 0xe0, 0xf, 0x3c, 0x79, 0xe0,
    0xf, 0x3c, 0x79, 0xe0, 0xf, 0x3c, 0x79, 0xe0,
    0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c, 0x78, 0x0,
    0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c, 0x78, 0x0,
    0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c, 0x78, 0x0,
    0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c, 0x78, 0x0,
    0x0, 0x38, 0x78, 0x0, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x2, 0x0, 0x70, 0x78, 0x2,
    0x0, 0xf0, 0x78, 0x2, 0x0, 0xe0, 0x78, 0x2,
    0x1, 0xc0, 0x78, 0x2, 0x1, 0xc0, 0x78, 0x6,
    0x3, 0x80, 0x78, 0x7, 0x3, 0x0, 0x78, 0x7,
    0x6, 0x0, 0x78, 0xf, 0xc, 0x0, 0x7c, 0xf,
    0x18, 0x0, 0x7f, 0xfe, 0x30, 0x0, 0x7f, 0xfe,
    0x60, 0x0, 0x7f, 0xfe, 0xc0, 0x0, 0x3f, 0xfc,

    /* U+5145 "充" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0x80, 0x0,
    0xff, 0xff, 0xff, 0xfc, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x8, 0x0, 0x0, 0x1e, 0x8, 0x0,
    0x0, 0x3c, 0x8, 0x0, 0x0, 0x3c, 0xc, 0x0,
    0x0, 0x38, 0xc, 0x0, 0x0, 0x70, 0xe, 0x0,
    0x0, 0xe0, 0x7, 0x0, 0x1, 0xc0, 0x1f, 0x80,
    0x3, 0x0, 0xf7, 0xc0, 0x1e, 0x7f, 0xc3, 0xe0,
    0xf, 0xff, 0x3, 0xf0, 0xf, 0xfc, 0x1, 0xe0,
    0xf, 0xe0, 0x0, 0xe0, 0xe, 0x0, 0x78, 0x60,
    0x0, 0x78, 0x78, 0x20, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x70, 0x78, 0x0, 0x0, 0x70, 0x78, 0x2,
    0x0, 0x70, 0x78, 0x2, 0x0, 0xf0, 0x78, 0x2,
    0x0, 0xe0, 0x78, 0x2, 0x0, 0xe0, 0x78, 0x2,
    0x1, 0xc0, 0x78, 0x2, 0x1, 0xc0, 0x78, 0x6,
    0x3, 0x80, 0x78, 0x6, 0x3, 0x0, 0x78, 0x7,
    0x6, 0x0, 0x78, 0x7, 0x4, 0x0, 0x78, 0xf,
    0x8, 0x0, 0x7f, 0xff, 0x10, 0x0, 0x7f, 0xff,
    0x20, 0x0, 0x3f, 0xfe, 0x40, 0x0, 0x1f, 0xfc,

    /* U+5146 "兆" */
    0x0, 0x3c, 0x3c, 0x0, 0x0, 0x1e, 0x1e, 0x0,
    0x0, 0xf, 0xf, 0x0, 0x0, 0x7, 0x87, 0x80,
    0x0, 0x3, 0xc3, 0xc0, 0x0, 0x1, 0xe1, 0xe0,
    0x0, 0x80, 0xf0, 0xf0, 0x38, 0x60, 0x78, 0x78,
    0x18, 0x10, 0x3c, 0x3c, 0x18, 0xc, 0x1e, 0x1e,
    0xc, 0x7, 0xf, 0xf, 0xc, 0x3, 0x87, 0x87,
    0x8c, 0x0, 0xe3, 0xc3, 0xc6, 0x0, 0x79, 0xe1,
    0xe6, 0x0, 0x3c, 0xf0, 0xf6, 0x0, 0xe, 0x78,
    0x7b, 0x0, 0x7, 0x3c, 0x3f, 0x0, 0x3, 0x9e,
    0x1f, 0x0, 0x0, 0x8f, 0xf, 0x80, 0x0, 0x47,
    0x87, 0x80, 0x0, 0x3, 0xc3, 0xe0, 0x0, 0x3,
    0xe1, 0xe8, 0x0, 0x3, 0xf0, 0xf6, 0x0, 0x7,
    0x78, 0x79, 0x80, 0xf, 0x3c, 0x3c, 0xf0, 0x7f,
    0x9e, 0x1e, 0x7c, 0x1f, 0x8f, 0xf, 0x1f, 0xf,
    0x87, 0x87, 0x8f, 0x87, 0x83, 0xc3, 0xc3, 0xc3,
    0x1, 0xe1, 0xe0, 0xc1, 0x0, 0xf0, 0xf0, 0x64,
    0x0, 0x78, 0x78, 0x12, 0x0, 0x3c, 0x3c, 0x1,
    0x0, 0x1e, 0x1e, 0x1, 0x80, 0xe, 0xf, 0x0,
    0xc0, 0xf, 0x7, 0x80, 0x60, 0x7, 0x3, 0xc0,
    0x30, 0x7, 0x81, 0xe0, 0x18, 0x3, 0x80, 0xf0,
    0xc, 0x3, 0x80, 0x78, 0xf, 0x3, 0x80, 0x3e,
    0x7, 0x83, 0x80, 0x1f, 0xff, 0xc3, 0x80, 0xf,
    0xff, 0xc3, 0x80, 0x3, 0xff, 0xe3, 0x0, 0x0,
    0xff, 0xe3, 0x0, 0x0, 0x0, 0x0,

    /* U+5147 "兇" */
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x2, 0x1, 0xe0, 0x0, 0x4, 0x3, 0xc0, 0x1,
    0xe4, 0x7, 0x8f, 0x3, 0xc4, 0xf, 0x1e, 0x7,
    0x8c, 0x3c, 0x3c, 0xf, 0xc, 0x78, 0x78, 0x1e,
    0xd, 0xe0, 0xf0, 0x3c, 0x1f, 0xc1, 0xe0, 0x78,
    0x1f, 0x3, 0xc0, 0xf0, 0x1e, 0x7, 0x81, 0xe0,
    0x7e, 0xf, 0x3, 0xc0, 0xfe, 0x1e, 0x7, 0x83,
    0x3e, 0x3c, 0xf, 0xc, 0x3c, 0x78, 0x1e, 0x10,
    0x7c, 0xf0, 0x3c, 0x40, 0x79, 0xe0, 0x79, 0x0,
    0x73, 0xc0, 0xf4, 0x0, 0x67, 0x81, 0xf0, 0x0,
    0x4f, 0x3, 0xc0, 0x0, 0x1e, 0x7, 0xff, 0xff,
    0xfc, 0xf, 0xff, 0xff, 0xf8, 0x1e, 0x78, 0xf0,
    0xf0, 0x3c, 0xf1, 0xe1, 0xe0, 0x79, 0xe3, 0xc3,
    0xc0, 0x3, 0xc7, 0x80, 0x0, 0x7, 0x8f, 0x0,
    0x0, 0xf, 0x1e, 0x0, 0x0, 0x1e, 0x3c, 0x0,
    0x0, 0x3c, 0x78, 0x2, 0x0, 0x78, 0xf0, 0x4,
    0x0, 0xe1, 0xe0, 0x8, 0x1, 0xc3, 0xc0, 0x10,
    0x7, 0x7, 0x80, 0x20, 0xe, 0xf, 0x0, 0x40,
    0x38, 0x1e, 0x0, 0x80, 0x70, 0x3c, 0x1, 0x81,
    0xc0, 0x78, 0x7, 0x7, 0x0, 0xf0, 0xe, 0xc,
    0x1, 0xff, 0xfc, 0x30, 0x3, 0xff, 0xf8, 0xc0,
    0x7, 0xff, 0xf3, 0x0, 0x7, 0xff, 0xcc, 0x0,
    0x0, 0x0, 0x0,

    /* U+5148 "先" */
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x7, 0xc3, 0xc0,
    0x0, 0x1, 0xf0, 0xf0, 0x0, 0x0, 0x78, 0x3c,
    0x0, 0x0, 0x1e, 0xf, 0x0, 0x0, 0x7, 0x83,
    0xc0, 0x0, 0x1, 0xff, 0xff, 0xf8, 0x0, 0x7f,
    0xff, 0xfe, 0x0, 0x3c, 0xf, 0x0, 0x0, 0xf,
    0x3, 0xc0, 0x0, 0x3, 0x80, 0xf0, 0x0, 0x0,
    0xc0, 0x3c, 0x0, 0x0, 0x70, 0xf, 0x0, 0x0,
    0x18, 0x3, 0xc0, 0x0, 0xc, 0x0, 0xf0, 0x0,
    0x3, 0x0, 0x3c, 0x0, 0x1, 0x80, 0xf, 0x0,
    0x0, 0xc0, 0x3, 0xc0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x78, 0x78, 0x0, 0x0, 0x1e,
    0x1e, 0x0, 0x0, 0x7, 0x87, 0x80, 0x0, 0x1,
    0xe1, 0xe0, 0x0, 0x0, 0x78, 0x78, 0x0, 0x0,
    0x1e, 0x1e, 0x0, 0x0, 0x7, 0x87, 0x80, 0x0,
    0x1, 0xe1, 0xe0, 0x0, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x80, 0xf, 0x7, 0x80,
    0x20, 0x3, 0x81, 0xe0, 0x18, 0x0, 0xe0, 0x78,
    0x6, 0x0, 0x70, 0x1e, 0x1, 0x80, 0x18, 0x7,
    0x80, 0x60, 0xc, 0x1, 0xe0, 0x18, 0x7, 0x0,
    0x78, 0x7, 0x3, 0x80, 0x1e, 0x1, 0xc0, 0xc0,
    0x7, 0x80, 0xf0, 0x40, 0x1, 0xff, 0xfc, 0x60,
    0x0, 0x7f, 0xff, 0x30, 0x0, 0xf, 0xff, 0x98,
    0x0, 0x1, 0xff, 0xc0,

    /* U+5149 "光" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x4, 0x1, 0x0, 0x78, 0x3,
    0x0, 0xc0, 0x3c, 0x3, 0x80, 0x30, 0x1e, 0x1,
    0x80, 0x1e, 0xf, 0x1, 0xc0, 0xf, 0x87, 0x80,
    0xc0, 0x3, 0xe3, 0xc0, 0xc0, 0x1, 0xf9, 0xe0,
    0x60, 0x0, 0x7c, 0xf0, 0x60, 0x0, 0x3c, 0x78,
    0x70, 0x0, 0xe, 0x3c, 0x30, 0x0, 0x6, 0x1e,
    0x30, 0x0, 0x0, 0xf, 0x18, 0x0, 0x0, 0x7,
    0x98, 0x0, 0x0, 0x3, 0xcc, 0x0, 0x3f, 0xff,
    0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xe0, 0x7,
    0x87, 0x80, 0x0, 0x3, 0xc3, 0xc0, 0x0, 0x1,
    0xe1, 0xe0, 0x0, 0x0, 0xf0, 0xf0, 0x0, 0x0,
    0x78, 0x78, 0x0, 0x0, 0x3c, 0x3c, 0x0, 0x0,
    0x1e, 0x1e, 0x0, 0x0, 0xf, 0xf, 0x0, 0x0,
    0x7, 0x87, 0x80, 0x0, 0x3, 0xc3, 0xc0, 0x0,
    0x1, 0xe1, 0xe0, 0x0, 0x1, 0xe0, 0xf0, 0x0,
    0x0, 0xf0, 0x78, 0x0, 0x0, 0x78, 0x3c, 0x1,
    0x0, 0x38, 0x1e, 0x0, 0x80, 0x3c, 0xf, 0x0,
    0x40, 0x1c, 0x7, 0x80, 0x60, 0xc, 0x3, 0xc0,
    0x20, 0xe, 0x1, 0xe0, 0x10, 0x6, 0x0, 0xf0,
    0x8, 0x6, 0x0, 0x78, 0x7, 0x6, 0x0, 0x3c,
    0x7, 0x82, 0x0, 0x1e, 0x3, 0xc2, 0x0, 0xf,
    0xff, 0xe2, 0x0, 0x7, 0xff, 0xe2, 0x0, 0x3,
    0xff, 0xf2, 0x0, 0x0, 0xff, 0xf0,

    /* U+514B "克" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0x7f, 0xff, 0xff, 0xff, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x7, 0x86, 0x0, 0xe0, 0x7, 0x84, 0x0, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0x80, 0x0, 0xe0, 0x7, 0x80, 0x0, 0xe0,
    0x7, 0x80, 0x0, 0xe0, 0x7, 0x80, 0x0, 0xe0,
    0x7, 0x80, 0x0, 0xe0, 0x7, 0x80, 0x0, 0xe0,
    0x7, 0x80, 0x0, 0xe0, 0x7, 0x80, 0x0, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0x80, 0x0, 0xe0,
    0x7, 0x80, 0x0, 0xe0, 0x7, 0xbe, 0x38, 0xe0,
    0x0, 0x3e, 0x38, 0x0, 0x0, 0x3e, 0x38, 0x0,
    0x0, 0x3c, 0x38, 0x0, 0x0, 0x3c, 0x38, 0x2,
    0x0, 0x3c, 0x38, 0x2, 0x0, 0x7c, 0x38, 0x2,
    0x0, 0x78, 0x38, 0x2, 0x0, 0x78, 0x38, 0x2,
    0x0, 0x70, 0x38, 0x2, 0x0, 0xe0, 0x38, 0x2,
    0x1, 0xe0, 0x38, 0x6, 0x1, 0xc0, 0x38, 0x7,
    0x3, 0x80, 0x38, 0x7, 0x7, 0x0, 0x3c, 0x7,
    0xe, 0x0, 0x3f, 0xff, 0x18, 0x0, 0x3f, 0xff,
    0x30, 0x0, 0x3f, 0xfe, 0xe0, 0x0, 0x1f, 0xfe,
    0x0, 0x0, 0x0, 0x0,

    /* U+514D "免" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0xf0, 0x3, 0xe0, 0x0, 0xf0, 0x3, 0xe0,
    0x0, 0xe0, 0x3, 0xc0, 0x1, 0xff, 0xff, 0xc0,
    0x1, 0xff, 0xff, 0x80, 0x3, 0xc0, 0xf, 0x0,
    0x7, 0x0, 0x1e, 0x0, 0x6, 0x0, 0x3c, 0x0,
    0xc, 0x0, 0x70, 0x3c, 0x1f, 0x80, 0xc0, 0x3c,
    0x37, 0x83, 0x0, 0x3c, 0x67, 0xff, 0xff, 0xfc,
    0x7, 0x81, 0xe0, 0x3c, 0x7, 0x81, 0xe0, 0x3c,
    0x7, 0x81, 0xe0, 0x3c, 0x7, 0x81, 0xe0, 0x3c,
    0x7, 0x81, 0xe0, 0x3c, 0x7, 0x81, 0xe0, 0x3c,
    0x7, 0x81, 0xe0, 0x3c, 0x7, 0x81, 0xe0, 0x3c,
    0x7, 0x81, 0xe0, 0x3c, 0x7, 0xff, 0xff, 0xfc,
    0x7, 0xff, 0xff, 0xfc, 0x7, 0x83, 0xf8, 0x3c,
    0x7, 0x87, 0xf8, 0x3c, 0x7, 0x87, 0xf8, 0x3c,
    0x0, 0x7, 0xf8, 0x0, 0x0, 0xf, 0x78, 0x0,
    0x0, 0xf, 0x78, 0x0, 0x0, 0xe, 0x78, 0x0,
    0x0, 0x1e, 0x78, 0x0, 0x0, 0x1c, 0x78, 0x0,
    0x0, 0x3c, 0x78, 0x2, 0x0, 0x78, 0x78, 0x2,
    0x0, 0x70, 0x78, 0x2, 0x0, 0xe0, 0x78, 0x2,
    0x1, 0xe0, 0x78, 0x2, 0x1, 0xc0, 0x78, 0x3,
    0x3, 0x80, 0x78, 0x3, 0x7, 0x0, 0x7c, 0x3,
    0xc, 0x0, 0x7f, 0xff, 0x18, 0x0, 0x7f, 0xff,
    0x30, 0x0, 0x3f, 0xfe, 0x60, 0x0, 0x1f, 0xfe,
    0x0, 0x0, 0x0, 0x0,

    /* U+5151 "兑" */
    0x0, 0x0, 0x0, 0x80, 0x0, 0xc0, 0x1, 0xc0,
    0x0, 0x60, 0x1, 0x80, 0x0, 0x78, 0x3, 0x0,
    0x0, 0x3c, 0x6, 0x0, 0x0, 0x3e, 0xe, 0x0,
    0x0, 0x1e, 0x1c, 0x0, 0x0, 0x1e, 0x18, 0x0,
    0x7, 0x8e, 0x31, 0xe0, 0x7, 0x84, 0x61, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0x80, 0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0,
    0x7, 0x9e, 0x79, 0xe0, 0x0, 0x1e, 0x78, 0x0,
    0x0, 0x1e, 0x78, 0x0, 0x0, 0x1e, 0x78, 0x0,
    0x0, 0x1c, 0x78, 0x1, 0x0, 0x3c, 0x78, 0x1,
    0x0, 0x3c, 0x78, 0x1, 0x0, 0x38, 0x78, 0x2,
    0x0, 0x38, 0x78, 0x2, 0x0, 0x70, 0x78, 0x2,
    0x0, 0x70, 0x78, 0x2, 0x0, 0xe0, 0x78, 0x2,
    0x0, 0xc0, 0x78, 0x2, 0x1, 0xc0, 0x78, 0x3,
    0x3, 0x80, 0x78, 0x3, 0x7, 0x0, 0x78, 0x7,
    0xc, 0x0, 0x7f, 0xff, 0x18, 0x0, 0x7f, 0xff,
    0x20, 0x0, 0x7f, 0xff, 0x40, 0x0, 0x3f, 0xfe,

    /* U+5152 "兒" */
    0x0, 0x6, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x78, 0xfe, 0x3, 0xc0, 0xf3, 0xe0, 0x7, 0x81,
    0xfe, 0x7, 0xff, 0x3, 0xc0, 0xf, 0xfe, 0x7,
    0x80, 0x0, 0x3c, 0xf, 0x0, 0x0, 0x78, 0x1e,
    0x0, 0x0, 0xf0, 0x3c, 0x0, 0x1, 0xe0, 0x78,
    0x0, 0x3, 0xc0, 0xf0, 0x0, 0x7, 0x81, 0xff,
    0xc7, 0xff, 0x3, 0xff, 0x8f, 0xfe, 0x7, 0x80,
    0x0, 0x3c, 0xf, 0x0, 0x0, 0x78, 0x1e, 0x0,
    0x0, 0xf0, 0x3c, 0x0, 0x1, 0xe0, 0x78, 0x0,
    0x3, 0xc0, 0xf0, 0x0, 0x7, 0x81, 0xe0, 0x0,
    0xf, 0x3, 0xc0, 0x0, 0x1e, 0x7, 0xff, 0xff,
    0xfc, 0xf, 0x1e, 0x3c, 0x78, 0x1e, 0x3c, 0x78,
    0xf0, 0x3c, 0x78, 0xf1, 0xe0, 0x78, 0xf1, 0xe3,
    0xc0, 0x1, 0xe3, 0xc0, 0x0, 0x3, 0xc7, 0x80,
    0x0, 0x7, 0x8f, 0x0, 0x0, 0xf, 0x1e, 0x0,
    0x0, 0x1e, 0x3c, 0x0, 0x0, 0x3c, 0x78, 0x4,
    0x0, 0x78, 0xf0, 0x8, 0x0, 0xe1, 0xe0, 0x10,
    0x3, 0xc3, 0xc0, 0x20, 0x7, 0x7, 0x80, 0x40,
    0x1c, 0xf, 0x0, 0x80, 0x70, 0x1e, 0x1, 0x81,
    0xc0, 0x3c, 0x7, 0x3, 0x0, 0x78, 0xe, 0x1c,
    0x0, 0xff, 0xfc, 0x70, 0x1, 0xff, 0xf9, 0x80,
    0x3, 0xff, 0xf6, 0x0, 0x3, 0xff, 0xc0,

    /* U+5154 "兔" */
    0x0, 0x7c, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x1, 0xe0, 0x7, 0xc0, 0x0, 0x3c, 0x0,
    0xf8, 0x0, 0xf, 0xff, 0xfe, 0x0, 0x1, 0xff,
    0xff, 0xc0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xe,
    0x0, 0x3e, 0x0, 0x3, 0x80, 0x7, 0x80, 0x0,
    0x70, 0x1, 0xe0, 0x0, 0x1c, 0x0, 0x78, 0x0,
    0x7, 0xc0, 0x1c, 0x3c, 0x1, 0xf8, 0x6, 0x7,
    0x80, 0x6f, 0xff, 0xff, 0xf0, 0x19, 0xff, 0xff,
    0xfe, 0x0, 0x3c, 0xf, 0x3, 0xc0, 0x7, 0x81,
    0xe0, 0x78, 0x0, 0xf0, 0x3c, 0xf, 0x0, 0x1e,
    0x7, 0x81, 0xe0, 0x3, 0xc0, 0xf0, 0x3c, 0x0,
    0x78, 0x1e, 0x7, 0x80, 0xf, 0x3, 0xc0, 0xf0,
    0x1, 0xe0, 0x78, 0x1e, 0x0, 0x3f, 0xff, 0xff,
    0xc0, 0x7, 0xff, 0xff, 0xf8, 0x0, 0xf0, 0x3c,
    0xf, 0x0, 0x1e, 0x7, 0x81, 0xe0, 0x3, 0xc0,
    0xfc, 0x0, 0x0, 0x0, 0x3f, 0x80, 0x0, 0x0,
    0x7, 0xf1, 0x0, 0x0, 0x0, 0xee, 0x30, 0x0,
    0x0, 0x3d, 0xc3, 0x0, 0x0, 0x7, 0x38, 0x70,
    0x40, 0x1, 0xe7, 0xf, 0x8, 0x0, 0x38, 0xe1,
    0xe1, 0x0, 0xe, 0x1c, 0x18, 0x60, 0x3, 0xc3,
    0x83, 0xc, 0x0, 0xf0, 0x70, 0x41, 0x80, 0x1c,
    0xe, 0x0, 0x30, 0x7, 0x1, 0xc0, 0x6, 0x1,
    0xc0, 0x38, 0x0, 0xe0, 0x70, 0x7, 0x0, 0x1c,
    0x1c, 0x0, 0xf0, 0x7, 0x86, 0x0, 0x1f, 0xff,
    0xe1, 0x80, 0x3, 0xff, 0xfc, 0xe0, 0x0, 0x3f,
    0xff, 0x0,

    /* U+5155 "兕" */
    0x3c, 0x38, 0x38, 0x78, 0x3c, 0x38, 0x38, 0x78,
    0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8,
    0x3c, 0x38, 0x38, 0x78, 0x3c, 0x38, 0x38, 0x78,
    0x3c, 0x38, 0x38, 0x78, 0x3c, 0x38, 0x38, 0x78,
    0x3c, 0x38, 0x38, 0x78, 0x3c, 0x38, 0x38, 0x78,
    0x3c, 0x38, 0x38, 0x78, 0x3c, 0x38, 0x38, 0x78,
    0x3c, 0x3f, 0xf8, 0x78, 0x3c, 0x3f, 0xf8, 0x78,
    0x3c, 0x38, 0x38, 0x78, 0x3c, 0x38, 0x38, 0x78,
    0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0, 0x78,
    0x3c, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0, 0x78,
    0x3c, 0x0, 0x0, 0x78, 0x3f, 0xff, 0xff, 0xf8,
    0x3f, 0xff, 0xff, 0xf8, 0x3c, 0x0, 0x0, 0x78,
    0x3c, 0x0, 0x0, 0x78, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x78, 0x78, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x78, 0x78, 0x2,
    0x0, 0x78, 0x78, 0x2, 0x0, 0x78, 0x78, 0x2,
    0x0, 0xf0, 0x78, 0x2, 0x0, 0xf0, 0x78, 0x2,
    0x0, 0xe0, 0x78, 0x6, 0x1, 0xe0, 0x78, 0x6,
    0x1, 0xc0, 0x78, 0x7, 0x3, 0x80, 0x78, 0x7,
    0x7, 0x0, 0x78, 0xf, 0xe, 0x0, 0x7f, 0xff,
    0x1c, 0x0, 0x7f, 0xfe, 0x30, 0x0, 0x7f, 0xfe,
    0xe0, 0x0, 0x3f, 0xfc,

    /* U+5156 "兖" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0x7, 0x0,
    0x1, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x4, 0x0, 0x0, 0x7c, 0x1,
    0x0, 0x0, 0x3c, 0x0, 0x80, 0x0, 0x1e, 0x0,
    0x60, 0x0, 0xe, 0x0, 0x18, 0x0, 0xf, 0x0,
    0xe, 0x0, 0x7, 0x1f, 0x7, 0xc0, 0x7, 0xf,
    0x81, 0xf8, 0x3, 0x7, 0x80, 0xfe, 0x3, 0x7,
    0xc2, 0x3f, 0x1, 0x3, 0xc1, 0x8f, 0x81, 0x1,
    0xc0, 0xc3, 0xc1, 0x1, 0xc0, 0x30, 0x61, 0x1,
    0xc0, 0x1c, 0x0, 0x0, 0xc0, 0xe, 0x0, 0x0,
    0xc0, 0x1f, 0xc0, 0x8, 0x81, 0xf9, 0xf8, 0x7,
    0xff, 0xf0, 0xf8, 0x1, 0xff, 0xe0, 0x38, 0x0,
    0xff, 0xc0, 0x1c, 0x0, 0xff, 0xc3, 0xc6, 0x0,
    0x1, 0xe1, 0xe1, 0x0, 0x0, 0xf0, 0xf0, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x3c, 0x3c, 0x0,
    0x0, 0x1c, 0x1e, 0x0, 0x0, 0xe, 0xf, 0x0,
    0x0, 0xf, 0x7, 0x80, 0x40, 0x7, 0x3, 0xc0,
    0x20, 0x3, 0x81, 0xe0, 0x10, 0x3, 0x80, 0xf0,
    0x8, 0x1, 0x80, 0x78, 0x4, 0x1, 0x80, 0x3c,
    0x3, 0x1, 0xc0, 0x1e, 0x3, 0x81, 0xc0, 0xf,
    0x1, 0xc1, 0xc0, 0x7, 0xff, 0xe1, 0x80, 0x3,
    0xff, 0xf1, 0x80, 0x1, 0xff, 0xf9, 0x80, 0x0,
    0x7f, 0xf8,

    /* U+515A "党" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x80,
    0x30, 0x1e, 0x3, 0x0, 0x38, 0x3c, 0xc, 0x0,
    0x78, 0x78, 0x18, 0x0, 0x78, 0xf0, 0x60, 0x0,
    0xf9, 0xe1, 0x80, 0x0, 0xe3, 0xc3, 0x0, 0x1,
    0xc7, 0x8c, 0x3d, 0xe1, 0xf, 0x38, 0x7b, 0xff,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xef, 0x0,
    0x0, 0x3, 0xde, 0x0, 0x0, 0x7, 0xbc, 0x0,
    0x0, 0xf, 0x79, 0xe0, 0x3, 0xd0, 0xf3, 0xc0,
    0x7, 0x80, 0x7, 0xff, 0xff, 0x0, 0xf, 0xff,
    0xfe, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x3c, 0x0,
    0x78, 0x0, 0x78, 0x0, 0xf0, 0x0, 0xf0, 0x1,
    0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x3, 0xc0, 0x7,
    0x80, 0x7, 0xff, 0xff, 0x0, 0xf, 0xff, 0xfe,
    0x0, 0x1e, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x78,
    0x0, 0x7, 0xf, 0x0, 0x0, 0xe, 0x1e, 0x0,
    0x0, 0x18, 0x3c, 0x0, 0x0, 0x70, 0x78, 0x4,
    0x0, 0xe0, 0xf0, 0x8, 0x1, 0xc1, 0xe0, 0x10,
    0x3, 0x3, 0xc0, 0x20, 0xe, 0x7, 0x80, 0x40,
    0x18, 0xf, 0x0, 0x80, 0x70, 0x1e, 0x1, 0x0,
    0xc0, 0x3c, 0x3, 0x3, 0x0, 0x78, 0xe, 0xc,
    0x0, 0xff, 0xfc, 0x30, 0x1, 0xff, 0xf8, 0x80,
    0x3, 0xff, 0xf2, 0x0, 0x3, 0xff, 0xc8, 0x0,
    0x0, 0x0, 0x0,

    /* U+515B "兛" */
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x6,
    0x0, 0x3c, 0x0, 0xf, 0x80, 0x1e, 0x0, 0xf,
    0xe0, 0xf, 0x0, 0x1f, 0xf0, 0x7, 0x80, 0x3f,
    0xc1, 0xff, 0xff, 0x7f, 0x80, 0xff, 0xff, 0x83,
    0xc0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0x70, 0x0,
    0xf0, 0x0, 0x38, 0x0, 0x78, 0x0, 0x18, 0x0,
    0x3c, 0x3, 0xc8, 0x70, 0x1e, 0x1, 0xe8, 0x38,
    0xf, 0x0, 0xff, 0xfc, 0x7, 0x80, 0x7f, 0xfe,
    0x3, 0xc0, 0x3c, 0x7, 0x1, 0xe0, 0x1e, 0x3,
    0x80, 0xf0, 0xf, 0x1, 0xcf, 0xff, 0xe7, 0x80,
    0xe7, 0xff, 0xf3, 0xc0, 0x70, 0x1e, 0x1, 0xe0,
    0x38, 0xf, 0x0, 0xf0, 0x1c, 0x7, 0x80, 0x78,
    0xe, 0x3, 0xc0, 0x3f, 0xff, 0x1, 0xe0, 0x1f,
    0xff, 0x80, 0xf0, 0xf, 0x1, 0xc0, 0x78, 0x7,
    0x80, 0xe0, 0x3c, 0x0, 0x71, 0xe0, 0x1e, 0x0,
    0x38, 0xf0, 0xf, 0x0, 0x1c, 0x78, 0x7, 0x80,
    0x1e, 0x3c, 0x3, 0xc0, 0xf, 0x1e, 0x1, 0xe0,
    0x7, 0x8f, 0x0, 0xf1, 0x3, 0xc7, 0x80, 0x78,
    0x81, 0xe3, 0xc0, 0x3c, 0x40, 0xe1, 0xe0, 0x1e,
    0x20, 0x70, 0xf0, 0xf, 0x10, 0x78, 0x78, 0x7,
    0x88, 0x38, 0x3c, 0x3, 0xc6, 0x18, 0x1e, 0x0,
    0x3, 0xc, 0xf, 0x0, 0x3, 0x8c, 0x7, 0xff,
    0xff, 0xc4, 0x3, 0xff, 0xff, 0xe6, 0x0, 0xff,
    0xff, 0xf2, 0x0, 0x3f, 0xff, 0xf0,

    /* U+515C "兜" */
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x87, 0x80, 0x0, 0x1, 0xc7, 0x0, 0x0,
    0x3f, 0xf6, 0x78, 0x70, 0x38, 0x7f, 0xfb, 0xf0,
    0x38, 0x7f, 0xfb, 0xf0, 0x38, 0x70, 0x78, 0x70,
    0x38, 0x70, 0x78, 0x70, 0x38, 0x70, 0x78, 0x70,
    0x38, 0x70, 0x78, 0x70, 0x38, 0x70, 0x78, 0x70,
    0x38, 0x70, 0x78, 0x70, 0x38, 0x7f, 0xf8, 0x70,
    0x38, 0x7f, 0xf8, 0x70, 0x38, 0x70, 0x78, 0x70,
    0x38, 0x70, 0x78, 0x70, 0x38, 0x70, 0x78, 0x70,
    0x38, 0x70, 0x78, 0x70, 0x38, 0x70, 0x78, 0x70,
    0x38, 0x70, 0x78, 0x70, 0x3f, 0x7f, 0xfb, 0xf0,
    0x3f, 0x7f, 0xfb, 0xf0, 0x38, 0x70, 0x78, 0x70,
    0x38, 0x70, 0x78, 0x70, 0x38, 0x70, 0x78, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x70, 0x78, 0x0, 0x0, 0x70, 0x78, 0x0,
    0x0, 0x70, 0x78, 0x0, 0x0, 0x70, 0x78, 0x0,
    0x0, 0x70, 0x78, 0x2, 0x0, 0x70, 0x78, 0x2,
    0x0, 0xe0, 0x78, 0x2, 0x0, 0xe0, 0x78, 0x2,
    0x0, 0xc0, 0x78, 0x6, 0x1, 0xc0, 0x78, 0x6,
    0x1, 0x80, 0x78, 0x4, 0x3, 0x80, 0x78, 0x7,
    0x3, 0x0, 0x78, 0x7, 0x6, 0x0, 0x78, 0xf,
    0xc, 0x0, 0x7f, 0xff, 0x18, 0x0, 0x7f, 0xfe,
    0x20, 0x0, 0x3f, 0xfe, 0x40, 0x0, 0x1f, 0xfc,

    /* U+5162 "兢" */
    0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0xf, 0x0, 0x1e, 0x3, 0xff, 0xf9, 0xff,
    0xfd, 0xff, 0xfc, 0xff, 0xfe, 0x1, 0xe0, 0x3,
    0xc0, 0x0, 0xe0, 0x1, 0xc0, 0x0, 0x70, 0x0,
    0xe0, 0x0, 0x38, 0x0, 0x70, 0x0, 0x18, 0x0,
    0x30, 0x1, 0xf9, 0xe3, 0xd9, 0xe0, 0xff, 0xf1,
    0xff, 0xf0, 0x7f, 0xf8, 0xff, 0xf8, 0x3c, 0x3c,
    0x78, 0x3c, 0x1e, 0x1e, 0x3c, 0x1e, 0xf, 0xf,
    0x1e, 0xf, 0x7, 0x87, 0x8f, 0x7, 0x83, 0xc3,
    0xc7, 0x83, 0xc1, 0xe1, 0xe3, 0xc1, 0xe0, 0xf0,
    0xf1, 0xe0, 0xf0, 0x78, 0x78, 0xf0, 0x78, 0x3c,
    0x3c, 0x78, 0x3c, 0x1f, 0xfe, 0x3f, 0xfe, 0xf,
    0xf, 0x1f, 0xff, 0x7, 0x87, 0x8f, 0x7, 0x83,
    0xc3, 0xc7, 0x83, 0xc0, 0xf3, 0x81, 0xe7, 0x0,
    0x79, 0xc0, 0xf3, 0x80, 0x3c, 0xe0, 0x79, 0xc0,
    0x1e, 0x70, 0x3c, 0xe0, 0xf, 0x38, 0x1e, 0x70,
    0x87, 0x9c, 0xf, 0x38, 0x43, 0xce, 0x17, 0x9c,
    0x21, 0xe7, 0xb, 0x8e, 0x10, 0xe3, 0x89, 0xc7,
    0x18, 0x71, 0xcd, 0xc3, 0x8c, 0x38, 0xfc, 0xe1,
    0xc6, 0x38, 0xfc, 0xe0, 0xe3, 0x18, 0xfc, 0xe0,
    0x71, 0x8c, 0x7c, 0x60, 0x39, 0xcc, 0x3c, 0x60,
    0x1f, 0xe4, 0x18, 0x60, 0xf, 0xf4, 0x0, 0x60,
    0x7, 0xfe, 0x0, 0x60, 0x1, 0xf8, 0x0, 0x0,
    0x0, 0x0,

    /* U+5165 "入" */
    0x0, 0xc, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x6, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xb0, 0x0, 0x0, 0x7, 0xb8, 0x0,
    0x0, 0x7, 0xb8, 0x0, 0x0, 0x7, 0x98, 0x0,
    0x0, 0x7, 0x1c, 0x0, 0x0, 0xf, 0x1c, 0x0,
    0x0, 0xf, 0x1c, 0x0, 0x0, 0xe, 0x1e, 0x0,
    0x0, 0xe, 0xe, 0x0, 0x0, 0x1c, 0xe, 0x0,
    0x0, 0x1c, 0xf, 0x0, 0x0, 0x38, 0x7, 0x0,
    0x0, 0x38, 0x7, 0x80, 0x0, 0x30, 0x7, 0xc0,
    0x0, 0x70, 0x3, 0xc0, 0x0, 0x60, 0x3, 0xe0,
    0x0, 0xe0, 0x3, 0xf0, 0x0, 0xc0, 0x1, 0xf8,
    0x1, 0x80, 0x1, 0xfc, 0x3, 0x0, 0x0, 0xfe,
    0x3, 0x0, 0x0, 0x7f, 0x6, 0x0, 0x0, 0x7f,
    0xc, 0x0, 0x0, 0x3e, 0x8, 0x0, 0x0, 0x1e,
    0x10, 0x0, 0x0, 0xe, 0x30, 0x0, 0x0, 0x6,
    0x60, 0x0, 0x0, 0x2, 0xc0, 0x0, 0x0, 0x0,

    /* U+5168 "全" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x7a, 0x0,
    0x0, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x3c, 0xc0,
    0x0, 0x0, 0x3e, 0x60, 0x0, 0x0, 0x1e, 0x18,
    0x0, 0x0, 0xe, 0xe, 0x0, 0x0, 0xf, 0x3,
    0x80, 0x0, 0xf, 0x1, 0xe0, 0x0, 0x7, 0x0,
    0x78, 0x0, 0x7, 0x0, 0x1f, 0x0, 0x7, 0x0,
    0xf, 0xc0, 0x3, 0x0, 0x3, 0xf8, 0x3, 0x0,
    0x0, 0xfe, 0x3, 0x0, 0x0, 0x3f, 0x3, 0x0,
    0x0, 0xf, 0x83, 0xff, 0xff, 0xff, 0xc2, 0x7f,
    0xff, 0xfe, 0xe2, 0x0, 0x1e, 0x0, 0x32, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0x80, 0x1f, 0xff, 0xff, 0xc0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x7, 0xff, 0xff, 0xff, 0x83, 0xff, 0xff,
    0xff, 0xc0,

    /* U+5169 "兩" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0xf,
    0x0, 0xf0, 0xf, 0x1e, 0x1, 0xe0, 0x1e, 0x3c,
    0x3, 0xc0, 0x3c, 0x7f, 0xff, 0xff, 0xf8, 0xff,
    0xff, 0xff, 0xf1, 0xe0, 0x1e, 0x1, 0xe3, 0xc0,
    0x3c, 0x3, 0xc7, 0x80, 0x7b, 0x7, 0x8f, 0x20,
    0xf2, 0xf, 0x1e, 0x61, 0xe4, 0x1e, 0x3c, 0x43,
    0xcc, 0x3c, 0x78, 0x87, 0x98, 0x78, 0xf1, 0xf,
    0x30, 0xf1, 0xe2, 0x1e, 0x61, 0xe3, 0xc6, 0x3c,
    0xc3, 0xc7, 0x9c, 0x79, 0xc7, 0x8f, 0x38, 0xf3,
    0x8f, 0x1e, 0x71, 0xe7, 0x1e, 0x3c, 0xf3, 0xcf,
    0x3c, 0x79, 0xe7, 0xbe, 0x78, 0xf7, 0xef, 0x6e,
    0xf1, 0xed, 0xde, 0xdf, 0xe3, 0xdb, 0xfd, 0x3f,
    0xc7, 0xa3, 0x7e, 0x37, 0x8f, 0xc6, 0xf8, 0x6f,
    0x1f, 0xd, 0xf0, 0xde, 0x3e, 0xb, 0xc0, 0xbc,
    0x78, 0x27, 0x81, 0x78, 0xf0, 0xf, 0x0, 0xf1,
    0xe0, 0x1e, 0x1, 0xe3, 0xc0, 0x3c, 0x3, 0xc7,
    0x80, 0x78, 0x7, 0x8f, 0x0, 0xf0, 0xf, 0x1e,
    0x1, 0xe0, 0x1c, 0x3c, 0x3, 0xc0, 0x70, 0x78,
    0x7, 0x83, 0xc0, 0xf0, 0x0, 0x1e, 0x0,

    /* U+516B "八" */
    0x0, 0x0, 0xc, 0x0, 0x0, 0x1e, 0x6, 0x0,
    0x0, 0xf, 0x3, 0x0, 0x0, 0x7, 0x81, 0x80,
    0x0, 0x3, 0xc0, 0xc0, 0x0, 0x1, 0xe0, 0x60,
    0x0, 0x0, 0xf0, 0x30, 0x0, 0x0, 0x78, 0x18,
    0x0, 0x0, 0x3c, 0xc, 0x0, 0x0, 0x1e, 0x6,
    0x0, 0x0, 0xf, 0x3, 0x0, 0x0, 0x7, 0x81,
    0x80, 0x0, 0x3, 0xc0, 0xc0, 0x0, 0x1, 0xe0,
    0x60, 0x0, 0x0, 0xf0, 0x30, 0x0, 0x0, 0x70,
    0x18, 0x0, 0x0, 0x38, 0xe, 0x0, 0x0, 0x3c,
    0x7, 0x0, 0x0, 0x1e, 0x3, 0x80, 0x0, 0xf,
    0x0, 0xc0, 0x0, 0x7, 0x80, 0x60, 0x0, 0x3,
    0x80, 0x38, 0x0, 0x1, 0xc0, 0x1c, 0x0, 0x0,
    0xe0, 0xe, 0x0, 0x0, 0x70, 0x7, 0x0, 0x0,
    0x78, 0x3, 0xc0, 0x0, 0x38, 0x0, 0xe0, 0x0,
    0x1c, 0x0, 0x78, 0x0, 0xe, 0x0, 0x3c, 0x0,
    0x6, 0x0, 0x1e, 0x0, 0x7, 0x0, 0xf, 0x80,
    0x3, 0x0, 0x3, 0xc0, 0x1, 0x80, 0x1, 0xf0,
    0x1, 0xc0, 0x0, 0xfc, 0x0, 0xc0, 0x0, 0x3e,
    0x0, 0x60, 0x0, 0x1f, 0x80, 0x60, 0x0, 0x7,
    0xe0, 0x30, 0x0, 0x3, 0xf8, 0x30, 0x0, 0x0,
    0xfc, 0x10, 0x0, 0x0, 0x7f, 0x18, 0x0, 0x0,
    0x1f, 0x8, 0x0, 0x0, 0xf, 0x8c, 0x0, 0x0,
    0x3, 0xc4, 0x0, 0x0, 0x0, 0xe4, 0x0, 0x0,
    0x0, 0x36, 0x0, 0x0, 0x0, 0x8,

    /* U+516C "公" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x10, 0x0, 0x0, 0xf0, 0x10, 0x0,
    0x0, 0xf0, 0x18, 0x0, 0x0, 0xf0, 0x8, 0x0,
    0x1, 0xf0, 0x8, 0x0, 0x1, 0xf0, 0xc, 0x0,
    0x1, 0xe0, 0xc, 0x0, 0x1, 0xe0, 0xe, 0x0,
    0x1, 0xc0, 0x6, 0x0, 0x3, 0xc0, 0x7, 0x0,
    0x3, 0x80, 0x7, 0x0, 0x3, 0x80, 0x3, 0x80,
    0x7, 0x0, 0x3, 0xc0, 0x7, 0xf, 0x81, 0xe0,
    0x6, 0xf, 0x81, 0xf0, 0xc, 0xf, 0x80, 0xf8,
    0xc, 0xf, 0x80, 0xfe, 0x18, 0xf, 0x90, 0x7f,
    0x30, 0xf, 0x10, 0x3e, 0x20, 0xf, 0x10, 0x3e,
    0x40, 0x1f, 0x10, 0x1e, 0x80, 0x1f, 0x10, 0x6,
    0x0, 0x1e, 0x18, 0x2, 0x0, 0x1e, 0x18, 0x0,
    0x0, 0x1e, 0x18, 0x0, 0x0, 0x1c, 0x1c, 0x0,
    0x0, 0x3c, 0xc, 0x0, 0x0, 0x3c, 0xc, 0x0,
    0x0, 0x38, 0xe, 0x0, 0x0, 0x38, 0xe, 0x0,
    0x0, 0x70, 0xf, 0x0, 0x0, 0x60, 0xf, 0x0,
    0x0, 0x60, 0x7, 0x80, 0x0, 0xc0, 0x7, 0x80,
    0x0, 0xc0, 0x7, 0xc0, 0x1, 0x80, 0x3, 0xe0,
    0x1, 0x0, 0xf, 0xf0, 0x2, 0x0, 0x71, 0xf0,
    0x4, 0x1f, 0xe1, 0xf8, 0x3f, 0xff, 0x80, 0xf0,
    0x3f, 0xfe, 0x0, 0xf0, 0x1f, 0xf0, 0x0, 0x70,
    0x1f, 0x80, 0x0, 0x60, 0x38, 0x0, 0x0, 0x20,

    /* U+516D "六" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0,
    0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x70, 0x0,
    0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0x60,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xdf, 0xff, 0xff,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0, 0xf8,
    0x10, 0x0, 0x0, 0x7c, 0x8, 0x0, 0x0, 0x3c,
    0x4, 0x0, 0x0, 0x1e, 0x3, 0x0, 0x0, 0xf,
    0x1, 0x80, 0x0, 0x7, 0x80, 0xc0, 0x0, 0x3,
    0xc0, 0x60, 0x0, 0x1, 0xe0, 0x30, 0x0, 0x0,
    0xf0, 0x8, 0x0, 0x0, 0x78, 0x6, 0x0, 0x0,
    0x3c, 0x3, 0x0, 0x0, 0x1c, 0x1, 0x80, 0x0,
    0xe, 0x0, 0xe0, 0x0, 0xf, 0x0, 0x70, 0x0,
    0x7, 0x80, 0x1c, 0x0, 0x3, 0x80, 0xe, 0x0,
    0x1, 0xc0, 0x7, 0x80, 0x0, 0xe0, 0x3, 0xc0,
    0x0, 0x60, 0x0, 0xf0, 0x0, 0x70, 0x0, 0x7c,
    0x0, 0x30, 0x0, 0x3f, 0x0, 0x18, 0x0, 0xf,
    0x80, 0x1c, 0x0, 0x7, 0xe0, 0xc, 0x0, 0x1,
    0xfc, 0x6, 0x0, 0x0, 0xff, 0x6, 0x0, 0x0,
    0x3f, 0x86, 0x0, 0x0, 0x1f, 0x83, 0x0, 0x0,
    0x7, 0x83, 0x0, 0x0, 0x1, 0xc1, 0x0, 0x0,
    0x0, 0x61, 0x80, 0x0, 0x0, 0x10,

    /* U+516E "兮" */
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x7c, 0x8, 0x0,
    0x0, 0x3c, 0x4, 0x0, 0x0, 0x1e, 0x1, 0x0,
    0x0, 0xe, 0x0, 0x80, 0x0, 0xf, 0x0, 0x60,
    0x0, 0x7, 0x0, 0x38, 0x0, 0x3, 0x80, 0xc,
    0x0, 0x1, 0x80, 0x7, 0x0, 0x1, 0xc0, 0x3,
    0xc0, 0x0, 0xc0, 0x0, 0xf8, 0x0, 0xe0, 0x0,
    0x7e, 0x0, 0x60, 0x0, 0x1f, 0xc0, 0x60, 0x0,
    0x7, 0xf8, 0x30, 0x0, 0x3, 0xfc, 0x30, 0x0,
    0x0, 0xfe, 0x1f, 0xff, 0xff, 0xff, 0x1b, 0xff,
    0xff, 0xf7, 0x18, 0x1e, 0x0, 0x1, 0x8c, 0xf,
    0x0, 0x0, 0x6c, 0x7, 0x80, 0x0, 0x0, 0x3,
    0x80, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x1,
    0xc0, 0x7, 0x80, 0x0, 0xc0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xe0, 0x0, 0x7f, 0xff, 0xf0, 0x0,
    0x20, 0x0, 0x78, 0x0, 0x20, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0xf,
    0xc0, 0x0, 0x0, 0x18, 0x0, 0x0,

    /* U+5170 "兰" */
    0x1, 0x0, 0x0, 0x0, 0x3, 0x0, 0x1, 0x80,
    0x3, 0x0, 0x7, 0x0, 0x7, 0x0, 0xc, 0x0,
    0xe, 0x0, 0x30, 0x0, 0x1e, 0x0, 0x60, 0x0,
    0x1e, 0x1, 0x80, 0x0, 0x3c, 0x3, 0x0, 0x0,
    0x38, 0xc, 0x0, 0x0, 0x60, 0x18, 0x0, 0x0,
    0xc0, 0x60, 0x0, 0x0, 0x0, 0xc0, 0x0, 0x0,
    0x3, 0x0, 0x7, 0xff, 0xff, 0xff, 0x8f, 0xff,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff,
    0xe0, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0,

    /* U+5171 "共" */
    0x0, 0x70, 0x7, 0x0, 0x0, 0x38, 0x3, 0x80,
    0x0, 0x1c, 0x1, 0xc0, 0x0, 0xe, 0x0, 0xe0,
    0x0, 0x7, 0x0, 0x70, 0x0, 0x3, 0x80, 0x38,
    0x0, 0x1, 0xc0, 0x1c, 0x0, 0x0, 0xe0, 0xe,
    0x0, 0x0, 0x70, 0x7, 0x0, 0x0, 0x38, 0x3,
    0x80, 0xf, 0xff, 0xff, 0xff, 0x87, 0xff, 0xff,
    0xff, 0xc0, 0x7, 0x0, 0x70, 0x0, 0x3, 0x80,
    0x38, 0x0, 0x1, 0xc0, 0x1c, 0x0, 0x0, 0xe0,
    0xe, 0x0, 0x0, 0x70, 0x7, 0x0, 0x0, 0x38,
    0x3, 0x80, 0x0, 0x1c, 0x1, 0xc0, 0x0, 0xe,
    0x0, 0xe0, 0x0, 0x7, 0x0, 0x70, 0x0, 0x3,
    0x80, 0x38, 0x0, 0x1, 0xc0, 0x1c, 0x0, 0x0,
    0xe0, 0xe, 0x0, 0x0, 0x70, 0x7, 0x0, 0x0,
    0x38, 0x3, 0x80, 0x0, 0x1c, 0x1, 0xc0, 0x0,
    0xe, 0x0, 0xe0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x4, 0x0,
    0x0, 0x7c, 0x1, 0x0, 0x0, 0x3e, 0x0, 0x80,
    0x0, 0x1e, 0x0, 0x60, 0x0, 0x1f, 0x0, 0x18,
    0x0, 0xf, 0x0, 0xe, 0x0, 0x7, 0x0, 0x7,
    0x80, 0x7, 0x0, 0x3, 0xf0, 0x3, 0x0, 0x0,
    0xfe, 0x3, 0x0, 0x0, 0x3f, 0x3, 0x0, 0x0,
    0x1f, 0x83, 0x0, 0x0, 0x7, 0xc1, 0x0, 0x0,
    0x1, 0xe1, 0x0, 0x0, 0x0, 0x30,

    /* U+5173 "关" */
    0x0, 0x0, 0x0, 0xc0, 0x0, 0x40, 0x0, 0xe0,
    0x0, 0x30, 0x0, 0x60, 0x0, 0x1e, 0x0, 0x60,
    0x0, 0x7, 0x80, 0x30, 0x0, 0x3, 0xe0, 0x30,
    0x0, 0x0, 0xf0, 0x18, 0x0, 0x0, 0x78, 0x18,
    0x0, 0x0, 0x1c, 0xc, 0x0, 0x0, 0x4, 0xc,
    0x0, 0x7, 0xff, 0xff, 0xff, 0x3, 0xff, 0xff,
    0xff, 0x80, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0xf, 0x40, 0x0,
    0x0, 0x7, 0xb0, 0x0, 0x0, 0x7, 0x98, 0x0,
    0x0, 0x3, 0xc6, 0x0, 0x0, 0x3, 0xc3, 0x80,
    0x0, 0x3, 0xc1, 0xe0, 0x0, 0x1, 0xc0, 0x78,
    0x0, 0x1, 0xc0, 0x1e, 0x0, 0x1, 0xc0, 0xf,
    0xc0, 0x1, 0xc0, 0x3, 0xf8, 0x1, 0xc0, 0x0,
    0xff, 0x1, 0xc0, 0x0, 0x7f, 0x1, 0xc0, 0x0,
    0x1f, 0x81, 0x80, 0x0, 0x3, 0xc1, 0x80, 0x0,
    0x0, 0xe3, 0x0, 0x0, 0x0, 0x10,

    /* U+5174 "兴" */
    0x0, 0x2, 0x0, 0x38, 0x0, 0x2, 0x0, 0x30,
    0x10, 0x2, 0x0, 0x70, 0x8, 0x2, 0x0, 0x70,
    0x8, 0x3, 0x0, 0x60, 0xc, 0x3, 0x0, 0x60,
    0xc, 0x3, 0x0, 0xe0, 0x6, 0x3, 0x80, 0xe0,
    0x6, 0x3, 0x80, 0xc0, 0x7, 0x3, 0x80, 0xc0,
    0x7, 0x3, 0x80, 0xc0, 0x7, 0x83, 0xc1, 0xc0,
    0x3, 0x81, 0xc1, 0x80, 0x3, 0xc1, 0xc1, 0x80,
    0x3, 0xc1, 0xe1, 0x80, 0x3, 0xe1, 0xe3, 0x0,
    0x1, 0xe1, 0xc3, 0x0, 0x1, 0xe1, 0xc3, 0x0,
    0x1, 0xe1, 0x83, 0x0, 0x0, 0xc1, 0x2, 0x0,
    0x0, 0xc0, 0x6, 0x0, 0x0, 0x80, 0x6, 0x0,
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0xf8, 0x8, 0x0,
    0x0, 0xf8, 0x4, 0x0, 0x0, 0xf0, 0x4, 0x0,
    0x0, 0xf0, 0x6, 0x0, 0x1, 0xf0, 0x3, 0x0,
    0x1, 0xe0, 0x3, 0x0, 0x1, 0xc0, 0x3, 0x80,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0x80, 0x1, 0xf0,
    0x7, 0x0, 0x1, 0xf8, 0x6, 0x0, 0x0, 0xfe,
    0xe, 0x0, 0x0, 0xff, 0x1c, 0x0, 0x0, 0x7e,
    0x18, 0x0, 0x0, 0x3e, 0x30, 0x0, 0x0, 0x1e,
    0x60, 0x0, 0x0, 0xe, 0xc0, 0x0, 0x0, 0x2,

    /* U+5175 "兵" */
    0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x78, 0x3, 0xfe, 0x0, 0x3c, 0x1f, 0xff,
    0x0, 0x1f, 0xff, 0xf0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xf8, 0x7, 0xff, 0xff, 0xfc, 0x3, 0xc0,
    0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0, 0xf0,
    0x3, 0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0, 0xf,
    0x0, 0x3c, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x3,
    0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0,
    0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0,
    0x3c, 0x0, 0xf0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0x1, 0x0, 0x0, 0x3e, 0x0, 0xc0,
    0x0, 0x1f, 0x0, 0x60, 0x0, 0xf, 0x0, 0x38,
    0x0, 0xf, 0x80, 0xf, 0x0, 0x7, 0x80, 0x7,
    0xc0, 0x3, 0x80, 0x3, 0xf8, 0x3, 0x80, 0x0,
    0xfe, 0x3, 0x80, 0x0, 0x3e, 0x1, 0x80, 0x0,
    0xf, 0x1, 0x80, 0x0, 0x3, 0x81, 0x80, 0x0,
    0x0, 0xc1, 0x0, 0x0, 0x0, 0x20,

    /* U+5176 "其" */
    0x1, 0xf0, 0x1, 0xe0, 0x0, 0xf8, 0x0, 0xf0,
    0x0, 0x7c, 0x0, 0x78, 0x0, 0x3e, 0x0, 0x3c,
    0x0, 0x1f, 0x0, 0x1e, 0x0, 0xf, 0x80, 0xf,
    0x1, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff,
    0xff, 0x1, 0xf0, 0x1, 0xe0, 0x0, 0xf8, 0x0,
    0xf0, 0x0, 0x7c, 0x0, 0x78, 0x0, 0x3e, 0x0,
    0x3c, 0x0, 0x1f, 0x0, 0x1e, 0x0, 0xf, 0x80,
    0xf, 0x0, 0x7, 0xff, 0xe7, 0x80, 0x3, 0xff,
    0xf3, 0xc0, 0x1, 0xf0, 0x1, 0xe0, 0x0, 0xf8,
    0x0, 0xf0, 0x0, 0x7c, 0x0, 0x78, 0x0, 0x3e,
    0x0, 0x3c, 0x0, 0x1f, 0x0, 0x1e, 0x0, 0xf,
    0x80, 0xf, 0x0, 0x7, 0xff, 0xe7, 0x80, 0x3,
    0xff, 0xf3, 0xc0, 0x1, 0xf0, 0x1, 0xe0, 0x0,
    0xf8, 0x0, 0xf0, 0x0, 0x7c, 0x0, 0x78, 0x0,
    0x3e, 0x0, 0x3c, 0x0, 0x1f, 0x0, 0x1e, 0x0,
    0xf, 0x80, 0xf, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x80,
    0x0, 0xf, 0x0, 0x20, 0x0, 0x7, 0x80, 0x18,
    0x0, 0x7, 0xc0, 0xe, 0x0, 0x3, 0xc0, 0x7,
    0x80, 0x1, 0xe0, 0x1, 0xf0, 0x1, 0xe0, 0x0,
    0xfe, 0x1, 0xe0, 0x0, 0x3f, 0x0, 0xe0, 0x0,
    0x1f, 0x0, 0xc0, 0x0, 0x7, 0x80, 0xc0, 0x0,
    0x0, 0xc0, 0xc0, 0x0, 0x0, 0x10,

    /* U+5177 "具" */
    0x3, 0xc0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0x78,
    0x0, 0xff, 0xff, 0xfc, 0x0, 0x7f, 0xff, 0xfe,
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x1e, 0x0, 0x7,
    0x80, 0xf, 0x0, 0x3, 0xc0, 0x7, 0x80, 0x1,
    0xe0, 0x3, 0xc0, 0x0, 0xf0, 0x1, 0xff, 0xfe,
    0x78, 0x0, 0xff, 0xff, 0x3c, 0x0, 0x78, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x1e, 0x0,
    0x7, 0x80, 0xf, 0x0, 0x3, 0xc0, 0x7, 0xff,
    0xf9, 0xe0, 0x3, 0xff, 0xfc, 0xf0, 0x1, 0xe0,
    0x0, 0x78, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0x78,
    0x0, 0x1e, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x1e,
    0x0, 0x7, 0x80, 0xf, 0xff, 0xf3, 0xc0, 0x7,
    0xff, 0xf9, 0xe0, 0x3, 0xc0, 0x0, 0xf0, 0x1,
    0xe0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0x3c, 0x0,
    0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x1e, 0x0, 0x7, 0x83, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x2, 0x0,
    0x0, 0xf, 0x80, 0x80, 0x0, 0x7, 0xc0, 0x70,
    0x0, 0x7, 0xc0, 0x3c, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x3, 0xc0, 0x7, 0xe0, 0x3, 0xc0, 0x1,
    0xfe, 0x1, 0xc0, 0x0, 0x7f, 0x81, 0xc0, 0x0,
    0x1f, 0x81, 0x80, 0x0, 0x7, 0xc3, 0x80, 0x0,
    0x1, 0xe3, 0x0, 0x0, 0x0, 0x30,

    /* U+5178 "典" */
    0x0, 0x1e, 0x3c, 0x0, 0x0, 0xf, 0x1e, 0x0,
    0x0, 0x7, 0x8f, 0x0, 0x0, 0x3, 0xc7, 0x80,
    0x0, 0x1, 0xe3, 0xc0, 0x0, 0x78, 0xf1, 0xe3,
    0xc0, 0x3c, 0x78, 0xf1, 0xe0, 0x1f, 0xff, 0xff,
    0xf0, 0xf, 0xff, 0xff, 0xf8, 0x7, 0x8f, 0x1e,
    0x3c, 0x3, 0xc7, 0x8f, 0x1e, 0x1, 0xe3, 0xc7,
    0x8f, 0x0, 0xf1, 0xe3, 0xc7, 0x80, 0x78, 0xf1,
    0xe3, 0xc0, 0x3c, 0x78, 0xf1, 0xe0, 0x1e, 0x3c,
    0x78, 0xf0, 0xf, 0x1e, 0x3c, 0x78, 0x7, 0x8f,
    0x1e, 0x3c, 0x3, 0xff, 0xff, 0xfe, 0x1, 0xff,
    0xff, 0xff, 0x0, 0xf1, 0xe3, 0xc7, 0x80, 0x78,
    0xf1, 0xe3, 0xc0, 0x3c, 0x78, 0xf1, 0xe0, 0x1e,
    0x3c, 0x78, 0xf0, 0xf, 0x1e, 0x3c, 0x78, 0x7,
    0x8f, 0x1e, 0x3c, 0x3, 0xc7, 0x8f, 0x1e, 0x1,
    0xe3, 0xc7, 0x8f, 0x0, 0xf1, 0xe3, 0xc7, 0x87,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7c, 0x4, 0x0, 0x0, 0x3c, 0x1, 0x0,
    0x0, 0x1e, 0x0, 0x80, 0x0, 0xf, 0x0, 0x60,
    0x0, 0xf, 0x0, 0x38, 0x0, 0x7, 0x80, 0xf,
    0x0, 0x3, 0x80, 0x7, 0xe0, 0x3, 0x80, 0x1,
    0xfc, 0x3, 0x80, 0x0, 0x7e, 0x1, 0x80, 0x0,
    0x1f, 0x1, 0x80, 0x0, 0x7, 0x83, 0x0, 0x0,
    0x1, 0xc3, 0x0, 0x0, 0x0, 0x20,

    /* U+5179 "兹" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x1, 0x80,
    0x0, 0x30, 0x3, 0x80, 0x0, 0x38, 0x3, 0x0,
    0x0, 0x3c, 0x6, 0x0, 0x0, 0x1c, 0xe, 0x0,
    0x0, 0x1c, 0xc, 0x0, 0x0, 0x18, 0x1c, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x7, 0x8e, 0x1c, 0x7c, 0x7, 0x8e, 0x1c, 0x78,
    0x7, 0xe, 0x18, 0x78, 0x7, 0x1e, 0x38, 0x78,
    0xe, 0x1e, 0x30, 0x78, 0xc, 0x1e, 0x30, 0x78,
    0x8, 0x1c, 0x60, 0xf0, 0x18, 0x3c, 0x40, 0xf0,
    0x30, 0xfc, 0x87, 0xf0, 0x7f, 0xb9, 0xfe, 0xe0,
    0x7e, 0x39, 0xf8, 0xe0, 0x38, 0x70, 0xe1, 0xe0,
    0x0, 0x70, 0x81, 0xc0, 0x0, 0xe0, 0x1, 0xc0,
    0x0, 0xe0, 0x3, 0x80, 0x0, 0xc0, 0x3, 0xa0,
    0x1, 0x90, 0x7, 0x20, 0x3, 0x90, 0x6, 0x30,
    0x3, 0x18, 0xe, 0x30, 0x6, 0x18, 0xc, 0x30,
    0x4, 0x18, 0x18, 0x38, 0x8, 0x1c, 0x10, 0x38,
    0x18, 0x1c, 0x20, 0x3c, 0x10, 0x1e, 0x40, 0xfe,
    0x20, 0xef, 0x83, 0x9f, 0x7f, 0xcf, 0xff, 0x1e,
    0x7f, 0xe, 0xfe, 0x1e, 0x7e, 0x6, 0x78, 0xc,
    0x70, 0x6, 0x60, 0xc, 0x40, 0x2, 0x0, 0x4,
    0x0, 0x0, 0x0, 0x0,

    /* U+517B "养" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x18, 0x0, 0xc0,
    0x0, 0xe, 0x0, 0xc0, 0x0, 0x3, 0xc0, 0xe0,
    0x0, 0x1, 0xe0, 0x60, 0x0, 0x0, 0x70, 0x70,
    0x0, 0x0, 0x10, 0x30, 0x0, 0x7f, 0xff, 0xff,
    0xfe, 0x3f, 0xff, 0xff, 0xff, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x7f, 0xff,
    0xff, 0xe0, 0x3f, 0xff, 0xff, 0xf0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x3, 0xc0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xf8, 0x0,
    0xe0, 0x30, 0x0, 0x0, 0xf0, 0xc, 0x0, 0x0,
    0xf0, 0x6, 0x0, 0x0, 0x70, 0x3, 0x80, 0x0,
    0x78, 0x0, 0xe0, 0x0, 0x78, 0x0, 0x38, 0x0,
    0x3f, 0x80, 0xff, 0x0, 0x3b, 0xc0, 0x7f, 0xe0,
    0x39, 0xe0, 0x3f, 0xfc, 0x38, 0xf0, 0x1e, 0xfe,
    0x38, 0x78, 0xf, 0x1e, 0x30, 0x38, 0x7, 0x87,
    0x30, 0x1c, 0x3, 0xc0, 0x80, 0xe, 0x1, 0xe0,
    0x0, 0x7, 0x0, 0xf0, 0x0, 0x7, 0x80, 0x78,
    0x0, 0x3, 0x80, 0x3c, 0x0, 0x1, 0xc0, 0x1e,
    0x0, 0x0, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0x7,
    0x80, 0x0, 0x60, 0x3, 0xc0, 0x0, 0x60, 0x1,
    0xe0, 0x0, 0x60, 0x0, 0xf0, 0x0, 0x60, 0x0,
    0x78, 0x0, 0x60, 0x0, 0x3c, 0x0, 0x60, 0x0,
    0x1e, 0x0,

    /* U+517C "兼" */
    0x0, 0x40, 0x0, 0x0, 0x0, 0xc, 0x0, 0x30,
    0x0, 0x1, 0xc0, 0x18, 0x0, 0x0, 0x78, 0xc,
    0x0, 0x0, 0xe, 0x6, 0x0, 0x0, 0x3, 0x83,
    0x0, 0x1, 0xff, 0xff, 0xff, 0xf8, 0x7f, 0xff,
    0xff, 0xfe, 0x0, 0x1e, 0x3c, 0x0, 0x0, 0x7,
    0x8f, 0x0, 0x0, 0x1, 0xe3, 0xc0, 0x0, 0x0,
    0x78, 0xf0, 0x0, 0x0, 0x1e, 0x3c, 0x38, 0x1,
    0xff, 0xff, 0xfe, 0x0, 0x7f, 0xff, 0xff, 0x80,
    0x0, 0x78, 0xf0, 0xe0, 0x0, 0x1e, 0x3c, 0x38,
    0x0, 0x7, 0x8f, 0xe, 0x0, 0x1, 0xe3, 0xc3,
    0x80, 0x0, 0x78, 0xf0, 0xe0, 0x7f, 0xff, 0xff,
    0xff, 0xdf, 0xff, 0xff, 0xff, 0xf0, 0x1, 0xe3,
    0xc3, 0x80, 0x0, 0x78, 0xf0, 0xe0, 0x0, 0x1e,
    0x3c, 0x38, 0x0, 0x7, 0x8f, 0xe, 0x0, 0x1,
    0xe3, 0xc3, 0x80, 0x3f, 0xff, 0xff, 0xe0, 0x0,
    0x3e, 0x3d, 0x38, 0x0, 0xf, 0x8f, 0x4e, 0x0,
    0x3, 0xe3, 0xd3, 0x80, 0x1, 0xf8, 0xf4, 0x0,
    0x0, 0x7e, 0x3d, 0x80, 0x0, 0x3f, 0x8f, 0x60,
    0x0, 0xf, 0xe3, 0xdc, 0x0, 0x7, 0x78, 0xf3,
    0x0, 0x1, 0xde, 0x3c, 0xe0, 0x0, 0xe7, 0x8f,
    0x3e, 0x0, 0x71, 0xe3, 0xc7, 0xc0, 0x18, 0x78,
    0xf0, 0xfe, 0xc, 0x1e, 0x3c, 0x3f, 0x6, 0x7,
    0x8f, 0x7, 0xc3, 0x1, 0xe3, 0xc0, 0xf0, 0x80,
    0x78, 0xf0, 0x1c, 0x40, 0x1e, 0x3c, 0x2, 0x0,
    0x7, 0x8f, 0x0, 0x0, 0x1, 0xe3, 0xc0, 0x0,

    /* U+517D "兽" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x38, 0x0, 0xc0,
    0x0, 0xf, 0x0, 0xc0, 0x0, 0x7, 0xc0, 0xe0,
    0x0, 0x1, 0xe0, 0x60, 0x0, 0xf0, 0x60, 0x61,
    0xe0, 0x78, 0x30, 0x60, 0xf0, 0x3f, 0xff, 0xff,
    0xf8, 0x1f, 0xff, 0xff, 0xfc, 0xf, 0x0, 0xf0,
    0x1e, 0x7, 0x80, 0x78, 0xf, 0x3, 0xc0, 0x3c,
    0x7, 0x81, 0xe0, 0x1e, 0x3, 0xc0, 0xff, 0xff,
    0xff, 0xe0, 0x7f, 0xff, 0xff, 0xf0, 0x3c, 0x3,
    0xc0, 0x78, 0x1e, 0x1, 0xe0, 0x3c, 0xf, 0x0,
    0xf0, 0x1e, 0x7, 0x80, 0x78, 0xf, 0x3, 0xc0,
    0x3c, 0x7, 0x81, 0xff, 0xff, 0xff, 0xc0, 0xff,
    0xff, 0xff, 0xe0, 0x78, 0x0, 0x0, 0xf0, 0x3c,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x3, 0xc0,
    0xf, 0x0, 0x1, 0xe0, 0x7, 0xff, 0xff, 0xf0,
    0x3, 0xff, 0xff, 0xf8, 0x1, 0xe0, 0x0, 0x3c,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0, 0xf,
    0x0, 0x3c, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x3,
    0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0,
    0xf0, 0x3, 0xff, 0xff, 0xf8, 0x1, 0xff, 0xff,
    0xfc, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0,
    0xf, 0x0, 0x3c, 0x0, 0x7, 0x80,

    /* U+5180 "冀" */
    0x0, 0x3c, 0x3c, 0x0, 0x0, 0x1e, 0x1e, 0x2,
    0x0, 0xf, 0xf, 0x7, 0xf, 0xff, 0x87, 0x8e,
    0x27, 0xff, 0xc3, 0xde, 0x20, 0x1, 0xe1, 0xfc,
    0x10, 0x0, 0xf0, 0xf8, 0x8, 0x0, 0xf8, 0x78,
    0x4, 0x1f, 0xbc, 0x3c, 0x7, 0x7f, 0x9e, 0x1f,
    0xff, 0x9f, 0x8f, 0xf, 0xff, 0xcf, 0x7, 0x83,
    0xff, 0xc4, 0x3, 0xc1, 0xff, 0xc0, 0x3c, 0x0,
    0x7, 0x80, 0x1f, 0xff, 0xff, 0xc0, 0xf, 0xff,
    0xff, 0xe0, 0x7, 0x83, 0xc0, 0xf0, 0x3, 0xc1,
    0xe0, 0x78, 0x1, 0xff, 0xff, 0xfc, 0x0, 0xff,
    0xff, 0xfe, 0x0, 0x78, 0x3c, 0xf, 0x0, 0x3c,
    0x1e, 0x7, 0x80, 0x1e, 0xf, 0x3, 0xc0, 0xf,
    0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0xf0, 0x3,
    0xc0, 0x0, 0x78, 0x0, 0x3c, 0x3, 0xc0, 0x0,
    0x1e, 0x1, 0xe0, 0x0, 0xf, 0x0, 0xf0, 0x1,
    0xff, 0xff, 0xff, 0xe0, 0xff, 0xff, 0xff, 0xf0,
    0x1, 0xe0, 0x1e, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0x78, 0x7, 0x80, 0x0, 0x3c, 0x3, 0xc0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0x0, 0x40, 0x0, 0x3, 0xe0, 0x10,
    0x0, 0x3, 0xe0, 0xc, 0x0, 0x1, 0xe0, 0x3,
    0xc0, 0x1, 0xe0, 0x1, 0xfe, 0x1, 0xe0, 0x0,
    0x7f, 0x1, 0xc0, 0x0, 0x1f, 0x1, 0x80, 0x0,
    0x7, 0x83, 0x0, 0x0, 0x0, 0xe0,

    /* U+5181 "冁" */
    0x0, 0x10, 0x0, 0x0, 0x10, 0xc, 0xe0, 0x7,
    0x8c, 0xc, 0x70, 0x3, 0xc3, 0x6, 0x3f, 0xff,
    0xe1, 0xc6, 0x1f, 0xff, 0xf0, 0x73, 0xe, 0x0,
    0x78, 0x39, 0x7, 0x0, 0x3c, 0x9, 0x83, 0x80,
    0x1e, 0x4, 0x81, 0xc0, 0xf, 0x38, 0xdc, 0xe0,
    0x7, 0x9f, 0xfe, 0x7f, 0xff, 0xce, 0x67, 0x3f,
    0xff, 0xe7, 0x33, 0x9c, 0x0, 0xf3, 0x99, 0xce,
    0x31, 0xc1, 0xcc, 0xe7, 0x18, 0xe0, 0xe6, 0x73,
    0x8c, 0x70, 0x73, 0x39, 0xc6, 0x38, 0x39, 0x9c,
    0xe3, 0x1c, 0x1f, 0xfe, 0x7f, 0xff, 0xce, 0x67,
    0x3f, 0xff, 0xe7, 0x33, 0x9c, 0x63, 0x83, 0x99,
    0xce, 0x31, 0xc1, 0xcc, 0xe7, 0x18, 0xe0, 0xe6,
    0x73, 0x8c, 0x70, 0x73, 0x39, 0xc6, 0x38, 0x39,
    0x9c, 0xe3, 0x1c, 0x1f, 0xfe, 0x7f, 0xff, 0xee,
    0x67, 0x3f, 0xff, 0xf7, 0x33, 0x9c, 0xe8, 0x0,
    0x18, 0xe, 0x72, 0x18, 0xc, 0x7, 0x39, 0x18,
    0x6, 0x3, 0x9c, 0x8c, 0x3, 0x1, 0xce, 0x4c,
    0x7f, 0xfe, 0xe7, 0x24, 0x3f, 0xff, 0x73, 0x9e,
    0x0, 0x60, 0x39, 0xce, 0x0, 0x30, 0x1c, 0xe7,
    0x0, 0x18, 0xc, 0x73, 0x80, 0xc, 0xe, 0x38,
    0xe0, 0x6, 0x7, 0x1c, 0x78, 0x3, 0x3, 0xe,
    0x7f, 0x1, 0x81, 0x87, 0xef, 0x80, 0xc1, 0x9f,
    0xe3, 0xc0, 0x60, 0x87, 0xe1, 0xe0, 0x30, 0xc3,
    0xc0, 0x70, 0x18, 0x41, 0xc0, 0x18, 0xc, 0x40,
    0x80, 0x0,

    /* U+5182 "冂" */
    0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x1e, 0xf0, 0x0, 0x7, 0xcf, 0x0, 0x1,
    0x90,

    /* U+5185 "内" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0xf0, 0xf, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0xf0, 0xf, 0xf0, 0xf, 0x0, 0xff, 0x0, 0xf0,
    0xf, 0xf0, 0xf, 0x0, 0xff, 0x0, 0xf0, 0xf,
    0xf0, 0xf, 0x0, 0xff, 0x0, 0xf0, 0xf, 0xf0,
    0xf, 0x0, 0xff, 0x0, 0xf0, 0xf, 0xf0, 0xf,
    0x0, 0xff, 0x1, 0xf0, 0xf, 0xf0, 0x1f, 0x80,
    0xff, 0x1, 0xd8, 0xf, 0xf0, 0x1d, 0xc0, 0xff,
    0x1, 0x8c, 0xf, 0xf0, 0x38, 0xe0, 0xff, 0x3,
    0xf, 0xf, 0xf0, 0x70, 0x78, 0xff, 0x6, 0x7,
    0xcf, 0xf0, 0xc0, 0x3f, 0xff, 0x18, 0x3, 0xef,
    0xf3, 0x0, 0x1e, 0xff, 0x60, 0x1, 0xcf, 0xfc,
    0x0, 0xc, 0xff, 0x0, 0x0, 0x4f, 0xf0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x1, 0xef, 0x0,
    0x0, 0x3e, 0xf0, 0x0, 0xf, 0xcf, 0x0, 0x3,
    0xb0,

    /* U+5187 "冇" */
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x3e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xff, 0xff,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0xf0,
    0x0, 0xe0, 0x0, 0xf0, 0x1, 0xff, 0xff, 0xf0,
    0x1, 0xff, 0xff, 0xf0, 0x3, 0xe0, 0x0, 0xf0,
    0x3, 0xe0, 0x0, 0xf0, 0x7, 0xe0, 0x0, 0xf0,
    0x7, 0xe0, 0x0, 0xf0, 0xd, 0xe0, 0x0, 0xf0,
    0x9, 0xe0, 0x0, 0xf0, 0x19, 0xe0, 0x0, 0xf0,
    0x31, 0xe0, 0x0, 0xf0, 0x61, 0xe0, 0x0, 0xf0,
    0x41, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0,
    0x1, 0xe0, 0x1, 0xf0, 0x1, 0xe0, 0x1, 0xe0,
    0x1, 0xe0, 0x7, 0x80, 0x1, 0xe0, 0x1a, 0x0,

    /* U+5188 "冈" */
    0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf4, 0x0, 0xf8, 0xff,
    0x40, 0xf, 0x8f, 0xf2, 0x0, 0xf8, 0xff, 0x10,
    0xf, 0x8f, 0xf1, 0x0, 0xf8, 0xff, 0x18, 0xf,
    0xf, 0xf0, 0xc0, 0xf0, 0xff, 0xc, 0x1f, 0xf,
    0xf0, 0x61, 0xf0, 0xff, 0x7, 0x1e, 0xf, 0xf0,
    0x31, 0xe0, 0xff, 0x3, 0xbc, 0xf, 0xf0, 0x1f,
    0xc0, 0xff, 0x1, 0xf8, 0xf, 0xf0, 0xf, 0x80,
    0xff, 0x0, 0xf0, 0xf, 0xf0, 0xf, 0x80, 0xff,
    0x0, 0xf8, 0xf, 0xf0, 0x1f, 0xc0, 0xff, 0x1,
    0xbe, 0xf, 0xf0, 0x39, 0xf0, 0xff, 0x7, 0x1f,
    0x8f, 0xf0, 0x60, 0xf8, 0xff, 0xc, 0xf, 0xcf,
    0xf1, 0x80, 0x7c, 0xff, 0x30, 0x3, 0xcf, 0xf2,
    0x0, 0x38, 0xff, 0x40, 0x1, 0x8f, 0xf8, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x1f, 0xf0, 0x0, 0x1, 0xef, 0x0,
    0x0, 0x7c, 0xf0, 0x0, 0xf, 0x8f, 0x0, 0x3,
    0x20,

    /* U+5189 "冉" */
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x0, 0x70, 0x0, 0x0, 0x0, 0x38, 0x0,
    0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xe, 0x0,
    0x0, 0x1e, 0x7, 0x3, 0xc0, 0xf, 0xff, 0xff,
    0xe0, 0x7, 0xff, 0xff, 0xf0, 0x3, 0xc0, 0xe0,
    0x78, 0x1, 0xe0, 0x70, 0x3c, 0x0, 0xf0, 0x38,
    0x1e, 0x0, 0x78, 0x1c, 0xf, 0x0, 0x3c, 0xe,
    0x7, 0x80, 0x1e, 0x7, 0x3, 0xc0, 0xf, 0x3,
    0x81, 0xe0, 0x7, 0x81, 0xc0, 0xf0, 0x3, 0xff,
    0xff, 0xf8, 0x1, 0xff, 0xff, 0xfc, 0x0, 0xf0,
    0x38, 0x1e, 0x0, 0x78, 0x1c, 0xf, 0x0, 0x3c,
    0xe, 0x7, 0x80, 0x1e, 0x7, 0x3, 0xc0, 0xf,
    0x3, 0x81, 0xe0, 0x7, 0x81, 0xc0, 0xf0, 0x3,
    0xc0, 0xe0, 0x78, 0x1, 0xe0, 0x70, 0x3c, 0x0,
    0xf0, 0x38, 0x1e, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x1e, 0x0, 0x3, 0xc0,
    0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0, 0xf0,
    0x3, 0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x78, 0x0, 0xf,
    0x0, 0x3c, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x3,
    0xc0, 0xf, 0x0, 0x1, 0xe0, 0x7, 0x80, 0x0,
    0xf0, 0x3, 0xc0, 0x0, 0x78, 0x1, 0xe0, 0x0,
    0x3c, 0x0, 0xf0, 0x0, 0x3e, 0x0, 0x78, 0x0,
    0x7e, 0x0, 0x3c, 0x0, 0xfc, 0x0,

    /* U+518C "册" */
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xf, 0xfc, 0x7f, 0xf0, 0xf, 0xfc, 0x7f, 0xf0,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0xe, 0x1c, 0x78, 0x70, 0xe, 0x1c, 0x78, 0x70,
    0x1e, 0x1c, 0x70, 0x70, 0x1c, 0x1c, 0x70, 0x70,
    0x1c, 0x1c, 0x70, 0x70, 0x1c, 0x1c, 0x60, 0x70,
    0x18, 0x1c, 0xe0, 0x70, 0x30, 0x3c, 0xc0, 0xf0,
    0x30, 0x78, 0x80, 0xe0, 0x60, 0xf1, 0x1, 0xc0,
    0x43, 0x42, 0x7, 0x80, 0x80, 0x2, 0x1e, 0x0,

    /* U+518D "再" */
    0x3f, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0xe, 0x3, 0xc0,
    0xf0, 0x7, 0xff, 0xff, 0xf8, 0x3, 0xff, 0xff,
    0xfc, 0x1, 0xc0, 0x78, 0x1e, 0x0, 0xe0, 0x3c,
    0xf, 0x0, 0x70, 0x1e, 0x7, 0x80, 0x38, 0xf,
    0x3, 0xc0, 0x1c, 0x7, 0x81, 0xe0, 0xe, 0x3,
    0xc0, 0xf0, 0x7, 0x1, 0xe0, 0x78, 0x3, 0x80,
    0xf0, 0x3c, 0x1, 0xff, 0xff, 0xfe, 0x0, 0xff,
    0xff, 0xff, 0x0, 0x70, 0x1e, 0x7, 0x80, 0x38,
    0xf, 0x3, 0xc0, 0x1c, 0x7, 0x81, 0xe0, 0xe,
    0x3, 0xc0, 0xf0, 0x7, 0x1, 0xe0, 0x78, 0x3,
    0x80, 0xf0, 0x3c, 0x1, 0xc0, 0x78, 0x1e, 0x0,
    0xe0, 0x3c, 0xf, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x1c, 0x0, 0x1, 0xe0,
    0xe, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0, 0x78,
    0x3, 0x80, 0x0, 0x3c, 0x1, 0xc0, 0x0, 0x1e,
    0x0, 0xe0, 0x0, 0xf, 0x0, 0x70, 0x0, 0x7,
    0x80, 0x38, 0x0, 0x3, 0xc0, 0x1c, 0x0, 0x1,
    0xe0, 0xe, 0x0, 0x0, 0xf0, 0x7, 0x0, 0x0,
    0x78, 0x3, 0x80, 0x0, 0x7c, 0x1, 0xc0, 0x0,
    0x7c, 0x0, 0xe0, 0x1, 0xfc, 0x0, 0x70, 0x3,
    0x98, 0x0,

    /* U+5192 "冒" */
    0xf0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x7, 0xf8, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0xf, 0xf3, 0xff, 0xff,
    0x7f, 0x9f, 0xff, 0xfb, 0xfc, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x3f, 0xcf, 0xff, 0xfd, 0xfe, 0x7f,
    0xff, 0xef, 0xf0, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x1e, 0x1f, 0xff, 0xff, 0xf0,
    0xff, 0xff, 0xff, 0x87, 0xc0, 0x0, 0x3c, 0x3e,
    0x0, 0x1, 0xe1, 0xf0, 0x0, 0xf, 0xf, 0x80,
    0x0, 0x78, 0x7f, 0xff, 0xfb, 0xc3, 0xff, 0xff,
    0xde, 0x1f, 0x0, 0x0, 0xf0, 0xf8, 0x0, 0x7,
    0x87, 0xc0, 0x0, 0x3c, 0x3e, 0x0, 0x1, 0xe1,
    0xf0, 0x0, 0xf, 0xf, 0xff, 0xff, 0x78, 0x7f,
    0xff, 0xfb, 0xc3, 0xe0, 0x0, 0x1e, 0x1f, 0x0,
    0x0, 0xf0, 0xf8, 0x0, 0x7, 0x87, 0xc0, 0x0,
    0x3c, 0x3e, 0x0, 0x1, 0xe1, 0xff, 0xff, 0xff,
    0xf, 0xff, 0xff, 0xf8, 0x7c, 0x0, 0x3, 0xc3,
    0xe0, 0x0, 0x1e, 0x1f, 0x0, 0x0, 0xf0,

    /* U+5195 "冕" */
    0x1e, 0x0, 0x0, 0x1e, 0x7, 0xff, 0xff, 0xff,
    0x81, 0xff, 0xff, 0xff, 0xe0, 0x78, 0x0, 0x0,
    0x78, 0x1e, 0x0, 0x0, 0x1e, 0x7, 0x80, 0x0,
    0x7, 0x81, 0xe7, 0xff, 0xf9, 0xe0, 0x79, 0xff,
    0xfe, 0x78, 0x1e, 0x0, 0x0, 0x1e, 0x7, 0x80,
    0x0, 0x7, 0x81, 0xe0, 0x0, 0x1, 0xe0, 0x79,
    0xff, 0xfe, 0x78, 0x1e, 0x7f, 0xff, 0x9e, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x1, 0xff, 0xff, 0xc0,
    0x0, 0x7f, 0xff, 0xe0, 0x0, 0x3c, 0x0, 0x70,
    0x0, 0xe, 0x0, 0x38, 0x0, 0x7, 0x0, 0xc,
    0x0, 0x3, 0xe0, 0x6, 0xf, 0x1, 0xff, 0xff,
    0xff, 0xc0, 0xdf, 0xff, 0xff, 0xf0, 0x67, 0x81,
    0xe0, 0x3c, 0x1, 0xe0, 0x78, 0xf, 0x0, 0x78,
    0x1e, 0x3, 0xc0, 0x1e, 0x7, 0x80, 0xf0, 0x7,
    0x81, 0xe0, 0x3c, 0x1, 0xe0, 0x70, 0xf, 0x0,
    0x7f, 0xff, 0xff, 0xc0, 0x1f, 0xff, 0xff, 0xf0,
    0x7, 0x83, 0xb8, 0x3c, 0x1, 0xe1, 0xee, 0xf,
    0x20, 0x0, 0x73, 0x80, 0x8, 0x0, 0x38, 0xe0,
    0x2, 0x0, 0x1c, 0x38, 0x0, 0x80, 0x6, 0xe,
    0x0, 0x60, 0x3, 0x3, 0x80, 0x18, 0x1, 0x80,
    0xe0, 0x6, 0x0, 0xc0, 0x38, 0x1, 0xc0, 0x60,
    0xe, 0x0, 0x70, 0x30, 0x3, 0xc0, 0x38, 0x30,
    0x0, 0xff, 0xfe, 0x18, 0x0, 0x3f, 0xff, 0x98,
    0x0, 0x7, 0xff, 0xc0,

    /* U+5196 "冖" */
    0xf0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x7, 0xf8, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0xc, 0x0, 0x0, 0x0,
    0x40, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x0,

    /* U+5197 "冗" */
    0x78, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c,
    0x7f, 0xff, 0xff, 0xfc, 0x7f, 0xff, 0xff, 0xfc,
    0x78, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c,
    0x78, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x0, 0x3c,
    0x78, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x0, 0x20,
    0x0, 0xf0, 0x1e, 0x20, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xff, 0xfe, 0x0,
    0x0, 0xff, 0xfe, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xf0, 0x1e, 0x2, 0x0, 0xf0, 0x1e, 0x6,
    0x0, 0xe0, 0x1e, 0x6, 0x1, 0xe0, 0x1e, 0x6,
    0x1, 0xc0, 0x1e, 0x6, 0x1, 0xc0, 0x1e, 0x6,
    0x1, 0x80, 0x1e, 0x6, 0x3, 0x80, 0x1e, 0xf,
    0x3, 0x0, 0x1e, 0xf, 0x6, 0x0, 0x1e, 0xf,
    0xe, 0x0, 0x1e, 0xf, 0xc, 0x0, 0x1f, 0xfe,
    0x18, 0x0, 0x1f, 0xfe, 0x30, 0x0, 0xf, 0xfe,
    0x20, 0x0, 0x7, 0xfc, 0x40, 0x0, 0x0, 0x0,

    /* U+5198 "冘" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0xf, 0x0, 0xf0, 0x7, 0x87, 0x80, 0x78,
    0x3, 0xc3, 0xc0, 0x3c, 0x1, 0xe1, 0xff, 0xff,
    0xff, 0xf0, 0xff, 0xff, 0xff, 0xf8, 0x78, 0x7,
    0x80, 0x3c, 0x3c, 0x3, 0xc0, 0x1e, 0x1e, 0x1,
    0xe0, 0xf, 0xf, 0x0, 0xf0, 0x7, 0x87, 0x80,
    0x78, 0x2, 0x0, 0x0, 0x3c, 0x1, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0xf, 0x3c, 0x0, 0x0,
    0x7, 0x9e, 0x0, 0x0, 0x7, 0x8f, 0x0, 0x0,
    0x3, 0xc7, 0x80, 0x0, 0x1, 0xe3, 0xc0, 0x0,
    0x0, 0xf1, 0xe0, 0x0, 0x0, 0x70, 0xf0, 0x0,
    0x0, 0x78, 0x78, 0x0, 0x0, 0x38, 0x3c, 0x0,
    0x0, 0x3c, 0x1e, 0x2, 0x0, 0x1c, 0xf, 0x3,
    0x0, 0x1e, 0x7, 0x81, 0x80, 0xe, 0x3, 0xc0,
    0xc0, 0xf, 0x1, 0xe0, 0x60, 0x7, 0x0, 0xf0,
    0x30, 0x7, 0x0, 0x78, 0x18, 0x7, 0x0, 0x3c,
    0x1e, 0x3, 0x0, 0x1e, 0xf, 0x3, 0x0, 0xf,
    0x7, 0x83, 0x0, 0x7, 0x83, 0xc3, 0x0, 0x3,
    0xff, 0xc3, 0x0, 0x1, 0xff, 0xe2, 0x0, 0x0,
    0x7f, 0xf2, 0x0, 0x0, 0x1f, 0xf0,

    /* U+5199 "写" */
    0x78, 0x0, 0x0, 0x1e, 0xf0, 0x0, 0x0, 0x3d,
    0xff, 0xff, 0xff, 0xfb, 0xff, 0xff, 0xff, 0xf7,
    0x80, 0x0, 0x1, 0xef, 0x0, 0x0, 0x3, 0xde,
    0x0, 0x0, 0x7, 0xbc, 0xf8, 0x0, 0xc, 0x1,
    0xf0, 0x0, 0x10, 0x3, 0xe0, 0x0, 0x0, 0x7,
    0xc0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xfe, 0x0, 0x7f,
    0xff, 0xfc, 0x0, 0xf8, 0x0, 0x0, 0x1, 0xf0,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0xf, 0x80, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x0, 0x3e, 0x0, 0xf, 0x0, 0x7f, 0xff,
    0xfe, 0x0, 0xff, 0xff, 0xfc, 0x1, 0xf0, 0x0,
    0x78, 0x3, 0xe0, 0x0, 0xf0, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x79,
    0xff, 0xff, 0xfc, 0xf3, 0xff, 0xff, 0xf9, 0xe0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x6, 0x18, 0x0,

    /* U+519B "军" */
    0x3c, 0x0, 0x0, 0x1e, 0x3c, 0x0, 0x0, 0x1e,
    0x3f, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xfe,
    0x3c, 0x0, 0x0, 0x1e, 0x3c, 0x0, 0x0, 0x1e,
    0x3c, 0x1f, 0x0, 0x1e, 0x3c, 0x1f, 0x0, 0x10,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xf8,
    0x1f, 0xff, 0xff, 0xf8, 0x0, 0x1c, 0x0, 0x0,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x31, 0xe0, 0x0,
    0x0, 0x71, 0xe0, 0x0, 0x0, 0x61, 0xe0, 0x0,
    0x0, 0xe1, 0xe0, 0x0, 0x0, 0xc1, 0xe0, 0x0,
    0x1, 0x81, 0xe0, 0x0, 0x3, 0x1, 0xe0, 0x0,
    0x6, 0x1, 0xe0, 0x0, 0x7, 0xff, 0xff, 0xf8,
    0x7, 0xff, 0xff, 0xf8, 0x8, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,

    /* U+519C "农" */
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x78, 0x78, 0x7, 0x80, 0x3c, 0x3f, 0xff, 0xff,
    0xfe, 0x1f, 0xff, 0xff, 0xff, 0xf, 0x0, 0xf0,
    0x7, 0x87, 0x80, 0x70, 0x3, 0xc3, 0xc0, 0x78,
    0x1, 0xe1, 0xe0, 0x3c, 0x0, 0xf0, 0xf0, 0x1e,
    0x0, 0x40, 0x0, 0x1f, 0x0, 0x0, 0x0, 0xe,
    0x80, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x3f,
    0x10, 0x4, 0x0, 0x1f, 0x8, 0x7, 0x0, 0xf,
    0x84, 0x7, 0x0, 0x7, 0x82, 0x7, 0x0, 0x3,
    0xc1, 0x87, 0x0, 0x3, 0xe0, 0xc7, 0x0, 0x1,
    0xf0, 0x63, 0x0, 0x1, 0xf8, 0x3b, 0x0, 0x1,
    0xfc, 0x1f, 0x0, 0x0, 0xde, 0x7, 0x0, 0x0,
    0xcf, 0x3, 0x80, 0x0, 0xc7, 0x81, 0xe0, 0x0,
    0xc3, 0xc0, 0xf0, 0x0, 0xc1, 0xe0, 0x7c, 0x0,
    0x40, 0xf0, 0x1f, 0x0, 0x40, 0x78, 0xf, 0x80,
    0x0, 0x3c, 0x3, 0xe0, 0x0, 0x1e, 0x1, 0xf8,
    0x0, 0xf, 0x0, 0x7f, 0x0, 0x7, 0x81, 0x1f,
    0xc0, 0x3, 0xc3, 0xf, 0xfc, 0x1, 0xe7, 0x3,
    0xfc, 0x0, 0xff, 0x0, 0xfe, 0xf, 0xff, 0x0,
    0x1e, 0x7, 0xfe, 0x0, 0x7, 0x3, 0xfc, 0x0,
    0x1, 0x81, 0xf8, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x0,

    /* U+51A0 "冠" */
    0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3,
    0xcf, 0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff,
    0xf3, 0xc0, 0x0, 0x0, 0x79, 0xe0, 0x0, 0x0,
    0x3c, 0xf0, 0x0, 0x0, 0x1e, 0x78, 0x0, 0x0,
    0xd, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xc0, 0x1e, 0x1, 0xff, 0xe0,
    0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0xff, 0xff, 0x0, 0x0, 0x7f, 0xff, 0x80, 0x0,
    0x0, 0x3c, 0x1f, 0xff, 0xf0, 0x1e, 0xf, 0xff,
    0xf8, 0xf, 0x0, 0x79, 0xe0, 0x7, 0x80, 0x3c,
    0xf1, 0x3, 0xc0, 0x1e, 0x78, 0xc1, 0xe0, 0xf,
    0x3c, 0x20, 0xf0, 0x7, 0x9e, 0x18, 0x78, 0x3,
    0xcf, 0xe, 0x3c, 0x1, 0xe7, 0x87, 0x1e, 0x0,
    0xf3, 0xc3, 0xcf, 0x0, 0x79, 0xe1, 0xe7, 0x80,
    0x3c, 0xf0, 0xf3, 0xc0, 0x1e, 0x78, 0x31, 0xe0,
    0xe, 0x3c, 0x10, 0xf0, 0x7, 0x1e, 0x0, 0x78,
    0x7, 0x8f, 0x0, 0x3c, 0x83, 0xc7, 0x80, 0x1e,
    0x41, 0xc3, 0xc0, 0xf, 0x20, 0xe1, 0xe0, 0xf,
    0x90, 0x60, 0xf0, 0xf, 0x88, 0x30, 0x78, 0x1f,
    0x86, 0x30, 0x3c, 0x3f, 0x3, 0x18, 0x1e, 0x0,
    0x3, 0x88, 0xf, 0x0, 0x1, 0xcc, 0x7, 0xff,
    0xff, 0xe4, 0x3, 0xff, 0xff, 0xf4, 0x0, 0xff,
    0xff, 0xfa, 0x0, 0x3f, 0xff, 0xf8,

    /* U+51A2 "冢" */
    0xf0, 0x0, 0x0, 0x1e, 0xf0, 0x0, 0x0, 0x1e,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xfe,
    0xf0, 0x0, 0x0, 0x1e, 0xf0, 0x0, 0x0, 0x1e,
    0xf0, 0x0, 0x0, 0x10, 0xf0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xc0, 0x7, 0xff, 0xff, 0xc0,
    0x0, 0xf, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x30,
    0x0, 0x7b, 0x0, 0x70, 0x0, 0x73, 0x80, 0xe0,
    0x0, 0xe1, 0xc1, 0xc0, 0x1, 0x81, 0xe3, 0x80,
    0x3, 0x3d, 0xe7, 0x0, 0xe, 0x79, 0xec, 0x0,
    0x18, 0x79, 0xfc, 0x0, 0x34, 0xf1, 0xf4, 0x0,
    0xc6, 0xe1, 0xe6, 0x0, 0x3, 0xc1, 0xe2, 0x0,
    0x3, 0x81, 0xe2, 0x0, 0x3, 0xdf, 0xe3, 0x0,
    0x7, 0xdf, 0xe3, 0x80, 0xd, 0xbf, 0xe3, 0x80,
    0x18, 0xbd, 0xe1, 0xc0, 0x60, 0x7d, 0xe1, 0xe0,
    0xc0, 0x79, 0xe1, 0xf0, 0x0, 0xf1, 0xe0, 0xf8,
    0x1, 0xe1, 0xe0, 0xfe, 0x1, 0xc1, 0xe0, 0x7e,
    0x3, 0x81, 0xe0, 0x7e, 0x7, 0x1, 0xe0, 0x3c,
    0xe, 0x1, 0xe0, 0x1c, 0x18, 0x1, 0xe0, 0xc,
    0x30, 0x1, 0xe0, 0x4, 0x40, 0x1, 0xe0, 0x0,
    0x80, 0x3, 0xc0, 0x0, 0x0, 0x7, 0xc0, 0x0,
    0x0, 0x1f, 0x80, 0x0, 0x0, 0xfe, 0x0, 0x0,

    /* U+51A4 "冤" */
    0x78, 0x0, 0x0, 0x1e, 0x78, 0x0, 0x0, 0x1e,
    0x7f, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xfe,
    0x78, 0x0, 0x0, 0x1e, 0x78, 0x0, 0x0, 0x1e,
    0x78, 0x7c, 0x0, 0x1e, 0x78, 0xf8, 0x1f, 0x18,
    0x0, 0xf8, 0x1f, 0x10, 0x0, 0xff, 0xfe, 0x0,
    0x1, 0xff, 0xfe, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x3, 0xc0, 0x1c, 0x0, 0x3, 0x80, 0x1c, 0x0,
    0x7, 0x0, 0x38, 0x0, 0x7, 0x0, 0x31, 0xe0,
    0xf, 0xff, 0xff, 0xe0, 0x1f, 0xff, 0xff, 0xe0,
    0x37, 0x3, 0xc1, 0xe0, 0x67, 0x3, 0xc1, 0xe0,
    0x7, 0x3, 0xc1, 0xe0, 0x7, 0x3, 0xc1, 0xe0,
    0x7, 0x3, 0xc1, 0xe0, 0x7, 0x3, 0xc1, 0xe0,
    0x7, 0x3, 0xc1, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0x7, 0x81, 0xe0,
    0x7, 0x7, 0xe1, 0xe0, 0x7, 0x7, 0xe0, 0x0,
    0x0, 0xe, 0xe4, 0x0, 0x0, 0xe, 0xe2, 0x0,
    0x0, 0x1c, 0xe3, 0x4, 0x0, 0x18, 0xe3, 0xc4,
    0x0, 0x38, 0xe1, 0xc4, 0x0, 0x70, 0xe1, 0xc4,
    0x0, 0x60, 0xe0, 0xc4, 0x0, 0xc0, 0xe0, 0x4c,
    0x1, 0x80, 0xe0, 0xe, 0x1, 0x80, 0xe0, 0xe,
    0x3, 0x0, 0xe0, 0xe, 0x6, 0x0, 0xf0, 0x1e,
    0xc, 0x0, 0xff, 0xfe, 0x18, 0x0, 0xff, 0xfe,
    0x30, 0x0, 0xff, 0xfc, 0x60, 0x0, 0x7f, 0xf8,
    0x0, 0x0, 0x0, 0x0,

    /* U+51A5 "冥" */
    0x78, 0x0, 0x0, 0x1e, 0x78, 0x0, 0x0, 0x1e,
    0x7f, 0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xfe,
    0x78, 0x0, 0x0, 0x1e, 0x78, 0x0, 0x0, 0x1e,
    0x78, 0x0, 0x0, 0x1e, 0x78, 0x0, 0x0, 0x18,
    0x7, 0x0, 0x0, 0x10, 0x7, 0x0, 0x0, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0x0, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xe0,
    0x7, 0x0, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xe0,
    0x7, 0xff, 0xf8, 0xe0, 0x7, 0xff, 0xf8, 0xe0,
    0x7, 0x0, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xe0,
    0x7, 0x0, 0x0, 0xe0, 0x7, 0x0, 0x0, 0xe0,
    0x7, 0xff, 0xff, 0xe0, 0x7, 0xff, 0xff, 0xe0,
    0x7, 0x2, 0x0, 0xe0, 0x7, 0x3, 0x0, 0xe0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x1, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7c, 0x10, 0x0, 0x0, 0x78, 0x10, 0x0,
    0x0, 0x78, 0x8, 0x0, 0x0, 0xf0, 0xc, 0x0,
    0x0, 0xf0, 0xe, 0x0, 0x1, 0xe0, 0x7, 0x80,
    0x1, 0xc0, 0x7, 0xf0, 0x3, 0x80, 0x3, 0xf8,
    0x7, 0x0, 0x1, 0xf8, 0xc, 0x0, 0x0, 0xf8,
    0x18, 0x0, 0x0, 0x78, 0x60, 0x0, 0x0, 0x18,

    /* U+51AB "冫" */
    0x20, 0x4, 0x1, 0x0, 0x60, 0x1c, 0x7, 0x81,
    0xe0, 0x3d, 0xf, 0x43, 0x90, 0x64, 0x13, 0x0,
    0x80, 0x20, 0x8, 0x6, 0x1, 0x80, 0x40, 0x10,
    0xc, 0x3, 0x0, 0xc0, 0x30, 0x18, 0x6, 0x1,
    0x88, 0x63, 0x38, 0x4c, 0x1b, 0x7, 0xc1, 0xf0,
    0x3c, 0xf, 0x3, 0xc0, 0xf8, 0x1f, 0x7, 0xc1,
    0xf0, 0x3c, 0xf, 0x1, 0x80, 0x60, 0x18, 0x0,
    0x0,

    /* U+51AC "冬" */
    0x0, 0x7c, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80, 0x7c,
    0x0, 0x7, 0xc0, 0x3e, 0x0, 0x3, 0xff, 0xfe,
    0x0, 0x1, 0xff, 0xff, 0x0, 0x1, 0xe0, 0x7,
    0x80, 0x0, 0xf0, 0x7, 0xc0, 0x0, 0x7c, 0x3,
    0xc0, 0x0, 0x7a, 0x1, 0xe0, 0x0, 0x39, 0x81,
    0xf0, 0x0, 0x1c, 0x40, 0xf0, 0x0, 0x1c, 0x30,
    0x78, 0x0, 0xc, 0x18, 0x78, 0x0, 0xc, 0x6,
    0x38, 0x0, 0xc, 0x3, 0xbc, 0x0, 0x4, 0x0,
    0xfc, 0x0, 0x6, 0x0, 0x7c, 0x0, 0x4, 0x0,
    0x1e, 0x0, 0x4, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x1c, 0xfc, 0x0, 0x0,
    0x1c, 0x3f, 0x80, 0x0, 0x38, 0x1f, 0xf0, 0x0,
    0x38, 0x7, 0xff, 0x80, 0x38, 0x0, 0xff, 0xe0,
    0x30, 0x80, 0x3f, 0xe0, 0x70, 0x30, 0x7, 0xf0,
    0x60, 0x1e, 0x1, 0xf8, 0x40, 0x7, 0xc0, 0x1c,
    0xc0, 0x1, 0xf0, 0x2, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xe, 0x0,
    0x0, 0x4, 0x3, 0x0, 0x0, 0x1, 0xc0, 0x80,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x1f, 0x0,
    0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x1, 0xfc,
    0x0, 0x0, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x1f,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x1,
    0x80, 0x0, 0x0, 0x0, 0x40, 0x0,

    /* U+51AF "冯" */
    0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x1, 0xc2,
    0x1, 0xff, 0xff, 0xc, 0x7, 0xff, 0xfc, 0x18,
    0x0, 0x0, 0x70, 0x70, 0x0, 0x1, 0xc1, 0xe0,
    0xf0, 0x7, 0x3, 0x8b, 0xc0, 0x1c, 0xf, 0x4f,
    0x0, 0x70, 0x3d, 0x3c, 0x1, 0xc0, 0x64, 0xf0,
    0x7, 0x1, 0x93, 0xc0, 0x1c, 0x0, 0x8f, 0x0,
    0x70, 0x2, 0x3c, 0x1, 0xc0, 0x8, 0xf0, 0x6,
    0x0, 0x63, 0xc0, 0x18, 0x1, 0x8f, 0x0, 0xe0,
    0x4, 0x3c, 0x3, 0x0, 0x30, 0xf0, 0x8, 0x0,
    0xc3, 0xc0, 0x60, 0x3, 0xf, 0x2, 0x3c, 0x18,
    0x3c, 0x0, 0xf0, 0x60, 0xff, 0xff, 0xc1, 0x83,
    0xc0, 0xf, 0xe, 0xf, 0x0, 0x3c, 0x30, 0x3c,
    0x0, 0xf8, 0xc0, 0x0, 0x3, 0xe7, 0x0, 0x0,
    0xf, 0x5c, 0x0, 0x0, 0x3d, 0x70, 0x0, 0x0,
    0xf7, 0x80, 0x0, 0x3, 0xde, 0x0, 0x0, 0xf,
    0x78, 0x0, 0x0, 0x3c, 0xe3, 0xff, 0xfe, 0xf3,
    0x8f, 0xff, 0xfb, 0xcf, 0x0, 0x0, 0xf, 0x3c,
    0x0, 0x0, 0x3c, 0x78, 0x0, 0x0, 0xf1, 0xe0,
    0x0, 0x3, 0xc7, 0xc0, 0x0, 0xf, 0xe, 0x0,
    0x0, 0x3c, 0x38, 0x0, 0x0, 0xf0, 0xe0, 0x0,
    0x7, 0x81, 0x0, 0x0, 0x3e, 0x4, 0x0, 0x3,
    0xf0, 0x0, 0x0, 0x3f, 0x0,

    /* U+51B0 "冰" */
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x20, 0x0, 0x3c, 0x0, 0x30, 0x0, 0x3c, 0x0,
    0x30, 0x0, 0x3c, 0x0, 0x18, 0x0, 0x3c, 0x0,
    0x1c, 0x0, 0x3d, 0x0, 0x1e, 0x0, 0x3d, 0x0,
    0x1e, 0x0, 0x3d, 0x2, 0xe, 0x47, 0xbd, 0x7,
    0xe, 0x47, 0xbd, 0x6, 0xe, 0x7f, 0xbd, 0xc,
    0x4, 0x7f, 0xbd, 0x1c, 0x0, 0x87, 0xbd, 0x18,
    0x0, 0x87, 0xbd, 0x38, 0x0, 0x87, 0xbd, 0xb0,
    0x1, 0x87, 0xbd, 0xe0, 0x1, 0x7, 0x3d, 0xe0,
    0x1, 0x7, 0x3d, 0xc0, 0x3, 0x7, 0x3d, 0x80,
    0x3, 0x7, 0x3d, 0x80, 0x2, 0xf, 0x3d, 0x80,
    0x6, 0xf, 0x3d, 0xc0, 0x6, 0xe, 0x3d, 0xc0,
    0xc, 0xe, 0x3c, 0xc0, 0xc, 0xe, 0x3c, 0xe0,
    0xc, 0xe, 0x3c, 0xe0, 0x1c, 0x1c, 0x3c, 0xe0,
    0x98, 0x1c, 0x3c, 0xf0, 0xd8, 0x1c, 0x3c, 0xf0,
    0x78, 0x18, 0x3c, 0x78, 0x70, 0x38, 0x3c, 0x7c,
    0x70, 0x30, 0x3c, 0x7c, 0x70, 0x30, 0x3c, 0x3e,
    0x78, 0x30, 0x3c, 0x3f, 0x78, 0x60, 0x3c, 0x1f,
    0x3c, 0x40, 0x3c, 0x1f, 0x3c, 0xc0, 0x3c, 0xe,
    0x3e, 0x80, 0x3c, 0xe, 0x1c, 0x80, 0x3c, 0x6,
    0x19, 0x0, 0x3c, 0x2, 0x19, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x9, 0x0, 0x0,

    /* U+51B1 "冱" */
    0x20, 0x3f, 0xff, 0xff, 0x10, 0x3f, 0xff, 0xff,
    0x18, 0x0, 0xf0, 0x0, 0x1c, 0x0, 0xf0, 0x0,
    0x1e, 0x0, 0xf0, 0x0, 0xe, 0x0, 0xf0, 0x0,
    0xf, 0x10, 0xf0, 0x0, 0xf, 0x90, 0xf0, 0x0,
    0x7, 0x10, 0xf0, 0x78, 0x7, 0x20, 0xf0, 0x78,
    0x6, 0x20, 0xf0, 0x78, 0x2, 0x20, 0xf0, 0x78,
    0x0, 0x60, 0xff, 0xf8, 0x0, 0x40, 0xff, 0xf8,
    0x0, 0x40, 0xe0, 0x78, 0x0, 0xc0, 0xe0, 0x78,
    0x0, 0xc1, 0xe0, 0x78, 0x0, 0x81, 0xe0, 0x78,
    0x1, 0x81, 0xe0, 0x78, 0x1, 0x81, 0xc0, 0x78,
    0x1, 0x1, 0xc0, 0x78, 0x3, 0x1, 0x80, 0x78,
    0x3, 0x3, 0x80, 0x78, 0x3, 0x3, 0x0, 0x78,
    0x86, 0x6, 0x0, 0x78, 0xc6, 0x4, 0x0, 0x78,
    0x46, 0xf, 0xff, 0xf8, 0x6e, 0xf, 0xff, 0xf8,
    0x7c, 0x8, 0x0, 0x70, 0x3c, 0x0, 0x0, 0x70,
    0x3c, 0x0, 0x0, 0x70, 0x3c, 0x0, 0x0, 0x70,
    0x1c, 0x0, 0x0, 0x60, 0x1e, 0x0, 0x0, 0x60,
    0x1f, 0x0, 0x0, 0xc0, 0xf, 0x0, 0x0, 0xc0,
    0xf, 0x0, 0x0, 0x80, 0x7, 0x0, 0x1, 0x0,
    0x7, 0x0, 0x2, 0x0, 0x2, 0x7f, 0xff, 0xff,
    0x2, 0x7f, 0xff, 0xff,

    /* U+51B2 "冲" */
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x78, 0x1, 0x0, 0x0, 0xf0, 0x3,
    0x0, 0x1, 0xe0, 0x6, 0x0, 0x3, 0xc0, 0xe,
    0x0, 0x7, 0x80, 0xe, 0x0, 0xf, 0x0, 0x1e,
    0x1e, 0x1e, 0x1e, 0x3e, 0x3c, 0x3c, 0x3c, 0x39,
    0x7f, 0xff, 0xf8, 0x74, 0xff, 0xff, 0xf0, 0xc9,
    0xe1, 0xe1, 0xe0, 0x13, 0xc3, 0xc3, 0xc0, 0x27,
    0x87, 0x87, 0x80, 0x8f, 0xf, 0xf, 0x1, 0x1e,
    0x1e, 0x1e, 0x2, 0x3c, 0x3c, 0x3c, 0x4, 0x78,
    0x78, 0x78, 0x10, 0xf0, 0xf0, 0xf0, 0x21, 0xe1,
    0xe1, 0xe0, 0x43, 0xc3, 0xc3, 0xc1, 0x87, 0x87,
    0x87, 0x82, 0xf, 0xf, 0xf, 0x4, 0x1e, 0x1e,
    0x1e, 0x18, 0x3f, 0xff, 0xfc, 0x30, 0x7f, 0xff,
    0xfc, 0x40, 0xf0, 0xf0, 0xf9, 0x81, 0xe1, 0xe1,
    0xfb, 0x3, 0xc3, 0xc3, 0xf6, 0x7, 0x87, 0x80,
    0x38, 0x0, 0xf, 0x0, 0x70, 0x0, 0x1e, 0x0,
    0xe0, 0x0, 0x3c, 0x1, 0xe0, 0x0, 0x78, 0x3,
    0xc0, 0x0, 0xf0, 0x3, 0xc0, 0x1, 0xe0, 0x7,
    0xc0, 0x3, 0xc0, 0xf, 0x80, 0x7, 0x80, 0xf,
    0x0, 0xf, 0x0, 0x1c, 0x0, 0x1e, 0x0, 0x30,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x3, 0xc0, 0x0,

    /* U+51B3 "决" */
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x7, 0x80, 0x1, 0x0, 0xf, 0x0, 0x3,
    0x0, 0x1e, 0x0, 0x6, 0x0, 0x3c, 0x0, 0xe,
    0x0, 0x78, 0x0, 0xe, 0x0, 0xf0, 0x78, 0x1c,
    0x1f, 0xff, 0xf0, 0x3c, 0x3f, 0xff, 0xe0, 0x39,
    0x7, 0x83, 0xc0, 0x64, 0xf, 0x7, 0x80, 0xc8,
    0x1e, 0xf, 0x0, 0x10, 0x3c, 0x1e, 0x0, 0x20,
    0x78, 0x3c, 0x0, 0x40, 0xf0, 0x78, 0x1, 0x1,
    0xe0, 0xf0, 0x2, 0x3, 0xc1, 0xe0, 0x4, 0x7,
    0x83, 0xc0, 0x18, 0xf, 0x7, 0x0, 0x20, 0x1e,
    0xe, 0x0, 0x40, 0x3c, 0x3c, 0x1, 0x80, 0x78,
    0x70, 0x3, 0x0, 0xf0, 0xc0, 0x4, 0xff, 0xff,
    0xfe, 0x19, 0xff, 0xff, 0xfc, 0x30, 0x7, 0xa0,
    0x0, 0x60, 0xf, 0x40, 0x9, 0xc0, 0x1e, 0x80,
    0x13, 0x0, 0x3d, 0x0, 0x36, 0x0, 0x7b, 0x0,
    0x3c, 0x0, 0xe6, 0x0, 0x78, 0x3, 0xcc, 0x0,
    0xe0, 0x7, 0x1c, 0x1, 0xc0, 0xe, 0x1c, 0x1,
    0xc0, 0x38, 0x38, 0x3, 0x80, 0x70, 0x78, 0x7,
    0x81, 0xc0, 0x7c, 0xf, 0x3, 0x0, 0xfc, 0xf,
    0xc, 0x0, 0xfe, 0x1c, 0x38, 0x1, 0xfe, 0x30,
    0x60, 0x1, 0xf8, 0x1, 0x80, 0x1, 0xf0, 0x6,
    0x0, 0x1, 0xe0, 0x18, 0x0, 0x1, 0x80, 0x60,
    0x0, 0x1, 0x0,

    /* U+51B5 "况" */
    0x0, 0xf, 0x0, 0x78, 0x20, 0x7, 0x80, 0x3c,
    0x8, 0x3, 0xff, 0xfe, 0x4, 0x1, 0xff, 0xff,
    0x3, 0x0, 0xf0, 0x7, 0x81, 0xc0, 0x78, 0x3,
    0xc0, 0x70, 0x3c, 0x1, 0xe0, 0x38, 0x1e, 0x0,
    0xf0, 0x1e, 0xf, 0x0, 0x78, 0x7, 0x97, 0x80,
    0x3c, 0x3, 0xd3, 0xc0, 0x1e, 0x1, 0xc9, 0xe0,
    0xf, 0x0, 0x64, 0xf0, 0x7, 0x80, 0x22, 0x78,
    0x3, 0xc0, 0x2, 0x3c, 0x1, 0xe0, 0x1, 0x1e,
    0x0, 0xf0, 0x0, 0x8f, 0x0, 0x78, 0x0, 0x47,
    0xff, 0xfc, 0x0, 0x63, 0xff, 0xfe, 0x0, 0x21,
    0xe0, 0xf, 0x0, 0x10, 0xf0, 0x7, 0x80, 0x18,
    0xf, 0x3c, 0x0, 0xc, 0x7, 0x9e, 0x0, 0x4,
    0x3, 0xcf, 0x0, 0x6, 0x1, 0xe7, 0x80, 0x3,
    0x1, 0xf3, 0xc0, 0x1, 0x80, 0xf1, 0xe0, 0x11,
    0x80, 0x78, 0xf0, 0x4, 0xc0, 0x3c, 0x78, 0x2,
    0x60, 0x1e, 0x3c, 0x9, 0xf0, 0xe, 0x1e, 0x4,
    0xf8, 0x7, 0xf, 0x2, 0x38, 0x7, 0x87, 0x82,
    0x1c, 0x3, 0x83, 0xc1, 0xf, 0x1, 0xc1, 0xe0,
    0x87, 0x81, 0xc0, 0xf0, 0x41, 0xc0, 0xe0, 0x78,
    0x20, 0xf0, 0x60, 0x3c, 0x10, 0x78, 0x60, 0x1e,
    0x1c, 0x1c, 0x30, 0xf, 0xe, 0xc, 0x30, 0x7,
    0x87, 0x4, 0x18, 0x3, 0xc7, 0x80, 0x18, 0x1,
    0xff, 0xc0, 0x18, 0x0, 0xff, 0xe0, 0x18, 0x0,
    0x7f, 0xe0, 0xc, 0x0, 0x1f, 0xf0,

    /* U+51B6 "冶" */
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x20, 0x0, 0x7c, 0x0, 0x30, 0x0, 0x7c, 0x80,
    0x10, 0x0, 0x78, 0x80, 0x18, 0x0, 0x78, 0x80,
    0x1c, 0x0, 0xf8, 0x80, 0x1e, 0x0, 0xf0, 0xc0,
    0xe, 0x0, 0xf0, 0xc0, 0xf, 0x0, 0xe0, 0xe0,
    0xe, 0x1, 0xe0, 0xe0, 0x6, 0x41, 0xc0, 0x70,
    0x6, 0x41, 0x80, 0x78, 0x4, 0x83, 0x0, 0x7c,
    0x0, 0x86, 0x1, 0xbe, 0x0, 0x84, 0x7, 0x3f,
    0x1, 0x88, 0xfe, 0x1f, 0x1, 0xbf, 0xfc, 0x1e,
    0x1, 0x3f, 0xf0, 0xe, 0x3, 0x1f, 0xc0, 0x6,
    0x3, 0x3f, 0x0, 0x3, 0x3, 0x30, 0x0, 0x0,
    0x6, 0x0, 0x0, 0x0, 0x6, 0xf, 0x0, 0x78,
    0x6, 0xf, 0x0, 0x78, 0xe, 0xf, 0xff, 0xf8,
    0xe, 0xf, 0xff, 0xf8, 0x8c, 0xf, 0x0, 0x78,
    0x9c, 0xf, 0x0, 0x78, 0x5c, 0xf, 0x0, 0x78,
    0x7c, 0xf, 0x0, 0x78, 0x78, 0xf, 0x0, 0x78,
    0x78, 0xf, 0x0, 0x78, 0x38, 0xf, 0x0, 0x78,
    0x38, 0xf, 0x0, 0x78, 0x3c, 0xf, 0x0, 0x78,
    0x3c, 0xf, 0x0, 0x78, 0x3e, 0xf, 0x0, 0x78,
    0x1e, 0xf, 0x0, 0x78, 0x1e, 0xf, 0x0, 0x78,
    0x1c, 0xf, 0xff, 0xf8, 0x8, 0xf, 0xff, 0xf8,
    0x0, 0xf, 0x0, 0x78, 0x0, 0xf, 0x0, 0x78,
    0x0, 0xf, 0x0, 0x78, 0x0, 0xf, 0x0, 0x78,

    /* U+51B7 "冷" */
    0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x40, 0x0, 0x7c, 0x0, 0x60, 0x0, 0x7c, 0x0,
    0x30, 0x0, 0x7c, 0x0, 0x30, 0x0, 0xfe, 0x0,
    0x38, 0x0, 0xf2, 0x0, 0x1c, 0x0, 0xf3, 0x0,
    0x1e, 0x20, 0xe3, 0x0, 0x1e, 0x20, 0xe1, 0x80,
    0xe, 0x21, 0xc1, 0xc0, 0xc, 0x41, 0xc1, 0xe0,
    0x4, 0x41, 0x80, 0xf8, 0x0, 0x43, 0x0, 0xfc,
    0x0, 0x43, 0x30, 0x7f, 0x0, 0xc6, 0x38, 0x3e,
    0x0, 0x84, 0x1c, 0x3e, 0x0, 0x88, 0x1e, 0x1c,
    0x1, 0x98, 0xc, 0xc, 0x1, 0xb0, 0xc, 0x4,
    0x1, 0xa0, 0x8, 0x4, 0x3, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0xf0, 0x3, 0x0, 0x0, 0xf0,
    0x7, 0x1f, 0xff, 0xf0, 0x6, 0x1f, 0xff, 0xf0,
    0x6, 0x0, 0x0, 0xf0, 0x8e, 0x0, 0x0, 0xf0,
    0x8e, 0x0, 0x0, 0xf0, 0x4c, 0x0, 0x0, 0xe0,
    0x7c, 0x0, 0x1, 0xe0, 0x7c, 0x0, 0x1, 0xc0,
    0x3c, 0x2, 0x1, 0x80, 0x3c, 0x1, 0x3, 0x80,
    0x3c, 0x1, 0xc6, 0x0, 0x1c, 0x0, 0xec, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0xf, 0x0, 0xf, 0x80,
    0x7, 0x0, 0xf, 0xc0, 0x7, 0x0, 0x7, 0xe0,
    0x6, 0x0, 0x3, 0xe0, 0x2, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0x40,

    /* U+51BB "冻" */
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0x3e, 0x0, 0x20, 0x0, 0x3e, 0x0,
    0x30, 0x0, 0x3e, 0x0, 0x30, 0x0, 0x3c, 0x0,
    0x18, 0x1f, 0xff, 0xff, 0x1c, 0x1f, 0xff, 0xff,
    0x1e, 0x0, 0x3c, 0x0, 0xf, 0x10, 0x3c, 0x0,
    0xf, 0x20, 0x78, 0x0, 0xe, 0x20, 0x78, 0x0,
    0x6, 0x20, 0x7f, 0x80, 0x4, 0x20, 0xf7, 0x80,
    0x0, 0x40, 0xe7, 0x80, 0x0, 0x40, 0xe7, 0x80,
    0x0, 0x41, 0xc7, 0x80, 0x0, 0xc1, 0x87, 0x80,
    0x0, 0x83, 0x7, 0x80, 0x0, 0x86, 0x7, 0x80,
    0x1, 0x8c, 0x7, 0x80, 0x1, 0x8f, 0xff, 0xff,
    0x1, 0xf, 0xff, 0xff, 0x3, 0x8, 0x7, 0x80,
    0x3, 0x0, 0x7, 0x80, 0x3, 0x0, 0x7, 0xa0,
    0x6, 0x3, 0xe7, 0xa0, 0x6, 0x3, 0xe7, 0xa0,
    0x86, 0x3, 0xc7, 0xa0, 0x8e, 0x3, 0xc7, 0xa0,
    0x4c, 0x3, 0xc7, 0xb0, 0x6c, 0x3, 0x87, 0xb0,
    0x7c, 0x3, 0x87, 0x98, 0x3c, 0x3, 0x87, 0x98,
    0x3c, 0x7, 0x7, 0x9c, 0x3c, 0x7, 0x7, 0x9e,
    0x1c, 0x6, 0x7, 0x8f, 0x1e, 0xc, 0x7, 0x8f,
    0x1f, 0xc, 0x7, 0x8e, 0xf, 0x8, 0x7, 0x86,
    0xf, 0x10, 0x7, 0x86, 0x7, 0x30, 0x7, 0x83,
    0x6, 0x0, 0xf, 0x1, 0x2, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x3e, 0x0, 0x0, 0x0, 0xfc, 0x0,
    0x0, 0x1, 0x30, 0x0,

    /* U+51BC "冼" */
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x2, 0x0, 0xf9, 0xe0,
    0x1, 0x80, 0x7c, 0xf0, 0x0, 0xe0, 0x3e, 0x78,
    0x0, 0x38, 0x5e, 0x3c, 0x0, 0x1e, 0x2f, 0x1e,
    0x0, 0xf, 0xa7, 0xff, 0xfe, 0x3, 0x93, 0xff,
    0xff, 0x1, 0xc9, 0xc3, 0xc0, 0x0, 0x4c, 0xe1,
    0xe0, 0x0, 0x24, 0x60, 0xf0, 0x0, 0x2, 0x30,
    0x78, 0x0, 0x1, 0x30, 0x3c, 0x0, 0x1, 0x90,
    0x1e, 0x0, 0x0, 0xd8, 0xf, 0x0, 0x0, 0x40,
    0x7, 0x80, 0x0, 0x60, 0x3, 0xc0, 0x0, 0x30,
    0x1, 0xe0, 0x0, 0x1b, 0xff, 0xff, 0xf8, 0x19,
    0xff, 0xff, 0xfc, 0xc, 0x7, 0x8f, 0x0, 0x6,
    0x3, 0xc7, 0x80, 0x7, 0x1, 0xe3, 0xc0, 0x3,
    0x0, 0xf1, 0xe0, 0x1, 0x80, 0x78, 0xf0, 0x10,
    0xc0, 0x3c, 0x78, 0x4, 0xe0, 0x1e, 0x3c, 0x2,
    0x60, 0xf, 0x1e, 0x1, 0xb0, 0x7, 0x8f, 0x0,
    0xf8, 0x3, 0xc7, 0x82, 0x7c, 0x1, 0xe3, 0xc1,
    0x1c, 0x0, 0xf1, 0xe0, 0x8e, 0x0, 0x70, 0xf0,
    0x47, 0x80, 0x78, 0x78, 0x21, 0xc0, 0x38, 0x3c,
    0x10, 0xf0, 0x1c, 0x1e, 0x8, 0x7c, 0x1c, 0xf,
    0x4, 0x1e, 0xc, 0x7, 0x83, 0xf, 0x8e, 0x3,
    0xc1, 0x87, 0x86, 0x1, 0xe1, 0xc1, 0xc6, 0x0,
    0xf0, 0xe0, 0xc6, 0x0, 0x7f, 0xf0, 0x46, 0x0,
    0x3f, 0xf8, 0x6, 0x0, 0xf, 0xf8,

    /* U+51BD "冽" */
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x3d,
    0x3, 0xff, 0xe0, 0x79, 0x7, 0xff, 0xc0, 0xf3,
    0x3, 0xc0, 0x1, 0xe7, 0x7, 0x80, 0x3, 0xce,
    0xf, 0x0, 0xe7, 0x8e, 0x1e, 0x1, 0xcf, 0x1e,
    0x3c, 0x3, 0x9e, 0x3c, 0x78, 0x7, 0x3c, 0x38,
    0xf0, 0xe, 0x78, 0x65, 0xe7, 0x9c, 0xf0, 0x53,
    0xff, 0x39, 0xe0, 0x27, 0xfe, 0x73, 0xc0, 0x4e,
    0x3c, 0xe7, 0x80, 0x9c, 0x79, 0xcf, 0x2, 0x38,
    0xf3, 0x9e, 0x4, 0x61, 0xe7, 0x3c, 0x8, 0xc3,
    0xce, 0x78, 0x13, 0x87, 0x9c, 0xf0, 0x67, 0xf,
    0x39, 0xe0, 0x8f, 0x1e, 0x73, 0xc1, 0x17, 0x3c,
    0xe7, 0x86, 0x6e, 0x79, 0xcf, 0xc, 0x8e, 0xf3,
    0x9e, 0x19, 0x1d, 0xe7, 0x3c, 0x64, 0x3f, 0x8e,
    0x7c, 0xc8, 0x7f, 0x1c, 0xf9, 0x80, 0xfe, 0x39,
    0xfb, 0x1, 0xb8, 0x73, 0xde, 0x0, 0x70, 0xe7,
    0xb8, 0x0, 0xe1, 0xcf, 0x70, 0x3, 0x83, 0x9e,
    0xe0, 0x7, 0x7, 0x3c, 0xe0, 0x1c, 0x0, 0x79,
    0xc0, 0x38, 0x0, 0xf3, 0xc0, 0x60, 0x1, 0xe3,
    0xc1, 0xc0, 0x3, 0xc7, 0x83, 0x0, 0x7, 0x8e,
    0xc, 0x0, 0xf, 0xc, 0x38, 0x0, 0x1e, 0x18,
    0x60, 0x0, 0x3c, 0x21, 0x80, 0x0, 0xf0, 0x6,
    0x0, 0x3, 0xe0, 0x8, 0x0, 0x1f, 0x0, 0x20,
    0x0, 0xf8, 0x0,

    /* U+51C0 "净" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0x1e, 0x0, 0x4,
    0x0, 0x78, 0x3c, 0x10, 0x1, 0xe0, 0xf0, 0x20,
    0x7, 0x83, 0xc0, 0x80, 0x1f, 0xfe, 0x3, 0x0,
    0x7f, 0xf8, 0xe, 0x3, 0xc0, 0xe0, 0x18, 0xe,
    0x7, 0x0, 0x70, 0x38, 0x18, 0x1, 0xc1, 0xc0,
    0xe0, 0x7, 0x26, 0x6, 0x3c, 0x9, 0x18, 0x30,
    0xf0, 0x24, 0xff, 0xff, 0xc0, 0x17, 0xff, 0xff,
    0x0, 0x58, 0x3c, 0x3c, 0x2, 0xc0, 0xf0, 0xf0,
    0x8, 0x3, 0xc3, 0xc0, 0x20, 0xf, 0xf, 0x0,
    0x80, 0x3c, 0x3c, 0x4, 0x0, 0xf0, 0xf0, 0x13,
    0xff, 0xff, 0xf0, 0x4f, 0xff, 0xff, 0xc1, 0x0,
    0x3c, 0x3c, 0xc, 0x0, 0xf0, 0xf0, 0x20, 0x3,
    0xc3, 0xc0, 0x80, 0xf, 0xf, 0x6, 0x0, 0x3c,
    0x3c, 0x98, 0x0, 0xf0, 0xf2, 0x40, 0xff, 0xff,
    0xc5, 0x3, 0xff, 0xff, 0x1c, 0x0, 0x3c, 0x3c,
    0x70, 0x0, 0xf0, 0xf1, 0xc0, 0x3, 0xc3, 0xc7,
    0x0, 0xf, 0x0, 0xe, 0x0, 0x3c, 0x0, 0x38,
    0x0, 0xf0, 0x0, 0xe0, 0x3, 0xc0, 0x3, 0xc0,
    0xf, 0x0, 0x7, 0x0, 0x3c, 0x0, 0x18, 0x0,
    0xf0, 0x0, 0x60, 0x3, 0xc0, 0x1, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1f, 0x80,
    0x0, 0x0, 0x80, 0x0, 0x0,

    /* U+51C4 "凄" */
    0x0, 0x0, 0x3c, 0x0, 0x10, 0x0, 0x1e, 0x0,
    0xc, 0x0, 0xf, 0x0, 0x3, 0x7, 0xff, 0xff,
    0xf1, 0x83, 0xff, 0xff, 0xf8, 0xe0, 0x1, 0xe0,
    0x0, 0x78, 0x0, 0xf0, 0x0, 0x1c, 0x0, 0x78,
    0x78, 0xf, 0x20, 0x3c, 0x3c, 0x7, 0x93, 0xff,
    0xfe, 0x1, 0xc9, 0xff, 0xff, 0x0, 0xc8, 0x7,
    0x87, 0x80, 0x24, 0x3, 0xc3, 0xc0, 0x2, 0x1,
    0xe1, 0xe0, 0x1, 0x0, 0xf0, 0xf0, 0x1, 0x3f,
    0xff, 0xff, 0x0, 0x9f, 0xff, 0xff, 0x80, 0x40,
    0x1e, 0x1e, 0x0, 0x60, 0xf, 0xf, 0x0, 0x30,
    0x7, 0x87, 0x80, 0x10, 0x3, 0xc3, 0xc0, 0x18,
    0x7f, 0xff, 0xe0, 0xc, 0x3f, 0xff, 0xf0, 0x6,
    0x1, 0xe0, 0x78, 0x7, 0x0, 0xf0, 0x0, 0x3,
    0x0, 0x78, 0x0, 0x21, 0x80, 0x3c, 0x0, 0x18,
    0xc0, 0x3c, 0x0, 0x4, 0xe7, 0xff, 0xff, 0xfb,
    0x63, 0xff, 0xff, 0xfd, 0xf0, 0xf, 0x3, 0xe0,
    0x78, 0x7, 0x81, 0xe0, 0x3c, 0x3, 0xc0, 0xf0,
    0x1e, 0x1, 0xc0, 0x78, 0x7, 0x1, 0xe0, 0x78,
    0x3, 0xc0, 0xf0, 0x3c, 0x1, 0xe0, 0x7c, 0x3c,
    0x0, 0x78, 0x7b, 0xdc, 0x0, 0x3e, 0x0, 0xfc,
    0x0, 0xf, 0x0, 0x3f, 0x0, 0x7, 0x0, 0x3f,
    0xf0, 0x1, 0x80, 0x38, 0xfe, 0x0, 0x80, 0x70,
    0x3f, 0x80, 0x0, 0x60, 0x7, 0xc0, 0x0, 0xe0,
    0x0, 0xe0, 0x1, 0xc0, 0x0, 0x10,

    /* U+51C6 "准" */
    0x0, 0x3, 0xe8, 0x0, 0x0, 0x3, 0xe4, 0x0,
    0x0, 0x3, 0xc6, 0x0, 0x20, 0x7, 0xc7, 0x0,
    0x20, 0x7, 0xc7, 0x80, 0x30, 0x7, 0xc7, 0xc0,
    0x18, 0x7, 0x83, 0x80, 0x18, 0x7, 0x83, 0x80,
    0x1c, 0x7, 0x83, 0x0, 0x1e, 0x7, 0xff, 0xff,
    0xe, 0x7, 0xff, 0xff, 0xe, 0x4f, 0x7, 0x80,
    0xc, 0x8f, 0x7, 0x80, 0x0, 0x8f, 0x7, 0x80,
    0x0, 0x9f, 0x7, 0x80, 0x0, 0x9f, 0x7, 0x80,
    0x1, 0x1f, 0x7, 0x80, 0x1, 0x3f, 0x7, 0x80,
    0x3, 0x2f, 0xff, 0xfc, 0x2, 0x6f, 0xff, 0xfc,
    0x2, 0xcf, 0x7, 0x80, 0x7, 0x8f, 0x7, 0x80,
    0x7, 0xf, 0x7, 0x80, 0x4, 0xf, 0x7, 0x80,
    0xc, 0xf, 0x7, 0x80, 0xc, 0xf, 0x7, 0x80,
    0xc, 0xf, 0x7, 0x80, 0x98, 0xf, 0x7, 0x80,
    0x98, 0xf, 0xff, 0xfc, 0xf8, 0xf, 0xff, 0xfc,
    0xf0, 0xf, 0x7, 0x80, 0x70, 0xf, 0x7, 0x80,
    0x70, 0xf, 0x7, 0x80, 0x70, 0xf, 0x7, 0x80,
    0x78, 0xf, 0x7, 0x80, 0x78, 0xf, 0x7, 0x80,
    0x3c, 0xf, 0x7, 0x80, 0x3c, 0xf, 0x7, 0x80,
    0x3c, 0xf, 0x7, 0x80, 0x1c, 0xf, 0x7, 0x80,
    0x18, 0xf, 0xff, 0xff, 0x18, 0xf, 0xff, 0xff,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,

    /* U+51C7 "凇" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x20,
    0x0, 0xf, 0x7, 0xa0, 0x0, 0xf, 0x7, 0xa0,
    0x0, 0xf, 0x7, 0xa0, 0x0, 0xf, 0x7, 0xa0,
    0x0, 0xf, 0x7, 0x90, 0x80, 0x8f, 0x7, 0x10,
    0x80, 0x8f, 0x7, 0x10, 0x40, 0x8f, 0x7, 0x10,
    0x60, 0x8f, 0x7, 0x18, 0x70, 0xff, 0xee, 0x18,
    0x38, 0xff, 0xee, 0x1c, 0x39, 0x1f, 0xc, 0x1c,
    0x11, 0x1f, 0xc, 0x1e, 0x11, 0x1f, 0x1c, 0xf,
    0x1, 0x1f, 0x18, 0xf, 0x3, 0x1f, 0x10, 0xf,
    0x2, 0x1f, 0x33, 0xc6, 0x2, 0x1f, 0x23, 0xc6,
    0x2, 0x3f, 0xc3, 0xc2, 0x6, 0x3f, 0xc3, 0xc2,
    0x6, 0x3f, 0xe3, 0xc0, 0x6, 0x3f, 0x73, 0xc0,
    0x4, 0x3f, 0x73, 0x80, 0xc, 0x7f, 0x33, 0x80,
    0xc, 0x6f, 0x23, 0x80, 0xc, 0xef, 0x3, 0xa0,
    0xc, 0xcf, 0x3, 0xa0, 0x58, 0xcf, 0x3, 0x20,
    0x59, 0x8f, 0x7, 0x20, 0x3b, 0xf, 0x7, 0x30,
    0x3a, 0xf, 0x7, 0x30, 0x3c, 0xf, 0x6, 0x30,
    0x38, 0xf, 0x6, 0x38, 0x1c, 0xf, 0xe, 0x38,
    0x1c, 0xf, 0xc, 0x3c, 0x1e, 0xf, 0xc, 0x1c,
    0xe, 0xf, 0x8, 0x1e, 0xe, 0xf, 0x18, 0x7f,
    0xe, 0xf, 0x13, 0xde, 0x4, 0xf, 0x3f, 0x8e,
    0x4, 0xf, 0x3f, 0xe, 0x0, 0xf, 0x3c, 0xe,
    0x0, 0xf, 0x30, 0x6, 0x0, 0xf, 0x0, 0x2,

    /* U+51C9 "凉" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0xe, 0x0,
    0x0, 0x0, 0x3, 0x80, 0x4, 0x0, 0x1, 0xe0,
    0x2, 0x0, 0x0, 0x70, 0x1, 0x80, 0x0, 0x38,
    0x0, 0x60, 0x7f, 0xff, 0xfe, 0x38, 0x3f, 0xff,
    0xff, 0x1c, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0x3, 0xc8, 0x0, 0x0, 0x1, 0xe4, 0x0,
    0x0, 0x0, 0x62, 0x3c, 0x3, 0xc0, 0x32, 0x1f,
    0xff, 0xe0, 0x11, 0xf, 0xff, 0xf0, 0x0, 0x87,
    0x80, 0x78, 0x0, 0xc3, 0xc0, 0x3c, 0x0, 0x41,
    0xe0, 0x1e, 0x0, 0x20, 0xf0, 0xf, 0x0, 0x30,
    0x78, 0x7, 0x80, 0x18, 0x3c, 0x3, 0xc0, 0xc,
    0x1e, 0x1, 0xe0, 0x4, 0xf, 0x0, 0xf0, 0x6,
    0x7, 0xff, 0xf8, 0x3, 0x3, 0xc0, 0x3c, 0x1,
    0x81, 0xe0, 0x1e, 0x1, 0x80, 0xf3, 0xcf, 0x0,
    0xc0, 0x1, 0xe0, 0x0, 0x60, 0x0, 0xf0, 0x4,
    0x70, 0x1e, 0x79, 0x1, 0x30, 0xf, 0x3c, 0x80,
    0xd8, 0x7, 0x9e, 0x40, 0x3c, 0x3, 0x8f, 0x30,
    0x1e, 0x3, 0xc7, 0x98, 0xe, 0x1, 0xe3, 0xce,
    0x7, 0x80, 0xe1, 0xe7, 0x1, 0xc0, 0x70, 0xf1,
    0xe0, 0xf0, 0x30, 0x78, 0xf8, 0x78, 0x30, 0x3c,
    0x7c, 0x1e, 0x18, 0x1e, 0x1e, 0xf, 0x18, 0xf,
    0xe, 0x7, 0x88, 0x7, 0x83, 0x1, 0x88, 0x3,
    0xc1, 0x80, 0xc8, 0x3, 0xc0, 0x40, 0x40, 0x3,
    0xe0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0, 0x1f,
    0xc0, 0x0,

    /* U+51CB "凋" */
    0x0, 0x1e, 0x0, 0xf, 0x0, 0x1f, 0xff, 0xff,
    0x20, 0x1f, 0xff, 0xff, 0x30, 0x1e, 0x0, 0xf,
    0x38, 0x1e, 0x1e, 0xf, 0x18, 0x1e, 0x1e, 0xf,
    0x1c, 0x1e, 0x1e, 0xf, 0x1e, 0x1e, 0x1e, 0xf,
    0xe, 0x3e, 0x1e, 0xf, 0xf, 0x5e, 0xff, 0xcf,
    0xe, 0x5e, 0xff, 0xcf, 0x6, 0x5e, 0x1e, 0xf,
    0x4, 0x5e, 0x1e, 0xf, 0x0, 0x9e, 0x1e, 0xf,
    0x0, 0x9e, 0x1e, 0xf, 0x0, 0x9e, 0x1e, 0xf,
    0x1, 0x9e, 0xff, 0xef, 0x1, 0x9e, 0xff, 0xef,
    0x1, 0x1e, 0x0, 0xf, 0x3, 0x1e, 0x0, 0xf,
    0x3, 0x1e, 0x0, 0xf, 0x3, 0x1e, 0xe3, 0xcf,
    0x2, 0x1e, 0xe3, 0xcf, 0x6, 0x1e, 0xff, 0xcf,
    0x6, 0x1e, 0xe3, 0xcf, 0x6, 0x1e, 0xe3, 0xcf,
    0xe, 0x1e, 0xe3, 0xcf, 0x8c, 0x1e, 0xe3, 0xcf,
    0x8c, 0x1e, 0xe3, 0xcf, 0x5c, 0x1e, 0xe3, 0xcf,
    0x7c, 0x1e, 0xe3, 0xcf, 0x78, 0x1e, 0xe3, 0xcf,
    0x78, 0x1e, 0xff, 0xcf, 0x78, 0x1e, 0xff, 0xcf,
    0x38, 0x1c, 0xe3, 0xcf, 0x3c, 0x1c, 0xe3, 0xcf,
    0x3e, 0x1c, 0xe3, 0xcf, 0x1e, 0x38, 0x0, 0xf,
    0x1f, 0x38, 0x0, 0xf, 0x1e, 0x30, 0x0, 0xf,
    0xe, 0x60, 0x0, 0xf, 0xc, 0x60, 0x0, 0xf,
    0xc, 0xc0, 0x0, 0x1e, 0x0, 0x80, 0x0, 0x7c,
    0x1, 0x0, 0x0, 0xf8, 0x2, 0x0, 0x3, 0x60,

    /* U+51CC "凌" */
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x20, 0x0, 0x1e, 0x0, 0x30, 0x0, 0x1e, 0x0,
    0x38, 0x7, 0xff, 0xfc, 0x18, 0x7, 0xff, 0xfc,
    0x1c, 0x20, 0x1e, 0x0, 0x1e, 0x20, 0x1e, 0x0,
    0x1e, 0x40, 0x1e, 0x0, 0xe, 0x40, 0x1e, 0x0,
    0xe, 0x40, 0x1e, 0x0, 0xc, 0x5f, 0xff, 0xff,
    0x4, 0xdf, 0xff, 0xff, 0x0, 0x80, 0x1, 0x0,
    0x0, 0x83, 0xc0, 0x80, 0x1, 0x83, 0xc0, 0xc0,
    0x1, 0x87, 0x80, 0xe0, 0x1, 0x87, 0x80, 0xf0,
    0x1, 0x7, 0x0, 0x7c, 0x3, 0xf, 0xe0, 0x7f,
    0x3, 0xf, 0xe0, 0x3e, 0x3, 0x1d, 0xe0, 0xfe,
    0x6, 0x19, 0xc0, 0xfe, 0x6, 0x33, 0xff, 0xf6,
    0x6, 0x63, 0xff, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xe, 0x3, 0x80, 0xf0, 0x8c, 0x3, 0xc1, 0xf0,
    0xdc, 0x3, 0xc1, 0xe0, 0x5c, 0x7, 0x41, 0xe0,
    0x7c, 0x7, 0x61, 0xe0, 0x7c, 0x6, 0x33, 0xc0,
    0x38, 0xc, 0x33, 0xc0, 0x38, 0xc, 0x3b, 0x80,
    0x3c, 0x18, 0x1f, 0x0, 0x1e, 0x18, 0x1f, 0x0,
    0x1e, 0x30, 0xf, 0x0, 0x1f, 0x0, 0x1f, 0xc0,
    0xf, 0x0, 0x3f, 0xf0, 0xf, 0x0, 0x63, 0xfe,
    0xf, 0x0, 0xc1, 0xff, 0x6, 0x3, 0x80, 0xfe,
    0x6, 0x7, 0x0, 0x7e, 0x0, 0xc, 0x0, 0x1e,
    0x0, 0x18, 0x0, 0x6, 0x0, 0x60, 0x0, 0x1,

    /* U+51CD "凍" */
    0x0, 0x0, 0x38, 0x0, 0x0, 0x0, 0x70, 0x0,
    0x80, 0x0, 0xe0, 0x1, 0x80, 0x1, 0xc0, 0x3,
    0x80, 0x3, 0x80, 0x7, 0xf, 0xff, 0xff, 0xc7,
    0x1f, 0xff, 0xff, 0x8f, 0x0, 0x1c, 0x0, 0x1e,
    0x0, 0x38, 0x0, 0x3c, 0x78, 0x70, 0xf0, 0x32,
    0xf0, 0xe1, 0xe0, 0x65, 0xff, 0xff, 0xc0, 0x8b,
    0xff, 0xff, 0x80, 0x27, 0x87, 0xf, 0x0, 0x4f,
    0xe, 0x1e, 0x0, 0x9e, 0x1c, 0x3c, 0x1, 0x3c,
    0x38, 0x78, 0x6, 0x7f, 0xff, 0xf0, 0x8, 0xff,
    0xff, 0xe0, 0x11, 0xe1, 0xc3, 0xc0, 0x63, 0xc3,
    0x87, 0x80, 0xc7, 0x87, 0xf, 0x1, 0xf, 0xe,
    0x1e, 0x6, 0x1f, 0xff, 0xfc, 0xc, 0x3f, 0xff,
    0xf8, 0x18, 0x78, 0x74, 0xf0, 0x60, 0xf0, 0xe9,
    0xe4, 0xc0, 0x1f, 0xd0, 0x9, 0x80, 0x3f, 0xb0,
    0x1b, 0x0, 0x77, 0x20, 0x3c, 0x1, 0xee, 0x60,
    0x78, 0x3, 0xdc, 0xc0, 0xf0, 0x7, 0x39, 0xc0,
    0xe0, 0x1c, 0x73, 0xc1, 0xe0, 0x38, 0xe3, 0xc3,
    0xe0, 0xe1, 0xc7, 0xc3, 0xc1, 0x83, 0x8f, 0xc7,
    0x86, 0x7, 0xf, 0x8e, 0x18, 0xe, 0xe, 0xc,
    0x30, 0x1c, 0x1c, 0x18, 0xc0, 0x38, 0x18, 0x3,
    0x0, 0x70, 0x10, 0x8, 0x0, 0xe0, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x3, 0x80, 0x0,

    /* U+51CF "减" */
    0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xee, 0x4, 0x0, 0x0, 0x73,
    0xc3, 0x0, 0x0, 0x39, 0xe1, 0xc3, 0x80, 0x1c,
    0x70, 0x71, 0xc0, 0xe, 0x10, 0x3c, 0xff, 0xff,
    0xff, 0x1f, 0x7f, 0xff, 0xff, 0x87, 0xb8, 0x1,
    0xc0, 0x3, 0x9c, 0x0, 0xe0, 0x0, 0xce, 0x0,
    0x70, 0x0, 0x4f, 0x0, 0x39, 0xe0, 0x27, 0x80,
    0x1c, 0xf0, 0x3, 0xdf, 0xee, 0x78, 0x2, 0xef,
    0xf7, 0x3c, 0x1, 0x70, 0x3, 0x9e, 0x0, 0xb8,
    0x1, 0xcf, 0x0, 0xdc, 0x0, 0xe7, 0x80, 0x6e,
    0x0, 0x73, 0xc0, 0x27, 0x73, 0xb9, 0xe0, 0x13,
    0xb9, 0xdc, 0xf0, 0x19, 0xdf, 0xee, 0x78, 0xc,
    0xef, 0xf7, 0x3c, 0x6, 0x77, 0x3b, 0x9e, 0x2,
    0x3b, 0x9d, 0xcf, 0x23, 0x1d, 0xce, 0xe7, 0x91,
    0x8e, 0xe7, 0x73, 0x84, 0xc7, 0x73, 0xbb, 0xc2,
    0xe3, 0xb9, 0xcd, 0xe1, 0xf1, 0xdc, 0xe7, 0xf4,
    0x70, 0xee, 0x73, 0xf2, 0x38, 0x77, 0xf9, 0xf9,
    0x1c, 0x3b, 0xfc, 0xf8, 0x8e, 0x1d, 0xce, 0x78,
    0x43, 0x8e, 0xe7, 0x3e, 0x61, 0xc7, 0x73, 0x9f,
    0x30, 0xf3, 0x38, 0x1f, 0xd8, 0x79, 0x80, 0x1d,
    0xec, 0x1d, 0xc0, 0xc, 0xfe, 0xc, 0xc0, 0xc,
    0x3f, 0x6, 0xc0, 0xc, 0xf, 0x80, 0x60, 0xc,
    0x7, 0xc0, 0x60, 0xc, 0x1, 0xe0, 0x20, 0xc,
    0x0, 0x30, 0x20, 0x0, 0x0, 0x8,

    /* U+51D1 "凑" */
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x3c, 0x0,
    0x30, 0x0, 0x3c, 0x0, 0x38, 0x1f, 0xff, 0xfe,
    0x38, 0x1f, 0xff, 0xfe, 0x1c, 0x0, 0x3c, 0x0,
    0x1e, 0x20, 0x38, 0x0, 0x1f, 0x20, 0x78, 0x0,
    0xe, 0x20, 0x78, 0x0, 0xe, 0x4f, 0xff, 0xf8,
    0xc, 0x4f, 0xff, 0xf8, 0x4, 0x40, 0x78, 0x0,
    0x0, 0x80, 0x70, 0x0, 0x0, 0x80, 0xf0, 0x0,
    0x0, 0x80, 0xf0, 0x0, 0x1, 0xbf, 0xff, 0xff,
    0x1, 0x3f, 0xff, 0xff, 0x1, 0x1, 0xc1, 0x0,
    0x3, 0x1, 0xc0, 0x80, 0x3, 0x3, 0x80, 0xc0,
    0x2, 0x3, 0x0, 0xc0, 0x6, 0x6, 0x0, 0x60,
    0x6, 0xf, 0xff, 0xf8, 0x6, 0xb, 0xff, 0xbe,
    0xc, 0x18, 0x3c, 0x3f, 0x8c, 0x30, 0x3c, 0x1e,
    0x8c, 0x60, 0x3c, 0x1e, 0x5c, 0x80, 0x3c, 0xe,
    0x79, 0x0, 0x3c, 0x2, 0x78, 0x1f, 0xff, 0xf8,
    0x78, 0x1f, 0xff, 0xf8, 0x38, 0x0, 0x7a, 0x0,
    0x3c, 0x0, 0x7a, 0x0, 0x3c, 0x0, 0x73, 0x0,
    0x1e, 0x0, 0xf3, 0x0, 0x1e, 0x0, 0xe1, 0x80,
    0x1f, 0x1, 0xc1, 0x80, 0xf, 0x1, 0x81, 0xc0,
    0xf, 0x3, 0x1, 0xf0, 0x6, 0x6, 0x0, 0xfc,
    0x6, 0xc, 0x0, 0xfc, 0x0, 0x18, 0x0, 0x78,
    0x0, 0x30, 0x0, 0x38, 0x0, 0x40, 0x0, 0x18,
    0x0, 0x0, 0x0, 0x0,

    /* U+51DB "凛" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x8, 0x0, 0x3, 0x80, 0x4, 0x0, 0x1, 0xc0,
    0x3, 0x3, 0xff, 0xff, 0xf8, 0xc1, 0xff, 0xff,
    0xfc, 0x70, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0xe, 0xe, 0x0, 0xe, 0x7, 0x97, 0xff,
    0xff, 0x3, 0xcb, 0x80, 0x3, 0x80, 0xc9, 0xc0,
    0x1, 0xc0, 0x64, 0xe7, 0x1c, 0xe0, 0x12, 0x73,
    0xfe, 0x70, 0x1, 0x39, 0xff, 0x38, 0x0, 0x9c,
    0xe3, 0x9c, 0x0, 0x8e, 0x71, 0xce, 0x0, 0x47,
    0x38, 0xe7, 0x0, 0x23, 0x9f, 0xf3, 0x80, 0x31,
    0xcf, 0xf9, 0xc0, 0x18, 0xe7, 0x1c, 0xe0, 0x8,
    0x70, 0x0, 0x70, 0xc, 0x38, 0x0, 0x38, 0x6,
    0x1f, 0xff, 0xfc, 0x3, 0xf, 0xff, 0xfe, 0x1,
    0x87, 0x0, 0x7, 0x1, 0x80, 0x0, 0x0, 0x0,
    0xc0, 0x0, 0x0, 0x0, 0x60, 0xff, 0xff, 0xe4,
    0x70, 0x7f, 0xff, 0xf1, 0x38, 0x0, 0x0, 0x0,
    0xd8, 0x0, 0x0, 0x0, 0x7c, 0x7f, 0xff, 0xff,
    0x9e, 0x3f, 0xff, 0xff, 0xcf, 0x0, 0x3, 0x88,
    0x7, 0x0, 0x1, 0xc4, 0x1, 0xc0, 0x78, 0xe2,
    0x0, 0xf0, 0x3c, 0x71, 0x80, 0x78, 0x1c, 0x38,
    0xe0, 0x1e, 0x1e, 0x1c, 0x78, 0xf, 0xe, 0xe,
    0x1f, 0x7, 0x86, 0x7, 0xf, 0xc1, 0x87, 0x3,
    0x83, 0xc0, 0xc3, 0x1, 0xc1, 0xe0, 0x23, 0x1,
    0xe0, 0x60, 0x3, 0x1, 0xf0, 0x10, 0x3, 0x3,
    0xf0, 0x0, 0x0, 0x6, 0x60, 0x0,

    /* U+51DD "凝" */
    0x0, 0x70, 0x0, 0x4, 0x0, 0x70, 0x0, 0x4,
    0x40, 0x70, 0x3f, 0xfc, 0x40, 0x70, 0x3f, 0xfc,
    0x20, 0x71, 0x80, 0x1c, 0x30, 0x73, 0x0, 0x18,
    0x30, 0x76, 0x0, 0x30, 0x38, 0x7c, 0x8, 0x60,
    0x3c, 0x79, 0x4, 0x60, 0x1c, 0x71, 0x7, 0xc0,
    0x1c, 0x71, 0x7, 0x80, 0x18, 0x71, 0x83, 0x80,
    0x1a, 0x71, 0x83, 0xc0, 0x2, 0x7f, 0x81, 0xe0,
    0x2, 0x7f, 0x81, 0xc7, 0x2, 0x7f, 0x1, 0x87,
    0x2, 0x0, 0x3f, 0xff, 0x4, 0xe0, 0x3f, 0xff,
    0x4, 0xe0, 0x1, 0xc7, 0x4, 0xe0, 0x1, 0xc7,
    0x4, 0xe0, 0x1, 0xc7, 0xc, 0xff, 0x39, 0xc7,
    0xd, 0xff, 0x39, 0xc5, 0x9, 0xfc, 0x39, 0xc0,
    0x19, 0xbc, 0x39, 0xc0, 0x19, 0x3c, 0x39, 0xc0,
    0x1b, 0x3c, 0x39, 0xc0, 0x1a, 0x3c, 0x39, 0xfe,
    0xb8, 0x3c, 0x39, 0xfe, 0xb3, 0xff, 0xb9, 0xc0,
    0xf3, 0xff, 0xb9, 0xc0, 0xf0, 0x38, 0x39, 0xc0,
    0x70, 0x38, 0x39, 0xc0, 0x70, 0x38, 0x39, 0xc0,
    0x70, 0x7c, 0x39, 0xc0, 0x78, 0x7c, 0x39, 0xc0,
    0x38, 0x6e, 0x39, 0xc0, 0x38, 0x67, 0x79, 0xc0,
    0x3c, 0xc7, 0xf9, 0xc0, 0x3c, 0xc7, 0x79, 0xc0,
    0x1c, 0x82, 0x79, 0xc0, 0x19, 0x82, 0xef, 0xc0,
    0x11, 0x0, 0xc7, 0xff, 0x2, 0x1, 0x87, 0xfe,
    0x6, 0x1, 0x3, 0xfe, 0x4, 0x2, 0x0, 0x0,

    /* U+51DF "凟" */
    0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x38, 0x1,
    0x0, 0x0, 0x70, 0x3, 0x0, 0x0, 0xe0, 0x3,
    0x3, 0xff, 0xff, 0xe7, 0x7, 0xff, 0xff, 0xcf,
    0x0, 0x7, 0x0, 0xe, 0x0, 0xe, 0x0, 0x1e,
    0x0, 0x1c, 0x0, 0x3c, 0x3f, 0xff, 0xf0, 0x31,
    0x7f, 0xff, 0xe0, 0x64, 0x0, 0x0, 0x0, 0x48,
    0x0, 0x0, 0x0, 0x17, 0x80, 0x3, 0xc0, 0x2f,
    0xff, 0xff, 0x80, 0x5e, 0x71, 0xcf, 0x1, 0x3c,
    0xe3, 0x9e, 0x2, 0x79, 0xc7, 0x3c, 0x4, 0xf3,
    0x8e, 0x78, 0x9, 0xe7, 0x1c, 0xf0, 0x33, 0xce,
    0x39, 0xe0, 0x67, 0xff, 0xff, 0xc0, 0x8f, 0x0,
    0x7, 0x81, 0x1e, 0x0, 0xf, 0x6, 0x1e, 0x0,
    0x78, 0xc, 0x3f, 0xff, 0xf0, 0x18, 0x7f, 0xff,
    0xe0, 0x20, 0xf0, 0x3, 0xc0, 0xc1, 0xe0, 0x7,
    0x81, 0x83, 0xff, 0xcf, 0x13, 0x7, 0x80, 0x1e,
    0x26, 0xf, 0x0, 0x3c, 0x78, 0x1f, 0xfe, 0x78,
    0xf0, 0x3f, 0xfc, 0xf0, 0xe0, 0x78, 0x1, 0xe1,
    0xc0, 0xf0, 0x3, 0xc3, 0xc1, 0xff, 0xff, 0x87,
    0x83, 0xff, 0xff, 0x7, 0x87, 0x80, 0x9e, 0xf,
    0x1, 0xf1, 0x80, 0x1c, 0x3, 0xc1, 0xc0, 0x18,
    0xf, 0x1, 0xfc, 0x20, 0x3c, 0x3, 0xf8, 0x0,
    0xe0, 0x3, 0xe0, 0x3, 0x80, 0x3, 0xc0, 0xc,
    0x0, 0x1, 0x80,

    /* U+51E0 "几" */
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xff, 0xfe, 0x0, 0x1, 0xff, 0xfe, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x1, 0xe0, 0x1e, 0x4, 0x1, 0xe0, 0x1e, 0x4,
    0x1, 0xe0, 0x1e, 0x4, 0x1, 0xe0, 0x1e, 0x4,
    0x1, 0xe0, 0x1e, 0x4, 0x1, 0xc0, 0x1e, 0x4,
    0x3, 0xc0, 0x1e, 0x4, 0x3, 0x80, 0x1e, 0x4,
    0x3, 0x0, 0x1e, 0x4, 0x7, 0x0, 0x1e, 0x7,
    0x6, 0x0, 0x1e, 0x7, 0xc, 0x0, 0x1e, 0xf,
    0x18, 0x0, 0x1f, 0xff, 0x18, 0x0, 0x1f, 0xff,
    0x30, 0x0, 0x7, 0xfc, 0x60, 0x0, 0x0, 0x0,

    /* U+51E1 "凡" */
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xff, 0xff, 0x0, 0x3, 0xff, 0xff, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc8, 0xf, 0x0, 0x3, 0xc8, 0xf, 0x0,
    0x3, 0xcc, 0xf, 0x0, 0x3, 0xce, 0xf, 0x0,
    0x3, 0xc6, 0xf, 0x0, 0x3, 0xc7, 0xf, 0x0,
    0x3, 0xc7, 0x8f, 0x0, 0x3, 0xc7, 0x8f, 0x0,
    0x3, 0xc7, 0xcf, 0x0, 0x3, 0xc3, 0xcf, 0x0,
    0x3, 0xc3, 0xef, 0x0, 0x3, 0xc3, 0xcf, 0x0,
    0x3, 0xc1, 0xcf, 0x0, 0x3, 0xc1, 0x8f, 0x0,
    0x3, 0xc1, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0xc0, 0xf, 0x1,
    0x3, 0xc0, 0xf, 0x1, 0x3, 0xc0, 0xf, 0x2,
    0x3, 0xc0, 0xf, 0x2, 0x3, 0xc0, 0xf, 0x2,
    0x7, 0x80, 0xf, 0x2, 0x7, 0x80, 0xf, 0x2,
    0x7, 0x0, 0xf, 0x2, 0x7, 0x0, 0xf, 0x7,
    0xe, 0x0, 0xf, 0x7, 0xc, 0x0, 0xf, 0x7,
    0x18, 0x0, 0xf, 0x7, 0x18, 0x0, 0xf, 0xff,
    0x30, 0x0, 0xf, 0xff, 0x20, 0x0, 0xf, 0xfe,
    0x40, 0x0, 0x7, 0xfe, 0x80, 0x0, 0x0, 0x0,

    /* U+51E4 "凤" */
    0x1e, 0x0, 0x0, 0xf0, 0xf, 0x0, 0x0, 0x78,
    0x7, 0xff, 0xff, 0xfc, 0x3, 0xff, 0xff, 0xfe,
    0x1, 0xe0, 0x0, 0xf, 0x0, 0xf0, 0x0, 0x7,
    0x80, 0x78, 0x0, 0x3, 0xc0, 0x3c, 0x0, 0xf1,
    0xe0, 0x1e, 0x0, 0x78, 0xf0, 0xf, 0x3f, 0xfc,
    0x78, 0x7, 0x9f, 0xfe, 0x3c, 0x3, 0xc0, 0xf,
    0x1e, 0x1, 0xe0, 0x7, 0x8f, 0x0, 0xf0, 0x3,
    0xc7, 0x80, 0x78, 0x1, 0xe3, 0xc0, 0x3c, 0x80,
    0xf1, 0xe0, 0x1e, 0x60, 0x78, 0xf0, 0xf, 0x10,
    0x3c, 0x78, 0x7, 0x8c, 0x1e, 0x3c, 0x3, 0xc3,
    0xf, 0x1e, 0x1, 0xe1, 0x87, 0x8f, 0x0, 0xf0,
    0xe3, 0x87, 0x80, 0x78, 0x33, 0xc3, 0xc0, 0x3c,
    0x1d, 0xe1, 0xe0, 0x1e, 0x7, 0xf0, 0xf0, 0xf,
    0x3, 0xf0, 0x78, 0x7, 0x80, 0xf8, 0x3c, 0x3,
    0xc0, 0x78, 0x1e, 0x1, 0xe0, 0x3e, 0xf, 0x0,
    0xf0, 0x1f, 0x7, 0x80, 0x78, 0x1f, 0xc3, 0xc0,
    0x3c, 0xd, 0xe1, 0xe0, 0x1e, 0xe, 0xf8, 0xf0,
    0xf, 0x6, 0x3e, 0x78, 0x87, 0x86, 0x1f, 0x3c,
    0x43, 0x86, 0x7, 0x9f, 0x21, 0xc2, 0x3, 0xc7,
    0x90, 0xe2, 0x0, 0xc3, 0xc8, 0x62, 0x0, 0x61,
    0xe4, 0x72, 0x0, 0x0, 0x7a, 0x39, 0x0, 0x0,
    0x3f, 0x98, 0x0, 0x0, 0x1f, 0xc8, 0x0, 0x0,
    0x7, 0xec, 0x0, 0x0, 0x1, 0xf4, 0x0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x0, 0x1c,

    /* U+51EB "凫" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x7, 0x82, 0x0, 0xf0, 0x7, 0xff, 0xff, 0xf0,
    0x7, 0xff, 0xff, 0xf0, 0x7, 0x80, 0x0, 0xf0,
    0x7, 0x80, 0x0, 0xf0, 0x7, 0x88, 0x0, 0xf0,
    0x7, 0x87, 0x0, 0xf0, 0x7, 0x83, 0xe0, 0xf0,
    0x7, 0x81, 0xe0, 0xf0, 0x7, 0x80, 0xe0, 0xf0,
    0x7, 0x80, 0x60, 0xf0, 0x7, 0x80, 0x21, 0xe0,
    0x7, 0x80, 0x3, 0xc0, 0x7, 0x80, 0x3f, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x1c,
    0x7, 0xff, 0xff, 0xfc, 0x7, 0xff, 0xff, 0xfc,
    0x7, 0x80, 0x0, 0x1c, 0x7, 0x80, 0x0, 0x1c,
    0x0, 0x0, 0x0, 0x1c, 0x0, 0x78, 0x3c, 0x1c,
    0x0, 0x78, 0x3c, 0x1c, 0x0, 0x7f, 0xfc, 0x1c,
    0x0, 0x7f, 0xfc, 0x1c, 0x0, 0x78, 0x3c, 0x38,
    0x0, 0x78, 0x3d, 0xf0, 0x0, 0x78, 0x3e, 0x0,
    0x0, 0x78, 0x3c, 0x2, 0x0, 0x70, 0x3c, 0x2,
    0x0, 0xf0, 0x3c, 0x2, 0x0, 0xf0, 0x3c, 0x2,
    0x0, 0xe0, 0x3c, 0x2, 0x1, 0xe0, 0x3c, 0x2,
    0x1, 0xc0, 0x3c, 0x3, 0x3, 0x80, 0x3c, 0x3,
    0x7, 0x0, 0x3c, 0x7, 0xe, 0x0, 0x3f, 0xff,
    0x1c, 0x0, 0x3f, 0xff, 0x30, 0x0, 0x3f, 0xfe,
    0xc0, 0x0, 0x1f, 0xfe,

    /* U+51ED "凭" */
    0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x3c,
    0x0, 0x78, 0x0, 0xff, 0x0, 0x78, 0x3, 0xff,
    0xe0, 0x3c, 0x3f, 0xf8, 0x0, 0x1c, 0x20, 0x38,
    0x0, 0x1e, 0x0, 0x1c, 0x0, 0xf, 0x80, 0xe,
    0x0, 0xf, 0xc0, 0x7, 0x0, 0x7, 0xe0, 0x3,
    0x80, 0x6, 0xf0, 0x1, 0xc0, 0x3, 0x79, 0xff,
    0xff, 0xf3, 0x3c, 0xff, 0xff, 0xfb, 0x1e, 0x0,
    0x38, 0x1, 0xf, 0x0, 0x1c, 0x0, 0x7, 0x80,
    0xe, 0x0, 0x3, 0xc0, 0x7, 0x0, 0x1, 0xe0,
    0x3, 0x80, 0x0, 0xf0, 0x1, 0xc0, 0x0, 0x78,
    0x0, 0xe0, 0x0, 0x3c, 0x7f, 0xff, 0xe0, 0x1e,
    0x3f, 0xff, 0xf0, 0xf, 0x0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3e, 0x7, 0xc0, 0x0,
    0x1f, 0x3, 0xe0, 0x0, 0xf, 0xff, 0xf0, 0x0,
    0x7, 0xff, 0xf8, 0x0, 0x3, 0xe0, 0x7c, 0x0,
    0x1, 0xf0, 0x3e, 0x0, 0x0, 0xf8, 0x1f, 0x1,
    0x0, 0x7c, 0xf, 0x80, 0x80, 0x3e, 0x7, 0xc0,
    0x40, 0x1f, 0x3, 0xe0, 0x20, 0xf, 0x1, 0xf0,
    0x30, 0x7, 0x80, 0xf8, 0x18, 0x7, 0x80, 0x7c,
    0xc, 0x3, 0xc0, 0x3e, 0x6, 0x3, 0xc0, 0x1f,
    0x3, 0x3, 0xc0, 0xf, 0x81, 0x83, 0x80, 0x7,
    0xc1, 0xc3, 0x80, 0x1, 0xff, 0xe3, 0x0, 0x0,
    0xff, 0xf2, 0x0, 0x0, 0x3f, 0xf0,

    /* U+51EF "凯" */
    0x1, 0xc0, 0x3c, 0x78, 0x0, 0xe0, 0x1e, 0x3c,
    0x1c, 0x71, 0xef, 0x1e, 0xe, 0x38, 0xf7, 0xff,
    0x7, 0x1c, 0x7b, 0xff, 0x83, 0x8e, 0x3d, 0xe3,
    0xc1, 0xc7, 0x1e, 0xf1, 0xe0, 0xe3, 0x8f, 0x78,
    0xf0, 0x71, 0xc7, 0xbc, 0x78, 0x38, 0xe3, 0xde,
    0x3c, 0x1c, 0x71, 0xef, 0x1e, 0xf, 0xff, 0xf7,
    0x8f, 0x7, 0xff, 0xfb, 0xc7, 0x83, 0x80, 0x3d,
    0xe3, 0xc1, 0xc0, 0x1e, 0xf1, 0xe0, 0x0, 0x0,
    0x78, 0xf0, 0x0, 0x0, 0x3c, 0x78, 0x0, 0x7,
    0x9e, 0x3c, 0x0, 0x3, 0xcf, 0x1e, 0xf, 0xff,
    0xe7, 0x8f, 0x7, 0xff, 0xf3, 0xc7, 0x80, 0x0,
    0x79, 0xe3, 0xc0, 0x0, 0x3c, 0xf1, 0xe0, 0x0,
    0x1e, 0x78, 0xf0, 0x0, 0xf, 0x3c, 0x78, 0x1e,
    0x7, 0x9e, 0x3c, 0xf, 0x3, 0xcf, 0x1e, 0x7,
    0x81, 0xe7, 0x8f, 0x3, 0xff, 0xf3, 0xc7, 0x91,
    0xff, 0xf9, 0xe3, 0xc8, 0xf0, 0x3c, 0xf1, 0xe4,
    0x78, 0x0, 0x78, 0xf2, 0x3c, 0x0, 0x3c, 0x79,
    0x1e, 0x0, 0x9e, 0x3c, 0x8f, 0x0, 0x8f, 0x1e,
    0x47, 0x81, 0xcf, 0x8f, 0x23, 0xc1, 0xc7, 0x87,
    0x91, 0xe3, 0xc3, 0xc3, 0xc8, 0xff, 0x83, 0xc1,
    0xe7, 0xff, 0x81, 0xe0, 0xf3, 0xff, 0x0, 0xe0,
    0x79, 0xbf, 0x0, 0xe0, 0x3f, 0xde, 0x0, 0xe0,
    0x1f, 0xe8, 0x0, 0x60, 0xf, 0xe0, 0x0, 0x60,
    0x3, 0xf0, 0x0, 0x60, 0x0, 0x0,

    /* U+51F0 "凰" */
    0x1e, 0x0, 0x0, 0xf8, 0xf, 0xff, 0xff, 0xfc,
    0x7, 0xff, 0xff, 0xfe, 0x3, 0xc0, 0x0, 0x1f,
    0x1, 0xe0, 0x3c, 0xf, 0x80, 0xf0, 0x1e, 0x7,
    0xc0, 0x78, 0xe, 0x3, 0xe0, 0x3c, 0xf7, 0x3d,
    0xf0, 0x1e, 0x7f, 0xfe, 0xf8, 0xf, 0x3f, 0xff,
    0x7c, 0x7, 0x9e, 0x7, 0xbe, 0x3, 0xcf, 0x3,
    0xdf, 0x1, 0xe7, 0x81, 0xef, 0x80, 0xf3, 0xfe,
    0xf7, 0xc0, 0x79, 0xff, 0x7b, 0xe0, 0x3c, 0xf0,
    0x3d, 0xf0, 0x1e, 0x78, 0x1e, 0xf8, 0xf, 0x3c,
    0xf, 0x7c, 0x7, 0x9e, 0x7, 0xbe, 0x3, 0xcf,
    0xff, 0xdf, 0x1, 0xe7, 0xff, 0xef, 0x80, 0xf3,
    0xc0, 0xf7, 0xc0, 0x78, 0x0, 0x3, 0xe0, 0x3c,
    0x0, 0x1, 0xf0, 0x1e, 0xff, 0xfe, 0xf8, 0xf,
    0x7f, 0xff, 0x7c, 0x7, 0x80, 0xf0, 0x3e, 0x3,
    0xc0, 0x78, 0x1f, 0x1, 0xe0, 0x3c, 0xf, 0x80,
    0xf0, 0x1e, 0x7, 0xc0, 0x78, 0xf, 0x3, 0xe0,
    0x3c, 0xff, 0xfd, 0xf1, 0x1e, 0x7f, 0xfe, 0xf8,
    0x8f, 0x1, 0xe0, 0x7c, 0x47, 0x80, 0xf0, 0x3e,
    0x23, 0x80, 0x78, 0x1f, 0x11, 0xc0, 0x3c, 0x7,
    0xd8, 0xe0, 0x1e, 0x3, 0xec, 0xe0, 0xf, 0x1,
    0xf6, 0x77, 0xff, 0xff, 0x7f, 0x30, 0x0, 0x0,
    0x3f, 0x98, 0x0, 0x0, 0xf, 0xc8, 0x0, 0x0,
    0x7, 0xec, 0x0, 0x0, 0x1, 0xf4, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0xc,

    /* U+51F1 "凱" */
    0x1, 0xe0, 0x1c, 0x70, 0x3, 0xc0, 0x38, 0xe1,
    0xc7, 0x9e, 0x71, 0xc3, 0x8f, 0x3c, 0xff, 0x87,
    0x1e, 0x79, 0xff, 0xe, 0x3c, 0xf3, 0x8e, 0x1c,
    0x79, 0xe7, 0x1c, 0x38, 0xf3, 0xce, 0x38, 0x71,
    0xe7, 0x9c, 0x70, 0xe3, 0xcf, 0x38, 0xe1, 0xff,
    0xfe, 0x71, 0xc3, 0xff, 0xfc, 0xe3, 0x87, 0x0,
    0x79, 0xc7, 0xe, 0x0, 0xf3, 0x8e, 0x0, 0x0,
    0x7, 0x1c, 0x0, 0x0, 0xe, 0x38, 0xff, 0xff,
    0x9c, 0x71, 0xff, 0xff, 0x38, 0xe0, 0x0, 0x0,
    0x71, 0xc0, 0x0, 0x0, 0xe3, 0x83, 0x80, 0xe1,
    0xc7, 0x7, 0xff, 0xc3, 0x8e, 0xf, 0xff, 0x87,
    0x1c, 0x1c, 0x7, 0xe, 0x38, 0x38, 0xe, 0x1c,
    0x70, 0x70, 0x1c, 0x38, 0xe0, 0xe0, 0x38, 0x71,
    0xc1, 0xc0, 0x70, 0xe3, 0x83, 0xff, 0xe1, 0xc7,
    0x7, 0x1, 0xc3, 0x8e, 0xe, 0x3, 0x86, 0x1c,
    0x8, 0xc, 0xc, 0x38, 0x18, 0x18, 0x38, 0x74,
    0x18, 0x20, 0x70, 0xe8, 0x38, 0xc2, 0xc1, 0xd0,
    0x71, 0x89, 0x83, 0xa0, 0x62, 0x67, 0x7, 0x40,
    0x8f, 0xc, 0xe, 0xa0, 0x3c, 0x38, 0x1d, 0xbf,
    0xe0, 0x60, 0x3b, 0x7f, 0x1, 0x80, 0x76, 0xf0,
    0x2, 0x0, 0xfc, 0x0, 0xc, 0x1, 0xf8, 0x0,
    0x30, 0x3, 0xf0, 0x0, 0xc0, 0x0, 0x0, 0x3,
    0x0, 0x0, 0x0,

    /* U+51F3 "凳" */
    0x0, 0xf, 0x20, 0x20, 0x0, 0x7, 0x88, 0x30,
    0xf, 0xff, 0xc4, 0x30, 0x7, 0xff, 0xe3, 0x30,
    0xc0, 0x0, 0xe0, 0x90, 0xc0, 0x0, 0xf0, 0x70,
    0xc0, 0x30, 0x78, 0x38, 0xc0, 0xe, 0x38, 0xe,
    0xc0, 0x7, 0xbc, 0x3, 0xc0, 0x1, 0xdf, 0xff,
    0xe0, 0x0, 0xf8, 0x0, 0x7c, 0x0, 0x38, 0x0,
    0x1f, 0xc0, 0x18, 0x0, 0x7, 0xf8, 0x1f, 0x0,
    0x1f, 0xf8, 0x1f, 0xff, 0xff, 0x3c, 0x33, 0xff,
    0xff, 0x8e, 0x21, 0xe0, 0x3, 0xc1, 0x20, 0xf0,
    0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0x3f,
    0xff, 0xf8, 0x0, 0x1f, 0xff, 0xfc, 0x0, 0xf,
    0x0, 0x1e, 0x0, 0x0, 0xc0, 0xc, 0x0, 0x0,
    0x78, 0x6, 0x0, 0x0, 0x1e, 0x6, 0x0, 0x0,
    0xe, 0x6, 0x0, 0x0, 0x3, 0x3, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe0, 0x1e, 0x0, 0x0, 0x7f, 0xff, 0x0,
    0x0, 0x3f, 0xff, 0x80, 0x0, 0x3c, 0x3, 0xc0,
    0x0, 0x1e, 0x1, 0xe0, 0x20, 0xf, 0x0, 0xf0,
    0x10, 0x7, 0x80, 0x78, 0x8, 0x3, 0x80, 0x3c,
    0x4, 0x3, 0xc0, 0x1e, 0x6, 0x1, 0xc0, 0xf,
    0x3, 0x1, 0xc0, 0x7, 0x81, 0x80, 0xc0, 0x3,
    0xff, 0xc0, 0x80, 0x1, 0xff, 0xe1, 0x80, 0x0,
    0xff, 0xf1, 0x0, 0x0, 0x3f, 0xf0,

    /* U+51F5 "凵" */
    0xf0, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x7, 0xf8, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x7f,
    0x80, 0x0, 0xf, 0xf0, 0x0, 0x1, 0xfe, 0x0,
    0x0, 0x3f, 0xc0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0x7f, 0x80, 0x0, 0xf, 0xf0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0x7,
    0xf8, 0x0, 0x0, 0xff, 0x0, 0x0, 0x1f, 0xe0,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0xf, 0xf0, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x3f,
    0xc0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x3, 0xfc, 0x0, 0x0,
    0x7f, 0x80, 0x0, 0xf, 0xf0, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0xf0,

    /* U+51F6 "凶" */
    0x0, 0x0, 0x78, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x78, 0x0, 0x20, 0x7, 0x80, 0xf2, 0x0,
    0x78, 0xff, 0x20, 0x7, 0x8f, 0xf1, 0x0, 0x78,
    0xff, 0x10, 0x7, 0x8f, 0xf0, 0x80, 0x70, 0xff,
    0x8, 0x7, 0xf, 0xf0, 0xc0, 0xf0, 0xff, 0x4,
    0xf, 0xf, 0xf0, 0x60, 0xf0, 0xff, 0x6, 0xe,
    0xf, 0xf0, 0x30, 0xe0, 0xff, 0x3, 0xe, 0xf,
    0xf0, 0x18, 0xe0, 0xff, 0x1, 0x9c, 0xf, 0xf0,
    0x1d, 0xc0, 0xff, 0x0, 0xdc, 0xf, 0xf0, 0xf,
    0x80, 0xff, 0x0, 0xf8, 0xf, 0xf0, 0x7, 0x80,
    0xff, 0x0, 0x78, 0xf, 0xf0, 0x7, 0x80, 0xff,
    0x0, 0xfc, 0xf, 0xf0, 0xf, 0xc0, 0xff, 0x1,
    0x9e, 0xf, 0xf0, 0x19, 0xe0, 0xff, 0x3, 0xf,
    0xf, 0xf0, 0x60, 0xf8, 0xff, 0x6, 0x7, 0x8f,
    0xf0, 0xc0, 0x7c, 0xff, 0x18, 0x3, 0x8f, 0xf3,
    0x80, 0x38, 0xff, 0x30, 0x1, 0xf, 0xf6, 0x0,
    0x10, 0xff, 0xc0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf0,

    /* U+51F8 "凸" */
    0x1, 0xe0, 0xf0, 0x0, 0x1e, 0xf, 0x0, 0x1,
    0xff, 0xf0, 0x0, 0x1f, 0xff, 0x0, 0x1, 0xe0,
    0xf0, 0x0, 0x1e, 0xf, 0x0, 0x1, 0xe0, 0xf0,
    0x0, 0x1e, 0xf, 0x0, 0x1, 0xe0, 0xf0, 0x0,
    0x1e, 0xf, 0x0, 0x1, 0xe0, 0xf0, 0x0, 0x1e,
    0xf, 0x0, 0x1, 0xe0, 0xf0, 0x0, 0x1e, 0xf,
    0x0, 0x1, 0xe0, 0xf0, 0xf, 0x1e, 0xf, 0xf,
    0xf1, 0xe0, 0xf0, 0xff, 0xfe, 0xf, 0xff, 0xff,
    0xe0, 0xff, 0xff, 0x1e, 0xf, 0xf, 0xf1, 0xe0,
    0xf0, 0xff, 0x1e, 0xf, 0xf, 0xf1, 0xe0, 0xf0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xf,

    /* U+51F9 "凹" */
    0xf0, 0xf0, 0xf1, 0xfe, 0x1e, 0x1e, 0x3f, 0xff,
    0xc3, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xf, 0xf,
    0x1f, 0xe1, 0xe1, 0xe3, 0xfc, 0x3c, 0x3c, 0x7f,
    0x87, 0x87, 0x8f, 0xf0, 0xf0, 0xf1, 0xfe, 0x1e,
    0x1e, 0x3f, 0xc3, 0xc3, 0xc7, 0xf8, 0x78, 0x78,
    0xff, 0xf, 0xf, 0x1f, 0xe1, 0xe1, 0xe3, 0xfc,
    0x3c, 0x3c, 0x7f, 0x87, 0x87, 0x8f, 0xf0, 0xf0,
    0xf1, 0xfe, 0x1e, 0x1e, 0x3f, 0xc3, 0xc3, 0xc7,
    0xf8, 0x78, 0x78, 0xff, 0xf, 0xf, 0x1f, 0xe1,
    0xe1, 0xe3, 0xfc, 0x3c, 0x3c, 0x7f, 0x87, 0xff,
    0x8f, 0xf0, 0xff, 0xf1, 0xfe, 0x1e, 0x1e, 0x3f,
    0xc3, 0xc3, 0xc7, 0xf8, 0x78, 0x78, 0xff, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x3, 0xfc, 0x0, 0x0,
    0x7f, 0x80, 0x0, 0xf, 0xf0, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x3,
    0xfc, 0x0, 0x0, 0x7f, 0x80, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x7, 0xf8, 0x0, 0x0, 0xff, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x3, 0xc0,

    /* U+51FA "出" */
    0x0, 0xf, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0xf0,
    0x0, 0xf0, 0x1e, 0x3, 0xde, 0x3, 0xc0, 0x7b,
    0xc0, 0x78, 0xf, 0x78, 0xf, 0x1, 0xef, 0x1,
    0xe0, 0x3d, 0xe0, 0x3c, 0x7, 0xbc, 0x7, 0x80,
    0xf7, 0x80, 0xf0, 0x1e, 0xf0, 0x1e, 0x3, 0xde,
    0x3, 0xc0, 0x7b, 0xc0, 0x78, 0xf, 0x78, 0xf,
    0x1, 0xef, 0x1, 0xe0, 0x3d, 0xff, 0xff, 0xff,
    0xbf, 0xff, 0xff, 0xf7, 0x80, 0xf0, 0x1e, 0xf0,
    0x1e, 0x3, 0xc0, 0x3, 0xc0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x1, 0xe0, 0x3f,
    0xc0, 0x3c, 0x7, 0xf8, 0x7, 0x80, 0xff, 0x0,
    0xf0, 0x1f, 0xe0, 0x1e, 0x3, 0xfc, 0x3, 0xc0,
    0x7f, 0x80, 0x78, 0xf, 0xf0, 0xf, 0x1, 0xfe,
    0x1, 0xe0, 0x3f, 0xc0, 0x3c, 0x7, 0xf8, 0x7,
    0x80, 0xff, 0x0, 0xf0, 0x1f, 0xe0, 0x1e, 0x3,
    0xfc, 0x3, 0xc0, 0x7f, 0x80, 0x78, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0,
    0x7, 0xf8, 0x0, 0x0, 0xff, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x3, 0xc0,

    /* U+51FB "击" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x1f, 0xff, 0xff, 0xfc,
    0x1f, 0xff, 0xff, 0xfc, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xe, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xe, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xe, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xe, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xe, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xe, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xe, 0x3, 0xc0, 0xf0, 0xe, 0x3, 0xc0, 0xf0,
    0xf, 0xff, 0xff, 0xf0, 0xf, 0xff, 0xff, 0xf0,
    0xe, 0x0, 0x0, 0xf0, 0xe, 0x0, 0x0, 0xf0,
    0xe, 0x0, 0x0, 0xf0, 0xe, 0x0, 0x0, 0xf0,

    /* U+51FC "凼" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x78, 0x0, 0x0, 0x7,
    0x80, 0xf, 0x0, 0x78, 0xf, 0xf0, 0x7, 0x80,
    0xff, 0xf, 0x78, 0x3f, 0xf0, 0xf7, 0x82, 0xff,
    0xf, 0x78, 0x2f, 0xf0, 0xf7, 0x86, 0xff, 0x7f,
    0x78, 0x4f, 0xf7, 0xf7, 0xcc, 0xff, 0xf, 0x7c,
    0x8f, 0xf0, 0xf7, 0xd8, 0xff, 0xf, 0x7d, 0x8f,
    0xf0, 0xf7, 0xf0, 0xff, 0xf, 0x7f, 0xf, 0xf0,
    0xf7, 0xa0, 0xff, 0xf, 0x7a, 0xf, 0xf0, 0xf7,
    0xb0, 0xff, 0xe, 0x7b, 0xf, 0xf0, 0xe7, 0xb0,
    0xff, 0xe, 0x79, 0x8f, 0xf0, 0xe7, 0x98, 0xff,
    0xc, 0x79, 0xcf, 0xf1, 0xc7, 0x9c, 0xff, 0x18,
    0x78, 0xef, 0xf1, 0x87, 0x8f, 0xff, 0x30, 0x78,
    0x7f, 0xf3, 0x7, 0x87, 0xff, 0x60, 0x78, 0x6f,
    0xf4, 0x7, 0x82, 0xff, 0x80, 0x78, 0x2f, 0xf0,
    0x7, 0x80, 0xff, 0x0, 0x78, 0xf, 0xf0, 0xf,
    0x0, 0xff, 0x3, 0xe0, 0xf, 0xf0, 0xc0, 0x0,
    0xff, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xf,

    /* U+51FD "函" */
    0x0, 0x0, 0x0, 0x33, 0xff, 0xff, 0xff, 0x9f,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x3c, 0x0, 0x3c, 0x3, 0xc0, 0x1f,
    0xe0, 0x3e, 0x0, 0xff, 0x0, 0xf0, 0x7, 0xf9,
    0x7, 0x82, 0x3f, 0xcc, 0x3c, 0x19, 0xfe, 0x61,
    0xe1, 0xcf, 0xf1, 0x8f, 0xc, 0x7f, 0x8e, 0x78,
    0xe3, 0xfc, 0x73, 0xe6, 0x1f, 0xe3, 0xdf, 0x60,
    0xff, 0xc, 0xfb, 0x7, 0xf8, 0x67, 0xf0, 0x3f,
    0xc3, 0x7d, 0x81, 0xfe, 0x3, 0xec, 0xf, 0xf0,
    0x3f, 0x70, 0x7f, 0x81, 0x7b, 0x83, 0xfc, 0x1b,
    0xce, 0x1f, 0xe3, 0x9e, 0x78, 0xff, 0x7c, 0xf3,
    0xf7, 0xfb, 0xc7, 0x8f, 0xff, 0xce, 0x3c, 0x79,
    0xfe, 0x61, 0xe1, 0xcf, 0xf2, 0xf, 0xc, 0x7f,
    0xa0, 0x78, 0x23, 0xfc, 0x3, 0xc0, 0x1f, 0xe0,
    0x1e, 0x0, 0xff, 0x1, 0xe0, 0x7, 0xf8, 0x1e,
    0x0, 0x3f, 0xc1, 0xe0, 0x1, 0xfe, 0x10, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x3c,

    /* U+51FF "凿" */
    0x0, 0x1e, 0x1c, 0x0, 0x0, 0xf, 0xe, 0x0,
    0x0, 0x7, 0x87, 0x2, 0x1, 0x3, 0xc3, 0x83,
    0x80, 0xc1, 0xe1, 0xc1, 0x80, 0x30, 0xf0, 0xe0,
    0xc0, 0x1c, 0x78, 0x70, 0xc0, 0x7, 0x3c, 0x38,
    0x60, 0x3, 0x9e, 0x1c, 0x60, 0x0, 0xcf, 0xe,
    0x30, 0x0, 0x67, 0x87, 0x30, 0x0, 0x3, 0xc3,
    0x98, 0x0, 0x1, 0xe1, 0xd8, 0x7, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x0,
    0x8, 0x0, 0x0, 0x10, 0x6, 0x0, 0x0, 0xc,
    0x3, 0x0, 0x0, 0x7, 0x83, 0x0, 0x0, 0x1,
    0xe1, 0x80, 0x1, 0xe0, 0xe1, 0x83, 0xc0, 0xf0,
    0x30, 0xc1, 0xe0, 0x78, 0x10, 0xe0, 0xf0, 0x3c,
    0xff, 0xfe, 0x78, 0x1e, 0x7f, 0xff, 0x3c, 0xf,
    0x0, 0xf0, 0x1e, 0x7, 0x80, 0x78, 0xf, 0x3,
    0xc0, 0x3c, 0x7, 0x81, 0xe0, 0x1e, 0x3, 0xc0,
    0xf0, 0xf, 0x1, 0xe0, 0x7b, 0xff, 0xfe, 0xf0,
    0x3d, 0xff, 0xff, 0x78, 0x1e, 0x1, 0xe0, 0x3c,
    0xf, 0x0, 0xf0, 0x1e, 0x7, 0x80, 0x78, 0xf,
    0x3, 0xc0, 0x3c, 0x7, 0x81, 0xe0, 0x1e, 0x3,
    0xc0, 0xf0, 0xf, 0x1, 0xe0, 0x78, 0x7, 0x80,
    0xf0, 0x3c, 0x3, 0xc0, 0x78, 0x1e, 0x1, 0xe0,
    0x3c, 0xf, 0xff, 0xff, 0xfe, 0x7, 0xff, 0xff,
    0xff, 0x3, 0xc0, 0x0, 0x7, 0x81, 0xe0, 0x0,
    0x3, 0xc0, 0xf0, 0x0, 0x1, 0xe0,

    /* U+5200 "刀" */
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x3, 0xcf,
    0xff, 0xff, 0xfe, 0x7f, 0xff, 0xff, 0xf0, 0x7,
    0x80, 0x7, 0x80, 0x3c, 0x0, 0x3c, 0x1, 0xe0,
    0x1, 0xe0, 0xf, 0x0, 0xf, 0x0, 0x78, 0x0,
    0x78, 0x3, 0xc0, 0x3, 0xc0, 0x1e, 0x0, 0x1e,
    0x0, 0xf0, 0x0, 0xf0, 0x7, 0x80, 0x7, 0x80,
    0x3c, 0x0, 0x3c, 0x1, 0xe0, 0x1, 0xe0, 0xf,
    0x0, 0xf, 0x0, 0x78, 0x0, 0x78, 0x3, 0xc0,
    0x3, 0xc0, 0x1e, 0x0, 0x1e, 0x0, 0xf0, 0x0,
    0xf0, 0x7, 0x80, 0x7, 0x80, 0x3c, 0x0, 0x3c,
    0x1, 0xe0, 0x1, 0xe0, 0xf, 0x0, 0xf, 0x0,
    0x78, 0x0, 0x78, 0x3, 0xc0, 0x3, 0xc0, 0x1e,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0xf0, 0x7, 0x80,
    0x7, 0x80, 0x38, 0x0, 0x3c, 0x3, 0xc0, 0x1,
    0xe0, 0x1e, 0x0, 0xf, 0x0, 0xe0, 0x0, 0x78,
    0x7, 0x0, 0x3, 0xc0, 0x70, 0x0, 0x1e, 0x3,
    0x0, 0x0, 0xf0, 0x38, 0x0, 0x7, 0x83, 0x80,
    0x0, 0x3c, 0x18, 0x0, 0x3, 0xc1, 0x80, 0x0,
    0x3e, 0x18, 0x0, 0x3, 0xc1, 0x80, 0x0, 0x7c,
    0x10, 0x0, 0x1d, 0x81, 0x0, 0x0, 0x0, 0x0,

    /* U+5201 "刁" */
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3d, 0xff,
    0xff, 0xff, 0xbf, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x81, 0xe0, 0x0,
    0x10, 0x3c, 0x0, 0x2, 0x7, 0x80, 0x0, 0x40,
    0xf0, 0x0, 0x10, 0x1e, 0x0, 0x2, 0x3, 0xc0,
    0x0, 0x40, 0x78, 0x0, 0x8, 0xf, 0x0, 0x3,
    0x1, 0xe0, 0x0, 0x40, 0x3c, 0x0, 0x18, 0x7,
    0x80, 0x3, 0x0, 0xf0, 0x0, 0x60, 0x1e, 0x0,
    0x18, 0x3, 0xc0, 0x3, 0x0, 0x78, 0x0, 0xe0,
    0xf, 0x0, 0x38, 0x1, 0xe0, 0x7, 0x0, 0x3c,
    0x1, 0xc0, 0x7, 0x80, 0x78, 0x0, 0xf0, 0xe,
    0x0, 0x1e, 0x3, 0xc0, 0x3, 0xc0, 0xf0, 0x0,
    0x78, 0x7c, 0x0, 0xf, 0x1f, 0x80, 0x1, 0xe7,
    0xe0, 0x0, 0x3f, 0xf8, 0x0, 0x7, 0xbe, 0x0,
    0x0, 0xf7, 0x80, 0x0, 0x1e, 0xe0, 0x0, 0x3,
    0xc8, 0x0, 0x0, 0x78, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x1f, 0x80, 0x0, 0xc, 0x80,

    /* U+5202 "刂" */
    0x3, 0xc0, 0xf0, 0x3c, 0xf, 0x3, 0xfc, 0xff,
    0x3f, 0xcf, 0xf3, 0xfc, 0xff, 0x3f, 0xcf, 0xf3,
    0xfc, 0xff, 0x3f, 0xcf, 0xf3, 0xfc, 0xff, 0x3f,
    0xcf, 0xf3, 0xfc, 0xff, 0x3f, 0xcf, 0xf3, 0xfc,
    0xff, 0x3f, 0xcf, 0xf3, 0xfc, 0xff, 0x3f, 0xcf,
    0xf3, 0xfc, 0xff, 0x3f, 0xcf, 0x3, 0xc0, 0xf0,
    0x3c, 0xf, 0x3, 0xc0, 0xf0, 0x78, 0x3c, 0x3e,
    0x32, 0x0,

    /* U+5203 "刃" */
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x7, 0xbf,
    0xff, 0xff, 0xfd, 0xff, 0xff, 0xff, 0xe0, 0x0,
    0xf0, 0xf, 0x0, 0x7, 0x80, 0x78, 0x0, 0x3c,
    0x3, 0xc0, 0x1, 0xe0, 0x1e, 0x0, 0xf, 0x0,
    0xf0, 0x0, 0x78, 0x7, 0x80, 0x3, 0xc0, 0x3c,
    0x0, 0x1e, 0x1, 0xe0, 0xf0, 0xf0, 0xf, 0x7,
    0x87, 0x80, 0x78, 0x3c, 0x3c, 0x3, 0xc1, 0xe1,
    0xe0, 0x1e, 0xf, 0xf, 0x0, 0xf0, 0x78, 0x78,
    0x7, 0x83, 0x83, 0xc0, 0x3c, 0x1c, 0x1e, 0x1,
    0xe0, 0xe0, 0xf0, 0xf, 0xf, 0x7, 0x80, 0x78,
    0x70, 0x3c, 0x3, 0xc3, 0x81, 0xe0, 0x1e, 0x1c,
    0xf, 0x0, 0xf0, 0xc0, 0x78, 0x7, 0x8e, 0x3,
    0x80, 0x3c, 0x70, 0x3c, 0x1, 0xe3, 0x1, 0xe0,
    0xf, 0x10, 0xe, 0x0, 0x79, 0x80, 0xf0, 0x3,
    0xc8, 0x7, 0x0, 0x1e, 0xc0, 0x38, 0x0, 0xf0,
    0x3, 0x80, 0x7, 0x80, 0x1c, 0x0, 0x3c, 0x1,
    0xc0, 0x1, 0xe0, 0xc, 0x0, 0xf, 0x0, 0xc0,
    0x0, 0x78, 0xe, 0x0, 0x3, 0xc0, 0x60, 0x0,
    0x1e, 0x6, 0x0, 0x0, 0xf0, 0x60, 0x0, 0xf,
    0x82, 0x0, 0x0, 0xf8, 0x20, 0x0, 0x3f, 0x83,
    0x0, 0xf, 0xf0, 0x30, 0x0, 0x4, 0x0,

    /* U+5206 "分" */
    0x0, 0x7c, 0x0, 0x0, 0x0, 0x3e, 0x4, 0x0,
    0x0, 0x1f, 0x2, 0x0, 0x0, 0x1f, 0x0, 0x80,
    0x0, 0xf, 0x80, 0x40, 0x0, 0x7, 0x80, 0x30,
    0x0, 0x3, 0xc0, 0x18, 0x0, 0x1, 0xe0, 0xe,
    0x0, 0x1, 0xe0, 0x3, 0x80, 0x0, 0xf0, 0x1,
    0xc0, 0x0, 0x70, 0x0, 0xf0, 0x0, 0x70, 0x0,
    0x3c, 0x0, 0x38, 0x0, 0x1f, 0x0, 0x38, 0x0,
    0xf, 0xe0, 0x1c, 0x0, 0x3, 0xf8, 0x1c, 0x0,
    0x1, 0xff, 0xc, 0x0, 0x0, 0x7f, 0xc, 0x0,
    0x1, 0xff, 0x84, 0x0, 0x0, 0xf7, 0xc6, 0xff,
    0xff, 0xf9, 0xe6, 0x7f, 0xff, 0xfc, 0x72, 0x3,
    0xc0, 0x1e, 0x18, 0x1, 0xe0, 0xf, 0x4, 0x0,
    0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0, 0x0,
    0x3c, 0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x78, 0x0, 0x7, 0x80, 0x3c, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x38, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0x78, 0x0, 0xe, 0x0, 0x3c,
    0x0, 0x6, 0x0, 0x1e, 0x0, 0x7, 0x0, 0xf,
    0x0, 0x3, 0x0, 0x7, 0x80, 0x3, 0x0, 0x3,
    0xc0, 0x3, 0x0, 0x1, 0xe0, 0x1, 0x0, 0x1,
    0xe0, 0x1, 0x0, 0x3, 0xe0, 0x1, 0x0, 0x3,
    0xe0, 0x1, 0x0, 0x6, 0xc0, 0x0,

    /* U+5207 "切" */
    0x7, 0x0, 0x0, 0x3c, 0xe, 0x0, 0x0, 0x78,
    0x1c, 0x1f, 0xff, 0xf0, 0x38, 0x3f, 0xff, 0xe0,
    0x70, 0x7, 0x83, 0xc0, 0xe0, 0xf, 0x7, 0x81,
    0xc0, 0x1e, 0xf, 0x3, 0x80, 0x3c, 0x1e, 0x7,
    0x0, 0x78, 0x3c, 0xe, 0x0, 0xf0, 0x78, 0x1c,
    0x1, 0xe0, 0xf0, 0x38, 0x3, 0xc1, 0xe0, 0x70,
    0x7, 0x83, 0xdf, 0xff, 0x8f, 0x7, 0xbf, 0xff,
    0x1e, 0xf, 0x3, 0x80, 0x3c, 0x1e, 0x7, 0x0,
    0x78, 0x3c, 0xe, 0x0, 0xf0, 0x78, 0x1c, 0x1,
    0xe0, 0xf0, 0x38, 0x3, 0xc1, 0xe0, 0x70, 0x7,
    0x83, 0xc0, 0xe0, 0xf, 0x7, 0x81, 0xc0, 0x1e,
    0xf, 0x3, 0x80, 0x3c, 0x1e, 0x7, 0x0, 0x78,
    0x3c, 0xe, 0x0, 0xf0, 0x78, 0x1c, 0x1, 0xe0,
    0xf0, 0x38, 0x3, 0xc1, 0xe0, 0x70, 0x27, 0x83,
    0xc0, 0xe0, 0x4e, 0x7, 0x81, 0xc1, 0x3c, 0xf,
    0x3, 0x86, 0x78, 0x1e, 0x7, 0x1c, 0xf0, 0x3c,
    0xe, 0x71, 0xc0, 0x78, 0x1f, 0xc7, 0x80, 0xf0,
    0x3f, 0x8e, 0x1, 0xe1, 0xfe, 0x1c, 0x3, 0xc7,
    0xf8, 0x70, 0x7, 0x8f, 0xe0, 0xc0, 0xf, 0xf,
    0x3, 0x80, 0x1e, 0x1c, 0xe, 0x0, 0x7c, 0x0,
    0x18, 0x1, 0xf0, 0x0, 0x60, 0x7, 0xc0, 0x1,
    0xc0, 0x3f, 0x0, 0x3, 0x1, 0x88, 0x0, 0xc,
    0x0, 0x0, 0x0,

    /* U+5208 "刈" */
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x78, 0x0, 0xf0,
    0x0, 0xf0, 0x1, 0xe8, 0x1, 0xe0, 0x3, 0xd0,
    0x3, 0xc3, 0xc7, 0x90, 0x7, 0x87, 0x8f, 0x20,
    0xf, 0xf, 0x1e, 0x20, 0x1e, 0x1e, 0x3c, 0x60,
    0x3c, 0x3c, 0x78, 0xc0, 0x78, 0x78, 0xf0, 0xc0,
    0xf0, 0xf1, 0xe1, 0x81, 0xe1, 0xe3, 0xc3, 0x83,
    0xc3, 0xc7, 0x83, 0x7, 0x87, 0x8f, 0x7, 0xf,
    0xf, 0x1e, 0xf, 0x3c, 0x1e, 0x3c, 0xe, 0x78,
    0x3c, 0x78, 0x1e, 0xf0, 0x78, 0xf0, 0x1d, 0xe0,
    0xf1, 0xe0, 0x3f, 0x81, 0xe3, 0xc0, 0x3f, 0x3,
    0xc7, 0x80, 0x7e, 0x7, 0x8f, 0x0, 0xf8, 0xf,
    0x1e, 0x0, 0xf0, 0x1e, 0x3c, 0x1, 0xe0, 0x3c,
    0x78, 0x3, 0xe0, 0x78, 0xf0, 0xf, 0xc0, 0xf1,
    0xe0, 0x1f, 0xc1, 0xe3, 0xc0, 0x77, 0x83, 0xc7,
    0x80, 0xef, 0x87, 0x8f, 0x3, 0x8f, 0xf, 0x1e,
    0x7, 0x1f, 0x1e, 0x3c, 0x1c, 0x1e, 0x3c, 0x78,
    0x38, 0x3e, 0x0, 0xf0, 0x60, 0x3c, 0x1, 0xe1,
    0xc0, 0x78, 0x3, 0xc7, 0x0, 0x70, 0x7, 0x8c,
    0x0, 0xc0, 0xf, 0x38, 0x0, 0x80, 0x1e, 0x60,
    0x0, 0x0, 0x3d, 0x80, 0x0, 0x0, 0xf3, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x1, 0x9c, 0x0,

    /* U+520A "刊" */
    0x0, 0x0, 0x0, 0x1e, 0x7f, 0xfe, 0x0, 0x3c,
    0xff, 0xfc, 0x0, 0x78, 0xf, 0x0, 0x0, 0xf0,
    0x1e, 0x0, 0x1, 0xe0, 0x3c, 0x0, 0x3, 0xc0,
    0x78, 0x7, 0x87, 0x80, 0xf0, 0xf, 0xf, 0x1,
    0xe0, 0x1e, 0x1e, 0x3, 0xc0, 0x3c, 0x3c, 0x7,
    0x80, 0x78, 0x78, 0xf, 0x0, 0xf0, 0xf0, 0x1e,
    0x1, 0xe1, 0xe0, 0x3c, 0x3, 0xc3, 0xc0, 0x78,
    0x7, 0x87, 0x80, 0xf0, 0xf, 0xf, 0x1, 0xe0,
    0x1e, 0x1f, 0xff, 0xff, 0x3c, 0x3f, 0xff, 0xfe,
    0x78, 0x78, 0xf, 0x0, 0xf0, 0xf0, 0x1e, 0x1,
    0xe1, 0xe0, 0x3c, 0x3, 0xc3, 0xc0, 0x78, 0x7,
    0x87, 0x80, 0xf0, 0xf, 0xf, 0x1, 0xe0, 0x1e,
    0x1e, 0x3, 0xc0, 0x3c, 0x3c, 0x7, 0x80, 0x78,
    0x78, 0xf, 0x0, 0xf0, 0xf0, 0x1e, 0x1, 0xe1,
    0xe0, 0x3c, 0x3, 0xc3, 0xc0, 0x78, 0x7, 0x87,
    0x80, 0xf0, 0xf, 0xf, 0x1, 0xe0, 0x1e, 0x1e,
    0x3, 0xc0, 0x3c, 0x3c, 0x7, 0x80, 0x0, 0x78,
    0xf, 0x0, 0x0, 0xf0, 0x1e, 0x0, 0x1, 0xe0,
    0x3c, 0x0, 0x3, 0xc0, 0x78, 0x0, 0x7, 0x80,
    0xf0, 0x0, 0xf, 0x1, 0xe0, 0x0, 0x1e, 0x3,
    0xc0, 0x0, 0x7c, 0x7, 0x80, 0x0, 0xf0, 0xf,
    0x0, 0x3, 0xe0, 0x1e, 0x0, 0x1f, 0x80, 0x3c,
    0x0, 0xfc, 0x0, 0x0, 0x2, 0x0, 0x0,

    /* U+520D "刍" */
    0x3, 0xf0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x3e, 0x0, 0x7c, 0x3, 0xe0,
    0x7, 0xc0, 0x3e, 0x0, 0x7c, 0x3, 0xff, 0xff,
    0xc0, 0x3f, 0xff, 0xfc, 0x7, 0xc0, 0x7, 0xc0,
    0x78, 0x0, 0x78, 0x7, 0x80, 0xf, 0x80, 0x70,
    0x0, 0xf0, 0xe, 0x0, 0xe, 0x0, 0xc0, 0x1,
    0xc0, 0x1c, 0x0, 0x18, 0x1, 0x80, 0x3, 0x0,
    0x30, 0x0, 0x60, 0xf2, 0x0, 0xc, 0xf, 0x5f,
    0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf, 0x1f, 0xff, 0xff, 0xf1, 0xff, 0xff,
    0xff, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x3f, 0xff, 0xff, 0xf3,
    0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xf,

    /* U+520E "刎" */
    0xf, 0x0, 0x0, 0x1e, 0x1e, 0x0, 0x0, 0x3c,
    0x3c, 0x0, 0x0, 0x78, 0x78, 0x0, 0x0, 0xf0,
    0xe0, 0x0, 0x1, 0xe1, 0xc0, 0x3c, 0x3, 0xc3,
    0x80, 0x78, 0x7, 0x87, 0xff, 0xf3, 0xcf, 0x1f,
    0xff, 0xe7, 0x9e, 0x38, 0x3, 0xcf, 0x3c, 0x70,
    0x7, 0x9e, 0x78, 0xf1, 0xcf, 0x3c, 0xf3, 0xe3,
    0x9e, 0x79, 0xe7, 0xc7, 0x3c, 0xf3, 0xcf, 0x8e,
    0x79, 0xe7, 0xb7, 0x1c, 0xf3, 0xcf, 0x4e, 0x39,
    0xe7, 0x9f, 0x1c, 0x73, 0xcf, 0x3c, 0x38, 0xe7,
    0x9e, 0x78, 0x71, 0xcf, 0x3c, 0xf0, 0xe3, 0x9e,
    0x79, 0xe1, 0xc7, 0x3c, 0xf3, 0xc3, 0x8e, 0x79,
    0xe7, 0x87, 0x1c, 0xf3, 0xcf, 0xe, 0x39, 0xe7,
    0x9e, 0x1c, 0x73, 0xcf, 0x3c, 0x38, 0xc7, 0x9e,
    0x78, 0x61, 0x8f, 0x3c, 0xf0, 0xc7, 0x1e, 0x79,
    0xe3, 0x8e, 0x3c, 0xf3, 0xc7, 0x18, 0x79, 0xe7,
    0x8c, 0x30, 0xf3, 0xcf, 0x18, 0xe1, 0xe7, 0x9e,
    0x31, 0x83, 0xcf, 0x3c, 0xe3, 0x7, 0x9e, 0x79,
    0x8c, 0xf, 0x3c, 0xf3, 0x18, 0x1e, 0x1, 0xec,
    0x20, 0x3c, 0x3, 0xd8, 0xc0, 0x78, 0x7, 0xa1,
    0x0, 0xf0, 0xf, 0xc6, 0x3, 0xe0, 0x1e, 0x18,
    0x7, 0x80, 0x3c, 0x20, 0x1e, 0x0, 0xf8, 0x80,
    0xf8, 0x3, 0xe0, 0x3, 0x60, 0xf, 0xc0, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x1, 0x0, 0x0,

    /* U+5211 "刑" */
    0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x73,
    0xff, 0xff, 0x1, 0xcf, 0xff, 0xfc, 0x7, 0x3,
    0x87, 0x0, 0x1c, 0xe, 0x1c, 0x0, 0x70, 0x38,
    0x70, 0x71, 0xc0, 0xe1, 0xc1, 0xc7, 0x3, 0x87,
    0x7, 0x1c, 0xe, 0x1c, 0x1c, 0x70, 0x38, 0x70,
    0x71, 0xc0, 0xe1, 0xc1, 0xc7, 0x3, 0x87, 0x7,
    0x1c, 0xe, 0x1c, 0x1c, 0x70, 0x38, 0x70, 0x71,
    0xc0, 0xe1, 0xc1, 0xc7, 0x3, 0x87, 0x7, 0x1f,
    0xff, 0xff, 0x9c, 0x7f, 0xff, 0xfe, 0x71, 0xc0,
    0xe1, 0xc1, 0xc7, 0x7, 0x87, 0x7, 0x1c, 0x1e,
    0x1c, 0x1c, 0x70, 0x78, 0x70, 0x71, 0xc1, 0xe1,
    0xc1, 0xc7, 0x7, 0x87, 0x7, 0x1c, 0x1e, 0x1c,
    0x1c, 0x70, 0x78, 0x70, 0x71, 0xc1, 0xe1, 0xc1,
    0xc7, 0x7, 0x87, 0x7, 0x1c, 0x3c, 0x1c, 0x1c,
    0x70, 0xf0, 0x70, 0x71, 0xc3, 0xc1, 0xc1, 0xc7,
    0xf, 0x7, 0x7, 0x1c, 0x3c, 0x1c, 0x0, 0x70,
    0xe0, 0x70, 0x1, 0xc3, 0x81, 0xc0, 0x7, 0x1e,
    0x7, 0x0, 0x1c, 0x70, 0x1c, 0x0, 0x71, 0x80,
    0x70, 0x1, 0xc6, 0x1, 0xc0, 0x7, 0x30, 0x7,
    0x0, 0x1c, 0xc0, 0x1c, 0x0, 0x72, 0x0, 0x70,
    0x3, 0x90, 0x1, 0xc0, 0x3e, 0x40, 0x7, 0x3,
    0xf2, 0x0, 0x1c, 0x38, 0x80,

    /* U+5212 "划" */
    0x3, 0xc0, 0x0, 0xf, 0x3, 0xc0, 0x0, 0xf,
    0x3, 0xc8, 0x0, 0xf, 0x3, 0xcc, 0x0, 0xf,
    0x3, 0xcc, 0x0, 0xf, 0x3, 0xc6, 0x7, 0x8f,
    0x3, 0xc7, 0x7, 0x8f, 0x3, 0xc7, 0x7, 0x8f,
    0x3, 0xc2, 0x7, 0x8f, 0x3, 0xc2, 0x7, 0x8f,
    0x3, 0xc0, 0x7, 0x8f, 0x3, 0xc7, 0xc7, 0x8f,
    0x3f, 0xff, 0xc7, 0x8f, 0x7f, 0xff, 0x7, 0x8f,
    0x7b, 0xc0, 0x7, 0x8f, 0x3, 0xc0, 0x7, 0x8f,
    0x3, 0xc0, 0x7, 0x8f, 0x3, 0xc7, 0x87, 0x8f,
    0x3, 0xc7, 0x87, 0x8f, 0x3, 0xc7, 0x87, 0x8f,
    0x3, 0xc7, 0x87, 0x8f, 0x3, 0xc7, 0x87, 0x8f,
    0x3, 0xc7, 0x87, 0x8f, 0x3, 0xc7, 0x87, 0x8f,
    0x3, 0xc7, 0x7, 0x8f, 0x3, 0xcf, 0x7, 0x8f,
    0x3, 0xcf, 0x7, 0x8f, 0x3, 0xcf, 0x7, 0x8f,
    0x3, 0xce, 0x7, 0x8f, 0x3, 0xde, 0x7, 0x8f,
    0x1, 0xfe, 0x7, 0x8f, 0x1, 0xfc, 0x7, 0x8f,
    0x1, 0xfc, 0x87, 0x8f, 0x1, 0xf8, 0x87, 0x8f,
    0x0, 0xf0, 0x87, 0x8f, 0x0, 0xf0, 0x87, 0x8f,
    0x1, 0xf8, 0x87, 0x8f, 0x1, 0xf8, 0x80, 0xf,
    0x3, 0x3c, 0x80, 0xf, 0x6, 0x3e, 0x80, 0xf,
    0xc, 0x1f, 0x80, 0xf, 0x18, 0xf, 0xc0, 0xf,
    0x30, 0x7, 0xc0, 0x1e, 0x60, 0x3, 0xc0, 0x3e,
    0x0, 0x1, 0xc0, 0x78, 0x0, 0x0, 0x41, 0xf0,
    0x0, 0x0, 0x6, 0x0,

    /* U+5216 "刖" */
    0x1c, 0x7, 0x0, 0x1c, 0x70, 0x1c, 0x0, 0x71,
    0xc0, 0x70, 0x1, 0xc7, 0xff, 0xc0, 0x7, 0x1f,
    0xff, 0x0, 0x1c, 0x70, 0x1c, 0x0, 0x71, 0xc0,
    0x70, 0xe1, 0xc7, 0x1, 0xc3, 0x87, 0x1c, 0x7,
    0xe, 0x1c, 0x70, 0x1c, 0x38, 0x71, 0xc0, 0x70,
    0xe1, 0xc7, 0x1, 0xc3, 0x87, 0x1c, 0x7, 0xe,
    0x1c, 0x70, 0x1c, 0x38, 0x71, 0xfe, 0x70, 0xe1,
    0xc7, 0xf9, 0xc3, 0x87, 0x1c, 0x7, 0xe, 0x1c,
    0x70, 0x1c, 0x38, 0x71, 0xc0, 0x70, 0xe1, 0xc7,
    0x1, 0xc3, 0x87, 0x1c, 0x7, 0xe, 0x1c, 0x70,
    0x1c, 0x38, 0x71, 0xc0, 0x70, 0xe1, 0xc7, 0x1,
    0xc3, 0x87, 0x1c, 0x7, 0xe, 0x1c, 0x7f, 0x9c,
    0x38, 0x71, 0xfe, 0x70, 0xe1, 0xc7, 0x1, 0xc3,
    0x87, 0x1c, 0x7, 0xe, 0x1c, 0x70, 0x1c, 0x38,
    0x71, 0xc0, 0x70, 0xe1, 0xc7, 0x1, 0xc3, 0x87,
    0x1c, 0x7, 0xe, 0x1c, 0x70, 0x1c, 0x38, 0x71,
    0xc0, 0x70, 0xe1, 0xc7, 0x1, 0xc3, 0x87, 0x1c,
    0x7, 0x0, 0x1c, 0x60, 0x1c, 0x0, 0x71, 0x80,
    0x70, 0x1, 0xcc, 0x1, 0xc0, 0x7, 0x30, 0x7,
    0x0, 0x1c, 0x80, 0x1c, 0x0, 0x76, 0x0, 0xf0,
    0x3, 0x90, 0x7, 0x80, 0x1c, 0xc0, 0xf8, 0x1,
    0xe2, 0x0, 0x0, 0x1a, 0x0,

    /* U+5217 "列" */
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e,
    0x7f, 0xff, 0xc0, 0x1e, 0x7f, 0xff, 0xc0, 0x1e,
    0x3, 0xc0, 0x0, 0x1e, 0x3, 0xc0, 0x0, 0x1e,
    0x3, 0xc0, 0x0, 0x1e, 0x3, 0xc0, 0x1e, 0x1e,
    0x3, 0xc0, 0x1e, 0x1e, 0x3, 0x80, 0x1e, 0x1e,
    0x3, 0x80, 0x1e, 0x1e, 0x3, 0x8f, 0x1e, 0x1e,
    0x7, 0x8f, 0x1e, 0x1e, 0x7, 0xff, 0x1e, 0x1e,
    0x7, 0xff, 0x1e, 0x1e, 0x7, 0xf, 0x1e, 0x1e,
    0x7, 0xf, 0x1e, 0x1e, 0x6, 0xf, 0x1e, 0x1e,
    0xe, 0xf, 0x1e, 0x1e, 0xe, 0xf, 0x1e, 0x1e,
    0xc, 0xe, 0x1e, 0x1e, 0xc, 0xe, 0x1e, 0x1e,
    0x1e, 0xe, 0x1e, 0x1e, 0x1b, 0xe, 0x1e, 0x1e,
    0x13, 0x9e, 0x1e, 0x1e, 0x33, 0xde, 0x1e, 0x1e,
    0x21, 0xdc, 0x1e, 0x1e, 0x61, 0xdc, 0x1e, 0x1e,
    0x40, 0xdc, 0x1e, 0x1e, 0x0, 0xb8, 0x1e, 0x1e,
    0x0, 0x38, 0x1e, 0x1e, 0x0, 0x38, 0x1e, 0x1e,
    0x0, 0x70, 0x1e, 0x1e, 0x0, 0x70, 0x1e, 0x1e,
    0x0, 0xe0, 0x1e, 0x1e, 0x0, 0xe0, 0x0, 0x1e,
    0x1, 0xc0, 0x0, 0x1e, 0x1, 0x80, 0x0, 0x1e,
    0x3, 0x0, 0x0, 0x1e, 0x7, 0x0, 0x0, 0x1e,
    0x6, 0x0, 0x0, 0x1e, 0xc, 0x0, 0x0, 0x1e,
    0x18, 0x0, 0x0, 0x1e, 0x30, 0x0, 0x0, 0x3e,
    0x20, 0x0, 0x1, 0xfc, 0x40, 0x0, 0x7, 0xf0,
    0x0, 0x0, 0x8, 0x0,

    /* U+5218 "刘" */
    0x1, 0x0, 0x0, 0x1e, 0x1, 0xc0, 0x0, 0x1e,
    0x1, 0xe0, 0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0x60, 0x0, 0x1e,
    0x0, 0x60, 0xf, 0x1e, 0x7f, 0xff, 0xef, 0x1e,
    0x7f, 0xff, 0xef, 0x1e, 0x0, 0xf, 0xf, 0x1e,
    0x0, 0xf, 0xf, 0x1e, 0x0, 0xf, 0xf, 0x1e,
    0x10, 0xf, 0xf, 0x1e, 0x10, 0xf, 0xf, 0x1e,
    0x8, 0xf, 0xf, 0x1e, 0xc, 0xf, 0xf, 0x1e,
    0xc, 0xf, 0xf, 0x1e, 0x6, 0xf, 0xf, 0x1e,
    0x6, 0xf, 0xf, 0x1e, 0x7, 0xe, 0xf, 0x1e,
    0x3, 0x8e, 0xf, 0x1e, 0x3, 0x8e, 0xf, 0x1e,
    0x3, 0xde, 0xf, 0x1e, 0x1, 0xde, 0xf, 0x1e,
    0x1, 0xfc, 0xf, 0x1e, 0x0, 0xfc, 0xf, 0x1e,
    0x0, 0xfc, 0xf, 0x1e, 0x0, 0xf8, 0xf, 0x1e,
    0x0, 0x78, 0xf, 0x1e, 0x0, 0x78, 0xf, 0x1e,
    0x0, 0x7c, 0xf, 0x1e, 0x0, 0xfc, 0xf, 0x1e,
    0x0, 0xfe, 0xf, 0x1e, 0x1, 0xdf, 0xf, 0x1e,
    0x1, 0x9f, 0xf, 0x1e, 0x3, 0x8f, 0x80, 0x1e,
    0x7, 0xf, 0x80, 0x1e, 0x6, 0x7, 0xc0, 0x1e,
    0xe, 0x7, 0xc0, 0x1e, 0xc, 0x3, 0x80, 0x1e,
    0x18, 0x3, 0x80, 0x1e, 0x30, 0x1, 0x0, 0x1e,
    0x60, 0x1, 0x0, 0x1e, 0x40, 0x0, 0x0, 0x7c,
    0x80, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x7, 0xf0,

    /* U+5219 "则" */
    0x38, 0x3, 0x80, 0x3c, 0xff, 0xfe, 0x0, 0xf3,
    0xff, 0xf8, 0x3, 0xcf, 0xff, 0xe0, 0xf, 0x38,
    0x3, 0x8e, 0x3c, 0xe0, 0xe, 0x38, 0xf3, 0x80,
    0x38, 0xe3, 0xce, 0x38, 0xe3, 0x8f, 0x38, 0xe3,
    0x8e, 0x3c, 0xe3, 0x8e, 0x38, 0xf3, 0x8e, 0x38,
    0xe3, 0xce, 0x38, 0xe3, 0x8f, 0x38, 0xe3, 0x8e,
    0x3c, 0xe3, 0x8e, 0x38, 0xf3, 0x8e, 0x38, 0xe3,
    0xce, 0x38, 0xe3, 0x8f, 0x38, 0xe3, 0x8e, 0x3c,
    0xe3, 0x8e, 0x38, 0xf3, 0x8e, 0x38, 0xe3, 0xce,
    0x38, 0xe3, 0x8f, 0x38, 0xe3, 0x8e, 0x3c, 0xe3,
    0x8e, 0x38, 0xf3, 0x8e, 0x38, 0xe3, 0xce, 0x38,
    0xe3, 0x8f, 0x38, 0xe3, 0x8e, 0x3c, 0xe3, 0x8e,
    0x38, 0xf3, 0x8e, 0x38, 0xe3, 0xce, 0x38, 0xe3,
    0x8f, 0x38, 0xe3, 0x8e, 0x3c, 0xe3, 0x8e, 0x38,
    0xf3, 0x8e, 0x30, 0xe3, 0xce, 0x38, 0xc3, 0x8f,
    0x38, 0xe3, 0xe, 0x3c, 0xe3, 0x98, 0x38, 0xf3,
    0x8e, 0x40, 0xe3, 0xc0, 0x75, 0x3, 0x8f, 0x1,
    0x98, 0x0, 0x3c, 0x6, 0x70, 0x0, 0xf0, 0x30,
    0xe0, 0x3, 0xc0, 0x83, 0xe0, 0xf, 0x6, 0x7,
    0xc0, 0x3c, 0x30, 0x1f, 0x0, 0xf1, 0x80, 0x3c,
    0x7, 0x84, 0x0, 0x70, 0x7e, 0x20, 0x0, 0xc7,
    0xe1, 0x0, 0x0, 0x0, 0x0,

    /* U+521A "刚" */
    0xe0, 0x7, 0x0, 0x7e, 0x0, 0x70, 0x7, 0xff,
    0xff, 0x0, 0x7f, 0xff, 0xf0, 0x7, 0xe0, 0x7,
    0x0, 0x7e, 0x0, 0x70, 0x7, 0xe0, 0x7, 0x1c,
    0x7e, 0x0, 0x71, 0xc7, 0xe0, 0x77, 0x1c, 0x7e,
    0x7, 0x71, 0xc7, 0xf0, 0x77, 0x1c, 0x7e, 0x87,
    0x71, 0xc7, 0xe8, 0x77, 0x1c, 0x7e, 0xc7, 0x71,
    0xc7, 0xe4, 0x77, 0x1c, 0x7e, 0x67, 0x71, 0xc7,
    0xe6, 0x77, 0x1c, 0x7e, 0x36, 0x71, 0xc7, 0xe3,
    0x67, 0x1c, 0x7e, 0x3e, 0x71, 0xc7, 0xe1, 0xe7,
    0x1c, 0x7e, 0x1e, 0x71, 0xc7, 0xe1, 0xc7, 0x1c,
    0x7e, 0xe, 0x71, 0xc7, 0xe1, 0xe7, 0x1c, 0x7e,
    0x1e, 0x71, 0xc7, 0xe1, 0xf7, 0x1c, 0x7e, 0x37,
    0x71, 0xc7, 0xe3, 0x77, 0x1c, 0x7e, 0x73, 0xf1,
    0xc7, 0xe6, 0x3f, 0x1c, 0x7e, 0x43, 0xf1, 0xc7,
    0xec, 0x3f, 0x1c, 0x7e, 0x81, 0x70, 0x7, 0xf8,
    0x17, 0x0, 0x7f, 0x0, 0x70, 0x7, 0xe0, 0x7,
    0x0, 0x7e, 0x0, 0x70, 0x7, 0xe0, 0x7, 0x0,
    0x7e, 0x0, 0x70, 0x7, 0xe0, 0x7, 0x0, 0x7e,
    0x0, 0x70, 0x7, 0xe0, 0xe, 0x0, 0xfe, 0x1,
    0xc0, 0x1e, 0xe0, 0x38, 0x3, 0xce, 0x4, 0x0,
    0xf8,

    /* U+521B "创" */
    0x1, 0xf0, 0x0, 0x1e, 0x3, 0xe0, 0x0, 0x3c,
    0x7, 0xc0, 0x0, 0x78, 0xf, 0x40, 0x0, 0xf0,
    0x1e, 0xc0, 0x1, 0xe0, 0x3d, 0xc1, 0xe3, 0xc0,
    0x71, 0xc3, 0xc7, 0x81, 0xe3, 0xc7, 0x8f, 0x3,
    0xc3, 0xcf, 0x1e, 0x7, 0x7, 0xde, 0x3c, 0xe,
    0x7, 0xbc, 0x78, 0x38, 0x7, 0x78, 0xf0, 0x60,
    0xe, 0xf1, 0xe0, 0xc0, 0xd, 0xe3, 0xc3, 0x0,
    0x1b, 0xc7, 0x87, 0x83, 0xc7, 0x8f, 0x1f, 0x7,
    0x8f, 0x1e, 0x3f, 0xff, 0x1e, 0x3c, 0xbc, 0x1e,
    0x3c, 0x7b, 0x78, 0x3c, 0x78, 0xf4, 0xf0, 0x78,
    0xf1, 0xe1, 0xe0, 0xf1, 0xe3, 0xc3, 0xc1, 0xe3,
    0xc7, 0x87, 0x83, 0xc7, 0x8f, 0xf, 0x7, 0x8f,
    0x1e, 0x1e, 0xf, 0x1e, 0x3c, 0x3c, 0x1e, 0x3c,
    0x78, 0x78, 0x3c, 0x78, 0xf0, 0xf0, 0xf0, 0xf1,
    0xe1, 0xe3, 0xc1, 0xe3, 0xc3, 0xdf, 0x3, 0xc7,
    0x87, 0x80, 0x7, 0x8f, 0xf, 0x0, 0x8f, 0x1e,
    0x1e, 0x1, 0x1e, 0x3c, 0x3c, 0x2, 0x3c, 0x78,
    0x78, 0x4, 0x78, 0xf0, 0xf0, 0x8, 0x1, 0xe1,
    0xe0, 0x18, 0x3, 0xc3, 0xc0, 0x70, 0x7, 0x87,
    0x80, 0xe0, 0xf, 0xf, 0x3, 0xc0, 0x1e, 0x1f,
    0xff, 0x80, 0x3c, 0x3f, 0xff, 0x0, 0xf8, 0x7f,
    0xfc, 0x3, 0xe0, 0x7f, 0xf0, 0x1f, 0x80, 0x0,
    0x0, 0xfc, 0x0,

    /* U+521D "初" */
    0x4, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0,
    0xe, 0x0, 0x0, 0x78, 0xe, 0x0, 0x0, 0xf0,
    0x1e, 0x3f, 0xff, 0xe0, 0x3c, 0x7f, 0xff, 0xc0,
    0x38, 0xf, 0x7, 0x80, 0x20, 0x1e, 0xf, 0x0,
    0xf8, 0x3c, 0x1e, 0x1, 0xf0, 0x78, 0x3f, 0xff,
    0xc0, 0xf0, 0x7f, 0xff, 0x81, 0xe0, 0xf0, 0xf,
    0x3, 0xc1, 0xe0, 0x1c, 0x7, 0x83, 0xc0, 0x78,
    0x4f, 0x7, 0x80, 0xf0, 0xde, 0xf, 0x1, 0xc3,
    0x3c, 0x1e, 0x3, 0x8c, 0x78, 0x3c, 0xf, 0x10,
    0xf0, 0x78, 0x1e, 0x61, 0xe0, 0xf0, 0x7c, 0x83,
    0xc1, 0xe0, 0xfe, 0x7, 0x83, 0xc3, 0xfc, 0xf,
    0x7, 0x85, 0xec, 0x1e, 0xf, 0x1b, 0xdc, 0x3c,
    0x1e, 0x67, 0xbc, 0x78, 0x3c, 0x8f, 0x3c, 0xf0,
    0x7a, 0x1e, 0x79, 0xe0, 0xf8, 0x3c, 0x63, 0xc1,
    0xe0, 0x78, 0xc7, 0x83, 0xc0, 0xf0, 0xf, 0x7,
    0x81, 0xe0, 0x1e, 0xf, 0x3, 0xc0, 0x3c, 0x1e,
    0x7, 0x80, 0x78, 0x3c, 0xf, 0x0, 0xf0, 0x78,
    0x1e, 0x1, 0xc0, 0xf0, 0x3c, 0x3, 0x81, 0xe0,
    0x78, 0xf, 0x3, 0xc0, 0xf0, 0x1c, 0x7, 0x81,
    0xe0, 0x30, 0xf, 0x3, 0xc0, 0xe0, 0x1e, 0x7,
    0x81, 0x80, 0x3c, 0xf, 0x6, 0x0, 0xf0, 0x1e,
    0x18, 0x3, 0xe0, 0x3c, 0x20, 0xf, 0x80, 0x78,
    0x80, 0x6c, 0x0,

    /* U+5220 "删" */
    0x1c, 0xee, 0x70, 0xf, 0x1c, 0xee, 0x70, 0xf,
    0x1f, 0xef, 0xf0, 0xf, 0x1f, 0xef, 0xf0, 0xf,
    0x1c, 0xee, 0x70, 0xf, 0x1c, 0xee, 0x70, 0xf,
    0x1c, 0xee, 0x70, 0xf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x7f, 0xff, 0xfd, 0xcf,
    0x7f, 0xff, 0xfd, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x1c, 0xee, 0x71, 0xcf,
    0x1c, 0xee, 0x71, 0xcf, 0x38, 0xee, 0x71, 0xcf,
    0x38, 0xee, 0x71, 0xcf, 0x38, 0xee, 0x71, 0xcf,
    0x38, 0xee, 0x71, 0xcf, 0x38, 0xee, 0x71, 0xcf,
    0x38, 0xee, 0x71, 0xcf, 0x38, 0xec, 0x71, 0xcf,
    0x30, 0xec, 0x70, 0xf, 0x30, 0xfc, 0x70, 0xf,
    0x30, 0xfc, 0x70, 0xf, 0x71, 0xf8, 0x70, 0xf,
    0x61, 0xd8, 0x70, 0xf, 0x67, 0xb0, 0x70, 0xf,
    0x7f, 0x30, 0xf0, 0xf, 0x40, 0x21, 0xe0, 0x1e,
    0xc0, 0x67, 0xc0, 0x3c, 0x0, 0x4c, 0x1, 0xf8,
    0x0, 0x0, 0x0, 0x0,

    /* U+5224 "判" */
    0x0, 0xf0, 0x0, 0x1e, 0x1, 0xe0, 0x0, 0x3d,
    0x3, 0xc0, 0x0, 0x7a, 0x7, 0x83, 0x0, 0xf6,
    0xf, 0xe, 0x1, 0xe6, 0x1e, 0x18, 0x3, 0xcc,
    0x3c, 0x63, 0xc7, 0x9c, 0x79, 0xc7, 0x8f, 0x3c,
    0xf3, 0xf, 0x1e, 0x39, 0xee, 0x1e, 0x3c, 0x7b,
    0xd8, 0x3c, 0x78, 0xe7, 0xe0, 0x78, 0xf1, 0xcf,
    0xc0, 0xf1, 0xe1, 0x1f, 0x1, 0xe3, 0xc0, 0x3e,
    0x3, 0xc7, 0x80, 0x78, 0x7, 0x8f, 0x7f, 0xff,
    0xcf, 0x1e, 0xff, 0xff, 0x9e, 0x3c, 0x3, 0xc0,
    0x3c, 0x78, 0x7, 0x80, 0x78, 0xf0, 0xf, 0x0,
    0xf1, 0xe0, 0x1e, 0x1, 0xe3, 0xc0, 0x3c, 0x3,
    0xc7, 0x80, 0x78, 0x37, 0x8f, 0x0, 0xf3, 0x8f,
    0x1e, 0x1, 0xfe, 0x1e, 0x3d, 0xff, 0xf8, 0x3c,
    0x7b, 0xff, 0xc0, 0x78, 0xf7, 0xff, 0x0, 0xf1,
    0xef, 0x9e, 0x1, 0xe3, 0xd8, 0x3c, 0x3, 0xc7,
    0x80, 0x78, 0x7, 0x8f, 0x0, 0xf0, 0xf, 0x1e,
    0x1, 0xe0, 0x1e, 0x3c, 0x3, 0x80, 0x3c, 0x78,
    0xf, 0x0, 0x0, 0xf0, 0x1c, 0x0, 0x1, 0xe0,
    0x38, 0x0, 0x3, 0xc0, 0xe0, 0x0, 0x7, 0x81,
    0x80, 0x0, 0xf, 0x7, 0x0, 0x0, 0x1e, 0xc,
    0x0, 0x0, 0x3c, 0x30, 0x0, 0x0, 0xf0, 0xc0,
    0x0, 0x3, 0xc3, 0x0, 0x0, 0x1b, 0x8, 0x0,
    0x0, 0x40, 0x0,

    /* U+5228 "刨" */
    0x7, 0xc0, 0x0, 0x1e, 0xf, 0x0, 0x0, 0x3c,
    0x1e, 0x0, 0x0, 0x78, 0x3c, 0x0, 0x0, 0xf0,
    0x78, 0xe, 0x1, 0xe0, 0xf0, 0x1c, 0x3, 0xc1,
    0xff, 0xf8, 0xe7, 0x87, 0xff, 0xf1, 0xcf, 0xf,
    0x0, 0xe3, 0x9e, 0x1c, 0x1, 0xc7, 0x3c, 0x30,
    0x3, 0x8e, 0x78, 0xe0, 0x7, 0x1c, 0xf1, 0x80,
    0xe, 0x39, 0xe7, 0xc7, 0x1c, 0x73, 0xcf, 0x8e,
    0x38, 0xe7, 0xaf, 0xfc, 0x71, 0xcf, 0xdf, 0xf8,
    0xe3, 0x9e, 0x3c, 0x71, 0xc7, 0x3c, 0x78, 0xe3,
    0x8e, 0x78, 0xf1, 0xc7, 0x1c, 0xf1, 0xe3, 0x8e,
    0x39, 0xe3, 0xc7, 0x1c, 0x73, 0xc7, 0x8e, 0x38,
    0xe7, 0x8f, 0x1c, 0x71, 0xcf, 0x1e, 0x38, 0xe3,
    0x9e, 0x3f, 0xf1, 0xc7, 0x3c, 0x7f, 0xe3, 0x8e,
    0x78, 0xf1, 0xc7, 0x1c, 0xf1, 0xe3, 0x8e, 0x39,
    0xe3, 0xc0, 0x3c, 0x73, 0xc7, 0x80, 0xf0, 0xe7,
    0x8f, 0x7, 0xc1, 0xcf, 0x1e, 0x30, 0x23, 0x9e,
    0x3c, 0x0, 0x47, 0x3c, 0x78, 0x0, 0x8e, 0x78,
    0xf0, 0x1, 0x0, 0xf1, 0xe0, 0x2, 0x1, 0xe3,
    0xc0, 0xc, 0x3, 0xc7, 0x80, 0x18, 0x7, 0x8f,
    0x0, 0x30, 0xf, 0x1f, 0x0, 0xe0, 0x1e, 0x3f,
    0xff, 0xc0, 0x78, 0x3f, 0xff, 0x81, 0xe0, 0x3f,
    0xfc, 0xf, 0x80, 0x0, 0x0, 0x76, 0x0,

    /* U+5229 "利" */
    0x0, 0x6, 0x0, 0x1e, 0x0, 0x1f, 0x0, 0x1e,
    0x0, 0x7f, 0x80, 0x1e, 0x7, 0xff, 0xc0, 0x1e,
    0x7f, 0xe0, 0x0, 0x1e, 0x0, 0xe0, 0x0, 0x1e,
    0x0, 0xe0, 0x0, 0x1e, 0x0, 0xe0, 0xf, 0x1e,
    0x0, 0xe0, 0xf, 0x1e, 0x0, 0xe0, 0xf, 0x1e,
    0x0, 0xe0, 0xf, 0x1e, 0x0, 0xe0, 0xf, 0x1e,
    0x0, 0xe0, 0xf, 0x1e, 0x7f, 0xff, 0xcf, 0x1e,
    0x7f, 0xff, 0xcf, 0x1e, 0x1, 0xe0, 0xf, 0x1e,
    0x1, 0xe0, 0xf, 0x1e, 0x1, 0xe0, 0xf, 0x1e,
    0x3, 0xe0, 0xf, 0x1e, 0x3, 0xf8, 0xf, 0x1e,
    0x3, 0xec, 0xf, 0x1e, 0x3, 0xee, 0xf, 0x1e,
    0x3, 0xe7, 0xf, 0x1e, 0x7, 0xe7, 0x8f, 0x1e,
    0x7, 0xe7, 0x8f, 0x1e, 0x6, 0xe3, 0xf, 0x1e,
    0xe, 0xe3, 0xf, 0x1e, 0xc, 0xe1, 0xf, 0x1e,
    0xc, 0xe0, 0xf, 0x1e, 0x18, 0xe0, 0xf, 0x1e,
    0x18, 0xe0, 0xf, 0x1e, 0x30, 0xe0, 0xf, 0x1e,
    0x30, 0xe0, 0xf, 0x1e, 0x60, 0xe0, 0xf, 0x1e,
    0x40, 0xe0, 0x0, 0x1e, 0xc0, 0xe0, 0x0, 0x1e,
    0x0, 0xe0, 0x0, 0x1e, 0x0, 0xe0, 0x0, 0x1e,
    0x0, 0xe0, 0x0, 0x1e, 0x0, 0xe0, 0x0, 0x1e,
    0x0, 0xe0, 0x0, 0x1e, 0x0, 0xe0, 0x0, 0x1e,
    0x0, 0xe0, 0x0, 0x3c, 0x0, 0xe0, 0x0, 0x7c,
    0x0, 0xe0, 0x1, 0xf8, 0x0, 0xe0, 0x7, 0x60,

    /* U+522B "别" */
    0x1e, 0xf, 0x0, 0x1e, 0x3c, 0x1e, 0x0, 0x3c,
    0x7f, 0xfc, 0x0, 0x78, 0xff, 0xf8, 0x0, 0xf1,
    0xff, 0xf0, 0x1, 0xe3, 0xc1, 0xe1, 0xe3, 0xc7,
    0x83, 0xc3, 0xc7, 0x8f, 0x7, 0x87, 0x8f, 0x1e,
    0xf, 0xf, 0x1e, 0x3c, 0x1e, 0x1e, 0x3c, 0x78,
    0x3c, 0x3c, 0x78, 0xf0, 0x78, 0x78, 0xf1, 0xe0,
    0xf0, 0xf1, 0xe3, 0xff, 0xe1, 0xe3, 0xc7, 0xff,
    0xc3, 0xc7, 0x8f, 0xff, 0x87, 0x8f, 0x1e, 0xf,
    0xf, 0x1e, 0x0, 0x0, 0x1e, 0x3c, 0x0, 0x0,
    0x3c, 0x78, 0x3c, 0x0, 0x78, 0xf0, 0x78, 0xf0,
    0xf1, 0xe0, 0xf1, 0xe1, 0xe3, 0xdf, 0xff, 0xc3,
    0xc7, 0xbf, 0xff, 0x87, 0x8f, 0x7f, 0xff, 0xf,
    0x1e, 0xf, 0x1e, 0x1e, 0x3c, 0x1e, 0x3c, 0x3c,
    0x78, 0x3c, 0x78, 0x78, 0xf0, 0x78, 0xf0, 0xf1,
    0xe0, 0xf1, 0xe1, 0xe3, 0xc1, 0xe3, 0xc3, 0xc7,
    0x83, 0x87, 0x87, 0x8f, 0x7, 0xf, 0xf, 0x1e,
    0xe, 0x1e, 0x1e, 0x3c, 0x1c, 0x3c, 0x0, 0x78,
    0x38, 0x78, 0x0, 0xf0, 0x70, 0xf0, 0x1, 0xe0,
    0xc1, 0xe0, 0x3, 0xc3, 0x83, 0xc0, 0x7, 0x86,
    0x7, 0x80, 0xf, 0xc, 0xf, 0x0, 0x1e, 0x30,
    0x1e, 0x0, 0x3c, 0x40, 0x78, 0x0, 0xf1, 0x81,
    0xe0, 0x7, 0xc2, 0xd, 0x0, 0x3f, 0x8, 0x0,
    0x0, 0x0, 0x0,

    /* U+522D "刭" */
    0x0, 0xf, 0x80, 0x1e, 0x0, 0x1e, 0x0, 0x3c,
    0xff, 0xfc, 0x0, 0x79, 0xff, 0xf8, 0x0, 0xf0,
    0x0, 0xf0, 0x1, 0xe0, 0x3, 0xe3, 0xc3, 0xc0,
    0x7, 0x87, 0x87, 0x80, 0xf, 0xf, 0xf, 0x0,
    0x1e, 0x1e, 0x1e, 0x0, 0x78, 0x3c, 0x3c, 0x0,
    0xf0, 0x78, 0x78, 0x1, 0xc0, 0xf0, 0xf0, 0x7,
    0x81, 0xe1, 0xe0, 0xf, 0x3, 0xc3, 0xc0, 0x3b,
    0x7, 0x87, 0x80, 0xe3, 0x8f, 0xf, 0x1, 0x87,
    0xde, 0x1e, 0x6, 0x7, 0xbc, 0x3c, 0x18, 0xf,
    0x78, 0x78, 0x60, 0xc, 0xf0, 0xf1, 0x80, 0x9,
    0xe1, 0xe4, 0x0, 0xb, 0xc3, 0xd0, 0x0, 0x7,
    0x87, 0x9f, 0xff, 0xcf, 0xf, 0x3f, 0xff, 0x9e,
    0x1e, 0x1, 0xc0, 0x3c, 0x3c, 0x3, 0x80, 0x78,
    0x78, 0x7, 0x0, 0xf0, 0xf0, 0xe, 0x1, 0xe1,
    0xe0, 0x1c, 0x3, 0xc3, 0xc0, 0x38, 0x7, 0x87,
    0x80, 0x70, 0xf, 0xf, 0x0, 0xe0, 0x1e, 0x1e,
    0x1, 0xc0, 0xbc, 0x3c, 0x3, 0x82, 0x78, 0x78,
    0x7, 0x18, 0x0, 0xf0, 0xf, 0xe0, 0x1, 0xe0,
    0x3f, 0x80, 0x3, 0xdf, 0xfc, 0x0, 0x7, 0x9f,
    0xe0, 0x0, 0xf, 0x3f, 0x0, 0x0, 0x1e, 0x78,
    0x0, 0x0, 0x3c, 0x80, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x0, 0x8c, 0x0,

    /* U+522E "刮" */
    0x0, 0x6, 0x0, 0x3c, 0x0, 0x7e, 0x0, 0xf0,
    0x7, 0xfc, 0x3, 0xc1, 0xff, 0xe0, 0xf, 0x7f,
    0xf0, 0x0, 0x3c, 0x3, 0x80, 0x0, 0xf0, 0xe,
    0x1, 0xe3, 0xc0, 0x38, 0x7, 0x8f, 0x0, 0xe0,
    0x1e, 0x3c, 0x3, 0x80, 0x78, 0xf0, 0xe, 0x1,
    0xe3, 0xc0, 0x38, 0x7, 0x8f, 0x0, 0xe0, 0x1e,
    0x3f, 0xff, 0xff, 0x78, 0xff, 0xff, 0xfd, 0xe3,
    0xc0, 0x38, 0x7, 0x8f, 0x0, 0xe0, 0x1e, 0x3c,
    0x3, 0x80, 0x78, 0xf0, 0xe, 0x1, 0xe3, 0xc0,
    0x38, 0x7, 0x8f, 0x1, 0xe0, 0x1e, 0x3c, 0x7,
    0x0, 0x78, 0xf0, 0x18, 0x1, 0xe3, 0xde, 0x63,
    0xc7, 0x8f, 0x79, 0xf, 0x1e, 0x3d, 0xff, 0xfc,
    0x78, 0xf7, 0xff, 0xf1, 0xe3, 0xde, 0x3, 0xc7,
    0x8f, 0x78, 0xf, 0x1e, 0x3d, 0xe0, 0x3c, 0x78,
    0xf7, 0x80, 0xf1, 0xe3, 0xde, 0x3, 0xc7, 0x8f,
    0x78, 0xf, 0x1e, 0x3d, 0xe0, 0x3c, 0x78, 0xf7,
    0x80, 0xf1, 0xe3, 0xde, 0x3, 0xc0, 0xf, 0x78,
    0xf, 0x0, 0x3d, 0xe0, 0x3c, 0x0, 0xf7, 0x80,
    0xf0, 0x3, 0xde, 0x3, 0xc0, 0xf, 0x7f, 0xff,
    0x0, 0x3d, 0xff, 0xfc, 0x0, 0xf7, 0x80, 0xf0,
    0x7, 0x9e, 0x3, 0xc0, 0x3e, 0x78, 0xf, 0x3,
    0xe0, 0x0, 0x0, 0x3e, 0x0,

    /* U+5230 "到" */
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xfc, 0x3, 0xff, 0xff, 0xf0, 0xf, 0x3,
    0xc0, 0x0, 0x3c, 0xf, 0x0, 0x3c, 0xf0, 0x3c,
    0x0, 0xf3, 0xc0, 0xe0, 0x3, 0xcf, 0x3, 0x88,
    0xf, 0x3c, 0x1c, 0x20, 0x3c, 0xf0, 0x60, 0x80,
    0xf3, 0xc3, 0x83, 0x3, 0xcf, 0xc, 0xe, 0xf,
    0x3c, 0x60, 0x3c, 0x3c, 0xf1, 0x3, 0x78, 0xf3,
    0xc8, 0x79, 0xe3, 0xcf, 0xff, 0xc7, 0x8f, 0x3d,
    0xfe, 0xe, 0x3c, 0xf7, 0xe0, 0x18, 0xf3, 0xde,
    0x78, 0x23, 0xcf, 0x41, 0xe0, 0xf, 0x3c, 0x7,
    0x80, 0x3c, 0xf0, 0x1e, 0x0, 0xf3, 0xc0, 0x78,
    0x3, 0xcf, 0x1, 0xe0, 0xf, 0x3c, 0x7, 0x80,
    0x3c, 0xf7, 0xff, 0xf8, 0xf3, 0xdf, 0xff, 0xe3,
    0xcf, 0x1, 0xe0, 0xf, 0x3c, 0x7, 0x80, 0x3c,
    0xf0, 0x1e, 0x0, 0xf3, 0xc0, 0x78, 0x3, 0xcf,
    0x1, 0xe0, 0xf, 0x3c, 0x7, 0x81, 0x3c, 0xf0,
    0x1e, 0x8, 0xf3, 0xc0, 0x78, 0x40, 0xf, 0x1,
    0xe7, 0x0, 0x3c, 0x7, 0xf8, 0x0, 0xf8, 0x3f,
    0x80, 0x3, 0xff, 0xfc, 0x0, 0xf, 0xff, 0xc0,
    0x0, 0x3f, 0xfc, 0x0, 0x1, 0xff, 0x80, 0x0,
    0x7, 0xb0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x12, 0x0,

    /* U+5232 "刲" */
    0x1, 0xe0, 0x0, 0x3c, 0x7, 0x80, 0x0, 0xf0,
    0x1e, 0x0, 0x3, 0xc0, 0x78, 0x0, 0xf, 0x1,
    0xe0, 0x0, 0x3c, 0x7, 0x80, 0xf0, 0xf0, 0x1e,
    0x3, 0xc3, 0xdf, 0xff, 0xcf, 0xf, 0x7f, 0xff,
    0x3c, 0x3c, 0x7, 0x80, 0xf0, 0xf0, 0x1e, 0x3,
    0xc3, 0xc0, 0x78, 0xf, 0xf, 0x1, 0xe0, 0x3c,
    0x3c, 0x7, 0x80, 0xf0, 0xf0, 0x1e, 0x3, 0xc3,
    0xc0, 0x78, 0xf, 0xf, 0x1, 0xe0, 0x3c, 0x3f,
    0xff, 0xfe, 0xf0, 0xff, 0xff, 0xfb, 0xc3, 0xc0,
    0x0, 0xf, 0xf, 0x1, 0xe0, 0x3c, 0x3c, 0x7,
    0x80, 0xf0, 0xf0, 0x1e, 0x3, 0xc3, 0xc0, 0x78,
    0xf, 0xf, 0x1, 0xe0, 0x3c, 0x3c, 0x7, 0x80,
    0xf0, 0xf0, 0x1e, 0x3, 0xc3, 0xdf, 0xff, 0xcf,
    0xf, 0x7f, 0xff, 0x3c, 0x3c, 0x7, 0x80, 0xf0,
    0xf0, 0x1e, 0x3, 0xc3, 0xc0, 0x78, 0xf, 0xf,
    0x1, 0xe0, 0x3c, 0x3c, 0x7, 0x80, 0xf0, 0xf0,
    0x1e, 0x3, 0xc3, 0xc0, 0x78, 0x20, 0xf, 0x1,
    0xe1, 0x0, 0x3c, 0x7, 0xb8, 0x0, 0xf0, 0x1f,
    0xc0, 0x3, 0xff, 0xfc, 0x0, 0xf, 0xff, 0xe0,
    0x0, 0x3d, 0xfe, 0x0, 0x0, 0xf7, 0xc0, 0x0,
    0x7, 0x98, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x30, 0x0,

    /* U+5233 "刳" */
    0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0, 0xf,
    0x3f, 0xff, 0xe0, 0xf, 0x3f, 0xff, 0xef, 0xf,
    0x3f, 0xff, 0xef, 0xf, 0x1, 0xe0, 0xf, 0xf,
    0x1, 0xf0, 0xf, 0xf, 0x3, 0xd8, 0xf, 0xf,
    0x3, 0x8c, 0xf, 0xf, 0x3, 0x8f, 0xf, 0xf,
    0x7, 0x7, 0x8f, 0xf, 0x6, 0x3, 0xcf, 0xf,
    0xe, 0x1, 0xef, 0xf, 0xf, 0xff, 0xef, 0xf,
    0x1f, 0xff, 0xef, 0xf, 0x30, 0x0, 0x6f, 0xf,
    0x20, 0x0, 0x2f, 0xf, 0x40, 0x0, 0xf, 0xf,
    0x0, 0x0, 0xf, 0xf, 0x3f, 0xff, 0xef, 0xf,
    0x3f, 0xff, 0xef, 0xf, 0x3, 0x80, 0xf, 0xf,
    0x3, 0x80, 0xf, 0xf, 0x3, 0x0, 0xf, 0xf,
    0x7, 0x0, 0xf, 0xf, 0x6, 0xf, 0xf, 0xf,
    0xc, 0xf, 0xf, 0xf, 0xf, 0xff, 0xf, 0xf,
    0xf, 0xff, 0xf, 0xf, 0x8, 0xf, 0xf, 0xf,
    0x0, 0xf, 0xf, 0xf, 0x0, 0xf, 0xf, 0xf,
    0x0, 0xf, 0xf, 0xf, 0x0, 0xf, 0xf, 0xf,
    0x0, 0xf, 0xf, 0xf, 0x0, 0xf, 0x0, 0xf,
    0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf,
    0x0, 0xf, 0x0, 0xf, 0x0, 0xf, 0x0, 0xf,
    0x0, 0x1e, 0x0, 0x1e, 0x0, 0x7c, 0x0, 0x7c,
    0x0, 0x80, 0x1, 0xf8, 0x0, 0x0, 0x2, 0x20,

    /* U+5236 "制" */
    0x0, 0xf0, 0x0, 0x3c, 0xf3, 0xc0, 0x0, 0xf3,
    0xcf, 0x0, 0x3, 0xcf, 0x3c, 0x0, 0xf, 0x3c,
    0xf0, 0x0, 0x3c, 0xf3, 0xc0, 0x0, 0xf3, 0xff,
    0xfc, 0xf3, 0xcf, 0xff, 0xf3, 0xcf, 0x38, 0xf0,
    0xf, 0x3c, 0xc3, 0xc0, 0x3c, 0xf3, 0xf, 0x0,
    0xf3, 0xd8, 0x3c, 0x3, 0xcf, 0x60, 0xf0, 0xf,
    0x3c, 0x3, 0xc0, 0x3c, 0xff, 0xff, 0xfe, 0xf3,
    0xff, 0xff, 0xfb, 0xcf, 0x0, 0xf0, 0xf, 0x3c,
    0x3, 0xc0, 0x3c, 0xf0, 0xf, 0x0, 0xf3, 0xc0,
    0x3c, 0x3, 0xcf, 0x3c, 0xf3, 0x8f, 0x3c, 0xf3,
    0xce, 0x3c, 0xf3, 0xff, 0xf8, 0xf3, 0xcf, 0xff,
    0xe3, 0xcf, 0x3c, 0xf3, 0x8f, 0x3c, 0xf3, 0xce,
    0x3c, 0xf3, 0xcf, 0x38, 0xf3, 0xcf, 0x3c, 0xe3,
    0xcf, 0x3c, 0xf3, 0x8f, 0x3c, 0xf3, 0xce, 0x3c,
    0xf3, 0xcf, 0x38, 0xf3, 0xcf, 0x3c, 0xe3, 0xcf,
    0x3c, 0xf3, 0x8f, 0x3c, 0xf3, 0xce, 0x3c, 0xf3,
    0xcf, 0x38, 0xf3, 0xcf, 0x3c, 0xe3, 0xcf, 0x3c,
    0xf3, 0x80, 0x3c, 0xf3, 0xde, 0x0, 0xf3, 0xcf,
    0xf0, 0x3, 0xcf, 0x3c, 0x0, 0xf, 0x3c, 0xf0,
    0x0, 0x3c, 0x3, 0xc0, 0x0, 0xf0, 0xf, 0x0,
    0x7, 0x80, 0x3c, 0x0, 0x7e, 0x0, 0xf0, 0x7,
    0xf0, 0x3, 0xc0, 0x39, 0x80,

    /* U+5237 "刷" */
    0x38, 0x0, 0x70, 0x1c, 0xe0, 0x1, 0xc0, 0x73,
    0xff, 0xff, 0x1, 0xcf, 0xff, 0xfc, 0x7, 0x38,
    0x0, 0x70, 0x1c, 0xe0, 0x1, 0xc0, 0x73, 0x80,
    0x7, 0x39, 0xce, 0x0, 0x1c, 0xe7, 0x38, 0x0,
    0x73, 0x9c, 0xe0, 0x1, 0xce, 0x73, 0xff, 0xff,
    0x39, 0xcf, 0xff, 0xfc, 0xe7, 0x38, 0x0, 0x73,
    0x9c, 0xe0, 0x0, 0xe, 0x73, 0x80, 0xe0, 0x39,
    0xce, 0x3, 0x80, 0xe7, 0x38, 0xe, 0x3, 0x9c,
    0xe0, 0x38, 0xe, 0x73, 0x80, 0xe0, 0x39, 0xce,
    0xf3, 0x9c, 0xe7, 0x3b, 0xff, 0xf3, 0x9c, 0xef,
    0xff, 0xce, 0x73, 0xbc, 0xe7, 0x39, 0xce, 0xf3,
    0x9c, 0xe7, 0x3b, 0xce, 0x73, 0x9c, 0xef, 0x39,
    0xce, 0x73, 0xbc, 0xe7, 0x39, 0xce, 0xf3, 0x9c,
    0xe7, 0x3b, 0xce, 0x73, 0x9c, 0xef, 0x39, 0xce,
    0x73, 0xbc, 0xe7, 0x39, 0xce, 0xf3, 0x9c, 0xe7,
    0x3b, 0xce, 0x73, 0x9c, 0xef, 0x39, 0xce, 0x73,
    0xbc, 0xe7, 0x39, 0xce, 0xf3, 0x9c, 0xe7, 0x33,
    0xce, 0x73, 0x9c, 0xcf, 0x39, 0xc0, 0x77, 0x3c,
    0xe7, 0x1, 0xdc, 0xf3, 0xb8, 0x7, 0x63, 0xcf,
    0xe0, 0x1d, 0x80, 0x38, 0x0, 0x74, 0x0, 0xe0,
    0x3, 0xb0, 0x3, 0x80, 0x1e, 0xc0, 0xe, 0x0,
    0xf2, 0x0, 0x38, 0xf, 0x80,

    /* U+5238 "券" */
    0x0, 0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0,
    0x8, 0x7, 0x1, 0xc0, 0xe, 0x7, 0x1, 0x80,
    0x7, 0x7, 0x3, 0x80, 0x7, 0xc7, 0x3, 0x0,
    0x3, 0xc7, 0x7, 0x0, 0x3, 0x87, 0x6, 0x0,
    0x1, 0x87, 0xc, 0x0, 0x1, 0x7, 0xc, 0x0,
    0x7f, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xff, 0xf8,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xe, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x78, 0x20, 0x0,
    0x0, 0x70, 0x10, 0x0, 0x0, 0xe0, 0x18, 0x0,
    0x1, 0xc0, 0x1e, 0x0, 0x1, 0xc0, 0xf, 0x0,
    0x3, 0x80, 0xf, 0xc0, 0x7, 0x0, 0x1f, 0xfe,
    0xf, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xfc,
    0x30, 0x78, 0x1e, 0x7c, 0x60, 0x78, 0x1e, 0x1c,
    0xc0, 0x78, 0x1e, 0x0, 0x0, 0x78, 0x1e, 0x0,
    0x0, 0x78, 0x1e, 0x0, 0x0, 0x70, 0x1e, 0x0,
    0x0, 0x70, 0x1e, 0x0, 0x0, 0x70, 0x1e, 0x0,
    0x0, 0x70, 0x1e, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x0, 0xe0, 0x1e, 0x0, 0x0, 0xe0, 0x1e, 0x0,
    0x1, 0xc0, 0x1e, 0x0, 0x3, 0x80, 0x3c, 0x0,
    0x7, 0x0, 0x7c, 0x0, 0xc, 0x1, 0xf8, 0x0,
    0x38, 0x3, 0x60, 0x0, 0x60, 0x4, 0x0, 0x0,

    /* U+5239 "刹" */
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x1e, 0x0, 0x3c,
    0x0, 0x3c, 0x0, 0x78, 0xc0, 0x78, 0x0, 0xf0,
    0xe0, 0xe0, 0x1, 0xe0, 0xe3, 0xc0, 0x3, 0xc0,
    0xf7, 0x3, 0xc7, 0x80, 0xfe, 0x7, 0x8f, 0x0,
    0xf8, 0xf, 0x1e, 0x0, 0xf8, 0x1e, 0x3c, 0x3,
    0xf8, 0x3c, 0x78, 0x6, 0xfc, 0x78, 0xf0, 0x18,
    0xfc, 0xf1, 0xe0, 0x60, 0xf9, 0xe3, 0xc1, 0x80,
    0xf3, 0xc7, 0x86, 0x0, 0xe7, 0x8f, 0x18, 0xf0,
    0xcf, 0x1e, 0xe1, 0xe0, 0x9e, 0x3c, 0x3, 0xc0,
    0x3c, 0x78, 0x7, 0x80, 0x78, 0xf0, 0xf, 0x0,
    0xf1, 0xe0, 0x1e, 0x1, 0xe3, 0xdf, 0xff, 0xfb,
    0xc7, 0xbf, 0xff, 0xf7, 0x8f, 0x1, 0xf0, 0xf,
    0x1e, 0x7, 0xe0, 0x1e, 0x3c, 0xf, 0xc0, 0x3c,
    0x78, 0x1f, 0xe0, 0x78, 0xf0, 0x3f, 0xe0, 0xf1,
    0xe0, 0xfe, 0xe1, 0xe3, 0xc1, 0xfd, 0xe3, 0xc7,
    0x83, 0xf9, 0xe7, 0x8f, 0xe, 0xf3, 0xcf, 0x1e,
    0x1d, 0xe3, 0x9e, 0x3c, 0x73, 0xc3, 0x3c, 0x78,
    0xc7, 0x84, 0x0, 0xf1, 0x8f, 0x0, 0x1, 0xe6,
    0x1e, 0x0, 0x3, 0xcc, 0x3c, 0x0, 0x7, 0xb0,
    0x78, 0x0, 0xf, 0x40, 0xf0, 0x0, 0x1f, 0x81,
    0xe0, 0x0, 0x3c, 0x3, 0xc0, 0x0, 0x78, 0x7,
    0x80, 0x3, 0xe0, 0xf, 0x0, 0x1f, 0x80, 0x1e,
    0x0, 0xfe, 0x0,

    /* U+523A "刺" */
    0x0, 0xf0, 0x0, 0x1e, 0x1, 0xe0, 0x0, 0x3c,
    0x3, 0xc0, 0x0, 0x78, 0x7, 0x80, 0x0, 0xf0,
    0xf, 0x0, 0x1, 0xef, 0xff, 0xfc, 0xf3, 0xdf,
    0xff, 0xf9, 0xe7, 0x80, 0x78, 0x3, 0xcf, 0x0,
    0xf0, 0x7, 0x9e, 0x1, 0xe0, 0xf, 0x3c, 0x3,
    0xc0, 0x1e, 0x79, 0xe7, 0x8f, 0x3c, 0xf3, 0xcf,
    0x1e, 0x79, 0xe7, 0xff, 0xfc, 0xf3, 0xcf, 0xff,
    0xf9, 0xe7, 0x9e, 0x78, 0xf3, 0xcf, 0x3c, 0xf1,
    0xe7, 0x9e, 0x79, 0xe3, 0xcf, 0x3c, 0xf3, 0xc7,
    0x9e, 0x79, 0xe7, 0x8f, 0x3c, 0xf3, 0xcf, 0x1e,
    0x79, 0xe7, 0x9e, 0x3c, 0xf3, 0xcf, 0x3c, 0x79,
    0xe7, 0x9e, 0x78, 0xf3, 0xcf, 0x3c, 0xf1, 0xc7,
    0x9e, 0x79, 0xe7, 0x8f, 0x3c, 0xff, 0xfe, 0x1e,
    0x78, 0x1f, 0x90, 0x3c, 0xf0, 0x7f, 0x0, 0x79,
    0xe0, 0xff, 0x0, 0xf3, 0xc1, 0xff, 0x1, 0xe7,
    0x83, 0xff, 0x3, 0xcf, 0xe, 0xf7, 0x7, 0x9e,
    0x1d, 0xef, 0xf, 0x3c, 0x33, 0xde, 0x0, 0x78,
    0xc7, 0x9e, 0x0, 0xf1, 0x8f, 0x3c, 0x1, 0xe6,
    0x1e, 0x30, 0x3, 0xc8, 0x3c, 0x60, 0x7, 0xa0,
    0x78, 0x0, 0xf, 0x80, 0xf0, 0x0, 0x1e, 0x1,
    0xe0, 0x0, 0x3c, 0x3, 0xc0, 0x0, 0x78, 0x7,
    0x80, 0x1, 0xe0, 0xf, 0x0, 0xf, 0x80, 0x1e,
    0x0, 0x6e, 0x0,

    /* U+523B "刻" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x1c,
    0x1, 0xc0, 0x0, 0x38, 0x1, 0xc0, 0x0, 0x70,
    0x3, 0xc0, 0x0, 0xe0, 0x7, 0x0, 0x1, 0xc0,
    0x6, 0x0, 0x3, 0x80, 0x8, 0x0, 0x7, 0x7f,
    0xff, 0xe7, 0x8e, 0x3, 0xc0, 0xf, 0x1c, 0x7,
    0x80, 0x1e, 0x38, 0xf, 0x0, 0x3c, 0x70, 0x1c,
    0x0, 0x78, 0xe0, 0x78, 0x0, 0xf1, 0xc0, 0xe1,
    0xe1, 0xe3, 0x81, 0xc3, 0xc3, 0xc7, 0x7, 0xf,
    0x7, 0x8e, 0xc, 0x1e, 0xf, 0x1c, 0x38, 0x3c,
    0x1e, 0x38, 0x60, 0xf8, 0x3c, 0x71, 0x87, 0xe0,
    0x78, 0xed, 0xfd, 0xc0, 0xf1, 0xcf, 0xe3, 0x81,
    0xe3, 0x9f, 0xe, 0x3, 0xc7, 0x38, 0x18, 0x7,
    0x8e, 0x0, 0x70, 0xf, 0x1c, 0x0, 0xc0, 0x1e,
    0x38, 0x3, 0x7c, 0x3c, 0x70, 0xe, 0xf8, 0x78,
    0xe0, 0x19, 0xe0, 0xf1, 0xc0, 0x63, 0xc1, 0xe3,
    0x81, 0x87, 0x83, 0xc7, 0x6, 0xf, 0x7, 0x8e,
    0x18, 0x3c, 0xf, 0x1c, 0x60, 0x78, 0x1e, 0x39,
    0x80, 0xe0, 0x3c, 0x76, 0x3, 0xc0, 0x78, 0xe0,
    0x7, 0x80, 0x1, 0xc0, 0x1d, 0x80, 0x3, 0x80,
    0x71, 0x80, 0x7, 0x1, 0xc3, 0xc0, 0xe, 0x6,
    0x7, 0xc0, 0x1c, 0x18, 0x7, 0x0, 0x38, 0x60,
    0xe, 0x0, 0xf1, 0x80, 0xc, 0x3, 0xc4, 0x0,
    0x18, 0xf, 0x10, 0x0, 0x10, 0xe8, 0x0,

    /* U+523D "刽" */
    0x0, 0xf0, 0x0, 0x1e, 0x1, 0xe0, 0x0, 0x3c,
    0x7, 0xc0, 0x0, 0x78, 0xf, 0x0, 0x0, 0xf0,
    0x1f, 0x0, 0x1, 0xe0, 0x3f, 0x0, 0x3, 0xc0,
    0x73, 0x1, 0xe7, 0x81, 0xe7, 0x3, 0xcf, 0x3,
    0x87, 0x87, 0x9e, 0x7, 0xf, 0x8f, 0x3c, 0x1c,
    0xf, 0x9e, 0x78, 0x30, 0xf, 0xbc, 0xf0, 0xe0,
    0xf, 0x79, 0xe1, 0x80, 0x1e, 0xf3, 0xc6, 0x0,
    0x19, 0xe7, 0x98, 0x0, 0x13, 0xcf, 0x2f, 0xff,
    0x7, 0x9e, 0x9f, 0xfe, 0xf, 0x3f, 0x0, 0x0,
    0x1e, 0x78, 0x0, 0x0, 0x3c, 0xf0, 0x0, 0x0,
    0x79, 0xe0, 0x0, 0x0, 0xf3, 0xc0, 0x0, 0x1,
    0xe7, 0xbf, 0xff, 0xfb, 0xcf, 0x7f, 0xff, 0xf7,
    0x9e, 0x1, 0xe0, 0xf, 0x3c, 0x3, 0x80, 0x1e,
    0x78, 0xf, 0x0, 0x3c, 0xf0, 0x1e, 0x40, 0x79,
    0xe0, 0x38, 0x40, 0xf3, 0xc0, 0x70, 0x81, 0xe7,
    0x81, 0xc1, 0x83, 0xcf, 0x3, 0x83, 0x7, 0x9e,
    0x6, 0x7, 0xf, 0x3c, 0x18, 0xe, 0x1e, 0x78,
    0x20, 0x1e, 0x0, 0xf0, 0xc0, 0x5e, 0x1, 0xe3,
    0x3, 0x3e, 0x3, 0xc8, 0x3c, 0x38, 0x7, 0xbf,
    0xf0, 0x70, 0xf, 0x3f, 0x80, 0x60, 0x1e, 0x7c,
    0x0, 0xc0, 0x3c, 0xc0, 0x0, 0x80, 0xf0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0xe8, 0x0,

    /* U+523F "刿" */
    0x0, 0x3c, 0x0, 0xf, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x3c, 0x0, 0xf, 0x1e, 0x3c, 0xf0, 0xf,
    0x1e, 0x3c, 0xf0, 0xf, 0x1e, 0x3c, 0xf0, 0xf,
    0x1e, 0x3c, 0xf3, 0xcf, 0x1e, 0x3c, 0xf3, 0xcf,
    0x1e, 0x3c, 0xf3, 0xcf, 0x1e, 0x3c, 0xf3, 0xcf,
    0x1e, 0x3c, 0xf3, 0xcf, 0x1e, 0x3c, 0xf3, 0xcf,
    0x1e, 0x3c, 0xf3, 0xcf, 0x1f, 0xff, 0xf3, 0xcf,
    0x1e, 0x0, 0xf3, 0xcf, 0x1e, 0x0, 0xf3, 0xcf,
    0x0, 0x0, 0x3, 0xcf, 0x7, 0xc0, 0x3, 0xcf,
    0x7, 0xc1, 0xe3, 0xcf, 0x7, 0x81, 0xe3, 0xcf,
    0x7, 0xff, 0xe3, 0xcf, 0x7, 0xff, 0xe3, 0xcf,
    0x7, 0x1, 0xe3, 0xcf, 0x7, 0x1, 0xe3, 0xcf,
    0xf, 0x1, 0xe3, 0xcf, 0xe, 0x1, 0xe3, 0xcf,
    0xf, 0x81, 0xe3, 0xcf, 0xc, 0xc1, 0xe3, 0xcf,
    0x18, 0xe1, 0xe3, 0xcf, 0x18, 0xf3, 0xc3, 0xcf,
    0x30, 0x7b, 0xc3, 0xcf, 0x20, 0x73, 0x83, 0xcf,
    0x60, 0x37, 0x83, 0xcf, 0x0, 0x27, 0x3, 0xcf,
    0x0, 0xe, 0x3, 0xcf, 0x0, 0x1c, 0x3, 0xcf,
    0x0, 0x18, 0x0, 0xf, 0x0, 0x30, 0x0, 0xf,
    0x0, 0x60, 0x0, 0xf, 0x0, 0xc0, 0x0, 0xf,
    0x1, 0x80, 0x0, 0xf, 0x3, 0x0, 0x0, 0x1f,
    0x6, 0x0, 0x0, 0x1e, 0x8, 0x0, 0x0, 0x7c,
    0x30, 0x0, 0x0, 0xf8, 0x60, 0x0, 0x3, 0x30,

    /* U+5240 "剀" */
    0x0, 0xe0, 0x0, 0x1e, 0x1, 0xc0, 0x0, 0x3d,
    0xc3, 0x87, 0x0, 0x7b, 0x87, 0xe, 0x0, 0xf7,
    0xe, 0x1c, 0x71, 0xee, 0x1c, 0x38, 0xe3, 0xdc,
    0x38, 0x71, 0xc7, 0xb8, 0x70, 0xe3, 0x8f, 0x70,
    0xe1, 0xc7, 0x1e, 0xe1, 0xc3, 0x8e, 0x3d, 0xff,
    0xff, 0x1c, 0x7b, 0xff, 0xfe, 0x38, 0xf7, 0x0,
    0x1c, 0x71, 0xee, 0x0, 0x38, 0xe3, 0xc0, 0x0,
    0x1, 0xc7, 0x80, 0x0, 0x3, 0x8f, 0x0, 0x7,
    0x87, 0x1e, 0xff, 0xff, 0xe, 0x3d, 0xff, 0xfe,
    0x1c, 0x78, 0x0, 0x3c, 0x38, 0xf0, 0x0, 0x78,
    0x71, 0xe0, 0x0, 0xf0, 0xe3, 0xc0, 0x1, 0xe1,
    0xc7, 0x80, 0x3, 0xc3, 0x8f, 0x0, 0x7, 0x87,
    0x1e, 0x78, 0xf, 0xe, 0x3c, 0xff, 0xfe, 0x1c,
    0x79, 0xff, 0xfc, 0x38, 0xf3, 0xc0, 0x78, 0x71,
    0xe7, 0x80, 0xf0, 0xe3, 0xcf, 0x0, 0x1, 0xc7,
    0x9e, 0x0, 0x3, 0x8f, 0x3c, 0x0, 0x7, 0x1e,
    0x78, 0x0, 0xe, 0x3c, 0xf0, 0x0, 0x1c, 0x79,
    0xe0, 0xc, 0x38, 0xf3, 0xc0, 0x60, 0x71, 0xe7,
    0x83, 0x80, 0x3, 0xcf, 0x7e, 0x0, 0x7, 0xbf,
    0xf0, 0x0, 0xf, 0x7f, 0x80, 0x0, 0x1e, 0xfc,
    0x0, 0x0, 0x3d, 0xc0, 0x0, 0x0, 0xf8, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x48, 0x0,

    /* U+5241 "剁" */
    0x7, 0x87, 0x80, 0xf, 0x7, 0x87, 0x80, 0xf,
    0x7, 0xff, 0x80, 0xf, 0x7, 0xff, 0x80, 0xf,
    0x7, 0x87, 0x80, 0xf, 0x7, 0x87, 0x80, 0xf,
    0x7, 0x87, 0x87, 0x8f, 0x7, 0x87, 0x87, 0x8f,
    0x7, 0x87, 0x87, 0x8f, 0x7, 0x7, 0x87, 0x8f,
    0x7, 0x7, 0x87, 0x8f, 0x7, 0x7, 0x87, 0x8f,
    0xe, 0x7, 0x87, 0x8f, 0xe, 0x7, 0x87, 0x8f,
    0xc, 0x7, 0x87, 0x8f, 0x18, 0x7, 0x87, 0x8f,
    0x18, 0x7, 0xf7, 0x8f, 0x30, 0x3, 0xf7, 0x8f,
    0x20, 0x0, 0x7, 0x8f, 0x40, 0xf0, 0x7, 0x8f,
    0x0, 0xf0, 0x7, 0x8f, 0x0, 0xf0, 0x7, 0x8f,
    0x0, 0xf0, 0x7, 0x8f, 0x7f, 0xff, 0xf7, 0x8f,
    0x7f, 0xff, 0xf7, 0x8f, 0x0, 0xf0, 0x7, 0x8f,
    0x1, 0xf0, 0x7, 0x8f, 0x1, 0xf0, 0x7, 0x8f,
    0x1, 0xfc, 0x7, 0x8f, 0x1, 0xf6, 0x7, 0x8f,
    0x3, 0xf7, 0x87, 0x8f, 0x3, 0xf3, 0xc7, 0x8f,
    0x7, 0xf3, 0xc7, 0x8f, 0x6, 0xf1, 0xc7, 0x8f,
    0x6, 0xf0, 0xc7, 0x8f, 0xc, 0xf0, 0x40, 0xf,
    0x8, 0xf0, 0x0, 0xf, 0x18, 0xf0, 0x0, 0xf,
    0x30, 0xf0, 0x0, 0xf, 0x20, 0xf0, 0x0, 0xf,
    0x40, 0xf0, 0x0, 0xf, 0x40, 0xf0, 0x0, 0xf,
    0x0, 0xf0, 0x0, 0x1f, 0x0, 0xf0, 0x0, 0x3e,
    0x0, 0xf0, 0x0, 0x7c, 0x0, 0xf0, 0x3, 0xf0,

    /* U+5242 "剂" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x30, 0x0, 0x3,
    0x80, 0xc, 0x0, 0x1, 0xc0, 0x7, 0x80, 0x0,
    0xe0, 0x3, 0x80, 0x0, 0x70, 0x0, 0xc0, 0x0,
    0x38, 0x0, 0x60, 0x7, 0x1c, 0x7f, 0xff, 0xf3,
    0x8e, 0x3f, 0xff, 0xf9, 0xc7, 0x0, 0x1, 0xe0,
    0xe3, 0x80, 0x1, 0xe0, 0x71, 0xc0, 0x80, 0xf0,
    0x38, 0xe0, 0x20, 0x78, 0x1c, 0x70, 0xc, 0x38,
    0xe, 0x38, 0x3, 0xbc, 0x7, 0x1c, 0x0, 0xfc,
    0x3, 0x8e, 0x0, 0x3e, 0x1, 0xc7, 0x0, 0xf,
    0x0, 0xe3, 0x80, 0xf, 0xc0, 0x71, 0xc0, 0xe,
    0xf8, 0x38, 0xe0, 0xe, 0x3f, 0x1c, 0x70, 0xe,
    0xf, 0x8e, 0x38, 0xe, 0x3, 0xc7, 0x1c, 0xc,
    0x0, 0xe3, 0x8e, 0x1c, 0x0, 0x31, 0xc7, 0x19,
    0xe1, 0xc8, 0xe3, 0x98, 0xf0, 0xe0, 0x71, 0xc0,
    0x78, 0x70, 0x38, 0xe0, 0x3c, 0x38, 0x1c, 0x70,
    0x1e, 0x1c, 0xe, 0x38, 0xf, 0xe, 0x7, 0x1c,
    0x7, 0x87, 0x3, 0x8e, 0x3, 0xc3, 0x81, 0xc7,
    0x1, 0xe1, 0xc0, 0xe3, 0x80, 0xf0, 0xe0, 0x71,
    0xc0, 0x78, 0x70, 0x38, 0xe0, 0x3c, 0x38, 0x1c,
    0x70, 0x1c, 0x1c, 0x0, 0x38, 0xe, 0xe, 0x0,
    0x1c, 0x6, 0x7, 0x0, 0xe, 0x7, 0x3, 0x80,
    0x7, 0x3, 0x1, 0xc0, 0x3, 0x83, 0x0, 0xe0,
    0x1, 0xc3, 0x0, 0x70, 0x1, 0xe3, 0x0, 0x38,
    0x1, 0xe3, 0x0, 0x1c, 0x3, 0xe0, 0x0, 0x0,
    0x6, 0x40,

    /* U+5243 "剃" */
    0x0, 0x1, 0x0, 0x0, 0x6, 0x1, 0x80, 0xf,
    0x3, 0x83, 0x80, 0xf, 0x3, 0xc3, 0x0, 0xf,
    0x1, 0xc7, 0x0, 0xf, 0x1, 0xc6, 0x0, 0xf,
    0x0, 0xce, 0x0, 0xf, 0x0, 0x4d, 0xe3, 0xcf,
    0x3f, 0xff, 0xe3, 0xcf, 0x3f, 0xff, 0xe3, 0xcf,
    0x0, 0x79, 0xe3, 0xcf, 0x0, 0x79, 0xe3, 0xcf,
    0x0, 0x79, 0xe3, 0xcf, 0x0, 0x79, 0xe3, 0xcf,
    0x3c, 0x79, 0xe3, 0xcf, 0x3c, 0x79, 0xe3, 0xcf,
    0x3f, 0xff, 0xe3, 0xcf, 0x3f, 0xff, 0xe3, 0xcf,
    0x3c, 0x79, 0xe3, 0xcf, 0x3c, 0x79, 0xe3, 0xcf,
    0x3c, 0x78, 0x3, 0xcf, 0x3c, 0x78, 0x3, 0xcf,
    0x3c, 0x78, 0x3, 0xcf, 0x3c, 0x78, 0xf3, 0xcf,
    0x3f, 0xff, 0xf3, 0xcf, 0x3f, 0xff, 0xf3, 0xcf,
    0x3c, 0xf8, 0xf3, 0xcf, 0x3c, 0xf8, 0xf3, 0xcf,
    0x3c, 0xf8, 0xf3, 0xcf, 0x1, 0xf8, 0xf3, 0xcf,
    0x1, 0xf8, 0xf3, 0xcf, 0x1, 0xf8, 0xf3, 0xcf,
    0x3, 0xf8, 0xf3, 0xcf, 0x3, 0xf8, 0xf3, 0xcf,
    0x7, 0x78, 0xf3, 0xcf, 0x6, 0x78, 0xf3, 0xcf,
    0xe, 0x78, 0xe0, 0xf, 0xc, 0x79, 0xe0, 0xf,
    0x18, 0x7b, 0xc0, 0xf, 0x18, 0x7f, 0x80, 0xf,
    0x30, 0x78, 0x0, 0xf, 0x60, 0x78, 0x0, 0xf,
    0x40, 0x78, 0x0, 0xf, 0x0, 0x78, 0x0, 0xf,
    0x0, 0x78, 0x0, 0x1e, 0x0, 0x78, 0x0, 0x7e,
    0x0, 0x78, 0x3, 0xf8,

    /* U+5244 "剄" */
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xfe, 0x3, 0xff, 0xff, 0xf8, 0xf, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xf3, 0xc7,
    0x1e, 0xe3, 0xcf, 0x1c, 0x73, 0x8f, 0x3c, 0x71,
    0xce, 0x3c, 0xf1, 0xc7, 0x38, 0xf3, 0x87, 0x18,
    0xe3, 0xce, 0x38, 0xe3, 0x8f, 0x30, 0xc3, 0xe,
    0x3c, 0x83, 0x8, 0x38, 0xf4, 0x18, 0x40, 0xe3,
    0xd0, 0x42, 0x3, 0x8f, 0x61, 0x84, 0xe, 0x3c,
    0xc7, 0x18, 0x38, 0xf3, 0x8e, 0x30, 0xe3, 0xcf,
    0x38, 0xe3, 0x8f, 0x1c, 0x73, 0xce, 0x3c, 0x71,
    0xc7, 0x38, 0xf1, 0xc6, 0x18, 0xe3, 0xc2, 0x0,
    0x3, 0x8f, 0x0, 0x0, 0xe, 0x3f, 0xff, 0xff,
    0x38, 0xff, 0xff, 0xfc, 0xe3, 0xc0, 0x78, 0x3,
    0x8f, 0x1, 0xe0, 0xe, 0x3c, 0x7, 0x80, 0x38,
    0xf0, 0x1e, 0x0, 0xe3, 0xc0, 0x78, 0x3, 0x8f,
    0x1, 0xe0, 0xe, 0x3c, 0x7, 0x80, 0x38, 0xf0,
    0x1e, 0x4, 0xe3, 0xc0, 0x78, 0x33, 0x8f, 0x1,
    0xe3, 0xe, 0x3c, 0x7, 0xb8, 0x38, 0xf8, 0x1f,
    0xc0, 0xe3, 0xdf, 0xfc, 0x0, 0xf, 0x7f, 0xc0,
    0x0, 0x3d, 0xfc, 0x0, 0x0, 0xf7, 0x80, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x0, 0x3b, 0x0,

    /* U+5247 "則" */
    0x0, 0x0, 0x0, 0x3c, 0xf0, 0x3c, 0x0, 0xf3,
    0xc0, 0xf0, 0x3, 0xcf, 0xff, 0xc0, 0xf, 0x3f,
    0xff, 0x0, 0x3c, 0xf0, 0x3c, 0x78, 0xf3, 0xc0,
    0xf1, 0xe3, 0xcf, 0x3, 0xc7, 0x8f, 0x3c, 0xf,
    0x1e, 0x3c, 0xf0, 0x3c, 0x78, 0xf3, 0xc0, 0xf1,
    0xe3, 0xcf, 0xfb, 0xc7, 0x8f, 0x3f, 0xef, 0x1e,
    0x3c, 0xf0, 0x3c, 0x78, 0xf3, 0xc0, 0xf1, 0xe3,
    0xcf, 0x3, 0xc7, 0x8f, 0x3c, 0xf, 0x1e, 0x3c,
    0xf0, 0x3c, 0x78, 0xf3, 0xc0, 0xf1, 0xe3, 0xcf,
    0x3, 0xc7, 0x8f, 0x3f, 0xef, 0x1e, 0x3c, 0xff,
    0xbc, 0x78, 0xf3, 0xc0, 0xf1, 0xe3, 0xcf, 0x3,
    0xc7, 0x8f, 0x3c, 0xf, 0x1e, 0x3c, 0xf0, 0x3c,
    0x78, 0xf3, 0xc0, 0xf1, 0xe3, 0xcf, 0x3, 0xc7,
    0x8f, 0x3f, 0xff, 0x1e, 0x3c, 0xff, 0xfc, 0x78,
    0xf3, 0xc0, 0xf1, 0xe3, 0xcf, 0xb, 0xc7, 0x8f,
    0x3c, 0x2f, 0x1e, 0x3c, 0x0, 0x80, 0x78, 0xf0,
    0x79, 0x1, 0xe3, 0xc1, 0xe4, 0x7, 0x8f, 0xf,
    0x18, 0x0, 0x3c, 0x3c, 0x70, 0x0, 0xf0, 0xf0,
    0xe0, 0x3, 0xc3, 0x83, 0xc0, 0xf, 0xc, 0xf,
    0x0, 0x3c, 0x70, 0x18, 0x0, 0xf1, 0x80, 0x60,
    0x3, 0xcc, 0x0, 0x80, 0x1c, 0x60, 0x2, 0x0,
    0xe1, 0x0, 0x4, 0xf, 0x0,

    /* U+5249 "剉" */
    0x0, 0xf0, 0x0, 0x3c, 0x3, 0xc0, 0x0, 0xf0,
    0xf, 0x0, 0x3, 0xc0, 0x3c, 0x0, 0xf, 0x0,
    0xf0, 0x0, 0x3c, 0xf3, 0xc7, 0x1c, 0xf3, 0xcf,
    0x1c, 0x73, 0xcf, 0x3c, 0x71, 0xcf, 0x3c, 0xf1,
    0xc7, 0x3c, 0xf3, 0xc7, 0x1c, 0xf3, 0x8f, 0x1c,
    0x73, 0xce, 0x3c, 0x71, 0xcf, 0x38, 0xf1, 0xc7,
    0x3c, 0xe3, 0xc7, 0x1c, 0xf3, 0xcf, 0x3c, 0x73,
    0xcf, 0xbc, 0xf9, 0xcf, 0x37, 0xf3, 0x7f, 0x3c,
    0xdf, 0xcd, 0xfc, 0xf6, 0x3f, 0x27, 0x73, 0xd8,
    0xbd, 0x89, 0xcf, 0x60, 0xf4, 0x27, 0x3d, 0x3,
    0xd0, 0x9c, 0xfc, 0xf, 0x80, 0x73, 0xc0, 0x3c,
    0x1, 0xcf, 0x0, 0xf0, 0x7, 0x3c, 0x3, 0xc0,
    0x1c, 0xf7, 0xff, 0xfe, 0x73, 0xdf, 0xff, 0xf9,
    0xcf, 0x0, 0xf0, 0x7, 0x3c, 0x3, 0xc0, 0x1c,
    0xf0, 0xf, 0x0, 0x73, 0xc0, 0x3c, 0x1, 0xcf,
    0x0, 0xf0, 0x7, 0x3c, 0x3, 0xc0, 0x1c, 0xf0,
    0xf, 0x2, 0x73, 0xc0, 0x3c, 0x31, 0xcf, 0x0,
    0xf7, 0x0, 0x3d, 0xc3, 0xf0, 0x0, 0xf7, 0xff,
    0x80, 0x3, 0xcf, 0xf0, 0x0, 0xf, 0x3f, 0x0,
    0x0, 0x3d, 0xe0, 0x0, 0x0, 0xf4, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3,
    0x40,

    /* U+524A "削" */
    0x1, 0xe0, 0x0, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x78, 0x0, 0x1e, 0x3, 0xc3, 0x0, 0xf8, 0x1e,
    0x18, 0x7, 0xe0, 0xf1, 0xc0, 0x3d, 0x87, 0x8c,
    0x1, 0xee, 0x3c, 0xe3, 0xcf, 0x79, 0xee, 0x1e,
    0x79, 0xcf, 0x60, 0xf3, 0xce, 0x7f, 0x7, 0x9e,
    0x23, 0xf0, 0x3c, 0xf1, 0x1f, 0x1, 0xe7, 0x80,
    0xf8, 0xf, 0x3c, 0x7, 0x80, 0x79, 0xef, 0x3d,
    0xe3, 0xcf, 0x7f, 0xff, 0x1e, 0x7b, 0xff, 0xf8,
    0xf3, 0xde, 0x3, 0xc7, 0x9e, 0xf0, 0x1e, 0x3c,
    0xf7, 0x80, 0xf1, 0xe7, 0xbc, 0x7, 0x8f, 0x3d,
    0xe0, 0x3c, 0x79, 0xef, 0xfd, 0xe3, 0xcf, 0x7f,
    0xef, 0x1e, 0x7b, 0xc0, 0x78, 0xf3, 0xde, 0x3,
    0xc7, 0x9e, 0xf0, 0x1e, 0x3c, 0xf7, 0x80, 0xf1,
    0xe7, 0xbc, 0x7, 0x8f, 0x3d, 0xe0, 0x3c, 0x79,
    0xef, 0xfd, 0xe3, 0xcf, 0x78, 0xf, 0x1e, 0x7b,
    0xc0, 0x78, 0xf3, 0xde, 0x3, 0xc7, 0x9e, 0xf0,
    0x1e, 0x3c, 0xf7, 0x80, 0xf0, 0x7, 0xbc, 0x7,
    0x80, 0x3d, 0xe0, 0x3c, 0x1, 0xef, 0x1, 0xe0,
    0xf, 0x78, 0xf, 0x0, 0x7b, 0xc0, 0x78, 0x3,
    0xde, 0x3, 0xc0, 0x1e, 0xf0, 0x3c, 0x1, 0xe7,
    0x83, 0xe0, 0x1f, 0x3c, 0x7c, 0x3, 0xe0, 0x0,
    0x0, 0x62, 0x0,

    /* U+524B "剋" */
    0x0, 0xf0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0x78,
    0x0, 0xf0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0x78,
    0x0, 0xf0, 0x0, 0x78, 0x0, 0xf0, 0x1e, 0x78,
    0x7f, 0xff, 0xde, 0x78, 0x7f, 0xff, 0xde, 0x78,
    0x0, 0xe0, 0x1e, 0x78, 0x0, 0xe0, 0x1e, 0x78,
    0x0, 0xc0, 0x1e, 0x78, 0x1, 0x80, 0x1e, 0x78,
    0x3d, 0x87, 0x1e, 0x78, 0x3d, 0x7, 0x1e, 0x78,
    0x3f, 0xff, 0x1e, 0x78, 0x3f, 0xff, 0x1e, 0x78,
    0x3c, 0x7, 0x1e, 0x78, 0x3c, 0x7, 0x1e, 0x78,
    0x3c, 0x7, 0x1e, 0x78, 0x3c, 0x7, 0x1e, 0x78,
    0x3c, 0x7, 0x1e, 0x78, 0x3c, 0x7, 0x1e, 0x78,
    0x3c, 0x7, 0x1e, 0x78, 0x3c, 0x7, 0x1e, 0x78,
    0x3f, 0xff, 0x1e, 0x78, 0x3f, 0xff, 0x1e, 0x78,
    0x3c, 0x7, 0x1e, 0x78, 0x3c, 0x7, 0x1e, 0x78,
    0xf, 0x9e, 0x1e, 0x78, 0xf, 0x9e, 0x1e, 0x78,
    0xf, 0x1e, 0x1e, 0x78, 0xf, 0x1e, 0x1e, 0x78,
    0xf, 0x1e, 0x1e, 0x7a, 0xf, 0x1e, 0x0, 0x7a,
    0xf, 0x1e, 0x0, 0x7a, 0xf, 0x1e, 0x0, 0x7a,
    0xe, 0x1e, 0x0, 0x72, 0xe, 0x1e, 0x0, 0x76,
    0xe, 0x1e, 0x1, 0xe6, 0xc, 0x1e, 0x7, 0x87,
    0x1c, 0x1e, 0x0, 0x7, 0x18, 0x1f, 0x0, 0xf,
    0x18, 0xf, 0xff, 0xff, 0x30, 0xf, 0xff, 0xff,
    0x60, 0x3, 0xff, 0xfe, 0x40, 0x0, 0x0, 0x0,

    /* U+524C "剌" */
    0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0xf0, 0x0, 0xf, 0x7f, 0xff, 0xf0, 0xf,
    0x7f, 0xff, 0xf7, 0x8f, 0x0, 0xf0, 0x7, 0x8f,
    0x0, 0xf0, 0x7, 0x8f, 0x0, 0xf0, 0x7, 0x8f,
    0x0, 0xf0, 0x7, 0x8f, 0x3c, 0xf1, 0xc7, 0x8f,
    0x3f, 0xff, 0xc7, 0x8f, 0x3f, 0xff, 0xc7, 0x8f,
    0x3c, 0xf1, 0xc7, 0x8f, 0x3c, 0xf1, 0xc7, 0x8f,
    0x3c, 0xf1, 0xc7, 0x8f, 0x3c, 0xf1, 0xc7, 0x8f,
    0x3c, 0xf1, 0xc7, 0x8f, 0x3c, 0xf1, 0xc7, 0x8f,
    0x3c, 0xf1, 0xc7, 0x8f, 0x3c, 0xf1, 0xc7, 0x8f,
    0x3f, 0xff, 0xc7, 0x8f, 0x3f, 0xff, 0xc7, 0x8f,
    0x3c, 0xf1, 0xc7, 0x8f, 0x3c, 0xf1, 0xc7, 0x8f,
    0x1, 0xf0, 0x7, 0x8f, 0x1, 0xf0, 0x7, 0x8f,
    0x1, 0xfc, 0x7, 0x8f, 0x3, 0xfe, 0x7, 0x8f,
    0x3, 0xf7, 0x7, 0x8f, 0x3, 0xf7, 0x87, 0x8f,
    0x6, 0xf3, 0xc7, 0x8f, 0x6, 0xf3, 0xc7, 0x8f,
    0xc, 0xf1, 0xc7, 0x8f, 0x18, 0xf1, 0xc0, 0xf,
    0x18, 0xf0, 0xc0, 0xf, 0x30, 0xf0, 0x0, 0xf,
    0x60, 0xf0, 0x0, 0xf, 0x60, 0xf0, 0x0, 0xf,
    0xc0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0, 0xf,
    0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0, 0x0, 0x7e,
    0x0, 0xf0, 0x1, 0xf8, 0x0, 0xf0, 0x7, 0x60,

    /* U+524D "前" */
    0x0, 0x40, 0x0, 0x80, 0x0, 0x30, 0x0, 0x60,
    0x0, 0xc, 0x0, 0x60, 0x0, 0x7, 0x0, 0x30,
    0x0, 0x3, 0xc0, 0x30, 0x0, 0x0, 0xf0, 0x18,
    0x0, 0x0, 0x70, 0x18, 0x0, 0x0, 0x18, 0xc,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf8, 0x3c,
    0x1, 0xe0, 0x7f, 0xfe, 0x0, 0xf0, 0x3f, 0xff,
    0x3c, 0x78, 0x1e, 0x7, 0x9e, 0x3c, 0xf, 0x3,
    0xcf, 0x1e, 0x7, 0x81, 0xe7, 0x8f, 0x3, 0xc0,
    0xf3, 0xc7, 0x81, 0xe0, 0x79, 0xe3, 0xc0, 0xf0,
    0x3c, 0xf1, 0xe0, 0x78, 0x1e, 0x78, 0xf0, 0x3f,
    0xef, 0x3c, 0x78, 0x1e, 0x7, 0x9e, 0x3c, 0xf,
    0x3, 0xcf, 0x1e, 0x7, 0x81, 0xe7, 0x8f, 0x3,
    0xc0, 0xf3, 0xc7, 0x81, 0xe0, 0x79, 0xe3, 0xc0,
    0xf0, 0x3c, 0xf1, 0xe0, 0x78, 0x1e, 0x78, 0xf0,
    0x3f, 0xcf, 0x3c, 0x78, 0x1f, 0xe7, 0x9e, 0x3c,
    0xf, 0x3, 0xcf, 0x1e, 0x7, 0x81, 0xe7, 0x8f,
    0x3, 0xc0, 0xf3, 0xc7, 0x81, 0xe0, 0x79, 0xe3,
    0xc0, 0xf0, 0x3c, 0x1, 0xe0, 0x78, 0x1e, 0x0,
    0xf0, 0x3c, 0xf, 0x0, 0x78, 0x1e, 0x7, 0x80,
    0x3c, 0xf, 0x3, 0xc0, 0x1e, 0x7, 0x81, 0xc0,
    0xf, 0x3, 0xc1, 0xe0, 0x7, 0x81, 0xe1, 0xe0,
    0x7, 0x80, 0xf3, 0xe0, 0x7, 0xc0, 0x0, 0x0,
    0xd, 0x80,

    /* U+5250 "剐" */
    0x38, 0xe, 0x0, 0x39, 0xc0, 0x70, 0x1, 0xcf,
    0xff, 0x80, 0xe, 0x7f, 0xfc, 0x0, 0x73, 0x80,
    0xe0, 0x3, 0x9c, 0x7, 0x7, 0x1c, 0xe0, 0x38,
    0x38, 0xe7, 0x1, 0xc1, 0xc7, 0x38, 0xe, 0xe,
    0x39, 0xc0, 0x70, 0x71, 0xce, 0x3, 0x83, 0x8e,
    0x70, 0x1c, 0x1c, 0x73, 0xff, 0xe0, 0xe3, 0x9f,
    0xff, 0x7, 0x1c, 0xe0, 0x38, 0x38, 0xe7, 0x79,
    0xc1, 0xc7, 0x3b, 0xc0, 0xe, 0x38, 0x1e, 0x0,
    0x71, 0xc0, 0xf0, 0x3, 0x8e, 0x7, 0x80, 0x1c,
    0x7e, 0x3c, 0x38, 0xe3, 0xf1, 0xe1, 0xc7, 0x1f,
    0xff, 0xfe, 0x38, 0xff, 0xff, 0xf1, 0xc7, 0xe3,
    0xc3, 0x8e, 0x3f, 0x1e, 0x1c, 0x71, 0xf8, 0xf0,
    0xe3, 0x8f, 0xc7, 0x87, 0x1c, 0x7e, 0x3c, 0x38,
    0xe3, 0xf1, 0xf1, 0xc7, 0x1f, 0x9d, 0xce, 0x38,
    0xfc, 0xef, 0x71, 0xc7, 0xe6, 0x3f, 0x8e, 0x3f,
    0x21, 0xdc, 0x71, 0xfb, 0xe, 0xe3, 0x8f, 0xd0,
    0x37, 0x1c, 0x7f, 0x80, 0xb8, 0xe3, 0xf8, 0x5,
    0xc7, 0x1f, 0x80, 0xe, 0x0, 0xfc, 0x0, 0x70,
    0x7, 0xe0, 0x3, 0x80, 0x3f, 0x0, 0x3c, 0x1,
    0xf8, 0x3, 0xe0, 0x1f, 0xc0, 0x3e, 0x1, 0xe0,
    0x6, 0xc0, 0x1e, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x30, 0x0,

    /* U+5251 "剑" */
    0x0, 0xf0, 0x0, 0x1e, 0x1, 0xe0, 0x0, 0x3c,
    0x7, 0xc0, 0x0, 0x78, 0xf, 0x40, 0x0, 0xf0,
    0x1c, 0xc0, 0x1, 0xe0, 0x38, 0xc1, 0xe3, 0xc0,
    0x60, 0xc3, 0xc7, 0x81, 0xc1, 0xc7, 0x8f, 0x3,
    0x1, 0xef, 0x1e, 0x6, 0x1, 0xde, 0x3c, 0x18,
    0x3, 0xbc, 0x78, 0x30, 0x3, 0x78, 0xf0, 0xc0,
    0x2, 0xf1, 0xe1, 0x80, 0x1, 0xe3, 0xc7, 0xff,
    0xe3, 0xc7, 0x9f, 0xff, 0xc7, 0x8f, 0x20, 0x0,
    0xf, 0x1e, 0xc0, 0x0, 0x1e, 0x3c, 0x2, 0x0,
    0x3c, 0x78, 0x4, 0x1c, 0x78, 0xf0, 0x8, 0x38,
    0xf1, 0xe1, 0x8, 0x71, 0xe3, 0xc2, 0x10, 0xe3,
    0xc7, 0x84, 0x21, 0xc7, 0x8f, 0xc, 0x63, 0x8f,
    0x1e, 0x18, 0xc6, 0x1e, 0x3c, 0x31, 0x8c, 0x3c,
    0x78, 0x73, 0x98, 0x78, 0xf0, 0xe7, 0x70, 0xf1,
    0xe1, 0xcc, 0xe1, 0xe3, 0xc3, 0xd1, 0x83, 0xc7,
    0x87, 0x83, 0x7, 0x8f, 0xf, 0x6, 0xf, 0x1e,
    0x1e, 0x18, 0x1e, 0x3c, 0x3c, 0x31, 0x3c, 0x78,
    0x70, 0x64, 0x78, 0xf0, 0x0, 0x98, 0xf1, 0xe0,
    0x3, 0xe0, 0x3, 0xc0, 0x3f, 0x0, 0x7, 0xbf,
    0xfc, 0x0, 0xf, 0x7f, 0xe0, 0x0, 0x1e, 0xff,
    0x0, 0x0, 0x3d, 0xf0, 0x0, 0x0, 0xf2, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x0, 0xc8, 0x0,

    /* U+5254 "剔" */
    0x1e, 0x3, 0xc0, 0x1e, 0x3f, 0xff, 0x80, 0x3c,
    0x7f, 0xff, 0x0, 0x78, 0xf0, 0x1e, 0x0, 0xf1,
    0xe0, 0x3c, 0x1, 0xe3, 0xc0, 0x78, 0x3, 0xc7,
    0x80, 0xf1, 0xe7, 0x8f, 0xfd, 0xe3, 0xcf, 0x1f,
    0xfb, 0xc7, 0x9e, 0x3c, 0x7, 0x8f, 0x3c, 0x78,
    0xf, 0x1e, 0x78, 0xf0, 0x1e, 0x3c, 0xf1, 0xe0,
    0x3c, 0x79, 0xe3, 0xc0, 0x78, 0xf3, 0xc7, 0xff,
    0xf1, 0xe7, 0x8f, 0xff, 0xe3, 0xcf, 0x1e, 0x3,
    0xc7, 0x9e, 0x3c, 0x7, 0x8f, 0x3c, 0x0, 0x0,
    0x1e, 0x78, 0xf0, 0x0, 0x3c, 0xf1, 0xe0, 0x1e,
    0x79, 0xe3, 0xff, 0xfc, 0xf3, 0xc7, 0xff, 0xf9,
    0xe7, 0x8e, 0x0, 0xf3, 0xcf, 0x1c, 0x1, 0xe7,
    0x9e, 0x7f, 0x73, 0xcf, 0x3c, 0xfc, 0xe7, 0x9e,
    0x79, 0xb9, 0xcf, 0x3c, 0xf3, 0x73, 0x9e, 0x79,
    0xec, 0xe7, 0x3c, 0xf3, 0xd1, 0x8c, 0x79, 0xe7,
    0x83, 0x38, 0xf3, 0xcf, 0xe, 0x71, 0xe7, 0x9e,
    0x18, 0xe3, 0xcf, 0x3c, 0x31, 0x87, 0x9e, 0x78,
    0xe7, 0xf, 0x0, 0xf1, 0x8c, 0x1e, 0x1, 0xe3,
    0x18, 0x3c, 0x3, 0xcc, 0x60, 0x78, 0x7, 0x90,
    0xc0, 0xf0, 0xf, 0x63, 0x1, 0xe0, 0x1e, 0x84,
    0x7, 0x80, 0x7c, 0x10, 0x1e, 0x0, 0xf0, 0x60,
    0xf8, 0x7, 0xc0, 0x7, 0xc0, 0x3e, 0x0,

    /* U+5256 "剖" */
    0x0, 0xc0, 0x0, 0x1e, 0x0, 0x60, 0x0, 0x1e,
    0x0, 0x78, 0x0, 0x1e, 0x0, 0x38, 0x0, 0x1e,
    0x0, 0x30, 0x0, 0x1e, 0x0, 0x10, 0x0, 0x1e,
    0x3f, 0xff, 0xcf, 0x1e, 0x3f, 0xff, 0xcf, 0x1e,
    0x0, 0x2, 0xf, 0x1e, 0x0, 0x3, 0xf, 0x1e,
    0x4, 0x3, 0xf, 0x1e, 0x6, 0x6, 0xf, 0x1e,
    0x7, 0x6, 0xf, 0x1e, 0x7, 0x86, 0xf, 0x1e,
    0x3, 0x8c, 0xf, 0x1e, 0x3, 0xc, 0xf, 0x1e,
    0x3, 0x8, 0xf, 0x1e, 0x1, 0x18, 0xf, 0x1e,
    0xff, 0xff, 0xef, 0x1e, 0xff, 0xff, 0xef, 0x1e,
    0x0, 0x0, 0xf, 0x1e, 0x0, 0x0, 0xf, 0x1e,
    0x0, 0x0, 0xf, 0x1e, 0x0, 0x0, 0xf, 0x1e,
    0x0, 0x7, 0xf, 0x1e, 0x1c, 0x7, 0xf, 0x1e,
    0x1f, 0xff, 0xf, 0x1e, 0x1f, 0xff, 0xf, 0x1e,
    0x1c, 0x7, 0xf, 0x1e, 0x1c, 0x7, 0xf, 0x1e,
    0x1c, 0x7, 0xf, 0x1e, 0x1c, 0x7, 0xf, 0x1e,
    0x1c, 0x7, 0xf, 0x1e, 0x1c, 0x7, 0xf, 0x1e,
    0x1c, 0x7, 0xf, 0x1e, 0x1c, 0x7, 0xf, 0x1e,
    0x1c, 0x7, 0xf, 0x1e, 0x1c, 0x7, 0x0, 0x1e,
    0x1c, 0x7, 0x0, 0x1e, 0x1c, 0x7, 0x0, 0x1e,
    0x1f, 0xff, 0x0, 0x1e, 0x1c, 0x7, 0x0, 0x1e,
    0x1c, 0x7, 0x0, 0x1e, 0x1c, 0x7, 0x0, 0x3c,
    0x1c, 0x7, 0x0, 0xf8, 0x1c, 0x0, 0x3, 0xf0,
    0x0, 0x0, 0xc, 0x80,

    /* U+525B "剛" */
    0x0, 0x1, 0xc0, 0x70, 0x0, 0xe, 0x3, 0xbf,
    0xff, 0xf0, 0x1d, 0xff, 0xff, 0x80, 0xee, 0x0,
    0x1c, 0xe7, 0x70, 0x2, 0xe7, 0x3b, 0x90, 0x37,
    0x39, 0xdc, 0xc1, 0xb9, 0xce, 0xe7, 0x19, 0xce,
    0x77, 0x1c, 0xce, 0x73, 0xb8, 0xe6, 0x73, 0x9d,
    0xc6, 0x63, 0x9c, 0xee, 0x13, 0x1c, 0xe7, 0x7f,
    0xff, 0xe7, 0x3b, 0xff, 0xff, 0x39, 0xdc, 0x18,
    0x39, 0xce, 0xe0, 0xc1, 0xce, 0x77, 0x6, 0xe,
    0x73, 0xbb, 0xb3, 0x73, 0x9d, 0xdd, 0x9b, 0x9c,
    0xee, 0xec, 0xdc, 0xe7, 0x77, 0x66, 0xe7, 0x3b,
    0xbb, 0x37, 0x39, 0xdd, 0xd9, 0xb9, 0xce, 0xee,
    0xcd, 0xce, 0x77, 0x76, 0x6e, 0x73, 0xbb, 0xb3,
    0x73, 0x9d, 0xdd, 0x9b, 0x9c, 0xee, 0xec, 0xdc,
    0xe7, 0x77, 0x66, 0xe7, 0x3b, 0xbb, 0x37, 0x39,
    0xdd, 0xd9, 0xb9, 0xce, 0xee, 0xcd, 0xce, 0x77,
    0x7f, 0xee, 0x73, 0xbb, 0xff, 0x73, 0x9d, 0xdc,
    0x1b, 0x9c, 0xee, 0xe0, 0xdc, 0x7, 0x77, 0x6,
    0xe0, 0x3b, 0x80, 0x7, 0x1, 0xdc, 0x0, 0x38,
    0xe, 0xe0, 0x1, 0xc0, 0x77, 0x0, 0xe, 0x3,
    0xb8, 0x0, 0x70, 0x1d, 0xc0, 0x7, 0x1, 0xce,
    0x0, 0xf0, 0x3c, 0x70, 0x8, 0x2, 0xc0,

    /* U+525C "剜" */
    0x0, 0x20, 0x0, 0x0, 0x0, 0x8, 0x0, 0x3,
    0xc0, 0x6, 0x0, 0x1, 0xe0, 0x3, 0x80, 0x0,
    0xf0, 0x0, 0xc7, 0x80, 0x79, 0xe0, 0x43, 0xc0,
    0x3c, 0xff, 0xff, 0xe0, 0x1e, 0x7f, 0xff, 0xf3,
    0xcf, 0x3c, 0x0, 0x79, 0xe7, 0x9e, 0x0, 0x3c,
    0xf3, 0xcf, 0x0, 0x1e, 0x79, 0xe7, 0x80, 0xc,
    0x3c, 0xf0, 0xf0, 0x0, 0x1e, 0x78, 0x78, 0x38,
    0xf, 0x3c, 0x3d, 0xdd, 0xe7, 0x9e, 0x1e, 0xee,
    0xf3, 0xcf, 0xf, 0xf7, 0xf9, 0xe7, 0x87, 0xfb,
    0xfc, 0xf3, 0xc3, 0xdd, 0xde, 0x79, 0xe1, 0xce,
    0xef, 0x3c, 0xf0, 0xe7, 0x77, 0x9e, 0x78, 0x73,
    0xbb, 0xcf, 0x3c, 0x31, 0xdd, 0xe7, 0x9e, 0x18,
    0xee, 0xf3, 0xcf, 0x1c, 0x77, 0x79, 0xe7, 0x8c,
    0x3b, 0xbc, 0xf3, 0xc7, 0x1d, 0xde, 0x79, 0xe2,
    0xce, 0xef, 0x3c, 0xf3, 0x7f, 0x77, 0x9e, 0x79,
    0xbf, 0x3b, 0xcf, 0x3c, 0x8f, 0x9d, 0xe7, 0x9e,
    0xc5, 0xce, 0xf3, 0xcf, 0x40, 0xe7, 0x71, 0xe7,
    0x80, 0xe3, 0xf8, 0xf3, 0xc0, 0x71, 0xf0, 0x79,
    0xe0, 0x30, 0xe0, 0x3c, 0xf0, 0x38, 0x70, 0x0,
    0x78, 0x38, 0x38, 0x20, 0x3c, 0x18, 0x1c, 0x20,
    0x1e, 0x18, 0xe, 0xe0, 0xf, 0x18, 0x7, 0xe0,
    0x7, 0x88, 0x1f, 0xe0, 0x3, 0xc8, 0x7, 0xe0,
    0x3, 0xe8, 0x3, 0xc0, 0x3, 0xe0, 0x1, 0x80,
    0x3, 0xe0, 0x0, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x4, 0x0,

    /* U+525E "剞" */
    0x1, 0xe0, 0x0, 0x1e, 0x3, 0xc0, 0x0, 0x3c,
    0x7, 0x80, 0x0, 0x78, 0xf, 0x0, 0x0, 0xf7,
    0xff, 0xfe, 0x1, 0xef, 0xff, 0xfc, 0x3, 0xc0,
    0x78, 0x1, 0xc7, 0x80, 0xf0, 0x3, 0x8f, 0x1,
    0xf0, 0x7, 0x1e, 0x7, 0x30, 0xe, 0x3c, 0xc,
    0x70, 0x1c, 0x78, 0x30, 0x7e, 0x38, 0xf0, 0xe0,
    0xfc, 0x71, 0xe3, 0x80, 0xf8, 0xe3, 0xc4, 0x0,
    0xf1, 0xc7, 0xb0, 0x0, 0x63, 0x8f, 0x0, 0x0,
    0x47, 0x1f, 0xff, 0xff, 0xee, 0x3f, 0xff, 0xff,
    0xdc, 0x78, 0x0, 0x3c, 0x38, 0xf0, 0x0, 0x78,
    0x71, 0xe0, 0x0, 0xf0, 0xe3, 0xcf, 0x3d, 0xe1,
    0xc7, 0x9e, 0x7b, 0xc3, 0x8f, 0x3f, 0xf7, 0x87,
    0x1e, 0x79, 0xef, 0xe, 0x3c, 0xf3, 0xde, 0x1c,
    0x79, 0xe7, 0xbc, 0x38, 0xf3, 0xcf, 0x78, 0x71,
    0xe7, 0x9e, 0xf0, 0xe3, 0xcf, 0x3d, 0xe1, 0xc7,
    0x9e, 0x7b, 0xc3, 0x8f, 0x3c, 0xf7, 0x87, 0x1e,
    0x7f, 0xef, 0xe, 0x3c, 0xff, 0xde, 0x1c, 0x79,
    0xe7, 0xbc, 0x38, 0xf3, 0xcf, 0x78, 0x1, 0xe7,
    0x9e, 0xf0, 0x3, 0xc0, 0x1, 0xe0, 0x7, 0x80,
    0x3, 0xc0, 0xf, 0x0, 0x7, 0x80, 0x1e, 0x0,
    0xf, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0xf8, 0x1,
    0xf0, 0x3, 0xe0, 0xc, 0xc0, 0xf, 0x80, 0x0,
    0x0, 0x6c, 0x0,

    /* U+5261 "剡" */
    0x0, 0x70, 0x0, 0x1e, 0x0, 0xe0, 0x0, 0x3c,
    0x1, 0xc0, 0x0, 0x79, 0x3, 0x81, 0x80, 0xf1,
    0x7, 0x6, 0x1, 0xe3, 0xe, 0xc, 0x3, 0xc7,
    0x1c, 0x31, 0xc7, 0x8e, 0x38, 0x63, 0x8f, 0x1e,
    0xf1, 0x87, 0x1e, 0x1d, 0xe3, 0xe, 0x3c, 0x3b,
    0xec, 0x1c, 0x78, 0x67, 0xc0, 0x38, 0xf0, 0x4f,
    0x40, 0x71, 0xe0, 0x1c, 0xc0, 0xe3, 0xc0, 0x79,
    0xc1, 0xc7, 0x80, 0xe1, 0xc3, 0x8f, 0x3, 0x83,
    0xf7, 0x1e, 0x6, 0x3, 0xce, 0x3c, 0x18, 0x7,
    0x9c, 0x78, 0x67, 0x87, 0x38, 0xf1, 0x8f, 0x6,
    0x71, 0xe6, 0x1e, 0x4, 0xe3, 0xc0, 0x3c, 0x1,
    0xc7, 0x90, 0x78, 0x13, 0x8f, 0x30, 0xf0, 0x67,
    0x1e, 0x21, 0xe0, 0xce, 0x3c, 0x63, 0xc3, 0x1c,
    0x78, 0xe7, 0x84, 0x38, 0xf1, 0xef, 0x18, 0x71,
    0xe3, 0xde, 0x20, 0xe3, 0xc7, 0xbc, 0xc1, 0xc7,
    0x86, 0x7d, 0x3, 0x8f, 0xc, 0xf8, 0x7, 0x1e,
    0x11, 0xf8, 0xe, 0x3c, 0x3, 0xb0, 0x1c, 0x78,
    0xf, 0x30, 0x38, 0xf0, 0x1c, 0x70, 0x1, 0xe0,
    0x38, 0xe0, 0x3, 0xc0, 0xe0, 0xf0, 0x7, 0x81,
    0x81, 0xf0, 0xf, 0x6, 0x3, 0xf0, 0x1e, 0x18,
    0x3, 0xe0, 0x3c, 0x60, 0x7, 0x80, 0xf8, 0xc0,
    0x7, 0x3, 0xe3, 0x0, 0x6, 0xf, 0x8c, 0x0,
    0x4, 0x64, 0x0,

    /* U+5265 "剥" */
    0x0, 0x3, 0x80, 0x1e, 0x0, 0x7, 0x0, 0x3d,
    0xff, 0xfe, 0x0, 0x7b, 0xff, 0xfc, 0x0, 0xf0,
    0x0, 0x38, 0x1, 0xe0, 0x0, 0x70, 0x3, 0xc0,
    0x0, 0xe3, 0xc7, 0x80, 0x1, 0xc7, 0x8f, 0x0,
    0x3, 0x8f, 0x1e, 0x7f, 0xff, 0x1e, 0x3c, 0xff,
    0xfe, 0x3c, 0x78, 0x0, 0x1c, 0x78, 0xf0, 0x0,
    0x38, 0xf1, 0xe0, 0x0, 0xe1, 0xe3, 0xc0, 0x1,
    0xc3, 0xc7, 0x80, 0x2, 0x7, 0x8f, 0xff, 0xff,
    0xef, 0x1f, 0xff, 0xff, 0xde, 0x3c, 0x7, 0x80,
    0x3c, 0x78, 0xf, 0x0, 0x78, 0xf4, 0x1e, 0x0,
    0xf1, 0xe4, 0x3c, 0x11, 0xe3, 0xcc, 0x78, 0x73,
    0xc7, 0x98, 0xf0, 0xc7, 0x8f, 0x39, 0xe3, 0xf,
    0x1e, 0x7b, 0xc6, 0x1e, 0x3c, 0x67, 0xd8, 0x3c,
    0x78, 0xcf, 0xa0, 0x78, 0xf1, 0x1f, 0xc0, 0xf1,
    0xe0, 0x3d, 0x81, 0xe3, 0xc0, 0xfb, 0x3, 0xc7,
    0x83, 0xf7, 0x7, 0x8f, 0x1d, 0xef, 0xf, 0x1f,
    0xfb, 0xcf, 0x1e, 0x3f, 0xe7, 0x9f, 0x3c, 0x7f,
    0x8f, 0x1e, 0x0, 0xfe, 0x1e, 0x3c, 0x1, 0xf8,
    0x3c, 0x38, 0x3, 0xc0, 0x78, 0x30, 0x7, 0x80,
    0xf0, 0x0, 0xf, 0x1, 0xe0, 0x0, 0x1e, 0x7,
    0x80, 0x0, 0x7c, 0x1e, 0x0, 0x1, 0xf0, 0xf8,
    0x0, 0x7, 0xc7, 0xc0, 0x0, 0x3f, 0x0, 0x0,
    0x1, 0x90, 0x0,

    /* U+5267 "剧" */
    0x1e, 0x0, 0xf0, 0x7, 0x8f, 0x0, 0x78, 0x3,
    0xc7, 0xff, 0xfc, 0x1, 0xe3, 0xff, 0xfe, 0x0,
    0xf1, 0xe0, 0xf, 0x0, 0x78, 0xf0, 0x7, 0x80,
    0x3c, 0x78, 0x3, 0xcf, 0x1e, 0x3c, 0x1, 0xe7,
    0x8f, 0x1e, 0x0, 0xf3, 0xc7, 0x8f, 0xff, 0xf9,
    0xe3, 0xc7, 0xff, 0xfc, 0xf1, 0xe3, 0xc0, 0x1e,
    0x78, 0xf1, 0xe0, 0x0, 0x3c, 0x78, 0xf0, 0x0,
    0x1e, 0x3c, 0x78, 0x3c, 0xf, 0x1e, 0x3c, 0x1e,
    0x7, 0x8f, 0x1e, 0xf, 0x3, 0xc7, 0x8f, 0x7,
    0x81, 0xe3, 0xc7, 0x83, 0xc0, 0xf1, 0xe3, 0xff,
    0xff, 0x78, 0xf1, 0xff, 0xff, 0xbc, 0x78, 0xf8,
    0x78, 0x1e, 0x3c, 0x7c, 0x3c, 0xf, 0x1e, 0x3e,
    0x1e, 0x7, 0x8f, 0x1f, 0xe, 0x3, 0xc7, 0x8f,
    0x87, 0x1, 0xe3, 0xc7, 0xc7, 0x0, 0xf1, 0xe3,
    0xfe, 0x1c, 0x78, 0xf1, 0xfe, 0xe, 0x3c, 0x78,
    0xff, 0xff, 0x1e, 0x3c, 0x7f, 0xff, 0x8f, 0x1e,
    0x3f, 0xc1, 0xc7, 0x8f, 0x1f, 0xe0, 0xe3, 0xc7,
    0x8e, 0xf0, 0x71, 0xe3, 0xc7, 0x78, 0x38, 0xf1,
    0xe3, 0xbc, 0x1c, 0x0, 0xf1, 0x9e, 0xe, 0x0,
    0x79, 0xcf, 0x7, 0x0, 0x3c, 0xe7, 0x83, 0x80,
    0x1e, 0x63, 0xc1, 0xc0, 0xf, 0x31, 0xff, 0xe0,
    0x7, 0xb0, 0xf0, 0x70, 0x3, 0xd0, 0x78, 0x38,
    0x3, 0xd8, 0x3c, 0x1c, 0x3, 0xc0, 0x1e, 0xe,
    0x7, 0xc0, 0x0, 0x0, 0x3d, 0x80,

    /* U+5269 "剩" */
    0x0, 0x1, 0x80, 0xf, 0x0, 0x7, 0xc0, 0xf,
    0x0, 0x3f, 0xe0, 0xf, 0x7, 0xff, 0xc0, 0xf,
    0x27, 0xf8, 0x0, 0xf, 0x0, 0x78, 0x0, 0xf,
    0x0, 0x78, 0x0, 0xf, 0x0, 0x78, 0x3, 0xcf,
    0x0, 0x78, 0x3, 0xcf, 0x7f, 0xff, 0xfb, 0xcf,
    0x7f, 0xff, 0xfb, 0xcf, 0x0, 0x78, 0x3, 0xcf,
    0x0, 0x78, 0x3, 0xcf, 0x0, 0x78, 0x3, 0xcf,
    0xe, 0x7b, 0x83, 0xcf, 0xe, 0x7b, 0x9b, 0xcf,
    0xe, 0x7b, 0xb3, 0xcf, 0xfe, 0x7b, 0xe3, 0xcf,
    0xfe, 0x7b, 0xc3, 0xcf, 0xe, 0x7b, 0x93, 0xcf,
    0xe, 0x7b, 0x93, 0xcf, 0xe, 0x7b, 0x93, 0xcf,
    0x1e, 0x7b, 0x93, 0xcf, 0xfe, 0x7b, 0x9b, 0xcf,
    0xee, 0x7b, 0xfb, 0xcf, 0xce, 0x7b, 0xfb, 0xcf,
    0x8e, 0x7b, 0xf3, 0xcf, 0x3, 0xf8, 0x3, 0xcf,
    0x3, 0xfc, 0x3, 0xcf, 0x3, 0xfe, 0x3, 0xcf,
    0x7, 0xff, 0x3, 0xcf, 0x7, 0x7b, 0x83, 0xcf,
    0x7, 0x7b, 0xe3, 0xcf, 0xe, 0x79, 0xe3, 0xcf,
    0xe, 0x78, 0xe3, 0xcf, 0xc, 0x78, 0xc3, 0xcf,
    0x1c, 0x78, 0x43, 0xcf, 0x18, 0x78, 0x0, 0xf,
    0x10, 0x78, 0x0, 0xf, 0x30, 0x78, 0x0, 0xf,
    0x20, 0x78, 0x0, 0xf, 0x40, 0x78, 0x0, 0x1e,
    0xc0, 0x78, 0x0, 0x3e, 0x0, 0x78, 0x0, 0x7c,
    0x0, 0x78, 0x1, 0xf8, 0x0, 0x78, 0x7, 0xe0,

    /* U+526A "剪" */
    0x0, 0x0, 0x2, 0x0, 0x0, 0xc0, 0x3, 0x0,
    0x0, 0x70, 0x6, 0x0, 0x0, 0x3c, 0xc, 0x0,
    0x0, 0x3c, 0xc, 0x0, 0x0, 0x1c, 0x18, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x38,
    0x1e, 0x7, 0x80, 0x38, 0x1e, 0x7, 0x8e, 0x38,
    0x1f, 0xff, 0x8e, 0x38, 0x1f, 0xff, 0x8e, 0x38,
    0x1e, 0x7, 0x8e, 0x38, 0x1e, 0x7, 0x8e, 0x38,
    0x1e, 0x7, 0x8e, 0x38, 0x1f, 0xf7, 0x8e, 0x38,
    0x1f, 0xf7, 0x8e, 0x38, 0x1e, 0x7, 0x8e, 0x38,
    0x1e, 0x7, 0x8e, 0x38, 0x1e, 0x7, 0x8e, 0x38,
    0x1f, 0xf7, 0x8e, 0x38, 0x1f, 0xf7, 0x8e, 0x38,
    0x1e, 0x7, 0x8e, 0x38, 0x1e, 0x7, 0x8e, 0x38,
    0x1e, 0x7, 0x80, 0x38, 0x1e, 0x7, 0x80, 0x78,
    0x1e, 0xf, 0x0, 0xf0, 0x1e, 0x3e, 0x7, 0xc0,
    0x0, 0x48, 0x0, 0x0, 0x0, 0x0, 0x0, 0x78,
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x78,
    0x0, 0x3c, 0x0, 0x78, 0x0, 0x3c, 0x0, 0x78,
    0x0, 0x38, 0x0, 0x78, 0x0, 0x38, 0x0, 0x78,
    0x0, 0x70, 0x0, 0x78, 0x0, 0x70, 0x0, 0x78,
    0x0, 0xe0, 0x0, 0x78, 0x1, 0x80, 0x0, 0x78,
    0x7, 0x0, 0x0, 0xf0, 0xc, 0x0, 0x3, 0xe0,
    0x38, 0x0, 0xe, 0x80,

    /* U+526E "剮" */
    0x38, 0xf, 0x0, 0x79, 0xff, 0xf8, 0x3, 0xcf,
    0xff, 0xc0, 0x1e, 0x70, 0x1e, 0x1c, 0xf3, 0x80,
    0xf0, 0xe7, 0x9c, 0x7, 0x87, 0x3c, 0xe3, 0x3c,
    0x39, 0xe7, 0x19, 0xe1, 0xcf, 0x3f, 0xcf, 0xe,
    0x79, 0xfe, 0x78, 0x73, 0xce, 0x33, 0xc3, 0x9e,
    0x71, 0x9e, 0x1c, 0xf3, 0x8c, 0xf0, 0xe7, 0x9c,
    0x67, 0x87, 0x3c, 0xe3, 0x3c, 0x39, 0xe7, 0x19,
    0xe1, 0xcf, 0x38, 0xcf, 0xe, 0x7f, 0xc6, 0x7e,
    0x73, 0xff, 0xff, 0xf3, 0x9f, 0xff, 0xff, 0x9c,
    0xfe, 0x0, 0x1c, 0xe7, 0xf0, 0x0, 0xe7, 0x3f,
    0x80, 0x7, 0x39, 0xfc, 0xe7, 0x39, 0xcf, 0xe7,
    0x39, 0xce, 0x7f, 0x3f, 0xce, 0x73, 0xf9, 0xfe,
    0x73, 0x9f, 0xce, 0x73, 0x9c, 0xfe, 0x73, 0x9c,
    0xe7, 0xf3, 0x9c, 0xe7, 0x3f, 0x9c, 0xe7, 0x39,
    0xfc, 0xe7, 0x39, 0xcf, 0xe7, 0x39, 0xce, 0x7f,
    0x3f, 0xce, 0x73, 0xf9, 0xfe, 0x73, 0x9f, 0xce,
    0x73, 0x9c, 0xfe, 0x73, 0x9c, 0xe7, 0xf3, 0x9c,
    0xe0, 0x3f, 0x80, 0x7, 0x1, 0xfc, 0x0, 0x38,
    0xf, 0xe0, 0x1, 0xc0, 0x7f, 0x0, 0xe, 0x7,
    0xb8, 0x0, 0xe0, 0x79, 0xc0, 0x1e, 0x7, 0x8e,
    0x3, 0x40, 0xf0, 0x0,

    /* U+526F "副" */
    0x0, 0x0, 0x0, 0x38, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xf0, 0xf, 0xff, 0xff, 0x80, 0x70, 0x0,
    0x0, 0x3, 0x80, 0x0, 0x0, 0x1c, 0x0, 0x0,
    0x38, 0xe7, 0x0, 0xe1, 0xc7, 0x3f, 0xff, 0xe,
    0x39, 0xff, 0xf8, 0x71, 0xce, 0x1, 0xc3, 0x8e,
    0x70, 0xe, 0x1c, 0x73, 0x80, 0x70, 0xe3, 0x9c,
    0x3, 0x87, 0x1c, 0xe0, 0x1c, 0x38, 0xe7, 0x0,
    0xe1, 0xc7, 0x38, 0x7, 0xe, 0x39, 0xff, 0xf8,
    0x71, 0xcf, 0xff, 0xc3, 0x8e, 0x70, 0xe, 0x1c,
    0x73, 0x80, 0x70, 0xe3, 0x80, 0x0, 0x7, 0x1c,
    0x0, 0x0, 0x38, 0xfe, 0x0, 0x71, 0xc7, 0xff,
    0xff, 0x8e, 0x3f, 0xff, 0xfc, 0x71, 0xfc, 0x78,
    0xe3, 0x8f, 0xe3, 0xc7, 0x1c, 0x7f, 0x1e, 0x38,
    0xe3, 0xf8, 0xf1, 0xc7, 0x1f, 0xc7, 0x8e, 0x38,
    0xfe, 0x3c, 0x71, 0xc7, 0xff, 0xff, 0x8e, 0x3f,
    0xff, 0xfc, 0x71, 0xfc, 0x78, 0xe3, 0x8f, 0xe3,
    0xc7, 0x0, 0x7f, 0x1e, 0x38, 0x3, 0xf8, 0xf1,
    0xc0, 0x1f, 0xc7, 0x8e, 0x0, 0xfe, 0x3c, 0x70,
    0x7, 0xf1, 0xe3, 0x80, 0x3f, 0xff, 0xfc, 0x1,
    0xff, 0xff, 0xe0, 0x1d, 0xe0, 0x7, 0x1, 0xef,
    0x0, 0x38, 0x1c, 0x78, 0x1, 0xc3, 0xc0, 0x0,
    0x0, 0x24, 0x0,

    /* U+5272 "割" */
    0x0, 0x80, 0x0, 0x0, 0x3, 0x0, 0x0, 0x70,
    0x7, 0x0, 0x1, 0xc0, 0x1c, 0x0, 0x7, 0x78,
    0x30, 0x70, 0x1d, 0xff, 0xff, 0xc0, 0x77, 0xff,
    0xff, 0x1, 0xde, 0x0, 0x1d, 0xc7, 0x78, 0x0,
    0x77, 0x1d, 0xe3, 0xc1, 0xdc, 0x77, 0x8f, 0x7,
    0x71, 0xc0, 0x3c, 0x11, 0xc7, 0x0, 0xf0, 0x87,
    0x1c, 0xff, 0xff, 0x1c, 0x73, 0xff, 0xfc, 0x71,
    0xc0, 0x3c, 0x1, 0xc7, 0x0, 0xf0, 0x7, 0x1c,
    0x3, 0xc0, 0x1c, 0x73, 0xff, 0xfc, 0x71, 0xcf,
    0xff, 0xf1, 0xc7, 0x0, 0xf0, 0x7, 0x1c, 0x3,
    0xc0, 0x1c, 0x70, 0xf, 0x0, 0x71, 0xc0, 0x3c,
    0x1, 0xc7, 0xff, 0xff, 0xe7, 0x1c, 0x3, 0xc0,
    0x1c, 0x70, 0xf, 0x0, 0x71, 0xc0, 0x3c, 0x1,
    0xc7, 0x0, 0xf0, 0x7, 0x1c, 0x0, 0x0, 0x1c,
    0x70, 0x0, 0x0, 0x71, 0xcf, 0x0, 0x71, 0xc7,
    0x3f, 0xff, 0xc7, 0x1c, 0xff, 0xff, 0x1c, 0x73,
    0xc0, 0x1c, 0x71, 0xcf, 0x0, 0x71, 0xc7, 0x3c,
    0x1, 0xc7, 0x1c, 0xf0, 0x7, 0x1c, 0x73, 0xc0,
    0x1c, 0x71, 0xcf, 0x0, 0x70, 0x7, 0x3c, 0x1,
    0xc0, 0x1c, 0xff, 0xff, 0x0, 0x73, 0xff, 0xfc,
    0x1, 0xcf, 0x0, 0x70, 0xe, 0x3c, 0x1, 0xc0,
    0x70, 0xf0, 0x7, 0x7, 0x80, 0x0, 0x0, 0x78,
    0x0,

    /* U+5274 "剴" */
    0x1, 0xe0, 0x0, 0x3c, 0x7, 0x80, 0x0, 0xf7,
    0x9e, 0x38, 0x3, 0xde, 0x78, 0xe0, 0xf, 0x79,
    0xe3, 0x8e, 0x3d, 0xe7, 0x8e, 0x38, 0xf7, 0x9e,
    0x38, 0xe3, 0xde, 0x78, 0xe3, 0x8f, 0x79, 0xe3,
    0x8e, 0x3d, 0xe7, 0x8e, 0x38, 0xf7, 0xff, 0xf8,
    0xe3, 0xdf, 0xff, 0xe3, 0x8f, 0x78, 0x3, 0x8e,
    0x3d, 0xe0, 0xe, 0x38, 0xf0, 0x0, 0x0, 0xe3,
    0xc0, 0x0, 0x3, 0x8f, 0xff, 0xff, 0xce, 0x3c,
    0x0, 0x0, 0x38, 0xf0, 0x0, 0x0, 0xe3, 0xce,
    0x1, 0xc3, 0x8f, 0x38, 0x7, 0xe, 0x3c, 0xff,
    0xfc, 0x38, 0xf3, 0x80, 0x70, 0xe3, 0xce, 0x1,
    0xc3, 0x8f, 0x38, 0x7, 0xe, 0x3c, 0xe0, 0x1c,
    0x38, 0xf3, 0x80, 0x70, 0xe3, 0xce, 0x1, 0xc3,
    0x8f, 0x3f, 0xff, 0xe, 0x3c, 0xe0, 0x1c, 0x38,
    0xf3, 0x80, 0x70, 0xe3, 0xc4, 0x2, 0x3, 0x8f,
    0x8, 0xc, 0xe, 0x3c, 0x30, 0x20, 0x38, 0xf0,
    0xe1, 0x84, 0xe3, 0xc3, 0x84, 0x63, 0x8f, 0x6,
    0x36, 0x0, 0x3c, 0x19, 0xe0, 0x0, 0xff, 0xfe,
    0x0, 0x3, 0xdf, 0xe0, 0x0, 0xf, 0x7c, 0x0,
    0x0, 0x3b, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0xe, 0x0, 0x0, 0x0, 0xf0,

    /* U+5275 "創" */
    0x0, 0xf8, 0x0, 0x1e, 0x1, 0xf0, 0x0, 0x3c,
    0x3, 0xe0, 0x0, 0x78, 0x7, 0xe0, 0x0, 0xf0,
    0x1e, 0x60, 0x1, 0xe0, 0x3c, 0xe0, 0xf3, 0xc0,
    0x70, 0xe1, 0xe7, 0x80, 0xe1, 0xf3, 0xcf, 0x3,
    0xe1, 0xf7, 0x9e, 0x7, 0x63, 0xef, 0x3c, 0x1c,
    0xe3, 0x9e, 0x78, 0x31, 0xc3, 0x3c, 0xf0, 0xc1,
    0x82, 0x79, 0xe3, 0xe2, 0x3e, 0xf3, 0xc7, 0xc0,
    0x79, 0xe7, 0x97, 0xff, 0xf3, 0xcf, 0x4f, 0xff,
    0xe7, 0x9e, 0x1e, 0x3, 0xcf, 0x3c, 0x3c, 0x7,
    0x9e, 0x78, 0x78, 0xf, 0x3c, 0xf0, 0xff, 0x9e,
    0x79, 0xe1, 0xff, 0x3c, 0xf3, 0xc3, 0xc0, 0x79,
    0xe7, 0x87, 0x80, 0xf3, 0xcf, 0xf, 0x1, 0xe7,
    0x9e, 0x1e, 0x3, 0xcf, 0x3c, 0x3f, 0xff, 0x9e,
    0x78, 0x7f, 0xff, 0x3c, 0xf0, 0xf0, 0x1e, 0x79,
    0xe1, 0xe0, 0x0, 0xf3, 0xc3, 0xf0, 0x79, 0xe7,
    0x87, 0xff, 0xf3, 0xcf, 0xf, 0xff, 0xe7, 0x9e,
    0x1f, 0x83, 0xcf, 0x3c, 0x37, 0x7, 0x9e, 0x78,
    0x6e, 0xf, 0x3c, 0xf1, 0x9c, 0x1e, 0x1, 0xe3,
    0x38, 0x3c, 0x3, 0xc6, 0x70, 0x78, 0x7, 0x98,
    0xff, 0xf0, 0xf, 0x21, 0xff, 0xe0, 0x1e, 0xc3,
    0x83, 0xc0, 0x3d, 0x7, 0x7, 0x80, 0xf0, 0xe,
    0xf, 0x7, 0x80, 0x0, 0x0, 0x34, 0x0,

    /* U+5277 "剷" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0x0, 0x70,
    0x3, 0x0, 0x1, 0xc0, 0xf, 0x0, 0x7, 0x0,
    0x3c, 0x0, 0x1c, 0x0, 0x70, 0x0, 0x70, 0x1,
    0x80, 0x1, 0xc0, 0x2, 0x1, 0xe7, 0x7f, 0xff,
    0xf7, 0x9d, 0xff, 0xff, 0xde, 0x70, 0x10, 0xe,
    0x79, 0xc0, 0x60, 0x31, 0xe7, 0x0, 0xc1, 0xc7,
    0x9c, 0x3, 0x86, 0x1e, 0x71, 0xc7, 0x38, 0x79,
    0xc7, 0x1c, 0xc1, 0xe7, 0x1c, 0x63, 0x7, 0x9c,
    0x71, 0x18, 0x1e, 0x71, 0xff, 0xff, 0x79, 0xc7,
    0x0, 0x1, 0xe7, 0x1c, 0x0, 0x7, 0x9c, 0x70,
    0x3c, 0x1e, 0x71, 0xce, 0xf0, 0x79, 0xc7, 0x3b,
    0xc1, 0xe7, 0x1c, 0xef, 0x7, 0x9c, 0x73, 0xbc,
    0x1e, 0x71, 0xcf, 0xff, 0x79, 0xc7, 0x7f, 0xfd,
    0xe7, 0x1d, 0xcf, 0x7, 0x9c, 0x76, 0x3c, 0x1e,
    0x71, 0xd8, 0xf0, 0x79, 0xc7, 0x43, 0xc1, 0xe7,
    0x1f, 0xf, 0x7, 0x9c, 0x7b, 0xff, 0xde, 0x73,
    0xc0, 0xf0, 0x79, 0xce, 0x3, 0xc1, 0xe7, 0x38,
    0xf, 0x7, 0x9c, 0xe0, 0x3c, 0x0, 0x73, 0x80,
    0xf1, 0x81, 0xcc, 0x3, 0xd8, 0x7, 0x30, 0xf,
    0xc0, 0x1d, 0x9f, 0xfc, 0x0, 0x76, 0x3f, 0xc0,
    0x1, 0xd0, 0x7c, 0x0, 0x7, 0x43, 0x80, 0x0,
    0x3a, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x3e,
    0x0,

    /* U+527D "剽" */
    0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xf0, 0x1d,
    0xff, 0xff, 0xe0, 0x38, 0xc, 0x60, 0x0, 0x70,
    0x18, 0xc0, 0x0, 0xe0, 0x31, 0x80, 0x1, 0xc0,
    0x63, 0x0, 0xe3, 0xbc, 0xc6, 0x79, 0xc7, 0x79,
    0x8c, 0xf3, 0x8e, 0xff, 0xff, 0xe7, 0x1d, 0xe6,
    0x33, 0xce, 0x3b, 0xcc, 0x67, 0x9c, 0x77, 0x98,
    0xcf, 0x38, 0xef, 0x31, 0x9e, 0x71, 0xde, 0x63,
    0x3c, 0xe3, 0xbc, 0xc6, 0x79, 0xc7, 0x79, 0x8c,
    0xf3, 0x8e, 0xff, 0xff, 0xe7, 0x1d, 0xff, 0xff,
    0xce, 0x3b, 0xc0, 0x7, 0x9c, 0x70, 0x0, 0x0,
    0x38, 0xe0, 0x0, 0x0, 0x71, 0xc0, 0x0, 0x0,
    0xe3, 0x87, 0xff, 0xe1, 0xc7, 0xf, 0xff, 0xc3,
    0x8e, 0x0, 0x0, 0x7, 0x1c, 0x0, 0x0, 0xe,
    0x38, 0x0, 0x0, 0x1c, 0x77, 0xff, 0xff, 0x38,
    0xef, 0xff, 0xfe, 0x71, 0xc0, 0x1c, 0x0, 0xe3,
    0x80, 0x38, 0x1, 0xc7, 0xe, 0x72, 0x3, 0x8e,
    0x1c, 0xe4, 0x7, 0x1c, 0x39, 0xcc, 0xe, 0x38,
    0x63, 0x9c, 0x1c, 0x71, 0xc7, 0x1c, 0x0, 0xe3,
    0xe, 0x3e, 0x1, 0xc6, 0x1c, 0x78, 0x3, 0x88,
    0x38, 0x70, 0x7, 0x30, 0x70, 0xe0, 0xe, 0x40,
    0xe0, 0xc0, 0x1d, 0x3, 0xc0, 0x80, 0x78, 0x1f,
    0x0, 0x3, 0xe0, 0xd8, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0x44, 0x0,

    /* U+527F "剿" */
    0x1e, 0x38, 0xf0, 0xf, 0x1c, 0x78, 0xe0, 0xf,
    0x1c, 0x71, 0xc0, 0xf, 0x38, 0x71, 0xc0, 0xf,
    0x30, 0xe1, 0x80, 0xf, 0x20, 0xc3, 0x0, 0xf,
    0x20, 0xc3, 0x3, 0xcf, 0x18, 0xe1, 0xc3, 0xcf,
    0x1c, 0x70, 0xe3, 0xcf, 0xc, 0x30, 0x63, 0xcf,
    0x4, 0x30, 0x63, 0xcf, 0x0, 0x0, 0x3, 0xcf,
    0x3c, 0x1, 0xc3, 0xcf, 0x3f, 0xff, 0xc3, 0xcf,
    0x3f, 0xff, 0xc3, 0xcf, 0x3c, 0x71, 0xc3, 0xcf,
    0x3c, 0x71, 0xc3, 0xcf, 0x3c, 0x71, 0xc3, 0xcf,
    0x3c, 0x71, 0xc3, 0xcf, 0x3f, 0xff, 0xc3, 0xcf,
    0x3c, 0x71, 0xc3, 0xcf, 0x3c, 0x71, 0xc3, 0xcf,
    0x3c, 0x71, 0xc3, 0xcf, 0x3c, 0x71, 0xc3, 0xcf,
    0x3f, 0xff, 0xc3, 0xcf, 0x3f, 0xff, 0xc3, 0xcf,
    0x3c, 0x71, 0xc3, 0xcf, 0x0, 0x70, 0x3, 0xcf,
    0x0, 0x70, 0x3, 0xcf, 0x0, 0x70, 0x3, 0xcf,
    0xff, 0xff, 0xf3, 0xcf, 0xff, 0xff, 0xf3, 0xcf,
    0x1, 0xf8, 0x3, 0xcf, 0x1, 0xfc, 0x3, 0xcf,
    0x1, 0xf6, 0x3, 0xcf, 0x3, 0xf7, 0x3, 0xcf,
    0x7, 0x73, 0xc0, 0xf, 0x6, 0x71, 0xe0, 0xf,
    0xc, 0x70, 0xe0, 0xf, 0x18, 0x70, 0x60, 0xf,
    0x10, 0x70, 0x20, 0xf, 0x20, 0x70, 0x0, 0xf,
    0x40, 0x70, 0x0, 0x1e, 0x80, 0x70, 0x0, 0x3e,
    0x0, 0x70, 0x0, 0x7c, 0x0, 0x70, 0x1, 0xf0,
    0x0, 0x0, 0x2, 0x0,

    /* U+5281 "劁" */
    0x7, 0x90, 0x0, 0x1c, 0x1e, 0x20, 0x0, 0x70,
    0x78, 0xe0, 0x1, 0xc1, 0xe3, 0x80, 0x7, 0x7,
    0x6, 0x0, 0x1c, 0x3c, 0x18, 0x0, 0x70, 0xff,
    0xff, 0xb9, 0xc3, 0xff, 0xfe, 0xe7, 0x1f, 0xe,
    0x3, 0x9c, 0x7c, 0x38, 0xe, 0x71, 0xf0, 0xe0,
    0x39, 0xcd, 0xc3, 0x80, 0xe7, 0x27, 0xe, 0x3,
    0x9d, 0x9c, 0x38, 0xe, 0x74, 0x7f, 0xff, 0x39,
    0xc1, 0xc3, 0x80, 0xe7, 0x7, 0xe, 0x3, 0x9c,
    0x1c, 0x38, 0xe, 0x70, 0x70, 0xe0, 0x39, 0xc1,
    0xc3, 0x80, 0xe7, 0x7, 0xe, 0x3, 0x9c, 0x1f,
    0xff, 0xce, 0x70, 0x7f, 0xff, 0x39, 0xc1, 0xc3,
    0x80, 0xe7, 0x7, 0xe, 0x3, 0x9c, 0x1c, 0x38,
    0xe, 0x70, 0x70, 0xe0, 0x39, 0xc1, 0xc3, 0x80,
    0xe7, 0x7, 0xe, 0x3, 0x9c, 0x1f, 0xff, 0xee,
    0x70, 0x70, 0x0, 0x39, 0xc1, 0xc0, 0x0, 0xe7,
    0x0, 0x0, 0x3, 0x9c, 0x0, 0x1, 0xe, 0x70,
    0xe4, 0x42, 0x39, 0xc3, 0x90, 0x8c, 0x7, 0xe,
    0x62, 0x30, 0x1c, 0x38, 0x88, 0xe0, 0x70, 0xe3,
    0x33, 0xc1, 0xc3, 0x8c, 0xc7, 0x7, 0xe, 0x33,
    0x9c, 0x1c, 0x38, 0x8c, 0x70, 0x70, 0xe2, 0x20,
    0xc3, 0xc7, 0x0, 0x1, 0x1e, 0x38, 0x0, 0x1,
    0xf0, 0x80, 0x0, 0x8, 0x0,

    /* U+5282 "劂" */
    0x3c, 0x0, 0x0, 0x7, 0x3f, 0xff, 0xff, 0x7,
    0x3f, 0xff, 0xff, 0x7, 0x3c, 0x0, 0x0, 0x7,
    0x3c, 0x3, 0x78, 0xe7, 0x3c, 0x82, 0x70, 0xe7,
    0x3c, 0x82, 0x70, 0xe7, 0x3c, 0xc6, 0x70, 0xe7,
    0x3c, 0xe6, 0x70, 0xe7, 0x3c, 0xec, 0x70, 0xe7,
    0x3c, 0x6c, 0x66, 0xe7, 0x3c, 0x4c, 0x66, 0xe7,
    0x3f, 0xff, 0x7e, 0xe7, 0x3f, 0xff, 0xc6, 0xe7,
    0x3c, 0x38, 0xc6, 0xe7, 0x3c, 0x38, 0x86, 0xe7,
    0x3c, 0x38, 0x88, 0xe7, 0x3d, 0xb9, 0xb8, 0xe7,
    0x3d, 0xb9, 0xb8, 0xe7, 0x3d, 0xb9, 0xb8, 0xe7,
    0x3d, 0xb9, 0xb8, 0xe7, 0x3d, 0xb9, 0xb8, 0xe7,
    0x3d, 0xb9, 0xb8, 0xe7, 0x3d, 0xb9, 0xb8, 0xe7,
    0x3d, 0xb9, 0xb8, 0xe7, 0x3d, 0xb9, 0xb8, 0xe7,
    0x3d, 0xb9, 0xb8, 0xe7, 0x3d, 0xb9, 0xb8, 0xe7,
    0x3d, 0xb9, 0xb8, 0xe7, 0x3d, 0xff, 0xb8, 0xe7,
    0x3d, 0xff, 0xb8, 0xe7, 0x3d, 0xb9, 0xb8, 0xe7,
    0x3c, 0x38, 0x38, 0xe7, 0x3c, 0x70, 0x78, 0xe7,
    0x3c, 0x70, 0x78, 0xe7, 0x38, 0x70, 0x7c, 0xe7,
    0x38, 0x60, 0x6c, 0xe7, 0x38, 0xe0, 0xee, 0x7,
    0x38, 0xc0, 0xc7, 0x7, 0x31, 0xc1, 0x87, 0x87,
    0x31, 0x81, 0x87, 0x7, 0x73, 0x3, 0x3, 0x7,
    0x66, 0x6, 0x3, 0x7, 0x64, 0xc, 0x1, 0xe,
    0x48, 0x8, 0x0, 0x3c, 0xc0, 0x10, 0x0, 0xf8,

    /* U+5283 "劃" */
    0x0, 0xf0, 0x0, 0x1c, 0x1, 0xe0, 0x0, 0x38,
    0x3, 0xc7, 0x0, 0x70, 0x7, 0x8e, 0x0, 0xe3,
    0xff, 0xfc, 0x1, 0xc7, 0xff, 0xf8, 0xe3, 0x80,
    0x3c, 0x71, 0xc7, 0x0, 0x78, 0xe3, 0x8e, 0xff,
    0xff, 0xf7, 0x1d, 0xff, 0xff, 0xee, 0x38, 0x3,
    0xc7, 0x1c, 0x70, 0x7, 0x8e, 0x38, 0xe3, 0xff,
    0xfc, 0x71, 0xc7, 0xff, 0xf8, 0xe3, 0x80, 0x3c,
    0x71, 0xc7, 0x0, 0x78, 0x3, 0x8e, 0x0, 0xf0,
    0x7, 0x1c, 0x7f, 0xff, 0x8e, 0x38, 0x3, 0xc0,
    0x1c, 0x70, 0x7, 0x80, 0x38, 0xef, 0xff, 0xff,
    0x71, 0xdf, 0xff, 0xfe, 0xe3, 0x80, 0x0, 0x1,
    0xc7, 0x0, 0x0, 0x3, 0x8e, 0x3c, 0x1, 0xc7,
    0x1c, 0x7f, 0xff, 0x8e, 0x38, 0xff, 0xff, 0x1c,
    0x71, 0xe7, 0x8e, 0x38, 0xe3, 0xcf, 0x1c, 0x71,
    0xc7, 0xff, 0xf8, 0xe3, 0x8f, 0xff, 0xf1, 0xc7,
    0x1e, 0x78, 0xe3, 0x8e, 0x3c, 0xf1, 0xc7, 0x1c,
    0x79, 0xe3, 0x8e, 0x38, 0xff, 0xff, 0x1c, 0x71,
    0xff, 0xfe, 0x0, 0xe3, 0xc0, 0x1c, 0x1, 0xc7,
    0x80, 0x6, 0x3, 0x80, 0x0, 0x30, 0x7, 0x0,
    0x7, 0x80, 0xe, 0x7f, 0xfc, 0x0, 0x1c, 0xff,
    0xe0, 0x0, 0x39, 0xfe, 0x0, 0x0, 0xe3, 0xc0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3c, 0x0,

    /* U+5287 "劇" */
    0x0, 0x78, 0x0, 0x1e, 0x0, 0xf0, 0x0, 0x3c,
    0x1, 0xe0, 0x0, 0x78, 0x3, 0xfe, 0x0, 0xf0,
    0x7, 0xfc, 0x1, 0xe0, 0xf, 0x0, 0x73, 0xce,
    0x1e, 0x38, 0xe7, 0x9c, 0x3c, 0x71, 0xcf, 0x3f,
    0xff, 0xe3, 0x9e, 0x70, 0x1, 0xc7, 0x3c, 0xe1,
    0xc2, 0xe, 0x79, 0xc3, 0x80, 0x1c, 0xf3, 0x87,
    0x30, 0x39, 0xe7, 0xff, 0xe8, 0x73, 0xcf, 0xfc,
    0x10, 0xe7, 0x9c, 0x38, 0x31, 0xcf, 0x38, 0x7f,
    0xe3, 0x9e, 0x70, 0xff, 0xc7, 0x3c, 0xe0, 0xff,
    0xe, 0x79, 0xc0, 0x0, 0x1c, 0xf3, 0xbf, 0xff,
    0x39, 0xe7, 0x7f, 0xfe, 0x73, 0xce, 0xf, 0x0,
    0xe7, 0x9c, 0x3c, 0x1, 0xcf, 0x38, 0x78, 0x23,
    0x9e, 0x70, 0xe0, 0xc7, 0x3c, 0xe3, 0xe3, 0xe,
    0x79, 0xc6, 0xe6, 0x1c, 0xf3, 0x90, 0xd8, 0x39,
    0xe7, 0x5d, 0xf0, 0x73, 0xcf, 0x3b, 0xa0, 0xe7,
    0x9c, 0xe7, 0x41, 0xcf, 0x39, 0x8e, 0xc3, 0x9e,
    0x67, 0xfd, 0xc7, 0x3c, 0xcb, 0xbb, 0xee, 0x79,
    0xa7, 0x73, 0x9c, 0xf3, 0xc, 0xe7, 0x39, 0xe6,
    0x31, 0xcc, 0x3, 0xdc, 0x63, 0x88, 0x7, 0xb1,
    0x87, 0x10, 0xf, 0x66, 0xe, 0x0, 0x1e, 0xd8,
    0x38, 0x0, 0x3d, 0x0, 0xf0, 0x0, 0xf2, 0x3,
    0x80, 0x3, 0xc8, 0x1a, 0x0, 0x1e, 0x0,

    /* U+5288 "劈" */
    0xf, 0x7, 0x80, 0xc0, 0x7, 0x83, 0xc0, 0x78,
    0x3, 0xff, 0xe0, 0x1c, 0x1, 0xff, 0xf0, 0xc,
    0x0, 0xf0, 0x7f, 0xff, 0xf0, 0x78, 0x3c, 0x40,
    0x20, 0x3c, 0x1e, 0x30, 0x30, 0x1e, 0xf, 0x1c,
    0x18, 0xf, 0x7, 0x87, 0x8, 0x7, 0xff, 0xc3,
    0xcc, 0x3, 0xc1, 0xe0, 0xc6, 0x1, 0xe0, 0xf0,
    0x66, 0x0, 0xe0, 0x7, 0xff, 0xf8, 0x70, 0x3f,
    0xff, 0xfc, 0x3e, 0x1e, 0x7, 0x80, 0x1f, 0xff,
    0x3, 0xc0, 0xf, 0xff, 0x81, 0xe0, 0xf, 0xc3,
    0xc0, 0xf0, 0x7, 0xe1, 0xff, 0xff, 0xc3, 0x70,
    0xff, 0xff, 0xe3, 0x38, 0x78, 0x1e, 0x1, 0x9c,
    0x3c, 0xf, 0x0, 0x8f, 0xfe, 0x7, 0x80, 0xc7,
    0xff, 0x3, 0xc0, 0x43, 0x87, 0x81, 0xe0, 0x1,
    0xc3, 0xc0, 0xf0, 0x0, 0xe0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0xff, 0xff, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0xe0,
    0x0, 0xf, 0x0, 0xf0, 0x0, 0x7, 0x80, 0x78,
    0x0, 0x3, 0xc0, 0x3c, 0x0, 0x1, 0xc0, 0x1e,
    0x0, 0x1, 0xe0, 0xf, 0x0, 0x0, 0xf0, 0x7,
    0x80, 0x0, 0x70, 0x3, 0xc0, 0x0, 0x70, 0x1,
    0xe0, 0x0, 0x70, 0x0, 0xf0, 0x0, 0x78, 0x0,
    0x78, 0x0, 0x70, 0x0, 0x3c, 0x0, 0x70, 0x0,
    0x3c, 0x0, 0x70, 0x0, 0x7e, 0x0, 0x60, 0x1,
    0xfc, 0x0, 0xc0, 0x1, 0x8, 0x0,

    /* U+5289 "劉" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x80, 0xf0, 0x1e,
    0x39, 0xc0, 0xf0, 0x1e, 0x3b, 0xe0, 0xf0, 0x1e,
    0x3e, 0x3f, 0xf0, 0x1e, 0x38, 0x3f, 0xf0, 0x1e,
    0x38, 0x1c, 0xf3, 0x9e, 0x3a, 0x1c, 0xf3, 0x9e,
    0x39, 0x1c, 0xf3, 0x9e, 0x39, 0x9c, 0xf3, 0x9e,
    0x39, 0xdc, 0xf3, 0x9e, 0x38, 0xdc, 0xf3, 0x9e,
    0x39, 0xdc, 0xf3, 0x9e, 0x3a, 0xd8, 0xf3, 0x9e,
    0x3e, 0x58, 0xf3, 0x9e, 0x3c, 0x70, 0xf3, 0x9e,
    0x7c, 0x20, 0xf3, 0x9e, 0x79, 0xf0, 0xe3, 0x9e,
    0x73, 0xe3, 0x83, 0x9e, 0x43, 0xe0, 0x3, 0x9e,
    0x3, 0xd8, 0x3, 0x9e, 0x3, 0x8f, 0x3, 0x9e,
    0x7, 0x7, 0xe3, 0x9e, 0x6, 0x1, 0xf3, 0x9e,
    0xc, 0x0, 0xf3, 0x9e, 0x1f, 0xff, 0x73, 0x9e,
    0x3f, 0xff, 0x13, 0x9e, 0x60, 0xe0, 0x3, 0x9e,
    0xc0, 0xe0, 0x3, 0x9e, 0x0, 0xe0, 0x3, 0x9e,
    0x3f, 0xff, 0xc3, 0x9e, 0x3f, 0xff, 0xc3, 0x9e,
    0x0, 0xe0, 0x3, 0x9e, 0x0, 0xe1, 0x3, 0x9e,
    0x10, 0xe1, 0x83, 0x9e, 0x1c, 0xe3, 0x3, 0x9e,
    0xe, 0xe3, 0x3, 0x9e, 0xe, 0xe6, 0x30, 0x1e,
    0x6, 0xe4, 0xc0, 0x1e, 0x4, 0xef, 0x0, 0x1e,
    0x3f, 0xfe, 0x0, 0x1e, 0x3f, 0xf8, 0x0, 0x1e,
    0x3f, 0xe0, 0x0, 0x1e, 0x3e, 0x0, 0x0, 0x3c,
    0x60, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3, 0x40,

    /* U+528A "劊" */
    0x0, 0xf8, 0x0, 0x3c, 0x7, 0xc0, 0x0, 0xf0,
    0x1f, 0x80, 0x3, 0xc0, 0x7a, 0x0, 0xf, 0x3,
    0xcc, 0x0, 0x3c, 0xe, 0x18, 0x1c, 0xf0, 0x30,
    0x70, 0x73, 0xc1, 0xc0, 0xf1, 0xcf, 0xe, 0x3,
    0xff, 0x3c, 0x30, 0x7, 0xdc, 0xf1, 0xff, 0xee,
    0x73, 0xcd, 0xff, 0x99, 0xcf, 0x60, 0x0, 0x27,
    0x3f, 0xe0, 0x7, 0x1c, 0xf3, 0xff, 0xfc, 0x73,
    0xcf, 0xff, 0xf1, 0xcf, 0x38, 0x71, 0xc7, 0x3c,
    0xf1, 0xc7, 0x1c, 0xf3, 0xe7, 0x7c, 0x73, 0xce,
    0xdd, 0x71, 0xcf, 0x3b, 0xfd, 0xc7, 0x3c, 0xe5,
    0xe7, 0x1c, 0xf3, 0x87, 0x1c, 0x73, 0xcf, 0xff,
    0xf1, 0xcf, 0x3f, 0xff, 0xc7, 0x3c, 0xe0, 0x7,
    0x1c, 0xf3, 0x80, 0x1c, 0x73, 0xce, 0x0, 0xe1,
    0xcf, 0x1e, 0x3, 0x87, 0x3c, 0x7f, 0xfe, 0x1c,
    0xf1, 0xff, 0xf8, 0x73, 0xc7, 0x80, 0xe1, 0xcf,
    0x1e, 0x3, 0x87, 0x3c, 0x78, 0xe, 0x1c, 0xf1,
    0xff, 0xb8, 0x73, 0xc7, 0xfe, 0xe1, 0xcf, 0x1e,
    0x3, 0x87, 0x3c, 0x78, 0xe, 0x0, 0xf1, 0xe0,
    0x38, 0x3, 0xc7, 0xff, 0xe0, 0xf, 0x1f, 0xff,
    0x80, 0x3c, 0x78, 0xe, 0x0, 0xe1, 0xe0, 0x38,
    0x7, 0x7, 0x80, 0xe0, 0x78, 0x0, 0x0, 0x6,
    0x80,

    /* U+528C "劌" */
    0x0, 0x1c, 0x0, 0x1c, 0xe, 0x38, 0x0, 0x38,
    0x1c, 0x70, 0x0, 0x70, 0x38, 0xe0, 0x0, 0xe0,
    0x71, 0xc0, 0x1, 0xc0, 0xe3, 0xfe, 0x73, 0x81,
    0xc7, 0xfc, 0xe7, 0x3, 0x8e, 0x1, 0xce, 0x7,
    0x1c, 0x3, 0x9c, 0xe, 0x38, 0x7, 0x38, 0x1c,
    0x70, 0xe, 0x73, 0xff, 0xff, 0xdc, 0xe7, 0xff,
    0xff, 0xb9, 0xc0, 0x0, 0x78, 0x73, 0x80, 0x0,
    0xe8, 0xe7, 0x0, 0x1, 0xd9, 0xce, 0x38, 0x3,
    0xb3, 0x9c, 0x70, 0x7, 0x47, 0x38, 0xff, 0xff,
    0xee, 0x71, 0xff, 0xff, 0xdc, 0xe3, 0x80, 0x38,
    0x39, 0xc7, 0x0, 0x70, 0x73, 0x8e, 0x0, 0xee,
    0xe7, 0x1f, 0xff, 0xdd, 0xce, 0x3f, 0xff, 0xbb,
    0x9c, 0x71, 0xc7, 0x77, 0x38, 0xe3, 0x8e, 0xee,
    0x71, 0xc7, 0x1d, 0xdc, 0xe3, 0xbe, 0xfb, 0x39,
    0xc7, 0x7d, 0xf6, 0x73, 0x8e, 0xfb, 0xfc, 0xe7,
    0x1d, 0xf6, 0xf9, 0xce, 0x3a, 0xed, 0xe3, 0x9c,
    0x75, 0xf3, 0xc7, 0x38, 0xeb, 0xe7, 0x0, 0x71,
    0xa7, 0x8e, 0x0, 0xe3, 0x43, 0x1e, 0x41, 0xc6,
    0xc, 0x7c, 0x83, 0x8c, 0x31, 0x9d, 0x7, 0x10,
    0x43, 0x3e, 0xe, 0x61, 0x8, 0x3c, 0x1c, 0xc4,
    0x30, 0x78, 0x39, 0x30, 0xc0, 0x70, 0xf2, 0xc3,
    0x0, 0x63, 0xc8, 0xc, 0x0, 0x5e, 0x0,

    /* U+528D "劍" */
    0x0, 0x0, 0x0, 0x3c, 0x7, 0xc0, 0x0, 0xf0,
    0x1f, 0x0, 0x3, 0xc0, 0x78, 0x0, 0xf, 0x1,
    0xf0, 0x0, 0x3c, 0x7, 0x60, 0x1e, 0xf0, 0x38,
    0xe0, 0x7b, 0xc0, 0xe1, 0xe1, 0xef, 0x3, 0x3,
    0xc7, 0xbc, 0x18, 0xf, 0x9e, 0xf0, 0x60, 0x1e,
    0x7b, 0xc3, 0xff, 0xb9, 0xef, 0xf, 0xfe, 0x67,
    0xbc, 0x60, 0x0, 0x9e, 0xf3, 0x0, 0x0, 0x7b,
    0xc8, 0x0, 0x1, 0xef, 0x7d, 0xdc, 0xe7, 0xbc,
    0x77, 0x73, 0x9e, 0xf1, 0xfd, 0xfe, 0x7b, 0xc7,
    0xf7, 0xf9, 0xef, 0x1d, 0xdc, 0xe7, 0xbc, 0x77,
    0x73, 0x9e, 0xf1, 0xdd, 0xce, 0x7b, 0xc7, 0x77,
    0x39, 0xef, 0x1d, 0xdc, 0xe7, 0xbc, 0x77, 0x73,
    0x9e, 0xf1, 0xdd, 0xce, 0x7b, 0xc7, 0x77, 0x39,
    0xef, 0x1f, 0xdf, 0xe7, 0xbc, 0x7f, 0x7f, 0x9e,
    0xf1, 0xdd, 0xce, 0x7b, 0xc7, 0x77, 0x39, 0xef,
    0x0, 0x0, 0x7, 0xbc, 0x3c, 0x3c, 0x1e, 0xf0,
    0xe0, 0xf0, 0x7b, 0xc3, 0x83, 0x81, 0xef, 0xe,
    0xe, 0x7, 0xbc, 0x3c, 0x34, 0x0, 0xf0, 0xdd,
    0xd0, 0x3, 0xc3, 0x76, 0x70, 0xf, 0x18, 0x99,
    0xf0, 0x3c, 0x60, 0xc3, 0xc0, 0xf1, 0x2, 0xe,
    0x3, 0xc8, 0x10, 0x18, 0x1e, 0x20, 0x80, 0x60,
    0xf1, 0x2, 0x0, 0x87, 0x0,

    /* U+5290 "劐" */
    0x3, 0x87, 0x80, 0x1c, 0xe, 0x1e, 0x0, 0x70,
    0x38, 0x78, 0x1, 0xc0, 0xe1, 0xe0, 0x7, 0x7f,
    0xff, 0xf8, 0x1d, 0xff, 0xff, 0xef, 0x70, 0x38,
    0x78, 0x3d, 0xc0, 0xe1, 0xe0, 0xf7, 0x7, 0x88,
    0x3, 0xdc, 0x1c, 0x38, 0xf, 0x70, 0x70, 0x60,
    0x3d, 0xc1, 0x81, 0x80, 0xf7, 0xf, 0xff, 0xfb,
    0xdc, 0x3f, 0xff, 0xef, 0x70, 0xf0, 0xe0, 0x3d,
    0xc7, 0xc3, 0x80, 0xf7, 0x1f, 0xe, 0x3, 0xdc,
    0xff, 0xff, 0xef, 0x72, 0xff, 0xff, 0xbd, 0xd3,
    0xc3, 0x80, 0xf7, 0x4f, 0xe, 0x3, 0xdc, 0x3c,
    0x38, 0xf, 0x70, 0xff, 0xff, 0xbd, 0xc3, 0xff,
    0xfe, 0xf7, 0xf, 0xe, 0x3, 0xdc, 0x3c, 0x38,
    0xf, 0x70, 0xff, 0xff, 0xbd, 0xc3, 0xff, 0xfe,
    0xf7, 0xf, 0x0, 0x3, 0xdc, 0x0, 0x0, 0xf,
    0x70, 0x0, 0xf, 0x3d, 0xc7, 0xff, 0xfc, 0xf7,
    0x1f, 0xff, 0xe3, 0xdc, 0x8, 0x7, 0x8f, 0x70,
    0x10, 0x1c, 0x3d, 0xc0, 0x60, 0xf0, 0xf7, 0x0,
    0xc3, 0x80, 0x1c, 0x1, 0x9c, 0x0, 0x70, 0x7,
    0xe0, 0x1, 0xc0, 0xf, 0x0, 0x7, 0x0, 0x3e,
    0x0, 0x1c, 0x1, 0xff, 0x80, 0xf0, 0x1c, 0x7f,
    0x87, 0x81, 0xe0, 0xfe, 0x7c, 0xe, 0x0, 0xfa,
    0x20, 0xc0, 0x0, 0xe0, 0x0,

    /* U+5291 "劑" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x60, 0x0, 0x0,
    0x0, 0xe0, 0x0, 0x38, 0x0, 0xe0, 0x0, 0x70,
    0x1, 0xc0, 0x0, 0xef, 0xff, 0xff, 0x81, 0xc0,
    0x40, 0xc0, 0xf3, 0x80, 0x41, 0x81, 0xe7, 0x0,
    0xc6, 0x3, 0xce, 0x1, 0xec, 0x37, 0x9c, 0x1,
    0x90, 0x7f, 0x38, 0x1f, 0x7d, 0xde, 0x77, 0xfb,
    0xbf, 0x3c, 0xef, 0xf7, 0x72, 0x79, 0xce, 0xee,
    0xe4, 0xf3, 0x9d, 0xdd, 0xc9, 0xe7, 0x3b, 0xbb,
    0x93, 0xce, 0x77, 0x77, 0x27, 0x9c, 0xee, 0xee,
    0x6f, 0x39, 0xdd, 0xdc, 0xfe, 0x73, 0xbb, 0xb9,
    0xfc, 0xe6, 0x77, 0x7d, 0xf9, 0xcc, 0xee, 0xf2,
    0xf3, 0x93, 0x9d, 0xc5, 0xe7, 0x58, 0x39, 0x3,
    0xcf, 0x80, 0x0, 0x7, 0x9c, 0x3c, 0x0, 0xf,
    0x38, 0x78, 0x7, 0x9e, 0x70, 0xf0, 0xf, 0x3c,
    0xe1, 0xe0, 0x1e, 0x79, 0xc3, 0xff, 0xfc, 0xf3,
    0x87, 0xff, 0xf9, 0xe7, 0xf, 0x0, 0xf3, 0xce,
    0x1e, 0x1, 0xe7, 0x9c, 0x3c, 0x3, 0xcf, 0x38,
    0x78, 0x7, 0x9e, 0x70, 0xff, 0xff, 0x3c, 0xe1,
    0xff, 0xfe, 0x1, 0xc3, 0x80, 0x3c, 0x3, 0x86,
    0x0, 0x78, 0x7, 0x1c, 0x0, 0xf0, 0xe, 0x30,
    0x1, 0xe0, 0x1c, 0xc0, 0x3, 0xc0, 0x39, 0x0,
    0x7, 0x80, 0xe4, 0x0, 0xf, 0x7, 0x80, 0x0,
    0x0, 0x34, 0x0,

    /* U+5293 "劓" */
    0x0, 0x78, 0x0, 0x1e, 0x0, 0xe0, 0x0, 0x3c,
    0x1, 0x80, 0x0, 0x78, 0xf6, 0xe, 0x0, 0xf1,
    0xff, 0xfc, 0x1, 0xe3, 0xff, 0xf8, 0x3, 0xc7,
    0x80, 0x71, 0xc7, 0x8f, 0xfc, 0xe3, 0x8f, 0x1f,
    0xf9, 0xc7, 0x1e, 0x3c, 0x3, 0x8e, 0x3c, 0x78,
    0x7, 0x1c, 0x78, 0xff, 0xce, 0x38, 0xf1, 0xff,
    0x9c, 0x71, 0xe3, 0xc0, 0x38, 0xe3, 0xc7, 0x80,
    0x71, 0xc7, 0x8f, 0xff, 0xe3, 0x8f, 0x1f, 0xff,
    0xc7, 0x1e, 0x3c, 0x3, 0x8e, 0x3c, 0xe0, 0x7,
    0x9c, 0x79, 0xff, 0xff, 0x38, 0xf3, 0xff, 0xfe,
    0x71, 0xe7, 0xe, 0x3c, 0xe3, 0xce, 0x1c, 0x79,
    0xc7, 0x9c, 0x38, 0xf3, 0x8f, 0x3f, 0xff, 0xe7,
    0x1e, 0x70, 0xe3, 0xce, 0x3c, 0xe1, 0xc7, 0x9c,
    0x79, 0xc3, 0x8f, 0x38, 0xf3, 0xff, 0xfe, 0x71,
    0xe7, 0xff, 0xfc, 0xe3, 0xc0, 0x0, 0x79, 0xc7,
    0x80, 0x0, 0x3, 0x8f, 0xff, 0xff, 0xf7, 0x1f,
    0xff, 0xff, 0xee, 0x3c, 0x1e, 0x38, 0x1c, 0x78,
    0x3c, 0x70, 0x38, 0xf0, 0x78, 0xe0, 0x1, 0xe0,
    0xe1, 0xc0, 0x3, 0xc1, 0xc3, 0x80, 0x7, 0x83,
    0x87, 0x0, 0xf, 0xe, 0xe, 0x0, 0x1e, 0x18,
    0x1c, 0x0, 0x3c, 0x60, 0x38, 0x0, 0xf8, 0x80,
    0x70, 0x3, 0xe2, 0x0, 0xe0, 0x1f, 0x8, 0x1,
    0xc0, 0xd8, 0x0,

    /* U+529B "力" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x3, 0xc0, 0x1e, 0x0, 0xf,
    0x0, 0x78, 0x0, 0x3c, 0x1, 0xe3, 0xff, 0xff,
    0xff, 0x8f, 0xff, 0xff, 0xfe, 0x0, 0xf, 0x0,
    0x78, 0x0, 0x3c, 0x1, 0xe0, 0x0, 0xf0, 0x7,
    0x80, 0x3, 0xc0, 0x1e, 0x0, 0xf, 0x0, 0x78,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0xf0, 0x7, 0x80,
    0x3, 0xc0, 0x1e, 0x0, 0xf, 0x0, 0x78, 0x0,
    0x3c, 0x1, 0xe0, 0x0, 0xf0, 0x7, 0x80, 0x3,
    0xc0, 0x1e, 0x0, 0xf, 0x0, 0x78, 0x0, 0x3c,
    0x1, 0xe0, 0x0, 0xf0, 0x7, 0x80, 0x3, 0xc0,
    0x1e, 0x0, 0xf, 0x0, 0x78, 0x0, 0x3c, 0x1,
    0xe0, 0x0, 0xf0, 0x7, 0x80, 0x3, 0xc0, 0x1e,
    0x0, 0xe, 0x0, 0x78, 0x0, 0x78, 0x1, 0xe0,
    0x1, 0xc0, 0x7, 0x80, 0xf, 0x0, 0x1e, 0x0,
    0x38, 0x0, 0x78, 0x1, 0xc0, 0x1, 0xe0, 0xe,
    0x0, 0x7, 0x80, 0x78, 0x0, 0x1e, 0x3, 0x80,
    0x0, 0xf8, 0x1c, 0x0, 0x7, 0xc0, 0xe0, 0x0,
    0x3e, 0x7, 0x0, 0x3, 0xf0, 0x30, 0x0, 0x73,
    0x1, 0x80, 0x0, 0x0, 0x0,

    /* U+529D "劝" */
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x7f, 0xfc, 0x1e, 0x0, 0x7f, 0xfc, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x1e,
    0x0, 0x3c, 0x1e, 0x1e, 0x0, 0x3c, 0x1e, 0x1e,
    0x0, 0x3d, 0xff, 0xfe, 0x0, 0x3d, 0xff, 0xfe,
    0x20, 0x3c, 0x1e, 0x1e, 0x10, 0x3c, 0x1e, 0x1e,
    0x18, 0x3c, 0x1e, 0x1e, 0x8, 0x3c, 0x1e, 0x1e,
    0xc, 0x3c, 0x1e, 0x1e, 0xc, 0x3c, 0x1e, 0x1e,
    0x6, 0x3c, 0x1e, 0x1e, 0x7, 0x38, 0x1e, 0x1e,
    0x7, 0x38, 0x1e, 0x1e, 0x3, 0xf8, 0x1e, 0x1e,
    0x3, 0xf8, 0x1e, 0x1e, 0x3, 0xf8, 0x1e, 0x1e,
    0x1, 0xf0, 0x1e, 0x1e, 0x1, 0xf0, 0x1e, 0x1e,
    0x1, 0xf0, 0x1e, 0x1e, 0x1, 0xf0, 0x1e, 0x1e,
    0x1, 0xf8, 0x1e, 0x1e, 0x1, 0xfc, 0x1e, 0x1e,
    0x3, 0xfc, 0x1c, 0x1e, 0x3, 0x3e, 0x1c, 0x1e,
    0x6, 0x3e, 0x3c, 0x1e, 0x6, 0x3f, 0x38, 0x1e,
    0xc, 0x1f, 0x38, 0x1e, 0x18, 0x1e, 0x30, 0x1e,
    0x18, 0xe, 0x70, 0x1e, 0x30, 0xc, 0x60, 0x1e,
    0x20, 0x4, 0xe0, 0x1e, 0x40, 0x0, 0xc0, 0x1e,
    0x0, 0x1, 0xc0, 0x1e, 0x0, 0x1, 0x80, 0x3e,
    0x0, 0x3, 0x0, 0x7c, 0x0, 0x6, 0x0, 0xf8,
    0x0, 0x4, 0x3, 0xf0, 0x0, 0xc, 0x6, 0x40,

    /* U+529E "办" */
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x3c, 0x7, 0x80,
    0x0, 0x3c, 0x7, 0x80, 0x1f, 0xff, 0xff, 0x80,
    0x1f, 0xff, 0xff, 0x80, 0x0, 0x3c, 0x7, 0x80,
    0x0, 0x3c, 0x7, 0x80, 0x0, 0x3c, 0x7, 0xb0,
    0x0, 0x3c, 0x7, 0xb0, 0x0, 0x3c, 0x7, 0xb0,
    0xf, 0x3c, 0x7, 0xb0, 0xf, 0x3c, 0x7, 0xb0,
    0xf, 0x3c, 0x7, 0xb0, 0xf, 0x3c, 0x7, 0xb0,
    0xf, 0x3c, 0x7, 0x90, 0xf, 0x3c, 0x7, 0x98,
    0xe, 0x3c, 0x7, 0x98, 0xe, 0x3c, 0x7, 0x98,
    0x1e, 0x3c, 0x7, 0x9c, 0x1e, 0x3c, 0x7, 0x9e,
    0x1c, 0x3c, 0x7, 0x9f, 0x1c, 0x3c, 0x7, 0x9f,
    0x1c, 0x3c, 0x7, 0x8e, 0x38, 0x3c, 0x7, 0x8e,
    0x38, 0x3c, 0x7, 0x8e, 0x30, 0x3c, 0x7, 0x86,
    0x60, 0x3c, 0x7, 0x86, 0x40, 0x3c, 0x7, 0x82,
    0x80, 0x38, 0x7, 0x80, 0x0, 0x38, 0x7, 0x80,
    0x0, 0x70, 0x7, 0x80, 0x0, 0x70, 0x7, 0x80,
    0x0, 0xe0, 0x7, 0x80, 0x0, 0xe0, 0x7, 0x80,
    0x1, 0xc0, 0x7, 0x80, 0x3, 0x80, 0x7, 0x80,
    0x3, 0x0, 0xf, 0x80, 0x6, 0x0, 0x1f, 0x0,
    0x18, 0x0, 0x7e, 0x0, 0x30, 0x3, 0x98, 0x0,

    /* U+529F "功" */
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x3, 0xc0, 0xf, 0xff, 0x87, 0x80, 0x1f,
    0xff, 0xf, 0x0, 0x1, 0xe0, 0x1e, 0x0, 0x3,
    0xc0, 0x3c, 0x1e, 0x7, 0x80, 0x78, 0x3c, 0xf,
    0x0, 0xf0, 0x78, 0x1e, 0x1f, 0xff, 0xf0, 0x3c,
    0x3f, 0xff, 0xe0, 0x78, 0x7, 0x83, 0xc0, 0xf0,
    0xf, 0x7, 0x81, 0xe0, 0x1e, 0xf, 0x3, 0xc0,
    0x3c, 0x1e, 0x7, 0x80, 0x78, 0x3c, 0xf, 0x0,
    0xf0, 0x78, 0x1e, 0x1, 0xe0, 0xf0, 0x3c, 0x3,
    0xc1, 0xe0, 0x78, 0x7, 0x83, 0xc0, 0xf0, 0xf,
    0x7, 0x81, 0xe0, 0x1e, 0xf, 0x3, 0xc0, 0x3c,
    0x1e, 0x7, 0x80, 0x78, 0x3c, 0xf, 0x0, 0xf0,
    0x78, 0x1e, 0x1, 0xe0, 0xf0, 0x3c, 0x3, 0xc1,
    0xe0, 0x78, 0x7, 0x83, 0xc0, 0xf0, 0x1e, 0x7,
    0x81, 0xe1, 0x3c, 0xf, 0x3, 0xcc, 0x70, 0x1e,
    0x7, 0xb1, 0xe0, 0x3c, 0xf, 0xe3, 0x80, 0x78,
    0x1f, 0x87, 0x0, 0xff, 0xfe, 0x1c, 0x1, 0xef,
    0xf0, 0x70, 0x3, 0xdf, 0xc0, 0xc0, 0x7, 0xbe,
    0x3, 0x80, 0xf, 0x60, 0xe, 0x0, 0x1e, 0x0,
    0x38, 0x0, 0x3c, 0x0, 0x40, 0x0, 0xf0, 0x1,
    0x0, 0x3, 0xc0, 0x4, 0x0, 0x1e, 0x0, 0x10,
    0x0, 0xf0, 0x0,

    /* U+52A0 "加" */
    0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1,
    0xe0, 0x7, 0x87, 0x83, 0xc7, 0x8f, 0xf, 0x7,
    0x8f, 0x1f, 0xfe, 0xff, 0xfe, 0x3f, 0xfd, 0xff,
    0xfc, 0x78, 0x78, 0x3c, 0x78, 0xf0, 0xf0, 0x78,
    0xf1, 0xe1, 0xe0, 0xf1, 0xe3, 0xc3, 0xc1, 0xe3,
    0xc7, 0x87, 0x83, 0xc7, 0x8f, 0xf, 0x7, 0x8f,
    0x1e, 0x1e, 0xf, 0x1e, 0x3c, 0x3c, 0x1e, 0x3c,
    0x78, 0x78, 0x3c, 0x78, 0xf0, 0xf0, 0x78, 0xf1,
    0xe1, 0xe0, 0xf1, 0xe3, 0xc3, 0xc1, 0xe3, 0xc7,
    0x87, 0x83, 0xc7, 0x8f, 0xf, 0x7, 0x8f, 0x1e,
    0x1e, 0xf, 0x1e, 0x3c, 0x3c, 0x1e, 0x3c, 0x78,
    0x78, 0x3c, 0x78, 0xf0, 0xf0, 0x78, 0xf1, 0xe1,
    0xe0, 0xf1, 0xe3, 0xc3, 0xc1, 0xe3, 0xc7, 0x87,
    0x83, 0xc7, 0x8f, 0xf, 0x7, 0x8f, 0x1e, 0x1e,
    0xf, 0x1e, 0x3c, 0x3c, 0x1e, 0x3c, 0x78, 0x78,
    0x3c, 0x78, 0xf0, 0xf0, 0x70, 0xf1, 0xe1, 0xe1,
    0xe1, 0xe3, 0xc3, 0xc3, 0x83, 0xc7, 0x87, 0x87,
    0x7, 0x8f, 0xf, 0x1c, 0xf, 0x1f, 0xfe, 0x30,
    0x1e, 0x3c, 0x3c, 0xe0, 0x78, 0x78, 0x7b, 0x81,
    0xe0, 0xf0, 0xf6, 0x7, 0x81, 0xe1, 0xf8, 0x34,
    0x3, 0xc3, 0xc0,

    /* U+52A1 "务" */
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x7c, 0x0, 0x1e, 0x0, 0x7e,
    0x0, 0xf, 0xff, 0xfe, 0x0, 0x7, 0x0, 0x1f,
    0x0, 0x7, 0xc0, 0xf, 0x80, 0x3, 0xe0, 0x7,
    0x80, 0x1, 0x90, 0x7, 0xc0, 0x1, 0xcc, 0x3,
    0xc0, 0x0, 0xc3, 0x3, 0xc0, 0x0, 0x41, 0xc3,
    0xc0, 0x0, 0x60, 0x73, 0xe0, 0x0, 0x60, 0x1f,
    0xc0, 0x0, 0x60, 0xf, 0xc0, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x0, 0x7,
    0xbf, 0xe0, 0x0, 0x7, 0xf, 0xff, 0xe0, 0xe,
    0x1, 0xff, 0xe0, 0x1c, 0x0, 0x7f, 0xf0, 0x38,
    0x0, 0xf, 0xf8, 0x60, 0xf0, 0x0, 0xf8, 0xc0,
    0x78, 0x0, 0x4, 0x0, 0x3c, 0x1, 0xe0, 0x0,
    0x1e, 0x0, 0xf0, 0x7, 0xff, 0xff, 0xf8, 0x3,
    0xff, 0xff, 0xfc, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x1, 0xe0, 0xf, 0x0, 0x0, 0xf0, 0x7, 0x80,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0xe, 0x0, 0x78,
    0x0, 0x7, 0x0, 0x3c, 0x0, 0x7, 0x80, 0x1e,
    0x0, 0x3, 0x80, 0xf, 0x0, 0x1, 0xc0, 0x7,
    0x80, 0x1, 0xc0, 0x3, 0xc0, 0x0, 0xc0, 0x1,
    0xe0, 0x0, 0xe0, 0x1, 0xf0, 0x0, 0xe0, 0x1,
    0xf0, 0x0, 0xe0, 0x1, 0xf0, 0x0, 0xc0, 0x7,
    0xe0, 0x0, 0xc0, 0x4, 0x40, 0x0,

    /* U+52A2 "劢" */
    0x0, 0x0, 0x1e, 0x1, 0xff, 0xff, 0x3c, 0x3,
    0xff, 0xfe, 0x78, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0xf0, 0x1, 0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x3,
    0xc0, 0x7, 0x80, 0x7, 0x80, 0xf, 0x0, 0xf,
    0x0, 0x1e, 0x1e, 0x1e, 0x0, 0x3c, 0x3c, 0x3c,
    0x0, 0x78, 0x78, 0x78, 0xfb, 0xff, 0xf0, 0xf1,
    0xf7, 0xff, 0xe1, 0xe3, 0xe3, 0xc3, 0xc3, 0xff,
    0xc7, 0x87, 0x87, 0xff, 0x8f, 0xf, 0xf, 0xf,
    0x1e, 0x1e, 0x1e, 0x1e, 0x3c, 0x3c, 0x3c, 0x3c,
    0x78, 0x78, 0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf1,
    0xe1, 0xe1, 0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7,
    0x87, 0x87, 0x87, 0x8f, 0xf, 0xf, 0xf, 0x1e,
    0x1e, 0x1e, 0x1e, 0x3c, 0x3c, 0x3c, 0x3c, 0x78,
    0x78, 0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf1, 0xe1,
    0xe1, 0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7, 0x87,
    0x87, 0x87, 0x8f, 0xf, 0xe, 0xf, 0x1e, 0x1e,
    0x1c, 0x1e, 0x3c, 0x3c, 0x38, 0x3c, 0x78, 0x78,
    0x70, 0x78, 0xe0, 0xf1, 0xc0, 0xf1, 0xc1, 0xe3,
    0x81, 0xe7, 0x3, 0xc7, 0x3, 0xce, 0x7, 0x8c,
    0x7, 0x98, 0xf, 0x18, 0xe, 0x70, 0x1e, 0x60,
    0x3c, 0xc0, 0x3c, 0xc0, 0xf3, 0x0, 0xf3, 0x7,
    0xcc, 0x3, 0xe4, 0x10, 0x30, 0x1f, 0x18, 0x0,
    0xc0, 0xd8, 0x0,

    /* U+52A3 "劣" */
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x7, 0xc7, 0x86,
    0x0, 0x1, 0xf1, 0xe0, 0xc0, 0x0, 0x78, 0x78,
    0x1c, 0x0, 0x1e, 0x1e, 0x7, 0x80, 0x7, 0x87,
    0x80, 0xf0, 0x3, 0xc1, 0xe0, 0x1f, 0x0, 0xf0,
    0x78, 0x3, 0xe0, 0x38, 0x1e, 0xf, 0xfc, 0xc,
    0x7, 0x83, 0xdf, 0x7, 0x1, 0xe1, 0xf3, 0xc1,
    0x80, 0x78, 0x78, 0x70, 0xc0, 0x1e, 0x3e, 0xc,
    0x20, 0x7, 0x9f, 0x0, 0x18, 0x1, 0xef, 0x80,
    0x4, 0x0, 0x7f, 0xc0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x1, 0xde, 0x0, 0x0, 0x1, 0xc7,
    0x80, 0x3c, 0x1, 0xc1, 0xe0, 0xf, 0x1, 0x80,
    0x78, 0x3, 0xc1, 0x9f, 0xff, 0xff, 0xf0, 0x7,
    0xff, 0xff, 0xfc, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x7, 0x0, 0x3c, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x38, 0x0,
    0xf0, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x7, 0x0,
    0xf, 0x0, 0x3, 0x80, 0x3, 0xc0, 0x1, 0xc0,
    0x0, 0xf0, 0x0, 0x60, 0x0, 0x3c, 0x0, 0x30,
    0x0, 0xf, 0x0, 0x18, 0x0, 0x7, 0x80, 0x8,
    0x0, 0x7, 0xe0, 0xc, 0x0, 0x7, 0xe0, 0x4,
    0x0, 0xe, 0x60, 0x0,

    /* U+52A8 "动" */
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x78, 0x1, 0xff, 0xf0, 0xf0, 0x3,
    0xff, 0xe1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0xf, 0xf, 0x0,
    0x0, 0x1e, 0x1e, 0x0, 0x0, 0x3c, 0x3c, 0x0,
    0xf, 0xff, 0xf8, 0x0, 0x1f, 0xff, 0xf0, 0x0,
    0x1, 0xe1, 0xe0, 0x0, 0x3, 0xc3, 0xc0, 0x0,
    0x7, 0x87, 0xbf, 0xff, 0x8f, 0xf, 0x7f, 0xff,
    0x1e, 0x1e, 0x7, 0x0, 0x3c, 0x3c, 0xe, 0x0,
    0x78, 0x78, 0x1c, 0x0, 0xf0, 0xf0, 0x3a, 0x1,
    0xe1, 0xe0, 0x74, 0x3, 0xc3, 0xc0, 0xe4, 0x7,
    0x87, 0x83, 0xd8, 0xf, 0xf, 0x7, 0xb0, 0x1e,
    0x1e, 0xf, 0x60, 0x3c, 0x3c, 0x1c, 0xc0, 0x78,
    0x78, 0x39, 0xc0, 0xf0, 0xf0, 0x73, 0x81, 0xe1,
    0xe1, 0xc3, 0x3, 0xc3, 0xc3, 0x87, 0x7, 0x87,
    0x86, 0xe, 0xe, 0xf, 0x1c, 0x1e, 0x1c, 0x1e,
    0x30, 0x1e, 0x78, 0x3c, 0x40, 0x7c, 0xf0, 0x79,
    0x83, 0x39, 0xc0, 0xf6, 0x3c, 0x73, 0x81, 0xff,
    0xf0, 0xce, 0x3, 0xff, 0x80, 0x9c, 0x7, 0xfc,
    0x0, 0xb0, 0xf, 0x80, 0x0, 0xe0, 0x1e, 0x0,
    0x1, 0x80, 0x78, 0x0, 0x6, 0x0, 0xf0, 0x0,
    0x8, 0x3, 0xc0, 0x0, 0x20, 0x1f, 0x0, 0x0,
    0x80, 0xd8, 0x0,

    /* U+52A9 "助" */
    0x0, 0x0, 0x1e, 0x0, 0x3c, 0x3c, 0x3c, 0x0,
    0x78, 0x78, 0x78, 0x0, 0xff, 0xf0, 0xf0, 0x1,
    0xff, 0xe1, 0xe0, 0x3, 0xc3, 0xc3, 0xc0, 0x7,
    0x87, 0x87, 0x80, 0xf, 0xf, 0xf, 0x0, 0x1e,
    0x1e, 0x1e, 0x1e, 0x3c, 0x3c, 0x3c, 0x3c, 0x78,
    0x7b, 0xff, 0xf8, 0xf0, 0xf7, 0xff, 0xf1, 0xe1,
    0xe1, 0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7, 0xf7,
    0x87, 0x87, 0x8f, 0xef, 0xf, 0xf, 0x1e, 0x1e,
    0x1e, 0x1e, 0x3c, 0x3c, 0x3c, 0x3c, 0x78, 0x78,
    0x78, 0x78, 0xf0, 0xf0, 0xf0, 0xf1, 0xe1, 0xe1,
    0xe1, 0xe3, 0xc3, 0xc3, 0xc3, 0xc7, 0x87, 0x87,
    0x87, 0x8f, 0xf, 0xf, 0xf, 0x1e, 0x1e, 0x1e,
    0x1e, 0x3f, 0xbc, 0x3c, 0x3c, 0x7f, 0x78, 0x78,
    0x78, 0xf0, 0xf0, 0xf0, 0xf1, 0xe1, 0xe1, 0xe1,
    0xe3, 0xc3, 0xc3, 0xc3, 0xc7, 0x87, 0x87, 0x7,
    0x8f, 0xf, 0xe, 0xf, 0x1e, 0x1e, 0x1c, 0x1e,
    0x3c, 0x3c, 0x78, 0x3c, 0x78, 0x78, 0xe0, 0x78,
    0xf0, 0xfd, 0xc0, 0xf1, 0xe1, 0xf7, 0x1, 0xe3,
    0xc7, 0xce, 0x3, 0xc7, 0xbe, 0x18, 0x7, 0xff,
    0xf8, 0x60, 0xf, 0xff, 0xc0, 0xc0, 0x1f, 0xfc,
    0x3, 0x0, 0x3f, 0xc0, 0xc, 0x0, 0xf0, 0x0,
    0x30, 0x7, 0xc0, 0x0, 0xc0, 0x3f, 0x0, 0x3,
    0x0, 0x80, 0x0,

    /* U+52AA "努" */
    0x7, 0x0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x70,
    0x7, 0x0, 0x0, 0x70, 0xf, 0x0, 0xff, 0xf0,
    0xe, 0x0, 0xff, 0xf0, 0xe, 0x1e, 0x20, 0x70,
    0xff, 0xfe, 0x20, 0x70, 0xff, 0xfe, 0x20, 0x70,
    0x1e, 0x1e, 0x20, 0x70, 0x1c, 0x1e, 0x20, 0x70,
    0x1c, 0x1e, 0x30, 0xe0, 0x1c, 0x1e, 0x30, 0xe0,
    0x1c, 0x1e, 0x18, 0xe0, 0x3c, 0x1e, 0x18, 0xe0,
    0x38, 0x1c, 0x1d, 0xc0, 0x3e, 0x1c, 0xd, 0xc0,
    0x3b, 0xb8, 0xf, 0x80, 0x38, 0xf8, 0x7, 0x80,
    0x0, 0x7c, 0x7, 0xc0, 0x0, 0xff, 0x7, 0xe0,
    0x1, 0xdf, 0xd, 0xf8, 0x3, 0x8f, 0x18, 0xff,
    0x7, 0x7, 0x30, 0x7e, 0xc, 0x3, 0x60, 0x3e,
    0x38, 0x0, 0xc0, 0xe, 0x60, 0x79, 0x80, 0x6,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x3, 0xc0,
    0x3f, 0xff, 0xff, 0xc0, 0x3f, 0xff, 0xff, 0xc0,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x78, 0x3, 0xc0, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0x70, 0x3, 0xc0, 0x0, 0xf0, 0x3, 0xc0,
    0x0, 0xe0, 0x3, 0xc0, 0x1, 0xc0, 0x3, 0xc0,
    0x1, 0x80, 0x3, 0xc0, 0x3, 0x0, 0x3, 0xc0,
    0x6, 0x0, 0x7, 0x80, 0xc, 0x0, 0xf, 0x80,
    0x30, 0x0, 0x3f, 0x0, 0x60, 0x0, 0xec, 0x0,

    /* U+52AB "劫" */
    0x1, 0xe0, 0xf, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x7, 0x80, 0x3c, 0x0, 0xf, 0x0, 0x78, 0x0,
    0x1e, 0x0, 0xf0, 0x0, 0x3c, 0x1, 0xe0, 0x0,
    0x78, 0x3, 0xc0, 0x0, 0xf0, 0x7, 0x80, 0x3f,
    0xff, 0x8f, 0x0, 0x7f, 0xff, 0x1e, 0x0, 0x7,
    0x80, 0x3c, 0x78, 0xf, 0x7, 0xff, 0xf0, 0x1e,
    0xf, 0xff, 0xe0, 0x3c, 0x1, 0xe3, 0xc0, 0x78,
    0x3, 0xc7, 0x80, 0xf0, 0x7, 0x8f, 0x1, 0xe0,
    0xf, 0x1e, 0x3, 0xc0, 0x1e, 0x3c, 0x7, 0x80,
    0x3c, 0x7f, 0xff, 0xfe, 0x78, 0xff, 0xff, 0xfc,
    0xf1, 0xe0, 0x78, 0x1, 0xe3, 0xc0, 0xf0, 0x3,
    0xc7, 0x81, 0xe0, 0x7, 0x8f, 0x3, 0xc8, 0xf,
    0x1e, 0x7, 0x90, 0x1e, 0x3c, 0xe, 0x20, 0x3c,
    0x78, 0x1c, 0x60, 0x78, 0xf0, 0x38, 0xc0, 0xf1,
    0xe0, 0x61, 0x81, 0xe3, 0xc1, 0xc3, 0x83, 0xc7,
    0x83, 0x87, 0x7, 0x8f, 0x6, 0x7, 0xf, 0x1e,
    0xc, 0xf, 0x1e, 0x3c, 0x30, 0x1f, 0x3c, 0x78,
    0x40, 0xdc, 0x70, 0xf0, 0x87, 0x38, 0xe1, 0xef,
    0xfc, 0x73, 0xc3, 0xdf, 0xf0, 0x67, 0x7, 0xbf,
    0x80, 0xdc, 0xf, 0x3c, 0x0, 0x38, 0x1e, 0xc0,
    0x0, 0xc0, 0x3c, 0x0, 0x3, 0x0, 0xf0, 0x0,
    0xc, 0x3, 0xc0, 0x0, 0x30, 0x1f, 0x0, 0x0,
    0xc0, 0x40, 0x0,

    /* U+52AC "劬" */
    0xf, 0x80, 0x1, 0xc0, 0xf, 0x80, 0x1, 0xc0,
    0xf, 0x0, 0x1, 0xc0, 0xf, 0x0, 0x1, 0xc0,
    0xf, 0x0, 0x1, 0xc0, 0xf, 0x1, 0xc1, 0xc0,
    0xf, 0x1, 0xc1, 0xc0, 0xf, 0xff, 0xc1, 0xc0,
    0xf, 0xff, 0xc1, 0xc7, 0xe, 0x1, 0xc1, 0xc7,
    0xc, 0x1, 0xcf, 0xff, 0x1c, 0x1, 0xcf, 0xff,
    0x18, 0x1, 0xc1, 0xc7, 0x10, 0x1, 0xc1, 0xc7,
    0x30, 0x1, 0xc1, 0xc7, 0x3c, 0x71, 0xc1, 0xc7,
    0x5c, 0x71, 0xc1, 0xc7, 0xdf, 0xf1, 0xc1, 0xc7,
    0x1c, 0x71, 0xc1, 0xc7, 0x1c, 0x71, 0xc1, 0xc7,
    0x1c, 0x71, 0xc1, 0xc7, 0x1c, 0x71, 0xc1, 0xc7,
    0x1c, 0x71, 0xc1, 0xc7, 0x1c, 0x71, 0xc1, 0xc7,
    0x1c, 0x71, 0xc1, 0xc7, 0x1c, 0x71, 0xc1, 0xc7,
    0x1c, 0x71, 0xc1, 0xc7, 0x1c, 0x71, 0xc1, 0xc7,
    0x1c, 0x71, 0xc1, 0xc7, 0x1f, 0xf1, 0xc1, 0xc7,
    0x1f, 0xf1, 0xc1, 0xc7, 0x1c, 0x71, 0xc1, 0xc7,
    0x1c, 0x71, 0xc3, 0x87, 0x1c, 0x71, 0xc3, 0x87,
    0x1c, 0x1, 0xc3, 0x87, 0x0, 0x1, 0xc3, 0x87,
    0x0, 0x1, 0xc3, 0x7, 0x0, 0x1, 0xc7, 0x7,
    0x0, 0x1, 0xc6, 0x7, 0x0, 0x1, 0xce, 0x7,
    0x0, 0x1, 0xcc, 0x7, 0x0, 0x3, 0x98, 0x7,
    0x0, 0x7, 0x18, 0xf, 0x0, 0x1e, 0x30, 0x1e,
    0x0, 0xe8, 0x60, 0x7c, 0x0, 0x0, 0x81, 0xd8,

    /* U+52AD "劭" */
    0x0, 0x7, 0xf, 0x1, 0xff, 0xfc, 0x3c, 0x7,
    0xff, 0xf0, 0xf0, 0x3, 0xc1, 0xc3, 0xc0, 0xf,
    0x7, 0xf, 0x0, 0x3c, 0x1c, 0x3c, 0x0, 0xf0,
    0x70, 0xf0, 0x3, 0xc1, 0xc3, 0xc0, 0xf, 0x7,
    0xf, 0x1c, 0x3c, 0x1c, 0x3c, 0x70, 0xf0, 0x73,
    0xff, 0xc3, 0xc1, 0xcf, 0xff, 0xe, 0x7, 0xf,
    0x1c, 0x38, 0x1c, 0x3c, 0x70, 0xc0, 0x70, 0xf1,
    0xc7, 0x1, 0xc3, 0xc7, 0x18, 0x7, 0xf, 0x1c,
    0xc0, 0x38, 0x3c, 0x76, 0x7, 0xc0, 0xf1, 0xd0,
    0x20, 0x3, 0xc7, 0x80, 0x0, 0xf, 0x1c, 0xe0,
    0x1c, 0x3c, 0x73, 0x80, 0x70, 0xf1, 0xcf, 0xff,
    0xc3, 0xc7, 0x3f, 0xff, 0xf, 0x1c, 0xe0, 0x1c,
    0x3c, 0x73, 0x80, 0x70, 0xf1, 0xce, 0x1, 0xc3,
    0xc7, 0x38, 0x7, 0xf, 0x1c, 0xe0, 0x1c, 0x3c,
    0x73, 0x80, 0x70, 0xf1, 0xce, 0x1, 0xc3, 0xc7,
    0x38, 0x7, 0xf, 0x1c, 0xe0, 0x1c, 0x38, 0x73,
    0x80, 0x71, 0xe1, 0xce, 0x1, 0xc7, 0x87, 0x38,
    0x7, 0x1c, 0x1c, 0xe0, 0x1c, 0x70, 0x73, 0xff,
    0xf3, 0x81, 0xcf, 0xff, 0xce, 0x7, 0x38, 0x7,
    0x70, 0x1c, 0xe0, 0x1d, 0x80, 0x73, 0x80, 0x7e,
    0x3, 0xce, 0x0, 0x30, 0x1e, 0x0, 0x1, 0x80,
    0xf0, 0x0, 0x4, 0xf, 0x80, 0x0, 0x0, 0x40,
    0x0,

    /* U+52B1 "励" */
    0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x7, 0x80,
    0x1f, 0xff, 0xc7, 0x80, 0x1f, 0xff, 0xc7, 0x80,
    0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x7, 0x80,
    0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x7, 0x80,
    0x1e, 0x0, 0x7, 0x8f, 0x1e, 0x0, 0x7, 0x8f,
    0x1f, 0xff, 0x9f, 0xff, 0x1f, 0xff, 0x9f, 0xff,
    0x1e, 0x70, 0x7, 0x8f, 0x1e, 0x70, 0x7, 0x8f,
    0x1e, 0x70, 0x7, 0x8f, 0x1e, 0x70, 0x7, 0x8f,
    0x1e, 0x70, 0x7, 0x8f, 0x1e, 0x70, 0x7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1e, 0x7f, 0xc7, 0x8f,
    0x1e, 0x7f, 0xc7, 0x8f, 0x1e, 0x73, 0xc7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1e, 0x73, 0xc7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1e, 0x73, 0xc7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1e, 0x73, 0xc7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1e, 0x73, 0xc7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1e, 0x73, 0xc7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1e, 0x73, 0xc7, 0x8f,
    0x1e, 0x73, 0xc7, 0x8f, 0x1c, 0x63, 0xc7, 0xf,
    0x1c, 0xe3, 0xcf, 0xf, 0x1c, 0xe3, 0xce, 0xf,
    0x18, 0xc3, 0xce, 0xf, 0x39, 0xc3, 0xdc, 0xf,
    0x31, 0x83, 0xdc, 0xf, 0x33, 0x3, 0xf8, 0xf,
    0x63, 0x7, 0xb0, 0x1e, 0x46, 0xf, 0x60, 0x3c,
    0xcc, 0x3e, 0xc0, 0xf8, 0x8, 0x0, 0x83, 0x80,

    /* U+52B2 "劲" */
    0x0, 0x1e, 0x1e, 0x0, 0x0, 0x1e, 0x1e, 0x0,
    0x7f, 0xfc, 0x1e, 0x0, 0x7f, 0xfc, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x78, 0x1e, 0x0,
    0x0, 0x78, 0x1e, 0x0, 0x0, 0x70, 0x1e, 0x1e,
    0x0, 0xf0, 0x1e, 0x1e, 0x0, 0xe0, 0xff, 0xfe,
    0x1, 0xe0, 0xff, 0xfe, 0x1, 0xf0, 0x1e, 0x1e,
    0x3, 0xb8, 0x1e, 0x1e, 0x7, 0x1c, 0x1e, 0x1e,
    0x6, 0x1f, 0x1e, 0x1e, 0xc, 0xf, 0x1e, 0x1e,
    0x18, 0x7, 0x1e, 0x1e, 0x10, 0x3, 0x1e, 0x1e,
    0x20, 0x1, 0x1e, 0x1e, 0x40, 0x0, 0x1e, 0x1e,
    0x0, 0x0, 0x1e, 0x1e, 0x0, 0x0, 0x1e, 0x1e,
    0x7f, 0xff, 0x1e, 0x1e, 0x7f, 0xff, 0x1e, 0x1e,
    0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e,
    0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e,
    0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e,
    0x1, 0xe0, 0x1c, 0x1e, 0x1, 0xe0, 0x7c, 0x1e,
    0x1, 0xe0, 0xbc, 0x1e, 0x1, 0xe3, 0x38, 0x1e,
    0x1, 0xee, 0x38, 0x1e, 0x1, 0xf8, 0x70, 0x1e,
    0x7f, 0xf0, 0x60, 0x1e, 0x7f, 0xc0, 0xe0, 0x1e,
    0x7f, 0x80, 0xc0, 0x1e, 0x7c, 0x1, 0x80, 0x1e,
    0x70, 0x3, 0x80, 0x3c, 0x0, 0x3, 0x0, 0x78,
    0x0, 0x6, 0x1, 0xe0, 0x0, 0xc, 0x6, 0x0,

    /* U+52B3 "劳" */
    0x0, 0x78, 0x3c, 0x0, 0x0, 0xf0, 0x78, 0x0,
    0x1, 0xe0, 0xf0, 0x0, 0x3, 0xc1, 0xe0, 0x0,
    0x7, 0x83, 0xc0, 0x0, 0xf, 0x7, 0x80, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x78, 0x3c, 0x0, 0x0, 0xf0, 0x78, 0x0, 0x1,
    0xe0, 0xf0, 0x0, 0x3, 0xc1, 0xe0, 0x0, 0x7,
    0x83, 0xc0, 0x0, 0xf, 0x7, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x1e, 0xf0, 0x0,
    0x0, 0x3d, 0xff, 0xff, 0xff, 0xfb, 0xc0, 0x0,
    0x0, 0xf7, 0x80, 0x0, 0x1, 0xef, 0x0, 0x0,
    0x3, 0xde, 0xf, 0x0, 0x7, 0xbc, 0x1e, 0x0,
    0x8, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x7,
    0x80, 0x0, 0xf0, 0xf, 0x0, 0xff, 0xff, 0xfe,
    0x1, 0xff, 0xff, 0xfc, 0x0, 0x7, 0x80, 0x78,
    0x0, 0xf, 0x0, 0xf0, 0x0, 0x1e, 0x1, 0xe0,
    0x0, 0x3c, 0x3, 0xc0, 0x0, 0x78, 0x7, 0x80,
    0x0, 0xf0, 0xf, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x3, 0x80, 0x3c, 0x0, 0xf, 0x0, 0x78, 0x0,
    0x1e, 0x0, 0xf0, 0x0, 0x38, 0x1, 0xe0, 0x0,
    0xe0, 0x3, 0xc0, 0x3, 0x80, 0x7, 0x80, 0xe,
    0x0, 0xf, 0x0, 0x38, 0x0, 0x3c, 0x0, 0xe0,
    0x0, 0xf8, 0x3, 0x0, 0x7, 0xc0, 0x18, 0x0,
    0x32, 0x0, 0x0,

    /* U+52BB "劻" */
    0xe0, 0x0, 0x38, 0x7, 0x0, 0x1, 0xc0, 0x38,
    0x0, 0xe, 0x1, 0xff, 0xfc, 0x70, 0xf, 0xff,
    0xe3, 0x80, 0x70, 0x0, 0x1c, 0x3, 0x80, 0x0,
    0xe0, 0x1c, 0x0, 0x7, 0x0, 0xe0, 0x0, 0x38,
    0x3f, 0x0, 0x1, 0xc1, 0xfb, 0xff, 0xbf, 0xff,
    0xdf, 0xfd, 0xff, 0xfe, 0xe, 0x3, 0x83, 0xf0,
    0x70, 0x1c, 0x1f, 0x83, 0x80, 0xe0, 0xfc, 0x1c,
    0x7, 0x7, 0xe0, 0xe0, 0x38, 0x3f, 0x7, 0x1,
    0xc1, 0xf8, 0x38, 0xe, 0xf, 0xc1, 0xc0, 0x70,
    0x7e, 0xe, 0x3, 0x83, 0xf7, 0xff, 0x1c, 0x1f,
    0xbf, 0xf8, 0xe0, 0xfc, 0x1c, 0x7, 0x7, 0xe0,
    0xe0, 0x38, 0x3f, 0x7, 0x1, 0xc1, 0xf8, 0x38,
    0xe, 0xf, 0xc1, 0xc0, 0x70, 0x7e, 0xe, 0x3,
    0x83, 0xf0, 0x70, 0x1c, 0x1f, 0x83, 0x80, 0xe0,
    0xfc, 0x1c, 0x7, 0x7, 0xe0, 0xe0, 0x38, 0x3f,
    0x7f, 0xf1, 0xc1, 0xfb, 0xff, 0x8e, 0xf, 0xc0,
    0x0, 0x60, 0x7e, 0x0, 0x3, 0x3, 0xf0, 0x0,
    0x38, 0x1f, 0x80, 0x1, 0x80, 0xfc, 0x0, 0xc,
    0x7, 0xff, 0xfe, 0xc0, 0x3f, 0xff, 0xf6, 0x3,
    0xf8, 0x0, 0x60, 0x3d, 0xc0, 0x2, 0x3, 0xc0,
    0x0, 0x30, 0x7c, 0x0, 0x3, 0x4, 0x0,

    /* U+52BE "劾" */
    0x1, 0x80, 0x1e, 0x0, 0x1, 0x80, 0x3c, 0x0,
    0x3, 0xc0, 0x78, 0x0, 0x3, 0x80, 0xf0, 0x0,
    0x7, 0x1, 0xe0, 0x0, 0x4, 0x3, 0xc0, 0x1f,
    0xff, 0xf7, 0x80, 0x3f, 0xff, 0xef, 0x0, 0x3,
    0xc0, 0x1e, 0x0, 0x7, 0x80, 0x3c, 0x3c, 0xf,
    0x0, 0x78, 0x78, 0x1e, 0x7, 0xff, 0xf0, 0x39,
    0xef, 0xff, 0xe0, 0xf3, 0xc3, 0xc3, 0xc1, 0xc7,
    0x87, 0x87, 0x83, 0xf, 0xf, 0xf, 0xe, 0x1c,
    0x1e, 0x1e, 0x18, 0x38, 0x3c, 0x3c, 0x60, 0xf0,
    0x78, 0x79, 0x87, 0xe0, 0xf0, 0xf7, 0xfb, 0x81,
    0xe1, 0xe7, 0xef, 0x3, 0xc3, 0xcf, 0x1c, 0x7,
    0x87, 0xb0, 0x38, 0xf, 0xf, 0x0, 0xe0, 0x1e,
    0x1e, 0x1, 0xde, 0x3c, 0x3c, 0x7, 0x3c, 0x78,
    0x78, 0xc, 0x78, 0xf0, 0xf0, 0x38, 0xf1, 0xe1,
    0xe0, 0xe1, 0xc3, 0xc3, 0xc1, 0x87, 0x87, 0x87,
    0x86, 0xf, 0xf, 0xf, 0x18, 0x1c, 0x1e, 0x1e,
    0x60, 0x78, 0x3c, 0x3c, 0x80, 0xf0, 0x78, 0x7a,
    0x3, 0xf0, 0xe0, 0xf0, 0x7, 0x63, 0xc1, 0xe0,
    0x1c, 0xe7, 0x3, 0xc0, 0x31, 0xee, 0x7, 0x80,
    0xc1, 0xb8, 0xf, 0x3, 0x3, 0x60, 0x1e, 0xc,
    0x7, 0xc0, 0x7c, 0x30, 0x7, 0x1, 0xf0, 0xc0,
    0xc, 0x7, 0xc3, 0x0, 0x20, 0x1e, 0xc, 0x0,
    0x80, 0xc0, 0x0,

    /* U+52BF "势" */
    0x7, 0x80, 0xf0, 0x0, 0xf, 0x1, 0xe0, 0x0,
    0x1e, 0x3, 0xc0, 0x0, 0x3c, 0x7, 0x80, 0x0,
    0x78, 0xf, 0x0, 0x1f, 0xff, 0x1e, 0x1c, 0x3f,
    0xfe, 0x3f, 0xf8, 0x3, 0xc3, 0xff, 0xf0, 0x7,
    0x87, 0xf0, 0xe0, 0xf, 0x1, 0xe1, 0xc0, 0x1e,
    0x3, 0xc3, 0x80, 0x3c, 0xc7, 0x87, 0x0, 0x7f,
    0x4f, 0xe, 0x0, 0xfc, 0x7e, 0x1c, 0x3f, 0xf0,
    0xfc, 0x38, 0x7f, 0xc0, 0xf8, 0x72, 0xff, 0x80,
    0xf8, 0xe5, 0xcf, 0x3, 0xf9, 0xe8, 0x1e, 0x7,
    0xf3, 0xd0, 0x3c, 0x1f, 0xe7, 0xe0, 0x78, 0x39,
    0xc7, 0xc0, 0xf0, 0xe1, 0x8f, 0xc1, 0xe1, 0xc0,
    0xf, 0x8f, 0x87, 0x0, 0x1f, 0x7e, 0x18, 0x0,
    0x1e, 0x0, 0x20, 0x0, 0x1c, 0x1, 0xe0, 0x0,
    0x8, 0x3, 0xc0, 0x1e, 0x3, 0xff, 0xff, 0xfc,
    0x7, 0xff, 0xff, 0xf8, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x78, 0x3, 0xc0,
    0x0, 0xf0, 0x7, 0x80, 0x1, 0xe0, 0xf, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0x3c, 0x0, 0xf0, 0x0,
    0xf0, 0x1, 0xe0, 0x1, 0xe0, 0x3, 0xc0, 0x7,
    0x80, 0x7, 0x80, 0x1e, 0x0, 0xf, 0x0, 0x70,
    0x0, 0x3c, 0x1, 0xc0, 0x0, 0xf8, 0xe, 0x0,
    0x7, 0xc0, 0x0,

    /* U+52C1 "勁" */
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x78, 0xf,
    0xff, 0xf9, 0xe0, 0x3f, 0xff, 0xe7, 0x80, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x78, 0x3, 0x9c,
    0xf1, 0xe0, 0xe, 0x73, 0xc7, 0x80, 0x39, 0xcf,
    0x1e, 0x3c, 0xe7, 0x38, 0x78, 0xf3, 0x18, 0xe1,
    0xe3, 0xcc, 0xe7, 0x3f, 0xff, 0x33, 0x1c, 0xff,
    0xfd, 0x8c, 0x60, 0x78, 0xf4, 0x21, 0x1, 0xe3,
    0xd0, 0x84, 0x7, 0x8f, 0x43, 0x18, 0x1e, 0x3d,
    0x8e, 0x38, 0x78, 0xf3, 0x1c, 0xf1, 0xe3, 0xcf,
    0x79, 0xe7, 0x8f, 0x18, 0xc7, 0x1e, 0x3c, 0x63,
    0xc, 0x78, 0xf0, 0x80, 0x21, 0xe3, 0xc0, 0x0,
    0x7, 0x8f, 0x0, 0x0, 0x1e, 0x3f, 0xff, 0xfc,
    0x78, 0xff, 0xff, 0xf1, 0xe3, 0xc0, 0xe0, 0x7,
    0x8f, 0x3, 0x80, 0x1e, 0x3c, 0xe, 0x0, 0x70,
    0xf0, 0x38, 0x1, 0xc3, 0xc0, 0xe0, 0xf, 0xf,
    0x3, 0x80, 0x3c, 0x3c, 0xe, 0x0, 0xe0, 0xf0,
    0x38, 0x1b, 0x83, 0xc0, 0xe1, 0x9c, 0xf, 0x3,
    0x9c, 0x70, 0x3c, 0xf, 0xe1, 0x80, 0xff, 0xfe,
    0xe, 0x3, 0xff, 0xf0, 0x30, 0xf, 0xff, 0x1,
    0x80, 0x3f, 0xe0, 0xc, 0x0, 0xfc, 0x0, 0x20,
    0x7, 0x80, 0x1, 0x0, 0x1c, 0x0, 0x8, 0x1,
    0xe0, 0x0, 0x40, 0x3a, 0x0,

    /* U+52C3 "勃" */
    0x1, 0xe0, 0x1e, 0x0, 0x7, 0x80, 0x78, 0x0,
    0x1e, 0x1, 0xe0, 0x0, 0x78, 0x7, 0x80, 0x1,
    0xe0, 0x1e, 0x3, 0xff, 0xfe, 0x78, 0xf, 0xff,
    0xf9, 0xe0, 0x0, 0x78, 0x7, 0x80, 0x1, 0xe0,
    0x1e, 0x0, 0x7, 0x80, 0x78, 0xff, 0x1e, 0x79,
    0xe3, 0xfc, 0x79, 0xff, 0xff, 0xff, 0xff, 0x9e,
    0x3f, 0xff, 0xfe, 0x78, 0xff, 0x0, 0x79, 0xe3,
    0xfc, 0x1, 0xe7, 0x8f, 0xf0, 0x6, 0x1e, 0x3f,
    0xc0, 0x0, 0x78, 0xf0, 0x0, 0x31, 0xe3, 0xdf,
    0xff, 0xc7, 0x8f, 0x7f, 0xfe, 0x1e, 0x3c, 0x0,
    0x70, 0x78, 0xf0, 0x3, 0x81, 0xe3, 0xc0, 0x18,
    0x7, 0x8f, 0x0, 0xc0, 0x1e, 0x3c, 0xf, 0x80,
    0x78, 0xf0, 0x7e, 0x9, 0xe3, 0xc0, 0x78, 0x47,
    0x8f, 0x1, 0xe3, 0x1e, 0x3c, 0x7, 0xb8, 0x78,
    0xf0, 0x1f, 0xc1, 0xe3, 0xff, 0xfc, 0x7, 0x8f,
    0xff, 0xe0, 0x1e, 0x3f, 0xff, 0x80, 0x70, 0xff,
    0x1e, 0x1, 0xc3, 0xc0, 0x78, 0xf, 0xf, 0x1,
    0xe0, 0x38, 0x3c, 0x7, 0x80, 0xe0, 0xf0, 0x1e,
    0x7, 0x3, 0xc0, 0x78, 0x18, 0xf, 0x1, 0xe0,
    0xc0, 0x3c, 0x7, 0x83, 0x0, 0xf0, 0x3c, 0x18,
    0x7, 0x81, 0xe0, 0x80, 0x7c, 0x1e, 0x4, 0x3,
    0xc0, 0x90, 0x20, 0x10, 0x0,

    /* U+52C7 "勇" */
    0x0, 0x0, 0x0, 0x4, 0x7f, 0xff, 0xff, 0xf1,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xe0, 0x0, 0x10, 0xe, 0x0, 0x0,
    0x70, 0xe0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x78, 0x3, 0xc0, 0xf1, 0xff, 0xff,
    0xff, 0xc7, 0xff, 0xff, 0xff, 0x1e, 0x3, 0xc0,
    0x3c, 0x78, 0xf, 0x0, 0xf1, 0xe0, 0x3c, 0x3,
    0xc7, 0x80, 0xf0, 0xf, 0x1f, 0xff, 0xff, 0xfc,
    0x7f, 0xff, 0xff, 0xf1, 0xe0, 0x3c, 0x3, 0xc7,
    0x80, 0xf0, 0xf, 0x1e, 0x3, 0xc0, 0x3c, 0x7f,
    0xff, 0xff, 0xf1, 0xff, 0xff, 0xff, 0xc7, 0x80,
    0xf0, 0xf, 0x1e, 0x3, 0xc0, 0x3c, 0x78, 0xf,
    0x0, 0xf1, 0xe0, 0x3c, 0x3, 0xc7, 0x80, 0xf0,
    0xf, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x1, 0xe0, 0x3, 0xdf, 0xff, 0xff, 0xff,
    0x7f, 0xff, 0xff, 0xfc, 0x0, 0x78, 0x0, 0xf0,
    0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0,
    0x3c, 0x0, 0x3c, 0x0, 0xf0, 0x0, 0xf0, 0x3,
    0x80, 0x3, 0xc0, 0x1e, 0x0, 0xf, 0x0, 0xf0,
    0x0, 0x3c, 0x7, 0x80, 0x0, 0xf0, 0x38, 0x0,
    0x3, 0xc1, 0xc0, 0x0, 0x1e, 0xc, 0x0, 0x0,
    0xf0, 0xc0, 0x0, 0x1f, 0x86, 0x0, 0x1, 0x98,
    0x0,

    /* U+52C9 "勉" */
    0x7, 0x80, 0xe, 0x0, 0x7, 0x80, 0xe, 0x0,
    0x7, 0x80, 0xe, 0x0, 0xf, 0x1e, 0xe, 0x0,
    0xf, 0x1e, 0xe, 0x0, 0xf, 0xfe, 0xe, 0x0,
    0xf, 0xfc, 0xe, 0x0, 0xe, 0x1c, 0xe, 0x1c,
    0xe, 0x18, 0xe, 0x1c, 0x1c, 0x18, 0x3f, 0xfc,
    0x18, 0x30, 0x3f, 0xfc, 0x38, 0x63, 0xce, 0x1c,
    0x38, 0x43, 0x8e, 0x1c, 0x7f, 0xff, 0x8e, 0x1c,
    0x78, 0xe3, 0x8e, 0x1c, 0xb8, 0xe3, 0x8e, 0x1c,
    0x38, 0xe3, 0x8e, 0x1c, 0x38, 0xe3, 0x8e, 0x1c,
    0x38, 0xe3, 0x8e, 0x1c, 0x38, 0xe3, 0x8e, 0x1c,
    0x38, 0xe3, 0x8e, 0x1c, 0x38, 0xe3, 0x8e, 0x1c,
    0x38, 0xe3, 0x8e, 0x1c, 0x38, 0xe3, 0x8e, 0x1c,
    0x38, 0xe3, 0x8e, 0x1c, 0x3f, 0xff, 0x8e, 0x1c,
    0x39, 0xe3, 0x8e, 0x1c, 0x39, 0xe3, 0x8c, 0x1c,
    0x1, 0xe0, 0xc, 0x1c, 0x1, 0xfc, 0xc, 0x1c,
    0x1, 0xfc, 0x18, 0x1c, 0x1, 0xfc, 0x18, 0x1c,
    0x1, 0xbc, 0x18, 0x1c, 0x3, 0xbc, 0x30, 0x1c,
    0x3, 0xbc, 0x30, 0x3e, 0x3, 0x3c, 0x60, 0x3a,
    0x6, 0x3c, 0x40, 0xf2, 0x6, 0x3c, 0xc1, 0xe2,
    0x4, 0x3d, 0x86, 0x2, 0x8, 0x3c, 0x0, 0x3,
    0x18, 0x3c, 0x0, 0x7, 0x10, 0x3c, 0x0, 0x7,
    0x20, 0x3c, 0x0, 0x7, 0x20, 0x3f, 0xff, 0xff,
    0x40, 0x3f, 0xff, 0xff, 0x80, 0x1f, 0xff, 0xfe,

    /* U+52CA "勊" */
    0x1, 0xe0, 0x1c, 0x0, 0x3, 0xc0, 0x38, 0x0,
    0x7, 0x80, 0x70, 0x0, 0xf, 0x0, 0xe0, 0x0,
    0x1e, 0x1, 0xc0, 0x1f, 0xff, 0xf3, 0x80, 0x3f,
    0xff, 0xe7, 0x0, 0x0, 0xe0, 0xe, 0x1c, 0x1,
    0xc0, 0x1c, 0x38, 0x3, 0x80, 0xff, 0xf0, 0x6,
    0x0, 0x70, 0xe1, 0xcc, 0x78, 0xe1, 0xc3, 0x90,
    0xf1, 0xc3, 0x87, 0xff, 0xe3, 0x87, 0xf, 0xff,
    0xc7, 0xe, 0x1c, 0x7, 0x8e, 0x1c, 0x38, 0xf,
    0x1c, 0x38, 0x70, 0x1e, 0x38, 0x70, 0xe0, 0x3c,
    0x70, 0xe1, 0xc0, 0x78, 0xe1, 0xc3, 0x80, 0xf1,
    0xc3, 0x87, 0x1, 0xe3, 0x87, 0xe, 0x3, 0xc7,
    0xe, 0x1f, 0xff, 0x8e, 0x1c, 0x3f, 0xff, 0x1c,
    0x38, 0x70, 0x1e, 0x38, 0x70, 0xe0, 0x3c, 0x60,
    0xe0, 0x71, 0xe0, 0xc1, 0xc0, 0xe3, 0xc1, 0x83,
    0x81, 0xc7, 0x87, 0x7, 0x3, 0x8f, 0xc, 0xe,
    0x7, 0x1e, 0x18, 0x1c, 0xe, 0x3c, 0x20, 0x38,
    0x1c, 0x78, 0xc0, 0x74, 0x38, 0xf1, 0x80, 0xe8,
    0x71, 0xe2, 0x1, 0x90, 0xe3, 0xcc, 0x7, 0x61,
    0xc7, 0x90, 0x38, 0xc7, 0xf, 0x61, 0xe1, 0x8e,
    0x1e, 0x0, 0x3, 0x18, 0x3c, 0x0, 0x6, 0x30,
    0x78, 0x0, 0xc, 0xc0, 0xff, 0xff, 0xf9, 0x1,
    0xff, 0xff, 0xf6, 0x1, 0xff, 0xff, 0xc8, 0x0,
    0x0, 0x0, 0x0,

    /* U+52CB "勋" */
    0x1e, 0x7, 0x8f, 0x0, 0x3c, 0xf, 0x1e, 0x0,
    0x7f, 0xfe, 0x3c, 0x0, 0xff, 0xfc, 0x78, 0x1,
    0xe0, 0x78, 0xf0, 0x3, 0xc0, 0xf1, 0xe0, 0x7,
    0x81, 0xe3, 0xc0, 0xf, 0x3, 0xc7, 0x8f, 0x1e,
    0x7, 0x8f, 0x1e, 0x3c, 0xf, 0x1e, 0x3c, 0x7f,
    0xfe, 0xff, 0xf8, 0xff, 0xfd, 0xff, 0xf1, 0xe0,
    0x78, 0xf1, 0xe0, 0x0, 0x1, 0xe3, 0xc0, 0x0,
    0x3, 0xc7, 0xbc, 0x1, 0xc7, 0x8f, 0x78, 0x3,
    0x8f, 0x1e, 0xff, 0xff, 0x1e, 0x3d, 0xff, 0xfe,
    0x3c, 0x7b, 0xc0, 0x1c, 0x78, 0xf7, 0x80, 0x38,
    0xf1, 0xef, 0x1c, 0x71, 0xe3, 0xde, 0x38, 0xe3,
    0xc7, 0xbc, 0x71, 0xc7, 0x8f, 0x78, 0xe3, 0x8f,
    0x1e, 0xf1, 0xc7, 0x1e, 0x3d, 0xe3, 0x8e, 0x3c,
    0x7b, 0xc7, 0x1c, 0x78, 0xf7, 0x8e, 0x38, 0xf1,
    0xef, 0x1c, 0x71, 0xe3, 0xde, 0x38, 0xe3, 0xc7,
    0xbc, 0x71, 0xc7, 0x8f, 0x78, 0xe3, 0x8f, 0x1e,
    0xf1, 0xc7, 0x1e, 0x3d, 0xe3, 0x8e, 0x38, 0x7b,
    0xcf, 0x38, 0x70, 0xf0, 0x1d, 0x40, 0xe1, 0xe0,
    0x3b, 0x1, 0xc3, 0xc0, 0x67, 0x83, 0x7, 0x81,
    0x87, 0xce, 0xf, 0x6, 0xf, 0x98, 0x1e, 0x8,
    0xf, 0x30, 0x3c, 0x20, 0xe, 0xc0, 0x78, 0x80,
    0xd, 0x3, 0xe2, 0x0, 0xe, 0xf, 0x18, 0x0,
    0x18, 0xf8, 0x0,

    /* U+52D0 "勐" */
    0x1f, 0xff, 0x87, 0x0, 0x3f, 0xff, 0xe, 0x0,
    0x0, 0x1e, 0x1c, 0x0, 0x0, 0x70, 0x38, 0x0,
    0x1, 0x80, 0x70, 0x0, 0xe, 0x0, 0xe0, 0x0,
    0x38, 0x1, 0xc0, 0x0, 0xf8, 0x3, 0x80, 0x0,
    0xf0, 0x7, 0x0, 0x1, 0xe0, 0xe, 0x1c, 0x3,
    0xc0, 0x1c, 0x3f, 0xff, 0xfd, 0xff, 0xff, 0xff,
    0xfb, 0xff, 0xe0, 0x1c, 0x0, 0xe1, 0xc0, 0x38,
    0x1, 0xc3, 0x80, 0x70, 0x3, 0x87, 0x0, 0xe0,
    0x7, 0xe, 0x1, 0xc0, 0xe, 0x1c, 0x3, 0x80,
    0x1c, 0x38, 0x7, 0x0, 0x38, 0x70, 0x1c, 0x0,
    0x70, 0xe0, 0xf0, 0x0, 0xe1, 0xce, 0x0, 0x71,
    0xc3, 0x9f, 0xff, 0xe3, 0x87, 0x3f, 0xff, 0xc7,
    0xe, 0x73, 0x73, 0x8e, 0x1c, 0xe6, 0xe7, 0x1c,
    0x39, 0xcd, 0xce, 0x38, 0x73, 0x9b, 0x9c, 0x70,
    0xe7, 0x37, 0x38, 0xe1, 0xce, 0x6e, 0x71, 0xc3,
    0x9c, 0xdc, 0xe3, 0x87, 0x39, 0xb9, 0xc6, 0xe,
    0x73, 0x73, 0x8c, 0x1c, 0xe6, 0xe7, 0x38, 0x39,
    0xcd, 0xcf, 0xf0, 0x73, 0x9b, 0x9c, 0xc0, 0xe7,
    0x37, 0x71, 0x81, 0xce, 0x6f, 0x86, 0x3, 0x9f,
    0xfc, 0xc, 0x7, 0xff, 0xe0, 0x30, 0xf, 0xfe,
    0x0, 0x60, 0x3b, 0xe0, 0x1, 0x80, 0x76, 0x0,
    0x2, 0x3, 0xc0, 0x0, 0xc, 0x1f, 0x0, 0x0,
    0x30, 0xd8, 0x0,

    /* U+52D2 "勒" */
    0xf, 0xe, 0x7, 0x0, 0x3c, 0x38, 0x1c, 0x0,
    0xf0, 0xe0, 0x70, 0x3, 0xc3, 0x81, 0xc0, 0xf,
    0xe, 0x7, 0x3, 0xff, 0xff, 0x9c, 0xf, 0xff,
    0xfe, 0x70, 0x3, 0xc3, 0x81, 0xc0, 0xf, 0xe,
    0x7, 0x0, 0x3c, 0x38, 0x1c, 0x70, 0xff, 0xe0,
    0x71, 0xc3, 0xff, 0x9f, 0xff, 0xf, 0xfe, 0x7f,
    0xfc, 0x3f, 0xf8, 0x1c, 0x70, 0xe, 0x0, 0x71,
    0xc0, 0x38, 0x1, 0xc7, 0x0, 0xe0, 0x7, 0x1c,
    0xe3, 0x8e, 0x1c, 0x73, 0xff, 0xf8, 0x71, 0xcf,
    0xff, 0xe1, 0xc7, 0x38, 0xe3, 0x87, 0x1c, 0xe3,
    0x8e, 0x1c, 0x73, 0x8e, 0x38, 0x71, 0xce, 0x38,
    0xe1, 0xc7, 0x38, 0xe3, 0x87, 0x1c, 0xe3, 0x8e,
    0x1c, 0x73, 0xff, 0xf8, 0x71, 0xcf, 0xff, 0xe1,
    0xc7, 0x38, 0xe3, 0x87, 0x1c, 0x3, 0x80, 0x1c,
    0x70, 0xe, 0x0, 0x71, 0xc0, 0x38, 0x1, 0xc7,
    0x0, 0xe0, 0x7, 0x1f, 0xff, 0xff, 0x9c, 0x7f,
    0xff, 0xfe, 0x71, 0xc0, 0x38, 0x1, 0x87, 0x0,
    0xe0, 0x6, 0x1c, 0x3, 0x80, 0x38, 0x70, 0xe,
    0x0, 0xc1, 0xc0, 0x38, 0x3, 0x7, 0x0, 0xe0,
    0x18, 0x1c, 0x3, 0x80, 0x40, 0x70, 0xe, 0x3,
    0x1, 0xc0, 0x38, 0x8, 0x1f, 0x0, 0xe0, 0x41,
    0xf8, 0x3, 0x82, 0x9, 0x80,

    /* U+52D5 "動" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x3c, 0x3c, 0x0,
    0x3, 0xfc, 0x78, 0x0, 0x3f, 0xfc, 0xf0, 0x3,
    0xfe, 0x1, 0xe0, 0x18, 0x38, 0x3, 0xc0, 0x0,
    0x70, 0x7, 0x80, 0x0, 0xe0, 0xf, 0x0, 0x1,
    0xc0, 0x1e, 0x1, 0xff, 0xff, 0x3c, 0x3, 0xff,
    0xfe, 0x78, 0xf0, 0xe, 0x0, 0xf1, 0xe0, 0x1c,
    0x7, 0xff, 0xce, 0x38, 0xef, 0xff, 0x9c, 0x71,
    0xc7, 0x8f, 0x3f, 0xff, 0x8f, 0x1e, 0x71, 0xc7,
    0x1e, 0x3c, 0xe3, 0x8e, 0x3c, 0x79, 0xc7, 0x1c,
    0x78, 0xf3, 0x8e, 0x38, 0xf1, 0xe7, 0xff, 0xf1,
    0xe3, 0xcf, 0xff, 0xe3, 0xc7, 0x9c, 0x71, 0xc7,
    0x8f, 0x38, 0xe3, 0x8f, 0x1e, 0x71, 0xc7, 0x1e,
    0x3c, 0xe3, 0x8e, 0x3c, 0x79, 0xff, 0xfc, 0x78,
    0xf3, 0xff, 0xf8, 0xf1, 0xe7, 0x1c, 0x71, 0xe3,
    0xce, 0x38, 0xe3, 0xc7, 0x80, 0x70, 0x7, 0x8f,
    0x0, 0xe0, 0xe, 0x1e, 0xff, 0xff, 0x9c, 0x3d,
    0xff, 0xff, 0x38, 0x78, 0x7, 0x0, 0x70, 0xf0,
    0xe, 0x1, 0xe1, 0xe0, 0x1c, 0xb, 0x83, 0xc0,
    0x38, 0x27, 0x7, 0x80, 0x73, 0x9c, 0xf, 0x0,
    0xfc, 0x38, 0x1e, 0xff, 0xe0, 0x60, 0x3d, 0xff,
    0x1, 0x80, 0x7b, 0xf8, 0x7, 0x0, 0xf7, 0x80,
    0xc, 0x3, 0xc8, 0x0, 0x30, 0xf, 0x0, 0x0,
    0xc0, 0x3c, 0x0, 0x3, 0x1, 0xa0, 0x0,

    /* U+52D6 "勖" */
    0xe0, 0xe, 0x1c, 0x7, 0x0, 0x70, 0xe0, 0x3f,
    0xff, 0x87, 0x1, 0xff, 0xfc, 0x38, 0xe, 0x0,
    0xe1, 0xc0, 0x70, 0x7, 0xe, 0x3, 0x80, 0x38,
    0x70, 0x1d, 0xf9, 0xc3, 0x80, 0xef, 0xce, 0x1c,
    0x3f, 0x0, 0x70, 0xe1, 0xf8, 0x3, 0xbf, 0xff,
    0xc0, 0x1d, 0xff, 0xfe, 0x0, 0xe1, 0xc3, 0xf0,
    0x7, 0xe, 0x1f, 0xbf, 0x38, 0x70, 0xfd, 0xf9,
    0xc3, 0x87, 0xe0, 0xe, 0x1c, 0x38, 0x0, 0x0,
    0xe1, 0xc0, 0x0, 0x7, 0xe, 0xf0, 0x38, 0x38,
    0x77, 0xff, 0xc1, 0xc3, 0xbf, 0xfe, 0xe, 0x1d,
    0xc0, 0x70, 0x70, 0xee, 0x3, 0x83, 0x87, 0x70,
    0x1c, 0x1c, 0x3b, 0x80, 0xe0, 0xe1, 0xdc, 0x7,
    0x7, 0xe, 0xff, 0xb8, 0x38, 0x77, 0xfd, 0xc1,
    0xc3, 0xb8, 0xe, 0xe, 0x1d, 0xc0, 0x70, 0x70,
    0xee, 0x3, 0x83, 0x87, 0x70, 0x1c, 0x1c, 0x3b,
    0xfe, 0xe0, 0xe1, 0xdf, 0xf7, 0x7, 0xe, 0xe0,
    0x38, 0x30, 0x77, 0x1, 0xc3, 0x83, 0xb8, 0xe,
    0x18, 0x1d, 0xc0, 0x70, 0xc0, 0xee, 0x3, 0x8c,
    0x7, 0x7f, 0xfc, 0x60, 0x3b, 0xff, 0xe2, 0x3,
    0xdc, 0x7, 0x20, 0x3c, 0xe0, 0x3b, 0x3, 0xc7,
    0x0, 0x10, 0xfc, 0x0, 0x1, 0x0, 0x0,

    /* U+52D7 "勗" */
    0x3, 0xc0, 0x0, 0x3c, 0x0, 0xff, 0xff, 0xff,
    0x0, 0x3f, 0xff, 0xff, 0xc0, 0xf, 0x0, 0x0,
    0xf0, 0x3, 0xc0, 0x0, 0x3c, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0x3c, 0x0, 0x3, 0xc0, 0xf, 0xff,
    0xfc, 0xf0, 0x3, 0xff, 0xff, 0x3c, 0x0, 0xf0,
    0x0, 0xf, 0x0, 0x3c, 0x0, 0x3, 0xc0, 0xf,
    0x0, 0x0, 0xf0, 0x3, 0xff, 0xff, 0xfc, 0x0,
    0xff, 0xff, 0xff, 0x0, 0x3c, 0x0, 0x3, 0xc0,
    0xf, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x0, 0xf0, 0x1, 0xe0, 0xf0, 0x3c,
    0x0, 0x7f, 0xfc, 0xf, 0x0, 0x1f, 0xff, 0x3,
    0xc7, 0x87, 0x83, 0xc0, 0xf1, 0xe1, 0xe0, 0xf7,
    0xff, 0xf8, 0x78, 0x3d, 0xff, 0xfe, 0x1e, 0xf,
    0x3, 0xc7, 0x87, 0xfb, 0xc0, 0xf1, 0xe1, 0xfe,
    0xf0, 0x3c, 0x78, 0x78, 0x3c, 0xf, 0x1e, 0x1e,
    0xf, 0x3, 0xc7, 0x87, 0x83, 0xc0, 0xf1, 0xe1,
    0xe0, 0xf0, 0x3c, 0x78, 0x78, 0x3c, 0xe, 0x1e,
    0x1f, 0xef, 0x7, 0x87, 0x87, 0xfb, 0xc1, 0xe1,
    0xe1, 0xe0, 0xf0, 0x70, 0x78, 0x78, 0x3c, 0xb8,
    0x1e, 0x1e, 0xf, 0xce, 0x7, 0x87, 0x83, 0xc7,
    0x1, 0xe1, 0xe3, 0xe1, 0x80, 0x7b, 0xff, 0xe0,
    0xc0, 0x1e, 0xff, 0xe0, 0x60, 0x7, 0x3f, 0xc0,
    0x30, 0x3, 0x8f, 0x80, 0x18, 0x3, 0xc2, 0x0,
    0xc, 0x7, 0x40,

    /* U+52D8 "勘" */
    0xe, 0x7, 0x87, 0x0, 0x7, 0x3, 0xc3, 0x80,
    0x3, 0x81, 0xe1, 0xc0, 0x1, 0xc0, 0xf0, 0xe0,
    0x0, 0xe0, 0x78, 0x70, 0x3, 0xff, 0xff, 0xb8,
    0x1, 0xff, 0xff, 0xdc, 0x0, 0x1c, 0xf, 0xe,
    0x1e, 0xe, 0x7, 0x87, 0xf, 0x7, 0x3, 0xc3,
    0x87, 0x83, 0x81, 0xe7, 0xff, 0xc1, 0xfe, 0xf0,
    0xe1, 0xe0, 0xff, 0x78, 0x70, 0xf0, 0x70, 0x3c,
    0x38, 0x78, 0x38, 0x1e, 0x1c, 0x3c, 0x1c, 0xf,
    0xe, 0x1e, 0xe, 0x7, 0x87, 0xf, 0x7, 0x3,
    0xc3, 0x87, 0x83, 0xfd, 0xe1, 0xc3, 0xc1, 0xfe,
    0xf0, 0xe1, 0xe0, 0xe0, 0x78, 0x70, 0xf0, 0x70,
    0x3c, 0x38, 0x78, 0x38, 0x1e, 0x1c, 0x3c, 0x1c,
    0xf, 0xe, 0x1e, 0xff, 0xff, 0xf7, 0xf, 0x7f,
    0xff, 0xfb, 0x87, 0x8f, 0x0, 0x1, 0xc3, 0xc7,
    0x80, 0x0, 0xe1, 0xe3, 0xc0, 0x40, 0x70, 0xf1,
    0xe7, 0x20, 0x38, 0x78, 0xf3, 0x90, 0x1c, 0x3c,
    0x79, 0xcc, 0xe, 0x1e, 0x3c, 0xe7, 0x7, 0xf,
    0x1e, 0x63, 0xc3, 0x87, 0x8f, 0x30, 0xf1, 0x83,
    0xc7, 0xb0, 0x78, 0xc1, 0xe3, 0xd8, 0x18, 0xe0,
    0xf1, 0xe8, 0xc, 0x60, 0x78, 0xf8, 0x1, 0x30,
    0x3c, 0x78, 0x0, 0x10, 0x1e, 0x3f, 0xff, 0xd8,
    0xf, 0x1f, 0xff, 0xe8, 0xf, 0x8f, 0x0, 0xc,
    0xf, 0x87, 0x80, 0x4, 0xf, 0x83, 0xc0, 0x4,
    0x1f, 0x0, 0x0, 0x4, 0x30, 0x0,

    /* U+52D9 "務" */
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x8f, 0x0,
    0xf, 0xff, 0xc7, 0x8f, 0x87, 0xff, 0xe3, 0x87,
    0xc0, 0x0, 0x63, 0xff, 0xe0, 0x0, 0x61, 0xff,
    0xe0, 0x20, 0x30, 0xe0, 0xf0, 0x8, 0x30, 0x70,
    0x78, 0x2, 0x30, 0x30, 0x3c, 0x1, 0xd0, 0x38,
    0x3c, 0x0, 0x78, 0x1c, 0x1e, 0x0, 0x3c, 0x1b,
    0xe, 0x0, 0xf, 0x8, 0x87, 0x0, 0x7, 0x8,
    0x67, 0x0, 0x1, 0x9c, 0x1b, 0x0, 0xff, 0xfe,
    0xf, 0x80, 0x7f, 0xff, 0x3, 0x80, 0x0, 0xf3,
    0x83, 0xf8, 0x0, 0x79, 0xc3, 0x3f, 0xc0, 0x3c,
    0x83, 0xf, 0xf0, 0x1e, 0x3, 0x3, 0xf0, 0xf,
    0x6, 0x0, 0xf8, 0x7, 0x86, 0x78, 0x1c, 0x7,
    0xcc, 0x3c, 0x2, 0x3, 0xe0, 0x1e, 0x3c, 0x1,
    0xf0, 0xf, 0x1e, 0x0, 0xf8, 0xff, 0xff, 0x0,
    0xfc, 0x7f, 0xff, 0x80, 0x6e, 0x1, 0xe3, 0xc0,
    0x37, 0x0, 0xf1, 0xe0, 0x33, 0x80, 0x78, 0xf0,
    0x19, 0xc0, 0x3c, 0x78, 0x18, 0xe0, 0x1e, 0x3c,
    0x8, 0x70, 0xe, 0x1e, 0x4, 0x38, 0xf, 0xf,
    0x4, 0x1c, 0x7, 0x7, 0x86, 0xe, 0x3, 0x83,
    0xc2, 0x7, 0x3, 0x81, 0xe0, 0x3, 0x81, 0x80,
    0xf0, 0x1, 0xc1, 0xc0, 0x78, 0x0, 0xe0, 0xc0,
    0x3c, 0x0, 0x70, 0xc0, 0x1e, 0x0, 0x70, 0xc0,
    0x1e, 0x0, 0x70, 0xc0, 0x1e, 0x1, 0xe0, 0xc0,
    0xfe, 0x0,

    /* U+52DB "勛" */
    0x1e, 0xf, 0xf, 0x0, 0x3c, 0x1e, 0x1e, 0x0,
    0x7f, 0xfc, 0x3c, 0x0, 0xff, 0xf8, 0x78, 0x1,
    0xe0, 0xf0, 0xf0, 0x3, 0xc1, 0xe1, 0xe0, 0x7,
    0x83, 0xc3, 0xc0, 0xf, 0x7, 0x87, 0x80, 0x1e,
    0xf, 0xf, 0x3c, 0x3f, 0xfe, 0x1e, 0x78, 0x7f,
    0xfd, 0xff, 0xf0, 0xf0, 0x7b, 0xff, 0xe0, 0x0,
    0x0, 0xf3, 0xc7, 0x80, 0xf1, 0xe7, 0x8f, 0x1,
    0xe3, 0xcf, 0x1f, 0xff, 0xc7, 0x9e, 0x3f, 0xff,
    0x8f, 0x3c, 0x78, 0xf, 0x1e, 0x78, 0xf0, 0x1e,
    0x3c, 0xf1, 0xe0, 0x3c, 0x79, 0xe3, 0xff, 0x78,
    0xf3, 0xc7, 0xfe, 0xf1, 0xe7, 0x8f, 0x1, 0xe3,
    0xcf, 0x1e, 0x3, 0xc7, 0x9e, 0x3c, 0x7, 0x8f,
    0x3c, 0x7f, 0xef, 0x1e, 0x78, 0xff, 0xde, 0x3c,
    0xf1, 0xe0, 0x3c, 0x79, 0xe3, 0xc0, 0x78, 0xf3,
    0xc7, 0x80, 0xf1, 0xe7, 0x8f, 0xff, 0xe3, 0xcf,
    0x1f, 0xff, 0xc7, 0x1e, 0x3c, 0x7, 0x8e, 0x3c,
    0x78, 0xf, 0x3c, 0x78, 0x0, 0x0, 0x78, 0xf0,
    0x3c, 0x80, 0xe1, 0xe0, 0x79, 0x81, 0xc3, 0xc0,
    0xf3, 0x83, 0x7, 0x81, 0xc3, 0xce, 0xf, 0x3,
    0x87, 0x98, 0x1e, 0xe, 0xe, 0x30, 0x3c, 0x18,
    0xc, 0xc0, 0x78, 0x60, 0x19, 0x1, 0xe1, 0x80,
    0x14, 0xf, 0x86, 0x0, 0x18, 0x3c, 0x0,

    /* U+52DD "勝" */
    0x38, 0xf0, 0x1e, 0x0, 0x71, 0xe0, 0x3c, 0x0,
    0xe3, 0xc0, 0x78, 0x61, 0xff, 0xb0, 0xf0, 0xc3,
    0xff, 0x31, 0xe3, 0x7, 0x1e, 0x73, 0xc6, 0xe,
    0x3c, 0xe7, 0x98, 0x1c, 0x78, 0xcf, 0x30, 0x38,
    0xf1, 0x1e, 0xc0, 0x71, 0xe0, 0x3d, 0x0, 0xe3,
    0xdf, 0xff, 0xf1, 0xc7, 0xbf, 0xff, 0xe3, 0x8f,
    0x1, 0xc0, 0x7, 0x1e, 0x3, 0x80, 0xf, 0xfc,
    0x7, 0x0, 0x1f, 0xf8, 0x1c, 0x0, 0x38, 0xf7,
    0xff, 0xfe, 0x71, 0xef, 0xff, 0xfc, 0xe3, 0xc1,
    0xc2, 0x1, 0xc7, 0x83, 0x4, 0x3, 0x8f, 0xe,
    0xc, 0x7, 0x1e, 0x18, 0x1e, 0xe, 0x3c, 0x6e,
    0x1f, 0x1c, 0x78, 0x9c, 0x3f, 0x38, 0xf2, 0x38,
    0x3c, 0x7f, 0xe8, 0x70, 0x38, 0xff, 0xf0, 0xe1,
    0xf1, 0xc7, 0xbf, 0xff, 0x83, 0x8f, 0x7f, 0xff,
    0x7, 0x1e, 0xf, 0xe, 0xe, 0x3c, 0x1e, 0x1c,
    0x1c, 0x78, 0x3c, 0x38, 0x38, 0xf0, 0x78, 0x70,
    0x71, 0xe0, 0xf0, 0xe0, 0xe3, 0xc1, 0xe1, 0xc1,
    0xc7, 0x83, 0x83, 0x83, 0x8f, 0x7, 0x7, 0x7,
    0x1e, 0xe, 0xe, 0xc, 0x3c, 0x38, 0x1c, 0x18,
    0x78, 0x60, 0x38, 0x30, 0xf0, 0xc0, 0x70, 0xc1,
    0xe3, 0x0, 0xe1, 0x83, 0x8c, 0x1, 0xc2, 0xe,
    0x10, 0x7, 0x4, 0x70, 0x60, 0x3c, 0x11, 0x1,
    0x81, 0xe0, 0x0,

    /* U+52DE "勞" */
    0x1, 0xe0, 0x1e, 0x0, 0x3, 0xc0, 0x3c, 0x0,
    0x87, 0x9c, 0x78, 0xc1, 0x8f, 0x30, 0xf1, 0x81,
    0x9e, 0xd1, 0xe6, 0x3, 0x3f, 0x33, 0xd8, 0x7,
    0x7c, 0x77, 0x60, 0xe, 0xf8, 0xef, 0x80, 0x9,
    0xe0, 0xde, 0x0, 0x13, 0x81, 0x3e, 0x0, 0x6,
    0xc0, 0xe7, 0x0, 0x1d, 0xc1, 0x8f, 0xc0, 0x31,
    0xe6, 0xf, 0x0, 0x41, 0x88, 0xe, 0x1, 0x3,
    0x20, 0xc, 0x7e, 0x2, 0x80, 0xf, 0xf0, 0x2,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0xff, 0x1, 0xe0,
    0x1, 0xfe, 0x3, 0xc0, 0x2, 0x7c, 0x7, 0x80,
    0x0, 0x0, 0xf, 0x0, 0xe0, 0x0, 0x1e, 0x1,
    0xc0, 0x3f, 0xff, 0xff, 0x80, 0x7f, 0xff, 0xff,
    0x0, 0x0, 0xf0, 0xe, 0x0, 0x1, 0xe0, 0x1c,
    0x0, 0x3, 0xc0, 0x38, 0x0, 0x7, 0x80, 0x70,
    0x0, 0xf, 0x0, 0xe0, 0x0, 0x1e, 0x1, 0xc0,
    0x0, 0x38, 0x3, 0x80, 0x0, 0xf0, 0x7, 0x0,
    0x1, 0xe0, 0xe, 0x0, 0x7, 0x80, 0x1c, 0x0,
    0xe, 0x0, 0x38, 0x0, 0x38, 0x0, 0x70, 0x0,
    0xe0, 0x0, 0xf0, 0x3, 0x80, 0x3, 0xc0, 0xc,
    0x0, 0x7, 0x80, 0x30, 0x0, 0x1e, 0x1, 0xc0,
    0x0, 0xf0, 0x6, 0x0, 0x6, 0xc0, 0x0,

    /* U+52DF "募" */
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x1e, 0xf, 0x0,
    0x0, 0xf, 0x7, 0x80, 0x0, 0x7, 0x83, 0xc0,
    0x7, 0xff, 0xff, 0xff, 0xf3, 0xff, 0xff, 0xff,
    0xf8, 0x0, 0xf0, 0x78, 0x0, 0x0, 0x78, 0x3c,
    0x0, 0x0, 0x3c, 0x1e, 0x0, 0x3, 0xc0, 0x0,
    0x78, 0x1, 0xff, 0xff, 0xfc, 0x0, 0xff, 0xff,
    0xfe, 0x0, 0x78, 0x0, 0xf, 0x0, 0x3c, 0x0,
    0x7, 0x80, 0x1e, 0x0, 0x3, 0xc0, 0xf, 0xff,
    0xfd, 0xe0, 0x7, 0xff, 0xfe, 0xf0, 0x3, 0xc0,
    0x0, 0x78, 0x1, 0xe0, 0x0, 0x3c, 0x0, 0xff,
    0xff, 0xfe, 0x0, 0x7f, 0xff, 0xff, 0x0, 0x3c,
    0x78, 0x7, 0x80, 0x1e, 0x7c, 0x3, 0xc0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0x9f, 0xff, 0xff, 0xff, 0xc0,
    0xe, 0x0, 0x60, 0x0, 0xe, 0x0, 0x18, 0x0,
    0xe, 0x78, 0xe, 0x0, 0x6, 0x3c, 0x3, 0xc0,
    0x6, 0x1e, 0x3, 0xf8, 0xe, 0xf, 0x1, 0xff,
    0x8d, 0xff, 0xff, 0xff, 0x8c, 0xff, 0xff, 0xf3,
    0xcc, 0x3, 0xc0, 0x38, 0xe0, 0x1, 0xe0, 0x1c,
    0x10, 0x0, 0xe0, 0xe, 0x0, 0x0, 0xf0, 0x7,
    0x0, 0x0, 0x70, 0x3, 0x80, 0x0, 0x70, 0x1,
    0xc0, 0x0, 0x70, 0x0, 0xe0, 0x0, 0x70, 0x0,
    0xf0, 0x0, 0x60, 0x0, 0xf0, 0x0, 0x60, 0x1,
    0xf0, 0x0, 0xc0, 0x3, 0x60, 0x0,

    /* U+52E2 "勢" */
    0x3, 0x80, 0x3c, 0x0, 0xe, 0x0, 0xf0, 0x0,
    0x38, 0x3, 0xc0, 0x0, 0xe0, 0xf, 0x0, 0x7f,
    0xfe, 0x3c, 0x1, 0xff, 0xf8, 0xf0, 0x0, 0x38,
    0x3, 0xce, 0x0, 0xe0, 0xf, 0x38, 0x3, 0x81,
    0xff, 0xe3, 0xff, 0xff, 0xff, 0x8f, 0xff, 0xf3,
    0xde, 0x0, 0x10, 0xf, 0x78, 0x3c, 0x20, 0x39,
    0xe0, 0xf0, 0xc0, 0xe3, 0x83, 0xbb, 0x9b, 0x8e,
    0x4e, 0xe7, 0xbe, 0x39, 0x33, 0x9e, 0x78, 0xe5,
    0x8e, 0x31, 0xe3, 0x97, 0xff, 0xc7, 0xce, 0x6f,
    0xff, 0x1f, 0xb9, 0x3, 0x80, 0xce, 0x74, 0xe,
    0x13, 0x19, 0xf0, 0x39, 0x98, 0x27, 0xc0, 0xf8,
    0xc0, 0xf, 0xff, 0xc6, 0x0, 0x3d, 0xfc, 0x30,
    0x0, 0x77, 0xc1, 0x80, 0x0, 0xdc, 0xf, 0xc0,
    0x1, 0x0, 0xf, 0x1, 0xc0, 0x0, 0x3c, 0x7,
    0x3, 0xff, 0xff, 0xfc, 0xf, 0xff, 0xff, 0xf0,
    0x0, 0x1f, 0x1, 0xc0, 0x0, 0x7c, 0x7, 0x0,
    0x1, 0xf0, 0x1c, 0x0, 0x7, 0x80, 0x70, 0x0,
    0x1e, 0x1, 0xc0, 0x0, 0xf0, 0x7, 0x0, 0x7,
    0x80, 0x1c, 0x0, 0x1c, 0x0, 0x70, 0x0, 0xe0,
    0x1, 0xc0, 0x7, 0x0, 0x7, 0x0, 0x38, 0x0,
    0x38, 0x3, 0x80, 0x1, 0xc0, 0x1c, 0x0, 0x3e,
    0x1, 0xc0, 0x1, 0x0, 0x0,

    /* U+52E3 "勣" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x7, 0x0,
    0x1, 0xe0, 0xe, 0x0, 0x3, 0xc0, 0x1c, 0x0,
    0x7, 0x80, 0x38, 0xf, 0xff, 0xfe, 0x70, 0x1f,
    0xff, 0xfc, 0xe0, 0x0, 0x3c, 0x1, 0xc0, 0x0,
    0x78, 0x3, 0x80, 0x0, 0xf0, 0x7, 0x1c, 0xff,
    0xff, 0x8e, 0x38, 0x3, 0xc0, 0x1c, 0x70, 0x7,
    0x81, 0xff, 0xe0, 0xf, 0x3, 0xff, 0xc0, 0x1e,
    0x0, 0xe3, 0xff, 0xff, 0xf9, 0xc7, 0xff, 0xff,
    0xf3, 0x8e, 0x0, 0x0, 0x7, 0x1c, 0xf0, 0x7,
    0x8e, 0x39, 0xff, 0xff, 0x1c, 0x73, 0xff, 0xfe,
    0x38, 0xe7, 0x80, 0x3c, 0x71, 0xcf, 0x0, 0x78,
    0xe3, 0x9e, 0x0, 0xf1, 0xc7, 0x3f, 0xfd, 0xe3,
    0x8e, 0x78, 0x3, 0xc7, 0x1c, 0xf0, 0x7, 0x8e,
    0x39, 0xe0, 0xf, 0x1c, 0x73, 0xff, 0xde, 0x38,
    0xe7, 0xff, 0xbc, 0x71, 0xcf, 0x0, 0x78, 0xc3,
    0x9e, 0x0, 0xf1, 0x87, 0x3c, 0x1, 0xe3, 0xe,
    0x7f, 0xff, 0xce, 0x1c, 0xff, 0xff, 0x98, 0x39,
    0xe0, 0xf, 0x30, 0x73, 0xfd, 0x1e, 0x60, 0xe0,
    0x79, 0x0, 0x81, 0xc1, 0xe3, 0x3, 0x3, 0x83,
    0xc7, 0x4, 0x7, 0x7, 0xf, 0xc8, 0xe, 0x1c,
    0xf, 0x30, 0x1c, 0x30, 0x1e, 0x40, 0x70, 0xc0,
    0x1d, 0x81, 0xc3, 0x0, 0x1a, 0x7, 0xc, 0x0,
    0x18, 0x7c, 0x0, 0x0, 0x10, 0x0, 0x0,

    /* U+52E4 "勤" */
    0xe, 0x1e, 0x1e, 0x0, 0x70, 0xf0, 0xf0, 0x3,
    0x87, 0x87, 0x80, 0x1c, 0x3c, 0x3c, 0x0, 0xe1,
    0xe1, 0xe0, 0x7f, 0xff, 0xef, 0x3, 0xff, 0xff,
    0x78, 0x1, 0xc3, 0xc3, 0xc0, 0xe, 0x1e, 0x1e,
    0x0, 0x70, 0xf0, 0xf1, 0xc3, 0xff, 0x87, 0x8e,
    0x1f, 0xfc, 0xff, 0xf0, 0xe1, 0xe7, 0xff, 0x80,
    0xe0, 0xf, 0x1c, 0x7, 0x0, 0x78, 0xee, 0x38,
    0xe3, 0xc7, 0x7f, 0xff, 0x1e, 0x3b, 0xff, 0xf8,
    0xf1, 0xdc, 0x71, 0xc7, 0x8e, 0xe3, 0x8e, 0x3c,
    0x77, 0x1c, 0x71, 0xe3, 0xb8, 0xe3, 0x8f, 0x1d,
    0xc7, 0x1c, 0x78, 0xef, 0xff, 0xe3, 0xc7, 0x7f,
    0xff, 0x1e, 0x3b, 0x8e, 0x38, 0xf1, 0xc0, 0x70,
    0x7, 0x8e, 0x3, 0x80, 0x3c, 0x70, 0x1c, 0x1,
    0xe3, 0xbf, 0xff, 0xcf, 0x1c, 0x7, 0x0, 0x78,
    0xe0, 0x38, 0x3, 0xc7, 0x1, 0xc0, 0x1e, 0x38,
    0xe, 0x0, 0xf1, 0xdf, 0xff, 0xc7, 0x8e, 0x3,
    0x80, 0x3c, 0x70, 0x1c, 0x1, 0xc3, 0x80, 0xe0,
    0x5e, 0x1c, 0x7, 0xc, 0xe0, 0xe0, 0x3b, 0xce,
    0x7, 0xff, 0xf8, 0x70, 0x3f, 0xff, 0x7, 0x1,
    0xff, 0xc0, 0x30, 0x1f, 0xe0, 0x3, 0x1, 0xe0,
    0x0, 0x30, 0x3e, 0x0, 0x3, 0x6, 0x60,

    /* U+52E6 "勦" */
    0x1e, 0x3c, 0xf0, 0x0, 0x3c, 0x71, 0xcf, 0x0,
    0x70, 0xe3, 0x1e, 0x0, 0xc3, 0x8e, 0x3c, 0x3,
    0x86, 0x18, 0x78, 0x6, 0x18, 0x20, 0xf0, 0x8,
    0x20, 0xc1, 0xe0, 0x1c, 0x60, 0xc3, 0xc0, 0x1c,
    0x70, 0xe7, 0x80, 0x3c, 0xf1, 0xcf, 0x0, 0x30,
    0xc1, 0x9e, 0x38, 0x20, 0x81, 0x3c, 0x70, 0x0,
    0x0, 0x78, 0xe7, 0x80, 0x3f, 0xff, 0xcf, 0xff,
    0xff, 0xff, 0x9f, 0xff, 0xf3, 0xc7, 0x3c, 0x71,
    0xe7, 0x8e, 0x78, 0xe3, 0xcf, 0x1c, 0xf1, 0xc7,
    0x9e, 0x39, 0xff, 0xff, 0x3c, 0x73, 0xff, 0xfe,
    0x78, 0xe7, 0x8e, 0x3c, 0xf1, 0xcf, 0x1c, 0x79,
    0xe3, 0x9e, 0x38, 0xf3, 0xc7, 0x3c, 0x71, 0xe7,
    0x8e, 0x7f, 0xff, 0xcf, 0x1c, 0xff, 0xff, 0x9e,
    0x39, 0xe3, 0x8f, 0x3c, 0x70, 0x7, 0x0, 0x78,
    0xe0, 0xe, 0x0, 0xf1, 0xff, 0xff, 0xfd, 0xe3,
    0xff, 0xff, 0xfb, 0xc7, 0x0, 0xf8, 0x7, 0xe,
    0x3, 0xe8, 0xe, 0x1c, 0x7, 0xd8, 0x3c, 0x38,
    0x1f, 0xb8, 0x78, 0x70, 0x3f, 0x38, 0xe0, 0xe0,
    0xee, 0x7d, 0xc1, 0xc3, 0x9c, 0x73, 0x3, 0x86,
    0x38, 0x6e, 0x7, 0x18, 0x70, 0x58, 0xe, 0x60,
    0xe0, 0x60, 0x1d, 0x81, 0xc0, 0x80, 0x76, 0x3,
    0x81, 0x1, 0xc0, 0x7, 0x4, 0x7, 0x0, 0xe,
    0x18, 0x7c, 0x0,

    /* U+52F0 "勰" */
    0x7, 0x0, 0x38, 0x7, 0x3, 0x8f, 0x1c, 0x3,
    0x81, 0xc7, 0x8f, 0xff, 0xc0, 0xe3, 0xc7, 0x38,
    0xe7, 0xff, 0xe3, 0x9c, 0x73, 0xff, 0xf1, 0xce,
    0x38, 0x1c, 0x78, 0xe7, 0x1c, 0xe, 0x3c, 0x73,
    0x8e, 0x7, 0x1e, 0x39, 0xc7, 0x3, 0x8f, 0x1c,
    0xe3, 0x81, 0xc7, 0x8f, 0xff, 0xc0, 0xe3, 0xc7,
    0xff, 0xe0, 0x61, 0xe3, 0x9c, 0x70, 0x70, 0xf1,
    0xce, 0x38, 0x30, 0x78, 0xe7, 0x1c, 0x30, 0x78,
    0x73, 0x8e, 0x30, 0x78, 0x39, 0xc7, 0x10, 0xf8,
    0x1c, 0xe3, 0x90, 0x0, 0xe, 0x71, 0xc0, 0xe,
    0x7, 0x38, 0xe3, 0x87, 0x3, 0xff, 0xf1, 0xc3,
    0x81, 0xff, 0xf8, 0xe1, 0xcc, 0xe0, 0x1c, 0x76,
    0xe6, 0x72, 0xe, 0x7f, 0xff, 0x38, 0x80, 0x3f,
    0xff, 0x80, 0x40, 0xe, 0xdc, 0xc1, 0xf0, 0x7,
    0x6e, 0x60, 0xf8, 0x83, 0xb7, 0x30, 0x7e, 0x41,
    0xdb, 0x99, 0xbb, 0xb0, 0xed, 0xcc, 0xdd, 0xc8,
    0x76, 0xe6, 0x6e, 0xe6, 0x3b, 0x73, 0x37, 0x73,
    0x1d, 0xb9, 0x9b, 0x91, 0x8e, 0xdc, 0xcd, 0xc8,
    0xe7, 0x6e, 0x66, 0xe1, 0x73, 0xb7, 0x33, 0x70,
    0xb9, 0xdb, 0x99, 0xb8, 0x4c, 0xcd, 0xcc, 0xdc,
    0x26, 0x66, 0xe6, 0x4e, 0x12, 0x33, 0x63, 0x27,
    0xc, 0x11, 0xb1, 0xa3, 0x86, 0x18, 0xf0, 0xc1,
    0xc7, 0xc, 0xd8, 0xe0, 0xff, 0x85, 0xe9, 0xe0,
    0x7f, 0x85, 0x29, 0x60, 0x1f, 0xc0,

    /* U+52F1 "勱" */
    0xf, 0x1c, 0x7, 0x0, 0x3c, 0x70, 0x1c, 0x0,
    0xf1, 0xc0, 0x70, 0x3, 0xc7, 0x1, 0xc0, 0xff,
    0xff, 0xe7, 0x3, 0xff, 0xff, 0x9c, 0x0, 0xf1,
    0xc0, 0x70, 0x3, 0xc7, 0x1, 0xc0, 0xf, 0x1c,
    0x7, 0x1c, 0xe0, 0x1e, 0x1c, 0x73, 0x80, 0x7b,
    0xff, 0xcf, 0xff, 0xef, 0xff, 0x38, 0xe7, 0x87,
    0x1c, 0xe3, 0x9e, 0x1c, 0x73, 0x8e, 0x78, 0x71,
    0xce, 0x39, 0xe1, 0xc7, 0x3f, 0xff, 0x87, 0x1c,
    0xff, 0xfe, 0x1c, 0x73, 0x8e, 0x78, 0x71, 0xce,
    0x39, 0xe1, 0xc7, 0x38, 0xe7, 0x87, 0x1c, 0xff,
    0xfe, 0x1c, 0x73, 0xff, 0xf8, 0x71, 0xce, 0x39,
    0xe1, 0xc7, 0x0, 0xe0, 0x7, 0x1c, 0x3, 0x80,
    0x1c, 0x77, 0xe, 0x3c, 0x71, 0xdf, 0xff, 0xf1,
    0xc7, 0x7f, 0xff, 0xc7, 0x1d, 0xc3, 0x8f, 0x1c,
    0x77, 0xe, 0x3c, 0x71, 0xdc, 0x3c, 0xf1, 0xc7,
    0x70, 0xfb, 0xc7, 0x1d, 0xc3, 0xbf, 0x1c, 0x77,
    0xf, 0xfc, 0x61, 0xdc, 0x3b, 0xf1, 0x87, 0x77,
    0xcf, 0xc6, 0x1d, 0xde, 0x2f, 0x10, 0x77, 0x70,
    0xbc, 0xc1, 0xdc, 0x0, 0xf3, 0x7, 0x70, 0x3,
    0xc8, 0x1d, 0xc0, 0xf, 0x40, 0x67, 0x0, 0x7b,
    0x3, 0x9c, 0x7, 0xc8, 0x1c, 0x70, 0x2c, 0x41,
    0xe0, 0x0, 0x2, 0x18, 0x0,

    /* U+52F3 "勳" */
    0x0, 0x2, 0xf, 0x0, 0x0, 0x3c, 0x3c, 0x0,
    0x7, 0xf8, 0xf0, 0x1, 0xff, 0xfb, 0xc0, 0xfe,
    0xe0, 0xf, 0x0, 0x3, 0x80, 0x3c, 0x0, 0xe,
    0x0, 0xf0, 0x3f, 0xff, 0xf3, 0xc0, 0xff, 0xff,
    0xcf, 0x0, 0x3, 0x80, 0x3c, 0x0, 0xe, 0x0,
    0xf1, 0xde, 0x38, 0xe3, 0xc7, 0x78, 0xe3, 0xbf,
    0xfd, 0xff, 0xfe, 0xff, 0xf7, 0x8e, 0x38, 0xf1,
    0xde, 0x3a, 0xe3, 0xc7, 0x7c, 0xef, 0x8f, 0x1d,
    0xfb, 0xee, 0x3c, 0x77, 0xbf, 0xb8, 0xf1, 0xde,
    0xfc, 0xe3, 0xc7, 0x78, 0xe3, 0x8f, 0x1d, 0xe3,
    0x8e, 0x3c, 0x77, 0xff, 0xf8, 0xf1, 0xde, 0x38,
    0xe3, 0xc7, 0x78, 0xe3, 0x8f, 0x1c, 0x3, 0x80,
    0x3c, 0x77, 0xff, 0xfc, 0xf1, 0xdf, 0xff, 0xf3,
    0xc7, 0x0, 0xe0, 0xf, 0x1c, 0x3, 0x81, 0x3c,
    0x70, 0xe, 0x18, 0xf1, 0xf0, 0x3f, 0x83, 0xc7,
    0x7f, 0xfc, 0xe, 0x1d, 0xff, 0x10, 0x38, 0x77,
    0xe0, 0x20, 0xe1, 0xd8, 0x8, 0xc7, 0x7, 0x39,
    0x23, 0x9c, 0x1c, 0xe4, 0xcf, 0x60, 0x73, 0x91,
    0x19, 0x81, 0xcc, 0x66, 0x6c, 0x7, 0x31, 0x98,
    0xf0, 0x1d, 0xc6, 0x43, 0x80, 0x76, 0x10, 0xc,
    0x3, 0xb0, 0x0, 0x60, 0x1c, 0x80, 0x6, 0x0,
    0xe0, 0x0, 0x30, 0x1e, 0x0,

    /* U+52F5 "勵" */
    0x0, 0x0, 0x7, 0x80, 0x70, 0x0, 0xf, 0x0,
    0xe0, 0x0, 0x1e, 0x1, 0xff, 0xff, 0xfc, 0x3,
    0xff, 0xff, 0xf8, 0x7, 0x1e, 0xf0, 0xf0, 0xe,
    0x3d, 0xe1, 0xe0, 0x1c, 0x7b, 0xc3, 0xc0, 0x3f,
    0xff, 0xf7, 0x80, 0x7f, 0xff, 0xef, 0x1c, 0xe3,
    0xde, 0x1e, 0x39, 0xc7, 0xbc, 0x3c, 0x73, 0x9c,
    0xe, 0xff, 0xe7, 0x3f, 0xfd, 0xff, 0xce, 0x7f,
    0xf9, 0xe3, 0x9c, 0xe6, 0x73, 0xc7, 0x39, 0xcc,
    0xe7, 0x8e, 0x73, 0x99, 0xcf, 0x1c, 0xe7, 0xff,
    0x9e, 0x39, 0xcf, 0xff, 0x3c, 0x73, 0x9c, 0xce,
    0x78, 0xe7, 0x39, 0x9c, 0xf1, 0xce, 0x73, 0x39,
    0xe3, 0x9c, 0xff, 0xf3, 0xc7, 0x39, 0xff, 0xe7,
    0x8e, 0x73, 0x99, 0xcf, 0x1c, 0xe0, 0x30, 0x1e,
    0x39, 0xdc, 0x63, 0xbc, 0x73, 0xbf, 0xff, 0x78,
    0xe7, 0x71, 0x8e, 0xf1, 0xce, 0xe3, 0x5d, 0xe3,
    0x9d, 0xc6, 0xbb, 0xc7, 0x3b, 0x8d, 0x77, 0x8e,
    0x77, 0x1a, 0xef, 0x1c, 0xee, 0x37, 0xde, 0x39,
    0xdc, 0x7f, 0xb8, 0x73, 0x3f, 0xd7, 0x70, 0xe6,
    0x77, 0x2e, 0xe1, 0xcc, 0xec, 0x5d, 0x83, 0x99,
    0xd0, 0x3f, 0x7, 0x73, 0x80, 0x7c, 0xe, 0xc7,
    0x0, 0xf8, 0x1d, 0x8e, 0x3, 0xe0, 0x3b, 0x1c,
    0x6, 0x80, 0xe4, 0x38, 0x3b, 0x7, 0x98, 0x70,
    0x84, 0x34, 0x0,

    /* U+52F7 "勷" */
    0x0, 0x80, 0x7, 0x0, 0x0, 0xe0, 0xe, 0x0,
    0x1, 0xc0, 0x1c, 0x0, 0x1, 0x0, 0x38, 0xf,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0xe0, 0x0,
    0x0, 0x1, 0xc0, 0x39, 0xcc, 0x73, 0x80, 0x73,
    0x98, 0xe7, 0xe, 0xff, 0x3f, 0xce, 0x1d, 0xce,
    0x63, 0xff, 0xfb, 0x9c, 0xc7, 0xff, 0xf7, 0x39,
    0x8e, 0x70, 0xee, 0x73, 0x1c, 0xe1, 0xdf, 0xe7,
    0xf9, 0xc3, 0xb9, 0xcc, 0x73, 0x87, 0x73, 0x98,
    0xe7, 0xe, 0xe, 0x1c, 0xe, 0x1c, 0x1c, 0x38,
    0x1c, 0x38, 0x38, 0x70, 0x38, 0x77, 0xff, 0xfe,
    0x70, 0xe0, 0xe1, 0xc0, 0xe1, 0xc1, 0xc3, 0x81,
    0xc3, 0x83, 0x87, 0x3, 0x87, 0x7f, 0xff, 0xe7,
    0xe, 0xe, 0x1c, 0xe, 0x1c, 0x1c, 0x38, 0x1c,
    0x38, 0x38, 0x70, 0x38, 0x70, 0x70, 0xe0, 0x70,
    0xff, 0xff, 0xfe, 0xe1, 0xc0, 0xf4, 0x11, 0xc3,
    0x83, 0xe8, 0x23, 0x87, 0x7, 0x90, 0x87, 0xe,
    0x1e, 0x13, 0xe, 0x1c, 0x3c, 0x3c, 0x1c, 0x38,
    0xf8, 0x70, 0x30, 0x71, 0xf0, 0xf0, 0xe0, 0xe6,
    0xe2, 0xf1, 0xc1, 0xd1, 0xcc, 0xfb, 0x3, 0xc3,
    0xb1, 0xf6, 0x7, 0x7, 0xc1, 0xd8, 0xe, 0x7f,
    0x1, 0xb0, 0x38, 0x7c, 0x0, 0xc0, 0xf0, 0xf0,
    0x1, 0x3, 0x81, 0xc0, 0x6, 0x1e, 0x2, 0x0,
    0x18, 0xc0, 0x0,

    /* U+52F8 "勸" */
    0x0, 0x0, 0x7, 0x80, 0x1c, 0x70, 0x1e, 0x0,
    0x71, 0xc0, 0x78, 0x1, 0xc7, 0x1, 0xe0, 0xff,
    0xff, 0xe7, 0x83, 0xff, 0xff, 0x9e, 0x0, 0x71,
    0xc0, 0x78, 0x1, 0xc7, 0x1, 0xe0, 0x7, 0x1c,
    0x7, 0x81, 0xce, 0xe7, 0x1e, 0x77, 0x3b, 0x9c,
    0x79, 0xdf, 0xef, 0xf1, 0xe7, 0x73, 0xb9, 0xff,
    0xfd, 0xce, 0xe7, 0xff, 0xf7, 0x3b, 0x9c, 0x79,
    0xdc, 0xee, 0x71, 0xe7, 0x73, 0xb9, 0xc7, 0x9d,
    0xfe, 0xff, 0x1e, 0x77, 0xfb, 0xfc, 0x79, 0xdc,
    0xee, 0x71, 0xe7, 0x73, 0xb9, 0xc7, 0x9c, 0xe,
    0x0, 0x1e, 0x70, 0xf2, 0x0, 0x79, 0xc3, 0xce,
    0x1, 0xe7, 0xe, 0x18, 0x7, 0x9c, 0x3f, 0xff,
    0x1e, 0x70, 0xe3, 0x80, 0x79, 0xc7, 0x8e, 0x1,
    0xe7, 0x1e, 0x38, 0x7, 0x9c, 0xf8, 0xe0, 0x1e,
    0x73, 0xff, 0xf8, 0x79, 0xd7, 0xff, 0xe1, 0xc7,
    0x1e, 0x38, 0x7, 0x1c, 0x78, 0xe0, 0x3c, 0x71,
    0xe3, 0x80, 0xf1, 0xc7, 0xff, 0xe3, 0x87, 0x1e,
    0x38, 0xe, 0x1c, 0x78, 0xe0, 0x70, 0x71, 0xe3,
    0x81, 0x81, 0xc7, 0x8e, 0xe, 0x7, 0x1f, 0xff,
    0xf0, 0x1c, 0x78, 0x1, 0x80, 0x71, 0xe0, 0xc,
    0x3, 0x87, 0x80, 0x30, 0xc, 0x1e, 0x1, 0x80,
    0xf0, 0x78, 0x4, 0xf, 0x0,

    /* U+52F9 "勹" */
    0x1e, 0x0, 0x0, 0x7, 0x80, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x7, 0x80, 0x0, 0xf1, 0xc0, 0x0, 0x3c, 0x70,
    0x0, 0xf, 0x3f, 0xff, 0xff, 0xcf, 0xff, 0xff,
    0xf3, 0x80, 0x0, 0x3c, 0xe0, 0x0, 0xf, 0x38,
    0x0, 0x3, 0xdc, 0x0, 0x0, 0xf6, 0x0, 0x0,
    0x3d, 0x80, 0x0, 0xf, 0xc0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0xf, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x7e, 0x0, 0x0, 0x74, 0x0,

    /* U+52FA "勺" */
    0x3, 0xe0, 0x0, 0x0, 0xf, 0x80, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x3c, 0xf, 0x0, 0x0, 0xf0, 0x3c,
    0x0, 0x3, 0xc0, 0xff, 0xff, 0xff, 0x7, 0xff,
    0xff, 0xfc, 0x1e, 0x0, 0x0, 0xf0, 0x70, 0x0,
    0x3, 0xc1, 0xc0, 0x0, 0xf, 0xe, 0x0, 0x0,
    0x3c, 0x38, 0x0, 0x0, 0xf0, 0xc0, 0x0, 0x3,
    0xc7, 0x0, 0x0, 0xf, 0x18, 0x0, 0x0, 0x3c,
    0xc2, 0x0, 0x0, 0xf3, 0x4, 0x0, 0x3, 0xc8,
    0x18, 0x0, 0xf, 0x60, 0x30, 0x0, 0x3c, 0x0,
    0xe0, 0x0, 0xf0, 0x1, 0xe0, 0x3, 0xc0, 0x3,
    0xc0, 0xf, 0x0, 0xf, 0x80, 0x3c, 0x0, 0x1f,
    0x0, 0xf0, 0x0, 0x3e, 0x3, 0xc0, 0x0, 0xfc,
    0xf, 0x0, 0x1, 0xf0, 0x3c, 0x0, 0x3, 0xc0,
    0xf0, 0x0, 0x7, 0x3, 0xc0, 0x0, 0x1c, 0xf,
    0x0, 0x0, 0x30, 0x3c, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x3,
    0xf8, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x0, 0x10,
    0x0,

    /* U+52FC "勼" */
    0x7, 0x80, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x70,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x3c, 0x3c, 0x0,
    0x1, 0xe1, 0xe0, 0x0, 0xf, 0xf, 0xff, 0xff,
    0xf8, 0x7f, 0xff, 0xff, 0xc3, 0x80, 0x0, 0x1e,
    0x38, 0x0, 0x0, 0xf1, 0x8f, 0x0, 0x7, 0x9c,
    0x78, 0x0, 0x3c, 0xc3, 0xc0, 0x1, 0xec, 0x1e,
    0x1e, 0xf, 0x40, 0xf0, 0xf0, 0x7c, 0x7, 0x87,
    0x83, 0xc7, 0xff, 0xfc, 0x1e, 0x3f, 0xff, 0xe0,
    0xf0, 0xf, 0xf, 0x7, 0x80, 0x78, 0x78, 0x3c,
    0x3, 0xc3, 0xc1, 0xe0, 0x1e, 0x1e, 0xf, 0x0,
    0xf0, 0xf0, 0x78, 0x7, 0x87, 0x83, 0xc0, 0x3c,
    0x3c, 0x1e, 0x1, 0xe1, 0xe0, 0xf0, 0xf, 0xf,
    0x7, 0x80, 0x78, 0x78, 0x3c, 0x3, 0xc3, 0xc1,
    0xe0, 0x1c, 0x1e, 0x1f, 0x0, 0xe0, 0xf1, 0x78,
    0xf, 0x7, 0x9b, 0xc0, 0x70, 0x3d, 0x9e, 0x3,
    0x81, 0xfc, 0xf0, 0x38, 0xf, 0xc7, 0x81, 0x81,
    0xfc, 0x3c, 0x1c, 0xf, 0xc1, 0xe0, 0xc0, 0x7c,
    0xf, 0xc, 0x3, 0x80, 0x78, 0xc0, 0x0, 0x3,
    0xcc, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0x7e, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x1, 0x80, 0x0,

    /* U+52FE "勾" */
    0x1, 0xe0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0xf, 0x80, 0x0, 0xf0, 0x3c,
    0x0, 0x3, 0xc0, 0xff, 0xff, 0xff, 0x3, 0xff,
    0xff, 0xfc, 0xe, 0x0, 0x0, 0xf0, 0x78, 0x0,
    0x3, 0xc1, 0xc0, 0x0, 0xf, 0x7, 0x0, 0x0,
    0x3c, 0x38, 0x78, 0x0, 0xf0, 0xe1, 0xe0, 0x3,
    0xc7, 0x7, 0x80, 0xf, 0x18, 0x1e, 0x0, 0x3c,
    0xc0, 0x7a, 0x0, 0xf3, 0x1, 0xe8, 0x3, 0xd8,
    0x7, 0x30, 0xf, 0x40, 0x3c, 0xc0, 0x3e, 0x0,
    0xf3, 0x0, 0xf0, 0x3, 0xc4, 0x3, 0xc0, 0xe,
    0x18, 0xf, 0x0, 0x38, 0x60, 0x3c, 0x1, 0xc1,
    0x80, 0xf0, 0x7, 0x7, 0x3, 0xc0, 0x18, 0x1c,
    0xf, 0x0, 0xe0, 0x78, 0x3c, 0x3, 0x1, 0xf0,
    0xf0, 0x18, 0xf, 0xc3, 0xc0, 0xc0, 0xef, 0x8f,
    0x6, 0x1f, 0x3f, 0x3c, 0x3f, 0xf0, 0x78, 0xf0,
    0xff, 0x81, 0xe3, 0xc3, 0xf8, 0x3, 0xf, 0xf,
    0x80, 0x4, 0x3c, 0x20, 0x0, 0x18, 0xf0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0x64, 0x0,

    /* U+52FF "勿" */
    0x3, 0xf0, 0x0, 0x0, 0xf, 0xc0, 0x0, 0x0,
    0x3e, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0, 0x3,
    0xe0, 0x0, 0x0, 0xf, 0x0, 0x0, 0xf0, 0x3c,
    0x0, 0x3, 0xc0, 0xff, 0xff, 0xff, 0x3, 0xff,
    0xff, 0xfc, 0xe, 0x0, 0x0, 0xf0, 0x79, 0xe0,
    0x3, 0xc1, 0xc7, 0x8f, 0x8f, 0x7, 0x1e, 0x3c,
    0x3c, 0x38, 0x78, 0xf0, 0xf0, 0xe1, 0xe3, 0xc3,
    0xc3, 0x7, 0x8f, 0xf, 0x18, 0x1c, 0x3c, 0x3c,
    0x60, 0xf0, 0xf0, 0xf3, 0x3, 0xc3, 0xc3, 0xc8,
    0xf, 0xf, 0xf, 0x40, 0x38, 0x38, 0x3e, 0x0,
    0xe0, 0xe0, 0xf0, 0x7, 0x7, 0x83, 0xc0, 0x1c,
    0x1e, 0xf, 0x0, 0xe0, 0x78, 0x3c, 0x3, 0x81,
    0xc0, 0xf0, 0xc, 0x7, 0x3, 0xc0, 0x60, 0x3c,
    0xf, 0x3, 0x80, 0xe0, 0x3c, 0xc, 0x7, 0x80,
    0xf0, 0x60, 0x1c, 0x3, 0xc1, 0x0, 0x60, 0xf,
    0x8, 0x3, 0x80, 0x3c, 0x40, 0x1c, 0x0, 0xf3,
    0x0, 0x60, 0x3, 0xd8, 0x3, 0x0, 0xf, 0xc0,
    0x8, 0x0, 0x3c, 0x0, 0x60, 0x0, 0xf0, 0x3,
    0x0, 0x3, 0xc0, 0x18, 0x0, 0xf, 0x0, 0x40,
    0x0, 0x78, 0x2, 0x0, 0x3, 0xc0, 0x10, 0x0,
    0x3e, 0x0, 0x80, 0x7, 0xe0, 0x6, 0x0, 0x76,
    0x0,

    /* U+5300 "匀" */
    0x0, 0xf8, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x1,
    0xf0, 0x0, 0x3c, 0x7, 0xc0, 0x0, 0xf0, 0x1f,
    0xff, 0xff, 0xc0, 0x7f, 0xff, 0xff, 0x1, 0xc0,
    0x0, 0x3c, 0x7, 0x0, 0x0, 0xf0, 0x3c, 0x0,
    0x3, 0xc0, 0xe0, 0x0, 0xf, 0x3, 0x80, 0x0,
    0x3c, 0xc, 0x0, 0x0, 0xf0, 0x60, 0x0, 0x3,
    0xc1, 0x86, 0x0, 0xf, 0x4, 0xc, 0x0, 0x3c,
    0x30, 0x38, 0x0, 0xf0, 0x80, 0xf0, 0x3, 0xc4,
    0x1, 0xe0, 0xf, 0x30, 0x7, 0xc0, 0x3c, 0x80,
    0xe, 0x0, 0xf4, 0x0, 0x38, 0x13, 0xc0, 0x0,
    0x60, 0x8f, 0x0, 0x1, 0x86, 0x3c, 0x0, 0x0,
    0x30, 0xf0, 0x0, 0x1, 0xc3, 0xc0, 0x0, 0xe,
    0xf, 0x0, 0x0, 0xf0, 0x3c, 0x0, 0xf, 0x80,
    0xf0, 0x0, 0xfc, 0x3, 0xc0, 0x3f, 0xe0, 0xf,
    0xf, 0xff, 0x0, 0x3c, 0x1f, 0xf0, 0x0, 0xf0,
    0x7f, 0x0, 0x3, 0xc1, 0xf0, 0x0, 0xf, 0x6,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x7,
    0xe0, 0x0, 0x0, 0x20, 0x0,

    /* U+5305 "包" */
    0x1, 0xf0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0xf, 0x0, 0x78, 0x0, 0x1e, 0x0,
    0xff, 0xff, 0xfc, 0x3, 0xff, 0xff, 0xf8, 0x7,
    0x80, 0x0, 0xf0, 0xe, 0x0, 0x1, 0xe0, 0x1c,
    0x0, 0x3, 0xc0, 0x70, 0x0, 0x7, 0x80, 0xc0,
    0x0, 0xf, 0x3, 0x80, 0x0, 0x1e, 0x7, 0xc0,
    0x78, 0x3c, 0x1f, 0x80, 0xf0, 0x78, 0x2f, 0xff,
    0xe0, 0xf0, 0xdf, 0xff, 0xc1, 0xe1, 0x3c, 0x7,
    0x83, 0xc0, 0x78, 0xf, 0x7, 0x80, 0xf0, 0x1e,
    0xf, 0x1, 0xe0, 0x3c, 0x1e, 0x3, 0xc0, 0x78,
    0x3c, 0x7, 0x80, 0xf0, 0x78, 0xf, 0x1, 0xe0,
    0xf0, 0x1e, 0x3, 0xc1, 0xe0, 0x3f, 0xff, 0x83,
    0xc0, 0x7f, 0xff, 0x7, 0x80, 0xf0, 0x1e, 0xf,
    0x1, 0xe0, 0x3c, 0x1e, 0x3, 0xc0, 0x0, 0x3c,
    0x7, 0x80, 0x0, 0xf8, 0xf, 0x0, 0x3, 0xe4,
    0x1e, 0x0, 0x1f, 0x8, 0x3c, 0x0, 0xf8, 0x10,
    0x78, 0x0, 0x0, 0x20, 0xf0, 0x0, 0x0, 0x41,
    0xe0, 0x0, 0x1, 0x83, 0xc0, 0x0, 0x3, 0x7,
    0x80, 0x0, 0x7, 0xf, 0x0, 0x0, 0xe, 0x1e,
    0x0, 0x0, 0x1c, 0x3c, 0x0, 0x0, 0x78, 0x7f,
    0xff, 0xff, 0xf0, 0x7f, 0xff, 0xff, 0xc0, 0x7f,
    0xff, 0xff, 0x0,

    /* U+5306 "匆" */
    0x3, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x7c, 0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x7,
    0xc0, 0x0, 0x3c, 0x1e, 0x0, 0x0, 0xf0, 0x7f,
    0xff, 0xff, 0xc1, 0xff, 0xff, 0xff, 0x7, 0x0,
    0x0, 0x3c, 0x3c, 0x0, 0x0, 0xf0, 0xe3, 0xc7,
    0x83, 0xc3, 0x8f, 0x1e, 0xf, 0x1c, 0x3c, 0x78,
    0x3c, 0x60, 0xf1, 0xe0, 0xf1, 0x83, 0xc7, 0x83,
    0xcc, 0xf, 0x1e, 0xf, 0x30, 0x3c, 0x78, 0x3d,
    0x81, 0xf1, 0xe0, 0xf4, 0x7, 0xc7, 0x83, 0xf1,
    0x9f, 0x1e, 0xf, 0x83, 0x7c, 0x78, 0x3c, 0x7,
    0xe1, 0xe0, 0xf0, 0xf, 0x87, 0x3, 0xc0, 0x1e,
    0x1c, 0xf, 0x0, 0x7e, 0x70, 0x3c, 0x1, 0xfd,
    0xc0, 0xf0, 0xf, 0x7f, 0x3, 0xc0, 0x3c, 0xfc,
    0xf, 0x0, 0xf1, 0xf0, 0x3c, 0x3, 0x83, 0xe0,
    0xf0, 0x1c, 0xf, 0xe3, 0xc0, 0x70, 0x7f, 0xcf,
    0x3, 0x81, 0xfe, 0x3c, 0xe, 0xe, 0x78, 0xf0,
    0x30, 0x38, 0x63, 0xc1, 0x81, 0xc0, 0x8f, 0x6,
    0x6, 0x0, 0x3c, 0x30, 0x30, 0x0, 0xf1, 0x80,
    0x80, 0x3, 0xc4, 0x4, 0x0, 0xf, 0x20, 0x30,
    0x0, 0x3d, 0x80, 0x80, 0x1, 0xf4, 0x4, 0x0,
    0xf, 0xa0, 0x20, 0x0, 0xfc, 0x1, 0x0, 0x1f,
    0xc0, 0x0, 0x0, 0x8, 0x0,

    /* U+5308 "匈" */
    0x1, 0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0xf, 0x80, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0,
    0x3c, 0x0, 0x1, 0xe0, 0x78, 0x0, 0x3, 0xc0,
    0xff, 0xff, 0xff, 0x83, 0xff, 0xff, 0xff, 0x7,
    0x80, 0x0, 0x1e, 0xe, 0x0, 0x0, 0x3c, 0x1c,
    0x0, 0x0, 0x78, 0x70, 0xe, 0x0, 0xf0, 0xe4,
    0x1c, 0x1, 0xe3, 0xe8, 0x39, 0xe3, 0xc7, 0xc8,
    0xf3, 0xc7, 0x8f, 0x91, 0xe7, 0x8f, 0x3f, 0x33,
    0xcf, 0x1e, 0xde, 0x37, 0x1e, 0x3d, 0x3c, 0x6e,
    0x3c, 0x7c, 0x78, 0x7c, 0x78, 0xf0, 0xf0, 0xf8,
    0xf1, 0xe1, 0xe1, 0xe1, 0xe3, 0xc3, 0xc1, 0xc3,
    0xc7, 0x87, 0x83, 0x87, 0x8f, 0xf, 0x7, 0x8f,
    0x1e, 0x1e, 0xf, 0x1e, 0x3c, 0x3c, 0x3f, 0x3c,
    0x78, 0x78, 0x6f, 0x78, 0xf0, 0xf1, 0x9e, 0xf1,
    0xe1, 0xe2, 0x1d, 0xe3, 0xc3, 0xc8, 0x33, 0xc7,
    0x87, 0xb0, 0x27, 0x8f, 0xf, 0x40, 0x4f, 0x1e,
    0x1f, 0x0, 0x1e, 0x3c, 0x3c, 0x0, 0x3c, 0x78,
    0x78, 0x0, 0x78, 0xf0, 0xff, 0xff, 0xf1, 0xe1,
    0xff, 0xff, 0xe3, 0xc3, 0xc0, 0x3, 0xc7, 0x87,
    0x80, 0x7, 0x8f, 0xf, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x0, 0x4, 0x0,

    /* U+530D "匍" */
    0x1, 0xf0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x7, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0, 0xf0,
    0x1e, 0x0, 0x1, 0xe0, 0x3c, 0x0, 0x3, 0xc0,
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0x3,
    0xc0, 0x0, 0x1e, 0xf, 0xe, 0x20, 0x3c, 0x1e,
    0x1c, 0x70, 0x78, 0x38, 0x38, 0xf0, 0xf0, 0xe0,
    0x70, 0xc1, 0xe1, 0xc0, 0xe1, 0x83, 0xc7, 0xff,
    0xff, 0xf7, 0x8f, 0xff, 0xff, 0xef, 0x30, 0x7,
    0x0, 0x1e, 0x60, 0xe, 0x0, 0x3d, 0x9e, 0x1c,
    0x3c, 0x7e, 0x3c, 0x38, 0x78, 0xf0, 0x7f, 0xff,
    0xf1, 0xe0, 0xff, 0xff, 0xe3, 0xc1, 0xe1, 0xc3,
    0xc7, 0x83, 0xc3, 0x87, 0x8f, 0x7, 0x87, 0xf,
    0x1e, 0xf, 0xe, 0x1e, 0x3c, 0x1f, 0xff, 0xfc,
    0x78, 0x3f, 0xff, 0xf8, 0xf0, 0x78, 0x70, 0xf1,
    0xe0, 0xf0, 0xe1, 0xe3, 0xc1, 0xe1, 0xc3, 0xc7,
    0x83, 0xc3, 0x87, 0x8f, 0x7, 0xff, 0xff, 0x1e,
    0xf, 0xff, 0xfe, 0x3c, 0x1e, 0x1c, 0x3c, 0x78,
    0x3c, 0x38, 0x78, 0xf0, 0x78, 0x70, 0xf1, 0xe0,
    0xf0, 0xe1, 0xe3, 0xc1, 0xe1, 0xc3, 0xc7, 0x83,
    0xc3, 0x87, 0x8f, 0x7, 0x87, 0xf, 0x1e, 0xf,
    0xe, 0x3c, 0x3c, 0x1e, 0x0, 0xf0, 0xf0, 0x3c,
    0x6, 0xc3, 0xe0, 0x0, 0x0, 0x1f, 0x80, 0x0,
    0x0, 0xdc, 0x0,

    /* U+530F "匏" */
    0x3, 0xc0, 0x3c, 0x0, 0x7, 0x80, 0x78, 0x0,
    0xf, 0x0, 0xf0, 0x0, 0x1e, 0x1, 0xe0, 0x0,
    0x3c, 0x3, 0xc1, 0xdf, 0xff, 0xe7, 0x3, 0xbf,
    0xff, 0xce, 0x7, 0x1, 0xc0, 0x3f, 0xfe, 0x3,
    0x80, 0x7f, 0xfc, 0xf, 0x80, 0xe0, 0x38, 0x1d,
    0x81, 0xc0, 0x70, 0x79, 0xc3, 0x0, 0xe0, 0xe1,
    0xce, 0x1, 0xc3, 0x83, 0xd8, 0x3, 0x8e, 0x3,
    0xbc, 0xe7, 0x38, 0x2, 0xf9, 0xce, 0xff, 0xf9,
    0xff, 0x9c, 0x7f, 0xf2, 0xff, 0x38, 0x0, 0xd,
    0xce, 0x70, 0x0, 0x13, 0x9c, 0xe0, 0x0, 0x7,
    0x39, 0xc0, 0x0, 0xe, 0x73, 0x80, 0x0, 0x1c,
    0xe7, 0x7f, 0xff, 0x39, 0xce, 0xe, 0x0, 0x73,
    0x9c, 0x1c, 0x0, 0xe7, 0x38, 0x30, 0x1, 0xfe,
    0x70, 0x60, 0x3, 0xfc, 0xe1, 0x83, 0x87, 0x39,
    0xc6, 0x7, 0xe, 0x73, 0x8f, 0xfe, 0x1c, 0x7,
    0x1f, 0xfc, 0x38, 0x1c, 0x20, 0x38, 0x70, 0x78,
    0x0, 0x70, 0xe3, 0xc8, 0x0, 0xe1, 0xc8, 0x10,
    0x1, 0xc3, 0x80, 0x20, 0x3, 0x87, 0x0, 0x40,
    0x7, 0xe, 0x0, 0x80, 0xe, 0x1c, 0x1, 0x0,
    0x1c, 0x38, 0x3, 0x0, 0x38, 0x70, 0x6, 0x0,
    0x70, 0xe0, 0xc, 0x1, 0xc1, 0xff, 0xf8, 0xf,
    0x83, 0xff, 0xf0, 0xfc, 0x7, 0xff, 0xc0,

    /* U+5310 "匐" */
    0x1, 0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x3e, 0x0, 0x1, 0xe0, 0x78, 0x0, 0x3, 0xc0,
    0xff, 0xff, 0xff, 0x81, 0xff, 0xff, 0xff, 0x3,
    0x80, 0x0, 0x1e, 0x7, 0x0, 0x0, 0x3c, 0x1e,
    0x0, 0x0, 0x78, 0x38, 0x0, 0x0, 0xf0, 0x7f,
    0xff, 0xf1, 0xe1, 0xff, 0xff, 0xe3, 0xc3, 0x0,
    0x0, 0x7, 0x8e, 0x0, 0x0, 0xf, 0x1b, 0x80,
    0x1c, 0x1e, 0x67, 0xff, 0xf8, 0x3c, 0x8f, 0xff,
    0xf0, 0x7a, 0x1c, 0x0, 0xe0, 0xf0, 0x38, 0x1,
    0xc1, 0xe0, 0x70, 0x3, 0x83, 0xc0, 0xff, 0xff,
    0x7, 0x81, 0xff, 0xfe, 0xf, 0x3, 0x80, 0x1c,
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0x1c, 0x0, 0x70,
    0x78, 0x3f, 0xff, 0xe0, 0xf0, 0x7f, 0xff, 0xc1,
    0xe0, 0xe1, 0xc3, 0x83, 0xc1, 0xc3, 0x87, 0x7,
    0x83, 0x87, 0xe, 0xf, 0x7, 0xff, 0xfc, 0x1e,
    0xf, 0xff, 0xf8, 0x3c, 0x1c, 0x38, 0x70, 0x78,
    0x38, 0x70, 0xe0, 0xf0, 0x70, 0xe1, 0xc1, 0xe0,
    0xe1, 0xc3, 0x83, 0xc1, 0xff, 0xff, 0x7, 0x83,
    0x80, 0xe, 0xf, 0x7, 0x0, 0x1c, 0x1e, 0xe,
    0x0, 0x38, 0x78, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x0, 0x80, 0x0,

    /* U+5315 "匕" */
    0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf0, 0x0, 0x8, 0xf0, 0x0, 0x1c,
    0xf0, 0x0, 0x38, 0xf0, 0x0, 0x70, 0xf0, 0x0,
    0xe0, 0xf0, 0x1, 0xc0, 0xf0, 0x7, 0x80, 0xf0,
    0xf, 0x0, 0xf0, 0x1e, 0x0, 0xf0, 0x3c, 0x0,
    0xf0, 0x78, 0x0, 0xf0, 0xf0, 0x0, 0xf1, 0xe0,
    0x0, 0xf3, 0xc0, 0x0, 0xf7, 0x80, 0x0, 0xff,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0xf8, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf0, 0x0, 0x1,
    0xf0, 0x0, 0x1, 0xf0, 0x0, 0x1, 0xf0, 0x0,
    0x3, 0xf0, 0x0, 0x3, 0xf0, 0x0, 0x3, 0xf0,
    0x0, 0x3, 0xf0, 0x0, 0x3, 0xf0, 0x0, 0x7,
    0xf0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x7f, 0xff, 0xfe,

    /* U+5316 "化" */
    0x3, 0xe0, 0xf0, 0x0, 0x3, 0xe0, 0xf0, 0x0,
    0x3, 0xe0, 0xf0, 0x0, 0x3, 0xe0, 0xf0, 0x0,
    0x3, 0xc0, 0xf0, 0x0, 0x3, 0xc0, 0xf0, 0x0,
    0x3, 0xc0, 0xf0, 0x7c, 0x7, 0x80, 0xf0, 0x7c,
    0x7, 0x80, 0xf0, 0x78, 0x7, 0x80, 0xf0, 0x78,
    0x7, 0x0, 0xf0, 0xf8, 0xf, 0x0, 0xf0, 0xf8,
    0xe, 0x0, 0xf0, 0xf8, 0xf, 0x80, 0xf0, 0xf0,
    0x1f, 0x80, 0xf0, 0xf0, 0x1f, 0x80, 0xf1, 0xe0,
    0x1f, 0x80, 0xf1, 0xe0, 0x37, 0x80, 0xf1, 0xc0,
    0x37, 0x80, 0xf3, 0xc0, 0x67, 0x80, 0xf3, 0x80,
    0x47, 0x80, 0xf7, 0x80, 0xc7, 0x80, 0xff, 0x0,
    0x87, 0x80, 0xfe, 0x0, 0x7, 0x80, 0xfc, 0x0,
    0x7, 0x80, 0xf8, 0x0, 0x7, 0x80, 0xf8, 0x0,
    0x7, 0x80, 0xf0, 0x0, 0x7, 0x81, 0xf0, 0x0,
    0x7, 0x81, 0xf0, 0x0, 0x7, 0x83, 0xf0, 0x2,
    0x7, 0x86, 0xf0, 0x2, 0x7, 0x8c, 0xf0, 0x2,
    0x7, 0x98, 0xf0, 0x6, 0x7, 0xb0, 0xf0, 0x6,
    0x7, 0xe0, 0xf0, 0x6, 0x7, 0x80, 0xf0, 0x6,
    0x7, 0x80, 0xf0, 0x7, 0x7, 0x80, 0xf0, 0x7,
    0x7, 0x80, 0xf0, 0x7, 0x7, 0x80, 0xf0, 0xe,
    0x7, 0x80, 0xf0, 0xe, 0x7, 0x80, 0xf8, 0xe,
    0x7, 0x80, 0xff, 0xfe, 0x7, 0x80, 0xff, 0xfe,
    0x7, 0x80, 0x7f, 0xfe, 0x7, 0x80, 0x3f, 0xfc,

    /* U+5317 "北" */
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x2, 0x0, 0x3c, 0x1e, 0x6,
    0x0, 0x3c, 0x1e, 0xe, 0x0, 0x3c, 0x1e, 0xc,
    0x0, 0x3c, 0x1e, 0x18, 0x7f, 0xfc, 0x1e, 0x18,
    0x7f, 0xfc, 0x1e, 0x30, 0x0, 0x3c, 0x1e, 0x60,
    0x0, 0x3c, 0x1e, 0x60, 0x0, 0x3c, 0x1e, 0xc0,
    0x0, 0x3c, 0x1e, 0x80, 0x0, 0x3c, 0x1f, 0x80,
    0x0, 0x3c, 0x1f, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x0,
    0x0, 0x3c, 0x1e, 0x0, 0x0, 0x3c, 0x1e, 0x1,
    0x0, 0x3c, 0x1e, 0x1, 0x0, 0x7c, 0x1e, 0x3,
    0x0, 0xfc, 0x1e, 0x3, 0x1, 0xbc, 0x1e, 0x2,
    0x7, 0x3c, 0x1e, 0x2, 0xff, 0x3c, 0x1e, 0x6,
    0xfe, 0x3c, 0x1e, 0x7, 0x7c, 0x3c, 0x1e, 0x7,
    0x78, 0x3c, 0x1e, 0x7, 0x70, 0x3c, 0x1f, 0xff,
    0x40, 0x3c, 0x1f, 0xff, 0x0, 0x3c, 0xf, 0xff,
    0x0, 0x3c, 0x7, 0xfe, 0x0, 0x3c, 0x0, 0x0,

    /* U+5319 "匙" */
    0x3c, 0xf, 0xf, 0x0, 0x3c, 0xf, 0xf, 0x0,
    0x3f, 0xff, 0xf, 0x0, 0x3f, 0xff, 0xf, 0x0,
    0x3c, 0xf, 0xf, 0x0, 0x3c, 0xf, 0xf, 0x0,
    0x3c, 0xf, 0xf, 0x0, 0x3c, 0xf, 0xf, 0x0,
    0x3c, 0xf, 0xf, 0x1, 0x3f, 0xef, 0xf, 0x3,
    0x3f, 0xef, 0xf, 0x6, 0x3c, 0xf, 0xf, 0xc,
    0x3c, 0xf, 0xf, 0x18, 0x3c, 0xf, 0xf, 0x30,
    0x3c, 0xf, 0xf, 0x30, 0x3c, 0xf, 0xf, 0x60,
    0x3f, 0xff, 0xf, 0xc0, 0x3f, 0xff, 0xf, 0x80,
    0x3c, 0xf, 0xf, 0x0, 0x3c, 0xf, 0xf, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0,
    0xff, 0xff, 0xcf, 0x0, 0xff, 0xff, 0xcf, 0x0,
    0x0, 0x70, 0xf, 0x0, 0x0, 0x70, 0xf, 0x0,
    0x0, 0x70, 0xf, 0x2, 0x3c, 0x70, 0xf, 0x2,
    0x3c, 0x70, 0xf, 0x2, 0x3c, 0x70, 0xf, 0x2,
    0x3c, 0x7f, 0xcf, 0x2, 0x3c, 0x7f, 0xcf, 0x2,
    0x3c, 0x70, 0xf, 0x7, 0x3c, 0x70, 0xf, 0x7,
    0x3c, 0x70, 0xf, 0x7, 0x3c, 0x70, 0xf, 0xff,
    0x3c, 0x70, 0xf, 0xff, 0x3c, 0x70, 0xf, 0xfe,
    0x3a, 0x70, 0x7, 0xfc, 0x73, 0x70, 0x0, 0x0,
    0x73, 0xf0, 0x0, 0x0, 0x61, 0xf0, 0x0, 0x0,
    0x61, 0xff, 0xff, 0xff, 0x40, 0xff, 0xff, 0xfe,
    0xc0, 0x7f, 0xff, 0xfe, 0x80, 0x3f, 0xff, 0xff,

    /* U+531A "匚" */
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0,

    /* U+531D "匝" */
    0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0, 0x1,
    0xe0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x3c, 0x1e,
    0x1e, 0x3c, 0xf0, 0x78, 0x78, 0xf3, 0xff, 0xff,
    0xe3, 0xcf, 0xff, 0xff, 0x8f, 0x3c, 0x1e, 0x1e,
    0x3c, 0xf0, 0x78, 0x78, 0xf3, 0xc1, 0xe1, 0xe3,
    0xcf, 0x7, 0x87, 0x8f, 0x3c, 0x1e, 0x1e, 0x3c,
    0xf0, 0x78, 0x78, 0xf3, 0xc1, 0xe1, 0xe3, 0xcf,
    0x7, 0x87, 0x8f, 0x3c, 0x1e, 0x1e, 0x3c, 0xf0,
    0x78, 0x78, 0xf3, 0xc1, 0xe1, 0xe3, 0xcf, 0x7,
    0x87, 0x8f, 0x3c, 0x1e, 0x1e, 0x3c, 0xf0, 0x78,
    0x78, 0xf3, 0xc1, 0xe1, 0xe3, 0xcf, 0x7, 0x87,
    0x8f, 0x3c, 0x1e, 0x1e, 0x3c, 0xf0, 0x78, 0x78,
    0xf3, 0xc1, 0xe3, 0xe3, 0xcf, 0x7, 0x9f, 0xf,
    0x0, 0x1e, 0x90, 0x3c, 0x0, 0x78, 0x0, 0xf0,
    0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0, 0x1,
    0xe0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x0,

    /* U+5320 "匠" */
    0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xfe, 0xf0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x10, 0x3c, 0x1e, 0x1, 0xe0, 0xf0, 0x78,
    0x1f, 0xc3, 0xc1, 0xe3, 0xff, 0x8f, 0x7, 0xff,
    0xf8, 0x3c, 0x1e, 0x0, 0x0, 0xf0, 0x78, 0x0,
    0x3, 0xc1, 0xe0, 0x0, 0xf, 0x7, 0x80, 0x0,
    0x3c, 0x1e, 0x0, 0x0, 0xf0, 0x78, 0x0, 0x3,
    0xc1, 0xff, 0xff, 0xef, 0x7, 0xff, 0xff, 0xbc,
    0x1e, 0xf, 0x0, 0xf0, 0x78, 0x3c, 0x3, 0xc1,
    0xe0, 0xf0, 0xf, 0x7, 0x83, 0xc0, 0x3c, 0x1e,
    0xf, 0x0, 0xf0, 0x78, 0x3c, 0x3, 0xc1, 0xe0,
    0xf0, 0xf, 0x7, 0x83, 0xc0, 0x3c, 0x1e, 0xf,
    0x0, 0xf0, 0x78, 0x3c, 0x3, 0xc1, 0xe0, 0xf0,
    0xf, 0x7, 0x83, 0xc0, 0x3c, 0x1c, 0xf, 0x0,
    0xf0, 0x70, 0x3c, 0x3, 0xc3, 0x80, 0xf0, 0xf,
    0xc, 0x3, 0xc0, 0x3c, 0x30, 0xf, 0x0, 0xf1,
    0x80, 0x3c, 0x3, 0xcc, 0x0, 0xf0, 0xf, 0x20,
    0x3, 0xc0, 0x3c, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x0,

    /* U+5321 "匡" */
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xcf,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x1, 0xe7, 0xff, 0xff, 0xc3, 0xcf,
    0xff, 0xff, 0x87, 0x80, 0xe, 0x0, 0xf, 0x0,
    0x1c, 0x0, 0x1e, 0x0, 0x38, 0x0, 0x3c, 0x0,
    0x70, 0x0, 0x78, 0x0, 0xe0, 0x0, 0xf0, 0x1,
    0xc0, 0x1, 0xe0, 0x3, 0x80, 0x3, 0xc0, 0x7,
    0x0, 0x7, 0x80, 0xe, 0x0, 0xf, 0x1f, 0xff,
    0xfe, 0x1e, 0x3f, 0xff, 0xfc, 0x3c, 0x0, 0x70,
    0x0, 0x78, 0x0, 0xe0, 0x0, 0xf0, 0x1, 0xc0,
    0x1, 0xe0, 0x3, 0x80, 0x3, 0xc0, 0x7, 0x0,
    0x7, 0x80, 0xe, 0x0, 0xf, 0x0, 0x1c, 0x0,
    0x1e, 0x0, 0x38, 0x0, 0x3c, 0x0, 0x70, 0x0,
    0x78, 0x0, 0xe0, 0x0, 0xf0, 0x1, 0xc0, 0x1,
    0xe0, 0x3, 0x80, 0x3, 0xc0, 0x7, 0x0, 0x7,
    0xbf, 0xff, 0xff, 0xcf, 0x7f, 0xff, 0xff, 0x9e,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0,

    /* U+5323 "匣" */
    0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf,
    0xff, 0xff, 0xff, 0xbf, 0xff, 0xff, 0xfe, 0xf0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x3c, 0xf0, 0x0, 0x78, 0xf3, 0xff,
    0xff, 0xe3, 0xcf, 0xff, 0xff, 0x8f, 0x3c, 0x1e,
    0x1e, 0x3c, 0xf0, 0x78, 0x78, 0xf3, 0xc1, 0xe1,
    0xe3, 0xcf, 0x7, 0x87, 0x8f, 0x3c, 0x1e, 0x1e,
    0x3c, 0xf0, 0x78, 0x78, 0xf3, 0xff, 0xff, 0xe3,
    0xcf, 0xff, 0xff, 0x8f, 0x3c, 0x1e, 0x1e, 0x3c,
    0xf0, 0x78, 0x78, 0xf3, 0xc1, 0xe1, 0xe3, 0xcf,
    0x7, 0x87, 0x8f, 0x3c, 0x1e, 0x1e, 0x3c, 0xf0,
    0x78, 0x78, 0xf3, 0xff, 0xff, 0xe3, 0xcf, 0xff,
    0xff, 0x8f, 0x3c, 0x1e, 0x1e, 0x3c, 0xf0, 0x78,
    0x78, 0xf3, 0xc1, 0xe0, 0x3, 0xc0, 0x7, 0x80,
    0xf, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0x78, 0x0,
    0xf0, 0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0xf,
    0x0, 0x1e, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0,
    0x1, 0xe0, 0x3, 0xc0, 0x7, 0x80, 0xf, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x0,

    /* U+5326 "匦" */
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xef,
    0x3, 0xc3, 0xc0, 0x1e, 0x7, 0x87, 0x80, 0x3c,
    0x1e, 0xf, 0x0, 0x78, 0x3c, 0x1e, 0x0, 0xf0,
    0x78, 0x3c, 0x1, 0xef, 0xfe, 0x78, 0x3, 0xdf,
    0xfc, 0xf0, 0x7, 0x87, 0x81, 0xe7, 0xf, 0xf,
    0x3, 0xce, 0x1e, 0x1e, 0x7, 0x9c, 0x3c, 0x38,
    0x7f, 0xf8, 0x78, 0xfc, 0xff, 0xf0, 0xf1, 0xf8,
    0x3c, 0xe1, 0xe7, 0x70, 0x79, 0xc3, 0xcc, 0xe0,
    0xf3, 0x87, 0xb1, 0xc1, 0xe7, 0xf, 0x7f, 0xf3,
    0xce, 0x1e, 0xff, 0xe7, 0x9c, 0x3c, 0xe, 0xf,
    0x38, 0x78, 0x1c, 0x1e, 0x70, 0xf0, 0x38, 0x3c,
    0xe1, 0xe0, 0x70, 0x79, 0xc3, 0xc0, 0xe4, 0xf3,
    0x87, 0x81, 0xf1, 0xc7, 0xf, 0x3, 0xc3, 0x8e,
    0x1e, 0xff, 0xf, 0x1c, 0x3d, 0xfe, 0x1c, 0x3a,
    0x7b, 0xfc, 0x38, 0x74, 0xf7, 0x38, 0x70, 0xe9,
    0xe0, 0x71, 0xc1, 0xd3, 0xc0, 0xe3, 0x83, 0xb7,
    0x81, 0xc6, 0x7, 0x6f, 0x3, 0x9c, 0xe, 0xde,
    0x7, 0x30, 0x1f, 0xbc, 0xe, 0xc0, 0x3f, 0x78,
    0x1f, 0x0, 0x7c, 0xf0, 0x3e, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0,

    /* U+532A "匪" */
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xef,
    0x0, 0x0, 0x0, 0x1e, 0x3, 0xc7, 0x80, 0x3c,
    0x7, 0x8f, 0x0, 0x78, 0xf, 0x1e, 0x0, 0xf0,
    0x1e, 0x3c, 0x1, 0xe0, 0x3c, 0x78, 0x3, 0xc0,
    0x78, 0xf0, 0x7, 0xbf, 0xf1, 0xff, 0xcf, 0x7f,
    0xe3, 0xff, 0x9e, 0x3, 0xc7, 0x80, 0x3c, 0x7,
    0x8f, 0x0, 0x78, 0xf, 0x1e, 0x0, 0xf0, 0x1e,
    0x3c, 0x1, 0xe0, 0x3c, 0x78, 0x3, 0xc0, 0x78,
    0xf0, 0x7, 0xbf, 0xf1, 0xff, 0x8f, 0x7f, 0xe3,
    0xff, 0x1e, 0x3, 0xc7, 0x80, 0x3c, 0x7, 0x8f,
    0x0, 0x78, 0xf, 0x1e, 0x0, 0xf0, 0x1e, 0x3c,
    0x1, 0xe0, 0x3c, 0x78, 0x3, 0xc0, 0x78, 0xf0,
    0x7, 0x80, 0xf1, 0xe0, 0xf, 0xff, 0xe3, 0xff,
    0xdf, 0xff, 0xc7, 0xff, 0xbc, 0x7, 0x8f, 0x0,
    0x78, 0xf, 0x1e, 0x0, 0xf0, 0x1e, 0x3c, 0x1,
    0xe0, 0x3c, 0x78, 0x3, 0xc0, 0x78, 0xf0, 0x7,
    0x80, 0xf1, 0xe0, 0xf, 0x1, 0xe3, 0xc0, 0x1e,
    0x3, 0xc7, 0x80, 0x3c, 0x7, 0x8f, 0x0, 0x78,
    0xf, 0x1e, 0x0, 0xf0, 0x1e, 0x3c, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0,

    /* U+532D "匭" */
    0xe0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0xe, 0x7,
    0x1, 0xc0, 0x70, 0x38, 0xe, 0x3, 0x81, 0xc0,
    0x70, 0x1c, 0xe, 0x3, 0x80, 0xef, 0xff, 0x9c,
    0x7, 0x7f, 0xfc, 0xe0, 0x38, 0x1c, 0x7, 0x1,
    0xc0, 0xe0, 0x39, 0xce, 0x77, 0x31, 0xce, 0x73,
    0xff, 0x8f, 0xf3, 0x9f, 0xff, 0xff, 0x9c, 0xee,
    0x7f, 0x9c, 0xe7, 0x73, 0x1c, 0xe7, 0x3b, 0x98,
    0xe7, 0x39, 0xdc, 0xc7, 0x39, 0xcf, 0xfe, 0x39,
    0xce, 0x7f, 0xf1, 0xce, 0x73, 0xb9, 0x8e, 0x73,
    0x9d, 0xcc, 0x73, 0x9c, 0xee, 0x63, 0x9c, 0xe7,
    0x73, 0x1c, 0xe7, 0x3f, 0xf8, 0xe7, 0x79, 0xff,
    0xc7, 0x3b, 0xce, 0xe6, 0x31, 0xde, 0x7, 0x1,
    0x8e, 0xf0, 0x38, 0x1c, 0x77, 0xbf, 0xfe, 0xe3,
    0xbd, 0xff, 0xf6, 0x1d, 0xe0, 0x70, 0x30, 0xef,
    0x3, 0x83, 0x7, 0x78, 0x1c, 0x18, 0x3b, 0xc0,
    0xe1, 0x81, 0xde, 0x7, 0x8, 0xf, 0xf0, 0x38,
    0x80, 0x7f, 0x81, 0xc8, 0x3, 0xfc, 0xe, 0x0,
    0x0, 0xe0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0xe,
    0x0, 0x0, 0x0, 0x0,

    /* U+532E "匮" */
    0xf0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xfe, 0xf0, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0, 0xf0, 0x0,
    0xf0, 0x0, 0xf0, 0x0, 0xf1, 0xe0, 0xf0, 0xf0,
    0xf1, 0xff, 0xff, 0xf0, 0xf1, 0xff, 0xff, 0xf0,
    0xf1, 0xe0, 0xf0, 0xf0, 0xf1, 0xe0, 0xf0, 0xf0,
    0xf1, 0xe0, 0xf0, 0xf0, 0xf1, 0xe0, 0xf0, 0xf0,
    0xf1, 0xff, 0xff, 0xf0, 0xf1, 0xff, 0xff, 0xf0,
    0xf1, 0xe0, 0xf0, 0xf0, 0xf0, 0x0, 0xf0, 0x0,
    0xf7, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0,
    0xf1, 0xe0, 0x0, 0xf0, 0xf1, 0xff, 0xff, 0xf0,
    0xf1, 0xff, 0xff, 0xf0, 0xf1, 0xe0, 0x0, 0xf0,
    0xf1, 0xe1, 0xe0, 0xf0, 0xf1, 0xe1, 0xe0, 0xf0,
    0xf1, 0xe1, 0xe0, 0xf0, 0xf1, 0xe1, 0xe0, 0xf0,
    0xf1, 0xe1, 0xe0, 0xf0, 0xf1, 0xe1, 0xf0, 0xf0,
    0xf1, 0xe1, 0xf0, 0xf0, 0xf1, 0xe3, 0xe8, 0xe0,
    0xf1, 0xe3, 0xcc, 0xe0, 0xf1, 0xe7, 0x8f, 0x80,
    0xf0, 0x7, 0x7, 0x80, 0xf0, 0xc, 0x7, 0xf8,
    0xf0, 0x18, 0x3, 0xf8, 0xf0, 0x60, 0x1, 0xf0,
    0xf1, 0x80, 0x0, 0xf0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0,

    /* U+532F "匯" */
    0xf0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x78, 0x81, 0xe4, 0x3, 0xc6, 0xf,
    0x30, 0x1e, 0x18, 0x79, 0xe0, 0xf0, 0xe3, 0xc7,
    0x7, 0x83, 0x9c, 0x30, 0x3c, 0x18, 0xe1, 0x1,
    0xe0, 0x5f, 0xff, 0xef, 0x1, 0x7f, 0xff, 0x7a,
    0xb, 0x87, 0x3, 0xd8, 0x5c, 0x38, 0x1e, 0xc2,
    0xe1, 0xc0, 0xf3, 0x2f, 0xe, 0x7, 0x9d, 0x78,
    0x70, 0x3c, 0x6b, 0xff, 0xfd, 0xe3, 0x7f, 0xff,
    0xef, 0x7, 0x70, 0xe0, 0x78, 0x23, 0x87, 0x3,
    0xc1, 0x1c, 0x38, 0x1e, 0x18, 0xe1, 0xc0, 0xf0,
    0xc7, 0xe, 0x7, 0x84, 0x38, 0x70, 0x3c, 0x21,
    0xff, 0xfd, 0xf3, 0xe, 0x1c, 0xf, 0x58, 0x70,
    0xe0, 0x79, 0xc3, 0x87, 0x3, 0xce, 0x1c, 0x38,
    0x1e, 0x70, 0xe1, 0xc0, 0xf1, 0xc7, 0xe, 0x7,
    0x8f, 0x38, 0x70, 0x3c, 0x39, 0xff, 0xfd, 0xe0,
    0xef, 0xff, 0xef, 0x6, 0x70, 0x0, 0x78, 0x13,
    0x80, 0x3, 0xc0, 0x1c, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfc, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x0,

    /* U+5331 "匱" */
    0xf0, 0x0, 0x0, 0x3, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x38, 0x0, 0xf0,
    0x0, 0xe0, 0x3, 0xc3, 0xc3, 0x87, 0xf, 0xf,
    0xff, 0xfc, 0x3c, 0x3f, 0xff, 0xf0, 0xf0, 0xf0,
    0xe1, 0xc3, 0xc3, 0xc3, 0x87, 0xf, 0xf, 0xe,
    0x1c, 0x3c, 0x3c, 0x38, 0x70, 0xf0, 0xff, 0xff,
    0xc3, 0xc3, 0xff, 0xff, 0xf, 0xf, 0xe, 0x1c,
    0x3d, 0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x3c,
    0x78, 0x0, 0x38, 0xf1, 0xff, 0xff, 0xe3, 0xc7,
    0xff, 0xff, 0x8f, 0x1e, 0x0, 0x1e, 0x3c, 0x78,
    0x0, 0x78, 0xf1, 0xff, 0xfd, 0xe3, 0xc7, 0xff,
    0xf7, 0x8f, 0x1e, 0x0, 0x1e, 0x3c, 0x78, 0x0,
    0x78, 0xf1, 0xff, 0xfd, 0xe3, 0xc7, 0x80, 0x7,
    0x8f, 0x1e, 0x0, 0x1e, 0x3c, 0x7f, 0xff, 0xf8,
    0xf1, 0xff, 0xff, 0xe3, 0xc7, 0x80, 0x7, 0x8f,
    0x1e, 0x1, 0x1e, 0x3c, 0x3, 0xe3, 0x0, 0xf0,
    0x1e, 0xf, 0x3, 0xc0, 0xf0, 0x1f, 0xcf, 0x7,
    0x0, 0x1f, 0x3c, 0x60, 0x0, 0x38, 0xf2, 0x0,
    0x0, 0x23, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x0,

    /* U+5339 "匹" */
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xe7, 0xff, 0xff, 0xff, 0xcf,
    0x3, 0xc7, 0x80, 0x1e, 0x7, 0x8f, 0x0, 0x3c,
    0xf, 0x1e, 0x0, 0x78, 0x1e, 0x3c, 0x0, 0xf0,
    0x3c, 0x78, 0x1, 0xe0, 0x78, 0xf0, 0x3, 0xc0,
    0xf1, 0xe0, 0x7, 0x81, 0xe3, 0xc0, 0xf, 0x3,
    0xc7, 0x80, 0x1e, 0x7, 0x8f, 0x0, 0x3c, 0xf,
    0x1e, 0x0, 0x78, 0x1e, 0x3c, 0x0, 0xf0, 0x3c,
    0x78, 0x1, 0xe0, 0x78, 0xf0, 0x3, 0xc0, 0xf1,
    0xe0, 0x7, 0x81, 0xe3, 0xc0, 0xf, 0x3, 0xc7,
    0x80, 0x1e, 0x7, 0x8f, 0x4, 0x3c, 0xf, 0x1e,
    0x8, 0x78, 0x1e, 0x3c, 0x10, 0xf0, 0x3c, 0x78,
    0x21, 0xe0, 0x70, 0xf0, 0x43, 0xc0, 0xe1, 0xe1,
    0x87, 0x81, 0xc3, 0xc3, 0xf, 0x3, 0x7, 0x86,
    0x1e, 0xe, 0xf, 0xe, 0x3c, 0x18, 0x1e, 0x1c,
    0x78, 0x30, 0x3f, 0xf8, 0xf0, 0xc0, 0x7f, 0xe1,
    0xe3, 0x0, 0x7f, 0xc3, 0xc6, 0x0, 0x7f, 0x7,
    0x98, 0x0, 0x0, 0xf, 0x60, 0x0, 0x0, 0x1f,
    0x80, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0,

    /* U+533A "区" */
    0xf0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x7, 0x90, 0x0, 0x78, 0x3c, 0x40, 0x3, 0xc1,
    0xe3, 0x0, 0x3e, 0xf, 0xc, 0x1, 0xf0, 0x78,
    0x30, 0xf, 0x83, 0xc1, 0x80, 0x78, 0x1e, 0x6,
    0x3, 0xc0, 0xf0, 0x38, 0x1e, 0x7, 0x80, 0xe0,
    0xf0, 0x3c, 0x3, 0x8f, 0x1, 0xe0, 0x1e, 0x78,
    0xf, 0x0, 0x7b, 0xc0, 0x78, 0x1, 0xfc, 0x3,
    0xc0, 0xf, 0xe0, 0x1e, 0x0, 0x3e, 0x0, 0xf0,
    0x1, 0xf0, 0x7, 0x80, 0xf, 0xc0, 0x3c, 0x0,
    0xff, 0x1, 0xe0, 0x7, 0x7c, 0xf, 0x0, 0x73,
    0xf0, 0x78, 0x7, 0xf, 0xc3, 0xc0, 0x70, 0x3f,
    0x1e, 0x7, 0x0, 0xf8, 0xf0, 0x30, 0x7, 0x87,
    0x83, 0x0, 0x1c, 0x3c, 0x30, 0x0, 0x61, 0xe3,
    0x0, 0x1, 0xf, 0x30, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,

    /* U+533B "医" */
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xef,
    0x0, 0x0, 0x0, 0x1e, 0x7, 0x80, 0x0, 0x3c,
    0xf, 0x0, 0x0, 0x78, 0x1e, 0x0, 0x0, 0xf0,
    0x38, 0x0, 0x1, 0xe0, 0x70, 0x0, 0x3, 0xc1,
    0xe0, 0x0, 0x7, 0x83, 0xff, 0xfe, 0xf, 0x7,
    0xff, 0xfc, 0x1e, 0xe, 0x3c, 0x0, 0x3c, 0x1c,
    0x78, 0x0, 0x78, 0x30, 0xf0, 0x0, 0xf0, 0xc1,
    0xe0, 0x1, 0xe1, 0x83, 0xc0, 0x3, 0xc2, 0x7,
    0x80, 0x7, 0x8c, 0xf, 0x0, 0xf, 0x10, 0x1e,
    0x0, 0x1e, 0x0, 0x3c, 0x0, 0x3c, 0xff, 0xff,
    0xff, 0x79, 0xff, 0xff, 0xfe, 0xf0, 0x1, 0xe0,
    0x1, 0xe0, 0x3, 0xc0, 0x3, 0xc0, 0xf, 0x80,
    0x7, 0x80, 0x1f, 0x80, 0xf, 0x0, 0x39, 0x80,
    0x1e, 0x0, 0xf3, 0x0, 0x3c, 0x1, 0xc7, 0x0,
    0x78, 0x7, 0x7, 0x0, 0xf0, 0xc, 0xf, 0x81,
    0xe0, 0x38, 0x1f, 0xc3, 0xc0, 0x60, 0x1f, 0xf7,
    0x81, 0x80, 0x1f, 0xcf, 0x6, 0x0, 0x1f, 0x9e,
    0x18, 0x0, 0x1f, 0x3c, 0x60, 0x0, 0x1c, 0x79,
    0x80, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0,

    /* U+533D "匽" */
    0xf0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0xf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0xf, 0x1c, 0x0, 0xe3, 0xc7,
    0xff, 0xf8, 0xf1, 0xff, 0xfe, 0x3c, 0x70, 0x3,
    0x8f, 0x1c, 0x0, 0xe3, 0xc7, 0x0, 0x38, 0xf1,
    0xc0, 0xe, 0x3c, 0x7f, 0xf3, 0x8f, 0x1f, 0xfc,
    0xe3, 0xc7, 0x0, 0x38, 0xf1, 0xc0, 0xe, 0x3c,
    0x70, 0x3, 0x8f, 0x1f, 0xff, 0xe3, 0xc7, 0xff,
    0xf8, 0xf1, 0xc0, 0xe, 0x3c, 0x70, 0x3, 0x8f,
    0x1, 0xe0, 0x3, 0xc0, 0x78, 0x0, 0xf0, 0x1c,
    0x0, 0x3c, 0x7, 0x0, 0xf, 0x7f, 0xff, 0xf3,
    0xdf, 0xff, 0xfc, 0xf0, 0x78, 0x3c, 0x3c, 0x1e,
    0xe, 0xf, 0x7, 0x3, 0x83, 0xc3, 0xc1, 0xe0,
    0xf0, 0xe0, 0x70, 0x3c, 0x3c, 0x3c, 0xf, 0x1f,
    0xfe, 0x3, 0xc0, 0x1f, 0xc0, 0xf0, 0x7, 0xfc,
    0x3c, 0x3, 0x9f, 0x8f, 0x3, 0x81, 0xf3, 0xc1,
    0x80, 0x1c, 0xf1, 0x80, 0x1, 0x3d, 0x80, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,

    /* U+533E "匾" */
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x10, 0x0, 0x1e, 0x0, 0x38, 0x0, 0x3c,
    0x0, 0x3c, 0x0, 0x78, 0xf0, 0x30, 0x38, 0xf1,
    0xff, 0xff, 0xf1, 0xe3, 0xff, 0xff, 0xe3, 0xc7,
    0x80, 0x1, 0xc7, 0x8f, 0x0, 0x3, 0x8f, 0x1e,
    0x0, 0x7, 0x1e, 0x3c, 0x0, 0xe, 0x3c, 0x78,
    0x0, 0x1c, 0x78, 0xff, 0xff, 0xf8, 0xf1, 0xff,
    0xff, 0xf1, 0xe3, 0xc0, 0x0, 0xe3, 0xc7, 0x80,
    0x0, 0x7, 0x8f, 0x0, 0x1, 0xcf, 0x1e, 0x0,
    0x3, 0x9e, 0x3f, 0xff, 0xff, 0x3c, 0x7f, 0xff,
    0xfe, 0x78, 0xfc, 0xe3, 0x9c, 0xf1, 0xf9, 0xc7,
    0x39, 0xe3, 0xf3, 0x8e, 0x73, 0xcf, 0xe7, 0x1c,
    0xe7, 0x9f, 0xce, 0x39, 0xcf, 0x3f, 0xff, 0xff,
    0x9e, 0x6f, 0xff, 0xff, 0x3c, 0xde, 0x71, 0xce,
    0x79, 0x3c, 0xe3, 0x9c, 0xf6, 0x79, 0xc7, 0x39,
    0xe8, 0xf3, 0x8e, 0x73, 0xd1, 0xe7, 0x1c, 0xe7,
    0xc3, 0xce, 0x39, 0xcf, 0x87, 0x9c, 0x73, 0x9e,
    0xf, 0x38, 0xf, 0x3c, 0x1e, 0x0, 0x3c, 0x78,
    0x3c, 0x1, 0xe0, 0xf0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0,

    /* U+533F "匿" */
    0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xf7, 0xff, 0xff, 0xff, 0xef,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x3c,
    0xf, 0x3, 0xc0, 0x78, 0x1e, 0x7, 0x80, 0xf0,
    0x3c, 0xf, 0x1, 0xe0, 0x78, 0x1e, 0x3, 0xdf,
    0xff, 0xff, 0xf7, 0xbf, 0xff, 0xff, 0xef, 0x3,
    0xc0, 0xf0, 0x1e, 0x7, 0x81, 0xe0, 0x3c, 0xf,
    0x3, 0xc0, 0x78, 0x1e, 0x7, 0x80, 0xf0, 0x7,
    0xc0, 0x1, 0xe0, 0xf, 0x80, 0x3, 0xc0, 0x1e,
    0x0, 0x7, 0x80, 0x3c, 0x0, 0xf, 0x7f, 0xff,
    0xff, 0xde, 0xff, 0xff, 0xff, 0xbc, 0x3, 0xc0,
    0x0, 0x78, 0xf, 0x0, 0x0, 0xf0, 0x1e, 0x0,
    0x1, 0xe0, 0x78, 0x0, 0x3, 0xc0, 0xf0, 0x7,
    0x87, 0x83, 0xff, 0xff, 0xf, 0x7, 0xff, 0xfe,
    0x1e, 0x1f, 0x80, 0x3c, 0x3c, 0x37, 0x0, 0x78,
    0x78, 0xce, 0x0, 0xf0, 0xf1, 0x1c, 0x1, 0xe1,
    0xe4, 0x38, 0x3, 0xc3, 0xd8, 0x70, 0x7, 0x87,
    0xa0, 0xe0, 0xf, 0xf, 0x1, 0xff, 0xfe, 0x1e,
    0x3, 0x80, 0x3c, 0x3c, 0x7, 0x0, 0x78, 0x78,
    0xe, 0x0, 0xf0, 0xf0, 0x0, 0x0, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x0,

    /* U+5340 "區" */
    0xf0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x78, 0x78, 0xf, 0x83, 0xc3, 0xc0,
    0x7c, 0x1e, 0x1f, 0xff, 0xe0, 0xf0, 0xff, 0xff,
    0x7, 0x87, 0x80, 0xf8, 0x3c, 0x3c, 0x7, 0xc1,
    0xe1, 0xe0, 0x3e, 0xf, 0xf, 0x1, 0xf0, 0x78,
    0x78, 0xf, 0x83, 0xc3, 0xc0, 0x7c, 0x1e, 0x1e,
    0x3, 0xe0, 0xf0, 0xff, 0xff, 0x7, 0x87, 0xff,
    0xf8, 0x3c, 0x3c, 0x7, 0xc1, 0xe1, 0xe0, 0x3e,
    0xf, 0x0, 0x0, 0x0, 0x79, 0xc7, 0x38, 0x73,
    0xce, 0x39, 0xc3, 0x9e, 0x7f, 0xcf, 0xfc, 0xf3,
    0x8e, 0x70, 0xe7, 0x9c, 0x73, 0x87, 0x3c, 0xe3,
    0x9c, 0x39, 0xe7, 0x1c, 0xe1, 0xcf, 0x38, 0xe7,
    0xe, 0x79, 0xc7, 0x38, 0x73, 0xce, 0x39, 0xc3,
    0x9e, 0x71, 0xce, 0x1c, 0xf3, 0x8e, 0x70, 0xe7,
    0x9c, 0x73, 0x87, 0x3c, 0xff, 0x9f, 0xf9, 0xe7,
    0xfc, 0xff, 0xcf, 0x38, 0xe7, 0xe, 0x79, 0xc7,
    0x38, 0x73, 0xce, 0x39, 0xc3, 0x9e, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,

    /* U+5341 "十" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+5343 "千" */
    0x0, 0x0, 0x3, 0x80, 0x0, 0x0, 0x1f, 0xc0,
    0x0, 0x1, 0xff, 0xf0, 0x0, 0x3f, 0xff, 0xf8,
    0xf, 0xff, 0xff, 0x0, 0x30, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+5345 "卅" */
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x83, 0xc1, 0xe0, 0x7, 0x83, 0xc1, 0xe0,
    0x7, 0x3, 0xc1, 0xe0, 0x7, 0x3, 0xc1, 0xe0,
    0x7, 0x3, 0xc1, 0xe0, 0x6, 0x3, 0xc1, 0xe0,
    0xc, 0x3, 0xc1, 0xe0, 0xc, 0x3, 0xc1, 0xe0,
    0x18, 0x3, 0xc1, 0xe0, 0x10, 0x0, 0x1, 0xe0,
    0x20, 0x0, 0x1, 0xe0, 0x40, 0x0, 0x1, 0xe0,

    /* U+5347 "升" */
    0x0, 0x2, 0xf, 0x0, 0x0, 0x7, 0xf, 0x0,
    0x0, 0x1f, 0xcf, 0x0, 0x0, 0x7f, 0xef, 0x0,
    0x3, 0xfe, 0xf, 0x0, 0xf, 0xf0, 0xf, 0x0,
    0x78, 0xf0, 0xf, 0x0, 0x80, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xf0, 0xf, 0x0, 0x0, 0xf0, 0xf, 0x0,
    0x0, 0xe0, 0xf, 0x0, 0x0, 0xe0, 0xf, 0x0,
    0x1, 0xe0, 0xf, 0x0, 0x1, 0xe0, 0xf, 0x0,
    0x1, 0xe0, 0xf, 0x0, 0x1, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xf, 0x0, 0x3, 0x80, 0xf, 0x0,
    0x3, 0x0, 0xf, 0x0, 0x7, 0x0, 0xf, 0x0,
    0x6, 0x0, 0xf, 0x0, 0xc, 0x0, 0xf, 0x0,
    0x18, 0x0, 0xf, 0x0, 0x30, 0x0, 0xf, 0x0,
    0x20, 0x0, 0xf, 0x0, 0x40, 0x0, 0xf, 0x0,

    /* U+5348 "午" */
    0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xf8, 0x3, 0xff, 0xff, 0xf8,
    0x3, 0x83, 0xe0, 0x0, 0x7, 0x83, 0xe0, 0x0,
    0x7, 0x83, 0xe0, 0x0, 0x7, 0x3, 0xe0, 0x0,
    0x7, 0x3, 0xe0, 0x0, 0xe, 0x3, 0xe0, 0x0,
    0xe, 0x3, 0xe0, 0x0, 0xc, 0x3, 0xe0, 0x0,
    0x18, 0x3, 0xe0, 0x0, 0x18, 0x3, 0xe0, 0x0,
    0x30, 0x3, 0xe0, 0x0, 0x20, 0x3, 0xe0, 0x0,
    0x40, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0, 0x0,

    /* U+5349 "卉" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x7f, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0xff,
    0xf8, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x3, 0xc7,
    0x87, 0x80, 0x1, 0xe3, 0xc3, 0xc0, 0x0, 0xf1,
    0xe1, 0xe0, 0x0, 0x78, 0x0, 0xf0, 0x0, 0x3c,
    0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0, 0xf,
    0x0, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x1, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x80,
    0xf0, 0x1, 0xe0, 0x0, 0x78, 0x0, 0xf0, 0x0,
    0x3c, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xf, 0x0,
    0x3, 0xc0, 0x7, 0x80, 0x1, 0xe0, 0x3, 0xc0,
    0x0, 0xf0, 0x1, 0xe0, 0x0, 0xf0, 0x0, 0xf0,
    0x0, 0x78, 0x0, 0x78, 0x0, 0x38, 0x0, 0x3c,
    0x0, 0x1c, 0x0, 0x1e, 0x0, 0x1c, 0x0, 0xf,
    0x0, 0xe, 0x0, 0x7, 0x80, 0x6, 0x0, 0x3,
    0xc0, 0x6, 0x0, 0x1, 0xe0, 0x2, 0x0, 0x0,
    0xf0, 0x3, 0x0, 0x0, 0x78, 0x3, 0x0, 0x0,
    0x3c, 0x1, 0x0, 0x0, 0x1e, 0x0,

    /* U+534A "半" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x10, 0x3, 0xc0, 0x10,
    0x18, 0x3, 0xc0, 0x18, 0x1c, 0x3, 0xc0, 0x38,
    0xe, 0x3, 0xc0, 0x30, 0xf, 0x3, 0xc0, 0x60,
    0x7, 0x83, 0xc0, 0xe0, 0x7, 0xc3, 0xc0, 0xc0,
    0x7, 0xe3, 0xc1, 0xc0, 0x3, 0xe3, 0xc3, 0x80,
    0x1, 0xe3, 0xc3, 0x0, 0x1, 0xc3, 0xc7, 0x0,
    0x0, 0xc3, 0xc6, 0x0, 0x0, 0x83, 0xcc, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+534E "华" */
    0x0, 0xf0, 0x3c, 0x0, 0x0, 0xf8, 0x1e, 0x0,
    0x0, 0x7c, 0xf, 0x0, 0x0, 0x3c, 0x7, 0x87,
    0xc0, 0x1e, 0x3, 0xc3, 0xe0, 0xf, 0x1, 0xe1,
    0xf0, 0xf, 0x0, 0xf0, 0xf0, 0x7, 0x80, 0x78,
    0xf0, 0x3, 0x80, 0x3c, 0x78, 0x3, 0xe0, 0x1e,
    0x78, 0x1, 0xf0, 0xf, 0x78, 0x0, 0xf8, 0x7,
    0xf0, 0x0, 0xfc, 0x3, 0xf0, 0x0, 0xde, 0x1,
    0xf0, 0x10, 0x4f, 0x0, 0xf0, 0x8, 0x47, 0x80,
    0xf8, 0x4, 0x43, 0xc0, 0xfc, 0x2, 0x61, 0xe1,
    0xde, 0x1, 0x0, 0xf1, 0x8f, 0x0, 0xc0, 0x7b,
    0x7, 0x80, 0x60, 0x3e, 0x3, 0xff, 0xf0, 0x1e,
    0x1, 0xff, 0xf8, 0xf, 0x0, 0xff, 0xfc, 0x7,
    0x80, 0x7f, 0xfc, 0x3, 0xc1, 0xef, 0xfc, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x7,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0,

    /* U+534F "协" */
    0xf, 0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0xf0, 0x0, 0xf, 0x0, 0xf0, 0x0,
    0xf, 0x0, 0xf0, 0x0, 0xf, 0x0, 0xf1, 0xe0,
    0xf, 0x0, 0xf1, 0xe0, 0xf, 0xf, 0xff, 0xe0,
    0xff, 0xff, 0xff, 0xe0, 0xff, 0xf0, 0xf1, 0xe0,
    0xf, 0x0, 0xf1, 0xe0, 0xf, 0x0, 0xf1, 0xe0,
    0xf, 0x0, 0xf1, 0xe0, 0xf, 0x0, 0xf1, 0xe8,
    0xf, 0x1c, 0xf1, 0xe8, 0xf, 0x1c, 0xf1, 0xe4,
    0xf, 0x1c, 0xf1, 0xe4, 0xf, 0x1c, 0xf1, 0xe4,
    0xf, 0x1c, 0xf1, 0xec, 0xf, 0x1c, 0xf1, 0xec,
    0xf, 0x1c, 0xf1, 0xee, 0xf, 0x1c, 0xf1, 0xe6,
    0xf, 0x1c, 0xf1, 0xe6, 0xf, 0x1c, 0xf1, 0xe6,
    0xf, 0x1c, 0xf1, 0xe7, 0xf, 0x1c, 0xf1, 0xe7,
    0xf, 0x18, 0xf1, 0xe7, 0xf, 0x18, 0xf1, 0xe7,
    0xf, 0x30, 0xf1, 0xe7, 0xf, 0x30, 0xe1, 0xe3,
    0xf, 0x30, 0xe1, 0xe3, 0xf, 0x61, 0xe1, 0xe1,
    0xf, 0x41, 0xe1, 0xe1, 0xf, 0xc1, 0xc1, 0xe0,
    0xf, 0x1, 0xc1, 0xe0, 0xf, 0x3, 0x81, 0xe0,
    0xf, 0x3, 0x1, 0xe0, 0xf, 0x3, 0x1, 0xe0,
    0xf, 0x6, 0x1, 0xe0, 0xf, 0x4, 0x1, 0xe0,
    0xf, 0x8, 0x1, 0xe0, 0xf, 0x10, 0x7, 0xc0,
    0xf, 0x10, 0xf, 0x80, 0xf, 0x20, 0x32, 0x0,

    /* U+5351 "卑" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x70, 0x0,
    0x0, 0xf0, 0x30, 0x7, 0x80, 0x7f, 0xff, 0xff,
    0xc0, 0x3f, 0xff, 0xff, 0xe0, 0x1e, 0x7, 0xc0,
    0xf0, 0xf, 0x3, 0xe0, 0x78, 0x7, 0x81, 0xf0,
    0x3c, 0x3, 0xc0, 0xf8, 0x1e, 0x1, 0xe0, 0x7c,
    0xf, 0x0, 0xf0, 0x3e, 0x7, 0x80, 0x7f, 0xff,
    0xff, 0xc0, 0x3f, 0xff, 0xff, 0xe0, 0x1e, 0x7,
    0x80, 0xf0, 0xf, 0x3, 0xc0, 0x78, 0x7, 0x81,
    0xe0, 0x3c, 0x3, 0xc0, 0xf0, 0x1e, 0x1, 0xe0,
    0x78, 0xf, 0x0, 0xf0, 0x3c, 0x7, 0x80, 0x78,
    0x1c, 0x3, 0xc0, 0x3f, 0xff, 0xff, 0xe0, 0x1e,
    0xe, 0x0, 0xf0, 0xf, 0x6, 0x0, 0x78, 0x7,
    0x87, 0x78, 0x3c, 0x0, 0x7, 0x3c, 0x0, 0x0,
    0x7, 0x1e, 0x0, 0x0, 0x6, 0xf, 0x0, 0x0,
    0x6, 0x7, 0x80, 0x0, 0x4, 0x3, 0xc0, 0x1,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x80, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x7, 0x80, 0x0,

    /* U+5352 "卒" */
    0x0, 0x7, 0x0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x7f, 0xff, 0xff, 0xfe,
    0x7f, 0xff, 0xff, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xe0, 0xe, 0x0,
    0x1, 0xe0, 0xe, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x3, 0xe0, 0x1e, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x3, 0xc0, 0x1f, 0x0, 0x3, 0xc0, 0x1d, 0x0,
    0x3, 0xe0, 0x1d, 0x80, 0x7, 0xf0, 0x39, 0xc0,
    0x7, 0x3c, 0x39, 0xc0, 0x7, 0x3e, 0x30, 0xe0,
    0x6, 0x1e, 0x30, 0xf8, 0xe, 0x1e, 0x60, 0xfc,
    0xc, 0xc, 0x60, 0x7c, 0x8, 0x4, 0xc0, 0x78,
    0x18, 0x0, 0xc0, 0x38, 0x10, 0x0, 0x80, 0x18,
    0x20, 0x3, 0xc0, 0x8, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,

    /* U+5353 "卓" */
    0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xc0, 0x0, 0x1f, 0xff, 0xe0, 0x0, 0xf, 0x0,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x3, 0xe0, 0xf0,
    0x3c, 0x1, 0xff, 0xff, 0xfe, 0x0, 0xff, 0xff,
    0xff, 0x0, 0x7c, 0x0, 0x7, 0x80, 0x3e, 0x0,
    0x3, 0xc0, 0x1f, 0x0, 0x1, 0xe0, 0xf, 0x80,
    0x0, 0xf0, 0x7, 0xc0, 0x0, 0x78, 0x3, 0xe0,
    0x0, 0x3c, 0x1, 0xff, 0xff, 0x1e, 0x0, 0xf8,
    0x0, 0xf, 0x0, 0x7c, 0x0, 0x7, 0x80, 0x3e,
    0x0, 0x3, 0xc0, 0x1f, 0x0, 0x1, 0xe0, 0xf,
    0x80, 0x0, 0xf0, 0x7, 0xc0, 0x0, 0x78, 0x3,
    0xff, 0xff, 0xfc, 0x1, 0xf0, 0xf8, 0x1e, 0x0,
    0xf8, 0x7c, 0xf, 0x0, 0x7c, 0x3e, 0x7, 0x80,
    0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80, 0x0,
    0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x0, 0x1f, 0x0, 0x0, 0x0, 0xf, 0x80,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x3, 0xe0,
    0x0, 0x0, 0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8,
    0x0, 0x0, 0x0, 0x7c, 0x0, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x0, 0x1f, 0x0, 0x0,

    /* U+5354 "協" */
    0x0, 0x0, 0x70, 0x0, 0x38, 0x1, 0xc0, 0x0,
    0xe0, 0x7, 0x0, 0x3, 0x80, 0x1c, 0x0, 0xe,
    0x0, 0x70, 0x70, 0x38, 0x1, 0xc1, 0xc0, 0xe1,
    0xff, 0xff, 0x3, 0x87, 0xff, 0xfc, 0xe, 0x0,
    0xf0, 0x70, 0x38, 0x3, 0xc1, 0xc0, 0xe0, 0xe,
    0x7, 0x3, 0x80, 0x38, 0x1c, 0xff, 0xe1, 0xc0,
    0x73, 0xff, 0x87, 0x1, 0xc0, 0xe0, 0x38, 0x7,
    0x3, 0x80, 0xc0, 0x38, 0xe, 0x6, 0x1, 0xe0,
    0x38, 0x70, 0x1e, 0x0, 0xe3, 0x3, 0x80, 0x3,
    0x87, 0x0, 0xe0, 0xe, 0x1c, 0x3, 0x80, 0x38,
    0x70, 0xe, 0x0, 0xe1, 0xc0, 0x38, 0x3, 0x87,
    0x0, 0xe0, 0xe, 0x1c, 0xe3, 0x9c, 0x3b, 0xff,
    0xff, 0xf0, 0xef, 0xff, 0xff, 0xc3, 0x87, 0x38,
    0xc7, 0xe, 0x1c, 0xe3, 0x1c, 0x38, 0x73, 0x8c,
    0x70, 0xe1, 0xce, 0x31, 0xc3, 0x87, 0x38, 0xc7,
    0xe, 0x1c, 0xe3, 0x1c, 0x38, 0x73, 0x8c, 0x70,
    0xe1, 0xce, 0x31, 0xc3, 0x86, 0x38, 0xc7, 0xe,
    0x18, 0xe3, 0x1c, 0x38, 0xe3, 0x8c, 0x70, 0xe3,
    0xe, 0x61, 0xc3, 0x8c, 0x39, 0x87, 0xe, 0x20,
    0xcc, 0x1c, 0x39, 0x87, 0x20, 0x70, 0xe4, 0x39,
    0x83, 0x83, 0xb1, 0x8c, 0x1e, 0xe, 0x80, 0x20,
    0xe0, 0x3c, 0x1, 0xf, 0x0,

    /* U+5355 "单" */
    0x0, 0x0, 0x1, 0x80, 0x0, 0xc0, 0x3, 0x80,
    0x0, 0x70, 0x3, 0x0, 0x0, 0x78, 0x6, 0x0,
    0x0, 0x3e, 0x6, 0x0, 0x0, 0x3e, 0xc, 0x0,
    0x0, 0x1e, 0x18, 0x0, 0xf, 0xc, 0x18, 0x78,
    0xf, 0xc, 0x30, 0x78, 0xf, 0xff, 0xff, 0xf8,
    0xf, 0x3, 0xc0, 0x78, 0xf, 0x3, 0xc0, 0x78,
    0xf, 0x3, 0xc0, 0x78, 0xf, 0x3, 0xc0, 0x78,
    0xf, 0x3, 0xc0, 0x78, 0xf, 0x3, 0xc0, 0x78,
    0xf, 0xff, 0xff, 0xf8, 0xf, 0xff, 0xff, 0xf8,
    0xf, 0x3, 0xc0, 0x78, 0xf, 0x3, 0xc0, 0x78,
    0xf, 0x3, 0xc0, 0x78, 0xf, 0x3, 0xc0, 0x78,
    0xf, 0x3, 0xc0, 0x78, 0xf, 0x3, 0xc0, 0x78,
    0xf, 0xff, 0xff, 0xf8, 0xf, 0xff, 0xff, 0xf8,
    0xf, 0x3, 0xc0, 0x78, 0xf, 0x3, 0xc0, 0x78,
    0xf, 0x3, 0xc0, 0x78, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0,

    /* U+5356 "卖" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x3f, 0xff, 0xff, 0xfe,
    0x3f, 0xff, 0xff, 0xfe, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x1e,
    0x0, 0x3, 0xc0, 0x1e, 0x0, 0x3, 0xc0, 0x1e,
    0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xfe,
    0x0, 0x0, 0x0, 0x1e, 0x1, 0x0, 0xf0, 0x1e,
    0x0, 0x80, 0xf0, 0x1e, 0x0, 0xe0, 0xf0, 0x10,
    0x0, 0x70, 0xf0, 0x10, 0x0, 0x78, 0xf0, 0x0,
    0x0, 0x38, 0xf0, 0x0, 0x0, 0x38, 0xf0, 0x0,
    0x8, 0x18, 0xf0, 0x0, 0x4, 0x10, 0xf0, 0x0,
    0x3, 0x0, 0xf0, 0x0, 0x3, 0xc0, 0xf0, 0x0,
    0x1, 0xe0, 0xf0, 0x0, 0x0, 0xe0, 0xf0, 0x0,
    0x0, 0xe0, 0xf0, 0x0, 0x0, 0x40, 0xf0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1, 0xf0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xd8, 0x0, 0x0, 0x7, 0x9c, 0x0,
    0x0, 0xf, 0xe, 0x0, 0x0, 0xe, 0xf, 0x80,
    0x0, 0x1c, 0x7, 0xe0, 0x0, 0x38, 0x3, 0xfc,
    0x0, 0x70, 0x1, 0xff, 0x1, 0xc0, 0x0, 0xff,
    0x3, 0x80, 0x0, 0x7f, 0x6, 0x0, 0x0, 0x1f,
    0x18, 0x0, 0x0, 0x7, 0x30, 0x0, 0x0, 0x1,

    /* U+5357 "南" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x0,
    0x0, 0x0, 0xf8, 0x0, 0x0, 0x0, 0x7c, 0x0,
    0x0, 0x0, 0x3e, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xc0,
    0x0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x0, 0x60,
    0x0, 0x3, 0xc0, 0x60, 0x3, 0xc1, 0xff, 0xff,
    0xff, 0xe0, 0xff, 0xff, 0xff, 0xf0, 0x78, 0x0,
    0x0, 0x78, 0x3c, 0x20, 0x4, 0x3c, 0x1e, 0x8,
    0x6, 0x1e, 0xf, 0x6, 0x2, 0xf, 0x7, 0x83,
    0xc3, 0x7, 0x83, 0xc0, 0xc3, 0x3, 0xc1, 0xe0,
    0x61, 0x81, 0xe0, 0xf0, 0x11, 0x80, 0xf0, 0x79,
    0xff, 0xff, 0x78, 0x3c, 0xff, 0xff, 0xbc, 0x1e,
    0x1, 0xe0, 0x1e, 0xf, 0x0, 0xf0, 0xf, 0x7,
    0x80, 0x78, 0x7, 0x83, 0xc0, 0x3c, 0x3, 0xc1,
    0xe0, 0x1e, 0x1, 0xe0, 0xf0, 0xf, 0x0, 0xf0,
    0x79, 0xff, 0xff, 0x78, 0x3c, 0xff, 0xff, 0xbc,
    0x1e, 0x1, 0xe0, 0x1e, 0xf, 0x0, 0xf0, 0xf,
    0x7, 0x80, 0x78, 0x7, 0x83, 0xc0, 0x3c, 0x3,
    0xc1, 0xe0, 0x1e, 0x1, 0xe0, 0xf0, 0xf, 0x0,
    0xf0, 0x78, 0x7, 0x80, 0x78, 0x3c, 0x3, 0xc0,
    0x3c, 0x1e, 0x1, 0xe0, 0x1e, 0xf, 0x0, 0xf0,
    0xf, 0x7, 0x80, 0x78, 0xf, 0x83, 0xc0, 0x0,
    0x1f, 0x81, 0xe0, 0x0, 0x3f, 0x0, 0x0, 0x0,
    0x20, 0x0,

    /* U+535A "博" */
    0x1e, 0x0, 0x3d, 0x80, 0x1e, 0x0, 0x3c, 0xe0,
    0x1e, 0x0, 0x3c, 0xf0, 0x1e, 0x0, 0x3c, 0x70,
    0x1e, 0x0, 0x3c, 0x30, 0x1e, 0x7f, 0xff, 0xff,
    0x1e, 0x7f, 0xff, 0xff, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x1e, 0x3c, 0x78, 0xff, 0xdf, 0xff, 0xf8,
    0xff, 0xdf, 0xff, 0xf8, 0x1e, 0x1e, 0x3c, 0x78,
    0x1e, 0x1e, 0x3c, 0x78, 0x1e, 0x1e, 0x3c, 0x78,
    0x1e, 0x1e, 0x3c, 0x78, 0x1e, 0x1f, 0xff, 0xf8,
    0x1e, 0x1f, 0xff, 0xf8, 0x1e, 0x1e, 0x3c, 0x78,
    0x1e, 0x1e, 0x3c, 0x78, 0x1e, 0x1e, 0x3c, 0x78,
    0x1e, 0x1e, 0x3c, 0x78, 0x1e, 0x1f, 0xff, 0xf8,
    0x1e, 0x1f, 0xff, 0xf8, 0x1e, 0x1e, 0x3c, 0x78,
    0x1e, 0x1e, 0x3c, 0x78, 0x1e, 0x1e, 0x3c, 0x78,
    0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0,
    0x1e, 0x7f, 0xff, 0xff, 0x1e, 0x7f, 0xff, 0xff,
    0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0, 0x1, 0xe0,
    0x1e, 0x4, 0x1, 0xe0, 0x1e, 0x6, 0x1, 0xe0,
    0x1e, 0x3, 0x1, 0xe0, 0x1e, 0x3, 0x81, 0xe0,
    0x1e, 0x3, 0x81, 0xe0, 0x1e, 0x1, 0x81, 0xe0,
    0x1e, 0x1, 0x81, 0xe0, 0x1e, 0x0, 0x1, 0xe0,
    0x1e, 0x0, 0x1, 0xe0, 0x1e, 0x0, 0x3, 0xe0,
    0x1e, 0x0, 0x7, 0xc0, 0x1e, 0x0, 0x1f, 0x0,

    /* U+535C "卜" */
    0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x40, 0xf, 0x10, 0x3,
    0xc4, 0x0, 0xf1, 0x0, 0x3c, 0x40, 0xf, 0x18,
    0x3, 0xc6, 0x0, 0xf1, 0x80, 0x3c, 0x60, 0xf,
    0x1c, 0x3, 0xc3, 0x0, 0xf0, 0xe0, 0x3c, 0x38,
    0xf, 0xf, 0x3, 0xc3, 0xc0, 0xf0, 0x78, 0x3c,
    0x1f, 0xf, 0x7, 0xc3, 0xc0, 0xf8, 0xf0, 0x3f,
    0x3c, 0x7, 0xef, 0x1, 0xfb, 0xc0, 0x3c, 0xf0,
    0xf, 0x3c, 0x1, 0xcf, 0x0, 0x33, 0xc0, 0xc,
    0xf0, 0x1, 0x3c, 0x0, 0xf, 0x0, 0x3, 0xc0,
    0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x3,
    0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0xf, 0x0,
    0x3, 0xc0, 0x0, 0xf0, 0x0, 0x3c, 0x0, 0x0,

    /* U+535E "卞" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x0, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xc0, 0x0,
    0x0, 0x0, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x84, 0x0, 0x0, 0x7, 0x84, 0x0,
    0x0, 0x7, 0x84, 0x0, 0x0, 0x7, 0x86, 0x0,
    0x0, 0x7, 0x86, 0x0, 0x0, 0x7, 0x86, 0x0,
    0x0, 0x7, 0x86, 0x0, 0x0, 0x7, 0x86, 0x0,
    0x0, 0x7, 0x83, 0x0, 0x0, 0x7, 0x83, 0x0,
    0x0, 0x7, 0x83, 0x80, 0x0, 0x7, 0x83, 0x80,
    0x0, 0x7, 0x83, 0xc0, 0x0, 0x7, 0x81, 0xe0,
    0x0, 0x7, 0x81, 0xf0, 0x0, 0x7, 0x81, 0xf8,
    0x0, 0x7, 0x80, 0xf8, 0x0, 0x7, 0x80, 0xf0,
    0x0, 0x7, 0x80, 0x70, 0x0, 0x7, 0x80, 0x70,
    0x0, 0x7, 0x80, 0x30, 0x0, 0x7, 0x80, 0x10,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,

    /* U+535F "卟" */
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x0,
    0x0, 0x1, 0xe0, 0x7, 0x7, 0x3, 0xc0, 0xe,
    0xe, 0x7, 0x80, 0x1f, 0xfc, 0xf, 0x0, 0x3f,
    0xf8, 0x1e, 0x0, 0x70, 0x70, 0x3c, 0x0, 0xe0,
    0xe0, 0x78, 0x1, 0xc1, 0xc0, 0xf0, 0x3, 0x83,
    0x81, 0xe0, 0x7, 0x7, 0x3, 0xc8, 0xe, 0xe,
    0x7, 0x90, 0x1c, 0x1c, 0xf, 0x30, 0x38, 0x38,
    0x1e, 0x60, 0x70, 0x70, 0x3c, 0xc0, 0xe0, 0xe0,
    0x79, 0x81, 0xc1, 0xc0, 0xf3, 0x83, 0x83, 0x81,
    0xe3, 0x7, 0x7, 0x3, 0xc7, 0xe, 0xe, 0x7,
    0x8e, 0x1c, 0x1c, 0xf, 0x1e, 0x38, 0x38, 0x1e,
    0x3e, 0x70, 0x70, 0x3c, 0x3f, 0xe0, 0xe0, 0x78,
    0x7d, 0xc1, 0xc0, 0xf0, 0xfb, 0x83, 0x81, 0xe0,
    0xf7, 0x7, 0x3, 0xc1, 0xef, 0xfe, 0x7, 0x81,
    0x9c, 0x1c, 0xf, 0x3, 0x38, 0x38, 0x1e, 0x2,
    0x70, 0x70, 0x3c, 0x0, 0xe0, 0xe0, 0x78, 0x1,
    0xc1, 0xc0, 0xf0, 0x3, 0x80, 0x1, 0xe0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0xf, 0x0, 0x0,

    /* U+5360 "占" */
    0x0, 0x3c, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0x3, 0xff, 0xff, 0x0, 0x3f, 0xff, 0xf0,
    0x3, 0xc0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x3c,
    0x0, 0xf, 0x3, 0xc0, 0xf0, 0xff, 0xff, 0xff,
    0xf, 0xff, 0xff, 0xf0, 0xf0, 0x0, 0xf, 0xf,
    0x0, 0x0, 0xf0, 0xf0, 0x0, 0xf, 0xf, 0x0,
    0x0, 0xf0, 0xf0, 0x0, 0xf, 0xf, 0x0, 0x0,
    0xf0, 0xf0, 0x0, 0xf, 0xf, 0x0, 0x0, 0xf0,
    0xf0, 0x0, 0xf, 0xf, 0x0, 0x0, 0xf0, 0xf0,
    0x0, 0xf, 0xf, 0x0, 0x0, 0xf0, 0xf0, 0x0,
    0xf, 0xf, 0x0, 0x0, 0xf0, 0xf0, 0x0, 0xf,
    0xf, 0x0, 0x0, 0xf0, 0xff, 0xff, 0xff, 0xf,
    0xff, 0xff, 0xf0, 0xf0, 0x0, 0xf, 0xf, 0x0,
    0x0, 0xf0, 0xf0, 0x0, 0xf, 0xf, 0x0, 0x0,
    0xf0,

    /* U+5361 "卡" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0xff, 0xfc,
    0x0, 0x7, 0xff, 0xfc, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x90, 0x0,
    0x0, 0x7, 0x90, 0x0, 0x0, 0x7, 0x88, 0x0,
    0x0, 0x7, 0x8c, 0x0, 0x0, 0x7, 0x8c, 0x0,
    0x0, 0x7, 0x8e, 0x0, 0x0, 0x7, 0x8f, 0x0,
    0x0, 0x7, 0x87, 0x80, 0x0, 0x7, 0x87, 0xe0,
    0x0, 0x7, 0x83, 0xf8, 0x0, 0x7, 0x83, 0xf8,
    0x0, 0x7, 0x81, 0xf0, 0x0, 0x7, 0x80, 0xf0,
    0x0, 0x7, 0x80, 0x70, 0x0, 0x7, 0x80, 0x38,
    0x0, 0x7, 0x80, 0x8, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0,

    /* U+5362 "卢" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1f, 0xff,
    0xfc, 0x0, 0xf, 0xff, 0xfe, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x1, 0xe0, 0x78,
    0x7, 0x80, 0xf0, 0x3c, 0x3, 0xc0, 0x7f, 0xff,
    0xff, 0xe0, 0x3f, 0xff, 0xff, 0xf0, 0x1e, 0x0,
    0x0, 0x78, 0xf, 0x0, 0x0, 0x3c, 0x7, 0x80,
    0x0, 0x1e, 0x3, 0xc0, 0x0, 0xf, 0x1, 0xe0,
    0x0, 0x7, 0x80, 0xf0, 0x0, 0x3, 0xc0, 0x78,
    0x0, 0x1, 0xe0, 0x3c, 0x0, 0x0, 0xf0, 0x1e,
    0x0, 0x0, 0x78, 0xf, 0xff, 0xff, 0xfc, 0x7,
    0xff, 0xff, 0xfe, 0x3, 0xc0, 0x0, 0xf, 0x1,
    0xe0, 0x0, 0x7, 0x80, 0xf0, 0x0, 0x0, 0x0,
    0x78, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0x0, 0x70, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0,
    0x0, 0x38, 0x0, 0x0, 0x0, 0x18, 0x0, 0x0,
    0x0, 0xc, 0x0, 0x0, 0x0, 0xc, 0x0, 0x0,
    0x0, 0x4, 0x0, 0x0, 0x0, 0x4, 0x0, 0x0,
    0x0, 0x6, 0x0, 0x0, 0x0, 0x0,

    /* U+5363 "卣" */
    0x0, 0x1e, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x1,
    0xe0, 0x0, 0x0, 0xf, 0xff, 0xfc, 0x0, 0x7f,
    0xff, 0xe0, 0x3, 0xc0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x3c, 0x7, 0x80, 0x1,
    0xe0, 0x3c, 0x3, 0xcf, 0xff, 0xff, 0xfe, 0x7f,
    0xff, 0xff, 0xf3, 0xc0, 0x0, 0x7, 0x9e, 0x0,
    0x0, 0x3c, 0xf0, 0x0, 0x1, 0xe7, 0x80, 0x0,
    0xf, 0x3c, 0x0, 0x0, 0x79, 0xe0, 0x0, 0x3,
    0xcf, 0x0, 0x3c, 0x1e, 0x78, 0x1, 0xe0, 0xf3,
    0xc0, 0xf, 0x7, 0x9f, 0xff, 0xf8, 0x3c, 0xf0,
    0x3, 0xc1, 0xe7, 0x80, 0x1e, 0xf, 0x3c, 0x0,
    0xf0, 0x79, 0xe0, 0x7, 0x83, 0xcf, 0x0, 0x3c,
    0x1e, 0x78, 0x1, 0xe0, 0xf3, 0xc0, 0xf, 0x7,
    0x9e, 0x0, 0x78, 0x3c, 0xff, 0xff, 0xc1, 0xe7,
    0xff, 0xfe, 0xf, 0x3c, 0x0, 0xf0, 0x79, 0xe0,
    0x7, 0x83, 0xcf, 0x0, 0x3c, 0x1e, 0x78, 0x0,
    0x0, 0xf3, 0xc0, 0x0, 0x7, 0x9e, 0x0, 0x0,
    0x3c, 0xf0, 0x0, 0x1, 0xe7, 0xff, 0xff, 0xff,
    0x3f, 0xff, 0xff, 0xf9, 0xe0, 0x0, 0x3, 0xcf,
    0x0, 0x0, 0x1e, 0x78, 0x0, 0x0, 0xf0,

    /* U+5364 "卤" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xf0, 0x0,
    0xff, 0xff, 0xc0, 0x3, 0xc0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x3c, 0x3, 0xc0, 0x78, 0xff, 0xff, 0xff,
    0xe3, 0xff, 0xff, 0xff, 0x8f, 0x0, 0x0, 0x1e,
    0x3c, 0x0, 0x0, 0x78, 0xf0, 0x0, 0xf1, 0xe3,
    0xc0, 0x3, 0xc7, 0x8f, 0x0, 0xf, 0x1e, 0x3c,
    0x40, 0x3c, 0x78, 0xf0, 0x80, 0xf1, 0xe3, 0xc3,
    0x3, 0x87, 0x8f, 0x6, 0x1e, 0x1e, 0x3c, 0x1c,
    0x78, 0x78, 0xf0, 0x39, 0xe1, 0xe3, 0xc0, 0x77,
    0x7, 0x8f, 0x1, 0xfc, 0x1e, 0x3c, 0x3, 0xf0,
    0x78, 0xf0, 0xf, 0x81, 0xe3, 0xc0, 0x1e, 0x7,
    0x8f, 0x0, 0xfc, 0x1e, 0x3c, 0x3, 0xf8, 0x78,
    0xf0, 0x19, 0xf1, 0xe3, 0xc0, 0xc3, 0xe7, 0x8f,
    0x6, 0x7, 0x9e, 0x3c, 0x30, 0xe, 0x78, 0xf1,
    0x80, 0x39, 0xe3, 0xcc, 0x0, 0x67, 0x8f, 0xc0,
    0x0, 0x9e, 0x3c, 0x0, 0x0, 0x78, 0xf0, 0x0,
    0x1, 0xe3, 0xff, 0xff, 0xff, 0x8f, 0x0, 0x0,
    0x1e, 0x3c, 0x0, 0x0, 0x78, 0xf0, 0x0, 0x1,
    0xe3, 0xc0, 0x0, 0x7, 0x80,

    /* U+5366 "卦" */
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0xf, 0x0, 0x78, 0x0, 0x3, 0xc0, 0x1e,
    0x0, 0x0, 0xf0, 0x7, 0x80, 0x0, 0x3c, 0x1,
    0xe0, 0x0, 0xf, 0x0, 0x78, 0x0, 0x7f, 0xff,
    0x1e, 0x0, 0x1f, 0xff, 0xc7, 0x80, 0x0, 0x3c,
    0x1, 0xe0, 0x0, 0xf, 0x0, 0x78, 0x0, 0x3,
    0xc0, 0x1e, 0x40, 0x0, 0xf0, 0x7, 0x90, 0x0,
    0x3c, 0x1, 0xe4, 0x0, 0xf, 0x0, 0x79, 0x0,
    0x3, 0xc0, 0x1e, 0x40, 0x7f, 0xff, 0xe7, 0x98,
    0x1f, 0xff, 0xf9, 0xe6, 0x0, 0x0, 0x0, 0x79,
    0xc0, 0x3, 0xc0, 0x1e, 0x30, 0x0, 0xf0, 0x7,
    0x8e, 0x0, 0x3c, 0x1, 0xe3, 0xc0, 0xf, 0x0,
    0x78, 0xf0, 0x3, 0xc0, 0x1e, 0x3e, 0x0, 0xf0,
    0x7, 0x87, 0xc0, 0x3c, 0x1, 0xe1, 0xe3, 0xff,
    0xf8, 0x78, 0x38, 0xff, 0xfe, 0x1e, 0xe, 0x0,
    0xf0, 0x7, 0x81, 0x80, 0x3c, 0x1, 0xe0, 0x20,
    0xf, 0x0, 0x78, 0x0, 0x3, 0xc0, 0x1e, 0x0,
    0x0, 0xf0, 0x7, 0x80, 0x0, 0x3c, 0x1, 0xe0,
    0x0, 0xf, 0x1, 0xf8, 0x0, 0x3, 0xc0, 0x9e,
    0x0, 0x0, 0xf0, 0xc7, 0x80, 0x0, 0x3d, 0xe1,
    0xe0, 0xe, 0x1f, 0xe0, 0x78, 0x1, 0xff, 0xe0,
    0x1e, 0x0, 0x7f, 0xe0, 0x7, 0x80, 0x1f, 0xc0,
    0x1, 0xe0, 0x7, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0x1, 0xe0, 0x0,

    /* U+5367 "卧" */
    0xf0, 0x0, 0x1e, 0x1, 0xe0, 0x0, 0x3c, 0x3,
    0xff, 0xfe, 0x78, 0x7, 0xff, 0xfc, 0xf0, 0xf,
    0x1c, 0x1, 0xe0, 0x1e, 0x38, 0x3, 0xc0, 0x3c,
    0x70, 0x7, 0x80, 0x78, 0xe0, 0xf, 0x0, 0xf1,
    0xc0, 0x1e, 0x1, 0xe3, 0x80, 0x3c, 0x3, 0xc7,
    0x0, 0x78, 0x7, 0x8e, 0x0, 0xf2, 0xf, 0x1c,
    0x1, 0xe4, 0x1e, 0x38, 0xf3, 0xc8, 0x3c, 0x71,
    0xe7, 0x90, 0x7f, 0xff, 0xcf, 0x20, 0xff, 0xff,
    0x9e, 0x41, 0xe0, 0xf, 0x3c, 0x83, 0xc0, 0x1e,
    0x79, 0x87, 0x80, 0x3c, 0xf3, 0xf, 0x0, 0x79,
    0xe7, 0x1e, 0x0, 0xf3, 0xce, 0x3c, 0x1, 0xe7,
    0x9e, 0x78, 0x3, 0xcf, 0x3f, 0xf0, 0x7, 0x9e,
    0x7f, 0xe0, 0xf, 0x3c, 0x7b, 0xc0, 0x1e, 0x78,
    0xf7, 0xff, 0xfc, 0xf0, 0xef, 0xff, 0xf9, 0xe0,
    0xde, 0x3c, 0xf3, 0xc0, 0xbc, 0x79, 0xe7, 0x80,
    0xf8, 0xf0, 0xf, 0x0, 0xf1, 0xe0, 0x1e, 0x1,
    0xe3, 0xc0, 0x3c, 0x3, 0xc7, 0x80, 0x78, 0x7,
    0x8f, 0x0, 0xf0, 0xf, 0x1e, 0x1, 0xe0, 0x1e,
    0x3c, 0x3, 0xc0, 0x3c, 0x78, 0x7, 0x80, 0x78,
    0xf0, 0xf, 0x0, 0xf1, 0xe0, 0x1e, 0x1, 0xe3,
    0xc0, 0x3c, 0x3, 0xff, 0xff, 0x78, 0x7, 0xff,
    0xfe, 0xf0, 0xf, 0x0, 0x1, 0xe0, 0x1e, 0x0,
    0x3, 0xc0, 0x0,

    /* U+5369 "卩" */
    0xf0, 0xff, 0xf, 0xff, 0xff, 0xff, 0xf0, 0xff,
    0xf, 0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0,
    0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf,
    0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0, 0xff,
    0xf, 0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0,
    0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf,
    0xf0, 0xff, 0xf, 0xf0, 0xff, 0xf, 0xf0, 0xff,
    0x1e, 0xf1, 0xef, 0x7c, 0xff, 0x8f, 0x0, 0xf0,
    0xf, 0x0, 0xf0, 0xf, 0x0,

    /* U+536B "卫" */
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x0, 0xf0,
    0x3f, 0xff, 0xff, 0xf0, 0x3f, 0xff, 0xff, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x1e, 0x0, 0xf0, 0x0, 0x1e, 0x1, 0xe0,
    0x0, 0x1e, 0x3, 0xc0, 0x0, 0x1e, 0xf, 0x80,
    0x0, 0x1e, 0x12, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+536E "卮" */
    0x0, 0x0, 0x0, 0x38, 0x3, 0x80, 0x0, 0xfc,
    0x1, 0xc0, 0x7, 0xff, 0x0, 0xe0, 0x3f, 0xff,
    0xc0, 0x77, 0xff, 0xfc, 0x0, 0x3e, 0x40, 0x0,
    0x0, 0x1c, 0x0, 0x0, 0x0, 0xe, 0x0, 0x0,
    0x0, 0x7, 0x0, 0x0, 0x0, 0x3, 0x80, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xf0, 0x7f, 0xff, 0xff, 0xf8, 0x38, 0x0,
    0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0xe, 0x0,
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x3, 0x83,
    0x80, 0x3c, 0x1, 0xc1, 0xc0, 0x1e, 0x0, 0xe0,
    0xe0, 0xf, 0x0, 0x70, 0x7f, 0xff, 0x80, 0x38,
    0x3f, 0xff, 0xc0, 0x1c, 0x1c, 0x1, 0xe0, 0xe,
    0xe, 0x0, 0xf0, 0x7, 0x7, 0x0, 0x78, 0x3,
    0x83, 0x80, 0x3c, 0x1, 0xc1, 0xc0, 0x1e, 0x0,
    0xe0, 0xe0, 0xf, 0x0, 0x70, 0x70, 0x7, 0x80,
    0x38, 0x38, 0x3, 0xc0, 0x1c, 0x1c, 0x3, 0xe0,
    0xe, 0xe, 0x3, 0xe2, 0x7, 0x7, 0x3, 0xe1,
    0x3, 0x83, 0x87, 0xe0, 0x83, 0x81, 0xc4, 0x40,
    0x41, 0xc0, 0xe0, 0x0, 0x20, 0xe0, 0x70, 0x0,
    0x10, 0x70, 0x38, 0x0, 0x8, 0x70, 0x1c, 0x0,
    0x6, 0x38, 0xe, 0x0, 0x3, 0x18, 0x7, 0x0,
    0x3, 0x9c, 0x3, 0xff, 0xff, 0xcc, 0x1, 0xff,
    0xff, 0xec, 0x0, 0x7f, 0xff, 0xf4, 0x0, 0x0,
    0x0, 0x0,

    /* U+536F "卯" */
    0x0, 0x2, 0x0, 0x0, 0x0, 0x1c, 0xf0, 0x1,
    0xe0, 0xfb, 0xc3, 0xc7, 0x8f, 0xff, 0xf, 0x1e,
    0xfe, 0x3f, 0xfc, 0x7e, 0x0, 0xff, 0xf1, 0xe0,
    0x3, 0xc3, 0xc7, 0x80, 0xf, 0xf, 0x1e, 0x1e,
    0x3c, 0x3c, 0x78, 0x78, 0xf0, 0xf1, 0xe1, 0xe3,
    0xc3, 0xc7, 0x87, 0x8f, 0xf, 0x1e, 0x1e, 0x3c,
    0x3c, 0x78, 0x78, 0xf0, 0xf1, 0xe1, 0xe3, 0xc3,
    0xc7, 0x87, 0x8f, 0xf, 0x1e, 0x1e, 0x3c, 0x3c,
    0x78, 0x78, 0xf0, 0xf1, 0xe1, 0xe3, 0xc3, 0xc7,
    0x87, 0x8f, 0xf, 0x1e, 0x1e, 0x3c, 0x3c, 0x78,
    0x78, 0xf0, 0xf1, 0xe1, 0xe3, 0xc3, 0xc7, 0x87,
    0x8f, 0xf, 0x1e, 0x1e, 0x3c, 0x3c, 0x78, 0x78,
    0xf0, 0xf1, 0xe1, 0xe3, 0xc3, 0xc7, 0x87, 0x8f,
    0xf, 0x1e, 0x1e, 0x3c, 0x3c, 0x78, 0x78, 0xf0,
    0xf1, 0xe3, 0xe3, 0xc3, 0xc7, 0x9f, 0x8f, 0xf,
    0x1f, 0xde, 0x3c, 0x3f, 0xfe, 0x70, 0xf0, 0xf7,
    0xf3, 0xc3, 0xc3, 0xdf, 0xf, 0xf, 0xf, 0x70,
    0x38, 0x3c, 0x3c, 0x1, 0xe0, 0xf1, 0xe0, 0x7,
    0x3, 0xcf, 0x80, 0x38, 0xf, 0xf8, 0x0, 0xc0,
    0x3c, 0x0, 0x7, 0x0, 0xf0, 0x0, 0x38, 0x3,
    0xc0, 0x1, 0xc0, 0xf, 0x0, 0xe, 0x0, 0x3c,
    0x0, 0x60, 0x0, 0xf0, 0x3, 0x0, 0x3, 0xc0,
    0x0,

    /* U+5370 "印" */
    0x0, 0x4, 0x78, 0x0, 0xf0, 0x79, 0xe0, 0xf3,
    0xc7, 0xf7, 0x83, 0xcf, 0x7f, 0xff, 0xff, 0x3e,
    0x0, 0x7f, 0xfc, 0xf0, 0x1, 0xe0, 0xf3, 0xc0,
    0x7, 0x83, 0xcf, 0x0, 0x1e, 0xf, 0x3c, 0x0,
    0x78, 0x3c, 0xf0, 0x1, 0xe0, 0xf3, 0xc0, 0x7,
    0x83, 0xcf, 0x0, 0x1e, 0xf, 0x3c, 0x0, 0x78,
    0x3c, 0xf0, 0x1, 0xe0, 0xf3, 0xc0, 0x7, 0x83,
    0xcf, 0x0, 0x1e, 0xf, 0x3c, 0x0, 0x78, 0x3c,
    0xf0, 0x1, 0xe0, 0xf3, 0xff, 0xe7, 0x83, 0xcf,
    0xff, 0x9e, 0xf, 0x3c, 0x0, 0x78, 0x3c, 0xf0,
    0x1, 0xe0, 0xf3, 0xc0, 0x7, 0x83, 0xcf, 0x0,
    0x1e, 0xf, 0x3c, 0x0, 0x78, 0x3c, 0xf0, 0x1,
    0xe0, 0xf3, 0xc0, 0x7, 0x83, 0xcf, 0x0, 0x1e,
    0xf, 0x3c, 0x0, 0x78, 0x3c, 0xf0, 0x1, 0xe0,
    0xf3, 0xc0, 0x7, 0x83, 0xcf, 0x0, 0x9e, 0xf,
    0x3c, 0x6, 0x78, 0x3c, 0xf0, 0x71, 0xe0, 0xf3,
    0xc3, 0x87, 0x83, 0xcf, 0xfc, 0x1e, 0xf, 0x7f,
    0xe0, 0x78, 0x3d, 0xff, 0x1, 0xe3, 0xe7, 0xf0,
    0x7, 0xbf, 0x1f, 0x0, 0x1f, 0x60, 0x60, 0x0,
    0x78, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x1, 0xe0, 0x0,

    /* U+5371 "危" */
    0x0, 0xf8, 0x0, 0x0, 0x0, 0x7c, 0x1, 0xe0,
    0x0, 0x7c, 0x0, 0xf0, 0x0, 0x3f, 0xff, 0xf8,
    0x0, 0x1f, 0xff, 0xfc, 0x0, 0xf, 0x0, 0x1c,
    0x0, 0xf, 0x0, 0x1e, 0x0, 0x7, 0x80, 0xe,
    0x0, 0x3, 0x80, 0x7, 0x0, 0x3, 0x80, 0x3,
    0x0, 0x1, 0xc0, 0x3, 0x0, 0x1, 0xf0, 0x1,
    0x80, 0x0, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff,
    0xff, 0xfc, 0x7e, 0x0, 0x0, 0x0, 0x6f, 0x0,
    0x0, 0x0, 0x67, 0x80, 0x0, 0x0, 0x23, 0xc7,
    0x80, 0x78, 0x21, 0xe3, 0xc0, 0x3c, 0x0, 0xf1,
    0xff, 0xfe, 0x0, 0x78, 0xff, 0xff, 0x0, 0x3c,
    0x78, 0x7, 0x80, 0x1e, 0x3c, 0x3, 0xc0, 0xf,
    0x1e, 0x1, 0xe0, 0x7, 0x8f, 0x0, 0xf0, 0x3,
    0xc7, 0x80, 0x78, 0x1, 0xe3, 0xc0, 0x3c, 0x0,
    0xf1, 0xe0, 0x1e, 0x0, 0x78, 0xf0, 0xf, 0x0,
    0x3c, 0x78, 0x7, 0x80, 0x1c, 0x3c, 0x3, 0xc0,
    0xe, 0x1e, 0x1, 0xe0, 0x7, 0xf, 0x1, 0xe0,
    0x3, 0x87, 0x83, 0xc0, 0x81, 0x83, 0xcf, 0x80,
    0x40, 0xc1, 0xe0, 0x0, 0x60, 0xe0, 0xf0, 0x0,
    0x30, 0x60, 0x78, 0x0, 0x18, 0x30, 0x3c, 0x0,
    0xc, 0x30, 0x1e, 0x0, 0x6, 0x18, 0xf, 0x0,
    0x7, 0x18, 0x7, 0x80, 0x3, 0x8c, 0x3, 0xff,
    0xff, 0xcc, 0x1, 0xff, 0xff, 0xe4, 0x0, 0x7f,
    0xff, 0xf4, 0x0, 0x3f, 0xff, 0xf0,

    /* U+5372 "卲" */
    0x0, 0xf, 0x1c, 0x1f, 0xff, 0xfc, 0x70, 0x7f,
    0xff, 0xf1, 0xc1, 0xc1, 0xc3, 0xc7, 0xff, 0x7,
    0xf, 0x1f, 0xfc, 0x1c, 0x3c, 0x70, 0x70, 0x70,
    0xf1, 0xc1, 0xc1, 0xc3, 0xc7, 0x7, 0x7, 0xf,
    0x1c, 0x1c, 0x1c, 0x3c, 0x70, 0x70, 0xe0, 0xf1,
    0xc1, 0xc3, 0x83, 0xc7, 0x7, 0xe, 0xf, 0x1c,
    0x1c, 0x30, 0x3c, 0x70, 0x70, 0xc0, 0xf1, 0xc1,
    0xc7, 0x3, 0xc7, 0x7, 0x18, 0xf, 0x1c, 0x1c,
    0x40, 0x3c, 0x70, 0x73, 0x1, 0xe1, 0xc1, 0xc8,
    0x1f, 0x7, 0x7, 0x40, 0x90, 0x1c, 0x1f, 0x0,
    0x0, 0x70, 0x70, 0x0, 0x1, 0xc1, 0xcf, 0x3,
    0xe7, 0x7, 0x3f, 0xff, 0x9c, 0x1c, 0xff, 0xfe,
    0x70, 0x73, 0xc0, 0xf9, 0xc1, 0xcf, 0x3, 0xe7,
    0x7, 0x3c, 0xf, 0x9c, 0x1c, 0xf0, 0x3e, 0x70,
    0x73, 0xc0, 0xf9, 0xc1, 0xcf, 0x3, 0xe7, 0x7,
    0x3c, 0xf, 0x9c, 0x1c, 0xf0, 0x3e, 0x70, 0x73,
    0xc0, 0xf9, 0xc1, 0xcf, 0x3, 0xe7, 0x7, 0x3c,
    0xf, 0x9c, 0x1c, 0xf0, 0x3e, 0x70, 0xe3, 0xc0,
    0xf9, 0xcf, 0xf, 0xff, 0xe7, 0xf0, 0x3f, 0xff,
    0x9c, 0x0, 0xf0, 0x3e, 0x70, 0x3, 0xc0, 0xf9,
    0xc0, 0xf, 0x3, 0xe7, 0x0, 0x3c, 0xf, 0x80,
    0x0, 0xf0, 0x0, 0x0, 0x0,

    /* U+5373 "即" */
    0x1c, 0xe, 0x3c, 0x3c, 0x70, 0x38, 0xf0, 0xf1,
    0xff, 0xe3, 0xff, 0xc7, 0xff, 0x8f, 0xff, 0x1c,
    0xe, 0x3c, 0x3c, 0x70, 0x38, 0xf0, 0xf1, 0xc0,
    0xe3, 0xc3, 0xc7, 0x3, 0x8f, 0xf, 0x1c, 0xe,
    0x3c, 0x3c, 0x70, 0x38, 0xf0, 0xf1, 0xc0, 0xe3,
    0xc3, 0xc7, 0x3, 0x8f, 0xf, 0x1f, 0xee, 0x3c,
    0x3c, 0x7f, 0xb8, 0xf0, 0xf1, 0xc0, 0xe3, 0xc3,
    0xc7, 0x3, 0x8f, 0xf, 0x1c, 0xe, 0x3c, 0x3c,
    0x70, 0x38, 0xf0, 0xf1, 0xc0, 0xe3, 0xc3, 0xc7,
    0x3, 0x8f, 0xf, 0x1c, 0xe, 0x3c, 0x3c, 0x7f,
    0xf8, 0xf0, 0xf1, 0xff, 0xe3, 0xc3, 0xc7, 0x3,
    0x8f, 0xf, 0x1c, 0xe, 0x3c, 0x3c, 0x70, 0x0,
    0xf0, 0xf1, 0xc2, 0x3, 0xc3, 0xc7, 0x8, 0xf,
    0xf, 0x1c, 0x20, 0x3c, 0x3c, 0x70, 0x80, 0xf0,
    0xf1, 0xc3, 0x3, 0xc3, 0xc7, 0x4, 0xf, 0xf,
    0x1c, 0x18, 0x3c, 0x3c, 0x70, 0x60, 0xf0, 0xf1,
    0xc1, 0xc3, 0xc3, 0xc7, 0xf, 0x8f, 0xf, 0x1c,
    0xcf, 0xbc, 0x3c, 0x7e, 0x3c, 0xf1, 0xff, 0xf0,
    0xe3, 0xcf, 0x9f, 0x81, 0x8f, 0xd8, 0x7c, 0x6,
    0x3c, 0x1, 0xe0, 0x0, 0xf0, 0x4, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0xf0, 0x0,

    /* U+5374 "却" */
    0x1, 0xc0, 0x0, 0x0, 0x7, 0x0, 0x0, 0x0,
    0x1c, 0x3, 0xc3, 0xc0, 0x70, 0xf, 0xff, 0x1,
    0xc0, 0x3f, 0xfc, 0x7, 0x0, 0xf0, 0xf0, 0x1c,
    0x3, 0xc3, 0xc0, 0x70, 0xf, 0xf, 0x7f, 0xff,
    0x3c, 0x3d, 0xff, 0xfc, 0xf0, 0xf0, 0x1c, 0x3,
    0xc3, 0xc0, 0x70, 0xf, 0xf, 0x1, 0xc0, 0x3c,
    0x3c, 0x7, 0x0, 0xf0, 0xf0, 0x1c, 0x3, 0xc3,
    0xc0, 0x70, 0xf, 0xf, 0x1, 0xc0, 0x3c, 0x3c,
    0x7, 0x0, 0xf0, 0xff, 0xff, 0xfb, 0xc3, 0xff,
    0xff, 0xef, 0xf, 0x7, 0x80, 0x3c, 0x3c, 0x1e,
    0x0, 0xf0, 0xf0, 0x78, 0x3, 0xc3, 0xc1, 0xe4,
    0xf, 0xf, 0x7, 0x10, 0x3c, 0x3c, 0x1c, 0x40,
    0xf0, 0xf0, 0x71, 0x3, 0xc3, 0xc1, 0xc4, 0xf,
    0xf, 0x7, 0x18, 0x3c, 0x3c, 0x18, 0x60, 0xf0,
    0xf0, 0x61, 0xc3, 0xc3, 0xc3, 0x87, 0xf, 0xf,
    0xc, 0x1e, 0x3c, 0x3c, 0x30, 0x38, 0xf0, 0xf0,
    0x83, 0xf3, 0xc3, 0xc2, 0x3b, 0xcf, 0xf, 0xdf,
    0xc7, 0x3c, 0x3d, 0xfe, 0x18, 0xf0, 0xf7, 0xe0,
    0x23, 0xc7, 0x9f, 0x0, 0xcf, 0x7c, 0x60, 0x1,
    0x3f, 0x60, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0xf0, 0x0,

    /* U+5375 "卵" */
    0x0, 0x8, 0x0, 0x0, 0x78, 0x7c, 0xf0, 0xf1,
    0xe3, 0xe3, 0xc3, 0xc7, 0xbe, 0xf, 0xff, 0x1f,
    0xc0, 0x3f, 0xfc, 0x78, 0x0, 0xf0, 0xf1, 0xe1,
    0xe3, 0xc3, 0xc7, 0x87, 0x8f, 0xf, 0x1e, 0x1e,
    0x3c, 0x3c, 0x78, 0x78, 0xf0, 0xf1, 0xe1, 0xe3,
    0xc3, 0xc7, 0x87, 0x8f, 0xf, 0x1e, 0x1e, 0x3c,
    0x3c, 0x7c, 0x78, 0xf0, 0xf1, 0xe9, 0xe3, 0xf3,
    0xc7, 0xa7, 0x8f, 0xcf, 0x1e, 0xde, 0x3f, 0xbc,
    0x7b, 0x78, 0xf6, 0xf1, 0xef, 0xe3, 0xdb, 0xc7,
    0xbf, 0x8f, 0x7f, 0x1e, 0xfe, 0x3d, 0xfc, 0x79,
    0xf8, 0xf7, 0xf1, 0xe5, 0xe3, 0xdf, 0xc7, 0x87,
    0x8f, 0x6f, 0x1e, 0x1e, 0x3d, 0x3c, 0x78, 0x78,
    0xf0, 0xf1, 0xe1, 0xe3, 0xc3, 0xc7, 0x87, 0x8f,
    0xf, 0x1e, 0x3e, 0x3c, 0x3c, 0x79, 0xf8, 0xf0,
    0xf1, 0xed, 0xe3, 0xc3, 0xc7, 0xe7, 0x8f, 0xf,
    0x7f, 0x1c, 0x3c, 0x3d, 0xf8, 0x70, 0xf0, 0xf7,
    0x83, 0xc3, 0xc3, 0xd8, 0xe, 0xf, 0xf, 0x0,
    0x38, 0x3c, 0x78, 0x1, 0xc0, 0xf3, 0xc0, 0x7,
    0x3, 0xde, 0x0, 0x38, 0xf, 0x80, 0x1, 0xc0,
    0x3c, 0x0, 0x6, 0x0, 0xf0, 0x0, 0x30, 0x3,
    0xc0, 0x1, 0x80, 0xf, 0x0, 0xc, 0x0, 0x3c,
    0x0, 0x60, 0x0, 0xf0, 0x3, 0x0, 0x3, 0xc0,
    0x0,

    /* U+5377 "卷" */
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x1, 0xf0, 0x10,
    0x1, 0x0, 0xf8, 0x1c, 0x0, 0x40, 0x7c, 0xc,
    0x0, 0x38, 0x3e, 0xe, 0x0, 0x1e, 0x1f, 0xe,
    0x0, 0x7, 0x8f, 0x6, 0x0, 0x3, 0xc7, 0x87,
    0x0, 0x0, 0xe3, 0xc3, 0x0, 0x0, 0x61, 0xe3,
    0x0, 0x0, 0x10, 0xf3, 0x80, 0x7, 0xff, 0xff,
    0xff, 0xc3, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x3c,
    0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0xf,
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf0, 0x3, 0x80, 0x20, 0x0, 0x3,
    0x80, 0x18, 0x0, 0x1, 0x80, 0xe, 0x0, 0x1,
    0x80, 0x3, 0x80, 0x1, 0xe0, 0x7, 0xf0, 0x1,
    0xf0, 0x3, 0xfe, 0x0, 0xbf, 0xff, 0xff, 0xe0,
    0x9f, 0xff, 0xf7, 0xf0, 0x8e, 0x0, 0x79, 0xf0,
    0x87, 0x0, 0x3c, 0x78, 0xc3, 0x80, 0x1e, 0x1c,
    0xc1, 0xc0, 0xf, 0x2, 0xc0, 0xe0, 0x7, 0x80,
    0x0, 0x70, 0x3, 0xc0, 0x0, 0x38, 0x3, 0xc4,
    0x0, 0x1c, 0x7, 0xe2, 0x0, 0xe, 0xf, 0xc1,
    0x0, 0x7, 0x8, 0x1, 0x80, 0x3, 0x80, 0x0,
    0xc0, 0x1, 0xc0, 0x0, 0x60, 0x0, 0xe0, 0x0,
    0x38, 0x0, 0x70, 0x0, 0x1c, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x1f, 0xff, 0xff, 0x0, 0xf, 0xff,
    0xff, 0x0, 0x1, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+5378 "卸" */
    0x7, 0x80, 0x0, 0x0, 0xf, 0x0, 0x3c, 0x3c,
    0x1c, 0x0, 0x78, 0x78, 0x38, 0x0, 0xff, 0xf0,
    0xf0, 0x1, 0xff, 0xe1, 0xff, 0xfb, 0xc3, 0xc3,
    0xff, 0xf7, 0x87, 0x86, 0x78, 0xf, 0xf, 0x1c,
    0xf0, 0x1e, 0x1e, 0x31, 0xe0, 0x3c, 0x3c, 0xc3,
    0xc0, 0x78, 0x79, 0x7, 0x80, 0xf0, 0xf4, 0xf,
    0x1, 0xe1, 0xf8, 0x1e, 0x3, 0xc3, 0xc0, 0x3c,
    0x7, 0x87, 0x80, 0x78, 0xf, 0xf, 0x7f, 0xff,
    0xde, 0x1e, 0xff, 0xff, 0xbc, 0x3c, 0x3, 0xc0,
    0x78, 0x78, 0x7, 0x80, 0xf0, 0xf0, 0xf, 0x1,
    0xe1, 0xe0, 0x1e, 0x3, 0xc3, 0xcf, 0x3c, 0x7,
    0x87, 0x9e, 0x78, 0xf, 0xf, 0x3c, 0xf0, 0x1e,
    0x1e, 0x79, 0xff, 0x3c, 0x3c, 0xf3, 0xfe, 0x78,
    0x79, 0xe7, 0x80, 0xf0, 0xf3, 0xcf, 0x1, 0xe1,
    0xe7, 0x9e, 0x3, 0xc3, 0xcf, 0x3c, 0x7, 0x87,
    0x9e, 0x78, 0xf, 0xf, 0x3c, 0xf0, 0x5e, 0x1e,
    0x79, 0xe1, 0x3c, 0x3c, 0xf3, 0xcc, 0x78, 0x79,
    0xe7, 0xf0, 0xf0, 0xf3, 0xcf, 0xc1, 0xe1, 0xe7,
    0xff, 0x3, 0xc3, 0xff, 0xf8, 0x7, 0x8f, 0x3f,
    0xc0, 0xf, 0x7e, 0x7c, 0x0, 0x1f, 0x90, 0xc0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x3, 0xc0, 0x0,

    /* U+5379 "卹" */
    0x0, 0xf8, 0x0, 0x0, 0x1, 0xe0, 0x1c, 0x1c,
    0x3, 0xc0, 0x38, 0x38, 0x7, 0x80, 0x7f, 0xf0,
    0xe, 0x0, 0xff, 0xe0, 0x18, 0x1, 0xc1, 0xce,
    0x30, 0x73, 0x83, 0x9c, 0x40, 0xe7, 0x7, 0x3f,
    0xff, 0xce, 0xe, 0x7f, 0xff, 0x9c, 0x1c, 0xe6,
    0x67, 0x38, 0x39, 0xcc, 0xce, 0x70, 0x73, 0x99,
    0x9c, 0xe0, 0xe7, 0x33, 0x39, 0xc1, 0xce, 0x66,
    0x73, 0x83, 0x9c, 0xcc, 0xe7, 0x7, 0x39, 0x99,
    0xce, 0xe, 0x73, 0x33, 0x9c, 0x1c, 0xe6, 0x67,
    0x38, 0x39, 0xcc, 0xce, 0x70, 0x73, 0x99, 0x9c,
    0xe0, 0xe7, 0x33, 0x39, 0xc1, 0xce, 0x66, 0x73,
    0x83, 0x9c, 0xcc, 0xe7, 0x7, 0x39, 0x99, 0xce,
    0xe, 0x73, 0x33, 0x9c, 0x1c, 0xe6, 0x67, 0x38,
    0x39, 0xcc, 0xce, 0x70, 0x73, 0x99, 0x9c, 0xe0,
    0xe7, 0x33, 0x39, 0xc1, 0xce, 0x66, 0x73, 0x83,
    0x9c, 0xcc, 0xe7, 0x7, 0x39, 0x99, 0xce, 0xe,
    0x73, 0x33, 0xbc, 0x1c, 0xe6, 0x67, 0xb8, 0x39,
    0xcc, 0xce, 0x70, 0x73, 0x99, 0x98, 0xe0, 0xe7,
    0x33, 0xe1, 0xc1, 0xce, 0x7f, 0x3, 0x87, 0xbf,
    0xf8, 0x7, 0x1e, 0x7f, 0xc0, 0xf, 0xf0, 0xfc,
    0x0, 0x1c, 0x1, 0xc0, 0x0, 0x38, 0x0, 0x0,
    0x0, 0x70, 0x0, 0x0, 0x0, 0xe0, 0x0, 0x0,
    0x1, 0xc0, 0x0,

    /* U+537A "卺" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x30,
    0x3f, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0, 0x1c, 0x0,
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0xf0, 0x8,
    0x1, 0xe3, 0x88, 0x18, 0x1, 0xe3, 0xc8, 0x30,
    0x1, 0xe3, 0xc8, 0x60, 0x7f, 0xe3, 0xcc, 0xc0,
    0x7f, 0xe3, 0xc4, 0x80, 0x1, 0xe3, 0xc7, 0x80,
    0x1, 0xe3, 0xc7, 0x0, 0x1, 0xe3, 0xc3, 0x0,
    0x1, 0xc3, 0xc3, 0x80, 0x3, 0xc3, 0xc1, 0xe0,
    0x3, 0x83, 0xc0, 0xff, 0x7, 0x3, 0xc0, 0x7e,
    0xe, 0x3, 0xc0, 0x3e, 0xc, 0xf, 0x80, 0x1e,
    0x18, 0x1f, 0x0, 0xe, 0x60, 0x24, 0x0, 0x2,
    0x3f, 0xff, 0xff, 0xf8, 0x3f, 0xff, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0x0, 0x7, 0x80, 0xf, 0x0, 0x7, 0x80,
    0xf, 0xff, 0xff, 0x80, 0xf, 0xff, 0xff, 0x80,
    0xf, 0x0, 0x7, 0x80, 0xf, 0x0, 0x7, 0x84,
    0xf, 0x0, 0x7, 0x84, 0xf, 0x0, 0x7, 0x84,
    0xf, 0x0, 0x7, 0x84, 0xf, 0x0, 0xf, 0x4,
    0xf, 0x0, 0x3e, 0x4, 0xf, 0x0, 0xd8, 0x4,
    0xf, 0x0, 0x0, 0x4, 0xf, 0x0, 0x0, 0xe,
    0xf, 0x0, 0x0, 0xe, 0xf, 0x0, 0x0, 0xe,
    0xf, 0xff, 0xff, 0xfe, 0x7, 0xff, 0xff, 0xfe,
    0x7, 0xff, 0xff, 0xfc,

    /* U+537F "卿" */
    0x38, 0x40, 0x3, 0x8e, 0x71, 0xdc, 0x77, 0x1c,
    0xe7, 0xf8, 0xee, 0x39, 0xff, 0x7f, 0xdf, 0xf3,
    0x80, 0xff, 0xbf, 0xe7, 0x1, 0xc7, 0x71, 0xce,
    0x3, 0x8e, 0xe3, 0x9c, 0xe7, 0x1d, 0xc7, 0x39,
    0xce, 0x3b, 0x8e, 0x73, 0x9c, 0x77, 0x1c, 0xe7,
    0x38, 0xee, 0x39, 0xce, 0x71, 0xdc, 0x73, 0x9c,
    0xff, 0xb8, 0xe7, 0x39, 0xff, 0x71, 0xce, 0x73,
    0x8e, 0xe3, 0x9c, 0xe7, 0x1d, 0xc7, 0x39, 0xce,
    0x3b, 0x8e, 0x73, 0x9c, 0x77, 0x1c, 0xe7, 0x38,
    0xee, 0x39, 0xce, 0x71, 0xdc, 0x73, 0x9c, 0xe3,
    0xb8, 0xe7, 0x39, 0xc7, 0x71, 0xce, 0x73, 0xfe,
    0xe3, 0x9c, 0xe7, 0xfd, 0xc7, 0x39, 0xce, 0x3b,
    0x8e, 0x73, 0x9c, 0x7, 0x1c, 0xe7, 0x39, 0xe,
    0x39, 0xce, 0x72, 0x1c, 0x73, 0x9c, 0xe4, 0x38,
    0xe7, 0x39, 0xcc, 0x71, 0xce, 0x73, 0x98, 0xe3,
    0x9d, 0xe7, 0x39, 0xc7, 0x3f, 0xce, 0x33, 0x8f,
    0xfb, 0x1c, 0x77, 0x1d, 0xe6, 0x38, 0xfe, 0x3b,
    0x1c, 0x71, 0xfc, 0x78, 0x30, 0xe3, 0xb8, 0xc0,
    0x61, 0xdb, 0x77, 0x81, 0x83, 0xe6, 0xf0, 0x3,
    0x1f, 0x85, 0xc0, 0xc, 0x1e, 0x3, 0x80, 0x30,
    0x38, 0x7, 0x0, 0x40, 0x40, 0xe, 0x1, 0x80,
    0x0, 0x1c, 0x6, 0x0, 0x0, 0x38, 0x18, 0x0,
    0x0, 0x70, 0x0,

    /* U+5382 "厂" */
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf1,
    0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x7,
    0x80, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78,
    0x0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x1, 0xe0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0,
    0x0, 0x0, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x7, 0x80, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x1, 0xe0, 0x0, 0x0,
    0x3, 0xc0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0xf, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x3c, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0, 0x0,
    0xe0, 0x0, 0x0, 0x1, 0xc0, 0x0, 0x0, 0x3,
    0x0, 0x0, 0x0, 0xe, 0x0, 0x0, 0x0, 0x1c,
    0x0, 0x0, 0x0, 0x30, 0x0, 0x0, 0x0, 0x60,
    0x0, 0x0, 0x1, 0x80, 0x0, 0x0, 0x3, 0x0,
    0x0, 0x0, 0x4, 0x0, 0x0, 0x0, 0x10, 0x0,
    0x0, 0x0, 0x0,

    /* U+5384 "厄" */
    0x1e, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xfe,
    0x1f, 0xff, 0xff, 0xfe, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1f, 0xff, 0xe0, 0x1e, 0x1f, 0xff, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x1, 0xe0, 0x1e, 0x1e, 0x1, 0xe0,
    0x1e, 0x1e, 0x3, 0xe0, 0x1e, 0x1e, 0x7, 0xc0,
    0x1e, 0x1e, 0x1f, 0x82, 0x1e, 0x1e, 0x26, 0x2,
    0x1e, 0x1e, 0x0, 0x2, 0x1e, 0x1e, 0x0, 0x2,
    0x1e, 0x1e, 0x0, 0x2, 0x1c, 0x1e, 0x0, 0x6,
    0x1c, 0x1e, 0x0, 0x7, 0x1c, 0x1e, 0x0, 0x7,
    0x38, 0x1e, 0x0, 0x7, 0x38, 0x1e, 0x0, 0xf,
    0x30, 0x1e, 0x0, 0xf, 0x20, 0x1f, 0xff, 0xff,
    0x60, 0xf, 0xff, 0xfe, 0x40, 0x7, 0xff, 0xfc,
    0x40, 0x0, 0x0, 0x0, 0x80, 0x0, 0x0, 0x0,

    /* U+5385 "厅" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xfe, 0x1f, 0xff, 0xff, 0xfe,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0xff, 0xff, 0xff, 0x1e, 0xff, 0xff, 0xff,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1c, 0x0, 0x3c, 0x0,
    0x1c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0,
    0x38, 0x0, 0x3c, 0x0, 0x38, 0x0, 0x3c, 0x0,
    0x30, 0x0, 0x3c, 0x0, 0x60, 0x0, 0x3c, 0x0,
    0x60, 0x0, 0x78, 0x0, 0xc0, 0x1, 0xf0, 0x0,
    0x80, 0x7, 0xe0, 0x0, 0x0, 0x8, 0x80, 0x0,

    /* U+5386 "历" */
    0xf, 0x0, 0x0, 0x0, 0x7, 0xff, 0xff, 0xff,
    0xc3, 0xff, 0xff, 0xff, 0xe1, 0xe0, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0xf, 0x0,
    0x0, 0x3c, 0x7, 0x80, 0x0, 0x1e, 0x3, 0xc0,
    0x0, 0xf, 0x1, 0xe0, 0x0, 0x7, 0x80, 0xf0,
    0x0, 0x3, 0xc0, 0x78, 0x0, 0x1, 0xe0, 0x3c,
    0xf, 0x0, 0xf0, 0x1e, 0x7, 0x80, 0x78, 0xf,
    0x3, 0xc0, 0x3d, 0xff, 0xff, 0xe0, 0x1e, 0xff,
    0xff, 0xf0, 0xf, 0x1, 0xe0, 0x78, 0x7, 0x80,
    0xf0, 0x3c, 0x3, 0xc0, 0x78, 0x1e, 0x1, 0xe0,
    0x3c, 0xf, 0x0, 0xf0, 0x1e, 0x7, 0x80, 0x78,
    0xf, 0x3, 0xc0, 0x3c, 0x7, 0x81, 0xe0, 0x1e,
    0x3, 0xc0, 0xf0, 0xf, 0x1, 0xe0, 0x78, 0x7,
    0x80, 0xf0, 0x3c, 0x3, 0xc0, 0x78, 0x1e, 0x1,
    0xe0, 0x3c, 0xf, 0x0, 0xf0, 0x1e, 0x7, 0x80,
    0x78, 0xf, 0x3, 0xc0, 0x3c, 0x7, 0x81, 0xe0,
    0x1e, 0x3, 0xc0, 0xf0, 0xf, 0x1, 0xe0, 0x78,
    0x7, 0x80, 0xf0, 0x3c, 0x3, 0xc0, 0x70, 0x1e,
    0x1, 0xc0, 0x38, 0xf, 0x0, 0xe0, 0x38, 0x7,
    0x80, 0xf0, 0x1c, 0x3, 0xc0, 0x78, 0x1c, 0x1,
    0xe0, 0x38, 0xc, 0x0, 0xf0, 0x1c, 0xc, 0x0,
    0x78, 0xc, 0xc, 0x0, 0x3c, 0xc, 0x6, 0x0,
    0x3c, 0x6, 0x6, 0x0, 0x3c, 0x6, 0x6, 0x0,
    0x3c, 0x2, 0x4, 0x0, 0x60, 0x0,

    /* U+5389 "厉" */
    0xf, 0x0, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xff, 0xe1, 0xff, 0xff, 0xff,
    0xf0, 0xf0, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x7, 0xbf, 0xff,
    0xff, 0xc3, 0xdf, 0xff, 0xff, 0xe1, 0xe0, 0x78,
    0x0, 0x0, 0xf0, 0x3c, 0x0, 0x0, 0x78, 0x1e,
    0x0, 0x0, 0x3c, 0xf, 0x0, 0x0, 0x1e, 0x7,
    0x80, 0x0, 0xf, 0x3, 0xc0, 0x0, 0x7, 0x81,
    0xe0, 0x3c, 0x3, 0xc0, 0xf0, 0x1e, 0x1, 0xe0,
    0x7f, 0xff, 0x0, 0xf0, 0x3f, 0xff, 0x80, 0x78,
    0x1e, 0x3, 0xc0, 0x3c, 0xf, 0x1, 0xe0, 0x1e,
    0x7, 0x80, 0xf0, 0xf, 0x3, 0xc0, 0x78, 0x7,
    0x81, 0xe0, 0x3c, 0x3, 0xc0, 0xf0, 0x1e, 0x1,
    0xe0, 0x78, 0xf, 0x0, 0xf0, 0x3c, 0x7, 0x80,
    0x78, 0x1e, 0x3, 0xc0, 0x3c, 0xf, 0x1, 0xe0,
    0x1e, 0x7, 0x80, 0xf0, 0xe, 0x3, 0xc0, 0x78,
    0x7, 0x1, 0xe0, 0x3c, 0x3, 0x80, 0xe0, 0x1e,
    0x1, 0xc0, 0x70, 0xf, 0x0, 0xc0, 0x78, 0x7,
    0x80, 0xe0, 0x38, 0x3, 0xc0, 0x60, 0x1c, 0x1,
    0xe0, 0x30, 0x1c, 0x0, 0xf0, 0x10, 0xc, 0x0,
    0x78, 0x18, 0xe, 0x0, 0x3c, 0xc, 0x6, 0x0,
    0x3c, 0x4, 0x6, 0x0, 0x3c, 0x4, 0x6, 0x0,
    0x78, 0x2, 0x6, 0x0, 0xc8, 0x0,

    /* U+538B "压" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x7f, 0xff, 0xfc,
    0x1e, 0x7f, 0xff, 0xfc, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x80, 0x1e, 0x0, 0x3c, 0x40,
    0x1e, 0x0, 0x3c, 0x60, 0x1e, 0x0, 0x3c, 0x70,
    0x1e, 0x0, 0x3c, 0x38, 0x1e, 0x0, 0x3c, 0x3c,
    0x1e, 0x0, 0x3c, 0x1c, 0x1e, 0x0, 0x3c, 0x1c,
    0x1e, 0x0, 0x3c, 0x1c, 0x1e, 0x0, 0x3c, 0x8,
    0x1e, 0x0, 0x3c, 0x0, 0x1c, 0x0, 0x3c, 0x0,
    0x1c, 0x0, 0x3c, 0x0, 0x3c, 0x0, 0x3c, 0x0,
    0x38, 0x0, 0x3c, 0x0, 0x3b, 0xff, 0xff, 0xff,
    0x73, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0, 0x0,
    0x60, 0x0, 0x0, 0x0, 0xc0, 0x0, 0x0, 0x0,

    /* U+538C "厌" */
    0x1e, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf1,
    0xe0, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x7,
    0x80, 0x1c, 0x0, 0xf, 0x0, 0x38, 0xc0, 0x1e,
    0x0, 0x71, 0xc0, 0x3c, 0x0, 0xe1, 0xc0, 0x78,
    0x1, 0xc3, 0x80, 0xf0, 0x3, 0x83, 0x1, 0xe0,
    0x7, 0x6, 0x3, 0xc0, 0xe, 0x0, 0x7, 0x80,
    0x1c, 0x0, 0xf, 0x7f, 0xff, 0xff, 0x1e, 0xff,
    0xff, 0xfe, 0x3c, 0x1, 0xe0, 0x0, 0x78, 0x3,
    0xc0, 0x0, 0xf0, 0x7, 0x80, 0x1, 0xe0, 0xf,
    0x0, 0x3, 0xc0, 0x1e, 0x0, 0x7, 0x80, 0x3c,
    0x0, 0xf, 0x0, 0x78, 0x0, 0x1e, 0x0, 0xf0,
    0x0, 0x3c, 0x1, 0xe0, 0x0, 0x78, 0x3, 0xe0,
    0x0, 0xf0, 0x7, 0xc0, 0x1, 0xe0, 0xf, 0x80,
    0x3, 0xc0, 0x1f, 0x80, 0x7, 0x80, 0x3b, 0x0,
    0xf, 0x0, 0x73, 0x0, 0x1e, 0x0, 0xe6, 0x0,
    0x3c, 0x3, 0x8e, 0x0, 0x70, 0x7, 0xe, 0x0,
    0xe0, 0x1c, 0x1c, 0x1, 0xc0, 0x30, 0x3c, 0x3,
    0x80, 0xe0, 0x3c, 0x7, 0x1, 0x80, 0x7c, 0xc,
    0x6, 0x0, 0x7e, 0x38, 0x18, 0x0, 0xfc, 0x60,
    0x20, 0x0, 0xf8, 0xc0, 0xc0, 0x0, 0xf3, 0x3,
    0x0, 0x0, 0xc6, 0xc, 0x0, 0x0, 0xc8, 0x30,
    0x0, 0x0, 0x80,

    /* U+538D "厍" */
    0x1c, 0x0, 0x0, 0x0, 0x38, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xf1,
    0xc0, 0x0, 0x0, 0x3, 0x80, 0x7c, 0x0, 0x7,
    0x0, 0xf8, 0x0, 0xe, 0x1, 0xf0, 0x0, 0x1c,
    0x3, 0xc0, 0x0, 0x38, 0x7, 0x80, 0x0, 0x70,
    0xf, 0x0, 0x0, 0xe7, 0xff, 0xff, 0xe1, 0xcf,
    0xff, 0xff, 0xc3, 0x80, 0x78, 0x0, 0x7, 0x0,
    0xe0, 0x0, 0xe, 0x3, 0xc0, 0x0, 0x1c, 0x7,
    0x3c, 0x0, 0x38, 0xc, 0x78, 0x0, 0x70, 0x30,
    0xf0, 0x0, 0xe0, 0x61, 0xe0, 0x1, 0xc1, 0x83,
    0xc0, 0x3, 0x84, 0x7, 0x80, 0x7, 0x3f, 0xff,
    0xfc, 0xe, 0x7f, 0xff, 0xf8, 0x1c, 0x80, 0x3c,
    0x0, 0x38, 0x0, 0x78, 0x0, 0x70, 0x0, 0xf0,
    0x0, 0xe0, 0x1, 0xe0, 0x1, 0xc0, 0x3, 0xc0,
    0x3, 0x80, 0x7, 0x80, 0x7, 0x0, 0xf, 0x0,
    0xe, 0xff, 0xff, 0xff, 0x19, 0xff, 0xff, 0xfe,
    0x30, 0x0, 0x78, 0x0, 0x60, 0x0, 0xf0, 0x0,
    0xc0, 0x1, 0xe0, 0x3, 0x0, 0x3, 0xc0, 0x6,
    0x0, 0x7, 0x80, 0xc, 0x0, 0xf, 0x0, 0x10,
    0x0, 0x1e, 0x0, 0x20, 0x0, 0x3c, 0x0, 0xc0,
    0x0, 0x78, 0x1, 0x0, 0x0, 0xf0, 0x2, 0x0,
    0x1, 0xe0, 0x8, 0x0, 0x3, 0xc0, 0x10, 0x0,
    0x7, 0x80, 0x0,

    /* U+5395 "厕" */
    0x3c, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xf9, 0xe0, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0x7, 0x9c, 0xe, 0x3, 0x8f,
    0x38, 0x1c, 0x7, 0x1e, 0x70, 0x38, 0xe, 0x3c,
    0xff, 0xf0, 0x1c, 0x79, 0xff, 0xe7, 0x38, 0xf3,
    0x81, 0xce, 0x71, 0xe7, 0x3, 0x9c, 0xe3, 0xce,
    0xe7, 0x39, 0xc7, 0x9d, 0xce, 0x73, 0x8f, 0x3b,
    0x9c, 0xe7, 0x1e, 0x77, 0x39, 0xce, 0x3c, 0xee,
    0x73, 0x9c, 0x79, 0xdc, 0xe7, 0x38, 0xf3, 0xb9,
    0xce, 0x71, 0xe7, 0x73, 0x9c, 0xe3, 0xce, 0xe7,
    0x39, 0xc7, 0x9d, 0xce, 0x73, 0x8f, 0x3b, 0x9c,
    0xe7, 0x1e, 0x77, 0x39, 0xce, 0x3c, 0xee, 0x73,
    0x9c, 0x79, 0xdc, 0xe7, 0x38, 0xf3, 0xb9, 0xce,
    0x71, 0xe7, 0x73, 0x9c, 0xe3, 0xce, 0xe7, 0x39,
    0xc7, 0x9d, 0xce, 0x73, 0x8f, 0x3b, 0x9c, 0xe7,
    0x1e, 0x77, 0x39, 0xce, 0x3c, 0xee, 0x73, 0x9c,
    0x79, 0xdc, 0xe7, 0x38, 0xf0, 0x3f, 0x8e, 0x71,
    0xe0, 0x7c, 0x0, 0xe3, 0xc0, 0xd8, 0x1, 0xc7,
    0x3, 0xb8, 0x3, 0x8e, 0x6, 0x78, 0x7, 0x1c,
    0xc, 0x7c, 0xe, 0x70, 0x30, 0xf0, 0x1c, 0xe0,
    0x40, 0xc0, 0x39, 0x81, 0x0, 0x80, 0xf2, 0x6,
    0x1, 0x7, 0xc8, 0x8, 0x0, 0x3e, 0x10, 0x20,
    0x1, 0xf8, 0x0,

    /* U+5396 "厖" */
    0x1c, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1c, 0x0, 0x0, 0x0, 0x1c, 0x1c, 0x8, 0x0,
    0x1c, 0x1c, 0x6, 0x0, 0x1c, 0x1c, 0x7, 0x80,
    0x1c, 0x1c, 0x3, 0xc0, 0x1c, 0x1c, 0x1, 0x80,
    0x1c, 0x1c, 0x0, 0x80, 0x1c, 0x1c, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0xff, 0xfc,
    0x1c, 0x1c, 0x70, 0x0, 0x1c, 0x1c, 0x77, 0x80,
    0x1c, 0x1c, 0x77, 0x0, 0x1c, 0x1c, 0x77, 0x0,
    0x1c, 0x1c, 0x77, 0x0, 0x1c, 0x1c, 0x7e, 0x0,
    0x1c, 0x1c, 0x7c, 0x0, 0x1c, 0x18, 0x7c, 0xe0,
    0x1c, 0x18, 0x79, 0xe0, 0x1c, 0x38, 0x71, 0xe0,
    0x1c, 0x38, 0x73, 0xc0, 0x1c, 0x38, 0xf3, 0x80,
    0x1c, 0x3b, 0xf7, 0x80, 0x1c, 0x34, 0x77, 0x38,
    0x1c, 0x30, 0x7e, 0x78, 0x1c, 0x70, 0x7c, 0x70,
    0x1c, 0x60, 0x78, 0x70, 0x1c, 0x60, 0x70, 0xe0,
    0x1c, 0x60, 0xf1, 0xc8, 0x18, 0xc3, 0xf1, 0xc8,
    0x18, 0xc7, 0x73, 0x88, 0x19, 0x9c, 0x77, 0x8,
    0x19, 0xe0, 0x7e, 0x8, 0x11, 0x0, 0x78, 0x8,
    0x33, 0x0, 0x70, 0x8, 0x32, 0x0, 0xf0, 0xc,
    0x26, 0x7, 0xf0, 0xc, 0x24, 0x1c, 0x70, 0xc,
    0x68, 0x60, 0x7f, 0xfc, 0x58, 0x0, 0x7f, 0xfc,
    0xd0, 0x0, 0x3f, 0xf8, 0xa0, 0x0, 0x0, 0x0,

    /* U+5398 "厘" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x78, 0x0, 0x78, 0x1e, 0x7f, 0xff, 0xf8,
    0x1e, 0x7f, 0xff, 0xf8, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x78, 0x78, 0x78, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x78, 0x78, 0x78, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x78, 0x78, 0x78, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x7f, 0xff, 0xf8, 0x1e, 0x7f, 0xff, 0xf8,
    0x1e, 0x78, 0x78, 0x78, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x78, 0x78, 0x78, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x78, 0x78, 0x78, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x7f, 0xff, 0xf8, 0x1e, 0x7f, 0xff, 0xf8,
    0x1e, 0x78, 0x78, 0x78, 0x1e, 0x78, 0x78, 0x78,
    0x1e, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x78, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0x1e, 0x0, 0x78, 0x0,
    0x1e, 0x0, 0x78, 0x0, 0x1e, 0x7f, 0xff, 0xfc,
    0x1e, 0x7f, 0xff, 0xfc, 0x1c, 0x0, 0x78, 0x0,
    0x1c, 0x0, 0x78, 0x0, 0x1c, 0x0, 0x78, 0x0,
    0x18, 0x0, 0x78, 0x0, 0x38, 0x0, 0x78, 0x0,
    0x30, 0x0, 0x78, 0x0, 0x30, 0x0, 0x78, 0x0,
    0x61, 0xff, 0xff, 0xff, 0x41, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x80, 0x0, 0x0, 0x0,

    /* U+5399 "厙" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x38, 0x0,
    0x1e, 0x0, 0x38, 0x0, 0x1e, 0x0, 0x38, 0x0,
    0x1e, 0x0, 0x38, 0x0, 0x1e, 0xff, 0xff, 0xff,
    0x1e, 0xff, 0xff, 0xff, 0x1e, 0x0, 0x38, 0x0,
    0x1e, 0x0, 0x38, 0x0, 0x1e, 0x0, 0x38, 0x0,
    0x1e, 0x38, 0x38, 0x38, 0x1e, 0x3f, 0xff, 0xf8,
    0x1e, 0x3f, 0xff, 0xf8, 0x1e, 0x38, 0x38, 0x38,
    0x1e, 0x38, 0x38, 0x38, 0x1e, 0x38, 0x38, 0x38,
    0x1e, 0x38, 0x38, 0x38, 0x1e, 0x38, 0x38, 0x38,
    0x1e, 0x3f, 0xff, 0xf8, 0x1e, 0x3f, 0xff, 0xf8,
    0x1e, 0x38, 0x38, 0x38, 0x1e, 0x38, 0x38, 0x38,
    0x1e, 0x38, 0x38, 0x38, 0x1e, 0x38, 0x38, 0x38,
    0x1e, 0x3f, 0xff, 0xf8, 0x1e, 0x3f, 0xff, 0xf8,
    0x1e, 0x38, 0x38, 0x38, 0x1e, 0x38, 0x38, 0x38,
    0x1e, 0x38, 0x38, 0x38, 0x1c, 0x0, 0x38, 0x0,
    0x1c, 0x0, 0x38, 0x0, 0x1c, 0xff, 0xff, 0xff,
    0x1c, 0xff, 0xff, 0xff, 0x18, 0x0, 0x38, 0x0,
    0x38, 0x0, 0x38, 0x0, 0x38, 0x0, 0x38, 0x0,
    0x30, 0x0, 0x38, 0x0, 0x30, 0x0, 0x38, 0x0,
    0x60, 0x0, 0x38, 0x0, 0x60, 0x0, 0x38, 0x0,
    0x40, 0x0, 0x38, 0x0, 0x0, 0x0, 0x38, 0x0,

    /* U+539A "厚" */
    0x1e, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0x1f, 0xff, 0xff, 0xff, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3f, 0xff, 0xfc,
    0x1e, 0x3f, 0xff, 0xfc, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3f, 0xff, 0xbc, 0x1e, 0x3f, 0xff, 0xbc,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3f, 0xff, 0xfc,
    0x1e, 0x3f, 0xff, 0xfc, 0x1e, 0x3f, 0xff, 0xfc,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x4, 0x1e, 0x7f, 0xff, 0xfc,
    0x1e, 0x7f, 0xff, 0xfc, 0x1e, 0x0, 0x0, 0xf0,
    0x1e, 0x0, 0x7, 0x80, 0x1e, 0x0, 0x1c, 0x0,
    0x1e, 0x0, 0x30, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0xff, 0xff, 0xff,
    0x1e, 0xff, 0xff, 0xff, 0x1c, 0x0, 0x3c, 0x0,
    0x1c, 0x0, 0x3c, 0x0, 0x1c, 0x0, 0x3c, 0x0,
    0x18, 0x0, 0x3c, 0x0, 0x18, 0x0, 0x3c, 0x0,
    0x30, 0x0, 0x3c, 0x0, 0x30, 0x0, 0x3c, 0x0,
    0x20, 0x0, 0x3c, 0x0, 0x20, 0x0, 0x3c, 0x0,
    0x40, 0x0, 0x3c, 0x0, 0x40, 0x0, 0xf8, 0x0,
    0x80, 0x7, 0xf0, 0x0, 0x0, 0x18, 0xc0, 0x0,

    /* U+539D "厝" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1e, 0x7, 0x87, 0x80, 0x1e, 0x7, 0x87, 0x80,
    0x1e, 0x7, 0x87, 0x80, 0x1e, 0x7, 0x87, 0x80,
    0x1e, 0x7, 0x87, 0x80, 0x1e, 0x7, 0x87, 0x80,
    0x1e, 0x7, 0x87, 0x80, 0x1e, 0xff, 0xff, 0xfc,
    0x1e, 0xff, 0xff, 0xfc, 0x1e, 0x7, 0x87, 0x80,
    0x1e, 0x7, 0x87, 0x80, 0x1e, 0x7, 0x87, 0x80,
    0x1e, 0x7, 0x87, 0x80, 0x1e, 0x7, 0x87, 0x80,
    0x1e, 0x7, 0x87, 0x80, 0x1f, 0xff, 0xff, 0xff,
    0x1f, 0xff, 0xff, 0xff, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x78, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3f, 0xff, 0xf8, 0x1e, 0x3f, 0xff, 0xf8,
    0x1e, 0x3c, 0x0, 0x78, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3c, 0x0, 0x78, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3f, 0xff, 0x78, 0x1c, 0x3f, 0xff, 0x78,
    0x1c, 0x3c, 0x0, 0x78, 0x1c, 0x3c, 0x0, 0x78,
    0x18, 0x3c, 0x0, 0x78, 0x18, 0x3c, 0x0, 0x78,
    0x18, 0x3c, 0x0, 0x78, 0x30, 0x3c, 0x0, 0x78,
    0x30, 0x3f, 0xff, 0xf8, 0x20, 0x3f, 0xff, 0xf8,
    0x20, 0x3c, 0x0, 0x78, 0x60, 0x3c, 0x0, 0x78,
    0x40, 0x3c, 0x0, 0x78, 0x40, 0x3c, 0x0, 0x0,

    /* U+539F "原" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1e, 0x0, 0x3e, 0x0, 0x1e, 0x0, 0x3c, 0x0,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x38, 0x0,
    0x1e, 0x0, 0x30, 0x0, 0x1e, 0x3c, 0x30, 0x3c,
    0x1e, 0x3f, 0xff, 0xfc, 0x1e, 0x3f, 0xff, 0xfc,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3f, 0xff, 0xbc,
    0x1e, 0x3f, 0xff, 0xbc, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3c, 0x0, 0x3c, 0x1e, 0x3c, 0x0, 0x3c,
    0x1e, 0x3f, 0xff, 0xfc, 0x1e, 0x3f, 0xff, 0xfc,
    0x1e, 0x3c, 0x3c, 0x3c, 0x1e, 0x3c, 0x3c, 0x3c,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x1f, 0x3c, 0x80,
    0x1e, 0x1f, 0x3c, 0x80, 0x1e, 0x1e, 0x3c, 0x40,
    0x1e, 0x1e, 0x3c, 0x40, 0x1c, 0x3e, 0x3c, 0x60,
    0x1c, 0x3c, 0x3c, 0x70, 0x1c, 0x3c, 0x3c, 0x78,
    0x18, 0x38, 0x3c, 0x3c, 0x38, 0x70, 0x3c, 0x3e,
    0x30, 0x70, 0x3c, 0x3f, 0x30, 0xe0, 0x3c, 0x1f,
    0x20, 0xc0, 0x3c, 0xe, 0x61, 0x80, 0x3c, 0xe,
    0x43, 0x0, 0x78, 0x2, 0x80, 0x1, 0xf0, 0x0,
    0x0, 0x7, 0x40, 0x0,

    /* U+53A0 "厠" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x78, 0xf0, 0x1c, 0x1e, 0x78, 0xf0, 0x1c,
    0x1e, 0x78, 0xf0, 0x1c, 0x1e, 0x7f, 0xf3, 0x9c,
    0x1e, 0x7f, 0xf3, 0x9c, 0x1e, 0x78, 0xf3, 0x9c,
    0x1e, 0x78, 0xf3, 0x9c, 0x1e, 0x78, 0xf3, 0x9c,
    0x1e, 0x78, 0xf3, 0x9c, 0x1e, 0x7f, 0xf3, 0x9c,
    0x1e, 0x7f, 0xf3, 0x9c, 0x1e, 0x78, 0xf3, 0x9c,
    0x1e, 0x78, 0xf3, 0x9c, 0x1e, 0x78, 0xf3, 0x9c,
    0x1e, 0x78, 0xf3, 0x9c, 0x1e, 0x78, 0xf3, 0x9c,
    0x1e, 0x7f, 0xf3, 0x9c, 0x1e, 0x7f, 0xf3, 0x9c,
    0x1e, 0x78, 0xf3, 0x9c, 0x1e, 0x78, 0xf3, 0x9c,
    0x1e, 0x78, 0xf3, 0x9c, 0x1e, 0x78, 0xf3, 0x9c,
    0x1e, 0x78, 0xf3, 0x9c, 0x1e, 0x7f, 0xf3, 0x9c,
    0x1c, 0x7f, 0xf3, 0x9c, 0x1c, 0x78, 0xf3, 0x9c,
    0x1c, 0x78, 0xf3, 0x9c, 0x1c, 0x1, 0x3, 0x9c,
    0x3c, 0x3c, 0x83, 0x9c, 0x38, 0x3c, 0xc0, 0x1c,
    0x38, 0x38, 0xe0, 0x1c, 0x30, 0x78, 0x70, 0x1c,
    0x30, 0x70, 0x78, 0x1c, 0x30, 0x60, 0x38, 0x1c,
    0x60, 0xc0, 0x30, 0x1c, 0x61, 0x80, 0x10, 0x38,
    0x43, 0x0, 0x0, 0xf0, 0x80, 0x0, 0x3, 0xc0,

    /* U+53A2 "厢" */
    0x1e, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0x1f, 0xff, 0xff, 0xff, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1f, 0xfe, 0x1e, 0x1e, 0x1f, 0xfe,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0xff, 0xde, 0x1e, 0x1e, 0xff, 0xde, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e, 0x1f, 0xfe,
    0x1e, 0x1e, 0x1f, 0xfe, 0x1e, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1f, 0x1e, 0x1e, 0x1e, 0x3f, 0x9e, 0x1e,
    0x1e, 0x3e, 0xde, 0x1e, 0x1e, 0x3e, 0xfe, 0x1e,
    0x1e, 0x3e, 0xfe, 0x1e, 0x1e, 0x7e, 0x5e, 0x1e,
    0x1e, 0x7e, 0x5e, 0x1e, 0x1e, 0x7e, 0x1f, 0xfe,
    0x1e, 0xde, 0x1f, 0xfe, 0x1e, 0xde, 0x1e, 0x1e,
    0x1e, 0x9e, 0x1e, 0x1e, 0x1f, 0x9e, 0x1e, 0x1e,
    0x1f, 0x1e, 0x1e, 0x1e, 0x1f, 0x1e, 0x1e, 0x1e,
    0x1e, 0x1e, 0x1e, 0x1e, 0x1c, 0x1e, 0x1e, 0x1e,
    0x18, 0x1e, 0x1e, 0x1e, 0x38, 0x1e, 0x1f, 0xfe,
    0x38, 0x1e, 0x1e, 0x1e, 0x30, 0x1e, 0x1e, 0x1e,
    0x20, 0x1e, 0x1e, 0x1e, 0x60, 0x1e, 0x1e, 0x1e,
    0x40, 0x1e, 0x1e, 0x1e, 0xc0, 0x1e, 0x1e, 0x0,

    /* U+53A3 "厣" */
    0x3c, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xfc,
    0xff, 0xff, 0xff, 0xf9, 0xe0, 0x0, 0x0, 0x3,
    0xc0, 0x1f, 0x40, 0x7, 0x80, 0x3e, 0x60, 0xf,
    0x0, 0x7c, 0xf0, 0x1e, 0x0, 0xf8, 0xe0, 0x3c,
    0x1, 0xf1, 0x80, 0x7b, 0xff, 0xff, 0xf8, 0xf7,
    0xff, 0xff, 0xf1, 0xe0, 0xf, 0x40, 0x3, 0xc0,
    0x3c, 0x80, 0x7, 0x80, 0x71, 0x80, 0xf, 0x1,
    0xe1, 0x80, 0x1e, 0x3, 0x83, 0xc0, 0x3c, 0xe,
    0x3, 0xfc, 0x78, 0x30, 0x7, 0xf8, 0xf0, 0xc0,
    0x7, 0xf1, 0xe3, 0x0, 0x7, 0xe3, 0xdc, 0x0,
    0x7, 0xc7, 0x8e, 0x0, 0x1f, 0x8f, 0x1f, 0xff,
    0xf8, 0x1e, 0x3f, 0xff, 0xf0, 0x3c, 0x70, 0xf0,
    0xe0, 0x78, 0xe1, 0xe1, 0xc0, 0xf1, 0xc3, 0xc3,
    0x81, 0xe3, 0x87, 0x87, 0x3, 0xc7, 0xff, 0xfe,
    0x7, 0x8f, 0xff, 0xfc, 0xf, 0x1c, 0x3c, 0x38,
    0x1e, 0x38, 0x78, 0x70, 0x3c, 0x70, 0xf0, 0xe0,
    0x78, 0xe1, 0xe1, 0xc0, 0xf1, 0xff, 0xff, 0x81,
    0xc3, 0x87, 0x87, 0x3, 0x87, 0xf, 0xe, 0x7,
    0xe, 0x1e, 0x1c, 0xc, 0x0, 0x3c, 0x0, 0x18,
    0x0, 0x78, 0x0, 0x30, 0x0, 0xf0, 0x0, 0xc0,
    0x1, 0xe0, 0x1, 0x80, 0x3, 0xc0, 0x2, 0x0,
    0x7, 0x80, 0xc, 0x0, 0xf, 0x0, 0x10, 0x0,
    0x1e, 0x0, 0x0,

    /* U+53A5 "厥" */
    0x1e, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0x1f, 0xff, 0xff, 0xff, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x20, 0x21, 0xe0,
    0x1e, 0x30, 0x61, 0xe0, 0x1e, 0x38, 0x61, 0xe0,
    0x1e, 0x3c, 0x41, 0xe0, 0x1e, 0x18, 0xc1, 0xc0,
    0x1e, 0x18, 0xc1, 0xc0, 0x1e, 0x18, 0x81, 0xcf,
    0x1e, 0xff, 0xfd, 0xcf, 0x1e, 0xff, 0xfd, 0xff,
    0x1e, 0x7, 0x1, 0xff, 0x1e, 0x7, 0x3, 0x8f,
    0x1e, 0x7, 0x3, 0x8f, 0x1e, 0xe7, 0x3b, 0xf,
    0x1e, 0xe7, 0x3b, 0xef, 0x1e, 0xe7, 0x3a, 0xe8,
    0x1e, 0xe7, 0x3e, 0xe0, 0x1e, 0xe7, 0x3c, 0xe0,
    0x1e, 0xe7, 0x3c, 0xe0, 0x1e, 0xe7, 0x38, 0xe0,
    0x1e, 0xe7, 0x38, 0xe0, 0x1e, 0xe7, 0x38, 0xe0,
    0x1e, 0xe7, 0x38, 0xe0, 0x1e, 0xe7, 0x38, 0xe0,
    0x1e, 0xe7, 0x38, 0xe0, 0x1e, 0xff, 0xf8, 0xe0,
    0x1e, 0xff, 0xf9, 0xe0, 0x1e, 0xe7, 0x39, 0xe0,
    0x1e, 0xe7, 0x39, 0xe0, 0x1e, 0x7, 0x1, 0xe0,
    0x1e, 0x7, 0x1, 0xa0, 0x1e, 0x6, 0x3, 0x90,
    0x1e, 0xe, 0x3, 0x18, 0x1c, 0xc, 0x7, 0x1c,
    0x1c, 0xc, 0x6, 0x1e, 0x18, 0x18, 0xc, 0xf,
    0x38, 0x10, 0x8, 0xf, 0x30, 0x30, 0x18, 0xf,
    0x30, 0x60, 0x30, 0x7, 0x60, 0x40, 0x60, 0x7,
    0x60, 0x80, 0xc0, 0x2, 0x41, 0x1, 0x80, 0x2,

    /* U+53A6 "厦" */
    0x1e, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0x1f, 0xff, 0xff, 0xff, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1e, 0xff, 0xff, 0xfe, 0x1e, 0xff, 0xff, 0xfe,
    0x1e, 0x0, 0x3c, 0x0, 0x1e, 0x0, 0x38, 0x0,
    0x1e, 0x3c, 0x30, 0x78, 0x1e, 0x3f, 0xff, 0xf8,
    0x1e, 0x3f, 0xff, 0xf8, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3c, 0x0, 0x78, 0x1e, 0x3f, 0xff, 0x78,
    0x1e, 0x3f, 0xff, 0x78, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3c, 0x0, 0x78, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3f, 0xff, 0x78, 0x1e, 0x3f, 0xff, 0x78,
    0x1e, 0x3c, 0x0, 0x78, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3f, 0xff, 0xf8, 0x1e, 0x3c, 0x0, 0x78,
    0x1e, 0x3c, 0x0, 0x78, 0x1e, 0x7, 0xc0, 0x0,
    0x1e, 0x7, 0x80, 0x0, 0x1e, 0x7, 0x80, 0x78,
    0x1e, 0xf, 0xff, 0xf8, 0x1e, 0xf, 0xff, 0xf0,
    0x1e, 0xf, 0x0, 0xf0, 0x1e, 0x1f, 0x81, 0xe0,
    0x1e, 0x1c, 0x81, 0xc0, 0x1c, 0x38, 0xc3, 0xc0,
    0x1c, 0x30, 0x77, 0x80, 0x1c, 0x60, 0x3f, 0x0,
    0x18, 0x40, 0x3e, 0x0, 0x38, 0x80, 0x7f, 0xc0,
    0x31, 0x0, 0xe7, 0xff, 0x30, 0x3, 0x83, 0xfe,
    0x60, 0xe, 0x1, 0xfe, 0x60, 0x18, 0x0, 0x7e,
    0xc0, 0x60, 0x0, 0x1e, 0x81, 0x80, 0x0, 0x6,

    /* U+53A8 "厨" */
    0x1e, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x87, 0xff, 0xff, 0xff, 0xc3, 0xc0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x1,
    0xe0, 0x78, 0x0, 0x0, 0xf0, 0x3c, 0xff, 0xf0,
    0x78, 0x1e, 0x7f, 0xf8, 0x3c, 0xf, 0x0, 0x0,
    0x1e, 0x7, 0x80, 0x0, 0xf, 0x3, 0xc0, 0x0,
    0x7, 0x81, 0xe7, 0x87, 0x83, 0xc0, 0xf3, 0xc3,
    0xdf, 0xfc, 0x79, 0xff, 0xef, 0xfe, 0x3c, 0xff,
    0xf0, 0x78, 0x1e, 0x78, 0x78, 0x3c, 0xf, 0x3c,
    0x3c, 0x1e, 0x7, 0x9e, 0x1e, 0xf, 0x3, 0xcf,
    0xf, 0x47, 0x81, 0xe7, 0x87, 0xa3, 0xc0, 0xf3,
    0xc3, 0xd1, 0xe0, 0x79, 0xe1, 0xec, 0xf0, 0x3c,
    0xff, 0xf6, 0x78, 0x1e, 0x7f, 0xfb, 0xbc, 0xf,
    0x3c, 0x3d, 0xde, 0x7, 0x9e, 0x1e, 0xef, 0x3,
    0xc0, 0x0, 0x77, 0x81, 0xe0, 0x2, 0x13, 0xc0,
    0xf0, 0x83, 0x9, 0xe0, 0x78, 0x41, 0x80, 0xf0,
    0x3c, 0x30, 0xc0, 0x78, 0x1e, 0x18, 0x60, 0x3c,
    0xf, 0xe, 0x30, 0x1e, 0x7, 0x87, 0x10, 0xf,
    0x3, 0x83, 0x88, 0x87, 0x81, 0xc1, 0xc4, 0xc3,
    0xc0, 0xe0, 0xc7, 0xc1, 0xe0, 0x60, 0x23, 0xc0,
    0xf0, 0x71, 0xff, 0xc0, 0x78, 0x30, 0xff, 0x80,
    0x3c, 0x18, 0x7f, 0x0, 0x1e, 0x8, 0x3e, 0x0,
    0x1e, 0xc, 0x18, 0x0, 0x1f, 0x4, 0x0, 0x0,
    0x7e, 0x2, 0x0, 0x0, 0x0, 0x0,

    /* U+53A9 "厩" */
    0x1e, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0xc7, 0xff, 0xff, 0xff, 0xe3, 0xc0, 0x0, 0x0,
    0x1, 0xe0, 0x0, 0x0, 0x0, 0xf3, 0x8e, 0x0,
    0x0, 0x79, 0xc7, 0x3f, 0xfc, 0x3c, 0xff, 0x9f,
    0xfe, 0x1e, 0x7f, 0xc0, 0x78, 0xf, 0x38, 0xe0,
    0x3c, 0x7, 0x9c, 0x70, 0x1e, 0x3, 0xce, 0x38,
    0xef, 0x1, 0xe7, 0x1c, 0x77, 0x80, 0xf3, 0x8e,
    0x3b, 0xc0, 0x79, 0xc7, 0x1d, 0xe0, 0x3c, 0xff,
    0x8e, 0xf0, 0x1e, 0x7f, 0xc6, 0x78, 0xf, 0x38,
    0xe3, 0x3c, 0x7, 0x9c, 0x71, 0x9e, 0x3, 0xce,
    0x39, 0x8e, 0x1, 0xe7, 0x1c, 0x87, 0x0, 0xf3,
    0x8e, 0x7f, 0xfc, 0x79, 0xc7, 0x3f, 0xfe, 0x3c,
    0xe3, 0x80, 0xe0, 0x1e, 0x7f, 0xc0, 0xf0, 0xf,
    0x3f, 0xe0, 0x78, 0x7, 0x9c, 0x70, 0x3c, 0x3,
    0xce, 0x0, 0x1e, 0x1, 0xe7, 0x0, 0x1f, 0x0,
    0xf3, 0x90, 0xf, 0x80, 0x79, 0xcc, 0x7, 0xc0,
    0x3c, 0xe7, 0x7, 0xe0, 0x1e, 0x71, 0xc3, 0xf0,
    0xf, 0x38, 0xf1, 0xb8, 0x87, 0x9c, 0x3d, 0xdc,
    0x43, 0xce, 0x1c, 0xce, 0x21, 0xe7, 0x3e, 0x67,
    0x10, 0xe3, 0xb3, 0x63, 0x88, 0x71, 0xf1, 0xb1,
    0xc4, 0x38, 0xf0, 0x70, 0xe2, 0x19, 0xf0, 0x30,
    0x71, 0x9c, 0xf0, 0x38, 0x39, 0xcc, 0x70, 0x18,
    0x1f, 0xe4, 0x20, 0x18, 0xf, 0xf6, 0x0, 0x18,
    0x3, 0xf2, 0x0, 0xc, 0x0, 0x0,

    /* U+53AD "厭" */
    0x3c, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xfe,
    0x3c, 0x0, 0x0, 0x0, 0x3c, 0xe1, 0xc1, 0xc0,
    0x3c, 0xe1, 0xc1, 0xc0, 0x3c, 0xff, 0xc1, 0xc0,
    0x3c, 0xe1, 0xc1, 0xe0, 0x3c, 0xe1, 0xc1, 0xf0,
    0x3c, 0xe1, 0xc1, 0xd8, 0x3c, 0xe1, 0xc1, 0xde,
    0x3c, 0xff, 0xc1, 0xcc, 0x3c, 0xe1, 0xc1, 0xc4,
    0x3c, 0xe1, 0xc1, 0xc4, 0x3c, 0xe1, 0xc1, 0xc0,
    0x3c, 0xe1, 0xc1, 0xc0, 0x3c, 0xff, 0xcf, 0xfe,
    0x3c, 0xe1, 0xcf, 0xfe, 0x3c, 0xe1, 0xc1, 0xc0,
    0x3c, 0x0, 0x1, 0xc0, 0x3d, 0xc0, 0x1, 0xc0,
    0x3d, 0xc1, 0xc1, 0xc0, 0x3d, 0xff, 0xc1, 0xc0,
    0x3d, 0xff, 0xc1, 0xe0, 0x3d, 0xc1, 0xc1, 0xe0,
    0x3d, 0xc1, 0xc1, 0xa0, 0x3d, 0xc1, 0xc1, 0xa0,
    0x3d, 0xfd, 0xc1, 0xa0, 0x3d, 0xfd, 0xc3, 0xa0,
    0x3d, 0xc1, 0xc3, 0xb0, 0x3d, 0xc1, 0xc3, 0xb0,
    0x3d, 0xc1, 0xc3, 0x30, 0x3d, 0xfd, 0xc3, 0x38,
    0x39, 0xfd, 0xc3, 0x18, 0x39, 0xc1, 0xc3, 0x1c,
    0x39, 0xc1, 0xc6, 0x1e, 0x39, 0xc1, 0xc6, 0x1f,
    0x31, 0xc1, 0xc4, 0xe, 0x71, 0xc1, 0xcc, 0xe,
    0x71, 0xc1, 0xc8, 0xe, 0x61, 0xc1, 0xd8, 0x6,
    0x61, 0xc3, 0x90, 0x6, 0x41, 0xc7, 0x30, 0x6,
    0xc1, 0xc8, 0x20, 0x2, 0x80, 0x0, 0x40, 0x0,

    /* U+53AE "厮" */
    0x1e, 0x0, 0x0, 0x0, 0xf, 0xff, 0xff, 0xff,
    0x87, 0xff, 0xff, 0xff, 0xc3, 0xc0, 0x0, 0x0,
    0x1, 0xe7, 0x8e, 0x0, 0x60, 0xf3, 0xc7, 0x1c,
    0x78, 0x79, 0xe3, 0x8e, 0xfc, 0x3c, 0xf1, 0xc7,
    0x80, 0x1e, 0x78, 0xe3, 0x80, 0xf, 0x7f, 0xfd,
    0xc0, 0x7, 0xbf, 0xfe, 0xe0, 0x3, 0xcf, 0x1c,
    0x70, 0x1, 0xe7, 0x8e, 0x38, 0x0, 0xf3, 0xc7,
    0x1c, 0x0, 0x79, 0xe3, 0x8e, 0x0, 0x3c, 0xfd,
    0xc7, 0xff, 0x1e, 0x7e, 0xe3, 0xff, 0x8f, 0x3c,
    0x71, 0xce, 0x7, 0x9e, 0x38, 0xe7, 0x3, 0xcf,
    0x1c, 0x73, 0x81, 0xe7, 0x8e, 0x39, 0xc0, 0xf3,
    0xc7, 0x1c, 0xe0, 0x79, 0xfb, 0x8e, 0x70, 0x3c,
    0xfd, 0xc7, 0x38, 0x1e, 0x78, 0xe3, 0x9c, 0xf,
    0x3c, 0x71, 0xce, 0x7, 0x9e, 0x38, 0xe7, 0x3,
    0xcf, 0x1c, 0x73, 0x81, 0xe7, 0x8e, 0x39, 0xc0,
    0xff, 0xff, 0xfc, 0xe0, 0x7f, 0xff, 0xfe, 0x70,
    0x3c, 0x0, 0x7, 0x38, 0x1e, 0x0, 0x3, 0x9c,
    0xe, 0x1e, 0x81, 0xce, 0x7, 0xf, 0x20, 0xe7,
    0x3, 0x87, 0x10, 0xe3, 0x81, 0xc3, 0x8c, 0x71,
    0xc0, 0xc3, 0xc7, 0x38, 0xe0, 0x61, 0xe3, 0xd8,
    0x70, 0x60, 0xe0, 0xec, 0x38, 0x30, 0x70, 0x76,
    0x1c, 0x18, 0x30, 0x36, 0xe, 0x8, 0x38, 0xa,
    0x7, 0xc, 0x18, 0x3, 0x3, 0x84, 0x18, 0x1,
    0x1, 0xc2, 0xc, 0x1, 0x80, 0xe0,

    /* U+53B2 "厲" */
    0x3c, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xf9, 0xff, 0xff, 0xff, 0xf3,
    0xc0, 0x0, 0x0, 0x7, 0x80, 0xf0, 0xf0, 0xf,
    0x1, 0xe1, 0xe0, 0x1e, 0x3, 0xc3, 0xc0, 0x3d,
    0xff, 0xff, 0xfe, 0x7b, 0xff, 0xff, 0xfc, 0xf0,
    0x1e, 0x1e, 0x1, 0xe0, 0x3c, 0x3c, 0x3, 0xc7,
    0x80, 0xf, 0x7, 0x8f, 0xff, 0xfe, 0xf, 0x1f,
    0xff, 0xfc, 0x1e, 0x3c, 0x38, 0x78, 0x3c, 0x78,
    0x70, 0xf0, 0x78, 0xf0, 0xe1, 0xe0, 0xf1, 0xff,
    0xff, 0xc1, 0xe3, 0xff, 0xff, 0x83, 0xc7, 0x87,
    0xf, 0x7, 0x8f, 0xe, 0x1e, 0xf, 0x1e, 0x1c,
    0x3c, 0x1e, 0x3c, 0x38, 0x78, 0x3c, 0x7f, 0xff,
    0xf0, 0x78, 0xf0, 0xe1, 0xe0, 0xf1, 0xe1, 0xc3,
    0xc1, 0xe3, 0x83, 0x81, 0x83, 0xcf, 0x7, 0x3,
    0xc7, 0x9f, 0xff, 0xff, 0x8f, 0x3f, 0xff, 0xff,
    0x1e, 0x78, 0x38, 0x1e, 0x3c, 0xf0, 0x70, 0x3c,
    0x79, 0xe0, 0xe4, 0x78, 0xe3, 0xc1, 0xc8, 0xf1,
    0xc7, 0x83, 0x99, 0xe3, 0x8f, 0x7, 0xfb, 0xc7,
    0x1e, 0x8f, 0x7f, 0x9c, 0x3d, 0xfc, 0x6f, 0x38,
    0x7b, 0xe0, 0xde, 0x70, 0xf7, 0x0, 0xbc, 0xc1,
    0xe0, 0x0, 0x79, 0x83, 0xc0, 0x0, 0xf6, 0x7,
    0x80, 0x1, 0xcc, 0xf, 0x0, 0xf, 0x10, 0x1e,
    0x0, 0x78, 0x0,

    /* U+53B4 "厴" */
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0x1f, 0xff, 0xff, 0xff,
    0x1e, 0x0, 0x0, 0x0, 0x1e, 0x70, 0x71, 0xe0,
    0x1e, 0x7f, 0xf1, 0xe0, 0x1e, 0x70, 0x71, 0xf8,
    0x1e, 0x70, 0x71, 0xee, 0x1e, 0x7f, 0x71, 0xee,
    0x1e, 0x70, 0x71, 0xe6, 0x1e, 0x7f, 0xf1, 0xe0,
    0x1e, 0x7f, 0xf7, 0xfe, 0x1e, 0x7f, 0xf7, 0xfe,
    0x1e, 0xff, 0xf1, 0xe0, 0x1e, 0xff, 0xf1, 0xe0,
    0x1e, 0xff, 0xf1, 0xe0, 0x1e, 0xe0, 0x71, 0xd0,
    0x1e, 0xff, 0x71, 0xd0, 0x1e, 0xe0, 0x71, 0xd8,
    0x1e, 0xe0, 0x73, 0x9c, 0x1e, 0xff, 0x73, 0x9e,
    0x1e, 0xe0, 0x73, 0x1e, 0x1e, 0xe0, 0x72, 0xe,
    0x1e, 0xe1, 0xe6, 0xe, 0x1e, 0x2, 0x84, 0x6,
    0x1e, 0x0, 0x8, 0x4, 0x1e, 0x38, 0x0, 0x1c,
    0x1e, 0x3f, 0xff, 0xfc, 0x1e, 0x3f, 0xff, 0xfc,
    0x1e, 0x38, 0x3c, 0x1c, 0x1e, 0x38, 0x3c, 0x1c,
    0x1c, 0x38, 0x3c, 0x1c, 0x1c, 0x3f, 0xff, 0xfc,
    0x1c, 0x38, 0x3c, 0x1c, 0x3c, 0x38, 0x3c, 0x1c,
    0x3c, 0x38, 0x3c, 0x1c, 0x3c, 0x3f, 0xff, 0xfc,
    0x38, 0x3f, 0xff, 0xfc, 0x38, 0x38, 0x3c, 0x1c,
    0x38, 0x38, 0x3c, 0x1c, 0x30, 0x0, 0x3c, 0x0,
    0x70, 0x0, 0x3c, 0x0, 0x60, 0x0, 0x3c, 0x0,
    0x40, 0x0, 0x3c, 0x0, 0xc0, 0x0, 0x3c, 0x0,

    /* U+53B6 "厶" */
    0x0, 0x3c, 0x0, 0x0, 0xf, 0x0, 0x0, 0x3,
    0xc0, 0x0, 0x0, 0xf0, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x3, 0xc0, 0x0, 0x0,
    0xf0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0xf, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0x38, 0x0, 0x0, 0xe, 0x0, 0x0, 0x3, 0x88,
    0x0, 0x1, 0xe2, 0x0, 0x0, 0x78, 0x80, 0x0,
    0x1e, 0x20, 0x0, 0x7, 0xc, 0x0, 0x1, 0xc3,
    0x0, 0x0, 0x70, 0xc0, 0x0, 0x1c, 0x30, 0x0,
    0xe, 0x6, 0x0, 0x3, 0x81, 0x80, 0x0, 0xe0,
    0x60, 0x0, 0x30, 0x1c, 0x0, 0x1c, 0x7, 0x0,
    0x6, 0x1, 0xe0, 0x1, 0x80, 0x78, 0x0, 0xc0,
    0xf, 0x0, 0x30, 0x3, 0xc0, 0x8, 0x0, 0xf8,
    0x6, 0x0, 0x3e, 0x1, 0x0, 0x7, 0xc0, 0xc0,
    0xf, 0xf8, 0x20, 0x3e, 0x3f, 0x18, 0xfe, 0xf,
    0xbf, 0xfe, 0x3, 0xe7, 0xfe, 0x0, 0x79, 0xfc,
    0x0, 0xc, 0x70, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x20,

    /* U+53BB "去" */
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x1f, 0xff, 0xff, 0xf8, 0x1f, 0xff, 0xff, 0xf8,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf, 0x8, 0x0,
    0x0, 0x1e, 0x8, 0x0, 0x0, 0x1e, 0x8, 0x0,
    0x0, 0x1e, 0xc, 0x0, 0x0, 0x1c, 0xc, 0x0,
    0x0, 0x1c, 0xe, 0x0, 0x0, 0x38, 0xe, 0x0,
    0x0, 0x38, 0xf, 0x0, 0x0, 0x30, 0x7, 0x0,
    0x0, 0x60, 0x7, 0x80, 0x0, 0x40, 0xf, 0xc0,
    0x0, 0xc0, 0x3b, 0xe0, 0x1, 0x0, 0xf3, 0xf0,
    0x2, 0x7, 0xe1, 0xfc, 0x3c, 0x7f, 0x80, 0xf8,
    0x3f, 0xfe, 0x0, 0x78, 0x1f, 0xf8, 0x0, 0x38,
    0x1f, 0xc0, 0x0, 0x18, 0x3c, 0x0, 0x0, 0x8,

    /* U+53BF "县" */
    0x3, 0x80, 0x1, 0xe0, 0x1, 0xc0, 0x0, 0xf0,
    0x0, 0xff, 0xff, 0xf8, 0x0, 0x7f, 0xff, 0xfc,
    0x0, 0x38, 0x0, 0x1e, 0x0, 0x1c, 0x0, 0xf,
    0x0, 0xe, 0x0, 0x7, 0x80, 0x7, 0x0, 0x3,
    0xc0, 0x3, 0x80, 0x1, 0xe0, 0x1, 0xc0, 0x0,
    0xf0, 0x0, 0xff, 0xff, 0x78, 0x0, 0x7f, 0xff,
    0xbc, 0x0, 0x38, 0x0, 0x1e, 0x0, 0x1c, 0x0,
    0xf, 0x0, 0xe, 0x0, 0x7, 0x80, 0x7, 0x0,
    0x3, 0xc0, 0x3, 0x80, 0x1, 0xe0, 0x1, 0xc0,
    0x0, 0xf0, 0x0, 0xff, 0xff, 0x78, 0x0, 0x7f,
    0xff, 0xbc, 0x0, 0x38, 0x0, 0x1e, 0x0, 0x1c,
    0x0, 0xf, 0x0, 0xe, 0x0, 0x7, 0x80, 0x7,
    0x0, 0x3, 0xc0, 0x3, 0x80, 0x1, 0xe0, 0x1,
    0xc0, 0x0, 0xf0, 0x0, 0xe0, 0x0, 0x78, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0x1, 0xf0, 0x0, 0x0, 0x0, 0xf8, 0x0, 0x0,
    0x0, 0x7c, 0x10, 0x0, 0x0, 0x3c, 0x4, 0x0,
    0x0, 0x1e, 0x2, 0x0, 0x0, 0x1e, 0x1, 0x80,
    0x0, 0xf, 0x0, 0xc0, 0x0, 0xf, 0x0, 0x70,
    0x0, 0x7, 0x0, 0x3c, 0x0, 0x7, 0x0, 0x1f,
    0x80, 0x3, 0x0, 0x77, 0xf0, 0x42, 0x3, 0xe1,
    0xfc, 0x1f, 0xff, 0xc0, 0xfe, 0xf, 0xff, 0x80,
    0x3f, 0x7, 0xff, 0x0, 0xf, 0x83, 0xf8, 0x0,
    0x3, 0xc3, 0x0, 0x0, 0x0, 0x60,

    /* U+53C1 "叁" */
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x8, 0x0,
    0x0, 0x1e, 0x8, 0x0, 0x0, 0x1e, 0x4, 0x0,
    0x0, 0x3c, 0x4, 0x0, 0x0, 0x38, 0x6, 0x0,
    0x0, 0x70, 0x7, 0x0, 0x0, 0xe0, 0x3, 0xc0,
    0x1, 0x80, 0xf, 0xe0, 0x2, 0x1f, 0xf1, 0xf8,
    0x1f, 0xff, 0xc1, 0xf0, 0x1f, 0xfe, 0x0, 0xf0,
    0x1f, 0xef, 0x80, 0x70, 0x1c, 0xf, 0x80, 0x30,
    0x0, 0xf, 0x0, 0x10, 0x0, 0x1f, 0x0, 0x0,
    0x0, 0x1f, 0x0, 0x0, 0xff, 0xff, 0xff, 0xfe,
    0xff, 0xff, 0xff, 0xfe, 0x0, 0x3c, 0x10, 0x0,
    0x0, 0x38, 0x8, 0x0, 0x0, 0x78, 0xc, 0x0,
    0x0, 0xf0, 0x6, 0x0, 0x0, 0xe0, 0x7, 0x0,
    0x1, 0xc0, 0x7, 0x80, 0x1, 0x80, 0x3, 0xc0,
    0x3, 0xff, 0xff, 0xf0, 0x7, 0xff, 0xff, 0xfc,
    0xe, 0x0, 0x0, 0xff, 0xc, 0x0, 0x0, 0x7e,
    0x18, 0x0, 0x0, 0x3e, 0x30, 0x0, 0x0, 0x1e,
    0x60, 0x0, 0x0, 0x6, 0x80, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0x80, 0x3, 0xff, 0xff, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xfc,
    0x7f, 0xff, 0xff, 0xfc,

    /* U+53C2 "参" */
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x1f, 0x4, 0x0,
    0x0, 0x1e, 0x4, 0x0, 0x0, 0x3c, 0x6, 0x0,
    0x0, 0x38, 0x7, 0x0, 0x0, 0x70, 0x1f, 0xc0,
    0x0, 0xc0, 0xf3, 0xe0, 0x1f, 0xff, 0x81, 0xf8,
    0x1f, 0xfc, 0x0, 0xf0, 0x1f, 0xe0, 0x0, 0x70,
    0x1c, 0x1f, 0x0, 0x30, 0x0, 0x1f, 0x0, 0x10,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x7c, 0x8, 0x0, 0x0, 0x78, 0x8, 0x0,
    0x0, 0x70, 0xc, 0x0, 0x0, 0xf0, 0x6, 0x0,
    0x0, 0xe3, 0xc6, 0x0, 0x1, 0xc7, 0xc7, 0x0,
    0x3, 0x87, 0x83, 0xc0, 0x3, 0x7, 0x83, 0xe0,
    0x6, 0xf, 0x1, 0xf8, 0xc, 0x1e, 0x0, 0xff,
    0x8, 0x1c, 0x7c, 0x7f, 0x10, 0x38, 0x78, 0x3f,
    0x20, 0x70, 0xf8, 0x1f, 0x40, 0x60, 0xf0, 0xf,
    0x80, 0xc1, 0xe0, 0x3, 0x1, 0x3, 0xc3, 0xc0,
    0x2, 0x3, 0x87, 0xc0, 0xc, 0x7, 0x7, 0xc0,
    0x0, 0xe, 0xf, 0x80, 0x0, 0x18, 0x1f, 0x0,
    0x0, 0x30, 0x3e, 0x0, 0x0, 0xc0, 0x7c, 0x0,
    0x1, 0x80, 0xf8, 0x0, 0x6, 0x1, 0xf0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0xf, 0x0, 0x0,
    0x0, 0x1c, 0x0, 0x0, 0x0, 0x70, 0x0, 0x0,
    0x1, 0xc0, 0x0, 0x0, 0x6, 0x0, 0x0, 0x0,

    /* U+53C3 "參" */
    0x0, 0x1f, 0x0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x0, 0x3e, 0x10, 0x0, 0x0, 0x7c, 0x18, 0x0,
    0x0, 0x78, 0x1c, 0x0, 0x0, 0xf0, 0xe, 0x0,
    0x1, 0xc0, 0xf, 0x80, 0x7, 0x0, 0x37, 0xf0,
    0x3f, 0xf, 0xe7, 0xe0, 0x1f, 0xff, 0x83, 0xe0,
    0x1f, 0xfc, 0x1, 0xe0, 0x1f, 0xc0, 0x0, 0x60,
    0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x1f, 0x0,
    0xf, 0x0, 0x1f, 0x0, 0xf, 0xf, 0x9e, 0x80,
    0x1e, 0xf, 0x1c, 0xc0, 0x1c, 0x8f, 0x38, 0x60,
    0x18, 0xdf, 0x30, 0xf8, 0x23, 0xfe, 0xe3, 0xf8,
    0x7e, 0x7c, 0xfe, 0x38, 0x78, 0x7c, 0x70, 0x38,
    0x70, 0x78, 0x70, 0x18, 0x0, 0x70, 0x38, 0x0,
    0x0, 0xe0, 0x1e, 0x0, 0x1, 0xcf, 0x8f, 0x80,
    0x3, 0xf, 0x87, 0xf8, 0x6, 0x1f, 0x3, 0xfe,
    0xc, 0x1e, 0x1, 0xfe, 0x30, 0x3c, 0x0, 0x7c,
    0x60, 0x39, 0xf8, 0x3c, 0x80, 0x71, 0xf0, 0x4,
    0x0, 0xc1, 0xe0, 0x0, 0x1, 0x83, 0xe7, 0xe0,
    0x6, 0x7, 0x87, 0xc0, 0xc, 0xf, 0xf, 0xc0,
    0x0, 0x1c, 0x1f, 0x80, 0x0, 0x38, 0x1f, 0x0,
    0x0, 0xe0, 0x3e, 0x0, 0x1, 0x80, 0xf8, 0x0,
    0x6, 0x1, 0xf0, 0x0, 0x0, 0x3, 0xc0, 0x0,
    0x0, 0xf, 0x0, 0x0, 0x0, 0x3c, 0x0, 0x0,
    0x0, 0xf0, 0x0, 0x0, 0x3, 0x80, 0x0, 0x0,
    0xe, 0x0, 0x0, 0x0,

    /* U+53C6 "叆" */
    0x0, 0x0, 0x0, 0x8, 0x0, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x1, 0xff, 0x8f, 0xfe, 0x7, 0xff,
    0xe7, 0xff, 0x7f, 0xc0, 0x0, 0x0, 0x0, 0x20,
    0x20, 0x0, 0x2, 0x8, 0x30, 0x0, 0x1, 0x84,
    0x10, 0x0, 0x0, 0xe3, 0x18, 0x0, 0x0, 0x39,
    0x8c, 0x0, 0x0, 0x1c, 0xec, 0x0, 0x0, 0xc,
    0x66, 0x0, 0x0, 0x72, 0x26, 0x78, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xdf, 0xff, 0xff, 0xff, 0xee,
    0x0, 0xf, 0xf, 0x7, 0x3c, 0x7, 0x87, 0x83,
    0x9e, 0x3, 0xc3, 0xc1, 0xcf, 0x2, 0x21, 0xe0,
    0x7, 0x80, 0x0, 0xf0, 0x3, 0xc0, 0x0, 0x78,
    0x3f, 0xff, 0xf0, 0x3c, 0x1f, 0xff, 0xf8, 0x1e,
    0x0, 0x78, 0x0, 0xe, 0x0, 0x3c, 0x0, 0x7,
    0x10, 0x1e, 0x1e, 0x3, 0x88, 0xf, 0xf, 0x1,
    0xc4, 0xf, 0xff, 0x0, 0xe2, 0x7, 0xff, 0x80,
    0x61, 0x3, 0xc3, 0xc0, 0x30, 0xc1, 0xe1, 0xe0,
    0x38, 0x60, 0xf0, 0xf0, 0x18, 0x38, 0x74, 0x78,
    0xc, 0x1c, 0x72, 0x38, 0x4, 0x2e, 0x39, 0x9c,
    0x6, 0x37, 0x18, 0xee, 0x2, 0xf3, 0x9c, 0x3e,
    0x7, 0xf0, 0x8c, 0x1f, 0x1, 0xf0, 0x4e, 0x7,
    0x80, 0xf0, 0x6, 0x7, 0xe0, 0x30, 0x6, 0x7,
    0xfe, 0x10, 0x2, 0x7, 0x3f, 0x0, 0x3, 0x6,
    0x1f, 0x80, 0x3, 0x6, 0x3, 0x80, 0x1, 0xc,
    0x0, 0xc0, 0x0, 0x8, 0x0, 0x0,

    /* U+53C7 "叇" */
    0x0, 0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x1, 0x0, 0xf0,
    0x7, 0xfe, 0xc0, 0x78, 0xe0, 0x0, 0x60, 0x3c,
    0x70, 0x0, 0x39, 0xff, 0xf8, 0x0, 0xc, 0xff,
    0xfc, 0x0, 0x7, 0x7, 0x8e, 0x0, 0x3, 0x83,
    0xc7, 0x0, 0x1, 0x81, 0xe3, 0x80, 0x0, 0xc0,
    0xf1, 0xc0, 0x0, 0xf, 0xff, 0xf0, 0x0, 0x7,
    0xff, 0xf8, 0x0, 0x0, 0x1e, 0x39, 0xff, 0xc0,
    0xf, 0x1c, 0xff, 0xee, 0x7, 0x8e, 0xe, 0x7,
    0x3, 0xc7, 0x7, 0x3, 0xbf, 0xff, 0x83, 0x8f,
    0xdf, 0xff, 0xc1, 0xc7, 0xe0, 0x78, 0xe0, 0xe0,
    0x70, 0x3c, 0x10, 0x70, 0x39, 0x1e, 0x18, 0x38,
    0x1c, 0xcf, 0x8, 0x1d, 0xe, 0x67, 0xcc, 0xe,
    0x87, 0x13, 0xe4, 0x7, 0x43, 0x89, 0xfe, 0x3,
    0xb1, 0xc4, 0xfe, 0x1, 0xd8, 0xe0, 0xff, 0x0,
    0xec, 0x70, 0xfd, 0x80, 0x77, 0x38, 0xde, 0xe0,
    0x33, 0x9d, 0xef, 0x78, 0x19, 0xce, 0xf7, 0x9e,
    0x1c, 0x77, 0x73, 0xcf, 0xc, 0x3b, 0xb1, 0xe7,
    0x86, 0x3d, 0xd8, 0xf1, 0xc2, 0x2c, 0xe8, 0x78,
    0x62, 0x76, 0x70, 0x3c, 0x11, 0xf1, 0x38, 0x3c,
    0x1, 0xf8, 0x9c, 0x7c, 0x0, 0xf8, 0xf, 0x0,
    0x0, 0x78, 0x7f, 0x80, 0x0, 0x38, 0x1e, 0x70,
    0x0, 0x10, 0xe, 0x3f, 0xff, 0xe0, 0x7, 0xf,
    0xff, 0xe0, 0x6, 0x3, 0xff, 0xf8, 0x2, 0x0,
    0x0, 0x0,

    /* U+53C8 "又" */
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0xf, 0x80,
    0xff, 0xff, 0xff, 0x1, 0xff, 0xff, 0xfe, 0x0,
    0x8, 0x0, 0x7c, 0x0, 0x10, 0x0, 0xf8, 0x0,
    0x20, 0x1, 0xf0, 0x0, 0x40, 0x3, 0xe0, 0x0,
    0x80, 0x7, 0xc0, 0x1, 0x0, 0xf, 0x80, 0x2,
    0x0, 0x1f, 0x0, 0x4, 0x0, 0x3e, 0x0, 0x8,
    0x0, 0x7c, 0x0, 0x18, 0x0, 0xf8, 0x0, 0x30,
    0x1, 0xf0, 0x0, 0x60, 0x3, 0xe0, 0x0, 0xc0,
    0x7, 0xc0, 0x1, 0x80, 0xf, 0x80, 0x3, 0x80,
    0x1e, 0x0, 0x3, 0x0, 0x3c, 0x0, 0x6, 0x0,
    0x78, 0x0, 0xc, 0x1, 0xf0, 0x0, 0x1c, 0x3,
    0xe0, 0x0, 0x18, 0x7, 0x80, 0x0, 0x38, 0xf,
    0x0, 0x0, 0x70, 0x1e, 0x0, 0x0, 0x70, 0x78,
    0x0, 0x0, 0xe0, 0xf0, 0x0, 0x1, 0xe1, 0xc0,
    0x0, 0x1, 0xe7, 0x80, 0x0, 0x3, 0xce, 0x0,
    0x0, 0x3, 0xf8, 0x0, 0x0, 0x3, 0xe0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x7, 0xe0, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x67, 0xf0, 0x0,
    0x1, 0x87, 0xf8, 0x0, 0xe, 0x7, 0xfc, 0x0,
    0x30, 0x7, 0xff, 0x0, 0xc0, 0x7, 0xfe, 0x3,
    0x0, 0x3, 0xf8, 0x18, 0x0, 0x3, 0xf0, 0x60,
    0x0, 0x1, 0xe3, 0x0, 0x0, 0x0, 0xcc, 0x0,
    0x0, 0x0, 0x0,

    /* U+53C9 "叉" */
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0,
    0x1f, 0xff, 0xff, 0xe0, 0x1f, 0xff, 0xff, 0xe0,
    0x2, 0x0, 0x3, 0xe0, 0x2, 0x0, 0x3, 0xe0,
    0x2, 0x8, 0x3, 0xe0, 0x2, 0x4, 0x3, 0xe0,
    0x2, 0x4, 0x3, 0xe0, 0x2, 0x6, 0x3, 0xe0,
    0x2, 0x7, 0x3, 0xe0, 0x2, 0x7, 0x3, 0xc0,
    0x3, 0x7, 0x83, 0xc0, 0x1, 0x7, 0x87, 0xc0,
    0x1, 0x3, 0xc7, 0xc0, 0x1, 0x3, 0xc7, 0xc0,
    0x1, 0x3, 0xc7, 0xc0, 0x1, 0x83, 0x87, 0xc0,
    0x1, 0x81, 0x87, 0x80, 0x0, 0x81, 0xf, 0x80,
    0x0, 0xc1, 0xf, 0x80, 0x0, 0xc0, 0xf, 0x0,
    0x0, 0xe0, 0xf, 0x0, 0x0, 0x60, 0x1f, 0x0,
    0x0, 0x70, 0x1e, 0x0, 0x0, 0x70, 0x1e, 0x0,
    0x0, 0x38, 0x3c, 0x0, 0x0, 0x3c, 0x3c, 0x0,
    0x0, 0x1c, 0x78, 0x0, 0x0, 0x1e, 0x70, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0xf, 0xe0, 0x0,
    0x0, 0x7, 0xe0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x7, 0xfc, 0x0, 0x0, 0xf, 0xfe, 0x0,
    0x0, 0xe, 0x7f, 0x80, 0x0, 0x1c, 0x3f, 0xe0,
    0x0, 0x38, 0x1f, 0xfc, 0x0, 0x60, 0xf, 0xff,
    0x0, 0xc0, 0x3, 0xfe, 0x3, 0x80, 0x1, 0xfe,
    0x6, 0x0, 0x0, 0x7e, 0xc, 0x0, 0x0, 0x3e,
    0x18, 0x0, 0x0, 0xe, 0x60, 0x0, 0x0, 0x0,

    /* U+53CA "及" */
    0x0, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x3, 0xe0,
    0x7f, 0xff, 0xff, 0xe0, 0x7f, 0xff, 0xff, 0xe0,
    0x3, 0xc0, 0x3, 0xe0, 0x3, 0xc0, 0x3, 0xc0,
    0x3, 0xc0, 0x3, 0xc0, 0x3, 0xc0, 0x7, 0xc0,
    0x3, 0xc0, 0x7, 0x80, 0x3, 0xc0, 0xf, 0x0,
    0x3, 0xc0, 0xe, 0x0, 0x3, 0xc0, 0x1c, 0x0,
    0x3, 0xc0, 0x38, 0x0, 0x3, 0xc0, 0x60, 0x0,
    0x3, 0xc0, 0xc0, 0xf0, 0x3, 0xc1, 0x0, 0xf0,
    0x3, 0xcf, 0xff, 0xf0, 0x3, 0xcf, 0xff, 0xf0,
    0x3, 0xc2, 0x0, 0xf0, 0x3, 0xc2, 0x0, 0xf0,
    0x3, 0xc2, 0x0, 0xf0, 0x3, 0xc2, 0x0, 0xf0,
    0x3, 0xc2, 0x0, 0xf0, 0x3, 0xc3, 0x1, 0xf0,
    0x3, 0xc3, 0x1, 0xf0, 0x3, 0xc3, 0x1, 0xf0,
    0x3, 0xc3, 0x81, 0xf0, 0x3, 0xc1, 0x81, 0xf0,
    0x3, 0xc1, 0x81, 0xe0, 0x3, 0xc1, 0xc3, 0xe0,
    0x3, 0xc1, 0xc3, 0xe0, 0x3, 0xc0, 0xe3, 0xc0,
    0x3, 0x80, 0xf7, 0xc0, 0x3, 0x80, 0xf7, 0x80,
    0x7, 0x80, 0x7f, 0x0, 0x7, 0x80, 0x7e, 0x0,
    0x7, 0x0, 0x3e, 0x0, 0x7, 0x0, 0x7f, 0x0,
    0xe, 0x0, 0xff, 0x80, 0xe, 0x1, 0xef, 0xe0,
    0xc, 0x3, 0xc7, 0xff, 0x18, 0x7, 0x3, 0xff,
    0x30, 0xe, 0x1, 0xfe, 0x30, 0x3c, 0x0, 0x7e,
    0x60, 0x70, 0x0, 0x1e, 0xc1, 0xc0, 0x0, 0x6,

    /* U+53CB "友" */
    0x0, 0x7c, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0x0, 0x7c, 0x0, 0x0, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x0, 0x0,
    0x0, 0x78, 0x0, 0x0, 0x0, 0x78, 0x1, 0xe0,
    0x0, 0x78, 0x1, 0xe0, 0x0, 0x78, 0x1, 0xe0,
    0x0, 0x7f, 0xff, 0xe0, 0x0, 0x7f, 0xff, 0xe0,
    0x0, 0x7a, 0x1, 0xe0, 0x0, 0x7a, 0x1, 0xe0,
    0x0, 0x7a, 0x1, 0xe0, 0x0, 0x7a, 0x1, 0xe0,
    0x0, 0x7b, 0x1, 0xe0, 0x0, 0x7b, 0x1, 0xe0,
    0x0, 0x73, 0x1, 0xe0, 0x0, 0x71, 0x1, 0xc0,
    0x0, 0x71, 0x83, 0xc0, 0x0, 0x71, 0x83, 0xc0,
    0x0, 0x71, 0x83, 0xc0, 0x0, 0xe1, 0xc3, 0xc0,
    0x0, 0xe0, 0xc3, 0x80, 0x0, 0xe0, 0xe7, 0x80,
    0x0, 0xc0, 0xf7, 0x0, 0x0, 0xc0, 0x7f, 0x0,
    0x1, 0xc0, 0x7e, 0x0, 0x1, 0x80, 0x7c, 0x0,
    0x1, 0x80, 0x3e, 0x0, 0x3, 0x0, 0x7f, 0x80,
    0x2, 0x0, 0xef, 0xe0, 0x6, 0x1, 0xc7, 0xf0,
    0xc, 0x3, 0x3, 0xfe, 0x8, 0x6, 0x1, 0xff,
    0x18, 0x1c, 0x0, 0xfe, 0x30, 0x38, 0x0, 0x3e,
    0x20, 0x60, 0x0, 0xe, 0x41, 0x80, 0x0, 0x2,

    /* U+53CC "双" */
    0x0, 0x1e, 0x0, 0x3c, 0x0, 0xf, 0x0, 0x1e,
    0xf, 0xff, 0x9f, 0xff, 0x7, 0xff, 0xcf, 0xff,
    0x80, 0x1, 0xe1, 0x3, 0xc0, 0x0, 0xf0, 0x81,
    0xe0, 0x0, 0x78, 0x40, 0xf0, 0x0, 0x3c, 0x20,
    0x78, 0x0, 0x1e, 0x10, 0x3c, 0x8, 0xf, 0x8,
    0x1e, 0x4, 0x7, 0x84, 0xf, 0x3, 0x3, 0xc2,
    0x7, 0x80, 0x81, 0xe1, 0x3, 0xc0, 0x60, 0xf0,
    0x81, 0xe0, 0x30, 0x78, 0x60, 0xf0, 0xc, 0x3c,
    0x30, 0x78, 0x6, 0x1e, 0x18, 0x3c, 0x3, 0x8f,
    0xc, 0x1e, 0x1, 0xc7, 0x86, 0xf, 0x0, 0x73,
    0xc1, 0x7, 0x80, 0x39, 0xe0, 0x83, 0x80, 0x1e,
    0xf0, 0x61, 0xc0, 0x7, 0x70, 0x31, 0xe0, 0x3,
    0xf8, 0x18, 0xf0, 0x1, 0xfc, 0xc, 0x70, 0x0,
    0x7e, 0x7, 0x38, 0x0, 0x3e, 0x3, 0x9c, 0x0,
    0x1f, 0x0, 0xde, 0x0, 0x7, 0x80, 0x7e, 0x0,
    0x3, 0xe0, 0x3f, 0x0, 0x1, 0xf0, 0x1f, 0x0,
    0x1, 0xfc, 0x7, 0x80, 0x0, 0xde, 0x3, 0xc0,
    0x0, 0xef, 0x81, 0xf0, 0x0, 0x67, 0xc1, 0xfc,
    0x0, 0x71, 0xf0, 0xfe, 0x0, 0x30, 0xf0, 0xcf,
    0xc0, 0x30, 0x78, 0xc7, 0xf0, 0x18, 0x1c, 0xc1,
    0xfc, 0x18, 0xc, 0x60, 0x7f, 0xc, 0x2, 0x60,
    0x3f, 0x8c, 0x0, 0x60, 0xf, 0xc4, 0x0, 0x60,
    0x3, 0xc6, 0x0, 0x60, 0x0, 0xe6, 0x0, 0x60,
    0x0, 0x32, 0x0, 0x60, 0x0, 0x0,

    /* U+53CD "反" */
    0x0, 0x0, 0x0, 0xe0, 0x0, 0x0, 0x3, 0xf0,
    0x7, 0x80, 0x1f, 0xf8, 0x7, 0x81, 0xff, 0xfc,
    0x7, 0x9f, 0xfe, 0x0, 0x7, 0xe0, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0x0, 0x7, 0x80, 0x0, 0x0,
    0x7, 0x80, 0x0, 0xf0, 0x7, 0x80, 0x0, 0xf0,
    0x7, 0xff, 0xff, 0xf0, 0x7, 0xff, 0xff, 0xf0,
    0x7, 0x84, 0x0, 0xf0, 0x7, 0x84, 0x0, 0xf0,
    0x7, 0x84, 0x0, 0xf0, 0x7, 0x84, 0x0, 0xf0,
    0x7, 0x84, 0x0, 0xf0, 0x7, 0x84, 0x0, 0xe0,
    0x7, 0x86, 0x0, 0xe0, 0x7, 0x86, 0x1, 0xe0,
    0x7, 0x86, 0x1, 0xe0, 0x7, 0x83, 0x1, 0xe0,
    0x7, 0x83, 0x1, 0xc0, 0x7, 0x83, 0x1, 0xc0,
    0x7, 0x83, 0x83, 0xc0, 0x7, 0x81, 0x83, 0x80,
    0x7, 0x1, 0xc3, 0x80, 0x7, 0x1, 0xe7, 0x0,
    0x7, 0x0, 0xe7, 0x0, 0x7, 0x0, 0xfe, 0x0,
    0xf, 0x0, 0x7e, 0x0, 0xe, 0x0, 0x7c, 0x0,
    0xe, 0x0, 0x7e, 0x0, 0xe, 0x0, 0xff, 0x80,
    0xc, 0x1, 0xff, 0xe0, 0xc, 0x3, 0x87, 0xf8,
    0x18, 0xe, 0x3, 0xff, 0x18, 0x1c, 0x1, 0xff,
    0x30, 0x30, 0x0, 0x7e, 0x30, 0xc0, 0x0, 0x3e,
    0x61, 0x0, 0x0, 0xe, 0x46, 0x0, 0x0, 0x2,

    /* U+53D1 "发" */
    0x0, 0x7, 0x80, 0x0, 0x0, 0x3, 0xc1, 0x0,
    0x3, 0xc1, 0xe0, 0x60, 0x1, 0xe0, 0xf0, 0x3c,
    0x0, 0xe0, 0x78, 0xf, 0x0, 0x70, 0x3c, 0x3,
    0xc0, 0x38, 0x1e, 0x1, 0xe0, 0x38, 0xf, 0x0,
    0x70, 0x1c, 0x7, 0x80, 0x10, 0xc, 0x3, 0xc0,
    0x0, 0xc, 0x1, 0xe0, 0x0, 0xf, 0xff, 0xff,
    0xff, 0xf7, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x78,
    0x0, 0x0, 0x0, 0x3c, 0x0, 0x0, 0x0, 0x1e,
    0x0, 0x0, 0x0, 0xf, 0x0, 0x0, 0x0, 0x7,
    0x0, 0xf8, 0x0, 0x7, 0x80, 0x7c, 0x0, 0x3,
    0xff, 0xfe, 0x0, 0x1, 0xff, 0xfe, 0x0, 0x0,
    0xf0, 0xf, 0x0, 0x0, 0xf8, 0x7, 0x80, 0x0,
    0x7c, 0x3, 0xc0, 0x0, 0x3a, 0x1, 0xe0, 0x0,
    0x1d, 0x0, 0xf0, 0x0, 0x1e, 0xc0, 0x70, 0x0,
    0xe, 0x60, 0x78, 0x0, 0x7, 0x30, 0x3c, 0x0,
    0x7, 0xc, 0x1c, 0x0, 0x3, 0x86, 0x1e, 0x0,
    0x3, 0x83, 0x8f, 0x0, 0x1, 0x80, 0xef, 0x0,
    0x1, 0xc0, 0x7f, 0x0, 0x0, 0xc0, 0x1f, 0x80,
    0x0, 0x60, 0xf, 0x80, 0x0, 0x60, 0x7, 0xe0,
    0x0, 0x60, 0x7, 0xf8, 0x0, 0x20, 0x7, 0xbf,
    0x0, 0x30, 0x7, 0xf, 0xf0, 0x10, 0x7, 0x3,
    0xff, 0x90, 0x6, 0x0, 0xff, 0x88, 0x6, 0x0,
    0x1f, 0xc8, 0x4, 0x0, 0x7, 0xe8, 0xc, 0x0,
    0x0, 0xf0, 0x8, 0x0, 0x0, 0x18,

    /* U+53D4 "叔" */
    0x0, 0x70, 0x0, 0x0, 0x0, 0x1c, 0x0, 0x7,
    0x80, 0x7, 0x0, 0x1, 0xe0, 0x1, 0xc0, 0xff,
    0xf8, 0x0, 0x70, 0x3f, 0xfe, 0x0, 0x1c, 0x4,
    0x7, 0x80, 0x7, 0xf9, 0x1, 0xe0, 0x1, 0xfe,
    0x40, 0x78, 0x0, 0x70, 0x10, 0x1e, 0x0, 0x1c,
    0x4, 0x7, 0x80, 0x7, 0x1, 0x1, 0xe0, 0x1,
    0xc0, 0x40, 0x78, 0x0, 0x70, 0x10, 0x1e, 0x0,
    0x1c, 0x4, 0x7, 0x80, 0x7, 0x1, 0x81, 0xe0,
    0x1, 0xc0, 0x60, 0x78, 0x0, 0x70, 0x18, 0x1e,
    0x1f, 0xff, 0xf6, 0x7, 0x87, 0xff, 0xfd, 0x83,
    0xc0, 0x0, 0x0, 0x60, 0xf0, 0x0, 0x70, 0x1c,
    0x3c, 0x0, 0x1c, 0x3, 0xf, 0x0, 0x7, 0x0,
    0xc3, 0xc0, 0x79, 0xc8, 0x30, 0xf0, 0x1e, 0x72,
    0xe, 0x38, 0x7, 0x9c, 0x43, 0x8e, 0x1, 0xe7,
    0x10, 0xe7, 0x80, 0x79, 0xc4, 0x3d, 0xe0, 0x1e,
    0x71, 0x87, 0x70, 0x7, 0x1c, 0x71, 0xfc, 0x1,
    0xc7, 0x1c, 0x7e, 0x0, 0x71, 0xc3, 0x9f, 0x80,
    0x18, 0x70, 0xc3, 0xc0, 0xe, 0x1c, 0x30, 0xf8,
    0x3, 0x7, 0x4, 0x3f, 0x0, 0xc1, 0xc1, 0x1f,
    0xe0, 0x60, 0x70, 0x7, 0xfc, 0x18, 0x1c, 0x3,
    0x3f, 0x84, 0x7, 0x1, 0x87, 0xf8, 0x1, 0xc0,
    0xc0, 0xfe, 0x0, 0x70, 0x60, 0x1f, 0x80, 0x3c,
    0x30, 0x3, 0xe0, 0xf, 0x18, 0x0, 0x78, 0xf,
    0x8c, 0x0, 0xe, 0x1f, 0x86, 0x0, 0x1, 0x80,
    0x3, 0x0, 0x0, 0x0,

    /* U+53D6 "取" */
    0xff, 0xff, 0xf0, 0x0, 0x7f, 0xff, 0xf8, 0x0,
    0x3, 0x83, 0xc0, 0x0, 0x1, 0xc1, 0xe0, 0x7,
    0x80, 0xe0, 0xf0, 0x3, 0xc0, 0x70, 0x78, 0x1,
    0xe0, 0x38, 0x3d, 0xff, 0xf0, 0x1c, 0x1e, 0xff,
    0xf8, 0xe, 0xf, 0x10, 0x3c, 0x7, 0x7, 0x88,
    0x1e, 0x3, 0x83, 0xc4, 0xf, 0x1, 0xfd, 0xe2,
    0x7, 0x80, 0xfe, 0xf1, 0x83, 0xc0, 0x70, 0x78,
    0xc1, 0xe0, 0x38, 0x3c, 0x60, 0xf0, 0x1c, 0x1e,
    0x30, 0x78, 0xe, 0xf, 0x18, 0x3c, 0x7, 0x7,
    0x8c, 0x1e, 0x3, 0x83, 0xc6, 0xf, 0x1, 0xc1,
    0xe1, 0x7, 0x80, 0xe0, 0xf0, 0xc3, 0xc0, 0x7f,
    0x78, 0x61, 0xe0, 0x3f, 0xbc, 0x30, 0xf0, 0x1c,
    0x1e, 0x1c, 0x70, 0xe, 0xf, 0xe, 0x38, 0x7,
    0x7, 0x83, 0x3c, 0x3, 0x83, 0xc9, 0xdc, 0x1,
    0xc1, 0xe8, 0xee, 0x0, 0xe0, 0xf8, 0x7f, 0x0,
    0x70, 0x7c, 0x1f, 0x0, 0x38, 0x3c, 0xf, 0x80,
    0x1c, 0x3e, 0x3, 0xc0, 0xe, 0x3f, 0x1, 0xf0,
    0x7, 0x7f, 0x81, 0xfc, 0x3f, 0xfb, 0xc0, 0xdf,
    0x1f, 0xf1, 0xe0, 0xc7, 0xef, 0xe0, 0xf0, 0x61,
    0xfb, 0xc0, 0x78, 0x60, 0xf9, 0x0, 0x3c, 0x60,
    0x3c, 0x0, 0x1e, 0x30, 0xe, 0x0, 0xf, 0x30,
    0x3, 0x0, 0x7, 0xb0, 0x0, 0x80, 0x3, 0xf0,
    0x0, 0x0, 0x1, 0xe0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0,

    /* U+53D7 "受" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1e, 0x0,
    0x0, 0x3, 0xfc, 0x0, 0x1, 0xff, 0xf8, 0x1,
    0xff, 0xff, 0x80, 0xff, 0x40, 0x0, 0x0, 0x0,
    0x80, 0x18, 0x1, 0x3, 0x0, 0xe0, 0x6, 0xe,
    0x3, 0x0, 0xc, 0x3c, 0x1c, 0x0, 0x38, 0x78,
    0x60, 0x0, 0xf1, 0xe3, 0x0, 0x3, 0xc3, 0xc,
    0x0, 0x6, 0xc, 0x60, 0xf, 0x18, 0x1, 0x83,
    0xfc, 0x40, 0xc, 0xf, 0xff, 0xff, 0xff, 0xff,
    0xc0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x7c, 0x80, 0x0, 0x1, 0xf0, 0x1, 0xff,
    0xff, 0xc0, 0x7, 0xff, 0xff, 0x0, 0x4, 0x0,
    0x7c, 0x0, 0x8, 0x1, 0xf0, 0x0, 0x20, 0x7,
    0x80, 0x0, 0xc0, 0x1e, 0x0, 0x1, 0x0, 0x78,
    0x0, 0x6, 0x3, 0xc0, 0x0, 0x1c, 0xf, 0x0,
    0x0, 0x38, 0x78, 0x0, 0x0, 0xf1, 0xe0, 0x0,
    0x1, 0xef, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x0, 0x1f, 0x80, 0x0, 0x0,
    0xff, 0x80, 0x0, 0x7, 0xff, 0x80, 0x0, 0x70,
    0xff, 0xf8, 0x3, 0x81, 0xff, 0xe0, 0x18, 0x1,
    0xff, 0x1, 0xc0, 0x1, 0xfc, 0x1c, 0x0, 0x1,
    0xf0, 0xc0, 0x0, 0x0, 0xc0,

    /* U+53D8 "变" */
    0x0, 0x4, 0x0, 0x0, 0x0, 0x3, 0x0, 0x0,
    0x0, 0x3, 0xc0, 0x0, 0x0, 0x1, 0xe0, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xc0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x1c, 0x3c, 0x0, 0x0, 0x1c, 0x3c, 0x0,
    0x0, 0x1c, 0x3c, 0x80, 0x7, 0x9c, 0x3c, 0x80,
    0x7, 0x9c, 0x3c, 0xc0, 0x7, 0x9c, 0x3c, 0xe0,
    0x7, 0x1c, 0x3c, 0xf0, 0x7, 0x1c, 0x3c, 0x78,
    0xe, 0x1c, 0x3c, 0x7e, 0xc, 0x1c, 0x3c, 0x3e,
    0x1c, 0x1c, 0x3c, 0x3e, 0x18, 0x1c, 0x3c, 0x1e,
    0x30, 0x1c, 0x3c, 0xe, 0x60, 0x1c, 0x3c, 0x2,
    0x0, 0x1c, 0x3c, 0x0, 0x0, 0x0, 0x7, 0xc0,
    0x0, 0x0, 0x7, 0xc0, 0x0, 0x0, 0x7, 0xc0,
    0x7, 0xff, 0xff, 0xc0, 0x7, 0xff, 0xff, 0x80,
    0x0, 0x40, 0x7, 0x80, 0x0, 0x20, 0x7, 0x80,
    0x0, 0x20, 0x7, 0x80, 0x0, 0x30, 0xf, 0x0,
    0x0, 0x18, 0xf, 0x0, 0x0, 0x18, 0x1e, 0x0,
    0x0, 0xc, 0x1e, 0x0, 0x0, 0xe, 0x3c, 0x0,
    0x0, 0x7, 0x78, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x3, 0xfc, 0x0,
    0x0, 0xe, 0x7f, 0xc0, 0x0, 0x1c, 0x3f, 0xff,
    0x0, 0x70, 0xf, 0xfe, 0x1, 0xc0, 0x3, 0xfe,
    0x6, 0x0, 0x0, 0xfe, 0x18, 0x0, 0x0, 0x3e,
    0x60, 0x0, 0x0, 0x6,

    /* U+53D9 "叙" */
    0x3, 0xe0, 0x0, 0x78, 0x3, 0xe0, 0x0, 0x78,
    0x3, 0xc0, 0x0, 0x78, 0x3, 0xc0, 0xff, 0xf8,
    0x7, 0xe0, 0xff, 0xf8, 0x7, 0x90, 0x20, 0x78,
    0x7, 0x98, 0x20, 0x78, 0x7, 0xe, 0x20, 0x78,
    0x6, 0x7, 0x20, 0x78, 0xe, 0x7, 0x20, 0x78,
    0xc, 0x3, 0x20, 0x78, 0x18, 0x1, 0x20, 0x78,
    0x18, 0x0, 0x30, 0x78, 0x3f, 0xff, 0x30, 0x78,
    0x2f, 0xff, 0x30, 0x78, 0x41, 0xe0, 0x30, 0x78,
    0x41, 0xe0, 0x30, 0x78, 0x81, 0xe0, 0x30,