/* 
 * ProductManufacturer_qr_demo.ino (refreshed QR assets)
 * Pins: DC=1, RST=0, CS=2, SCLK=4, SDIN=3  (keep as in your snippet)
 * Shows two 45x45 QR codes centered at 180x180, alternating normal/invert.
 */

#include <Arduino.h>
#include <SPI.h>
#include <ST73XX_UI.h>
#include <ST7305_1p5_BW_DisplayDriver.h>
#include <ST73xxPins.h>

#include <U8g2_for_ST73XX.h>


#define PIN_SCLK 4
#define PIN_SDIN 3
#define PIN_CS 2
#define PIN_DC 1
#define PIN_RST 0

#ifndef DISPLAY_WIDTH
#define DISPLAY_WIDTH 200
#endif
#ifndef DISPLAY_HEIGHT
#define DISPLAY_HEIGHT 200
#endif

const ST73xxPins PINS{ PIN_DC, PIN_CS, PIN_SCLK, PIN_SDIN, PIN_RST };
ST7305_1p5_BW_DisplayDriver display(PINS, SPI);

U8G2_FOR_ST73XX u8g2_for_st73xx;


const int QR_URL_W = 45;
const int QR_URL_H = 45;
const int QR_URL_ROWBYTES = 6;
const int QR_SCALE_FACTOR = 4;  // 45*4=180

static const int DEV_W = 200;
static const int DEV_H = 200;



const int QR_X = 10;
const int QR_Y = 2;
// Model + Chinese


static inline uint16_t COL_FG() {
  return ST7305_COLOR_BLACK;
}

// ===== Inlined new QR arrays =====
const uint8_t QR_FISH_STORE[] PROGMEM = {
  // 45x45, 6 bytes/row = 270 bytes
  0xFF, 0xB1, 0xF0, 0xFA, 0x0F, 0xF8, 0x81, 0x80, 0x4D, 0x7B, 0xCC, 0x08,
  0xBD, 0x82, 0x0D, 0x74, 0x4D, 0xE8, 0xBD, 0x82, 0x0D, 0x74, 0x4D, 0xE8,
  0xBD, 0xB1, 0xFC, 0x0F, 0x8D, 0xE8, 0xBD, 0x9E, 0x05, 0x63, 0xED, 0xE8,
  0x81, 0x8D, 0xF6, 0x09, 0xEC, 0x08, 0xFF, 0xAD, 0x4A, 0x95, 0xAF, 0xF8,
  0xFF, 0xAD, 0x4A, 0x95, 0xAF, 0xF8, 0x00, 0x12, 0x42, 0x90, 0x20, 0x00,
  0x37, 0xBD, 0xF6, 0xF0, 0x70, 0x88, 0x8A, 0x41, 0x4C, 0xFC, 0x5C, 0x10,
  0xB1, 0xBD, 0x09, 0x02, 0x0F, 0x18, 0xB1, 0xBD, 0x09, 0x02, 0x0F, 0x18,
  0xF6, 0x2D, 0x49, 0x07, 0x92, 0x08, 0x81, 0xCE, 0x36, 0x76, 0x1E, 0x08,
  0x3C, 0x6F, 0x4A, 0xE2, 0x0E, 0xF8, 0x0D, 0xF3, 0xF3, 0x8F, 0x93, 0x78,
  0x8A, 0x12, 0x89, 0x1B, 0x9E, 0x10, 0x8A, 0x12, 0x89, 0x1B, 0x9E, 0x10,
  0xF5, 0xD0, 0xF3, 0xE6, 0x6C, 0x98, 0x8A, 0x50, 0xF7, 0xF6, 0x1C, 0x98,
  0x0D, 0xB0, 0x3B, 0x92, 0x32, 0x18, 0xF8, 0x5C, 0xC5, 0x1A, 0x4E, 0x90,
  0x33, 0xBE, 0x46, 0xF2, 0x7E, 0x00, 0x0A, 0x43, 0xF0, 0x86, 0x0C, 0x98,
  0x0A, 0x43, 0xF0, 0x86, 0x0C, 0x98, 0xFD, 0x82, 0xF4, 0x09, 0xA1, 0x18,
  0x32, 0x42, 0xBF, 0x67, 0x90, 0x88, 0x47, 0xEF, 0x34, 0x01, 0xDF, 0x88,
  0x7A, 0x32, 0x30, 0x89, 0x9C, 0x98, 0xB1, 0xD0, 0x45, 0x60, 0x0C, 0x98,
  0xB1, 0xD0, 0x45, 0x60, 0x0C, 0x98, 0x78, 0x12, 0x78, 0x1B, 0xEC, 0x10,
  0x89, 0xF0, 0xCB, 0xE7, 0xBF, 0x80, 0x00, 0x20, 0x7A, 0xFC, 0x61, 0x08,
  0xFF, 0x8D, 0x78, 0x07, 0xED, 0x78, 0xFF, 0x8D, 0x78, 0x07, 0xED, 0x78,
  0x81, 0xBD, 0xFF, 0x7A, 0x21, 0x18, 0xBD, 0xA0, 0xCA, 0x94, 0x3F, 0x90,
  0xBD, 0x8E, 0xB8, 0x6F, 0xD1, 0x78, 0xBD, 0xB0, 0x89, 0x8E, 0x73, 0x08,
  0xBD, 0xB0, 0x89, 0x8E, 0x73, 0x08, 0x81, 0x80, 0x47, 0x16, 0x6E, 0x10,
  0xFF, 0x83, 0x3D, 0x9A, 0x71, 0x18
};

const uint8_t QR_GITHUB[] PROGMEM = {
  // 45x45, 6 bytes/row = 270 bytes
  0xFF, 0x78, 0xF6, 0x7C, 0xE7, 0xF8, 0x81, 0x17, 0x17, 0x9B, 0xA4, 0x08,
  0xB9, 0x29, 0xE8, 0xA2, 0x24, 0xE8, 0xB9, 0x72, 0x29, 0x18, 0x44, 0xE8,
  0xB9, 0x25, 0xCA, 0x67, 0x64, 0xE8, 0x81, 0x06, 0x3C, 0x25, 0x64, 0x08,
  0x81, 0x06, 0x3C, 0x25, 0x64, 0x08, 0xFF, 0x55, 0x2A, 0xA5, 0x57, 0xF8,
  0x00, 0x31, 0x1A, 0x39, 0xF0, 0x00, 0x2F, 0x61, 0xF0, 0x1F, 0x98, 0x48,
  0xB6, 0x29, 0xD5, 0xBD, 0x90, 0x78, 0xC7, 0x80, 0xCA, 0x5C, 0x08, 0xB8,
  0xBE, 0x54, 0x04, 0xFB, 0xDF, 0x98, 0x67, 0xF4, 0xD0, 0x80, 0xBC, 0xC8,
  0xB6, 0xBA, 0xD6, 0xC5, 0x1C, 0x50, 0x5F, 0xED, 0x23, 0x85, 0x97, 0x48,
  0x30, 0x9D, 0xD2, 0x04, 0xF4, 0x90, 0x30, 0x9D, 0xD2, 0x04, 0xF4, 0x90,
  0x2F, 0xB0, 0xDE, 0xC0, 0x37, 0x18, 0x98, 0x58, 0x07, 0xA7, 0xD4, 0x58,
  0x91, 0xEF, 0xE0, 0x81, 0xCC, 0x98, 0x26, 0x79, 0x29, 0x1F, 0x9F, 0x58,
  0x1F, 0x2B, 0xD5, 0x44, 0xAC, 0x70, 0x66, 0x52, 0xF4, 0xC4, 0x50, 0x18,
  0x09, 0xDF, 0x3A, 0x25, 0x4B, 0xB8, 0xE8, 0x48, 0xE9, 0x9A, 0xF7, 0x98,
  0x2F, 0x87, 0xCF, 0xB8, 0xBF, 0xC0, 0x90, 0x8F, 0xF1, 0xA5, 0x4B, 0x08,
  0x90, 0x8F, 0xF1, 0xA5, 0x4B, 0x08, 0xC9, 0xE4, 0x16, 0x5D, 0x08, 0xB8,
  0xAE, 0xF2, 0x19, 0x26, 0x94, 0x00, 0x87, 0x86, 0xCE, 0x46, 0xBC, 0x48,
  0x2E, 0x70, 0xE9, 0xDD, 0xB3, 0x38, 0x9F, 0x17, 0xE5, 0x24, 0x03, 0xC0,
  0x48, 0xAB, 0x2F, 0x22, 0x9C, 0x88, 0xA1, 0x27, 0x1A, 0x5C, 0x3F, 0x80,
  0x00, 0x58, 0xCF, 0x87, 0xB0, 0xB8, 0xFF, 0x2B, 0xEC, 0xD9, 0xF4, 0xA8,
  0x81, 0x77, 0x04, 0x3D, 0x90, 0x98, 0x81, 0x77, 0x04, 0x3D, 0x90, 0x98,
  0xB9, 0x41, 0xE9, 0xF9, 0x9F, 0xE8, 0xB9, 0x38, 0x04, 0x44, 0x88, 0x80,
  0xB9, 0x55, 0xD6, 0xDC, 0x23, 0xE8, 0x81, 0x23, 0x3F, 0x3B, 0xB3, 0x10,
  0xFF, 0x05, 0xCA, 0xC1, 0x97, 0x98
};


// 0°：逻辑坐标 == 面板坐标（左上为原点，x 向右，y 向下）
static inline void land2dev(int x_land, int y_land, int& xd, int& yd) {
  xd = x_land;
  yd = y_land;
}

static inline void fillRectL(int x1, int y1, int x2, int y2, uint16_t col) {
  int ax, ay, bx, by;
  land2dev(x1, y1, ax, ay);
  land2dev(x2, y2, bx, by);
  if (ax > bx) {
    int t = ax;
    ax = bx;
    bx = t;
  }
  if (ay > by) {
    int t = ay;
    ay = by;
    by = t;
  }
  display.drawFilledRectangle(ax, ay, bx, by, col);
}

static void drawQR_L(int x, int y, int scale, const uint8_t* qr_data) {
  for (int r = 0; r < QR_URL_H; ++r) {
    for (int c = 0; c < QR_URL_W; ++c) {
      int byteIndex = r * QR_URL_ROWBYTES + (c >> 3);
      uint8_t b = pgm_read_byte(&qr_data[byteIndex]);
      if ((b >> (7 - (c & 7))) & 1) {
        int x1 = x + c * scale, y1 = y + r * scale;
        fillRectL(x1, y1, x1 + scale - 1, y1 + scale - 1, COL_FG());
      }
    }
  }
}

void setup() {
  Serial.begin(115200);
  Serial.println("Refresh QR demo");

  SPI.begin(PIN_SCLK, -1, PIN_SDIN, PIN_CS);
  display.initialize();
  display.High_Power_Mode();
  display.display_on(true);
  display.display_Inversion(false);
  display.clearDisplay();
  display.display();

  
  u8g2_for_st73xx.begin(display);   // hook u8g2 to the driver
}

void loop() {

  drawQR_L(QR_X, QR_Y, QR_SCALE_FACTOR, QR_FISH_STORE);  
  u8g2_for_st73xx.setFont(u8g2_font_wqy16_t_gb2312b);
  u8g2_for_st73xx.setCursor(0, 198); 
  u8g2_for_st73xx.print(F("不定期推出各种有意思产品")); 
  display.display();

  display.display_Inversion(false);
  display.display();
  delay(5000);

  // New QR #2
  display.clearDisplay();
  drawQR_L(QR_X, QR_Y, QR_SCALE_FACTOR, QR_GITHUB);
  display.display_Inversion(false);
  display.display();
  //delay(2000);


  //display.clearDisplay();
  u8g2_for_st73xx.setFont(u8g2_font_wqy16_t_gb2312b);
  u8g2_for_st73xx.setCursor(80, 198);
  u8g2_for_st73xx.print(F("github")); 
  display.display();

  delay(5000);

  // New QR #1
  display.clearDisplay();
}
