<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<!-- Copying and distribution of this file, with or without modification,
     are permitted in any medium without royalty provided the copyright
     notice and this notice are preserved.  This file is offered as-is,
     without any warranty.
-->

<!--
This tool resides and is maintained at
https://github.com/bengtmartensson/KeywordsTxtGenerator
-->

<!-- Author: Bengt Martensson -->

<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0">
    <xsl:output method="text" />

    <xsl:template match="/doxygenindex">
        <xsl:text>#######################################
# Syntax Coloring Map For the current project.
# This file was generated by doxygen2keywords.xsl.
#######################################

#######################################
# Classes and structs (KEYWORD1)
#######################################

</xsl:text>
    <xsl:apply-templates select="compound[@kind='class' or @kind='struct' ]"/>

    <xsl:text>
#######################################
# Methods (KEYWORD2)
#######################################

</xsl:text>
    <xsl:apply-templates select="compound/member[@kind='function']"/>

    <xsl:text>
#######################################
# Constants (LITERAL1)
#######################################

</xsl:text>
    <xsl:apply-templates select="compound/member[@kind='define' or @kind='enumvalue']"/>
    </xsl:template>

    <xsl:template match="compound[@kind='class' or @kind='struct' ]">
        <xsl:value-of select="name"/>
        <xsl:text>&#x9;KEYWORD1&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="member[@kind='function']">
        <xsl:value-of select="name"/>
        <xsl:text>&#x9;KEYWORD2&#xA;</xsl:text>
    </xsl:template>

    <xsl:template match="member[@kind='define' or @kind='enumvalue']">
        <xsl:value-of select="name"/>
        <xsl:text>&#x9;LITERAL1&#xA;</xsl:text>
    </xsl:template>
</xsl:stylesheet>
