# MPU6050 by Electronic Cats - Library for Arduino
<p align=center>
  <a href="https://github.com/ElectronicCats/mpu6050/wiki">
    <img src="https://user-images.githubusercontent.com/107638696/241324971-43b8fe88-447d-4c2d-9296-4b3aaa50f4ce.png" height="400" />
  </a>
</p>
<p align=center>
  <a href="https://github.com/ElectronicCats/mpu6050/wiki">
    <img src="https://github.com/ElectronicCats/mpu6050/assets/139595394/62f14865-5e11-4c83-a044-f63a2ddbeb23" width="200" height="104"/>
  </a>
</p>

[![LibraryBuild](https://github.com/ElectronicCats/mpu6050/actions/workflows/LibraryBuild.yml/badge.svg)](https://github.com/ElectronicCats/mpu6050/actions/workflows/LibraryBuild.yml)

Arduino library for controlling MPU6050 module.

MPU6050 Combines a 3-axis gyroscope and a 3-axis accelerometer on the same silicon die together with
an onboard DMP (_Digital Motion Processor_) which processes complex 6-axis MotionFusion algorithms.

_Based on [jrowberg/i2cdevlib](https://github.com/jrowberg/i2cdevlib/tree/master/Arduino/MPU6050)_

## Features of this version
- ### Supported Chipsets
  - AVR
  - SAM
  - SAMD21 
  - ARM
  - ESP32 
  - ESP8266
  - RENESAS
  
## Quick Installing
To install, use the [Arduino Library Manager](https://support.arduino.cc/hc/en-us/articles/5145457742236-Add-libraries-to-Arduino-IDE) and search for "MPU6050" and install the MPU6050 by Electronic Cats library.

## How to contribute <img src="https://electroniccats.com/wp-content/uploads/2018/01/fav.png" height="35"><img src="https://raw.githubusercontent.com/gist/ManulMax/2d20af60d709805c55fd784ca7cba4b9/raw/bcfeac7604f674ace63623106eb8bb8471d844a6/github.gif" height="30">
 Contributions are welcome! 

Please read the document  [**Contribution Manual**](https://github.com/ElectronicCats/electroniccats-cla/blob/main/electroniccats-contribution-manual.md)  which will show you how to contribute your changes to the project.

✨ Thanks to all our [contributors](https://github.com/ElectronicCats/mpu6050/graphs/contributors)! ✨

See [**_Electronic Cats CLA_**](https://github.com/ElectronicCats/electroniccats-cla/blob/main/electroniccats-cla.md) for more information.

See the  [**community code of conduct**](https://github.com/ElectronicCats/electroniccats-cla/blob/main/electroniccats-community-code-of-conduct.md)   for a vision of the community we want to build and what we expect from it.

## Maintainer
<a href="https://github.com/sponsors/ElectronicCats">
 <p align="center">
  <img src="https://electroniccats.com/wp-content/uploads/2020/07/Badge_GHS.png" height="104" />
 </p>
</a>

Electronic Cats invests time and resources providing this open source design, please support Electronic Cats and open-source hardware by purchasing products from Electronic Cats!
