![LibraryBuild](https://github.com/ElectronicCats/ElectronicCats-PN7150/workflows/LibraryBuild/badge.svg?branch=master)

# Electronic Cats PN7150 and PN7160

<p align="center">
  <img src="https://github.com/ElectronicCats/ElectronicCats-PN7150/assets/122187221/e2285142-2924-4075-80d5-c9397a16178c" />
</p>

<p align=center>
<a href="https://github.com/ElectronicCats/ElectronicCats-PN7150/wiki">
  <img src="https://github.com/ElectronicCats/ElectronicCats-PN7150/assets/122187221/74aaa2cf-20bf-45dc-b072-7afd0b28949d" width="200" height="104" />
</a>
</p>

Library/Driver for NXP PN7150 and PN7160 NFC device

Optimized for fast design-in, NXP's PN7150 and PN7160 NFC solutions fully comply with the NFC Forum, including Linux®, AndroidTM, and WinIoT drivers, and support NCI 1.0 host communication.

PN7150 is the high-performance version of PN7120, the plug-and-play NFC solution for easy integration into any OS environment, reducing Bill of Material (BOM) size and cost. 

PN7160 is compatible with popular MCUs, including LPC, Kinetis and i.MX. The PN7161 version adds support for Apple ECP.

PN71xx controllers are ideal for home automation applications such as gateways and work seamlessly with NFC-connected tags.

## API Documentation

Check the [API Documentation](/API.md) for more information about the methods available in the library.

### Compatibility

* Arduino MKR Family
* STM32H747 
* ESP32  
* RP2040 
* RENESAS

**NOTE: NOT COMPATIBLE WITH ARDUINO AVR FAMILY**

## How to contribute <img src="https://electroniccats.com/wp-content/uploads/2018/01/fav.png" height="35"><img src="https://raw.githubusercontent.com/gist/ManulMax/2d20af60d709805c55fd784ca7cba4b9/raw/bcfeac7604f674ace63623106eb8bb8471d844a6/github.gif" height="30">
 Contributions are welcome! 

Please read the document  [**Contribution Manual**](https://github.com/ElectronicCats/electroniccats-cla/blob/main/electroniccats-contribution-manual.md)  which will show you how to contribute your changes to the project.

✨ Thanks to all our [contributors](https://github.com/ElectronicCats/ElectronicCats-PN7150/graphs/contributors)! ✨

See [**_Electronic Cats CLA_**](https://github.com/ElectronicCats/electroniccats-cla/blob/main/electroniccats-cla.md) for more information.

See the  [**community code of conduct**](https://github.com/ElectronicCats/electroniccats-cla/blob/main/electroniccats-community-code-of-conduct.md) for a vision of the community we want to build and what we expect from it.

## Special Thanks

✨We want to extend our sincere thanks to [Elechouse](https://www.elechouse.com/) for their valuable contribution in providing PN7160 boards, which were instrumental in enabling significant improvements to this library. Thanks to their support, we have successfully achieved full and functional integration with the PN7160 module. We deeply appreciate this kind of support from the community. Thank you for helping us continue to improve and expand the capabilities of this library!✨

## Maintainer

<a href="https://github.com/sponsors/ElectronicCats">
 <p align="center">
  <img src="https://electroniccats.com/wp-content/uploads/2020/07/Badge_GHS.png" height="104" />
 </p>
</a>

Electronic Cats invests time and resources in providing this open-source design, please support Electronic Cats and open-source hardware by purchasing products from Electronic Cats!
