/*
 * CayenneLPP - Catch2 Unit Tests
 *
 * Copyright (C) 2021 by Manuel Weichselbaumer <mincequi@web.de>
 *
 * Use of this source code is governed by the MIT license that can be found in the LICENSE file.
 *
 */

#include <iostream>
#include <fstream>

#include <catch2/catch_test_macros.hpp>
#include <catch2/benchmark/catch_benchmark.hpp>
#include <catch2/generators/catch_generators.hpp>

#include <CayenneLPP.h>

using Expectations = std::vector<std::tuple<CayenneLPPPolyline::Precision, double, uint32_t, uint32_t, uint32_t>>;
using SampleData = std::vector<CayenneLPPPolyline::Point>;

const SampleData sampleData1 {
    { 48.501959, 11.501984 },
    { 48.502972, 11.501884 },
    { 48.503043, 11.501878 },
    { 48.503052, 11.50226 },
    { 48.502984, 11.502808 },
    { 48.503126, 11.502846 },
    { 48.503536, 11.503009 },
    { 48.50367, 11.503083 },
    { 48.503744, 11.503146 },
    { 48.503797, 11.50318 },
    { 48.503889, 11.503215 },
    { 48.504481, 11.503381 },
    { 48.5045, 11.503395 },
    { 48.504521, 11.503433 },
    { 48.504525, 11.503455 },
    { 48.504523, 11.503504 },
    { 48.504518, 11.503635 },
    { 48.504553, 11.503733 },
    { 48.505365, 11.50313 },
    { 48.505567, 11.503016 },
    { 48.505773, 11.502945 },
    { 48.505804, 11.502937 },
    { 48.506076, 11.502894 },
    { 48.506272, 11.502901 },
    { 48.506465, 11.502936 },
    { 48.506553, 11.502961 },
    { 48.506965, 11.503111 },
    { 48.507336, 11.503289 },
    { 48.507363, 11.503301 },
    { 48.507517, 11.502853 },
    { 48.50776, 11.502969 },
    { 48.507998, 11.503067 },
    { 48.50827, 11.503152 },
    { 48.508522, 11.503222 },
    { 48.508919, 11.503308 },
    { 48.50947, 11.503318 },
    { 48.50964, 11.503317 },
    { 48.509682, 11.503818 },
    { 48.509697, 11.503929 },
    { 48.509785, 11.503895 },
    { 48.510027, 11.503791 },
    { 48.510153, 11.503729 },
    { 48.511002, 11.503243 },
    { 48.511108, 11.503177 },
    { 48.511171, 11.503154 },
    { 48.511277, 11.503121 },
    { 48.511413, 11.50309 },
    { 48.511736, 11.503055 },
    { 48.511791, 11.503049 },
    { 48.512226, 11.503024 },
    { 48.512507, 11.503022 },
    { 48.513184, 11.503176 },
    { 48.513938, 11.503301 },
    { 48.514023, 11.503335 },
    { 48.514049, 11.503351 },
    { 48.514101, 11.503383 },
    { 48.514272, 11.503459 },
    { 48.514347, 11.503485 },
    { 48.514502, 11.503541 },
    { 48.514477, 11.503678 },
    { 48.514458, 11.503825 },
    { 48.514368, 11.504809 },
    { 48.514345, 11.505073 },
    { 48.514335, 11.505192 },
    { 48.514313, 11.505438 },
    { 48.514302, 11.505566 },
    { 48.514295, 11.505699 },
    { 48.514284, 11.506058 },
    { 48.514299, 11.506227 },
    { 48.514348, 11.506747 },
    { 48.514372, 11.507706 },
    { 48.514355, 11.508547 },
    { 48.51444, 11.508559 },
    { 48.514995, 11.508741 },
    { 48.515595, 11.508932 },
    { 48.516207, 11.509173 },
    { 48.516658, 11.509386 },
    { 48.516895, 11.50952 },
    { 48.517121, 11.509701 },
    { 48.517447, 11.51 },
    { 48.517815, 11.510317 },
    { 48.518054, 11.51045 },
    { 48.518414, 11.510556 },
    { 48.518684, 11.510625 },
    { 48.518851, 11.510668 },
    { 48.519037, 11.510718 },
    { 48.519229, 11.510769 },
    { 48.519391, 11.510805 },
    { 48.519699, 11.510875 },
    { 48.519842, 11.510908 },
    { 48.520026, 11.510947 },
    { 48.520149, 11.510973 },
    { 48.520452, 11.511031 },
    { 48.520547, 11.511048 },
    { 48.520655, 11.511067 },
    { 48.520955, 11.511095 },
    { 48.521696, 11.511101 },
    { 48.522108, 11.511088 },
    { 48.522254, 11.511083 },
    { 48.522253, 11.511211 },
    { 48.522253, 11.511323 },
    { 48.522272, 11.511329 },
    { 48.522308, 11.511356 },
    { 48.522322, 11.511377 },
    { 48.522419, 11.511382 },
    { 48.522495, 11.511386 },
    { 48.522488, 11.511416 },
    { 48.522474, 11.511628 },
    { 48.522474, 11.511676 },
    { 48.52247, 11.511714 },
    { 48.522434, 11.512065 },
    { 48.522432, 11.512089 },
    { 48.522549, 11.512102 },
    { 48.522549, 11.512121 },
    { 48.522539, 11.5123 },
    { 48.522538, 11.512343 },
    { 48.522541, 11.512377 },
    { 48.522581, 11.51248 },
    { 48.522614, 11.512552 },
    { 48.522645, 11.512529 },
    { 48.522812, 11.512563 },
    { 48.522883, 11.512537 },
    { 48.523051, 11.512574 },
    { 48.523074, 11.512561 },
    { 48.523186, 11.512669 },
    { 48.523211, 11.512602 },
    { 48.523243, 11.512628 },
    { 48.523292, 11.512647 },
    { 48.523344, 11.512632 },
    { 48.52336, 11.512619 },
    { 48.523439, 11.512679 },
    { 48.523744, 11.512765 },
    { 48.523906, 11.512775 },
    { 48.524379, 11.512782 },
    { 48.52474, 11.512802 },
    { 48.525188, 11.512865 },
    { 48.525419, 11.512963 },
    { 48.525516, 11.513005 },
    { 48.52571, 11.51299 },
    { 48.52581, 11.51299 },
    { 48.525902, 11.512999 },
    { 48.526049, 11.513021 },
    { 48.526081, 11.513031 },
    { 48.526103, 11.513038 },
    { 48.526228, 11.513091 },
    { 48.526374, 11.5132 },
    { 48.526449, 11.513274 },
    { 48.526549, 11.513382 },
    { 48.526581, 11.51342 },
    { 48.526639, 11.513495 },
    { 48.526719, 11.513583 },
    { 48.526769, 11.513611 },
    { 48.52675, 11.513725 },
    { 48.52675, 11.513959 },
    { 48.526807, 11.513961 },
    { 48.526842, 11.513963 },
    { 48.526899, 11.513969 },
    { 48.526902, 11.513866 },
    { 48.526924, 11.513669 },
    { 48.526957, 11.513686 },
    { 48.527553, 11.514128 },
    { 48.528623, 11.515066 },
    { 48.528847, 11.515222 },
    { 48.52939, 11.515421 },
    { 48.530046, 11.515665 },
    { 48.530186, 11.515732 },
    { 48.530249, 11.515766 },
    { 48.530275, 11.51578 },
    { 48.530499, 11.515935 },
    { 48.530563, 11.516002 },
    { 48.530697, 11.51623 },
    { 48.530736, 11.516309 },
    { 48.530892, 11.516607 },
    { 48.531101, 11.517036 },
    { 48.531124, 11.517081 },
    { 48.53116, 11.517131 },
    { 48.531216, 11.517196 },
    { 48.531258, 11.517237 },
    { 48.531422, 11.517327 },
    { 48.531568, 11.51736 },
    { 48.531589, 11.517363 },
    { 48.531735, 11.517385 },
    { 48.531764, 11.517389 },
    { 48.53185, 11.517396 },
    { 48.531893, 11.517403 },
    { 48.531934, 11.517416 },
    { 48.53196, 11.517437 },
    { 48.531993, 11.517486 },
    { 48.532012, 11.517568 },
    { 48.531993, 11.518085 },
    { 48.531985, 11.51818 },
    { 48.531977, 11.518268 },
    { 48.53197, 11.5192 },
    { 48.531976, 11.519266 },
    { 48.531999, 11.51931 },
    { 48.532008, 11.519317 },
    { 48.532045, 11.519321 },
    { 48.532083, 11.519325 },
    { 48.532234, 11.519332 },
    { 48.532427, 11.519342 },
    { 48.532465, 11.519344 },
    { 48.532467, 11.519327 },
    { 48.532522, 11.519336 },
    { 48.532502, 11.519586 },
    { 48.532488, 11.520043 },
    { 48.532494, 11.520272 },
    { 48.532512, 11.520898 },
    { 48.532523, 11.521236 },
    { 48.532495, 11.521695 },
    { 48.532503, 11.521806 },
    { 48.532561, 11.522048 },
    { 48.532681, 11.522452 },
    { 48.532765, 11.522688 },
    { 48.53283, 11.522902 },
    { 48.532993, 11.523574 },
    { 48.533051, 11.523736 },
    { 48.533088, 11.523813 },
    { 48.533307, 11.524174 },
    { 48.53334, 11.524248 },
    { 48.533399, 11.524496 },
    { 48.533425, 11.524633 },
    { 48.53348, 11.524881 },
    { 48.533664, 11.525571 },
    { 48.533954, 11.526317 },
    { 48.534009, 11.526478 },
    { 48.534046, 11.526568 },
    { 48.534092, 11.5267 },
    { 48.534208, 11.526954 },
    { 48.534274, 11.527072 },
    { 48.534437, 11.527225 },
    { 48.534634, 11.527279 },
    { 48.53498, 11.527325 },
    { 48.535069, 11.527378 },
    { 48.535209, 11.527572 },
    { 48.535304, 11.52778 },
    { 48.535327, 11.527844 },
    { 48.535344, 11.52791 },
    { 48.535374, 11.528082 },
    { 48.535344, 11.528621 },
    { 48.535333, 11.529239 },
    { 48.535321, 11.529427 },
    { 48.53523, 11.529921 },
    { 48.535207, 11.530124 },
    { 48.535207, 11.530225 },
    { 48.535215, 11.530325 },
    { 48.535272, 11.530652 },
    { 48.535416, 11.531326 },
    { 48.535426, 11.531433 },
    { 48.535386, 11.531747 },
    { 48.535413, 11.532104 },
    { 48.535488, 11.532672 },
    { 48.535605, 11.533276 },
    { 48.535603, 11.533338 },
    { 48.535528, 11.533527 },
    { 48.535366, 11.533911 },
    { 48.535278, 11.534094 },
    { 48.535137, 11.534324 },
    { 48.535016, 11.534505 },
    { 48.534858, 11.534784 },
    { 48.534776, 11.534979 },
    { 48.534744, 11.535085 },
    { 48.534721, 11.535201 },
    { 48.534706, 11.535283 },
    { 48.534692, 11.535377 },
    { 48.534666, 11.535824 },
    { 48.534646, 11.536132 },
    { 48.534625, 11.536568 },
    { 48.534633, 11.536698 },
    { 48.534708, 11.536979 },
    { 48.534795, 11.537248 },
    { 48.534922, 11.537521 },
    { 48.535072, 11.537852 },
    { 48.535234, 11.538167 },
    { 48.535539, 11.538621 },
    { 48.535809, 11.539014 },
    { 48.535922, 11.53921 },
    { 48.536523, 11.540643 },
    { 48.536876, 11.541297 },
    { 48.537349, 11.542173 },
    { 48.537507, 11.542486 },
    { 48.537644, 11.542475 },
    { 48.538147, 11.542479 },
    { 48.538199, 11.542529 },
    { 48.538279, 11.542671 },
    { 48.538329, 11.542698 },
    { 48.539064, 11.542768 },
    { 48.539583, 11.542748 },
    { 48.540001, 11.542976 },
    { 48.540123, 11.543107 },
    { 48.540143, 11.543209 },
    { 48.5402, 11.54337 },
    { 48.540253, 11.543443 },
    { 48.540531, 11.543596 },
    { 48.541004, 11.543779 },
    { 48.541241, 11.543932 },
    { 48.541315, 11.544095 },
    { 48.541324, 11.544235 },
    { 48.541266, 11.544611 },
    { 48.541265, 11.54471 },
    { 48.541282, 11.544788 },
    { 48.541335, 11.544909 },
    { 48.54142, 11.545008 },
    { 48.541513, 11.545071 },
    { 48.541601, 11.545133 },
    { 48.54228, 11.545505 },
    { 48.542317, 11.545538 },
    { 48.542658, 11.545847 },
    { 48.542771, 11.545956 },
    { 48.543504, 11.546672 },
    { 48.543568, 11.546684 },
    { 48.543618, 11.546667 },
    { 48.543589, 11.546979 },
    { 48.543511, 11.547258 },
    { 48.543322, 11.547602 },
    { 48.543013, 11.548892 },
    { 48.542994, 11.54907 },
    { 48.543006, 11.550214 },
    { 48.54302, 11.550348 },
    { 48.543198, 11.550702 },
    { 48.544417, 11.552403 },
    { 48.544522, 11.552581 },
    { 48.544793, 11.553347 },
    { 48.544861, 11.553455 },
    { 48.544938, 11.553633 },
    { 48.54532, 11.554355 },
    { 48.545622, 11.55478 },
    { 48.545849, 11.55573 },
    { 48.545817, 11.555919 },
    { 48.545797, 11.556003 },
    { 48.545687, 11.556278 },
    { 48.545584, 11.556461 },
    { 48.545538, 11.556836 },
    { 48.545531, 11.557067 },
    { 48.545555, 11.557459 },
    { 48.54561, 11.557634 },
    { 48.545555, 11.557685 },
    { 48.54556, 11.557975 },
    { 48.545553, 11.558459 },
    { 48.545518, 11.55912 },
    { 48.545468, 11.559531 },
    { 48.545548, 11.560298 },
    { 48.545577, 11.560641 },
    { 48.545719, 11.560956 },
    { 48.545963, 11.560956 },
    { 48.546261, 11.560819 },
    { 48.546405, 11.560974 },
    { 48.546537, 11.560934 },
    { 48.546657, 11.560923 },
    { 48.546967, 11.56098 },
    { 48.54703, 11.560987 },
    { 48.547229, 11.561123 },
    { 48.547539, 11.560902 },
    { 48.547872, 11.560708 },
    { 48.547942, 11.560674 },
    { 48.547991, 11.560713 },
    { 48.548305, 11.561028 },
    { 48.548593, 11.561074 },
    { 48.548608, 11.561086 },
    { 48.54881, 11.561256 },
    { 48.549135, 11.561529 },
    { 48.549352, 11.561845 },
    { 48.549379, 11.561884 },
    { 48.549521, 11.562133 },
    { 48.54973, 11.562393 },
    { 48.549788, 11.562465 },
    { 48.55003, 11.562826 },
    { 48.550518, 11.562853 },
    { 48.551132, 11.563126 },
    { 48.551777, 11.563454 },
    { 48.552018, 11.563577 },
    { 48.552695, 11.564696 },
    { 48.552732, 11.565051 },
    { 48.552894, 11.565338 },
    { 48.552985, 11.56539 },
    { 48.553653, 11.565775 },
    { 48.554277, 11.565747 },
    { 48.554332, 11.565734 },
    { 48.554774, 11.565624 },
    { 48.554842, 11.56589 },
    { 48.554953, 11.566108 },
    { 48.554897, 11.56646 },
    { 48.554808, 11.566862 },
    { 48.554698, 11.567248 },
    { 48.554786, 11.567683 },
    { 48.555052, 11.568438 },
    { 48.555095, 11.56855 },
    { 48.555197, 11.568823 },
    { 48.55533, 11.569057 },
    { 48.555485, 11.569208 },
    { 48.555607, 11.569409 },
    { 48.555962, 11.57013 },
    { 48.556051, 11.570549 },
    { 48.55615, 11.570884 },
    { 48.556206, 11.571487 },
    { 48.556416, 11.572358 },
    { 48.556494, 11.572861 },
    { 48.556494, 11.57318 },
    { 48.556439, 11.573515 },
    { 48.556416, 11.573783 },
    { 48.556528, 11.574252 },
    { 48.556661, 11.574772 },
    { 48.556435, 11.574839 },
    { 48.556262, 11.574906 },
    { 48.55611, 11.575043 },
    { 48.555963, 11.575325 },
    { 48.555972, 11.575768 },
    { 48.556323, 11.576834 },
    { 48.556443, 11.577638 },
    { 48.556377, 11.57786 },
    { 48.556266, 11.578007 },
    { 48.55638, 11.578554 },
    { 48.556659, 11.579293 },
    { 48.556899, 11.580041 },
    { 48.557053, 11.58012 },
    { 48.557391, 11.580052 },
    { 48.557651, 11.580035 },
    { 48.55774, 11.580123 },
    { 48.557838, 11.580658 },
    { 48.558123, 11.581371 },
    { 48.558379, 11.581999 },
    { 48.558468, 11.582222 },
    { 48.558442, 11.582548 },
    { 48.558365, 11.582937 },
    { 48.558357, 11.582975 },
    { 48.558032, 11.583584 },
    { 48.557895, 11.583996 },
    { 48.557657, 11.584903 },
    { 48.557394, 11.585511 },
    { 48.557332, 11.585652 },
    { 48.557409, 11.586773 },
    { 48.557448, 11.586832 },
    { 48.558631, 11.587062 },
    { 48.55877, 11.587186 },
    { 48.558747, 11.587995 },
    { 48.558748, 11.588082 },
    { 48.558704, 11.588894 },
    { 48.558649, 11.589196 },
    { 48.558485, 11.58972 },
    { 48.558427, 11.590139 },
    { 48.558397, 11.590681 },
    { 48.558308, 11.591181 },
    { 48.557954, 11.591929 },
    { 48.557796, 11.592419 },
    { 48.557729, 11.592788 },
    { 48.557595, 11.593371 },
    { 48.557392, 11.594636 },
    { 48.557306, 11.594975 },
    { 48.557249, 11.595184 },
    { 48.557139, 11.595554 },
    { 48.55698, 11.595874 },
    { 48.556675, 11.596121 },
    { 48.556127, 11.59658 },
    { 48.555801, 11.596793 },
    { 48.555617, 11.596813 },
    { 48.555429, 11.596761 },
    { 48.555378, 11.596887 },
    { 48.555301, 11.596969 },
    { 48.55515, 11.597014 },
    { 48.554649, 11.597011 },
    { 48.554718, 11.597421 },
    { 48.554721, 11.597756 },
    { 48.5547, 11.598094 },
    { 48.554635, 11.59857 },
    { 48.554597, 11.598786 },
    { 48.554576, 11.599189 },
    { 48.554583, 11.599524 },
    { 48.554475, 11.599559 },
    { 48.554476, 11.5996 },
    { 48.554569, 11.599716 },
    { 48.554693, 11.600164 },
    { 48.554936, 11.600793 },
    { 48.55549, 11.602053 },
    { 48.555961, 11.603059 },
    { 48.556193, 11.603596 },
    { 48.556411, 11.604203 },
    { 48.55656, 11.604742 },
    { 48.55664, 11.605095 },
    { 48.556733, 11.605425 },
    { 48.556862, 11.605846 },
    { 48.557124, 11.606474 },
    { 48.557284, 11.606812 },
    { 48.557529, 11.607265 },
    { 48.557901, 11.607866 },
    { 48.558501, 11.608751 },
    { 48.559533, 11.609973 },
    { 48.55992, 11.610498 },
    { 48.560604, 11.611535 },
    { 48.56153, 11.613049 },
    { 48.561582, 11.613121 },
    { 48.561539, 11.613241 },
    { 48.561425, 11.613699 },
    { 48.561354, 11.613935 },
    { 48.561288, 11.614192 },
    { 48.561286, 11.61433 },
    { 48.561301, 11.614446 },
    { 48.561368, 11.614638 },
    { 48.561507, 11.61494 },
    { 48.561644, 11.615204 },
    { 48.561799, 11.615468 },
    { 48.561954, 11.615671 },
    { 48.562311, 11.616152 },
    { 48.56277, 11.617507 },
    { 48.56296, 11.617979 },
    { 48.563043, 11.618147 },
    { 48.563177, 11.618388 },
    { 48.563296, 11.618582 },
    { 48.563537, 11.618809 },
    { 48.564534, 11.619984 },
    { 48.56475, 11.620263 },
    { 48.564736, 11.62051 },
    { 48.56476, 11.620672 },
    { 48.564606, 11.621224 },
    { 48.564762, 11.621266 },
    { 48.564978, 11.621385 },
    { 48.56566, 11.622359 },
    { 48.565724, 11.62239 },
    { 48.565926, 11.622462 },
    { 48.566101, 11.622492 },
    { 48.566128, 11.622615 },
    { 48.566494, 11.623098 },
    { 48.566522, 11.623334 },
    { 48.566315, 11.623946 },
    { 48.566254, 11.62418 },
    { 48.565797, 11.625272 },
    { 48.565464, 11.626188 },
    { 48.565263, 11.626986 },
    { 48.565388, 11.627062 },
    { 48.56554, 11.627205 },
    { 48.565921, 11.627788 },
    { 48.56606, 11.627962 },
    { 48.566168, 11.628029 },
    { 48.56624, 11.628073 },
    { 48.566407, 11.628108 },
    { 48.566446, 11.628086 },
    { 48.566498, 11.628224 },
    { 48.566749, 11.628581 },
    { 48.566985, 11.628748 },
    { 48.567072, 11.628843 },
    { 48.567293, 11.629411 },
    { 48.567505, 11.629879 },
    { 48.567543, 11.629963 },
    { 48.567429, 11.630258 },
    { 48.567155, 11.631036 },
    { 48.567006, 11.631763 },
    { 48.56675, 11.632351 },
    { 48.566703, 11.632484 },
    { 48.566673, 11.632653 },
    { 48.566673, 11.632782 },
    { 48.5667, 11.63294 },
    { 48.566858, 11.633357 },
    { 48.566911, 11.633565 },
    { 48.566933, 11.633985 },
    { 48.566918, 11.634118 },
    { 48.566869, 11.634287 },
    { 48.566712, 11.634611 },
    { 48.566665, 11.634751 },
    { 48.566617, 11.634995 },
    { 48.566611, 11.635117 },
    { 48.566649, 11.635433 },
    { 48.56675, 11.635861 },
    { 48.56695, 11.636451 },
    { 48.567052, 11.63671 },
    { 48.567207, 11.637029 },
    { 48.567574, 11.637955 },
    { 48.567763, 11.638382 },
    { 48.567902, 11.638829 },
    { 48.567959, 11.63903 },
    { 48.568072, 11.639829 },
    { 48.568116, 11.640412 },
    { 48.568119, 11.640792 },
    { 48.56815, 11.641118 },
    { 48.56848, 11.642228 },
    { 48.568675, 11.642574 },
    { 48.56941, 11.643112 },
    { 48.570066, 11.643538 },
    { 48.570389, 11.644151 },
    { 48.570618, 11.644585 },
    { 48.571129, 11.645262 },
    { 48.570262, 11.64747 },
    { 48.569834, 11.648401 },
    { 48.56974, 11.648565 },
    { 48.569582, 11.648881 },
    { 48.569008, 11.650014 },
    { 48.568658, 11.650858 },
    { 48.568387, 11.651639 },
    { 48.568179, 11.652543 },
    { 48.56817, 11.652686 },
    { 48.568304, 11.652774 },
    { 48.568153, 11.6532 },
    { 48.568052, 11.653573 },
    { 48.567999, 11.653841 },
    { 48.567984, 11.65399 },
    { 48.567972, 11.654504 },
    { 48.568029, 11.65515 },
    { 48.568143, 11.655565 },
    { 48.56827, 11.655939 },
    { 48.568371, 11.656341 },
    { 48.568428, 11.656774 },
    { 48.56844, 11.657182 },
    { 48.568404, 11.657604 },
    { 48.56831, 11.658034 },
    { 48.568212, 11.658343 },
    { 48.567999, 11.658943 },
    { 48.567772, 11.659594 },
    { 48.567753, 11.65988 },
    { 48.567753, 11.660309 },
    { 48.567758, 11.661285 },
    { 48.56779, 11.661545 },
    { 48.567843, 11.661784 },
    { 48.567842, 11.662001 },
    { 48.567772, 11.662614 },
    { 48.567632, 11.663547 },
    { 48.567569, 11.664111 },
    { 48.567447, 11.66496 },
    { 48.567422, 11.665304 },
    { 48.567418, 11.665738 },
    { 48.56739, 11.665906 },
    { 48.567273, 11.66618 },
    { 48.566967, 11.666716 },
    { 48.566898, 11.6669 },
    { 48.566838, 11.667261 },
    { 48.5667, 11.667518 },
    { 48.566485, 11.667861 },
    { 48.566186, 11.668387 },
    { 48.565862, 11.669066 },
    { 48.5657, 11.669599 },
    { 48.565653, 11.669771 },
    { 48.565653, 11.669949 },
    { 48.565699, 11.670179 },
    { 48.565668, 11.670381 },
    { 48.565534, 11.670752 },
    { 48.565424, 11.671109 },
    { 48.565282, 11.67136 },
    { 48.565207, 11.671672 },
    { 48.565152, 11.672038 },
    { 48.565076, 11.67219 },
    { 48.56495, 11.672616 },
    { 48.564842, 11.67298 },
    { 48.564824, 11.673112 },
    { 48.564819, 11.673143 },
    { 48.564813, 11.673185 },
    { 48.564747, 11.673556 },
    { 48.564422, 11.675082 },
    { 48.564404, 11.675141 },
    { 48.564352, 11.675318 },
    { 48.564286, 11.675505 },
    { 48.564174, 11.675774 },
    { 48.563988, 11.67631 },
    { 48.563539, 11.677485 },
    { 48.563431, 11.677732 },
    { 48.563358, 11.677834 },
    { 48.563255, 11.677914 },
    { 48.563143, 11.677946 },
    { 48.562847, 11.679022 },
    { 48.562625, 11.679288 },
    { 48.562432, 11.679271 },
    { 48.562017, 11.679151 },
    { 48.561756, 11.678953 },
    { 48.56137, 11.67982 },
    { 48.56129, 11.68007 },
    { 48.561191, 11.680441 },
    { 48.560897, 11.680945 },
    { 48.560837, 11.680969 }
};

const Expectations expectations1 {
    { CayenneLPPPolyline::Prec0_0001, 0.0001, 686, 477, 439 },
    { CayenneLPPPolyline::Prec0_0002, 0.0002, 560, 283, 238 },
    { CayenneLPPPolyline::Prec0_0005, 0.0005, 402, 176, 120 },
    { CayenneLPPPolyline::Prec0_001,  0.001,  251, 115,  69 },
    { CayenneLPPPolyline::Prec0_002,  0.002,  150,  92,  42 },
    { CayenneLPPPolyline::Prec0_005,  0.005,   68,  46,  20 },
    { CayenneLPPPolyline::Prec0_01,   0.01,    38,  28,  14 }
    // { CayenneLPPPolyline::Prec0_02,   0.02,    22,  17,  12 },
    // { CayenneLPPPolyline::Prec0_05,   0.05,    13,  10,  10 },
    // { CayenneLPPPolyline::Prec0_1,    0.1,     11,  11,   9 },
    // { CayenneLPPPolyline::Prec0_2,    0.2,      8,   8,   8 },
    // { CayenneLPPPolyline::Prec0_5,    0.5,      8,   8,   8 },
    // { CayenneLPPPolyline::Prec1_0,    1.0,      8,   8,   8 }
};

const SampleData sampleData2 {
    { 53.007645, 0.08461 },
    { 53.007374, 0.084953 },
    { 53.007277, 0.084953 },
    { 53.006999, 0.084492 },
    { 53.006883, 0.084106 },
    { 53.007045, 0.083955 },
    { 53.007129, 0.083773 },
    { 53.007144, 0.083697 },
    { 53.00718, 0.083515 },
    { 53.0072, 0.083215 },
    { 53.007116, 0.082571 },
    { 53.006993, 0.082056 },
    { 53.00689, 0.081606 },
    { 53.006819, 0.081144 },
    { 53.006722, 0.080769 },
    { 53.006586, 0.080318 },
    { 53.006554, 0.080018 },
    { 53.00656, 0.079696 },
    { 53.006522, 0.078934 },
    { 53.006393, 0.077475 },
    { 53.006251, 0.076145 },
    { 53.006096, 0.07519 },
    { 53.005915, 0.074364 },
    { 53.005618, 0.072883 },
    { 53.005534, 0.0724 },
    { 53.005547, 0.072261 },
    { 53.006038, 0.071006 },
    { 53.006638, 0.069181 },
    { 53.006658, 0.069127 },
    { 53.006774, 0.068806 },
    { 53.00729, 0.067561 },
    { 53.008071, 0.065952 },
    { 53.008291, 0.065394 },
    { 53.008523, 0.064375 },
    { 53.008601, 0.06415 },
    { 53.008717, 0.063967 },
    { 53.008859, 0.063892 },
    { 53.010595, 0.063613 },
    { 53.010866, 0.063592 },
    { 53.010995, 0.063538 },
    { 53.012357, 0.062777 },
    { 53.012878, 0.062529 },
    { 53.013044, 0.062435 },
    { 53.013141, 0.062242 },
    { 53.013139, 0.062039 },
    { 53.013092, 0.061652 },
    { 53.012892, 0.057856 },
    { 53.012905, 0.057103 },
    { 53.012684, 0.052789 },
    { 53.01258, 0.0514 },
    { 53.012512, 0.051216 },
    { 53.012418, 0.051103 },
    { 53.012245, 0.051125 },
    { 53.01096, 0.051499 },
    { 53.010851, 0.051466 },
    { 53.010771, 0.05142 },
    { 53.010686, 0.05119 },
    { 53.010352, 0.050155 },
    { 53.010089, 0.049186 },
    { 53.009983, 0.048679 },
    { 53.009902, 0.048202 },
    { 53.009812, 0.047117 },
    { 53.00973, 0.046143 },
    { 53.009364, 0.043948 },
    { 53.009041, 0.042564 },
    { 53.008656, 0.041473 },
    { 53.008575, 0.041125 },
    { 53.008484, 0.040529 },
    { 53.008338, 0.039949 },
    { 53.007624, 0.038081 },
    { 53.00747, 0.037475 },
    { 53.007461, 0.037252 },
    { 53.007352, 0.037207 },
    { 53.007357, 0.036993 },
    { 53.007382, 0.036589 },
    { 53.007338, 0.036416 },
    { 53.007237, 0.036218 },
    { 53.007104, 0.036035 },
    { 53.006938, 0.035672 },
    { 53.006713, 0.034901 },
    { 53.006498, 0.033976 },
    { 53.00634, 0.033012 },
    { 53.005977, 0.032057 },
    { 53.005418, 0.031041 },
    { 53.005139, 0.030379 },
    { 53.00471, 0.02918 },
    { 53.004631, 0.028603 },
    { 53.004628, 0.027635 },
    { 53.004549, 0.027261 },
    { 53.004278, 0.026546 },
    { 53.004025, 0.025821 },
    { 53.003934, 0.025406 },
    { 53.003884, 0.024996 },
    { 53.003836, 0.024335 },
    { 53.00383, 0.024236 },
    { 53.003826, 0.024114 },
    { 53.003742, 0.024041 },
    { 53.003705, 0.023998 },
    { 53.003652, 0.023958 },
    { 53.003109, 0.024214 },
    { 53.002428, 0.024418 },
    { 53.002189, 0.02449 },
    { 53.002112, 0.024513 },
    { 53.000724, 0.024902 },
    { 53.00038, 0.024999 },
    { 52.999643, 0.024955 },
    { 52.99919, 0.025013 },
    { 52.998564, 0.025225 },
    { 52.997838, 0.025565 },
    { 52.99498, 0.027034 },
    { 52.994662, 0.027147 },
    { 52.994096, 0.027348 },
    { 52.994007, 0.027435 },
    { 52.993913, 0.02766 },
    { 52.993826, 0.02802 },
    { 52.993748, 0.028338 },
    { 52.993662, 0.028248 },
    { 52.993355, 0.028085 },
    { 52.993301, 0.028102 },
    { 52.993326, 0.028005 },
    { 52.995483, 0.017839 },
    { 52.995504, 0.017606 },
    { 52.995434, 0.017209 },
    { 52.993549, 0.01501 },
    { 52.993517, 0.014974 },
    { 52.992852, 0.014176 },
    { 52.991816, 0.012877 },
    { 52.990825, 0.011378 },
    { 52.99024, 0.010392 },
    { 52.99007, 0.010184 },
    { 52.989845, 0.009991 },
    { 52.989642, 0.009769 },
    { 52.989385, 0.009307 },
    { 52.98917, 0.008883 },
    { 52.989142, 0.008798 },
    { 52.989126, 0.008701 },
    { 52.989008, 0.008661 },
    { 52.988696, 0.008549 },
    { 52.988461, 0.008527 },
    { 52.988267, 0.008528 },
    { 52.987551, 0.008642 },
    { 52.987186, 0.008637 },
    { 52.986912, 0.008503 },
    { 52.986511, 0.00824 },
    { 52.986497, 0.008233 },
    { 52.986622, 0.007557 },
    { 52.98664, 0.007227 },
    { 52.986622, 0.006545 },
    { 52.986663, 0.006025 },
    { 52.986774, 0.005061 },
    { 52.986834, 0.004706 },
    { 52.986924, 0.004157 },
    { 52.987144, 0.002848 },
    { 52.987149, 0.00282 },
    { 52.987304, 0.001927 },
    { 52.987335, 0.00195 },
    { 52.9874, 0.001592 },
    { 52.987417, 0.001499 },
    { 52.987435, 0.001399 },
    { 52.987452, 0.001311 },
    { 52.98746, 0.001275 },
    { 52.98749, 0.000966 },
    { 52.987751, -0.00032 },
    { 52.98811, -0.002033 },
    { 52.988263, -0.00257 },
    { 52.988326, -0.002823 },
    { 52.988338, -0.002865 },
    { 52.988479, -0.003416 },
    { 52.988562, -0.004132 },
    { 52.988582, -0.004204 },
    { 52.988609, -0.004326 },
    { 52.988548, -0.004365 },
    { 52.9885, -0.004394 },
    { 52.988465, -0.004422 },
    { 52.988503, -0.004621 },
    { 52.988431, -0.004824 },
    { 52.988389, -0.005069 },
    { 52.988362, -0.005126 },
    { 52.988317, -0.00515 },
    { 52.987969, -0.005301 },
    { 52.987866, -0.005347 },
    { 52.987843, -0.005382 },
    { 52.987794, -0.005604 },
    { 52.987781, -0.005659 },
    { 52.987768, -0.005717 },
    { 52.987683, -0.00593 },
    { 52.987552, -0.006093 },
    { 52.987509, -0.006122 },
    { 52.987479, -0.006141 },
    { 52.987409, -0.006167 },
    { 52.987335, -0.006171 },
    { 52.987305, -0.006173 },
    { 52.987112, -0.006157 },
    { 52.986966, -0.006229 },
    { 52.986701, -0.006455 },
    { 52.986626, -0.00654 },
    { 52.986486, -0.006374 },
    { 52.986424, -0.006397 },
    { 52.986198, -0.006528 },
    { 52.986022, -0.006574 },
    { 52.98596, -0.006559 },
    { 52.985752, -0.006398 },
    { 52.985512, -0.006099 },
    { 52.985261, -0.005647 },
    { 52.98503, -0.005154 },
    { 52.984962, -0.00496 },
    { 52.98491, -0.004748 },
    { 52.984849, -0.004663 },
    { 52.98476, -0.004662 },
    { 52.984113, -0.004884 },
    { 52.984013, -0.004969 },
    { 52.983974, -0.005047 },
    { 52.983929, -0.005197 },
    { 52.983891, -0.005172 },
    { 52.983851, -0.005167 },
    { 52.98381, -0.005187 },
    { 52.983743, -0.005296 },
    { 52.983687, -0.005509 },
    { 52.983538, -0.006895 },
    { 52.983514, -0.006964 },
    { 52.983491, -0.006999 },
    { 52.983461, -0.007018 },
    { 52.983105, -0.007051 },
    { 52.982883, -0.007076 },
    { 52.982701, -0.007088 },
    { 52.982362, -0.007017 },
    { 52.982297, -0.007019 },
    { 52.982252, -0.007533 },
    { 52.9822, -0.008094 },
    { 52.982109, -0.009158 },
    { 52.982051, -0.009837 },
    { 52.98202, -0.010076 },
    { 52.98197, -0.010164 },
    { 52.981873, -0.01019 },
    { 52.98155, -0.010189 },
    { 52.981103, -0.01018 },
    { 52.981103, -0.009839 },
    { 52.981092, -0.009468 },
    { 52.98095, -0.00948 },
    { 52.980739, -0.009482 },
    { 52.978823, -0.009181 },
    { 52.97819, -0.009081 },
    { 52.978172, -0.009551 },
    { 52.978156, -0.009911 },
    { 52.978052, -0.011381 },
    { 52.977989, -0.011812 },
    { 52.977981, -0.011879 },
    { 52.97781, -0.011965 },
    { 52.977791, -0.011865 },
    { 52.977691, -0.011907 },
    { 52.977243, -0.012075 },
    { 52.976994, -0.012171 },
    { 52.977038, -0.012495 },
    { 52.977097, -0.01294 },
    { 52.977019, -0.012911 },
    { 52.977027, -0.013213 },
    { 52.977033, -0.013353 },
    { 52.976938, -0.013458 },
    { 52.976725, -0.013705 },
    { 52.976622, -0.013832 },
    { 52.976414, -0.014077 },
    { 52.976373, -0.014111 },
    { 52.976465, -0.014375 },
    { 52.976291, -0.014348 },
    { 52.974887, -0.014146 },
    { 52.974873, -0.014138 },
    { 52.97485, -0.014145 },
    { 52.974802, -0.014139 },
    { 52.974789, -0.014137 },
    { 52.974766, -0.014639 },
    { 52.974765, -0.014655 },
    { 52.974771, -0.014663 },
    { 52.97486, -0.014675 },
    { 52.974879, -0.014795 },
    { 52.974965, -0.015228 },
    { 52.974975, -0.015285 },
    { 52.974982, -0.015322 },
    { 52.97512, -0.015986 },
    { 52.97512, -0.016096 },
    { 52.975159, -0.016111 },
    { 52.975144, -0.016541 },
    { 52.975124, -0.017092 },
    { 52.975098, -0.017687 },
    { 52.975023, -0.019437 },
    { 52.97497, -0.020586 },
    { 52.974947, -0.021082 },
    { 52.974904, -0.021072 },
    { 52.974889, -0.02124 },
    { 52.974813, -0.02213 },
    { 52.9748, -0.022305 },
    { 52.974821, -0.022322 },
    { 52.974814, -0.022403 },
    { 52.974792, -0.022578 },
    { 52.974787, -0.022706 },
    { 52.974823, -0.022716 },
    { 52.974867, -0.02273 },
    { 52.974878, -0.022734 },
    { 52.974869, -0.02284 },
    { 52.974881, -0.022843 },
    { 52.974912, -0.02285 },
    { 52.97495, -0.022861 },
    { 52.974956, -0.022879 },
    { 52.974985, -0.022944 },
    { 52.974994, -0.022956 },
    { 52.974983, -0.023027 },
    { 52.974976, -0.023073 },
    { 52.974952, -0.023067 },
    { 52.974947, -0.023104 },
    { 52.974973, -0.023108 },
    { 52.97497, -0.023146 },
    { 52.974963, -0.02321 },
    { 52.974958, -0.02321 },
    { 52.974907, -0.023233 },
    { 52.974843, -0.023549 },
    { 52.974787, -0.02381 },
    { 52.974648, -0.024381 },
    { 52.974612, -0.024514 },
    { 52.974569, -0.024726 },
    { 52.974553, -0.024812 },
    { 52.974504, -0.024831 },
    { 52.974455, -0.025134 },
    { 52.974408, -0.025104 },
    { 52.97443, -0.024971 },
    { 52.974388, -0.024953 },
    { 52.97432, -0.024947 },
    { 52.974308, -0.025006 },
    { 52.974287, -0.024976 },
    { 52.974224, -0.02494 },
    { 52.974022, -0.025008 },
    { 52.973998, -0.025017 },
    { 52.973866, -0.02505 },
    { 52.973781, -0.025059 },
    { 52.973728, -0.025047 },
    { 52.973621, -0.025005 },
    { 52.973424, -0.024917 },
    { 52.973153, -0.024851 },
    { 52.97301, -0.024831 },
    { 52.972795, -0.02481 },
    { 52.972584, -0.02481 },
    { 52.972473, -0.024833 },
    { 52.972199, -0.024904 },
    { 52.972033, -0.024953 },
    { 52.971988, -0.024972 },
    { 52.971961, -0.024984 },
    { 52.971873, -0.025034 },
    { 52.971584, -0.02524 },
    { 52.971199, -0.02552 },
    { 52.97086, -0.025807 },
    { 52.970787, -0.025869 },
    { 52.970605, -0.026011 },
    { 52.97044, -0.026125 },
    { 52.970304, -0.026199 },
    { 52.969837, -0.02633 },
    { 52.969592, -0.02636 },
    { 52.969541, -0.026369 },
    { 52.969053, -0.026451 },
    { 52.968528, -0.026504 },
    { 52.968385, -0.026459 },
    { 52.968045, -0.026274 },
    { 52.967944, -0.026228 },
    { 52.967938, -0.026283 },
    { 52.967927, -0.026375 },
    { 52.967858, -0.026373 },
    { 52.967838, -0.026372 },
    { 52.967395, -0.026176 },
    { 52.967375, -0.02616 },
    { 52.96731, -0.026143 },
    { 52.967213, -0.026116 },
    { 52.967193, -0.026114 },
    { 52.967129, -0.02611 },
    { 52.966755, -0.026247 },
    { 52.966526, -0.026345 },
    { 52.966501, -0.026266 },
    { 52.966423, -0.026287 },
    { 52.966227, -0.026292 },
    { 52.966158, -0.026304 },
    { 52.966135, -0.026381 },
    { 52.96611, -0.026398 },
    { 52.966087, -0.026408 },
    { 52.966067, -0.026415 },
    { 52.966039, -0.026382 },
    { 52.965997, -0.026414 },
    { 52.965935, -0.026512 },
    { 52.965774, -0.026927 },
    { 52.965663, -0.027136 },
    { 52.965581, -0.02727 },
    { 52.965532, -0.0273 },
    { 52.965456, -0.027315 },
    { 52.965291, -0.027312 },
    { 52.965199, -0.027291 },
    { 52.965073, -0.027262 },
    { 52.964579, -0.027165 },
    { 52.964136, -0.027063 },
    { 52.964062, -0.027023 },
    { 52.963972, -0.026992 },
    { 52.963945, -0.026873 },
    { 52.963896, -0.026813 },
    { 52.963833, -0.026785 },
    { 52.963887, -0.02658 },
    { 52.963803, -0.026522 },
    { 52.963686, -0.026734 },
    { 52.963573, -0.026834 },
    { 52.963058, -0.026987 },
    { 52.962886, -0.026999 },
    { 52.962759, -0.027011 },
    { 52.962321, -0.027053 },
    { 52.961802, -0.027166 },
    { 52.961761, -0.027149 },
    { 52.961388, -0.027223 },
    { 52.961341, -0.027388 },
    { 52.96084, -0.027542 },
    { 52.960466, -0.027697 },
    { 52.959588, -0.028166 },
    { 52.959539, -0.028167 },
    { 52.95942, -0.028268 },
    { 52.959388, -0.028287 },
    { 52.95939, -0.028297 },
    { 52.958568, -0.028863 },
    { 52.958136, -0.029199 },
    { 52.958115, -0.029221 },
    { 52.958123, -0.029254 },
    { 52.958117, -0.029258 },
    { 52.958124, -0.029284 },
    { 52.958134, -0.029318 },
    { 52.958138, -0.02933 },
    { 52.958142, -0.029345 },
    { 52.958152, -0.029376 },
    { 52.958159, -0.029401 },
    { 52.957909, -0.029594 },
    { 52.957725, -0.029778 },
    { 52.957686, -0.0299 },
    { 52.957686, -0.029907 },
    { 52.957659, -0.029925 },
    { 52.95764, -0.029938 },
    { 52.957632, -0.029944 },
    { 52.957621, -0.029953 },
    { 52.957566, -0.030019 },
    { 52.957561, -0.030029 },
    { 52.957536, -0.03008 },
    { 52.957451, -0.03017 },
    { 52.957436, -0.030182 },
    { 52.957413, -0.0302 },
    { 52.957152, -0.0304 },
    { 52.956942, -0.030594 },
    { 52.95606, -0.031288 },
    { 52.955937, -0.031346 },
    { 52.95586, -0.031413 },
    { 52.955723, -0.031566 },
    { 52.955605, -0.031764 },
    { 52.955586, -0.031852 },
    { 52.95552, -0.031866 },
    { 52.955422, -0.031971 },
    { 52.955375, -0.032028 },
    { 52.955335, -0.031936 },
    { 52.955304, -0.031896 },
    { 52.955275, -0.031897 },
    { 52.954981, -0.032123 },
    { 52.954835, -0.032267 },
    { 52.95479, -0.032384 },
    { 52.954054, -0.032969 },
    { 52.953804, -0.033139 },
    { 52.953648, -0.033064 },
    { 52.953309, -0.033256 },
    { 52.953308, -0.033456 },
    { 52.952632, -0.033942 },
    { 52.951727, -0.034651 },
    { 52.951627, -0.034685 },
    { 52.951651, -0.034827 },
    { 52.95174, -0.035406 },
    { 52.951794, -0.03576 },
    { 52.951838, -0.036127 },
    { 52.951876, -0.036481 },
    { 52.951901, -0.03679 },
    { 52.951921, -0.037042 },
    { 52.951953, -0.037282 },
    { 52.952027, -0.037791 },
    { 52.952092, -0.038129 },
    { 52.95249, -0.039545 },
    { 52.952611, -0.040138 },
    { 52.952633, -0.040385 },
    { 52.952648, -0.041463 },
    { 52.952773, -0.041495 },
    { 52.952814, -0.04154 },
    { 52.952908, -0.041881 },
    { 52.952942, -0.041944 },
    { 52.952991, -0.04197 },
    { 52.953037, -0.041952 },
    { 52.953001, -0.042147 },
    { 52.953014, -0.04218 },
    { 52.952903, -0.042334 },
    { 52.952772, -0.042513 },
    { 52.952455, -0.042939 },
    { 52.9524, -0.042992 },
    { 52.952342, -0.042871 },
    { 52.952243, -0.04297 },
    { 52.95214, -0.043098 },
    { 52.952099, -0.043209 },
    { 52.952015, -0.043316 },
    { 52.951837, -0.043453 },
    { 52.951628, -0.043726 },
    { 52.951416, -0.044002 },
    { 52.951374, -0.044071 },
    { 52.951344, -0.04413 },
    { 52.951291, -0.044235 },
    { 52.950563, -0.045177 },
    { 52.950448, -0.045324 },
    { 52.950414, -0.04532 },
    { 52.950367, -0.045398 },
    { 52.950339, -0.045683 },
    { 52.949712, -0.046417 },
    { 52.948554, -0.047668 },
    { 52.947477, -0.049091 },
    { 52.94738, -0.049187 },
    { 52.94731, -0.049334 },
    { 52.946651, -0.050203 },
    { 52.9465, -0.050379 },
    { 52.946243, -0.050605 },
    { 52.946044, -0.050761 },
    { 52.945535, -0.051147 },
    { 52.944455, -0.052037 },
    { 52.944232, -0.052252 },
    { 52.943214, -0.053419 },
    { 52.941565, -0.055079 },
    { 52.941208, -0.055366 },
    { 52.940673, -0.055739 },
    { 52.94, -0.056176 },
    { 52.939642, -0.056355 },
    { 52.93959, -0.05648 },
    { 52.939032, -0.056781 },
    { 52.938494, -0.05707 },
    { 52.937865, -0.057351 },
    { 52.937139, -0.057773 },
    { 52.936872, -0.057329 },
    { 52.936654, -0.05699 },
    { 52.936375, -0.056551 },
    { 52.935909, -0.055848 },
    { 52.935398, -0.054951 },
    { 52.934825, -0.054095 },
    { 52.934633, -0.053743 },
    { 52.934327, -0.05299 },
    { 52.933422, -0.054261 },
    { 52.933313, -0.0544 },
    { 52.933209, -0.054503 },
    { 52.933162, -0.05453 },
    { 52.933078, -0.054578 },
    { 52.932847, -0.054629 },
    { 52.932729, -0.054619 },
    { 52.932601, -0.054576 },
    { 52.932466, -0.054479 },
    { 52.932131, -0.054206 },
    { 52.931795, -0.053907 },
    { 52.931531, -0.053711 },
    { 52.931116, -0.053446 },
    { 52.93091, -0.053331 },
    { 52.930515, -0.053038 },
    { 52.930467, -0.05302 },
    { 52.930373, -0.052984 },
    { 52.930264, -0.053018 },
    { 52.930195, -0.053081 },
    { 52.930037, -0.053321 },
    { 52.929849, -0.053522 },
    { 52.929787, -0.05356 },
    { 52.929716, -0.053602 },
    { 52.929588, -0.053704 },
    { 52.929505, -0.0538 },
    { 52.929358, -0.054068 },
    { 52.929288, -0.054149 },
    { 52.929052, -0.054334 },
    { 52.92895, -0.054366 },
    { 52.92885, -0.054358 },
    { 52.928701, -0.054281 },
    { 52.928639, -0.054293 },
    { 52.928565, -0.054329 },
    { 52.928534, -0.05441 },
    { 52.928491, -0.054588 },
    { 52.928453, -0.054679 },
    { 52.928156, -0.054977 },
    { 52.927959, -0.055109 },
    { 52.927811, -0.055243 },
    { 52.927378, -0.055682 },
    { 52.927583, -0.056132 },
    { 52.927285, -0.056459 },
    { 52.927256, -0.056558 },
    { 52.927077, -0.056891 },
    { 52.92703, -0.05686 },
    { 52.926975, -0.056869 },
    { 52.926931, -0.056906 },
    { 52.926857, -0.057021 },
    { 52.926887, -0.057104 },
    { 52.926738, -0.057372 },
    { 52.92666, -0.057576 },
    { 52.926544, -0.057705 },
    { 52.926317, -0.057276 },
    { 52.925739, -0.058086 },
    { 52.925095, -0.059247 },
    { 52.925029, -0.059325 },
    { 52.924956, -0.059365 },
    { 52.924833, -0.059389 },
    { 52.924708, -0.05943 },
    { 52.924598, -0.059534 },
    { 52.924514, -0.059638 },
    { 52.924461, -0.059818 },
    { 52.924309, -0.060372 },
    { 52.924241, -0.060654 },
    { 52.92418, -0.060814 },
    { 52.924104, -0.060916 },
    { 52.92401, -0.06098 },
    { 52.923627, -0.06102 },
    { 52.923536, -0.061074 },
    { 52.923323, -0.061331 },
    { 52.922829, -0.061602 },
    { 52.922947, -0.062292 },
    { 52.923058, -0.06278 },
    { 52.923125, -0.063015 }
};

const Expectations expectations2 {
    { CayenneLPPPolyline::Prec0_0001, 0.0001, 664, 491, 439 },
    { CayenneLPPPolyline::Prec0_0002, 0.0002, 497, 290, 247 },
    { CayenneLPPPolyline::Prec0_0005, 0.0005, 327, 153, 111 },
    { CayenneLPPPolyline::Prec0_001,  0.001,  228, 120,  64 },
    { CayenneLPPPolyline::Prec0_002,  0.002,  149,  93,  37 },
    { CayenneLPPPolyline::Prec0_005,  0.005,   67,  45,  25 },
    { CayenneLPPPolyline::Prec0_01,   0.01,    45,  37,  18 }
    // { CayenneLPPPolyline::Prec0_02,   0.02,    22,  18,  11 },
    // { CayenneLPPPolyline::Prec0_05,   0.05,    23,  20,  10 },
    // { CayenneLPPPolyline::Prec0_1,    0.1,     11,  11,   9 },
    // { CayenneLPPPolyline::Prec0_2,    0.2,      8,   8,   8 },
    // { CayenneLPPPolyline::Prec0_5,    0.5,      8,   8,   8 },
    // { CayenneLPPPolyline::Prec1_0,    1.0,      8,   8,   8 }
};

TEST_CASE("Coordinates within precision", "[LppPolyline]") {
    std::vector<std::pair<double, double>> coords {
        { 12.0, -13.0 },
        { 12.01, -13.01 }
    };

    CayenneLPPPolyline polyline(255);
    auto buffer = polyline.encode(coords, CayenneLPPPolyline::Prec0_01);
    auto stats = polyline.getEncodeStats();
    auto out = polyline.decode(buffer);

    REQUIRE(buffer.size() == 9);
    REQUIRE(stats.keptCoords == 1);
    REQUIRE(stats.addedCoords == 0);
    REQUIRE(stats.removedCoords == 0);
    REQUIRE(out == coords);
}

TEST_CASE("Coordinates out of precision", "[LppPolyline]") {
    std::vector<std::pair<double, double>> coords {
        { -12.0, -13.0 },
        { -12.01, -13.01 }
    };

    CayenneLPPPolyline polyline(255);
    auto buffer = polyline.encode(coords, CayenneLPPPolyline::Prec0_02);
    auto stats = polyline.getEncodeStats();
    auto out = polyline.decode(buffer);

    REQUIRE(buffer.size() == 9);
    REQUIRE(stats.keptCoords == 1);
    REQUIRE(stats.addedCoords == 0);
    REQUIRE(stats.removedCoords == 0);
    REQUIRE(out.front() == coords.front());
    REQUIRE(out.back() == std::pair<double, double> { -12.02, -13.02 });
}

TEST_CASE("Coordinates kept", "[LppPolyline]") {
    std::vector<std::pair<double, double>> coords {
        { 12.0, -13.0 },
        { 12.005, -13.005 }
    };

    CayenneLPPPolyline polyline(255);
    auto buffer = polyline.encode(coords, CayenneLPPPolyline::Prec0_01);
    auto stats = polyline.getEncodeStats();
    auto out = polyline.decode(buffer);

    REQUIRE(buffer.size() == 9);
    REQUIRE(stats.keptCoords == 1);
    REQUIRE(stats.addedCoords == 0);
    REQUIRE(stats.removedCoords == 0);
    REQUIRE(out.size() == 2);
}

TEST_CASE("Coordinates added", "[LppPolyline]") {
    std::vector<std::pair<double, double>> coords {
        { 14.0, 78.0 },
        { 14.08, 78.08 }
    };

    CayenneLPPPolyline polyline(255);
    auto buffer = polyline.encode(coords, CayenneLPPPolyline::Prec0_01);
    auto stats = polyline.getEncodeStats();
    auto out = polyline.decode(buffer);

    REQUIRE(buffer.size() == 10);
    REQUIRE(stats.keptCoords == 1);
    REQUIRE(stats.addedCoords == 1);
    REQUIRE(stats.removedCoords == 0);
    REQUIRE(out.size() == 3);
    REQUIRE(out.at(1) == std::pair<double, double> { 14.04, 78.04 });
}

TEST_CASE("Coordinates removed", "[LppPolyline]") {
    std::vector<std::pair<double, double>> coords {
        { 78.0, -12.0 },
        { 78.024, -12.024 }
    };

    CayenneLPPPolyline polyline(255);
    auto buffer = polyline.encode(coords, CayenneLPPPolyline::Prec0_05);
    auto stats = polyline.getEncodeStats();
    auto out = polyline.decode(buffer);

    REQUIRE(buffer.size() == 8);
    REQUIRE(stats.keptCoords == 0);
    REQUIRE(stats.addedCoords == 0);
    REQUIRE(stats.removedCoords == 1);
    REQUIRE(out.size() == 1);
}

TEST_CASE("Encode sample data", "[LppPolyline]") {
    const auto i = GENERATE(std::tuple<std::string, SampleData, Expectations>("sample1", sampleData1, expectations1),
                            std::tuple<std::string, SampleData, Expectations>("sample2", sampleData2, expectations2));
    const auto j = GENERATE(CayenneLPPPolyline::None,
                            CayenneLPPPolyline::PerpendicularDistance,
                            CayenneLPPPolyline::DouglasPeucker);

    CayenneLPPPolyline polyline(65535);

    // Iterate test data sets
    for (const auto& exp : std::get<2>(i)) {
        std::vector<uint8_t> buffer;
        //BENCHMARK("Encode " + std::get<0>(i)
        //          + " with precision " + std::to_string(std::get<1>(exp))
        //          + " and simplification " + std::to_string(j)) {
            buffer = polyline.encode(std::get<1>(i), std::get<0>(exp), j);
        //};
        //auto stats = polyline.getEncodeStats();
        //WARN("Polyine(" << std::get<0>(exp.second) << ") kept: " << stats.keptCoords
        //     << ", removed: " << stats.removedCoords
        //     << ", added: " << stats.addedCoords
        //     << " coordinates");
        //WARN("Size: " << buffer.size());
        const auto out = polyline.decode(buffer);
        REQUIRE(buffer.size() == ((j == CayenneLPPPolyline::None) ?
                    std::get<2>(exp) : (j == CayenneLPPPolyline::PerpendicularDistance) ?
                        std::get<3>(exp) : std::get<4>(exp)));
        REQUIRE(abs(std::get<1>(i).front().first - out.front().first) <= std::get<1>(exp) / 2.0);
        REQUIRE(abs(std::get<1>(i).front().second - out.front().second) <= std::get<1>(exp) / 2.0);
        REQUIRE(abs(std::get<1>(i).back().first - out.back().first) <= std::get<1>(exp) / 2.0);
        REQUIRE(abs(std::get<1>(i).back().second - out.back().second) <= std::get<1>(exp) / 2.0);

        //std::ofstream myfile;
        //myfile.open("lpp_" + std::get<0>(i) + "_"
        //            + std::to_string(std::get<1>(exp)) + ".txt");
        //for (const auto& c : out) {
        //    myfile << std::to_string(c.first) << ", " << std::to_string(c.second) << std::endl;
        //}
        //myfile.close();
    }
}

TEST_CASE("Polyline fits in buffer", "[LppPolyline]") {
    CayenneLPP lpp(16);
    REQUIRE(lpp.addColour(1, 2, 3, 4) == 5);
    REQUIRE(lpp.addPolyline(2, { { 13.0001, 12.0001 }, { 13.0002, 12.0002 } }) == 16);
    REQUIRE(lpp.getError() == LPP_ERROR_OK);
}

TEST_CASE("Polyline exceeds buffer", "[LppPolyline]") {
    CayenneLPP lpp(15);
    REQUIRE(lpp.addColour(1, 2, 3, 4) == 5);
    REQUIRE(lpp.addPolyline(2, { { 13.0001, 12.0001 }, { 13.0002, 12.0002 } }) == 0);
    REQUIRE(lpp.getError() == LPP_ERROR_OVERFLOW);
}

TEST_CASE("Decode polyline from message", "[LppPolyline]") {
    CayenneLPP lpp(16);
    REQUIRE(lpp.addColour(1, 2, 3, 4) == 5);
    std::vector<std::pair<double, double>> coords {
        { 13.0001, 12.0001 },
        { 13.0002, 12.0002 }
    };
    REQUIRE(lpp.addPolyline(2, coords) == 16);

    const std::vector<uint8_t> buffer(lpp.getBuffer(), lpp.getBuffer()+lpp.getSize());
    std::map<uint8_t, CayenneLPPMessage> messages;
    REQUIRE(lpp.decode(lpp.getBuffer(), lpp.getSize(), messages) == 2);
    REQUIRE(messages.at(2).polyline == coords);
}
