/******************************************************************************
The MIT License(MIT)

Embedded Template Library.
https://github.com/ETLCPP/etl
https://www.etlcpp.com

Copyright(c) 2018 John Wellbelove

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files(the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions :

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
******************************************************************************/

#ifndef ETL_TYPE_SELECT_INCLUDED
#define ETL_TYPE_SELECT_INCLUDED

#include "platform.h"
#include "static_assert.h"
#include "type_traits.h"
#include "null_type.h"

#if 0
#error THIS HEADER IS A GENERATOR. DO NOT INCLUDE.
#endif

//***************************************************************************
// THIS FILE HAS BEEN AUTO GENERATED. DO NOT EDIT THIS FILE.
//***************************************************************************

namespace etl
{
#if ETL_USING_CPP11 && !defined(ETL_TYPE_SELECT_FORCE_CPP03_IMPLEMENTATION)
  //***************************************************************************
  // Variadic version.
  //***************************************************************************
  template <typename... TTypes>
  struct type_select
  {
  private:

    //***********************************
    template <size_t Id, size_t Index, typename T1, typename... TRest>
    struct type_select_helper
    {
      using type = typename etl::conditional<Id == Index,
                                             T1,
                                             typename type_select_helper<Id, Index + 1, TRest...>::type>::type;
    };

    //***********************************
    template <size_t Id, size_t Index, typename T1>
    struct type_select_helper<Id, Index, T1>
    {
      using type = T1;
    };

  public:

    template <size_t Id>
    struct select
    {
      static_assert(Id < sizeof...(TTypes), "Illegal type_select::select index");

      using type = typename type_select_helper<Id, 0, TTypes...>::type;
    };

    template <size_t Id>
    using select_t = typename select<Id>::type;
  };

  //***************************************************************************
  // Select type alias
  //***************************************************************************
  template <size_t Index, typename... TTypes>
  using type_select_t = typename etl::type_select<TTypes...>:: template select_t<Index>;

#else

  //***************************************************************************
  // For 16 types.
  //***************************************************************************
  template <typename T0,
            typename T1 = void,
            typename T2 = void,
            typename T3 = void,
            typename T4 = void,
            typename T5 = void,
            typename T6 = void,
            typename T7 = void,
            typename T8 = void,
            typename T9 = void,
            typename T10 = void,
            typename T11 = void,
            typename T12 = void,
            typename T13 = void,
            typename T14 = void,
            typename T15 = void>
  struct type_select
  {
  public:

    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              typename etl::conditional<Id == 9, T9,
              typename etl::conditional<Id == 10, T10,
              typename etl::conditional<Id == 11, T11,
              typename etl::conditional<Id == 12, T12,
              typename etl::conditional<Id == 13, T13,
              typename etl::conditional<Id == 14, T14,
              typename etl::conditional<Id == 15, T15,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type>::type>::type>::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 16, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 15 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7, 
            typename T8, 
            typename T9, 
            typename T10, 
            typename T11, 
            typename T12, 
            typename T13, 
            typename T14>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              typename etl::conditional<Id == 9, T9,
              typename etl::conditional<Id == 10, T10,
              typename etl::conditional<Id == 11, T11,
              typename etl::conditional<Id == 12, T12,
              typename etl::conditional<Id == 13, T13,
              typename etl::conditional<Id == 14, T14,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type>::type>::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 15, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 14 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7, 
            typename T8, 
            typename T9, 
            typename T10, 
            typename T11, 
            typename T12, 
            typename T13>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              typename etl::conditional<Id == 9, T9,
              typename etl::conditional<Id == 10, T10,
              typename etl::conditional<Id == 11, T11,
              typename etl::conditional<Id == 12, T12,
              typename etl::conditional<Id == 13, T13,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type>::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 14, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 13 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7, 
            typename T8, 
            typename T9, 
            typename T10, 
            typename T11, 
            typename T12>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              typename etl::conditional<Id == 9, T9,
              typename etl::conditional<Id == 10, T10,
              typename etl::conditional<Id == 11, T11,
              typename etl::conditional<Id == 12, T12,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 13, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 12 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7, 
            typename T8, 
            typename T9, 
            typename T10, 
            typename T11>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              typename etl::conditional<Id == 9, T9,
              typename etl::conditional<Id == 10, T10,
              typename etl::conditional<Id == 11, T11,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 12, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 11 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7, 
            typename T8, 
            typename T9, 
            typename T10>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              typename etl::conditional<Id == 9, T9,
              typename etl::conditional<Id == 10, T10,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 11, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 10 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7, 
            typename T8, 
            typename T9>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7, T8, T9>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              typename etl::conditional<Id == 9, T9,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type>::type type;

      ETL_STATIC_ASSERT(Id < 10, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 9 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7, 
            typename T8>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7, T8>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              typename etl::conditional<Id == 8, T8,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type>
              ::type type;

      ETL_STATIC_ASSERT(Id < 9, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 8 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6, 
            typename T7>
  struct type_select<T0, T1, T2, T3, T4, T5, T6, T7>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              typename etl::conditional<Id == 7, T7,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 8, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 7 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5, 
            typename T6>
  struct type_select<T0, T1, T2, T3, T4, T5, T6>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              typename etl::conditional<Id == 6, T6,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 7, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 6 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4, 
            typename T5>
  struct type_select<T0, T1, T2, T3, T4, T5>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              typename etl::conditional<Id == 5, T5,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 6, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 5 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3, 
            typename T4>
  struct type_select<T0, T1, T2, T3, T4>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              typename etl::conditional<Id == 4, T4,
              etl::null_type<0> >
              ::type>::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 5, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 4 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2, 
            typename T3>
  struct type_select<T0, T1, T2, T3>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              typename etl::conditional<Id == 3, T3,
              etl::null_type<0> >
              ::type>::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 4, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 3 types.
  //***************************************************************************
  template <typename T0, 
            typename T1, 
            typename T2>
  struct type_select<T0, T1, T2>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              typename etl::conditional<Id == 2, T2,
              etl::null_type<0> >
              ::type>::type>::type type;

      ETL_STATIC_ASSERT(Id < 3, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 2 types.
  //***************************************************************************
  template <typename T0, 
            typename T1>
  struct type_select<T0, T1>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              typename etl::conditional<Id == 1, T1,
              etl::null_type<0> >
              ::type>::type type;

      ETL_STATIC_ASSERT(Id < 2, "Invalid Id");
    };
  };

  //***************************************************************************
  // For 1 types.
  //***************************************************************************
  template <typename T0>
  struct type_select<T0>
  {
  public:
    template <size_t Id>
    struct select
    {
      typedef typename etl::conditional<Id == 0, T0,
              etl::null_type<0> >
              ::type type;

      ETL_STATIC_ASSERT(Id < 1, "Invalid Id");
    };
  };
#endif
}

#endif
