///\file

/******************************************************************************
The MIT License(MIT)

Embedded Template Library.
https://github.com/ETLCPP/etl
https://www.etlcpp.com

Copyright(c) 2019 jwellbelove

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files(the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions :

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
******************************************************************************/

#ifndef ETL_CRC16_TABLE_POLY_0X42F0E1EBA9EA3693_INCLUDED
#define ETL_CRC16_TABLE_POLY_0X42F0E1EBA9EA3693_INCLUDED

#include <stdint.h>

#include "../platform.h"
#include "../frame_check_sequence.h"
#include "../binary.h"
#include "../iterator.h"

#if defined(ETL_COMPILER_KEIL)
#pragma diag_suppress 1300
#endif

///\defgroup crc64_poly 0x42F0E1EBA9EA3693 64 bit CRC Poly 0x42F0E1EBA9EA3693 calculation
///\ingroup crc

namespace etl
{
  //***************************************************************************
  /// Table and add value.
  //***************************************************************************
  class crc64_table_poly_0x42f0e1eba9ea3693
  {
  public:

    //*************************************************************************
    uint64_t add(uint64_t crc, uint8_t value) const
    {
      static const uint64_t table[256] =
      {
        0x0000000000000000, 0x42F0E1EBA9EA3693, 0x85E1C3D753D46D26, 0xC711223CFA3E5BB5, 0x493366450E42ECDF, 0x0BC387AEA7A8DA4C, 0xCCD2A5925D9681F9, 0x8E224479F47CB76A,
        0x9266CC8A1C85D9BE, 0xD0962D61B56FEF2D, 0x17870F5D4F51B498, 0x5577EEB6E6BB820B, 0xDB55AACF12C73561, 0x99A54B24BB2D03F2, 0x5EB4691841135847, 0x1C4488F3E8F96ED4,
        0x663D78FF90E185EF, 0x24CD9914390BB37C, 0xE3DCBB28C335E8C9, 0xA12C5AC36ADFDE5A, 0x2F0E1EBA9EA36930, 0x6DFEFF5137495FA3, 0xAAEFDD6DCD770416, 0xE81F3C86649D3285,
        0xF45BB4758C645C51, 0xB6AB559E258E6AC2, 0x71BA77A2DFB03177, 0x334A9649765A07E4, 0xBD68D2308226B08E, 0xFF9833DB2BCC861D, 0x388911E7D1F2DDA8, 0x7A79F00C7818EB3B,
        0xCC7AF1FF21C30BDE, 0x8E8A101488293D4D, 0x499B3228721766F8, 0x0B6BD3C3DBFD506B, 0x854997BA2F81E701, 0xC7B97651866BD192, 0x00A8546D7C558A27, 0x4258B586D5BFBCB4,
        0x5E1C3D753D46D260, 0x1CECDC9E94ACE4F3, 0xDBFDFEA26E92BF46, 0x990D1F49C77889D5, 0x172F5B3033043EBF, 0x55DFBADB9AEE082C, 0x92CE98E760D05399, 0xD03E790CC93A650A,
        0xAA478900B1228E31, 0xE8B768EB18C8B8A2, 0x2FA64AD7E2F6E317, 0x6D56AB3C4B1CD584, 0xE374EF45BF6062EE, 0xA1840EAE168A547D, 0x66952C92ECB40FC8, 0x2465CD79455E395B,
        0x3821458AADA7578F, 0x7AD1A461044D611C, 0xBDC0865DFE733AA9, 0xFF3067B657990C3A, 0x711223CFA3E5BB50, 0x33E2C2240A0F8DC3, 0xF4F3E018F031D676, 0xB60301F359DBE0E5,
        0xDA050215EA6C212F, 0x98F5E3FE438617BC, 0x5FE4C1C2B9B84C09, 0x1D14202910527A9A, 0x93366450E42ECDF0, 0xD1C685BB4DC4FB63, 0x16D7A787B7FAA0D6, 0x5427466C1E109645,
        0x4863CE9FF6E9F891, 0x0A932F745F03CE02, 0xCD820D48A53D95B7, 0x8F72ECA30CD7A324, 0x0150A8DAF8AB144E, 0x43A04931514122DD, 0x84B16B0DAB7F7968, 0xC6418AE602954FFB,
        0xBC387AEA7A8DA4C0, 0xFEC89B01D3679253, 0x39D9B93D2959C9E6, 0x7B2958D680B3FF75, 0xF50B1CAF74CF481F, 0xB7FBFD44DD257E8C, 0x70EADF78271B2539, 0x321A3E938EF113AA,
        0x2E5EB66066087D7E, 0x6CAE578BCFE24BED, 0xABBF75B735DC1058, 0xE94F945C9C3626CB, 0x676DD025684A91A1, 0x259D31CEC1A0A732, 0xE28C13F23B9EFC87, 0xA07CF2199274CA14,
        0x167FF3EACBAF2AF1, 0x548F120162451C62, 0x939E303D987B47D7, 0xD16ED1D631917144, 0x5F4C95AFC5EDC62E, 0x1DBC74446C07F0BD, 0xDAAD56789639AB08, 0x985DB7933FD39D9B,
        0x84193F60D72AF34F, 0xC6E9DE8B7EC0C5DC, 0x01F8FCB784FE9E69, 0x43081D5C2D14A8FA, 0xCD2A5925D9681F90, 0x8FDAB8CE70822903, 0x48CB9AF28ABC72B6, 0x0A3B7B1923564425,
        0x70428B155B4EAF1E, 0x32B26AFEF2A4998D, 0xF5A348C2089AC238, 0xB753A929A170F4AB, 0x3971ED50550C43C1, 0x7B810CBBFCE67552, 0xBC902E8706D82EE7, 0xFE60CF6CAF321874,
        0xE224479F47CB76A0, 0xA0D4A674EE214033, 0x67C58448141F1B86, 0x253565A3BDF52D15, 0xAB1721DA49899A7F, 0xE9E7C031E063ACEC, 0x2EF6E20D1A5DF759, 0x6C0603E6B3B7C1CA,
        0xF6FAE5C07D3274CD, 0xB40A042BD4D8425E, 0x731B26172EE619EB, 0x31EBC7FC870C2F78, 0xBFC9838573709812, 0xFD39626EDA9AAE81, 0x3A28405220A4F534, 0x78D8A1B9894EC3A7,
        0x649C294A61B7AD73, 0x266CC8A1C85D9BE0, 0xE17DEA9D3263C055, 0xA38D0B769B89F6C6, 0x2DAF4F0F6FF541AC, 0x6F5FAEE4C61F773F, 0xA84E8CD83C212C8A, 0xEABE6D3395CB1A19,
        0x90C79D3FEDD3F122, 0xD2377CD44439C7B1, 0x15265EE8BE079C04, 0x57D6BF0317EDAA97, 0xD9F4FB7AE3911DFD, 0x9B041A914A7B2B6E, 0x5C1538ADB04570DB, 0x1EE5D94619AF4648,
        0x02A151B5F156289C, 0x4051B05E58BC1E0F, 0x87409262A28245BA, 0xC5B073890B687329, 0x4B9237F0FF14C443, 0x0962D61B56FEF2D0, 0xCE73F427ACC0A965, 0x8C8315CC052A9FF6,
        0x3A80143F5CF17F13, 0x7870F5D4F51B4980, 0xBF61D7E80F251235, 0xFD913603A6CF24A6, 0x73B3727A52B393CC, 0x31439391FB59A55F, 0xF652B1AD0167FEEA, 0xB4A25046A88DC879,
        0xA8E6D8B54074A6AD, 0xEA16395EE99E903E, 0x2D071B6213A0CB8B, 0x6FF7FA89BA4AFD18, 0xE1D5BEF04E364A72, 0xA3255F1BE7DC7CE1, 0x64347D271DE22754, 0x26C49CCCB40811C7,
        0x5CBD6CC0CC10FAFC, 0x1E4D8D2B65FACC6F, 0xD95CAF179FC497DA, 0x9BAC4EFC362EA149, 0x158E0A85C2521623, 0x577EEB6E6BB820B0, 0x906FC95291867B05, 0xD29F28B9386C4D96,
        0xCEDBA04AD0952342, 0x8C2B41A1797F15D1, 0x4B3A639D83414E64, 0x09CA82762AAB78F7, 0x87E8C60FDED7CF9D, 0xC51827E4773DF90E, 0x020905D88D03A2BB, 0x40F9E43324E99428,
        0x2CFFE7D5975E55E2, 0x6E0F063E3EB46371, 0xA91E2402C48A38C4, 0xEBEEC5E96D600E57, 0x65CC8190991CB93D, 0x273C607B30F68FAE, 0xE02D4247CAC8D41B, 0xA2DDA3AC6322E288,
        0xBE992B5F8BDB8C5C, 0xFC69CAB42231BACF, 0x3B78E888D80FE17A, 0x7988096371E5D7E9, 0xF7AA4D1A85996083, 0xB55AACF12C735610, 0x724B8ECDD64D0DA5, 0x30BB6F267FA73B36,
        0x4AC29F2A07BFD00D, 0x08327EC1AE55E69E, 0xCF235CFD546BBD2B, 0x8DD3BD16FD818BB8, 0x03F1F96F09FD3CD2, 0x41011884A0170A41, 0x86103AB85A2951F4, 0xC4E0DB53F3C36767,
        0xD8A453A01B3A09B3, 0x9A54B24BB2D03F20, 0x5D45907748EE6495, 0x1FB5719CE1045206, 0x919735E51578E56C, 0xD367D40EBC92D3FF, 0x1476F63246AC884A, 0x568617D9EF46BED9,
        0xE085162AB69D5E3C, 0xA275F7C11F7768AF, 0x6564D5FDE549331A, 0x279434164CA30589, 0xA9B6706FB8DFB2E3, 0xEB46918411358470, 0x2C57B3B8EB0BDFC5, 0x6EA7525342E1E956,
        0x72E3DAA0AA188782, 0x30133B4B03F2B111, 0xF7021977F9CCEAA4, 0xB5F2F89C5026DC37, 0x3BD0BCE5A45A6B5D, 0x79205D0E0DB05DCE, 0xBE317F32F78E067B, 0xFCC19ED95E6430E8,
        0x86B86ED5267CDBD3, 0xC4488F3E8F96ED40, 0x0359AD0275A8B6F5, 0x41A94CE9DC428066, 0xCF8B0890283E370C, 0x8D7BE97B81D4019F, 0x4A6ACB477BEA5A2A, 0x089A2AACD2006CB9,
        0x14DEA25F3AF9026D, 0x562E43B4931334FE, 0x913F6188692D6F4B, 0xD3CF8063C0C759D8, 0x5DEDC41A34BBEEB2, 0x1F1D25F19D51D821, 0xD80C07CD676F8394, 0x9AFCE626CE85B507
      };

      return (crc << 8) ^ table[((crc >> 56) ^ value) & 0xFF];
    }
  };

  //***************************************************************************
  /// Table and add value.
  //***************************************************************************
  class crc64_table_poly_0x42f0e1eba9ea3693_reflected
  {
  public:

    //*************************************************************************
    uint64_t add(uint64_t crc, uint8_t value) const
    {
      static const uint64_t table[256] =
      {
        0x0000000000000000, 0xC96C5795D7870F42, 0x64B62BCAEBC387A1, 0xADDA7C5F3C4488E3, 0xFB374270A266CC92, 0x325B15E575E1C3D0, 0x9F8169BA49A54B33, 0x56ED3E2F9E224471,
        0x7D9BA13851336649, 0xB4F7F6AD86B4690B, 0x192D8AF2BAF0E1E8, 0xD041DD676D77EEAA, 0x86ACE348F355AADB, 0x4FC0B4DD24D2A599, 0xE21AC88218962D7A, 0x2B769F17CF112238,
        0xF7A18709FF1EBC66, 0x3ECDD09C2899B324, 0x9317ACC314DD3BC7, 0x5A7BFB56C35A3485, 0x0C96C5795D7870F4, 0xC5FA92EC8AFF7FB6, 0x6820EEB3B6BBF755, 0xA14CB926613CF817,
        0x8A3A2631AE2DDA2F, 0x435671A479AAD56D, 0xEE8C0DFB45EE5D8E, 0x27E05A6E926952CC, 0x710D64410C4B16BD, 0xB86133D4DBCC19FF, 0x15BB4F8BE788911C, 0xDCD7181E300F9E5E,
        0x7BD0C384FF8F5E33, 0xB2BC941128085171, 0x1F66E84E144CD992, 0xD60ABFDBC3CBD6D0, 0x80E781F45DE992A1, 0x498BD6618A6E9DE3, 0xE451AA3EB62A1500, 0x2D3DFDAB61AD1A42,
        0x064B62BCAEBC387A, 0xCF273529793B3738, 0x62FD4976457FBFDB, 0xAB911EE392F8B099, 0xFD7C20CC0CDAF4E8, 0x34107759DB5DFBAA, 0x99CA0B06E7197349, 0x50A65C93309E7C0B,
        0x8C71448D0091E255, 0x451D1318D716ED17, 0xE8C76F47EB5265F4, 0x21AB38D23CD56AB6, 0x774606FDA2F72EC7, 0xBE2A516875702185, 0x13F02D374934A966, 0xDA9C7AA29EB3A624,
        0xF1EAE5B551A2841C, 0x3886B22086258B5E, 0x955CCE7FBA6103BD, 0x5C3099EA6DE60CFF, 0x0ADDA7C5F3C4488E, 0xC3B1F050244347CC, 0x6E6B8C0F1807CF2F, 0xA707DB9ACF80C06D,
        0xF4843657A840A05B, 0x3DE861C27FC7AF19, 0x90321D9D438327FA, 0x595E4A08940428B8, 0x0FB374270A266CC9, 0xC6DF23B2DDA1638B, 0x6B055FEDE1E5EB68, 0xA26908783662E42A,
        0x891F976FF973C612, 0x4073C0FA2EF4C950, 0xEDA9BCA512B041B3, 0x24C5EB30C5374EF1, 0x7228D51F5B150A80, 0xBB44828A8C9205C2, 0x169EFED5B0D68D21, 0xDFF2A94067518263,
        0x0325B15E575E1C3D, 0xCA49E6CB80D9137F, 0x67939A94BC9D9B9C, 0xAEFFCD016B1A94DE, 0xF812F32EF538D0AF, 0x317EA4BB22BFDFED, 0x9CA4D8E41EFB570E, 0x55C88F71C97C584C,
        0x7EBE1066066D7A74, 0xB7D247F3D1EA7536, 0x1A083BACEDAEFDD5, 0xD3646C393A29F297, 0x85895216A40BB6E6, 0x4CE50583738CB9A4, 0xE13F79DC4FC83147, 0x28532E49984F3E05,
        0x8F54F5D357CFFE68, 0x4638A2468048F12A, 0xEBE2DE19BC0C79C9, 0x228E898C6B8B768B, 0x7463B7A3F5A932FA, 0xBD0FE036222E3DB8, 0x10D59C691E6AB55B, 0xD9B9CBFCC9EDBA19,
        0xF2CF54EB06FC9821, 0x3BA3037ED17B9763, 0x96797F21ED3F1F80, 0x5F1528B43AB810C2, 0x09F8169BA49A54B3, 0xC094410E731D5BF1, 0x6D4E3D514F59D312, 0xA4226AC498DEDC50,
        0x78F572DAA8D1420E, 0xB199254F7F564D4C, 0x1C4359104312C5AF, 0xD52F0E859495CAED, 0x83C230AA0AB78E9C, 0x4AAE673FDD3081DE, 0xE7741B60E174093D, 0x2E184CF536F3067F,
        0x056ED3E2F9E22447, 0xCC0284772E652B05, 0x61D8F8281221A3E6, 0xA8B4AFBDC5A6ACA4, 0xFE5991925B84E8D5, 0x3735C6078C03E797, 0x9AEFBA58B0476F74, 0x5383EDCD67C06036,
        0xB32E4CBE03A75F6F, 0x7A421B2BD420502D, 0xD7986774E864D8CE, 0x1EF430E13FE3D78C, 0x48190ECEA1C193FD, 0x8175595B76469CBF, 0x2CAF25044A02145C, 0xE5C372919D851B1E,
        0xCEB5ED8652943926, 0x07D9BA1385133664, 0xAA03C64CB957BE87, 0x636F91D96ED0B1C5, 0x3582AFF6F0F2F5B4, 0xFCEEF8632775FAF6, 0x5134843C1B317215, 0x9858D3A9CCB67D57,
        0x448FCBB7FCB9E309, 0x8DE39C222B3EEC4B, 0x2039E07D177A64A8, 0xE955B7E8C0FD6BEA, 0xBFB889C75EDF2F9B, 0x76D4DE52895820D9, 0xDB0EA20DB51CA83A, 0x1262F598629BA778,
        0x39146A8FAD8A8540, 0xF0783D1A7A0D8A02, 0x5DA24145464902E1, 0x94CE16D091CE0DA3, 0xC22328FF0FEC49D2, 0x0B4F7F6AD86B4690, 0xA6950335E42FCE73, 0x6FF954A033A8C131,
        0xC8FE8F3AFC28015C, 0x0192D8AF2BAF0E1E, 0xAC48A4F017EB86FD, 0x6524F365C06C89BF, 0x33C9CD4A5E4ECDCE, 0xFAA59ADF89C9C28C, 0x577FE680B58D4A6F, 0x9E13B115620A452D,
        0xB5652E02AD1B6715, 0x7C0979977A9C6857, 0xD1D305C846D8E0B4, 0x18BF525D915FEFF6, 0x4E526C720F7DAB87, 0x873E3BE7D8FAA4C5, 0x2AE447B8E4BE2C26, 0xE388102D33392364,
        0x3F5F08330336BD3A, 0xF6335FA6D4B1B278, 0x5BE923F9E8F53A9B, 0x9285746C3F7235D9, 0xC4684A43A15071A8, 0x0D041DD676D77EEA, 0xA0DE61894A93F609, 0x69B2361C9D14F94B,
        0x42C4A90B5205DB73, 0x8BA8FE9E8582D431, 0x267282C1B9C65CD2, 0xEF1ED5546E415390, 0xB9F3EB7BF06317E1, 0x709FBCEE27E418A3, 0xDD45C0B11BA09040, 0x14299724CC279F02,
        0x47AA7AE9ABE7FF34, 0x8EC62D7C7C60F076, 0x231C512340247895, 0xEA7006B697A377D7, 0xBC9D3899098133A6, 0x75F16F0CDE063CE4, 0xD82B1353E242B407, 0x114744C635C5BB45,
        0x3A31DBD1FAD4997D, 0xF35D8C442D53963F, 0x5E87F01B11171EDC, 0x97EBA78EC690119E, 0xC10699A158B255EF, 0x086ACE348F355AAD, 0xA5B0B26BB371D24E, 0x6CDCE5FE64F6DD0C,
        0xB00BFDE054F94352, 0x7967AA75837E4C10, 0xD4BDD62ABF3AC4F3, 0x1DD181BF68BDCBB1, 0x4B3CBF90F69F8FC0, 0x8250E80521188082, 0x2F8A945A1D5C0861, 0xE6E6C3CFCADB0723,
        0xCD905CD805CA251B, 0x04FC0B4DD24D2A59, 0xA9267712EE09A2BA, 0x604A2087398EADF8, 0x36A71EA8A7ACE989, 0xFFCB493D702BE6CB, 0x521135624C6F6E28, 0x9B7D62F79BE8616A,
        0x3C7AB96D5468A107, 0xF516EEF883EFAE45, 0x58CC92A7BFAB26A6, 0x91A0C532682C29E4, 0xC74DFB1DF60E6D95, 0x0E21AC88218962D7, 0xA3FBD0D71DCDEA34, 0x6A978742CA4AE576,
        0x41E11855055BC74E, 0x888D4FC0D2DCC80C, 0x2557339FEE9840EF, 0xEC3B640A391F4FAD, 0xBAD65A25A73D0BDC, 0x73BA0DB070BA049E, 0xDE6071EF4CFE8C7D, 0x170C267A9B79833F,
        0xCBDB3E64AB761D61, 0x02B769F17CF11223, 0xAF6D15AE40B59AC0, 0x6601423B97329582, 0x30EC7C140910D1F3, 0xF9802B81DE97DEB1, 0x545A57DEE2D35652, 0x9D36004B35545910,
        0xB6409F5CFA457B28, 0x7F2CC8C92DC2746A, 0xD2F6B4961186FC89, 0x1B9AE303C601F3CB, 0x4D77DD2C5823B7BA, 0x841B8AB98FA4B8F8, 0x29C1F6E6B3E0301B, 0xE0ADA17364673F59
      };

      return (crc >> 8) ^ table[(crc ^ value) & 0xFF];
    }
  };

  //***************************************************************************
  /// CRC64 Poly 0x42F0E1EBA9EA3693 policy.
  /// Calculates CRC64 using polynomial 0x42F0E1EBA9EA3693
  //***************************************************************************
  template <const uint64_t INITIAL, const uint64_t XOR_OUT, const bool REFLECT = false>
  struct crc64_policy_poly_0x42f0e1eba9ea3693 : public crc64_table_poly_0x42f0e1eba9ea3693
  {
    typedef uint64_t value_type;

    //*************************************************************************
    ETL_CONSTEXPR uint64_t initial() const
    {
      return INITIAL;
    }

    //*************************************************************************
    uint64_t final(uint64_t crc) const
    {
      return crc ^ XOR_OUT;
    }
  };

  //***************************************************************************
  /// CRC64 Poly 0x42F0E1EBA9EA3693 reflected policy specialisation.
  //***************************************************************************
  template <const uint64_t INITIAL, const uint64_t XOR_OUT>
  struct crc64_policy_poly_0x42f0e1eba9ea3693<INITIAL, XOR_OUT, true> : public crc64_table_poly_0x42f0e1eba9ea3693_reflected
  {
    typedef uint64_t value_type;

    //*************************************************************************
    ETL_CONSTEXPR uint64_t initial() const
    {
      return INITIAL;
    }

    //*************************************************************************
    uint64_t final(uint64_t crc) const
    {
      return crc ^ XOR_OUT;
    }
  };

  //*************************************************************************
  /// CRC64 Poly 0x42F0E1EBA9EA3693
  //*************************************************************************
  template <const uint64_t INITIAL, const uint64_t XOR_OUT, const bool REFLECT>
  class crc64_poly_0x42f0e1eba9ea3693 : public etl::frame_check_sequence<etl::crc64_policy_poly_0x42f0e1eba9ea3693<INITIAL, XOR_OUT, REFLECT> >
  {
  public:

    //*************************************************************************
    /// Default constructor.
    //*************************************************************************
    crc64_poly_0x42f0e1eba9ea3693()
    {
      this->reset();
    }

    //*************************************************************************
    /// Constructor from range.
    /// \param begin Start of the range.
    /// \param end   End of the range.
    //*************************************************************************
    template<typename TIterator, typename = typename etl::enable_if<!etl::is_integral<TIterator>::value, void>::type>
    crc64_poly_0x42f0e1eba9ea3693(TIterator begin, const TIterator end)
    {
      this->reset();
      this->add(begin, end);
    }
  };
}

#endif
