/******************************************************************************
The MIT License(MIT)

Embedded Template Library.
https://github.com/ETLCPP/etl
https://www.etlcpp.com

Copyright(c) 2020 John Wellbelove

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files(the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and / or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions :

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
******************************************************************************/

#if 0
#error THIS HEADER IS A GENERATOR. DO NOT INCLUDE.
#endif

//***************************************************************************
// THIS FILE HAS BEEN AUTO GENERATED. DO NOT EDIT THIS FILE.
//***************************************************************************

//***************************************************************************
// To generate to header file, run this at the command line.
// Note: You will need Python and COG installed.
//
// python -m cogapp -d -e -omessage_packet.h -DHandlers=<n> message_packet_generator.h
// Where <n> is the number of messages to support.
//
// e.g.
// To generate handlers for up to 16 messages...
// python -m cogapp -d -e -omessage_packet.h -DHandlers=16 message_packet_generator.h
//
// See generate.bat
//***************************************************************************

#ifndef ETL_MESSAGE_PACKET_INCLUDED
#define ETL_MESSAGE_PACKET_INCLUDED

#include "platform.h"

#include "message.h"
#include "error_handler.h"
#include "static_assert.h"
#include "largest.h"
#include "alignment.h"
#include "utility.h"

#include <stdint.h>

namespace etl
{
#if ETL_USING_CPP17 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
  //***************************************************************************
  // The definition for all message types.
  //***************************************************************************
  template <typename... TMessageTypes>
  class message_packet
  {

  private:

    template <typename T>
    static constexpr bool IsMessagePacket = etl::is_same_v< etl::remove_const_t<etl::remove_reference_t<T>>, etl::message_packet<TMessageTypes...>>;

    template <typename T>
    static constexpr bool IsInMessageList = etl::is_one_of_v<etl::remove_const_t<etl::remove_reference_t<T>>, TMessageTypes...>;

    template <typename T>
    static constexpr bool IsIMessage = etl::is_same_v<remove_const_t<etl::remove_reference_t<T>>, etl::imessage>;

  public:

    //********************************************
#include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
#include "private/diagnostic_pop.h"

    //********************************************
    ///
    //********************************************
#include "private/diagnostic_uninitialized_push.h"
    template <typename T, typename = typename etl::enable_if<IsIMessage<T> || IsInMessageList<T>, int>::type>
    explicit message_packet(T&& msg)
      : valid(true)
    {
      if constexpr (IsIMessage<T>)
      {
        if (accepts(msg))
        {
          add_new_message(etl::forward<T>(msg));
          valid = true;
        }
        else
        {
          valid = false;
        }

        ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
      }
      else if constexpr (IsInMessageList<T>)
      {
        add_new_message_type<T>(etl::forward<T>(msg));
      }
      else
      {
        ETL_STATIC_ASSERT(IsInMessageList<T>, "Message not in packet type list");
      }
    }
#include "private/diagnostic_pop.h"

    //**********************************************
    message_packet(const message_packet& other)
    {
      valid = other.is_valid();

      if (valid)
      {
        add_new_message(other.get());
      }
    }

#if ETL_USING_CPP11
    //**********************************************
    message_packet(message_packet&& other)
    {
      valid = other.is_valid();

      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
#endif

    //**********************************************
    void copy(const message_packet& other)
    {
      valid = other.is_valid();

      if (valid)
      {
        add_new_message(other.get());
      }
    }

    //**********************************************
    void copy(message_packet&& other)
    {
      valid = other.is_valid();

      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }

    //**********************************************
#include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
#include "private/diagnostic_pop.h"

    //**********************************************
#include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
#include "private/diagnostic_pop.h"

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return (accepts_message<TMessageTypes::ID>(id) || ...);
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return (accepts_message<TMessageTypes::ID, Id>() || ...);
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
      typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return accepts<TMessage::ID>();
    }

    enum
    {
      SIZE = etl::largest<TMessageTypes...>::size,
      ALIGNMENT = etl::largest<TMessageTypes...>::alignment
    };

  private:

    //**********************************************
    template <etl::message_id_t Id1, etl::message_id_t Id2>
    static bool accepts_message()
    {
      return Id1 == Id2;
    }

    //**********************************************
    template <etl::message_id_t Id1>
    static bool accepts_message(etl::message_id_t id2)
    {
      return Id1 == id2;
    }

    //********************************************
#include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);

#if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
#else
        delete_message(pmsg);
#endif
      }
    }
#include "private/diagnostic_pop.h"

#if !ETL_HAS_VIRTUAL_MESSAGES
    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      (delete_message_type<TMessageTypes>(pmsg) || ...);
    }

    //********************************************
    template <typename TType>
    bool delete_message_type(etl::imessage* pmsg)
    {
      if (TType::ID == pmsg->get_message_id())
      {
        TType* p = static_cast<TType*>(pmsg);
        p->~TType();
        return true;
      }
      else
      {
        return false;
      }
    }
#endif

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      (add_new_message_type<TMessageTypes>(msg) || ...);
    }

    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      (add_new_message_type<TMessageTypes>(etl::move(msg)) || ...);
    }

#include "private/diagnostic_uninitialized_push.h"
    //********************************************
    /// Only enabled for types that are in the typelist.
    //********************************************
    template <typename TMessage>
    etl::enable_if_t<etl::is_one_of_v<etl::remove_const_t<etl::remove_reference_t<TMessage>>, TMessageTypes...>, void>
      add_new_message_type(TMessage&& msg)
    {
      void* p = data;
      new (p) etl::remove_reference_t<TMessage>((etl::forward<TMessage>(msg)));
    }
#include "private/diagnostic_pop.h"

#include "private/diagnostic_uninitialized_push.h"
    //********************************************
    template <typename TType>
    bool add_new_message_type(const etl::imessage& msg)
    {
      if (TType::ID == msg.get_message_id())
      {
        void* p = data;
        new (p) TType(static_cast<const TType&>(msg));
        return true;
      }
      else
      {
        return false;
      }
    }
#include "private/diagnostic_pop.h"

    //********************************************
    template <typename TType>
    bool add_new_message_type(etl::imessage&& msg)
    {
      if (TType::ID == msg.get_message_id())
      {
        void* p = data;
        new (p) TType(static_cast<TType&&>(msg));
        return true;
      }
      else
      {
        return false;
      }
    }

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

#else

  //***************************************************************************
  // The definition for all 16 message types.
  //***************************************************************************
  template <typename T1, typename T2 = void, typename T3 = void, typename T4 = void, 
            typename T5 = void, typename T6 = void, typename T7 = void, typename T8 = void, 
            typename T9 = void, typename T10 = void, typename T11 = void, typename T12 = void, 
            typename T13 = void, typename T14 = void, typename T15 = void, typename T16 = void>
  class message_packet
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id || T10::ID == id || T11::ID == id || T12::ID == id ||
             T13::ID == id || T14::ID == id || T15::ID == id || T16::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id || T10::ID == Id || T11::ID == Id || T12::ID == Id ||
             T13::ID == Id || T14::ID == Id || T15::ID == Id || T16::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID || T10::ID == TMessage::ID || T11::ID == TMessage::ID || T12::ID == TMessage::ID ||
             T13::ID == TMessage::ID || T14::ID == TMessage::ID || T15::ID == TMessage::ID || T16::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);

  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        case T10::ID: static_cast<const T10*>(pmsg)->~T10(); break;
        case T11::ID: static_cast<const T11*>(pmsg)->~T11(); break;
        case T12::ID: static_cast<const T12*>(pmsg)->~T12(); break;
        case T13::ID: static_cast<const T13*>(pmsg)->~T13(); break;
        case T14::ID: static_cast<const T14*>(pmsg)->~T14(); break;
        case T15::ID: static_cast<const T15*>(pmsg)->~T15(); break;
        case T16::ID: static_cast<const T16*>(pmsg)->~T16(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<const T10&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<const T11&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<const T12&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<const T13&>(msg)); break;
        case T14::ID: ::new (p) T14(static_cast<const T14&>(msg)); break;
        case T15::ID: ::new (p) T15(static_cast<const T15&>(msg)); break;
        case T16::ID: ::new (p) T16(static_cast<const T16&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<T10&&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<T11&&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<T12&&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<T13&&>(msg)); break;
        case T14::ID: ::new (p) T14(static_cast<T14&&>(msg)); break;
        case T15::ID: ::new (p) T15(static_cast<T15&&>(msg)); break;
        case T16::ID: ::new (p) T16(static_cast<T16&&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 15 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12, 
            typename T13, typename T14, typename T15>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id || T10::ID == id || T11::ID == id || T12::ID == id ||
             T13::ID == id || T14::ID == id || T15::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id || T10::ID == Id || T11::ID == Id || T12::ID == Id ||
             T13::ID == Id || T14::ID == Id || T15::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID || T10::ID == TMessage::ID || T11::ID == TMessage::ID || T12::ID == TMessage::ID ||
             T13::ID == TMessage::ID || T14::ID == TMessage::ID || T15::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        case T10::ID: static_cast<const T10*>(pmsg)->~T10(); break;
        case T11::ID: static_cast<const T11*>(pmsg)->~T11(); break;
        case T12::ID: static_cast<const T12*>(pmsg)->~T12(); break;
        case T13::ID: static_cast<const T13*>(pmsg)->~T13(); break;
        case T14::ID: static_cast<const T14*>(pmsg)->~T14(); break;
        case T15::ID: static_cast<const T15*>(pmsg)->~T15(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<const T10&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<const T11&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<const T12&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<const T13&>(msg)); break;
        case T14::ID: ::new (p) T14(static_cast<const T14&>(msg)); break;
        case T15::ID: ::new (p) T15(static_cast<const T15&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<T10&&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<T11&&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<T12&&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<T13&&>(msg)); break;
        case T14::ID: ::new (p) T14(static_cast<T14&&>(msg)); break;
        case T15::ID: ::new (p) T15(static_cast<T15&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 14 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12, 
            typename T13, typename T14>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id || T10::ID == id || T11::ID == id || T12::ID == id ||
             T13::ID == id || T14::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id || T10::ID == Id || T11::ID == Id || T12::ID == Id ||
             T13::ID == Id || T14::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID || T10::ID == TMessage::ID || T11::ID == TMessage::ID || T12::ID == TMessage::ID ||
             T13::ID == TMessage::ID || T14::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        case T10::ID: static_cast<const T10*>(pmsg)->~T10(); break;
        case T11::ID: static_cast<const T11*>(pmsg)->~T11(); break;
        case T12::ID: static_cast<const T12*>(pmsg)->~T12(); break;
        case T13::ID: static_cast<const T13*>(pmsg)->~T13(); break;
        case T14::ID: static_cast<const T14*>(pmsg)->~T14(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<const T10&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<const T11&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<const T12&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<const T13&>(msg)); break;
        case T14::ID: ::new (p) T14(static_cast<const T14&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<T10&&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<T11&&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<T12&&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<T13&&>(msg)); break;
        case T14::ID: ::new (p) T14(static_cast<T14&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 13 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12, 
            typename T13>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id || T10::ID == id || T11::ID == id || T12::ID == id ||
             T13::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id || T10::ID == Id || T11::ID == Id || T12::ID == Id ||
             T13::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID || T10::ID == TMessage::ID || T11::ID == TMessage::ID || T12::ID == TMessage::ID ||
             T13::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        case T10::ID: static_cast<const T10*>(pmsg)->~T10(); break;
        case T11::ID: static_cast<const T11*>(pmsg)->~T11(); break;
        case T12::ID: static_cast<const T12*>(pmsg)->~T12(); break;
        case T13::ID: static_cast<const T13*>(pmsg)->~T13(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<const T10&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<const T11&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<const T12&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<const T13&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<T10&&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<T11&&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<T12&&>(msg)); break;
        case T13::ID: ::new (p) T13(static_cast<T13&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 12 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11, typename T12>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id || T10::ID == id || T11::ID == id || T12::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id || T10::ID == Id || T11::ID == Id || T12::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID || T10::ID == TMessage::ID || T11::ID == TMessage::ID || T12::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        case T10::ID: static_cast<const T10*>(pmsg)->~T10(); break;
        case T11::ID: static_cast<const T11*>(pmsg)->~T11(); break;
        case T12::ID: static_cast<const T12*>(pmsg)->~T12(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<const T10&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<const T11&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<const T12&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<T10&&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<T11&&>(msg)); break;
        case T12::ID: ::new (p) T12(static_cast<T12&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 11 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10, typename T11>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id || T10::ID == id || T11::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id || T10::ID == Id || T11::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID || T10::ID == TMessage::ID || T11::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        case T10::ID: static_cast<const T10*>(pmsg)->~T10(); break;
        case T11::ID: static_cast<const T11*>(pmsg)->~T11(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<const T10&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<const T11&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<T10&&>(msg)); break;
        case T11::ID: ::new (p) T11(static_cast<T11&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 10 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9, typename T10>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id || T10::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id || T10::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID || T10::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        case T10::ID: static_cast<const T10*>(pmsg)->~T10(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<const T10&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        case T10::ID: ::new (p) T10(static_cast<T10&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 9 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8, 
            typename T9>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8, T9>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8, T9> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8, T9>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id ||
             T9::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id ||
             T9::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID ||
             T9::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8, T9>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        case T9::ID: static_cast<const T9*>(pmsg)->~T9(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<const T9&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        case T9::ID: ::new (p) T9(static_cast<T9&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 8 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7, typename T8>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, T8, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7, T8>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7, T8> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7, T8>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id || T8::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id || T8::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID || T8::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7, T8>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        case T8::ID: static_cast<const T8*>(pmsg)->~T8(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<const T8&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        case T8::ID: ::new (p) T8(static_cast<T8&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 7 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6, typename T7>
  class message_packet<T1, T2, T3, T4, T5, T6, T7, void, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6, T7>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6, T7> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6, T7>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id || T7::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id || T7::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID || T7::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6, T7>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6, T7>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        case T7::ID: static_cast<const T7*>(pmsg)->~T7(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<const T7&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        case T7::ID: ::new (p) T7(static_cast<T7&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 6 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5, typename T6>
  class message_packet<T1, T2, T3, T4, T5, T6, void, void, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5, T6>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5, T6> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5, T6>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id || T6::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id || T6::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID || T6::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5, T6>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5, T6>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        case T6::ID: static_cast<const T6*>(pmsg)->~T6(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<const T6&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        case T6::ID: ::new (p) T6(static_cast<T6&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 5 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4, 
            typename T5>
  class message_packet<T1, T2, T3, T4, T5, void, void, void, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4, T5>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4, T5> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4, T5>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id ||
             T5::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id ||
             T5::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID ||
             T5::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4, T5>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4, T5>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        case T5::ID: static_cast<const T5*>(pmsg)->~T5(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<const T5&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        case T5::ID: ::new (p) T5(static_cast<T5&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 4 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3, typename T4>
  class message_packet<T1, T2, T3, T4, void, void, void, void, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3, T4>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3, T4> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3, T4>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id || T4::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id || T4::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID || T4::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3, T4>::size,
      ALIGNMENT = etl::largest<T1, T2, T3, T4>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        case T4::ID: static_cast<const T4*>(pmsg)->~T4(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<const T4&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        case T4::ID: ::new (p) T4(static_cast<T4&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 3 message types.
  //***************************************************************************
  template <typename T1, typename T2, typename T3>
  class message_packet<T1, T2, T3, void, void, void, void, void, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2, T3>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2, T3> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2, T3>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id || T3::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id || T3::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID || T3::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2, T3>::size,
      ALIGNMENT = etl::largest<T1, T2, T3>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        case T3::ID: static_cast<const T3*>(pmsg)->~T3(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<const T3&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        case T3::ID: ::new (p) T3(static_cast<T3&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 2 message types.
  //***************************************************************************
  template <typename T1, typename T2>
  class message_packet<T1, T2, void, void, void, void, void, void, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1, T2>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1, T2> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1, T2>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id || T2::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id || T2::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID || T2::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1, T2>::size,
      ALIGNMENT = etl::largest<T1, T2>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        case T2::ID: static_cast<const T2*>(pmsg)->~T2(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<const T2&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        case T2::ID: ::new (p) T2(static_cast<T2&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };

  //***************************************************************************
  // Specialisation for 1 message type.
  //***************************************************************************
  template <typename T1>
  class message_packet<T1, void, void, void, void, void, void, void, void, void, void, void, void, void, void, void>
  {
  public:

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet()
      : valid(false)
    {
    }
  #include "private/diagnostic_pop.h"

    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(const etl::imessage& msg)
    {
      if (accepts(msg))
      {
        add_new_message(msg);
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    explicit message_packet(etl::imessage&& msg)
    {
      if (accepts(msg))
      {
        add_new_message(etl::move(msg));
        valid = true;
      }
      else
      {
        valid = false;
      }

      ETL_ASSERT(valid, ETL_ERROR(unhandled_message_exception));
    }
  #include "private/diagnostic_pop.h"
  #endif

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION) && !defined(ETL_COMPILER_GREEN_HILLS)
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage, typename = typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1> >::value &&
                                                                    !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                    !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1>::value, int>::type>
    explicit message_packet(TMessage&& /*msg*/)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static constexpr bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1> >::value &&
                                       !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                       etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #else
    //********************************************
  #include "private/diagnostic_uninitialized_push.h"
    template <typename TMessage>
    explicit message_packet(const TMessage& /*msg*/, typename etl::enable_if<!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1> >::value &&
                                                                         !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                                                         !etl::is_one_of<typename etl::remove_cvref<TMessage>::type, T1>::value, int>::type = 0)
      : valid(true)
    {
      // Not etl::message_packet, not etl::imessage and in typelist.
      static const bool Enabled = (!etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::message_packet<T1> >::value &&
                                   !etl::is_same<typename etl::remove_cvref<TMessage>::type, etl::imessage>::value &&
                                   etl::is_one_of<typename etl::remove_cvref<TMessage>::type,T1>::value);

      ETL_STATIC_ASSERT(Enabled, "Message not in packet type list");
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(const message_packet& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(other.get());
      }
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet(message_packet&& other)
      : valid(other.is_valid())
    {
      if (valid)
      {
        add_new_message(etl::move(other.get()));
      }
    }
  #include "private/diagnostic_pop.h"
  #endif

    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(const message_packet& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(rhs.get());
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //**********************************************
  #include "private/diagnostic_uninitialized_push.h"
    message_packet& operator =(message_packet&& rhs)
    {
      delete_current_message();
      valid = rhs.is_valid();
      if (valid)
      {
        add_new_message(etl::move(rhs.get()));
      }

      return *this;
    }
  #include "private/diagnostic_pop.h"
  #endif

    //********************************************
    ~message_packet()
    {
      delete_current_message();
    }

    //********************************************
    etl::imessage& get() ETL_NOEXCEPT
    {
      return *static_cast<etl::imessage*>(data);
    }

    //********************************************
    const etl::imessage& get() const ETL_NOEXCEPT
    {
      return *static_cast<const etl::imessage*>(data);
    }

    //********************************************
    bool is_valid() const
    {
      return valid;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(etl::message_id_t id)
    {
      return T1::ID == id;
    }

    //**********************************************
    static ETL_CONSTEXPR bool accepts(const etl::imessage& msg)
    {
      return accepts(msg.get_message_id());
    }

    //**********************************************
    template <etl::message_id_t Id>
    static ETL_CONSTEXPR bool accepts()
    {
      return T1::ID == Id;
    }

    //**********************************************
    template <typename TMessage>
    static ETL_CONSTEXPR
    typename etl::enable_if<etl::is_base_of<etl::imessage, TMessage>::value, bool>::type
      accepts()
    {
      return T1::ID == TMessage::ID;
    }

    enum
    {
      SIZE      = etl::largest<T1>::size,
      ALIGNMENT = etl::largest<T1>::alignment
    };

  private:

    //********************************************
    #include "private/diagnostic_uninitialized_push.h"
    void delete_current_message()
    {
      if (valid)
      {
        etl::imessage* pmsg = static_cast<etl::imessage*>(data);


  #if ETL_HAS_VIRTUAL_MESSAGES
        pmsg->~imessage();
  #else
        delete_message(pmsg);
  #endif
      }
    }
    #include "private/diagnostic_pop.h"

    //********************************************
    void delete_message(etl::imessage* pmsg)
    {
      switch (pmsg->get_message_id())
      {
        case T1::ID: static_cast<const T1*>(pmsg)->~T1(); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

    //********************************************
    void add_new_message(const etl::imessage& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<const T1&>(msg)); break;
        default: ETL_ASSERT_FAIL(ETL_ERROR(unhandled_message_exception)); break;
      }
    }

  #if ETL_USING_CPP11 && !defined(ETL_MESSAGE_PACKET_FORCE_CPP03_IMPLEMENTATION)
    //********************************************
    void add_new_message(etl::imessage&& msg)
    {
      const size_t id = msg.get_message_id();
      void* p = data;

      switch (id)
      {
        case T1::ID: ::new (p) T1(static_cast<T1&&>(msg)); break;
        default: break;
      }
    }
  #endif

    typename etl::aligned_storage<SIZE, ALIGNMENT>::type data;
    bool valid;
  };
#endif
}

#endif
