/*


          ██████╗    ██╗    ██████╗    ██╗   ████████╗    █████╗    ██╗
          ██╔══██╗   ██║   ██╔════╝    ██║   ╚══██╔══╝   ██╔══██╗   ██║
          ██║  ██║   ██║   ██║  ███╗   ██║      ██║      ███████║   ██║
          ██║  ██║   ██║   ██║   ██║   ██║      ██║      ██╔══██║   ██║
          ██████╔╝   ██║   ╚██████╔╝   ██║      ██║      ██║  ██║   ███████╗
          ╚═════╝    ╚═╝    ╚═════╝    ╚═╝      ╚═╝      ╚═╝  ╚═╝   ╚══════╝

   ██████╗    ██████╗    ██████╗    ███████╗   ███████╗   ██╗    ██████╗    ███╗   ██╗
  ██╔════╝   ██╔═══██╗   ██╔══██╗   ██╔════╝   ██╔════╝   ██║   ██╔════╝    ████╗  ██║
  ██║        ██║   ██║   ██║  ██║   █████╗     ███████╗   ██║   ██║  ███╗   ██╔██╗ ██║
  ██║        ██║   ██║   ██║  ██║   ██╔══╝     ╚════██║   ██║   ██║   ██║   ██║╚██╗██║
  ╚██████╗   ╚██████╔╝   ██████╔╝   ███████╗   ███████║   ██║   ╚██████╔╝   ██║ ╚████║
   ╚═════╝    ╚═════╝    ╚═════╝    ╚══════╝   ╚══════╝   ╚═╝    ╚═════╝    ╚═╝  ╚═══╝


  Autor: Digital Codesign
  Version: 1.0.0
  Fecha de creación: Septiembre de 2024
  Fecha de version: Septiembre de 2024
  Repositorio: https://github.com/DigitalCodesign/MentorBit-RGB
  Descripcion:
    Esta libreria esta especificamente diseñada para ser utilizada junto con
    el modulo de led RGB de MentorBit
  Metodos principales:
    MentorBitRGB -> constructor de la clase
    begin -> inicializador, debe colocarse en el setup
    apagar -> este metodo apaga el led RGB
    cambiarColor -> este metodo cambia el color del led RGB 
    cambiarBrillo -> este metodo permite ajustar el brillo del led RGB

*/

#ifndef MentorBitRGB_h
#define MentorBitRGB_h

#include <arduino.h>
#include <Adafruit_NeoPixel.h>

class MentorBitRGB
{

    public:

        MentorBitRGB(uint8_t dint_pin);
        void begin();
        void apagar();
        void cambiarColor(uint8_t rojo, uint8_t verde, uint8_t azul);
        void cambiarBrillo(uint8_t brillo);

    private:

        uint8_t _dint_pin;
        Adafruit_NeoPixel _led_rgb;

};

#endif