/*


          ██████╗    ██╗    ██████╗    ██╗   ████████╗    █████╗    ██╗
          ██╔══██╗   ██║   ██╔════╝    ██║   ╚══██╔══╝   ██╔══██╗   ██║
          ██║  ██║   ██║   ██║  ███╗   ██║      ██║      ███████║   ██║
          ██║  ██║   ██║   ██║   ██║   ██║      ██║      ██╔══██║   ██║
          ██████╔╝   ██║   ╚██████╔╝   ██║      ██║      ██║  ██║   ███████╗
          ╚═════╝    ╚═╝    ╚═════╝    ╚═╝      ╚═╝      ╚═╝  ╚═╝   ╚══════╝

   ██████╗    ██████╗    ██████╗    ███████╗   ███████╗   ██╗    ██████╗    ███╗   ██╗
  ██╔════╝   ██╔═══██╗   ██╔══██╗   ██╔════╝   ██╔════╝   ██║   ██╔════╝    ████╗  ██║
  ██║        ██║   ██║   ██║  ██║   █████╗     ███████╗   ██║   ██║  ███╗   ██╔██╗ ██║
  ██║        ██║   ██║   ██║  ██║   ██╔══╝     ╚════██║   ██║   ██║   ██║   ██║╚██╗██║
  ╚██████╗   ╚██████╔╝   ██████╔╝   ███████╗   ███████║   ██║   ╚██████╔╝   ██║ ╚████║
   ╚═════╝    ╚═════╝    ╚═════╝    ╚══════╝   ╚══════╝   ╚═╝    ╚═════╝    ╚═╝  ╚═══╝


  Autor: Digital Codesign
  Version: 1.0.0
  Fecha de creación: Septiembre de 2024
  Fecha de version: Septiembre de 2024
  Repositorio: https://github.com/DigitalCodesign/MentorBit-PoteRueda
  Descripcion:
    Este sketch muestra un ejemplo de como leer el valor analogico del potenciometro y
    mostrarlo por pantalla en el monitor serial

*/

// Se incluye la libreria MentorBitPoteRueda
#include <MentorBitPoteRueda.h>

// Se definen los pines a los que esta conectado el modulo de potenciometro
#define Pin_Potenciometro A4
#define Pin_Led 24

// Se crea el objeto potenciometro
MentorBitPoteRueda potenciometro(Pin_Potenciometro,Pin_Led);

void setup(){
    
    // Inicializamos el monitor seerial a una velocidad de 9600 baudios
    Serial.begin(9600);
}

void loop(){

    // Enviamos por monitor serial el valor de lectura del potenciometro
    Serial.println("Valor del potenciometro: " + String(potenciometro.obtenerLectura()));

    // Ponemos un pequeño delay para evitar llenar el monitor serial de mensajes
    delay(1000);
}