/*


          ██████╗    ██╗    ██████╗    ██╗   ████████╗    █████╗    ██╗
          ██╔══██╗   ██║   ██╔════╝    ██║   ╚══██╔══╝   ██╔══██╗   ██║
          ██║  ██║   ██║   ██║  ███╗   ██║      ██║      ███████║   ██║
          ██║  ██║   ██║   ██║   ██║   ██║      ██║      ██╔══██║   ██║
          ██████╔╝   ██║   ╚██████╔╝   ██║      ██║      ██║  ██║   ███████╗
          ╚═════╝    ╚═╝    ╚═════╝    ╚═╝      ╚═╝      ╚═╝  ╚═╝   ╚══════╝

   ██████╗    ██████╗    ██████╗    ███████╗   ███████╗   ██╗    ██████╗    ███╗   ██╗
  ██╔════╝   ██╔═══██╗   ██╔══██╗   ██╔════╝   ██╔════╝   ██║   ██╔════╝    ████╗  ██║
  ██║        ██║   ██║   ██║  ██║   █████╗     ███████╗   ██║   ██║  ███╗   ██╔██╗ ██║
  ██║        ██║   ██║   ██║  ██║   ██╔══╝     ╚════██║   ██║   ██║   ██║   ██║╚██╗██║
  ╚██████╗   ╚██████╔╝   ██████╔╝   ███████╗   ███████║   ██║   ╚██████╔╝   ██║ ╚████║
   ╚═════╝    ╚═════╝    ╚═════╝    ╚══════╝   ╚══════╝   ╚═╝    ╚═════╝    ╚═╝  ╚═══╝


  Autor: Digital Codesign
  Version: 1.0.0
  Fecha de creación: Septiembre de 2024
  Fecha de version: Septiembre de 2024
  Repositorio: https://github.com/DigitalCodesign/MentorBit-PIR
  Descripcion:
    Este sketch muestra un ejemplo de como leer el valor de la lectura digital dado
    por el modulo de sensor PIR
*/

// Se incluye la libreria de MentorBitPir
#include <MentorBitPir.h>

// Se define a que pin se va a conectar el modulo
#define PIR_PIN 24

// Se crea el objeto pir y se le indica el pin
MentorBitPir pir(PIR_PIN);

void setup(){
    // Inicializamos el bus serial para mostrar mensajes por pantalla
    Serial.begin(9600);
    Serial.println("Iniciando");
}

void loop(){
    // Si se detecta presencia, imprimir un mensaje por pantalla.
    if(pir.lecturaDigital()){
        // Imprimir mensaje por mopnmitor serial
        Serial.println("Se ha detectado movimiento");
        // Ponemos delay para no llenar el bus serial
        delay(1000);
    }
}